// SPDX-License-Identifier: GPL-2.0-or-later

/*
  This program configures the General Programmable Interface (GPIF) for FX2.
  Please do not modify sections of text which are marked as "DO NOT EDIT ...".
*/

/* GPIF Program Code */

#include "reg_ezusb.h"
#include "delay.h"

/****************************** GPIF PROGRAM CODE ********************************/
/* DO NOT EDIT ... */
const char wavedata[128] = {
// Wave 0
/* LenBr */ 0x01,     0x3F,     0x01,     0x01,     0x01,     0x01,     0x01,     0x07,
/* Opcode*/ 0x02,     0x07,     0x02,     0x02,     0x02,     0x02,     0x02,     0x00,
/* Output*/ 0x04,     0x07,     0x07,     0x07,     0x07,     0x07,     0x07,     0x07,
/* LFun  */ 0x00,     0x09,     0x00,     0x00,     0x00,     0x00,     0x00,     0x3F,
// Wave 1
/* LenBr */ 0x01,     0x01,     0x01,     0x01,     0x01,     0x01,     0x01,     0x07,
/* Opcode*/ 0x00,     0x00,     0x00,     0x00,     0x00,     0x00,     0x00,     0x00,
/* Output*/ 0x01,     0x01,     0x01,     0x01,     0x01,     0x01,     0x01,     0x01,
/* LFun  */ 0x00,     0x00,     0x00,     0x00,     0x00,     0x00,     0x00,     0x3F,
// Wave 2
/* LenBr */ 0x01,     0x01,     0x01,     0x01,     0x01,     0x01,     0x01,     0x07,
/* Opcode*/ 0x00,     0x00,     0x00,     0x00,     0x00,     0x00,     0x00,     0x00,
/* Output*/ 0x01,     0x01,     0x01,     0x01,     0x01,     0x01,     0x01,     0x01,
/* LFun  */ 0x00,     0x00,     0x00,     0x00,     0x00,     0x00,     0x00,     0x3F,
// Wave 3
/* LenBr */ 0x01,     0x01,     0x01,     0x01,     0x01,     0x01,     0x01,     0x07,
/* Opcode*/ 0x00,     0x00,     0x00,     0x00,     0x00,     0x00,     0x00,     0x00,
/* Output*/ 0x01,     0x01,     0x01,     0x01,     0x01,     0x01,     0x01,     0x01,
/* LFun  */ 0x00,     0x00,     0x00,     0x00,     0x00,     0x00,     0x00,     0x3F,
};
/* END DO NOT EDIT */

/* DO NOT EDIT ... */
const char flowstates[36] = {
/* Wave 0 flowstates */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* Wave 1 flowstates */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* Wave 2 flowstates */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
/* Wave 3 flowstates */ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};
/* END DO NOT EDIT */

/* DO NOT EDIT ... */
const char initdata[7] = {
/* Regs  */ 0xE0, 0x00, 0x00, 0x07, 0xEE, 0xF2, 0x00
};
/* END DO NOT EDIT */

void gpif_init(void)
{
	uint8_t i;

	IFCONFIG = 0xEE;

	GPIFABORT = 0xFF;	/* abort any waveforms pending */
	GPIFREADYCFG = initdata[0];
	GPIFCTLCFG = initdata[1];
	GPIFIDLECS = initdata[2];
	GPIFIDLECTL = initdata[3];
	GPIFWFSELECT = initdata[5];
	GPIFREADYSTAT = initdata[6];

	/* use dual autopointer feature... */
	AUTOPTRSETUP = 0x07;

	/* source */
	AUTOPTRH1 = (uint8_t)(((uint16_t)(&wavedata) >> 8) & 0xff);
	AUTOPTRL1 = (uint8_t)((uint16_t)(&wavedata) & 0xff);

	/* destination */
	AUTOPTRH2 = 0xE4;
	AUTOPTRL2 = 0x00;

	/* transfer */
	for (i = 0x00; i < 128; i++)
		EXTAUTODAT2 = EXTAUTODAT1;

	/* GPIF address pins update when GPIFADRH/L written */
	syncdelay(3);
	GPIFADRH = 0x00;    /* bits[7:1] always 0 */
	syncdelay(3);
	GPIFADRL = 0x00;    /* point to PERIPHERAL address 0x0000 */

	/* Configure GPIF flowstates registers for Wave 0 of wavedata */
	FLOWSTATE = flowstates[0];
	FLOWLOGIC = flowstates[1];
	FLOWEQ0CTL = flowstates[2];
	FLOWEQ1CTL = flowstates[3];
	FLOWHOLDOFF = flowstates[4];
	FLOWSTB = flowstates[5];
	FLOWSTBEDGE = flowstates[6];
	FLOWSTBHPERIOD = flowstates[7];
}
