/* ARC64 instruction defintions.
   Copyright (C) 2022 Free Software Foundation, Inc.

   Contributed by Claudiu Zissulescu (claziss@synopsys.com)

   This file is part of libopcodes.

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 51 Franklin Street - Fifth Floor, Boston, MA 02110-1301, USA.  */

/* abs<.f> b,c 00100bbb00101111FBBBCCCCCC001001.  */
{ "abs", 0x202F0009, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* abs<.f> 0,c 0010011000101111F111CCCCCC001001.  */
{ "abs", 0x262F7009, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RC }, { C_F }},

/* abs<.f> b,u6 00100bbb01101111FBBBuuuuuu001001.  */
{ "abs", 0x206F0009, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* abs<.f> 0,u6 0010011001101111F111uuuuuu001001.  */
{ "abs", 0x266F7009, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* abs<.f> b,limm 00100bbb00101111FBBB111110001001.  */
{ "abs", 0x202F0F89, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* abs<.f> 0,limm 0010011000101111F111111110001001.  */
{ "abs", 0x262F7F89, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* absl<.f> RB,RC 01011bbb00101111FBBBcccccc001001.  */
{ "absl", 0x582F0009, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* absl<.f> 0,RC 0101111000101111F111cccccc001001.  */
{ "absl", 0x5E2F7009, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RC }, { C_F }},

/* absl<.f> RB,u6 01011bbb01101111FBBBuuuuuu001001.  */
{ "absl", 0x586F0009, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* absl<.f> 0,u6 0101111001101111F111uuuuuu001001.  */
{ "absl", 0x5E6F7009, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* absl<.f> RB,ximm 01011bbb00101111FBBB111100001001.  */
{ "absl", 0x582F0F09, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { C_F }},

/* absl<.f> 0,ximm 0101111000101111F111111100001001.  */
{ "absl", 0x5E2F7F09, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM }, { C_F }},

/* absl<.f> RB,limm 01011bbb00101111FBBB111110001001.  */
{ "absl", 0x582F0F89, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* absl<.f> 0,limm 0101111000101111F111111110001001.  */
{ "absl", 0x5E2F7F89, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* abs_s b,c 01111bbbccc10001.  */
{ "abs_s", 0x00007811, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB_S, RC_S }, { 0 }},

/* adc<.f> a,b,c 00100bbb00000001FBBBCCCCCCAAAAAA.  */
{ "adc", 0x20010000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* adc<.f> 0,b,c 00100bbb00000001FBBBCCCCCC111110.  */
{ "adc", 0x2001003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* adc<.f><.cc> b,b,c 00100bbb11000001FBBBCCCCCC0QQQQQ.  */
{ "adc", 0x20C10000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* adc<.f> a,b,u6 00100bbb01000001FBBBuuuuuuAAAAAA.  */
{ "adc", 0x20410000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* adc<.f> 0,b,u6 00100bbb01000001FBBBuuuuuu111110.  */
{ "adc", 0x2041003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* adc<.f><.cc> b,b,u6 00100bbb11000001FBBBuuuuuu1QQQQQ.  */
{ "adc", 0x20C10020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* adc<.f> b,b,s12 00100bbb10000001FBBBssssssSSSSSS.  */
{ "adc", 0x20810000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* adc<.f> a,limm,c 0010011000000001F111CCCCCCAAAAAA.  */
{ "adc", 0x26017000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* adc<.f> a,b,limm 00100bbb00000001FBBB111110AAAAAA.  */
{ "adc", 0x20010F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* adc<.f> 0,limm,c 0010011000000001F111CCCCCC111110.  */
{ "adc", 0x2601703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* adc<.f> 0,b,limm 00100bbb00000001FBBB111110111110.  */
{ "adc", 0x20010FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* adc<.f><.cc> b,b,limm 00100bbb11000001FBBB1111100QQQQQ.  */
{ "adc", 0x20C10F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* adc<.f><.cc> 0,limm,c 0010011011000001F111CCCCCC0QQQQQ.  */
{ "adc", 0x26C17000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* adc<.f> a,limm,u6 0010011001000001F111uuuuuuAAAAAA.  */
{ "adc", 0x26417000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* adc<.f> 0,limm,u6 0010011001000001F111uuuuuu111110.  */
{ "adc", 0x2641703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* adc<.f><.cc> 0,limm,u6 0010011011000001F111uuuuuu1QQQQQ.  */
{ "adc", 0x26C17020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* adc<.f> 0,limm,s12 0010011010000001F111ssssssSSSSSS.  */
{ "adc", 0x26817000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* adc<.f> a,limm,limm 0010011000000001F111111110AAAAAA.  */
{ "adc", 0x26017F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* adc<.f> 0,limm,limm 0010011000000001F111111110111110.  */
{ "adc", 0x26017FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* adc<.f><.cc> 0,limm,limm 0010011011000001F1111111100QQQQQ.  */
{ "adc", 0x26C17F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* adcl<.f> RA,RB,RC 01011bbb00000001FBBBccccccaaaaaa.  */
{ "adcl", 0x58010000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* adcl<.f> 0,RB,RC 01011bbb00000001FBBBcccccc111110.  */
{ "adcl", 0x5801003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* adcl<.f><.cc> RB,RB,RC 01011bbb11000001FBBBcccccc0QQQQQ.  */
{ "adcl", 0x58C10000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* adcl<.f> RA,RB,u6 01011bbb01000001FBBBuuuuuuaaaaaa.  */
{ "adcl", 0x58410000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* adcl<.f> 0,RB,u6 01011bbb01000001FBBBuuuuuu111110.  */
{ "adcl", 0x5841003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* adcl<.f><.cc> RB,RB,u6 01011bbb11000001FBBBuuuuuu1QQQQQ.  */
{ "adcl", 0x58C10020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* adcl<.f> RB,RB,s12 01011bbb10000001FBBBssssssSSSSSS.  */
{ "adcl", 0x58810000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* adcl<.f> RA,ximm,RC 0101110000000001F111ccccccaaaaaa.  */
{ "adcl", 0x5C017000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* adcl<.f> RA,RB,ximm 01011bbb00000001FBBB111100aaaaaa.  */
{ "adcl", 0x58010F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* adcl<.f> 0,ximm,RC 0101110000000001F111cccccc111110.  */
{ "adcl", 0x5C01703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* adcl<.f> 0,RB,ximm 01011bbb00000001FBBB111100111110.  */
{ "adcl", 0x58010F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* adcl<.f><.cc> 0,ximm,RC 0101110011000001F111cccccc0QQQQQ.  */
{ "adcl", 0x5CC17000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* adcl<.f><.cc> RB,RB,ximm 01011bbb11000001FBBB1111000QQQQQ.  */
{ "adcl", 0x58C10F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* adcl<.f> RA,ximm,u6 0101110001000001F111uuuuuuaaaaaa.  */
{ "adcl", 0x5C417000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* adcl<.f> 0,ximm,u6 0101110001000001F111uuuuuu111110.  */
{ "adcl", 0x5C41703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* adcl<.f><.cc> 0,ximm,u6 0101110011000001F111uuuuuu1QQQQQ.  */
{ "adcl", 0x5CC17020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* adcl<.f> RA,limm,RC 0101111000000001F111ccccccaaaaaa.  */
{ "adcl", 0x5E017000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* adcl<.f> RA,RB,limm 01011bbb00000001FBBB111110aaaaaa.  */
{ "adcl", 0x58010F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* adcl<.f> 0,limm,RC 0101111000000001F111cccccc111110.  */
{ "adcl", 0x5E01703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* adcl<.f> 0,RB,limm 01011bbb00000001FBBB111110111110.  */
{ "adcl", 0x58010FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* adcl<.f><.cc> 0,limm,RC 0101111011000001F111cccccc0QQQQQ.  */
{ "adcl", 0x5EC17000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* adcl<.f><.cc> RB,RB,limm 01011bbb11000001FBBB1111100QQQQQ.  */
{ "adcl", 0x58C10F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* adcl<.f> RA,limm,u6 0101111001000001F111uuuuuuaaaaaa.  */
{ "adcl", 0x5E417000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* adcl<.f> 0,limm,u6 0101111001000001F111uuuuuu111110.  */
{ "adcl", 0x5E41703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* adcl<.f><.cc> 0,limm,u6 0101111011000001F111uuuuuu1QQQQQ.  */
{ "adcl", 0x5EC17020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* adcl<.f> 0,ximm,s12 0101110010000001F111ssssssSSSSSS.  */
{ "adcl", 0x5C817000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* adcl<.f> 0,limm,s12 0101111010000001F111ssssssSSSSSS.  */
{ "adcl", 0x5E817000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* adcl<.f> RA,ximm,ximm 0101110000000001F111111100aaaaaa.  */
{ "adcl", 0x5C017F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* adcl<.f> 0,ximm,ximm 0101110000000001F111111100111110.  */
{ "adcl", 0x5C017F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* adcl<.f><.cc> 0,ximm,ximm 0101110011000001F1111111000QQQQQ.  */
{ "adcl", 0x5CC17F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* adcl<.f> RA,limm,limm 0101111000000001F111111110aaaaaa.  */
{ "adcl", 0x5E017F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* adcl<.f> 0,limm,limm 0101111000000001F111111110111110.  */
{ "adcl", 0x5E017FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* adcl<.f><.cc> 0,limm,limm 0101111011000001F1111111100QQQQQ.  */
{ "adcl", 0x5EC17F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* add<.f> a,b,c 00100bbb00000000FBBBCCCCCCAAAAAA.  */
{ "add", 0x20000000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* add<.f> 0,b,c 00100bbb00000000FBBBCCCCCC111110.  */
{ "add", 0x2000003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* add<.f><.cc> b,b,c 00100bbb11000000FBBBCCCCCC0QQQQQ.  */
{ "add", 0x20C00000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* add<.f> a,b,u6 00100bbb01000000FBBBuuuuuuAAAAAA.  */
{ "add", 0x20400000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* add<.f> 0,b,u6 00100bbb01000000FBBBuuuuuu111110.  */
{ "add", 0x2040003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* add<.f><.cc> b,b,u6 00100bbb11000000FBBBuuuuuu1QQQQQ.  */
{ "add", 0x20C00020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* add<.f> b,b,s12 00100bbb10000000FBBBssssssSSSSSS.  */
{ "add", 0x20800000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* add<.f> a,limm,c 0010011000000000F111CCCCCCAAAAAA.  */
{ "add", 0x26007000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* add<.f> a,b,limm 00100bbb00000000FBBB111110AAAAAA.  */
{ "add", 0x20000F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* add<.f> 0,limm,c 0010011000000000F111CCCCCC111110.  */
{ "add", 0x2600703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* add<.f> 0,b,limm 00100bbb00000000FBBB111110111110.  */
{ "add", 0x20000FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* add<.f><.cc> b,b,limm 00100bbb11000000FBBB1111100QQQQQ.  */
{ "add", 0x20C00F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* add<.f><.cc> 0,limm,c 0010011011000000F111CCCCCC0QQQQQ.  */
{ "add", 0x26C07000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* add<.f> a,limm,u6 0010011001000000F111uuuuuuAAAAAA.  */
{ "add", 0x26407000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* add<.f> 0,limm,u6 0010011001000000F111uuuuuu111110.  */
{ "add", 0x2640703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* add<.f><.cc> 0,limm,u6 0010011011000000F111uuuuuu1QQQQQ.  */
{ "add", 0x26C07020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* add<.f> 0,limm,s12 0010011010000000F111ssssssSSSSSS.  */
{ "add", 0x26807000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* add<.f> a,limm,limm 0010011000000000F111111110AAAAAA.  */
{ "add", 0x26007F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* add<.f> 0,limm,limm 0010011000000000F111111110111110.  */
{ "add", 0x26007FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* add<.f><.cc> 0,limm,limm 0010011011000000F1111111100QQQQQ.  */
{ "add", 0x26C07F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* add1<.f> a,b,c 00100bbb00010100FBBBCCCCCCAAAAAA.  */
{ "add1", 0x20140000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* add1<.f> 0,b,c 00100bbb00010100FBBBCCCCCC111110.  */
{ "add1", 0x2014003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* add1<.f><.cc> b,b,c 00100bbb11010100FBBBCCCCCC0QQQQQ.  */
{ "add1", 0x20D40000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* add1<.f> a,b,u6 00100bbb01010100FBBBuuuuuuAAAAAA.  */
{ "add1", 0x20540000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* add1<.f> 0,b,u6 00100bbb01010100FBBBuuuuuu111110.  */
{ "add1", 0x2054003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* add1<.f><.cc> b,b,u6 00100bbb11010100FBBBuuuuuu1QQQQQ.  */
{ "add1", 0x20D40020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* add1<.f> b,b,s12 00100bbb10010100FBBBssssssSSSSSS.  */
{ "add1", 0x20940000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* add1<.f> a,limm,c 0010011000010100F111CCCCCCAAAAAA.  */
{ "add1", 0x26147000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* add1<.f> a,b,limm 00100bbb00010100FBBB111110AAAAAA.  */
{ "add1", 0x20140F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* add1<.f> 0,limm,c 0010011000010100F111CCCCCC111110.  */
{ "add1", 0x2614703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* add1<.f> 0,b,limm 00100bbb00010100FBBB111110111110.  */
{ "add1", 0x20140FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* add1<.f><.cc> b,b,limm 00100bbb11010100FBBB1111100QQQQQ.  */
{ "add1", 0x20D40F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* add1<.f><.cc> 0,limm,c 0010011011010100F111CCCCCC0QQQQQ.  */
{ "add1", 0x26D47000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* add1<.f> a,limm,u6 0010011001010100F111uuuuuuAAAAAA.  */
{ "add1", 0x26547000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* add1<.f> 0,limm,u6 0010011001010100F111uuuuuu111110.  */
{ "add1", 0x2654703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* add1<.f><.cc> 0,limm,u6 0010011011010100F111uuuuuu1QQQQQ.  */
{ "add1", 0x26D47020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* add1<.f> 0,limm,s12 0010011010010100F111ssssssSSSSSS.  */
{ "add1", 0x26947000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* add1<.f> a,limm,limm 0010011000010100F111111110AAAAAA.  */
{ "add1", 0x26147F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* add1<.f> 0,limm,limm 0010011000010100F111111110111110.  */
{ "add1", 0x26147FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* add1<.f><.cc> 0,limm,limm 0010011011010100F1111111100QQQQQ.  */
{ "add1", 0x26D47F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* add1l<.f> RA,RB,RC 01011bbb00010100FBBBccccccaaaaaa.  */
{ "add1l", 0x58140000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* add1l<.f> 0,RB,RC 01011bbb00010100FBBBcccccc111110.  */
{ "add1l", 0x5814003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* add1l<.f><.cc> RB,RB,RC 01011bbb11010100FBBBcccccc0QQQQQ.  */
{ "add1l", 0x58D40000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* add1l<.f> RA,RB,u6 01011bbb01010100FBBBuuuuuuaaaaaa.  */
{ "add1l", 0x58540000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* add1l<.f> 0,RB,u6 01011bbb01010100FBBBuuuuuu111110.  */
{ "add1l", 0x5854003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* add1l<.f><.cc> RB,RB,u6 01011bbb11010100FBBBuuuuuu1QQQQQ.  */
{ "add1l", 0x58D40020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* add1l<.f> RB,RB,s12 01011bbb10010100FBBBssssssSSSSSS.  */
{ "add1l", 0x58940000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* add1l<.f> RA,ximm,RC 0101110000010100F111ccccccaaaaaa.  */
{ "add1l", 0x5C147000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* add1l<.f> RA,RB,ximm 01011bbb00010100FBBB111100aaaaaa.  */
{ "add1l", 0x58140F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* add1l<.f> 0,ximm,RC 0101110000010100F111cccccc111110.  */
{ "add1l", 0x5C14703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* add1l<.f> 0,RB,ximm 01011bbb00010100FBBB111100111110.  */
{ "add1l", 0x58140F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* add1l<.f><.cc> 0,ximm,RC 0101110011010100F111cccccc0QQQQQ.  */
{ "add1l", 0x5CD47000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* add1l<.f><.cc> RB,RB,ximm 01011bbb11010100FBBB1111000QQQQQ.  */
{ "add1l", 0x58D40F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* add1l<.f> RA,ximm,u6 0101110001010100F111uuuuuuaaaaaa.  */
{ "add1l", 0x5C547000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* add1l<.f> 0,ximm,u6 0101110001010100F111uuuuuu111110.  */
{ "add1l", 0x5C54703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* add1l<.f><.cc> 0,ximm,u6 0101110011010100F111uuuuuu1QQQQQ.  */
{ "add1l", 0x5CD47020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* add1l<.f> RA,limm,RC 0101111000010100F111ccccccaaaaaa.  */
{ "add1l", 0x5E147000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* add1l<.f> RA,RB,limm 01011bbb00010100FBBB111110aaaaaa.  */
{ "add1l", 0x58140F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* add1l<.f> 0,limm,RC 0101111000010100F111cccccc111110.  */
{ "add1l", 0x5E14703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* add1l<.f> 0,RB,limm 01011bbb00010100FBBB111110111110.  */
{ "add1l", 0x58140FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* add1l<.f><.cc> 0,limm,RC 0101111011010100F111cccccc0QQQQQ.  */
{ "add1l", 0x5ED47000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* add1l<.f><.cc> RB,RB,limm 01011bbb11010100FBBB1111100QQQQQ.  */
{ "add1l", 0x58D40F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* add1l<.f> RA,limm,u6 0101111001010100F111uuuuuuaaaaaa.  */
{ "add1l", 0x5E547000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* add1l<.f> 0,limm,u6 0101111001010100F111uuuuuu111110.  */
{ "add1l", 0x5E54703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* add1l<.f><.cc> 0,limm,u6 0101111011010100F111uuuuuu1QQQQQ.  */
{ "add1l", 0x5ED47020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* add1l<.f> 0,ximm,s12 0101110010010100F111ssssssSSSSSS.  */
{ "add1l", 0x5C947000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* add1l<.f> 0,limm,s12 0101111010010100F111ssssssSSSSSS.  */
{ "add1l", 0x5E947000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* add1l<.f> RA,ximm,ximm 0101110000010100F111111100aaaaaa.  */
{ "add1l", 0x5C147F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* add1l<.f> 0,ximm,ximm 0101110000010100F111111100111110.  */
{ "add1l", 0x5C147F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* add1l<.f><.cc> 0,ximm,ximm 0101110011010100F1111111000QQQQQ.  */
{ "add1l", 0x5CD47F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* add1l<.f> RA,limm,limm 0101111000010100F111111110aaaaaa.  */
{ "add1l", 0x5E147F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* add1l<.f> 0,limm,limm 0101111000010100F111111110111110.  */
{ "add1l", 0x5E147FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* add1l<.f><.cc> 0,limm,limm 0101111011010100F1111111100QQQQQ.  */
{ "add1l", 0x5ED47F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* add1_s b,b,c 01111bbbccc10100.  */
{ "add1_s", 0x00007814, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* add2<.f> a,b,c 00100bbb00010101FBBBCCCCCCAAAAAA.  */
{ "add2", 0x20150000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* add2<.f> 0,b,c 00100bbb00010101FBBBCCCCCC111110.  */
{ "add2", 0x2015003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* add2<.f><.cc> b,b,c 00100bbb11010101FBBBCCCCCC0QQQQQ.  */
{ "add2", 0x20D50000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* add2<.f> a,b,u6 00100bbb01010101FBBBuuuuuuAAAAAA.  */
{ "add2", 0x20550000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* add2<.f> 0,b,u6 00100bbb01010101FBBBuuuuuu111110.  */
{ "add2", 0x2055003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* add2<.f><.cc> b,b,u6 00100bbb11010101FBBBuuuuuu1QQQQQ.  */
{ "add2", 0x20D50020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* add2<.f> b,b,s12 00100bbb10010101FBBBssssssSSSSSS.  */
{ "add2", 0x20950000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* add2<.f> a,limm,c 0010011000010101F111CCCCCCAAAAAA.  */
{ "add2", 0x26157000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* add2<.f> a,b,limm 00100bbb00010101FBBB111110AAAAAA.  */
{ "add2", 0x20150F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* add2<.f> 0,limm,c 0010011000010101F111CCCCCC111110.  */
{ "add2", 0x2615703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* add2<.f> 0,b,limm 00100bbb00010101FBBB111110111110.  */
{ "add2", 0x20150FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* add2<.f><.cc> b,b,limm 00100bbb11010101FBBB1111100QQQQQ.  */
{ "add2", 0x20D50F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* add2<.f><.cc> 0,limm,c 0010011011010101F111CCCCCC0QQQQQ.  */
{ "add2", 0x26D57000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* add2<.f> a,limm,u6 0010011001010101F111uuuuuuAAAAAA.  */
{ "add2", 0x26557000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* add2<.f> 0,limm,u6 0010011001010101F111uuuuuu111110.  */
{ "add2", 0x2655703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* add2<.f><.cc> 0,limm,u6 0010011011010101F111uuuuuu1QQQQQ.  */
{ "add2", 0x26D57020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* add2<.f> 0,limm,s12 0010011010010101F111ssssssSSSSSS.  */
{ "add2", 0x26957000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* add2<.f> a,limm,limm 0010011000010101F111111110AAAAAA.  */
{ "add2", 0x26157F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* add2<.f> 0,limm,limm 0010011000010101F111111110111110.  */
{ "add2", 0x26157FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* add2<.f><.cc> 0,limm,limm 0010011011010101F1111111100QQQQQ.  */
{ "add2", 0x26D57F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* add2l<.f> RA,RB,RC 01011bbb00010101FBBBccccccaaaaaa.  */
{ "add2l", 0x58150000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* add2l<.f> 0,RB,RC 01011bbb00010101FBBBcccccc111110.  */
{ "add2l", 0x5815003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* add2l<.f><.cc> RB,RB,RC 01011bbb11010101FBBBcccccc0QQQQQ.  */
{ "add2l", 0x58D50000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* add2l<.f> RA,RB,u6 01011bbb01010101FBBBuuuuuuaaaaaa.  */
{ "add2l", 0x58550000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* add2l<.f> 0,RB,u6 01011bbb01010101FBBBuuuuuu111110.  */
{ "add2l", 0x5855003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* add2l<.f><.cc> RB,RB,u6 01011bbb11010101FBBBuuuuuu1QQQQQ.  */
{ "add2l", 0x58D50020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* add2l<.f> RB,RB,s12 01011bbb10010101FBBBssssssSSSSSS.  */
{ "add2l", 0x58950000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* add2l<.f> RA,ximm,RC 0101110000010101F111ccccccaaaaaa.  */
{ "add2l", 0x5C157000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* add2l<.f> RA,RB,ximm 01011bbb00010101FBBB111100aaaaaa.  */
{ "add2l", 0x58150F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* add2l<.f> 0,ximm,RC 0101110000010101F111cccccc111110.  */
{ "add2l", 0x5C15703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* add2l<.f> 0,RB,ximm 01011bbb00010101FBBB111100111110.  */
{ "add2l", 0x58150F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* add2l<.f><.cc> 0,ximm,RC 0101110011010101F111cccccc0QQQQQ.  */
{ "add2l", 0x5CD57000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* add2l<.f><.cc> RB,RB,ximm 01011bbb11010101FBBB1111000QQQQQ.  */
{ "add2l", 0x58D50F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* add2l<.f> RA,ximm,u6 0101110001010101F111uuuuuuaaaaaa.  */
{ "add2l", 0x5C557000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* add2l<.f> 0,ximm,u6 0101110001010101F111uuuuuu111110.  */
{ "add2l", 0x5C55703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* add2l<.f><.cc> 0,ximm,u6 0101110011010101F111uuuuuu1QQQQQ.  */
{ "add2l", 0x5CD57020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* add2l<.f> RA,limm,RC 0101111000010101F111ccccccaaaaaa.  */
{ "add2l", 0x5E157000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* add2l<.f> RA,RB,limm 01011bbb00010101FBBB111110aaaaaa.  */
{ "add2l", 0x58150F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* add2l<.f> 0,limm,RC 0101111000010101F111cccccc111110.  */
{ "add2l", 0x5E15703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* add2l<.f> 0,RB,limm 01011bbb00010101FBBB111110111110.  */
{ "add2l", 0x58150FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* add2l<.f><.cc> 0,limm,RC 0101111011010101F111cccccc0QQQQQ.  */
{ "add2l", 0x5ED57000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* add2l<.f><.cc> RB,RB,limm 01011bbb11010101FBBB1111100QQQQQ.  */
{ "add2l", 0x58D50F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* add2l<.f> RA,limm,u6 0101111001010101F111uuuuuuaaaaaa.  */
{ "add2l", 0x5E557000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* add2l<.f> 0,limm,u6 0101111001010101F111uuuuuu111110.  */
{ "add2l", 0x5E55703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* add2l<.f><.cc> 0,limm,u6 0101111011010101F111uuuuuu1QQQQQ.  */
{ "add2l", 0x5ED57020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* add2l<.f> 0,ximm,s12 0101110010010101F111ssssssSSSSSS.  */
{ "add2l", 0x5C957000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* add2l<.f> 0,limm,s12 0101111010010101F111ssssssSSSSSS.  */
{ "add2l", 0x5E957000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* add2l<.f> RA,ximm,ximm 0101110000010101F111111100aaaaaa.  */
{ "add2l", 0x5C157F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* add2l<.f> 0,ximm,ximm 0101110000010101F111111100111110.  */
{ "add2l", 0x5C157F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* add2l<.f><.cc> 0,ximm,ximm 0101110011010101F1111111000QQQQQ.  */
{ "add2l", 0x5CD57F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* add2l<.f> RA,limm,limm 0101111000010101F111111110aaaaaa.  */
{ "add2l", 0x5E157F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* add2l<.f> 0,limm,limm 0101111000010101F111111110111110.  */
{ "add2l", 0x5E157FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* add2l<.f><.cc> 0,limm,limm 0101111011010101F1111111100QQQQQ.  */
{ "add2l", 0x5ED57F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* add2_s b,b,c 01111bbbccc10101.  */
{ "add2_s", 0x00007815, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* add3<.f> a,b,c 00100bbb00010110FBBBCCCCCCAAAAAA.  */
{ "add3", 0x20160000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* add3<.f> 0,b,c 00100bbb00010110FBBBCCCCCC111110.  */
{ "add3", 0x2016003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* add3<.f><.cc> b,b,c 00100bbb11010110FBBBCCCCCC0QQQQQ.  */
{ "add3", 0x20D60000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* add3<.f> a,b,u6 00100bbb01010110FBBBuuuuuuAAAAAA.  */
{ "add3", 0x20560000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* add3<.f> 0,b,u6 00100bbb01010110FBBBuuuuuu111110.  */
{ "add3", 0x2056003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* add3<.f><.cc> b,b,u6 00100bbb11010110FBBBuuuuuu1QQQQQ.  */
{ "add3", 0x20D60020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* add3<.f> b,b,s12 00100bbb10010110FBBBssssssSSSSSS.  */
{ "add3", 0x20960000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* add3<.f> a,limm,c 0010011000010110F111CCCCCCAAAAAA.  */
{ "add3", 0x26167000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* add3<.f> a,b,limm 00100bbb00010110FBBB111110AAAAAA.  */
{ "add3", 0x20160F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* add3<.f> 0,limm,c 0010011000010110F111CCCCCC111110.  */
{ "add3", 0x2616703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* add3<.f> 0,b,limm 00100bbb00010110FBBB111110111110.  */
{ "add3", 0x20160FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* add3<.f><.cc> b,b,limm 00100bbb11010110FBBB1111100QQQQQ.  */
{ "add3", 0x20D60F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* add3<.f><.cc> 0,limm,c 0010011011010110F111CCCCCC0QQQQQ.  */
{ "add3", 0x26D67000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* add3<.f> a,limm,u6 0010011001010110F111uuuuuuAAAAAA.  */
{ "add3", 0x26567000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* add3<.f> 0,limm,u6 0010011001010110F111uuuuuu111110.  */
{ "add3", 0x2656703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* add3<.f><.cc> 0,limm,u6 0010011011010110F111uuuuuu1QQQQQ.  */
{ "add3", 0x26D67020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* add3<.f> 0,limm,s12 0010011010010110F111ssssssSSSSSS.  */
{ "add3", 0x26967000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* add3<.f> a,limm,limm 0010011000010110F111111110AAAAAA.  */
{ "add3", 0x26167F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* add3<.f> 0,limm,limm 0010011000010110F111111110111110.  */
{ "add3", 0x26167FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* add3<.f><.cc> 0,limm,limm 0010011011010110F1111111100QQQQQ.  */
{ "add3", 0x26D67F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* add3l<.f> RA,RB,RC 01011bbb00010110FBBBccccccaaaaaa.  */
{ "add3l", 0x58160000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* add3l<.f> 0,RB,RC 01011bbb00010110FBBBcccccc111110.  */
{ "add3l", 0x5816003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* add3l<.f><.cc> RB,RB,RC 01011bbb11010110FBBBcccccc0QQQQQ.  */
{ "add3l", 0x58D60000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* add3l<.f> RA,RB,u6 01011bbb01010110FBBBuuuuuuaaaaaa.  */
{ "add3l", 0x58560000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* add3l<.f> 0,RB,u6 01011bbb01010110FBBBuuuuuu111110.  */
{ "add3l", 0x5856003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* add3l<.f><.cc> RB,RB,u6 01011bbb11010110FBBBuuuuuu1QQQQQ.  */
{ "add3l", 0x58D60020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* add3l<.f> RB,RB,s12 01011bbb10010110FBBBssssssSSSSSS.  */
{ "add3l", 0x58960000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* add3l<.f> RA,ximm,RC 0101110000010110F111ccccccaaaaaa.  */
{ "add3l", 0x5C167000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* add3l<.f> RA,RB,ximm 01011bbb00010110FBBB111100aaaaaa.  */
{ "add3l", 0x58160F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* add3l<.f> 0,ximm,RC 0101110000010110F111cccccc111110.  */
{ "add3l", 0x5C16703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* add3l<.f> 0,RB,ximm 01011bbb00010110FBBB111100111110.  */
{ "add3l", 0x58160F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* add3l<.f><.cc> 0,ximm,RC 0101110011010110F111cccccc0QQQQQ.  */
{ "add3l", 0x5CD67000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* add3l<.f><.cc> RB,RB,ximm 01011bbb11010110FBBB1111000QQQQQ.  */
{ "add3l", 0x58D60F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* add3l<.f> RA,ximm,u6 0101110001010110F111uuuuuuaaaaaa.  */
{ "add3l", 0x5C567000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* add3l<.f> 0,ximm,u6 0101110001010110F111uuuuuu111110.  */
{ "add3l", 0x5C56703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* add3l<.f><.cc> 0,ximm,u6 0101110011010110F111uuuuuu1QQQQQ.  */
{ "add3l", 0x5CD67020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* add3l<.f> RA,limm,RC 0101111000010110F111ccccccaaaaaa.  */
{ "add3l", 0x5E167000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* add3l<.f> RA,RB,limm 01011bbb00010110FBBB111110aaaaaa.  */
{ "add3l", 0x58160F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* add3l<.f> 0,limm,RC 0101111000010110F111cccccc111110.  */
{ "add3l", 0x5E16703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* add3l<.f> 0,RB,limm 01011bbb00010110FBBB111110111110.  */
{ "add3l", 0x58160FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* add3l<.f><.cc> 0,limm,RC 0101111011010110F111cccccc0QQQQQ.  */
{ "add3l", 0x5ED67000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* add3l<.f><.cc> RB,RB,limm 01011bbb11010110FBBB1111100QQQQQ.  */
{ "add3l", 0x58D60F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* add3l<.f> RA,limm,u6 0101111001010110F111uuuuuuaaaaaa.  */
{ "add3l", 0x5E567000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* add3l<.f> 0,limm,u6 0101111001010110F111uuuuuu111110.  */
{ "add3l", 0x5E56703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* add3l<.f><.cc> 0,limm,u6 0101111011010110F111uuuuuu1QQQQQ.  */
{ "add3l", 0x5ED67020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* add3l<.f> 0,ximm,s12 0101110010010110F111ssssssSSSSSS.  */
{ "add3l", 0x5C967000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* add3l<.f> 0,limm,s12 0101111010010110F111ssssssSSSSSS.  */
{ "add3l", 0x5E967000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* add3l<.f> RA,ximm,ximm 0101110000010110F111111100aaaaaa.  */
{ "add3l", 0x5C167F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* add3l<.f> 0,ximm,ximm 0101110000010110F111111100111110.  */
{ "add3l", 0x5C167F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* add3l<.f><.cc> 0,ximm,ximm 0101110011010110F1111111000QQQQQ.  */
{ "add3l", 0x5CD67F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* add3l<.f> RA,limm,limm 0101111000010110F111111110aaaaaa.  */
{ "add3l", 0x5E167F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* add3l<.f> 0,limm,limm 0101111000010110F111111110111110.  */
{ "add3l", 0x5E167FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* add3l<.f><.cc> 0,limm,limm 0101111011010110F1111111100QQQQQ.  */
{ "add3l", 0x5ED67F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* add3_s b,b,c 01111bbbccc10110.  */
{ "add3_s", 0x00007816, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* addhl RA,RB,RC 01011bbb001011100BBBccccccaaaaaa.  */
{ "addhl", 0x582E0000, 0xF8FF8000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { 0 }},

/* addhl 0,RB,RC 01011bbb001011100BBBcccccc111110.  */
{ "addhl", 0x582E003E, 0xF8FF803F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { 0 }},

/* addhl<.cc> RB,RB,RC 01011bbb111011100BBBcccccc0QQQQQ.  */
{ "addhl", 0x58EE0000, 0xF8FF8020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_CC }},

/* addhl RA,RB,u6 01011bbb011011100BBBuuuuuuaaaaaa.  */
{ "addhl", 0x586E0000, 0xF8FF8000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { 0 }},

/* addhl 0,RB,u6 01011bbb011011100BBBuuuuuu111110.  */
{ "addhl", 0x586E003E, 0xF8FF803F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { 0 }},

/* addhl<.cc> RB,RB,u6 01011bbb111011100BBBuuuuuu1QQQQQ.  */
{ "addhl", 0x58EE0020, 0xF8FF8020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_CC }},

/* addhl RB,RB,s12 01011bbb101011100BBBssssssSSSSSS.  */
{ "addhl", 0x58AE0000, 0xF8FF8000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { 0 }},

/* addhl RA,limm,RC 01011110001011100111ccccccaaaaaa.  */
{ "addhl", 0x5E2E7000, 0xFFFFF000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, HI32, RC }, { 0 }},

/* addhl RA,RB,limm 01011bbb001011100BBB111110aaaaaa.  */
{ "addhl", 0x582E0F80, 0xF8FF8FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, HI32 }, { 0 }},

/* addhl<.cc> RB,RB,limm 01011bbb111011100BBB1111100QQQQQ.  */
{ "addhl", 0x58EE0F80, 0xF8FF8FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, HI32 }, { C_CC }},

/* addhl_s h,PCL,ximm 01110011hhh010HH.  */
{ "addhl_s", 0x00007308, 0x0000FF1C, ARC_OPCODE_ARC64, ARITH, NONE, { RH_S, PCL_S, XIMM_S }, { 0 }},

/* addhl_s h,h,limm 01110001hhh010HH.  */
{ "addhl_s", 0x00007108, 0x0000FF1C, ARC_OPCODE_ARC64, ARITH, NONE, { RH_S, RH_Sdup, HI32 }, { 0 }},

/* addl<.f> RA,RB,RC 01011bbb00000000FBBBccccccaaaaaa.  */
{ "addl", 0x58000000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* addl<.f> 0,RB,RC 01011bbb00000000FBBBcccccc111110.  */
{ "addl", 0x5800003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* addl<.f><.cc> RB,RB,RC 01011bbb11000000FBBBcccccc0QQQQQ.  */
{ "addl", 0x58C00000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* addl<.f> RA,RB,u6 01011bbb01000000FBBBuuuuuuaaaaaa.  */
{ "addl", 0x58400000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* addl<.f> 0,RB,u6 01011bbb01000000FBBBuuuuuu111110.  */
{ "addl", 0x5840003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* addl<.f><.cc> RB,RB,u6 01011bbb11000000FBBBuuuuuu1QQQQQ.  */
{ "addl", 0x58C00020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* addl<.f> RB,RB,s12 01011bbb10000000FBBBssssssSSSSSS.  */
{ "addl", 0x58800000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* addl<.f> RA,ximm,RC 0101110000000000F111ccccccaaaaaa.  */
{ "addl", 0x5C007000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* addl<.f> RA,RB,ximm 01011bbb00000000FBBB111100aaaaaa.  */
{ "addl", 0x58000F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* addl<.f> 0,ximm,RC 0101110000000000F111cccccc111110.  */
{ "addl", 0x5C00703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* addl<.f> 0,RB,ximm 01011bbb00000000FBBB111100111110.  */
{ "addl", 0x58000F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* addl<.f><.cc> 0,ximm,RC 0101110011000000F111cccccc0QQQQQ.  */
{ "addl", 0x5CC07000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* addl<.f><.cc> RB,RB,ximm 01011bbb11000000FBBB1111000QQQQQ.  */
{ "addl", 0x58C00F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* addl<.f> RA,ximm,u6 0101110001000000F111uuuuuuaaaaaa.  */
{ "addl", 0x5C407000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* addl<.f> 0,ximm,u6 0101110001000000F111uuuuuu111110.  */
{ "addl", 0x5C40703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* addl<.f><.cc> 0,ximm,u6 0101110011000000F111uuuuuu1QQQQQ.  */
{ "addl", 0x5CC07020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* addl<.f> RA,limm,RC 0101111000000000F111ccccccaaaaaa.  */
{ "addl", 0x5E007000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* addl<.f> RA,RB,limm 01011bbb00000000FBBB111110aaaaaa.  */
{ "addl", 0x58000F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* addl<.f> 0,limm,RC 0101111000000000F111cccccc111110.  */
{ "addl", 0x5E00703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* addl<.f> 0,RB,limm 01011bbb00000000FBBB111110111110.  */
{ "addl", 0x58000FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* addl<.f><.cc> 0,limm,RC 0101111011000000F111cccccc0QQQQQ.  */
{ "addl", 0x5EC07000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* addl<.f><.cc> RB,RB,limm 01011bbb11000000FBBB1111100QQQQQ.  */
{ "addl", 0x58C00F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* addl<.f> RA,limm,u6 0101111001000000F111uuuuuuaaaaaa.  */
{ "addl", 0x5E407000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* addl<.f> 0,limm,u6 0101111001000000F111uuuuuu111110.  */
{ "addl", 0x5E40703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* addl<.f><.cc> 0,limm,u6 0101111011000000F111uuuuuu1QQQQQ.  */
{ "addl", 0x5EC07020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* addl<.f> 0,ximm,s12 0101110010000000F111ssssssSSSSSS.  */
{ "addl", 0x5C807000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* addl<.f> 0,limm,s12 0101111010000000F111ssssssSSSSSS.  */
{ "addl", 0x5E807000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* addl<.f> RA,ximm,ximm 0101110000000000F111111100aaaaaa.  */
{ "addl", 0x5C007F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* addl<.f> 0,ximm,ximm 0101110000000000F111111100111110.  */
{ "addl", 0x5C007F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* addl<.f><.cc> 0,ximm,ximm 0101110011000000F1111111000QQQQQ.  */
{ "addl", 0x5CC07F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* addl<.f> RA,limm,limm 0101111000000000F111111110aaaaaa.  */
{ "addl", 0x5E007F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* addl<.f> 0,limm,limm 0101111000000000F111111110111110.  */
{ "addl", 0x5E007FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* addl<.f><.cc> 0,limm,limm 0101111011000000F1111111100QQQQQ.  */
{ "addl", 0x5EC07F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* addl_s SP,SP,u9 11000UU0101uuuuu.  */
{ "addl_s", 0x0000C0A0, 0x0000F9E0, ARC_OPCODE_ARC64, ARITH, NONE, { SP_S, SP_Sdup, UIMM9_A32_11_S }, { 0 }},

/* addl_s b,b,c 01111bbbccc00001.  */
{ "addl_s", 0x00007801, 0x0000F81F, ARC_OPCODE_ARC64, ARITH, NONE, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* addl_s b,SP,u7 11000bbb100uuuuu.  */
{ "addl_s", 0x0000C080, 0x0000F8E0, ARC_OPCODE_ARC64, ARITH, NONE, { RB_S, SP_S, UIMM7_A32_11_S }, { 0 }},

/* addl_s R0,GP,s11 1100111sssssssss.  */
{ "addl_s", 0x0000CE00, 0x0000FE00, ARC_OPCODE_ARC64, ARITH, NONE, { R0_S, GP_S, SIMM11_A32_7_S }, { 0 }},

/* addl_s h,h,LO32 01110001hhh110HH.  */
{ "addl_s", 0x00007118, 0x0000FF1C, ARC_OPCODE_ARC64, ARITH, NONE, { RH_S, RH_Sdup, LO32 }, { 0 }},

/* addl_s h,PCL,LO32 01110011hhh110HH.  */
{ "addl_s", 0x00007318, 0x0000FF1C, ARC_OPCODE_ARC64, ARITH, NONE, { RH_S, PCL_S, LO32 }, { 0 }},

/* add_s a,b,c 01100bbbccc11aaa.  */
{ "add_s", 0x00006018, 0x0000F818,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA_S, RB_S, RC_S }, { 0 }},

/* add_s b,b,h 01110bbbhhh000HH.  */
{ "add_s", 0x00007000, 0x0000F81C,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB_S, RB_Sdup, RH_S }, { 0 }},

/* add_s h,h,s3 01110ssshhh001HH.  */
{ "add_s", 0x00007004, 0x0000F81C,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RH_S, RH_Sdup, SIMM3_5_S }, { 0 }},

/* add_s R0,b,u6 01001bbb0UUU1uuu.  */
{ "add_s", 0x00004808, 0x0000F888,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, CD2, { R0_S, RB_S, UIMM6_13_S }, { 0 }},

/* add_s R1,b,u6 01001bbb1UUU1uuu.  */
{ "add_s", 0x00004888, 0x0000F888,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, CD2, { R1_S, RB_S, UIMM6_13_S }, { 0 }},

/* add_s b,b,limm 01110bbb11000011.  */
{ "add_s", 0x000070C3, 0x0000F8FF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB_S, RB_Sdup, LIMM_S }, { 0 }},

/* add_s 0,limm,s3 01110sss11000111.  */
{ "add_s", 0x000070C7, 0x0000F8FF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA_S, LIMM_S, SIMM3_5_S }, { 0 }},

/* aex b,c 00100bbb00100111RBBBCCCCCCRRRRRR.  */
{ "aex", 0x20270000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, RC, BRAKETdup }, { 0 }},

/* aex<.cc> b,c 00100bbb11100111RBBBCCCCCC0QQQQQ.  */
{ "aex", 0x20E70000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, RC, BRAKETdup }, { C_CC }},

/* aex b,u6 00100bbb01100111RBBBuuuuuuRRRRRR.  */
{ "aex", 0x20670000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, UIMM6_20, BRAKETdup }, { 0 }},

/* aex<.cc> b,u6 00100bbb11100111RBBBuuuuuu1QQQQQ.  */
{ "aex", 0x20E70020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, UIMM6_20, BRAKETdup }, { C_CC }},

/* aex b,s12 00100bbb10100111RBBBssssssSSSSSS.  */
{ "aex", 0x20A70000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, SIMM12_20, BRAKETdup }, { 0 }},

/* aex limm,c 0010011000100111R111CCCCCCRRRRRR.  */
{ "aex", 0x26277000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { LIMM, BRAKET, RC, BRAKETdup }, { 0 }},

/* aex b,limm 00100bbb00100111RBBB111110RRRRRR.  */
{ "aex", 0x20270F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, LIMM, BRAKETdup }, { 0 }},

/* aex<.cc> limm,c 0010011011100111R111CCCCCC0QQQQQ.  */
{ "aex", 0x26E77000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { LIMM, BRAKET, RC, BRAKETdup }, { C_CC }},

/* aex<.cc> b,limm 00100bbb11100111RBBB1111100QQQQQ.  */
{ "aex", 0x20E70F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, LIMM, BRAKETdup }, { C_CC }},

/* aex limm,u6 0010011001100111R111uuuuuuRRRRRR.  */
{ "aex", 0x26677000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { LIMM, BRAKET, UIMM6_20, BRAKETdup }, { 0 }},

/* aex<.cc> limm,u6 0010011011100111R111uuuuuu1QQQQQ.  */
{ "aex", 0x26E77020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { LIMM, BRAKET, UIMM6_20, BRAKETdup }, { C_CC }},

/* aex limm,s12 0010011010100111R111ssssssSSSSSS.  */
{ "aex", 0x26A77000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { LIMM, BRAKET, SIMM12_20, BRAKETdup }, { 0 }},

/* aex limm,limm 0010011000100111R111111110RRRRRR.  */
{ "aex", 0x26277F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { LIMM, BRAKET, LIMMdup, BRAKETdup }, { 0 }},

/* aex<.cc> limm,limm 0010011011100111R1111111100QQQQQ.  */
{ "aex", 0x26E77F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { LIMM, BRAKET, LIMMdup, BRAKETdup }, { C_CC }},

/* aexl RB,RC 01011bbb001001110BBBccccccRRRRRR.  */
{ "aexl", 0x58270000, 0xF8FF8000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, BRAKET, RC, BRAKETdup }, { 0 }},

/* aexl<.cc> RB,RC 01011bbb111001110BBBcccccc0QQQQQ.  */
{ "aexl", 0x58E70000, 0xF8FF8020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, BRAKET, RC, BRAKETdup }, { C_CC }},

/* aexl RB,u6 01011bbb011001110BBBuuuuuuRRRRRR.  */
{ "aexl", 0x58670000, 0xF8FF8000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, BRAKET, UIMM6_20, BRAKETdup }, { 0 }},

/* aexl<.cc> RB,u6 01011bbb111001110BBBuuuuuu1QQQQQ.  */
{ "aexl", 0x58E70020, 0xF8FF8020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, BRAKET, UIMM6_20, BRAKETdup }, { C_CC }},

/* aexl RB,s12 01011bbb101001110BBBssssssSSSSSS.  */
{ "aexl", 0x58A70000, 0xF8FF8000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, BRAKET, SIMM12_20, BRAKETdup }, { 0 }},

/* aexl RB,ximm 01011bbb001001110BBB111100RRRRRR.  */
{ "aexl", 0x58270F00, 0xF8FF8FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, BRAKET, XIMM, BRAKETdup }, { 0 }},

/* aexl<.cc> RB,ximm 01011bbb111001110BBB1111000QQQQQ.  */
{ "aexl", 0x58E70F00, 0xF8FF8FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, BRAKET, XIMM, BRAKETdup }, { C_CC }},

/* aexl RB,limm 01011bbb001001110BBB111110RRRRRR.  */
{ "aexl", 0x58270F80, 0xF8FF8FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, BRAKET, LIMM, BRAKETdup }, { 0 }},

/* aexl<.cc> RB,limm 01011bbb111001110BBB1111100QQQQQ.  */
{ "aexl", 0x58E70F80, 0xF8FF8FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, BRAKET, LIMM, BRAKETdup }, { C_CC }},

/* and<.f> a,b,c 00100bbb00000100FBBBCCCCCCAAAAAA.  */
{ "and", 0x20040000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* and<.f> 0,b,c 00100bbb00000100FBBBCCCCCC111110.  */
{ "and", 0x2004003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* and<.f><.cc> b,b,c 00100bbb11000100FBBBCCCCCC0QQQQQ.  */
{ "and", 0x20C40000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* and<.f> a,b,u6 00100bbb01000100FBBBuuuuuuAAAAAA.  */
{ "and", 0x20440000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* and<.f> 0,b,u6 00100bbb01000100FBBBuuuuuu111110.  */
{ "and", 0x2044003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* and<.f><.cc> b,b,u6 00100bbb11000100FBBBuuuuuu1QQQQQ.  */
{ "and", 0x20C40020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* and<.f> b,b,s12 00100bbb10000100FBBBssssssSSSSSS.  */
{ "and", 0x20840000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* and<.f> a,limm,c 0010011000000100F111CCCCCCAAAAAA.  */
{ "and", 0x26047000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* and<.f> a,b,limm 00100bbb00000100FBBB111110AAAAAA.  */
{ "and", 0x20040F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* and<.f> 0,limm,c 0010011000000100F111CCCCCC111110.  */
{ "and", 0x2604703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* and<.f> 0,b,limm 00100bbb00000100FBBB111110111110.  */
{ "and", 0x20040FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* and<.f><.cc> b,b,limm 00100bbb11000100FBBB1111100QQQQQ.  */
{ "and", 0x20C40F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* and<.f><.cc> 0,limm,c 0010011011000100F111CCCCCC0QQQQQ.  */
{ "and", 0x26C47000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* and<.f> a,limm,u6 0010011001000100F111uuuuuuAAAAAA.  */
{ "and", 0x26447000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* and<.f> 0,limm,u6 0010011001000100F111uuuuuu111110.  */
{ "and", 0x2644703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* and<.f><.cc> 0,limm,u6 0010011011000100F111uuuuuu1QQQQQ.  */
{ "and", 0x26C47020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* and<.f> 0,limm,s12 0010011010000100F111ssssssSSSSSS.  */
{ "and", 0x26847000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* and<.f> a,limm,limm 0010011000000100F111111110AAAAAA.  */
{ "and", 0x26047F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* and<.f> 0,limm,limm 0010011000000100F111111110111110.  */
{ "and", 0x26047FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* and<.f><.cc> 0,limm,limm 0010011011000100F1111111100QQQQQ.  */
{ "and", 0x26C47F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* andl<.f> RA,RB,RC 01011bbb00000100FBBBccccccaaaaaa.  */
{ "andl", 0x58040000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* andl<.f> 0,RB,RC 01011bbb00000100FBBBcccccc111110.  */
{ "andl", 0x5804003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* andl<.f><.cc> RB,RB,RC 01011bbb11000100FBBBcccccc0QQQQQ.  */
{ "andl", 0x58C40000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* andl<.f> RA,RB,u6 01011bbb01000100FBBBuuuuuuaaaaaa.  */
{ "andl", 0x58440000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* andl<.f> 0,RB,u6 01011bbb01000100FBBBuuuuuu111110.  */
{ "andl", 0x5844003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* andl<.f><.cc> RB,RB,u6 01011bbb11000100FBBBuuuuuu1QQQQQ.  */
{ "andl", 0x58C40020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* andl<.f> RB,RB,s12 01011bbb10000100FBBBssssssSSSSSS.  */
{ "andl", 0x58840000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* andl<.f> RA,ximm,RC 0101110000000100F111ccccccaaaaaa.  */
{ "andl", 0x5C047000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* andl<.f> RA,RB,ximm 01011bbb00000100FBBB111100aaaaaa.  */
{ "andl", 0x58040F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* andl<.f> 0,ximm,RC 0101110000000100F111cccccc111110.  */
{ "andl", 0x5C04703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* andl<.f> 0,RB,ximm 01011bbb00000100FBBB111100111110.  */
{ "andl", 0x58040F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* andl<.f><.cc> 0,ximm,RC 0101110011000100F111cccccc0QQQQQ.  */
{ "andl", 0x5CC47000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* andl<.f><.cc> RB,RB,ximm 01011bbb11000100FBBB1111000QQQQQ.  */
{ "andl", 0x58C40F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* andl<.f> RA,ximm,u6 0101110001000100F111uuuuuuaaaaaa.  */
{ "andl", 0x5C447000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* andl<.f> 0,ximm,u6 0101110001000100F111uuuuuu111110.  */
{ "andl", 0x5C44703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* andl<.f><.cc> 0,ximm,u6 0101110011000100F111uuuuuu1QQQQQ.  */
{ "andl", 0x5CC47020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* andl<.f> RA,limm,RC 0101111000000100F111ccccccaaaaaa.  */
{ "andl", 0x5E047000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* andl<.f> RA,RB,limm 01011bbb00000100FBBB111110aaaaaa.  */
{ "andl", 0x58040F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* andl<.f> 0,limm,RC 0101111000000100F111cccccc111110.  */
{ "andl", 0x5E04703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* andl<.f> 0,RB,limm 01011bbb00000100FBBB111110111110.  */
{ "andl", 0x58040FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* andl<.f><.cc> 0,limm,RC 0101111011000100F111cccccc0QQQQQ.  */
{ "andl", 0x5EC47000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* andl<.f><.cc> RB,RB,limm 01011bbb11000100FBBB1111100QQQQQ.  */
{ "andl", 0x58C40F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* andl<.f> RA,limm,u6 0101111001000100F111uuuuuuaaaaaa.  */
{ "andl", 0x5E447000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* andl<.f> 0,limm,u6 0101111001000100F111uuuuuu111110.  */
{ "andl", 0x5E44703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* andl<.f><.cc> 0,limm,u6 0101111011000100F111uuuuuu1QQQQQ.  */
{ "andl", 0x5EC47020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* andl<.f> 0,ximm,s12 0101110010000100F111ssssssSSSSSS.  */
{ "andl", 0x5C847000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* andl<.f> 0,limm,s12 0101111010000100F111ssssssSSSSSS.  */
{ "andl", 0x5E847000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* andl<.f> RA,ximm,ximm 0101110000000100F111111100aaaaaa.  */
{ "andl", 0x5C047F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* andl<.f> 0,ximm,ximm 0101110000000100F111111100111110.  */
{ "andl", 0x5C047F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* andl<.f><.cc> 0,ximm,ximm 0101110011000100F1111111000QQQQQ.  */
{ "andl", 0x5CC47F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* andl<.f> RA,limm,limm 0101111000000100F111111110aaaaaa.  */
{ "andl", 0x5E047F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* andl<.f> 0,limm,limm 0101111000000100F111111110111110.  */
{ "andl", 0x5E047FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* andl<.f><.cc> 0,limm,limm 0101111011000100F1111111100QQQQQ.  */
{ "andl", 0x5EC47F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* andl_s b,b,c 01111bbbccc01000.  */
{ "andl_s", 0x00007808, 0x0000F81F, ARC_OPCODE_ARC64, ARITH, NONE, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* and_s b,b,c 01111bbbccc00100.  */
{ "and_s", 0x00007804, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* asl<.f> b,c 00100bbb00101111FBBBCCCCCC000000.  */
{ "asl", 0x202F0000, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RC }, { C_F }},

/* asl<.f> 0,c 0010011000101111F111CCCCCC000000.  */
{ "asl", 0x262F7000, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RC }, { C_F }},

/* asl<.f> a,b,c 00101bbb00000000FBBBCCCCCCAAAAAA.  */
{ "asl", 0x28000000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, RB, RC }, { C_F }},

/* asl<.f> 0,b,c 00101bbb00000000FBBBCCCCCC111110.  */
{ "asl", 0x2800003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, RB, RC }, { C_F }},

/* asl<.f><.cc> b,b,c 00101bbb11000000FBBBCCCCCC0QQQQQ.  */
{ "asl", 0x28C00000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RB, RBdup, RC }, { C_F, C_CC }},

/* asl<.f> b,u6 00100bbb01101111FBBBuuuuuu000000.  */
{ "asl", 0x206F0000, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, UIMM6_20 }, { C_F }},

/* asl<.f> 0,u6 0010011001101111F111uuuuuu000000.  */
{ "asl", 0x266F7000, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, UIMM6_20 }, { C_F }},

/* asl<.f> a,b,u6 00101bbb01000000FBBBuuuuuuAAAAAA.  */
{ "asl", 0x28400000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, RB, UIMM6_20 }, { C_F }},

/* asl<.f> 0,b,u6 00101bbb01000000FBBBuuuuuu111110.  */
{ "asl", 0x2840003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, RB, UIMM6_20 }, { C_F }},

/* asl<.f><.cc> b,b,u6 00101bbb11000000FBBBuuuuuu1QQQQQ.  */
{ "asl", 0x28C00020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* asl<.f> b,b,s12 00101bbb10000000FBBBssssssSSSSSS.  */
{ "asl", 0x28800000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RB, RBdup, SIMM12_20 }, { C_F }},

/* asl<.f> b,limm 00100bbb00101111FBBB111110000000.  */
{ "asl", 0x202F0F80, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, LIMM }, { C_F }},

/* asl<.f> 0,limm 0010011000101111F111111110000000.  */
{ "asl", 0x262F7F80, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM }, { C_F }},

/* asl<.f> a,limm,c 0010111000000000F111CCCCCCAAAAAA.  */
{ "asl", 0x2E007000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, LIMM, RC }, { C_F }},

/* asl<.f> a,b,limm 00101bbb00000000FBBB111110AAAAAA.  */
{ "asl", 0x28000F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, RB, LIMM }, { C_F }},

/* asl<.f> 0,limm,c 0010111000000000F111CCCCCC111110.  */
{ "asl", 0x2E00703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, RC }, { C_F }},

/* asl<.f> 0,b,limm 00101bbb00000000FBBB111110111110.  */
{ "asl", 0x28000FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, RB, LIMM }, { C_F }},

/* asl<.f><.cc> b,b,limm 00101bbb11000000FBBB1111100QQQQQ.  */
{ "asl", 0x28C00F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* asl<.f><.cc> 0,limm,c 0010111011000000F111CCCCCC0QQQQQ.  */
{ "asl", 0x2EC07000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, RC }, { C_F, C_CC }},

/* asl<.f> a,limm,u6 0010111001000000F111uuuuuuAAAAAA.  */
{ "asl", 0x2E407000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, LIMM, UIMM6_20 }, { C_F }},

/* asl<.f> 0,limm,u6 0010111001000000F111uuuuuu111110.  */
{ "asl", 0x2E40703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* asl<.f><.cc> 0,limm,u6 0010111011000000F111uuuuuu1QQQQQ.  */
{ "asl", 0x2EC07020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* asl<.f> 0,limm,s12 0010111010000000F111ssssssSSSSSS.  */
{ "asl", 0x2E807000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* asl<.f> a,limm,limm 0010111000000000F111111110AAAAAA.  */
{ "asl", 0x2E007F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, LIMM, LIMMdup }, { C_F }},

/* asl<.f> 0,limm,limm 0010111000000000F111111110111110.  */
{ "asl", 0x2E007FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, LIMMdup }, { C_F }},

/* asl<.f><.cc> 0,limm,limm 0010111011000000F1111111100QQQQQ.  */
{ "asl", 0x2EC07F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* asll<.f> RA,RB,RC 01011bbb00100000FBBBccccccaaaaaa.  */
{ "asll", 0x58200000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* asll<.f> 0,RB,RC 01011bbb00100000FBBBcccccc111110.  */
{ "asll", 0x5820003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* asll<.f><.cc> RB,RB,RC 01011bbb11100000FBBBcccccc0QQQQQ.  */
{ "asll", 0x58E00000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* asll<.f> RB,RC 01011bbb00101111FBBBcccccc000000.  */
{ "asll", 0x582F0000, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* asll<.f> 0,RC 0101111000101111F111cccccc000000.  */
{ "asll", 0x5E2F7000, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RC }, { C_F }},

/* asll<.f> RA,RB,u6 01011bbb01100000FBBBuuuuuuaaaaaa.  */
{ "asll", 0x58600000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* asll<.f> 0,RB,u6 01011bbb01100000FBBBuuuuuu111110.  */
{ "asll", 0x5860003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* asll<.f><.cc> RB,RB,u6 01011bbb11100000FBBBuuuuuu1QQQQQ.  */
{ "asll", 0x58E00020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* asll<.f> RB,u6 01011bbb01101111FBBBuuuuuu000000.  */
{ "asll", 0x586F0000, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* asll<.f> 0,u6 0101111001101111F111uuuuuu000000.  */
{ "asll", 0x5E6F7000, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* asll<.f> RB,RB,s12 01011bbb10100000FBBBssssssSSSSSS.  */
{ "asll", 0x58A00000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* asll<.f> RA,ximm,RC 0101110000100000F111ccccccaaaaaa.  */
{ "asll", 0x5C207000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* asll<.f> RA,RB,ximm 01011bbb00100000FBBB111100aaaaaa.  */
{ "asll", 0x58200F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* asll<.f> 0,ximm,RC 0101110000100000F111cccccc111110.  */
{ "asll", 0x5C20703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* asll<.f> 0,RB,ximm 01011bbb00100000FBBB111100111110.  */
{ "asll", 0x58200F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* asll<.f><.cc> 0,ximm,RC 0101110011100000F111cccccc0QQQQQ.  */
{ "asll", 0x5CE07000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* asll<.f><.cc> RB,RB,ximm 01011bbb11100000FBBB1111000QQQQQ.  */
{ "asll", 0x58E00F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* asll<.f> RB,ximm 01011bbb00101111FBBB111100000000.  */
{ "asll", 0x582F0F00, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { C_F }},

/* asll<.f> 0,ximm 0101111000101111F111111100000000.  */
{ "asll", 0x5E2F7F00, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM }, { C_F }},

/* asll<.f> RA,ximm,u6 0101110001100000F111uuuuuuaaaaaa.  */
{ "asll", 0x5C607000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* asll<.f> 0,ximm,u6 0101110001100000F111uuuuuu111110.  */
{ "asll", 0x5C60703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* asll<.f><.cc> 0,ximm,u6 0101110011100000F111uuuuuu1QQQQQ.  */
{ "asll", 0x5CE07020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* asll<.f> RA,limm,RC 0101111000100000F111ccccccaaaaaa.  */
{ "asll", 0x5E207000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* asll<.f> RA,RB,limm 01011bbb00100000FBBB111110aaaaaa.  */
{ "asll", 0x58200F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* asll<.f> 0,limm,RC 0101111000100000F111cccccc111110.  */
{ "asll", 0x5E20703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* asll<.f> 0,RB,limm 01011bbb00100000FBBB111110111110.  */
{ "asll", 0x58200FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* asll<.f><.cc> 0,limm,RC 0101111011100000F111cccccc0QQQQQ.  */
{ "asll", 0x5EE07000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* asll<.f><.cc> RB,RB,limm 01011bbb11100000FBBB1111100QQQQQ.  */
{ "asll", 0x58E00F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* asll<.f> RB,limm 01011bbb00101111FBBB111110000000.  */
{ "asll", 0x582F0F80, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* asll<.f> 0,limm 0101111000101111F111111110000000.  */
{ "asll", 0x5E2F7F80, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* asll<.f> RA,limm,u6 0101111001100000F111uuuuuuaaaaaa.  */
{ "asll", 0x5E607000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* asll<.f> 0,limm,u6 0101111001100000F111uuuuuu111110.  */
{ "asll", 0x5E60703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* asll<.f><.cc> 0,limm,u6 0101111011100000F111uuuuuu1QQQQQ.  */
{ "asll", 0x5EE07020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* asll<.f> 0,ximm,s12 0101110010100000F111ssssssSSSSSS.  */
{ "asll", 0x5CA07000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* asll<.f> 0,limm,s12 0101111010100000F111ssssssSSSSSS.  */
{ "asll", 0x5EA07000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* asll<.f> RA,ximm,ximm 0101110000100000F111111100aaaaaa.  */
{ "asll", 0x5C207F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* asll<.f> 0,ximm,ximm 0101110000100000F111111100111110.  */
{ "asll", 0x5C207F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* asll<.f><.cc> 0,ximm,ximm 0101110011100000F1111111000QQQQQ.  */
{ "asll", 0x5CE07F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* asll<.f> RA,limm,limm 0101111000100000F111111110aaaaaa.  */
{ "asll", 0x5E207F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* asll<.f> 0,limm,limm 0101111000100000F111111110111110.  */
{ "asll", 0x5E207FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* asll<.f><.cc> 0,limm,limm 0101111011100000F1111111100QQQQQ.  */
{ "asll", 0x5EE07F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* asl_s b,c 01111bbbccc11011.  */
{ "asl_s", 0x0000781B, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB_S, RC_S }, { 0 }},

/* asl_s b,b,c 01111bbbccc11000.  */
{ "asl_s", 0x00007818, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* asl_s b,b,u5 10111bbb000uuuuu.  */
{ "asl_s", 0x0000B800, 0x0000F8E0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RB_S, RB_Sdup, UIMM5_11_S }, { 0 }},

/* asr<.f> b,c 00100bbb00101111FBBBCCCCCC000001.  */
{ "asr", 0x202F0001, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RC }, { C_F }},

/* asr<.f> 0,c 0010011000101111F111CCCCCC000001.  */
{ "asr", 0x262F7001, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RC }, { C_F }},

/* asr<.f> a,b,c 00101bbb00000010FBBBCCCCCCAAAAAA.  */
{ "asr", 0x28020000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, RB, RC }, { C_F }},

/* asr<.f> 0,b,c 00101bbb00000010FBBBCCCCCC111110.  */
{ "asr", 0x2802003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, RB, RC }, { C_F }},

/* asr<.f><.cc> b,b,c 00101bbb11000010FBBBCCCCCC0QQQQQ.  */
{ "asr", 0x28C20000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RB, RBdup, RC }, { C_F, C_CC }},

/* asr<.f> b,u6 00100bbb01101111FBBBuuuuuu000001.  */
{ "asr", 0x206F0001, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, UIMM6_20 }, { C_F }},

/* asr<.f> 0,u6 0010011001101111F111uuuuuu000001.  */
{ "asr", 0x266F7001, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, UIMM6_20 }, { C_F }},

/* asr<.f> a,b,u6 00101bbb01000010FBBBuuuuuuAAAAAA.  */
{ "asr", 0x28420000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, RB, UIMM6_20 }, { C_F }},

/* asr<.f> 0,b,u6 00101bbb01000010FBBBuuuuuu111110.  */
{ "asr", 0x2842003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, RB, UIMM6_20 }, { C_F }},

/* asr<.f><.cc> b,b,u6 00101bbb11000010FBBBuuuuuu1QQQQQ.  */
{ "asr", 0x28C20020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* asr<.f> b,b,s12 00101bbb10000010FBBBssssssSSSSSS.  */
{ "asr", 0x28820000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RB, RBdup, SIMM12_20 }, { C_F }},

/* asr<.f> b,limm 00100bbb00101111FBBB111110000001.  */
{ "asr", 0x202F0F81, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, LIMM }, { C_F }},

/* asr<.f> 0,limm 0010011000101111F111111110000001.  */
{ "asr", 0x262F7F81, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM }, { C_F }},

/* asr<.f> a,limm,c 0010111000000010F111CCCCCCAAAAAA.  */
{ "asr", 0x2E027000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, LIMM, RC }, { C_F }},

/* asr<.f> a,b,limm 00101bbb00000010FBBB111110AAAAAA.  */
{ "asr", 0x28020F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, RB, LIMM }, { C_F }},

/* asr<.f> 0,limm,c 0010111000000010F111CCCCCC111110.  */
{ "asr", 0x2E02703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, RC }, { C_F }},

/* asr<.f> 0,b,limm 00101bbb00000010FBBB111110111110.  */
{ "asr", 0x28020FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, RB, LIMM }, { C_F }},

/* asr<.f><.cc> b,b,limm 00101bbb11000010FBBB1111100QQQQQ.  */
{ "asr", 0x28C20F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* asr<.f><.cc> 0,limm,c 0010111011000010F111CCCCCC0QQQQQ.  */
{ "asr", 0x2EC27000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, RC }, { C_F, C_CC }},

/* asr<.f> a,limm,u6 0010111001000010F111uuuuuuAAAAAA.  */
{ "asr", 0x2E427000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, LIMM, UIMM6_20 }, { C_F }},

/* asr<.f> 0,limm,u6 0010111001000010F111uuuuuu111110.  */
{ "asr", 0x2E42703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* asr<.f><.cc> 0,limm,u6 0010111011000010F111uuuuuu1QQQQQ.  */
{ "asr", 0x2EC27020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* asr<.f> 0,limm,s12 0010111010000010F111ssssssSSSSSS.  */
{ "asr", 0x2E827000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* asr<.f> a,limm,limm 0010111000000010F111111110AAAAAA.  */
{ "asr", 0x2E027F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, LIMM, LIMMdup }, { C_F }},

/* asr<.f> 0,limm,limm 0010111000000010F111111110111110.  */
{ "asr", 0x2E027FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, LIMMdup }, { C_F }},

/* asr<.f><.cc> 0,limm,limm 0010111011000010F1111111100QQQQQ.  */
{ "asr", 0x2EC27F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* asr16<.f> b,c 00101bbb00101111FBBBCCCCCC001100.  */
{ "asr16", 0x282F000C, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { RB, RC }, { C_F }},

/* asr16<.f> 0,c 0010111000101111F111CCCCCC001100.  */
{ "asr16", 0x2E2F700C, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { ZA, RC }, { C_F }},

/* asr16<.f> b,u6 00101bbb01101111FBBBuuuuuu001100.  */
{ "asr16", 0x286F000C, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { RB, UIMM6_20 }, { C_F }},

/* asr16<.f> 0,u6 0010111001101111F111uuuuuu001100.  */
{ "asr16", 0x2E6F700C, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { ZA, UIMM6_20 }, { C_F }},

/* asr16<.f> b,limm 00101bbb00101111FBBB111110001100.  */
{ "asr16", 0x282F0F8C, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { RB, LIMM }, { C_F }},

/* asr16<.f> 0,limm 0010111000101111F111111110001100.  */
{ "asr16", 0x2E2F7F8C, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { ZA, LIMM }, { C_F }},

/* asr8<.f> b,c 00101bbb00101111FBBBCCCCCC001101.  */
{ "asr8", 0x282F000D, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { RB, RC }, { C_F }},

/* asr8<.f> 0,c 0010111000101111F111CCCCCC001101.  */
{ "asr8", 0x2E2F700D, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { ZA, RC }, { C_F }},

/* asr8<.f> b,u6 00101bbb01101111FBBBuuuuuu001101.  */
{ "asr8", 0x286F000D, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { RB, UIMM6_20 }, { C_F }},

/* asr8<.f> 0,u6 0010111001101111F111uuuuuu001101.  */
{ "asr8", 0x2E6F700D, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { ZA, UIMM6_20 }, { C_F }},

/* asr8<.f> b,limm 00101bbb00101111FBBB111110001101.  */
{ "asr8", 0x282F0F8D, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { RB, LIMM }, { C_F }},

/* asr8<.f> 0,limm 0010111000101111F111111110001101.  */
{ "asr8", 0x2E2F7F8D, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { ZA, LIMM }, { C_F }},

/* asrl<.f> RA,RB,RC 01011bbb00100010FBBBccccccaaaaaa.  */
{ "asrl", 0x58220000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* asrl<.f> 0,RB,RC 01011bbb00100010FBBBcccccc111110.  */
{ "asrl", 0x5822003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* asrl<.f><.cc> RB,RB,RC 01011bbb11100010FBBBcccccc0QQQQQ.  */
{ "asrl", 0x58E20000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* asrl<.f> RB,RC 01011bbb00101111FBBBcccccc000001.  */
{ "asrl", 0x582F0001, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* asrl<.f> 0,RC 0101111000101111F111cccccc000001.  */
{ "asrl", 0x5E2F7001, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RC }, { C_F }},

/* asrl<.f> RA,RB,u6 01011bbb01100010FBBBuuuuuuaaaaaa.  */
{ "asrl", 0x58620000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* asrl<.f> 0,RB,u6 01011bbb01100010FBBBuuuuuu111110.  */
{ "asrl", 0x5862003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* asrl<.f><.cc> RB,RB,u6 01011bbb11100010FBBBuuuuuu1QQQQQ.  */
{ "asrl", 0x58E20020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* asrl<.f> RB,u6 01011bbb01101111FBBBuuuuuu000001.  */
{ "asrl", 0x586F0001, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* asrl<.f> 0,u6 0101111001101111F111uuuuuu000001.  */
{ "asrl", 0x5E6F7001, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* asrl<.f> RB,RB,s12 01011bbb10100010FBBBssssssSSSSSS.  */
{ "asrl", 0x58A20000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* asrl<.f> RA,ximm,RC 0101110000100010F111ccccccaaaaaa.  */
{ "asrl", 0x5C227000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* asrl<.f> RA,RB,ximm 01011bbb00100010FBBB111100aaaaaa.  */
{ "asrl", 0x58220F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* asrl<.f> 0,ximm,RC 0101110000100010F111cccccc111110.  */
{ "asrl", 0x5C22703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* asrl<.f> 0,RB,ximm 01011bbb00100010FBBB111100111110.  */
{ "asrl", 0x58220F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* asrl<.f><.cc> 0,ximm,RC 0101110011100010F111cccccc0QQQQQ.  */
{ "asrl", 0x5CE27000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* asrl<.f><.cc> RB,RB,ximm 01011bbb11100010FBBB1111000QQQQQ.  */
{ "asrl", 0x58E20F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* asrl<.f> RB,ximm 01011bbb00101111FBBB111100000001.  */
{ "asrl", 0x582F0F01, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { C_F }},

/* asrl<.f> 0,ximm 0101111000101111F111111100000001.  */
{ "asrl", 0x5E2F7F01, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM }, { C_F }},

/* asrl<.f> RA,ximm,u6 0101110001100010F111uuuuuuaaaaaa.  */
{ "asrl", 0x5C627000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* asrl<.f> 0,ximm,u6 0101110001100010F111uuuuuu111110.  */
{ "asrl", 0x5C62703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* asrl<.f><.cc> 0,ximm,u6 0101110011100010F111uuuuuu1QQQQQ.  */
{ "asrl", 0x5CE27020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* asrl<.f> RA,limm,RC 0101111000100010F111ccccccaaaaaa.  */
{ "asrl", 0x5E227000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* asrl<.f> RA,RB,limm 01011bbb00100010FBBB111110aaaaaa.  */
{ "asrl", 0x58220F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* asrl<.f> 0,limm,RC 0101111000100010F111cccccc111110.  */
{ "asrl", 0x5E22703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* asrl<.f> 0,RB,limm 01011bbb00100010FBBB111110111110.  */
{ "asrl", 0x58220FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* asrl<.f><.cc> 0,limm,RC 0101111011100010F111cccccc0QQQQQ.  */
{ "asrl", 0x5EE27000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* asrl<.f><.cc> RB,RB,limm 01011bbb11100010FBBB1111100QQQQQ.  */
{ "asrl", 0x58E20F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* asrl<.f> RB,limm 01011bbb00101111FBBB111110000001.  */
{ "asrl", 0x582F0F81, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* asrl<.f> 0,limm 0101111000101111F111111110000001.  */
{ "asrl", 0x5E2F7F81, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* asrl<.f> RA,limm,u6 0101111001100010F111uuuuuuaaaaaa.  */
{ "asrl", 0x5E627000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* asrl<.f> 0,limm,u6 0101111001100010F111uuuuuu111110.  */
{ "asrl", 0x5E62703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* asrl<.f><.cc> 0,limm,u6 0101111011100010F111uuuuuu1QQQQQ.  */
{ "asrl", 0x5EE27020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* asrl<.f> 0,ximm,s12 0101110010100010F111ssssssSSSSSS.  */
{ "asrl", 0x5CA27000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* asrl<.f> 0,limm,s12 0101111010100010F111ssssssSSSSSS.  */
{ "asrl", 0x5EA27000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* asrl<.f> RA,ximm,ximm 0101110000100010F111111100aaaaaa.  */
{ "asrl", 0x5C227F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* asrl<.f> 0,ximm,ximm 0101110000100010F111111100111110.  */
{ "asrl", 0x5C227F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* asrl<.f><.cc> 0,ximm,ximm 0101110011100010F1111111000QQQQQ.  */
{ "asrl", 0x5CE27F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* asrl<.f> RA,limm,limm 0101111000100010F111111110aaaaaa.  */
{ "asrl", 0x5E227F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* asrl<.f> 0,limm,limm 0101111000100010F111111110111110.  */
{ "asrl", 0x5E227FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* asrl<.f><.cc> 0,limm,limm 0101111011100010F1111111100QQQQQ.  */
{ "asrl", 0x5EE27F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* asr_s b,c 01111bbbccc11100.  */
{ "asr_s", 0x0000781C, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB_S, RC_S }, { 0 }},

/* asr_s b,b,c 01111bbbccc11010.  */
{ "asr_s", 0x0000781A, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* asr_s b,b,u5 10111bbb010uuuuu.  */
{ "asr_s", 0x0000B840, 0x0000F8E0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RB_S, RB_Sdup, UIMM5_11_S }, { 0 }},

/* atld<.op><.aq> RB,RC 00100bbb00101111FBBBcccccc110OOO.  */
{ "atld", 0x202F0030, 0xF8FF0038, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, BRAKET, RC, BRAKETdup }, { C_ATOP, C_AQ, C_RL }},

/* atldl_add<.aq> RB,RC 01011bbb00101111FBBBcccccc110000.  */
{ "atldl", 0x582F0030, 0xF8FF0038, ARC_OPCODE_ARC64, ARITH, NONE, { RB, BRAKET, RC, BRAKETdup }, { C_ATOP, C_AQ, C_RL }},

/* b<.d> s25 00000ssssssssss1SSSSSSSSSSNRtttt.  */
{ "b", 0x00010000, 0xF8010000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRANCH, NONE, { SIMM25_A16_5 }, { C_D }},

/* b<.d><cc> s21 00000ssssssssss0SSSSSSSSSSNQQQQQ.  */
{ "b", 0x00000000, 0xF8010000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRANCH, NONE, { SIMM21_A16_5 }, { C_CC, C_D }},

/* bbit0<.d> b,c,s9 00001bbbsssssss1SBBBCCCCCCN00110.  */
{ "bbit0", 0x08010006, 0xF801001F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BBIT0, NONE, { RB, RC, SIMM9_A16_8 }, { C_D }},

/* bbit0<.d> b,u6,s9 00001bbbsssssss1SBBBuuuuuuN10110.  */
{ "bbit0", 0x08010016, 0xF801001F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BBIT0, NONE, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D }},

/* bbit0 b,limm,s9 00001bbbsssssss1SBBB111110000110.  */
{ "bbit0", 0x08010F86, 0xF8010FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BBIT0, NONE, { RB, LIMM, SIMM9_A16_8 }, { 0 }},

/* bbit0 limm,c,s9 00001110sssssss1S111CCCCCC000110.  */
{ "bbit0", 0x0E017006, 0xFF01703F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BBIT0, NONE, { LIMM, RC, SIMM9_A16_8 }, { 0 }},

/* bbit0 limm,u6,s9 00001110sssssss1S111uuuuuu010110.  */
{ "bbit0", 0x0E017016, 0xFF01703F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BBIT0, NONE, { LIMM, UIMM6_8, SIMM9_A16_8 }, { 0 }},

/* bbit0 limm,limm,s9 00001110sssssss1S111111110000110.  */
{ "bbit0", 0x0E017F86, 0xFF017FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BBIT0, NONE, { LIMM, LIMMdup, SIMM9_A16_8 }, { 0 }},

/* bbit0l<.d> b,c,s9 00001bbbsssssss1SBBBCCCCCCN01110.  */
{ "bbit0l", 0x0801000E, 0xF801001F, ARC_OPCODE_ARC64, BBIT0, NONE, { RB, RC, SIMM9_A16_8 }, { C_D }},

/* bbit0l<.d> b,u6,s9 00001bbbsssssss1SBBBuuuuuuN11110.  */
{ "bbit0l", 0x0801001E, 0xF801001F, ARC_OPCODE_ARC64, BBIT0, NONE, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D }},

/* bbit0l b,limm,s9 00001bbbsssssss1SBBB111110001110.  */
{ "bbit0l", 0x08010F8E, 0xF8010FFF, ARC_OPCODE_ARC64, BBIT0, NONE, { RB, LIMM, SIMM9_A16_8 }, { 0 }},

/* bbit0l limm,c,s9 00001110sssssss1S111CCCCCC001110.  */
{ "bbit0l", 0x0E01700E, 0xFF01703F, ARC_OPCODE_ARC64, BBIT0, NONE, { LIMM, RC, SIMM9_A16_8 }, { 0 }},

/* bbit0l limm,u6,s9 00001110sssssss1S111uuuuuu011110.  */
{ "bbit0l", 0x0E01701E, 0xFF01703F, ARC_OPCODE_ARC64, BBIT0, NONE, { LIMM, UIMM6_8, SIMM9_A16_8 }, { 0 }},

/* bbit0l limm,limm,s9 00001110sssssss1S111111110001110.  */
{ "bbit0l", 0x0E017F8E, 0xFF017FFF, ARC_OPCODE_ARC64, BBIT0, NONE, { LIMM, LIMMdup, SIMM9_A16_8 }, { 0 }},

/* bbit1<.d> b,c,s9 00001bbbsssssss1SBBBCCCCCCN00111.  */
{ "bbit1", 0x08010007, 0xF801001F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BBIT1, NONE, { RB, RC, SIMM9_A16_8 }, { C_D }},

/* bbit1<.d> b,u6,s9 00001bbbsssssss1SBBBuuuuuuN10111.  */
{ "bbit1", 0x08010017, 0xF801001F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BBIT1, NONE, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D }},

/* bbit1 b,limm,s9 00001bbbsssssss1SBBB111110000111.  */
{ "bbit1", 0x08010F87, 0xF8010FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BBIT1, NONE, { RB, LIMM, SIMM9_A16_8 }, { 0 }},

/* bbit1 limm,c,s9 00001110sssssss1S111CCCCCC000111.  */
{ "bbit1", 0x0E017007, 0xFF01703F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BBIT1, NONE, { LIMM, RC, SIMM9_A16_8 }, { 0 }},

/* bbit1 limm,u6,s9 00001110sssssss1S111uuuuuu010111.  */
{ "bbit1", 0x0E017017, 0xFF01703F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BBIT1, NONE, { LIMM, UIMM6_8, SIMM9_A16_8 }, { 0 }},

/* bbit1 limm,limm,s9 00001110sssssss1S111111110000111.  */
{ "bbit1", 0x0E017F87, 0xFF017FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BBIT1, NONE, { LIMM, LIMMdup, SIMM9_A16_8 }, { 0 }},

/* bbit1l<.d> b,c,s9 00001bbbsssssss1SBBBCCCCCCN01111.  */
{ "bbit1l", 0x0801000F, 0xF801001F, ARC_OPCODE_ARC64, BBIT1, NONE, { RB, RC, SIMM9_A16_8 }, { C_D }},

/* bbit1l<.d> b,u6,s9 00001bbbsssssss1SBBBuuuuuuN11111.  */
{ "bbit1l", 0x0801001F, 0xF801001F, ARC_OPCODE_ARC64, BBIT1, NONE, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D }},

/* bbit1l b,limm,s9 00001bbbsssssss1SBBB111110001111.  */
{ "bbit1l", 0x08010F8F, 0xF8010FFF, ARC_OPCODE_ARC64, BBIT1, NONE, { RB, LIMM, SIMM9_A16_8 }, { 0 }},

/* bbit1l limm,c,s9 00001110sssssss1S111CCCCCC001111.  */
{ "bbit1l", 0x0E01700F, 0xFF01703F, ARC_OPCODE_ARC64, BBIT1, NONE, { LIMM, RC, SIMM9_A16_8 }, { 0 }},

/* bbit1l limm,u6,s9 00001110sssssss1S111uuuuuu011111.  */
{ "bbit1l", 0x0E01701F, 0xFF01703F, ARC_OPCODE_ARC64, BBIT1, NONE, { LIMM, UIMM6_8, SIMM9_A16_8 }, { 0 }},

/* bbit1l limm,limm,s9 00001110sssssss1S111111110001111.  */
{ "bbit1l", 0x0E017F8F, 0xFF017FFF, ARC_OPCODE_ARC64, BBIT1, NONE, { LIMM, LIMMdup, SIMM9_A16_8 }, { 0 }},

/* bclr<.f> a,b,c 00100bbb00010000FBBBCCCCCCAAAAAA.  */
{ "bclr", 0x20100000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* bclr<.f> 0,b,c 00100bbb00010000FBBBCCCCCC111110.  */
{ "bclr", 0x2010003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* bclr<.f><.cc> b,b,c 00100bbb11010000FBBBCCCCCC0QQQQQ.  */
{ "bclr", 0x20D00000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* bclr<.f> a,b,u6 00100bbb01010000FBBBuuuuuuAAAAAA.  */
{ "bclr", 0x20500000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* bclr<.f> 0,b,u6 00100bbb01010000FBBBuuuuuu111110.  */
{ "bclr", 0x2050003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* bclr<.f><.cc> b,b,u6 00100bbb11010000FBBBuuuuuu1QQQQQ.  */
{ "bclr", 0x20D00020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* bclr<.f> b,b,s12 00100bbb10010000FBBBssssssSSSSSS.  */
{ "bclr", 0x20900000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* bclr<.f> a,limm,c 0010011000010000F111CCCCCCAAAAAA.  */
{ "bclr", 0x26107000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* bclr<.f> a,b,limm 00100bbb00010000FBBB111110AAAAAA.  */
{ "bclr", 0x20100F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* bclr<.f> 0,limm,c 0010011000010000F111CCCCCC111110.  */
{ "bclr", 0x2610703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* bclr<.f> 0,b,limm 00100bbb00010000FBBB111110111110.  */
{ "bclr", 0x20100FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* bclr<.f><.cc> b,b,limm 00100bbb11010000FBBB1111100QQQQQ.  */
{ "bclr", 0x20D00F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* bclr<.f><.cc> 0,limm,c 0010011011010000F111CCCCCC0QQQQQ.  */
{ "bclr", 0x26D07000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* bclr<.f> a,limm,u6 0010011001010000F111uuuuuuAAAAAA.  */
{ "bclr", 0x26507000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* bclr<.f> 0,limm,u6 0010011001010000F111uuuuuu111110.  */
{ "bclr", 0x2650703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* bclr<.f><.cc> 0,limm,u6 0010011011010000F111uuuuuu1QQQQQ.  */
{ "bclr", 0x26D07020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* bclr<.f> 0,limm,s12 0010011010010000F111ssssssSSSSSS.  */
{ "bclr", 0x26907000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* bclr<.f> a,limm,limm 0010011000010000F111111110AAAAAA.  */
{ "bclr", 0x26107F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* bclr<.f> 0,limm,limm 0010011000010000F111111110111110.  */
{ "bclr", 0x26107FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* bclr<.f><.cc> 0,limm,limm 0010011011010000F1111111100QQQQQ.  */
{ "bclr", 0x26D07F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* bclrl<.f> RA,RB,RC 01011bbb00010000FBBBccccccaaaaaa.  */
{ "bclrl", 0x58100000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* bclrl<.f> 0,RB,RC 01011bbb00010000FBBBcccccc111110.  */
{ "bclrl", 0x5810003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* bclrl<.f><.cc> RB,RB,RC 01011bbb11010000FBBBcccccc0QQQQQ.  */
{ "bclrl", 0x58D00000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* bclrl<.f> RA,RB,u6 01011bbb01010000FBBBuuuuuuaaaaaa.  */
{ "bclrl", 0x58500000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* bclrl<.f> 0,RB,u6 01011bbb01010000FBBBuuuuuu111110.  */
{ "bclrl", 0x5850003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* bclrl<.f><.cc> RB,RB,u6 01011bbb11010000FBBBuuuuuu1QQQQQ.  */
{ "bclrl", 0x58D00020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* bclrl<.f> RB,RB,s12 01011bbb10010000FBBBssssssSSSSSS.  */
{ "bclrl", 0x58900000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* bclrl<.f> RA,ximm,RC 0101110000010000F111ccccccaaaaaa.  */
{ "bclrl", 0x5C107000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* bclrl<.f> RA,RB,ximm 01011bbb00010000FBBB111100aaaaaa.  */
{ "bclrl", 0x58100F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* bclrl<.f> 0,ximm,RC 0101110000010000F111cccccc111110.  */
{ "bclrl", 0x5C10703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* bclrl<.f> 0,RB,ximm 01011bbb00010000FBBB111100111110.  */
{ "bclrl", 0x58100F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* bclrl<.f><.cc> 0,ximm,RC 0101110011010000F111cccccc0QQQQQ.  */
{ "bclrl", 0x5CD07000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* bclrl<.f><.cc> RB,RB,ximm 01011bbb11010000FBBB1111000QQQQQ.  */
{ "bclrl", 0x58D00F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* bclrl<.f> RA,ximm,u6 0101110001010000F111uuuuuuaaaaaa.  */
{ "bclrl", 0x5C507000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* bclrl<.f> 0,ximm,u6 0101110001010000F111uuuuuu111110.  */
{ "bclrl", 0x5C50703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* bclrl<.f><.cc> 0,ximm,u6 0101110011010000F111uuuuuu1QQQQQ.  */
{ "bclrl", 0x5CD07020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* bclrl<.f> RA,limm,RC 0101111000010000F111ccccccaaaaaa.  */
{ "bclrl", 0x5E107000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* bclrl<.f> RA,RB,limm 01011bbb00010000FBBB111110aaaaaa.  */
{ "bclrl", 0x58100F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* bclrl<.f> 0,limm,RC 0101111000010000F111cccccc111110.  */
{ "bclrl", 0x5E10703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* bclrl<.f> 0,RB,limm 01011bbb00010000FBBB111110111110.  */
{ "bclrl", 0x58100FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* bclrl<.f><.cc> 0,limm,RC 0101111011010000F111cccccc0QQQQQ.  */
{ "bclrl", 0x5ED07000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* bclrl<.f><.cc> RB,RB,limm 01011bbb11010000FBBB1111100QQQQQ.  */
{ "bclrl", 0x58D00F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* bclrl<.f> RA,limm,u6 0101111001010000F111uuuuuuaaaaaa.  */
{ "bclrl", 0x5E507000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* bclrl<.f> 0,limm,u6 0101111001010000F111uuuuuu111110.  */
{ "bclrl", 0x5E50703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* bclrl<.f><.cc> 0,limm,u6 0101111011010000F111uuuuuu1QQQQQ.  */
{ "bclrl", 0x5ED07020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* bclrl<.f> 0,ximm,s12 0101110010010000F111ssssssSSSSSS.  */
{ "bclrl", 0x5C907000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* bclrl<.f> 0,limm,s12 0101111010010000F111ssssssSSSSSS.  */
{ "bclrl", 0x5E907000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* bclrl<.f> RA,ximm,ximm 0101110000010000F111111100aaaaaa.  */
{ "bclrl", 0x5C107F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* bclrl<.f> 0,ximm,ximm 0101110000010000F111111100111110.  */
{ "bclrl", 0x5C107F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* bclrl<.f><.cc> 0,ximm,ximm 0101110011010000F1111111000QQQQQ.  */
{ "bclrl", 0x5CD07F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* bclrl<.f> RA,limm,limm 0101111000010000F111111110aaaaaa.  */
{ "bclrl", 0x5E107F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* bclrl<.f> 0,limm,limm 0101111000010000F111111110111110.  */
{ "bclrl", 0x5E107FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* bclrl<.f><.cc> 0,limm,limm 0101111011010000F1111111100QQQQQ.  */
{ "bclrl", 0x5ED07F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* bclr_s b,b,u5 10111bbb101uuuuu.  */
{ "bclr_s", 0x0000B8A0, 0x0000F8E0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB_S, RB_Sdup, UIMM5_11_S }, { 0 }},

/* beq_sCC_EQ s10 1111001sssssssss.  */
{ "beq_s", 0x0000F200, 0x0000FE00,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRANCH, COND, { SIMM10_A16_7_S }, { C_CC_EQ }},

/* bge_sCC_GE s7 1111011001ssssss.  */
{ "bge_s", 0x0000F640, 0x0000FFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRANCH, COND, { SIMM7_A16_10_S }, { C_CC_GE }},

/* bgt_sCC_GT s7 1111011000ssssss.  */
{ "bgt_s", 0x0000F600, 0x0000FFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRANCH, COND, { SIMM7_A16_10_S }, { C_CC_GT }},

/* bhi_sCC_HI s7 1111011100ssssss.  */
{ "bhi_s", 0x0000F700, 0x0000FFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRANCH, COND, { SIMM7_A16_10_S }, { C_CC_HI }},

/* bhs_sCC_HS s7 1111011101ssssss.  */
{ "bhs_s", 0x0000F740, 0x0000FFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRANCH, COND, { SIMM7_A16_10_S }, { C_CC_HS }},

/* bi c 00100RRR001001000RRRCCCCCCRRRRRR.  */
{ "bi", 0x20240000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BI, NONE, { BRAKET, RC, BRAKETdup }, { 0 }},

/* bi limm 00100RRR001001000RRR111110RRRRRR.  */
{ "bi", 0x20240F80, 0xF8FF8FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BI, NONE, { BRAKET, LIMM, BRAKETdup }, { 0 }},

/* bic<.f> a,b,c 00100bbb00000110FBBBCCCCCCAAAAAA.  */
{ "bic", 0x20060000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* bic<.f> 0,b,c 00100bbb00000110FBBBCCCCCC111110.  */
{ "bic", 0x2006003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* bic<.f><.cc> b,b,c 00100bbb11000110FBBBCCCCCC0QQQQQ.  */
{ "bic", 0x20C60000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* bic<.f> a,b,u6 00100bbb01000110FBBBuuuuuuAAAAAA.  */
{ "bic", 0x20460000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* bic<.f> 0,b,u6 00100bbb01000110FBBBuuuuuu111110.  */
{ "bic", 0x2046003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* bic<.f><.cc> b,b,u6 00100bbb11000110FBBBuuuuuu1QQQQQ.  */
{ "bic", 0x20C60020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* bic<.f> b,b,s12 00100bbb10000110FBBBssssssSSSSSS.  */
{ "bic", 0x20860000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* bic<.f> a,limm,c 0010011000000110F111CCCCCCAAAAAA.  */
{ "bic", 0x26067000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* bic<.f> a,b,limm 00100bbb00000110FBBB111110AAAAAA.  */
{ "bic", 0x20060F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* bic<.f> 0,limm,c 0010011000000110F111CCCCCC111110.  */
{ "bic", 0x2606703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* bic<.f> 0,b,limm 00100bbb00000110FBBB111110111110.  */
{ "bic", 0x20060FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* bic<.f><.cc> b,b,limm 00100bbb11000110FBBB1111100QQQQQ.  */
{ "bic", 0x20C60F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* bic<.f><.cc> 0,limm,c 0010011011000110F111CCCCCC0QQQQQ.  */
{ "bic", 0x26C67000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* bic<.f> a,limm,u6 0010011001000110F111uuuuuuAAAAAA.  */
{ "bic", 0x26467000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* bic<.f> 0,limm,u6 0010011001000110F111uuuuuu111110.  */
{ "bic", 0x2646703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* bic<.f><.cc> 0,limm,u6 0010011011000110F111uuuuuu1QQQQQ.  */
{ "bic", 0x26C67020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* bic<.f> 0,limm,s12 0010011010000110F111ssssssSSSSSS.  */
{ "bic", 0x26867000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* bic<.f> a,limm,limm 0010011000000110F111111110AAAAAA.  */
{ "bic", 0x26067F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* bic<.f> 0,limm,limm 0010011000000110F111111110111110.  */
{ "bic", 0x26067FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* bic<.f><.cc> 0,limm,limm 0010011011000110F1111111100QQQQQ.  */
{ "bic", 0x26C67F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* bicl<.f> RA,RB,RC 01011bbb00000110FBBBccccccaaaaaa.  */
{ "bicl", 0x58060000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* bicl<.f> 0,RB,RC 01011bbb00000110FBBBcccccc111110.  */
{ "bicl", 0x5806003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* bicl<.f><.cc> RB,RB,RC 01011bbb11000110FBBBcccccc0QQQQQ.  */
{ "bicl", 0x58C60000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* bicl<.f> RA,RB,u6 01011bbb01000110FBBBuuuuuuaaaaaa.  */
{ "bicl", 0x58460000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* bicl<.f> 0,RB,u6 01011bbb01000110FBBBuuuuuu111110.  */
{ "bicl", 0x5846003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* bicl<.f><.cc> RB,RB,u6 01011bbb11000110FBBBuuuuuu1QQQQQ.  */
{ "bicl", 0x58C60020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* bicl<.f> RB,RB,s12 01011bbb10000110FBBBssssssSSSSSS.  */
{ "bicl", 0x58860000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* bicl<.f> RA,ximm,RC 0101110000000110F111ccccccaaaaaa.  */
{ "bicl", 0x5C067000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* bicl<.f> RA,RB,ximm 01011bbb00000110FBBB111100aaaaaa.  */
{ "bicl", 0x58060F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* bicl<.f> 0,ximm,RC 0101110000000110F111cccccc111110.  */
{ "bicl", 0x5C06703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* bicl<.f> 0,RB,ximm 01011bbb00000110FBBB111100111110.  */
{ "bicl", 0x58060F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* bicl<.f><.cc> 0,ximm,RC 0101110011000110F111cccccc0QQQQQ.  */
{ "bicl", 0x5CC67000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* bicl<.f><.cc> RB,RB,ximm 01011bbb11000110FBBB1111000QQQQQ.  */
{ "bicl", 0x58C60F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* bicl<.f> RA,ximm,u6 0101110001000110F111uuuuuuaaaaaa.  */
{ "bicl", 0x5C467000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* bicl<.f> 0,ximm,u6 0101110001000110F111uuuuuu111110.  */
{ "bicl", 0x5C46703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* bicl<.f><.cc> 0,ximm,u6 0101110011000110F111uuuuuu1QQQQQ.  */
{ "bicl", 0x5CC67020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* bicl<.f> RA,limm,RC 0101111000000110F111ccccccaaaaaa.  */
{ "bicl", 0x5E067000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* bicl<.f> RA,RB,limm 01011bbb00000110FBBB111110aaaaaa.  */
{ "bicl", 0x58060F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* bicl<.f> 0,limm,RC 0101111000000110F111cccccc111110.  */
{ "bicl", 0x5E06703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* bicl<.f> 0,RB,limm 01011bbb00000110FBBB111110111110.  */
{ "bicl", 0x58060FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* bicl<.f><.cc> 0,limm,RC 0101111011000110F111cccccc0QQQQQ.  */
{ "bicl", 0x5EC67000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* bicl<.f><.cc> RB,RB,limm 01011bbb11000110FBBB1111100QQQQQ.  */
{ "bicl", 0x58C60F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* bicl<.f> RA,limm,u6 0101111001000110F111uuuuuuaaaaaa.  */
{ "bicl", 0x5E467000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* bicl<.f> 0,limm,u6 0101111001000110F111uuuuuu111110.  */
{ "bicl", 0x5E46703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* bicl<.f><.cc> 0,limm,u6 0101111011000110F111uuuuuu1QQQQQ.  */
{ "bicl", 0x5EC67020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* bicl<.f> 0,ximm,s12 0101110010000110F111ssssssSSSSSS.  */
{ "bicl", 0x5C867000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* bicl<.f> 0,limm,s12 0101111010000110F111ssssssSSSSSS.  */
{ "bicl", 0x5E867000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* bicl<.f> RA,ximm,ximm 0101110000000110F111111100aaaaaa.  */
{ "bicl", 0x5C067F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* bicl<.f> 0,ximm,ximm 0101110000000110F111111100111110.  */
{ "bicl", 0x5C067F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* bicl<.f><.cc> 0,ximm,ximm 0101110011000110F1111111000QQQQQ.  */
{ "bicl", 0x5CC67F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* bicl<.f> RA,limm,limm 0101111000000110F111111110aaaaaa.  */
{ "bicl", 0x5E067F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* bicl<.f> 0,limm,limm 0101111000000110F111111110111110.  */
{ "bicl", 0x5E067FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* bicl<.f><.cc> 0,limm,limm 0101111011000110F1111111100QQQQQ.  */
{ "bicl", 0x5EC67F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* bic_s b,b,c 01111bbbccc00110.  */
{ "bic_s", 0x00007806, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* bih c 00100RRR001001010RRRCCCCCCRRRRRR.  */
{ "bih", 0x20250000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BIH, NONE, { BRAKET, RC, BRAKETdup }, { 0 }},

/* bih limm 00100RRR001001010RRR111110RRRRRR.  */
{ "bih", 0x20250F80, 0xF8FF8FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BIH, NONE, { BRAKET, LIMM, BRAKETdup }, { 0 }},

/* bl<.d> s25 00001sssssssss10SSSSSSSSSSNRtttt.  */
{ "bl", 0x08020000, 0xF8030000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRANCH, NONE, { SIMM25_A32_5 }, { C_D }},

/* bl<.d><.cc> s21 00001sssssssss00SSSSSSSSSSNQQQQQ.  */
{ "bl", 0x08000000, 0xF8030000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRANCH, NONE, { SIMM21_A32_5 }, { C_CC, C_D }},

/* ble_sCC_LE s7 1111011011ssssss.  */
{ "ble_s", 0x0000F6C0, 0x0000FFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRANCH, COND, { SIMM7_A16_10_S }, { C_CC_LE }},

/* blo_sCC_LO s7 1111011110ssssss.  */
{ "blo_s", 0x0000F780, 0x0000FFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRANCH, COND, { SIMM7_A16_10_S }, { C_CC_LO }},

/* bls_sCC_LS s7 1111011111ssssss.  */
{ "bls_s", 0x0000F7C0, 0x0000FFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRANCH, COND, { SIMM7_A16_10_S }, { C_CC_LS }},

/* blt_sCC_LT s7 1111011010ssssss.  */
{ "blt_s", 0x0000F680, 0x0000FFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRANCH, COND, { SIMM7_A16_10_S }, { C_CC_LT }},

/* bl_s s13 11111sssssssssss.  */
{ "bl_s", 0x0000F800, 0x0000F800,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRANCH, NONE, { SIMM13_A32_5_S }, { 0 }},

/* bl_s LIMM 01111 011 111 00000.  */
{ "bl_s", 0x7BE0, 0xFFFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRANCH, NONE, { LIMM34 }, { 0 }},

/* bmsk<.f> a,b,c 00100bbb00010011FBBBCCCCCCAAAAAA.  */
{ "bmsk", 0x20130000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* bmsk<.f> 0,b,c 00100bbb00010011FBBBCCCCCC111110.  */
{ "bmsk", 0x2013003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* bmsk<.f><.cc> b,b,c 00100bbb11010011FBBBCCCCCC0QQQQQ.  */
{ "bmsk", 0x20D30000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* bmsk<.f> a,b,u6 00100bbb01010011FBBBuuuuuuAAAAAA.  */
{ "bmsk", 0x20530000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* bmsk<.f> 0,b,u6 00100bbb01010011FBBBuuuuuu111110.  */
{ "bmsk", 0x2053003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* bmsk<.f><.cc> b,b,u6 00100bbb11010011FBBBuuuuuu1QQQQQ.  */
{ "bmsk", 0x20D30020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* bmsk<.f> b,b,s12 00100bbb10010011FBBBssssssSSSSSS.  */
{ "bmsk", 0x20930000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* bmsk<.f> a,limm,c 0010011000010011F111CCCCCCAAAAAA.  */
{ "bmsk", 0x26137000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* bmsk<.f> a,b,limm 00100bbb00010011FBBB111110AAAAAA.  */
{ "bmsk", 0x20130F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* bmsk<.f> 0,limm,c 0010011000010011F111CCCCCC111110.  */
{ "bmsk", 0x2613703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* bmsk<.f> 0,b,limm 00100bbb00010011FBBB111110111110.  */
{ "bmsk", 0x20130FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* bmsk<.f><.cc> b,b,limm 00100bbb11010011FBBB1111100QQQQQ.  */
{ "bmsk", 0x20D30F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* bmsk<.f><.cc> 0,limm,c 0010011011010011F111CCCCCC0QQQQQ.  */
{ "bmsk", 0x26D37000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* bmsk<.f> a,limm,u6 0010011001010011F111uuuuuuAAAAAA.  */
{ "bmsk", 0x26537000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* bmsk<.f> 0,limm,u6 0010011001010011F111uuuuuu111110.  */
{ "bmsk", 0x2653703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* bmsk<.f><.cc> 0,limm,u6 0010011011010011F111uuuuuu1QQQQQ.  */
{ "bmsk", 0x26D37020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* bmsk<.f> 0,limm,s12 0010011010010011F111ssssssSSSSSS.  */
{ "bmsk", 0x26937000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* bmsk<.f> a,limm,limm 0010011000010011F111111110AAAAAA.  */
{ "bmsk", 0x26137F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* bmsk<.f> 0,limm,limm 0010011000010011F111111110111110.  */
{ "bmsk", 0x26137FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* bmsk<.f><.cc> 0,limm,limm 0010011011010011F1111111100QQQQQ.  */
{ "bmsk", 0x26D37F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* bmskl<.f> RA,RB,RC 01011bbb00010011FBBBccccccaaaaaa.  */
{ "bmskl", 0x58130000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* bmskl<.f> 0,RB,RC 01011bbb00010011FBBBcccccc111110.  */
{ "bmskl", 0x5813003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* bmskl<.f><.cc> RB,RB,RC 01011bbb11010011FBBBcccccc0QQQQQ.  */
{ "bmskl", 0x58D30000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* bmskl<.f> RA,RB,u6 01011bbb01010011FBBBuuuuuuaaaaaa.  */
{ "bmskl", 0x58530000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* bmskl<.f> 0,RB,u6 01011bbb01010011FBBBuuuuuu111110.  */
{ "bmskl", 0x5853003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* bmskl<.f><.cc> RB,RB,u6 01011bbb11010011FBBBuuuuuu1QQQQQ.  */
{ "bmskl", 0x58D30020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* bmskl<.f> RB,RB,s12 01011bbb10010011FBBBssssssSSSSSS.  */
{ "bmskl", 0x58930000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* bmskl<.f> RA,ximm,RC 0101110000010011F111ccccccaaaaaa.  */
{ "bmskl", 0x5C137000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* bmskl<.f> RA,RB,ximm 01011bbb00010011FBBB111100aaaaaa.  */
{ "bmskl", 0x58130F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* bmskl<.f> 0,ximm,RC 0101110000010011F111cccccc111110.  */
{ "bmskl", 0x5C13703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* bmskl<.f> 0,RB,ximm 01011bbb00010011FBBB111100111110.  */
{ "bmskl", 0x58130F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* bmskl<.f><.cc> 0,ximm,RC 0101110011010011F111cccccc0QQQQQ.  */
{ "bmskl", 0x5CD37000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* bmskl<.f><.cc> RB,RB,ximm 01011bbb11010011FBBB1111000QQQQQ.  */
{ "bmskl", 0x58D30F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* bmskl<.f> RA,ximm,u6 0101110001010011F111uuuuuuaaaaaa.  */
{ "bmskl", 0x5C537000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* bmskl<.f> 0,ximm,u6 0101110001010011F111uuuuuu111110.  */
{ "bmskl", 0x5C53703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* bmskl<.f><.cc> 0,ximm,u6 0101110011010011F111uuuuuu1QQQQQ.  */
{ "bmskl", 0x5CD37020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* bmskl<.f> RA,limm,RC 0101111000010011F111ccccccaaaaaa.  */
{ "bmskl", 0x5E137000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* bmskl<.f> RA,RB,limm 01011bbb00010011FBBB111110aaaaaa.  */
{ "bmskl", 0x58130F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* bmskl<.f> 0,limm,RC 0101111000010011F111cccccc111110.  */
{ "bmskl", 0x5E13703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* bmskl<.f> 0,RB,limm 01011bbb00010011FBBB111110111110.  */
{ "bmskl", 0x58130FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* bmskl<.f><.cc> 0,limm,RC 0101111011010011F111cccccc0QQQQQ.  */
{ "bmskl", 0x5ED37000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* bmskl<.f><.cc> RB,RB,limm 01011bbb11010011FBBB1111100QQQQQ.  */
{ "bmskl", 0x58D30F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* bmskl<.f> RA,limm,u6 0101111001010011F111uuuuuuaaaaaa.  */
{ "bmskl", 0x5E537000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* bmskl<.f> 0,limm,u6 0101111001010011F111uuuuuu111110.  */
{ "bmskl", 0x5E53703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* bmskl<.f><.cc> 0,limm,u6 0101111011010011F111uuuuuu1QQQQQ.  */
{ "bmskl", 0x5ED37020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* bmskl<.f> 0,ximm,s12 0101110010010011F111ssssssSSSSSS.  */
{ "bmskl", 0x5C937000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* bmskl<.f> 0,limm,s12 0101111010010011F111ssssssSSSSSS.  */
{ "bmskl", 0x5E937000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* bmskl<.f> RA,ximm,ximm 0101110000010011F111111100aaaaaa.  */
{ "bmskl", 0x5C137F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* bmskl<.f> 0,ximm,ximm 0101110000010011F111111100111110.  */
{ "bmskl", 0x5C137F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* bmskl<.f><.cc> 0,ximm,ximm 0101110011010011F1111111000QQQQQ.  */
{ "bmskl", 0x5CD37F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* bmskl<.f> RA,limm,limm 0101111000010011F111111110aaaaaa.  */
{ "bmskl", 0x5E137F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* bmskl<.f> 0,limm,limm 0101111000010011F111111110111110.  */
{ "bmskl", 0x5E137FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* bmskl<.f><.cc> 0,limm,limm 0101111011010011F1111111100QQQQQ.  */
{ "bmskl", 0x5ED37F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* bmskn<.f> a,b,c 00100bbb00101100FBBBCCCCCCAAAAAA.  */
{ "bmskn", 0x202C0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* bmskn<.f> 0,b,c 00100bbb00101100FBBBCCCCCC111110.  */
{ "bmskn", 0x202C003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* bmskn<.f><.cc> b,b,c 00100bbb11101100FBBBCCCCCC0QQQQQ.  */
{ "bmskn", 0x20EC0000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* bmskn<.f> a,b,u6 00100bbb01101100FBBBuuuuuuAAAAAA.  */
{ "bmskn", 0x206C0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* bmskn<.f> 0,b,u6 00100bbb01101100FBBBuuuuuu111110.  */
{ "bmskn", 0x206C003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* bmskn<.f><.cc> b,b,u6 00100bbb11101100FBBBuuuuuu1QQQQQ.  */
{ "bmskn", 0x20EC0020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* bmskn<.f> b,b,s12 00100bbb10101100FBBBssssssSSSSSS.  */
{ "bmskn", 0x20AC0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* bmskn<.f> a,limm,c 0010011000101100F111CCCCCCAAAAAA.  */
{ "bmskn", 0x262C7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* bmskn<.f> a,b,limm 00100bbb00101100FBBB111110AAAAAA.  */
{ "bmskn", 0x202C0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* bmskn<.f> 0,limm,c 0010011000101100F111CCCCCC111110.  */
{ "bmskn", 0x262C703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* bmskn<.f> 0,b,limm 00100bbb00101100FBBB111110111110.  */
{ "bmskn", 0x202C0FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* bmskn<.f><.cc> b,b,limm 00100bbb11101100FBBB1111100QQQQQ.  */
{ "bmskn", 0x20EC0F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* bmskn<.f><.cc> 0,limm,c 0010011011101100F111CCCCCC0QQQQQ.  */
{ "bmskn", 0x26EC7000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* bmskn<.f> a,limm,u6 0010011001101100F111uuuuuuAAAAAA.  */
{ "bmskn", 0x266C7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* bmskn<.f> 0,limm,u6 0010011001101100F111uuuuuu111110.  */
{ "bmskn", 0x266C703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* bmskn<.f><.cc> 0,limm,u6 0010011011101100F111uuuuuu1QQQQQ.  */
{ "bmskn", 0x26EC7020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* bmskn<.f> 0,limm,s12 0010011010101100F111ssssssSSSSSS.  */
{ "bmskn", 0x26AC7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* bmskn<.f> a,limm,limm 0010011000101100F111111110AAAAAA.  */
{ "bmskn", 0x262C7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* bmskn<.f> 0,limm,limm 0010011000101100F111111110111110.  */
{ "bmskn", 0x262C7FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* bmskn<.f><.cc> 0,limm,limm 0010011011101100F1111111100QQQQQ.  */
{ "bmskn", 0x26EC7F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* bmsknl<.f> RA,RB,RC 01011bbb00101100FBBBccccccaaaaaa.  */
{ "bmsknl", 0x582C0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* bmsknl<.f> 0,RB,RC 01011bbb00101100FBBBcccccc111110.  */
{ "bmsknl", 0x582C003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* bmsknl<.f><.cc> RB,RB,RC 01011bbb11101100FBBBcccccc0QQQQQ.  */
{ "bmsknl", 0x58EC0000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* bmsknl<.f> RA,RB,u6 01011bbb01101100FBBBuuuuuuaaaaaa.  */
{ "bmsknl", 0x586C0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* bmsknl<.f> 0,RB,u6 01011bbb01101100FBBBuuuuuu111110.  */
{ "bmsknl", 0x586C003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* bmsknl<.f><.cc> RB,RB,u6 01011bbb11101100FBBBuuuuuu1QQQQQ.  */
{ "bmsknl", 0x58EC0020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* bmsknl<.f> RB,RB,s12 01011bbb10101100FBBBssssssSSSSSS.  */
{ "bmsknl", 0x58AC0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* bmsknl<.f> RA,ximm,RC 0101110000101100F111ccccccaaaaaa.  */
{ "bmsknl", 0x5C2C7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* bmsknl<.f> RA,RB,ximm 01011bbb00101100FBBB111100aaaaaa.  */
{ "bmsknl", 0x582C0F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* bmsknl<.f> 0,ximm,RC 0101110000101100F111cccccc111110.  */
{ "bmsknl", 0x5C2C703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* bmsknl<.f> 0,RB,ximm 01011bbb00101100FBBB111100111110.  */
{ "bmsknl", 0x582C0F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* bmsknl<.f><.cc> 0,ximm,RC 0101110011101100F111cccccc0QQQQQ.  */
{ "bmsknl", 0x5CEC7000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* bmsknl<.f><.cc> RB,RB,ximm 01011bbb11101100FBBB1111000QQQQQ.  */
{ "bmsknl", 0x58EC0F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* bmsknl<.f> RA,ximm,u6 0101110001101100F111uuuuuuaaaaaa.  */
{ "bmsknl", 0x5C6C7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* bmsknl<.f> 0,ximm,u6 0101110001101100F111uuuuuu111110.  */
{ "bmsknl", 0x5C6C703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* bmsknl<.f><.cc> 0,ximm,u6 0101110011101100F111uuuuuu1QQQQQ.  */
{ "bmsknl", 0x5CEC7020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* bmsknl<.f> RA,limm,RC 0101111000101100F111ccccccaaaaaa.  */
{ "bmsknl", 0x5E2C7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* bmsknl<.f> RA,RB,limm 01011bbb00101100FBBB111110aaaaaa.  */
{ "bmsknl", 0x582C0F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* bmsknl<.f> 0,limm,RC 0101111000101100F111cccccc111110.  */
{ "bmsknl", 0x5E2C703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* bmsknl<.f> 0,RB,limm 01011bbb00101100FBBB111110111110.  */
{ "bmsknl", 0x582C0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* bmsknl<.f><.cc> 0,limm,RC 0101111011101100F111cccccc0QQQQQ.  */
{ "bmsknl", 0x5EEC7000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* bmsknl<.f><.cc> RB,RB,limm 01011bbb11101100FBBB1111100QQQQQ.  */
{ "bmsknl", 0x58EC0F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* bmsknl<.f> RA,limm,u6 0101111001101100F111uuuuuuaaaaaa.  */
{ "bmsknl", 0x5E6C7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* bmsknl<.f> 0,limm,u6 0101111001101100F111uuuuuu111110.  */
{ "bmsknl", 0x5E6C703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* bmsknl<.f><.cc> 0,limm,u6 0101111011101100F111uuuuuu1QQQQQ.  */
{ "bmsknl", 0x5EEC7020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* bmsknl<.f> 0,ximm,s12 0101110010101100F111ssssssSSSSSS.  */
{ "bmsknl", 0x5CAC7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* bmsknl<.f> 0,limm,s12 0101111010101100F111ssssssSSSSSS.  */
{ "bmsknl", 0x5EAC7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* bmsknl<.f> RA,ximm,ximm 0101110000101100F111111100aaaaaa.  */
{ "bmsknl", 0x5C2C7F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* bmsknl<.f> 0,ximm,ximm 0101110000101100F111111100111110.  */
{ "bmsknl", 0x5C2C7F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* bmsknl<.f><.cc> 0,ximm,ximm 0101110011101100F1111111000QQQQQ.  */
{ "bmsknl", 0x5CEC7F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* bmsknl<.f> RA,limm,limm 0101111000101100F111111110aaaaaa.  */
{ "bmsknl", 0x5E2C7F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* bmsknl<.f> 0,limm,limm 0101111000101100F111111110111110.  */
{ "bmsknl", 0x5E2C7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* bmsknl<.f><.cc> 0,limm,limm 0101111011101100F1111111100QQQQQ.  */
{ "bmsknl", 0x5EEC7F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* bmsk_s b,b,u5 10111bbb110uuuuu.  */
{ "bmsk_s", 0x0000B8C0, 0x0000F8E0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB_S, RB_Sdup, UIMM5_11_S }, { 0 }},

/* bne_sCC_NE s10 1111010sssssssss.  */
{ "bne_s", 0x0000F400, 0x0000FE00,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRANCH, COND, { SIMM10_A16_7_S }, { C_CC_NE }},

/* breq<.d>CC_EQ b,c,s9 00001bbbsssssss1SBBBCCCCCCN00000.  */
{ "breq", 0x08010000, 0xF801001F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { RB, RC, SIMM9_A16_8 }, { C_D, C_CC_EQ }},

/* breq<.d>CC_EQ b,u6,s9 00001bbbsssssss1SBBBuuuuuuN10000.  */
{ "breq", 0x08010010, 0xF801001F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D, C_CC_EQ }},

/* breqCC_EQ b,limm,s9 00001bbbsssssss1SBBB111110000000.  */
{ "breq", 0x08010F80, 0xF8010FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { RB, LIMM, SIMM9_A16_8 }, { C_CC_EQ }},

/* breqCC_EQ limm,c,s9 00001110sssssss1S111CCCCCC000000.  */
{ "breq", 0x0E017000, 0xFF01703F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { LIMM, RC, SIMM9_A16_8 }, { C_CC_EQ }},

/* breqCC_EQ limm,u6,s9 00001110sssssss1S111uuuuuu010000.  */
{ "breq", 0x0E017010, 0xFF01703F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { LIMM, UIMM6_8, SIMM9_A16_8 }, { C_CC_EQ }},

/* breqCC_EQ limm,limm,s9 00001110sssssss1S111111110000000.  */
{ "breq", 0x0E017F80, 0xFF017FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { LIMM, LIMMdup, SIMM9_A16_8 }, { C_CC_EQ }},

/* breql<.d> b,c,s9 00001bbbsssssss1SBBBCCCCCCN01000.  */
{ "breql", 0x08010008, 0xF801001F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC, SIMM9_A16_8 }, { C_D }},

/* breql<.d> b,u6,s9 00001bbbsssssss1SBBBuuuuuuN11000.  */
{ "breql", 0x08010018, 0xF801001F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D }},

/* breql b,ximm,s9 00001bbbsssssss1SBBB111100001000.  */
{ "breql", 0x08010F08, 0xF8010FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM, SIMM9_A16_8 }, { 0 }},

/* breql ximm,c,s9 00001100sssssss1S111CCCCCC001000.  */
{ "breql", 0x0C017008, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { XIMM, RC, SIMM9_A16_8 }, { 0 }},

/* breql ximm,u6,s9 00001100sssssss1S111uuuuuu011000.  */
{ "breql", 0x0C017018, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { XIMM, UIMM6_8, SIMM9_A16_8 }, { 0 }},

/* breql b,limm,s9 00001bbbsssssss1SBBB111110001000.  */
{ "breql", 0x08010F88, 0xF8010FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM, SIMM9_A16_8 }, { 0 }},

/* breql limm,c,s9 00001110sssssss1S111CCCCCC001000.  */
{ "breql", 0x0E017008, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, RC, SIMM9_A16_8 }, { 0 }},

/* breql limm,u6,s9 00001110sssssss1S111uuuuuu011000.  */
{ "breql", 0x0E017018, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, UIMM6_8, SIMM9_A16_8 }, { 0 }},

/* breql_s b,0,s8 11101bbb0sssssss.  */
{ "breql_s", 0x0000E800, 0x0000F880, ARC_OPCODE_ARC64, ARITH, NONE, { RB_S, ZB_S, SIMM8_A16_9_S }, { 0 }},

/* breq_s b,0,s8 11101bbb0sssssss.  */
{ "breq_s", 0x0000E800, 0x0000F880, ARC_OPCODE_ARC32, ARITH, NONE, { RB_S, ZB_S, SIMM8_A16_9_S }, { 0 }},

/* brge<.d>CC_GE b,c,s9 00001bbbsssssss1SBBBCCCCCCN00011.  */
{ "brge", 0x08010003, 0xF801001F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { RB, RC, SIMM9_A16_8 }, { C_D, C_CC_GE }},

/* brge<.d>CC_GE b,u6,s9 00001bbbsssssss1SBBBuuuuuuN10011.  */
{ "brge", 0x08010013, 0xF801001F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D, C_CC_GE }},

/* brgeCC_GE b,limm,s9 00001bbbsssssss1SBBB111110000011.  */
{ "brge", 0x08010F83, 0xF8010FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { RB, LIMM, SIMM9_A16_8 }, { C_CC_GE }},

/* brgeCC_GE limm,c,s9 00001110sssssss1S111CCCCCC000011.  */
{ "brge", 0x0E017003, 0xFF01703F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { LIMM, RC, SIMM9_A16_8 }, { C_CC_GE }},

/* brgeCC_GE limm,u6,s9 00001110sssssss1S111uuuuuu010011.  */
{ "brge", 0x0E017013, 0xFF01703F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { LIMM, UIMM6_8, SIMM9_A16_8 }, { C_CC_GE }},

/* brgeCC_GE limm,limm,s9 00001110sssssss1S111111110000011.  */
{ "brge", 0x0E017F83, 0xFF017FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { LIMM, LIMMdup, SIMM9_A16_8 }, { C_CC_GE }},

/* brgel<.d> b,c,s9 00001bbbsssssss1SBBBCCCCCCN01011.  */
{ "brgel", 0x0801000B, 0xF801001F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC, SIMM9_A16_8 }, { C_D }},

/* brgel<.d> b,u6,s9 00001bbbsssssss1SBBBuuuuuuN11011.  */
{ "brgel", 0x0801001B, 0xF801001F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D }},

/* brgel b,ximm,s9 00001bbbsssssss1SBBB111100001011.  */
{ "brgel", 0x08010F0B, 0xF8010FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM, SIMM9_A16_8 }, { 0 }},

/* brgel ximm,c,s9 00001100sssssss1S111CCCCCC001011.  */
{ "brgel", 0x0C01700B, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { XIMM, RC, SIMM9_A16_8 }, { 0 }},

/* brgel ximm,u6,s9 00001100sssssss1S111uuuuuu011011.  */
{ "brgel", 0x0C01701B, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { XIMM, UIMM6_8, SIMM9_A16_8 }, { 0 }},

/* brgel b,limm,s9 00001bbbsssssss1SBBB111110001011.  */
{ "brgel", 0x08010F8B, 0xF8010FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM, SIMM9_A16_8 }, { 0 }},

/* brgel limm,c,s9 00001110sssssss1S111CCCCCC001011.  */
{ "brgel", 0x0E01700B, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, RC, SIMM9_A16_8 }, { 0 }},

/* brgel limm,u6,s9 00001110sssssss1S111uuuuuu011011.  */
{ "brgel", 0x0E01701B, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, UIMM6_8, SIMM9_A16_8 }, { 0 }},

/* brhs<.d>CC_HS b,c,s9 00001bbbsssssss1SBBBCCCCCCN00101.  */
{ "brhs", 0x08010005, 0xF801001F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { RB, RC, SIMM9_A16_8 }, { C_D, C_CC_HS }},

/* brhs<.d>CC_HS b,u6,s9 00001bbbsssssss1SBBBuuuuuuN10101.  */
{ "brhs", 0x08010015, 0xF801001F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D, C_CC_HS }},

/* brhsCC_HS b,limm,s9 00001bbbsssssss1SBBB111110000101.  */
{ "brhs", 0x08010F85, 0xF8010FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { RB, LIMM, SIMM9_A16_8 }, { C_CC_HS }},

/* brhsCC_HS limm,c,s9 00001110sssssss1S111CCCCCC000101.  */
{ "brhs", 0x0E017005, 0xFF01703F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { LIMM, RC, SIMM9_A16_8 }, { C_CC_HS }},

/* brhsCC_HS limm,u6,s9 00001110sssssss1S111uuuuuu010101.  */
{ "brhs", 0x0E017015, 0xFF01703F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { LIMM, UIMM6_8, SIMM9_A16_8 }, { C_CC_HS }},

/* brhsCC_HS limm,limm,s9 00001110sssssss1S111111110000101.  */
{ "brhs", 0x0E017F85, 0xFF017FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { LIMM, LIMMdup, SIMM9_A16_8 }, { C_CC_HS }},

/* brhsl<.d> b,c,s9 00001bbbsssssss1SBBBCCCCCCN01101.  */
{ "brhsl", 0x0801000D, 0xF801001F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC, SIMM9_A16_8 }, { C_D }},

/* brhsl<.d> b,u6,s9 00001bbbsssssss1SBBBuuuuuuN11101.  */
{ "brhsl", 0x0801001D, 0xF801001F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D }},

/* brhsl b,ximm,s9 00001bbbsssssss1SBBB111100001101.  */
{ "brhsl", 0x08010F0D, 0xF8010FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM, SIMM9_A16_8 }, { 0 }},

/* brhsl ximm,c,s9 00001100sssssss1S111CCCCCC001101.  */
{ "brhsl", 0x0C01700D, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { XIMM, RC, SIMM9_A16_8 }, { 0 }},

/* brhsl ximm,u6,s9 00001100sssssss1S111uuuuuu011101.  */
{ "brhsl", 0x0C01701D, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { XIMM, UIMM6_8, SIMM9_A16_8 }, { 0 }},

/* brhsl b,limm,s9 00001bbbsssssss1SBBB111110001101.  */
{ "brhsl", 0x08010F8D, 0xF8010FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM, SIMM9_A16_8 }, { 0 }},

/* brhsl limm,c,s9 00001110sssssss1S111CCCCCC001101.  */
{ "brhsl", 0x0E01700D, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, RC, SIMM9_A16_8 }, { 0 }},

/* brhsl limm,u6,s9 00001110sssssss1S111uuuuuu011101.  */
{ "brhsl", 0x0E01701D, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, UIMM6_8, SIMM9_A16_8 }, { 0 }},

/* brk  00100101011011110000000000111111.  */
{ "brk", 0x256F003F, 0xFFFFFFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, KERNEL, NONE, { 0 }, { 0 }},

/* brk_s  0111111111111111.  */
{ "brk_s", 0x00007FFF, 0x0000FFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, KERNEL, NONE, { 0 }, { 0 }},

/* brlo<.d>CC_LO b,c,s9 00001bbbsssssss1SBBBCCCCCCN00100.  */
{ "brlo", 0x08010004, 0xF801001F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { RB, RC, SIMM9_A16_8 }, { C_D, C_CC_LO }},

/* brlo<.d>CC_LO b,u6,s9 00001bbbsssssss1SBBBuuuuuuN10100.  */
{ "brlo", 0x08010014, 0xF801001F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D, C_CC_LO }},

/* brloCC_LO b,limm,s9 00001bbbsssssss1SBBB111110000100.  */
{ "brlo", 0x08010F84, 0xF8010FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { RB, LIMM, SIMM9_A16_8 }, { C_CC_LO }},

/* brloCC_LO limm,c,s9 00001110sssssss1S111CCCCCC000100.  */
{ "brlo", 0x0E017004, 0xFF01703F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { LIMM, RC, SIMM9_A16_8 }, { C_CC_LO }},

/* brloCC_LO limm,u6,s9 00001110sssssss1S111uuuuuu010100.  */
{ "brlo", 0x0E017014, 0xFF01703F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { LIMM, UIMM6_8, SIMM9_A16_8 }, { C_CC_LO }},

/* brloCC_LO limm,limm,s9 00001110sssssss1S111111110000100.  */
{ "brlo", 0x0E017F84, 0xFF017FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { LIMM, LIMMdup, SIMM9_A16_8 }, { C_CC_LO }},

/* brlol<.d> b,c,s9 00001bbbsssssss1SBBBCCCCCCN01100.  */
{ "brlol", 0x0801000C, 0xF801001F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC, SIMM9_A16_8 }, { C_D }},

/* brlol<.d> b,u6,s9 00001bbbsssssss1SBBBuuuuuuN11100.  */
{ "brlol", 0x0801001C, 0xF801001F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D }},

/* brlol b,ximm,s9 00001bbbsssssss1SBBB111100001100.  */
{ "brlol", 0x08010F0C, 0xF8010FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM, SIMM9_A16_8 }, { 0 }},

/* brlol ximm,c,s9 00001100sssssss1S111CCCCCC001100.  */
{ "brlol", 0x0C01700C, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { XIMM, RC, SIMM9_A16_8 }, { 0 }},

/* brlol ximm,u6,s9 00001100sssssss1S111uuuuuu011100.  */
{ "brlol", 0x0C01701C, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { XIMM, UIMM6_8, SIMM9_A16_8 }, { 0 }},

/* brlol b,limm,s9 00001bbbsssssss1SBBB111110001100.  */
{ "brlol", 0x08010F8C, 0xF8010FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM, SIMM9_A16_8 }, { 0 }},

/* brlol limm,c,s9 00001110sssssss1S111CCCCCC001100.  */
{ "brlol", 0x0E01700C, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, RC, SIMM9_A16_8 }, { 0 }},

/* brlol limm,u6,s9 00001110sssssss1S111uuuuuu011100.  */
{ "brlol", 0x0E01701C, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, UIMM6_8, SIMM9_A16_8 }, { 0 }},

/* brlt<.d>CC_LT b,c,s9 00001bbbsssssss1SBBBCCCCCCN00010.  */
{ "brlt", 0x08010002, 0xF801001F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { RB, RC, SIMM9_A16_8 }, { C_D, C_CC_LT }},

/* brlt<.d>CC_LT b,u6,s9 00001bbbsssssss1SBBBuuuuuuN10010.  */
{ "brlt", 0x08010012, 0xF801001F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D, C_CC_LT }},

/* brltCC_LT b,limm,s9 00001bbbsssssss1SBBB111110000010.  */
{ "brlt", 0x08010F82, 0xF8010FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { RB, LIMM, SIMM9_A16_8 }, { C_CC_LT }},

/* brltCC_LT limm,c,s9 00001110sssssss1S111CCCCCC000010.  */
{ "brlt", 0x0E017002, 0xFF01703F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { LIMM, RC, SIMM9_A16_8 }, { C_CC_LT }},

/* brltCC_LT limm,u6,s9 00001110sssssss1S111uuuuuu010010.  */
{ "brlt", 0x0E017012, 0xFF01703F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { LIMM, UIMM6_8, SIMM9_A16_8 }, { C_CC_LT }},

/* brltCC_LT limm,limm,s9 00001110sssssss1S111111110000010.  */
{ "brlt", 0x0E017F82, 0xFF017FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { LIMM, LIMMdup, SIMM9_A16_8 }, { C_CC_LT }},

/* brltl<.d> b,c,s9 00001bbbsssssss1SBBBCCCCCCN01010.  */
{ "brltl", 0x0801000A, 0xF801001F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC, SIMM9_A16_8 }, { C_D }},

/* brltl<.d> b,u6,s9 00001bbbsssssss1SBBBuuuuuuN11010.  */
{ "brltl", 0x0801001A, 0xF801001F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D }},

/* brltl b,ximm,s9 00001bbbsssssss1SBBB111100001010.  */
{ "brltl", 0x08010F0A, 0xF8010FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM, SIMM9_A16_8 }, { 0 }},

/* brltl ximm,c,s9 00001100sssssss1S111CCCCCC001010.  */
{ "brltl", 0x0C01700A, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { XIMM, RC, SIMM9_A16_8 }, { 0 }},

/* brltl ximm,u6,s9 00001100sssssss1S111uuuuuu011010.  */
{ "brltl", 0x0C01701A, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { XIMM, UIMM6_8, SIMM9_A16_8 }, { 0 }},

/* brltl b,limm,s9 00001bbbsssssss1SBBB111110001010.  */
{ "brltl", 0x08010F8A, 0xF8010FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM, SIMM9_A16_8 }, { 0 }},

/* brltl limm,c,s9 00001110sssssss1S111CCCCCC001010.  */
{ "brltl", 0x0E01700A, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, RC, SIMM9_A16_8 }, { 0 }},

/* brltl limm,u6,s9 00001110sssssss1S111uuuuuu011010.  */
{ "brltl", 0x0E01701A, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, UIMM6_8, SIMM9_A16_8 }, { 0 }},

/* brne<.d>CC_NE b,c,s9 00001bbbsssssss1SBBBCCCCCCN00001.  */
{ "brne", 0x08010001, 0xF801001F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { RB, RC, SIMM9_A16_8 }, { C_D, C_CC_NE }},

/* brne<.d>CC_NE b,u6,s9 00001bbbsssssss1SBBBuuuuuuN10001.  */
{ "brne", 0x08010011, 0xF801001F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D, C_CC_NE }},

/* brneCC_NE b,limm,s9 00001bbbsssssss1SBBB111110000001.  */
{ "brne", 0x08010F81, 0xF8010FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { RB, LIMM, SIMM9_A16_8 }, { C_CC_NE }},

/* brneCC_NE limm,c,s9 00001110sssssss1S111CCCCCC000001.  */
{ "brne", 0x0E017001, 0xFF01703F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { LIMM, RC, SIMM9_A16_8 }, { C_CC_NE }},

/* brneCC_NE limm,u6,s9 00001110sssssss1S111uuuuuu010001.  */
{ "brne", 0x0E017011, 0xFF01703F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { LIMM, UIMM6_8, SIMM9_A16_8 }, { C_CC_NE }},

/* brneCC_NE limm,limm,s9 00001110sssssss1S111111110000001.  */
{ "brne", 0x0E017F81, 0xFF017FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRCC, NONE, { LIMM, LIMMdup, SIMM9_A16_8 }, { C_CC_NE }},

/* brnel<.d> b,c,s9 00001bbbsssssss1SBBBCCCCCCN01001.  */
{ "brnel", 0x08010009, 0xF801001F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC, SIMM9_A16_8 }, { C_D }},

/* brnel<.d> b,u6,s9 00001bbbsssssss1SBBBUUUUUUN11001.  */
{ "brnel", 0x08010019, 0xF801001F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_8, SIMM9_A16_8 }, { C_D }},

/* brnel b,ximm,s9 00001bbbsssssss1SBBB111100001001.  */
{ "brnel", 0x08010F09, 0xF8010FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM, SIMM9_A16_8 }, { 0 }},

/* brnel ximm,c,s9 00001100sssssss1S111CCCCCC001001.  */
{ "brnel", 0x0C017009, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { XIMM, RC, SIMM9_A16_8 }, { 0 }},

/* brnel ximm,u6,s9 00001100sssssss1S111uuuuuu011001.  */
{ "brnel", 0x0C017019, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { XIMM, UIMM6_8, SIMM9_A16_8 }, { 0 }},

/* brnel b,limm,s9 00001bbbsssssss1SBBB111110001001.  */
{ "brnel", 0x08010F89, 0xF8010FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM, SIMM9_A16_8 }, { 0 }},

/* brnel limm,c,s9 00001110sssssss1S111CCCCCC001001.  */
{ "brnel", 0x0E017009, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, RC, SIMM9_A16_8 }, { 0 }},

/* brnel limm,u6,s9 00001110sssssss1S111uuuuuu011001.  */
{ "brnel", 0x0E017019, 0xFF01703F, ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, UIMM6_8, SIMM9_A16_8 }, { 0 }},

/* brnel_s b,0,s8 11101bbb1sssssss.  */
{ "brnel_s", 0x0000E880, 0x0000F880, ARC_OPCODE_ARC64, ARITH, NONE, { RB_S, ZB_S, SIMM8_A16_9_S }, { 0 }},

/* brne_s b,0,s8 11101bbb1sssssss.  */
{ "brne_s", 0x0000E880, 0x0000F880, ARC_OPCODE_ARC32, ARITH, NONE, { RB_S, ZB_S, SIMM8_A16_9_S }, { 0 }},

/* bset<.f> a,b,c 00100bbb00001111FBBBCCCCCCAAAAAA.  */
{ "bset", 0x200F0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* bset<.f> 0,b,c 00100bbb00001111FBBBCCCCCC111110.  */
{ "bset", 0x200F003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* bset<.f><.cc> b,b,c 00100bbb11001111FBBBCCCCCC0QQQQQ.  */
{ "bset", 0x20CF0000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* bset<.f> a,b,u6 00100bbb01001111FBBBuuuuuuAAAAAA.  */
{ "bset", 0x204F0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* bset<.f> 0,b,u6 00100bbb01001111FBBBuuuuuu111110.  */
{ "bset", 0x204F003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* bset<.f><.cc> b,b,u6 00100bbb11001111FBBBuuuuuu1QQQQQ.  */
{ "bset", 0x20CF0020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* bset<.f> b,b,s12 00100bbb10001111FBBBssssssSSSSSS.  */
{ "bset", 0x208F0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* bset<.f> a,limm,c 0010011000001111F111CCCCCCAAAAAA.  */
{ "bset", 0x260F7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* bset<.f> a,b,limm 00100bbb00001111FBBB111110AAAAAA.  */
{ "bset", 0x200F0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* bset<.f> 0,limm,c 0010011000001111F111CCCCCC111110.  */
{ "bset", 0x260F703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* bset<.f> 0,b,limm 00100bbb00001111FBBB111110111110.  */
{ "bset", 0x200F0FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* bset<.f><.cc> b,b,limm 00100bbb11001111FBBB1111100QQQQQ.  */
{ "bset", 0x20CF0F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* bset<.f><.cc> 0,limm,c 0010011011001111F111CCCCCC0QQQQQ.  */
{ "bset", 0x26CF7000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* bset<.f> a,limm,u6 0010011001001111F111uuuuuuAAAAAA.  */
{ "bset", 0x264F7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* bset<.f> 0,limm,u6 0010011001001111F111uuuuuu111110.  */
{ "bset", 0x264F703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* bset<.f><.cc> 0,limm,u6 0010011011001111F111uuuuuu1QQQQQ.  */
{ "bset", 0x26CF7020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* bset<.f> 0,limm,s12 0010011010001111F111ssssssSSSSSS.  */
{ "bset", 0x268F7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* bset<.f> a,limm,limm 0010011000001111F111111110AAAAAA.  */
{ "bset", 0x260F7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* bset<.f> 0,limm,limm 0010011000001111F111111110111110.  */
{ "bset", 0x260F7FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* bset<.f><.cc> 0,limm,limm 0010011011001111F1111111100QQQQQ.  */
{ "bset", 0x26CF7F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* bsetl<.f> RA,RB,RC 01011bbb00001111FBBBccccccaaaaaa.  */
{ "bsetl", 0x580F0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* bsetl<.f> 0,RB,RC 01011bbb00001111FBBBcccccc111110.  */
{ "bsetl", 0x580F003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* bsetl<.f><.cc> RB,RB,RC 01011bbb11001111FBBBcccccc0QQQQQ.  */
{ "bsetl", 0x58CF0000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* bsetl<.f> RA,RB,u6 01011bbb01001111FBBBuuuuuuaaaaaa.  */
{ "bsetl", 0x584F0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* bsetl<.f> 0,RB,u6 01011bbb01001111FBBBuuuuuu111110.  */
{ "bsetl", 0x584F003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* bsetl<.f><.cc> RB,RB,u6 01011bbb11001111FBBBuuuuuu1QQQQQ.  */
{ "bsetl", 0x58CF0020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* bsetl<.f> RB,RB,s12 01011bbb10001111FBBBssssssSSSSSS.  */
{ "bsetl", 0x588F0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* bsetl<.f> RA,ximm,RC 0101110000001111F111ccccccaaaaaa.  */
{ "bsetl", 0x5C0F7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* bsetl<.f> RA,RB,ximm 01011bbb00001111FBBB111100aaaaaa.  */
{ "bsetl", 0x580F0F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* bsetl<.f> 0,ximm,RC 0101110000001111F111cccccc111110.  */
{ "bsetl", 0x5C0F703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* bsetl<.f> 0,RB,ximm 01011bbb00001111FBBB111100111110.  */
{ "bsetl", 0x580F0F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* bsetl<.f><.cc> 0,ximm,RC 0101110011001111F111cccccc0QQQQQ.  */
{ "bsetl", 0x5CCF7000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* bsetl<.f><.cc> RB,RB,ximm 01011bbb11001111FBBB1111000QQQQQ.  */
{ "bsetl", 0x58CF0F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* bsetl<.f> RA,ximm,u6 0101110001001111F111uuuuuuaaaaaa.  */
{ "bsetl", 0x5C4F7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* bsetl<.f> 0,ximm,u6 0101110001001111F111uuuuuu111110.  */
{ "bsetl", 0x5C4F703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* bsetl<.f><.cc> 0,ximm,u6 0101110011001111F111uuuuuu1QQQQQ.  */
{ "bsetl", 0x5CCF7020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* bsetl<.f> RA,limm,RC 0101111000001111F111ccccccaaaaaa.  */
{ "bsetl", 0x5E0F7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* bsetl<.f> RA,RB,limm 01011bbb00001111FBBB111110aaaaaa.  */
{ "bsetl", 0x580F0F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* bsetl<.f> 0,limm,RC 0101111000001111F111cccccc111110.  */
{ "bsetl", 0x5E0F703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* bsetl<.f> 0,RB,limm 01011bbb00001111FBBB111110111110.  */
{ "bsetl", 0x580F0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* bsetl<.f><.cc> 0,limm,RC 0101111011001111F111cccccc0QQQQQ.  */
{ "bsetl", 0x5ECF7000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* bsetl<.f><.cc> RB,RB,limm 01011bbb11001111FBBB1111100QQQQQ.  */
{ "bsetl", 0x58CF0F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* bsetl<.f> RA,limm,u6 0101111001001111F111uuuuuuaaaaaa.  */
{ "bsetl", 0x5E4F7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* bsetl<.f> 0,limm,u6 0101111001001111F111uuuuuu111110.  */
{ "bsetl", 0x5E4F703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* bsetl<.f><.cc> 0,limm,u6 0101111011001111F111uuuuuu1QQQQQ.  */
{ "bsetl", 0x5ECF7020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* bsetl<.f> 0,ximm,s12 0101110010001111F111ssssssSSSSSS.  */
{ "bsetl", 0x5C8F7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* bsetl<.f> 0,limm,s12 0101111010001111F111ssssssSSSSSS.  */
{ "bsetl", 0x5E8F7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* bsetl<.f> RA,ximm,ximm 0101110000001111F111111100aaaaaa.  */
{ "bsetl", 0x5C0F7F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* bsetl<.f> 0,ximm,ximm 0101110000001111F111111100111110.  */
{ "bsetl", 0x5C0F7F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* bsetl<.f><.cc> 0,ximm,ximm 0101110011001111F1111111000QQQQQ.  */
{ "bsetl", 0x5CCF7F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* bsetl<.f> RA,limm,limm 0101111000001111F111111110aaaaaa.  */
{ "bsetl", 0x5E0F7F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* bsetl<.f> 0,limm,limm 0101111000001111F111111110111110.  */
{ "bsetl", 0x5E0F7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* bsetl<.f><.cc> 0,limm,limm 0101111011001111F1111111100QQQQQ.  */
{ "bsetl", 0x5ECF7F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* bset_s b,b,u5 10111bbb100uuuuu.  */
{ "bset_s", 0x0000B880, 0x0000F8E0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB_S, RB_Sdup, UIMM5_11_S }, { 0 }},

/* btst b,c 00100bbb000100011BBBCCCCCCRRRRRR.  */
{ "btst", 0x20118000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RC }, { 0 }},

/* btst<.cc> b,c 00100bbb110100011BBBCCCCCC0QQQQQ.  */
{ "btst", 0x20D18000, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RC }, { C_CC }},

/* btst b,u6 00100bbb010100011BBBuuuuuuRRRRRR.  */
{ "btst", 0x20518000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, UIMM6_20 }, { 0 }},

/* btst<.cc> b,u6 00100bbb110100011BBBuuuuuu1QQQQQ.  */
{ "btst", 0x20D18020, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, UIMM6_20 }, { C_CC }},

/* btst b,s12 00100bbb100100011BBBssssssSSSSSS.  */
{ "btst", 0x20918000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, SIMM12_20 }, { 0 }},

/* btst limm,c 00100110000100011111CCCCCCRRRRRR.  */
{ "btst", 0x2611F000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { LIMM, RC }, { 0 }},

/* btst b,limm 00100bbb000100011BBB111110RRRRRR.  */
{ "btst", 0x20118F80, 0xF8FF8FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, LIMM }, { 0 }},

/* btst<.cc> b,limm 00100bbb110100011BBB1111100QQQQQ.  */
{ "btst", 0x20D18F80, 0xF8FF8FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, LIMM }, { C_CC }},

/* btst<.cc> limm,c 00100110110100011111CCCCCC0QQQQQ.  */
{ "btst", 0x26D1F000, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { LIMM, RC }, { C_CC }},

/* btst limm,u6 00100110010100011111uuuuuuRRRRRR.  */
{ "btst", 0x2651F000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { LIMM, UIMM6_20 }, { 0 }},

/* btst<.cc> limm,u6 00100110110100011111uuuuuu1QQQQQ.  */
{ "btst", 0x26D1F020, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { LIMM, UIMM6_20 }, { C_CC }},

/* btst limm,s12 00100110100100011111ssssssSSSSSS.  */
{ "btst", 0x2691F000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { LIMM, SIMM12_20 }, { 0 }},

/* btst limm,limm 00100110000100011111111110RRRRRR.  */
{ "btst", 0x2611FF80, 0xFFFFFFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { LIMM, LIMMdup }, { 0 }},

/* btst<.cc> limm,limm 001001101101000111111111100QQQQQ.  */
{ "btst", 0x26D1FF80, 0xFFFFFFE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { LIMM, LIMMdup }, { C_CC }},

/* btstl RB,RC 01011bbb000100011BBBccccccRRRRRR.  */
{ "btstl", 0x58118000, 0xF8FF8000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { 0 }},

/* btstl<.cc> RB,RC 01011bbb110100011BBBcccccc0QQQQQ.  */
{ "btstl", 0x58D18000, 0xF8FF8020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_CC }},

/* btstl RB,u6 01011bbb010100011BBBuuuuuuRRRRRR.  */
{ "btstl", 0x58518000, 0xF8FF8000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { 0 }},

/* btstl<.cc> RB,u6 01011bbb110100011BBBuuuuuu1QQQQQ.  */
{ "btstl", 0x58D18020, 0xF8FF8020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_CC }},

/* btstl RB,s12 01011bbb100100011BBBssssssSSSSSS.  */
{ "btstl", 0x58918000, 0xF8FF8000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, SIMM12_20 }, { 0 }},

/* btstl ximm,RC 01011100000100011111ccccccRRRRRR.  */
{ "btstl", 0x5C11F000, 0xFFFFF000, ARC_OPCODE_ARC64, ARITH, NONE, { XIMM, RC }, { 0 }},

/* btstl RB,ximm 01011bbb000100011BBB111100RRRRRR.  */
{ "btstl", 0x58118F00, 0xF8FF8FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { 0 }},

/* btstl<.cc> RB,ximm 01011bbb110100011BBB1111000QQQQQ.  */
{ "btstl", 0x58D18F00, 0xF8FF8FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { C_CC }},

/* btstl limm,RC 01011110000100011111ccccccRRRRRR.  */
{ "btstl", 0x5E11F000, 0xFFFFF000, ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, RC }, { 0 }},

/* btstl RB,limm 01011bbb000100011BBB111110RRRRRR.  */
{ "btstl", 0x58118F80, 0xF8FF8FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { 0 }},

/* btstl<.cc> RB,limm 01011bbb110100011BBB1111100QQQQQ.  */
{ "btstl", 0x58D18F80, 0xF8FF8FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_CC }},

/* btst_s b,u5 10111bbb111uuuuu.  */
{ "btst_s", 0x0000B8E0, 0x0000F8E0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB_S, UIMM5_11_S }, { 0 }},

/* bxor<.f> a,b,c 00100bbb00010010FBBBCCCCCCAAAAAA.  */
{ "bxor", 0x20120000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* bxor<.f> 0,b,c 00100bbb00010010FBBBCCCCCC111110.  */
{ "bxor", 0x2012003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* bxor<.f><.cc> b,b,c 00100bbb11010010FBBBCCCCCC0QQQQQ.  */
{ "bxor", 0x20D20000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* bxor<.f> a,b,u6 00100bbb01010010FBBBuuuuuuAAAAAA.  */
{ "bxor", 0x20520000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* bxor<.f> 0,b,u6 00100bbb01010010FBBBuuuuuu111110.  */
{ "bxor", 0x2052003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* bxor<.f><.cc> b,b,u6 00100bbb11010010FBBBuuuuuu1QQQQQ.  */
{ "bxor", 0x20D20020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* bxor<.f> b,b,s12 00100bbb10010010FBBBssssssSSSSSS.  */
{ "bxor", 0x20920000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* bxor<.f> a,limm,c 0010011000010010F111CCCCCCAAAAAA.  */
{ "bxor", 0x26127000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* bxor<.f> a,b,limm 00100bbb00010010FBBB111110AAAAAA.  */
{ "bxor", 0x20120F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* bxor<.f> 0,limm,c 0010011000010010F111CCCCCC111110.  */
{ "bxor", 0x2612703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* bxor<.f> 0,b,limm 00100bbb00010010FBBB111110111110.  */
{ "bxor", 0x20120FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* bxor<.f><.cc> b,b,limm 00100bbb11010010FBBB1111100QQQQQ.  */
{ "bxor", 0x20D20F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* bxor<.f><.cc> 0,limm,c 0010011011010010F111CCCCCC0QQQQQ.  */
{ "bxor", 0x26D27000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* bxor<.f> a,limm,u6 0010011001010010F111uuuuuuAAAAAA.  */
{ "bxor", 0x26527000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* bxor<.f> 0,limm,u6 0010011001010010F111uuuuuu111110.  */
{ "bxor", 0x2652703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* bxor<.f><.cc> 0,limm,u6 0010011011010010F111uuuuuu1QQQQQ.  */
{ "bxor", 0x26D27020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* bxor<.f> 0,limm,s12 0010011010010010F111ssssssSSSSSS.  */
{ "bxor", 0x26927000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* bxor<.f> a,limm,limm 0010011000010010F111111110AAAAAA.  */
{ "bxor", 0x26127F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* bxor<.f> 0,limm,limm 0010011000010010F111111110111110.  */
{ "bxor", 0x26127FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* bxor<.f><.cc> 0,limm,limm 0010011011010010F1111111100QQQQQ.  */
{ "bxor", 0x26D27F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* bxorl<.f> RA,RB,RC 01011bbb00010010FBBBccccccaaaaaa.  */
{ "bxorl", 0x58120000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* bxorl<.f> 0,RB,RC 01011bbb00010010FBBBcccccc111110.  */
{ "bxorl", 0x5812003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* bxorl<.f><.cc> RB,RB,RC 01011bbb11010010FBBBcccccc0QQQQQ.  */
{ "bxorl", 0x58D20000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* bxorl<.f> RA,RB,u6 01011bbb01010010FBBBuuuuuuaaaaaa.  */
{ "bxorl", 0x58520000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* bxorl<.f> 0,RB,u6 01011bbb01010010FBBBuuuuuu111110.  */
{ "bxorl", 0x5852003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* bxorl<.f><.cc> RB,RB,u6 01011bbb11010010FBBBuuuuuu1QQQQQ.  */
{ "bxorl", 0x58D20020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* bxorl<.f> RB,RB,s12 01011bbb10010010FBBBssssssSSSSSS.  */
{ "bxorl", 0x58920000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* bxorl<.f> RA,ximm,RC 0101110000010010F111ccccccaaaaaa.  */
{ "bxorl", 0x5C127000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* bxorl<.f> RA,RB,ximm 01011bbb00010010FBBB111100aaaaaa.  */
{ "bxorl", 0x58120F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* bxorl<.f> 0,ximm,RC 0101110000010010F111cccccc111110.  */
{ "bxorl", 0x5C12703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* bxorl<.f> 0,RB,ximm 01011bbb00010010FBBB111100111110.  */
{ "bxorl", 0x58120F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* bxorl<.f><.cc> 0,ximm,RC 0101110011010010F111cccccc0QQQQQ.  */
{ "bxorl", 0x5CD27000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* bxorl<.f><.cc> RB,RB,ximm 01011bbb11010010FBBB1111000QQQQQ.  */
{ "bxorl", 0x58D20F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* bxorl<.f> RA,ximm,u6 0101110001010010F111uuuuuuaaaaaa.  */
{ "bxorl", 0x5C527000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* bxorl<.f> 0,ximm,u6 0101110001010010F111uuuuuu111110.  */
{ "bxorl", 0x5C52703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* bxorl<.f><.cc> 0,ximm,u6 0101110011010010F111uuuuuu1QQQQQ.  */
{ "bxorl", 0x5CD27020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* bxorl<.f> RA,limm,RC 0101111000010010F111ccccccaaaaaa.  */
{ "bxorl", 0x5E127000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* bxorl<.f> RA,RB,limm 01011bbb00010010FBBB111110aaaaaa.  */
{ "bxorl", 0x58120F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* bxorl<.f> 0,limm,RC 0101111000010010F111cccccc111110.  */
{ "bxorl", 0x5E12703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* bxorl<.f> 0,RB,limm 01011bbb00010010FBBB111110111110.  */
{ "bxorl", 0x58120FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* bxorl<.f><.cc> 0,limm,RC 0101111011010010F111cccccc0QQQQQ.  */
{ "bxorl", 0x5ED27000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* bxorl<.f><.cc> RB,RB,limm 01011bbb11010010FBBB1111100QQQQQ.  */
{ "bxorl", 0x58D20F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* bxorl<.f> RA,limm,u6 0101111001010010F111uuuuuuaaaaaa.  */
{ "bxorl", 0x5E527000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* bxorl<.f> 0,limm,u6 0101111001010010F111uuuuuu111110.  */
{ "bxorl", 0x5E52703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* bxorl<.f><.cc> 0,limm,u6 0101111011010010F111uuuuuu1QQQQQ.  */
{ "bxorl", 0x5ED27020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* bxorl<.f> 0,ximm,s12 0101110010010010F111ssssssSSSSSS.  */
{ "bxorl", 0x5C927000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* bxorl<.f> 0,limm,s12 0101111010010010F111ssssssSSSSSS.  */
{ "bxorl", 0x5E927000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* bxorl<.f> RA,ximm,ximm 0101110000010010F111111100aaaaaa.  */
{ "bxorl", 0x5C127F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* bxorl<.f> 0,ximm,ximm 0101110000010010F111111100111110.  */
{ "bxorl", 0x5C127F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* bxorl<.f><.cc> 0,ximm,ximm 0101110011010010F1111111000QQQQQ.  */
{ "bxorl", 0x5CD27F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* bxorl<.f> RA,limm,limm 0101111000010010F111111110aaaaaa.  */
{ "bxorl", 0x5E127F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* bxorl<.f> 0,limm,limm 0101111000010010F111111110111110.  */
{ "bxorl", 0x5E127FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* bxorl<.f><.cc> 0,limm,limm 0101111011010010F1111111100QQQQQ.  */
{ "bxorl", 0x5ED27F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* b_s s10 1111000sssssssss.  */
{ "b_s", 0x0000F000, 0x0000FE00,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRANCH, NONE, { SIMM10_A16_7_S }, { 0 }},

/* clri c 00100111001011110000CCCCCC111111.  */
{ "clri", 0x272F003F, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { RC }, { 0 }},

/* clri u6 00100111011011110000uuuuuu111111.  */
{ "clri", 0x276F003F, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { UIMM6_20 }, { 0 }},

/* clri  00100111001011110000000000111111.  */
{ "clri", 0x276F003F, 0xFFFFFFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { 0 }, { 0 }},

/* cmp b,c 00100bbb000011001BBBCCCCCCRRRRRR.  */
{ "cmp", 0x200C8000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { 0 }},

/* cmp<.cc> b,c 00100bbb110011001BBBCCCCCC0QQQQQ.  */
{ "cmp", 0x20CC8000, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_CC }},

/* cmp b,u6 00100bbb010011001BBBuuuuuuRRRRRR.  */
{ "cmp", 0x204C8000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { 0 }},

/* cmp<.cc> b,u6 00100bbb110011001BBBuuuuuu1QQQQQ.  */
{ "cmp", 0x20CC8020, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_CC }},

/* cmp b,s12 00100bbb100011001BBBssssssSSSSSS.  */
{ "cmp", 0x208C8000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, SIMM12_20 }, { 0 }},

/* cmp limm,c 00100110000011001111CCCCCCRRRRRR.  */
{ "cmp", 0x260CF000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, RC }, { 0 }},

/* cmp b,limm 00100bbb000011001BBB111110RRRRRR.  */
{ "cmp", 0x200C8F80, 0xF8FF8FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { 0 }},

/* cmp<.cc> b,limm 00100bbb110011001BBB1111100QQQQQ.  */
{ "cmp", 0x20CC8F80, 0xF8FF8FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_CC }},

/* cmp<.cc> limm,c 00100110110011001111CCCCCC0QQQQQ.  */
{ "cmp", 0x26CCF000, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, RC }, { C_CC }},

/* cmp limm,u6 00100110010011001111uuuuuuRRRRRR.  */
{ "cmp", 0x264CF000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, UIMM6_20 }, { 0 }},

/* cmp<.cc> limm,u6 00100110110011001111uuuuuu1QQQQQ.  */
{ "cmp", 0x26CCF020, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, UIMM6_20 }, { C_CC }},

/* cmp limm,s12 00100110100011001111ssssssSSSSSS.  */
{ "cmp", 0x268CF000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, SIMM12_20 }, { 0 }},

/* cmp limm,limm 00100110000011001111111110RRRRRR.  */
{ "cmp", 0x260CFF80, 0xFFFFFFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, LIMMdup }, { 0 }},

/* cmp<.cc> limm,limm 001001101100110011111111100QQQQQ.  */
{ "cmp", 0x26CCFF80, 0xFFFFFFE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, LIMMdup }, { C_CC }},

/* cmpl RB,RC 01011bbb000011001BBBccccccRRRRRR.  */
{ "cmpl", 0x580C8000, 0xF8FF8000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { 0 }},

/* cmpl<.cc> RB,RC 01011bbb110011001BBBcccccc0QQQQQ.  */
{ "cmpl", 0x58CC8000, 0xF8FF8020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_CC }},

/* cmpl RB,u6 01011bbb010011001BBBuuuuuuRRRRRR.  */
{ "cmpl", 0x584C8000, 0xF8FF8000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { 0 }},

/* cmpl<.cc> RB,u6 01011bbb110011001BBBuuuuuu1QQQQQ.  */
{ "cmpl", 0x58CC8020, 0xF8FF8020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_CC }},

/* cmpl RB,s12 01011bbb100011001BBBssssssSSSSSS.  */
{ "cmpl", 0x588C8000, 0xF8FF8000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, SIMM12_20 }, { 0 }},

/* cmpl ximm,RC 01011100000011001111ccccccRRRRRR.  */
{ "cmpl", 0x5C0CF000, 0xFFFFF000, ARC_OPCODE_ARC64, ARITH, NONE, { XIMM, RC }, { 0 }},

/* cmpl RB,ximm 01011bbb000011001BBB111100RRRRRR.  */
{ "cmpl", 0x580C8F00, 0xF8FF8FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { 0 }},

/* cmpl<.cc> RB,ximm 01011bbb110011001BBB1111000QQQQQ.  */
{ "cmpl", 0x58CC8F00, 0xF8FF8FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { C_CC }},

/* cmpl limm,RC 01011110000011001111ccccccRRRRRR.  */
{ "cmpl", 0x5E0CF000, 0xFFFFF000, ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, RC }, { 0 }},

/* cmpl RB,limm 01011bbb000011001BBB111110RRRRRR.  */
{ "cmpl", 0x580C8F80, 0xF8FF8FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { 0 }},

/* cmpl<.cc> RB,limm 01011bbb110011001BBB1111100QQQQQ.  */
{ "cmpl", 0x58CC8F80, 0xF8FF8FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_CC }},

/* cmp_s b,h 01110bbbhhh100HH.  */
{ "cmp_s", 0x00007010, 0x0000F81C,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB_S, RH_S }, { 0 }},

/* cmp_s h,s3 01110ssshhh101HH.  */
{ "cmp_s", 0x00007014, 0x0000F81C,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RH_S, SIMM3_5_S }, { 0 }},

/* cmp_s b,limm 01110bbb11010011.  */
{ "cmp_s", 0x000070D3, 0x0000F8FF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB_S, LIMM_S }, { 0 }},

/* cmp_s limm,s3 01110sss11010111.  */
{ "cmp_s", 0x000070D7, 0x0000F8FF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { LIMM_S, SIMM3_5_S }, { 0 }},

/* dbnz<.d> b,s13 00100bbb1000110N0BBBssssssSSSSSS.  */
{ "dbnz", 0x208C0000, 0xF8FE8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, BRANCH, NONE, { RB, SIMM13_A16_20 }, { C_DNZ_D }},

/* div<.f> a,b,c 00101bbb00000100FBBBCCCCCCAAAAAA.  */
{ "div", 0x28040000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, RB, RC }, { C_F }},

/* div<.f> 0,b,c 00101bbb00000100FBBBCCCCCC111110.  */
{ "div", 0x2804003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, RB, RC }, { C_F }},

/* div<.f><.cc> b,b,c 00101bbb11000100FBBBCCCCCC0QQQQQ.  */
{ "div", 0x28C40000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* div<.f> a,b,u6 00101bbb01000100FBBBuuuuuuAAAAAA.  */
{ "div", 0x28440000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* div<.f> 0,b,u6 00101bbb01000100FBBBuuuuuu111110.  */
{ "div", 0x2844003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, RB, UIMM6_20 }, { C_F }},

/* div<.f><.cc> b,b,u6 00101bbb11000100FBBBuuuuuu1QQQQQ.  */
{ "div", 0x28C40020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* div<.f> b,b,s12 00101bbb10000100FBBBssssssSSSSSS.  */
{ "div", 0x28840000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* div<.f> a,limm,c 0010111000000100F111CCCCCCAAAAAA.  */
{ "div", 0x2E047000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, LIMM, RC }, { C_F }},

/* div<.f> a,b,limm 00101bbb00000100FBBB111110AAAAAA.  */
{ "div", 0x28040F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, RB, LIMM }, { C_F }},

/* div<.f> 0,limm,c 0010111000000100F111CCCCCC111110.  */
{ "div", 0x2E04703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, RC }, { C_F }},

/* div<.f> 0,b,limm 00101bbb00000100FBBB111110111110.  */
{ "div", 0x28040FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, RB, LIMM }, { C_F }},

/* div<.f><.cc> b,b,limm 00101bbb11000100FBBB1111100QQQQQ.  */
{ "div", 0x28C40F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* div<.f><.cc> 0,limm,c 0010111011000100F111CCCCCC0QQQQQ.  */
{ "div", 0x2EC47000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, RC }, { C_F, C_CC }},

/* div<.f> a,limm,u6 0010111001000100F111uuuuuuAAAAAA.  */
{ "div", 0x2E447000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* div<.f> 0,limm,u6 0010111001000100F111uuuuuu111110.  */
{ "div", 0x2E44703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* div<.f><.cc> 0,limm,u6 0010111011000100F111uuuuuu1QQQQQ.  */
{ "div", 0x2EC47020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* div<.f> 0,limm,s12 0010111010000100F111ssssssSSSSSS.  */
{ "div", 0x2E847000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* div<.f> a,limm,limm 0010111000000100F111111110AAAAAA.  */
{ "div", 0x2E047F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* div<.f> 0,limm,limm 0010111000000100F111111110111110.  */
{ "div", 0x2E047FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, LIMMdup }, { C_F }},

/* div<.f><.cc> 0,limm,limm 0010111011000100F1111111100QQQQQ.  */
{ "div", 0x2EC47F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* divl<.f> RA,RB,RC 01011bbb00100100FBBBccccccaaaaaa.  */
{ "divl", 0x58240000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* divl<.f> 0,RB,RC 01011bbb00100100FBBBcccccc111110.  */
{ "divl", 0x5824003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* divl<.f><.cc> RB,RB,RC 01011bbb11100100FBBBcccccc0QQQQQ.  */
{ "divl", 0x58E40000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* divl<.f> RA,RB,u6 01011bbb01100100FBBBuuuuuuaaaaaa.  */
{ "divl", 0x58640000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* divl<.f> 0,RB,u6 01011bbb01100100FBBBuuuuuu111110.  */
{ "divl", 0x5864003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* divl<.f><.cc> RB,RB,u6 01011bbb11100100FBBBuuuuuu1QQQQQ.  */
{ "divl", 0x58E40020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* divl<.f> RB,RB,s12 01011bbb10100100FBBBssssssSSSSSS.  */
{ "divl", 0x58A40000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* divl<.f> RA,ximm,RC 0101110000100100F111ccccccaaaaaa.  */
{ "divl", 0x5C247000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* divl<.f> RA,RB,ximm 01011bbb00100100FBBB111100aaaaaa.  */
{ "divl", 0x58240F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* divl<.f> 0,ximm,RC 0101110000100100F111cccccc111110.  */
{ "divl", 0x5C24703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* divl<.f> 0,RB,ximm 01011bbb00100100FBBB111100111110.  */
{ "divl", 0x58240F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* divl<.f><.cc> 0,ximm,RC 0101110011100100F111cccccc0QQQQQ.  */
{ "divl", 0x5CE47000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* divl<.f><.cc> RB,RB,ximm 01011bbb11100100FBBB1111000QQQQQ.  */
{ "divl", 0x58E40F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* divl<.f> RA,ximm,u6 0101110001100100F111uuuuuuaaaaaa.  */
{ "divl", 0x5C647000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* divl<.f> 0,ximm,u6 0101110001100100F111uuuuuu111110.  */
{ "divl", 0x5C64703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* divl<.f><.cc> 0,ximm,u6 0101110011100100F111uuuuuu1QQQQQ.  */
{ "divl", 0x5CE47020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* divl<.f> RA,limm,RC 0101111000100100F111ccccccaaaaaa.  */
{ "divl", 0x5E247000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* divl<.f> RA,RB,limm 01011bbb00100100FBBB111110aaaaaa.  */
{ "divl", 0x58240F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* divl<.f> 0,limm,RC 0101111000100100F111cccccc111110.  */
{ "divl", 0x5E24703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* divl<.f> 0,RB,limm 01011bbb00100100FBBB111110111110.  */
{ "divl", 0x58240FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* divl<.f><.cc> 0,limm,RC 0101111011100100F111cccccc0QQQQQ.  */
{ "divl", 0x5EE47000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* divl<.f><.cc> RB,RB,limm 01011bbb11100100FBBB1111100QQQQQ.  */
{ "divl", 0x58E40F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* divl<.f> RA,limm,u6 0101111001100100F111uuuuuuaaaaaa.  */
{ "divl", 0x5E647000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* divl<.f> 0,limm,u6 0101111001100100F111uuuuuu111110.  */
{ "divl", 0x5E64703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* divl<.f><.cc> 0,limm,u6 0101111011100100F111uuuuuu1QQQQQ.  */
{ "divl", 0x5EE47020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* divl<.f> 0,ximm,s12 0101110010100100F111ssssssSSSSSS.  */
{ "divl", 0x5CA47000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* divl<.f> 0,limm,s12 0101111010100100F111ssssssSSSSSS.  */
{ "divl", 0x5EA47000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* divl<.f> RA,ximm,ximm 0101110000100100F111111100aaaaaa.  */
{ "divl", 0x5C247F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* divl<.f> 0,ximm,ximm 0101110000100100F111111100111110.  */
{ "divl", 0x5C247F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* divl<.f><.cc> 0,ximm,ximm 0101110011100100F1111111000QQQQQ.  */
{ "divl", 0x5CE47F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* divl<.f> RA,limm,limm 0101111000100100F111111110aaaaaa.  */
{ "divl", 0x5E247F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* divl<.f> 0,limm,limm 0101111000100100F111111110111110.  */
{ "divl", 0x5E247FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* divl<.f><.cc> 0,limm,limm 0101111011100100F1111111100QQQQQ.  */
{ "divl", 0x5EE47F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* divu<.f> a,b,c 00101bbb00000101FBBBCCCCCCAAAAAA.  */
{ "divu", 0x28050000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, RB, RC }, { C_F }},

/* divu<.f> 0,b,c 00101bbb00000101FBBBCCCCCC111110.  */
{ "divu", 0x2805003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, RB, RC }, { C_F }},

/* divu<.f><.cc> b,b,c 00101bbb11000101FBBBCCCCCC0QQQQQ.  */
{ "divu", 0x28C50000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* divu<.f> a,b,u6 00101bbb01000101FBBBuuuuuuAAAAAA.  */
{ "divu", 0x28450000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* divu<.f> 0,b,u6 00101bbb01000101FBBBuuuuuu111110.  */
{ "divu", 0x2845003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, RB, UIMM6_20 }, { C_F }},

/* divu<.f><.cc> b,b,u6 00101bbb11000101FBBBuuuuuu1QQQQQ.  */
{ "divu", 0x28C50020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* divu<.f> b,b,s12 00101bbb10000101FBBBssssssSSSSSS.  */
{ "divu", 0x28850000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* divu<.f> a,limm,c 0010111000000101F111CCCCCCAAAAAA.  */
{ "divu", 0x2E057000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, LIMM, RC }, { C_F }},

/* divu<.f> a,b,limm 00101bbb00000101FBBB111110AAAAAA.  */
{ "divu", 0x28050F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, RB, LIMM }, { C_F }},

/* divu<.f> 0,limm,c 0010111000000101F111CCCCCC111110.  */
{ "divu", 0x2E05703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, RC }, { C_F }},

/* divu<.f> 0,b,limm 00101bbb00000101FBBB111110111110.  */
{ "divu", 0x28050FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, RB, LIMM }, { C_F }},

/* divu<.f><.cc> b,b,limm 00101bbb11000101FBBB1111100QQQQQ.  */
{ "divu", 0x28C50F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* divu<.f><.cc> 0,limm,c 0010111011000101F111CCCCCC0QQQQQ.  */
{ "divu", 0x2EC57000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, RC }, { C_F, C_CC }},

/* divu<.f> a,limm,u6 0010111001000101F111uuuuuuAAAAAA.  */
{ "divu", 0x2E457000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* divu<.f> 0,limm,u6 0010111001000101F111uuuuuu111110.  */
{ "divu", 0x2E45703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* divu<.f><.cc> 0,limm,u6 0010111011000101F111uuuuuu1QQQQQ.  */
{ "divu", 0x2EC57020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* divu<.f> 0,limm,s12 0010111010000101F111ssssssSSSSSS.  */
{ "divu", 0x2E857000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* divu<.f> a,limm,limm 0010111000000101F111111110AAAAAA.  */
{ "divu", 0x2E057F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* divu<.f> 0,limm,limm 0010111000000101F111111110111110.  */
{ "divu", 0x2E057FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, LIMMdup }, { C_F }},

/* divu<.f><.cc> 0,limm,limm 0010111011000101F1111111100QQQQQ.  */
{ "divu", 0x2EC57F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* divul<.f> RA,RB,RC 01011bbb00100101FBBBccccccaaaaaa.  */
{ "divul", 0x58250000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* divul<.f> 0,RB,RC 01011bbb00100101FBBBcccccc111110.  */
{ "divul", 0x5825003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* divul<.f><.cc> RB,RB,RC 01011bbb11100101FBBBcccccc0QQQQQ.  */
{ "divul", 0x58E50000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* divul<.f> RA,RB,u6 01011bbb01100101FBBBuuuuuuaaaaaa.  */
{ "divul", 0x58650000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* divul<.f> 0,RB,u6 01011bbb01100101FBBBuuuuuu111110.  */
{ "divul", 0x5865003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* divul<.f><.cc> RB,RB,u6 01011bbb11100101FBBBuuuuuu1QQQQQ.  */
{ "divul", 0x58E50020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* divul<.f> RB,RB,s12 01011bbb10100101FBBBssssssSSSSSS.  */
{ "divul", 0x58A50000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* divul<.f> RA,ximm,RC 0101110000100101F111ccccccaaaaaa.  */
{ "divul", 0x5C257000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* divul<.f> RA,RB,ximm 01011bbb00100101FBBB111100aaaaaa.  */
{ "divul", 0x58250F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* divul<.f> 0,ximm,RC 0101110000100101F111cccccc111110.  */
{ "divul", 0x5C25703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* divul<.f> 0,RB,ximm 01011bbb00100101FBBB111100111110.  */
{ "divul", 0x58250F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* divul<.f><.cc> 0,ximm,RC 0101110011100101F111cccccc0QQQQQ.  */
{ "divul", 0x5CE57000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* divul<.f><.cc> RB,RB,ximm 01011bbb11100101FBBB1111000QQQQQ.  */
{ "divul", 0x58E50F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* divul<.f> RA,ximm,u6 0101110001100101F111uuuuuuaaaaaa.  */
{ "divul", 0x5C657000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* divul<.f> 0,ximm,u6 0101110001100101F111uuuuuu111110.  */
{ "divul", 0x5C65703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* divul<.f><.cc> 0,ximm,u6 0101110011100101F111uuuuuu1QQQQQ.  */
{ "divul", 0x5CE57020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* divul<.f> RA,limm,RC 0101111000100101F111ccccccaaaaaa.  */
{ "divul", 0x5E257000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* divul<.f> RA,RB,limm 01011bbb00100101FBBB111110aaaaaa.  */
{ "divul", 0x58250F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* divul<.f> 0,limm,RC 0101111000100101F111cccccc111110.  */
{ "divul", 0x5E25703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* divul<.f> 0,RB,limm 01011bbb00100101FBBB111110111110.  */
{ "divul", 0x58250FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* divul<.f><.cc> 0,limm,RC 0101111011100101F111cccccc0QQQQQ.  */
{ "divul", 0x5EE57000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* divul<.f><.cc> RB,RB,limm 01011bbb11100101FBBB1111100QQQQQ.  */
{ "divul", 0x58E50F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* divul<.f> RA,limm,u6 0101111001100101F111uuuuuuaaaaaa.  */
{ "divul", 0x5E657000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* divul<.f> 0,limm,u6 0101111001100101F111uuuuuu111110.  */
{ "divul", 0x5E65703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* divul<.f><.cc> 0,limm,u6 0101111011100101F111uuuuuu1QQQQQ.  */
{ "divul", 0x5EE57020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* divul<.f> 0,ximm,s12 0101110010100101F111ssssssSSSSSS.  */
{ "divul", 0x5CA57000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* divul<.f> 0,limm,s12 0101111010100101F111ssssssSSSSSS.  */
{ "divul", 0x5EA57000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* divul<.f> RA,ximm,ximm 0101110000100101F111111100aaaaaa.  */
{ "divul", 0x5C257F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* divul<.f> 0,ximm,ximm 0101110000100101F111111100111110.  */
{ "divul", 0x5C257F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* divul<.f><.cc> 0,ximm,ximm 0101110011100101F1111111000QQQQQ.  */
{ "divul", 0x5CE57F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* divul<.f> RA,limm,limm 0101111000100101F111111110aaaaaa.  */
{ "divul", 0x5E257F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* divul<.f> 0,limm,limm 0101111000100101F111111110111110.  */
{ "divul", 0x5E257FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* divul<.f><.cc> 0,limm,limm 0101111011100101F1111111100QQQQQ.  */
{ "divul", 0x5EE57F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmach<.f> a,b,c 00101bbb00010010FBBBCCCCCCAAAAAA.  */
{ "dmach", 0x28120000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, RC }, { C_F }},

/* dmach<.f> 0,b,c 00101bbb00010010FBBBCCCCCC111110.  */
{ "dmach", 0x2812003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, RC }, { C_F }},

/* dmach<.f><.cc> b,b,c 00101bbb11010010FBBBCCCCCC0QQQQQ.  */
{ "dmach", 0x28D20000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmach<.f> a,b,u6 00101bbb01010010FBBBuuuuuuAAAAAA.  */
{ "dmach", 0x28520000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmach<.f> 0,b,u6 00101bbb01010010FBBBuuuuuu111110.  */
{ "dmach", 0x2852003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmach<.f><.cc> b,b,u6 00101bbb11010010FBBBuuuuuu1QQQQQ.  */
{ "dmach", 0x28D20020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmach<.f> b,b,s12 00101bbb10010010FBBBssssssSSSSSS.  */
{ "dmach", 0x28920000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmach<.f> a,limm,c 0010111000010010F111CCCCCCAAAAAA.  */
{ "dmach", 0x2E127000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, RC }, { C_F }},

/* dmach<.f> a,b,limm 00101bbb00010010FBBB111110AAAAAA.  */
{ "dmach", 0x28120F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, LIMM }, { C_F }},

/* dmach<.f> 0,limm,c 0010111000010010F111CCCCCC111110.  */
{ "dmach", 0x2E12703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, RC }, { C_F }},

/* dmach<.f> 0,b,limm 00101bbb00010010FBBB111110111110.  */
{ "dmach", 0x28120FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, LIMM }, { C_F }},

/* dmach<.f><.cc> b,b,limm 00101bbb11010010FBBB1111100QQQQQ.  */
{ "dmach", 0x28D20F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmach<.f><.cc> 0,limm,c 0010111011010010F111CCCCCC0QQQQQ.  */
{ "dmach", 0x2ED27000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmach<.f> a,limm,u6 0010111001010010F111uuuuuuAAAAAA.  */
{ "dmach", 0x2E527000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmach<.f> 0,limm,u6 0010111001010010F111uuuuuu111110.  */
{ "dmach", 0x2E52703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmach<.f><.cc> 0,limm,u6 0010111011010010F111uuuuuu1QQQQQ.  */
{ "dmach", 0x2ED27020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmach<.f> 0,limm,s12 0010111010010010F111ssssssSSSSSS.  */
{ "dmach", 0x2E927000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmach<.f> a,limm,limm 0010111000010010F111111110AAAAAA.  */
{ "dmach", 0x2E127F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmach<.f> 0,limm,limm 0010111000010010F111111110111110.  */
{ "dmach", 0x2E127FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmach<.f><.cc> 0,limm,limm 0010111011010010F1111111100QQQQQ.  */
{ "dmach", 0x2ED27F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmachu<.f> a,b,c 00101bbb00010011FBBBCCCCCCAAAAAA.  */
{ "dmachu", 0x28130000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, RC }, { C_F }},

/* dmachu<.f> 0,b,c 00101bbb00010011FBBBCCCCCC111110.  */
{ "dmachu", 0x2813003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, RC }, { C_F }},

/* dmachu<.f><.cc> b,b,c 00101bbb11010011FBBBCCCCCC0QQQQQ.  */
{ "dmachu", 0x28D30000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmachu<.f> a,b,u6 00101bbb01010011FBBBuuuuuuAAAAAA.  */
{ "dmachu", 0x28530000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmachu<.f> 0,b,u6 00101bbb01010011FBBBuuuuuu111110.  */
{ "dmachu", 0x2853003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmachu<.f><.cc> b,b,u6 00101bbb11010011FBBBuuuuuu1QQQQQ.  */
{ "dmachu", 0x28D30020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmachu<.f> b,b,s12 00101bbb10010011FBBBssssssSSSSSS.  */
{ "dmachu", 0x28930000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmachu<.f> a,limm,c 0010111000010011F111CCCCCCAAAAAA.  */
{ "dmachu", 0x2E137000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, RC }, { C_F }},

/* dmachu<.f> a,b,limm 00101bbb00010011FBBB111110AAAAAA.  */
{ "dmachu", 0x28130F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, LIMM }, { C_F }},

/* dmachu<.f> 0,limm,c 0010111000010011F111CCCCCC111110.  */
{ "dmachu", 0x2E13703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, RC }, { C_F }},

/* dmachu<.f> 0,b,limm 00101bbb00010011FBBB111110111110.  */
{ "dmachu", 0x28130FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, LIMM }, { C_F }},

/* dmachu<.f><.cc> b,b,limm 00101bbb11010011FBBB1111100QQQQQ.  */
{ "dmachu", 0x28D30F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmachu<.f><.cc> 0,limm,c 0010111011010011F111CCCCCC0QQQQQ.  */
{ "dmachu", 0x2ED37000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmachu<.f> a,limm,u6 0010111001010011F111uuuuuuAAAAAA.  */
{ "dmachu", 0x2E537000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmachu<.f> 0,limm,u6 0010111001010011F111uuuuuu111110.  */
{ "dmachu", 0x2E53703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmachu<.f><.cc> 0,limm,u6 0010111011010011F111uuuuuu1QQQQQ.  */
{ "dmachu", 0x2ED37020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmachu<.f> 0,limm,s12 0010111010010011F111ssssssSSSSSS.  */
{ "dmachu", 0x2E937000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmachu<.f> a,limm,limm 0010111000010011F111111110AAAAAA.  */
{ "dmachu", 0x2E137F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmachu<.f> 0,limm,limm 0010111000010011F111111110111110.  */
{ "dmachu", 0x2E137FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmachu<.f><.cc> 0,limm,limm 0010111011010011F1111111100QQQQQ.  */
{ "dmachu", 0x2ED37F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmacwh<.f> a,b,c 00101bbb00110110FBBBCCCCCCAAAAAA.  */
{ "dmacwh", 0x28360000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, RC }, { C_F }},

/* dmacwh<.f> 0,b,c 00101bbb00110110FBBBCCCCCC111110.  */
{ "dmacwh", 0x2836003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, RC }, { C_F }},

/* dmacwh<.f><.cc> b,b,c 00101bbb11110110FBBBCCCCCC0QQQQQ.  */
{ "dmacwh", 0x28F60000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmacwh<.f> a,b,u6 00101bbb01110110FBBBuuuuuuAAAAAA.  */
{ "dmacwh", 0x28760000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmacwh<.f> 0,b,u6 00101bbb01110110FBBBuuuuuu111110.  */
{ "dmacwh", 0x2876003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmacwh<.f><.cc> b,b,u6 00101bbb11110110FBBBuuuuuu1QQQQQ.  */
{ "dmacwh", 0x28F60020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmacwh<.f> b,b,s12 00101bbb10110110FBBBssssssSSSSSS.  */
{ "dmacwh", 0x28B60000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmacwh<.f> a,limm,c 0010111000110110F111CCCCCCAAAAAA.  */
{ "dmacwh", 0x2E367000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, RC }, { C_F }},

/* dmacwh<.f> a,b,limm 00101bbb00110110FBBB111110AAAAAA.  */
{ "dmacwh", 0x28360F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, LIMM }, { C_F }},

/* dmacwh<.f> 0,limm,c 0010111000110110F111CCCCCC111110.  */
{ "dmacwh", 0x2E36703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_F }},

/* dmacwh<.f> 0,b,limm 00101bbb00110110FBBB111110111110.  */
{ "dmacwh", 0x28360FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, LIMM }, { C_F }},

/* dmacwh<.f><.cc> b,b,limm 00101bbb11110110FBBB1111100QQQQQ.  */
{ "dmacwh", 0x28F60F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmacwh<.f><.cc> 0,limm,c 0010111011110110F111CCCCCC0QQQQQ.  */
{ "dmacwh", 0x2EF67000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmacwh<.f> a,limm,u6 0010111001110110F111uuuuuuAAAAAA.  */
{ "dmacwh", 0x2E767000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmacwh<.f> 0,limm,u6 0010111001110110F111uuuuuu111110.  */
{ "dmacwh", 0x2E76703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmacwh<.f><.cc> 0,limm,u6 0010111011110110F111uuuuuu1QQQQQ.  */
{ "dmacwh", 0x2EF67020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmacwh<.f> 0,limm,s12 0010111010110110F111ssssssSSSSSS.  */
{ "dmacwh", 0x2EB67000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmacwh<.f> a,limm,limm 0010111000110110F111111110AAAAAA.  */
{ "dmacwh", 0x2E367F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmacwh<.f> 0,limm,limm 0010111000110110F111111110111110.  */
{ "dmacwh", 0x2E367FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmacwh<.f><.cc> 0,limm,limm 0010111011110110F1111111100QQQQQ.  */
{ "dmacwh", 0x2EF67F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmacwhu<.f> a,b,c 00101bbb00110111FBBBCCCCCCAAAAAA.  */
{ "dmacwhu", 0x28370000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, RC }, { C_F }},

/* dmacwhu<.f> 0,b,c 00101bbb00110111FBBBCCCCCC111110.  */
{ "dmacwhu", 0x2837003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, RC }, { C_F }},

/* dmacwhu<.f><.cc> b,b,c 00101bbb11110111FBBBCCCCCC0QQQQQ.  */
{ "dmacwhu", 0x28F70000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmacwhu<.f> a,b,u6 00101bbb01110111FBBBuuuuuuAAAAAA.  */
{ "dmacwhu", 0x28770000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmacwhu<.f> 0,b,u6 00101bbb01110111FBBBuuuuuu111110.  */
{ "dmacwhu", 0x2877003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmacwhu<.f><.cc> b,b,u6 00101bbb11110111FBBBuuuuuu1QQQQQ.  */
{ "dmacwhu", 0x28F70020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmacwhu<.f> b,b,s12 00101bbb10110111FBBBssssssSSSSSS.  */
{ "dmacwhu", 0x28B70000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmacwhu<.f> a,limm,c 0010111000110111F111CCCCCCAAAAAA.  */
{ "dmacwhu", 0x2E377000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, RC }, { C_F }},

/* dmacwhu<.f> a,b,limm 00101bbb00110111FBBB111110AAAAAA.  */
{ "dmacwhu", 0x28370F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, LIMM }, { C_F }},

/* dmacwhu<.f> 0,limm,c 0010111000110111F111CCCCCC111110.  */
{ "dmacwhu", 0x2E37703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_F }},

/* dmacwhu<.f> 0,b,limm 00101bbb00110111FBBB111110111110.  */
{ "dmacwhu", 0x28370FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, LIMM }, { C_F }},

/* dmacwhu<.f><.cc> b,b,limm 00101bbb11110111FBBB1111100QQQQQ.  */
{ "dmacwhu", 0x28F70F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmacwhu<.f><.cc> 0,limm,c 0010111011110111F111CCCCCC0QQQQQ.  */
{ "dmacwhu", 0x2EF77000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmacwhu<.f> a,limm,u6 0010111001110111F111uuuuuuAAAAAA.  */
{ "dmacwhu", 0x2E777000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmacwhu<.f> 0,limm,u6 0010111001110111F111uuuuuu111110.  */
{ "dmacwhu", 0x2E77703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmacwhu<.f><.cc> 0,limm,u6 0010111011110111F111uuuuuu1QQQQQ.  */
{ "dmacwhu", 0x2EF77020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmacwhu<.f> 0,limm,s12 0010111010110111F111ssssssSSSSSS.  */
{ "dmacwhu", 0x2EB77000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmacwhu<.f> a,limm,limm 0010111000110111F111111110AAAAAA.  */
{ "dmacwhu", 0x2E377F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmacwhu<.f> 0,limm,limm 0010111000110111F111111110111110.  */
{ "dmacwhu", 0x2E377FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmacwhu<.f><.cc> 0,limm,limm 0010111011110111F1111111100QQQQQ.  */
{ "dmacwhu", 0x2EF77F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmb  00100011011011110001RRR000111111.  */
{ "dmb", 0x236F103F, 0xFFFFF1FF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { 0 }, { 0 }},

/* dmb u3 00100011011011110001RRRuuu111111.  */
{ "dmb", 0x236F103F, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { UIMM3_23 }, { 0 }},

/* dmpyh<.f> a,b,c 00101bbb00010000FBBBCCCCCCAAAAAA.  */
{ "dmpyh", 0x28100000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, RC }, { C_F }},

/* dmpyh<.f> 0,b,c 00101bbb00010000FBBBCCCCCC111110.  */
{ "dmpyh", 0x2810003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, RC }, { C_F }},

/* dmpyh<.f><.cc> b,b,c 00101bbb11010000FBBBCCCCCC0QQQQQ.  */
{ "dmpyh", 0x28D00000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmpyh<.f> a,b,u6 00101bbb01010000FBBBuuuuuuAAAAAA.  */
{ "dmpyh", 0x28500000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmpyh<.f> 0,b,u6 00101bbb01010000FBBBuuuuuu111110.  */
{ "dmpyh", 0x2850003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmpyh<.f><.cc> b,b,u6 00101bbb11010000FBBBuuuuuu1QQQQQ.  */
{ "dmpyh", 0x28D00020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmpyh<.f> b,b,s12 00101bbb10010000FBBBssssssSSSSSS.  */
{ "dmpyh", 0x28900000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmpyh<.f> a,limm,c 0010111000010000F111CCCCCCAAAAAA.  */
{ "dmpyh", 0x2E107000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, RC }, { C_F }},

/* dmpyh<.f> a,b,limm 00101bbb00010000FBBB111110AAAAAA.  */
{ "dmpyh", 0x28100F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, LIMM }, { C_F }},

/* dmpyh<.f> 0,limm,c 0010111000010000F111CCCCCC111110.  */
{ "dmpyh", 0x2E10703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, RC }, { C_F }},

/* dmpyh<.f> 0,b,limm 00101bbb00010000FBBB111110111110.  */
{ "dmpyh", 0x28100FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, LIMM }, { C_F }},

/* dmpyh<.f><.cc> b,b,limm 00101bbb11010000FBBB1111100QQQQQ.  */
{ "dmpyh", 0x28D00F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmpyh<.f><.cc> 0,limm,c 0010111011010000F111CCCCCC0QQQQQ.  */
{ "dmpyh", 0x2ED07000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmpyh<.f> a,limm,u6 0010111001010000F111uuuuuuAAAAAA.  */
{ "dmpyh", 0x2E507000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmpyh<.f> 0,limm,u6 0010111001010000F111uuuuuu111110.  */
{ "dmpyh", 0x2E50703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmpyh<.f><.cc> 0,limm,u6 0010111011010000F111uuuuuu1QQQQQ.  */
{ "dmpyh", 0x2ED07020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmpyh<.f> 0,limm,s12 0010111010010000F111ssssssSSSSSS.  */
{ "dmpyh", 0x2E907000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmpyh<.f> a,limm,limm 0010111000010000F111111110AAAAAA.  */
{ "dmpyh", 0x2E107F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmpyh<.f> 0,limm,limm 0010111000010000F111111110111110.  */
{ "dmpyh", 0x2E107FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmpyh<.f><.cc> 0,limm,limm 0010111011010000F1111111100QQQQQ.  */
{ "dmpyh", 0x2ED07F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmpyhu<.f> a,b,c 00101bbb00010001FBBBCCCCCCAAAAAA.  */
{ "dmpyhu", 0x28110000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, RC }, { C_F }},

/* dmpyhu<.f> 0,b,c 00101bbb00010001FBBBCCCCCC111110.  */
{ "dmpyhu", 0x2811003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, RC }, { C_F }},

/* dmpyhu<.f><.cc> b,b,c 00101bbb11010001FBBBCCCCCC0QQQQQ.  */
{ "dmpyhu", 0x28D10000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmpyhu<.f> a,b,u6 00101bbb01010001FBBBuuuuuuAAAAAA.  */
{ "dmpyhu", 0x28510000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmpyhu<.f> 0,b,u6 00101bbb01010001FBBBuuuuuu111110.  */
{ "dmpyhu", 0x2851003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmpyhu<.f><.cc> b,b,u6 00101bbb11010001FBBBuuuuuu1QQQQQ.  */
{ "dmpyhu", 0x28D10020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmpyhu<.f> b,b,s12 00101bbb10010001FBBBssssssSSSSSS.  */
{ "dmpyhu", 0x28910000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmpyhu<.f> a,limm,c 0010111000010001F111CCCCCCAAAAAA.  */
{ "dmpyhu", 0x2E117000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, RC }, { C_F }},

/* dmpyhu<.f> a,b,limm 00101bbb00010001FBBB111110AAAAAA.  */
{ "dmpyhu", 0x28110F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, LIMM }, { C_F }},

/* dmpyhu<.f> 0,limm,c 0010111000010001F111CCCCCC111110.  */
{ "dmpyhu", 0x2E11703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, RC }, { C_F }},

/* dmpyhu<.f> 0,b,limm 00101bbb00010001FBBB111110111110.  */
{ "dmpyhu", 0x28110FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, LIMM }, { C_F }},

/* dmpyhu<.f><.cc> b,b,limm 00101bbb11010001FBBB1111100QQQQQ.  */
{ "dmpyhu", 0x28D10F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmpyhu<.f><.cc> 0,limm,c 0010111011010001F111CCCCCC0QQQQQ.  */
{ "dmpyhu", 0x2ED17000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmpyhu<.f> a,limm,u6 0010111001010001F111uuuuuuAAAAAA.  */
{ "dmpyhu", 0x2E517000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmpyhu<.f> 0,limm,u6 0010111001010001F111uuuuuu111110.  */
{ "dmpyhu", 0x2E51703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmpyhu<.f><.cc> 0,limm,u6 0010111011010001F111uuuuuu1QQQQQ.  */
{ "dmpyhu", 0x2ED17020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmpyhu<.f> 0,limm,s12 0010111010010001F111ssssssSSSSSS.  */
{ "dmpyhu", 0x2E917000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmpyhu<.f> a,limm,limm 0010111000010001F111111110AAAAAA.  */
{ "dmpyhu", 0x2E117F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmpyhu<.f> 0,limm,limm 0010111000010001F111111110111110.  */
{ "dmpyhu", 0x2E117FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmpyhu<.f><.cc> 0,limm,limm 0010111011010001F1111111100QQQQQ.  */
{ "dmpyhu", 0x2ED17F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmpywh<.f> a,b,c 00101bbb00110010FBBBCCCCCCAAAAAA.  */
{ "dmpywh", 0x28320000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, RC }, { C_F }},

/* dmpywh<.f> 0,b,c 00101bbb00110010FBBBCCCCCC111110.  */
{ "dmpywh", 0x2832003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, RC }, { C_F }},

/* dmpywh<.f><.cc> b,b,c 00101bbb11110010FBBBCCCCCC0QQQQQ.  */
{ "dmpywh", 0x28F20000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmpywh<.f> a,b,u6 00101bbb01110010FBBBuuuuuuAAAAAA.  */
{ "dmpywh", 0x28720000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmpywh<.f> 0,b,u6 00101bbb01110010FBBBuuuuuu111110.  */
{ "dmpywh", 0x2872003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmpywh<.f><.cc> b,b,u6 00101bbb11110010FBBBuuuuuu1QQQQQ.  */
{ "dmpywh", 0x28F20020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmpywh<.f> b,b,s12 00101bbb10110010FBBBssssssSSSSSS.  */
{ "dmpywh", 0x28B20000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmpywh<.f> a,limm,c 0010111000110010F111CCCCCCAAAAAA.  */
{ "dmpywh", 0x2E327000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, RC }, { C_F }},

/* dmpywh<.f> a,b,limm 00101bbb00110010FBBB111110AAAAAA.  */
{ "dmpywh", 0x28320F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, LIMM }, { C_F }},

/* dmpywh<.f> 0,limm,c 0010111000110010F111CCCCCC111110.  */
{ "dmpywh", 0x2E32703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_F }},

/* dmpywh<.f> 0,b,limm 00101bbb00110010FBBB111110111110.  */
{ "dmpywh", 0x28320FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, LIMM }, { C_F }},

/* dmpywh<.f><.cc> b,b,limm 00101bbb11110010FBBB1111100QQQQQ.  */
{ "dmpywh", 0x28F20F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmpywh<.f><.cc> 0,limm,c 0010111011110010F111CCCCCC0QQQQQ.  */
{ "dmpywh", 0x2EF27000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmpywh<.f> a,limm,u6 0010111001110010F111uuuuuuAAAAAA.  */
{ "dmpywh", 0x2E727000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmpywh<.f> 0,limm,u6 0010111001110010F111uuuuuu111110.  */
{ "dmpywh", 0x2E72703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmpywh<.f><.cc> 0,limm,u6 0010111011110010F111uuuuuu1QQQQQ.  */
{ "dmpywh", 0x2EF27020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmpywh<.f> 0,limm,s12 0010111010110010F111ssssssSSSSSS.  */
{ "dmpywh", 0x2EB27000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmpywh<.f> a,limm,limm 0010111000110010F111111110AAAAAA.  */
{ "dmpywh", 0x2E327F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmpywh<.f> 0,limm,limm 0010111000110010F111111110111110.  */
{ "dmpywh", 0x2E327FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmpywh<.f><.cc> 0,limm,limm 0010111011110010F1111111100QQQQQ.  */
{ "dmpywh", 0x2EF27F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dmpywhu<.f> a,b,c 00101bbb00110011FBBBCCCCCCAAAAAA.  */
{ "dmpywhu", 0x28330000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, RC }, { C_F }},

/* dmpywhu<.f> 0,b,c 00101bbb00110011FBBBCCCCCC111110.  */
{ "dmpywhu", 0x2833003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, RC }, { C_F }},

/* dmpywhu<.f><.cc> b,b,c 00101bbb11110011FBBBCCCCCC0QQQQQ.  */
{ "dmpywhu", 0x28F30000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* dmpywhu<.f> a,b,u6 00101bbb01110011FBBBuuuuuuAAAAAA.  */
{ "dmpywhu", 0x28730000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* dmpywhu<.f> 0,b,u6 00101bbb01110011FBBBuuuuuu111110.  */
{ "dmpywhu", 0x2873003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { C_F }},

/* dmpywhu<.f><.cc> b,b,u6 00101bbb11110011FBBBuuuuuu1QQQQQ.  */
{ "dmpywhu", 0x28F30020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* dmpywhu<.f> b,b,s12 00101bbb10110011FBBBssssssSSSSSS.  */
{ "dmpywhu", 0x28B30000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* dmpywhu<.f> a,limm,c 0010111000110011F111CCCCCCAAAAAA.  */
{ "dmpywhu", 0x2E337000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, RC }, { C_F }},

/* dmpywhu<.f> a,b,limm 00101bbb00110011FBBB111110AAAAAA.  */
{ "dmpywhu", 0x28330F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, LIMM }, { C_F }},

/* dmpywhu<.f> 0,limm,c 0010111000110011F111CCCCCC111110.  */
{ "dmpywhu", 0x2E33703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_F }},

/* dmpywhu<.f> 0,b,limm 00101bbb00110011FBBB111110111110.  */
{ "dmpywhu", 0x28330FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, LIMM }, { C_F }},

/* dmpywhu<.f><.cc> b,b,limm 00101bbb11110011FBBB1111100QQQQQ.  */
{ "dmpywhu", 0x28F30F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* dmpywhu<.f><.cc> 0,limm,c 0010111011110011F111CCCCCC0QQQQQ.  */
{ "dmpywhu", 0x2EF37000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* dmpywhu<.f> a,limm,u6 0010111001110011F111uuuuuuAAAAAA.  */
{ "dmpywhu", 0x2E737000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* dmpywhu<.f> 0,limm,u6 0010111001110011F111uuuuuu111110.  */
{ "dmpywhu", 0x2E73703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* dmpywhu<.f><.cc> 0,limm,u6 0010111011110011F111uuuuuu1QQQQQ.  */
{ "dmpywhu", 0x2EF37020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* dmpywhu<.f> 0,limm,s12 0010111010110011F111ssssssSSSSSS.  */
{ "dmpywhu", 0x2EB37000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* dmpywhu<.f> a,limm,limm 0010111000110011F111111110AAAAAA.  */
{ "dmpywhu", 0x2E337F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* dmpywhu<.f> 0,limm,limm 0010111000110011F111111110111110.  */
{ "dmpywhu", 0x2E337FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F }},

/* dmpywhu<.f><.cc> 0,limm,limm 0010111011110011F1111111100QQQQQ.  */
{ "dmpywhu", 0x2EF37F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* dsync  00100010011011110001RRRRRR111111.  */
{ "dsync", 0x226F103F, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { 0 }, { 0 }},

/* ex<.di> b,c 00100bbb00101111DBBBCCCCCC001100.  */
{ "ex", 0x202F000C, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { RB, BRAKET, RC, BRAKETdup }, { C_DI16 }},

/* ex<.di> b,u6 00100bbb01101111DBBBuuuuuu001100.  */
{ "ex", 0x206F000C, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { RB, BRAKET, UIMM6_20, BRAKETdup }, { C_DI16 }},

/* ex<.di> b,limm 00100bbb00101111DBBB111110001100.  */
{ "ex", 0x202F0F8C, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { RB, BRAKET, LIMM, BRAKETdup }, { C_DI16 }},

/* ex<.di> limm,c 0010011000101111D111CCCCCC001100.  */
{ "ex", 0x262F700C, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { LIMM, BRAKET, RC, BRAKETdup }, { C_DI16 }},

/* ex<.di> limm,u6 0010011001101111D111uuuuuu001100.  */
{ "ex", 0x266F700C, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { LIMM, BRAKET, UIMM6_20, BRAKETdup }, { C_DI16 }},

/* ex<.di> limm,limm 0010011000101111D111111110001100.  */
{ "ex", 0x262F7F8C, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { LIMM, BRAKET, LIMMdup, BRAKETdup }, { C_DI16 }},

/* exl<.aq> RB,RC 01011bbb00101111FBBBcccccc001100.  */
{ "exl", 0x582F000C, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, BRAKET, RC, BRAKETdup }, { C_AQ, C_RL }},

/* extb<.f> b,c 00100bbb00101111FBBBCCCCCC000111.  */
{ "extb", 0x202F0007, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* extb<.f> 0,c 0010011000101111F111CCCCCC000111.  */
{ "extb", 0x262F7007, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RC }, { C_F }},

/* extb<.f> b,u6 00100bbb01101111FBBBuuuuuu000111.  */
{ "extb", 0x206F0007, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* extb<.f> 0,u6 0010011001101111F111uuuuuu000111.  */
{ "extb", 0x266F7007, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* extb<.f> b,limm 00100bbb00101111FBBB111110000111.  */
{ "extb", 0x202F0F87, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* extb<.f> 0,limm 0010011000101111F111111110000111.  */
{ "extb", 0x262F7F87, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* extb_s b,c 01111bbbccc01111.  */
{ "extb_s", 0x0000780F, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB_S, RC_S }, { 0 }},

/* exth<.f> b,c 00100bbb00101111FBBBCCCCCC001000.  */
{ "exth", 0x202F0008, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* exth<.f> 0,c 0010011000101111F111CCCCCC001000.  */
{ "exth", 0x262F7008, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RC }, { C_F }},

/* exth<.f> b,u6 00100bbb01101111FBBBuuuuuu001000.  */
{ "exth", 0x206F0008, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* exth<.f> 0,u6 0010011001101111F111uuuuuu001000.  */
{ "exth", 0x266F7008, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* exth<.f> b,limm 00100bbb00101111FBBB111110001000.  */
{ "exth", 0x202F0F88, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* exth<.f> 0,limm 0010011000101111F111111110001000.  */
{ "exth", 0x262F7F88, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* exth_s b,c 01111bbbccc10000.  */
{ "exth_s", 0x00007810, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB_S, RC_S }, { 0 }},

/* ffs<.f> b,c 00101bbb00101111FBBBCCCCCC010010.  */
{ "ffs", 0x282F0012, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* ffs<.f> 0,c 0010111000101111F111CCCCCC010010.  */
{ "ffs", 0x2E2F7012, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RC }, { C_F }},

/* ffs<.f> b,u6 00101bbb01101111FBBBuuuuuu010010.  */
{ "ffs", 0x286F0012, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* ffs<.f> 0,u6 0010111001101111F111uuuuuu010010.  */
{ "ffs", 0x2E6F7012, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* ffs<.f> b,limm 00101bbb00101111FBBB111110010010.  */
{ "ffs", 0x282F0F92, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* ffs<.f> 0,limm 0010111000101111F111111110010010.  */
{ "ffs", 0x2E2F7F92, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* ffsl<.f> RB,RC 01011bbb00101111FBBBcccccc010010.  */
{ "ffsl", 0x582F0012, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* ffsl<.f> 0,RC 0101111000101111F111cccccc010010.  */
{ "ffsl", 0x5E2F7012, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RC }, { C_F }},

/* ffsl<.f> RB,u6 01011bbb01101111FBBBuuuuuu010010.  */
{ "ffsl", 0x586F0012, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* ffsl<.f> 0,u6 0101111001101111F111uuuuuu010010.  */
{ "ffsl", 0x5E6F7012, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* ffsl<.f> RB,ximm 01011bbb00101111FBBB111100010010.  */
{ "ffsl", 0x582F0F12, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { C_F }},

/* ffsl<.f> 0,ximm 0101111000101111F111111100010010.  */
{ "ffsl", 0x5E2F7F12, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM }, { C_F }},

/* ffsl<.f> RB,limm 01011bbb00101111FBBB111110010010.  */
{ "ffsl", 0x582F0F92, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* ffsl<.f> 0,limm 0101111000101111F111111110010010.  */
{ "ffsl", 0x5E2F7F92, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* flag c 00100RRR001010010RRRCCCCCCRRRRRR.  */
{ "flag", 0x20290000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { RC }, { 0 }},

/* flag<.cc> c 00100RRR111010010RRRCCCCCC0QQQQQ.  */
{ "flag", 0x20E90000, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { RC }, { C_CC }},

/* flag u6 00100RRR011010010RRRuuuuuuRRRRRR.  */
{ "flag", 0x20690000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { UIMM6_20 }, { 0 }},

/* flag<.cc> u6 00100RRR111010010RRRuuuuuu1QQQQQ.  */
{ "flag", 0x20E90020, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { UIMM6_20 }, { C_CC }},

/* flag s12 00100RRR101010010RRRssssssSSSSSS.  */
{ "flag", 0x20A90000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { SIMM12_20 }, { 0 }},

/* flag limm 00100RRR001010010RRR111110RRRRRR.  */
{ "flag", 0x20290F80, 0xF8FF8FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { LIMM }, { 0 }},

/* flag<.cc> limm 00100RRR111010010RRR1111100QQQQQ.  */
{ "flag", 0x20E90F80, 0xF8FF8FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { LIMM }, { C_CC }},

/* fls<.f> b,c 00101bbb00101111FBBBCCCCCC010011.  */
{ "fls", 0x282F0013, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* fls<.f> 0,c 0010111000101111F111CCCCCC010011.  */
{ "fls", 0x2E2F7013, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RC }, { C_F }},

/* fls<.f> b,u6 00101bbb01101111FBBBuuuuuu010011.  */
{ "fls", 0x286F0013, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* fls<.f> 0,u6 0010111001101111F111uuuuuu010011.  */
{ "fls", 0x2E6F7013, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* fls<.f> b,limm 00101bbb00101111FBBB111110010011.  */
{ "fls", 0x282F0F93, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* fls<.f> 0,limm 0010111000101111F111111110010011.  */
{ "fls", 0x2E2F7F93, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* flsl<.f> RB,RC 01011bbb00101111FBBBcccccc010011.  */
{ "flsl", 0x582F0013, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* flsl<.f> 0,RC 0101111000101111F111cccccc010011.  */
{ "flsl", 0x5E2F7013, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RC }, { C_F }},

/* flsl<.f> RB,u6 01011bbb01101111FBBBuuuuuu010011.  */
{ "flsl", 0x586F0013, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* flsl<.f> 0,u6 0101111001101111F111uuuuuu010011.  */
{ "flsl", 0x5E6F7013, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* flsl<.f> RB,ximm 01011bbb00101111FBBB111100010011.  */
{ "flsl", 0x582F0F13, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { C_F }},

/* flsl<.f> 0,ximm 0101111000101111F111111100010011.  */
{ "flsl", 0x5E2F7F13, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM }, { C_F }},

/* flsl<.f> RB,limm 01011bbb00101111FBBB111110010011.  */
{ "flsl", 0x582F0F93, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* flsl<.f> 0,limm 0101111000101111F111111110010011.  */
{ "flsl", 0x5E2F7F93, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* j c 00100RRR00100000RRRRCCCCCCRRRRRR.  */
{ "j", 0x20200000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { BRAKET, RC, BRAKETdup }, { 0 }},

/* j BLINK 00100RRR00100000RRRR011111RRRRRR.  */
{ "j", 0x202007C0, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { BRAKET, BLINK, BRAKETdup }, { 0 }},

/* jcc c 00100RRR11100000RRRRCCCCCC0QQQQQ.  */
{ "j", 0x20E00000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, COND, { BRAKET, RC, BRAKETdup }, { C_CC }},

/* jcc BLINK 00100RRR11100000RRRR0111110QQQQQ.  */
{ "j", 0x20E007C0, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, COND, { BRAKET, BLINK, BRAKETdup }, { C_CC }},

/* j.D c 00100RRR00100001RRRRCCCCCCRRRRRR.  */
{ "j", 0x20210000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { BRAKET, RC, BRAKETdup }, { C_DHARD }},

/* j.D BLINK 00100RRR00100001RRRR011111RRRRRR.  */
{ "j", 0x202107C0, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { BRAKET, BLINK, BRAKETdup }, { C_DHARD }},

/* j.Dcc c 00100RRR11100001RRRRCCCCCC0QQQQQ.  */
{ "j", 0x20E10000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, COND, { BRAKET, RC, BRAKETdup }, { C_CC, C_DHARD }},

/* j.Dcc BLINK 00100RRR11100001RRRR0111110QQQQQ.  */
{ "j", 0x20E107C0, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, COND, { BRAKET, BLINK, BRAKETdup }, { C_CC, C_DHARD }},

/* j s12 00100RRR10100000RRRRssssssSSSSSS.  */
{ "j", 0x20A00000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { SIMM12_20 }, { 0 }},

/* j.D s12 00100RRR10100001RRRRssssssSSSSSS.  */
{ "j", 0x20A10000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { SIMM12_20 }, { C_DHARD }},

/* j u6 00100RRR01100000RRRRuuuuuuRRRRRR.  */
{ "j", 0x20600000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { UIMM6_20 }, { 0 }},

/* jcc u6 00100RRR11100000RRRRuuuuuu1QQQQQ.  */
{ "j", 0x20E00020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, COND, { UIMM6_20 }, { C_CC }},

/* j.D u6 00100RRR01100001RRRRuuuuuuRRRRRR.  */
{ "j", 0x20610000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { UIMM6_20 }, { C_DHARD }},

/* j.Dcc u6 00100RRR11100001RRRRuuuuuu1QQQQQ.  */
{ "j", 0x20E10020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, COND, { UIMM6_20 }, { C_CC, C_DHARD }},

/* j limm 00100RRR00100000RRRR111110RRRRRR.  */
{ "j", 0x20200F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { LIMM }, { 0 }},

/* jcc limm 00100RRR11100000RRRR1111100QQQQQ.  */
{ "j", 0x20E00F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, COND, { LIMM }, { C_CC }},

/* jeq_sCC_EQ BLINK 0111110011100000.  */
{ "jeq_s", 0x00007CE0, 0x0000FFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, COND, { BRAKET, BLINK_S, BRAKETdup }, { C_CC_EQ }},

/* jl c 00100RRR00100010RRRRCCCCCCRRRRRR.  */
{ "jl", 0x20220000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { BRAKET, RC, BRAKETdup }, { 0 }},

/* jlcc c 00100RRR11100010RRRRCCCCCC0QQQQQ.  */
{ "jl", 0x20E20000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { BRAKET, RC, BRAKETdup }, { C_CC }},

/* jl.D c 00100RRR00100011RRRRCCCCCCRRRRRR.  */
{ "jl", 0x20230000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { BRAKET, RC, BRAKETdup }, { C_DHARD }},

/* jl.Dcc c 00100RRR11100011RRRRCCCCCC0QQQQQ.  */
{ "jl", 0x20E30000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { BRAKET, RC, BRAKETdup }, { C_CC, C_DHARD }},

/* jl s12 00100RRR10100010RRRRssssssSSSSSS.  */
{ "jl", 0x20A20000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { SIMM12_20 }, { 0 }},

/* jl.D s12 00100RRR10100011RRRRssssssSSSSSS.  */
{ "jl", 0x20A30000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { SIMM12_20 }, { C_DHARD }},

/* jl u6 00100RRR01100010RRRRuuuuuuRRRRRR.  */
{ "jl", 0x20620000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { UIMM6_20 }, { 0 }},

/* jlcc u6 00100RRR11100010RRRRuuuuuu1QQQQQ.  */
{ "jl", 0x20E20020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { UIMM6_20 }, { C_CC }},

/* jl.D u6 00100RRR01100011RRRRuuuuuuRRRRRR.  */
{ "jl", 0x20630000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { UIMM6_20 }, { C_DHARD }},

/* jl.Dcc u6 00100RRR11100011RRRRuuuuuu1QQQQQ.  */
{ "jl", 0x20E30020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { UIMM6_20 }, { C_CC, C_DHARD }},

/* jl limm 00100RRR00100010RRRR111110RRRRRR.  */
{ "jl", 0x20220F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { LIMM }, { 0 }},

/* jlcc limm 00100RRR11100010RRRR1111100QQQQQ.  */
{ "jl", 0x20E20F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { LIMM }, { C_CC }},

/* jli_s u10 01010UUUUUUU1uuu.  */
{ "jli_s", 0x00005008, 0x0000F808, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JLI, NONE, { UIMM10_13_S }, { 0 }},

/* jl_s b 01111bbb01000000.  */
{ "jl_s", 0x00007840, 0x0000F8FF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { BRAKET, RB_S, BRAKETdup }, { 0 }},

/* jl_s.D b 01111bbb01100000.  */
{ "jl_s", 0x00007860, 0x0000F8FF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { BRAKET, RB_S, BRAKETdup }, { C_DHARD }},

/* jne_sCC_NE BLINK 0111110111100000.  */
{ "jne_s", 0x00007DE0, 0x0000FFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, COND, { BRAKET, BLINK_S, BRAKETdup }, { C_CC_NE }},

/* j_s b 01111bbb00000000.  */
{ "j_s", 0x00007800, 0x0000F8FF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { BRAKET, RB_S, BRAKETdup }, { 0 }},

/* j_s.D b 01111bbb00100000.  */
{ "j_s", 0x00007820, 0x0000F8FF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { BRAKET, RB_S, BRAKETdup }, { C_DHARD }},

/* j_s BLINK 0111111011100000.  */
{ "j_s", 0x00007EE0, 0x0000FFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { BRAKET, BLINK_S, BRAKETdup }, { 0 }},

/* j_s.D BLINK 0111111111100000.  */
{ "j_s", 0x00007FE0, 0x0000FFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, JUMP, NONE, { BRAKET, BLINK_S, BRAKETdup }, { C_DHARD }},

/* kflag c 00100RRR001010011RRRCCCCCCRRRRRR.  */
{ "kflag", 0x20298000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { RC }, { 0 }},

/* kflag<.cc> c 00100RRR111010011RRRCCCCCC0QQQQQ.  */
{ "kflag", 0x20E98000, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { RC }, { C_CC }},

/* kflag u6 00100RRR011010011RRRuuuuuuRRRRRR.  */
{ "kflag", 0x20698000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { UIMM6_20 }, { 0 }},

/* kflag<.cc> u6 00100RRR111010011RRRuuuuuu1QQQQQ.  */
{ "kflag", 0x20E98020, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { UIMM6_20 }, { C_CC }},

/* kflag s12 00100RRR101010011RRRssssssSSSSSS.  */
{ "kflag", 0x20A98000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { SIMM12_20 }, { 0 }},

/* kflag limm 00100RRR001010011RRR111110RRRRRR.  */
{ "kflag", 0x20298F80, 0xF8FF8FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { LIMM }, { 0 }},

/* kflag<.cc> limm 00100RRR111010011RRR1111100QQQQQ.  */
{ "kflag", 0x20E98F80, 0xF8FF8FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { LIMM }, { C_CC }},

/* ldZZ_W<.di><.aa> a,b 00010bbb000000000BBBDaa000AAAAAA.  */
{ "ld", 0x10000000, 0xF8FF81C0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, BRAKETdup }, { C_ZZ_W, C_DI20, C_AA21 }},

/* ldZZ_W<.di><.aa> a,b,c 00100bbbaa110000DBBBCCCCCCAAAAAA.  */
{ "ld", 0x20300000, 0xF83F0000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, RC, BRAKETdup }, { C_ZZ_W, C_DI16, C_AA8 }},

/* ldZZ_W<.di><.aa> 0,b,c 00100bbbaa110000DBBBCCCCCC111110.  */
{ "ld", 0x2030003E, 0xF83F003F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, RB, RC, BRAKETdup }, { C_ZZ_W, C_DI16, C_AA8 }},

/* ldZZ_W<.x><.aa> a,b 00010bbb000000000BBB0aa00XAAAAAA.  */
{ "ld", 0x10000000, 0xF8FF8980, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, BRAKETdup }, { C_ZZ_W, C_AA21, C_X25 }},

/* ldZZ_W<.x><.aa> a,b,c 00100bbbaa11000X0BBBCCCCCCAAAAAA.  */
{ "ld", 0x20300000, 0xF83E8000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, RC, BRAKETdup }, { C_ZZ_W, C_AA8, C_X15 }},

/* ldZZ_W<.x><.aa> 0,b,c 00100bbbaa11000X0BBBCCCCCC111110.  */
{ "ld", 0x2030003E, 0xF83E803F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, RB, RC, BRAKETdup }, { C_ZZ_W, C_AA8, C_X15 }},

/* ldZZ_W<.di><.aa> a,b,s9 00010bbbssssssssSBBBDaa000AAAAAA.  */
{ "ld", 0x10000000, 0xF80001C0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_ZZ_W, C_DI20, C_AA21 }},

/* ldZZ_W<.di><.aa> 0,b,s9 00010bbbssssssssSBBBDaa000111110.  */
{ "ld", 0x1000003E, 0xF80001FF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_ZZ_W, C_DI20, C_AA21 }},

/* ldZZ_W<.x><.aa> a,b,s9 00010bbbssssssssSBBB0aa00XAAAAAA.  */
{ "ld", 0x10000000, 0xF8000980, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_ZZ_W, C_AA21, C_X25 }},

/* ldZZ_W<.x><.aa> 0,b,s9 00010bbbssssssssSBBB0aa00X111110.  */
{ "ld", 0x1000003E, 0xF80009BF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_ZZ_W, C_AA21, C_X25 }},

/* ldZZ_W<.di> a,limm 00010110000000000111D00000AAAAAA.  */
{ "ld", 0x16007000, 0xFFFFF7C0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, LIMM, BRAKETdup }, { C_ZZ_W, C_DI20 }},

/* ldZZ_W<.di> 0,limm 00010110000000000111D00000111110.  */
{ "ld", 0x1600703E, 0xFFFFF7FF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, LIMM, BRAKETdup }, { C_ZZ_W, C_DI20 }},

/* ldZZ_W<.di><.aa> a,b,ximm 00100bbbaa110000DBBB111100AAAAAA.  */
{ "ld", 0x20300F00, 0xF83F0FC0, ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, XIMM, BRAKETdup }, { C_ZZ_W, C_DI16, C_AA8 }},

/* ldZZ_W<.di><.aa> a,b,limm 00100bbbaa110000DBBB111110AAAAAA.  */
{ "ld", 0x20300F80, 0xF83F0FC0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, LIMM, BRAKETdup }, { C_ZZ_W, C_DI16, C_AA8 }},

/* ldZZ_W<.di><.aa> a,ximm,c 00100100aa110000D111CCCCCCAAAAAA.  */
{ "ld", 0x24307000, 0xFF3F7000, ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, XIMM, RC, BRAKETdup }, { C_ZZ_W, C_DI16, C_AA8 }},

/* ldZZ_W<.di><.aa> a,limm,c 00100110aa110000D111CCCCCCAAAAAA.  */
{ "ld", 0x26307000, 0xFF3F7000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, LIMM, RC, BRAKETdup }, { C_ZZ_W, C_DI16, C_AA8 }},

/* ldZZ_W<.di><.aa> 0,b,limm 00100bbbaa110000DBBB111110111110.  */
{ "ld", 0x20300FBE, 0xF83F0FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, RB, LIMM, BRAKETdup }, { C_ZZ_W, C_DI16, C_AA8 }},

/* ldZZ_W<.di><.aa> 0,limm,c 00100110aa110000D111CCCCCC111110.  */
{ "ld", 0x2630703E, 0xFF3F703F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, LIMM, RC, BRAKETdup }, { C_ZZ_W, C_DI16, C_AA8 }},

/* ldZZ_W<.x> a,limm 0001011000000000011100000XAAAAAA.  */
{ "ld", 0x16007000, 0xFFFFFF80, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, LIMM, BRAKETdup }, { C_ZZ_W, C_X25 }},

/* ldZZ_W<.x> 0,limm 0001011000000000011100000X111110.  */
{ "ld", 0x1600703E, 0xFFFFFFBF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, LIMM, BRAKETdup }, { C_ZZ_W, C_X25 }},

/* ldZZ_W<.x><.aa> a,b,ximm 00100bbbaa11000X0BBB111100AAAAAA.  */
{ "ld", 0x20300F00, 0xF83E8FC0, ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, XIMM, BRAKETdup }, { C_ZZ_W, C_AA8, C_X15 }},

/* ldZZ_W<.x><.aa> a,b,limm 00100bbbaa11000X0BBB111110AAAAAA.  */
{ "ld", 0x20300F80, 0xF83E8FC0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, LIMM, BRAKETdup }, { C_ZZ_W, C_AA8, C_X15 }},

/* ldZZ_W<.x><.aa> a,ximm,c 00100100aa11000X0111CCCCCCAAAAAA.  */
{ "ld", 0x24307000, 0xFF3EF000, ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, XIMM, RC, BRAKETdup }, { C_ZZ_W, C_AA8, C_X15 }},

/* ldZZ_W<.x><.aa> a,limm,c 00100110aa11000X0111CCCCCCAAAAAA.  */
{ "ld", 0x26307000, 0xFF3EF000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, LIMM, RC, BRAKETdup }, { C_ZZ_W, C_AA8, C_X15 }},

/* ldZZ_W<.x><.aa> 0,b,limm 00100bbbaa11000X0BBB111110111110.  */
{ "ld", 0x20300FBE, 0xF83E8FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, RB, LIMM, BRAKETdup }, { C_ZZ_W, C_AA8, C_X15 }},

/* ldZZ_W<.di><.aa> a,limm,s9 00010110ssssssssS111Daa000AAAAAA.  */
{ "ld", 0x16007000, 0xFF0071C0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, LIMM, SIMM9_8, BRAKETdup }, { C_ZZ_W, C_DI20, C_AA21 }},

/* ldZZ_W<.di><.aa> 0,limm,s9 00010110ssssssssS111Daa000111110.  */
{ "ld", 0x1600703E, 0xFF0071FF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, LIMM, SIMM9_8, BRAKETdup }, { C_ZZ_W, C_DI20, C_AA21 }},

/* ldZZ_W<.x><.aa> a,limm,s9 00010110ssssssssS1110aa00XAAAAAA.  */
{ "ld", 0x16007000, 0xFF007980, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, LIMM, SIMM9_8, BRAKETdup }, { C_ZZ_W, C_AA21, C_X25 }},

/* ldZZ_W<.x><.aa> 0,limm,s9 00010110ssssssssS1110aa00X111110.  */
{ "ld", 0x1600703E, 0xFF0079BF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, LIMM, SIMM9_8, BRAKETdup }, { C_ZZ_W, C_AA21, C_X25 }},

/* ldZZ_W<.x><.aa> 0,limm,c 00100110aa11000X0111CCCCCC111110.  */
{ "ld", 0x2630703E, 0xFF3EF03F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, LIMM, RC }, { C_ZZ_W, C_AA8, C_X15 }},

/* ldbZZ_B<.x><.di><.aa> a,b 00010bbb000000000BBBDaa01XAAAAAA.  */
{ "ldb", 0x10000080, 0xF8FF8180, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, BRAKETdup }, { C_ZZ_B, C_DI20, C_AAB21, C_X25 }},

/* ldbZZ_B<.x><.di><.aa> a,b,c 00100bbbaa11001XDBBBCCCCCCAAAAAA.  */
{ "ldb", 0x20320000, 0xF83E0000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, RC, BRAKETdup }, { C_ZZ_B, C_DI16, C_AAB8, C_X15 }},

/* ldbZZ_B<.x><.di><.aa> 0,b,c 00100bbbaa11001XDBBBCCCCCC111110.  */
{ "ldb", 0x2032003E, 0xF83E003F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, RB, RC, BRAKETdup }, { C_ZZ_B, C_DI16, C_AAB8, C_X15 }},

/* ldbZZ_B<.x><.di><.aa> a,b,s9 00010bbbssssssssSBBBDaa01XAAAAAA.  */
{ "ldb", 0x10000080, 0xF8000180, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_ZZ_B, C_DI20, C_AAB21, C_X25 }},

/* ldbZZ_B<.x><.di><.aa> 0,b,s9 00010bbbssssssssSBBBDaa01X111110.  */
{ "ldb", 0x100000BE, 0xF80001BF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_ZZ_B, C_DI20, C_AAB21, C_X25 }},

/* ldbZZ_B<.x><.di> a,ximm 00010100000000000111D0001XAAAAAA.  */
{ "ldb", 0x14007080, 0xFFFFF780, ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, XIMM, BRAKETdup }, { C_ZZ_B, C_DI20, C_X25 }},
/* ldbZZ_B<.x><.di> a,limm 00010110000000000111D0001XAAAAAA.  */
{ "ldb", 0x16007080, 0xFFFFF780, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, LIMM, BRAKETdup }, { C_ZZ_B, C_DI20, C_X25 }},

/* ldbZZ_B<.x><.di> 0,limm 00010110000000000111D0001X111110.  */
{ "ldb", 0x160070BE, 0xFFFFF7BF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, LIMM, BRAKETdup }, { C_ZZ_B, C_DI20, C_X25 }},

/* ldbZZ_B<.x><.di><.aa> a,b,ximm 00100bbbaa11001XDBBB111100AAAAAA.  */
{ "ldb", 0x20320F00, 0xF83E0FC0, ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, XIMM, BRAKETdup }, { C_ZZ_B, C_DI16, C_AAB8, C_X15 }},
/* ldbZZ_B<.x><.di><.aa> a,b,limm 00100bbbaa11001XDBBB111110AAAAAA.  */
{ "ldb", 0x20320F80, 0xF83E0FC0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, LIMM, BRAKETdup }, { C_ZZ_B, C_DI16, C_AAB8, C_X15 }},

/* ldbZZ_B<.x><.di><.aa> a,ximm,c 00100100aa11001XD111CCCCCCAAAAAA.  */
{ "ldb", 0x24327000, 0xFF3E7000, ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, XIMM, RC, BRAKETdup }, { C_ZZ_B, C_DI16, C_AAB8, C_X15 }},
/* ldbZZ_B<.x><.di><.aa> a,limm,c 00100110aa11001XD111CCCCCCAAAAAA.  */
{ "ldb", 0x26327000, 0xFF3E7000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, LIMM, RC, BRAKETdup }, { C_ZZ_B, C_DI16, C_AAB8, C_X15 }},

/* ldbZZ_B<.x><.di><.aa> 0,b,limm 00100bbbaa11001XDBBB111110111110.  */
{ "ldb", 0x20320FBE, 0xF83E0FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, RB, LIMM, BRAKETdup }, { C_ZZ_B, C_DI16, C_AAB8, C_X15 }},

/* ldbZZ_B<.x><.di><.aa> 0,limm,c 00100110aa11001XD111CCCCCC111110.  */
{ "ldb", 0x2632703E, 0xFF3E703F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, LIMM, RC, BRAKETdup }, { C_ZZ_B, C_DI16, C_AAB8, C_X15 }},

/* ldbZZ_B<.x><.di><.aa> a,ximm,s9 00010100ssssssssS111Daa01XAAAAAA.  */
{ "ldb", 0x14007080, 0xFF007180, ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, XIMM, SIMM9_8, BRAKETdup }, { C_ZZ_B, C_DI20, C_AAB21, C_X25 }},
/* ldbZZ_B<.x><.di><.aa> a,limm,s9 00010110ssssssssS111Daa01XAAAAAA.  */
{ "ldb", 0x16007080, 0xFF007180, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, LIMM, SIMM9_8, BRAKETdup }, { C_ZZ_B, C_DI20, C_AAB21, C_X25 }},

/* ldbZZ_B<.x><.di><.aa> 0,limm,s9 00010110ssssssssS111Daa01X111110.  */
{ "ldb", 0x160070BE, 0xFF0071BF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, LIMM, SIMM9_8, BRAKETdup }, { C_ZZ_B, C_DI20, C_AAB21, C_X25 }},

/* ldhZZ_H<.x><.di><.aa> a,b 00010bbb000000000BBBDaa10XAAAAAA.  */
{ "ldh", 0x10000100, 0xF8FF8180, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, BRAKETdup }, { C_ZZ_H, C_DI20, C_AA21, C_X25 }},

/* ldhZZ_H<.x><.di><.aa> a,b,c 00100bbbaa11010XDBBBCCCCCCAAAAAA.  */
{ "ldh", 0x20340000, 0xF83E0000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, RC, BRAKETdup }, { C_ZZ_H, C_DI16, C_AA8, C_X15 }},

/* ldhZZ_H<.x><.di><.aa> 0,b,c 00100bbbaa11010XDBBBCCCCCC111110.  */
{ "ldh", 0x2034003E, 0xF83E003F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, RB, RC, BRAKETdup }, { C_ZZ_H, C_DI16, C_AA8, C_X15 }},

/* ldhZZ_H<.x><.di><.aa> a,b,s9 00010bbbssssssssSBBBDaa10XAAAAAA.  */
{ "ldh", 0x10000100, 0xF8000180, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_ZZ_H, C_DI20, C_AA21, C_X25 }},

/* ldhZZ_H<.x><.di><.aa> 0,b,s9 00010bbbssssssssSBBBDaa10X111110.  */
{ "ldh", 0x1000013E, 0xF80001BF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_ZZ_H, C_DI20, C_AA21, C_X25 }},

/* ldhZZ_H<.x><.di> a,limm 00010110000000000111D0010XAAAAAA.  */
{ "ldh", 0x16007100, 0xFFFFF780, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, LIMM, BRAKETdup }, { C_ZZ_H, C_DI20, C_X25 }},

/* ldhZZ_H<.x><.di> 0,limm 00010110000000000111D0010X111110.  */
{ "ldh", 0x1600713E, 0xFFFFF7BF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, LIMM, BRAKETdup }, { C_ZZ_H, C_DI20, C_X25 }},

/* ldhZZ_H<.x><.di><.aa> a,b,ximm 00100bbbaa11010XDBBB111100AAAAAA.  */
{ "ldh", 0x20340F00, 0xF83E0FC0, ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, XIMM, BRAKETdup }, { C_ZZ_H, C_DI16, C_AA8, C_X15 }},

/* ldhZZ_H<.x><.di><.aa> a,b,limm 00100bbbaa11010XDBBB111110AAAAAA.  */
{ "ldh", 0x20340F80, 0xF83E0FC0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, LIMM, BRAKETdup }, { C_ZZ_H, C_DI16, C_AA8, C_X15 }},

/* ldhZZ_H<.x><.di><.aa> a,ximm,c 00100100aa11010XD111CCCCCCAAAAAA.  */
{ "ldh", 0x24347000, 0xFF3E7000, ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, XIMM, RC, BRAKETdup }, { C_ZZ_H, C_DI16, C_AA8, C_X15 }},

/* ldhZZ_H<.x><.di><.aa> a,limm,c 00100110aa11010XD111CCCCCCAAAAAA.  */
{ "ldh", 0x26347000, 0xFF3E7000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, LIMM, RC, BRAKETdup }, { C_ZZ_H, C_DI16, C_AA8, C_X15 }},

/* ldhZZ_H<.x><.di><.aa> 0,b,limm 00100bbbaa11010XDBBB111110111110.  */
{ "ldh", 0x20340FBE, 0xF83E0FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, RB, LIMM, BRAKETdup }, { C_ZZ_H, C_DI16, C_AA8, C_X15 }},

/* ldhZZ_H<.x><.di><.aa> 0,limm,c 00100110aa11010XD111CCCCCC111110.  */
{ "ldh", 0x2634703E, 0xFF3E703F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, LIMM, RC, BRAKETdup }, { C_ZZ_H, C_DI16, C_AA8, C_X15 }},

/* ldhZZ_H<.x><.di><.aa> a,limm,s9 00010110ssssssssS111Daa10XAAAAAA.  */
{ "ldh", 0x16007100, 0xFF007180, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, LIMM, SIMM9_8, BRAKETdup }, { C_ZZ_H, C_DI20, C_AA21, C_X25 }},

/* ldhZZ_H<.x><.di><.aa> 0,limm,s9 00010110ssssssssS111Daa10X111110.  */
{ "ldh", 0x1600713E, 0xFF0071BF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, LIMM, SIMM9_8, BRAKETdup }, { C_ZZ_H, C_DI20, C_AA21, C_X25 }},


/* ldhZZ_H<.x><.di><.aa> a,b 00010bbb000000000BBBDaa10XAAAAAA.  */
{ "ldw", 0x10000100, 0xF8FF8180, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, BRAKETdup }, { C_ZZ_H, C_DI20, C_AA21, C_X25 }},

/* ldhZZ_H<.x><.di><.aa> a,b,c 00100bbbaa11010XDBBBCCCCCCAAAAAA.  */
{ "ldw", 0x20340000, 0xF83E0000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, RC, BRAKETdup }, { C_ZZ_H, C_DI16, C_AA8, C_X15 }},

/* ldhZZ_H<.x><.di><.aa> 0,b,c 00100bbbaa11010XDBBBCCCCCC111110.  */
{ "ldw", 0x2034003E, 0xF83E003F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, RB, RC, BRAKETdup }, { C_ZZ_H, C_DI16, C_AA8, C_X15 }},

/* ldhZZ_H<.x><.di><.aa> a,b,s9 00010bbbssssssssSBBBDaa10XAAAAAA.  */
{ "ldw", 0x10000100, 0xF8000180, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_ZZ_H, C_DI20, C_AA21, C_X25 }},

/* ldhZZ_H<.x><.di><.aa> 0,b,s9 00010bbbssssssssSBBBDaa10X111110.  */
{ "ldw", 0x1000013E, 0xF80001BF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_ZZ_H, C_DI20, C_AA21, C_X25 }},

/* ldhZZ_H<.x><.di> a,limm 00010110000000000111D0010XAAAAAA.  */
{ "ldw", 0x16007100, 0xFFFFF780, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, LIMM, BRAKETdup }, { C_ZZ_H, C_DI20, C_X25 }},

/* ldhZZ_H<.x><.di> 0,limm 00010110000000000111D0010X111110.  */
{ "ldw", 0x1600713E, 0xFFFFF7BF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, LIMM, BRAKETdup }, { C_ZZ_H, C_DI20, C_X25 }},

/* ldhZZ_H<.x><.di><.aa> a,b,ximm 00100bbbaa11010XDBBB111100AAAAAA.  */
{ "ldw", 0x20340F00, 0xF83E0FC0, ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, XIMM, BRAKETdup }, { C_ZZ_H, C_DI16, C_AA8, C_X15 }},

/* ldhZZ_H<.x><.di><.aa> a,b,limm 00100bbbaa11010XDBBB111110AAAAAA.  */
{ "ldw", 0x20340F80, 0xF83E0FC0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, LIMM, BRAKETdup }, { C_ZZ_H, C_DI16, C_AA8, C_X15 }},

/* ldhZZ_H<.x><.di><.aa> a,limm,c 00100100aa11010XD111CCCCCCAAAAAA.  */
{ "ldw", 0x24347000, 0xFF3E7000, ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, XIMM, RC, BRAKETdup }, { C_ZZ_H, C_DI16, C_AA8, C_X15 }},

/* ldhZZ_H<.x><.di><.aa> a,limm,c 00100110aa11010XD111CCCCCCAAAAAA.  */
{ "ldw", 0x26347000, 0xFF3E7000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, LIMM, RC, BRAKETdup }, { C_ZZ_H, C_DI16, C_AA8, C_X15 }},

/* ldhZZ_H<.x><.di><.aa> 0,b,limm 00100bbbaa11010XDBBB111110111110.  */
{ "ldw", 0x20340FBE, 0xF83E0FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, RB, LIMM, BRAKETdup }, { C_ZZ_H, C_DI16, C_AA8, C_X15 }},

/* ldhZZ_H<.x><.di><.aa> 0,limm,c 00100110aa11010XD111CCCCCC111110.  */
{ "ldw", 0x2634703E, 0xFF3E703F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, LIMM, RC, BRAKETdup }, { C_ZZ_H, C_DI16, C_AA8, C_X15 }},

/* ldhZZ_H<.x><.di><.aa> a,limm,s9 00010110ssssssssS111Daa10XAAAAAA.  */
{ "ldw", 0x16007100, 0xFF007180, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, LIMM, SIMM9_8, BRAKETdup }, { C_ZZ_H, C_DI20, C_AA21, C_X25 }},

/* ldhZZ_H<.x><.di><.aa> 0,limm,s9 00010110ssssssssS111Daa10X111110.  */
{ "ldw", 0x1600713E, 0xFF0071BF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, LIMM, SIMM9_8, BRAKETdup }, { C_ZZ_H, C_DI20, C_AA21, C_X25 }},

/* ldd<.aa><.di>  a,b      00010bbb000000000BBBDaa110AAAAAA -> ldd a,[b,s9=0]    */
/* ldd<.aa><.di>  a,b,s9   00010bbbssssssssSBBBDaa110AAAAAA -> ldd a,[b,s9]      */
/* ldd<.aa><.di>  a,limm   00010110000000000111Daa110AAAAAA -> ldd a,[b=62,s9=0] */
{ "ldd", 0x10000180, 0xF8FF81C0, ARC_OPCODE_ARC32, LOAD, NONE, { RAD, BRAKET, RB, BRAKETdup }, { C_DI20, C_AA21 }},
{ "ldd", 0x10000180, 0xF80001C0, ARC_OPCODE_ARC32, LOAD, NONE, { RAD, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_DI20, C_AA21 }},
{ "ldd", 0x16007180, 0xFFFFF1C0, ARC_OPCODE_ARC32, LOAD, NONE, { RAD, BRAKET, LIMM, BRAKETdup }, { C_DI20, C_AA21 }},

/* ldd<.aa><.di>  a,b,c    00100bbbaa110110DBBBCCCCCCAAAAAA -> ldd a,[b,c]    */
/* ldd<.aa><.di>  a,b,limm 00100bbbaa110110DBBB111110AAAAAA -> ldd a,[b,c=62] */
/* ldd<.aa><.di>  a,limm,c 00100110aa110110D111CCCCCCAAAAAA -> ldd a,[b=62,c] */
{ "ldd", 0x20360000, 0xF83F0000, ARC_OPCODE_ARC32, LOAD, NONE, { RAD, BRAKET, RB, RC, BRAKETdup }, { C_DI16, C_AA8 }},
{ "ldd", 0x20360F80, 0xF83F0FC0, ARC_OPCODE_ARC32, LOAD, NONE, { RAD, BRAKET, RB, LIMM, BRAKETdup }, { C_DI16, C_AA8 }},
{ "ldd", 0x26367000, 0xFF3F7000, ARC_OPCODE_ARC32, LOAD, NONE, { RAD, BRAKET, LIMM, RC, BRAKETdup }, { C_DI16, C_AA8 }},

/* lddl<.aa> a,b    00010bbb000000000BBBq1101QAAAAAA -> lddl a,[b,s9=0]     */
/* lddl<.aa> a,b,s9 00010bbbssssssssSBBBq1101QAAAAAA -> lddl a,[b,s9]       */
/* lddl<.as> a,ximm 00010100000000000111q1101QAAAAAA -> lddl a,[b=60,s9=0]  */
/* lddl<.as> a,limm 00010110000000000111q1101QAAAAAA -> lddl a,[b=62,s9=0]  */
{ "lddl", 0x10000680, 0xF8FF8780, ARC_OPCODE_ARC64, LOAD, NONE, { RAD, BRAKET, RB, BRAKETdup }, { C_AA_128S }},
{ "lddl", 0x10000680, 0xF8000780, ARC_OPCODE_ARC64, LOAD, NONE, { RAD, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_AA_128S }},

{ "lddl", 0x14007680, 0xFFFFF780, ARC_OPCODE_ARC64, LOAD, NONE, { RAD, BRAKET, XIMM, BRAKETdup }, { C_AS_128S }},
{ "lddl", 0x16007680, 0xFFFFF780, ARC_OPCODE_ARC64, LOAD, NONE, { RAD, BRAKET, LIMM, BRAKETdup }, { C_AS_128S }},

/* lddl<.aa> a,b,c    00100bbb1111001QQBBBCCCCCCAAAAAA -> lddl a,[b,c]     */
/* lddl<.aa> a,b,ximm 00100bbb1111001QQBBB111100AAAAAA -> lddl a,[b,c=60]  */
/* lddl<.aa> a,b,limm 00100bbb1111001QQBBB111110AAAAAA -> lddl a,[b,c=62]  */
/* lddl<.as> a,ximm,c 001001001111001QQ111CCCCCCAAAAAA -> lddl a,[b=60,c]  */
/* lddl<.as> a,limm,c 001001101111001QQ111CCCCCCAAAAAA -> lddl a,[b=62,c]  */
{ "lddl", 0x20F20000, 0xF8FE0000, ARC_OPCODE_ARC64, LOAD, NONE, { RAD, BRAKET, RB, RC, BRAKETdup }, { C_AA_128 }},

{ "lddl", 0x20F20F00, 0xF8FE0FC0, ARC_OPCODE_ARC64, LOAD, NONE, { RAD, BRAKET, RB, XIMM, BRAKETdup }, { C_AA_128 }},
{ "lddl", 0x20F20F80, 0xF8FE0FC0, ARC_OPCODE_ARC64, LOAD, NONE, { RAD, BRAKET, RB, LIMM, BRAKETdup }, { C_AA_128 }},

{ "lddl", 0x24F27000, 0xFFFE7000, ARC_OPCODE_ARC64, LOAD, NONE, { RAD, BRAKET, XIMM, RC, BRAKETdup }, { C_AS_128 }},
{ "lddl", 0x26F27000, 0xFFFE7000, ARC_OPCODE_ARC64, LOAD, NONE, { RAD, BRAKET, LIMM, RC, BRAKETdup }, { C_AS_128 }},


/* ldlZZ_L<.aa> a,b 00010bbb000000000BBB1aa001AAAAAA.  */
{ "ldl", 0x10000840, 0xF8FF89C0, ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, BRAKETdup }, { C_ZZ_L, C_AA21 }},

/* ldlZZ_L<.aa> 0,b 00010bbb000000000BBB1aa001111110.  */
{ "ldl", 0x1000087E, 0xF8FF89FF, ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, RB, BRAKETdup }, { C_ZZ_L, C_AA21 }},

/* ldlZZ_L<.aa> a,b,c 00100bbbaa1100011BBBCCCCCCAAAAAA.  */
{ "ldl", 0x20318000, 0xF83F8000, ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, RC, BRAKETdup }, { C_ZZ_L, C_AA8 }},

/* ldlZZ_L<.aa> 0,b,c 00100bbbaa1100011BBBCCCCCC111110.  */
{ "ldl", 0x2031803E, 0xF83F803F, ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, RB, RC, BRAKETdup }, { C_ZZ_L, C_AA8 }},

/* ldlZZ_L<.aa> a,b,s9 00010bbbssssssssSBBB1aa001AAAAAA.  */
{ "ldl", 0x10000840, 0xF80009C0, ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_ZZ_L, C_AA21 }},

/* ldlZZ_L<.aa> 0,b,s9 00010bbbssssssssSBBB1aa001111110.  */
{ "ldl", 0x1000087E, 0xF80009FF, ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_ZZ_L, C_AA21 }},

/* ldlZZ_L 0,limm 00010110000000000111100001111110.  */
{ "ldl", 0x1600787E, 0xFFFFFFFF, ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, LIMM, BRAKETdup }, { C_ZZ_L }},

/* ldlZZ_L a,limm 00010110000000000111100001AAAAAA.  */
{ "ldl", 0x16007840, 0xFFFFFFC0, ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, LIMM, BRAKETdup }, { C_ZZ_L }},

/* ldlZZ_L<.aa> a,b,ximm 00100bbbaa1100011BBB111100AAAAAA.  */
{ "ldl", 0x20318F00, 0xF83F8FC0, ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, XIMM, BRAKETdup }, { C_ZZ_L, C_AA8 }},

/* ldlZZ_L<.aa> a,b,limm 00100bbbaa1100011BBB111110AAAAAA.  */
{ "ldl", 0x20318F80, 0xF83F8FC0, ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, RB, LIMM, BRAKETdup }, { C_ZZ_L, C_AA8 }},

/* ldlZZ_L<.aa> 0,b,limm 00100bbbaa1100011BBB111110111110.  */
{ "ldl", 0x20318FBE, 0xF83F8FFF, ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, RB, LIMM, BRAKETdup }, { C_ZZ_L, C_AA8 }},

/* ldlZZ_L 0,limm,c 00100110001100011111CCCCCC111110.  */
{ "ldl", 0x2631F03E, 0xFFFFF03F, ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, LIMM, RC, BRAKETdup }, { C_ZZ_L }},

/* ldlZZ_L<.aa> a,ximm,c 00100100aa1100011111CCCCCCAAAAAA.  */
{ "ldl", 0x2431F000, 0xFF3FF000, ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, XIMM, RC, BRAKETdup }, { C_ZZ_L , C_AA8 }},

/* ldlZZ_L a,limm,c 00100110aa1100011111CCCCCCAAAAAA.  */
{ "ldl", 0x2631F000, 0xFF3FF000, ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, LO32, RC, BRAKETdup }, { C_ZZ_L, C_AA8 }},

/* ldlZZ_L<.aa> a,limm,s9 00010110ssssssssS1111aa001AAAAAA.  */
{ "ldl", 0x16007840, 0xFF0079C0, ARC_OPCODE_ARC64, LOAD, NONE, { RA_CHK, BRAKET, LO32, SIMM9_8, BRAKETdup }, { C_ZZ_L, C_AA21 }},

/* ldlZZ_L<.aa> 0,limm,s9 00010110ssssssssS1111aa001111110.  */
{ "ldl", 0x1600787E, 0xFF0079FF, ARC_OPCODE_ARC64, LOAD, NONE, { ZA, BRAKET, LIMM, SIMM9_8, BRAKETdup }, { C_ZZ_L, C_AA21 }},

/* ldb_sZZ_B a,b,c 01100bbbccc01aaa.  */
{ "ldb_s", 0x00006008, 0x0000F818,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_S, BRAKET, RB_S, RC_S, BRAKETdup }, { C_ZZ_B }},

/* ldb_sZZ_B c,b,u5 10001bbbcccuuuuu.  */
{ "ldb_s", 0x00008800, 0x0000F800,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RC_S, BRAKET, RB_S, UIMM5_11_S, BRAKETdup }, { C_ZZ_B }},

/* ldb_sZZ_B b,SP,u7 11000bbb001uuuuu.  */
{ "ldb_s", 0x0000C020, 0x0000F8E0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RB_S, BRAKET, SP_S, UIMM7_A32_11_S, BRAKETdup }, { C_ZZ_B }},

/* ldb_sZZ_B R0,GP,s9 1100101sssssssss.  */
{ "ldb_s", 0x0000CA00, 0x0000FE00,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { R0_S, BRAKET, GP_S, SIMM9_7_S, BRAKETdup }, { C_ZZ_B }},

/* ldh_sZZ_H a,b,c 01100bbbccc10aaa.  */
{ "ldh_s", 0x00006010, 0x0000F818,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_S, BRAKET, RB_S, RC_S, BRAKETdup }, { C_ZZ_H }},

/* ldh_sZZ_H c,b,u6 10010bbbcccuuuuu.  */
{ "ldh_s", 0x00009000, 0x0000F800,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RC_S, BRAKET, RB_S, UIMM6_A16_11_S, BRAKETdup }, { C_ZZ_H }},

/* ldh_sZZ_H.X c,b,u6 10011bbbcccuuuuu.  */
{ "ldh_s", 0x00009800, 0x0000F800,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RC_S, BRAKET, RB_S, UIMM6_A16_11_S, BRAKETdup }, { C_ZZ_H, C_XHARD }},

/* ldh_sZZ_H R0,GP,s10 1100110sssssssss.  */
{ "ldh_s", 0x0000CC00, 0x0000FE00,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { R0_S, BRAKET, GP_S, SIMM10_A16_7_Sbis, BRAKETdup }, { C_ZZ_H }},

/* ld_s a,b,c 01100bbbccc00aaa.  */
{ "ld_s", 0x00006000, 0x0000F818,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RA_S, BRAKET, RB_S, RC_S, BRAKETdup }, { 0 }},

/* ld_s.AS a,b,c 01001bbbccc00aaa.  */
{ "ld_s", 0x00004800, 0x0000F818,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, CD2, { RA_S, BRAKET, RB_S, RC_S, BRAKETdup }, { C_AS }},

/* ld_s b,SP,u7 11000bbb000uuuuu.  */
{ "ld_s", 0x0000C000, 0x0000F8E0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RB_S, BRAKET, SP_S, UIMM7_A32_11_S, BRAKETdup }, { 0 }},

/* ld_s c,b,u7 10000bbbcccuuuuu.  */
{ "ld_s", 0x00008000, 0x0000F800,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RC_S, BRAKET, RB_S, UIMM7_A32_11_S, BRAKETdup }, { 0 }},

/* ld_s b,PCL,u10 11010bbbuuuuuuuu.  */
{ "ld_s", 0x0000D000, 0x0000F800,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { RB_S, BRAKET, PCL_S, UIMM10_A32_8_S, BRAKETdup }, { 0 }},

/* ld_s R0,GP,s11 1100100sssssssss.  */
{ "ld_s", 0x0000C800, 0x0000FE00,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, NONE, { R0_S, BRAKET, GP_S, SIMM11_A32_7_S, BRAKETdup }, { 0 }},

/* ld_s R1,GP,s11 01010SSSSSS00sss.  */
{ "ld_s", 0x00005000, 0x0000F818,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOAD, CD2, { R1_S, BRAKET, GP_S, SIMM11_A32_13_S, BRAKETdup }, { 0 }},

/* llock<.di> b,c 00100bbb00101111DBBBCCCCCC010000.  */
{ "llock", 0x202F0010, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LLOCK, NONE, { RB, BRAKET, RC, BRAKETdup }, { C_DI16 }},

/* llock<.di> 0,c 0010011000101111D111CCCCCC010000.  */
{ "llock", 0x262F7010, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LLOCK, NONE, { ZA, BRAKET, RC, BRAKETdup }, { C_DI16 }},

/* llock<.di> b,u6 00100bbb01101111DBBBuuuuuu010000.  */
{ "llock", 0x206F0010, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LLOCK, NONE, { RB, BRAKET, UIMM6_20, BRAKETdup }, { C_DI16 }},

/* llock<.di> 0,u6 0010011001101111D111uuuuuu010000.  */
{ "llock", 0x266F7010, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LLOCK, NONE, { ZA, BRAKET, UIMM6_20, BRAKETdup }, { C_DI16 }},

/* llock<.di> b,limm 00100bbb00101111DBBB111110010000.  */
{ "llock", 0x202F0F90, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LLOCK, NONE, { RB, BRAKET, LIMM, BRAKETdup }, { C_DI16 }},

/* llock<.di> 0,limm 0010011000101111D111111110010000.  */
{ "llock", 0x262F7F90, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LLOCK, NONE, { ZA, BRAKET, LIMM, BRAKETdup }, { C_DI16 }},

/* llockl<.aq> RB,RC 01011bbb00101111FBBBcccccc010000.  */
{ "llockl", 0x582F0010, 0xF8FF003F, ARC_OPCODE_ARC64, LLOCK, NONE, { RB, BRAKET, RC, BRAKETdup }, { C_AQ }},

/* lr b,c 00100bbb00101010RBBBCCCCCCRRRRRR.  */
{ "lr", 0x202A0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, RC, BRAKETdup }, { 0 }},

/* lr 0,c 0010011000101010R111CCCCCCRRRRRR.  */
{ "lr", 0x262A7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { ZA, BRAKET, RC, BRAKETdup }, { 0 }},

/* lr b,u6 00100bbb01101010RBBBuuuuuu000000.  */
{ "lr", 0x206A0000, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, UIMM6_20, BRAKETdup }, { 0 }},

/* lr 0,u6 0010011001101010R111uuuuuu000000.  */
{ "lr", 0x266A7000, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { ZA, BRAKET, UIMM6_20, BRAKETdup }, { 0 }},

/* lr b,s12 00100bbb10101010RBBBssssssSSSSSS.  */
{ "lr", 0x20AA0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, SIMM12_20, BRAKETdup }, { 0 }},

/* lr 0,s12 0010011010101010R111ssssssSSSSSS.  */
{ "lr", 0x26AA7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { ZA, BRAKET, SIMM12_20, BRAKETdup }, { 0 }},

/* lr b,limm 00100bbb00101010RBBB111110RRRRRR.  */
{ "lr", 0x202A0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, LIMM, BRAKETdup }, { 0 }},

/* lr 0,limm 0010011000101010R111111110RRRRRR.  */
{ "lr", 0x262A7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { ZA, BRAKET, LIMM, BRAKETdup }, { 0 }},

/* lrl RB,RC 01011bbb001010100BBBccccccRRRRRR.  */
{ "lrl", 0x582A0000, 0xF8FF8000, ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, RC, BRAKETdup }, { 0 }},

/* lrl RB,u6 01011bbb011010100BBBuuuuuuRRRRRR.  */
{ "lrl", 0x586A0000, 0xF8FF8000, ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, UIMM6_20, BRAKETdup }, { 0 }},

/* lrl RB,s12 01011bbb101010100BBBssssssSSSSSS.  */
{ "lrl", 0x58AA0000, 0xF8FF8000, ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, SIMM12_20, BRAKETdup }, { 0 }},

/* lrl RB,ximm 01011bbb001010100BBB111100RRRRRR.  */
{ "lrl", 0x582A0F00, 0xF8FF8FC0,  ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, XIMM, BRAKETdup }, { 0 }},

/* lrl RB,limm 01011bbb001010100BBB111110RRRRRR.  */
{ "lrl", 0x582A0F80, 0xF8FF8FC0, ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, LIMM, BRAKETdup }, { 0 }},

/* lsl16<.f> b,c 00101bbb00101111FBBBCCCCCC001010.  */
{ "lsl16", 0x282F000A, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { RB, RC }, { C_F }},

/* lsl16<.f> 0,c 0010111000101111F111CCCCCC001010.  */
{ "lsl16", 0x2E2F700A, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { ZA, RC }, { C_F }},

/* lsl16<.f> b,u6 00101bbb01101111FBBBuuuuuu001010.  */
{ "lsl16", 0x286F000A, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { RB, UIMM6_20 }, { C_F }},

/* lsl16<.f> 0,u6 0010111001101111F111uuuuuu001010.  */
{ "lsl16", 0x2E6F700A, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { ZA, UIMM6_20 }, { C_F }},

/* lsl16<.f> b,limm 00101bbb00101111FBBB111110001010.  */
{ "lsl16", 0x282F0F8A, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { RB, LIMM }, { C_F }},

/* lsl16<.f> 0,limm 0010111000101111F111111110001010.  */
{ "lsl16", 0x2E2F7F8A, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { ZA, LIMM }, { C_F }},

/* lsl8<.f> b,c 00101bbb00101111FBBBCCCCCC001111.  */
{ "lsl8", 0x282F000F, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { RB, RC }, { C_F }},

/* lsl8<.f> 0,c 0010111000101111F111CCCCCC001111.  */
{ "lsl8", 0x2E2F700F, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { ZA, RC }, { C_F }},

/* lsl8<.f> b,u6 00101bbb01101111FBBBuuuuuu001111.  */
{ "lsl8", 0x286F000F, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { RB, UIMM6_20 }, { C_F }},

/* lsl8<.f> 0,u6 0010111001101111F111uuuuuu001111.  */
{ "lsl8", 0x2E6F700F, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { ZA, UIMM6_20 }, { C_F }},

/* lsl8<.f> b,limm 00101bbb00101111FBBB111110001111.  */
{ "lsl8", 0x282F0F8F, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { RB, LIMM }, { C_F }},

/* lsl8<.f> 0,limm 0010111000101111F111111110001111.  */
{ "lsl8", 0x2E2F7F8F, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { ZA, LIMM }, { C_F }},

/* lsr<.f> b,c 00100bbb00101111FBBBCCCCCC000010.  */
{ "lsr", 0x202F0002, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RC }, { C_F }},

/* lsr<.f> 0,c 0010011000101111F111CCCCCC000010.  */
{ "lsr", 0x262F7002, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RC }, { C_F }},

/* lsr<.f> a,b,c 00101bbb00000001FBBBCCCCCCAAAAAA.  */
{ "lsr", 0x28010000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, RB, RC }, { C_F }},

/* lsr<.f> 0,b,c 00101bbb00000001FBBBCCCCCC111110.  */
{ "lsr", 0x2801003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, RB, RC }, { C_F }},

/* lsr<.f><.cc> b,b,c 00101bbb11000001FBBBCCCCCC0QQQQQ.  */
{ "lsr", 0x28C10000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RB, RBdup, RC }, { C_F, C_CC }},

/* lsr<.f> b,u6 00100bbb01101111FBBBuuuuuu000010.  */
{ "lsr", 0x206F0002, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, UIMM6_20 }, { C_F }},

/* lsr<.f> 0,u6 0010011001101111F111uuuuuu000010.  */
{ "lsr", 0x266F7002, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, UIMM6_20 }, { C_F }},

/* lsr<.f> a,b,u6 00101bbb01000001FBBBuuuuuuAAAAAA.  */
{ "lsr", 0x28410000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, RB, UIMM6_20 }, { C_F }},

/* lsr<.f> 0,b,u6 00101bbb01000001FBBBuuuuuu111110.  */
{ "lsr", 0x2841003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, RB, UIMM6_20 }, { C_F }},

/* lsr<.f><.cc> b,b,u6 00101bbb11000001FBBBuuuuuu1QQQQQ.  */
{ "lsr", 0x28C10020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* lsr<.f> b,b,s12 00101bbb10000001FBBBssssssSSSSSS.  */
{ "lsr", 0x28810000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RB, RBdup, SIMM12_20 }, { C_F }},

/* lsr<.f> b,limm 00100bbb00101111FBBB111110000010.  */
{ "lsr", 0x202F0F82, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, LIMM }, { C_F }},

/* lsr<.f> 0,limm 0010011000101111F111111110000010.  */
{ "lsr", 0x262F7F82, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM }, { C_F }},

/* lsr<.f> a,limm,c 0010111000000001F111CCCCCCAAAAAA.  */
{ "lsr", 0x2E017000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, LIMM, RC }, { C_F }},

/* lsr<.f> a,b,limm 00101bbb00000001FBBB111110AAAAAA.  */
{ "lsr", 0x28010F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, RB, LIMM }, { C_F }},

/* lsr<.f> 0,limm,c 0010111000000001F111CCCCCC111110.  */
{ "lsr", 0x2E01703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, RC }, { C_F }},

/* lsr<.f> 0,b,limm 00101bbb00000001FBBB111110111110.  */
{ "lsr", 0x28010FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, RB, LIMM }, { C_F }},

/* lsr<.f><.cc> b,b,limm 00101bbb11000001FBBB1111100QQQQQ.  */
{ "lsr", 0x28C10F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* lsr<.f><.cc> 0,limm,c 0010111011000001F111CCCCCC0QQQQQ.  */
{ "lsr", 0x2EC17000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, RC }, { C_F, C_CC }},

/* lsr<.f> a,limm,u6 0010111001000001F111uuuuuuAAAAAA.  */
{ "lsr", 0x2E417000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, LIMM, UIMM6_20 }, { C_F }},

/* lsr<.f> 0,limm,u6 0010111001000001F111uuuuuu111110.  */
{ "lsr", 0x2E41703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* lsr<.f><.cc> 0,limm,u6 0010111011000001F111uuuuuu1QQQQQ.  */
{ "lsr", 0x2EC17020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* lsr<.f> 0,limm,s12 0010111010000001F111ssssssSSSSSS.  */
{ "lsr", 0x2E817000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* lsr<.f> a,limm,limm 0010111000000001F111111110AAAAAA.  */
{ "lsr", 0x2E017F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, LIMM, LIMMdup }, { C_F }},

/* lsr<.f> 0,limm,limm 0010111000000001F111111110111110.  */
{ "lsr", 0x2E017FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, LIMMdup }, { C_F }},

/* lsr<.f><.cc> 0,limm,limm 0010111011000001F1111111100QQQQQ.  */
{ "lsr", 0x2EC17F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* lsr16<.f> b,c 00101bbb00101111FBBBCCCCCC001011.  */
{ "lsr16", 0x282F000B, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { RB, RC }, { C_F }},

/* lsr16<.f> 0,c 0010111000101111F111CCCCCC001011.  */
{ "lsr16", 0x2E2F700B, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { ZA, RC }, { C_F }},

/* lsr16<.f> b,u6 00101bbb01101111FBBBuuuuuu001011.  */
{ "lsr16", 0x286F000B, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { RB, UIMM6_20 }, { C_F }},

/* lsr16<.f> 0,u6 0010111001101111F111uuuuuu001011.  */
{ "lsr16", 0x2E6F700B, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { ZA, UIMM6_20 }, { C_F }},

/* lsr16<.f> b,limm 00101bbb00101111FBBB111110001011.  */
{ "lsr16", 0x282F0F8B, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { RB, LIMM }, { C_F }},

/* lsr16<.f> 0,limm 0010111000101111F111111110001011.  */
{ "lsr16", 0x2E2F7F8B, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { ZA, LIMM }, { C_F }},

/* lsr8<.f> b,c 00101bbb00101111FBBBCCCCCC001110.  */
{ "lsr8", 0x282F000E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { RB, RC }, { C_F }},

/* lsr8<.f> 0,c 0010111000101111F111CCCCCC001110.  */
{ "lsr8", 0x2E2F700E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { ZA, RC }, { C_F }},

/* lsr8<.f> b,u6 00101bbb01101111FBBBuuuuuu001110.  */
{ "lsr8", 0x286F000E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { RB, UIMM6_20 }, { C_F }},

/* lsr8<.f> 0,u6 0010111001101111F111uuuuuu001110.  */
{ "lsr8", 0x2E6F700E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { ZA, UIMM6_20 }, { C_F }},

/* lsr8<.f> b,limm 00101bbb00101111FBBB111110001110.  */
{ "lsr8", 0x282F0F8E, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { RB, LIMM }, { C_F }},

/* lsr8<.f> 0,limm 0010111000101111F111111110001110.  */
{ "lsr8", 0x2E2F7F8E, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT1, { ZA, LIMM }, { C_F }},

/* lsrl<.f> RA,RB,RC 01011bbb00100001FBBBccccccaaaaaa.  */
{ "lsrl", 0x58210000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* lsrl<.f> 0,RB,RC 01011bbb00100001FBBBcccccc111110.  */
{ "lsrl", 0x5821003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* lsrl<.f><.cc> RB,RB,RC 01011bbb11100001FBBBcccccc0QQQQQ.  */
{ "lsrl", 0x58E10000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* lsrl<.f> RA,RB,u6 01011bbb01100001FBBBuuuuuuaaaaaa.  */
{ "lsrl", 0x58610000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* lsrl<.f> 0,RB,u6 01011bbb01100001FBBBuuuuuu111110.  */
{ "lsrl", 0x5861003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* lsrl<.f><.cc> RB,RB,u6 01011bbb11100001FBBBuuuuuu1QQQQQ.  */
{ "lsrl", 0x58E10020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* lsrl<.f> RB,RB,s12 01011bbb10100001FBBBssssssSSSSSS.  */
{ "lsrl", 0x58A10000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* lsrl<.f> RA,ximm,RC 0101110000100001F111ccccccaaaaaa.  */
{ "lsrl", 0x5C217000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* lsrl<.f> RA,RB,ximm 01011bbb00100001FBBB111100aaaaaa.  */
{ "lsrl", 0x58210F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* lsrl<.f> 0,ximm,RC 0101110000100001F111cccccc111110.  */
{ "lsrl", 0x5C21703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* lsrl<.f> 0,RB,ximm 01011bbb00100001FBBB111100111110.  */
{ "lsrl", 0x58210F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* lsrl<.f><.cc> 0,ximm,RC 0101110011100001F111cccccc0QQQQQ.  */
{ "lsrl", 0x5CE17000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* lsrl<.f><.cc> RB,RB,ximm 01011bbb11100001FBBB1111000QQQQQ.  */
{ "lsrl", 0x58E10F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* lsrl<.f> RA,ximm,u6 0101110001100001F111uuuuuuaaaaaa.  */
{ "lsrl", 0x5C617000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* lsrl<.f> 0,ximm,u6 0101110001100001F111uuuuuu111110.  */
{ "lsrl", 0x5C61703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* lsrl<.f><.cc> 0,ximm,u6 0101110011100001F111uuuuuu1QQQQQ.  */
{ "lsrl", 0x5CE17020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* lsrl<.f> RA,limm,RC 0101111000100001F111ccccccaaaaaa.  */
{ "lsrl", 0x5E217000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* lsrl<.f> RA,RB,limm 01011bbb00100001FBBB111110aaaaaa.  */
{ "lsrl", 0x58210F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* lsrl<.f> 0,limm,RC 0101111000100001F111cccccc111110.  */
{ "lsrl", 0x5E21703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* lsrl<.f> 0,RB,limm 01011bbb00100001FBBB111110111110.  */
{ "lsrl", 0x58210FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* lsrl<.f><.cc> 0,limm,RC 0101111011100001F111cccccc0QQQQQ.  */
{ "lsrl", 0x5EE17000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* lsrl<.f><.cc> RB,RB,limm 01011bbb11100001FBBB1111100QQQQQ.  */
{ "lsrl", 0x58E10F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* lsrl<.f> RA,limm,u6 0101111001100001F111uuuuuuaaaaaa.  */
{ "lsrl", 0x5E617000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* lsrl<.f> 0,limm,u6 0101111001100001F111uuuuuu111110.  */
{ "lsrl", 0x5E61703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* lsrl<.f><.cc> 0,limm,u6 0101111011100001F111uuuuuu1QQQQQ.  */
{ "lsrl", 0x5EE17020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* lsrl<.f> 0,ximm,s12 0101110010100001F111ssssssSSSSSS.  */
{ "lsrl", 0x5CA17000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* lsrl<.f> 0,limm,s12 0101111010100001F111ssssssSSSSSS.  */
{ "lsrl", 0x5EA17000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* lsrl<.f> RA,ximm,ximm 0101110000100001F111111100aaaaaa.  */
{ "lsrl", 0x5C217F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* lsrl<.f> 0,ximm,ximm 0101110000100001F111111100111110.  */
{ "lsrl", 0x5C217F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* lsrl<.f><.cc> 0,ximm,ximm 0101110011100001F1111111000QQQQQ.  */
{ "lsrl", 0x5CE17F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* lsrl<.f> RA,limm,limm 0101111000100001F111111110aaaaaa.  */
{ "lsrl", 0x5E217F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* lsrl<.f> 0,limm,limm 0101111000100001F111111110111110.  */
{ "lsrl", 0x5E217FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* lsrl<.f><.cc> 0,limm,limm 0101111011100001F1111111100QQQQQ.  */
{ "lsrl", 0x5EE17F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* lsr_s b,c 01111bbbccc11101.  */
{ "lsr_s", 0x0000781D, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB_S, RC_S }, { 0 }},

/* lsr_s b,b,c 01111bbbccc11001.  */
{ "lsr_s", 0x00007819, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* lsr_s b,b,u5 10111bbb001uuuuu.  */
{ "lsr_s", 0x0000B820, 0x0000F8E0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RB_S, RB_Sdup, UIMM5_11_S }, { 0 }},

/* lstl<.f> RB,RC 01011bbb00101111FBBBcccccc000010.  */
{ "lstl", 0x582F0002, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* lstl<.f> 0,RC 0101111000101111F111cccccc000010.  */
{ "lstl", 0x5E2F7002, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RC }, { C_F }},

/* lstl<.f> RB,u6 01011bbb01101111FBBBuuuuuu000010.  */
{ "lstl", 0x586F0002, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* lstl<.f> 0,u6 0101111001101111F111uuuuuu000010.  */
{ "lstl", 0x5E6F7002, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* lstl<.f> RB,ximm 01011bbb00101111FBBB111100000010.  */
{ "lstl", 0x582F0F02, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { C_F }},

/* lstl<.f> 0,ximm 0101111000101111F111111100000010.  */
{ "lstl", 0x5E2F7F02, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM }, { C_F }},

/* lstl<.f> RB,limm 01011bbb00101111FBBB111110000010.  */
{ "lstl", 0x582F0F82, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* lstl<.f> 0,limm 0101111000101111F111111110000010.  */
{ "lstl", 0x5E2F7F82, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* mac<.f> a,b,c 00101bbb00001110FBBBCCCCCCAAAAAA.  */
{ "mac", 0x280E0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, RC }, { C_F }},

/* mac<.f> 0,b,c 00101bbb00001110FBBBCCCCCC111110.  */
{ "mac", 0x280E003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, RC }, { C_F }},

/* mac<.f><.cc> b,b,c 00101bbb11001110FBBBCCCCCC0QQQQQ.  */
{ "mac", 0x28CE0000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mac<.f> a,b,u6 00101bbb01001110FBBBuuuuuuAAAAAA.  */
{ "mac", 0x284E0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mac<.f> 0,b,u6 00101bbb01001110FBBBuuuuuu111110.  */
{ "mac", 0x284E003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, UIMM6_20 }, { C_F }},

/* mac<.f><.cc> b,b,u6 00101bbb11001110FBBBuuuuuu1QQQQQ.  */
{ "mac", 0x28CE0020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mac<.f> b,b,s12 00101bbb10001110FBBBssssssSSSSSS.  */
{ "mac", 0x288E0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mac<.f> a,limm,c 0010111000001110F111CCCCCCAAAAAA.  */
{ "mac", 0x2E0E7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, RC }, { C_F }},

/* mac<.f> a,b,limm 00101bbb00001110FBBB111110AAAAAA.  */
{ "mac", 0x280E0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, LIMM }, { C_F }},

/* mac<.f> 0,limm,c 0010111000001110F111CCCCCC111110.  */
{ "mac", 0x2E0E703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, RC }, { C_F }},

/* mac<.f> 0,b,limm 00101bbb00001110FBBB111110111110.  */
{ "mac", 0x280E0FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, LIMM }, { C_F }},

/* mac<.f><.cc> b,b,limm 00101bbb11001110FBBB1111100QQQQQ.  */
{ "mac", 0x28CE0F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mac<.f><.cc> 0,limm,c 0010111011001110F111CCCCCC0QQQQQ.  */
{ "mac", 0x2ECE7000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mac<.f> a,limm,u6 0010111001001110F111uuuuuuAAAAAA.  */
{ "mac", 0x2E4E7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mac<.f> 0,limm,u6 0010111001001110F111uuuuuu111110.  */
{ "mac", 0x2E4E703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mac<.f><.cc> 0,limm,u6 0010111011001110F111uuuuuu1QQQQQ.  */
{ "mac", 0x2ECE7020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mac<.f> 0,limm,s12 0010111010001110F111ssssssSSSSSS.  */
{ "mac", 0x2E8E7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mac<.f> a,limm,limm 0010111000001110F111111110AAAAAA.  */
{ "mac", 0x2E0E7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mac<.f> 0,limm,limm 0010111000001110F111111110111110.  */
{ "mac", 0x2E0E7FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F }},

/* mac<.f><.cc> 0,limm,limm 0010111011001110F1111111100QQQQQ.  */
{ "mac", 0x2ECE7F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* macd<.f> a,b,c 00101bbb00011010FBBBCCCCCCAAAAAA.  */
{ "macd", 0x281A0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, RB, RC }, { C_F }},

/* macd<.f> 0,b,c 00101bbb00011010FBBBCCCCCC111110.  */
{ "macd", 0x281A003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, RB, RC }, { C_F }},

/* macd<.f><.cc> b,b,c 00101bbb11011010FBBBCCCCCC0QQQQQ.  */
{ "macd", 0x28DA0000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* macd<.f> a,b,u6 00101bbb01011010FBBBuuuuuuAAAAAA.  */
{ "macd", 0x285A0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* macd<.f> 0,b,u6 00101bbb01011010FBBBuuuuuu111110.  */
{ "macd", 0x285A003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, RB, UIMM6_20 }, { C_F }},

/* macd<.f><.cc> b,b,u6 00101bbb11011010FBBBuuuuuu1QQQQQ.  */
{ "macd", 0x28DA0020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* macd<.f> b,b,s12 00101bbb10011010FBBBssssssSSSSSS.  */
{ "macd", 0x289A0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* macd<.f> a,limm,c 0010111000011010F111CCCCCCAAAAAA.  */
{ "macd", 0x2E1A7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, LIMM, RC }, { C_F }},

/* macd<.f> a,b,limm 00101bbb00011010FBBB111110AAAAAA.  */
{ "macd", 0x281A0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, RB, LIMM }, { C_F }},

/* macd<.f> 0,limm,c 0010111000011010F111CCCCCC111110.  */
{ "macd", 0x2E1A703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, RC }, { C_F }},

/* macd<.f> 0,b,limm 00101bbb00011010FBBB111110111110.  */
{ "macd", 0x281A0FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, RB, LIMM }, { C_F }},

/* macd<.f><.cc> b,b,limm 00101bbb11011010FBBB1111100QQQQQ.  */
{ "macd", 0x28DA0F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* macd<.f><.cc> 0,limm,c 0010111011011010F111CCCCCC0QQQQQ.  */
{ "macd", 0x2EDA7000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* macd<.f> a,limm,u6 0010111001011010F111uuuuuuAAAAAA.  */
{ "macd", 0x2E5A7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* macd<.f> 0,limm,u6 0010111001011010F111uuuuuu111110.  */
{ "macd", 0x2E5A703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* macd<.f><.cc> 0,limm,u6 0010111011011010F111uuuuuu1QQQQQ.  */
{ "macd", 0x2EDA7020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* macd<.f> 0,limm,s12 0010111010011010F111ssssssSSSSSS.  */
{ "macd", 0x2E9A7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* macd<.f> a,limm,limm 0010111000011010F111111110AAAAAA.  */
{ "macd", 0x2E1A7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* macd<.f> 0,limm,limm 0010111000011010F111111110111110.  */
{ "macd", 0x2E1A7FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, LIMMdup }, { C_F }},

/* macd<.f><.cc> 0,limm,limm 0010111011011010F1111111100QQQQQ.  */
{ "macd", 0x2EDA7F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* macdu<.f> a,b,c 00101bbb00011011FBBBCCCCCCAAAAAA.  */
{ "macdu", 0x281B0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, RB, RC }, { C_F }},

/* macdu<.f> 0,b,c 00101bbb00011011FBBBCCCCCC111110.  */
{ "macdu", 0x281B003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, RB, RC }, { C_F }},

/* macdu<.f><.cc> b,b,c 00101bbb11011011FBBBCCCCCC0QQQQQ.  */
{ "macdu", 0x28DB0000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* macdu<.f> a,b,u6 00101bbb01011011FBBBuuuuuuAAAAAA.  */
{ "macdu", 0x285B0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* macdu<.f> 0,b,u6 00101bbb01011011FBBBuuuuuu111110.  */
{ "macdu", 0x285B003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, RB, UIMM6_20 }, { C_F }},

/* macdu<.f><.cc> b,b,u6 00101bbb11011011FBBBuuuuuu1QQQQQ.  */
{ "macdu", 0x28DB0020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* macdu<.f> b,b,s12 00101bbb10011011FBBBssssssSSSSSS.  */
{ "macdu", 0x289B0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* macdu<.f> a,limm,c 0010111000011011F111CCCCCCAAAAAA.  */
{ "macdu", 0x2E1B7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, LIMM, RC }, { C_F }},

/* macdu<.f> a,b,limm 00101bbb00011011FBBB111110AAAAAA.  */
{ "macdu", 0x281B0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, RB, LIMM }, { C_F }},

/* macdu<.f> 0,limm,c 0010111000011011F111CCCCCC111110.  */
{ "macdu", 0x2E1B703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, RC }, { C_F }},

/* macdu<.f> 0,b,limm 00101bbb00011011FBBB111110111110.  */
{ "macdu", 0x281B0FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, RB, LIMM }, { C_F }},

/* macdu<.f><.cc> b,b,limm 00101bbb11011011FBBB1111100QQQQQ.  */
{ "macdu", 0x28DB0F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* macdu<.f><.cc> 0,limm,c 0010111011011011F111CCCCCC0QQQQQ.  */
{ "macdu", 0x2EDB7000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* macdu<.f> a,limm,u6 0010111001011011F111uuuuuuAAAAAA.  */
{ "macdu", 0x2E5B7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* macdu<.f> 0,limm,u6 0010111001011011F111uuuuuu111110.  */
{ "macdu", 0x2E5B703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* macdu<.f><.cc> 0,limm,u6 0010111011011011F111uuuuuu1QQQQQ.  */
{ "macdu", 0x2EDB7020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* macdu<.f> 0,limm,s12 0010111010011011F111ssssssSSSSSS.  */
{ "macdu", 0x2E9B7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* macdu<.f> a,limm,limm 0010111000011011F111111110AAAAAA.  */
{ "macdu", 0x2E1B7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* macdu<.f> 0,limm,limm 0010111000011011F111111110111110.  */
{ "macdu", 0x2E1B7FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, LIMMdup }, { C_F }},

/* macdu<.f><.cc> 0,limm,limm 0010111011011011F1111111100QQQQQ.  */
{ "macdu", 0x2EDB7F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* macu<.f> a,b,c 00101bbb00001111FBBBCCCCCCAAAAAA.  */
{ "macu", 0x280F0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, RC }, { C_F }},

/* macu<.f> 0,b,c 00101bbb00001111FBBBCCCCCC111110.  */
{ "macu", 0x280F003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, RC }, { C_F }},

/* macu<.f><.cc> b,b,c 00101bbb11001111FBBBCCCCCC0QQQQQ.  */
{ "macu", 0x28CF0000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* macu<.f> a,b,u6 00101bbb01001111FBBBuuuuuuAAAAAA.  */
{ "macu", 0x284F0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* macu<.f> 0,b,u6 00101bbb01001111FBBBuuuuuu111110.  */
{ "macu", 0x284F003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, UIMM6_20 }, { C_F }},

/* macu<.f><.cc> b,b,u6 00101bbb11001111FBBBuuuuuu1QQQQQ.  */
{ "macu", 0x28CF0020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* macu<.f> b,b,s12 00101bbb10001111FBBBssssssSSSSSS.  */
{ "macu", 0x288F0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* macu<.f> a,limm,c 0010111000001111F111CCCCCCAAAAAA.  */
{ "macu", 0x2E0F7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, RC }, { C_F }},

/* macu<.f> a,b,limm 00101bbb00001111FBBB111110AAAAAA.  */
{ "macu", 0x280F0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, LIMM }, { C_F }},

/* macu<.f> 0,limm,c 0010111000001111F111CCCCCC111110.  */
{ "macu", 0x2E0F703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, RC }, { C_F }},

/* macu<.f> 0,b,limm 00101bbb00001111FBBB111110111110.  */
{ "macu", 0x280F0FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, LIMM }, { C_F }},

/* macu<.f><.cc> b,b,limm 00101bbb11001111FBBB1111100QQQQQ.  */
{ "macu", 0x28CF0F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* macu<.f><.cc> 0,limm,c 0010111011001111F111CCCCCC0QQQQQ.  */
{ "macu", 0x2ECF7000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* macu<.f> a,limm,u6 0010111001001111F111uuuuuuAAAAAA.  */
{ "macu", 0x2E4F7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* macu<.f> 0,limm,u6 0010111001001111F111uuuuuu111110.  */
{ "macu", 0x2E4F703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* macu<.f><.cc> 0,limm,u6 0010111011001111F111uuuuuu1QQQQQ.  */
{ "macu", 0x2ECF7020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* macu<.f> 0,limm,s12 0010111010001111F111ssssssSSSSSS.  */
{ "macu", 0x2E8F7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* macu<.f> a,limm,limm 0010111000001111F111111110AAAAAA.  */
{ "macu", 0x2E0F7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* macu<.f> 0,limm,limm 0010111000001111F111111110111110.  */
{ "macu", 0x2E0F7FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F }},

/* macu<.f><.cc> 0,limm,limm 0010111011001111F1111111100QQQQQ.  */
{ "macu", 0x2ECF7F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* max<.f> a,b,c 00100bbb00001000FBBBCCCCCCAAAAAA.  */
{ "max", 0x20080000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* max<.f> 0,b,c 00100bbb00001000FBBBCCCCCC111110.  */
{ "max", 0x2008003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* max<.f><.cc> b,b,c 00100bbb11001000FBBBCCCCCC0QQQQQ.  */
{ "max", 0x20C80000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* max<.f> a,b,u6 00100bbb01001000FBBBuuuuuuAAAAAA.  */
{ "max", 0x20480000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* max<.f> 0,b,u6 00100bbb01001000FBBBuuuuuu111110.  */
{ "max", 0x2048003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* max<.f><.cc> b,b,u6 00100bbb11001000FBBBuuuuuu1QQQQQ.  */
{ "max", 0x20C80020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* max<.f> b,b,s12 00100bbb10001000FBBBssssssSSSSSS.  */
{ "max", 0x20880000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* max<.f> a,limm,c 0010011000001000F111CCCCCCAAAAAA.  */
{ "max", 0x26087000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* max<.f> a,b,limm 00100bbb00001000FBBB111110AAAAAA.  */
{ "max", 0x20080F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* max<.f> 0,limm,c 0010011000001000F111CCCCCC111110.  */
{ "max", 0x2608703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* max<.f> 0,b,limm 00100bbb00001000FBBB111110111110.  */
{ "max", 0x20080FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* max<.f><.cc> b,b,limm 00100bbb11001000FBBB1111100QQQQQ.  */
{ "max", 0x20C80F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* max<.f><.cc> 0,limm,c 0010011011001000F111CCCCCC0QQQQQ.  */
{ "max", 0x26C87000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* max<.f> a,limm,u6 0010011001001000F111uuuuuuAAAAAA.  */
{ "max", 0x26487000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* max<.f> 0,limm,u6 0010011001001000F111uuuuuu111110.  */
{ "max", 0x2648703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* max<.f><.cc> 0,limm,u6 0010011011001000F111uuuuuu1QQQQQ.  */
{ "max", 0x26C87020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* max<.f> 0,limm,s12 0010011010001000F111ssssssSSSSSS.  */
{ "max", 0x26887000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* max<.f> a,limm,limm 0010011000001000F111111110AAAAAA.  */
{ "max", 0x26087F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* max<.f> 0,limm,limm 0010011000001000F111111110111110.  */
{ "max", 0x26087FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* max<.f><.cc> 0,limm,limm 0010011011001000F1111111100QQQQQ.  */
{ "max", 0x26C87F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* maxl<.f> RA,RB,RC 01011bbb00001000FBBBccccccaaaaaa.  */
{ "maxl", 0x58080000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* maxl<.f> 0,RB,RC 01011bbb00001000FBBBcccccc111110.  */
{ "maxl", 0x5808003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* maxl<.f><.cc> RB,RB,RC 01011bbb11001000FBBBcccccc0QQQQQ.  */
{ "maxl", 0x58C80000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* maxl<.f> RA,RB,u6 01011bbb01001000FBBBuuuuuuaaaaaa.  */
{ "maxl", 0x58480000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* maxl<.f> 0,RB,u6 01011bbb01001000FBBBuuuuuu111110.  */
{ "maxl", 0x5848003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* maxl<.f><.cc> RB,RB,u6 01011bbb11001000FBBBuuuuuu1QQQQQ.  */
{ "maxl", 0x58C80020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* maxl<.f> RB,RB,s12 01011bbb10001000FBBBssssssSSSSSS.  */
{ "maxl", 0x58880000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* maxl<.f> RA,ximm,RC 0101110000001000F111ccccccaaaaaa.  */
{ "maxl", 0x5C087000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* maxl<.f> RA,RB,ximm 01011bbb00001000FBBB111100aaaaaa.  */
{ "maxl", 0x58080F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* maxl<.f> 0,ximm,RC 0101110000001000F111cccccc111110.  */
{ "maxl", 0x5C08703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* maxl<.f> 0,RB,ximm 01011bbb00001000FBBB111100111110.  */
{ "maxl", 0x58080F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* maxl<.f><.cc> 0,ximm,RC 0101110011001000F111cccccc0QQQQQ.  */
{ "maxl", 0x5CC87000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* maxl<.f><.cc> RB,RB,ximm 01011bbb11001000FBBB1111000QQQQQ.  */
{ "maxl", 0x58C80F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* maxl<.f> RA,ximm,u6 0101110001001000F111uuuuuuaaaaaa.  */
{ "maxl", 0x5C487000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* maxl<.f> 0,ximm,u6 0101110001001000F111uuuuuu111110.  */
{ "maxl", 0x5C48703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* maxl<.f><.cc> 0,ximm,u6 0101110011001000F111uuuuuu1QQQQQ.  */
{ "maxl", 0x5CC87020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* maxl<.f> RA,limm,RC 0101111000001000F111ccccccaaaaaa.  */
{ "maxl", 0x5E087000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* maxl<.f> RA,RB,limm 01011bbb00001000FBBB111110aaaaaa.  */
{ "maxl", 0x58080F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* maxl<.f> 0,limm,RC 0101111000001000F111cccccc111110.  */
{ "maxl", 0x5E08703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* maxl<.f> 0,RB,limm 01011bbb00001000FBBB111110111110.  */
{ "maxl", 0x58080FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* maxl<.f><.cc> 0,limm,RC 0101111011001000F111cccccc0QQQQQ.  */
{ "maxl", 0x5EC87000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* maxl<.f><.cc> RB,RB,limm 01011bbb11001000FBBB1111100QQQQQ.  */
{ "maxl", 0x58C80F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* maxl<.f> RA,limm,u6 0101111001001000F111uuuuuuaaaaaa.  */
{ "maxl", 0x5E487000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* maxl<.f> 0,limm,u6 0101111001001000F111uuuuuu111110.  */
{ "maxl", 0x5E48703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* maxl<.f><.cc> 0,limm,u6 0101111011001000F111uuuuuu1QQQQQ.  */
{ "maxl", 0x5EC87020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* maxl<.f> 0,ximm,s12 0101110010001000F111ssssssSSSSSS.  */
{ "maxl", 0x5C887000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* maxl<.f> 0,limm,s12 0101111010001000F111ssssssSSSSSS.  */
{ "maxl", 0x5E887000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* maxl<.f> RA,ximm,ximm 0101110000001000F111111100aaaaaa.  */
{ "maxl", 0x5C087F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* maxl<.f> 0,ximm,ximm 0101110000001000F111111100111110.  */
{ "maxl", 0x5C087F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* maxl<.f><.cc> 0,ximm,ximm 0101110011001000F1111111000QQQQQ.  */
{ "maxl", 0x5CC87F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* maxl<.f> RA,limm,limm 0101111000001000F111111110aaaaaa.  */
{ "maxl", 0x5E087F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* maxl<.f> 0,limm,limm 0101111000001000F111111110111110.  */
{ "maxl", 0x5E087FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* maxl<.f><.cc> 0,limm,limm 0101111011001000F1111111100QQQQQ.  */
{ "maxl", 0x5EC87F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* min<.f> a,b,c 00100bbb00001001FBBBCCCCCCAAAAAA.  */
{ "min", 0x20090000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* min<.f> 0,b,c 00100bbb00001001FBBBCCCCCC111110.  */
{ "min", 0x2009003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* min<.f><.cc> b,b,c 00100bbb11001001FBBBCCCCCC0QQQQQ.  */
{ "min", 0x20C90000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* min<.f> a,b,u6 00100bbb01001001FBBBuuuuuuAAAAAA.  */
{ "min", 0x20490000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* min<.f> 0,b,u6 00100bbb01001001FBBBuuuuuu111110.  */
{ "min", 0x2049003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* min<.f><.cc> b,b,u6 00100bbb11001001FBBBuuuuuu1QQQQQ.  */
{ "min", 0x20C90020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* min<.f> b,b,s12 00100bbb10001001FBBBssssssSSSSSS.  */
{ "min", 0x20890000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* min<.f> a,limm,c 0010011000001001F111CCCCCCAAAAAA.  */
{ "min", 0x26097000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* min<.f> a,b,limm 00100bbb00001001FBBB111110AAAAAA.  */
{ "min", 0x20090F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* min<.f> 0,limm,c 0010011000001001F111CCCCCC111110.  */
{ "min", 0x2609703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* min<.f> 0,b,limm 00100bbb00001001FBBB111110111110.  */
{ "min", 0x20090FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* min<.f><.cc> b,b,limm 00100bbb11001001FBBB1111100QQQQQ.  */
{ "min", 0x20C90F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* min<.f><.cc> 0,limm,c 0010011011001001F111CCCCCC0QQQQQ.  */
{ "min", 0x26C97000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* min<.f> a,limm,u6 0010011001001001F111uuuuuuAAAAAA.  */
{ "min", 0x26497000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* min<.f> 0,limm,u6 0010011001001001F111uuuuuu111110.  */
{ "min", 0x2649703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* min<.f><.cc> 0,limm,u6 0010011011001001F111uuuuuu1QQQQQ.  */
{ "min", 0x26C97020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* min<.f> 0,limm,s12 0010011010001001F111ssssssSSSSSS.  */
{ "min", 0x26897000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* min<.f> a,limm,limm 0010011000001001F111111110AAAAAA.  */
{ "min", 0x26097F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* min<.f> 0,limm,limm 0010011000001001F111111110111110.  */
{ "min", 0x26097FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* min<.f><.cc> 0,limm,limm 0010011011001001F1111111100QQQQQ.  */
{ "min", 0x26C97F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* minl<.f> RA,RB,RC 01011bbb00001001FBBBccccccaaaaaa.  */
{ "minl", 0x58090000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* minl<.f> 0,RB,RC 01011bbb00001001FBBBcccccc111110.  */
{ "minl", 0x5809003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* minl<.f><.cc> RB,RB,RC 01011bbb11001001FBBBcccccc0QQQQQ.  */
{ "minl", 0x58C90000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* minl<.f> RA,RB,u6 01011bbb01001001FBBBuuuuuuaaaaaa.  */
{ "minl", 0x58490000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* minl<.f> 0,RB,u6 01011bbb01001001FBBBuuuuuu111110.  */
{ "minl", 0x5849003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* minl<.f><.cc> RB,RB,u6 01011bbb11001001FBBBuuuuuu1QQQQQ.  */
{ "minl", 0x58C90020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* minl<.f> RB,RB,s12 01011bbb10001001FBBBssssssSSSSSS.  */
{ "minl", 0x58890000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* minl<.f> RA,ximm,RC 0101110000001001F111ccccccaaaaaa.  */
{ "minl", 0x5C097000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* minl<.f> RA,RB,ximm 01011bbb00001001FBBB111100aaaaaa.  */
{ "minl", 0x58090F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* minl<.f> 0,ximm,RC 0101110000001001F111cccccc111110.  */
{ "minl", 0x5C09703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* minl<.f> 0,RB,ximm 01011bbb00001001FBBB111100111110.  */
{ "minl", 0x58090F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* minl<.f><.cc> 0,ximm,RC 0101110011001001F111cccccc0QQQQQ.  */
{ "minl", 0x5CC97000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* minl<.f><.cc> RB,RB,ximm 01011bbb11001001FBBB1111000QQQQQ.  */
{ "minl", 0x58C90F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* minl<.f> RA,ximm,u6 0101110001001001F111uuuuuuaaaaaa.  */
{ "minl", 0x5C497000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* minl<.f> 0,ximm,u6 0101110001001001F111uuuuuu111110.  */
{ "minl", 0x5C49703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* minl<.f><.cc> 0,ximm,u6 0101110011001001F111uuuuuu1QQQQQ.  */
{ "minl", 0x5CC97020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* minl<.f> RA,limm,RC 0101111000001001F111ccccccaaaaaa.  */
{ "minl", 0x5E097000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* minl<.f> RA,RB,limm 01011bbb00001001FBBB111110aaaaaa.  */
{ "minl", 0x58090F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* minl<.f> 0,limm,RC 0101111000001001F111cccccc111110.  */
{ "minl", 0x5E09703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* minl<.f> 0,RB,limm 01011bbb00001001FBBB111110111110.  */
{ "minl", 0x58090FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* minl<.f><.cc> 0,limm,RC 0101111011001001F111cccccc0QQQQQ.  */
{ "minl", 0x5EC97000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* minl<.f><.cc> RB,RB,limm 01011bbb11001001FBBB1111100QQQQQ.  */
{ "minl", 0x58C90F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* minl<.f> RA,limm,u6 0101111001001001F111uuuuuuaaaaaa.  */
{ "minl", 0x5E497000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* minl<.f> 0,limm,u6 0101111001001001F111uuuuuu111110.  */
{ "minl", 0x5E49703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* minl<.f><.cc> 0,limm,u6 0101111011001001F111uuuuuu1QQQQQ.  */
{ "minl", 0x5EC97020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* minl<.f> 0,ximm,s12 0101110010001001F111ssssssSSSSSS.  */
{ "minl", 0x5C897000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* minl<.f> 0,limm,s12 0101111010001001F111ssssssSSSSSS.  */
{ "minl", 0x5E897000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* minl<.f> RA,ximm,ximm 0101110000001001F111111100aaaaaa.  */
{ "minl", 0x5C097F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* minl<.f> 0,ximm,ximm 0101110000001001F111111100111110.  */
{ "minl", 0x5C097F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* minl<.f><.cc> 0,ximm,ximm 0101110011001001F1111111000QQQQQ.  */
{ "minl", 0x5CC97F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* minl<.f> RA,limm,limm 0101111000001001F111111110aaaaaa.  */
{ "minl", 0x5E097F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* minl<.f> 0,limm,limm 0101111000001001F111111110111110.  */
{ "minl", 0x5E097FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* minl<.f><.cc> 0,limm,limm 0101111011001001F1111111100QQQQQ.  */
{ "minl", 0x5EC97F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* nop  00100110010010100111000000000000.  */
{ "nop", 0x264A7000, 0xFFFFFFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { 0 }, { 0 }},

/* mov<.f> b,c 00100bbb00001010FBBBCCCCCCRRRRRR.  */
{ "mov", 0x200A0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { RB, RC }, { C_F }},

/* mov<.f> 0,c 0010011000001010F111CCCCCCRRRRRR.  */
{ "mov", 0x260A7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { ZA, RC }, { C_F }},

/* mov<.f><.cc> b,c 00100bbb11001010FBBBCCCCCC0QQQQQ.  */
{ "mov", 0x20CA0000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { RB, RC }, { C_F, C_CC }},

/* mov<.f><.cc> 0,c 0010011011001010F111CCCCCC0QQQQQ.  */
{ "mov", 0x26CA7000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { ZA, RC }, { C_F, C_CC }},

/* mov<.f> b,u6 00100bbb01001010FBBBuuuuuuRRRRRR.  */
{ "mov", 0x204A0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { RB, UIMM6_20 }, { C_F }},

/* mov<.f> 0,u6 0010011001001010F111uuuuuuRRRRRR.  */
{ "mov", 0x264A7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { ZA, UIMM6_20 }, { C_F }},

/* mov<.f><.cc> b,u6 00100bbb11001010FBBBuuuuuu1QQQQQ.  */
{ "mov", 0x20CA0020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { RB, UIMM6_20 }, { C_F, C_CC }},

/* mov<.f><.cc> 0,u6 0010011011001010F111uuuuuu1QQQQQ.  */
{ "mov", 0x26CA7020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { ZA, UIMM6_20 }, { C_F, C_CC }},

/* mov<.f> b,s12 00100bbb10001010FBBBssssssSSSSSS.  */
{ "mov", 0x208A0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { RB, SIMM12_20 }, { C_F }},

/* mov<.f> 0,s12 0010011010001010F111ssssssSSSSSS.  */
{ "mov", 0x268A7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { ZA, SIMM12_20 }, { C_F }},

/* mov<.f> b,limm 00100bbb00001010FBBB111110RRRRRR.  */
{ "mov", 0x200A0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { RB, LIMM }, { C_F }},

/* mov<.f> 0,limm 0010011000001010F111111110RRRRRR.  */
{ "mov", 0x260A7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { ZA, LIMM }, { C_F }},

/* mov<.f><.cc> b,limm 00100bbb11001010FBBB1111100QQQQQ.  */
{ "mov", 0x20CA0F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { RB, LIMM }, { C_F, C_CC }},

/* mov<.f><.cc> 0,limm 0010011011001010F1111111100QQQQQ.  */
{ "mov", 0x26CA7F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { ZA, LIMM }, { C_F, C_CC }},

/* movhl RB,RC 01011bbb000010110BBBccccccRRRRRR.  */
{ "movhl", 0x580B0000, 0xF8FF8000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { 0 }},

/* movhl<.cc> RB,RC 01011bbb110010110BBBcccccc0QQQQQ.  */
{ "movhl", 0x58CB0000, 0xF8FF8020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_CC }},

/* movhl RB,u6 01011bbb010010110BBBuuuuuuRRRRRR.  */
{ "movhl", 0x584B0000, 0xF8FF8000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { 0 }},

/* movhl<.cc> RB,u6 01011bbb110010110BBBuuuuuu1QQQQQ.  */
{ "movhl", 0x58CB0020, 0xF8FF8020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_CC }},

/* movhl RB,s12 01011bbb100010110BBBssssssSSSSSS.  */
{ "movhl", 0x588B0000, 0xF8FF8000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, SIMM12_20 }, { 0 }},

/* movhl RB,limm 01011bbb000010110BBB111110RRRRRR.  */
{ "movhl", 0x580B0F80, 0xF8FF8FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, HI32 }, { 0 }},

/* movhl<.cc> RB,limm 01011bbb110010110BBB1111100QQQQQ.  */
{ "movhl", 0x58CB0F80, 0xF8FF8FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, HI32 }, { C_CC }},

/* movhl_s h,limm 01110000hhh010HH.  */
{ "movhl_s", 0x00007008, 0x0000FF1C, ARC_OPCODE_ARC64, ARITH, NONE, { RH_S, HI32 }, { 0 }},

/* movl<.f> RB,RC 01011bbb00001010FBBBccccccRRRRRR.  */
{ "movl", 0x580A0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* movl<.f><.cc> RB,RC 01011bbb11001010FBBBcccccc0QQQQQ.  */
{ "movl", 0x58CA0000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F, C_CC }},

/* movl<.f> RB,u6 01011bbb01001010FBBBuuuuuuRRRRRR.  */
{ "movl", 0x584A0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* movl<.f><.cc> RB,u6 01011bbb11001010FBBBuuuuuu1QQQQQ.  */
{ "movl", 0x58CA0020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F, C_CC }},

/* movl<.f> RB,s12 01011bbb10001010FBBBssssssSSSSSS.  */
{ "movl", 0x588A0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, SIMM12_20 }, { C_F }},

/* movl<.f> RB,ximm 01011bbb00001010FBBB111100RRRRRR.  */
{ "movl", 0x580A0F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { C_F }},

/* movl<.f><.cc> RB,ximm 01011bbb11001010FBBB1111000QQQQQ.  */
{ "movl", 0x58CA0F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { C_F, C_CC }},

/* movl<.f> RB,limm 01011bbb00001010FBBB111110RRRRRR.  */
{ "movl", 0x580A0F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* movl<.f><.cc> RB,limm 01011bbb11001010FBBB1111100QQQQQ.  */
{ "movl", 0x58CA0F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F, C_CC }},

/* movl_s g,h 01000ggghhhGG1HH.  */
{ "movl_s", 0x00004004, 0x0000F804, ARC_OPCODE_ARC64, ARITH, NONE, { G_S, RH_S }, { 0 }},

/* movl_s b,u8 11011bbbuuuuuuuu.  */
{ "movl_s", 0x0000D800, 0x0000F800, ARC_OPCODE_ARC64, ARITH, NONE, { RB_S, UIMM8_8_S }, { 0 }},

/* movl_s g,limm 01000ggg110GG111.  */
{ "movl_s", 0x000040C7, 0x0000F8E7, ARC_OPCODE_ARC64, MOVE, NONE, { G_S, LIMM_S }, { 0 }},

/* mov_s.NE b,h 01110bbbhhh111HH.  */
{ "mov_s", 0x0000701C, 0x0000F81C,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { RB_S, RH_S }, { C_NE, C_CC_NE}},

/* mov_s g,h 01000ggghhhGG0HH.  */
{ "mov_s", 0x00004000, 0x0000F804,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { G_S, RH_S }, { 0 }},

/* mov_s 0,h 01000110hhh110HH.  */
{ "mov_s", 0x00004618, 0x0000FF1C,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { ZA_S, RH_S }, { 0 }},

/* mov_s h,s3 01110ssshhh011HH.  */
{ "mov_s", 0x0000700C, 0x0000F81C,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { RH_S, SIMM3_5_S }, { 0 }},

/* mov_s 0,s3 01110sss11001111.  */
{ "mov_s", 0x000070CF, 0x0000F8FF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { ZA_S, SIMM3_5_S }, { 0 }},

/* mov_s b,u8 11011bbbuuuuuuuu.  */
{ "mov_s", 0x0000D800, 0x0000F800,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { RB_S, UIMM8_8_S }, { 0 }},

/* mov_s.NE b,limm 01110bbb11011111.  */
{ "mov_s", 0x000070DF, 0x0000F8FF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { RB_S, LIMM_S }, { C_NE, C_CC_NE}},

/* mov_s g,limm 01000ggg110GG011.  */
{ "mov_s", 0x000040C3, 0x0000F8E7,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { G_S, LIMM_S }, { 0 }},

/* mov_s 0,limm 0100011011011011.  */
{ "mov_s", 0x000046DB, 0x0000FFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MOVE, NONE, { ZA_S, LIMM_S }, { 0 }},

/* mpy<.f> a,b,c 00100bbb00011010FBBBCCCCCCAAAAAA.  */
{ "mpy", 0x201A0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, RB, RC }, { C_F }},

/* mpy<.f> 0,b,c 00100bbb00011010FBBBCCCCCC111110.  */
{ "mpy", 0x201A003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, RB, RC }, { C_F }},

/* mpy<.f><.cc> b,b,c 00100bbb11011010FBBBCCCCCC0QQQQQ.  */
{ "mpy", 0x20DA0000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpy<.f> a,b,u6 00100bbb01011010FBBBuuuuuuAAAAAA.  */
{ "mpy", 0x205A0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpy<.f> 0,b,u6 00100bbb01011010FBBBuuuuuu111110.  */
{ "mpy", 0x205A003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpy<.f><.cc> b,b,u6 00100bbb11011010FBBBuuuuuu1QQQQQ.  */
{ "mpy", 0x20DA0020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpy<.f> b,b,s12 00100bbb10011010FBBBssssssSSSSSS.  */
{ "mpy", 0x209A0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpy<.f> a,limm,c 0010011000011010F111CCCCCCAAAAAA.  */
{ "mpy", 0x261A7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, LIMM, RC }, { C_F }},

/* mpy<.f> a,b,limm 00100bbb00011010FBBB111110AAAAAA.  */
{ "mpy", 0x201A0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, RB, LIMM }, { C_F }},

/* mpy<.f> 0,limm,c 0010011000011010F111CCCCCC111110.  */
{ "mpy", 0x261A703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, RC }, { C_F }},

/* mpy<.f> 0,b,limm 00100bbb00011010FBBB111110111110.  */
{ "mpy", 0x201A0FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, RB, LIMM }, { C_F }},

/* mpy<.f><.cc> b,b,limm 00100bbb11011010FBBB1111100QQQQQ.  */
{ "mpy", 0x20DA0F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpy<.f><.cc> 0,limm,c 0010011011011010F111CCCCCC0QQQQQ.  */
{ "mpy", 0x26DA7000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpy<.f> a,limm,u6 0010011001011010F111uuuuuuAAAAAA.  */
{ "mpy", 0x265A7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpy<.f> 0,limm,u6 0010011001011010F111uuuuuu111110.  */
{ "mpy", 0x265A703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpy<.f><.cc> 0,limm,u6 0010011011011010F111uuuuuu1QQQQQ.  */
{ "mpy", 0x26DA7020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpy<.f> 0,limm,s12 0010011010011010F111ssssssSSSSSS.  */
{ "mpy", 0x269A7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpy<.f> a,limm,limm 0010011000011010F111111110AAAAAA.  */
{ "mpy", 0x261A7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpy<.f> 0,limm,limm 0010011000011010F111111110111110.  */
{ "mpy", 0x261A7FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpy<.f><.cc> 0,limm,limm 0010011011011010F1111111100QQQQQ.  */
{ "mpy", 0x26DA7F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpyd<.f> a,b,c 00101bbb00011000FBBBCCCCCCAAAAAA.  */
{ "mpyd", 0x28180000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, RB, RC }, { C_F }},

/* mpyd<.f> 0,b,c 00101bbb00011000FBBBCCCCCC111110.  */
{ "mpyd", 0x2818003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, RB, RC }, { C_F }},

/* mpyd<.f><.cc> b,b,c 00101bbb11011000FBBBCCCCCC0QQQQQ.  */
{ "mpyd", 0x28D80000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpyd<.f> a,b,u6 00101bbb01011000FBBBuuuuuuAAAAAA.  */
{ "mpyd", 0x28580000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpyd<.f> 0,b,u6 00101bbb01011000FBBBuuuuuu111110.  */
{ "mpyd", 0x2858003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpyd<.f><.cc> b,b,u6 00101bbb11011000FBBBuuuuuu1QQQQQ.  */
{ "mpyd", 0x28D80020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpyd<.f> b,b,s12 00101bbb10011000FBBBssssssSSSSSS.  */
{ "mpyd", 0x28980000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpyd<.f> a,limm,c 0010111000011000F111CCCCCCAAAAAA.  */
{ "mpyd", 0x2E187000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, LIMM, RC }, { C_F }},

/* mpyd<.f> a,b,limm 00101bbb00011000FBBB111110AAAAAA.  */
{ "mpyd", 0x28180F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, RB, LIMM }, { C_F }},

/* mpyd<.f> 0,limm,c 0010111000011000F111CCCCCC111110.  */
{ "mpyd", 0x2E18703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, RC }, { C_F }},

/* mpyd<.f> 0,b,limm 00101bbb00011000FBBB111110111110.  */
{ "mpyd", 0x28180FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, RB, LIMM }, { C_F }},

/* mpyd<.f><.cc> b,b,limm 00101bbb11011000FBBB1111100QQQQQ.  */
{ "mpyd", 0x28D80F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpyd<.f><.cc> 0,limm,c 0010111011011000F111CCCCCC0QQQQQ.  */
{ "mpyd", 0x2ED87000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpyd<.f> a,limm,u6 0010111001011000F111uuuuuuAAAAAA.  */
{ "mpyd", 0x2E587000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpyd<.f> 0,limm,u6 0010111001011000F111uuuuuu111110.  */
{ "mpyd", 0x2E58703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpyd<.f><.cc> 0,limm,u6 0010111011011000F111uuuuuu1QQQQQ.  */
{ "mpyd", 0x2ED87020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpyd<.f> 0,limm,s12 0010111010011000F111ssssssSSSSSS.  */
{ "mpyd", 0x2E987000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpyd<.f> a,limm,limm 0010111000011000F111111110AAAAAA.  */
{ "mpyd", 0x2E187F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpyd<.f> 0,limm,limm 0010111000011000F111111110111110.  */
{ "mpyd", 0x2E187FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpyd<.f><.cc> 0,limm,limm 0010111011011000F1111111100QQQQQ.  */
{ "mpyd", 0x2ED87F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpydf<.f> a,b,c 00110bbb00010010FBBBCCCCCCAAAAAA.  */
{ "mpydf", 0x30120000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RA_CHK, RB, RC }, { C_F }},

/* mpydf<.f> 0,b,c 00110bbb00010010FBBBCCCCCC111110.  */
{ "mpydf", 0x3012003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, RB, RC }, { C_F }},

/* mpydf<.f><.cc> b,b,c 00110bbb11010010FBBBCCCCCC0QQQQQ.  */
{ "mpydf", 0x30D20000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpydf<.f> a,b,u6 00110bbb01010010FBBBuuuuuuAAAAAA.  */
{ "mpydf", 0x30520000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpydf<.f> 0,b,u6 00110bbb01010010FBBBuuuuuu111110.  */
{ "mpydf", 0x3052003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpydf<.f><.cc> b,b,u6 00110bbb11010010FBBBuuuuuu1QQQQQ.  */
{ "mpydf", 0x30D20020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpydf<.f> b,b,s12 00110bbb10010010FBBBssssssSSSSSS.  */
{ "mpydf", 0x30920000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpydf<.f> a,limm,c 0011011000010010F111CCCCCCAAAAAA.  */
{ "mpydf", 0x36127000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RA_CHK, LIMM, RC }, { C_F }},

/* mpydf<.f> a,b,limm 00110bbb00010010FBBB111110AAAAAA.  */
{ "mpydf", 0x30120F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RA_CHK, RB, LIMM }, { C_F }},

/* mpydf<.f> 0,limm,c 0011011000010010F111CCCCCC111110.  */
{ "mpydf", 0x3612703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, LIMM, RC }, { C_F }},

/* mpydf<.f> 0,b,limm 00110bbb00010010FBBB111110111110.  */
{ "mpydf", 0x30120FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, RB, LIMM }, { C_F }},

/* mpydf<.f><.cc> b,b,limm 00110bbb11010010FBBB1111100QQQQQ.  */
{ "mpydf", 0x30D20F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpydf<.f><.cc> 0,limm,c 0011011011010010F111CCCCCC0QQQQQ.  */
{ "mpydf", 0x36D27000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpydf<.f> a,limm,u6 0011011001010010F111uuuuuuAAAAAA.  */
{ "mpydf", 0x36527000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpydf<.f> 0,limm,u6 0011011001010010F111uuuuuu111110.  */
{ "mpydf", 0x3652703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpydf<.f><.cc> 0,limm,u6 0011011011010010F111uuuuuu1QQQQQ.  */
{ "mpydf", 0x36D27020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpydf<.f> 0,limm,s12 0011011010010010F111ssssssSSSSSS.  */
{ "mpydf", 0x36927000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpydf<.f> a,limm,limm 0011011000010010F111111110AAAAAA.  */
{ "mpydf", 0x36127F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpydf<.f> 0,limm,limm 0011011000010010F111111110111110.  */
{ "mpydf", 0x36127FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpydf<.f><.cc> 0,limm,limm 0011011011010010F1111111100QQQQQ.  */
{ "mpydf", 0x36D27F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpydu<.f> a,b,c 00101bbb00011001FBBBCCCCCCAAAAAA.  */
{ "mpydu", 0x28190000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, RB, RC }, { C_F }},

/* mpydu<.f> 0,b,c 00101bbb00011001FBBBCCCCCC111110.  */
{ "mpydu", 0x2819003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, RB, RC }, { C_F }},

/* mpydu<.f><.cc> b,b,c 00101bbb11011001FBBBCCCCCC0QQQQQ.  */
{ "mpydu", 0x28D90000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpydu<.f> a,b,u6 00101bbb01011001FBBBuuuuuuAAAAAA.  */
{ "mpydu", 0x28590000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpydu<.f> 0,b,u6 00101bbb01011001FBBBuuuuuu111110.  */
{ "mpydu", 0x2859003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpydu<.f><.cc> b,b,u6 00101bbb11011001FBBBuuuuuu1QQQQQ.  */
{ "mpydu", 0x28D90020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpydu<.f> b,b,s12 00101bbb10011001FBBBssssssSSSSSS.  */
{ "mpydu", 0x28990000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpydu<.f> a,limm,c 0010111000011001F111CCCCCCAAAAAA.  */
{ "mpydu", 0x2E197000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, LIMM, RC }, { C_F }},

/* mpydu<.f> a,b,limm 00101bbb00011001FBBB111110AAAAAA.  */
{ "mpydu", 0x28190F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, RB, LIMM }, { C_F }},

/* mpydu<.f> 0,limm,c 0010111000011001F111CCCCCC111110.  */
{ "mpydu", 0x2E19703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, RC }, { C_F }},

/* mpydu<.f> 0,b,limm 00101bbb00011001FBBB111110111110.  */
{ "mpydu", 0x28190FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, RB, LIMM }, { C_F }},

/* mpydu<.f><.cc> b,b,limm 00101bbb11011001FBBB1111100QQQQQ.  */
{ "mpydu", 0x28D90F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpydu<.f><.cc> 0,limm,c 0010111011011001F111CCCCCC0QQQQQ.  */
{ "mpydu", 0x2ED97000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpydu<.f> a,limm,u6 0010111001011001F111uuuuuuAAAAAA.  */
{ "mpydu", 0x2E597000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpydu<.f> 0,limm,u6 0010111001011001F111uuuuuu111110.  */
{ "mpydu", 0x2E59703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpydu<.f><.cc> 0,limm,u6 0010111011011001F111uuuuuu1QQQQQ.  */
{ "mpydu", 0x2ED97020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpydu<.f> 0,limm,s12 0010111010011001F111ssssssSSSSSS.  */
{ "mpydu", 0x2E997000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpydu<.f> a,limm,limm 0010111000011001F111111110AAAAAA.  */
{ "mpydu", 0x2E197F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpydu<.f> 0,limm,limm 0010111000011001F111111110111110.  */
{ "mpydu", 0x2E197FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpydu<.f><.cc> 0,limm,limm 0010111011011001F1111111100QQQQQ.  */
{ "mpydu", 0x2ED97F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpym<.f> a,b,c 00100bbb00011011FBBBCCCCCCAAAAAA.  */
{ "mpym", 0x201B0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, RB, RC }, { C_F }},

/* mpym<.f> 0,b,c 00100bbb00011011FBBBCCCCCC111110.  */
{ "mpym", 0x201B003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, RB, RC }, { C_F }},

/* mpym<.f><.cc> b,b,c 00100bbb11011011FBBBCCCCCC0QQQQQ.  */
{ "mpym", 0x20DB0000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpym<.f> a,b,u6 00100bbb01011011FBBBuuuuuuAAAAAA.  */
{ "mpym", 0x205B0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpym<.f> 0,b,u6 00100bbb01011011FBBBuuuuuu111110.  */
{ "mpym", 0x205B003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpym<.f><.cc> b,b,u6 00100bbb11011011FBBBuuuuuu1QQQQQ.  */
{ "mpym", 0x20DB0020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpym<.f> b,b,s12 00100bbb10011011FBBBssssssSSSSSS.  */
{ "mpym", 0x209B0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpym<.f> a,limm,c 0010011000011011F111CCCCCCAAAAAA.  */
{ "mpym", 0x261B7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, LIMM, RC }, { C_F }},

/* mpym<.f> a,b,limm 00100bbb00011011FBBB111110AAAAAA.  */
{ "mpym", 0x201B0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, RB, LIMM }, { C_F }},

/* mpym<.f> 0,limm,c 0010011000011011F111CCCCCC111110.  */
{ "mpym", 0x261B703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, RC }, { C_F }},

/* mpym<.f> 0,b,limm 00100bbb00011011FBBB111110111110.  */
{ "mpym", 0x201B0FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, RB, LIMM }, { C_F }},

/* mpym<.f><.cc> b,b,limm 00100bbb11011011FBBB1111100QQQQQ.  */
{ "mpym", 0x20DB0F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpym<.f><.cc> 0,limm,c 0010011011011011F111CCCCCC0QQQQQ.  */
{ "mpym", 0x26DB7000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpym<.f> a,limm,u6 0010011001011011F111uuuuuuAAAAAA.  */
{ "mpym", 0x265B7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpym<.f> 0,limm,u6 0010011001011011F111uuuuuu111110.  */
{ "mpym", 0x265B703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpym<.f><.cc> 0,limm,u6 0010011011011011F111uuuuuu1QQQQQ.  */
{ "mpym", 0x26DB7020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpym<.f> 0,limm,s12 0010011010011011F111ssssssSSSSSS.  */
{ "mpym", 0x269B7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpym<.f> a,limm,limm 0010011000011011F111111110AAAAAA.  */
{ "mpym", 0x261B7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpym<.f> 0,limm,limm 0010011000011011F111111110111110.  */
{ "mpym", 0x261B7FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpym<.f><.cc> 0,limm,limm 0010011011011011F1111111100QQQQQ.  */
{ "mpym", 0x26DB7F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpymu<.f> a,b,c 00100bbb00011100FBBBCCCCCCAAAAAA.  */
{ "mpymu", 0x201C0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, RB, RC }, { C_F }},

/* mpymu<.f> 0,b,c 00100bbb00011100FBBBCCCCCC111110.  */
{ "mpymu", 0x201C003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, RB, RC }, { C_F }},

/* mpymu<.f><.cc> b,b,c 00100bbb11011100FBBBCCCCCC0QQQQQ.  */
{ "mpymu", 0x20DC0000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpymu<.f> a,b,u6 00100bbb01011100FBBBuuuuuuAAAAAA.  */
{ "mpymu", 0x205C0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpymu<.f> 0,b,u6 00100bbb01011100FBBBuuuuuu111110.  */
{ "mpymu", 0x205C003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpymu<.f><.cc> b,b,u6 00100bbb11011100FBBBuuuuuu1QQQQQ.  */
{ "mpymu", 0x20DC0020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpymu<.f> b,b,s12 00100bbb10011100FBBBssssssSSSSSS.  */
{ "mpymu", 0x209C0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpymu<.f> a,limm,c 0010011000011100F111CCCCCCAAAAAA.  */
{ "mpymu", 0x261C7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, LIMM, RC }, { C_F }},

/* mpymu<.f> a,b,limm 00100bbb00011100FBBB111110AAAAAA.  */
{ "mpymu", 0x201C0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, RB, LIMM }, { C_F }},

/* mpymu<.f> 0,limm,c 0010011000011100F111CCCCCC111110.  */
{ "mpymu", 0x261C703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, RC }, { C_F }},

/* mpymu<.f> 0,b,limm 00100bbb00011100FBBB111110111110.  */
{ "mpymu", 0x201C0FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, RB, LIMM }, { C_F }},

/* mpymu<.f><.cc> b,b,limm 00100bbb11011100FBBB1111100QQQQQ.  */
{ "mpymu", 0x20DC0F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpymu<.f><.cc> 0,limm,c 0010011011011100F111CCCCCC0QQQQQ.  */
{ "mpymu", 0x26DC7000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpymu<.f> a,limm,u6 0010011001011100F111uuuuuuAAAAAA.  */
{ "mpymu", 0x265C7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpymu<.f> 0,limm,u6 0010011001011100F111uuuuuu111110.  */
{ "mpymu", 0x265C703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpymu<.f><.cc> 0,limm,u6 0010011011011100F111uuuuuu1QQQQQ.  */
{ "mpymu", 0x26DC7020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpymu<.f> 0,limm,s12 0010011010011100F111ssssssSSSSSS.  */
{ "mpymu", 0x269C7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpymu<.f> a,limm,limm 0010011000011100F111111110AAAAAA.  */
{ "mpymu", 0x261C7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpymu<.f> 0,limm,limm 0010011000011100F111111110111110.  */
{ "mpymu", 0x261C7FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpymu<.f><.cc> 0,limm,limm 0010011011011100F1111111100QQQQQ.  */
{ "mpymu", 0x26DC7F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpyu<.f> a,b,c 00100bbb00011101FBBBCCCCCCAAAAAA.  */
{ "mpyu", 0x201D0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, RB, RC }, { C_F }},

/* mpyu<.f> 0,b,c 00100bbb00011101FBBBCCCCCC111110.  */
{ "mpyu", 0x201D003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, RB, RC }, { C_F }},

/* mpyu<.f><.cc> b,b,c 00100bbb11011101FBBBCCCCCC0QQQQQ.  */
{ "mpyu", 0x20DD0000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpyu<.f> a,b,u6 00100bbb01011101FBBBuuuuuuAAAAAA.  */
{ "mpyu", 0x205D0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpyu<.f> 0,b,u6 00100bbb01011101FBBBuuuuuu111110.  */
{ "mpyu", 0x205D003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpyu<.f><.cc> b,b,u6 00100bbb11011101FBBBuuuuuu1QQQQQ.  */
{ "mpyu", 0x20DD0020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpyu<.f> b,b,s12 00100bbb10011101FBBBssssssSSSSSS.  */
{ "mpyu", 0x209D0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpyu<.f> a,limm,c 0010011000011101F111CCCCCCAAAAAA.  */
{ "mpyu", 0x261D7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, LIMM, RC }, { C_F }},

/* mpyu<.f> a,b,limm 00100bbb00011101FBBB111110AAAAAA.  */
{ "mpyu", 0x201D0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, RB, LIMM }, { C_F }},

/* mpyu<.f> 0,limm,c 0010011000011101F111CCCCCC111110.  */
{ "mpyu", 0x261D703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, RC }, { C_F }},

/* mpyu<.f> 0,b,limm 00100bbb00011101FBBB111110111110.  */
{ "mpyu", 0x201D0FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, RB, LIMM }, { C_F }},

/* mpyu<.f><.cc> b,b,limm 00100bbb11011101FBBB1111100QQQQQ.  */
{ "mpyu", 0x20DD0F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpyu<.f><.cc> 0,limm,c 0010011011011101F111CCCCCC0QQQQQ.  */
{ "mpyu", 0x26DD7000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpyu<.f> a,limm,u6 0010011001011101F111uuuuuuAAAAAA.  */
{ "mpyu", 0x265D7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpyu<.f> 0,limm,u6 0010011001011101F111uuuuuu111110.  */
{ "mpyu", 0x265D703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpyu<.f><.cc> 0,limm,u6 0010011011011101F111uuuuuu1QQQQQ.  */
{ "mpyu", 0x26DD7020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpyu<.f> 0,limm,s12 0010011010011101F111ssssssSSSSSS.  */
{ "mpyu", 0x269D7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpyu<.f> a,limm,limm 0010011000011101F111111110AAAAAA.  */
{ "mpyu", 0x261D7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpyu<.f> 0,limm,limm 0010011000011101F111111110111110.  */
{ "mpyu", 0x261D7FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpyu<.f><.cc> 0,limm,limm 0010011011011101F1111111100QQQQQ.  */
{ "mpyu", 0x26DD7F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpyuw<.f> a,b,c 00100bbb00011111FBBBCCCCCCAAAAAA.  */
{ "mpyuw", 0x201F0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { RA_CHK, RB, RC }, { C_F }},

/* mpyuw<.f> 0,b,c 00100bbb00011111FBBBCCCCCC111110.  */
{ "mpyuw", 0x201F003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { ZA, RB, RC }, { C_F }},

/* mpyuw<.f><.cc> b,b,c 00100bbb11011111FBBBCCCCCC0QQQQQ.  */
{ "mpyuw", 0x20DF0000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpyuw<.f> a,b,u6 00100bbb01011111FBBBuuuuuuAAAAAA.  */
{ "mpyuw", 0x205F0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpyuw<.f> 0,b,u6 00100bbb01011111FBBBuuuuuu111110.  */
{ "mpyuw", 0x205F003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpyuw<.f><.cc> b,b,u6 00100bbb11011111FBBBuuuuuu1QQQQQ.  */
{ "mpyuw", 0x20DF0020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpyuw<.f> b,b,s12 00100bbb10011111FBBBssssssSSSSSS.  */
{ "mpyuw", 0x209F0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpyuw<.f> a,limm,c 0010011000011111F111CCCCCCAAAAAA.  */
{ "mpyuw", 0x261F7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { RA_CHK, LIMM, RC }, { C_F }},

/* mpyuw<.f> a,b,limm 00100bbb00011111FBBB111110AAAAAA.  */
{ "mpyuw", 0x201F0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { RA_CHK, RB, LIMM }, { C_F }},

/* mpyuw<.f> 0,limm,c 0010011000011111F111CCCCCC111110.  */
{ "mpyuw", 0x261F703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { ZA, LIMM, RC }, { C_F }},

/* mpyuw<.f> 0,b,limm 00100bbb00011111FBBB111110111110.  */
{ "mpyuw", 0x201F0FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { ZA, RB, LIMM }, { C_F }},

/* mpyuw<.f><.cc> b,b,limm 00100bbb11011111FBBB1111100QQQQQ.  */
{ "mpyuw", 0x20DF0F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpyuw<.f><.cc> 0,limm,c 0010011011011111F111CCCCCC0QQQQQ.  */
{ "mpyuw", 0x26DF7000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpyuw<.f> a,limm,u6 0010011001011111F111uuuuuuAAAAAA.  */
{ "mpyuw", 0x265F7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpyuw<.f> 0,limm,u6 0010011001011111F111uuuuuu111110.  */
{ "mpyuw", 0x265F703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpyuw<.f><.cc> 0,limm,u6 0010011011011111F111uuuuuu1QQQQQ.  */
{ "mpyuw", 0x26DF7020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpyuw<.f> 0,limm,s12 0010011010011111F111ssssssSSSSSS.  */
{ "mpyuw", 0x269F7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpyuw<.f> a,limm,limm 0010011000011111F111111110AAAAAA.  */
{ "mpyuw", 0x261F7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpyuw<.f> 0,limm,limm 0010011000011111F111111110111110.  */
{ "mpyuw", 0x261F7FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpyuw<.f><.cc> 0,limm,limm 0010011011011111F1111111100QQQQQ.  */
{ "mpyuw", 0x26DF7F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpyuw_s b,b,c 01111bbbccc01010.  */
{ "mpyuw_s", 0x0000780A, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* mpyw<.f> a,b,c 00100bbb00011110FBBBCCCCCCAAAAAA.  */
{ "mpyw", 0x201E0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { RA_CHK, RB, RC }, { C_F }},

/* mpyw<.f> 0,b,c 00100bbb00011110FBBBCCCCCC111110.  */
{ "mpyw", 0x201E003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { ZA, RB, RC }, { C_F }},

/* mpyw<.f><.cc> b,b,c 00100bbb11011110FBBBCCCCCC0QQQQQ.  */
{ "mpyw", 0x20DE0000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* mpyw<.f> a,b,u6 00100bbb01011110FBBBuuuuuuAAAAAA.  */
{ "mpyw", 0x205E0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* mpyw<.f> 0,b,u6 00100bbb01011110FBBBuuuuuu111110.  */
{ "mpyw", 0x205E003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { ZA, RB, UIMM6_20 }, { C_F }},

/* mpyw<.f><.cc> b,b,u6 00100bbb11011110FBBBuuuuuu1QQQQQ.  */
{ "mpyw", 0x20DE0020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* mpyw<.f> b,b,s12 00100bbb10011110FBBBssssssSSSSSS.  */
{ "mpyw", 0x209E0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* mpyw<.f> a,limm,c 0010011000011110F111CCCCCCAAAAAA.  */
{ "mpyw", 0x261E7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { RA_CHK, LIMM, RC }, { C_F }},

/* mpyw<.f> a,b,limm 00100bbb00011110FBBB111110AAAAAA.  */
{ "mpyw", 0x201E0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { RA_CHK, RB, LIMM }, { C_F }},

/* mpyw<.f> 0,limm,c 0010011000011110F111CCCCCC111110.  */
{ "mpyw", 0x261E703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { ZA, LIMM, RC }, { C_F }},

/* mpyw<.f> 0,b,limm 00100bbb00011110FBBB111110111110.  */
{ "mpyw", 0x201E0FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { ZA, RB, LIMM }, { C_F }},

/* mpyw<.f><.cc> b,b,limm 00100bbb11011110FBBB1111100QQQQQ.  */
{ "mpyw", 0x20DE0F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* mpyw<.f><.cc> 0,limm,c 0010011011011110F111CCCCCC0QQQQQ.  */
{ "mpyw", 0x26DE7000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* mpyw<.f> a,limm,u6 0010011001011110F111uuuuuuAAAAAA.  */
{ "mpyw", 0x265E7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* mpyw<.f> 0,limm,u6 0010011001011110F111uuuuuu111110.  */
{ "mpyw", 0x265E703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* mpyw<.f><.cc> 0,limm,u6 0010011011011110F111uuuuuu1QQQQQ.  */
{ "mpyw", 0x26DE7020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* mpyw<.f> 0,limm,s12 0010011010011110F111ssssssSSSSSS.  */
{ "mpyw", 0x269E7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* mpyw<.f> a,limm,limm 0010011000011110F111111110AAAAAA.  */
{ "mpyw", 0x261E7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* mpyw<.f> 0,limm,limm 0010011000011110F111111110111110.  */
{ "mpyw", 0x261E7FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { ZA, LIMM, LIMMdup }, { C_F }},

/* mpyw<.f><.cc> 0,limm,limm 0010011011011110F1111111100QQQQQ.  */
{ "mpyw", 0x26DE7F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* mpyw_s b,b,c 01111bbbccc01001.  */
{ "mpyw_s", 0x00007809, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY1E, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* mpy_s b,b,c 01111bbbccc01100.  */
{ "mpy_s", 0x0000780C, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY6E, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* neg<.f> a,b 00100bbb01001110FBBB000000AAAAAA.  */
{ "neg", 0x204E0000, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB }, { C_F }},

/* neg<.f><.cc> b,b 00100bbb11001110FBBB0000001QQQQQ.  */
{ "neg", 0x20CE0020, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup }, { C_F, C_CC }},

/* neg<.f> a,limm 0010011001001110F111000000AAAAAA.  */
{ "neg", 0x264E7000, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM }, { C_F }},

/* neg<.f><.cc> 0,limm 0010011011001110F1110000001QQQQQ.  */
{ "neg", 0x26CE7020, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F, C_CC }},













/* neg_s b,c 01111bbbccc10011.  */
{ "neg_s", 0x00007813, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB_S, RC_S }, { 0 }},

/* nop_s  0111100011100000.  */
{ "nop_s", 0x000078E0, 0x0000FFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { 0 }, { 0 }},

/* norm<.f> b,c 00101bbb00101111FBBBCCCCCC000001.  */
{ "norm", 0x282F0001, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* norm<.f> 0,c 0010111000101111F111CCCCCC000001.  */
{ "norm", 0x2E2F7001, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RC }, { C_F }},

/* norm<.f> b,u6 00101bbb01101111FBBBuuuuuu000001.  */
{ "norm", 0x286F0001, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* norm<.f> 0,u6 0010111001101111F111uuuuuu000001.  */
{ "norm", 0x2E6F7001, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* norm<.f> b,limm 00101bbb00101111FBBB111110000001.  */
{ "norm", 0x282F0F81, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* norm<.f> 0,limm 0010111000101111F111111110000001.  */
{ "norm", 0x2E2F7F81, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* normh<.f> b,c 00101bbb00101111FBBBCCCCCC001000.  */
{ "normh", 0x282F0008, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* normh<.f> 0,c 0010111000101111F111CCCCCC001000.  */
{ "normh", 0x2E2F7008, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RC }, { C_F }},

/* normh<.f> b,u6 00101bbb01101111FBBBuuuuuu001000.  */
{ "normh", 0x286F0008, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* normh<.f> 0,u6 0010111001101111F111uuuuuu001000.  */
{ "normh", 0x2E6F7008, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* normh<.f> b,limm 00101bbb00101111FBBB111110001000.  */
{ "normh", 0x282F0F88, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* normh<.f> 0,limm 0010111000101111F111111110001000.  */
{ "normh", 0x2E2F7F88, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* norml<.f> RB,RC 01011bbb00101111FBBBcccccc100001.  */
{ "norml", 0x582F0021, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* norml<.f> 0,RC 0101111000101111F111cccccc100001.  */
{ "norml", 0x5E2F7021, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RC }, { C_F }},

/* norml<.f> RB,u6 01011bbb01101111FBBBuuuuuu100001.  */
{ "norml", 0x586F0021, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* norml<.f> 0,u6 0101111001101111F111uuuuuu100001.  */
{ "norml", 0x5E6F7021, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* norml<.f> RB,ximm 01011bbb00101111FBBB111100100001.  */
{ "norml", 0x582F0F21, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { C_F }},

/* norml<.f> 0,ximm 0101111000101111F111111100100001.  */
{ "norml", 0x5E2F7F21, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM }, { C_F }},

/* norml<.f> RB,limm 01011bbb00101111FBBB111110100001.  */
{ "norml", 0x582F0FA1, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* norml<.f> 0,limm 0101111000101111F111111110100001.  */
{ "norml", 0x5E2F7FA1, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* not<.f> b,c 00100bbb00101111FBBBCCCCCC001010.  */
{ "not", 0x202F000A, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RC }, { C_F }},

/* not<.f> 0,c 0010011000101111F111CCCCCC001010.  */
{ "not", 0x262F700A, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RC }, { C_F }},

/* not<.f> b,u6 00100bbb01101111FBBBuuuuuu001010.  */
{ "not", 0x206F000A, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, UIMM6_20 }, { C_F }},

/* not<.f> 0,u6 0010011001101111F111uuuuuu001010.  */
{ "not", 0x266F700A, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, UIMM6_20 }, { C_F }},

/* not<.f> b,limm 00100bbb00101111FBBB111110001010.  */
{ "not", 0x202F0F8A, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, LIMM }, { C_F }},

/* not<.f> 0,limm 0010011000101111F111111110001010.  */
{ "not", 0x262F7F8A, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM }, { C_F }},

/* notl<.f> RB,RC 01011bbb00101111FBBBcccccc001010.  */
{ "notl", 0x582F000A, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* notl<.f> 0,RC 0101111000101111F111cccccc001010.  */
{ "notl", 0x5E2F700A, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RC }, { C_F }},

/* notl<.f> RB,u6 01011bbb01101111FBBBuuuuuu001010.  */
{ "notl", 0x586F000A, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* notl<.f> 0,u6 0101111001101111F111uuuuuu001010.  */
{ "notl", 0x5E6F700A, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* notl<.f> RB,ximm 01011bbb00101111FBBB111100001010.  */
{ "notl", 0x582F0F0A, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { C_F }},

/* notl<.f> 0,ximm 0101111000101111F111111100001010.  */
{ "notl", 0x5E2F7F0A, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM }, { C_F }},

/* notl<.f> RB,limm 01011bbb00101111FBBB111110001010.  */
{ "notl", 0x582F0F8A, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* notl<.f> 0,limm 0101111000101111F111111110001010.  */
{ "notl", 0x5E2F7F8A, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* not_s b,c 01111bbbccc10010.  */
{ "not_s", 0x00007812, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB_S, RC_S }, { 0 }},

/* or<.f> a,b,c 00100bbb00000101FBBBCCCCCCAAAAAA.  */
{ "or", 0x20050000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* or<.f> 0,b,c 00100bbb00000101FBBBCCCCCC111110.  */
{ "or", 0x2005003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* or<.f><.cc> b,b,c 00100bbb11000101FBBBCCCCCC0QQQQQ.  */
{ "or", 0x20C50000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* or<.f> a,b,u6 00100bbb01000101FBBBuuuuuuAAAAAA.  */
{ "or", 0x20450000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* or<.f> 0,b,u6 00100bbb01000101FBBBuuuuuu111110.  */
{ "or", 0x2045003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* or<.f><.cc> b,b,u6 00100bbb11000101FBBBuuuuuu1QQQQQ.  */
{ "or", 0x20C50020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* or<.f> b,b,s12 00100bbb10000101FBBBssssssSSSSSS.  */
{ "or", 0x20850000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* or<.f> a,limm,c 0010011000000101F111CCCCCCAAAAAA.  */
{ "or", 0x26057000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* or<.f> a,b,limm 00100bbb00000101FBBB111110AAAAAA.  */
{ "or", 0x20050F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* or<.f> 0,limm,c 0010011000000101F111CCCCCC111110.  */
{ "or", 0x2605703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* or<.f> 0,b,limm 00100bbb00000101FBBB111110111110.  */
{ "or", 0x20050FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* or<.f><.cc> b,b,limm 00100bbb11000101FBBB1111100QQQQQ.  */
{ "or", 0x20C50F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* or<.f><.cc> 0,limm,c 0010011011000101F111CCCCCC0QQQQQ.  */
{ "or", 0x26C57000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* or<.f> a,limm,u6 0010011001000101F111uuuuuuAAAAAA.  */
{ "or", 0x26457000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* or<.f> 0,limm,u6 0010011001000101F111uuuuuu111110.  */
{ "or", 0x2645703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* or<.f><.cc> 0,limm,u6 0010011011000101F111uuuuuu1QQQQQ.  */
{ "or", 0x26C57020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* or<.f> 0,limm,s12 0010011010000101F111ssssssSSSSSS.  */
{ "or", 0x26857000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* or<.f> a,limm,limm 0010011000000101F111111110AAAAAA.  */
{ "or", 0x26057F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* or<.f> 0,limm,limm 0010011000000101F111111110111110.  */
{ "or", 0x26057FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* or<.f><.cc> 0,limm,limm 0010011011000101F1111111100QQQQQ.  */
{ "or", 0x26C57F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* orl<.f> RA,RB,RC 01011bbb00000101FBBBccccccaaaaaa.  */
{ "orl", 0x58050000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* orl<.f> 0,RB,RC 01011bbb00000101FBBBcccccc111110.  */
{ "orl", 0x5805003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* orl<.f><.cc> RB,RB,RC 01011bbb11000101FBBBcccccc0QQQQQ.  */
{ "orl", 0x58C50000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* orl<.f> RA,RB,u6 01011bbb01000101FBBBuuuuuuaaaaaa.  */
{ "orl", 0x58450000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* orl<.f> 0,RB,u6 01011bbb01000101FBBBuuuuuu111110.  */
{ "orl", 0x5845003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* orl<.f><.cc> RB,RB,u6 01011bbb11000101FBBBuuuuuu1QQQQQ.  */
{ "orl", 0x58C50020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* orl<.f> RB,RB,s12 01011bbb10000101FBBBssssssSSSSSS.  */
{ "orl", 0x58850000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* orl<.f> RA,ximm,RC 0101110000000101F111ccccccaaaaaa.  */
{ "orl", 0x5C057000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* orl<.f> RA,RB,ximm 01011bbb00000101FBBB111100aaaaaa.  */
{ "orl", 0x58050F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* orl<.f> 0,ximm,RC 0101110000000101F111cccccc111110.  */
{ "orl", 0x5C05703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* orl<.f> 0,RB,ximm 01011bbb00000101FBBB111100111110.  */
{ "orl", 0x58050F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* orl<.f><.cc> 0,ximm,RC 0101110011000101F111cccccc0QQQQQ.  */
{ "orl", 0x5CC57000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* orl<.f><.cc> RB,RB,ximm 01011bbb11000101FBBB1111000QQQQQ.  */
{ "orl", 0x58C50F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* orl<.f> RA,ximm,u6 0101110001000101F111uuuuuuaaaaaa.  */
{ "orl", 0x5C457000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* orl<.f> 0,ximm,u6 0101110001000101F111uuuuuu111110.  */
{ "orl", 0x5C45703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* orl<.f><.cc> 0,ximm,u6 0101110011000101F111uuuuuu1QQQQQ.  */
{ "orl", 0x5CC57020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* orl<.f> RA,limm,RC 0101111000000101F111ccccccaaaaaa.  */
{ "orl", 0x5E057000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* orl<.f> RA,RB,limm 01011bbb00000101FBBB111110aaaaaa.  */
{ "orl", 0x58050F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LO32 }, { C_F }},
{ "orl", 0x58050F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* orl<.f> 0,limm,RC 0101111000000101F111cccccc111110.  */
{ "orl", 0x5E05703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* orl<.f> 0,RB,limm 01011bbb00000101FBBB111110111110.  */
{ "orl", 0x58050FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* orl<.f><.cc> 0,limm,RC 0101111011000101F111cccccc0QQQQQ.  */
{ "orl", 0x5EC57000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* orl<.f><.cc> RB,RB,limm 01011bbb11000101FBBB1111100QQQQQ.  */
{ "orl", 0x58C50F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* orl<.f> RA,limm,u6 0101111001000101F111uuuuuuaaaaaa.  */
{ "orl", 0x5E457000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* orl<.f> 0,limm,u6 0101111001000101F111uuuuuu111110.  */
{ "orl", 0x5E45703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* orl<.f><.cc> 0,limm,u6 0101111011000101F111uuuuuu1QQQQQ.  */
{ "orl", 0x5EC57020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* orl<.f> 0,ximm,s12 0101110010000101F111ssssssSSSSSS.  */
{ "orl", 0x5C857000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* orl<.f> 0,limm,s12 0101111010000101F111ssssssSSSSSS.  */
{ "orl", 0x5E857000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* orl<.f> RA,ximm,ximm 0101110000000101F111111100aaaaaa.  */
{ "orl", 0x5C057F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* orl<.f> 0,ximm,ximm 0101110000000101F111111100111110.  */
{ "orl", 0x5C057F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* orl<.f><.cc> 0,ximm,ximm 0101110011000101F1111111000QQQQQ.  */
{ "orl", 0x5CC57F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* orl<.f> RA,limm,limm 0101111000000101F111111110aaaaaa.  */
{ "orl", 0x5E057F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* orl<.f> 0,limm,limm 0101111000000101F111111110111110.  */
{ "orl", 0x5E057FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* orl<.f><.cc> 0,limm,limm 0101111011000101F1111111100QQQQQ.  */
{ "orl", 0x5EC57F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* orl_s b,b,c 01111bbbccc10111.  */
{ "orl_s", 0x00007817, 0x0000F81F, ARC_OPCODE_ARC64, ARITH, NONE, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* orl_s h,h,ximm 01110000hhh110HH.  */
{ "orl_s", 0x00007018, 0x0000FF1C, ARC_OPCODE_ARC64, ARITH, NONE, { RH_S, RH_Sdup, LO32 }, { 0 }},

/* orl_s h,PCL,ximm 01110010hhh110HH.  */
{ "orl_s", 0x00007218, 0x0000FF1C, ARC_OPCODE_ARC64, ARITH, NONE, { RH_S, PCL_S, LO32 }, { 0 }},

/* or_s b,b,c 01111bbbccc00101.  */
{ "or_s", 0x00007805, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* popdl_s b 11000bbb1101BBB1.  */
{ "popdl_s", 0x0000C0D1, 0x0000F8F1, ARC_OPCODE_ARC64, ARITH, NONE, { RBB_S }, { 0 }},

/* popl_s b 11000bbb1100BBB1.  */
{ "popl_s", 0x0000C0C1, 0x0000F8F1, ARC_OPCODE_ARC64, ARITH, NONE, { RBB_S }, { 0 }},

/* prealloc<.aa> b,c 00100bbbaa1100010BBBCCCCCC111110.  */
{ "prealloc", 0x2031003E, 0xF83F803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { BRAKET, RB, RC, BRAKETdup }, { C_AA8 }},

/* prealloc<.aa> b,s9 00010bbbssssssssSBBB0aa001111110.  */
{ "prealloc", 0x1000007E, 0xF80009FF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { BRAKET, RB, SIMM9_8, BRAKETdup }, { C_AA21 }},

/* prealloc<.aa> b,limm 00100bbbaa1100010BBB111110111110.  */
{ "prealloc", 0x20310FBE, 0xF83F8FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { BRAKET, RB, LIMM, BRAKETdup }, { C_AA8 }},

/* prealloc limm,c 00100110RR1100010111CCCCCC111110.  */
{ "prealloc", 0x2631703E, 0xFF3FF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { BRAKET, LIMM, RC, BRAKETdup }, { 0 }},

/* prealloc limm 000101100000000001110RR001111110.  */
{ "prealloc", 0x1600707E, 0xFFFFF9FF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { BRAKET, LIMM, BRAKETdup }, { 0 }},

/* prealloc limm,s9 00010110ssssssssS1110RR001111110.  */
{ "prealloc", 0x1600707E, 0xFF0079FF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { BRAKET, LIMM, SIMM9_8, BRAKETdup }, { 0 }},

/* prefetch<.aa> b,c 00100bbbaa1100000BBBCCCCCC111110.  */
{ "prefetch", 0x2030003E, 0xF83F803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { BRAKET, RB, RC, BRAKETdup }, { C_AA8 }},

/* prefetch<.aa> b,s9 00010bbbssssssssSBBB0aa000111110.  */
{ "prefetch", 0x1000003E, 0xF80009FF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { BRAKET, RB, SIMM9_8, BRAKETdup }, { C_AA21 }},

/* prefetch<.aa> b,limm 00100bbbaa1100000BBB111110111110.  */
{ "prefetch", 0x20300FBE, 0xF83F8FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { BRAKET, RB, LIMM, BRAKETdup }, { C_AA8 }},

/* prefetch limm,c 00100110RR1100000111CCCCCC111110.  */
{ "prefetch", 0x2630703E, 0xFF3FF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { BRAKET, LIMM, RC, BRAKETdup }, { 0 }},

/* prefetch limm 000101100000000001110RR000111110.  */
{ "prefetch", 0x1600703E, 0xFFFFF9FF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { BRAKET, LIMM, BRAKETdup }, { 0 }},

/* prefetch limm,s9 00010110ssssssssS1110RR000111110.  */
{ "prefetch", 0x1600703E, 0xFF0079FF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { BRAKET, LIMM, SIMM9_8, BRAKETdup }, { 0 }},

/* prefetchw<.aa> b,c 00100bbbaa1100001BBBCCCCCC111110.  */
{ "prefetchw", 0x2030803E, 0xF83F803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { BRAKET, RB, RC, BRAKETdup }, { C_AA8 }},

/* prefetchw<.aa> b,s9 00010bbbssssssssSBBB1aa000111110.  */
{ "prefetchw", 0x1000083E, 0xF80009FF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { BRAKET, RB, SIMM9_8, BRAKETdup }, { C_AA21 }},

/* prefetchw<.aa> b,limm 00100bbbaa1100001BBB111110111110.  */
{ "prefetchw", 0x20308FBE, 0xF83F8FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { BRAKET, RB, LIMM, BRAKETdup }, { C_AA8 }},

/* prefetchw limm,c 00100110RR1100001111CCCCCC111110.  */
{ "prefetchw", 0x2630F03E, 0xFF3FF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { BRAKET, LIMM, RC, BRAKETdup }, { 0 }},

/* prefetchw limm 000101100000000001111RR000111110.  */
{ "prefetchw", 0x1600783E, 0xFFFFF9FF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { BRAKET, LIMM, BRAKETdup }, { 0 }},

/* prefetchw limm,s9 00010110ssssssssS1111RR000111110.  */
{ "prefetchw", 0x1600783E, 0xFF0079FF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MEMORY, NONE, { BRAKET, LIMM, SIMM9_8, BRAKETdup }, { 0 }},

/* pushdl_s b 11000bbb1111BBB1.  */
{ "pushdl_s", 0x0000C0F1, 0x0000F8F1, ARC_OPCODE_ARC64, ARITH, NONE, { RBB_S }, { 0 }},

/* pushl_s b 11000bbb1110BBB1.  */
{ "pushl_s", 0x0000C0E1, 0x0000F8F1, ARC_OPCODE_ARC64, ARITH, NONE, { RBB_S }, { 0 }},

/* qmach<.f> a,b,c 00101bbb00110100FBBBCCCCCCAAAAAA.  */
{ "qmach", 0x28340000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, RC }, { C_F }},

/* qmach<.f> 0,b,c 00101bbb00110100FBBBCCCCCC111110.  */
{ "qmach", 0x2834003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, RC }, { C_F }},

/* qmach<.f><.cc> b,b,c 00101bbb11110100FBBBCCCCCC0QQQQQ.  */
{ "qmach", 0x28F40000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* qmach<.f> a,b,u6 00101bbb01110100FBBBuuuuuuAAAAAA.  */
{ "qmach", 0x28740000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* qmach<.f> 0,b,u6 00101bbb01110100FBBBuuuuuu111110.  */
{ "qmach", 0x2874003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { C_F }},

/* qmach<.f><.cc> b,b,u6 00101bbb11110100FBBBuuuuuu1QQQQQ.  */
{ "qmach", 0x28F40020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* qmach<.f> b,b,s12 00101bbb10110100FBBBssssssSSSSSS.  */
{ "qmach", 0x28B40000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* qmach<.f> a,limm,c 0010111000110100F111CCCCCCAAAAAA.  */
{ "qmach", 0x2E347000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, RC }, { C_F }},

/* qmach<.f> a,b,limm 00101bbb00110100FBBB111110AAAAAA.  */
{ "qmach", 0x28340F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, LIMM }, { C_F }},

/* qmach<.f> 0,limm,c 0010111000110100F111CCCCCC111110.  */
{ "qmach", 0x2E34703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_F }},

/* qmach<.f> 0,b,limm 00101bbb00110100FBBB111110111110.  */
{ "qmach", 0x28340FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, LIMM }, { C_F }},

/* qmach<.f><.cc> b,b,limm 00101bbb11110100FBBB1111100QQQQQ.  */
{ "qmach", 0x28F40F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* qmach<.f><.cc> 0,limm,c 0010111011110100F111CCCCCC0QQQQQ.  */
{ "qmach", 0x2EF47000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* qmach<.f> a,limm,u6 0010111001110100F111uuuuuuAAAAAA.  */
{ "qmach", 0x2E747000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* qmach<.f> 0,limm,u6 0010111001110100F111uuuuuu111110.  */
{ "qmach", 0x2E74703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* qmach<.f><.cc> 0,limm,u6 0010111011110100F111uuuuuu1QQQQQ.  */
{ "qmach", 0x2EF47020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* qmach<.f> 0,limm,s12 0010111010110100F111ssssssSSSSSS.  */
{ "qmach", 0x2EB47000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* qmach<.f> a,limm,limm 0010111000110100F111111110AAAAAA.  */
{ "qmach", 0x2E347F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* qmach<.f> 0,limm,limm 0010111000110100F111111110111110.  */
{ "qmach", 0x2E347FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F }},

/* qmach<.f><.cc> 0,limm,limm 0010111011110100F1111111100QQQQQ.  */
{ "qmach", 0x2EF47F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* qmachu<.f> a,b,c 00101bbb00110101FBBBCCCCCCAAAAAA.  */
{ "qmachu", 0x28350000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, RC }, { C_F }},

/* qmachu<.f> 0,b,c 00101bbb00110101FBBBCCCCCC111110.  */
{ "qmachu", 0x2835003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, RC }, { C_F }},

/* qmachu<.f><.cc> b,b,c 00101bbb11110101FBBBCCCCCC0QQQQQ.  */
{ "qmachu", 0x28F50000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* qmachu<.f> a,b,u6 00101bbb01110101FBBBuuuuuuAAAAAA.  */
{ "qmachu", 0x28750000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* qmachu<.f> 0,b,u6 00101bbb01110101FBBBuuuuuu111110.  */
{ "qmachu", 0x2875003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { C_F }},

/* qmachu<.f><.cc> b,b,u6 00101bbb11110101FBBBuuuuuu1QQQQQ.  */
{ "qmachu", 0x28F50020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* qmachu<.f> b,b,s12 00101bbb10110101FBBBssssssSSSSSS.  */
{ "qmachu", 0x28B50000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* qmachu<.f> a,limm,c 0010111000110101F111CCCCCCAAAAAA.  */
{ "qmachu", 0x2E357000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, RC }, { C_F }},

/* qmachu<.f> a,b,limm 00101bbb00110101FBBB111110AAAAAA.  */
{ "qmachu", 0x28350F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, LIMM }, { C_F }},

/* qmachu<.f> 0,limm,c 0010111000110101F111CCCCCC111110.  */
{ "qmachu", 0x2E35703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_F }},

/* qmachu<.f> 0,b,limm 00101bbb00110101FBBB111110111110.  */
{ "qmachu", 0x28350FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, LIMM }, { C_F }},

/* qmachu<.f><.cc> b,b,limm 00101bbb11110101FBBB1111100QQQQQ.  */
{ "qmachu", 0x28F50F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* qmachu<.f><.cc> 0,limm,c 0010111011110101F111CCCCCC0QQQQQ.  */
{ "qmachu", 0x2EF57000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* qmachu<.f> a,limm,u6 0010111001110101F111uuuuuuAAAAAA.  */
{ "qmachu", 0x2E757000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* qmachu<.f> 0,limm,u6 0010111001110101F111uuuuuu111110.  */
{ "qmachu", 0x2E75703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* qmachu<.f><.cc> 0,limm,u6 0010111011110101F111uuuuuu1QQQQQ.  */
{ "qmachu", 0x2EF57020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* qmachu<.f> 0,limm,s12 0010111010110101F111ssssssSSSSSS.  */
{ "qmachu", 0x2EB57000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* qmachu<.f> a,limm,limm 0010111000110101F111111110AAAAAA.  */
{ "qmachu", 0x2E357F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* qmachu<.f> 0,limm,limm 0010111000110101F111111110111110.  */
{ "qmachu", 0x2E357FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F }},

/* qmachu<.f><.cc> 0,limm,limm 0010111011110101F1111111100QQQQQ.  */
{ "qmachu", 0x2EF57F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* qmpyh<.f> a,b,c 00101bbb00110000FBBBCCCCCCAAAAAA.  */
{ "qmpyh", 0x28300000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, RC }, { C_F }},

/* qmpyh<.f> 0,b,c 00101bbb00110000FBBBCCCCCC111110.  */
{ "qmpyh", 0x2830003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, RC }, { C_F }},

/* qmpyh<.f><.cc> b,b,c 00101bbb11110000FBBBCCCCCC0QQQQQ.  */
{ "qmpyh", 0x28F00000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* qmpyh<.f> a,b,u6 00101bbb01110000FBBBuuuuuuAAAAAA.  */
{ "qmpyh", 0x28700000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* qmpyh<.f> 0,b,u6 00101bbb01110000FBBBuuuuuu111110.  */
{ "qmpyh", 0x2870003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { C_F }},

/* qmpyh<.f><.cc> b,b,u6 00101bbb11110000FBBBuuuuuu1QQQQQ.  */
{ "qmpyh", 0x28F00020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* qmpyh<.f> b,b,s12 00101bbb10110000FBBBssssssSSSSSS.  */
{ "qmpyh", 0x28B00000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* qmpyh<.f> a,limm,c 0010111000110000F111CCCCCCAAAAAA.  */
{ "qmpyh", 0x2E307000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, RC }, { C_F }},

/* qmpyh<.f> a,b,limm 00101bbb00110000FBBB111110AAAAAA.  */
{ "qmpyh", 0x28300F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, LIMM }, { C_F }},

/* qmpyh<.f> 0,limm,c 0010111000110000F111CCCCCC111110.  */
{ "qmpyh", 0x2E30703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_F }},

/* qmpyh<.f> 0,b,limm 00101bbb00110000FBBB111110111110.  */
{ "qmpyh", 0x28300FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, LIMM }, { C_F }},

/* qmpyh<.f><.cc> b,b,limm 00101bbb11110000FBBB1111100QQQQQ.  */
{ "qmpyh", 0x28F00F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* qmpyh<.f><.cc> 0,limm,c 0010111011110000F111CCCCCC0QQQQQ.  */
{ "qmpyh", 0x2EF07000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* qmpyh<.f> a,limm,u6 0010111001110000F111uuuuuuAAAAAA.  */
{ "qmpyh", 0x2E707000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* qmpyh<.f> 0,limm,u6 0010111001110000F111uuuuuu111110.  */
{ "qmpyh", 0x2E70703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* qmpyh<.f><.cc> 0,limm,u6 0010111011110000F111uuuuuu1QQQQQ.  */
{ "qmpyh", 0x2EF07020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* qmpyh<.f> 0,limm,s12 0010111010110000F111ssssssSSSSSS.  */
{ "qmpyh", 0x2EB07000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* qmpyh<.f> a,limm,limm 0010111000110000F111111110AAAAAA.  */
{ "qmpyh", 0x2E307F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* qmpyh<.f> 0,limm,limm 0010111000110000F111111110111110.  */
{ "qmpyh", 0x2E307FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F }},

/* qmpyh<.f><.cc> 0,limm,limm 0010111011110000F1111111100QQQQQ.  */
{ "qmpyh", 0x2EF07F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* qmpyhu<.f> a,b,c 00101bbb00110001FBBBCCCCCCAAAAAA.  */
{ "qmpyhu", 0x28310000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, RC }, { C_F }},

/* qmpyhu<.f> 0,b,c 00101bbb00110001FBBBCCCCCC111110.  */
{ "qmpyhu", 0x2831003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, RC }, { C_F }},

/* qmpyhu<.f><.cc> b,b,c 00101bbb11110001FBBBCCCCCC0QQQQQ.  */
{ "qmpyhu", 0x28F10000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* qmpyhu<.f> a,b,u6 00101bbb01110001FBBBuuuuuuAAAAAA.  */
{ "qmpyhu", 0x28710000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* qmpyhu<.f> 0,b,u6 00101bbb01110001FBBBuuuuuu111110.  */
{ "qmpyhu", 0x2871003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { C_F }},

/* qmpyhu<.f><.cc> b,b,u6 00101bbb11110001FBBBuuuuuu1QQQQQ.  */
{ "qmpyhu", 0x28F10020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* qmpyhu<.f> b,b,s12 00101bbb10110001FBBBssssssSSSSSS.  */
{ "qmpyhu", 0x28B10000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* qmpyhu<.f> a,limm,c 0010111000110001F111CCCCCCAAAAAA.  */
{ "qmpyhu", 0x2E317000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, RC }, { C_F }},

/* qmpyhu<.f> a,b,limm 00101bbb00110001FBBB111110AAAAAA.  */
{ "qmpyhu", 0x28310F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, LIMM }, { C_F }},

/* qmpyhu<.f> 0,limm,c 0010111000110001F111CCCCCC111110.  */
{ "qmpyhu", 0x2E31703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_F }},

/* qmpyhu<.f> 0,b,limm 00101bbb00110001FBBB111110111110.  */
{ "qmpyhu", 0x28310FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, LIMM }, { C_F }},

/* qmpyhu<.f><.cc> b,b,limm 00101bbb11110001FBBB1111100QQQQQ.  */
{ "qmpyhu", 0x28F10F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* qmpyhu<.f><.cc> 0,limm,c 0010111011110001F111CCCCCC0QQQQQ.  */
{ "qmpyhu", 0x2EF17000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_F, C_CC }},

/* qmpyhu<.f> a,limm,u6 0010111001110001F111uuuuuuAAAAAA.  */
{ "qmpyhu", 0x2E717000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* qmpyhu<.f> 0,limm,u6 0010111001110001F111uuuuuu111110.  */
{ "qmpyhu", 0x2E71703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* qmpyhu<.f><.cc> 0,limm,u6 0010111011110001F111uuuuuu1QQQQQ.  */
{ "qmpyhu", 0x2EF17020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* qmpyhu<.f> 0,limm,s12 0010111010110001F111ssssssSSSSSS.  */
{ "qmpyhu", 0x2EB17000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* qmpyhu<.f> a,limm,limm 0010111000110001F111111110AAAAAA.  */
{ "qmpyhu", 0x2E317F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* qmpyhu<.f> 0,limm,limm 0010111000110001F111111110111110.  */
{ "qmpyhu", 0x2E317FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F }},

/* qmpyhu<.f><.cc> 0,limm,limm 0010111011110001F1111111100QQQQQ.  */
{ "qmpyhu", 0x2EF17F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* rcmp b,c 00100bbb000011011BBBCCCCCCRRRRRR.  */
{ "rcmp", 0x200D8000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { 0 }},

/* rcmp<.cc> b,c 00100bbb110011011BBBCCCCCC0QQQQQ.  */
{ "rcmp", 0x20CD8000, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_CC }},

/* rcmp b,u6 00100bbb010011011BBBuuuuuuRRRRRR.  */
{ "rcmp", 0x204D8000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { 0 }},

/* rcmp<.cc> b,u6 00100bbb110011011BBBuuuuuu1QQQQQ.  */
{ "rcmp", 0x20CD8020, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_CC }},

/* rcmp b,s12 00100bbb100011011BBBssssssSSSSSS.  */
{ "rcmp", 0x208D8000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, SIMM12_20 }, { 0 }},

/* rcmp limm,c 00100110000011011111CCCCCCRRRRRR.  */
{ "rcmp", 0x260DF000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, RC }, { 0 }},

/* rcmp b,limm 00100bbb000011011BBB111110RRRRRR.  */
{ "rcmp", 0x200D8F80, 0xF8FF8FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { 0 }},

/* rcmp<.cc> limm,c 00100110110011011111CCCCCC0QQQQQ.  */
{ "rcmp", 0x26CDF000, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, RC }, { C_CC }},

/* rcmp<.cc> b,limm 00100bbb110011011BBB1111100QQQQQ.  */
{ "rcmp", 0x20CD8F80, 0xF8FF8FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_CC }},

/* rcmp limm,u6 00100110010011011111uuuuuuRRRRRR.  */
{ "rcmp", 0x264DF000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, UIMM6_20 }, { 0 }},

/* rcmp<.cc> limm,u6 00100110110011011111uuuuuu1QQQQQ.  */
{ "rcmp", 0x26CDF020, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, UIMM6_20 }, { C_CC }},

/* rcmp limm,s12 00100110100011011111ssssssSSSSSS.  */
{ "rcmp", 0x268DF000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, SIMM12_20 }, { 0 }},

/* rcmp limm,limm 00100110000011011111111110RRRRRR.  */
{ "rcmp", 0x260DFF80, 0xFFFFFFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, LIMMdup }, { 0 }},

/* rcmp<.cc> limm,limm 001001101100110111111111100QQQQQ.  */
{ "rcmp", 0x26CDFF80, 0xFFFFFFE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, LIMMdup }, { C_CC }},

/* rcmpl RB,RC 01011bbb000011011BBBccccccRRRRRR.  */
{ "rcmpl", 0x580D8000, 0xF8FF8000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { 0 }},

/* rcmpl<.cc> RB,RC 01011bbb110011011BBBcccccc0QQQQQ.  */
{ "rcmpl", 0x58CD8000, 0xF8FF8020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_CC }},

/* rcmpl RB,u6 01011bbb010011011BBBuuuuuuRRRRRR.  */
{ "rcmpl", 0x584D8000, 0xF8FF8000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { 0 }},

/* rcmpl<.cc> RB,u6 01011bbb110011011BBBuuuuuu1QQQQQ.  */
{ "rcmpl", 0x58CD8020, 0xF8FF8020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_CC }},

/* rcmpl RB,s12 01011bbb100011011BBBssssssSSSSSS.  */
{ "rcmpl", 0x588D8000, 0xF8FF8000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, SIMM12_20 }, { 0 }},

/* rcmpl ximm,RC 01011100000011011111ccccccRRRRRR.  */
{ "rcmpl", 0x5C0DF000, 0xFFFFF000, ARC_OPCODE_ARC64, ARITH, NONE, { XIMM, RC }, { 0 }},

/* rcmpl RB,ximm 01011bbb000011011BBB111100RRRRRR.  */
{ "rcmpl", 0x580D8F00, 0xF8FF8FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { 0 }},

/* rcmpl<.cc> RB,ximm 01011bbb110011011BBB1111000QQQQQ.  */
{ "rcmpl", 0x58CD8F00, 0xF8FF8FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { C_CC }},

/* rcmpl limm,RC 01011110000011011111ccccccRRRRRR.  */
{ "rcmpl", 0x5E0DF000, 0xFFFFF000, ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, RC }, { 0 }},

/* rcmpl RB,limm 01011bbb000011011BBB111110RRRRRR.  */
{ "rcmpl", 0x580D8F80, 0xF8FF8FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { 0 }},

/* rcmpl<.cc> RB,limm 01011bbb110011011BBB1111100QQQQQ.  */
{ "rcmpl", 0x58CD8F80, 0xF8FF8FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_CC }},

/* rcmpl limm,u6 01011110010011011111uuuuuuRRRRRR.  */
{ "rcmpl", 0x5E4DF000, 0xFFFFF000, ARC_OPCODE_ARC64, ARITH, NONE, { LIMM, UIMM6_20 }, { 0 }},

/* rem<.f> a,b,c 00101bbb00001000FBBBCCCCCCAAAAAA.  */
{ "rem", 0x28080000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, RB, RC }, { C_F }},

/* rem<.f> 0,b,c 00101bbb00001000FBBBCCCCCC111110.  */
{ "rem", 0x2808003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, RB, RC }, { C_F }},

/* rem<.f><.cc> b,b,c 00101bbb11001000FBBBCCCCCC0QQQQQ.  */
{ "rem", 0x28C80000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* rem<.f> a,b,u6 00101bbb01001000FBBBuuuuuuAAAAAA.  */
{ "rem", 0x28480000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* rem<.f> 0,b,u6 00101bbb01001000FBBBuuuuuu111110.  */
{ "rem", 0x2848003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, RB, UIMM6_20 }, { C_F }},

/* rem<.f><.cc> b,b,u6 00101bbb11001000FBBBuuuuuu1QQQQQ.  */
{ "rem", 0x28C80020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* rem<.f> b,b,s12 00101bbb10001000FBBBssssssSSSSSS.  */
{ "rem", 0x28880000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* rem<.f> a,limm,c 0010111000001000F111CCCCCCAAAAAA.  */
{ "rem", 0x2E087000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, LIMM, RC }, { C_F }},

/* rem<.f> a,b,limm 00101bbb00001000FBBB111110AAAAAA.  */
{ "rem", 0x28080F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, RB, LIMM }, { C_F }},

/* rem<.f> 0,limm,c 0010111000001000F111CCCCCC111110.  */
{ "rem", 0x2E08703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, RC }, { C_F }},

/* rem<.f> 0,b,limm 00101bbb00001000FBBB111110111110.  */
{ "rem", 0x28080FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, RB, LIMM }, { C_F }},

/* rem<.f><.cc> b,b,limm 00101bbb11001000FBBB1111100QQQQQ.  */
{ "rem", 0x28C80F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* rem<.f><.cc> 0,limm,c 0010111011001000F111CCCCCC0QQQQQ.  */
{ "rem", 0x2EC87000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, RC }, { C_F, C_CC }},

/* rem<.f> a,limm,u6 0010111001001000F111uuuuuuAAAAAA.  */
{ "rem", 0x2E487000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* rem<.f> 0,limm,u6 0010111001001000F111uuuuuu111110.  */
{ "rem", 0x2E48703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* rem<.f><.cc> 0,limm,u6 0010111011001000F111uuuuuu1QQQQQ.  */
{ "rem", 0x2EC87020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* rem<.f> 0,limm,s12 0010111010001000F111ssssssSSSSSS.  */
{ "rem", 0x2E887000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* rem<.f> a,limm,limm 0010111000001000F111111110AAAAAA.  */
{ "rem", 0x2E087F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* rem<.f> 0,limm,limm 0010111000001000F111111110111110.  */
{ "rem", 0x2E087FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, LIMMdup }, { C_F }},

/* rem<.f><.cc> 0,limm,limm 0010111011001000F1111111100QQQQQ.  */
{ "rem", 0x2EC87F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* reml<.f> RA,RB,RC 01011bbb00101000FBBBccccccaaaaaa.  */
{ "reml", 0x58280000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* reml<.f> 0,RB,RC 01011bbb00101000FBBBcccccc111110.  */
{ "reml", 0x5828003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* reml<.f><.cc> RB,RB,RC 01011bbb11101000FBBBcccccc0QQQQQ.  */
{ "reml", 0x58E80000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* reml<.f> RA,RB,u6 01011bbb01101000FBBBuuuuuuaaaaaa.  */
{ "reml", 0x58680000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* reml<.f> 0,RB,u6 01011bbb01101000FBBBuuuuuu111110.  */
{ "reml", 0x5868003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* reml<.f><.cc> RB,RB,u6 01011bbb11101000FBBBuuuuuu1QQQQQ.  */
{ "reml", 0x58E80020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* reml<.f> RB,RB,s12 01011bbb10101000FBBBssssssSSSSSS.  */
{ "reml", 0x58A80000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* reml<.f> RA,ximm,RC 0101110000101000F111ccccccaaaaaa.  */
{ "reml", 0x5C287000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* reml<.f> RA,RB,ximm 01011bbb00101000FBBB111100aaaaaa.  */
{ "reml", 0x58280F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* reml<.f> 0,ximm,RC 0101110000101000F111cccccc111110.  */
{ "reml", 0x5C28703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* reml<.f> 0,RB,ximm 01011bbb00101000FBBB111100111110.  */
{ "reml", 0x58280F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* reml<.f><.cc> 0,ximm,RC 0101110011101000F111cccccc0QQQQQ.  */
{ "reml", 0x5CE87000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* reml<.f><.cc> RB,RB,ximm 01011bbb11101000FBBB1111000QQQQQ.  */
{ "reml", 0x58E80F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* reml<.f> RA,ximm,u6 0101110001101000F111uuuuuuaaaaaa.  */
{ "reml", 0x5C687000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* reml<.f> 0,ximm,u6 0101110001101000F111uuuuuu111110.  */
{ "reml", 0x5C68703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* reml<.f><.cc> 0,ximm,u6 0101110011101000F111uuuuuu1QQQQQ.  */
{ "reml", 0x5CE87020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* reml<.f> RA,limm,RC 0101111000101000F111ccccccaaaaaa.  */
{ "reml", 0x5E287000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* reml<.f> RA,RB,limm 01011bbb00101000FBBB111110aaaaaa.  */
{ "reml", 0x58280F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* reml<.f> 0,limm,RC 0101111000101000F111cccccc111110.  */
{ "reml", 0x5E28703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* reml<.f> 0,RB,limm 01011bbb00101000FBBB111110111110.  */
{ "reml", 0x58280FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* reml<.f><.cc> 0,limm,RC 0101111011101000F111cccccc0QQQQQ.  */
{ "reml", 0x5EE87000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* reml<.f><.cc> RB,RB,limm 01011bbb11101000FBBB1111100QQQQQ.  */
{ "reml", 0x58E80F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* reml<.f> RA,limm,u6 0101111001101000F111uuuuuuaaaaaa.  */
{ "reml", 0x5E687000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* reml<.f> 0,limm,u6 0101111001101000F111uuuuuu111110.  */
{ "reml", 0x5E68703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* reml<.f><.cc> 0,limm,u6 0101111011101000F111uuuuuu1QQQQQ.  */
{ "reml", 0x5EE87020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* reml<.f> 0,ximm,s12 0101110010101000F111ssssssSSSSSS.  */
{ "reml", 0x5CA87000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* reml<.f> 0,limm,s12 0101111010101000F111ssssssSSSSSS.  */
{ "reml", 0x5EA87000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* reml<.f> RA,ximm,ximm 0101110000101000F111111100aaaaaa.  */
{ "reml", 0x5C287F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* reml<.f> 0,ximm,ximm 0101110000101000F111111100111110.  */
{ "reml", 0x5C287F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* reml<.f><.cc> 0,ximm,ximm 0101110011101000F1111111000QQQQQ.  */
{ "reml", 0x5CE87F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* reml<.f> RA,limm,limm 0101111000101000F111111110aaaaaa.  */
{ "reml", 0x5E287F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* reml<.f> 0,limm,limm 0101111000101000F111111110111110.  */
{ "reml", 0x5E287FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* reml<.f><.cc> 0,limm,limm 0101111011101000F1111111100QQQQQ.  */
{ "reml", 0x5EE87F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* remu<.f> a,b,c 00101bbb00001001FBBBCCCCCCAAAAAA.  */
{ "remu", 0x28090000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, RB, RC }, { C_F }},

/* remu<.f> 0,b,c 00101bbb00001001FBBBCCCCCC111110.  */
{ "remu", 0x2809003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, RB, RC }, { C_F }},

/* remu<.f><.cc> b,b,c 00101bbb11001001FBBBCCCCCC0QQQQQ.  */
{ "remu", 0x28C90000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RB_CHK, RBdup, RC }, { C_F, C_CC }},

/* remu<.f> a,b,u6 00101bbb01001001FBBBuuuuuuAAAAAA.  */
{ "remu", 0x28490000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, RB, UIMM6_20 }, { C_F }},

/* remu<.f> 0,b,u6 00101bbb01001001FBBBuuuuuu111110.  */
{ "remu", 0x2849003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, RB, UIMM6_20 }, { C_F }},

/* remu<.f><.cc> b,b,u6 00101bbb11001001FBBBuuuuuu1QQQQQ.  */
{ "remu", 0x28C90020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RB_CHK, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* remu<.f> b,b,s12 00101bbb10001001FBBBssssssSSSSSS.  */
{ "remu", 0x28890000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RB_CHK, RBdup, SIMM12_20 }, { C_F }},

/* remu<.f> a,limm,c 0010111000001001F111CCCCCCAAAAAA.  */
{ "remu", 0x2E097000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, LIMM, RC }, { C_F }},

/* remu<.f> a,b,limm 00101bbb00001001FBBB111110AAAAAA.  */
{ "remu", 0x28090F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, RB, LIMM }, { C_F }},

/* remu<.f> 0,limm,c 0010111000001001F111CCCCCC111110.  */
{ "remu", 0x2E09703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, RC }, { C_F }},

/* remu<.f> 0,b,limm 00101bbb00001001FBBB111110111110.  */
{ "remu", 0x28090FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, RB, LIMM }, { C_F }},

/* remu<.f><.cc> b,b,limm 00101bbb11001001FBBB1111100QQQQQ.  */
{ "remu", 0x28C90F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RB_CHK, RBdup, LIMM }, { C_F, C_CC }},

/* remu<.f><.cc> 0,limm,c 0010111011001001F111CCCCCC0QQQQQ.  */
{ "remu", 0x2EC97000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, RC }, { C_F, C_CC }},

/* remu<.f> a,limm,u6 0010111001001001F111uuuuuuAAAAAA.  */
{ "remu", 0x2E497000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, LIMM, UIMM6_20 }, { C_F }},

/* remu<.f> 0,limm,u6 0010111001001001F111uuuuuu111110.  */
{ "remu", 0x2E49703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* remu<.f><.cc> 0,limm,u6 0010111011001001F111uuuuuu1QQQQQ.  */
{ "remu", 0x2EC97020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* remu<.f> 0,limm,s12 0010111010001001F111ssssssSSSSSS.  */
{ "remu", 0x2E897000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* remu<.f> a,limm,limm 0010111000001001F111111110AAAAAA.  */
{ "remu", 0x2E097F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { RA_CHK, LIMM, LIMMdup }, { C_F }},

/* remu<.f> 0,limm,limm 0010111000001001F111111110111110.  */
{ "remu", 0x2E097FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, LIMMdup }, { C_F }},

/* remu<.f><.cc> 0,limm,limm 0010111011001001F1111111100QQQQQ.  */
{ "remu", 0x2EC97F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, DIVREM, DIV, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* remul<.f> RA,RB,RC 01011bbb00101001FBBBccccccaaaaaa.  */
{ "remul", 0x58290000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* remul<.f> 0,RB,RC 01011bbb00101001FBBBcccccc111110.  */
{ "remul", 0x5829003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* remul<.f><.cc> RB,RB,RC 01011bbb11101001FBBBcccccc0QQQQQ.  */
{ "remul", 0x58E90000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* remul<.f> RA,RB,u6 01011bbb01101001FBBBuuuuuuaaaaaa.  */
{ "remul", 0x58690000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* remul<.f> 0,RB,u6 01011bbb01101001FBBBuuuuuu111110.  */
{ "remul", 0x5869003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* remul<.f><.cc> RB,RB,u6 01011bbb11101001FBBBuuuuuu1QQQQQ.  */
{ "remul", 0x58E90020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* remul<.f> RB,RB,s12 01011bbb10101001FBBBssssssSSSSSS.  */
{ "remul", 0x58A90000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* remul<.f> RA,ximm,RC 0101110000101001F111ccccccaaaaaa.  */
{ "remul", 0x5C297000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* remul<.f> RA,RB,ximm 01011bbb00101001FBBB111100aaaaaa.  */
{ "remul", 0x58290F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* remul<.f> 0,ximm,RC 0101110000101001F111cccccc111110.  */
{ "remul", 0x5C29703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* remul<.f> 0,RB,ximm 01011bbb00101001FBBB111100111110.  */
{ "remul", 0x58290F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* remul<.f><.cc> 0,ximm,RC 0101110011101001F111cccccc0QQQQQ.  */
{ "remul", 0x5CE97000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* remul<.f><.cc> RB,RB,ximm 01011bbb11101001FBBB1111000QQQQQ.  */
{ "remul", 0x58E90F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* remul<.f> RA,ximm,u6 0101110001101001F111uuuuuuaaaaaa.  */
{ "remul", 0x5C697000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* remul<.f> 0,ximm,u6 0101110001101001F111uuuuuu111110.  */
{ "remul", 0x5C69703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* remul<.f><.cc> 0,ximm,u6 0101110011101001F111uuuuuu1QQQQQ.  */
{ "remul", 0x5CE97020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* remul<.f> RA,limm,RC 0101111000101001F111ccccccaaaaaa.  */
{ "remul", 0x5E297000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* remul<.f> RA,RB,limm 01011bbb00101001FBBB111110aaaaaa.  */
{ "remul", 0x58290F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* remul<.f> 0,limm,RC 0101111000101001F111cccccc111110.  */
{ "remul", 0x5E29703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* remul<.f> 0,RB,limm 01011bbb00101001FBBB111110111110.  */
{ "remul", 0x58290FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* remul<.f><.cc> 0,limm,RC 0101111011101001F111cccccc0QQQQQ.  */
{ "remul", 0x5EE97000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* remul<.f><.cc> RB,RB,limm 01011bbb11101001FBBB1111100QQQQQ.  */
{ "remul", 0x58E90F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* remul<.f> RA,limm,u6 0101111001101001F111uuuuuuaaaaaa.  */
{ "remul", 0x5E697000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* remul<.f> 0,limm,u6 0101111001101001F111uuuuuu111110.  */
{ "remul", 0x5E69703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* remul<.f><.cc> 0,limm,u6 0101111011101001F111uuuuuu1QQQQQ.  */
{ "remul", 0x5EE97020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* remul<.f> 0,ximm,s12 0101110010101001F111ssssssSSSSSS.  */
{ "remul", 0x5CA97000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* remul<.f> 0,limm,s12 0101111010101001F111ssssssSSSSSS.  */
{ "remul", 0x5EA97000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* remul<.f> RA,ximm,ximm 0101110000101001F111111100aaaaaa.  */
{ "remul", 0x5C297F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* remul<.f> 0,ximm,ximm 0101110000101001F111111100111110.  */
{ "remul", 0x5C297F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* remul<.f><.cc> 0,ximm,ximm 0101110011101001F1111111000QQQQQ.  */
{ "remul", 0x5CE97F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* remul<.f> RA,limm,limm 0101111000101001F111111110aaaaaa.  */
{ "remul", 0x5E297F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* remul<.f> 0,limm,limm 0101111000101001F111111110111110.  */
{ "remul", 0x5E297FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* remul<.f><.cc> 0,limm,limm 0101111011101001F1111111100QQQQQ.  */
{ "remul", 0x5EE97F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* rlc<.f> b,c 00100bbb00101111FBBBCCCCCC001011.  */
{ "rlc", 0x202F000B, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RC }, { C_F }},

/* rlc<.f> 0,c 0010011000101111F111CCCCCC001011.  */
{ "rlc", 0x262F700B, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RC }, { C_F }},

/* rlc<.f> b,u6 00100bbb01101111FBBBuuuuuu001011.  */
{ "rlc", 0x206F000B, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, UIMM6_20 }, { C_F }},

/* rlc<.f> 0,u6 0010011001101111F111uuuuuu001011.  */
{ "rlc", 0x266F700B, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, UIMM6_20 }, { C_F }},

/* rlc<.f> b,limm 00100bbb00101111FBBB111110001011.  */
{ "rlc", 0x202F0F8B, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, LIMM }, { C_F }},

/* rlc<.f> 0,limm 0010011000101111F111111110001011.  */
{ "rlc", 0x262F7F8B, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM }, { C_F }},

/* rol<.f> b,c 00100bbb00101111FBBBCCCCCC001101.  */
{ "rol", 0x202F000D, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RC }, { C_F }},

/* rol<.f> 0,c 0010011000101111F111CCCCCC001101.  */
{ "rol", 0x262F700D, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RC }, { C_F }},

/* rol<.f> b,u6 00100bbb01101111FBBBuuuuuu001101.  */
{ "rol", 0x206F000D, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, UIMM6_20 }, { C_F }},

/* rol<.f> 0,u6 0010011001101111F111uuuuuu001101.  */
{ "rol", 0x266F700D, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, UIMM6_20 }, { C_F }},

/* rol<.f> b,limm 00100bbb00101111FBBB111110001101.  */
{ "rol", 0x202F0F8D, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, LIMM }, { C_F }},

/* rol<.f> 0,limm 0010011000101111F111111110001101.  */
{ "rol", 0x262F7F8D, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM }, { C_F }},

/* rol8<.f> b,c 00101bbb00101111FBBBCCCCCC010000.  */
{ "rol8", 0x282F0010, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT1, { RB, RC }, { C_F }},

/* rol8<.f> 0,c 0010111000101111F111CCCCCC010000.  */
{ "rol8", 0x2E2F7010, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT1, { ZA, RC }, { C_F }},

/* rol8<.f> b,u6 00101bbb01101111FBBBuuuuuu010000.  */
{ "rol8", 0x286F0010, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT1, { RB, UIMM6_20 }, { C_F }},

/* rol8<.f> 0,u6 0010111001101111F111uuuuuu010000.  */
{ "rol8", 0x2E6F7010, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT1, { ZA, UIMM6_20 }, { C_F }},

/* rol8<.f> b,limm 00101bbb00101111FBBB111110010000.  */
{ "rol8", 0x282F0F90, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT1, { RB, LIMM }, { C_F }},

/* rol8<.f> 0,limm 0010111000101111F111111110010000.  */
{ "rol8", 0x2E2F7F90, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT1, { ZA, LIMM }, { C_F }},

/* ror<.f> b,c 00100bbb00101111FBBBCCCCCC000011.  */
{ "ror", 0x202F0003, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RC }, { C_F }},

/* ror<.f> 0,c 0010011000101111F111CCCCCC000011.  */
{ "ror", 0x262F7003, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RC }, { C_F }},

/* ror<.f> a,b,c 00101bbb00000011FBBBCCCCCCAAAAAA.  */
{ "ror", 0x28030000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, RB, RC }, { C_F }},

/* ror<.f> 0,b,c 00101bbb00000011FBBBCCCCCC111110.  */
{ "ror", 0x2803003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, RB, RC }, { C_F }},

/* ror<.f><.cc> b,b,c 00101bbb11000011FBBBCCCCCC0QQQQQ.  */
{ "ror", 0x28C30000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RB, RBdup, RC }, { C_F, C_CC }},

/* ror<.f> b,u6 00100bbb01101111FBBBuuuuuu000011.  */
{ "ror", 0x206F0003, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, UIMM6_20 }, { C_F }},

/* ror<.f> 0,u6 0010011001101111F111uuuuuu000011.  */
{ "ror", 0x266F7003, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, UIMM6_20 }, { C_F }},

/* ror<.f> a,b,u6 00101bbb01000011FBBBuuuuuuAAAAAA.  */
{ "ror", 0x28430000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, RB, UIMM6_20 }, { C_F }},

/* ror<.f> 0,b,u6 00101bbb01000011FBBBuuuuuu111110.  */
{ "ror", 0x2843003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, RB, UIMM6_20 }, { C_F }},

/* ror<.f><.cc> b,b,u6 00101bbb11000011FBBBuuuuuu1QQQQQ.  */
{ "ror", 0x28C30020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* ror<.f> b,b,s12 00101bbb10000011FBBBssssssSSSSSS.  */
{ "ror", 0x28830000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RB, RBdup, SIMM12_20 }, { C_F }},

/* ror<.f> b,limm 00100bbb00101111FBBB111110000011.  */
{ "ror", 0x202F0F83, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, LIMM }, { C_F }},

/* ror<.f> 0,limm 0010011000101111F111111110000011.  */
{ "ror", 0x262F7F83, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM }, { C_F }},

/* ror<.f> a,limm,c 0010111000000011F111CCCCCCAAAAAA.  */
{ "ror", 0x2E037000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, LIMM, RC }, { C_F }},

/* ror<.f> a,b,limm 00101bbb00000011FBBB111110AAAAAA.  */
{ "ror", 0x28030F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, RB, LIMM }, { C_F }},

/* ror<.f> 0,limm,c 0010111000000011F111CCCCCC111110.  */
{ "ror", 0x2E03703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, RC }, { C_F }},

/* ror<.f> 0,b,limm 00101bbb00000011FBBB111110111110.  */
{ "ror", 0x28030FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, RB, LIMM }, { C_F }},

/* ror<.f><.cc> b,b,limm 00101bbb11000011FBBB1111100QQQQQ.  */
{ "ror", 0x28C30F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* ror<.f><.cc> 0,limm,c 0010111011000011F111CCCCCC0QQQQQ.  */
{ "ror", 0x2EC37000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, RC }, { C_F, C_CC }},

/* ror<.f> a,limm,u6 0010111001000011F111uuuuuuAAAAAA.  */
{ "ror", 0x2E437000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, LIMM, UIMM6_20 }, { C_F }},

/* ror<.f> 0,limm,u6 0010111001000011F111uuuuuu111110.  */
{ "ror", 0x2E43703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* ror<.f><.cc> 0,limm,u6 0010111011000011F111uuuuuu1QQQQQ.  */
{ "ror", 0x2EC37020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* ror<.f> 0,limm,s12 0010111010000011F111ssssssSSSSSS.  */
{ "ror", 0x2E837000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* ror<.f> a,limm,limm 0010111000000011F111111110AAAAAA.  */
{ "ror", 0x2E037F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { RA, LIMM, LIMMdup }, { C_F }},

/* ror<.f> 0,limm,limm 0010111000000011F111111110111110.  */
{ "ror", 0x2E037FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, LIMMdup }, { C_F }},

/* ror<.f><.cc> 0,limm,limm 0010111011000011F1111111100QQQQQ.  */
{ "ror", 0x2EC37F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT2, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* ror8<.f> b,c 00101bbb00101111FBBBCCCCCC010001.  */
{ "ror8", 0x282F0011, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT1, { RB, RC }, { C_F }},

/* ror8<.f> 0,c 0010111000101111F111CCCCCC010001.  */
{ "ror8", 0x2E2F7011, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT1, { ZA, RC }, { C_F }},

/* ror8<.f> b,u6 00101bbb01101111FBBBuuuuuu010001.  */
{ "ror8", 0x286F0011, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT1, { RB, UIMM6_20 }, { C_F }},

/* ror8<.f> 0,u6 0010111001101111F111uuuuuu010001.  */
{ "ror8", 0x2E6F7011, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT1, { ZA, UIMM6_20 }, { C_F }},

/* ror8<.f> b,limm 00101bbb00101111FBBB111110010001.  */
{ "ror8", 0x282F0F91, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT1, { RB, LIMM }, { C_F }},

/* ror8<.f> 0,limm 0010111000101111F111111110010001.  */
{ "ror8", 0x2E2F7F91, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, SHFT1, { ZA, LIMM }, { C_F }},

/* rrc<.f> b,c 00100bbb00101111FBBBCCCCCC000100.  */
{ "rrc", 0x202F0004, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RC }, { C_F }},

/* rrc<.f> 0,c 0010011000101111F111CCCCCC000100.  */
{ "rrc", 0x262F7004, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RC }, { C_F }},

/* rrc<.f> b,u6 00100bbb01101111FBBBuuuuuu000100.  */
{ "rrc", 0x206F0004, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, UIMM6_20 }, { C_F }},

/* rrc<.f> 0,u6 0010011001101111F111uuuuuu000100.  */
{ "rrc", 0x266F7004, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, UIMM6_20 }, { C_F }},

/* rrc<.f> b,limm 00100bbb00101111FBBB111110000100.  */
{ "rrc", 0x202F0F84, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, LIMM }, { C_F }},

/* rrc<.f> 0,limm 0010011000101111F111111110000100.  */
{ "rrc", 0x262F7F84, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM }, { C_F }},

/* rsub<.f> a,b,c 00100bbb00001110FBBBCCCCCCAAAAAA.  */
{ "rsub", 0x200E0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* rsub<.f> 0,b,c 00100bbb00001110FBBBCCCCCC111110.  */
{ "rsub", 0x200E003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* rsub<.f><.cc> b,b,c 00100bbb11001110FBBBCCCCCC0QQQQQ.  */
{ "rsub", 0x20CE0000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* rsub<.f> a,b,u6 00100bbb01001110FBBBuuuuuuAAAAAA.  */
{ "rsub", 0x204E0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* rsub<.f> 0,b,u6 00100bbb01001110FBBBuuuuuu111110.  */
{ "rsub", 0x204E003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* rsub<.f><.cc> b,b,u6 00100bbb11001110FBBBuuuuuu1QQQQQ.  */
{ "rsub", 0x20CE0020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* rsub<.f> b,b,s12 00100bbb10001110FBBBssssssSSSSSS.  */
{ "rsub", 0x208E0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* rsub<.f> a,limm,c 0010011000001110F111CCCCCCAAAAAA.  */
{ "rsub", 0x260E7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* rsub<.f> a,b,limm 00100bbb00001110FBBB111110AAAAAA.  */
{ "rsub", 0x200E0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* rsub<.f> 0,limm,c 0010011000001110F111CCCCCC111110.  */
{ "rsub", 0x260E703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* rsub<.f> 0,b,limm 00100bbb00001110FBBB111110111110.  */
{ "rsub", 0x200E0FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* rsub<.f><.cc> b,b,limm 00100bbb11001110FBBB1111100QQQQQ.  */
{ "rsub", 0x20CE0F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* rsub<.f><.cc> 0,limm,c 0010011011001110F111CCCCCC0QQQQQ.  */
{ "rsub", 0x26CE7000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* rsub<.f> a,limm,u6 0010011001001110F111uuuuuuAAAAAA.  */
{ "rsub", 0x264E7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* rsub<.f> 0,limm,u6 0010011001001110F111uuuuuu111110.  */
{ "rsub", 0x264E703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* rsub<.f><.cc> 0,limm,u6 0010011011001110F111uuuuuu1QQQQQ.  */
{ "rsub", 0x26CE7020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* rsub<.f> 0,limm,s12 0010011010001110F111ssssssSSSSSS.  */
{ "rsub", 0x268E7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* rsub<.f> a,limm,limm 0010011000001110F111111110AAAAAA.  */
{ "rsub", 0x260E7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* rsub<.f> 0,limm,limm 0010011000001110F111111110111110.  */
{ "rsub", 0x260E7FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* rsub<.f><.cc> 0,limm,limm 0010011011001110F1111111100QQQQQ.  */
{ "rsub", 0x26CE7F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* rsubl<.f> RA,RB,RC 01011bbb00001110FBBBccccccaaaaaa.  */
{ "rsubl", 0x580E0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* rsubl<.f> 0,RB,RC 01011bbb00001110FBBBcccccc111110.  */
{ "rsubl", 0x580E003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* rsubl<.f><.cc> RB,RB,RC 01011bbb11001110FBBBcccccc0QQQQQ.  */
{ "rsubl", 0x58CE0000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* rsubl<.f> RA,RB,u6 01011bbb01001110FBBBuuuuuuaaaaaa.  */
{ "rsubl", 0x584E0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* rsubl<.f> 0,RB,u6 01011bbb01001110FBBBuuuuuu111110.  */
{ "rsubl", 0x584E003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* rsubl<.f><.cc> RB,RB,u6 01011bbb11001110FBBBuuuuuu1QQQQQ.  */
{ "rsubl", 0x58CE0020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* rsubl<.f> RB,RB,s12 01011bbb10001110FBBBssssssSSSSSS.  */
{ "rsubl", 0x588E0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* rsubl<.f> RA,ximm,RC 0101110000001110F111ccccccaaaaaa.  */
{ "rsubl", 0x5C0E7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* rsubl<.f> RA,RB,ximm 01011bbb00001110FBBB111100aaaaaa.  */
{ "rsubl", 0x580E0F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* rsubl<.f> 0,ximm,RC 0101110000001110F111cccccc111110.  */
{ "rsubl", 0x5C0E703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* rsubl<.f> 0,RB,ximm 01011bbb00001110FBBB111100111110.  */
{ "rsubl", 0x580E0F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* rsubl<.f><.cc> 0,ximm,RC 0101110011001110F111cccccc0QQQQQ.  */
{ "rsubl", 0x5CCE7000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* rsubl<.f><.cc> RB,RB,ximm 01011bbb11001110FBBB1111000QQQQQ.  */
{ "rsubl", 0x58CE0F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* rsubl<.f> RA,ximm,u6 0101110001001110F111uuuuuuaaaaaa.  */
{ "rsubl", 0x5C4E7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* rsubl<.f> 0,ximm,u6 0101110001001110F111uuuuuu111110.  */
{ "rsubl", 0x5C4E703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* rsubl<.f><.cc> 0,ximm,u6 0101110011001110F111uuuuuu1QQQQQ.  */
{ "rsubl", 0x5CCE7020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* rsubl<.f> RA,limm,RC 0101111000001110F111ccccccaaaaaa.  */
{ "rsubl", 0x5E0E7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* rsubl<.f> RA,RB,limm 01011bbb00001110FBBB111110aaaaaa.  */
{ "rsubl", 0x580E0F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* rsubl<.f> 0,limm,RC 0101111000001110F111cccccc111110.  */
{ "rsubl", 0x5E0E703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* rsubl<.f> 0,RB,limm 01011bbb00001110FBBB111110111110.  */
{ "rsubl", 0x580E0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* rsubl<.f><.cc> 0,limm,RC 0101111011001110F111cccccc0QQQQQ.  */
{ "rsubl", 0x5ECE7000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* rsubl<.f><.cc> RB,RB,limm 01011bbb11001110FBBB1111100QQQQQ.  */
{ "rsubl", 0x58CE0F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* rsubl<.f> RA,limm,u6 0101111001001110F111uuuuuuaaaaaa.  */
{ "rsubl", 0x5E4E7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* rsubl<.f> 0,limm,u6 0101111001001110F111uuuuuu111110.  */
{ "rsubl", 0x5E4E703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* rsubl<.f><.cc> 0,limm,u6 0101111011001110F111uuuuuu1QQQQQ.  */
{ "rsubl", 0x5ECE7020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* rsubl<.f> 0,ximm,s12 0101110010001110F111ssssssSSSSSS.  */
{ "rsubl", 0x5C8E7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* rsubl<.f> 0,limm,s12 0101111010001110F111ssssssSSSSSS.  */
{ "rsubl", 0x5E8E7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* rsubl<.f> RA,ximm,ximm 0101110000001110F111111100aaaaaa.  */
{ "rsubl", 0x5C0E7F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* rsubl<.f> 0,ximm,ximm 0101110000001110F111111100111110.  */
{ "rsubl", 0x5C0E7F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* rsubl<.f><.cc> 0,ximm,ximm 0101110011001110F1111111000QQQQQ.  */
{ "rsubl", 0x5CCE7F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* rsubl<.f> RA,limm,limm 0101111000001110F111111110aaaaaa.  */
{ "rsubl", 0x5E0E7F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* rsubl<.f> 0,limm,limm 0101111000001110F111111110111110.  */
{ "rsubl", 0x5E0E7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* rsubl<.f><.cc> 0,limm,limm 0101111011001110F1111111100QQQQQ.  */
{ "rsubl", 0x5ECE7F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* rtie  00100100011011110000000000111111.  */
{ "rtie", 0x246F003F, 0xFFFFFFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, KERNEL, NONE, { 0 }, { 0 }},

/* sbc<.f> a,b,c 00100bbb00000011FBBBCCCCCCAAAAAA.  */
{ "sbc", 0x20030000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* sbc<.f> 0,b,c 00100bbb00000011FBBBCCCCCC111110.  */
{ "sbc", 0x2003003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* sbc<.f><.cc> b,b,c 00100bbb11000011FBBBCCCCCC0QQQQQ.  */
{ "sbc", 0x20C30000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* sbc<.f> a,b,u6 00100bbb01000011FBBBuuuuuuAAAAAA.  */
{ "sbc", 0x20430000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* sbc<.f> 0,b,u6 00100bbb01000011FBBBuuuuuu111110.  */
{ "sbc", 0x2043003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* sbc<.f><.cc> b,b,u6 00100bbb11000011FBBBuuuuuu1QQQQQ.  */
{ "sbc", 0x20C30020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* sbc<.f> b,b,s12 00100bbb10000011FBBBssssssSSSSSS.  */
{ "sbc", 0x20830000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* sbc<.f> a,limm,c 0010011000000011F111CCCCCCAAAAAA.  */
{ "sbc", 0x26037000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* sbc<.f> a,b,limm 00100bbb00000011FBBB111110AAAAAA.  */
{ "sbc", 0x20030F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* sbc<.f> 0,limm,c 0010011000000011F111CCCCCC111110.  */
{ "sbc", 0x2603703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* sbc<.f> 0,b,limm 00100bbb00000011FBBB111110111110.  */
{ "sbc", 0x20030FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* sbc<.f><.cc> b,b,limm 00100bbb11000011FBBB1111100QQQQQ.  */
{ "sbc", 0x20C30F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* sbc<.f><.cc> 0,limm,c 0010011011000011F111CCCCCC0QQQQQ.  */
{ "sbc", 0x26C37000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* sbc<.f> a,limm,u6 0010011001000011F111uuuuuuAAAAAA.  */
{ "sbc", 0x26437000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* sbc<.f> 0,limm,u6 0010011001000011F111uuuuuu111110.  */
{ "sbc", 0x2643703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* sbc<.f><.cc> 0,limm,u6 0010011011000011F111uuuuuu1QQQQQ.  */
{ "sbc", 0x26C37020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* sbc<.f> 0,limm,s12 0010011010000011F111ssssssSSSSSS.  */
{ "sbc", 0x26837000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* sbc<.f> a,limm,limm 0010011000000011F111111110AAAAAA.  */
{ "sbc", 0x26037F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* sbc<.f> 0,limm,limm 0010011000000011F111111110111110.  */
{ "sbc", 0x26037FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* sbc<.f><.cc> 0,limm,limm 0010011011000011F1111111100QQQQQ.  */
{ "sbc", 0x26C37F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* sbcl<.f> RA,RB,RC 01011bbb00000011FBBBccccccaaaaaa.  */
{ "sbcl", 0x58030000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* sbcl<.f> 0,RB,RC 01011bbb00000011FBBBcccccc111110.  */
{ "sbcl", 0x5803003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* sbcl<.f><.cc> RB,RB,RC 01011bbb11000011FBBBcccccc0QQQQQ.  */
{ "sbcl", 0x58C30000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* sbcl<.f> RA,RB,u6 01011bbb01000011FBBBuuuuuuaaaaaa.  */
{ "sbcl", 0x58430000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* sbcl<.f> 0,RB,u6 01011bbb01000011FBBBuuuuuu111110.  */
{ "sbcl", 0x5843003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* sbcl<.f><.cc> RB,RB,u6 01011bbb11000011FBBBuuuuuu1QQQQQ.  */
{ "sbcl", 0x58C30020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* sbcl<.f> RB,RB,s12 01011bbb10000011FBBBssssssSSSSSS.  */
{ "sbcl", 0x58830000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* sbcl<.f> RA,ximm,RC 0101110000000011F111ccccccaaaaaa.  */
{ "sbcl", 0x5C037000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* sbcl<.f> RA,RB,ximm 01011bbb00000011FBBB111100aaaaaa.  */
{ "sbcl", 0x58030F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* sbcl<.f> 0,ximm,RC 0101110000000011F111cccccc111110.  */
{ "sbcl", 0x5C03703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* sbcl<.f> 0,RB,ximm 01011bbb00000011FBBB111100111110.  */
{ "sbcl", 0x58030F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* sbcl<.f><.cc> 0,ximm,RC 0101110011000011F111cccccc0QQQQQ.  */
{ "sbcl", 0x5CC37000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* sbcl<.f><.cc> RB,RB,ximm 01011bbb11000011FBBB1111000QQQQQ.  */
{ "sbcl", 0x58C30F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* sbcl<.f> RA,ximm,u6 0101110001000011F111uuuuuuaaaaaa.  */
{ "sbcl", 0x5C437000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* sbcl<.f> 0,ximm,u6 0101110001000011F111uuuuuu111110.  */
{ "sbcl", 0x5C43703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* sbcl<.f><.cc> 0,ximm,u6 0101110011000011F111uuuuuu1QQQQQ.  */
{ "sbcl", 0x5CC37020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* sbcl<.f> RA,limm,RC 0101111000000011F111ccccccaaaaaa.  */
{ "sbcl", 0x5E037000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* sbcl<.f> RA,RB,limm 01011bbb00000011FBBB111110aaaaaa.  */
{ "sbcl", 0x58030F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* sbcl<.f> 0,limm,RC 0101111000000011F111cccccc111110.  */
{ "sbcl", 0x5E03703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* sbcl<.f> 0,RB,limm 01011bbb00000011FBBB111110111110.  */
{ "sbcl", 0x58030FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* sbcl<.f><.cc> 0,limm,RC 0101111011000011F111cccccc0QQQQQ.  */
{ "sbcl", 0x5EC37000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* sbcl<.f><.cc> RB,RB,limm 01011bbb11000011FBBB1111100QQQQQ.  */
{ "sbcl", 0x58C30F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* sbcl<.f> RA,limm,u6 0101111001000011F111uuuuuuaaaaaa.  */
{ "sbcl", 0x5E437000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* sbcl<.f> 0,limm,u6 0101111001000011F111uuuuuu111110.  */
{ "sbcl", 0x5E43703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* sbcl<.f><.cc> 0,limm,u6 0101111011000011F111uuuuuu1QQQQQ.  */
{ "sbcl", 0x5EC37020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* sbcl<.f> 0,ximm,s12 0101110010000011F111ssssssSSSSSS.  */
{ "sbcl", 0x5C837000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* sbcl<.f> 0,limm,s12 0101111010000011F111ssssssSSSSSS.  */
{ "sbcl", 0x5E837000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* sbcl<.f> RA,ximm,ximm 0101110000000011F111111100aaaaaa.  */
{ "sbcl", 0x5C037F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* sbcl<.f> 0,ximm,ximm 0101110000000011F111111100111110.  */
{ "sbcl", 0x5C037F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* sbcl<.f><.cc> 0,ximm,ximm 0101110011000011F1111111000QQQQQ.  */
{ "sbcl", 0x5CC37F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* sbcl<.f> RA,limm,limm 0101111000000011F111111110aaaaaa.  */
{ "sbcl", 0x5E037F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* sbcl<.f> 0,limm,limm 0101111000000011F111111110111110.  */
{ "sbcl", 0x5E037FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* sbcl<.f><.cc> 0,limm,limm 0101111011000011F1111111100QQQQQ.  */
{ "sbcl", 0x5EC37F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* scond<.di> b,c 00100bbb00101111DBBBCCCCCC010001.  */
{ "scond", 0x202F0011, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SCOND, NONE, { RB, BRAKET, RC, BRAKETdup }, { C_DI16 }},

/* scond<.di> b,u6 00100bbb01101111DBBBuuuuuu010001.  */
{ "scond", 0x206F0011, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SCOND, NONE, { RB, BRAKET, UIMM6_20, BRAKETdup }, { C_DI16 }},

/* scond<.di> b,limm 00100bbb00101111DBBB111110010001.  */
{ "scond", 0x202F0F91, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SCOND, NONE, { RB, BRAKET, LIMM, BRAKETdup }, { C_DI16 }},

/* scondl<.aq> RB,RC 01011bbb00101111FBBBcccccc010001.  */
{ "scondl", 0x582F0011, 0xF8FF003F, ARC_OPCODE_ARC64, SCOND, NONE, { RB, BRAKET, RC, BRAKETdup }, { C_RL }},

/* seteq<.f> a,b,c 00100bbb00111000FBBBCCCCCCAAAAAA.  */
{ "seteq", 0x20380000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* seteq<.f> 0,b,c 00100bbb00111000FBBBCCCCCC111110.  */
{ "seteq", 0x2038003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* seteq<.f><.cc> b,b,c 00100bbb11111000FBBBCCCCCC0QQQQQ.  */
{ "seteq", 0x20F80000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* seteq<.f> a,b,u6 00100bbb01111000FBBBuuuuuuAAAAAA.  */
{ "seteq", 0x20780000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* seteq<.f> 0,b,u6 00100bbb01111000FBBBuuuuuu111110.  */
{ "seteq", 0x2078003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* seteq<.f><.cc> b,b,u6 00100bbb11111000FBBBuuuuuu1QQQQQ.  */
{ "seteq", 0x20F80020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* seteq<.f> b,b,s12 00100bbb10111000FBBBssssssSSSSSS.  */
{ "seteq", 0x20B80000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* seteq<.f> a,limm,c 0010011000111000F111CCCCCCAAAAAA.  */
{ "seteq", 0x26387000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* seteq<.f> a,b,limm 00100bbb00111000FBBB111110AAAAAA.  */
{ "seteq", 0x20380F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* seteq<.f> 0,limm,c 0010011000111000F111CCCCCC111110.  */
{ "seteq", 0x2638703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* seteq<.f> 0,b,limm 00100bbb00111000FBBB111110111110.  */
{ "seteq", 0x20380FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* seteq<.f><.cc> b,b,limm 00100bbb11111000FBBB1111100QQQQQ.  */
{ "seteq", 0x20F80F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* seteq<.f><.cc> 0,limm,c 0010011011111000F111CCCCCC0QQQQQ.  */
{ "seteq", 0x26F87000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* seteq<.f> a,limm,u6 0010011001111000F111uuuuuuAAAAAA.  */
{ "seteq", 0x26787000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* seteq<.f> 0,limm,u6 0010011001111000F111uuuuuu111110.  */
{ "seteq", 0x2678703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* seteq<.f><.cc> 0,limm,u6 0010011011111000F111uuuuuu1QQQQQ.  */
{ "seteq", 0x26F87020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* seteq<.f> 0,limm,s12 0010011010111000F111ssssssSSSSSS.  */
{ "seteq", 0x26B87000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* seteq<.f> a,limm,limm 0010011000111000F111111110AAAAAA.  */
{ "seteq", 0x26387F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* seteq<.f> 0,limm,limm 0010011000111000F111111110111110.  */
{ "seteq", 0x26387FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* seteq<.f><.cc> 0,limm,limm 0010011011111000F1111111100QQQQQ.  */
{ "seteq", 0x26F87F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* seteql<.f> RA,RB,RC 01011bbb00111000FBBBccccccaaaaaa.  */
{ "seteql", 0x58380000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* seteql<.f> 0,RB,RC 01011bbb00111000FBBBcccccc111110.  */
{ "seteql", 0x5838003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* seteql<.f><.cc> RB,RB,RC 01011bbb11111000FBBBcccccc0QQQQQ.  */
{ "seteql", 0x58F80000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* seteql<.f> RA,RB,u6 01011bbb01111000FBBBuuuuuuaaaaaa.  */
{ "seteql", 0x58780000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* seteql<.f> 0,RB,u6 01011bbb01111000FBBBuuuuuu111110.  */
{ "seteql", 0x5878003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* seteql<.f><.cc> RB,RB,u6 01011bbb11111000FBBBuuuuuu1QQQQQ.  */
{ "seteql", 0x58F80020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* seteql<.f> RB,RB,s12 01011bbb10111000FBBBssssssSSSSSS.  */
{ "seteql", 0x58B80000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* seteql<.f> RA,ximm,RC 0101110000111000F111ccccccaaaaaa.  */
{ "seteql", 0x5C387000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* seteql<.f> RA,RB,ximm 01011bbb00111000FBBB111100aaaaaa.  */
{ "seteql", 0x58380F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* seteql<.f> 0,ximm,RC 0101110000111000F111cccccc111110.  */
{ "seteql", 0x5C38703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* seteql<.f> 0,RB,ximm 01011bbb00111000FBBB111100111110.  */
{ "seteql", 0x58380F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* seteql<.f><.cc> 0,ximm,RC 0101110011111000F111cccccc0QQQQQ.  */
{ "seteql", 0x5CF87000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* seteql<.f><.cc> RB,RB,ximm 01011bbb11111000FBBB1111000QQQQQ.  */
{ "seteql", 0x58F80F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* seteql<.f> RA,ximm,u6 0101110001111000F111uuuuuuaaaaaa.  */
{ "seteql", 0x5C787000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* seteql<.f> 0,ximm,u6 0101110001111000F111uuuuuu111110.  */
{ "seteql", 0x5C78703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* seteql<.f><.cc> 0,ximm,u6 0101110011111000F111uuuuuu1QQQQQ.  */
{ "seteql", 0x5CF87020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* seteql<.f> RA,limm,RC 0101111000111000F111ccccccaaaaaa.  */
{ "seteql", 0x5E387000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* seteql<.f> RA,RB,limm 01011bbb00111000FBBB111110aaaaaa.  */
{ "seteql", 0x58380F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* seteql<.f> 0,limm,RC 0101111000111000F111cccccc111110.  */
{ "seteql", 0x5E38703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* seteql<.f> 0,RB,limm 01011bbb00111000FBBB111110111110.  */
{ "seteql", 0x58380FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* seteql<.f><.cc> 0,limm,RC 0101111011111000F111cccccc0QQQQQ.  */
{ "seteql", 0x5EF87000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* seteql<.f><.cc> RB,RB,limm 01011bbb11111000FBBB1111100QQQQQ.  */
{ "seteql", 0x58F80F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* seteql<.f> RA,limm,u6 0101111001111000F111uuuuuuaaaaaa.  */
{ "seteql", 0x5E787000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* seteql<.f> 0,limm,u6 0101111001111000F111uuuuuu111110.  */
{ "seteql", 0x5E78703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* seteql<.f><.cc> 0,limm,u6 0101111011111000F111uuuuuu1QQQQQ.  */
{ "seteql", 0x5EF87020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* seteql<.f> 0,ximm,s12 0101110010111000F111ssssssSSSSSS.  */
{ "seteql", 0x5CB87000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* seteql<.f> 0,limm,s12 0101111010111000F111ssssssSSSSSS.  */
{ "seteql", 0x5EB87000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* seteql<.f> RA,ximm,ximm 0101110000111000F111111100aaaaaa.  */
{ "seteql", 0x5C387F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* seteql<.f> 0,ximm,ximm 0101110000111000F111111100111110.  */
{ "seteql", 0x5C387F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* seteql<.f><.cc> 0,ximm,ximm 0101110011111000F1111111000QQQQQ.  */
{ "seteql", 0x5CF87F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* seteql<.f> RA,limm,limm 0101111000111000F111111110aaaaaa.  */
{ "seteql", 0x5E387F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* seteql<.f> 0,limm,limm 0101111000111000F111111110111110.  */
{ "seteql", 0x5E387FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* seteql<.f><.cc> 0,limm,limm 0101111011111000F1111111100QQQQQ.  */
{ "seteql", 0x5EF87F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* setge<.f> a,b,c 00100bbb00111011FBBBCCCCCCAAAAAA.  */
{ "setge", 0x203B0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* setge<.f> 0,b,c 00100bbb00111011FBBBCCCCCC111110.  */
{ "setge", 0x203B003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* setge<.f><.cc> b,b,c 00100bbb11111011FBBBCCCCCC0QQQQQ.  */
{ "setge", 0x20FB0000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* setge<.f> a,b,u6 00100bbb01111011FBBBuuuuuuAAAAAA.  */
{ "setge", 0x207B0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* setge<.f> 0,b,u6 00100bbb01111011FBBBuuuuuu111110.  */
{ "setge", 0x207B003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* setge<.f><.cc> b,b,u6 00100bbb11111011FBBBuuuuuu1QQQQQ.  */
{ "setge", 0x20FB0020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* setge<.f> b,b,s12 00100bbb10111011FBBBssssssSSSSSS.  */
{ "setge", 0x20BB0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* setge<.f> a,limm,c 0010011000111011F111CCCCCCAAAAAA.  */
{ "setge", 0x263B7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* setge<.f> a,b,limm 00100bbb00111011FBBB111110AAAAAA.  */
{ "setge", 0x203B0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* setge<.f> 0,limm,c 0010011000111011F111CCCCCC111110.  */
{ "setge", 0x263B703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* setge<.f> 0,b,limm 00100bbb00111011FBBB111110111110.  */
{ "setge", 0x203B0FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* setge<.f><.cc> b,b,limm 00100bbb11111011FBBB1111100QQQQQ.  */
{ "setge", 0x20FB0F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* setge<.f><.cc> 0,limm,c 0010011011111011F111CCCCCC0QQQQQ.  */
{ "setge", 0x26FB7000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* setge<.f> a,limm,u6 0010011001111011F111uuuuuuAAAAAA.  */
{ "setge", 0x267B7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* setge<.f> 0,limm,u6 0010011001111011F111uuuuuu111110.  */
{ "setge", 0x267B703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* setge<.f><.cc> 0,limm,u6 0010011011111011F111uuuuuu1QQQQQ.  */
{ "setge", 0x26FB7020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* setge<.f> 0,limm,s12 0010011010111011F111ssssssSSSSSS.  */
{ "setge", 0x26BB7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* setge<.f> a,limm,limm 0010011000111011F111111110AAAAAA.  */
{ "setge", 0x263B7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* setge<.f> 0,limm,limm 0010011000111011F111111110111110.  */
{ "setge", 0x263B7FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* setge<.f><.cc> 0,limm,limm 0010011011111011F1111111100QQQQQ.  */
{ "setge", 0x26FB7F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* setgel<.f> RA,RB,RC 01011bbb00111011FBBBccccccaaaaaa.  */
{ "setgel", 0x583B0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* setgel<.f> 0,RB,RC 01011bbb00111011FBBBcccccc111110.  */
{ "setgel", 0x583B003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* setgel<.f><.cc> RB,RB,RC 01011bbb11111011FBBBcccccc0QQQQQ.  */
{ "setgel", 0x58FB0000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* setgel<.f> RA,RB,u6 01011bbb01111011FBBBuuuuuuaaaaaa.  */
{ "setgel", 0x587B0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* setgel<.f> 0,RB,u6 01011bbb01111011FBBBuuuuuu111110.  */
{ "setgel", 0x587B003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* setgel<.f><.cc> RB,RB,u6 01011bbb11111011FBBBuuuuuu1QQQQQ.  */
{ "setgel", 0x58FB0020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* setgel<.f> RB,RB,s12 01011bbb10111011FBBBssssssSSSSSS.  */
{ "setgel", 0x58BB0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* setgel<.f> RA,ximm,RC 0101110000111011F111ccccccaaaaaa.  */
{ "setgel", 0x5C3B7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* setgel<.f> RA,RB,ximm 01011bbb00111011FBBB111100aaaaaa.  */
{ "setgel", 0x583B0F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* setgel<.f> 0,ximm,RC 0101110000111011F111cccccc111110.  */
{ "setgel", 0x5C3B703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* setgel<.f> 0,RB,ximm 01011bbb00111011FBBB111100111110.  */
{ "setgel", 0x583B0F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* setgel<.f><.cc> 0,ximm,RC 0101110011111011F111cccccc0QQQQQ.  */
{ "setgel", 0x5CFB7000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* setgel<.f><.cc> RB,RB,ximm 01011bbb11111011FBBB1111000QQQQQ.  */
{ "setgel", 0x58FB0F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* setgel<.f> RA,ximm,u6 0101110001111011F111uuuuuuaaaaaa.  */
{ "setgel", 0x5C7B7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* setgel<.f> 0,ximm,u6 0101110001111011F111uuuuuu111110.  */
{ "setgel", 0x5C7B703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* setgel<.f><.cc> 0,ximm,u6 0101110011111011F111uuuuuu1QQQQQ.  */
{ "setgel", 0x5CFB7020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* setgel<.f> RA,limm,RC 0101111000111011F111ccccccaaaaaa.  */
{ "setgel", 0x5E3B7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* setgel<.f> RA,RB,limm 01011bbb00111011FBBB111110aaaaaa.  */
{ "setgel", 0x583B0F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* setgel<.f> 0,limm,RC 0101111000111011F111cccccc111110.  */
{ "setgel", 0x5E3B703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* setgel<.f> 0,RB,limm 01011bbb00111011FBBB111110111110.  */
{ "setgel", 0x583B0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* setgel<.f><.cc> 0,limm,RC 0101111011111011F111cccccc0QQQQQ.  */
{ "setgel", 0x5EFB7000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* setgel<.f><.cc> RB,RB,limm 01011bbb11111011FBBB1111100QQQQQ.  */
{ "setgel", 0x58FB0F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* setgel<.f> RA,limm,u6 0101111001111011F111uuuuuuaaaaaa.  */
{ "setgel", 0x5E7B7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* setgel<.f> 0,limm,u6 0101111001111011F111uuuuuu111110.  */
{ "setgel", 0x5E7B703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* setgel<.f><.cc> 0,limm,u6 0101111011111011F111uuuuuu1QQQQQ.  */
{ "setgel", 0x5EFB7020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* setgel<.f> 0,ximm,s12 0101110010111011F111ssssssSSSSSS.  */
{ "setgel", 0x5CBB7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* setgel<.f> 0,limm,s12 0101111010111011F111ssssssSSSSSS.  */
{ "setgel", 0x5EBB7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* setgel<.f> RA,ximm,ximm 0101110000111011F111111100aaaaaa.  */
{ "setgel", 0x5C3B7F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* setgel<.f> 0,ximm,ximm 0101110000111011F111111100111110.  */
{ "setgel", 0x5C3B7F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* setgel<.f><.cc> 0,ximm,ximm 0101110011111011F1111111000QQQQQ.  */
{ "setgel", 0x5CFB7F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* setgel<.f> RA,limm,limm 0101111000111011F111111110aaaaaa.  */
{ "setgel", 0x5E3B7F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* setgel<.f> 0,limm,limm 0101111000111011F111111110111110.  */
{ "setgel", 0x5E3B7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* setgel<.f><.cc> 0,limm,limm 0101111011111011F1111111100QQQQQ.  */
{ "setgel", 0x5EFB7F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* setgt<.f> a,b,c 00100bbb00111111FBBBCCCCCCAAAAAA.  */
{ "setgt", 0x203F0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* setgt<.f> 0,b,c 00100bbb00111111FBBBCCCCCC111110.  */
{ "setgt", 0x203F003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* setgt<.f><.cc> b,b,c 00100bbb11111111FBBBCCCCCC0QQQQQ.  */
{ "setgt", 0x20FF0000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* setgt<.f> a,b,u6 00100bbb01111111FBBBuuuuuuAAAAAA.  */
{ "setgt", 0x207F0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* setgt<.f> 0,b,u6 00100bbb01111111FBBBuuuuuu111110.  */
{ "setgt", 0x207F003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* setgt<.f><.cc> b,b,u6 00100bbb11111111FBBBuuuuuu1QQQQQ.  */
{ "setgt", 0x20FF0020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* setgt<.f> b,b,s12 00100bbb10111111FBBBssssssSSSSSS.  */
{ "setgt", 0x20BF0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* setgt<.f> a,limm,c 0010011000111111F111CCCCCCAAAAAA.  */
{ "setgt", 0x263F7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* setgt<.f> a,b,limm 00100bbb00111111FBBB111110AAAAAA.  */
{ "setgt", 0x203F0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* setgt<.f> 0,limm,c 0010011000111111F111CCCCCC111110.  */
{ "setgt", 0x263F703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* setgt<.f> 0,b,limm 00100bbb00111111FBBB111110111110.  */
{ "setgt", 0x203F0FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* setgt<.f><.cc> b,b,limm 00100bbb11111111FBBB1111100QQQQQ.  */
{ "setgt", 0x20FF0F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* setgt<.f><.cc> 0,limm,c 0010011011111111F111CCCCCC0QQQQQ.  */
{ "setgt", 0x26FF7000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* setgt<.f> a,limm,u6 0010011001111111F111uuuuuuAAAAAA.  */
{ "setgt", 0x267F7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* setgt<.f> 0,limm,u6 0010011001111111F111uuuuuu111110.  */
{ "setgt", 0x267F703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* setgt<.f><.cc> 0,limm,u6 0010011011111111F111uuuuuu1QQQQQ.  */
{ "setgt", 0x26FF7020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* setgt<.f> 0,limm,s12 0010011010111111F111ssssssSSSSSS.  */
{ "setgt", 0x26BF7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* setgt<.f> a,limm,limm 0010011000111111F111111110AAAAAA.  */
{ "setgt", 0x263F7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* setgt<.f> 0,limm,limm 0010011000111111F111111110111110.  */
{ "setgt", 0x263F7FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* setgt<.f><.cc> 0,limm,limm 0010011011111111F1111111100QQQQQ.  */
{ "setgt", 0x26FF7F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* setgtl<.f> RA,RB,RC 01011bbb00111111FBBBccccccaaaaaa.  */
{ "setgtl", 0x583F0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* setgtl<.f> 0,RB,RC 01011bbb00111111FBBBcccccc111110.  */
{ "setgtl", 0x583F003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* setgtl<.f><.cc> RB,RB,RC 01011bbb11111111FBBBcccccc0QQQQQ.  */
{ "setgtl", 0x58FF0000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* setgtl<.f> RA,RB,u6 01011bbb01111111FBBBuuuuuuaaaaaa.  */
{ "setgtl", 0x587F0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* setgtl<.f> 0,RB,u6 01011bbb01111111FBBBuuuuuu111110.  */
{ "setgtl", 0x587F003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* setgtl<.f><.cc> RB,RB,u6 01011bbb11111111FBBBuuuuuu1QQQQQ.  */
{ "setgtl", 0x58FF0020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* setgtl<.f> RB,RB,s12 01011bbb10111111FBBBssssssSSSSSS.  */
{ "setgtl", 0x58BF0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* setgtl<.f> RA,ximm,RC 0101110000111111F111ccccccaaaaaa.  */
{ "setgtl", 0x5C3F7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* setgtl<.f> RA,RB,ximm 01011bbb00111111FBBB111100aaaaaa.  */
{ "setgtl", 0x583F0F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* setgtl<.f> 0,ximm,RC 0101110000111111F111cccccc111110.  */
{ "setgtl", 0x5C3F703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* setgtl<.f> 0,RB,ximm 01011bbb00111111FBBB111100111110.  */
{ "setgtl", 0x583F0F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* setgtl<.f><.cc> 0,ximm,RC 0101110011111111F111cccccc0QQQQQ.  */
{ "setgtl", 0x5CFF7000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* setgtl<.f><.cc> RB,RB,ximm 01011bbb11111111FBBB1111000QQQQQ.  */
{ "setgtl", 0x58FF0F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* setgtl<.f> RA,ximm,u6 0101110001111111F111uuuuuuaaaaaa.  */
{ "setgtl", 0x5C7F7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* setgtl<.f> 0,ximm,u6 0101110001111111F111uuuuuu111110.  */
{ "setgtl", 0x5C7F703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* setgtl<.f><.cc> 0,ximm,u6 0101110011111111F111uuuuuu1QQQQQ.  */
{ "setgtl", 0x5CFF7020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* setgtl<.f> RA,limm,RC 0101111000111111F111ccccccaaaaaa.  */
{ "setgtl", 0x5E3F7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* setgtl<.f> RA,RB,limm 01011bbb00111111FBBB111110aaaaaa.  */
{ "setgtl", 0x583F0F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* setgtl<.f> 0,limm,RC 0101111000111111F111cccccc111110.  */
{ "setgtl", 0x5E3F703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* setgtl<.f> 0,RB,limm 01011bbb00111111FBBB111110111110.  */
{ "setgtl", 0x583F0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* setgtl<.f><.cc> 0,limm,RC 0101111011111111F111cccccc0QQQQQ.  */
{ "setgtl", 0x5EFF7000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* setgtl<.f><.cc> RB,RB,limm 01011bbb11111111FBBB1111100QQQQQ.  */
{ "setgtl", 0x58FF0F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* setgtl<.f> RA,limm,u6 0101111001111111F111uuuuuuaaaaaa.  */
{ "setgtl", 0x5E7F7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* setgtl<.f> 0,limm,u6 0101111001111111F111uuuuuu111110.  */
{ "setgtl", 0x5E7F703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* setgtl<.f><.cc> 0,limm,u6 0101111011111111F111uuuuuu1QQQQQ.  */
{ "setgtl", 0x5EFF7020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* setgtl<.f> 0,ximm,s12 0101110010111111F111ssssssSSSSSS.  */
{ "setgtl", 0x5CBF7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* setgtl<.f> 0,limm,s12 0101111010111111F111ssssssSSSSSS.  */
{ "setgtl", 0x5EBF7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* setgtl<.f> RA,ximm,ximm 0101110000111111F111111100aaaaaa.  */
{ "setgtl", 0x5C3F7F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* setgtl<.f> 0,ximm,ximm 0101110000111111F111111100111110.  */
{ "setgtl", 0x5C3F7F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* setgtl<.f><.cc> 0,ximm,ximm 0101110011111111F1111111000QQQQQ.  */
{ "setgtl", 0x5CFF7F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* setgtl<.f> RA,limm,limm 0101111000111111F111111110aaaaaa.  */
{ "setgtl", 0x5E3F7F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* setgtl<.f> 0,limm,limm 0101111000111111F111111110111110.  */
{ "setgtl", 0x5E3F7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* setgtl<.f><.cc> 0,limm,limm 0101111011111111F1111111100QQQQQ.  */
{ "setgtl", 0x5EFF7F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* seths<.f> a,b,c 00100bbb00111101FBBBCCCCCCAAAAAA.  */
{ "seths", 0x203D0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* seths<.f> 0,b,c 00100bbb00111101FBBBCCCCCC111110.  */
{ "seths", 0x203D003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* seths<.f><.cc> b,b,c 00100bbb11111101FBBBCCCCCC0QQQQQ.  */
{ "seths", 0x20FD0000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* seths<.f> a,b,u6 00100bbb01111101FBBBuuuuuuAAAAAA.  */
{ "seths", 0x207D0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* seths<.f> 0,b,u6 00100bbb01111101FBBBuuuuuu111110.  */
{ "seths", 0x207D003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* seths<.f><.cc> b,b,u6 00100bbb11111101FBBBuuuuuu1QQQQQ.  */
{ "seths", 0x20FD0020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* seths<.f> b,b,s12 00100bbb10111101FBBBssssssSSSSSS.  */
{ "seths", 0x20BD0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* seths<.f> a,limm,c 0010011000111101F111CCCCCCAAAAAA.  */
{ "seths", 0x263D7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* seths<.f> a,b,limm 00100bbb00111101FBBB111110AAAAAA.  */
{ "seths", 0x203D0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* seths<.f> 0,limm,c 0010011000111101F111CCCCCC111110.  */
{ "seths", 0x263D703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* seths<.f> 0,b,limm 00100bbb00111101FBBB111110111110.  */
{ "seths", 0x203D0FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* seths<.f><.cc> b,b,limm 00100bbb11111101FBBB1111100QQQQQ.  */
{ "seths", 0x20FD0F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* seths<.f><.cc> 0,limm,c 0010011011111101F111CCCCCC0QQQQQ.  */
{ "seths", 0x26FD7000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* seths<.f> a,limm,u6 0010011001111101F111uuuuuuAAAAAA.  */
{ "seths", 0x267D7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* seths<.f> 0,limm,u6 0010011001111101F111uuuuuu111110.  */
{ "seths", 0x267D703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* seths<.f><.cc> 0,limm,u6 0010011011111101F111uuuuuu1QQQQQ.  */
{ "seths", 0x26FD7020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* seths<.f> 0,limm,s12 0010011010111101F111ssssssSSSSSS.  */
{ "seths", 0x26BD7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* seths<.f> a,limm,limm 0010011000111101F111111110AAAAAA.  */
{ "seths", 0x263D7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* seths<.f> 0,limm,limm 0010011000111101F111111110111110.  */
{ "seths", 0x263D7FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* seths<.f><.cc> 0,limm,limm 0010011011111101F1111111100QQQQQ.  */
{ "seths", 0x26FD7F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* sethsl<.f> RA,RB,RC 01011bbb00111101FBBBccccccaaaaaa.  */
{ "sethsl", 0x583D0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* sethsl<.f> 0,RB,RC 01011bbb00111101FBBBcccccc111110.  */
{ "sethsl", 0x583D003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* sethsl<.f><.cc> RB,RB,RC 01011bbb11111101FBBBcccccc0QQQQQ.  */
{ "sethsl", 0x58FD0000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* sethsl<.f> RA,RB,u6 01011bbb01111101FBBBuuuuuuaaaaaa.  */
{ "sethsl", 0x587D0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* sethsl<.f> 0,RB,u6 01011bbb01111101FBBBuuuuuu111110.  */
{ "sethsl", 0x587D003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* sethsl<.f><.cc> RB,RB,u6 01011bbb11111101FBBBuuuuuu1QQQQQ.  */
{ "sethsl", 0x58FD0020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* sethsl<.f> RB,RB,s12 01011bbb10111101FBBBssssssSSSSSS.  */
{ "sethsl", 0x58BD0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* sethsl<.f> RA,ximm,RC 0101110000111101F111ccccccaaaaaa.  */
{ "sethsl", 0x5C3D7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* sethsl<.f> RA,RB,ximm 01011bbb00111101FBBB111100aaaaaa.  */
{ "sethsl", 0x583D0F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* sethsl<.f> 0,ximm,RC 0101110000111101F111cccccc111110.  */
{ "sethsl", 0x5C3D703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* sethsl<.f> 0,RB,ximm 01011bbb00111101FBBB111100111110.  */
{ "sethsl", 0x583D0F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* sethsl<.f><.cc> 0,ximm,RC 0101110011111101F111cccccc0QQQQQ.  */
{ "sethsl", 0x5CFD7000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* sethsl<.f><.cc> RB,RB,ximm 01011bbb11111101FBBB1111000QQQQQ.  */
{ "sethsl", 0x58FD0F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* sethsl<.f> RA,ximm,u6 0101110001111101F111uuuuuuaaaaaa.  */
{ "sethsl", 0x5C7D7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* sethsl<.f> 0,ximm,u6 0101110001111101F111uuuuuu111110.  */
{ "sethsl", 0x5C7D703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* sethsl<.f><.cc> 0,ximm,u6 0101110011111101F111uuuuuu1QQQQQ.  */
{ "sethsl", 0x5CFD7020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* sethsl<.f> RA,limm,RC 0101111000111101F111ccccccaaaaaa.  */
{ "sethsl", 0x5E3D7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* sethsl<.f> RA,RB,limm 01011bbb00111101FBBB111110aaaaaa.  */
{ "sethsl", 0x583D0F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* sethsl<.f> 0,limm,RC 0101111000111101F111cccccc111110.  */
{ "sethsl", 0x5E3D703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* sethsl<.f> 0,RB,limm 01011bbb00111101FBBB111110111110.  */
{ "sethsl", 0x583D0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* sethsl<.f><.cc> 0,limm,RC 0101111011111101F111cccccc0QQQQQ.  */
{ "sethsl", 0x5EFD7000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* sethsl<.f><.cc> RB,RB,limm 01011bbb11111101FBBB1111100QQQQQ.  */
{ "sethsl", 0x58FD0F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* sethsl<.f> RA,limm,u6 0101111001111101F111uuuuuuaaaaaa.  */
{ "sethsl", 0x5E7D7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* sethsl<.f> 0,limm,u6 0101111001111101F111uuuuuu111110.  */
{ "sethsl", 0x5E7D703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* sethsl<.f><.cc> 0,limm,u6 0101111011111101F111uuuuuu1QQQQQ.  */
{ "sethsl", 0x5EFD7020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* sethsl<.f> 0,ximm,s12 0101110010111101F111ssssssSSSSSS.  */
{ "sethsl", 0x5CBD7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* sethsl<.f> 0,limm,s12 0101111010111101F111ssssssSSSSSS.  */
{ "sethsl", 0x5EBD7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* sethsl<.f> RA,ximm,ximm 0101110000111101F111111100aaaaaa.  */
{ "sethsl", 0x5C3D7F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* sethsl<.f> 0,ximm,ximm 0101110000111101F111111100111110.  */
{ "sethsl", 0x5C3D7F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* sethsl<.f><.cc> 0,ximm,ximm 0101110011111101F1111111000QQQQQ.  */
{ "sethsl", 0x5CFD7F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* sethsl<.f> RA,limm,limm 0101111000111101F111111110aaaaaa.  */
{ "sethsl", 0x5E3D7F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* sethsl<.f> 0,limm,limm 0101111000111101F111111110111110.  */
{ "sethsl", 0x5E3D7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* sethsl<.f><.cc> 0,limm,limm 0101111011111101F1111111100QQQQQ.  */
{ "sethsl", 0x5EFD7F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* seti c 00100110001011110000CCCCCC111111.  */
{ "seti", 0x262F003F, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { RC }, { 0 }},

/* seti u6 00100110011011110000uuuuuu111111.  */
{ "seti", 0x266F003F, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { UIMM6_20 }, { 0 }},

/* seti limm 00100110001011110000111110111111.  */
{ "seti", 0x262F0FBF, 0xFFFFFFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { LIMM }, { 0 }},

/* seti  00100110011011110000000000111111.  */
{ "seti", 0x266F003F, 0xFFFFFFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { 0 }, { 0 }},

/* setle<.f> a,b,c 00100bbb00111110FBBBCCCCCCAAAAAA.  */
{ "setle", 0x203E0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* setle<.f> 0,b,c 00100bbb00111110FBBBCCCCCC111110.  */
{ "setle", 0x203E003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* setle<.f><.cc> b,b,c 00100bbb11111110FBBBCCCCCC0QQQQQ.  */
{ "setle", 0x20FE0000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* setle<.f> a,b,u6 00100bbb01111110FBBBuuuuuuAAAAAA.  */
{ "setle", 0x207E0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* setle<.f> 0,b,u6 00100bbb01111110FBBBuuuuuu111110.  */
{ "setle", 0x207E003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* setle<.f><.cc> b,b,u6 00100bbb11111110FBBBuuuuuu1QQQQQ.  */
{ "setle", 0x20FE0020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* setle<.f> b,b,s12 00100bbb10111110FBBBssssssSSSSSS.  */
{ "setle", 0x20BE0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* setle<.f> a,limm,c 0010011000111110F111CCCCCCAAAAAA.  */
{ "setle", 0x263E7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* setle<.f> a,b,limm 00100bbb00111110FBBB111110AAAAAA.  */
{ "setle", 0x203E0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* setle<.f> 0,limm,c 0010011000111110F111CCCCCC111110.  */
{ "setle", 0x263E703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* setle<.f> 0,b,limm 00100bbb00111110FBBB111110111110.  */
{ "setle", 0x203E0FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* setle<.f><.cc> b,b,limm 00100bbb11111110FBBB1111100QQQQQ.  */
{ "setle", 0x20FE0F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* setle<.f><.cc> 0,limm,c 0010011011111110F111CCCCCC0QQQQQ.  */
{ "setle", 0x26FE7000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* setle<.f> a,limm,u6 0010011001111110F111uuuuuuAAAAAA.  */
{ "setle", 0x267E7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* setle<.f> 0,limm,u6 0010011001111110F111uuuuuu111110.  */
{ "setle", 0x267E703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* setle<.f><.cc> 0,limm,u6 0010011011111110F111uuuuuu1QQQQQ.  */
{ "setle", 0x26FE7020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* setle<.f> 0,limm,s12 0010011010111110F111ssssssSSSSSS.  */
{ "setle", 0x26BE7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* setle<.f> a,limm,limm 0010011000111110F111111110AAAAAA.  */
{ "setle", 0x263E7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* setle<.f> 0,limm,limm 0010011000111110F111111110111110.  */
{ "setle", 0x263E7FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* setle<.f><.cc> 0,limm,limm 0010011011111110F1111111100QQQQQ.  */
{ "setle", 0x26FE7F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* setlel<.f> RA,RB,RC 01011bbb00111110FBBBccccccaaaaaa.  */
{ "setlel", 0x583E0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* setlel<.f> 0,RB,RC 01011bbb00111110FBBBcccccc111110.  */
{ "setlel", 0x583E003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* setlel<.f><.cc> RB,RB,RC 01011bbb11111110FBBBcccccc0QQQQQ.  */
{ "setlel", 0x58FE0000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* setlel<.f> RA,RB,u6 01011bbb01111110FBBBuuuuuuaaaaaa.  */
{ "setlel", 0x587E0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* setlel<.f> 0,RB,u6 01011bbb01111110FBBBuuuuuu111110.  */
{ "setlel", 0x587E003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* setlel<.f><.cc> RB,RB,u6 01011bbb11111110FBBBuuuuuu1QQQQQ.  */
{ "setlel", 0x58FE0020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* setlel<.f> RB,RB,s12 01011bbb10111110FBBBssssssSSSSSS.  */
{ "setlel", 0x58BE0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* setlel<.f> RA,ximm,RC 0101110000111110F111ccccccaaaaaa.  */
{ "setlel", 0x5C3E7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* setlel<.f> RA,RB,ximm 01011bbb00111110FBBB111100aaaaaa.  */
{ "setlel", 0x583E0F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* setlel<.f> 0,ximm,RC 0101110000111110F111cccccc111110.  */
{ "setlel", 0x5C3E703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* setlel<.f> 0,RB,ximm 01011bbb00111110FBBB111100111110.  */
{ "setlel", 0x583E0F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* setlel<.f><.cc> 0,ximm,RC 0101110011111110F111cccccc0QQQQQ.  */
{ "setlel", 0x5CFE7000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* setlel<.f><.cc> RB,RB,ximm 01011bbb11111110FBBB1111000QQQQQ.  */
{ "setlel", 0x58FE0F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* setlel<.f> RA,ximm,u6 0101110001111110F111uuuuuuaaaaaa.  */
{ "setlel", 0x5C7E7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* setlel<.f> 0,ximm,u6 0101110001111110F111uuuuuu111110.  */
{ "setlel", 0x5C7E703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* setlel<.f><.cc> 0,ximm,u6 0101110011111110F111uuuuuu1QQQQQ.  */
{ "setlel", 0x5CFE7020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* setlel<.f> RA,limm,RC 0101111000111110F111ccccccaaaaaa.  */
{ "setlel", 0x5E3E7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* setlel<.f> RA,RB,limm 01011bbb00111110FBBB111110aaaaaa.  */
{ "setlel", 0x583E0F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* setlel<.f> 0,limm,RC 0101111000111110F111cccccc111110.  */
{ "setlel", 0x5E3E703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* setlel<.f> 0,RB,limm 01011bbb00111110FBBB111110111110.  */
{ "setlel", 0x583E0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* setlel<.f><.cc> 0,limm,RC 0101111011111110F111cccccc0QQQQQ.  */
{ "setlel", 0x5EFE7000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* setlel<.f><.cc> RB,RB,limm 01011bbb11111110FBBB1111100QQQQQ.  */
{ "setlel", 0x58FE0F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* setlel<.f> RA,limm,u6 0101111001111110F111uuuuuuaaaaaa.  */
{ "setlel", 0x5E7E7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* setlel<.f> 0,limm,u6 0101111001111110F111uuuuuu111110.  */
{ "setlel", 0x5E7E703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* setlel<.f><.cc> 0,limm,u6 0101111011111110F111uuuuuu1QQQQQ.  */
{ "setlel", 0x5EFE7020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* setlel<.f> 0,ximm,s12 0101110010111110F111ssssssSSSSSS.  */
{ "setlel", 0x5CBE7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* setlel<.f> 0,limm,s12 0101111010111110F111ssssssSSSSSS.  */
{ "setlel", 0x5EBE7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* setlel<.f> RA,ximm,ximm 0101110000111110F111111100aaaaaa.  */
{ "setlel", 0x5C3E7F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* setlel<.f> 0,ximm,ximm 0101110000111110F111111100111110.  */
{ "setlel", 0x5C3E7F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* setlel<.f><.cc> 0,ximm,ximm 0101110011111110F1111111000QQQQQ.  */
{ "setlel", 0x5CFE7F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* setlel<.f> RA,limm,limm 0101111000111110F111111110aaaaaa.  */
{ "setlel", 0x5E3E7F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* setlel<.f> 0,limm,limm 0101111000111110F111111110111110.  */
{ "setlel", 0x5E3E7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* setlel<.f><.cc> 0,limm,limm 0101111011111110F1111111100QQQQQ.  */
{ "setlel", 0x5EFE7F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* setlo<.f> a,b,c 00100bbb00111100FBBBCCCCCCAAAAAA.  */
{ "setlo", 0x203C0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* setlo<.f> 0,b,c 00100bbb00111100FBBBCCCCCC111110.  */
{ "setlo", 0x203C003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* setlo<.f><.cc> b,b,c 00100bbb11111100FBBBCCCCCC0QQQQQ.  */
{ "setlo", 0x20FC0000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* setlo<.f> a,b,u6 00100bbb01111100FBBBuuuuuuAAAAAA.  */
{ "setlo", 0x207C0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* setlo<.f> 0,b,u6 00100bbb01111100FBBBuuuuuu111110.  */
{ "setlo", 0x207C003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* setlo<.f><.cc> b,b,u6 00100bbb11111100FBBBuuuuuu1QQQQQ.  */
{ "setlo", 0x20FC0020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* setlo<.f> b,b,s12 00100bbb10111100FBBBssssssSSSSSS.  */
{ "setlo", 0x20BC0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* setlo<.f> a,limm,c 0010011000111100F111CCCCCCAAAAAA.  */
{ "setlo", 0x263C7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* setlo<.f> a,b,limm 00100bbb00111100FBBB111110AAAAAA.  */
{ "setlo", 0x203C0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* setlo<.f> 0,limm,c 0010011000111100F111CCCCCC111110.  */
{ "setlo", 0x263C703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* setlo<.f> 0,b,limm 00100bbb00111100FBBB111110111110.  */
{ "setlo", 0x203C0FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* setlo<.f><.cc> b,b,limm 00100bbb11111100FBBB1111100QQQQQ.  */
{ "setlo", 0x20FC0F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* setlo<.f><.cc> 0,limm,c 0010011011111100F111CCCCCC0QQQQQ.  */
{ "setlo", 0x26FC7000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* setlo<.f> a,limm,u6 0010011001111100F111uuuuuuAAAAAA.  */
{ "setlo", 0x267C7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* setlo<.f> 0,limm,u6 0010011001111100F111uuuuuu111110.  */
{ "setlo", 0x267C703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* setlo<.f><.cc> 0,limm,u6 0010011011111100F111uuuuuu1QQQQQ.  */
{ "setlo", 0x26FC7020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* setlo<.f> 0,limm,s12 0010011010111100F111ssssssSSSSSS.  */
{ "setlo", 0x26BC7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* setlo<.f> a,limm,limm 0010011000111100F111111110AAAAAA.  */
{ "setlo", 0x263C7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* setlo<.f> 0,limm,limm 0010011000111100F111111110111110.  */
{ "setlo", 0x263C7FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* setlo<.f><.cc> 0,limm,limm 0010011011111100F1111111100QQQQQ.  */
{ "setlo", 0x26FC7F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* setlol<.f> RA,RB,RC 01011bbb00111100FBBBccccccaaaaaa.  */
{ "setlol", 0x583C0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* setlol<.f> 0,RB,RC 01011bbb00111100FBBBcccccc111110.  */
{ "setlol", 0x583C003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* setlol<.f><.cc> RB,RB,RC 01011bbb11111100FBBBcccccc0QQQQQ.  */
{ "setlol", 0x58FC0000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* setlol<.f> RA,RB,u6 01011bbb01111100FBBBuuuuuuaaaaaa.  */
{ "setlol", 0x587C0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* setlol<.f> 0,RB,u6 01011bbb01111100FBBBuuuuuu111110.  */
{ "setlol", 0x587C003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* setlol<.f><.cc> RB,RB,u6 01011bbb11111100FBBBuuuuuu1QQQQQ.  */
{ "setlol", 0x58FC0020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* setlol<.f> RB,RB,s12 01011bbb10111100FBBBssssssSSSSSS.  */
{ "setlol", 0x58BC0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* setlol<.f> RA,ximm,RC 0101110000111100F111ccccccaaaaaa.  */
{ "setlol", 0x5C3C7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* setlol<.f> RA,RB,ximm 01011bbb00111100FBBB111100aaaaaa.  */
{ "setlol", 0x583C0F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* setlol<.f> 0,ximm,RC 0101110000111100F111cccccc111110.  */
{ "setlol", 0x5C3C703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* setlol<.f> 0,RB,ximm 01011bbb00111100FBBB111100111110.  */
{ "setlol", 0x583C0F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* setlol<.f><.cc> 0,ximm,RC 0101110011111100F111cccccc0QQQQQ.  */
{ "setlol", 0x5CFC7000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* setlol<.f><.cc> RB,RB,ximm 01011bbb11111100FBBB1111000QQQQQ.  */
{ "setlol", 0x58FC0F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* setlol<.f> RA,ximm,u6 0101110001111100F111uuuuuuaaaaaa.  */
{ "setlol", 0x5C7C7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* setlol<.f> 0,ximm,u6 0101110001111100F111uuuuuu111110.  */
{ "setlol", 0x5C7C703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* setlol<.f><.cc> 0,ximm,u6 0101110011111100F111uuuuuu1QQQQQ.  */
{ "setlol", 0x5CFC7020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* setlol<.f> RA,limm,RC 0101111000111100F111ccccccaaaaaa.  */
{ "setlol", 0x5E3C7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* setlol<.f> RA,RB,limm 01011bbb00111100FBBB111110aaaaaa.  */
{ "setlol", 0x583C0F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* setlol<.f> 0,limm,RC 0101111000111100F111cccccc111110.  */
{ "setlol", 0x5E3C703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* setlol<.f> 0,RB,limm 01011bbb00111100FBBB111110111110.  */
{ "setlol", 0x583C0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* setlol<.f><.cc> 0,limm,RC 0101111011111100F111cccccc0QQQQQ.  */
{ "setlol", 0x5EFC7000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* setlol<.f><.cc> RB,RB,limm 01011bbb11111100FBBB1111100QQQQQ.  */
{ "setlol", 0x58FC0F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* setlol<.f> RA,limm,u6 0101111001111100F111uuuuuuaaaaaa.  */
{ "setlol", 0x5E7C7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* setlol<.f> 0,limm,u6 0101111001111100F111uuuuuu111110.  */
{ "setlol", 0x5E7C703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* setlol<.f><.cc> 0,limm,u6 0101111011111100F111uuuuuu1QQQQQ.  */
{ "setlol", 0x5EFC7020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* setlol<.f> 0,ximm,s12 0101110010111100F111ssssssSSSSSS.  */
{ "setlol", 0x5CBC7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* setlol<.f> 0,limm,s12 0101111010111100F111ssssssSSSSSS.  */
{ "setlol", 0x5EBC7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* setlol<.f> RA,ximm,ximm 0101110000111100F111111100aaaaaa.  */
{ "setlol", 0x5C3C7F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* setlol<.f> 0,ximm,ximm 0101110000111100F111111100111110.  */
{ "setlol", 0x5C3C7F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* setlol<.f><.cc> 0,ximm,ximm 0101110011111100F1111111000QQQQQ.  */
{ "setlol", 0x5CFC7F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* setlol<.f> RA,limm,limm 0101111000111100F111111110aaaaaa.  */
{ "setlol", 0x5E3C7F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* setlol<.f> 0,limm,limm 0101111000111100F111111110111110.  */
{ "setlol", 0x5E3C7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* setlol<.f><.cc> 0,limm,limm 0101111011111100F1111111100QQQQQ.  */
{ "setlol", 0x5EFC7F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* setlt<.f> a,b,c 00100bbb00111010FBBBCCCCCCAAAAAA.  */
{ "setlt", 0x203A0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* setlt<.f> 0,b,c 00100bbb00111010FBBBCCCCCC111110.  */
{ "setlt", 0x203A003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* setlt<.f><.cc> b,b,c 00100bbb11111010FBBBCCCCCC0QQQQQ.  */
{ "setlt", 0x20FA0000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* setlt<.f> a,b,u6 00100bbb01111010FBBBuuuuuuAAAAAA.  */
{ "setlt", 0x207A0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* setlt<.f> 0,b,u6 00100bbb01111010FBBBuuuuuu111110.  */
{ "setlt", 0x207A003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* setlt<.f><.cc> b,b,u6 00100bbb11111010FBBBuuuuuu1QQQQQ.  */
{ "setlt", 0x20FA0020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* setlt<.f> b,b,s12 00100bbb10111010FBBBssssssSSSSSS.  */
{ "setlt", 0x20BA0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* setlt<.f> a,limm,c 0010011000111010F111CCCCCCAAAAAA.  */
{ "setlt", 0x263A7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* setlt<.f> a,b,limm 00100bbb00111010FBBB111110AAAAAA.  */
{ "setlt", 0x203A0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* setlt<.f> 0,limm,c 0010011000111010F111CCCCCC111110.  */
{ "setlt", 0x263A703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* setlt<.f> 0,b,limm 00100bbb00111010FBBB111110111110.  */
{ "setlt", 0x203A0FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* setlt<.f><.cc> b,b,limm 00100bbb11111010FBBB1111100QQQQQ.  */
{ "setlt", 0x20FA0F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* setlt<.f><.cc> 0,limm,c 0010011011111010F111CCCCCC0QQQQQ.  */
{ "setlt", 0x26FA7000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* setlt<.f> a,limm,u6 0010011001111010F111uuuuuuAAAAAA.  */
{ "setlt", 0x267A7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* setlt<.f> 0,limm,u6 0010011001111010F111uuuuuu111110.  */
{ "setlt", 0x267A703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* setlt<.f><.cc> 0,limm,u6 0010011011111010F111uuuuuu1QQQQQ.  */
{ "setlt", 0x26FA7020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* setlt<.f> 0,limm,s12 0010011010111010F111ssssssSSSSSS.  */
{ "setlt", 0x26BA7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* setlt<.f> a,limm,limm 0010011000111010F111111110AAAAAA.  */
{ "setlt", 0x263A7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* setlt<.f> 0,limm,limm 0010011000111010F111111110111110.  */
{ "setlt", 0x263A7FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* setlt<.f><.cc> 0,limm,limm 0010011011111010F1111111100QQQQQ.  */
{ "setlt", 0x26FA7F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* setltl<.f> RA,RB,RC 01011bbb00111010FBBBccccccaaaaaa.  */
{ "setltl", 0x583A0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* setltl<.f> 0,RB,RC 01011bbb00111010FBBBcccccc111110.  */
{ "setltl", 0x583A003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* setltl<.f><.cc> RB,RB,RC 01011bbb11111010FBBBcccccc0QQQQQ.  */
{ "setltl", 0x58FA0000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* setltl<.f> RA,RB,u6 01011bbb01111010FBBBuuuuuuaaaaaa.  */
{ "setltl", 0x587A0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* setltl<.f> 0,RB,u6 01011bbb01111010FBBBuuuuuu111110.  */
{ "setltl", 0x587A003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* setltl<.f><.cc> RB,RB,u6 01011bbb11111010FBBBuuuuuu1QQQQQ.  */
{ "setltl", 0x58FA0020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* setltl<.f> RB,RB,s12 01011bbb10111010FBBBssssssSSSSSS.  */
{ "setltl", 0x58BA0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* setltl<.f> RA,ximm,RC 0101110000111010F111ccccccaaaaaa.  */
{ "setltl", 0x5C3A7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* setltl<.f> RA,RB,ximm 01011bbb00111010FBBB111100aaaaaa.  */
{ "setltl", 0x583A0F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* setltl<.f> 0,ximm,RC 0101110000111010F111cccccc111110.  */
{ "setltl", 0x5C3A703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* setltl<.f> 0,RB,ximm 01011bbb00111010FBBB111100111110.  */
{ "setltl", 0x583A0F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* setltl<.f><.cc> 0,ximm,RC 0101110011111010F111cccccc0QQQQQ.  */
{ "setltl", 0x5CFA7000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* setltl<.f><.cc> RB,RB,ximm 01011bbb11111010FBBB1111000QQQQQ.  */
{ "setltl", 0x58FA0F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* setltl<.f> RA,ximm,u6 0101110001111010F111uuuuuuaaaaaa.  */
{ "setltl", 0x5C7A7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* setltl<.f> 0,ximm,u6 0101110001111010F111uuuuuu111110.  */
{ "setltl", 0x5C7A703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* setltl<.f><.cc> 0,ximm,u6 0101110011111010F111uuuuuu1QQQQQ.  */
{ "setltl", 0x5CFA7020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* setltl<.f> RA,limm,RC 0101111000111010F111ccccccaaaaaa.  */
{ "setltl", 0x5E3A7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* setltl<.f> RA,RB,limm 01011bbb00111010FBBB111110aaaaaa.  */
{ "setltl", 0x583A0F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* setltl<.f> 0,limm,RC 0101111000111010F111cccccc111110.  */
{ "setltl", 0x5E3A703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* setltl<.f> 0,RB,limm 01011bbb00111010FBBB111110111110.  */
{ "setltl", 0x583A0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* setltl<.f><.cc> 0,limm,RC 0101111011111010F111cccccc0QQQQQ.  */
{ "setltl", 0x5EFA7000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* setltl<.f><.cc> RB,RB,limm 01011bbb11111010FBBB1111100QQQQQ.  */
{ "setltl", 0x58FA0F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* setltl<.f> RA,limm,u6 0101111001111010F111uuuuuuaaaaaa.  */
{ "setltl", 0x5E7A7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* setltl<.f> 0,limm,u6 0101111001111010F111uuuuuu111110.  */
{ "setltl", 0x5E7A703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* setltl<.f><.cc> 0,limm,u6 0101111011111010F111uuuuuu1QQQQQ.  */
{ "setltl", 0x5EFA7020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* setltl<.f> 0,ximm,s12 0101110010111010F111ssssssSSSSSS.  */
{ "setltl", 0x5CBA7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* setltl<.f> 0,limm,s12 0101111010111010F111ssssssSSSSSS.  */
{ "setltl", 0x5EBA7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* setltl<.f> RA,ximm,ximm 0101110000111010F111111100aaaaaa.  */
{ "setltl", 0x5C3A7F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* setltl<.f> 0,ximm,ximm 0101110000111010F111111100111110.  */
{ "setltl", 0x5C3A7F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* setltl<.f><.cc> 0,ximm,ximm 0101110011111010F1111111000QQQQQ.  */
{ "setltl", 0x5CFA7F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* setltl<.f> RA,limm,limm 0101111000111010F111111110aaaaaa.  */
{ "setltl", 0x5E3A7F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* setltl<.f> 0,limm,limm 0101111000111010F111111110111110.  */
{ "setltl", 0x5E3A7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* setltl<.f><.cc> 0,limm,limm 0101111011111010F1111111100QQQQQ.  */
{ "setltl", 0x5EFA7F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* setne<.f> a,b,c 00100bbb00111001FBBBCCCCCCAAAAAA.  */
{ "setne", 0x20390000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* setne<.f> 0,b,c 00100bbb00111001FBBBCCCCCC111110.  */
{ "setne", 0x2039003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* setne<.f><.cc> b,b,c 00100bbb11111001FBBBCCCCCC0QQQQQ.  */
{ "setne", 0x20F90000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* setne<.f> a,b,u6 00100bbb01111001FBBBuuuuuuAAAAAA.  */
{ "setne", 0x20790000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* setne<.f> 0,b,u6 00100bbb01111001FBBBuuuuuu111110.  */
{ "setne", 0x2079003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* setne<.f><.cc> b,b,u6 00100bbb11111001FBBBuuuuuu1QQQQQ.  */
{ "setne", 0x20F90020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* setne<.f> b,b,s12 00100bbb10111001FBBBssssssSSSSSS.  */
{ "setne", 0x20B90000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* setne<.f> a,limm,c 0010011000111001F111CCCCCCAAAAAA.  */
{ "setne", 0x26397000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* setne<.f> a,b,limm 00100bbb00111001FBBB111110AAAAAA.  */
{ "setne", 0x20390F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* setne<.f> 0,limm,c 0010011000111001F111CCCCCC111110.  */
{ "setne", 0x2639703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* setne<.f> 0,b,limm 00100bbb00111001FBBB111110111110.  */
{ "setne", 0x20390FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* setne<.f><.cc> b,b,limm 00100bbb11111001FBBB1111100QQQQQ.  */
{ "setne", 0x20F90F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* setne<.f><.cc> 0,limm,c 0010011011111001F111CCCCCC0QQQQQ.  */
{ "setne", 0x26F97000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* setne<.f> a,limm,u6 0010011001111001F111uuuuuuAAAAAA.  */
{ "setne", 0x26797000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* setne<.f> 0,limm,u6 0010011001111001F111uuuuuu111110.  */
{ "setne", 0x2679703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* setne<.f><.cc> 0,limm,u6 0010011011111001F111uuuuuu1QQQQQ.  */
{ "setne", 0x26F97020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* setne<.f> 0,limm,s12 0010011010111001F111ssssssSSSSSS.  */
{ "setne", 0x26B97000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* setne<.f> a,limm,limm 0010011000111001F111111110AAAAAA.  */
{ "setne", 0x26397F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* setne<.f> 0,limm,limm 0010011000111001F111111110111110.  */
{ "setne", 0x26397FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* setne<.f><.cc> 0,limm,limm 0010011011111001F1111111100QQQQQ.  */
{ "setne", 0x26F97F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* setnel<.f> RA,RB,RC 01011bbb00111001FBBBccccccaaaaaa.  */
{ "setnel", 0x58390000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* setnel<.f> 0,RB,RC 01011bbb00111001FBBBcccccc111110.  */
{ "setnel", 0x5839003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* setnel<.f><.cc> RB,RB,RC 01011bbb11111001FBBBcccccc0QQQQQ.  */
{ "setnel", 0x58F90000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* setnel<.f> RA,RB,u6 01011bbb01111001FBBBuuuuuuaaaaaa.  */
{ "setnel", 0x58790000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* setnel<.f> 0,RB,u6 01011bbb01111001FBBBuuuuuu111110.  */
{ "setnel", 0x5879003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* setnel<.f><.cc> RB,RB,u6 01011bbb11111001FBBBuuuuuu1QQQQQ.  */
{ "setnel", 0x58F90020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* setnel<.f> RB,RB,s12 01011bbb10111001FBBBssssssSSSSSS.  */
{ "setnel", 0x58B90000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* setnel<.f> RA,ximm,RC 0101110000111001F111ccccccaaaaaa.  */
{ "setnel", 0x5C397000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* setnel<.f> RA,RB,ximm 01011bbb00111001FBBB111100aaaaaa.  */
{ "setnel", 0x58390F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* setnel<.f> 0,ximm,RC 0101110000111001F111cccccc111110.  */
{ "setnel", 0x5C39703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* setnel<.f> 0,RB,ximm 01011bbb00111001FBBB111100111110.  */
{ "setnel", 0x58390F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* setnel<.f><.cc> 0,ximm,RC 0101110011111001F111cccccc0QQQQQ.  */
{ "setnel", 0x5CF97000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* setnel<.f><.cc> RB,RB,ximm 01011bbb11111001FBBB1111000QQQQQ.  */
{ "setnel", 0x58F90F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* setnel<.f> RA,ximm,u6 0101110001111001F111uuuuuuaaaaaa.  */
{ "setnel", 0x5C797000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* setnel<.f> 0,ximm,u6 0101110001111001F111uuuuuu111110.  */
{ "setnel", 0x5C79703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* setnel<.f><.cc> 0,ximm,u6 0101110011111001F111uuuuuu1QQQQQ.  */
{ "setnel", 0x5CF97020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* setnel<.f> RA,limm,RC 0101111000111001F111ccccccaaaaaa.  */
{ "setnel", 0x5E397000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* setnel<.f> RA,RB,limm 01011bbb00111001FBBB111110aaaaaa.  */
{ "setnel", 0x58390F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* setnel<.f> 0,limm,RC 0101111000111001F111cccccc111110.  */
{ "setnel", 0x5E39703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* setnel<.f> 0,RB,limm 01011bbb00111001FBBB111110111110.  */
{ "setnel", 0x58390FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* setnel<.f><.cc> 0,limm,RC 0101111011111001F111cccccc0QQQQQ.  */
{ "setnel", 0x5EF97000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* setnel<.f><.cc> RB,RB,limm 01011bbb11111001FBBB1111100QQQQQ.  */
{ "setnel", 0x58F90F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* setnel<.f> RA,limm,u6 0101111001111001F111uuuuuuaaaaaa.  */
{ "setnel", 0x5E797000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* setnel<.f> 0,limm,u6 0101111001111001F111uuuuuu111110.  */
{ "setnel", 0x5E79703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* setnel<.f><.cc> 0,limm,u6 0101111011111001F111uuuuuu1QQQQQ.  */
{ "setnel", 0x5EF97020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* setnel<.f> 0,ximm,s12 0101110010111001F111ssssssSSSSSS.  */
{ "setnel", 0x5CB97000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* setnel<.f> 0,limm,s12 0101111010111001F111ssssssSSSSSS.  */
{ "setnel", 0x5EB97000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* setnel<.f> RA,ximm,ximm 0101110000111001F111111100aaaaaa.  */
{ "setnel", 0x5C397F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* setnel<.f> 0,ximm,ximm 0101110000111001F111111100111110.  */
{ "setnel", 0x5C397F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* setnel<.f><.cc> 0,ximm,ximm 0101110011111001F1111111000QQQQQ.  */
{ "setnel", 0x5CF97F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* setnel<.f> RA,limm,limm 0101111000111001F111111110aaaaaa.  */
{ "setnel", 0x5E397F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* setnel<.f> 0,limm,limm 0101111000111001F111111110111110.  */
{ "setnel", 0x5E397FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* setnel<.f><.cc> 0,limm,limm 0101111011111001F1111111100QQQQQ.  */
{ "setnel", 0x5EF97F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* sexb<.f> b,c 00100bbb00101111FBBBCCCCCC000101.  */
{ "sexb", 0x202F0005, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* sexb<.f> 0,c 0010011000101111F111CCCCCC000101.  */
{ "sexb", 0x262F7005, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RC }, { C_F }},

/* sexb<.f> b,u6 00100bbb01101111FBBBuuuuuu000101.  */
{ "sexb", 0x206F0005, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* sexb<.f> 0,u6 0010011001101111F111uuuuuu000101.  */
{ "sexb", 0x266F7005, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* sexb<.f> b,limm 00100bbb00101111FBBB111110000101.  */
{ "sexb", 0x202F0F85, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* sexb<.f> 0,limm 0010011000101111F111111110000101.  */
{ "sexb", 0x262F7F85, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* sexbl<.f> RB,RC 01011bbb00101111FBBBcccccc000101.  */
{ "sexbl", 0x582F0005, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* sexbl<.f> 0,RC 0101111000101111F111cccccc000101.  */
{ "sexbl", 0x5E2F7005, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RC }, { C_F }},

/* sexbl<.f> RB,u6 01011bbb01101111FBBBuuuuuu000101.  */
{ "sexbl", 0x586F0005, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* sexbl<.f> 0,u6 0101111001101111F111uuuuuu000101.  */
{ "sexbl", 0x5E6F7005, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* sexbl<.f> RB,ximm 01011bbb00101111FBBB111100000101.  */
{ "sexbl", 0x582F0F05, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { C_F }},

/* sexbl<.f> 0,ximm 0101111000101111F111111100000101.  */
{ "sexbl", 0x5E2F7F05, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM }, { C_F }},

/* sexbl<.f> RB,limm 01011bbb00101111FBBB111110000101.  */
{ "sexbl", 0x582F0F85, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* sexbl<.f> 0,limm 0101111000101111F111111110000101.  */
{ "sexbl", 0x5E2F7F85, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* sexb_s b,c 01111bbbccc01101.  */
{ "sexb_s", 0x0000780D, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB_S, RC_S }, { 0 }},

/* sexh<.f> b,c 00100bbb00101111FBBBCCCCCC000110.  */
{ "sexh", 0x202F0006, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* sexh<.f> 0,c 0010011000101111F111CCCCCC000110.  */
{ "sexh", 0x262F7006, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RC }, { C_F }},

/* sexh<.f> b,u6 00100bbb01101111FBBBuuuuuu000110.  */
{ "sexh", 0x206F0006, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* sexh<.f> 0,u6 0010011001101111F111uuuuuu000110.  */
{ "sexh", 0x266F7006, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* sexh<.f> b,limm 00100bbb00101111FBBB111110000110.  */
{ "sexh", 0x202F0F86, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* sexh<.f> 0,limm 0010011000101111F111111110000110.  */
{ "sexh", 0x262F7F86, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* sexhl<.f> RB,RC 01011bbb00101111FBBBcccccc000110.  */
{ "sexhl", 0x582F0006, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* sexhl<.f> 0,RC 0101111000101111F111cccccc000110.  */
{ "sexhl", 0x5E2F7006, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RC }, { C_F }},

/* sexhl<.f> RB,u6 01011bbb01101111FBBBuuuuuu000110.  */
{ "sexhl", 0x586F0006, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* sexhl<.f> 0,u6 0101111001101111F111uuuuuu000110.  */
{ "sexhl", 0x5E6F7006, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* sexhl<.f> RB,ximm 01011bbb00101111FBBB111100000110.  */
{ "sexhl", 0x582F0F06, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { C_F }},

/* sexhl<.f> 0,ximm 0101111000101111F111111100000110.  */
{ "sexhl", 0x5E2F7F06, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM }, { C_F }},

/* sexhl<.f> RB,limm 01011bbb00101111FBBB111110000110.  */
{ "sexhl", 0x582F0F86, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* sexhl<.f> 0,limm 0101111000101111F111111110000110.  */
{ "sexhl", 0x5E2F7F86, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* sexh_s b,c 01111bbbccc01110.  */
{ "sexh_s", 0x0000780E, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, NONE, { RB_S, RC_S }, { 0 }},

/* sexwl<.f> RB,RC 01011bbb00101111FBBBcccccc000111.  */
{ "sexwl", 0x582F0007, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* sexwl<.f> 0,RC 0101111000101111F111cccccc000111.  */
{ "sexwl", 0x5E2F7007, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RC }, { C_F }},

/* sexwl<.f> RB,u6 01011bbb01101111FBBBuuuuuu000111.  */
{ "sexwl", 0x586F0007, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* sexwl<.f> 0,u6 0101111001101111F111uuuuuu000111.  */
{ "sexwl", 0x5E6F7007, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* sexwl<.f> RB,ximm 01011bbb00101111FBBB111100000111.  */
{ "sexwl", 0x582F0F07, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { C_F }},

/* sexwl<.f> 0,ximm 0101111000101111F111111100000111.  */
{ "sexwl", 0x5E2F7F07, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM }, { C_F }},

/* sexwl<.f> RB,limm 01011bbb00101111FBBB111110000111.  */
{ "sexwl", 0x582F0F87, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* sexwl<.f> 0,limm 0101111000101111F111111110000111.  */
{ "sexwl", 0x5E2F7F87, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* sleep c 00100001001011110000CCCCCC111111.  */
{ "sleep", 0x212F003F, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, KERNEL, NONE, { RC }, { 0 }},

/* sleep u6 00100001011011110000uuuuuu111111.  */
{ "sleep", 0x216F003F, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, KERNEL, NONE, { UIMM6_20 }, { 0 }},

/* sleep limm 00100001001011110000111110111111.  */
{ "sleep", 0x212F0FBF, 0xFFFFFFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, KERNEL, NONE, { LIMM }, { 0 }},

/* sleep  00100001011011110000000000111111.  */
{ "sleep", 0x216F003F, 0xFFFFFFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, KERNEL, NONE, { 0 }, { 0 }},

/* sr b,c 00100bbb00101011RBBBCCCCCCRRRRRR.  */
{ "sr", 0x202B0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, RC, BRAKETdup }, { 0 }},

/* sr b,u6 00100bbb01101011RBBBuuuuuu000000.  */
{ "sr", 0x206B0000, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, UIMM6_20, BRAKETdup }, { 0 }},

/* sr b,s12 00100bbb10101011RBBBssssssSSSSSS.  */
{ "sr", 0x20AB0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, SIMM12_20, BRAKETdup }, { 0 }},

/* sr limm,c 0010011000101011R111CCCCCCRRRRRR.  */
{ "sr", 0x262B7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { LIMM, BRAKET, RC, BRAKETdup }, { 0 }},

/* sr b,limm 00100bbb00101011RBBB111110RRRRRR.  */
{ "sr", 0x202B0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, LIMM, BRAKETdup }, { 0 }},

/* sr limm,u6 0010011001101011R111uuuuuu000000.  */
{ "sr", 0x266B7000, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { LIMM, BRAKET, UIMM6_20, BRAKETdup }, { 0 }},

/* sr limm,s12 0010011010101011R111ssssssSSSSSS.  */
{ "sr", 0x26AB7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { LIMM, BRAKET, SIMM12_20, BRAKETdup }, { 0 }},

/* sr limm,limm 0010011000101011R111111110RRRRRR.  */
{ "sr", 0x262B7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, AUXREG, NONE, { LIMM, BRAKET, LIMMdup, BRAKETdup }, { 0 }},

/* srl RB,RC 01011bbb001010110BBBccccccRRRRRR.  */
{ "srl", 0x582B0000, 0xF8FF8000, ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, RC, BRAKETdup }, { 0 }},

/* srl RB,u6 01011bbb011010110BBBuuuuuuRRRRRR.  */
{ "srl", 0x586B0000, 0xF8FF8000, ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, UIMM6_20, BRAKETdup }, { 0 }},

/* srl RB,s12 01011bbb101010110BBBssssssSSSSSS.  */
{ "srl", 0x58AB0000, 0xF8FF8000, ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, SIMM12_20, BRAKETdup }, { 0 }},

/* srl RB,ximm 01011bbb001010110BBB111100RRRRRR.  */
{ "srl", 0x582B0F00, 0xF8FF8FC0, ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, XIMM, BRAKETdup }, { 0 }},

/* srl RB,limm 01011bbb001010110BBB111110RRRRRR.  */
{ "srl", 0x582B0F80, 0xF8FF8FC0, ARC_OPCODE_ARC64, AUXREG, NONE, { RB_CHK, BRAKET, LIMM, BRAKETdup }, { 0 }},

/* st<zz><.di><.aa> c,b,s9       00011bbbssssssssSBBBCCCCCCDaaZZ0 -> st c   ,[b,s9]    */
/* st<zz><.di><.aa> w6,b,s9      00011bbbssssssssSBBBwwwwwwDaaZZ1 -> st w6  ,[b,s9]    */
/* st<zz><.di><.aa> limm,b,s9    00011bbbssssssssSBBB111110DaaZZ0 -> st c=62,[b,s9]    */
/* st<zz><.di><.aa> c,limm,s9    00011110ssssssssS111CCCCCCDRRZZ0 -> st c   ,[b=62,s9] */
/* st<zz><.di><.aa> w6,limm,s9   00011110ssssssssS111wwwwwwDRRZZ1 -> st w6  ,[b=62,s9] */
/* st<zz><.di><.aa> limm,limm,s9 00011110ssssssssS111111110DRRZZ0 -> st c=62,[b=62,s9] */
{ "st", 0x18000000, 0xF8000001, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, STORE, NONE, { RC, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_ZZ29, C_DI26, C_AA27 }},
{ "st", 0x18000001, 0xF8000001, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, STORE, NONE, { W6, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_ZZW6, C_DI26, C_AA27 }},
{ "st", 0x18000001, 0xF8000021, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, STORE, NONE, { W6, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_ZZH1, C_AA27 }},
{ "st", 0x18000F80, 0xF8000FC1, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, STORE, NONE, { LIMM, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_ZZ29, C_DI26, C_AA27 }},
{ "st", 0x1E007000, 0xFF007001, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, STORE, NONE, { RC, BRAKET, LIMM, SIMM9_8, BRAKETdup }, { C_ZZ29, C_DI26 }},
{ "st", 0x1E007001, 0xFF007001, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, STORE, NONE, { W6, BRAKET, LIMM, SIMM9_8, BRAKETdup }, { C_ZZW6, C_DI26 }},
{ "st", 0x1E007001, 0xFF007021, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, STORE, NONE, { W6, BRAKET, LIMM, SIMM9_8, BRAKETdup }, { C_ZZH1 }},
{ "st", 0x1E007F80, 0xFF007FC1, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, STORE, NONE, { LIMM, BRAKET, LIMMdup, SIMM9_8, BRAKETdup }, { C_ZZ29, C_DI26 }},

/* stb_sZZ_B c,b,u5 10101bbbcccuuuuu.  */
{ "stb_s", 0x0000A800, 0x0000F800,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, STORE, NONE, { RC_S, BRAKET, RB_S, UIMM5_11_S, BRAKETdup }, { C_ZZ_B }},

/* stb_sZZ_B b,SP,u7 11000bbb011uuuuu.  */
{ "stb_s", 0x0000C060, 0x0000F8E0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, STORE, NONE, { RB_S, BRAKET, SP_S, UIMM7_A32_11_S, BRAKETdup }, { C_ZZ_B }},

/* std<.aa>.<di> c,b       00011bbb000000000BBBCCCCCCDaa110 -> std c,[b,s9=0]       */
/* std<.aa>.<di> w6,b      00011bbb000000000BBBwwwwwwDaa111 -> std w6,[b,s9=0]      */
/* std<.aa>.<di> limm,b    00011bbb000000000BBB111110Daa110 -> std c=62,[b,s9=0]    */
/* std<.aa>.<di> c,limm    00011110000000000111CCCCCCDaa110 -> std c,[b=62,s9=0]    */
/* std<.aa>.<di> w6,limm   00011110000000000111wwwwwwDaa111 -> std w6,[b=62,s9=0]   */
/* std<.aa>.<di> limm,limm 00011110000000000111111110Daa110 -> std c=62,[b=62,s9=0] */
{ "std", 0x18000006, 0xF8FF8007, ARC_OPCODE_ARC32, STORE, NONE, { RCD, BRAKET, RB, BRAKETdup }, { C_DI26, C_AA27 }},
{ "std", 0x18000007, 0xF8FF8007, ARC_OPCODE_ARC32, STORE, NONE, { W6, BRAKET, RB, BRAKETdup }, { C_DI26, C_AA27 }},
{ "std", 0x18000F86, 0xF8FF8FC7, ARC_OPCODE_ARC32, STORE, NONE, { LIMM, BRAKET, RB, BRAKETdup }, { C_DI26, C_AA27 }},
{ "std", 0x1E007006, 0xFFFFF007, ARC_OPCODE_ARC32, STORE, NONE, { RCD, BRAKET, LIMM, BRAKETdup }, { C_DI26, C_AA27 }},
{ "std", 0x1E007007, 0xFFFFF007, ARC_OPCODE_ARC32, STORE, NONE, { W6, BRAKET, LIMM, BRAKETdup }, { C_DI26, C_AA27 }},
{ "std", 0x1E007F86, 0xFFFFFFC7, ARC_OPCODE_ARC32, STORE, NONE, { LIMM, BRAKET, LIMMdup, BRAKETdup }, { C_DI26, C_AA27 }},

/* std<.aa>.<di> c,b,s9       00011bbbssssssssSBBBCCCCCCDaa110 -> std c,[b,s9]       */
/* std<.aa>.<di> w6,b,s9      00011bbbssssssssSBBBwwwwwwDaa111 -> std w6,[b,s9]      */
/* std<.aa>.<di> limm,b,s9    00011bbbssssssssSBBB111110Daa110 -> std c=62,[b,s9]    */
/* std<.aa>.<di> c,limm,s9    00011110ssssssssS111CCCCCCDaa110 -> std c,[b=62,s9]    */
/* std<.aa>.<di> w6,limm,s9   00011110ssssssssS111wwwwwwDaa111 -> std w6,[b=62,s9]   */
/* std<.aa>.<di> limm,limm,s9 00011110ssssssssS111111110Daa110 -> std c=62,[b=62,s9] */
{ "std", 0x18000006, 0xF8000007, ARC_OPCODE_ARC32, STORE, NONE, { RCD, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_DI26, C_AA27 }},
{ "std", 0x18000007, 0xF8000007, ARC_OPCODE_ARC32, STORE, NONE, { W6, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_DI26, C_AA27 }},
{ "std", 0x18000F86, 0xF8000FC7, ARC_OPCODE_ARC32, STORE, NONE, { LIMM, BRAKET, RB, SIMM9_8, BRAKETdup }, { C_DI26, C_AA27 }},
{ "std", 0x1E007006, 0xFF007007, ARC_OPCODE_ARC32, STORE, NONE, { RCD, BRAKET, LIMM, SIMM9_8, BRAKETdup }, { C_DI26, C_AA27 }},
{ "std", 0x1E007007, 0xFF007007, ARC_OPCODE_ARC32, STORE, NONE, { W6, BRAKET, LIMM, SIMM9_8, BRAKETdup }, { C_DI26, C_AA27 }},
{ "std", 0x1E007F86, 0xFF007FC7, ARC_OPCODE_ARC32, STORE, NONE, { LIMM, BRAKET, LIMMdup, SIMM9_8, BRAKETdup }, { C_DI26, C_AA27 }},

/* sth_sZZ_H c,b,u6 10110bbbcccuuuuu.  */
{ "sth_s", 0x0000B000, 0x0000F800,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, STORE, NONE, { RC_S, BRAKET, RB_S, UIMM6_A16_11_S, BRAKETdup }, { C_ZZ_H }},

/* st_s b,SP,u7 11000bbb010uuuuu.  */
{ "st_s", 0x0000C040, 0x0000F8E0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, STORE, NONE, { RB_S, BRAKET, SP_S, UIMM7_A32_11_S, BRAKETdup }, { 0 }},

/* st_s c,b,u7 10100bbbcccuuuuu.  */
{ "st_s", 0x0000A000, 0x0000F800,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, STORE, NONE, { RC_S, BRAKET, RB_S, UIMM7_A32_11_S, BRAKETdup }, { 0 }},

/* st_s R0,GP,s11 01010SSSSSS10sss.  */
{ "st_s", 0x00005010, 0x0000F818,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, STORE, CD2, { R0_S, BRAKET, GP_S, SIMM11_A32_13_S, BRAKETdup }, { 0 }},

/* sub<.f> a,b,c 00100bbb00000010FBBBCCCCCCAAAAAA.  */
{ "sub", 0x20020000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, RB, RC }, { C_F }},

/* sub<.f> 0,b,c 00100bbb00000010FBBBCCCCCC111110.  */
{ "sub", 0x2002003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, RB, RC }, { C_F }},

/* sub<.f><.cc> b,b,c 00100bbb11000010FBBBCCCCCC0QQQQQ.  */
{ "sub", 0x20C20000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* sub<.f> a,b,u6 00100bbb01000010FBBBuuuuuuAAAAAA.  */
{ "sub", 0x20420000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* sub<.f> 0,b,u6 00100bbb01000010FBBBuuuuuu111110.  */
{ "sub", 0x2042003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* sub<.f><.cc> b,b,u6 00100bbb11000010FBBBuuuuuu1QQQQQ.  */
{ "sub", 0x20C20020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* sub<.f> b,b,s12 00100bbb10000010FBBBssssssSSSSSS.  */
{ "sub", 0x20820000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* sub<.f> a,limm,c 0010011000000010F111CCCCCCAAAAAA.  */
{ "sub", 0x26027000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, LIMM, RC }, { C_F }},

/* sub<.f> a,b,limm 00100bbb00000010FBBB111110AAAAAA.  */
{ "sub", 0x20020F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, RB, LIMM }, { C_F }},

/* sub<.f> 0,limm,c 0010011000000010F111CCCCCC111110.  */
{ "sub", 0x2602703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, RC }, { C_F }},

/* sub<.f> 0,b,limm 00100bbb00000010FBBB111110111110.  */
{ "sub", 0x20020FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, RB, LIMM }, { C_F }},

/* sub<.f><.cc> b,b,limm 00100bbb11000010FBBB1111100QQQQQ.  */
{ "sub", 0x20C20F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* sub<.f><.cc> 0,limm,c 0010011011000010F111CCCCCC0QQQQQ.  */
{ "sub", 0x26C27000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* sub<.f> a,limm,u6 0010011001000010F111uuuuuuAAAAAA.  */
{ "sub", 0x26427000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* sub<.f> 0,limm,u6 0010011001000010F111uuuuuu111110.  */
{ "sub", 0x2642703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* sub<.f><.cc> 0,limm,u6 0010011011000010F111uuuuuu1QQQQQ.  */
{ "sub", 0x26C27020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* sub<.f> 0,limm,s12 0010011010000010F111ssssssSSSSSS.  */
{ "sub", 0x26827000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* sub<.f> a,limm,limm 0010011000000010F111111110AAAAAA.  */
{ "sub", 0x26027F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* sub<.f> 0,limm,limm 0010011000000010F111111110111110.  */
{ "sub", 0x26027FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* sub<.f><.cc> 0,limm,limm 0010011011000010F1111111100QQQQQ.  */
{ "sub", 0x26C27F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* sub1<.f> a,b,c 00100bbb00010111FBBBCCCCCCAAAAAA.  */
{ "sub1", 0x20170000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, RB, RC }, { C_F }},

/* sub1<.f> 0,b,c 00100bbb00010111FBBBCCCCCC111110.  */
{ "sub1", 0x2017003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, RB, RC }, { C_F }},

/* sub1<.f><.cc> b,b,c 00100bbb11010111FBBBCCCCCC0QQQQQ.  */
{ "sub1", 0x20D70000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* sub1<.f> a,b,u6 00100bbb01010111FBBBuuuuuuAAAAAA.  */
{ "sub1", 0x20570000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* sub1<.f> 0,b,u6 00100bbb01010111FBBBuuuuuu111110.  */
{ "sub1", 0x2057003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* sub1<.f><.cc> b,b,u6 00100bbb11010111FBBBuuuuuu1QQQQQ.  */
{ "sub1", 0x20D70020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* sub1<.f> b,b,s12 00100bbb10010111FBBBssssssSSSSSS.  */
{ "sub1", 0x20970000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* sub1<.f> a,limm,c 0010011000010111F111CCCCCCAAAAAA.  */
{ "sub1", 0x26177000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, LIMM, RC }, { C_F }},

/* sub1<.f> a,b,limm 00100bbb00010111FBBB111110AAAAAA.  */
{ "sub1", 0x20170F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, RB, LIMM }, { C_F }},

/* sub1<.f> 0,limm,c 0010011000010111F111CCCCCC111110.  */
{ "sub1", 0x2617703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, RC }, { C_F }},

/* sub1<.f> 0,b,limm 00100bbb00010111FBBB111110111110.  */
{ "sub1", 0x20170FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, RB, LIMM }, { C_F }},

/* sub1<.f><.cc> b,b,limm 00100bbb11010111FBBB1111100QQQQQ.  */
{ "sub1", 0x20D70F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* sub1<.f><.cc> 0,limm,c 0010011011010111F111CCCCCC0QQQQQ.  */
{ "sub1", 0x26D77000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* sub1<.f> a,limm,u6 0010011001010111F111uuuuuuAAAAAA.  */
{ "sub1", 0x26577000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* sub1<.f> 0,limm,u6 0010011001010111F111uuuuuu111110.  */
{ "sub1", 0x2657703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* sub1<.f><.cc> 0,limm,u6 0010011011010111F111uuuuuu1QQQQQ.  */
{ "sub1", 0x26D77020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* sub1<.f> 0,limm,s12 0010011010010111F111ssssssSSSSSS.  */
{ "sub1", 0x26977000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* sub1<.f> a,limm,limm 0010011000010111F111111110AAAAAA.  */
{ "sub1", 0x26177F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* sub1<.f> 0,limm,limm 0010011000010111F111111110111110.  */
{ "sub1", 0x26177FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* sub1<.f><.cc> 0,limm,limm 0010011011010111F1111111100QQQQQ.  */
{ "sub1", 0x26D77F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* sub1l<.f> RA,RB,RC 01011bbb00010111FBBBccccccaaaaaa.  */
{ "sub1l", 0x58170000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* sub1l<.f> 0,RB,RC 01011bbb00010111FBBBcccccc111110.  */
{ "sub1l", 0x5817003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* sub1l<.f><.cc> RB,RB,RC 01011bbb11010111FBBBcccccc0QQQQQ.  */
{ "sub1l", 0x58D70000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* sub1l<.f> RA,RB,u6 01011bbb01010111FBBBuuuuuuaaaaaa.  */
{ "sub1l", 0x58570000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* sub1l<.f> 0,RB,u6 01011bbb01010111FBBBuuuuuu111110.  */
{ "sub1l", 0x5857003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* sub1l<.f><.cc> RB,RB,u6 01011bbb11010111FBBBuuuuuu1QQQQQ.  */
{ "sub1l", 0x58D70020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* sub1l<.f> RB,RB,s12 01011bbb10010111FBBBssssssSSSSSS.  */
{ "sub1l", 0x58970000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* sub1l<.f> RA,ximm,RC 0101110000010111F111ccccccaaaaaa.  */
{ "sub1l", 0x5C177000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* sub1l<.f> RA,RB,ximm 01011bbb00010111FBBB111100aaaaaa.  */
{ "sub1l", 0x58170F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* sub1l<.f> 0,ximm,RC 0101110000010111F111cccccc111110.  */
{ "sub1l", 0x5C17703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* sub1l<.f> 0,RB,ximm 01011bbb00010111FBBB111100111110.  */
{ "sub1l", 0x58170F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* sub1l<.f><.cc> 0,ximm,RC 0101110011010111F111cccccc0QQQQQ.  */
{ "sub1l", 0x5CD77000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* sub1l<.f><.cc> RB,RB,ximm 01011bbb11010111FBBB1111000QQQQQ.  */
{ "sub1l", 0x58D70F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* sub1l<.f> RA,ximm,u6 0101110001010111F111uuuuuuaaaaaa.  */
{ "sub1l", 0x5C577000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* sub1l<.f> 0,ximm,u6 0101110001010111F111uuuuuu111110.  */
{ "sub1l", 0x5C57703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* sub1l<.f><.cc> 0,ximm,u6 0101110011010111F111uuuuuu1QQQQQ.  */
{ "sub1l", 0x5CD77020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* sub1l<.f> RA,limm,RC 0101111000010111F111ccccccaaaaaa.  */
{ "sub1l", 0x5E177000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* sub1l<.f> RA,RB,limm 01011bbb00010111FBBB111110aaaaaa.  */
{ "sub1l", 0x58170F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* sub1l<.f> 0,limm,RC 0101111000010111F111cccccc111110.  */
{ "sub1l", 0x5E17703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* sub1l<.f> 0,RB,limm 01011bbb00010111FBBB111110111110.  */
{ "sub1l", 0x58170FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* sub1l<.f><.cc> 0,limm,RC 0101111011010111F111cccccc0QQQQQ.  */
{ "sub1l", 0x5ED77000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* sub1l<.f><.cc> RB,RB,limm 01011bbb11010111FBBB1111100QQQQQ.  */
{ "sub1l", 0x58D70F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* sub1l<.f> RA,limm,u6 0101111001010111F111uuuuuuaaaaaa.  */
{ "sub1l", 0x5E577000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* sub1l<.f> 0,limm,u6 0101111001010111F111uuuuuu111110.  */
{ "sub1l", 0x5E57703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* sub1l<.f><.cc> 0,limm,u6 0101111011010111F111uuuuuu1QQQQQ.  */
{ "sub1l", 0x5ED77020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* sub1l<.f> 0,ximm,s12 0101110010010111F111ssssssSSSSSS.  */
{ "sub1l", 0x5C977000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* sub1l<.f> 0,limm,s12 0101111010010111F111ssssssSSSSSS.  */
{ "sub1l", 0x5E977000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* sub1l<.f> RA,ximm,ximm 0101110000010111F111111100aaaaaa.  */
{ "sub1l", 0x5C177F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* sub1l<.f> 0,ximm,ximm 0101110000010111F111111100111110.  */
{ "sub1l", 0x5C177F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* sub1l<.f><.cc> 0,ximm,ximm 0101110011010111F1111111000QQQQQ.  */
{ "sub1l", 0x5CD77F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* sub1l<.f> RA,limm,limm 0101111000010111F111111110aaaaaa.  */
{ "sub1l", 0x5E177F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* sub1l<.f> 0,limm,limm 0101111000010111F111111110111110.  */
{ "sub1l", 0x5E177FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* sub1l<.f><.cc> 0,limm,limm 0101111011010111F1111111100QQQQQ.  */
{ "sub1l", 0x5ED77F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* sub2<.f> a,b,c 00100bbb00011000FBBBCCCCCCAAAAAA.  */
{ "sub2", 0x20180000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, RB, RC }, { C_F }},

/* sub2<.f> 0,b,c 00100bbb00011000FBBBCCCCCC111110.  */
{ "sub2", 0x2018003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, RB, RC }, { C_F }},

/* sub2<.f><.cc> b,b,c 00100bbb11011000FBBBCCCCCC0QQQQQ.  */
{ "sub2", 0x20D80000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* sub2<.f> a,b,u6 00100bbb01011000FBBBuuuuuuAAAAAA.  */
{ "sub2", 0x20580000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* sub2<.f> 0,b,u6 00100bbb01011000FBBBuuuuuu111110.  */
{ "sub2", 0x2058003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* sub2<.f><.cc> b,b,u6 00100bbb11011000FBBBuuuuuu1QQQQQ.  */
{ "sub2", 0x20D80020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* sub2<.f> b,b,s12 00100bbb10011000FBBBssssssSSSSSS.  */
{ "sub2", 0x20980000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* sub2<.f> a,limm,c 0010011000011000F111CCCCCCAAAAAA.  */
{ "sub2", 0x26187000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, LIMM, RC }, { C_F }},

/* sub2<.f> a,b,limm 00100bbb00011000FBBB111110AAAAAA.  */
{ "sub2", 0x20180F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, RB, LIMM }, { C_F }},

/* sub2<.f> 0,limm,c 0010011000011000F111CCCCCC111110.  */
{ "sub2", 0x2618703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, RC }, { C_F }},

/* sub2<.f> 0,b,limm 00100bbb00011000FBBB111110111110.  */
{ "sub2", 0x20180FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, RB, LIMM }, { C_F }},

/* sub2<.f><.cc> b,b,limm 00100bbb11011000FBBB1111100QQQQQ.  */
{ "sub2", 0x20D80F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* sub2<.f><.cc> 0,limm,c 0010011011011000F111CCCCCC0QQQQQ.  */
{ "sub2", 0x26D87000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* sub2<.f> a,limm,u6 0010011001011000F111uuuuuuAAAAAA.  */
{ "sub2", 0x26587000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* sub2<.f> 0,limm,u6 0010011001011000F111uuuuuu111110.  */
{ "sub2", 0x2658703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* sub2<.f><.cc> 0,limm,u6 0010011011011000F111uuuuuu1QQQQQ.  */
{ "sub2", 0x26D87020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* sub2<.f> 0,limm,s12 0010011010011000F111ssssssSSSSSS.  */
{ "sub2", 0x26987000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* sub2<.f> a,limm,limm 0010011000011000F111111110AAAAAA.  */
{ "sub2", 0x26187F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* sub2<.f> 0,limm,limm 0010011000011000F111111110111110.  */
{ "sub2", 0x26187FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* sub2<.f><.cc> 0,limm,limm 0010011011011000F1111111100QQQQQ.  */
{ "sub2", 0x26D87F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* sub2l<.f> RA,RB,RC 01011bbb00011000FBBBccccccaaaaaa.  */
{ "sub2l", 0x58180000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* sub2l<.f> 0,RB,RC 01011bbb00011000FBBBcccccc111110.  */
{ "sub2l", 0x5818003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* sub2l<.f><.cc> RB,RB,RC 01011bbb11011000FBBBcccccc0QQQQQ.  */
{ "sub2l", 0x58D80000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* sub2l<.f> RA,RB,u6 01011bbb01011000FBBBuuuuuuaaaaaa.  */
{ "sub2l", 0x58580000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* sub2l<.f> 0,RB,u6 01011bbb01011000FBBBuuuuuu111110.  */
{ "sub2l", 0x5858003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* sub2l<.f><.cc> RB,RB,u6 01011bbb11011000FBBBuuuuuu1QQQQQ.  */
{ "sub2l", 0x58D80020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* sub2l<.f> RB,RB,s12 01011bbb10011000FBBBssssssSSSSSS.  */
{ "sub2l", 0x58980000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* sub2l<.f> RA,ximm,RC 0101110000011000F111ccccccaaaaaa.  */
{ "sub2l", 0x5C187000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* sub2l<.f> RA,RB,ximm 01011bbb00011000FBBB111100aaaaaa.  */
{ "sub2l", 0x58180F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* sub2l<.f> 0,ximm,RC 0101110000011000F111cccccc111110.  */
{ "sub2l", 0x5C18703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* sub2l<.f> 0,RB,ximm 01011bbb00011000FBBB111100111110.  */
{ "sub2l", 0x58180F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* sub2l<.f><.cc> 0,ximm,RC 0101110011011000F111cccccc0QQQQQ.  */
{ "sub2l", 0x5CD87000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* sub2l<.f><.cc> RB,RB,ximm 01011bbb11011000FBBB1111000QQQQQ.  */
{ "sub2l", 0x58D80F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* sub2l<.f> RA,ximm,u6 0101110001011000F111uuuuuuaaaaaa.  */
{ "sub2l", 0x5C587000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* sub2l<.f> 0,ximm,u6 0101110001011000F111uuuuuu111110.  */
{ "sub2l", 0x5C58703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* sub2l<.f><.cc> 0,ximm,u6 0101110011011000F111uuuuuu1QQQQQ.  */
{ "sub2l", 0x5CD87020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* sub2l<.f> RA,limm,RC 0101111000011000F111ccccccaaaaaa.  */
{ "sub2l", 0x5E187000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* sub2l<.f> RA,RB,limm 01011bbb00011000FBBB111110aaaaaa.  */
{ "sub2l", 0x58180F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* sub2l<.f> 0,limm,RC 0101111000011000F111cccccc111110.  */
{ "sub2l", 0x5E18703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* sub2l<.f> 0,RB,limm 01011bbb00011000FBBB111110111110.  */
{ "sub2l", 0x58180FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* sub2l<.f><.cc> 0,limm,RC 0101111011011000F111cccccc0QQQQQ.  */
{ "sub2l", 0x5ED87000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* sub2l<.f><.cc> RB,RB,limm 01011bbb11011000FBBB1111100QQQQQ.  */
{ "sub2l", 0x58D80F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* sub2l<.f> RA,limm,u6 0101111001011000F111uuuuuuaaaaaa.  */
{ "sub2l", 0x5E587000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* sub2l<.f> 0,limm,u6 0101111001011000F111uuuuuu111110.  */
{ "sub2l", 0x5E58703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* sub2l<.f><.cc> 0,limm,u6 0101111011011000F111uuuuuu1QQQQQ.  */
{ "sub2l", 0x5ED87020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* sub2l<.f> 0,ximm,s12 0101110010011000F111ssssssSSSSSS.  */
{ "sub2l", 0x5C987000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* sub2l<.f> 0,limm,s12 0101111010011000F111ssssssSSSSSS.  */
{ "sub2l", 0x5E987000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* sub2l<.f> RA,ximm,ximm 0101110000011000F111111100aaaaaa.  */
{ "sub2l", 0x5C187F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* sub2l<.f> 0,ximm,ximm 0101110000011000F111111100111110.  */
{ "sub2l", 0x5C187F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* sub2l<.f><.cc> 0,ximm,ximm 0101110011011000F1111111000QQQQQ.  */
{ "sub2l", 0x5CD87F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* sub2l<.f> RA,limm,limm 0101111000011000F111111110aaaaaa.  */
{ "sub2l", 0x5E187F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* sub2l<.f> 0,limm,limm 0101111000011000F111111110111110.  */
{ "sub2l", 0x5E187FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* sub2l<.f><.cc> 0,limm,limm 0101111011011000F1111111100QQQQQ.  */
{ "sub2l", 0x5ED87F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* sub3<.f> a,b,c 00100bbb00011001FBBBCCCCCCAAAAAA.  */
{ "sub3", 0x20190000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, RB, RC }, { C_F }},

/* sub3<.f> 0,b,c 00100bbb00011001FBBBCCCCCC111110.  */
{ "sub3", 0x2019003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, RB, RC }, { C_F }},

/* sub3<.f><.cc> b,b,c 00100bbb11011001FBBBCCCCCC0QQQQQ.  */
{ "sub3", 0x20D90000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* sub3<.f> a,b,u6 00100bbb01011001FBBBuuuuuuAAAAAA.  */
{ "sub3", 0x20590000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* sub3<.f> 0,b,u6 00100bbb01011001FBBBuuuuuu111110.  */
{ "sub3", 0x2059003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* sub3<.f><.cc> b,b,u6 00100bbb11011001FBBBuuuuuu1QQQQQ.  */
{ "sub3", 0x20D90020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* sub3<.f> b,b,s12 00100bbb10011001FBBBssssssSSSSSS.  */
{ "sub3", 0x20990000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* sub3<.f> a,limm,c 0010011000011001F111CCCCCCAAAAAA.  */
{ "sub3", 0x26197000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, LIMM, RC }, { C_F }},

/* sub3<.f> a,b,limm 00100bbb00011001FBBB111110AAAAAA.  */
{ "sub3", 0x20190F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, RB, LIMM }, { C_F }},

/* sub3<.f> 0,limm,c 0010011000011001F111CCCCCC111110.  */
{ "sub3", 0x2619703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, RC }, { C_F }},

/* sub3<.f> 0,b,limm 00100bbb00011001FBBB111110111110.  */
{ "sub3", 0x20190FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, RB, LIMM }, { C_F }},

/* sub3<.f><.cc> b,b,limm 00100bbb11011001FBBB1111100QQQQQ.  */
{ "sub3", 0x20D90F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* sub3<.f><.cc> 0,limm,c 0010011011011001F111CCCCCC0QQQQQ.  */
{ "sub3", 0x26D97000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* sub3<.f> a,limm,u6 0010011001011001F111uuuuuuAAAAAA.  */
{ "sub3", 0x26597000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* sub3<.f> 0,limm,u6 0010011001011001F111uuuuuu111110.  */
{ "sub3", 0x2659703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* sub3<.f><.cc> 0,limm,u6 0010011011011001F111uuuuuu1QQQQQ.  */
{ "sub3", 0x26D97020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* sub3<.f> 0,limm,s12 0010011010011001F111ssssssSSSSSS.  */
{ "sub3", 0x26997000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* sub3<.f> a,limm,limm 0010011000011001F111111110AAAAAA.  */
{ "sub3", 0x26197F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* sub3<.f> 0,limm,limm 0010011000011001F111111110111110.  */
{ "sub3", 0x26197FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* sub3<.f><.cc> 0,limm,limm 0010011011011001F1111111100QQQQQ.  */
{ "sub3", 0x26D97F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* sub3l<.f> RA,RB,RC 01011bbb00011001FBBBccccccaaaaaa.  */
{ "sub3l", 0x58190000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* sub3l<.f> 0,RB,RC 01011bbb00011001FBBBcccccc111110.  */
{ "sub3l", 0x5819003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* sub3l<.f><.cc> RB,RB,RC 01011bbb11011001FBBBcccccc0QQQQQ.  */
{ "sub3l", 0x58D90000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* sub3l<.f> RA,RB,u6 01011bbb01011001FBBBuuuuuuaaaaaa.  */
{ "sub3l", 0x58590000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* sub3l<.f> 0,RB,u6 01011bbb01011001FBBBuuuuuu111110.  */
{ "sub3l", 0x5859003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* sub3l<.f><.cc> RB,RB,u6 01011bbb11011001FBBBuuuuuu1QQQQQ.  */
{ "sub3l", 0x58D90020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* sub3l<.f> RB,RB,s12 01011bbb10011001FBBBssssssSSSSSS.  */
{ "sub3l", 0x58990000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* sub3l<.f> RA,ximm,RC 0101110000011001F111ccccccaaaaaa.  */
{ "sub3l", 0x5C197000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* sub3l<.f> RA,RB,ximm 01011bbb00011001FBBB111100aaaaaa.  */
{ "sub3l", 0x58190F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* sub3l<.f> 0,ximm,RC 0101110000011001F111cccccc111110.  */
{ "sub3l", 0x5C19703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* sub3l<.f> 0,RB,ximm 01011bbb00011001FBBB111100111110.  */
{ "sub3l", 0x58190F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* sub3l<.f><.cc> 0,ximm,RC 0101110011011001F111cccccc0QQQQQ.  */
{ "sub3l", 0x5CD97000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* sub3l<.f><.cc> RB,RB,ximm 01011bbb11011001FBBB1111000QQQQQ.  */
{ "sub3l", 0x58D90F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* sub3l<.f> RA,ximm,u6 0101110001011001F111uuuuuuaaaaaa.  */
{ "sub3l", 0x5C597000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* sub3l<.f> 0,ximm,u6 0101110001011001F111uuuuuu111110.  */
{ "sub3l", 0x5C59703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* sub3l<.f><.cc> 0,ximm,u6 0101110011011001F111uuuuuu1QQQQQ.  */
{ "sub3l", 0x5CD97020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* sub3l<.f> RA,limm,RC 0101111000011001F111ccccccaaaaaa.  */
{ "sub3l", 0x5E197000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* sub3l<.f> RA,RB,limm 01011bbb00011001FBBB111110aaaaaa.  */
{ "sub3l", 0x58190F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* sub3l<.f> 0,limm,RC 0101111000011001F111cccccc111110.  */
{ "sub3l", 0x5E19703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* sub3l<.f> 0,RB,limm 01011bbb00011001FBBB111110111110.  */
{ "sub3l", 0x58190FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* sub3l<.f><.cc> 0,limm,RC 0101111011011001F111cccccc0QQQQQ.  */
{ "sub3l", 0x5ED97000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* sub3l<.f><.cc> RB,RB,limm 01011bbb11011001FBBB1111100QQQQQ.  */
{ "sub3l", 0x58D90F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* sub3l<.f> RA,limm,u6 0101111001011001F111uuuuuuaaaaaa.  */
{ "sub3l", 0x5E597000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* sub3l<.f> 0,limm,u6 0101111001011001F111uuuuuu111110.  */
{ "sub3l", 0x5E59703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* sub3l<.f><.cc> 0,limm,u6 0101111011011001F111uuuuuu1QQQQQ.  */
{ "sub3l", 0x5ED97020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* sub3l<.f> 0,ximm,s12 0101110010011001F111ssssssSSSSSS.  */
{ "sub3l", 0x5C997000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* sub3l<.f> 0,limm,s12 0101111010011001F111ssssssSSSSSS.  */
{ "sub3l", 0x5E997000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* sub3l<.f> RA,ximm,ximm 0101110000011001F111111100aaaaaa.  */
{ "sub3l", 0x5C197F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* sub3l<.f> 0,ximm,ximm 0101110000011001F111111100111110.  */
{ "sub3l", 0x5C197F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* sub3l<.f><.cc> 0,ximm,ximm 0101110011011001F1111111000QQQQQ.  */
{ "sub3l", 0x5CD97F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* sub3l<.f> RA,limm,limm 0101111000011001F111111110aaaaaa.  */
{ "sub3l", 0x5E197F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* sub3l<.f> 0,limm,limm 0101111000011001F111111110111110.  */
{ "sub3l", 0x5E197FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* sub3l<.f><.cc> 0,limm,limm 0101111011011001F1111111100QQQQQ.  */
{ "sub3l", 0x5ED97F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* subl<.f> RA,RB,RC 01011bbb00000010FBBBccccccaaaaaa.  */
{ "subl", 0x58020000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* subl<.f> 0,RB,RC 01011bbb00000010FBBBcccccc111110.  */
{ "subl", 0x5802003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* subl<.f><.cc> RB,RB,RC 01011bbb11000010FBBBcccccc0QQQQQ.  */
{ "subl", 0x58C20000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* subl<.f> RA,RB,u6 01011bbb01000010FBBBuuuuuuaaaaaa.  */
{ "subl", 0x58420000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* subl<.f> 0,RB,u6 01011bbb01000010FBBBuuuuuu111110.  */
{ "subl", 0x5842003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* subl<.f><.cc> RB,RB,u6 01011bbb11000010FBBBuuuuuu1QQQQQ.  */
{ "subl", 0x58C20020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* subl<.f> RB,RB,s12 01011bbb10000010FBBBssssssSSSSSS.  */
{ "subl", 0x58820000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* subl<.f> RA,ximm,RC 0101110000000010F111ccccccaaaaaa.  */
{ "subl", 0x5C027000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* subl<.f> RA,RB,ximm 01011bbb00000010FBBB111100aaaaaa.  */
{ "subl", 0x58020F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* subl<.f> 0,ximm,RC 0101110000000010F111cccccc111110.  */
{ "subl", 0x5C02703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* subl<.f> 0,RB,ximm 01011bbb00000010FBBB111100111110.  */
{ "subl", 0x58020F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* subl<.f><.cc> 0,ximm,RC 0101110011000010F111cccccc0QQQQQ.  */
{ "subl", 0x5CC27000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* subl<.f><.cc> RB,RB,ximm 01011bbb11000010FBBB1111000QQQQQ.  */
{ "subl", 0x58C20F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* subl<.f> RA,ximm,u6 0101110001000010F111uuuuuuaaaaaa.  */
{ "subl", 0x5C427000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* subl<.f> 0,ximm,u6 0101110001000010F111uuuuuu111110.  */
{ "subl", 0x5C42703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* subl<.f><.cc> 0,ximm,u6 0101110011000010F111uuuuuu1QQQQQ.  */
{ "subl", 0x5CC27020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* subl<.f> RA,limm,RC 0101111000000010F111ccccccaaaaaa.  */
{ "subl", 0x5E027000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* subl<.f> RA,RB,limm 01011bbb00000010FBBB111110aaaaaa.  */
{ "subl", 0x58020F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* subl<.f> 0,limm,RC 0101111000000010F111cccccc111110.  */
{ "subl", 0x5E02703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* subl<.f> 0,RB,limm 01011bbb00000010FBBB111110111110.  */
{ "subl", 0x58020FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* subl<.f><.cc> 0,limm,RC 0101111011000010F111cccccc0QQQQQ.  */
{ "subl", 0x5EC27000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* subl<.f><.cc> RB,RB,limm 01011bbb11000010FBBB1111100QQQQQ.  */
{ "subl", 0x58C20F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* subl<.f> RA,limm,u6 0101111001000010F111uuuuuuaaaaaa.  */
{ "subl", 0x5E427000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* subl<.f> 0,limm,u6 0101111001000010F111uuuuuu111110.  */
{ "subl", 0x5E42703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* subl<.f><.cc> 0,limm,u6 0101111011000010F111uuuuuu1QQQQQ.  */
{ "subl", 0x5EC27020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* subl<.f> 0,ximm,s12 0101110010000010F111ssssssSSSSSS.  */
{ "subl", 0x5C827000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* subl<.f> 0,limm,s12 0101111010000010F111ssssssSSSSSS.  */
{ "subl", 0x5E827000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* subl<.f> RA,ximm,ximm 0101110000000010F111111100aaaaaa.  */
{ "subl", 0x5C027F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* subl<.f> 0,ximm,ximm 0101110000000010F111111100111110.  */
{ "subl", 0x5C027F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* subl<.f><.cc> 0,ximm,ximm 0101110011000010F1111111000QQQQQ.  */
{ "subl", 0x5CC27F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* subl<.f> RA,limm,limm 0101111000000010F111111110aaaaaa.  */
{ "subl", 0x5E027F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* subl<.f> 0,limm,limm 0101111000000010F111111110111110.  */
{ "subl", 0x5E027FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* subl<.f><.cc> 0,limm,limm 0101111011000010F1111111100QQQQQ.  */
{ "subl", 0x5EC27F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* subl_s SP,SP,u9 11000UU1101uuuuu.  */
{ "subl_s", 0x0000C1A0, 0x0000F9E0, ARC_OPCODE_ARC64, ARITH, NONE, { SP_S, SP_Sdup, UIMM9_A32_11_S }, { 0 }},

/* subl_s b,b,c 01111bbbccc00011.  */
{ "subl_s", 0x00007803, 0x0000F81F, ARC_OPCODE_ARC64, ARITH, NONE, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* sub_s.NE b,b,b 01111bbb11000000.  */
{ "sub_s", 0x000078C0, 0x0000F8FF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RB_S, RB_Sdup, RB_Sdup }, { C_NE }},

/* sub_s b,b,c 01111bbbccc00010.  */
{ "sub_s", 0x00007802, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RB_S, RB_Sdup, RC_S }, { 0 }},

/* sub_s a,b,c 01001bbbccc10aaa.  */
{ "sub_s", 0x00004810, 0x0000F818,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, CD2, { RA_S, RB_S, RC_S }, { 0 }},

/* sub_s b,b,u5 10111bbb011uuuuu.  */
{ "sub_s", 0x0000B860, 0x0000F8E0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, SUB, NONE, { RB_S, RB_Sdup, UIMM5_11_S }, { 0 }},

/* swap<.f> b,c 00101bbb00101111FBBBCCCCCC000000.  */
{ "swap", 0x282F0000, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { RB, RC }, { C_F }},

/* swap<.f> 0,c 0010111000101111F111CCCCCC000000.  */
{ "swap", 0x2E2F7000, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { ZA, RC }, { C_F }},

/* swap<.f> b,u6 00101bbb01101111FBBBuuuuuu000000.  */
{ "swap", 0x286F0000, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { RB, UIMM6_20 }, { C_F }},

/* swap<.f> 0,u6 0010111001101111F111uuuuuu000000.  */
{ "swap", 0x2E6F7000, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { ZA, UIMM6_20 }, { C_F }},

/* swap<.f> b,limm 00101bbb00101111FBBB111110000000.  */
{ "swap", 0x282F0F80, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { RB, LIMM }, { C_F }},

/* swap<.f> 0,limm 0010111000101111F111111110000000.  */
{ "swap", 0x2E2F7F80, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { ZA, LIMM }, { C_F }},

/* swape<.f> b,c 00101bbb00101111FBBBCCCCCC001001.  */
{ "swape", 0x282F0009, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { RB, RC }, { C_F }},

/* swape<.f> 0,c 0010111000101111F111CCCCCC001001.  */
{ "swape", 0x2E2F7009, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { ZA, RC }, { C_F }},

/* swape<.f> b,u6 00101bbb01101111FBBBuuuuuu001001.  */
{ "swape", 0x286F0009, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { RB, UIMM6_20 }, { C_F }},

/* swape<.f> 0,u6 0010111001101111F111uuuuuu001001.  */
{ "swape", 0x2E6F7009, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { ZA, UIMM6_20 }, { C_F }},

/* swape<.f> b,limm 00101bbb00101111FBBB111110001001.  */
{ "swape", 0x282F0F89, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { RB, LIMM }, { C_F }},

/* swape<.f> 0,limm 0010111000101111F111111110001001.  */
{ "swape", 0x2E2F7F89, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SWAP, { ZA, LIMM }, { C_F }},

/* swapel<.f> RB,RC 01011bbb00101111FBBBcccccc101001.  */
{ "swapel", 0x582F0029, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* swapel<.f> 0,RC 0101111000101111F111cccccc101001.  */
{ "swapel", 0x5E2F7029, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RC }, { C_F }},

/* swapel<.f> RB,u6 01011bbb01101111FBBBuuuuuu101001.  */
{ "swapel", 0x586F0029, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* swapel<.f> 0,u6 0101111001101111F111uuuuuu101001.  */
{ "swapel", 0x5E6F7029, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* swapel<.f> RB,ximm 01011bbb00101111FBBB111100101001.  */
{ "swapel", 0x582F0F29, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { C_F }},

/* swapel<.f> 0,ximm 0101111000101111F111111100101001.  */
{ "swapel", 0x5E2F7F29, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM }, { C_F }},

/* swapel<.f> RB,limm 01011bbb00101111FBBB111110101001.  */
{ "swapel", 0x582F0FA9, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* swapel<.f> 0,limm 0101111000101111F111111110101001.  */
{ "swapel", 0x5E2F7FA9, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* swapl<.f> RB,RC 01011bbb00101111FBBBcccccc100000.  */
{ "swapl", 0x582F0020, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_F }},

/* swapl<.f> 0,RC 0101111000101111F111cccccc100000.  */
{ "swapl", 0x5E2F7020, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RC }, { C_F }},

/* swapl<.f> RB,u6 01011bbb01101111FBBBuuuuuu100000.  */
{ "swapl", 0x586F0020, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_F }},

/* swapl<.f> 0,u6 0101111001101111F111uuuuuu100000.  */
{ "swapl", 0x5E6F7020, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, UIMM6_20 }, { C_F }},

/* swapl<.f> RB,ximm 01011bbb00101111FBBB111100100000.  */
{ "swapl", 0x582F0F20, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { C_F }},

/* swapl<.f> 0,ximm 0101111000101111F111111100100000.  */
{ "swapl", 0x5E2F7F20, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM }, { C_F }},

/* swapl<.f> RB,limm 01011bbb00101111FBBB111110100000.  */
{ "swapl", 0x582F0FA0, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_F }},

/* swapl<.f> 0,limm 0101111000101111F111111110100000.  */
{ "swapl", 0x5E2F7FA0, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM }, { C_F }},

/* swi  00100010011011110000000000111111.  */
{ "swi", 0x226F003F, 0xFFFFFFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, KERNEL, NONE, { 0 }, { 0 }},

/* swi_s  0111101011100000.  */
{ "swi_s", 0x00007AE0, 0x0000FFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, KERNEL, NONE, { 0 }, { 0 }},

/* swi_s u6 01111uuuuuu11111.  */
{ "swi_s", 0x0000781F, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, KERNEL, NONE, { UIMM6_5_S }, { 0 }},

/* sync  00100011011011110000000000111111.  */
{ "sync", 0x236F003F, 0xFFFFFFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, CONTROL, NONE, { 0 }, { 0 }},

/* trap_s u6 01111uuuuuu11110.  */
{ "trap_s", 0x0000781E, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, KERNEL, NONE, { UIMM6_5_S }, { 0 }},

/* tst b,c 00100bbb000010111BBBCCCCCCRRRRRR.  */
{ "tst", 0x200B8000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RC }, { 0 }},

/* tst<.cc> b,c 00100bbb110010111BBBCCCCCC0QQQQQ.  */
{ "tst", 0x20CB8000, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RC }, { C_CC }},

/* tst b,u6 00100bbb010010111BBBuuuuuuRRRRRR.  */
{ "tst", 0x204B8000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, UIMM6_20 }, { 0 }},

/* tst<.cc> b,u6 00100bbb110010111BBBuuuuuu1QQQQQ.  */
{ "tst", 0x20CB8020, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, UIMM6_20 }, { C_CC }},

/* tst b,s12 00100bbb100010111BBBssssssSSSSSS.  */
{ "tst", 0x208B8000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, SIMM12_20 }, { 0 }},

/* tst limm,c 00100110000010111111CCCCCCRRRRRR.  */
{ "tst", 0x260BF000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { LIMM, RC }, { 0 }},

/* tst b,limm 00100bbb000010111BBB111110RRRRRR.  */
{ "tst", 0x200B8F80, 0xF8FF8FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, LIMM }, { 0 }},

/* tst<.cc> b,limm 00100bbb110010111BBB1111100QQQQQ.  */
{ "tst", 0x20CB8F80, 0xF8FF8FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, LIMM }, { C_CC }},

/* tst<.cc> limm,c 00100110110010111111CCCCCC0QQQQQ.  */
{ "tst", 0x26CBF000, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { LIMM, RC }, { C_CC }},

/* tst limm,u6 00100110010010111111uuuuuuRRRRRR.  */
{ "tst", 0x264BF000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { LIMM, UIMM6_20 }, { 0 }},

/* tst<.cc> limm,u6 00100110110010111111uuuuuu1QQQQQ.  */
{ "tst", 0x26CBF020, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { LIMM, UIMM6_20 }, { C_CC }},

/* tst limm,s12 00100110100010111111ssssssSSSSSS.  */
{ "tst", 0x268BF000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { LIMM, SIMM12_20 }, { 0 }},

/* tst limm,limm 00100110000010111111111110RRRRRR.  */
{ "tst", 0x260BFF80, 0xFFFFFFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { LIMM, LIMMdup }, { 0 }},

/* tst<.cc> limm,limm 001001101100101111111111100QQQQQ.  */
{ "tst", 0x26CBFF80, 0xFFFFFFE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { LIMM, LIMMdup }, { C_CC }},

/* tstl RB,RC 01011bbb000010111BBBccccccRRRRRR.  */
{ "tstl", 0x580B8000, 0xF8FF8000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { 0 }},

/* tstl<.cc> RB,RC 01011bbb110010111BBBcccccc0QQQQQ.  */
{ "tstl", 0x58CB8000, 0xF8FF8020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RC }, { C_CC }},

/* tstl RB,u6 01011bbb010010111BBBuuuuuuRRRRRR.  */
{ "tstl", 0x584B8000, 0xF8FF8000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { 0 }},

/* tstl<.cc> RB,u6 01011bbb110010111BBBuuuuuu1QQQQQ.  */
{ "tstl", 0x58CB8020, 0xF8FF8020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, UIMM6_20 }, { C_CC }},

/* tstl RB,s12 01011bbb100010111BBBssssssSSSSSS.  */
{ "tstl", 0x588B8000, 0xF8FF8000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, SIMM12_20 }, { 0 }},

/* tstl RB,ximm 01011bbb000010111BBB111100RRRRRR.  */
{ "tstl", 0x580B8F00, 0xF8FF8FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { 0 }},

/* tstl<.cc> RB,ximm 01011bbb110010111BBB1111000QQQQQ.  */
{ "tstl", 0x58CB8F00, 0xF8FF8FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, XIMM }, { C_CC }},

/* tstl RB,limm 01011bbb000010111BBB111110RRRRRR.  */
{ "tstl", 0x580B8F80, 0xF8FF8FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { 0 }},

/* tstl<.cc> RB,limm 01011bbb110010111BBB1111100QQQQQ.  */
{ "tstl", 0x58CB8F80, 0xF8FF8FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, LIMM }, { C_CC }},

/* tst_s b,c 01111bbbccc01011.  */
{ "tst_s", 0x0000780B, 0x0000F81F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB_S, RC_S }, { 0 }},

/* unimp_s  0111100111100000.  */
{ "unimp_s", 0x000079E0, 0x0000FFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, KERNEL, NONE, { 0 }, { 0 }},

/* vadd2 a,b,c 00101bbb001111000BBBCCCCCCAAAAAA.  */
{ "vadd2", 0x283C0000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, RC }, { 0 }},

/* vadd2 0,b,c 00101bbb001111000BBBCCCCCC111110.  */
{ "vadd2", 0x283C003E, 0xF8FF803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, RC }, { 0 }},

/* vadd2<.cc> b,b,c 00101bbb111111000BBBCCCCCC0QQQQQ.  */
{ "vadd2", 0x28FC0000, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_CC }},

/* vadd2 a,b,u6 00101bbb011111000BBBuuuuuuAAAAAA.  */
{ "vadd2", 0x287C0000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* vadd2 0,b,u6 00101bbb011111000BBBuuuuuu111110.  */
{ "vadd2", 0x287C003E, 0xF8FF803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { 0 }},

/* vadd2<.cc> b,b,u6 00101bbb111111000BBBuuuuuu1QQQQQ.  */
{ "vadd2", 0x28FC0020, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* vadd2 b,b,s12 00101bbb101111000BBBssssssSSSSSS.  */
{ "vadd2", 0x28BC0000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* vadd2 a,limm,c 00101110001111000111CCCCCCAAAAAA.  */
{ "vadd2", 0x2E3C7000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, RC }, { 0 }},

/* vadd2 a,b,limm 00101bbb001111000BBB111110AAAAAA.  */
{ "vadd2", 0x283C0F80, 0xF8FF8FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, LIMM }, { 0 }},

/* vadd2 0,limm,c 00101110001111000111CCCCCC111110.  */
{ "vadd2", 0x2E3C703E, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { 0 }},

/* vadd2 0,b,limm 00101bbb001111000BBB111110111110.  */
{ "vadd2", 0x283C0FBE, 0xF8FF8FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, LIMM }, { 0 }},

/* vadd2<.cc> b,b,limm 00101bbb111111000BBB1111100QQQQQ.  */
{ "vadd2", 0x28FC0F80, 0xF8FF8FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* vadd2<.cc> 0,limm,c 00101110111111000111CCCCCC0QQQQQ.  */
{ "vadd2", 0x2EFC7000, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_CC }},

/* vadd2 a,limm,u6 00101110011111000111uuuuuuAAAAAA.  */
{ "vadd2", 0x2E7C7000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* vadd2 0,limm,u6 00101110011111000111uuuuuu111110.  */
{ "vadd2", 0x2E7C703E, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* vadd2<.cc> 0,limm,u6 00101110111111000111uuuuuu1QQQQQ.  */
{ "vadd2", 0x2EFC7020, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* vadd2 0,limm,s12 00101110101111000111ssssssSSSSSS.  */
{ "vadd2", 0x2EBC7000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* vadd2 a,limm,limm 00101110001111000111111110AAAAAA.  */
{ "vadd2", 0x2E3C7F80, 0xFFFFFFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* vadd2 0,limm,limm 00101110001111000111111110111110.  */
{ "vadd2", 0x2E3C7FBE, 0xFFFFFFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { 0 }},

/* vadd2<.cc> 0,limm,limm 001011101111110001111111100QQQQQ.  */
{ "vadd2", 0x2EFC7F80, 0xFFFFFFE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_CC }},

/* vadd2h a,b,c 00101bbb000101000BBBCCCCCCAAAAAA.  */
{ "vadd2h", 0x28140000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, RC }, { 0 }},

/* vadd2h 0,b,c 00101bbb000101000BBBCCCCCC111110.  */
{ "vadd2h", 0x2814003E, 0xF8FF803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, RC }, { 0 }},

/* vadd2h<.cc> b,b,c 00101bbb110101000BBBCCCCCC0QQQQQ.  */
{ "vadd2h", 0x28D40000, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, RC }, { C_CC }},

/* vadd2h a,b,u6 00101bbb010101000BBBuuuuuuAAAAAA.  */
{ "vadd2h", 0x28540000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* vadd2h 0,b,u6 00101bbb010101000BBBuuuuuu111110.  */
{ "vadd2h", 0x2854003E, 0xF8FF803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, UIMM6_20 }, { 0 }},

/* vadd2h<.cc> b,b,u6 00101bbb110101000BBBuuuuuu1QQQQQ.  */
{ "vadd2h", 0x28D40020, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* vadd2h b,b,s12 00101bbb100101000BBBssssssSSSSSS.  */
{ "vadd2h", 0x28940000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* vadd2h a,limm,c 00101110000101000111CCCCCCAAAAAA.  */
{ "vadd2h", 0x2E147000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, RC }, { 0 }},

/* vadd2h a,b,limm 00101bbb000101000BBB111110AAAAAA.  */
{ "vadd2h", 0x28140F80, 0xF8FF8FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, LIMM }, { 0 }},

/* vadd2h 0,limm,c 00101110000101000111CCCCCC111110.  */
{ "vadd2h", 0x2E14703E, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, RC }, { 0 }},

/* vadd2h 0,b,limm 00101bbb000101000BBB111110111110.  */
{ "vadd2h", 0x28140FBE, 0xF8FF8FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, LIMM }, { 0 }},

/* vadd2h<.cc> b,b,limm 00101bbb110101000BBB1111100QQQQQ.  */
{ "vadd2h", 0x28D40F80, 0xF8FF8FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* vadd2h<.cc> 0,limm,c 00101110110101000111CCCCCC0QQQQQ.  */
{ "vadd2h", 0x2ED47000, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, RC }, { C_CC }},

/* vadd2h a,limm,u6 00101110010101000111uuuuuuAAAAAA.  */
{ "vadd2h", 0x2E547000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* vadd2h 0,limm,u6 00101110010101000111uuuuuu111110.  */
{ "vadd2h", 0x2E54703E, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* vadd2h<.cc> 0,limm,u6 00101110110101000111uuuuuu1QQQQQ.  */
{ "vadd2h", 0x2ED47020, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* vadd2h 0,limm,s12 00101110100101000111ssssssSSSSSS.  */
{ "vadd2h", 0x2E947000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* vadd2h a,limm,limm 00101110000101000111111110AAAAAA.  */
{ "vadd2h", 0x2E147F80, 0xFFFFFFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* vadd2h 0,limm,limm 00101110000101000111111110111110.  */
{ "vadd2h", 0x2E147FBE, 0xFFFFFFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { 0 }},

/* vadd2h<.cc> 0,limm,limm 001011101101010001111111100QQQQQ.  */
{ "vadd2h", 0x2ED47F80, 0xFFFFFFE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_CC }},

/* vadd4h a,b,c 00101bbb001110000BBBCCCCCCAAAAAA.  */
{ "vadd4h", 0x28380000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, RC }, { 0 }},

/* vadd4h 0,b,c 00101bbb001110000BBBCCCCCC111110.  */
{ "vadd4h", 0x2838003E, 0xF8FF803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, RC }, { 0 }},

/* vadd4h<.cc> b,b,c 00101bbb111110000BBBCCCCCC0QQQQQ.  */
{ "vadd4h", 0x28F80000, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_CC }},

/* vadd4h a,b,u6 00101bbb011110000BBBuuuuuuAAAAAA.  */
{ "vadd4h", 0x28780000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* vadd4h 0,b,u6 00101bbb011110000BBBuuuuuu111110.  */
{ "vadd4h", 0x2878003E, 0xF8FF803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { 0 }},

/* vadd4h<.cc> b,b,u6 00101bbb111110000BBBuuuuuu1QQQQQ.  */
{ "vadd4h", 0x28F80020, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* vadd4h b,b,s12 00101bbb101110000BBBssssssSSSSSS.  */
{ "vadd4h", 0x28B80000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* vadd4h a,limm,c 00101110001110000111CCCCCCAAAAAA.  */
{ "vadd4h", 0x2E387000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, RC }, { 0 }},

/* vadd4h a,b,limm 00101bbb001110000BBB111110AAAAAA.  */
{ "vadd4h", 0x28380F80, 0xF8FF8FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, LIMM }, { 0 }},

/* vadd4h 0,limm,c 00101110001110000111CCCCCC111110.  */
{ "vadd4h", 0x2E38703E, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { 0 }},

/* vadd4h 0,b,limm 00101bbb001110000BBB111110111110.  */
{ "vadd4h", 0x28380FBE, 0xF8FF8FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, LIMM }, { 0 }},

/* vadd4h<.cc> b,b,limm 00101bbb111110000BBB1111100QQQQQ.  */
{ "vadd4h", 0x28F80F80, 0xF8FF8FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* vadd4h<.cc> 0,limm,c 00101110111110000111CCCCCC0QQQQQ.  */
{ "vadd4h", 0x2EF87000, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_CC }},

/* vadd4h a,limm,u6 00101110011110000111uuuuuuAAAAAA.  */
{ "vadd4h", 0x2E787000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* vadd4h 0,limm,u6 00101110011110000111uuuuuu111110.  */
{ "vadd4h", 0x2E78703E, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* vadd4h<.cc> 0,limm,u6 00101110111110000111uuuuuu1QQQQQ.  */
{ "vadd4h", 0x2EF87020, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* vadd4h 0,limm,s12 00101110101110000111ssssssSSSSSS.  */
{ "vadd4h", 0x2EB87000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* vadd4h a,limm,limm 00101110001110000111111110AAAAAA.  */
{ "vadd4h", 0x2E387F80, 0xFFFFFFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* vadd4h 0,limm,limm 00101110001110000111111110111110.  */
{ "vadd4h", 0x2E387FBE, 0xFFFFFFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { 0 }},

/* vadd4h<.cc> 0,limm,limm 001011101111100001111111100QQQQQ.  */
{ "vadd4h", 0x2EF87F80, 0xFFFFFFE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_CC }},

/* vaddsub a,b,c 00101bbb001111100BBBCCCCCCAAAAAA.  */
{ "vaddsub", 0x283E0000, 0xF8FF8000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, RC }, { 0 }},

/* vaddsub 0,b,c 00101bbb001111100BBBCCCCCC111110.  */
{ "vaddsub", 0x283E003E, 0xF8FF803F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, RC }, { 0 }},

/* vaddsub<.cc> b,b,c 00101bbb111111100BBBCCCCCC0QQQQQ.  */
{ "vaddsub", 0x28FE0000, 0xF8FF8020, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_CC }},

/* vaddsub a,b,u6 00101bbb011111100BBBuuuuuuAAAAAA.  */
{ "vaddsub", 0x287E0000, 0xF8FF8000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* vaddsub 0,b,u6 00101bbb011111100BBBuuuuuu111110.  */
{ "vaddsub", 0x287E003E, 0xF8FF803F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { 0 }},

/* vaddsub<.cc> b,b,u6 00101bbb111111100BBBuuuuuu1QQQQQ.  */
{ "vaddsub", 0x28FE0020, 0xF8FF8020, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* vaddsub b,b,s12 00101bbb101111100BBBssssssSSSSSS.  */
{ "vaddsub", 0x28BE0000, 0xF8FF8000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* vaddsub a,limm,c 00101110001111100111CCCCCCAAAAAA.  */
{ "vaddsub", 0x2E3E7000, 0xFFFFF000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, RC }, { 0 }},

/* vaddsub a,b,limm 00101bbb001111100BBB111110AAAAAA.  */
{ "vaddsub", 0x283E0F80, 0xF8FF8FC0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, LIMM }, { 0 }},

/* vaddsub 0,limm,c 00101110001111100111CCCCCC111110.  */
{ "vaddsub", 0x2E3E703E, 0xFFFFF03F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { 0 }},

/* vaddsub 0,b,limm 00101bbb001111100BBB111110111110.  */
{ "vaddsub", 0x283E0FBE, 0xF8FF8FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, LIMM }, { 0 }},

/* vaddsub<.cc> b,b,limm 00101bbb111111100BBB1111100QQQQQ.  */
{ "vaddsub", 0x28FE0F80, 0xF8FF8FE0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* vaddsub<.cc> 0,limm,c 00101110111111100111CCCCCC0QQQQQ.  */
{ "vaddsub", 0x2EFE7000, 0xFFFFF020, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_CC }},

/* vaddsub a,limm,u6 00101110011111100111uuuuuuAAAAAA.  */
{ "vaddsub", 0x2E7E7000, 0xFFFFF000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* vaddsub 0,limm,u6 00101110011111100111uuuuuu111110.  */
{ "vaddsub", 0x2E7E703E, 0xFFFFF03F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* vaddsub<.cc> 0,limm,u6 00101110111111100111uuuuuu1QQQQQ.  */
{ "vaddsub", 0x2EFE7020, 0xFFFFF020, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* vaddsub 0,limm,s12 00101110101111100111ssssssSSSSSS.  */
{ "vaddsub", 0x2EBE7000, 0xFFFFF000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* vaddsub a,limm,limm 00101110001111100111111110AAAAAA.  */
{ "vaddsub", 0x2E3E7F80, 0xFFFFFFC0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* vaddsub 0,limm,limm 00101110001111100111111110111110.  */
{ "vaddsub", 0x2E3E7FBE, 0xFFFFFFFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { 0 }},

/* vaddsub<.cc> 0,limm,limm 001011101111111001111111100QQQQQ.  */
{ "vaddsub", 0x2EFE7F80, 0xFFFFFFE0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_CC }},

/* vaddsub2h a,b,c 00101bbb000101100BBBCCCCCCAAAAAA.  */
{ "vaddsub2h", 0x28160000, 0xF8FF8000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, RC }, { 0 }},

/* vaddsub2h 0,b,c 00101bbb000101100BBBCCCCCC111110.  */
{ "vaddsub2h", 0x2816003E, 0xF8FF803F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, RC }, { 0 }},

/* vaddsub2h<.cc> b,b,c 00101bbb110101100BBBCCCCCC0QQQQQ.  */
{ "vaddsub2h", 0x28D60000, 0xF8FF8020, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, RC }, { C_CC }},

/* vaddsub2h a,b,u6 00101bbb010101100BBBuuuuuuAAAAAA.  */
{ "vaddsub2h", 0x28560000, 0xF8FF8000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* vaddsub2h 0,b,u6 00101bbb010101100BBBuuuuuu111110.  */
{ "vaddsub2h", 0x2856003E, 0xF8FF803F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, UIMM6_20 }, { 0 }},

/* vaddsub2h<.cc> b,b,u6 00101bbb110101100BBBuuuuuu1QQQQQ.  */
{ "vaddsub2h", 0x28D60020, 0xF8FF8020, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* vaddsub2h b,b,s12 00101bbb100101100BBBssssssSSSSSS.  */
{ "vaddsub2h", 0x28960000, 0xF8FF8000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* vaddsub2h a,limm,c 00101110000101100111CCCCCCAAAAAA.  */
{ "vaddsub2h", 0x2E167000, 0xFFFFF000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, RC }, { 0 }},

/* vaddsub2h a,b,limm 00101bbb000101100BBB111110AAAAAA.  */
{ "vaddsub2h", 0x28160F80, 0xF8FF8FC0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, LIMM }, { 0 }},

/* vaddsub2h 0,limm,c 00101110000101100111CCCCCC111110.  */
{ "vaddsub2h", 0x2E16703E, 0xFFFFF03F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, RC }, { 0 }},

/* vaddsub2h 0,b,limm 00101bbb000101100BBB111110111110.  */
{ "vaddsub2h", 0x28160FBE, 0xF8FF8FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, LIMM }, { 0 }},

/* vaddsub2h<.cc> b,b,limm 00101bbb110101100BBB1111100QQQQQ.  */
{ "vaddsub2h", 0x28D60F80, 0xF8FF8FE0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* vaddsub2h<.cc> 0,limm,c 00101110110101100111CCCCCC0QQQQQ.  */
{ "vaddsub2h", 0x2ED67000, 0xFFFFF020, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, RC }, { C_CC }},

/* vaddsub2h a,limm,u6 00101110010101100111uuuuuuAAAAAA.  */
{ "vaddsub2h", 0x2E567000, 0xFFFFF000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* vaddsub2h 0,limm,u6 00101110010101100111uuuuuu111110.  */
{ "vaddsub2h", 0x2E56703E, 0xFFFFF03F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* vaddsub2h<.cc> 0,limm,u6 00101110110101100111uuuuuu1QQQQQ.  */
{ "vaddsub2h", 0x2ED67020, 0xFFFFF020, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* vaddsub2h 0,limm,s12 00101110100101100111ssssssSSSSSS.  */
{ "vaddsub2h", 0x2E967000, 0xFFFFF000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* vaddsub2h a,limm,limm 00101110000101100111111110AAAAAA.  */
{ "vaddsub2h", 0x2E167F80, 0xFFFFFFC0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* vaddsub2h 0,limm,limm 00101110000101100111111110111110.  */
{ "vaddsub2h", 0x2E167FBE, 0xFFFFFFFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { 0 }},

/* vaddsub2h<.cc> 0,limm,limm 001011101101011001111111100QQQQQ.  */
{ "vaddsub2h", 0x2ED67F80, 0xFFFFFFE0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_CC }},

/* vaddsub4h a,b,c 00101bbb001110100BBBCCCCCCAAAAAA.  */
{ "vaddsub4h", 0x283A0000, 0xF8FF8000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, RC }, { 0 }},

/* vaddsub4h 0,b,c 00101bbb001110100BBBCCCCCC111110.  */
{ "vaddsub4h", 0x283A003E, 0xF8FF803F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, RC }, { 0 }},

/* vaddsub4h<.cc> b,b,c 00101bbb111110100BBBCCCCCC0QQQQQ.  */
{ "vaddsub4h", 0x28FA0000, 0xF8FF8020, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_CC }},

/* vaddsub4h a,b,u6 00101bbb011110100BBBuuuuuuAAAAAA.  */
{ "vaddsub4h", 0x287A0000, 0xF8FF8000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* vaddsub4h 0,b,u6 00101bbb011110100BBBuuuuuu111110.  */
{ "vaddsub4h", 0x287A003E, 0xF8FF803F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { 0 }},

/* vaddsub4h<.cc> b,b,u6 00101bbb111110100BBBuuuuuu1QQQQQ.  */
{ "vaddsub4h", 0x28FA0020, 0xF8FF8020, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* vaddsub4h b,b,s12 00101bbb101110100BBBssssssSSSSSS.  */
{ "vaddsub4h", 0x28BA0000, 0xF8FF8000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* vaddsub4h a,limm,c 00101110001110100111CCCCCCAAAAAA.  */
{ "vaddsub4h", 0x2E3A7000, 0xFFFFF000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, RC }, { 0 }},

/* vaddsub4h a,b,limm 00101bbb001110100BBB111110AAAAAA.  */
{ "vaddsub4h", 0x283A0F80, 0xF8FF8FC0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, LIMM }, { 0 }},

/* vaddsub4h 0,limm,c 00101110001110100111CCCCCC111110.  */
{ "vaddsub4h", 0x2E3A703E, 0xFFFFF03F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { 0 }},

/* vaddsub4h 0,b,limm 00101bbb001110100BBB111110111110.  */
{ "vaddsub4h", 0x283A0FBE, 0xF8FF8FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, LIMM }, { 0 }},

/* vaddsub4h<.cc> b,b,limm 00101bbb111110100BBB1111100QQQQQ.  */
{ "vaddsub4h", 0x28FA0F80, 0xF8FF8FE0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* vaddsub4h<.cc> 0,limm,c 00101110111110100111CCCCCC0QQQQQ.  */
{ "vaddsub4h", 0x2EFA7000, 0xFFFFF020, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_CC }},

/* vaddsub4h a,limm,u6 00101110011110100111uuuuuuAAAAAA.  */
{ "vaddsub4h", 0x2E7A7000, 0xFFFFF000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* vaddsub4h 0,limm,u6 00101110011110100111uuuuuu111110.  */
{ "vaddsub4h", 0x2E7A703E, 0xFFFFF03F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* vaddsub4h<.cc> 0,limm,u6 00101110111110100111uuuuuu1QQQQQ.  */
{ "vaddsub4h", 0x2EFA7020, 0xFFFFF020, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* vaddsub4h 0,limm,s12 00101110101110100111ssssssSSSSSS.  */
{ "vaddsub4h", 0x2EBA7000, 0xFFFFF000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* vaddsub4h a,limm,limm 00101110001110100111111110AAAAAA.  */
{ "vaddsub4h", 0x2E3A7F80, 0xFFFFFFC0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* vaddsub4h 0,limm,limm 00101110001110100111111110111110.  */
{ "vaddsub4h", 0x2E3A7FBE, 0xFFFFFFFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { 0 }},

/* vaddsub4h<.cc> 0,limm,limm 001011101111101001111111100QQQQQ.  */
{ "vaddsub4h", 0x2EFA7F80, 0xFFFFFFE0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_CC }},

/* vmac2h a,b,c 00101bbb000111100BBBCCCCCCAAAAAA.  */
{ "vmac2h", 0x281E0000, 0xF8FF8000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RA_CHK, RB, RC }, { 0 }},

/* vmac2h 0,b,c 00101bbb000111100BBBCCCCCC111110.  */
{ "vmac2h", 0x281E003E, 0xF8FF803F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, RB, RC }, { 0 }},

/* vmac2h<.cc> b,b,c 00101bbb110111100BBBCCCCCC0QQQQQ.  */
{ "vmac2h", 0x28DE0000, 0xF8FF8020, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RB_CHK, RBdup, RC }, { C_CC }},

/* vmac2h a,b,u6 00101bbb010111100BBBuuuuuuAAAAAA.  */
{ "vmac2h", 0x285E0000, 0xF8FF8000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* vmac2h 0,b,u6 00101bbb010111100BBBuuuuuu111110.  */
{ "vmac2h", 0x285E003E, 0xF8FF803F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, RB, UIMM6_20 }, { 0 }},

/* vmac2h<.cc> b,b,u6 00101bbb110111100BBBuuuuuu1QQQQQ.  */
{ "vmac2h", 0x28DE0020, 0xF8FF8020, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* vmac2h b,b,s12 00101bbb100111100BBBssssssSSSSSS.  */
{ "vmac2h", 0x289E0000, 0xF8FF8000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* vmac2h a,limm,c 00101110000111100111CCCCCCAAAAAA.  */
{ "vmac2h", 0x2E1E7000, 0xFFFFF000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RA_CHK, LIMM, RC }, { 0 }},

/* vmac2h a,b,limm 00101bbb000111100BBB111110AAAAAA.  */
{ "vmac2h", 0x281E0F80, 0xF8FF8FC0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RA_CHK, RB, LIMM }, { 0 }},

/* vmac2h 0,limm,c 00101110000111100111CCCCCC111110.  */
{ "vmac2h", 0x2E1E703E, 0xFFFFF03F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, LIMM, RC }, { 0 }},

/* vmac2h 0,b,limm 00101bbb000111100BBB111110111110.  */
{ "vmac2h", 0x281E0FBE, 0xF8FF8FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, RB, LIMM }, { 0 }},

/* vmac2h<.cc> b,b,limm 00101bbb110111100BBB1111100QQQQQ.  */
{ "vmac2h", 0x28DE0F80, 0xF8FF8FE0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* vmac2h<.cc> 0,limm,c 00101110110111100111CCCCCC0QQQQQ.  */
{ "vmac2h", 0x2EDE7000, 0xFFFFF020, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, LIMM, RC }, { C_CC }},

/* vmac2h a,limm,u6 00101110010111100111uuuuuuAAAAAA.  */
{ "vmac2h", 0x2E5E7000, 0xFFFFF000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* vmac2h 0,limm,u6 00101110010111100111uuuuuu111110.  */
{ "vmac2h", 0x2E5E703E, 0xFFFFF03F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* vmac2h<.cc> 0,limm,u6 00101110110111100111uuuuuu1QQQQQ.  */
{ "vmac2h", 0x2EDE7020, 0xFFFFF020, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* vmac2h 0,limm,s12 00101110100111100111ssssssSSSSSS.  */
{ "vmac2h", 0x2E9E7000, 0xFFFFF000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* vmac2h a,limm,limm 00101110000111100111111110AAAAAA.  */
{ "vmac2h", 0x2E1E7F80, 0xFFFFFFC0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* vmac2h 0,limm,limm 00101110000111100111111110111110.  */
{ "vmac2h", 0x2E1E7FBE, 0xFFFFFFFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, LIMM, LIMMdup }, { 0 }},

/* vmac2h<.cc> 0,limm,limm 001011101101111001111111100QQQQQ.  */
{ "vmac2h", 0x2EDE7F80, 0xFFFFFFE0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, LIMM, LIMMdup }, { C_CC }},

/* vmac2hu a,b,c 00101bbb000111110BBBCCCCCCAAAAAA.  */
{ "vmac2hu", 0x281F0000, 0xF8FF8000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RA_CHK, RB, RC }, { 0 }},

/* vmac2hu 0,b,c 00101bbb000111110BBBCCCCCC111110.  */
{ "vmac2hu", 0x281F003E, 0xF8FF803F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, RB, RC }, { 0 }},

/* vmac2hu<.cc> b,b,c 00101bbb110111110BBBCCCCCC0QQQQQ.  */
{ "vmac2hu", 0x28DF0000, 0xF8FF8020, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RB_CHK, RBdup, RC }, { C_CC }},

/* vmac2hu a,b,u6 00101bbb010111110BBBuuuuuuAAAAAA.  */
{ "vmac2hu", 0x285F0000, 0xF8FF8000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* vmac2hu 0,b,u6 00101bbb010111110BBBuuuuuu111110.  */
{ "vmac2hu", 0x285F003E, 0xF8FF803F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, RB, UIMM6_20 }, { 0 }},

/* vmac2hu<.cc> b,b,u6 00101bbb110111110BBBuuuuuu1QQQQQ.  */
{ "vmac2hu", 0x28DF0020, 0xF8FF8020, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* vmac2hu b,b,s12 00101bbb100111110BBBssssssSSSSSS.  */
{ "vmac2hu", 0x289F0000, 0xF8FF8000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* vmac2hu a,limm,c 00101110000111110111CCCCCCAAAAAA.  */
{ "vmac2hu", 0x2E1F7000, 0xFFFFF000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RA_CHK, LIMM, RC }, { 0 }},

/* vmac2hu a,b,limm 00101bbb000111110BBB111110AAAAAA.  */
{ "vmac2hu", 0x281F0F80, 0xF8FF8FC0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RA_CHK, RB, LIMM }, { 0 }},

/* vmac2hu 0,limm,c 00101110000111110111CCCCCC111110.  */
{ "vmac2hu", 0x2E1F703E, 0xFFFFF03F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, LIMM, RC }, { 0 }},

/* vmac2hu 0,b,limm 00101bbb000111110BBB111110111110.  */
{ "vmac2hu", 0x281F0FBE, 0xF8FF8FFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, RB, LIMM }, { 0 }},

/* vmac2hu<.cc> b,b,limm 00101bbb110111110BBB1111100QQQQQ.  */
{ "vmac2hu", 0x28DF0F80, 0xF8FF8FE0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* vmac2hu<.cc> 0,limm,c 00101110110111110111CCCCCC0QQQQQ.  */
{ "vmac2hu", 0x2EDF7000, 0xFFFFF020, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, LIMM, RC }, { C_CC }},

/* vmac2hu a,limm,u6 00101110010111110111uuuuuuAAAAAA.  */
{ "vmac2hu", 0x2E5F7000, 0xFFFFF000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* vmac2hu 0,limm,u6 00101110010111110111uuuuuu111110.  */
{ "vmac2hu", 0x2E5F703E, 0xFFFFF03F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* vmac2hu<.cc> 0,limm,u6 00101110110111110111uuuuuu1QQQQQ.  */
{ "vmac2hu", 0x2EDF7020, 0xFFFFF020, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* vmac2hu 0,limm,s12 00101110100111110111ssssssSSSSSS.  */
{ "vmac2hu", 0x2E9F7000, 0xFFFFF000, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* vmac2hu a,limm,limm 00101110000111110111111110AAAAAA.  */
{ "vmac2hu", 0x2E1F7F80, 0xFFFFFFC0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* vmac2hu 0,limm,limm 00101110000111110111111110111110.  */
{ "vmac2hu", 0x2E1F7FBE, 0xFFFFFFFF, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, LIMM, LIMMdup }, { 0 }},

/* vmac2hu<.cc> 0,limm,limm 001011101101111101111111100QQQQQ.  */
{ "vmac2hu", 0x2EDF7F80, 0xFFFFFFE0, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, NONE, { ZA, LIMM, LIMMdup }, { C_CC }},

/* vmpy2h a,b,c 00101bbb000111000BBBCCCCCCAAAAAA.  */
{ "vmpy2h", 0x281C0000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, RB, RC }, { 0 }},

/* vmpy2h 0,b,c 00101bbb000111000BBBCCCCCC111110.  */
{ "vmpy2h", 0x281C003E, 0xF8FF803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, RB, RC }, { 0 }},

/* vmpy2h<.cc> b,b,c 00101bbb110111000BBBCCCCCC0QQQQQ.  */
{ "vmpy2h", 0x28DC0000, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, RC }, { C_CC }},

/* vmpy2h a,b,u6 00101bbb010111000BBBuuuuuuAAAAAA.  */
{ "vmpy2h", 0x285C0000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* vmpy2h 0,b,u6 00101bbb010111000BBBuuuuuu111110.  */
{ "vmpy2h", 0x285C003E, 0xF8FF803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, RB, UIMM6_20 }, { 0 }},

/* vmpy2h<.cc> b,b,u6 00101bbb110111000BBBuuuuuu1QQQQQ.  */
{ "vmpy2h", 0x28DC0020, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* vmpy2h b,b,s12 00101bbb100111000BBBssssssSSSSSS.  */

/* vmpy2h b,b,s12 00101bbb100111000BBBssssssSSSSSS.  */
{ "vmpy2h", 0x289C0000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* vmpy2h a,limm,c 00101110000111000111CCCCCCAAAAAA.  */
{ "vmpy2h", 0x2E1C7000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, LIMM, RC }, { 0 }},

/* vmpy2h a,b,limm 00101bbb000111000BBB111110AAAAAA.  */
{ "vmpy2h", 0x281C0F80, 0xF8FF8FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, RB, LIMM }, { 0 }},

/* vmpy2h 0,limm,c 00101110000111000111CCCCCC111110.  */
{ "vmpy2h", 0x2E1C703E, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, RC }, { 0 }},

/* vmpy2h 0,b,limm 00101bbb000111000BBB111110111110.  */
{ "vmpy2h", 0x281C0FBE, 0xF8FF8FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, RB, LIMM }, { 0 }},

/* vmpy2h<.cc> b,b,limm 00101bbb110111000BBB1111100QQQQQ.  */
{ "vmpy2h", 0x28DC0F80, 0xF8FF8FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* vmpy2h<.cc> 0,limm,c 00101110110111000111CCCCCC0QQQQQ.  */
{ "vmpy2h", 0x2EDC7000, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, RC }, { C_CC }},

/* vmpy2h a,limm,u6 00101110010111000111uuuuuuAAAAAA.  */
{ "vmpy2h", 0x2E5C7000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* vmpy2h 0,limm,u6 00101110010111000111uuuuuu111110.  */
{ "vmpy2h", 0x2E5C703E, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* vmpy2h<.cc> 0,limm,u6 00101110110111000111uuuuuu1QQQQQ.  */
{ "vmpy2h", 0x2EDC7020, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* vmpy2h 0,limm,s12 00101110100111000111ssssssSSSSSS.  */
{ "vmpy2h", 0x2E9C7000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* vmpy2h a,limm,limm 00101110000111000111111110AAAAAA.  */
{ "vmpy2h", 0x2E1C7F80, 0xFFFFFFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* vmpy2h 0,limm,limm 00101110000111000111111110111110.  */
{ "vmpy2h", 0x2E1C7FBE, 0xFFFFFFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, LIMMdup }, { 0 }},

/* vmpy2h<.cc> 0,limm,limm 001011101101110001111111100QQQQQ.  */
{ "vmpy2h", 0x2EDC7F80, 0xFFFFFFE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, LIMMdup }, { C_CC }},

/* vmpy2hu a,b,c 00101bbb000111010BBBCCCCCCAAAAAA.  */
{ "vmpy2hu", 0x281D0000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, RB, RC }, { 0 }},

/* vmpy2hu 0,b,c 00101bbb000111010BBBCCCCCC111110.  */
{ "vmpy2hu", 0x281D003E, 0xF8FF803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, RB, RC }, { 0 }},

/* vmpy2hu<.cc> b,b,c 00101bbb110111010BBBCCCCCC0QQQQQ.  */
{ "vmpy2hu", 0x28DD0000, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, RC }, { C_CC }},

/* vmpy2hu a,b,u6 00101bbb010111010BBBuuuuuuAAAAAA.  */
{ "vmpy2hu", 0x285D0000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* vmpy2hu 0,b,u6 00101bbb010111010BBBuuuuuu111110.  */
{ "vmpy2hu", 0x285D003E, 0xF8FF803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, RB, UIMM6_20 }, { 0 }},

/* vmpy2hu<.cc> b,b,u6 00101bbb110111010BBBuuuuuu1QQQQQ.  */
{ "vmpy2hu", 0x28DD0020, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* vmpy2hu b,b,s12 00101bbb100111010BBBssssssSSSSSS.  */
{ "vmpy2hu", 0x289D0000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* vmpy2hu a,limm,c 00101110000111010111CCCCCCAAAAAA.  */
{ "vmpy2hu", 0x2E1D7000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, LIMM, RC }, { 0 }},

/* vmpy2hu a,b,limm 00101bbb000111010BBB111110AAAAAA.  */
{ "vmpy2hu", 0x281D0F80, 0xF8FF8FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, RB, LIMM }, { 0 }},

/* vmpy2hu 0,limm,c 00101110000111010111CCCCCC111110.  */
{ "vmpy2hu", 0x2E1D703E, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, RC }, { 0 }},

/* vmpy2hu 0,b,limm 00101bbb000111010BBB111110111110.  */
{ "vmpy2hu", 0x281D0FBE, 0xF8FF8FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, RB, LIMM }, { 0 }},

/* vmpy2hu<.cc> b,b,limm 00101bbb110111010BBB1111100QQQQQ.  */
{ "vmpy2hu", 0x28DD0F80, 0xF8FF8FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* vmpy2hu<.cc> 0,limm,c 00101110110111010111CCCCCC0QQQQQ.  */
{ "vmpy2hu", 0x2EDD7000, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, RC }, { C_CC }},

/* vmpy2hu a,limm,u6 00101110010111010111uuuuuuAAAAAA.  */
{ "vmpy2hu", 0x2E5D7000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* vmpy2hu 0,limm,u6 00101110010111010111uuuuuu111110.  */
{ "vmpy2hu", 0x2E5D703E, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* vmpy2hu<.cc> 0,limm,u6 00101110110111010111uuuuuu1QQQQQ.  */
{ "vmpy2hu", 0x2EDD7020, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* vmpy2hu 0,limm,s12 00101110100111010111ssssssSSSSSS.  */
{ "vmpy2hu", 0x2E9D7000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* vmpy2hu a,limm,limm 00101110000111010111111110AAAAAA.  */
{ "vmpy2hu", 0x2E1D7F80, 0xFFFFFFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* vmpy2hu 0,limm,limm 00101110000111010111111110111110.  */
{ "vmpy2hu", 0x2E1D7FBE, 0xFFFFFFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, LIMMdup }, { 0 }},

/* vmpy2hu<.cc> 0,limm,limm 001011101101110101111111100QQQQQ.  */
{ "vmpy2hu", 0x2EDD7F80, 0xFFFFFFE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY8E, { ZA, LIMM, LIMMdup }, { C_CC }},

/* vsub2 a,b,c 00101bbb001111010BBBCCCCCCAAAAAA.  */
{ "vsub2", 0x283D0000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, RC }, { 0 }},

/* vsub2 0,b,c 00101bbb001111010BBBCCCCCC111110.  */
{ "vsub2", 0x283D003E, 0xF8FF803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, RC }, { 0 }},

/* vsub2<.cc> b,b,c 00101bbb111111010BBBCCCCCC0QQQQQ.  */
{ "vsub2", 0x28FD0000, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_CC }},

/* vsub2 a,b,u6 00101bbb011111010BBBuuuuuuAAAAAA.  */
{ "vsub2", 0x287D0000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* vsub2 0,b,u6 00101bbb011111010BBBuuuuuu111110.  */
{ "vsub2", 0x287D003E, 0xF8FF803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { 0 }},

/* vsub2<.cc> b,b,u6 00101bbb111111010BBBuuuuuu1QQQQQ.  */
{ "vsub2", 0x28FD0020, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* vsub2 b,b,s12 00101bbb101111010BBBssssssSSSSSS.  */
{ "vsub2", 0x28BD0000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* vsub2 a,limm,c 00101110001111010111CCCCCCAAAAAA.  */
{ "vsub2", 0x2E3D7000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, RC }, { 0 }},

/* vsub2 a,b,limm 00101bbb001111010BBB111110AAAAAA.  */
{ "vsub2", 0x283D0F80, 0xF8FF8FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, LIMM }, { 0 }},

/* vsub2 0,limm,c 00101110001111010111CCCCCC111110.  */
{ "vsub2", 0x2E3D703E, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { 0 }},

/* vsub2 0,b,limm 00101bbb001111010BBB111110111110.  */
{ "vsub2", 0x283D0FBE, 0xF8FF8FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, LIMM }, { 0 }},

/* vsub2<.cc> b,b,limm 00101bbb111111010BBB1111100QQQQQ.  */
{ "vsub2", 0x28FD0F80, 0xF8FF8FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* vsub2<.cc> 0,limm,c 00101110111111010111CCCCCC0QQQQQ.  */
{ "vsub2", 0x2EFD7000, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_CC }},

/* vsub2 a,limm,u6 00101110011111010111uuuuuuAAAAAA.  */
{ "vsub2", 0x2E7D7000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* vsub2 0,limm,u6 00101110011111010111uuuuuu111110.  */
{ "vsub2", 0x2E7D703E, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* vsub2<.cc> 0,limm,u6 00101110111111010111uuuuuu1QQQQQ.  */
{ "vsub2", 0x2EFD7020, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* vsub2 0,limm,s12 00101110101111010111ssssssSSSSSS.  */
{ "vsub2", 0x2EBD7000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* vsub2 a,limm,limm 00101110001111010111111110AAAAAA.  */
{ "vsub2", 0x2E3D7F80, 0xFFFFFFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* vsub2 0,limm,limm 00101110001111010111111110111110.  */
{ "vsub2", 0x2E3D7FBE, 0xFFFFFFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { 0 }},

/* vsub2<.cc> 0,limm,limm 001011101111110101111111100QQQQQ.  */
{ "vsub2", 0x2EFD7F80, 0xFFFFFFE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_CC }},

/* vsub2h a,b,c 00101bbb000101010BBBCCCCCCAAAAAA.  */
{ "vsub2h", 0x28150000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, RC }, { 0 }},

/* vsub2h 0,b,c 00101bbb000101010BBBCCCCCC111110.  */
{ "vsub2h", 0x2815003E, 0xF8FF803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, RC }, { 0 }},

/* vsub2h<.cc> b,b,c 00101bbb110101010BBBCCCCCC0QQQQQ.  */
{ "vsub2h", 0x28D50000, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, RC }, { C_CC }},

/* vsub2h a,b,u6 00101bbb010101010BBBuuuuuuAAAAAA.  */
{ "vsub2h", 0x28550000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* vsub2h 0,b,u6 00101bbb010101010BBBuuuuuu111110.  */
{ "vsub2h", 0x2855003E, 0xF8FF803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, UIMM6_20 }, { 0 }},

/* vsub2h<.cc> b,b,u6 00101bbb110101010BBBuuuuuu1QQQQQ.  */
{ "vsub2h", 0x28D50020, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* vsub2h b,b,s12 00101bbb100101010BBBssssssSSSSSS.  */
{ "vsub2h", 0x28950000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* vsub2h a,limm,c 00101110000101010111CCCCCCAAAAAA.  */
{ "vsub2h", 0x2E157000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, RC }, { 0 }},

/* vsub2h a,b,limm 00101bbb000101010BBB111110AAAAAA.  */
{ "vsub2h", 0x28150F80, 0xF8FF8FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, LIMM }, { 0 }},

/* vsub2h 0,limm,c 00101110000101010111CCCCCC111110.  */
{ "vsub2h", 0x2E15703E, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, RC }, { 0 }},

/* vsub2h 0,b,limm 00101bbb000101010BBB111110111110.  */
{ "vsub2h", 0x28150FBE, 0xF8FF8FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, LIMM }, { 0 }},

/* vsub2h<.cc> b,b,limm 00101bbb110101010BBB1111100QQQQQ.  */
{ "vsub2h", 0x28D50F80, 0xF8FF8FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* vsub2h<.cc> 0,limm,c 00101110110101010111CCCCCC0QQQQQ.  */
{ "vsub2h", 0x2ED57000, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, RC }, { C_CC }},

/* vsub2h a,limm,u6 00101110010101010111uuuuuuAAAAAA.  */
{ "vsub2h", 0x2E557000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* vsub2h 0,limm,u6 00101110010101010111uuuuuu111110.  */
{ "vsub2h", 0x2E55703E, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* vsub2h<.cc> 0,limm,u6 00101110110101010111uuuuuu1QQQQQ.  */
{ "vsub2h", 0x2ED57020, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* vsub2h 0,limm,s12 00101110100101010111ssssssSSSSSS.  */
{ "vsub2h", 0x2E957000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* vsub2h a,limm,limm 00101110000101010111111110AAAAAA.  */
{ "vsub2h", 0x2E157F80, 0xFFFFFFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* vsub2h 0,limm,limm 00101110000101010111111110111110.  */
{ "vsub2h", 0x2E157FBE, 0xFFFFFFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { 0 }},

/* vsub2h<.cc> 0,limm,limm 001011101101010101111111100QQQQQ.  */
{ "vsub2h", 0x2ED57F80, 0xFFFFFFE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_CC }},

/* vsub4h a,b,c 00101bbb001110010BBBCCCCCCAAAAAA.  */
{ "vsub4h", 0x28390000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, RC }, { 0 }},

/* vsub4h 0,b,c 00101bbb001110010BBBCCCCCC111110.  */
{ "vsub4h", 0x2839003E, 0xF8FF803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, RC }, { 0 }},

/* vsub4h<.cc> b,b,c 00101bbb111110010BBBCCCCCC0QQQQQ.  */
{ "vsub4h", 0x28F90000, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_CC }},

/* vsub4h a,b,u6 00101bbb011110010BBBuuuuuuAAAAAA.  */
{ "vsub4h", 0x28790000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* vsub4h 0,b,u6 00101bbb011110010BBBuuuuuu111110.  */
{ "vsub4h", 0x2879003E, 0xF8FF803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { 0 }},

/* vsub4h<.cc> b,b,u6 00101bbb111110010BBBuuuuuu1QQQQQ.  */
{ "vsub4h", 0x28F90020, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* vsub4h b,b,s12 00101bbb101110010BBBssssssSSSSSS.  */
{ "vsub4h", 0x28B90000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* vsub4h a,limm,c 00101110001110010111CCCCCCAAAAAA.  */
{ "vsub4h", 0x2E397000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, RC }, { 0 }},

/* vsub4h a,b,limm 00101bbb001110010BBB111110AAAAAA.  */
{ "vsub4h", 0x28390F80, 0xF8FF8FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, LIMM }, { 0 }},

/* vsub4h 0,limm,c 00101110001110010111CCCCCC111110.  */
{ "vsub4h", 0x2E39703E, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { 0 }},

/* vsub4h 0,b,limm 00101bbb001110010BBB111110111110.  */
{ "vsub4h", 0x28390FBE, 0xF8FF8FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, LIMM }, { 0 }},

/* vsub4h<.cc> b,b,limm 00101bbb111110010BBB1111100QQQQQ.  */
{ "vsub4h", 0x28F90F80, 0xF8FF8FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* vsub4h<.cc> 0,limm,c 00101110111110010111CCCCCC0QQQQQ.  */
{ "vsub4h", 0x2EF97000, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_CC }},

/* vsub4h a,limm,u6 00101110011110010111uuuuuuAAAAAA.  */
{ "vsub4h", 0x2E797000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* vsub4h 0,limm,u6 00101110011110010111uuuuuu111110.  */
{ "vsub4h", 0x2E79703E, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* vsub4h<.cc> 0,limm,u6 00101110111110010111uuuuuu1QQQQQ.  */
{ "vsub4h", 0x2EF97020, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* vsub4h 0,limm,s12 00101110101110010111ssssssSSSSSS.  */
{ "vsub4h", 0x2EB97000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* vsub4h a,limm,limm 00101110001110010111111110AAAAAA.  */
{ "vsub4h", 0x2E397F80, 0xFFFFFFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* vsub4h 0,limm,limm 00101110001110010111111110111110.  */
{ "vsub4h", 0x2E397FBE, 0xFFFFFFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { 0 }},

/* vsub4h<.cc> 0,limm,limm 001011101111100101111111100QQQQQ.  */
{ "vsub4h", 0x2EF97F80, 0xFFFFFFE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_CC }},

/* vsubadd a,b,c 00101bbb001111110BBBCCCCCCAAAAAA.  */
{ "vsubadd", 0x283F0000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, RC }, { 0 }},

/* vsubadd 0,b,c 00101bbb001111110BBBCCCCCC111110.  */
{ "vsubadd", 0x283F003E, 0xF8FF803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, RC }, { 0 }},

/* vsubadd<.cc> b,b,c 00101bbb111111110BBBCCCCCC0QQQQQ.  */
{ "vsubadd", 0x28FF0000, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_CC }},

/* vsubadd a,b,u6 00101bbb011111110BBBuuuuuuAAAAAA.  */
{ "vsubadd", 0x287F0000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* vsubadd 0,b,u6 00101bbb011111110BBBuuuuuu111110.  */
{ "vsubadd", 0x287F003E, 0xF8FF803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { 0 }},

/* vsubadd<.cc> b,b,u6 00101bbb111111110BBBuuuuuu1QQQQQ.  */
{ "vsubadd", 0x28FF0020, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* vsubadd b,b,s12 00101bbb101111110BBBssssssSSSSSS.  */
{ "vsubadd", 0x28BF0000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* vsubadd a,limm,c 00101110001111110111CCCCCCAAAAAA.  */
{ "vsubadd", 0x2E3F7000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, RC }, { 0 }},

/* vsubadd a,b,limm 00101bbb001111110BBB111110AAAAAA.  */
{ "vsubadd", 0x283F0F80, 0xF8FF8FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, LIMM }, { 0 }},

/* vsubadd 0,limm,c 00101110001111110111CCCCCC111110.  */
{ "vsubadd", 0x2E3F703E, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { 0 }},

/* vsubadd 0,b,limm 00101bbb001111110BBB111110111110.  */
{ "vsubadd", 0x283F0FBE, 0xF8FF8FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, LIMM }, { 0 }},

/* vsubadd<.cc> b,b,limm 00101bbb111111110BBB1111100QQQQQ.  */
{ "vsubadd", 0x28FF0F80, 0xF8FF8FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* vsubadd<.cc> 0,limm,c 00101110111111110111CCCCCC0QQQQQ.  */
{ "vsubadd", 0x2EFF7000, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_CC }},

/* vsubadd a,limm,u6 00101110011111110111uuuuuuAAAAAA.  */
{ "vsubadd", 0x2E7F7000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* vsubadd 0,limm,u6 00101110011111110111uuuuuu111110.  */
{ "vsubadd", 0x2E7F703E, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* vsubadd<.cc> 0,limm,u6 00101110111111110111uuuuuu1QQQQQ.  */
{ "vsubadd", 0x2EFF7020, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* vsubadd 0,limm,s12 00101110101111110111ssssssSSSSSS.  */
{ "vsubadd", 0x2EBF7000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* vsubadd a,limm,limm 00101110001111110111111110AAAAAA.  */
{ "vsubadd", 0x2E3F7F80, 0xFFFFFFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* vsubadd 0,limm,limm 00101110001111110111111110111110.  */
{ "vsubadd", 0x2E3F7FBE, 0xFFFFFFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { 0 }},

/* vsubadd<.cc> 0,limm,limm 001011101111111101111111100QQQQQ.  */
{ "vsubadd", 0x2EFF7F80, 0xFFFFFFE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_CC }},

/* vsubadd2h a,b,c 00101bbb000101110BBBCCCCCCAAAAAA.  */
{ "vsubadd2h", 0x28170000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, RC }, { 0 }},

/* vsubadd2h 0,b,c 00101bbb000101110BBBCCCCCC111110.  */
{ "vsubadd2h", 0x2817003E, 0xF8FF803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, RC }, { 0 }},

/* vsubadd2h<.cc> b,b,c 00101bbb110101110BBBCCCCCC0QQQQQ.  */
{ "vsubadd2h", 0x28D70000, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, RC }, { C_CC }},

/* vsubadd2h a,b,u6 00101bbb010101110BBBuuuuuuAAAAAA.  */
{ "vsubadd2h", 0x28570000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* vsubadd2h 0,b,u6 00101bbb010101110BBBuuuuuu111110.  */
{ "vsubadd2h", 0x2857003E, 0xF8FF803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, UIMM6_20 }, { 0 }},

/* vsubadd2h<.cc> b,b,u6 00101bbb110101110BBBuuuuuu1QQQQQ.  */
{ "vsubadd2h", 0x28D70020, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* vsubadd2h b,b,s12 00101bbb100101110BBBssssssSSSSSS.  */
{ "vsubadd2h", 0x28970000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* vsubadd2h a,limm,c 00101110000101110111CCCCCCAAAAAA.  */
{ "vsubadd2h", 0x2E177000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, RC }, { 0 }},

/* vsubadd2h a,b,limm 00101bbb000101110BBB111110AAAAAA.  */
{ "vsubadd2h", 0x28170F80, 0xF8FF8FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, RB, LIMM }, { 0 }},

/* vsubadd2h 0,limm,c 00101110000101110111CCCCCC111110.  */
{ "vsubadd2h", 0x2E17703E, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, RC }, { 0 }},

/* vsubadd2h 0,b,limm 00101bbb000101110BBB111110111110.  */
{ "vsubadd2h", 0x28170FBE, 0xF8FF8FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, RB, LIMM }, { 0 }},

/* vsubadd2h<.cc> b,b,limm 00101bbb110101110BBB1111100QQQQQ.  */
{ "vsubadd2h", 0x28D70F80, 0xF8FF8FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* vsubadd2h<.cc> 0,limm,c 00101110110101110111CCCCCC0QQQQQ.  */
{ "vsubadd2h", 0x2ED77000, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, RC }, { C_CC }},

/* vsubadd2h a,limm,u6 00101110010101110111uuuuuuAAAAAA.  */
{ "vsubadd2h", 0x2E577000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* vsubadd2h 0,limm,u6 00101110010101110111uuuuuu111110.  */
{ "vsubadd2h", 0x2E57703E, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* vsubadd2h<.cc> 0,limm,u6 00101110110101110111uuuuuu1QQQQQ.  */
{ "vsubadd2h", 0x2ED77020, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* vsubadd2h 0,limm,s12 00101110100101110111ssssssSSSSSS.  */
{ "vsubadd2h", 0x2E977000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* vsubadd2h a,limm,limm 00101110000101110111111110AAAAAA.  */
{ "vsubadd2h", 0x2E177F80, 0xFFFFFFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* vsubadd2h 0,limm,limm 00101110000101110111111110111110.  */
{ "vsubadd2h", 0x2E177FBE, 0xFFFFFFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { 0 }},

/* vsubadd2h<.cc> 0,limm,limm 001011101101011101111111100QQQQQ.  */
{ "vsubadd2h", 0x2ED77F80, 0xFFFFFFE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY7E, { ZA, LIMM, LIMMdup }, { C_CC }},

/* vsubadd4h a,b,c 00101bbb001110110BBBCCCCCCAAAAAA.  */
{ "vsubadd4h", 0x283B0000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, RC }, { 0 }},

/* vsubadd4h 0,b,c 00101bbb001110110BBBCCCCCC111110.  */
{ "vsubadd4h", 0x283B003E, 0xF8FF803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, RC }, { 0 }},

/* vsubadd4h<.cc> b,b,c 00101bbb111110110BBBCCCCCC0QQQQQ.  */
{ "vsubadd4h", 0x28FB0000, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, RC }, { C_CC }},

/* vsubadd4h a,b,u6 00101bbb011110110BBBuuuuuuAAAAAA.  */
{ "vsubadd4h", 0x287B0000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, UIMM6_20 }, { 0 }},

/* vsubadd4h 0,b,u6 00101bbb011110110BBBuuuuuu111110.  */
{ "vsubadd4h", 0x287B003E, 0xF8FF803F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, UIMM6_20 }, { 0 }},

/* vsubadd4h<.cc> b,b,u6 00101bbb111110110BBBuuuuuu1QQQQQ.  */
{ "vsubadd4h", 0x28FB0020, 0xF8FF8020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, UIMM6_20 }, { C_CC }},

/* vsubadd4h b,b,s12 00101bbb101110110BBBssssssSSSSSS.  */
{ "vsubadd4h", 0x28BB0000, 0xF8FF8000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, SIMM12_20 }, { 0 }},

/* vsubadd4h a,limm,c 00101110001110110111CCCCCCAAAAAA.  */
{ "vsubadd4h", 0x2E3B7000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, RC }, { 0 }},

/* vsubadd4h a,b,limm 00101bbb001110110BBB111110AAAAAA.  */
{ "vsubadd4h", 0x283B0F80, 0xF8FF8FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, RB, LIMM }, { 0 }},

/* vsubadd4h 0,limm,c 00101110001110110111CCCCCC111110.  */
{ "vsubadd4h", 0x2E3B703E, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { 0 }},

/* vsubadd4h 0,b,limm 00101bbb001110110BBB111110111110.  */
{ "vsubadd4h", 0x283B0FBE, 0xF8FF8FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, RB, LIMM }, { 0 }},

/* vsubadd4h<.cc> b,b,limm 00101bbb111110110BBB1111100QQQQQ.  */
{ "vsubadd4h", 0x28FB0F80, 0xF8FF8FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RB_CHK, RBdup, LIMM }, { C_CC }},

/* vsubadd4h<.cc> 0,limm,c 00101110111110110111CCCCCC0QQQQQ.  */
{ "vsubadd4h", 0x2EFB7000, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, RC }, { C_CC }},

/* vsubadd4h a,limm,u6 00101110011110110111uuuuuuAAAAAA.  */
{ "vsubadd4h", 0x2E7B7000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, UIMM6_20 }, { 0 }},

/* vsubadd4h 0,limm,u6 00101110011110110111uuuuuu111110.  */
{ "vsubadd4h", 0x2E7B703E, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { 0 }},

/* vsubadd4h<.cc> 0,limm,u6 00101110111110110111uuuuuu1QQQQQ.  */
{ "vsubadd4h", 0x2EFB7020, 0xFFFFF020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, UIMM6_20 }, { C_CC }},

/* vsubadd4h 0,limm,s12 00101110101110110111ssssssSSSSSS.  */
{ "vsubadd4h", 0x2EBB7000, 0xFFFFF000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, SIMM12_20 }, { 0 }},

/* vsubadd4h a,limm,limm 00101110001110110111111110AAAAAA.  */
{ "vsubadd4h", 0x2E3B7F80, 0xFFFFFFC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { RA_CHK, LIMM, LIMMdup }, { 0 }},

/* vsubadd4h 0,limm,limm 00101110001110110111111110111110.  */
{ "vsubadd4h", 0x2E3B7FBE, 0xFFFFFFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { 0 }},

/* vsubadd4h<.cc> 0,limm,limm 001011101111101101111111100QQQQQ.  */
{ "vsubadd4h", 0x2EFB7F80, 0xFFFFFFE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, MPY, MPY9E, { ZA, LIMM, LIMMdup }, { C_CC }},

/* wevt c 00100000001011110001CCCCCC111111.  */
{ "wevt", 0x202F103F, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, KERNEL, NONE, { RC }, { 0 }},

/* wevt  00100000011011110001000000111111.  */
{ "wevt", 0x206F103F, 0xFFFFFFFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, KERNEL, NONE, { 0 }, { 0 }},

/* wevt u6 00100000011011110001uuuuuu111111.  */
{ "wevt", 0x206F103F, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, KERNEL, NONE, { UIMM6_20 }, { 0 }},

/* wlfc c 00100001001011110001CCCCCC111111.  */
{ "wlfc", 0x212F103F, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, KERNEL, NONE, { RC }, { 0 }},

/* wlfc u6 00100001011011110001uuuuuu111111.  */
{ "wlfc", 0x216F103F, 0xFFFFF03F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, KERNEL, NONE, { UIMM6_20 }, { 0 }},

/* xbfu<.f> a,b,c 00100bbb00101101FBBBCCCCCCAAAAAA.  */
{ "xbfu", 0x202D0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT2, { RA, RB, RC }, { C_F }},

/* xbfu<.f> 0,b,c 00100bbb00101101FBBBCCCCCC111110.  */
{ "xbfu", 0x202D003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT2, { ZA, RB, RC }, { C_F }},

/* xbfu<.f><.cc> b,b,c 00100bbb11101101FBBBCCCCCC0QQQQQ.  */
{ "xbfu", 0x20ED0000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT2, { RB, RBdup, RC }, { C_F, C_CC }},

/* xbfu<.f> a,b,u6 00100bbb01101101FBBBuuuuuuAAAAAA.  */
{ "xbfu", 0x206D0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT2, { RA, RB, UIMM6_20 }, { C_F }},

/* xbfu<.f> 0,b,u6 00100bbb01101101FBBBuuuuuu111110.  */
{ "xbfu", 0x206D003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT2, { ZA, RB, UIMM6_20 }, { C_F }},

/* xbfu<.f><.cc> b,b,u6 00100bbb11101101FBBBuuuuuu1QQQQQ.  */
{ "xbfu", 0x20ED0020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT2, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* xbfu<.f> b,b,s12 00100bbb10101101FBBBssssssSSSSSS.  */
{ "xbfu", 0x20AD0000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT2, { RB, RBdup, SIMM12_20 }, { C_F }},

/* xbfu<.f> a,limm,c 0010011000101101F111CCCCCCAAAAAA.  */
{ "xbfu", 0x262D7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT2, { RA, LIMM, RC }, { C_F }},

/* xbfu<.f> a,b,limm 00100bbb00101101FBBB111110AAAAAA.  */
{ "xbfu", 0x202D0F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT2, { RA, RB, LIMM }, { C_F }},

/* xbfu<.f> 0,limm,c 0010011000101101F111CCCCCC111110.  */
{ "xbfu", 0x262D703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT2, { ZA, LIMM, RC }, { C_F }},

/* xbfu<.f> 0,b,limm 00100bbb00101101FBBB111110111110.  */
{ "xbfu", 0x202D0FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT2, { ZA, RB, LIMM }, { C_F }},

/* xbfu<.f><.cc> b,b,limm 00100bbb11101101FBBB1111100QQQQQ.  */
{ "xbfu", 0x20ED0F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT2, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* xbfu<.f><.cc> 0,limm,c 0010011011101101F111CCCCCC0QQQQQ.  */
{ "xbfu", 0x26ED7000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT2, { ZA, LIMM, RC }, { C_F, C_CC }},

/* xbfu<.f> a,limm,u6 0010011001101101F111uuuuuuAAAAAA.  */
{ "xbfu", 0x266D7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT2, { RA, LIMM, UIMM6_20 }, { C_F }},

/* xbfu<.f> 0,limm,u6 0010011001101101F111uuuuuu111110.  */
{ "xbfu", 0x266D703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT2, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* xbfu<.f><.cc> 0,limm,u6 0010011011101101F111uuuuuu1QQQQQ.  */
{ "xbfu", 0x26ED7020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT2, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* xbfu<.f> 0,limm,s12 0010011010101101F111ssssssSSSSSS.  */
{ "xbfu", 0x26AD7000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT2, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* xbfu<.f> a,limm,limm 0010011000101101F111111110AAAAAA.  */
{ "xbfu", 0x262D7F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT2, { RA, LIMM, LIMMdup }, { C_F }},

/* xbfu<.f> 0,limm,limm 0010011000101101F111111110111110.  */
{ "xbfu", 0x262D7FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT2, { ZA, LIMM, LIMMdup }, { C_F }},

/* xbfu<.f><.cc> 0,limm,limm 0010011011101101F1111111100QQQQQ.  */
{ "xbfu", 0x26ED7F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, ARITH, SHFT2, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* xbful<.f> RA,RB,RC 01011bbb00101101FBBBccccccaaaaaa.  */
{ "xbful", 0x582D0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* xbful<.f> 0,RB,RC 01011bbb00101101FBBBcccccc111110.  */
{ "xbful", 0x582D003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* xbful<.f><.cc> RB,RB,RC 01011bbb11101101FBBBcccccc0QQQQQ.  */
{ "xbful", 0x58ED0000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* xbful<.f> RA,RB,u6 01011bbb01101101FBBBuuuuuuaaaaaa.  */
{ "xbful", 0x586D0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* xbful<.f> 0,RB,u6 01011bbb01101101FBBBuuuuuu111110.  */
{ "xbful", 0x586D003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* xbful<.f><.cc> RB,RB,u6 01011bbb11101101FBBBuuuuuu1QQQQQ.  */
{ "xbful", 0x58ED0020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* xbful<.f> RB,RB,s12 01011bbb10101101FBBBssssssSSSSSS.  */
{ "xbful", 0x58AD0000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* xbful<.f> RA,ximm,RC 0101110000101101F111ccccccaaaaaa.  */
{ "xbful", 0x5C2D7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* xbful<.f> RA,RB,ximm 01011bbb00101101FBBB111100aaaaaa.  */
{ "xbful", 0x582D0F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* xbful<.f> 0,ximm,RC 0101110000101101F111cccccc111110.  */
{ "xbful", 0x5C2D703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* xbful<.f> 0,RB,ximm 01011bbb00101101FBBB111100111110.  */
{ "xbful", 0x582D0F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* xbful<.f><.cc> 0,ximm,RC 0101110011101101F111cccccc0QQQQQ.  */
{ "xbful", 0x5CED7000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* xbful<.f><.cc> RB,RB,ximm 01011bbb11101101FBBB1111000QQQQQ.  */
{ "xbful", 0x58ED0F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* xbful<.f> RA,ximm,u6 0101110001101101F111uuuuuuaaaaaa.  */
{ "xbful", 0x5C6D7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* xbful<.f> 0,ximm,u6 0101110001101101F111uuuuuu111110.  */
{ "xbful", 0x5C6D703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* xbful<.f><.cc> 0,ximm,u6 0101110011101101F111uuuuuu1QQQQQ.  */
{ "xbful", 0x5CED7020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* xbful<.f> RA,limm,RC 0101111000101101F111ccccccaaaaaa.  */
{ "xbful", 0x5E2D7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* xbful<.f> RA,RB,limm 01011bbb00101101FBBB111110aaaaaa.  */
{ "xbful", 0x582D0F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* xbful<.f> 0,limm,RC 0101111000101101F111cccccc111110.  */
{ "xbful", 0x5E2D703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* xbful<.f> 0,RB,limm 01011bbb00101101FBBB111110111110.  */
{ "xbful", 0x582D0FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* xbful<.f><.cc> 0,limm,RC 0101111011101101F111cccccc0QQQQQ.  */
{ "xbful", 0x5EED7000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* xbful<.f><.cc> RB,RB,limm 01011bbb11101101FBBB1111100QQQQQ.  */
{ "xbful", 0x58ED0F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* xbful<.f> RA,limm,u6 0101111001101101F111uuuuuuaaaaaa.  */
{ "xbful", 0x5E6D7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* xbful<.f> 0,limm,u6 0101111001101101F111uuuuuu111110.  */
{ "xbful", 0x5E6D703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* xbful<.f><.cc> 0,limm,u6 0101111011101101F111uuuuuu1QQQQQ.  */
{ "xbful", 0x5EED7020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* xbful<.f> 0,ximm,s12 0101110010101101F111ssssssSSSSSS.  */
{ "xbful", 0x5CAD7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* xbful<.f> 0,limm,s12 0101111010101101F111ssssssSSSSSS.  */
{ "xbful", 0x5EAD7000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* xbful<.f> RA,ximm,ximm 0101110000101101F111111100aaaaaa.  */
{ "xbful", 0x5C2D7F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* xbful<.f> 0,ximm,ximm 0101110000101101F111111100111110.  */
{ "xbful", 0x5C2D7F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* xbful<.f><.cc> 0,ximm,ximm 0101110011101101F1111111000QQQQQ.  */
{ "xbful", 0x5CED7F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* xbful<.f> RA,limm,limm 0101111000101101F111111110aaaaaa.  */
{ "xbful", 0x5E2D7F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* xbful<.f> 0,limm,limm 0101111000101101F111111110111110.  */
{ "xbful", 0x5E2D7FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* xbful<.f><.cc> 0,limm,limm 0101111011101101F1111111100QQQQQ.  */
{ "xbful", 0x5EED7F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* xor<.f> a,b,c 00100bbb00000111FBBBCCCCCCAAAAAA.  */
{ "xor", 0x20070000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, RC }, { C_F }},

/* xor<.f> 0,b,c 00100bbb00000111FBBBCCCCCC111110.  */
{ "xor", 0x2007003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, RC }, { C_F }},

/* xor<.f><.cc> b,b,c 00100bbb11000111FBBBCCCCCC0QQQQQ.  */
{ "xor", 0x20C70000, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* xor<.f> a,b,u6 00100bbb01000111FBBBuuuuuuAAAAAA.  */
{ "xor", 0x20470000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* xor<.f> 0,b,u6 00100bbb01000111FBBBuuuuuu111110.  */
{ "xor", 0x2047003E, 0xF8FF003F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* xor<.f><.cc> b,b,u6 00100bbb11000111FBBBuuuuuu1QQQQQ.  */
{ "xor", 0x20C70020, 0xF8FF0020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* xor<.f> b,b,s12 00100bbb10000111FBBBssssssSSSSSS.  */
{ "xor", 0x20870000, 0xF8FF0000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* xor<.f> a,limm,c 0010011000000111F111CCCCCCAAAAAA.  */
{ "xor", 0x26077000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, RC }, { C_F }},

/* xor<.f> a,b,limm 00100bbb00000111FBBB111110AAAAAA.  */
{ "xor", 0x20070F80, 0xF8FF0FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, RB, LIMM }, { C_F }},

/* xor<.f> 0,limm,c 0010011000000111F111CCCCCC111110.  */
{ "xor", 0x2607703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F }},

/* xor<.f> 0,b,limm 00100bbb00000111FBBB111110111110.  */
{ "xor", 0x20070FBE, 0xF8FF0FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, RB, LIMM }, { C_F }},

/* xor<.f><.cc> 0,limm,c 0010011011000111F111CCCCCC0QQQQQ.  */
{ "xor", 0x26C77000, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* xor<.f><.cc> b,b,limm 00100bbb11000111FBBB1111100QQQQQ.  */
{ "xor", 0x20C70F80, 0xF8FF0FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* xor<.f> a,limm,u6 0010011001000111F111uuuuuuAAAAAA.  */
{ "xor", 0x26477000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* xor<.f> 0,limm,u6 0010011001000111F111uuuuuu111110.  */
{ "xor", 0x2647703E, 0xFFFF703F,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* xor<.f><.cc> 0,limm,u6 0010011011000111F111uuuuuu1QQQQQ.  */
{ "xor", 0x26C77020, 0xFFFF7020,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* xor<.f> 0,limm,s12 0010011010000111F111ssssssSSSSSS.  */
{ "xor", 0x26877000, 0xFFFF7000,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* xor<.f> a,limm,limm 0010011000000111F111111110AAAAAA.  */
{ "xor", 0x26077F80, 0xFFFF7FC0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* xor<.f> 0,limm,limm 0010011000000111F111111110111110.  */
{ "xor", 0x26077FBE, 0xFFFF7FFF,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* xor<.f><.cc> 0,limm,limm 0010011011000111F1111111100QQQQQ.  */
{ "xor", 0x26C77F80, 0xFFFF7FE0,ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* xorl<.f> RA,RB,RC 01011bbb00000111FBBBccccccaaaaaa.  */
{ "xorl", 0x58070000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, RC }, { C_F }},

/* xorl<.f> 0,RB,RC 01011bbb00000111FBBBcccccc111110.  */
{ "xorl", 0x5807003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, RC }, { C_F }},

/* xorl<.f><.cc> RB,RB,RC 01011bbb11000111FBBBcccccc0QQQQQ.  */
{ "xorl", 0x58C70000, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, RC }, { C_F, C_CC }},

/* xorl<.f> RA,RB,u6 01011bbb01000111FBBBuuuuuuaaaaaa.  */
{ "xorl", 0x58470000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, UIMM6_20 }, { C_F }},

/* xorl<.f> 0,RB,u6 01011bbb01000111FBBBuuuuuu111110.  */
{ "xorl", 0x5847003E, 0xF8FF003F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, UIMM6_20 }, { C_F }},

/* xorl<.f><.cc> RB,RB,u6 01011bbb11000111FBBBuuuuuu1QQQQQ.  */
{ "xorl", 0x58C70020, 0xF8FF0020, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, UIMM6_20 }, { C_F, C_CC }},

/* xorl<.f> RB,RB,s12 01011bbb10000111FBBBssssssSSSSSS.  */
{ "xorl", 0x58870000, 0xF8FF0000, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, SIMM12_20 }, { C_F }},

/* xorl<.f> RA,ximm,RC 0101110000000111F111ccccccaaaaaa.  */
{ "xorl", 0x5C077000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, RC }, { C_F }},

/* xorl<.f> RA,RB,ximm 01011bbb00000111FBBB111100aaaaaa.  */
{ "xorl", 0x58070F00, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, XIMM }, { C_F }},

/* xorl<.f> 0,ximm,RC 0101110000000111F111cccccc111110.  */
{ "xorl", 0x5C07703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F }},

/* xorl<.f> 0,RB,ximm 01011bbb00000111FBBB111100111110.  */
{ "xorl", 0x58070F3E, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, XIMM }, { C_F }},

/* xorl<.f><.cc> 0,ximm,RC 0101110011000111F111cccccc0QQQQQ.  */
{ "xorl", 0x5CC77000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, RC }, { C_F, C_CC }},

/* xorl<.f><.cc> RB,RB,ximm 01011bbb11000111FBBB1111000QQQQQ.  */
{ "xorl", 0x58C70F00, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, XIMM }, { C_F, C_CC }},

/* xorl<.f> RA,ximm,u6 0101110001000111F111uuuuuuaaaaaa.  */
{ "xorl", 0x5C477000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, UIMM6_20 }, { C_F }},

/* xorl<.f> 0,ximm,u6 0101110001000111F111uuuuuu111110.  */
{ "xorl", 0x5C47703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F }},

/* xorl<.f><.cc> 0,ximm,u6 0101110011000111F111uuuuuu1QQQQQ.  */
{ "xorl", 0x5CC77020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, UIMM6_20 }, { C_F, C_CC }},

/* xorl<.f> RA,limm,RC 0101111000000111F111ccccccaaaaaa.  */
{ "xorl", 0x5E077000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, RC }, { C_F }},

/* xorl<.f> RA,RB,limm 01011bbb00000111FBBB111110aaaaaa.  */
{ "xorl", 0x58070F80, 0xF8FF0FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, RB, LIMM }, { C_F }},

/* xorl<.f> 0,limm,RC 0101111000000111F111cccccc111110.  */
{ "xorl", 0x5E07703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F }},

/* xorl<.f> 0,RB,limm 01011bbb00000111FBBB111110111110.  */
{ "xorl", 0x58070FBE, 0xF8FF0FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, RB, LIMM }, { C_F }},

/* xorl<.f><.cc> 0,limm,RC 0101111011000111F111cccccc0QQQQQ.  */
{ "xorl", 0x5EC77000, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, RC }, { C_F, C_CC }},

/* xorl<.f><.cc> RB,RB,limm 01011bbb11000111FBBB1111100QQQQQ.  */
{ "xorl", 0x58C70F80, 0xF8FF0FE0, ARC_OPCODE_ARC64, ARITH, NONE, { RB, RBdup, LIMM }, { C_F, C_CC }},

/* xorl<.f> RA,limm,u6 0101111001000111F111uuuuuuaaaaaa.  */
{ "xorl", 0x5E477000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, UIMM6_20 }, { C_F }},

/* xorl<.f> 0,limm,u6 0101111001000111F111uuuuuu111110.  */
{ "xorl", 0x5E47703E, 0xFFFF703F, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F }},

/* xorl<.f><.cc> 0,limm,u6 0101111011000111F111uuuuuu1QQQQQ.  */
{ "xorl", 0x5EC77020, 0xFFFF7020, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, UIMM6_20 }, { C_F, C_CC }},

/* xorl<.f> 0,ximm,s12 0101110010000111F111ssssssSSSSSS.  */
{ "xorl", 0x5C877000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, SIMM12_20 }, { C_F }},

/* xorl<.f> 0,limm,s12 0101111010000111F111ssssssSSSSSS.  */
{ "xorl", 0x5E877000, 0xFFFF7000, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, SIMM12_20 }, { C_F }},

/* xorl<.f> RA,ximm,ximm 0101110000000111F111111100aaaaaa.  */
{ "xorl", 0x5C077F00, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, XIMM, XIMMdup }, { C_F }},

/* xorl<.f> 0,ximm,ximm 0101110000000111F111111100111110.  */
{ "xorl", 0x5C077F3E, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F }},

/* xorl<.f><.cc> 0,ximm,ximm 0101110011000111F1111111000QQQQQ.  */
{ "xorl", 0x5CC77F00, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, XIMM, XIMMdup }, { C_F, C_CC }},

/* xorl<.f> RA,limm,limm 0101111000000111F111111110aaaaaa.  */
{ "xorl", 0x5E077F80, 0xFFFF7FC0, ARC_OPCODE_ARC64, ARITH, NONE, { RA, LIMM, LIMMdup }, { C_F }},

/* xorl<.f> 0,limm,limm 0101111000000111F111111110111110.  */
{ "xorl", 0x5E077FBE, 0xFFFF7FFF, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F }},

/* xorl<.f><.cc> 0,limm,limm 0101111011000111F1111111100QQQQQ.  */
{ "xorl", 0x5EC77F80, 0xFFFF7FE0, ARC_OPCODE_ARC64, ARITH, NONE, { ZA, LIMM, LIMMdup }, { C_F, C_CC }},

/* xor_s b,b,c 01111bbbccc00111.  */
{ "xor_s", 0x00007807, 0x0000F81F, ARC_OPCODE_ARC32 | ARC_OPCODE_ARC64, LOGICAL, NONE, { RB_S, RB_Sdup, RC_S }, { 0 }},
