/* Xtensa configuration-specific ISA information.

   Copyright (c) 2003-2020 Tensilica Inc.

   Permission is hereby granted, free of charge, to any person obtaining
   a copy of this software and associated documentation files (the
   "Software"), to deal in the Software without restriction, including
   without limitation the rights to use, copy, modify, merge, publish,
   distribute, sublicense, and/or sell copies of the Software, and to
   permit persons to whom the Software is furnished to do so, subject to
   the following conditions:

   The above copyright notice and this permission notice shall be included
   in all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
   CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
   TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
   SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.  */

#include "ansidecl.h"
#include <xtensa-isa.h>
#include "xtensa-isa-internal.h"


/* Sysregs.  */

static xtensa_sysreg_internal sysregs[] = {
  { "LBEG", 0, 0 },
  { "LEND", 1, 0 },
  { "LCOUNT", 2, 0 },
  { "BR", 4, 0 },
  { "DDR", 104, 0 },
  { "CONFIGID0", 176, 0 },
  { "CONFIGID1", 208, 0 },
  { "INTERRUPT", 226, 0 },
  { "INTCLEAR", 227, 0 },
  { "CCOUNT", 234, 0 },
  { "PRID", 235, 0 },
  { "ICOUNT", 236, 0 },
  { "CCOMPARE0", 240, 0 },
  { "CCOMPARE1", 241, 0 },
  { "EPC1", 177, 0 },
  { "EPC2", 178, 0 },
  { "EPC3", 179, 0 },
  { "EPC4", 180, 0 },
  { "EPC5", 181, 0 },
  { "EPC6", 182, 0 },
  { "EPC7", 183, 0 },
  { "EXCSAVE1", 209, 0 },
  { "EXCSAVE2", 210, 0 },
  { "EXCSAVE3", 211, 0 },
  { "EXCSAVE4", 212, 0 },
  { "EXCSAVE5", 213, 0 },
  { "EXCSAVE6", 214, 0 },
  { "EXCSAVE7", 215, 0 },
  { "EPS2", 194, 0 },
  { "EPS3", 195, 0 },
  { "EPS4", 196, 0 },
  { "EPS5", 197, 0 },
  { "EPS6", 198, 0 },
  { "EPS7", 199, 0 },
  { "EXCCAUSE", 232, 0 },
  { "DEPC", 192, 0 },
  { "EXCVADDR", 238, 0 },
  { "WINDOWBASE", 72, 0 },
  { "WINDOWSTART", 73, 0 },
  { "MEMCTL", 97, 0 },
  { "SAR", 3, 0 },
  { "PS", 230, 0 },
  { "MISC0", 244, 0 },
  { "MISC1", 245, 0 },
  { "INTENABLE", 228, 0 },
  { "DBREAKA0", 144, 0 },
  { "DBREAKC0", 160, 0 },
  { "DBREAKA1", 145, 0 },
  { "DBREAKC1", 161, 0 },
  { "IBREAKA0", 128, 0 },
  { "IBREAKA1", 129, 0 },
  { "IBREAKENABLE", 96, 0 },
  { "ICOUNTLEVEL", 237, 0 },
  { "DEBUGCAUSE", 233, 0 },
  { "PREFCTL", 40, 0 },
  { "CPENABLE", 224, 0 },
  { "SCOMPARE1", 12, 0 },
  { "ATOMCTL", 99, 0 },
  { "THREADPTR", 231, 1 },
  { "AE_OVF_SAR", 240, 1 },
  { "AE_BITHEAD", 241, 1 },
  { "AE_TS_FTS_BU_BP", 242, 1 },
  { "AE_CW_SD_NO", 243, 1 },
  { "AE_CBEGIN0", 246, 1 },
  { "AE_CEND0", 247, 1 },
  { "AE_CBEGIN1", 248, 1 },
  { "AE_CEND1", 249, 1 },
  { "AE_CBEGIN2", 250, 1 },
  { "AE_CEND2", 251, 1 },
  { "AE_ZBIASV8C", -1, 1 },
  { "FCR_FSR", -1, 1 }
};

#define NUM_SYSREGS 71
#define MAX_SPECIAL_REG 245
#define MAX_USER_REG 251


/* Processor states.  */

static xtensa_state_internal states[] = {
  { "LCOUNT", 32, 0 },
  { "PC", 32, 0 },
  { "ICOUNT", 32, 0 },
  { "DDR", 32, 0 },
  { "INTERRUPT", 9, 0 },
  { "CCOUNT", 32, 0 },
  { "XTSYNC", 1, 0 },
  { "EPC1", 32, 0 },
  { "EPC2", 32, 0 },
  { "EPC3", 32, 0 },
  { "EPC4", 32, 0 },
  { "EPC5", 32, 0 },
  { "EPC6", 32, 0 },
  { "EPC7", 32, 0 },
  { "EXCSAVE1", 32, 0 },
  { "EXCSAVE2", 32, 0 },
  { "EXCSAVE3", 32, 0 },
  { "EXCSAVE4", 32, 0 },
  { "EXCSAVE5", 32, 0 },
  { "EXCSAVE6", 32, 0 },
  { "EXCSAVE7", 32, 0 },
  { "EPS2", 13, 0 },
  { "EPS3", 13, 0 },
  { "EPS4", 13, 0 },
  { "EPS5", 13, 0 },
  { "EPS6", 13, 0 },
  { "EPS7", 13, 0 },
  { "EXCCAUSE", 6, 0 },
  { "PSINTLEVEL", 4, 0 },
  { "PSUM", 1, 0 },
  { "PSWOE", 1, 0 },
  { "PSEXCM", 1, 0 },
  { "DEPC", 32, 0 },
  { "EXCVADDR", 32, 0 },
  { "WindowBase", 4, 0 },
  { "WindowStart", 16, 0 },
  { "PSCALLINC", 2, 0 },
  { "PSOWB", 4, 0 },
  { "LBEG", 32, 0 },
  { "LEND", 32, 0 },
  { "MEMCTL", 24, 0 },
  { "SAR", 6, 0 },
  { "THREADPTR", 32, 0 },
  { "MISC0", 32, 0 },
  { "MISC1", 32, 0 },
  { "InOCDMode", 1, 0 },
  { "INTENABLE", 9, 0 },
  { "DBREAKA0", 32, 0 },
  { "DBREAKC0", 8, 0 },
  { "DBREAKA1", 32, 0 },
  { "DBREAKC1", 8, 0 },
  { "IBREAKA0", 32, 0 },
  { "IBREAKA1", 32, 0 },
  { "IBREAKENABLE", 2, 0 },
  { "ICOUNTLEVEL", 4, 0 },
  { "DEBUGCAUSE", 6, 0 },
  { "DBNUM", 4, 0 },
  { "CCOMPARE0", 32, 0 },
  { "CCOMPARE1", 32, 0 },
  { "PREFCTL", 13, 0 },
  { "CPENABLE", 2, 0 },
  { "SCOMPARE1", 32, 0 },
  { "ATOMCTL", 6, 0 },
  { "AE_OVERFLOW", 1, XTENSA_STATE_IS_SHARED_OR },
  { "AE_CBEGIN0", 32, 0 },
  { "AE_CEND0", 32, 0 },
  { "AE_CBEGIN1", 32, 0 },
  { "AE_CEND1", 32, 0 },
  { "AE_CBEGIN2", 32, 0 },
  { "AE_CEND2", 32, 0 },
  { "AE_SAR", 14, 0 },
  { "AE_CWRAP", 1, 0 },
  { "AE_BITHEAD", 32, 0 },
  { "AE_BITPTR", 4, 0 },
  { "AE_BITSUSED", 4, 0 },
  { "AE_TABLESIZE", 4, 0 },
  { "AE_FIRST_TS", 4, 0 },
  { "AE_NEXTOFFSET", 27, 0 },
  { "AE_SEARCHDONE", 1, 0 },
  { "AE_ZBIASV8", 8, 0 },
  { "AE_ZBIASC8", 8, 0 },
  { "RoundMode", 2, 0 },
  { "InvalidFlag", 1, XTENSA_STATE_IS_SHARED_OR },
  { "DivZeroFlag", 1, XTENSA_STATE_IS_SHARED_OR },
  { "OverflowFlag", 1, XTENSA_STATE_IS_SHARED_OR },
  { "UnderflowFlag", 1, XTENSA_STATE_IS_SHARED_OR },
  { "InexactFlag", 1, XTENSA_STATE_IS_SHARED_OR }
};

#define NUM_STATES 87

enum xtensa_state_id {
  STATE_LCOUNT,
  STATE_PC,
  STATE_ICOUNT,
  STATE_DDR,
  STATE_INTERRUPT,
  STATE_CCOUNT,
  STATE_XTSYNC,
  STATE_EPC1,
  STATE_EPC2,
  STATE_EPC3,
  STATE_EPC4,
  STATE_EPC5,
  STATE_EPC6,
  STATE_EPC7,
  STATE_EXCSAVE1,
  STATE_EXCSAVE2,
  STATE_EXCSAVE3,
  STATE_EXCSAVE4,
  STATE_EXCSAVE5,
  STATE_EXCSAVE6,
  STATE_EXCSAVE7,
  STATE_EPS2,
  STATE_EPS3,
  STATE_EPS4,
  STATE_EPS5,
  STATE_EPS6,
  STATE_EPS7,
  STATE_EXCCAUSE,
  STATE_PSINTLEVEL,
  STATE_PSUM,
  STATE_PSWOE,
  STATE_PSEXCM,
  STATE_DEPC,
  STATE_EXCVADDR,
  STATE_WindowBase,
  STATE_WindowStart,
  STATE_PSCALLINC,
  STATE_PSOWB,
  STATE_LBEG,
  STATE_LEND,
  STATE_MEMCTL,
  STATE_SAR,
  STATE_THREADPTR,
  STATE_MISC0,
  STATE_MISC1,
  STATE_InOCDMode,
  STATE_INTENABLE,
  STATE_DBREAKA0,
  STATE_DBREAKC0,
  STATE_DBREAKA1,
  STATE_DBREAKC1,
  STATE_IBREAKA0,
  STATE_IBREAKA1,
  STATE_IBREAKENABLE,
  STATE_ICOUNTLEVEL,
  STATE_DEBUGCAUSE,
  STATE_DBNUM,
  STATE_CCOMPARE0,
  STATE_CCOMPARE1,
  STATE_PREFCTL,
  STATE_CPENABLE,
  STATE_SCOMPARE1,
  STATE_ATOMCTL,
  STATE_AE_OVERFLOW,
  STATE_AE_CBEGIN0,
  STATE_AE_CEND0,
  STATE_AE_CBEGIN1,
  STATE_AE_CEND1,
  STATE_AE_CBEGIN2,
  STATE_AE_CEND2,
  STATE_AE_SAR,
  STATE_AE_CWRAP,
  STATE_AE_BITHEAD,
  STATE_AE_BITPTR,
  STATE_AE_BITSUSED,
  STATE_AE_TABLESIZE,
  STATE_AE_FIRST_TS,
  STATE_AE_NEXTOFFSET,
  STATE_AE_SEARCHDONE,
  STATE_AE_ZBIASV8,
  STATE_AE_ZBIASC8,
  STATE_RoundMode,
  STATE_InvalidFlag,
  STATE_DivZeroFlag,
  STATE_OverflowFlag,
  STATE_UnderflowFlag,
  STATE_InexactFlag
};


/* Field definitions.  */

static unsigned
Field_t_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_s_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_r_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_op2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_op1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_op1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_op0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_op0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_n_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_n_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_m_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_m_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_sr_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sr_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_st_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_st_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_thi3_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_thi3_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_fld_inst_15_12_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_inst_15_12_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_inst_11_8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_inst_11_8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_op0_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_op0_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_t_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_r_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_r_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_op0_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_op0_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_z_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_z_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_i_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_i_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_s_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_s_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_inst16b_15_13_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_ae_fld_inst16b_15_13_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_ae_fld_inst16b_12_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_ae_fld_inst16b_12_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_ae8_slot0_31_18_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 0) >> 18);
  return tie_t;
}

static void
Field_fld_ae8_slot0_31_18_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0xfffc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae8_slot0_13_12_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_fld_ae8_slot0_13_12_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_fld_ae8_slot0_31_12_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 20) | ((insn[0] << 0) >> 12);
  return tie_t;
}

static void
Field_fld_ae8_slot0_31_12_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 12) >> 12;
  insn[0] = (insn[0] & ~0xfffff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae8_slot0_31_8_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 24) | ((insn[0] << 0) >> 8);
  return tie_t;
}

static void
Field_fld_ae8_slot0_31_8_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 8) >> 8;
  insn[0] = (insn[0] & ~0xffffff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae8_slot0_3_0_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae8_slot0_3_0_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae8_slot0_13_13_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_fld_ae8_slot0_13_13_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_fld_ae8_slot0_31_20_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 0) >> 20);
  return tie_t;
}

static void
Field_fld_ae8_slot0_31_20_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae8_slot0_7_4_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae8_slot0_7_4_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae8_slot0_31_7_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 25) | ((insn[0] << 0) >> 7);
  return tie_t;
}

static void
Field_fld_ae8_slot0_31_7_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0xffffff80) | (tie_t << 7);
}

static unsigned
Field_fld_ae8_slot0_6_0_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 25) >> 25);
  return tie_t;
}

static void
Field_fld_ae8_slot0_6_0_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f) | (tie_t << 0);
}

static unsigned
Field_fld_ae8_slot0_31_9_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 23) | ((insn[0] << 0) >> 9);
  return tie_t;
}

static void
Field_fld_ae8_slot0_31_9_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 9) >> 9;
  insn[0] = (insn[0] & ~0xfffffe00) | (tie_t << 9);
}

static unsigned
Field_fld_ae8_slot0_31_15_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 17) | ((insn[0] << 0) >> 15);
  return tie_t;
}

static void
Field_fld_ae8_slot0_31_15_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0xffff8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae8_slot0_7_5_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_fld_ae8_slot0_7_5_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_fld_ae8_slot0_13_9_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 18) >> 27);
  return tie_t;
}

static void
Field_fld_ae8_slot0_13_9_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e00) | (tie_t << 9);
}

static unsigned
Field_fld_ae8_slot0_13_4_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 18) >> 22);
  return tie_t;
}

static void
Field_fld_ae8_slot0_13_4_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae8_slot0_7_7_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_ae8_slot0_7_7_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_ae8_slot0_17_4_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 14) >> 18);
  return tie_t;
}

static void
Field_fld_ae8_slot0_17_4_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0x3fff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae8_slot0_31_19_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 0) >> 19);
  return tie_t;
}

static void
Field_fld_ae8_slot0_31_19_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0xfff80000) | (tie_t << 19);
}

static unsigned
Field_fld_ae8_slot0_8_0_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 23) >> 23);
  return tie_t;
}

static void
Field_fld_ae8_slot0_8_0_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x1ff) | (tie_t << 0);
}

static unsigned
Field_fld_ae8_slot0_17_8_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 14) >> 22);
  return tie_t;
}

static void
Field_fld_ae8_slot0_17_8_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae8_slot0_31_21_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 0) >> 21);
  return tie_t;
}

static void
Field_fld_ae8_slot0_31_21_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0xffe00000) | (tie_t << 21);
}

static unsigned
Field_fld_ae8_slot0_31_22_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 0) >> 22);
  return tie_t;
}

static void
Field_fld_ae8_slot0_31_22_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0xffc00000) | (tie_t << 22);
}

static unsigned
Field_fld_ae8_slot0_31_23_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 0) >> 23);
  return tie_t;
}

static void
Field_fld_ae8_slot0_31_23_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0xff800000) | (tie_t << 23);
}

static unsigned
Field_fld_ae8_slot1_29_20_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 2) >> 22);
  return tie_t;
}

static void
Field_fld_ae8_slot1_29_20_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae8_slot1_17_14_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  return tie_t;
}

static void
Field_fld_ae8_slot1_17_14_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_fld_ae8_slot1_29_12_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 2) >> 14);
  return tie_t;
}

static void
Field_fld_ae8_slot1_29_12_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0x3ffff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae8_slot1_17_15_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  return tie_t;
}

static void
Field_fld_ae8_slot1_17_15_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
}

static unsigned
Field_fld_ae8_slot1_7_4_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae8_slot1_7_4_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae8_slot1_29_5_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 25) | ((insn[0] << 2) >> 7);
  return tie_t;
}

static void
Field_fld_ae8_slot1_29_5_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0x3fffffe0) | (tie_t << 5);
}

static unsigned
Field_fld_ae8_slot1_4_0_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae8_slot1_4_0_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae8_slot1_29_8_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 22) | ((insn[0] << 2) >> 10);
  return tie_t;
}

static void
Field_fld_ae8_slot1_29_8_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 10) >> 10;
  insn[0] = (insn[0] & ~0x3fffff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae8_slot1_3_0_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae8_slot1_3_0_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae8_slot1_29_9_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 21) | ((insn[0] << 2) >> 11);
  return tie_t;
}

static void
Field_fld_ae8_slot1_29_9_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 11) >> 11;
  insn[0] = (insn[0] & ~0x3ffffe00) | (tie_t << 9);
}

static unsigned
Field_fld_ae8_slot1_29_13_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 17) | ((insn[0] << 2) >> 15);
  return tie_t;
}

static void
Field_fld_ae8_slot1_29_13_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0x3fffe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae8_slot1_3_3_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 28) >> 31);
  return tie_t;
}

static void
Field_fld_ae8_slot1_3_3_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8) | (tie_t << 3);
}

static unsigned
Field_fld_ae8_slot1_29_18_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 2) >> 20);
  return tie_t;
}

static void
Field_fld_ae8_slot1_29_18_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x3ffc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae8_slot1_17_8_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 14) >> 22);
  return tie_t;
}

static void
Field_fld_ae8_slot1_17_8_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae8_slot1_17_13_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae8_slot1_17_13_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae8_slot1_29_22_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 2) >> 24);
  return tie_t;
}

static void
Field_fld_ae8_slot1_29_22_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc00000) | (tie_t << 22);
}

static unsigned
Field_fld_ae8_slot1_29_23_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 2) >> 25);
  return tie_t;
}

static void
Field_fld_ae8_slot1_29_23_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x3f800000) | (tie_t << 23);
}

static unsigned
Field_fld_ae8_slot2_58_34_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 25) | ((insn[1] << 5) >> 7);
  return tie_t;
}

static void
Field_fld_ae8_slot2_58_34_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[1] = (insn[1] & ~0x7fffffc) | (tie_t << 2);
}

static unsigned
Field_fld_ae8_slot2_33_9_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | (insn[1] & 0x3);
  tie_t = (tie_t << 23) | (insn[0] >> 9);
  return tie_t;
}

static void
Field_fld_ae8_slot2_33_9_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0xfffffe00) | (tie_t << 9);
  insn[1] = (insn[1] & ~0x3) | (tie_t >> 23);
}

static unsigned
Field_fld_ae8_slot2_8_0_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 23) >> 23);
  return tie_t;
}

static void
Field_fld_ae8_slot2_8_0_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x1ff) | (tie_t << 0);
}

static unsigned
Field_fld_ae8_slot2_33_25_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | (insn[1] & 0x3);
  tie_t = (tie_t << 7) | (insn[0] >> 25);
  return tie_t;
}

static void
Field_fld_ae8_slot2_33_25_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0xfe000000) | (tie_t << 25);
  insn[1] = (insn[1] & ~0x3) | (tie_t >> 7);
}

static unsigned
Field_fld_ae8_slot2_19_15_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae8_slot2_19_15_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae8_slot2_9_0_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 22) >> 22);
  return tie_t;
}

static void
Field_fld_ae8_slot2_9_0_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff) | (tie_t << 0);
}

static unsigned
Field_fld_ae8_slot2_33_15_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | (insn[1] & 0x3);
  tie_t = (tie_t << 17) | (insn[0] >> 15);
  return tie_t;
}

static void
Field_fld_ae8_slot2_33_15_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 13) >> 13;
  insn[0] = (insn[0] & ~0xffff8000) | (tie_t << 15);
  insn[1] = (insn[1] & ~0x3) | (tie_t >> 17);
}

static unsigned
Field_fld_ae8_slot2_58_50_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[1] << 5) >> 23);
  return tie_t;
}

static void
Field_fld_ae8_slot2_58_50_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[1] = (insn[1] & ~0x7fc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae8_slot2_34_30_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | (insn[1] & 0x7);
  tie_t = (tie_t << 2) | (insn[0] >> 30);
  return tie_t;
}

static void
Field_fld_ae8_slot2_34_30_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xc0000000) | (tie_t << 30);
  insn[1] = (insn[1] & ~0x7) | (tie_t >> 2);
}

static unsigned
Field_fld_ae8_slot2_19_10_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  return tie_t;
}

static void
Field_fld_ae8_slot2_19_10_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae8_slot2_58_40_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 19) | ((insn[1] << 5) >> 13);
  return tie_t;
}

static void
Field_fld_ae8_slot2_58_40_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 13) >> 13;
  insn[1] = (insn[1] & ~0x7ffff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae8_slot2_58_35_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 24) | ((insn[1] << 5) >> 8);
  return tie_t;
}

static void
Field_fld_ae8_slot2_58_35_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 8) >> 8;
  insn[1] = (insn[1] & ~0x7fffff8) | (tie_t << 3);
}

static unsigned
Field_fld_ae8_slot2_44_35_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[1] << 19) >> 22);
  return tie_t;
}

static void
Field_fld_ae8_slot2_44_35_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[1] = (insn[1] & ~0x1ff8) | (tie_t << 3);
}

static unsigned
Field_fld_ae8_slot2_39_35_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[1] << 24) >> 27);
  return tie_t;
}

static void
Field_fld_ae8_slot2_39_35_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[1] = (insn[1] & ~0xf8) | (tie_t << 3);
}

static unsigned
Field_fld_ae_slot0_28_19_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 3) >> 22);
  return tie_t;
}

static void
Field_fld_ae_slot0_28_19_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x1ff80000) | (tie_t << 19);
}

static unsigned
Field_fld_ae_slot0_17_16_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot0_17_16_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
}

static unsigned
Field_fld_ae_slot0_12_12_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot0_12_12_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_slot0_28_15_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 3) >> 18);
  return tie_t;
}

static void
Field_fld_ae_slot0_28_15_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0x1fff8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_slot0_3_2_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot0_3_2_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_ae_slot0_17_17_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 14) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot0_17_17_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20000) | (tie_t << 17);
}

static unsigned
Field_fld_ae_slot0_12_2_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 19) >> 21);
  return tie_t;
}

static void
Field_fld_ae_slot0_12_2_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x1ffc) | (tie_t << 2);
}

static unsigned
Field_fld_ae_slot0_28_22_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 3) >> 25);
  return tie_t;
}

static void
Field_fld_ae_slot0_28_22_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc00000) | (tie_t << 22);
}

static unsigned
Field_fld_ae_slot0_20_16_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 11) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot0_20_16_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae_slot0_28_21_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 3) >> 24);
  return tie_t;
}

static void
Field_fld_ae_slot0_28_21_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x1fe00000) | (tie_t << 21);
}

static unsigned
Field_fld_ae_slot0_19_19_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot0_19_19_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_fld_ae_slot0_7_4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot0_7_4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot0_20_20_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot0_20_20_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_slot0_18_16_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  return tie_t;
}

static void
Field_fld_ae_slot0_18_16_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static unsigned
Field_fld_ae_slot0_3_3_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 28) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot0_3_3_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8) | (tie_t << 3);
}

static unsigned
Field_fld_ae_slot0_28_12_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 17) | ((insn[0] << 3) >> 15);
  return tie_t;
}

static void
Field_fld_ae_slot0_28_12_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0x1ffff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_slot0_3_0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot0_3_0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot0_28_4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 25) | ((insn[0] << 3) >> 7);
  return tie_t;
}

static void
Field_fld_ae_slot0_28_4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0x1ffffff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot0_28_14_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 3) >> 17);
  return tie_t;
}

static void
Field_fld_ae_slot0_28_14_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x1fffc000) | (tie_t << 14);
}

static unsigned
Field_fld_ae_slot0_12_8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot0_12_8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot0_7_2_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 24) >> 26);
  return tie_t;
}

static void
Field_fld_ae_slot0_7_2_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc) | (tie_t << 2);
}

static unsigned
Field_fld_ae_slot0_17_15_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  return tie_t;
}

static void
Field_fld_ae_slot0_17_15_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_slot0_28_16_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 3) >> 19);
  return tie_t;
}

static void
Field_fld_ae_slot0_28_16_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x1fff0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae_slot0_28_10_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 19) | ((insn[0] << 3) >> 13);
  return tie_t;
}

static void
Field_fld_ae_slot0_28_10_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 13) >> 13;
  insn[0] = (insn[0] & ~0x1ffffc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_slot0_8_8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot0_8_8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot0_7_0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 24) >> 24);
  return tie_t;
}

static void
Field_fld_ae_slot0_7_0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot0_28_8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 21) | ((insn[0] << 3) >> 11);
  return tie_t;
}

static void
Field_fld_ae_slot0_28_8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 11) >> 11;
  insn[0] = (insn[0] & ~0x1fffff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot0_1_0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot0_1_0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot0_3_1_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_fld_ae_slot0_3_1_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_fld_ae_slot0_9_8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot0_9_8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot0_12_0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 19) >> 19);
  return tie_t;
}

static void
Field_fld_ae_slot0_12_0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x1fff) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot0_12_10_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_fld_ae_slot0_12_10_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_slot0_17_10_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 14) >> 24);
  return tie_t;
}

static void
Field_fld_ae_slot0_17_10_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_slot0_12_6_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 19) >> 25);
  return tie_t;
}

static void
Field_fld_ae_slot0_12_6_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae_slot0_17_8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 14) >> 22);
  return tie_t;
}

static void
Field_fld_ae_slot0_17_8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot0_28_27_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 3) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot0_28_27_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000000) | (tie_t << 27);
}

static unsigned
Field_fld_ae_slot0_23_15_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 8) >> 23);
  return tie_t;
}

static void
Field_fld_ae_slot0_23_15_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0xff8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_slot0_18_13_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 13) >> 26);
  return tie_t;
}

static void
Field_fld_ae_slot0_18_13_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x7e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_slot0_11_10_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot0_11_10_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_slot0_28_17_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 3) >> 20);
  return tie_t;
}

static void
Field_fld_ae_slot0_28_17_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x1ffe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae_slot0_11_9_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_fld_ae_slot0_11_9_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_fld_ae_slot0_11_11_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot0_11_11_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_fld_ae_slot0_5_0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 26) >> 26);
  return tie_t;
}

static void
Field_fld_ae_slot0_5_0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot0_4_0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot0_4_0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot0_18_15_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot0_18_15_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_slot0_19_8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 12) >> 20);
  return tie_t;
}

static void
Field_fld_ae_slot0_19_8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot0_18_8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 13) >> 21);
  return tie_t;
}

static void
Field_fld_ae_slot0_18_8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x7ff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot0_5_4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot0_5_4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot0_4_4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot0_4_4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot0_19_15_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot0_19_15_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_slot0_19_12_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 12) >> 24);
  return tie_t;
}

static void
Field_fld_ae_slot0_19_12_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_slot0_23_19_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 8) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot0_23_19_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80000) | (tie_t << 19);
}

static unsigned
Field_fld_ae_slot0_14_13_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot0_14_13_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_slot0_11_8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot0_11_8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot0_17_13_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot0_17_13_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_slot0_23_22_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot0_23_22_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_fld_ae_slot0_17_12_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 14) >> 26);
  return tie_t;
}

static void
Field_fld_ae_slot0_17_12_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_slot0_28_24_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 3) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot0_28_24_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f000000) | (tie_t << 24);
}

static unsigned
Field_fld_ae_slot0_17_14_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot0_17_14_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_fld_ae_slot0_28_26_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 3) >> 29);
  return tie_t;
}

static void
Field_fld_ae_slot0_28_26_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c000000) | (tie_t << 26);
}

static unsigned
Field_fld_ae_slot0_23_17_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 8) >> 25);
  return tie_t;
}

static void
Field_fld_ae_slot0_23_17_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0xfe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae_slot0_9_4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 22) >> 26);
  return tie_t;
}

static void
Field_fld_ae_slot0_9_4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot0_9_9_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot0_9_9_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_fld_ae_slot0_7_3_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 24) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot0_7_3_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8) | (tie_t << 3);
}

static unsigned
Field_fld_ae_slot0_12_9_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 19) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot0_12_9_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e00) | (tie_t << 9);
}

static unsigned
Field_fld_ae_slot0_14_12_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_fld_ae_slot0_14_12_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_slot1_25_16_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 6) >> 22);
  return tie_t;
}

static void
Field_fld_ae_slot1_25_16_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae_slot1_25_12_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 6) >> 18);
  return tie_t;
}

static void
Field_fld_ae_slot1_25_12_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0x3fff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_slot1_25_17_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 6) >> 23);
  return tie_t;
}

static void
Field_fld_ae_slot1_25_17_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x3fe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae_slot1_7_4_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot1_7_4_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot1_25_1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 25) | ((insn[0] << 6) >> 7);
  return tie_t;
}

static void
Field_fld_ae_slot1_25_1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0x3fffffe) | (tie_t << 1);
}

static unsigned
Field_fld_ae_slot1_0_0_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot1_0_0_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot1_25_8_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 6) >> 14);
  return tie_t;
}

static void
Field_fld_ae_slot1_25_8_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0x3ffff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot1_3_0_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot1_3_0_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot1_25_9_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 17) | ((insn[0] << 6) >> 15);
  return tie_t;
}

static void
Field_fld_ae_slot1_25_9_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0x3fffe00) | (tie_t << 9);
}

static unsigned
Field_fld_ae_slot1_25_13_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 6) >> 19);
  return tie_t;
}

static void
Field_fld_ae_slot1_25_13_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x3ffe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_slot1_3_3_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 28) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot1_3_3_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8) | (tie_t << 3);
}

static unsigned
Field_fld_ae_slot1_3_2_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot1_3_2_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_ae_slot1_25_18_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 6) >> 24);
  return tie_t;
}

static void
Field_fld_ae_slot1_25_18_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_slot1_25_20_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 6) >> 26);
  return tie_t;
}

static void
Field_fld_ae_slot1_25_20_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_slot1_17_8_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 14) >> 22);
  return tie_t;
}

static void
Field_fld_ae_slot1_17_8_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot1_17_13_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot1_17_13_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_slot1_12_8_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot1_12_8_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot1_17_17_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 14) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot1_17_17_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20000) | (tie_t << 17);
}

static unsigned
Field_fld_ae_slot1_25_22_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 6) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot1_25_22_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00000) | (tie_t << 22);
}

static unsigned
Field_fld_ae_slot1_25_23_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 6) >> 29);
  return tie_t;
}

static void
Field_fld_ae_slot1_25_23_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x3800000) | (tie_t << 23);
}

static unsigned
Field_fld_ae_slot2_28_4_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 25) | ((insn[0] << 3) >> 7);
  return tie_t;
}

static void
Field_fld_ae_slot2_28_4_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0x1ffffff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot2_3_0_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot2_3_0_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot2_28_15_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 3) >> 18);
  return tie_t;
}

static void
Field_fld_ae_slot2_28_15_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0x1fff8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_slot2_9_5_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot2_9_5_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_slot2_28_20_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 3) >> 23);
  return tie_t;
}

static void
Field_fld_ae_slot2_28_20_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x1ff00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_slot2_9_7_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_fld_ae_slot2_9_7_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
}

static unsigned
Field_fld_ae_slot2_9_1_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 22) >> 23);
  return tie_t;
}

static void
Field_fld_ae_slot2_9_1_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x3fe) | (tie_t << 1);
}

static unsigned
Field_fld_ae_slot2_9_0_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 22) >> 22);
  return tie_t;
}

static void
Field_fld_ae_slot2_9_0_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot2_9_2_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 22) >> 24);
  return tie_t;
}

static void
Field_fld_ae_slot2_9_2_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc) | (tie_t << 2);
}

static unsigned
Field_fld_ae_slot2_28_19_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 3) >> 22);
  return tie_t;
}

static void
Field_fld_ae_slot2_28_19_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x1ff80000) | (tie_t << 19);
}

static unsigned
Field_fld_ae_slot2_14_0_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 17) >> 17);
  return tie_t;
}

static void
Field_fld_ae_slot2_14_0_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x7fff) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot2_28_17_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 3) >> 20);
  return tie_t;
}

static void
Field_fld_ae_slot2_28_17_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x1ffe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae_slot2_14_5_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 17) >> 22);
  return tie_t;
}

static void
Field_fld_ae_slot2_14_5_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x7fe0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_slot2_16_15_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot2_16_15_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_slot2_28_25_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 3) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot2_28_25_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_slot2_14_10_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot2_14_10_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_slot2_19_15_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot2_19_15_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_slot2_28_5_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 24) | ((insn[0] << 3) >> 8);
  return tie_t;
}

static void
Field_fld_ae_slot2_28_5_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 8) >> 8;
  insn[0] = (insn[0] & ~0x1fffffe0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_slot2_9_6_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot2_9_6_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_fld_ae_slot2_9_8_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot2_9_8_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot2_14_14_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot2_14_14_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_fld_ae_slot3_36_12_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | (insn[1] & 0x1f);
  tie_t = (tie_t << 20) | (insn[0] >> 12);
  return tie_t;
}

static void
Field_fld_ae_slot3_36_12_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0xfffff000) | (tie_t << 12);
  insn[1] = (insn[1] & ~0x1f) | (tie_t >> 20);
}

static unsigned
Field_fld_ae_slot3_11_0_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 20) >> 20);
  return tie_t;
}

static void
Field_fld_ae_slot3_11_0_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot3_36_30_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | (insn[1] & 0x1f);
  tie_t = (tie_t << 2) | (insn[0] >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot3_36_30_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0xc0000000) | (tie_t << 30);
  insn[1] = (insn[1] & ~0x1f) | (tie_t >> 2);
}

static unsigned
Field_fld_ae_slot3_19_0_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 20) | ((insn[0] << 12) >> 12);
  return tie_t;
}

static void
Field_fld_ae_slot3_19_0_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 12) >> 12;
  insn[0] = (insn[0] & ~0xfffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot3_9_0_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 22) >> 22);
  return tie_t;
}

static void
Field_fld_ae_slot3_9_0_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot3_14_0_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 17) >> 17);
  return tie_t;
}

static void
Field_fld_ae_slot3_14_0_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x7fff) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot3_36_25_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | (insn[1] & 0x1f);
  tie_t = (tie_t << 7) | (insn[0] >> 25);
  return tie_t;
}

static void
Field_fld_ae_slot3_36_25_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfe000000) | (tie_t << 25);
  insn[1] = (insn[1] & ~0x1f) | (tie_t >> 7);
}

static unsigned
Field_fld_ae_slot3_19_19_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot3_19_19_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_fld_ae_slot3_14_10_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot3_14_10_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_slot3_4_0_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot3_4_0_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot3_24_10_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 7) >> 17);
  return tie_t;
}

static void
Field_fld_ae_slot3_24_10_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x1fffc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_slot3_36_16_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | (insn[1] & 0x1f);
  tie_t = (tie_t << 16) | (insn[0] >> 16);
  return tie_t;
}

static void
Field_fld_ae_slot3_36_16_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 11) >> 11;
  insn[0] = (insn[0] & ~0xffff0000) | (tie_t << 16);
  insn[1] = (insn[1] & ~0x1f) | (tie_t >> 16);
}

static unsigned
Field_fld_ae_slot3_19_10_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  return tie_t;
}

static void
Field_fld_ae_slot3_19_10_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_slot3_24_20_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot3_24_20_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_slot3_36_20_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | (insn[1] & 0x1f);
  tie_t = (tie_t << 12) | (insn[0] >> 20);
  return tie_t;
}

static void
Field_fld_ae_slot3_36_20_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0xfff00000) | (tie_t << 20);
  insn[1] = (insn[1] & ~0x1f) | (tie_t >> 12);
}

static unsigned
Field_fld_ae_slot3_9_5_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot3_9_5_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_slot3_16_13_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot3_16_13_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_slot3_24_19_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 7) >> 26);
  return tie_t;
}

static void
Field_fld_ae_slot3_24_19_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x1f80000) | (tie_t << 19);
}

static unsigned
Field_fld_ae_slot3_36_22_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | (insn[1] & 0x1f);
  tie_t = (tie_t << 10) | (insn[0] >> 22);
  return tie_t;
}

static void
Field_fld_ae_slot3_36_22_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0xffc00000) | (tie_t << 22);
  insn[1] = (insn[1] & ~0x1f) | (tie_t >> 10);
}

static unsigned
Field_fld_ae_slot3_19_17_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  return tie_t;
}

static void
Field_fld_ae_slot3_19_17_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae_slot3_14_13_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot3_14_13_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_slot3_19_15_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot3_19_15_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_slot3_14_12_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_fld_ae_slot3_14_12_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_slot3_9_1_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 22) >> 23);
  return tie_t;
}

static void
Field_fld_ae_slot3_9_1_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x3fe) | (tie_t << 1);
}

static unsigned
Field_fld_ae_slot3_9_3_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 22) >> 25);
  return tie_t;
}

static void
Field_fld_ae_slot3_9_3_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x3f8) | (tie_t << 3);
}

static unsigned
Field_fld_ae_slot3_36_19_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | (insn[1] & 0x1f);
  tie_t = (tie_t << 13) | (insn[0] >> 19);
  return tie_t;
}

static void
Field_fld_ae_slot3_36_19_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xfff80000) | (tie_t << 19);
  insn[1] = (insn[1] & ~0x1f) | (tie_t >> 13);
}

static unsigned
Field_fld_ae_slot3_19_18_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot3_19_18_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae2_slot0_40_16_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | (insn[1] & 0x1ff);
  tie_t = (tie_t << 16) | (insn[0] >> 16);
  return tie_t;
}

static void
Field_fld_ae2_slot0_40_16_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0xffff0000) | (tie_t << 16);
  insn[1] = (insn[1] & ~0x1ff) | (tie_t >> 16);
}

static unsigned
Field_fld_ae2_slot0_15_12_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot0_15_12_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae2_slot0_40_19_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | (insn[1] & 0x1ff);
  tie_t = (tie_t << 13) | (insn[0] >> 19);
  return tie_t;
}

static void
Field_fld_ae2_slot0_40_19_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 10) >> 10;
  insn[0] = (insn[0] & ~0xfff80000) | (tie_t << 19);
  insn[1] = (insn[1] & ~0x1ff) | (tie_t >> 13);
}

static unsigned
Field_fld_ae2_slot0_17_17_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 14) >> 31);
  return tie_t;
}

static void
Field_fld_ae2_slot0_17_17_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20000) | (tie_t << 17);
}

static unsigned
Field_fld_ae2_slot0_15_8_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_fld_ae2_slot0_15_8_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae2_slot0_3_0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot0_3_0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot0_40_17_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | (insn[1] & 0x1ff);
  tie_t = (tie_t << 15) | (insn[0] >> 17);
  return tie_t;
}

static void
Field_fld_ae2_slot0_40_17_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 8) >> 8;
  insn[0] = (insn[0] & ~0xfffe0000) | (tie_t << 17);
  insn[1] = (insn[1] & ~0x1ff) | (tie_t >> 15);
}

static unsigned
Field_fld_ae2_slot0_40_21_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | (insn[1] & 0x1ff);
  tie_t = (tie_t << 11) | (insn[0] >> 21);
  return tie_t;
}

static void
Field_fld_ae2_slot0_40_21_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 12) >> 12;
  insn[0] = (insn[0] & ~0xffe00000) | (tie_t << 21);
  insn[1] = (insn[1] & ~0x1ff) | (tie_t >> 11);
}

static unsigned
Field_fld_ae2_slot0_18_18_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  return tie_t;
}

static void
Field_fld_ae2_slot0_18_18_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_fld_ae2_slot0_7_4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot0_7_4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae2_slot0_15_0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 16) >> 16);
  return tie_t;
}

static void
Field_fld_ae2_slot0_15_0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot0_15_13_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_fld_ae2_slot0_15_13_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae2_slot0_11_4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_fld_ae2_slot0_11_4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae2_slot0_11_9_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_fld_ae2_slot0_11_9_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_fld_ae2_slot0_40_27_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | (insn[1] & 0x1ff);
  tie_t = (tie_t << 5) | (insn[0] >> 27);
  return tie_t;
}

static void
Field_fld_ae2_slot0_40_27_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0xf8000000) | (tie_t << 27);
  insn[1] = (insn[1] & ~0x1ff) | (tie_t >> 5);
}

static unsigned
Field_fld_ae2_slot0_11_8_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot0_11_8_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae2_slot0_14_13_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  return tie_t;
}

static void
Field_fld_ae2_slot0_14_13_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae2_slot0_7_7_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_ae2_slot0_7_7_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_ae2_slot0_7_6_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_ae2_slot0_7_6_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae2_slot0_40_18_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | (insn[1] & 0x1ff);
  tie_t = (tie_t << 14) | (insn[0] >> 18);
  return tie_t;
}

static void
Field_fld_ae2_slot0_40_18_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 9) >> 9;
  insn[0] = (insn[0] & ~0xfffc0000) | (tie_t << 18);
  insn[1] = (insn[1] & ~0x1ff) | (tie_t >> 14);
}

static unsigned
Field_fld_ae2_slot0_15_15_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_fld_ae2_slot0_15_15_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae2_slot0_12_0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 19) >> 19);
  return tie_t;
}

static void
Field_fld_ae2_slot0_12_0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x1fff) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot0_12_4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 19) >> 23);
  return tie_t;
}

static void
Field_fld_ae2_slot0_12_4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x1ff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae2_slot0_12_2_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 19) >> 21);
  return tie_t;
}

static void
Field_fld_ae2_slot0_12_2_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x1ffc) | (tie_t << 2);
}

static unsigned
Field_fld_ae2_slot0_14_8_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 17) >> 25);
  return tie_t;
}

static void
Field_fld_ae2_slot0_14_8_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae2_slot0_12_8_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae2_slot0_12_8_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae2_slot0_40_24_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | (insn[1] & 0x1ff);
  tie_t = (tie_t << 8) | (insn[0] >> 24);
  return tie_t;
}

static void
Field_fld_ae2_slot0_40_24_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0xff000000) | (tie_t << 24);
  insn[1] = (insn[1] & ~0x1ff) | (tie_t >> 8);
}

static unsigned
Field_fld_ae2_slot0_1_0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae2_slot0_1_0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot0_0_0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_ae2_slot0_0_0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot0_7_0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 24) >> 24);
  return tie_t;
}

static void
Field_fld_ae2_slot0_7_0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot0_15_4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 16) >> 20);
  return tie_t;
}

static void
Field_fld_ae2_slot0_15_4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae2_slot0_17_13_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae2_slot0_17_13_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae2_slot0_9_8_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae2_slot0_9_8_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae2_slot0_8_8_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_fld_ae2_slot0_8_8_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_fld_ae2_slot0_40_25_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | (insn[1] & 0x1ff);
  tie_t = (tie_t << 7) | (insn[0] >> 25);
  return tie_t;
}

static void
Field_fld_ae2_slot0_40_25_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xfe000000) | (tie_t << 25);
  insn[1] = (insn[1] & ~0x1ff) | (tie_t >> 7);
}

static unsigned
Field_fld_ae2_slot0_23_19_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 8) >> 27);
  return tie_t;
}

static void
Field_fld_ae2_slot0_23_19_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80000) | (tie_t << 19);
}

static unsigned
Field_fld_ae2_slot0_18_15_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot0_18_15_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_fld_ae2_slot0_40_26_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | (insn[1] & 0x1ff);
  tie_t = (tie_t << 6) | (insn[0] >> 26);
  return tie_t;
}

static void
Field_fld_ae2_slot0_40_26_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0xfc000000) | (tie_t << 26);
  insn[1] = (insn[1] & ~0x1ff) | (tie_t >> 6);
}

static unsigned
Field_fld_ae2_slot0_23_18_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  return tie_t;
}

static void
Field_fld_ae2_slot0_23_18_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae2_slot0_18_17_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 13) >> 30);
  return tie_t;
}

static void
Field_fld_ae2_slot0_18_17_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60000) | (tie_t << 17);
}

static unsigned
Field_fld_ae2_slot0_40_23_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | (insn[1] & 0x1ff);
  tie_t = (tie_t << 9) | (insn[0] >> 23);
  return tie_t;
}

static void
Field_fld_ae2_slot0_40_23_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xff800000) | (tie_t << 23);
  insn[1] = (insn[1] & ~0x1ff) | (tie_t >> 9);
}

static unsigned
Field_fld_ae2_slot1_36_20_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | (insn[1] & 0x1f);
  tie_t = (tie_t << 12) | (insn[0] >> 20);
  return tie_t;
}

static void
Field_fld_ae2_slot1_36_20_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0xfff00000) | (tie_t << 20);
  insn[1] = (insn[1] & ~0x1f) | (tie_t >> 12);
}

static unsigned
Field_fld_ae2_slot1_14_12_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_fld_ae2_slot1_14_12_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_fld_ae2_slot1_9_9_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_fld_ae2_slot1_9_9_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_fld_ae2_slot1_36_12_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | (insn[1] & 0x1f);
  tie_t = (tie_t << 20) | (insn[0] >> 12);
  return tie_t;
}

static void
Field_fld_ae2_slot1_36_12_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0xfffff000) | (tie_t << 12);
  insn[1] = (insn[1] & ~0x1f) | (tie_t >> 20);
}

static unsigned
Field_fld_ae2_slot1_7_4_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot1_7_4_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae2_slot1_11_0_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 20) >> 20);
  return tie_t;
}

static void
Field_fld_ae2_slot1_11_0_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot1_11_8_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot1_11_8_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae2_slot1_3_0_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot1_3_0_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot1_36_16_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | (insn[1] & 0x1f);
  tie_t = (tie_t << 16) | (insn[0] >> 16);
  return tie_t;
}

static void
Field_fld_ae2_slot1_36_16_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 11) >> 11;
  insn[0] = (insn[0] & ~0xffff0000) | (tie_t << 16);
  insn[1] = (insn[1] & ~0x1f) | (tie_t >> 16);
}

static unsigned
Field_fld_ae2_slot1_14_8_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 17) >> 25);
  return tie_t;
}

static void
Field_fld_ae2_slot1_14_8_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae2_slot1_36_17_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | (insn[1] & 0x1f);
  tie_t = (tie_t << 15) | (insn[0] >> 17);
  return tie_t;
}

static void
Field_fld_ae2_slot1_36_17_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 12) >> 12;
  insn[0] = (insn[0] & ~0xfffe0000) | (tie_t << 17);
  insn[1] = (insn[1] & ~0x1f) | (tie_t >> 15);
}

static unsigned
Field_fld_ae2_slot1_0_0_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_ae2_slot1_0_0_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot1_14_14_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  return tie_t;
}

static void
Field_fld_ae2_slot1_14_14_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_fld_ae2_slot1_9_8_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae2_slot1_9_8_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae2_slot1_3_3_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 28) >> 31);
  return tie_t;
}

static void
Field_fld_ae2_slot1_3_3_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8) | (tie_t << 3);
}

static unsigned
Field_fld_ae2_slot1_11_10_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_fld_ae2_slot1_11_10_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae2_slot1_36_14_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | (insn[1] & 0x1f);
  tie_t = (tie_t << 18) | (insn[0] >> 14);
  return tie_t;
}

static void
Field_fld_ae2_slot1_36_14_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 9) >> 9;
  insn[0] = (insn[0] & ~0xffffc000) | (tie_t << 14);
  insn[1] = (insn[1] & ~0x1f) | (tie_t >> 18);
}

static unsigned
Field_fld_ae2_slot1_3_2_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae2_slot1_3_2_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_ae2_slot1_14_11_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 17) >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot1_14_11_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x7800) | (tie_t << 11);
}

static unsigned
Field_fld_ae2_slot1_14_10_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae2_slot1_14_10_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae2_slot1_36_18_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | (insn[1] & 0x1f);
  tie_t = (tie_t << 14) | (insn[0] >> 18);
  return tie_t;
}

static void
Field_fld_ae2_slot1_36_18_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 13) >> 13;
  insn[0] = (insn[0] & ~0xfffc0000) | (tie_t << 18);
  insn[1] = (insn[1] & ~0x1f) | (tie_t >> 14);
}

static unsigned
Field_fld_ae2_slot1_36_22_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | (insn[1] & 0x1f);
  tie_t = (tie_t << 10) | (insn[0] >> 22);
  return tie_t;
}

static void
Field_fld_ae2_slot1_36_22_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0xffc00000) | (tie_t << 22);
  insn[1] = (insn[1] & ~0x1f) | (tie_t >> 10);
}

static unsigned
Field_fld_ae2_slot1_36_23_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | (insn[1] & 0x1f);
  tie_t = (tie_t << 9) | (insn[0] >> 23);
  return tie_t;
}

static void
Field_fld_ae2_slot1_36_23_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0xff800000) | (tie_t << 23);
  insn[1] = (insn[1] & ~0x1f) | (tie_t >> 9);
}

static unsigned
Field_fld_ae2_slot1_36_15_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | (insn[1] & 0x1f);
  tie_t = (tie_t << 17) | (insn[0] >> 15);
  return tie_t;
}

static void
Field_fld_ae2_slot1_36_15_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 10) >> 10;
  insn[0] = (insn[0] & ~0xffff8000) | (tie_t << 15);
  insn[1] = (insn[1] & ~0x1f) | (tie_t >> 17);
}

static unsigned
Field_fld_ae2_slot1_3_1_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_fld_ae2_slot1_3_1_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_fld_ae2_slot2_42_18_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | (insn[1] & 0x7ff);
  tie_t = (tie_t << 14) | (insn[0] >> 18);
  return tie_t;
}

static void
Field_fld_ae2_slot2_42_18_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0xfffc0000) | (tie_t << 18);
  insn[1] = (insn[1] & ~0x7ff) | (tie_t >> 14);
}

static unsigned
Field_fld_ae2_slot2_17_0_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 14) >> 14);
  return tie_t;
}

static void
Field_fld_ae2_slot2_17_0_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0x3ffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot2_42_30_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | (insn[1] & 0x7ff);
  tie_t = (tie_t << 2) | (insn[0] >> 30);
  return tie_t;
}

static void
Field_fld_ae2_slot2_42_30_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0xc0000000) | (tie_t << 30);
  insn[1] = (insn[1] & ~0x7ff) | (tie_t >> 2);
}

static unsigned
Field_fld_ae2_slot2_24_5_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 20) | ((insn[0] << 7) >> 12);
  return tie_t;
}

static void
Field_fld_ae2_slot2_24_5_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 12) >> 12;
  insn[0] = (insn[0] & ~0x1ffffe0) | (tie_t << 5);
}

static unsigned
Field_fld_ae2_slot2_24_10_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 7) >> 17);
  return tie_t;
}

static void
Field_fld_ae2_slot2_24_10_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x1fffc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae2_slot2_4_0_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae2_slot2_4_0_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot2_17_17_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 14) >> 31);
  return tie_t;
}

static void
Field_fld_ae2_slot2_17_17_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20000) | (tie_t << 17);
}

static unsigned
Field_fld_ae2_slot2_14_10_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae2_slot2_14_10_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae2_slot2_42_20_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | (insn[1] & 0x7ff);
  tie_t = (tie_t << 12) | (insn[0] >> 20);
  return tie_t;
}

static void
Field_fld_ae2_slot2_42_20_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 9) >> 9;
  insn[0] = (insn[0] & ~0xfff00000) | (tie_t << 20);
  insn[1] = (insn[1] & ~0x7ff) | (tie_t >> 12);
}

static unsigned
Field_fld_ae2_slot2_24_15_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 7) >> 22);
  return tie_t;
}

static void
Field_fld_ae2_slot2_24_15_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x1ff8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae2_slot2_9_5_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae2_slot2_9_5_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae2_slot2_19_15_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae2_slot2_19_15_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae2_slot2_24_20_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae2_slot2_24_20_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae2_slot2_17_10_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 14) >> 24);
  return tie_t;
}

static void
Field_fld_ae2_slot2_17_10_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae2_slot2_42_25_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | (insn[1] & 0x7ff);
  tie_t = (tie_t << 7) | (insn[0] >> 25);
  return tie_t;
}

static void
Field_fld_ae2_slot2_42_25_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xfe000000) | (tie_t << 25);
  insn[1] = (insn[1] & ~0x7ff) | (tie_t >> 7);
}

static unsigned
Field_fld_ae2_slot2_19_10_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 12) >> 22);
  return tie_t;
}

static void
Field_fld_ae2_slot2_19_10_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0xffc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae2_slot2_42_26_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | (insn[1] & 0x7ff);
  tie_t = (tie_t << 6) | (insn[0] >> 26);
  return tie_t;
}

static void
Field_fld_ae2_slot2_42_26_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0xfc000000) | (tie_t << 26);
  insn[1] = (insn[1] & ~0x7ff) | (tie_t >> 6);
}

static unsigned
Field_fld_ae2_slot2_42_28_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | (insn[1] & 0x7ff);
  tie_t = (tie_t << 4) | (insn[0] >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot2_42_28_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0xf0000000) | (tie_t << 28);
  insn[1] = (insn[1] & ~0x7ff) | (tie_t >> 4);
}

static unsigned
Field_fld_ae2_slot2_24_9_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 7) >> 16);
  return tie_t;
}

static void
Field_fld_ae2_slot2_24_9_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0x1fffe00) | (tie_t << 9);
}

static unsigned
Field_fld_ae2_slot2_19_18_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  return tie_t;
}

static void
Field_fld_ae2_slot2_19_18_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae2_slot2_19_9_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 12) >> 21);
  return tie_t;
}

static void
Field_fld_ae2_slot2_19_9_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0xffe00) | (tie_t << 9);
}

static unsigned
Field_fld_ae2_slot2_17_15_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  return tie_t;
}

static void
Field_fld_ae2_slot2_17_15_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
}

static unsigned
Field_fld_ae3_slot0_32_17_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | (insn[1] & 0x1);
  tie_t = (tie_t << 15) | (insn[0] >> 17);
  return tie_t;
}

static void
Field_fld_ae3_slot0_32_17_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xfffe0000) | (tie_t << 17);
  insn[1] = (insn[1] & ~0x1) | (tie_t >> 15);
}

static unsigned
Field_fld_ae3_slot0_13_13_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  return tie_t;
}

static void
Field_fld_ae3_slot0_13_13_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_fld_ae3_slot0_32_12_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | (insn[1] & 0x1);
  tie_t = (tie_t << 20) | (insn[0] >> 12);
  return tie_t;
}

static void
Field_fld_ae3_slot0_32_12_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 11) >> 11;
  insn[0] = (insn[0] & ~0xfffff000) | (tie_t << 12);
  insn[1] = (insn[1] & ~0x1) | (tie_t >> 20);
}

static unsigned
Field_fld_ae3_slot0_32_18_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | (insn[1] & 0x1);
  tie_t = (tie_t << 14) | (insn[0] >> 18);
  return tie_t;
}

static void
Field_fld_ae3_slot0_32_18_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0xfffc0000) | (tie_t << 18);
  insn[1] = (insn[1] & ~0x1) | (tie_t >> 14);
}

static unsigned
Field_fld_ae3_slot0_32_8_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | (insn[1] & 0x1);
  tie_t = (tie_t << 24) | (insn[0] >> 8);
  return tie_t;
}

static void
Field_fld_ae3_slot0_32_8_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0xffffff00) | (tie_t << 8);
  insn[1] = (insn[1] & ~0x1) | (tie_t >> 24);
}

static unsigned
Field_fld_ae3_slot0_7_4_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae3_slot0_7_4_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae3_slot0_32_20_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | (insn[1] & 0x1);
  tie_t = (tie_t << 12) | (insn[0] >> 20);
  return tie_t;
}

static void
Field_fld_ae3_slot0_32_20_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0xfff00000) | (tie_t << 20);
  insn[1] = (insn[1] & ~0x1) | (tie_t >> 12);
}

static unsigned
Field_fld_ae3_slot0_32_16_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | (insn[1] & 0x1);
  tie_t = (tie_t << 16) | (insn[0] >> 16);
  return tie_t;
}

static void
Field_fld_ae3_slot0_32_16_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0xffff0000) | (tie_t << 16);
  insn[1] = (insn[1] & ~0x1) | (tie_t >> 16);
}

static unsigned
Field_fld_ae3_slot0_3_0_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae3_slot0_3_0_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae3_slot0_7_0_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 24) >> 24);
  return tie_t;
}

static void
Field_fld_ae3_slot0_7_0_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff) | (tie_t << 0);
}

static unsigned
Field_fld_ae3_slot0_32_11_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | (insn[1] & 0x1);
  tie_t = (tie_t << 21) | (insn[0] >> 11);
  return tie_t;
}

static void
Field_fld_ae3_slot0_32_11_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 10) >> 10;
  insn[0] = (insn[0] & ~0xfffff800) | (tie_t << 11);
  insn[1] = (insn[1] & ~0x1) | (tie_t >> 21);
}

static unsigned
Field_fld_ae3_slot0_9_8_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae3_slot0_9_8_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae3_slot0_32_13_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | (insn[1] & 0x1);
  tie_t = (tie_t << 19) | (insn[0] >> 13);
  return tie_t;
}

static void
Field_fld_ae3_slot0_32_13_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 12) >> 12;
  insn[0] = (insn[0] & ~0xffffe000) | (tie_t << 13);
  insn[1] = (insn[1] & ~0x1) | (tie_t >> 19);
}

static unsigned
Field_fld_ae3_slot0_8_8_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_fld_ae3_slot0_8_8_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_fld_ae3_slot0_32_27_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | (insn[1] & 0x1);
  tie_t = (tie_t << 5) | (insn[0] >> 27);
  return tie_t;
}

static void
Field_fld_ae3_slot0_32_27_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xf8000000) | (tie_t << 27);
  insn[1] = (insn[1] & ~0x1) | (tie_t >> 5);
}

static unsigned
Field_fld_ae3_slot0_11_4_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_fld_ae3_slot0_11_4_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae3_slot0_11_11_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_fld_ae3_slot0_11_11_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_fld_ae3_slot0_11_8_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae3_slot0_11_8_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae3_slot0_32_15_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | (insn[1] & 0x1);
  tie_t = (tie_t << 17) | (insn[0] >> 15);
  return tie_t;
}

static void
Field_fld_ae3_slot0_32_15_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xffff8000) | (tie_t << 15);
  insn[1] = (insn[1] & ~0x1) | (tie_t >> 17);
}

static unsigned
Field_fld_ae3_slot0_1_0_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae3_slot0_1_0_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae3_slot0_3_3_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 28) >> 31);
  return tie_t;
}

static void
Field_fld_ae3_slot0_3_3_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8) | (tie_t << 3);
}

static unsigned
Field_fld_ae3_slot0_3_2_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae3_slot0_3_2_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_ae3_slot0_7_2_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 24) >> 26);
  return tie_t;
}

static void
Field_fld_ae3_slot0_7_2_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc) | (tie_t << 2);
}

static unsigned
Field_fld_ae3_slot0_12_8_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae3_slot0_12_8_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae3_slot0_7_6_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_ae3_slot0_7_6_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae3_slot0_5_0_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 26) >> 26);
  return tie_t;
}

static void
Field_fld_ae3_slot0_5_0_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f) | (tie_t << 0);
}

static unsigned
Field_fld_ae3_slot0_4_0_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae3_slot0_4_0_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae3_slot0_32_14_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | (insn[1] & 0x1);
  tie_t = (tie_t << 18) | (insn[0] >> 14);
  return tie_t;
}

static void
Field_fld_ae3_slot0_32_14_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 13) >> 13;
  insn[0] = (insn[0] & ~0xffffc000) | (tie_t << 14);
  insn[1] = (insn[1] & ~0x1) | (tie_t >> 18);
}

static unsigned
Field_fld_ae3_slot0_5_4_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae3_slot0_5_4_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae3_slot0_4_4_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_fld_ae3_slot0_4_4_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_fld_ae3_slot0_12_12_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_fld_ae3_slot0_12_12_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_ae3_slot0_13_8_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 18) >> 26);
  return tie_t;
}

static void
Field_fld_ae3_slot0_13_8_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae3_slot0_9_4_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 22) >> 26);
  return tie_t;
}

static void
Field_fld_ae3_slot0_9_4_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f0) | (tie_t << 4);
}

static unsigned
Field_fld_ae3_slot1_23_16_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 8) >> 24);
  return tie_t;
}

static void
Field_fld_ae3_slot1_23_16_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae3_slot1_23_12_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 8) >> 20);
  return tie_t;
}

static void
Field_fld_ae3_slot1_23_12_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae3_slot1_23_17_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 8) >> 25);
  return tie_t;
}

static void
Field_fld_ae3_slot1_23_17_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0xfe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae3_slot1_7_4_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae3_slot1_7_4_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae3_slot1_23_0_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 24) | ((insn[0] << 8) >> 8);
  return tie_t;
}

static void
Field_fld_ae3_slot1_23_0_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 8) >> 8;
  insn[0] = (insn[0] & ~0xffffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae3_slot1_23_8_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 8) >> 16);
  return tie_t;
}

static void
Field_fld_ae3_slot1_23_8_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae3_slot1_3_0_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae3_slot1_3_0_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae3_slot1_23_11_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 8) >> 19);
  return tie_t;
}

static void
Field_fld_ae3_slot1_23_11_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0xfff800) | (tie_t << 11);
}

static unsigned
Field_fld_ae3_slot1_9_8_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae3_slot1_9_8_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae3_slot1_23_13_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 8) >> 21);
  return tie_t;
}

static void
Field_fld_ae3_slot1_23_13_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0xffe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae3_slot1_23_15_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 8) >> 23);
  return tie_t;
}

static void
Field_fld_ae3_slot1_23_15_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0xff8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae3_slot1_3_3_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 28) >> 31);
  return tie_t;
}

static void
Field_fld_ae3_slot1_3_3_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8) | (tie_t << 3);
}

static unsigned
Field_fld_ae3_slot1_3_2_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae3_slot1_3_2_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_ae3_slot1_23_19_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 8) >> 27);
  return tie_t;
}

static void
Field_fld_ae3_slot1_23_19_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80000) | (tie_t << 19);
}

static unsigned
Field_fld_ae3_slot1_3_1_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_fld_ae3_slot1_3_1_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_fld_ae3_slot1_23_9_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 8) >> 17);
  return tie_t;
}

static void
Field_fld_ae3_slot1_23_9_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0xfffe00) | (tie_t << 9);
}

static unsigned
Field_fld_ae3_slot1_23_6_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 8) >> 14);
  return tie_t;
}

static void
Field_fld_ae3_slot1_23_6_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xffffc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae5_slot0_29_16_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 2) >> 18);
  return tie_t;
}

static void
Field_fld_ae5_slot0_29_16_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0x3fff0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae5_slot0_29_12_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 2) >> 14);
  return tie_t;
}

static void
Field_fld_ae5_slot0_29_12_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0x3ffff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae5_slot0_29_18_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 2) >> 20);
  return tie_t;
}

static void
Field_fld_ae5_slot0_29_18_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x3ffc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae5_slot0_29_5_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 25) | ((insn[0] << 2) >> 7);
  return tie_t;
}

static void
Field_fld_ae5_slot0_29_5_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0x3fffffe0) | (tie_t << 5);
}

static unsigned
Field_fld_ae5_slot0_4_4_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_fld_ae5_slot0_4_4_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_fld_ae5_slot0_29_17_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 2) >> 19);
  return tie_t;
}

static void
Field_fld_ae5_slot0_29_17_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x3ffe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae5_slot0_29_20_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 2) >> 22);
  return tie_t;
}

static void
Field_fld_ae5_slot0_29_20_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae5_slot0_7_4_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae5_slot0_7_4_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae5_slot0_3_0_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae5_slot0_3_0_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae5_slot0_4_0_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae5_slot0_4_0_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae5_slot0_29_8_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 22) | ((insn[0] << 2) >> 10);
  return tie_t;
}

static void
Field_fld_ae5_slot0_29_8_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 10) >> 10;
  insn[0] = (insn[0] & ~0x3fffff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae5_slot0_2_0_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae5_slot0_2_0_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae5_slot0_29_13_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 17) | ((insn[0] << 2) >> 15);
  return tie_t;
}

static void
Field_fld_ae5_slot0_29_13_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0x3fffe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae5_slot0_1_0_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae5_slot0_1_0_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae5_slot0_29_27_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 2) >> 29);
  return tie_t;
}

static void
Field_fld_ae5_slot0_29_27_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38000000) | (tie_t << 27);
}

static unsigned
Field_fld_ae5_slot0_11_4_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_fld_ae5_slot0_11_4_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae5_slot0_11_9_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_fld_ae5_slot0_11_9_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_fld_ae5_slot0_11_8_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae5_slot0_11_8_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae5_slot0_29_15_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 2) >> 17);
  return tie_t;
}

static void
Field_fld_ae5_slot0_29_15_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x3fff8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae5_slot0_3_2_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae5_slot0_3_2_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_ae5_slot0_1_1_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 30) >> 31);
  return tie_t;
}

static void
Field_fld_ae5_slot0_1_1_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2) | (tie_t << 1);
}

static unsigned
Field_fld_ae5_slot0_12_8_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae5_slot0_12_8_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae5_slot0_29_6_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 24) | ((insn[0] << 2) >> 8);
  return tie_t;
}

static void
Field_fld_ae5_slot0_29_6_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 8) >> 8;
  insn[0] = (insn[0] & ~0x3fffffc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae5_slot0_12_9_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 19) >> 28);
  return tie_t;
}

static void
Field_fld_ae5_slot0_12_9_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e00) | (tie_t << 9);
}

static unsigned
Field_fld_ae5_slot0_29_19_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 2) >> 21);
  return tie_t;
}

static void
Field_fld_ae5_slot0_29_19_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x3ff80000) | (tie_t << 19);
}

static unsigned
Field_fld_ae5_slot0_7_0_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 24) >> 24);
  return tie_t;
}

static void
Field_fld_ae5_slot0_7_0_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff) | (tie_t << 0);
}

static unsigned
Field_fld_ae5_slot0_12_4_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 19) >> 23);
  return tie_t;
}

static void
Field_fld_ae5_slot0_12_4_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x1ff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae5_slot0_12_6_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 19) >> 25);
  return tie_t;
}

static void
Field_fld_ae5_slot0_12_6_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae5_slot0_7_7_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_ae5_slot0_7_7_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_ae5_slot0_12_10_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_fld_ae5_slot0_12_10_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae5_slot0_11_10_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_fld_ae5_slot0_11_10_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae5_slot0_8_8_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_fld_ae5_slot0_8_8_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_fld_ae5_slot1_1_0_Slot_ae5_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae5_slot1_1_0_Slot_ae5_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae5_slot2_24_0_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 25) | ((insn[0] << 7) >> 7);
  return tie_t;
}

static void
Field_fld_ae5_slot2_24_0_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0x1ffffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae5_slot2_24_20_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae5_slot2_24_20_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae5_slot2_14_5_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 17) >> 22);
  return tie_t;
}

static void
Field_fld_ae5_slot2_14_5_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x7fe0) | (tie_t << 5);
}

static unsigned
Field_fld_ae5_slot2_9_7_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_fld_ae5_slot2_9_7_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
}

static unsigned
Field_fld_ae5_slot2_9_0_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 22) >> 22);
  return tie_t;
}

static void
Field_fld_ae5_slot2_9_0_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff) | (tie_t << 0);
}

static unsigned
Field_fld_ae5_slot2_24_17_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 7) >> 24);
  return tie_t;
}

static void
Field_fld_ae5_slot2_24_17_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x1fe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae5_slot2_9_5_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae5_slot2_9_5_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae5_slot2_14_10_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae5_slot2_14_10_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae5_slot2_24_15_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 7) >> 22);
  return tie_t;
}

static void
Field_fld_ae5_slot2_24_15_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x1ff8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae5_slot2_14_14_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  return tie_t;
}

static void
Field_fld_ae5_slot2_14_14_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_fld_ae5_slot2_4_0_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae5_slot2_4_0_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae6_slot0_29_5_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 25) | ((insn[0] << 2) >> 7);
  return tie_t;
}

static void
Field_fld_ae6_slot0_29_5_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0x3fffffe0) | (tie_t << 5);
}

static unsigned
Field_fld_ae6_slot0_4_0_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae6_slot0_4_0_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae6_slot0_29_15_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 2) >> 17);
  return tie_t;
}

static void
Field_fld_ae6_slot0_29_15_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x3fff8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae6_slot0_9_9_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_fld_ae6_slot0_9_9_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_fld_ae6_slot0_4_4_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_fld_ae6_slot0_4_4_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_fld_ae6_slot0_9_8_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae6_slot0_9_8_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae6_slot0_29_18_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 2) >> 20);
  return tie_t;
}

static void
Field_fld_ae6_slot0_29_18_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x3ffc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae6_slot0_7_4_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae6_slot0_7_4_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae6_slot0_29_10_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 20) | ((insn[0] << 2) >> 12);
  return tie_t;
}

static void
Field_fld_ae6_slot0_29_10_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 12) >> 12;
  insn[0] = (insn[0] & ~0x3ffffc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae6_slot0_29_20_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 2) >> 22);
  return tie_t;
}

static void
Field_fld_ae6_slot0_29_20_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae6_slot0_29_13_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 17) | ((insn[0] << 2) >> 15);
  return tie_t;
}

static void
Field_fld_ae6_slot0_29_13_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0x3fffe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae6_slot0_10_10_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_fld_ae6_slot0_10_10_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_fld_ae6_slot0_29_14_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 2) >> 16);
  return tie_t;
}

static void
Field_fld_ae6_slot0_29_14_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0x3fffc000) | (tie_t << 14);
}

static unsigned
Field_fld_ae6_slot0_15_15_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_fld_ae6_slot0_15_15_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae6_slot1_27_12_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 4) >> 16);
  return tie_t;
}

static void
Field_fld_ae6_slot1_27_12_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae6_slot1_27_3_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 25) | ((insn[0] << 4) >> 7);
  return tie_t;
}

static void
Field_fld_ae6_slot1_27_3_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0xffffff8) | (tie_t << 3);
}

static unsigned
Field_fld_ae6_slot1_2_0_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae6_slot1_2_0_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae6_slot1_27_15_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 4) >> 19);
  return tie_t;
}

static void
Field_fld_ae6_slot1_27_15_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0xfff8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae6_slot1_9_8_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae6_slot1_9_8_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae6_slot1_9_7_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_fld_ae6_slot1_9_7_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
}

static unsigned
Field_fld_ae6_slot1_27_20_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 4) >> 24);
  return tie_t;
}

static void
Field_fld_ae6_slot1_27_20_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae6_slot1_27_6_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 22) | ((insn[0] << 4) >> 10);
  return tie_t;
}

static void
Field_fld_ae6_slot1_27_6_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 10) >> 10;
  insn[0] = (insn[0] & ~0xfffffc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae6_slot1_9_6_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 22) >> 28);
  return tie_t;
}

static void
Field_fld_ae6_slot1_9_6_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0) | (tie_t << 6);
}

static unsigned
Field_fld_ae6_slot1_14_14_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  return tie_t;
}

static void
Field_fld_ae6_slot1_14_14_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_fld_ae6_slot1_9_5_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae6_slot1_9_5_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae6_slot1_9_9_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_fld_ae6_slot1_9_9_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_fld_ae6_slot1_27_21_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 4) >> 25);
  return tie_t;
}

static void
Field_fld_ae6_slot1_27_21_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0xfe00000) | (tie_t << 21);
}

static unsigned
Field_fld_ae6_slot2_24_0_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 25) | ((insn[0] << 7) >> 7);
  return tie_t;
}

static void
Field_fld_ae6_slot2_24_0_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0x1ffffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae6_slot2_24_15_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 7) >> 22);
  return tie_t;
}

static void
Field_fld_ae6_slot2_24_15_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x1ff8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae6_slot2_9_5_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae6_slot2_9_5_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae6_slot2_24_14_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 7) >> 21);
  return tie_t;
}

static void
Field_fld_ae6_slot2_24_14_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x1ffc000) | (tie_t << 14);
}

static unsigned
Field_fld_ae6_slot2_11_10_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_fld_ae6_slot2_11_10_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae6_slot2_10_10_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_fld_ae6_slot2_10_10_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_fld_ae6_slot2_24_10_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 7) >> 17);
  return tie_t;
}

static void
Field_fld_ae6_slot2_24_10_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x1fffc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae6_slot2_4_2_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_fld_ae6_slot2_4_2_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
}

static unsigned
Field_fld_ae6_slot2_24_20_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae6_slot2_24_20_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae6_slot3_37_13_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | (insn[1] & 0x3f);
  tie_t = (tie_t << 19) | (insn[0] >> 13);
  return tie_t;
}

static void
Field_fld_ae6_slot3_37_13_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0xffffe000) | (tie_t << 13);
  insn[1] = (insn[1] & ~0x3f) | (tie_t >> 19);
}

static unsigned
Field_fld_ae6_slot3_12_0_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 19) >> 19);
  return tie_t;
}

static void
Field_fld_ae6_slot3_12_0_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x1fff) | (tie_t << 0);
}

static unsigned
Field_fld_ae6_slot3_37_20_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | (insn[1] & 0x3f);
  tie_t = (tie_t << 12) | (insn[0] >> 20);
  return tie_t;
}

static void
Field_fld_ae6_slot3_37_20_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xfff00000) | (tie_t << 20);
  insn[1] = (insn[1] & ~0x3f) | (tie_t >> 12);
}

static unsigned
Field_fld_ae6_slot3_37_30_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | (insn[1] & 0x3f);
  tie_t = (tie_t << 2) | (insn[0] >> 30);
  return tie_t;
}

static void
Field_fld_ae6_slot3_37_30_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xc0000000) | (tie_t << 30);
  insn[1] = (insn[1] & ~0x3f) | (tie_t >> 2);
}

static unsigned
Field_fld_ae6_slot3_24_20_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae6_slot3_24_20_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae6_slot3_14_0_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 17) >> 17);
  return tie_t;
}

static void
Field_fld_ae6_slot3_14_0_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x7fff) | (tie_t << 0);
}

static unsigned
Field_fld_ae6_slot3_14_10_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae6_slot3_14_10_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae6_slot3_14_5_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 17) >> 22);
  return tie_t;
}

static void
Field_fld_ae6_slot3_14_5_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x7fe0) | (tie_t << 5);
}

static unsigned
Field_fld_ae6_slot3_37_15_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | (insn[1] & 0x3f);
  tie_t = (tie_t << 17) | (insn[0] >> 15);
  return tie_t;
}

static void
Field_fld_ae6_slot3_37_15_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 9) >> 9;
  insn[0] = (insn[0] & ~0xffff8000) | (tie_t << 15);
  insn[1] = (insn[1] & ~0x3f) | (tie_t >> 17);
}

static unsigned
Field_fld_ae6_slot3_9_5_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae6_slot3_9_5_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae6_slot3_14_13_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  return tie_t;
}

static void
Field_fld_ae6_slot3_14_13_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae6_slot3_10_10_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_fld_ae6_slot3_10_10_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_fld_ae7_slot0_23_0_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 24) | ((insn[0] << 8) >> 8);
  return tie_t;
}

static void
Field_fld_ae7_slot0_23_0_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 8) >> 8;
  insn[0] = (insn[0] & ~0xffffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae7_slot0_23_13_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 8) >> 21);
  return tie_t;
}

static void
Field_fld_ae7_slot0_23_13_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0xffe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae7_slot0_23_17_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 8) >> 25);
  return tie_t;
}

static void
Field_fld_ae7_slot0_23_17_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0xfe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae7_slot0_7_4_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae7_slot0_7_4_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae7_slot0_7_7_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_ae7_slot0_7_7_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_ae7_slot0_7_6_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_ae7_slot0_7_6_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae7_slot0_23_18_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  return tie_t;
}

static void
Field_fld_ae7_slot0_23_18_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae7_slot0_23_6_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 8) >> 14);
  return tie_t;
}

static void
Field_fld_ae7_slot0_23_6_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xffffc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae7_slot0_12_6_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 19) >> 25);
  return tie_t;
}

static void
Field_fld_ae7_slot0_12_6_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae7_slot1_23_0_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 24) | ((insn[0] << 8) >> 8);
  return tie_t;
}

static void
Field_fld_ae7_slot1_23_0_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 8) >> 8;
  insn[0] = (insn[0] & ~0xffffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae7_slot1_23_13_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 8) >> 21);
  return tie_t;
}

static void
Field_fld_ae7_slot1_23_13_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0xffe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae7_slot1_23_17_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 8) >> 25);
  return tie_t;
}

static void
Field_fld_ae7_slot1_23_17_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0xfe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae7_slot1_7_4_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae7_slot1_7_4_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae7_slot1_7_7_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_ae7_slot1_7_7_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_ae7_slot1_7_6_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_ae7_slot1_7_6_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae7_slot1_23_18_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 8) >> 26);
  return tie_t;
}

static void
Field_fld_ae7_slot1_23_18_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae7_slot1_23_6_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 8) >> 14);
  return tie_t;
}

static void
Field_fld_ae7_slot1_23_6_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xffffc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae7_slot1_12_6_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 19) >> 25);
  return tie_t;
}

static void
Field_fld_ae7_slot1_12_6_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae7_slot2_36_12_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | (insn[1] & 0x1f);
  tie_t = (tie_t << 20) | (insn[0] >> 12);
  return tie_t;
}

static void
Field_fld_ae7_slot2_36_12_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0xfffff000) | (tie_t << 12);
  insn[1] = (insn[1] & ~0x1f) | (tie_t >> 20);
}

static unsigned
Field_fld_ae7_slot2_11_0_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 20) >> 20);
  return tie_t;
}

static void
Field_fld_ae7_slot2_11_0_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff) | (tie_t << 0);
}

static unsigned
Field_fld_ae7_slot2_36_20_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | (insn[1] & 0x1f);
  tie_t = (tie_t << 12) | (insn[0] >> 20);
  return tie_t;
}

static void
Field_fld_ae7_slot2_36_20_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0xfff00000) | (tie_t << 20);
  insn[1] = (insn[1] & ~0x1f) | (tie_t >> 12);
}

static unsigned
Field_fld_ae7_slot2_14_5_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 17) >> 22);
  return tie_t;
}

static void
Field_fld_ae7_slot2_14_5_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x7fe0) | (tie_t << 5);
}

static unsigned
Field_fld_ae7_slot2_9_5_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae7_slot2_9_5_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae7_slot2_36_25_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | (insn[1] & 0x1f);
  tie_t = (tie_t << 7) | (insn[0] >> 25);
  return tie_t;
}

static void
Field_fld_ae7_slot2_36_25_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfe000000) | (tie_t << 25);
  insn[1] = (insn[1] & ~0x1f) | (tie_t >> 7);
}

static unsigned
Field_fld_ae7_slot2_36_30_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | (insn[1] & 0x1f);
  tie_t = (tie_t << 2) | (insn[0] >> 30);
  return tie_t;
}

static void
Field_fld_ae7_slot2_36_30_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0xc0000000) | (tie_t << 30);
  insn[1] = (insn[1] & ~0x1f) | (tie_t >> 2);
}

static unsigned
Field_fld_ae7_slot2_36_15_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | (insn[1] & 0x1f);
  tie_t = (tie_t << 17) | (insn[0] >> 15);
  return tie_t;
}

static void
Field_fld_ae7_slot2_36_15_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 10) >> 10;
  insn[0] = (insn[0] & ~0xffff8000) | (tie_t << 15);
  insn[1] = (insn[1] & ~0x1f) | (tie_t >> 17);
}

static unsigned
Field_fld_ae7_slot2_14_10_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae7_slot2_14_10_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae7_slot3_35_11_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | (insn[1] & 0xf);
  tie_t = (tie_t << 21) | (insn[0] >> 11);
  return tie_t;
}

static void
Field_fld_ae7_slot3_35_11_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0xfffff800) | (tie_t << 11);
  insn[1] = (insn[1] & ~0xf) | (tie_t >> 21);
}

static unsigned
Field_fld_ae7_slot3_10_0_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 21) >> 21);
  return tie_t;
}

static void
Field_fld_ae7_slot3_10_0_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x7ff) | (tie_t << 0);
}

static unsigned
Field_fld_ae7_slot3_35_30_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | (insn[1] & 0xf);
  tie_t = (tie_t << 2) | (insn[0] >> 30);
  return tie_t;
}

static void
Field_fld_ae7_slot3_35_30_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xc0000000) | (tie_t << 30);
  insn[1] = (insn[1] & ~0xf) | (tie_t >> 2);
}

static unsigned
Field_fld_ae7_slot3_24_10_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 7) >> 17);
  return tie_t;
}

static void
Field_fld_ae7_slot3_24_10_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x1fffc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae7_slot3_4_0_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae7_slot3_4_0_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae7_slot3_35_20_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | (insn[1] & 0xf);
  tie_t = (tie_t << 12) | (insn[0] >> 20);
  return tie_t;
}

static void
Field_fld_ae7_slot3_35_20_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xfff00000) | (tie_t << 20);
  insn[1] = (insn[1] & ~0xf) | (tie_t >> 12);
}

static unsigned
Field_fld_ae7_slot3_9_5_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae7_slot3_9_5_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae7_slot3_35_25_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | (insn[1] & 0xf);
  tie_t = (tie_t << 7) | (insn[0] >> 25);
  return tie_t;
}

static void
Field_fld_ae7_slot3_35_25_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0xfe000000) | (tie_t << 25);
  insn[1] = (insn[1] & ~0xf) | (tie_t >> 7);
}

static unsigned
Field_fld_ae7_slot3_14_5_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 17) >> 22);
  return tie_t;
}

static void
Field_fld_ae7_slot3_14_5_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x7fe0) | (tie_t << 5);
}

static unsigned
Field_fld_ae7_slot3_14_10_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae7_slot3_14_10_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae9_slot0_27_16_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 4) >> 20);
  return tie_t;
}

static void
Field_fld_ae9_slot0_27_16_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae9_slot0_27_12_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 4) >> 16);
  return tie_t;
}

static void
Field_fld_ae9_slot0_27_12_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae9_slot0_27_18_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 4) >> 22);
  return tie_t;
}

static void
Field_fld_ae9_slot0_27_18_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0xffc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae9_slot0_27_8_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 20) | ((insn[0] << 4) >> 12);
  return tie_t;
}

static void
Field_fld_ae9_slot0_27_8_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 12) >> 12;
  insn[0] = (insn[0] & ~0xfffff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae9_slot0_3_0_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae9_slot0_3_0_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae9_slot0_27_17_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 4) >> 21);
  return tie_t;
}

static void
Field_fld_ae9_slot0_27_17_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0xffe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae9_slot0_27_20_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 4) >> 24);
  return tie_t;
}

static void
Field_fld_ae9_slot0_27_20_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae9_slot0_7_4_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae9_slot0_7_4_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae9_slot0_27_3_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 25) | ((insn[0] << 4) >> 7);
  return tie_t;
}

static void
Field_fld_ae9_slot0_27_3_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0xffffff8) | (tie_t << 3);
}

static unsigned
Field_fld_ae9_slot0_2_0_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae9_slot0_2_0_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae9_slot0_27_10_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 4) >> 14);
  return tie_t;
}

static void
Field_fld_ae9_slot0_27_10_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xffffc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae9_slot0_8_4_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 23) >> 27);
  return tie_t;
}

static void
Field_fld_ae9_slot0_8_4_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0) | (tie_t << 4);
}

static unsigned
Field_fld_ae9_slot0_27_13_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 4) >> 17);
  return tie_t;
}

static void
Field_fld_ae9_slot0_27_13_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0xfffe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae9_slot0_7_7_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_ae9_slot0_7_7_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_ae9_slot0_7_6_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_ae9_slot0_7_6_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae9_slot0_17_4_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 14) >> 18);
  return tie_t;
}

static void
Field_fld_ae9_slot0_17_4_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0x3fff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae9_slot0_27_19_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 4) >> 23);
  return tie_t;
}

static void
Field_fld_ae9_slot0_27_19_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0xff80000) | (tie_t << 19);
}

static unsigned
Field_fld_ae9_slot0_12_5_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 19) >> 24);
  return tie_t;
}

static void
Field_fld_ae9_slot0_12_5_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x1fe0) | (tie_t << 5);
}

static unsigned
Field_fld_ae9_slot0_12_12_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_fld_ae9_slot0_12_12_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_ae9_slot0_9_5_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae9_slot0_9_5_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae9_slot0_8_5_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 23) >> 28);
  return tie_t;
}

static void
Field_fld_ae9_slot0_8_5_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae9_slot0_7_5_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_fld_ae9_slot0_7_5_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_fld_ae9_slot0_17_8_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 14) >> 22);
  return tie_t;
}

static void
Field_fld_ae9_slot0_17_8_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae9_slot0_17_13_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae9_slot0_17_13_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae9_slot0_27_22_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 4) >> 26);
  return tie_t;
}

static void
Field_fld_ae9_slot0_27_22_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc00000) | (tie_t << 22);
}

static unsigned
Field_fld_ae9_slot0_27_23_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 4) >> 27);
  return tie_t;
}

static void
Field_fld_ae9_slot0_27_23_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf800000) | (tie_t << 23);
}

static unsigned
Field_fld_ae9_slot0_7_0_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 24) >> 24);
  return tie_t;
}

static void
Field_fld_ae9_slot0_7_0_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff) | (tie_t << 0);
}

static unsigned
Field_fld_ae9_slot0_0_0_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_ae9_slot0_0_0_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_fld_ae9_slot0_12_8_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae9_slot0_12_8_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae9_slot1_26_16_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 5) >> 21);
  return tie_t;
}

static void
Field_fld_ae9_slot1_26_16_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x7ff0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae9_slot1_26_12_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 5) >> 17);
  return tie_t;
}

static void
Field_fld_ae9_slot1_26_12_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x7fff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae9_slot1_26_17_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 5) >> 22);
  return tie_t;
}

static void
Field_fld_ae9_slot1_26_17_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x7fe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae9_slot1_7_4_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae9_slot1_7_4_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae9_slot1_26_2_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 25) | ((insn[0] << 5) >> 7);
  return tie_t;
}

static void
Field_fld_ae9_slot1_26_2_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0x7fffffc) | (tie_t << 2);
}

static unsigned
Field_fld_ae9_slot1_1_0_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae9_slot1_1_0_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae9_slot1_26_8_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 19) | ((insn[0] << 5) >> 13);
  return tie_t;
}

static void
Field_fld_ae9_slot1_26_8_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 13) >> 13;
  insn[0] = (insn[0] & ~0x7ffff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae9_slot1_3_0_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae9_slot1_3_0_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae9_slot1_26_9_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 5) >> 14);
  return tie_t;
}

static void
Field_fld_ae9_slot1_26_9_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0x7fffe00) | (tie_t << 9);
}

static unsigned
Field_fld_ae9_slot1_26_13_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 5) >> 18);
  return tie_t;
}

static void
Field_fld_ae9_slot1_26_13_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0x7ffe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae9_slot1_3_3_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 28) >> 31);
  return tie_t;
}

static void
Field_fld_ae9_slot1_3_3_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8) | (tie_t << 3);
}

static unsigned
Field_fld_ae9_slot1_3_2_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae9_slot1_3_2_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_ae9_slot1_26_18_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 5) >> 23);
  return tie_t;
}

static void
Field_fld_ae9_slot1_26_18_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x7fc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae9_slot1_26_20_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 5) >> 25);
  return tie_t;
}

static void
Field_fld_ae9_slot1_26_20_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae9_slot1_17_8_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 14) >> 22);
  return tie_t;
}

static void
Field_fld_ae9_slot1_17_8_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae9_slot1_17_13_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae9_slot1_17_13_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae9_slot1_26_22_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 5) >> 27);
  return tie_t;
}

static void
Field_fld_ae9_slot1_26_22_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00000) | (tie_t << 22);
}

static unsigned
Field_fld_ae9_slot1_26_23_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 5) >> 28);
  return tie_t;
}

static void
Field_fld_ae9_slot1_26_23_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x7800000) | (tie_t << 23);
}

static unsigned
Field_fld_ae9_slot2_33_9_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | (insn[1] & 0x3);
  tie_t = (tie_t << 23) | (insn[0] >> 9);
  return tie_t;
}

static void
Field_fld_ae9_slot2_33_9_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0xfffffe00) | (tie_t << 9);
  insn[1] = (insn[1] & ~0x3) | (tie_t >> 23);
}

static unsigned
Field_fld_ae9_slot2_8_0_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 23) >> 23);
  return tie_t;
}

static void
Field_fld_ae9_slot2_8_0_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x1ff) | (tie_t << 0);
}

static unsigned
Field_fld_ae9_slot2_33_20_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | (insn[1] & 0x3);
  tie_t = (tie_t << 12) | (insn[0] >> 20);
  return tie_t;
}

static void
Field_fld_ae9_slot2_33_20_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0xfff00000) | (tie_t << 20);
  insn[1] = (insn[1] & ~0x3) | (tie_t >> 12);
}

static unsigned
Field_fld_ae9_slot2_9_9_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_fld_ae9_slot2_9_9_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_fld_ae9_slot2_6_0_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 25) >> 25);
  return tie_t;
}

static void
Field_fld_ae9_slot2_6_0_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f) | (tie_t << 0);
}

static unsigned
Field_fld_ae9_slot2_5_0_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 26) >> 26);
  return tie_t;
}

static void
Field_fld_ae9_slot2_5_0_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f) | (tie_t << 0);
}

static unsigned
Field_fld_ae9_slot2_9_0_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 22) >> 22);
  return tie_t;
}

static void
Field_fld_ae9_slot2_9_0_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff) | (tie_t << 0);
}

static unsigned
Field_fld_ae9_slot2_4_0_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae9_slot2_4_0_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae9_slot2_33_25_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | (insn[1] & 0x3);
  tie_t = (tie_t << 7) | (insn[0] >> 25);
  return tie_t;
}

static void
Field_fld_ae9_slot2_33_25_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0xfe000000) | (tie_t << 25);
  insn[1] = (insn[1] & ~0x3) | (tie_t >> 7);
}

static unsigned
Field_fld_ae9_slot2_33_30_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | (insn[1] & 0x3);
  tie_t = (tie_t << 2) | (insn[0] >> 30);
  return tie_t;
}

static void
Field_fld_ae9_slot2_33_30_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xc0000000) | (tie_t << 30);
  insn[1] = (insn[1] & ~0x3) | (tie_t >> 2);
}

static unsigned
Field_fld_ae9_slot2_9_5_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae9_slot2_9_5_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae9_slot2_24_20_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae9_slot2_24_20_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae9_slot2_33_15_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | (insn[1] & 0x3);
  tie_t = (tie_t << 17) | (insn[0] >> 15);
  return tie_t;
}

static void
Field_fld_ae9_slot2_33_15_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 13) >> 13;
  insn[0] = (insn[0] & ~0xffff8000) | (tie_t << 15);
  insn[1] = (insn[1] & ~0x3) | (tie_t >> 17);
}

static unsigned
Field_fld_ae9_slot2_33_26_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | (insn[1] & 0x3);
  tie_t = (tie_t << 6) | (insn[0] >> 26);
  return tie_t;
}

static void
Field_fld_ae9_slot2_33_26_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xfc000000) | (tie_t << 26);
  insn[1] = (insn[1] & ~0x3) | (tie_t >> 6);
}

static unsigned
Field_fld_ae9_slot2_33_28_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | (insn[1] & 0x3);
  tie_t = (tie_t << 4) | (insn[0] >> 28);
  return tie_t;
}

static void
Field_fld_ae9_slot2_33_28_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xf0000000) | (tie_t << 28);
  insn[1] = (insn[1] & ~0x3) | (tie_t >> 4);
}

static unsigned
Field_fld_ae9_slot2_33_14_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | (insn[1] & 0x3);
  tie_t = (tie_t << 18) | (insn[0] >> 14);
  return tie_t;
}

static void
Field_fld_ae9_slot2_33_14_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 12) >> 12;
  insn[0] = (insn[0] & ~0xffffc000) | (tie_t << 14);
  insn[1] = (insn[1] & ~0x3) | (tie_t >> 18);
}

static unsigned
Field_fld_ae9_slot2_24_15_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 7) >> 22);
  return tie_t;
}

static void
Field_fld_ae9_slot2_24_15_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x1ff8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae9_slot2_24_14_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 7) >> 21);
  return tie_t;
}

static void
Field_fld_ae9_slot2_24_14_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x1ffc000) | (tie_t << 14);
}

static unsigned
Field_fld_ae9_slot3_31_7_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 25) | ((insn[0] << 0) >> 7);
  return tie_t;
}

static void
Field_fld_ae9_slot3_31_7_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0xffffff80) | (tie_t << 7);
}

static unsigned
Field_fld_ae9_slot3_6_0_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 25) >> 25);
  return tie_t;
}

static void
Field_fld_ae9_slot3_6_0_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f) | (tie_t << 0);
}

static unsigned
Field_fld_ae9_slot3_31_25_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 0) >> 25);
  return tie_t;
}

static void
Field_fld_ae9_slot3_31_25_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0xfe000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae9_slot3_19_15_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae9_slot3_19_15_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae9_slot3_4_4_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_fld_ae9_slot3_4_4_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_fld_ae9_slot3_31_15_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 17) | ((insn[0] << 0) >> 15);
  return tie_t;
}

static void
Field_fld_ae9_slot3_31_15_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0xffff8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae9_slot3_4_0_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae9_slot3_4_0_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae9_slot3_9_5_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae9_slot3_9_5_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae9_slot3_31_20_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 0) >> 20);
  return tie_t;
}

static void
Field_fld_ae9_slot3_31_20_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae9_slot3_9_0_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 22) >> 22);
  return tie_t;
}

static void
Field_fld_ae9_slot3_9_0_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff) | (tie_t << 0);
}

static unsigned
Field_fld_ae9_slot3_31_26_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 0) >> 26);
  return tie_t;
}

static void
Field_fld_ae9_slot3_31_26_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc000000) | (tie_t << 26);
}

static unsigned
Field_fld_ae9_slot3_24_20_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae9_slot3_24_20_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae9_slot3_31_28_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 0) >> 28);
  return tie_t;
}

static void
Field_fld_ae9_slot3_31_28_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000000) | (tie_t << 28);
}

static unsigned
Field_fld_ae9_slot3_31_14_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 0) >> 14);
  return tie_t;
}

static void
Field_fld_ae9_slot3_31_14_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xffffc000) | (tie_t << 14);
}

static unsigned
Field_fld_ae9_slot3_4_3_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 27) >> 30);
  return tie_t;
}

static void
Field_fld_ae9_slot3_4_3_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18) | (tie_t << 3);
}

static unsigned
Field_fld_ae10_slot0_24_16_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 7) >> 23);
  return tie_t;
}

static void
Field_fld_ae10_slot0_24_16_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x1ff0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae10_slot0_24_12_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 7) >> 19);
  return tie_t;
}

static void
Field_fld_ae10_slot0_24_12_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x1fff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae10_slot0_24_18_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 7) >> 25);
  return tie_t;
}

static void
Field_fld_ae10_slot0_24_18_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae10_slot0_24_8_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 17) | ((insn[0] << 7) >> 15);
  return tie_t;
}

static void
Field_fld_ae10_slot0_24_8_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0x1ffff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae10_slot0_3_0_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae10_slot0_3_0_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae10_slot0_24_17_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 7) >> 24);
  return tie_t;
}

static void
Field_fld_ae10_slot0_24_17_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x1fe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae10_slot0_24_20_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae10_slot0_24_20_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae10_slot0_7_4_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae10_slot0_7_4_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae10_slot0_24_0_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 25) | ((insn[0] << 7) >> 7);
  return tie_t;
}

static void
Field_fld_ae10_slot0_24_0_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0x1ffffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae10_slot0_24_10_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 7) >> 17);
  return tie_t;
}

static void
Field_fld_ae10_slot0_24_10_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x1fffc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae10_slot0_8_4_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 23) >> 27);
  return tie_t;
}

static void
Field_fld_ae10_slot0_8_4_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0) | (tie_t << 4);
}

static unsigned
Field_fld_ae10_slot0_24_13_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 7) >> 20);
  return tie_t;
}

static void
Field_fld_ae10_slot0_24_13_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x1ffe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae10_slot0_7_7_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_ae10_slot0_7_7_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_ae10_slot0_7_6_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_ae10_slot0_7_6_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae10_slot0_17_4_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 14) >> 18);
  return tie_t;
}

static void
Field_fld_ae10_slot0_17_4_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0x3fff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae10_slot0_17_8_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 14) >> 22);
  return tie_t;
}

static void
Field_fld_ae10_slot0_17_8_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae10_slot0_17_13_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae10_slot0_17_13_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae10_slot1_25_16_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 6) >> 22);
  return tie_t;
}

static void
Field_fld_ae10_slot1_25_16_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae10_slot1_25_12_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 6) >> 18);
  return tie_t;
}

static void
Field_fld_ae10_slot1_25_12_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0x3fff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae10_slot1_25_17_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 6) >> 23);
  return tie_t;
}

static void
Field_fld_ae10_slot1_25_17_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x3fe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae10_slot1_7_4_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae10_slot1_7_4_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae10_slot1_25_1_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 25) | ((insn[0] << 6) >> 7);
  return tie_t;
}

static void
Field_fld_ae10_slot1_25_1_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0x3fffffe) | (tie_t << 1);
}

static unsigned
Field_fld_ae10_slot1_0_0_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_ae10_slot1_0_0_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_fld_ae10_slot1_25_8_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 6) >> 14);
  return tie_t;
}

static void
Field_fld_ae10_slot1_25_8_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0x3ffff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae10_slot1_3_0_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae10_slot1_3_0_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae10_slot1_25_9_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 17) | ((insn[0] << 6) >> 15);
  return tie_t;
}

static void
Field_fld_ae10_slot1_25_9_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0x3fffe00) | (tie_t << 9);
}

static unsigned
Field_fld_ae10_slot1_25_13_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 6) >> 19);
  return tie_t;
}

static void
Field_fld_ae10_slot1_25_13_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x3ffe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae10_slot1_3_3_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 28) >> 31);
  return tie_t;
}

static void
Field_fld_ae10_slot1_3_3_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8) | (tie_t << 3);
}

static unsigned
Field_fld_ae10_slot1_3_2_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae10_slot1_3_2_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_ae10_slot1_25_18_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 6) >> 24);
  return tie_t;
}

static void
Field_fld_ae10_slot1_25_18_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae10_slot1_25_20_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 6) >> 26);
  return tie_t;
}

static void
Field_fld_ae10_slot1_25_20_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae10_slot1_17_8_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 14) >> 22);
  return tie_t;
}

static void
Field_fld_ae10_slot1_17_8_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae10_slot1_17_13_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae10_slot1_17_13_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae10_slot1_25_22_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 6) >> 28);
  return tie_t;
}

static void
Field_fld_ae10_slot1_25_22_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00000) | (tie_t << 22);
}

static unsigned
Field_fld_ae10_slot1_25_23_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 6) >> 29);
  return tie_t;
}

static void
Field_fld_ae10_slot1_25_23_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x3800000) | (tie_t << 23);
}

static unsigned
Field_fld_ae10_slot2_34_10_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | (insn[1] & 0x7);
  tie_t = (tie_t << 22) | (insn[0] >> 10);
  return tie_t;
}

static void
Field_fld_ae10_slot2_34_10_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0xfffffc00) | (tie_t << 10);
  insn[1] = (insn[1] & ~0x7) | (tie_t >> 22);
}

static unsigned
Field_fld_ae10_slot2_9_0_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 22) >> 22);
  return tie_t;
}

static void
Field_fld_ae10_slot2_9_0_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff) | (tie_t << 0);
}

static unsigned
Field_fld_ae10_slot2_34_15_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | (insn[1] & 0x7);
  tie_t = (tie_t << 17) | (insn[0] >> 15);
  return tie_t;
}

static void
Field_fld_ae10_slot2_34_15_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 12) >> 12;
  insn[0] = (insn[0] & ~0xffff8000) | (tie_t << 15);
  insn[1] = (insn[1] & ~0x7) | (tie_t >> 17);
}

static unsigned
Field_fld_ae10_slot2_4_0_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae10_slot2_4_0_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae10_slot2_34_25_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | (insn[1] & 0x7);
  tie_t = (tie_t << 7) | (insn[0] >> 25);
  return tie_t;
}

static void
Field_fld_ae10_slot2_34_25_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0xfe000000) | (tie_t << 25);
  insn[1] = (insn[1] & ~0x7) | (tie_t >> 7);
}

static unsigned
Field_fld_ae10_slot2_34_20_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | (insn[1] & 0x7);
  tie_t = (tie_t << 12) | (insn[0] >> 20);
  return tie_t;
}

static void
Field_fld_ae10_slot2_34_20_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0xfff00000) | (tie_t << 20);
  insn[1] = (insn[1] & ~0x7) | (tie_t >> 12);
}

static unsigned
Field_fld_ae10_slot2_9_5_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae10_slot2_9_5_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae10_slot2_34_30_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | (insn[1] & 0x7);
  tie_t = (tie_t << 2) | (insn[0] >> 30);
  return tie_t;
}

static void
Field_fld_ae10_slot2_34_30_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xc0000000) | (tie_t << 30);
  insn[1] = (insn[1] & ~0x7) | (tie_t >> 2);
}

static unsigned
Field_fld_ae10_slot2_24_20_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae10_slot2_24_20_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae10_slot2_34_31_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | (insn[1] & 0x7);
  tie_t = (tie_t << 1) | (insn[0] >> 31);
  return tie_t;
}

static void
Field_fld_ae10_slot2_34_31_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x80000000) | (tie_t << 31);
  insn[1] = (insn[1] & ~0x7) | (tie_t >> 1);
}

static unsigned
Field_fld_ae10_slot2_29_20_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 2) >> 22);
  return tie_t;
}

static void
Field_fld_ae10_slot2_29_20_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae10_slot2_34_33_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[1] << 29) >> 30);
  return tie_t;
}

static void
Field_fld_ae10_slot2_34_33_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[1] = (insn[1] & ~0x6) | (tie_t << 1);
}

static unsigned
Field_fld_ae10_slot2_29_25_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae10_slot2_29_25_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae10_slot2_34_14_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | (insn[1] & 0x7);
  tie_t = (tie_t << 18) | (insn[0] >> 14);
  return tie_t;
}

static void
Field_fld_ae10_slot2_34_14_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 11) >> 11;
  insn[0] = (insn[0] & ~0xffffc000) | (tie_t << 14);
  insn[1] = (insn[1] & ~0x7) | (tie_t >> 18);
}

static unsigned
Field_fld_ae10_slot3_34_10_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | (insn[1] & 0x7);
  tie_t = (tie_t << 22) | (insn[0] >> 10);
  return tie_t;
}

static void
Field_fld_ae10_slot3_34_10_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0xfffffc00) | (tie_t << 10);
  insn[1] = (insn[1] & ~0x7) | (tie_t >> 22);
}

static unsigned
Field_fld_ae10_slot3_9_0_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 22) >> 22);
  return tie_t;
}

static void
Field_fld_ae10_slot3_9_0_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff) | (tie_t << 0);
}

static unsigned
Field_fld_ae10_slot3_34_25_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | (insn[1] & 0x7);
  tie_t = (tie_t << 7) | (insn[0] >> 25);
  return tie_t;
}

static void
Field_fld_ae10_slot3_34_25_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0xfe000000) | (tie_t << 25);
  insn[1] = (insn[1] & ~0x7) | (tie_t >> 7);
}

static unsigned
Field_fld_ae10_slot3_19_15_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae10_slot3_19_15_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae10_slot3_4_4_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_fld_ae10_slot3_4_4_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_fld_ae10_slot3_34_15_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | (insn[1] & 0x7);
  tie_t = (tie_t << 17) | (insn[0] >> 15);
  return tie_t;
}

static void
Field_fld_ae10_slot3_34_15_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 12) >> 12;
  insn[0] = (insn[0] & ~0xffff8000) | (tie_t << 15);
  insn[1] = (insn[1] & ~0x7) | (tie_t >> 17);
}

static unsigned
Field_fld_ae10_slot3_4_0_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae10_slot3_4_0_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae10_slot3_9_5_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae10_slot3_9_5_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae10_slot3_34_20_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | (insn[1] & 0x7);
  tie_t = (tie_t << 12) | (insn[0] >> 20);
  return tie_t;
}

static void
Field_fld_ae10_slot3_34_20_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0xfff00000) | (tie_t << 20);
  insn[1] = (insn[1] & ~0x7) | (tie_t >> 12);
}

static unsigned
Field_fld_ae10_slot3_34_31_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | (insn[1] & 0x7);
  tie_t = (tie_t << 1) | (insn[0] >> 31);
  return tie_t;
}

static void
Field_fld_ae10_slot3_34_31_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x80000000) | (tie_t << 31);
  insn[1] = (insn[1] & ~0x7) | (tie_t >> 1);
}

static unsigned
Field_fld_ae10_slot3_29_20_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 2) >> 22);
  return tie_t;
}

static void
Field_fld_ae10_slot3_29_20_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae10_slot3_34_33_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[1] << 29) >> 30);
  return tie_t;
}

static void
Field_fld_ae10_slot3_34_33_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[1] = (insn[1] & ~0x6) | (tie_t << 1);
}

static unsigned
Field_fld_ae10_slot3_29_25_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae10_slot3_29_25_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae10_slot3_34_14_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | (insn[1] & 0x7);
  tie_t = (tie_t << 18) | (insn[0] >> 14);
  return tie_t;
}

static void
Field_fld_ae10_slot3_34_14_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 11) >> 11;
  insn[0] = (insn[0] & ~0xffffc000) | (tie_t << 14);
  insn[1] = (insn[1] & ~0x7) | (tie_t >> 18);
}

static unsigned
Field_fld_ae10_slot3_4_3_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 27) >> 30);
  return tie_t;
}

static void
Field_fld_ae10_slot3_4_3_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18) | (tie_t << 3);
}

static unsigned
Field_fld_ae10_slot3_34_30_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | (insn[1] & 0x7);
  tie_t = (tie_t << 2) | (insn[0] >> 30);
  return tie_t;
}

static void
Field_fld_ae10_slot3_34_30_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xc0000000) | (tie_t << 30);
  insn[1] = (insn[1] & ~0x7) | (tie_t >> 2);
}

static unsigned
Field_fld_ae4_slot0_22_16_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 9) >> 25);
  return tie_t;
}

static void
Field_fld_ae4_slot0_22_16_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae4_slot0_22_12_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 9) >> 21);
  return tie_t;
}

static void
Field_fld_ae4_slot0_22_12_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x7ff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae4_slot0_22_18_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 9) >> 27);
  return tie_t;
}

static void
Field_fld_ae4_slot0_22_18_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae4_slot0_22_8_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 9) >> 17);
  return tie_t;
}

static void
Field_fld_ae4_slot0_22_8_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x7fff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae4_slot0_3_0_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae4_slot0_3_0_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae4_slot0_22_17_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 9) >> 26);
  return tie_t;
}

static void
Field_fld_ae4_slot0_22_17_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x7e0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae4_slot0_22_20_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 9) >> 29);
  return tie_t;
}

static void
Field_fld_ae4_slot0_22_20_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700000) | (tie_t << 20);
}

static unsigned
Field_fld_ae4_slot0_7_4_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae4_slot0_7_4_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae4_slot0_22_0_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 23) | ((insn[0] << 9) >> 9);
  return tie_t;
}

static void
Field_fld_ae4_slot0_22_0_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 9) >> 9;
  insn[0] = (insn[0] & ~0x7fffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae4_slot0_3_1_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_fld_ae4_slot0_3_1_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_fld_ae4_slot0_22_13_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 9) >> 22);
  return tie_t;
}

static void
Field_fld_ae4_slot0_22_13_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x7fe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae4_slot0_22_6_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 17) | ((insn[0] << 9) >> 15);
  return tie_t;
}

static void
Field_fld_ae4_slot0_22_6_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0x7fffc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae4_slot0_4_4_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_fld_ae4_slot0_4_4_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_fld_ae4_slot1_22_16_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 9) >> 25);
  return tie_t;
}

static void
Field_fld_ae4_slot1_22_16_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae4_slot1_22_12_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 9) >> 21);
  return tie_t;
}

static void
Field_fld_ae4_slot1_22_12_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x7ff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae4_slot1_22_17_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 9) >> 26);
  return tie_t;
}

static void
Field_fld_ae4_slot1_22_17_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x7e0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae4_slot1_7_4_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae4_slot1_7_4_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae4_slot1_22_0_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 23) | ((insn[0] << 9) >> 9);
  return tie_t;
}

static void
Field_fld_ae4_slot1_22_0_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 9) >> 9;
  insn[0] = (insn[0] & ~0x7fffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae4_slot1_22_8_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 9) >> 17);
  return tie_t;
}

static void
Field_fld_ae4_slot1_22_8_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x7fff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae4_slot1_3_0_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae4_slot1_3_0_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae4_slot1_3_1_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_fld_ae4_slot1_3_1_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_fld_ae4_slot1_22_13_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 9) >> 22);
  return tie_t;
}

static void
Field_fld_ae4_slot1_22_13_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x7fe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae4_slot1_22_18_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 9) >> 27);
  return tie_t;
}

static void
Field_fld_ae4_slot1_22_18_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae4_slot2_23_0_Slot_ae4_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 24) | ((insn[0] << 8) >> 8);
  return tie_t;
}

static void
Field_fld_ae4_slot2_23_0_Slot_ae4_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 8) >> 8;
  insn[0] = (insn[0] & ~0xffffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae4_slot2_23_15_Slot_ae4_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 8) >> 23);
  return tie_t;
}

static void
Field_fld_ae4_slot2_23_15_Slot_ae4_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0xff8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae4_slot2_9_5_Slot_ae4_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae4_slot2_9_5_Slot_ae4_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae4_slot2_23_20_Slot_ae4_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  return tie_t;
}

static void
Field_fld_ae4_slot2_23_20_Slot_ae4_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae4_slot2_23_17_Slot_ae4_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 8) >> 25);
  return tie_t;
}

static void
Field_fld_ae4_slot2_23_17_Slot_ae4_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0xfe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae4_slot2_4_0_Slot_ae4_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae4_slot2_4_0_Slot_ae4_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae4_slot2_23_12_Slot_ae4_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 8) >> 20);
  return tie_t;
}

static void
Field_fld_ae4_slot2_23_12_Slot_ae4_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae4_slot3_27_3_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 25) | ((insn[0] << 4) >> 7);
  return tie_t;
}

static void
Field_fld_ae4_slot3_27_3_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0xffffff8) | (tie_t << 3);
}

static unsigned
Field_fld_ae4_slot3_2_0_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae4_slot3_2_0_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae4_slot3_27_25_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 4) >> 29);
  return tie_t;
}

static void
Field_fld_ae4_slot3_27_25_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae4_slot3_19_15_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae4_slot3_19_15_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae4_slot3_9_0_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 22) >> 22);
  return tie_t;
}

static void
Field_fld_ae4_slot3_9_0_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff) | (tie_t << 0);
}

static unsigned
Field_fld_ae4_slot3_9_5_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae4_slot3_9_5_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae4_slot3_19_19_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  return tie_t;
}

static void
Field_fld_ae4_slot3_19_19_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_fld_ae4_slot3_19_5_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 12) >> 17);
  return tie_t;
}

static void
Field_fld_ae4_slot3_19_5_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0xfffe0) | (tie_t << 5);
}

static unsigned
Field_fld_ae4_slot3_27_20_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 4) >> 24);
  return tie_t;
}

static void
Field_fld_ae4_slot3_27_20_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae4_slot3_14_10_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae4_slot3_14_10_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae4_slot4_22_0_Slot_ae4_slot4_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 23) | ((insn[0] << 9) >> 9);
  return tie_t;
}

static void
Field_fld_ae4_slot4_22_0_Slot_ae4_slot4_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 9) >> 9;
  insn[0] = (insn[0] & ~0x7fffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae4_slot4_22_15_Slot_ae4_slot4_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 9) >> 24);
  return tie_t;
}

static void
Field_fld_ae4_slot4_22_15_Slot_ae4_slot4_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x7f8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae4_slot4_9_5_Slot_ae4_slot4_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae4_slot4_9_5_Slot_ae4_slot4_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae4_slot4_22_20_Slot_ae4_slot4_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 9) >> 29);
  return tie_t;
}

static void
Field_fld_ae4_slot4_22_20_Slot_ae4_slot4_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700000) | (tie_t << 20);
}

static unsigned
Field_t_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_t_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_t_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_t_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_t_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_t_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_t_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_t_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_t_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_t_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_t_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 23) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e0) | (tie_t << 5);
}

static unsigned
Field_t_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_t_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_t_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_t_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_bbi4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_bbi4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_bbi_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_bbi_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_bbi_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_bbi_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_bbi_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_bbi_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_bbi_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 23) >> 27);
  return tie_t;
}

static void
Field_bbi_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0) | (tie_t << 4);
}

static unsigned
Field_imm12_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 8) >> 20);
  return tie_t;
}

static void
Field_imm12_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff000) | (tie_t << 12);
}

static unsigned
Field_imm8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 8) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0000) | (tie_t << 16);
}

static unsigned
Field_imm8_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_imm8_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_imm8_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  tie_t = (tie_t << 6) | ((insn[0] << 18) >> 26);
  return tie_t;
}

static void
Field_imm8_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f00) | (tie_t << 8);
  tie_t = (val << 24) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_imm8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_imm8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 25) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 24) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_imm8_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm8_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm8_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_imm8_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 24) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_imm8_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 15) >> 29);
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_imm8_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
  tie_t = (val << 24) >> 29;
  insn[0] = (insn[0] & ~0x1c000) | (tie_t << 14);
}

static unsigned
Field_imm8_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm8_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm8_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm8_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm8_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm8_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm8_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm8_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_s_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_s_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_s_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_s_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_s_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_s_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_s_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_s_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_s8_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_s8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_s8_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_s8_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_s8_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 28) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8) | (tie_t << 3);
}

static unsigned
Field_s8_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_s8_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_s8_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
}

static unsigned
Field_imms8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 21) >> 29);
  return tie_t;
}

static void
Field_imms8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700) | (tie_t << 8);
}

static unsigned
Field_imm12b_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 8) >> 24);
  return tie_t;
}

static void
Field_imm12b_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0000) | (tie_t << 16);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_imm12b_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_imm12b_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_imm12b_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  tie_t = (tie_t << 10) | ((insn[0] << 18) >> 22);
  return tie_t;
}

static void
Field_imm12b_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff0) | (tie_t << 4);
  tie_t = (val << 20) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_imm12b_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 10) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_imm12b_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
  tie_t = (val << 25) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 22) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
  tie_t = (val << 21) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
  tie_t = (val << 20) >> 31;
  insn[0] = (insn[0] & ~0x200000) | (tie_t << 21);
}

static unsigned
Field_imm12b_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 16) >> 20);
  return tie_t;
}

static void
Field_imm12b_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0) | (tie_t << 4);
}

static unsigned
Field_imm12b_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 16) >> 20);
  return tie_t;
}

static void
Field_imm12b_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0) | (tie_t << 4);
}

static unsigned
Field_imm12b_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  tie_t = (tie_t << 5) | ((insn[0] << 23) >> 27);
  return tie_t;
}

static void
Field_imm12b_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0) | (tie_t << 4);
  tie_t = (val << 25) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 20) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_imm12b_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm12b_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm12b_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 16) >> 20);
  return tie_t;
}

static void
Field_imm12b_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0) | (tie_t << 4);
}

static unsigned
Field_imm12b_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm12b_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm12b_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 16) >> 20);
  return tie_t;
}

static void
Field_imm12b_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0) | (tie_t << 4);
}

static unsigned
Field_imm12b_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 16) >> 20);
  return tie_t;
}

static void
Field_imm12b_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0) | (tie_t << 4);
}

static unsigned
Field_imm12b_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 16) >> 20);
  return tie_t;
}

static void
Field_imm12b_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0) | (tie_t << 4);
}

static unsigned
Field_imm12b_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 16) >> 20);
  return tie_t;
}

static void
Field_imm12b_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0) | (tie_t << 4);
}

static unsigned
Field_imm12b_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 16) >> 20);
  return tie_t;
}

static void
Field_imm12b_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0) | (tie_t << 4);
}

static unsigned
Field_imm12b_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 16) >> 20);
  return tie_t;
}

static void
Field_imm12b_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0) | (tie_t << 4);
}

static unsigned
Field_imm16_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 8) >> 16);
  return tie_t;
}

static void
Field_imm16_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff00) | (tie_t << 8);
}

static unsigned
Field_imm16_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 12) >> 16);
  return tie_t;
}

static void
Field_imm16_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff0) | (tie_t << 4);
}

static unsigned
Field_imm16_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 11) | ((insn[0] << 13) >> 21);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm16_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 17) >> 21;
  insn[0] = (insn[0] & ~0x7ff00) | (tie_t << 8);
  tie_t = (val << 16) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_imm16_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 11) >> 30);
  tie_t = (tie_t << 14) | ((insn[0] << 14) >> 18);
  return tie_t;
}

static void
Field_imm16_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0x3fff0) | (tie_t << 4);
  tie_t = (val << 16) >> 30;
  insn[0] = (insn[0] & ~0x180000) | (tie_t << 19);
}

static unsigned
Field_imm16_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 12) >> 20);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm16_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 16) >> 20;
  insn[0] = (insn[0] & ~0xfff00) | (tie_t << 8);
}

static unsigned
Field_imm16_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 12) >> 20);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm16_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 16) >> 20;
  insn[0] = (insn[0] & ~0xfff00) | (tie_t << 8);
}

static unsigned
Field_imm16_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 12) >> 16);
  return tie_t;
}

static void
Field_imm16_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff0) | (tie_t << 4);
}

static unsigned
Field_imm16_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 12) >> 16);
  return tie_t;
}

static void
Field_imm16_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff0) | (tie_t << 4);
}

static unsigned
Field_imm16_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 12) >> 16);
  return tie_t;
}

static void
Field_imm16_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff0) | (tie_t << 4);
}

static unsigned
Field_offset_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 8) >> 14);
  return tie_t;
}

static void
Field_offset_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xffffc0) | (tie_t << 6);
}

static unsigned
Field_offset_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 14) >> 14);
  return tie_t;
}

static void
Field_offset_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0x3ffff) | (tie_t << 0);
}

static unsigned
Field_offset_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 17) | ((insn[0] << 15) >> 15);
  return tie_t;
}

static void
Field_offset_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0x1ffff) | (tie_t << 0);
  tie_t = (val << 14) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_offset_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 17) | ((insn[0] << 15) >> 15);
  return tie_t;
}

static void
Field_offset_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0x1ffff) | (tie_t << 0);
  tie_t = (val << 14) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_offset_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 14) >> 14);
  return tie_t;
}

static void
Field_offset_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0x3ffff) | (tie_t << 0);
}

static unsigned
Field_offset_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 14) >> 14);
  return tie_t;
}

static void
Field_offset_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0x3ffff) | (tie_t << 0);
}

static unsigned
Field_offset_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 14) >> 14);
  return tie_t;
}

static void
Field_offset_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0x3ffff) | (tie_t << 0);
}

static unsigned
Field_offset_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 14) >> 14);
  return tie_t;
}

static void
Field_offset_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0x3ffff) | (tie_t << 0);
}

static unsigned
Field_offset_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 14) >> 14);
  return tie_t;
}

static void
Field_offset_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0x3ffff) | (tie_t << 0);
}

static unsigned
Field_op2_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_op2_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_op2_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  return tie_t;
}

static void
Field_op2_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_op2_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 10) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_op2_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x200000) | (tie_t << 21);
}

static unsigned
Field_op2_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_op2_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_op2_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_op2_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_op2_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_op2_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_op2_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_op2_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_op2_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_op2_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_op2_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_op2_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_r_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_r_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_r_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_r_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_disp_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_r_disp_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_r_3_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_r_3_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_sa4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  return tie_t;
}

static void
Field_sa4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_sae4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_sae4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_sae_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_sae_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_sae_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_sae_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sae_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_sae_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_sae_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sae_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sae_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_sae_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sae_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sae_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sae_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sae_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sae_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sae_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sae_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sae_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_sal_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_sal_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_sal_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_sal_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_sal_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_sargt_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_sargt_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_sargt_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_sargt_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_sargt_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_sargt_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sas4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_sas4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_sas_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sas_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_sas_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sas_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_sas_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 23) >> 27);
  return tie_t;
}

static void
Field_sas_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0) | (tie_t << 4);
}

static unsigned
Field_sas_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sas_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_sas_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 23) >> 27);
  return tie_t;
}

static void
Field_sas_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0) | (tie_t << 4);
}

static unsigned
Field_sas_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sas_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sas_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sas_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_sas_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sas_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_sas_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sas_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_sas_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 24) >> 27);
  return tie_t;
}

static void
Field_sas_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8) | (tie_t << 3);
}

static unsigned
Field_sas_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sas_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_sas_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 23) >> 27);
  return tie_t;
}

static void
Field_sas_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0) | (tie_t << 4);
}

static unsigned
Field_sas_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sas_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_sas_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 23) >> 27);
  return tie_t;
}

static void
Field_sas_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0) | (tie_t << 4);
}

static unsigned
Field_sas_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_sas_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_sas_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_sas_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_imm4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_mn_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_mn_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_i_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_i_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_imm6lo_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm6lo_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm6lo_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm6lo_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm6hi_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_imm6hi_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_imm6hi_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_imm6hi_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_imm7lo_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm7lo_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm7lo_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm7lo_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm7hi_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_imm7hi_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_imm7hi_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_imm7hi_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_z_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_z_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_imm6_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm6_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_imm7_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm7_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_t2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_t2_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_t2_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_t2_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_t2_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
}

static unsigned
Field_t2_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
}

static unsigned
Field_t2_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 23) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c0) | (tie_t << 6);
}

static unsigned
Field_s2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_s2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_r2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_r2_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 10) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380000) | (tie_t << 19);
}

static unsigned
Field_r2_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_r2_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_r2_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
}

static unsigned
Field_r2_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
}

static unsigned
Field_r2_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_t4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_t4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_t4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_t4_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_t4_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 19) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x1800) | (tie_t << 11);
}

static unsigned
Field_t4_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_t4_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 23) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x180) | (tie_t << 7);
}

static unsigned
Field_s4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_s4_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_s4_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_s4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_s4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_s4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_s4_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 21) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x600) | (tie_t << 9);
}

static unsigned
Field_s4_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_s4_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_s4_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_s4_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_r4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_r4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_r4_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_r4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_r4_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_r4_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
}

static unsigned
Field_r4_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 19) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x1800) | (tie_t << 11);
}

static unsigned
Field_r4_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_t8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_t8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_r8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_r8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_xt_wbr15_imm_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 8) >> 17);
  return tie_t;
}

static void
Field_xt_wbr15_imm_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0xfffe00) | (tie_t << 9);
}

static unsigned
Field_xt_wbr15_imm_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 5) >> 17);
  return tie_t;
}

static void
Field_xt_wbr15_imm_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x7fff000) | (tie_t << 12);
}

static unsigned
Field_xt_wbr15_imm_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 5) >> 17);
  return tie_t;
}

static void
Field_xt_wbr15_imm_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x7fff000) | (tie_t << 12);
}

static unsigned
Field_xt_wbr15_imm_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 5) >> 17);
  return tie_t;
}

static void
Field_xt_wbr15_imm_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x7fff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_arithmetic_v_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_fld_ae_sem_arithmetic_v_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_arithmetic_v_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_arithmetic_v_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_arithmetic_v_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_arithmetic_v_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_arithmetic_v_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_arithmetic_v_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_arithmetic_v_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_arithmetic_v_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_arithmetic_v_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_arithmetic_v_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_arithmetic_v_Slot_ae4_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v_Slot_ae4_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_arithmetic_v_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_arithmetic_v_Slot_ae4_slot4_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v_Slot_ae4_slot4_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_arithmetic_v0_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v0_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_arithmetic_v0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_arithmetic_v0_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v0_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_arithmetic_v0_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v0_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_arithmetic_v0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_arithmetic_v0_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v0_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_arithmetic_v0_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v0_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_fld_ae_sem_arithmetic_v0_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v0_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_fld_ae_sem_arithmetic_v0_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v0_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_arithmetic_v0_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v0_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_arithmetic_v0_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v0_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_arithmetic_v0_Slot_ae4_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v0_Slot_ae4_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_arithmetic_v0_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v0_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_arithmetic_v0_Slot_ae4_slot4_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v0_Slot_ae4_slot4_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 18) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e00) | (tie_t << 9);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 23) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_ae4_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_ae4_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_ae4_slot4_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_ae4_slot4_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_immed_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_immed_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_immed_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_immed_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_immed_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_immed_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_immed_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_immed_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_immed_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_immed_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_immed_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_immed_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_immed_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_immed_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_immed_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_immed_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_immed_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_immed_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_immed_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_immed_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae4_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae4_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 18) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e00) | (tie_t << 9);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 10) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x200000) | (tie_t << 21);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 23) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae4_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae4_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae4_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae4_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_av_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_fld_ae_sem_loads_stores_av_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_av_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 5) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0x7000000) | (tie_t << 24);
}

static unsigned
Field_fld_ae_sem_loads_stores_av_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_av_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_av_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_loads_stores_av_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_av_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_loads_stores_av_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_av_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_loads_stores_av_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_av_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_av_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_av_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_av_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_av_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_av1_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 18) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av1_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e00) | (tie_t << 9);
}

static unsigned
Field_fld_ae_sem_loads_stores_av1_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av1_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_av1_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 10) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av1_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x200000) | (tie_t << 21);
}

static unsigned
Field_fld_ae_sem_loads_stores_av1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_av1_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 8) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av1_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80000) | (tie_t << 19);
}

static unsigned
Field_fld_ae_sem_loads_stores_av1_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av1_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_loads_stores_av1_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av1_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_av1_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av1_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_av1_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av1_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_av1_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av1_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_av1_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av1_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_av1_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av1_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_i128_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i128_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i128_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i128_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i128_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i128_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_i128_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i128_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i128_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i128_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i128_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i128_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i128_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i128_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i128_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i128_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i128_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i128_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i128_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i128_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i128_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i128_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i128_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i128_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i128_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i128_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i128_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i128_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i128_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i128_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i128_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i128_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i3_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 9) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i3_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_loads_stores_i3_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 9) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i3_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_loads_stores_i3_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i3_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_loads_stores_i3_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 9) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i3_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_loads_stores_i3_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i3_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_loads_stores_i3_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 9) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i3_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_loads_stores_i3_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 9) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i3_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_loads_stores_i3_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 9) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i3_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_loads_stores_i3_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 9) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i3_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 23) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64pos_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i8_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i8_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i8_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i8_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_i8_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i8_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i8_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i8_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i8_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i8_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i8_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i8_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i8_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i8_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i8_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i8_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i8_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i8_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i8_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i8_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i8_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i8_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i8_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i8_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_imm2_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_imm2_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_loads_stores_imm2_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_imm2_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_loads_stores_imm2_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_imm2_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_loads_stores_imm2_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_imm2_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_loads_stores_imm2_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_imm2_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_loads_stores_imm2_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_imm2_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_loads_stores_imm2_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_imm2_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_loads_stores_imm2_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_imm2_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_loads_stores_imm2_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_imm2_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_loads_stores_su_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_su_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_loads_stores_su_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_su_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_loads_stores_su_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_su_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_su_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_su_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_su_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_su_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_ae_sem_loads_stores_su_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_su_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_loads_stores_uu_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_uu_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_loads_stores_uu_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_uu_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_loads_stores_uu_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_uu_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_uu_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_uu_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_loads_stores_uu_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_uu_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_uu_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_uu_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_uu_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_uu_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_uu_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_uu_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_uu_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_uu_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_ae_sem_loads_stores_uu_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_uu_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_uu_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_uu_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_uu_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_uu_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_uu_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_uu_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_loads_stores_uu_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_uu_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_loads_stores_uu_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_uu_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_loads_stores_uu_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_uu_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_v1_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 18) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v1_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e00) | (tie_t << 9);
}

static unsigned
Field_fld_ae_sem_loads_stores_v1_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v1_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_v1_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 10) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v1_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x200000) | (tie_t << 21);
}

static unsigned
Field_fld_ae_sem_loads_stores_v1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_v1_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v1_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_v1_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v1_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_loads_stores_v1_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v1_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_v1_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v1_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_v1_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v1_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_loads_stores_v1_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v1_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_loads_stores_v1_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v1_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_v1_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v1_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_v1_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v1_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_v1_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v1_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_v1_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v1_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_v1_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v1_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_v1_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v1_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_v1_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v1_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_ae8_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_ae8_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_shift_a0_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_a0_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_shift_a0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_a0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_shift_a0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_a0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_shift_a0_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_a0_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_shift_a0_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_a0_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_shift_d_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 13) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c000) | (tie_t << 14);
}

static unsigned
Field_fld_ae_sem_shift_d_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 5) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0x7000000) | (tie_t << 24);
}

static unsigned
Field_fld_ae_sem_shift_d_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_shift_d_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_shift_d_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_shift_d_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_shift_d0_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d0_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_shift_d0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_shift_d0_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d0_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_shift_d0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_shift_d0_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d0_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_fld_ae_sem_shift_d0_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d0_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_shift_i16_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_i16_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_shift_i16_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_i16_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_shift_i16_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_i16_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_shift_i16_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_i16_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_shift_i16_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_i16_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_shift_i16_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_i16_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_shift_i32_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_i32_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_fld_ae_sem_shift_i32_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 10) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_i32_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0x380000) | (tie_t << 19);
}

static unsigned
Field_fld_ae_sem_shift_i32_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_i32_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_shift_i32_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 7) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_i32_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000000) | (tie_t << 24);
}

static unsigned
Field_fld_ae_sem_shift_i32_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_i32_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_fld_ae_sem_shift_i64_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 11) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_i64_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x180000) | (tie_t << 19);
}

static unsigned
Field_fld_ae_sem_shift_i64_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_i64_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_shift_i64_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_i64_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
  tie_t = (val << 26) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae_sem_shift_i64_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 11) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_i64_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x180000) | (tie_t << 19);
}

static unsigned
Field_fld_ae_sem_shift_i64_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_i64_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_shift_sd_Slot_ae8_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 18) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_sd_Slot_ae8_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e00) | (tie_t << 9);
}

static unsigned
Field_fld_ae_sem_shift_sd_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_sd_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_shift_sd_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_sd_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_shift_sd_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_sd_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_shift_sd_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 18) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_sd_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e00) | (tie_t << 9);
}

static unsigned
Field_fld_ae_sem_mul_nn_c0_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_nn_c0_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_mul_nn_c1_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[1] << 24) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_nn_c1_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[1] = (insn[1] & ~0xf8) | (tie_t << 3);
}

static unsigned
Field_fld_ae_sem_mul_nn_c2_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[1] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_nn_c2_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[1] = (insn[1] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_mul_nn_c3_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[1] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_nn_c3_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[1] = (insn[1] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_mul_nn_q0_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_nn_q0_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_mul_nn_q1_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_nn_q1_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_mul_nn_q2_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_nn_q2_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_mul_nn_q3_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_nn_q3_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_mul_nn_v0_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_nn_v0_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_mul_nn_v1_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | (insn[1] & 0x7);
  tie_t = (tie_t << 2) | (insn[0] >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_nn_v1_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xc0000000) | (tie_t << 30);
  insn[1] = (insn[1] & ~0x7) | (tie_t >> 2);
}

static unsigned
Field_fld_ae_sem_mul_nn_v2_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[1] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_nn_v2_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[1] = (insn[1] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_mul_nn_v3_Slot_ae8_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[1] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_nn_v3_Slot_ae8_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[1] = (insn[1] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_arithmetic_art_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_art_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_arithmetic_art_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_art_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_arithmetic_ds_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 10) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 21) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_ds_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x600) | (tie_t << 9);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0x380000) | (tie_t << 19);
}

static unsigned
Field_fld_ae_sem_arithmetic_ds_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_ds_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_arithmetic_ds_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_ds_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_arithmetic_ds_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 8) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_ds_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80000) | (tie_t << 19);
}

static unsigned
Field_fld_ae_sem_arithmetic_ds_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_ds_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_arithmetic_ds_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_ds_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_arithmetic_ds_Slot_ae4_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_ds_Slot_ae4_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_arithmetic_ds_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_ds_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_arithmetic_ds_Slot_ae4_slot4_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_ds_Slot_ae4_slot4_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_arithmetic_va_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_va_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_arithmetic_va_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_va_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_arithmetic_va_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_va_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_arithmetic_va_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_va_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_arithmetic_va_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_va_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_arithmetic_va_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_va_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_arithmetic_vs_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 10) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_vs_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x200000) | (tie_t << 21);
}

static unsigned
Field_fld_ae_sem_arithmetic_vs_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_vs_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_arithmetic_vs_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_vs_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_arithmetic_vs_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_vs_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_arithmetic_vs_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_vs_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_arithmetic_vs_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_vs_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_a_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_a_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_a_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_a_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_a_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_a_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_a_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_a_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_a_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_a_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_a_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_a_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_a_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_a_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ab_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ab_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ab_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ab_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ab_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ab_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ab_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ab_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ab_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ab_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ab_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ab_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ab_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ab_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ab_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ab_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ai_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ai_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ai_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ai_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ai_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ai_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ai_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ai_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ai_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ai_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ai_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ai_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ai_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ai_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ai_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ai_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ai_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ai_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_aoe_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_aoe_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_aoe_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_aoe_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_aoe_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_aoe_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_aoe_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_aoe_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_aoe_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_aoe_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_aoe_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_aoe_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_aoe_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_aoe_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_aoe_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_aoe_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_aoe_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_aoe_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_d_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 5) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_d_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0x7000000) | (tie_t << 24);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_d_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_d_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_d_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_d_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_d0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_d0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_d0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_d0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_d0_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_d0_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_d1_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_d1_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_d1_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_d1_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_imm8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_imm8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_imm8_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_imm8_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_imm8_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_imm8_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_imm8_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_imm8_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_imm8_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_imm8_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_v0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_v0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_v0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_v0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_v0_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_v0_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_v0_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_v0_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_v0_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 23) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_v0_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_v0_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_v0_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_v0_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_v0_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_vr_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_vr_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_arr_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_arr_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_arr_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_arr_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_arr_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_arr_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_arr_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_arr_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_bt_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_bt_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_bt_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_bt_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_bt_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_bt_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 8) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80000) | (tie_t << 19);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 17) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0x7800) | (tie_t << 11);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_ds_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_imm2_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 6) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_imm2_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000000) | (tie_t << 24);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_imm2_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 6) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_imm2_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000000) | (tie_t << 24);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_movi_imm_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_movi_imm_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_movi_imm_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_movi_imm_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_movi_imm_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_movi_imm_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
  tie_t = (val << 26) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_movi_imm_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 16) >> 26);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_movi_imm_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_movi_imm_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 26) >> 26);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_movi_imm_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_movi_imm_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_movi_imm_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_movi_imm_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_movi_imm_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_movi_imm_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_movi_imm_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_movi_imm_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 26) >> 26);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_movi_imm_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_hpcmp_br4t_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_br4t_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_hpcmp_vr_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vr_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_hpcmp_vr_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vr_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_hpcmp_vr_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vr_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_hpcmp_vr_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vr_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_hpcmp_vr_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vr_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_hpcmp_vr_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vr_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_hpcmp_vr_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vr_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_hpcmp_vr_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vr_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_hpcmp_vr_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vr_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_hpcmp_vr_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vr_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_hpcmp_vs_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vs_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_hpcmp_vs_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vs_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_hpcmp_vs_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vs_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_hpcmp_vs_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vs_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_hpcmp_vs_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vs_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_hpcmp_vs_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vs_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_hpcmp_vs_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vs_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_hpcmp_vs_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vs_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_hpcmp_vs_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vs_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_hpcnv_arr_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcnv_arr_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_hpcnv_arr_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcnv_arr_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_hpcnv_art_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcnv_art_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_hpcnv_art_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcnv_art_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_hpcnv_i_imm4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcnv_i_imm4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_hpcnv_i_imm4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcnv_i_imm4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_hpcnv_vr_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcnv_vr_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_hpcnv_vr_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcnv_vr_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_hpcnv_vr_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcnv_vr_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_hpcnv_vt_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 5) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcnv_vt_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0x7000000) | (tie_t << 24);
}

static unsigned
Field_fld_ae_sem_hpcnv_vt_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcnv_vt_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_hpcnv_vt_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcnv_vt_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_hprminmaxnum_vr_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_hprminmaxnum_vr_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_hprminmaxnum_vr_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_hprminmaxnum_vr_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_hprminmaxnum_vr_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hprminmaxnum_vr_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_hprminmaxnum_vt_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 5) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_hprminmaxnum_vt_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0x7000000) | (tie_t << 24);
}

static unsigned
Field_fld_ae_sem_hprminmaxnum_vt_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hprminmaxnum_vt_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_hprminmaxnum_vt_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hprminmaxnum_vt_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_lb_ops_iba_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_lb_ops_iba_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_lb_ops_iba_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_lb_ops_iba_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_lb_ops_iba_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_lb_ops_iba_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_lb_ops_iba_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_lb_ops_iba_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_end_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_end_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_loads_stores_end_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_end_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_end_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_end_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_end_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_end_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64half_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64half_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64half_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64half_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64half_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64half_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64half_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64half_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64half_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64half_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64half_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64half_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64half_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64half_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64half_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64half_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64half_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64half_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64half_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64half_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64half_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64half_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64half_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64half_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64half_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64half_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 29) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x6) | (tie_t << 1);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae9_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae9_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae10_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae10_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae10_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64neg_Slot_ae10_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_vu_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_vu_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_vu_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_vu_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_vu_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_vu_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_vu_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_vu_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_pks_d_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_d_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_pks_d_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_d_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_pks_d_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_d_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_pks_d_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_d_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_pks_d_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_d_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_pks_d_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_d_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_pks_d_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_d_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_pks_d_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_d_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_pks_d_Slot_ae4_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_d_Slot_ae4_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_pks_pos_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_pos_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_pks_pos_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_pos_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_pks_pos_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_pos_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_ae_sem_pks_pos_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_pos_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_pks_pos_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 25) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_pos_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_pks_pos_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_pos_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_pks_pos_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 19) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_pos_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x1800) | (tie_t << 11);
}

static unsigned
Field_fld_ae_sem_pks_pos_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_pos_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_pks_pos_Slot_ae4_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_pos_Slot_ae4_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_pks_s_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 10) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_s_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x200000) | (tie_t << 21);
}

static unsigned
Field_fld_ae_sem_pks_s_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_s_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_pks_s_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_s_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_pks_s_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_s_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_pks_s_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_s_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_pks_s_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_s_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_pks_s_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_s_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_pks_s_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_s_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_pks_s_Slot_ae4_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_s_Slot_ae4_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_rng_v0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_rng_v0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_rng_v1_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_rng_v1_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_sb_loads_stores_iba_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_sb_loads_stores_iba_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_sb_loads_stores_iba_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_sb_loads_stores_iba_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_shift_a_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_a_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_shift_a_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_a_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_shift_d1_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d1_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_shift_d1_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d1_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_shift_da_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_da_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_shift_da_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 8) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_da_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80000) | (tie_t << 19);
}

static unsigned
Field_fld_ae_sem_shift_da_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_da_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_shift_imm32_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_imm32_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_shift_imm32_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_imm32_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_shift_imm8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 18) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_imm8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x2000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_shift_imm8_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_imm8_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_sp32cvt_arr_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_sp32cvt_arr_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_sp32cvt_arr_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_sp32cvt_arr_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_sp32cvt_arr_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_sp32cvt_arr_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_sp32cvt_art_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_sp32cvt_art_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_sp32cvt_art_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_sp32cvt_art_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_sp32cvt_art_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_sp32cvt_art_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_sp32cvt_i_imm5_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 5) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_sp32cvt_i_imm5_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0x7000000) | (tie_t << 24);
}

static unsigned
Field_fld_ae_sem_sp32cvt_i_imm5_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 9) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_sp32cvt_i_imm5_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_sp32cvt_i_imm5_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 9) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_sp32cvt_i_imm5_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_sp32cvt_vr_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_sp32cvt_vr_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_sp32cvt_vr_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_sp32cvt_vr_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_sp32cvt_vr_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_sp32cvt_vr_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_sp32cvt_vt_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_sp32cvt_vt_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_sp32cvt_vt_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_sp32cvt_vt_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_sp32cvt_vt_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_sp32cvt_vt_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_spmisc_brt_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 10) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_brt_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380000) | (tie_t << 19);
}

static unsigned
Field_fld_ae_sem_spmisc_brt_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_brt_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_spmisc_brt_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_brt_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_fld_ae_sem_spmisc_brt_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 14) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_brt_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x38000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_spmisc_brt_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_brt_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spmisc_brt_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_brt_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_fld_ae_sem_spmisc_brt_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_brt_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spmisc_brt_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_brt_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spmisc_vr_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 13) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vr_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_sem_spmisc_vr_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vr_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_spmisc_vr_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vr_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_spmisc_vr_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vr_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_spmisc_vr_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vr_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spmisc_vr_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vr_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_fld_ae_sem_spmisc_vr_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vr_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_spmisc_vr_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vr_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_spmisc_vr_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vr_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_spmisc_vr_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vr_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_spmisc_vr_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vr_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_spmisc_vr_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vr_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_spmisc_vs_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vs_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_spmisc_vs_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vs_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spmisc_vs_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vs_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_spmisc_vs_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vs_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_spmisc_vs_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vs_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spmisc_vs_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vs_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_spmisc_vs_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vs_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spmisc_vs_Slot_ae9_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 14) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vs_Slot_ae9_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_sem_spmisc_vs_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vs_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_spmisc_vs_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vs_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_spmisc_vs_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vs_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_spmisc_vs_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vs_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_arithmetic_e_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 13) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_e_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60000) | (tie_t << 17);
}

static unsigned
Field_fld_ae_sem_arithmetic_e_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_e_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_arithmetic_ep_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_ep_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_arithmetic_ep1_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 13) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_ep1_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60000) | (tie_t << 17);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ei_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 13) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ei_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60000) | (tie_t << 17);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ei_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ei_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ei_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ei_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ei_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ei_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_eo_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_eo_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_eo_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_eo_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_eo_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_eo_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_eo_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_eo_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_immed_n_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 25) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_immed_n_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_immed_n_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 25) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_immed_n_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_immed_n_Slot_ae4_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_immed_n_Slot_ae4_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_fpmov_i_imm4_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_i_imm4_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_fpmov_i_imm4_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_i_imm4_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_fpmov_i_imm4_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_i_imm4_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_fpmov_i_imm4_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 23) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_i_imm4_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_fpmov_i_imm4_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_i_imm4_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_fpmov_i_imm4_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_i_imm4_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_fpmov_i_imm4_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_i_imm4_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_fpmov_i_imm4_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_i_imm4_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_fpmov_i_imm4_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 18) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_i_imm4_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_fpmov_vr_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vr_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_fpmov_vr_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vr_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_fpmov_vr_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vr_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_fpmov_vr_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vr_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_fpmov_vr_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vr_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_fpmov_vr_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vr_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_fpmov_vr_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vr_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_fpmov_vr_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vr_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_fpmov_vr_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vr_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_fpmov_vs_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vs_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_fpmov_vs_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vs_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_fpmov_vs_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vs_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_fpmov_vs_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vs_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_fpmov_vs_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vs_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_fpmov_vs_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vs_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_fpmov_vs_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vs_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_fpmov_vs_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vs_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_fpmov_vs_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vs_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_fpmov_vt_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vt_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_fpmov_vt_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vt_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_fpmov_vt_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vt_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_fpmov_vt_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vt_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_fpmov_vt_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vt_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_fpmov_vt_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vt_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_fpmov_vt_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vt_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_fpmov_vt_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vt_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_fpmov_vt_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vt_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_fpmov_vu_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vu_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_fpmov_vu_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vu_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_fpmov_vu_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vu_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_fpmov_vu_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vu_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_fpmov_vu_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vu_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_fpmov_vu_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vu_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_fpmov_vu_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vu_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_fpmov_vu_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vu_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_fpmov_vu_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_fpmov_vu_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_hpcmp_vt_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vt_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_hpcmp_vt_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vt_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_hpcmp_vt_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vt_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_hpcmp_vt_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vt_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_hpcmp_vt_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vt_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_hpcmp_vt_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vt_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_hpcmp_vt_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vt_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_hpcmp_vt_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vt_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_hpcmp_vt_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcmp_vt_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_hpcnv_vs_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpcnv_vs_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_hpfma_vr_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vr_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_hpfma_vr_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vr_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_hpfma_vr_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vr_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_hpfma_vr_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vr_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_hpfma_vr_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vr_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_hpfma_vr_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vr_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_hpfma_vr_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vr_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_hpfma_vr_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vr_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_hpfma_vs_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vs_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_hpfma_vs_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vs_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_hpfma_vs_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vs_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_hpfma_vs_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vs_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_hpfma_vs_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vs_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_hpfma_vs_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vs_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_hpfma_vs_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vs_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_hpfma_vs_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vs_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_hpfma_vt_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vt_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_hpfma_vt_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vt_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_hpfma_vt_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vt_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_hpfma_vt_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vt_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_hpfma_vt_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vt_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_hpfma_vt_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vt_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_hpfma_vt_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vt_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_hpfma_vt_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vt_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_movfpstate_v_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_movfpstate_v_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_multiply_acc_ep_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 25) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_acc_ep_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_multiply_acc_ep_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_acc_ep_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_multiply_d0_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d0_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_multiply_d0_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d0_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_multiply_d0_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d0_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_multiply_d0_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d0_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_multiply_d0_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d0_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_multiply_d0_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d0_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_multiply_d0_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d0_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_multiply_d0_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d0_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_multiply_d0_Slot_ae4_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d0_Slot_ae4_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_multiply_d0_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d0_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_multiply_d2_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d2_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_multiply_d2_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d2_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_multiply_d2_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d2_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_multiply_d2_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d2_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_multiply_d2_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d2_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_multiply_d2_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d2_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_multiply_d2_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d2_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_multiply_d2_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d2_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_multiply_d2_Slot_ae4_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d2_Slot_ae4_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_multiply_d2_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d2_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_multiply_q0_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_q0_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_multiply_q0_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_q0_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_multiply_q0_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_q0_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_multiply_q0_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_q0_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_multiply_q0_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_q0_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_multiply_q0_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_q0_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_multiply_q0_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_q0_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_multiply_q0_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_q0_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_multiply_q0_Slot_ae4_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_q0_Slot_ae4_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_multiply_q0_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_q0_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_multiply_q1_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_q1_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_multiply_q1_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_q1_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_multiply_q1_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_q1_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_multiply_q1_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_q1_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_multiply_q1_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_q1_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_multiply_q1_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_q1_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_multiply_q1_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_q1_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_multiply_q1_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_q1_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_reduction_sort_ds_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_reduction_sort_ds_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_reduction_sort_ds_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_reduction_sort_ds_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_reduction_sort_ds_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_reduction_sort_ds_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_reduction_sort_v_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_reduction_sort_v_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_reduction_sort_v_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_reduction_sort_v_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_reduction_sort_v_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_reduction_sort_v_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_reduction_sort_v0_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_reduction_sort_v0_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_reduction_sort_v0_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_reduction_sort_v0_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_reduction_sort_v0_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_reduction_sort_v0_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_select_isel_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_isel_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_select_isel_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_isel_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_select_isel_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_isel_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_select_isel_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_isel_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_select_isel_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_isel_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_select_isel_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_isel_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_select_ss_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_ss_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_select_ss_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_ss_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_select_ss_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_ss_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_select_ss_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_ss_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_select_ss_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_ss_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_select_ss_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_ss_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_select_ss_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_ss_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_select_ss_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_ss_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_select_ss_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_ss_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_select_ss_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_ss_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_select_vr_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vr_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_select_vr_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vr_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_select_vr_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vr_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_select_vr_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vr_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_select_vr_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vr_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_select_vr_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vr_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_select_vr_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vr_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_select_vr_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vr_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_select_vr_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vr_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_select_vr_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vr_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_select_vs_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vs_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_select_vs_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vs_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_select_vs_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vs_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_select_vs_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vs_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_select_vs_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vs_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_select_vs_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vs_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_select_vs_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vs_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_select_vs_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vs_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_select_vs_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vs_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_select_vs_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vs_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_select_vt_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vt_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_select_vt_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vt_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_select_vt_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vt_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_select_vt_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vt_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_select_vt_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vt_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_select_vt_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vt_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_select_vt_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vt_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_select_vt_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vt_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_select_vt_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vt_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_select_vt_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vt_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_select_vu_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vu_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_select_vu_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vu_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_select_vu_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vu_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_select_vu_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vu_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_select_vu_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vu_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_select_vu_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vu_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_select_vu_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vu_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_select_vu_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vu_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_select_vu_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_select_vu_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spaddsub_vr_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vr_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spaddsub_vr_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vr_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_spaddsub_vr_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vr_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spaddsub_vr_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vr_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spaddsub_vr_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vr_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_spaddsub_vr_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vr_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_spaddsub_vr_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vr_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_spaddsub_vr_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vr_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_spaddsub_vs_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vs_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_spaddsub_vs_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vs_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_spaddsub_vs_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vs_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spaddsub_vs_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vs_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_spaddsub_vs_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vs_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_spaddsub_vs_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vs_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_spaddsub_vs_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vs_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_spaddsub_vs_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vs_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_spaddsub_vt_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vt_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_spaddsub_vt_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vt_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_spaddsub_vt_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vt_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_spaddsub_vt_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vt_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spaddsub_vt_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vt_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_spaddsub_vt_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vt_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spaddsub_vt_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vt_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_spaddsub_vt_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vt_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spaddsub_vu_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vu_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_spaddsub_vu_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vu_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spaddsub_vu_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vu_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_spaddsub_vu_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vu_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_spaddsub_vu_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vu_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spaddsub_vu_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vu_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spaddsub_vu_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vu_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spaddsub_vu_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vu_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spfma_i_imm1_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_i_imm1_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spfma_i_imm1_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_i_imm1_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spfma_i_imm1_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 6) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_i_imm1_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_spfma_i_imm1_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 6) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_i_imm1_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_spfma_i_imm1_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 6) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_i_imm1_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_spfma_i_imm1_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 1) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_i_imm1_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40000000) | (tie_t << 30);
}

static unsigned
Field_fld_ae_sem_spfma_i_imm1_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 1) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_i_imm1_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40000000) | (tie_t << 30);
}

static unsigned
Field_fld_ae_sem_spfma_i_imm3_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_i_imm3_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spfma_i_imm3_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_i_imm3_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spfma_i_imm3_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 4) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_i_imm3_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_spfma_i_imm3_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 4) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_i_imm3_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_spfma_i_imm3_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 4) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_i_imm3_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_spfma_i_imm3_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | (insn[1] & 0x1);
  tie_t = (tie_t << 2) | (insn[0] >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_i_imm3_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xc0000000) | (tie_t << 30);
  insn[1] = (insn[1] & ~0x1) | (tie_t >> 2);
}

static unsigned
Field_fld_ae_sem_spfma_i_imm3_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | (insn[1] & 0x1);
  tie_t = (tie_t << 2) | (insn[0] >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_i_imm3_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xc0000000) | (tie_t << 30);
  insn[1] = (insn[1] & ~0x1) | (tie_t >> 2);
}

static unsigned
Field_fld_ae_sem_spfma_vp_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vp_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spfma_vp_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vp_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_spfma_vp_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vp_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_spfma_vp_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vp_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_spfma_vp_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vp_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_spfma_vp_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vp_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_spfma_vp_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vp_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_spfma_vr_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vr_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spfma_vr_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vr_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_spfma_vr_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vr_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spfma_vr_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vr_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spfma_vr_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vr_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_spfma_vr_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vr_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_spfma_vr_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vr_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_spfma_vr_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vr_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_spfma_vs_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vs_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_spfma_vs_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vs_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_spfma_vs_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vs_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spfma_vs_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vs_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_spfma_vs_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vs_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_spfma_vs_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vs_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_spfma_vs_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vs_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_spfma_vs_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vs_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_spfma_vt_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vt_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_spfma_vt_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vt_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_spfma_vt_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vt_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_spfma_vt_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vt_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_spfma_vt_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vt_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spfma_vt_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vt_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spfma_vt_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vt_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spfma_vt_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vt_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spmisc_vsm_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vsm_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spmisc_vsm_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vsm_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_spmisc_vsm_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vsm_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spmisc_vsm_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vsm_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spmisc_vsm_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vsm_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_spmisc_vsm_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vsm_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_spmisc_vsm_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vsm_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_spmisc_vsm_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vsm_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_spmisc_vt_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vt_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_spmisc_vt_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vt_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spmisc_vt_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vt_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_spmisc_vt_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vt_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_spmisc_vt_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vt_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spmisc_vt_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vt_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spmisc_vt_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vt_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spmisc_vt_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vt_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spmisc_vtm_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vtm_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_spmisc_vtm_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vtm_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spmisc_vtm_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vtm_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_spmisc_vtm_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vtm_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spmisc_vtm_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vtm_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_spmisc_vtm_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vtm_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spmisc_vtm_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vtm_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spmisc_vtm_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spmisc_vtm_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_imm_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 13) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_imm_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x78000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_multiply_d1_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d1_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_multiply_d1_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d1_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_multiply_d1_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d1_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_multiply_d1_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d1_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_multiply_d1_Slot_ae4_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d1_Slot_ae4_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_multiply_d3_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d3_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_multiply_d3_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d3_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_multiply_d3_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d3_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_multiply_d3_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_multiply_d3_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_rng_d_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_rng_d_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_shift_e_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 15) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_e_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_shift_i8_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_i8_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae_sem_spaddsub_vp_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 12) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vp_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_sem_spaddsub_vp_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vp_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spaddsub_vp_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vp_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spaddsub_vq_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 17) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vq_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_spaddsub_vq_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vq_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_spaddsub_vq_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spaddsub_vq_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ar_s_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ar_s_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_ar_s_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_ar_s_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_sb_loads_stores_iba2_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_sb_loads_stores_iba2_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_ardecnorm16_ar_u_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_ardecnorm16_ar_u_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_lb_db_ops_ar_u_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_lb_db_ops_ar_u_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_lb_db_ops_iba_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_lb_db_ops_iba_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_rng_a_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_rng_a_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_rng_art_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_rng_art_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_rng_i2_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_rng_i2_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_ae_sem_rng_imm2_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_rng_imm2_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_hpfma_vp_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vp_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_hpfma_vp_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vp_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_hpfma_vp_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vp_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_hpfma_vu_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vu_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_hpfma_vu_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vu_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_hpfma_vu_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vu_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_spfma_vu_Slot_ae9_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vu_Slot_ae9_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spfma_vu_Slot_ae9_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vu_Slot_ae9_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spfma_vu_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vu_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spfma_vu_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vu_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_hpfma_vq_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vq_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_hpfma_vq_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_hpfma_vq_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_ae_sem_spfma_vq_Slot_ae10_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vq_Slot_ae10_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_ae_sem_spfma_vq_Slot_ae10_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 2) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_vq_Slot_ae10_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e000000) | (tie_t << 25);
}

static unsigned
Field_fld_inst_12_12_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_fld_inst_12_12_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_inst_12_8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_inst_12_8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_inst_13_8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 18) >> 26);
  return tie_t;
}

static void
Field_fld_inst_13_8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f00) | (tie_t << 8);
}

static unsigned
Field_fld_inst_19_17_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  return tie_t;
}

static void
Field_fld_inst_19_17_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_fld_inst_19_18_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  return tie_t;
}

static void
Field_fld_inst_19_18_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_fld_inst_23_12_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 8) >> 20);
  return tie_t;
}

static void
Field_fld_inst_23_12_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff000) | (tie_t << 12);
}

static unsigned
Field_fld_inst_23_16_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 8) >> 24);
  return tie_t;
}

static void
Field_fld_inst_23_16_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0000) | (tie_t << 16);
}

static unsigned
Field_fld_inst_4_4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_fld_inst_4_4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_fld_inst_5_4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_inst_5_4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_inst_7_4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_inst_7_4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_inst_7_6_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_inst_7_6_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_inst_7_7_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_inst_7_7_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_inst_9_8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_inst_9_8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static void
Implicit_Field_set (xtensa_insnbuf insn ATTRIBUTE_UNUSED,
		    uint32 val ATTRIBUTE_UNUSED)
{
  /* Do nothing.  */
}

static unsigned
Implicit_Field_ar0_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_ar4_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 4;
}

static unsigned
Implicit_Field_ar8_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 8;
}

static unsigned
Implicit_Field_ar12_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 12;
}

static unsigned
Implicit_Field_bt16_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_bs16_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_br16_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_brall_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

enum xtensa_field_id {
  FIELD_t,
  FIELD_bbi4,
  FIELD_bbi,
  FIELD_imm12,
  FIELD_imm8,
  FIELD_s,
  FIELD_s8,
  FIELD_imms8,
  FIELD_imm12b,
  FIELD_imm16,
  FIELD_m,
  FIELD_n,
  FIELD_offset,
  FIELD_op0,
  FIELD_op1,
  FIELD_op2,
  FIELD_r,
  FIELD_r_disp,
  FIELD_r_3,
  FIELD_sa4,
  FIELD_sae4,
  FIELD_sae,
  FIELD_sal,
  FIELD_sargt,
  FIELD_sas4,
  FIELD_sas,
  FIELD_sr,
  FIELD_st,
  FIELD_thi3,
  FIELD_imm4,
  FIELD_mn,
  FIELD_i,
  FIELD_imm6lo,
  FIELD_imm6hi,
  FIELD_imm7lo,
  FIELD_imm7hi,
  FIELD_z,
  FIELD_imm6,
  FIELD_imm7,
  FIELD_t2,
  FIELD_s2,
  FIELD_r2,
  FIELD_t4,
  FIELD_s4,
  FIELD_r4,
  FIELD_t8,
  FIELD_r8,
  FIELD_xt_wbr15_imm,
  FIELD_ae_fld_Inst16b_12,
  FIELD_ae_fld_Inst16b_15_13,
  FIELD_fld_ae8_slot0_13_12,
  FIELD_fld_ae8_slot0_13_13,
  FIELD_fld_ae8_slot0_13_4,
  FIELD_fld_ae8_slot0_13_9,
  FIELD_fld_ae8_slot0_17_4,
  FIELD_fld_ae8_slot0_17_8,
  FIELD_fld_ae8_slot0_31_12,
  FIELD_fld_ae8_slot0_31_15,
  FIELD_fld_ae8_slot0_31_18,
  FIELD_fld_ae8_slot0_31_19,
  FIELD_fld_ae8_slot0_31_20,
  FIELD_fld_ae8_slot0_31_21,
  FIELD_fld_ae8_slot0_31_22,
  FIELD_fld_ae8_slot0_31_23,
  FIELD_fld_ae8_slot0_31_7,
  FIELD_fld_ae8_slot0_31_8,
  FIELD_fld_ae8_slot0_31_9,
  FIELD_fld_ae8_slot0_3_0,
  FIELD_fld_ae8_slot0_6_0,
  FIELD_fld_ae8_slot0_7_4,
  FIELD_fld_ae8_slot0_7_5,
  FIELD_fld_ae8_slot0_7_7,
  FIELD_fld_ae8_slot0_8_0,
  FIELD_fld_ae_sem_arithmetic_v,
  FIELD_fld_ae_sem_arithmetic_v0,
  FIELD_fld_ae_sem_arithmetic_v1,
  FIELD_fld_ae_sem_dr_to_dr_immed,
  FIELD_fld_ae_sem_dr_to_dr_v,
  FIELD_fld_ae_sem_dr_to_dr_v0,
  FIELD_fld_ae_sem_dr_to_dr_v1,
  FIELD_fld_ae_sem_loads_stores_a,
  FIELD_fld_ae_sem_loads_stores_av,
  FIELD_fld_ae_sem_loads_stores_av1,
  FIELD_fld_ae_sem_loads_stores_i128,
  FIELD_fld_ae_sem_loads_stores_i16,
  FIELD_fld_ae_sem_loads_stores_i3,
  FIELD_fld_ae_sem_loads_stores_i32,
  FIELD_fld_ae_sem_loads_stores_i64,
  FIELD_fld_ae_sem_loads_stores_i64pos,
  FIELD_fld_ae_sem_loads_stores_i8,
  FIELD_fld_ae_sem_loads_stores_imm2,
  FIELD_fld_ae_sem_loads_stores_su,
  FIELD_fld_ae_sem_loads_stores_uu,
  FIELD_fld_ae_sem_loads_stores_v,
  FIELD_fld_ae_sem_loads_stores_v1,
  FIELD_fld_ae_sem_loads_stores_x,
  FIELD_fld_ae_sem_shift_a0,
  FIELD_fld_ae_sem_shift_d,
  FIELD_fld_ae_sem_shift_d0,
  FIELD_fld_ae_sem_shift_i16,
  FIELD_fld_ae_sem_shift_i32,
  FIELD_fld_ae_sem_shift_i64,
  FIELD_fld_ae_sem_shift_sd,
  FIELD_fld_ae8_slot1_17_13,
  FIELD_fld_ae8_slot1_17_14,
  FIELD_fld_ae8_slot1_17_15,
  FIELD_fld_ae8_slot1_17_8,
  FIELD_fld_ae8_slot1_29_12,
  FIELD_fld_ae8_slot1_29_13,
  FIELD_fld_ae8_slot1_29_18,
  FIELD_fld_ae8_slot1_29_20,
  FIELD_fld_ae8_slot1_29_22,
  FIELD_fld_ae8_slot1_29_23,
  FIELD_fld_ae8_slot1_29_5,
  FIELD_fld_ae8_slot1_29_8,
  FIELD_fld_ae8_slot1_29_9,
  FIELD_fld_ae8_slot1_3_0,
  FIELD_fld_ae8_slot1_3_3,
  FIELD_fld_ae8_slot1_4_0,
  FIELD_fld_ae8_slot1_7_4,
  FIELD_fld_ae8_slot2_19_10,
  FIELD_fld_ae8_slot2_19_15,
  FIELD_fld_ae8_slot2_33_15,
  FIELD_fld_ae8_slot2_33_25,
  FIELD_fld_ae8_slot2_33_9,
  FIELD_fld_ae8_slot2_34_30,
  FIELD_fld_ae8_slot2_39_35,
  FIELD_fld_ae8_slot2_44_35,
  FIELD_fld_ae8_slot2_58_34,
  FIELD_fld_ae8_slot2_58_35,
  FIELD_fld_ae8_slot2_58_40,
  FIELD_fld_ae8_slot2_58_50,
  FIELD_fld_ae8_slot2_8_0,
  FIELD_fld_ae8_slot2_9_0,
  FIELD_fld_ae_sem_mul_nn_c0,
  FIELD_fld_ae_sem_mul_nn_c1,
  FIELD_fld_ae_sem_mul_nn_c2,
  FIELD_fld_ae_sem_mul_nn_c3,
  FIELD_fld_ae_sem_mul_nn_q0,
  FIELD_fld_ae_sem_mul_nn_q1,
  FIELD_fld_ae_sem_mul_nn_q2,
  FIELD_fld_ae_sem_mul_nn_q3,
  FIELD_fld_ae_sem_mul_nn_v0,
  FIELD_fld_ae_sem_mul_nn_v1,
  FIELD_fld_ae_sem_mul_nn_v2,
  FIELD_fld_ae_sem_mul_nn_v3,
  FIELD_fld_ae_sem_arithmetic_art,
  FIELD_fld_ae_sem_arithmetic_ds,
  FIELD_fld_ae_sem_arithmetic_va,
  FIELD_fld_ae_sem_arithmetic_vs,
  FIELD_fld_ae_sem_dr_to_ar_a,
  FIELD_fld_ae_sem_dr_to_ar_ab,
  FIELD_fld_ae_sem_dr_to_ar_ai,
  FIELD_fld_ae_sem_dr_to_ar_aoe,
  FIELD_fld_ae_sem_dr_to_ar_d,
  FIELD_fld_ae_sem_dr_to_ar_d0,
  FIELD_fld_ae_sem_dr_to_ar_d1,
  FIELD_fld_ae_sem_dr_to_ar_imm8,
  FIELD_fld_ae_sem_dr_to_ar_v0,
  FIELD_fld_ae_sem_dr_to_ar_vr,
  FIELD_fld_ae_sem_dr_to_dr_arr,
  FIELD_fld_ae_sem_dr_to_dr_bt,
  FIELD_fld_ae_sem_dr_to_dr_ds,
  FIELD_fld_ae_sem_dr_to_dr_imm2,
  FIELD_fld_ae_sem_dr_to_dr_movi_imm,
  FIELD_fld_ae_sem_hpcmp_br4t,
  FIELD_fld_ae_sem_hpcmp_vr,
  FIELD_fld_ae_sem_hpcmp_vs,
  FIELD_fld_ae_sem_hpcnv_arr,
  FIELD_fld_ae_sem_hpcnv_art,
  FIELD_fld_ae_sem_hpcnv_i_imm4,
  FIELD_fld_ae_sem_hpcnv_vr,
  FIELD_fld_ae_sem_hpcnv_vt,
  FIELD_fld_ae_sem_hprminmaxnum_vr,
  FIELD_fld_ae_sem_hprminmaxnum_vt,
  FIELD_fld_ae_sem_lb_ops_iba,
  FIELD_fld_ae_sem_loads_stores_end,
  FIELD_fld_ae_sem_loads_stores_i64half,
  FIELD_fld_ae_sem_loads_stores_i64neg,
  FIELD_fld_ae_sem_loads_stores_vu,
  FIELD_fld_ae_sem_pks_d,
  FIELD_fld_ae_sem_pks_pos,
  FIELD_fld_ae_sem_pks_s,
  FIELD_fld_ae_sem_rng_v0,
  FIELD_fld_ae_sem_rng_v1,
  FIELD_fld_ae_sem_sb_loads_stores_iba,
  FIELD_fld_ae_sem_shift_a,
  FIELD_fld_ae_sem_shift_d1,
  FIELD_fld_ae_sem_shift_da,
  FIELD_fld_ae_sem_shift_imm32,
  FIELD_fld_ae_sem_shift_imm8,
  FIELD_fld_ae_sem_sp32cvt_arr,
  FIELD_fld_ae_sem_sp32cvt_art,
  FIELD_fld_ae_sem_sp32cvt_i_imm5,
  FIELD_fld_ae_sem_sp32cvt_vr,
  FIELD_fld_ae_sem_sp32cvt_vt,
  FIELD_fld_ae_sem_spmisc_brt,
  FIELD_fld_ae_sem_spmisc_vr,
  FIELD_fld_ae_sem_spmisc_vs,
  FIELD_fld_ae_slot0_11_10,
  FIELD_fld_ae_slot0_11_11,
  FIELD_fld_ae_slot0_11_8,
  FIELD_fld_ae_slot0_11_9,
  FIELD_fld_ae_slot0_12_0,
  FIELD_fld_ae_slot0_12_10,
  FIELD_fld_ae_slot0_12_12,
  FIELD_fld_ae_slot0_12_2,
  FIELD_fld_ae_slot0_12_6,
  FIELD_fld_ae_slot0_12_8,
  FIELD_fld_ae_slot0_12_9,
  FIELD_fld_ae_slot0_14_12,
  FIELD_fld_ae_slot0_14_13,
  FIELD_fld_ae_slot0_17_10,
  FIELD_fld_ae_slot0_17_12,
  FIELD_fld_ae_slot0_17_13,
  FIELD_fld_ae_slot0_17_14,
  FIELD_fld_ae_slot0_17_15,
  FIELD_fld_ae_slot0_17_16,
  FIELD_fld_ae_slot0_17_17,
  FIELD_fld_ae_slot0_17_8,
  FIELD_fld_ae_slot0_18_13,
  FIELD_fld_ae_slot0_18_15,
  FIELD_fld_ae_slot0_18_16,
  FIELD_fld_ae_slot0_18_8,
  FIELD_fld_ae_slot0_19_12,
  FIELD_fld_ae_slot0_19_15,
  FIELD_fld_ae_slot0_19_19,
  FIELD_fld_ae_slot0_19_8,
  FIELD_fld_ae_slot0_1_0,
  FIELD_fld_ae_slot0_20_16,
  FIELD_fld_ae_slot0_20_20,
  FIELD_fld_ae_slot0_23_15,
  FIELD_fld_ae_slot0_23_17,
  FIELD_fld_ae_slot0_23_19,
  FIELD_fld_ae_slot0_23_22,
  FIELD_fld_ae_slot0_28_10,
  FIELD_fld_ae_slot0_28_12,
  FIELD_fld_ae_slot0_28_14,
  FIELD_fld_ae_slot0_28_15,
  FIELD_fld_ae_slot0_28_16,
  FIELD_fld_ae_slot0_28_17,
  FIELD_fld_ae_slot0_28_19,
  FIELD_fld_ae_slot0_28_21,
  FIELD_fld_ae_slot0_28_22,
  FIELD_fld_ae_slot0_28_24,
  FIELD_fld_ae_slot0_28_26,
  FIELD_fld_ae_slot0_28_27,
  FIELD_fld_ae_slot0_28_4,
  FIELD_fld_ae_slot0_28_8,
  FIELD_fld_ae_slot0_3_0,
  FIELD_fld_ae_slot0_3_1,
  FIELD_fld_ae_slot0_3_2,
  FIELD_fld_ae_slot0_3_3,
  FIELD_fld_ae_slot0_4_0,
  FIELD_fld_ae_slot0_4_4,
  FIELD_fld_ae_slot0_5_0,
  FIELD_fld_ae_slot0_5_4,
  FIELD_fld_ae_slot0_7_0,
  FIELD_fld_ae_slot0_7_2,
  FIELD_fld_ae_slot0_7_3,
  FIELD_fld_ae_slot0_7_4,
  FIELD_fld_ae_slot0_8_8,
  FIELD_fld_ae_slot0_9_4,
  FIELD_fld_ae_slot0_9_8,
  FIELD_fld_ae_slot0_9_9,
  FIELD_fld_ae_slot1_0_0,
  FIELD_fld_ae_slot1_12_8,
  FIELD_fld_ae_slot1_17_13,
  FIELD_fld_ae_slot1_17_17,
  FIELD_fld_ae_slot1_17_8,
  FIELD_fld_ae_slot1_25_1,
  FIELD_fld_ae_slot1_25_12,
  FIELD_fld_ae_slot1_25_13,
  FIELD_fld_ae_slot1_25_16,
  FIELD_fld_ae_slot1_25_17,
  FIELD_fld_ae_slot1_25_18,
  FIELD_fld_ae_slot1_25_20,
  FIELD_fld_ae_slot1_25_22,
  FIELD_fld_ae_slot1_25_23,
  FIELD_fld_ae_slot1_25_8,
  FIELD_fld_ae_slot1_25_9,
  FIELD_fld_ae_slot1_3_0,
  FIELD_fld_ae_slot1_3_2,
  FIELD_fld_ae_slot1_3_3,
  FIELD_fld_ae_slot1_7_4,
  FIELD_fld_ae_sem_arithmetic_e,
  FIELD_fld_ae_sem_arithmetic_ep,
  FIELD_fld_ae_sem_arithmetic_ep1,
  FIELD_fld_ae_sem_dr_to_ar_ei,
  FIELD_fld_ae_sem_dr_to_ar_eo,
  FIELD_fld_ae_sem_dr_to_dr_immed_N,
  FIELD_fld_ae_sem_fpmov_i_imm4,
  FIELD_fld_ae_sem_fpmov_vr,
  FIELD_fld_ae_sem_fpmov_vs,
  FIELD_fld_ae_sem_fpmov_vt,
  FIELD_fld_ae_sem_fpmov_vu,
  FIELD_fld_ae_sem_hpcmp_vt,
  FIELD_fld_ae_sem_hpcnv_vs,
  FIELD_fld_ae_sem_hpfma_vr,
  FIELD_fld_ae_sem_hpfma_vs,
  FIELD_fld_ae_sem_hpfma_vt,
  FIELD_fld_ae_sem_movfpstate_v,
  FIELD_fld_ae_sem_multiply_acc_ep,
  FIELD_fld_ae_sem_multiply_d0,
  FIELD_fld_ae_sem_multiply_d2,
  FIELD_fld_ae_sem_multiply_q0,
  FIELD_fld_ae_sem_multiply_q1,
  FIELD_fld_ae_sem_reduction_sort_ds,
  FIELD_fld_ae_sem_reduction_sort_v,
  FIELD_fld_ae_sem_reduction_sort_v0,
  FIELD_fld_ae_sem_select_isel,
  FIELD_fld_ae_sem_select_ss,
  FIELD_fld_ae_sem_select_vr,
  FIELD_fld_ae_sem_select_vs,
  FIELD_fld_ae_sem_select_vt,
  FIELD_fld_ae_sem_select_vu,
  FIELD_fld_ae_sem_spaddsub_vr,
  FIELD_fld_ae_sem_spaddsub_vs,
  FIELD_fld_ae_sem_spaddsub_vt,
  FIELD_fld_ae_sem_spaddsub_vu,
  FIELD_fld_ae_sem_spfma_i_imm1,
  FIELD_fld_ae_sem_spfma_i_imm3,
  FIELD_fld_ae_sem_spfma_vp,
  FIELD_fld_ae_sem_spfma_vr,
  FIELD_fld_ae_sem_spfma_vs,
  FIELD_fld_ae_sem_spfma_vt,
  FIELD_fld_ae_sem_spmisc_vsM,
  FIELD_fld_ae_sem_spmisc_vt,
  FIELD_fld_ae_sem_spmisc_vtM,
  FIELD_fld_ae_slot2_14_0,
  FIELD_fld_ae_slot2_14_10,
  FIELD_fld_ae_slot2_14_14,
  FIELD_fld_ae_slot2_14_5,
  FIELD_fld_ae_slot2_16_15,
  FIELD_fld_ae_slot2_19_15,
  FIELD_fld_ae_slot2_28_15,
  FIELD_fld_ae_slot2_28_17,
  FIELD_fld_ae_slot2_28_19,
  FIELD_fld_ae_slot2_28_20,
  FIELD_fld_ae_slot2_28_25,
  FIELD_fld_ae_slot2_28_4,
  FIELD_fld_ae_slot2_28_5,
  FIELD_fld_ae_slot2_3_0,
  FIELD_fld_ae_slot2_9_0,
  FIELD_fld_ae_slot2_9_1,
  FIELD_fld_ae_slot2_9_2,
  FIELD_fld_ae_slot2_9_5,
  FIELD_fld_ae_slot2_9_6,
  FIELD_fld_ae_slot2_9_7,
  FIELD_fld_ae_slot2_9_8,
  FIELD_fld_ae_sem_dr_to_dr_imm,
  FIELD_fld_ae_sem_multiply_d1,
  FIELD_fld_ae_sem_multiply_d3,
  FIELD_fld_ae_sem_rng_d,
  FIELD_fld_ae_sem_shift_e,
  FIELD_fld_ae_sem_shift_i8,
  FIELD_fld_ae_slot3_11_0,
  FIELD_fld_ae_slot3_14_0,
  FIELD_fld_ae_slot3_14_10,
  FIELD_fld_ae_slot3_14_12,
  FIELD_fld_ae_slot3_14_13,
  FIELD_fld_ae_slot3_16_13,
  FIELD_fld_ae_slot3_19_0,
  FIELD_fld_ae_slot3_19_10,
  FIELD_fld_ae_slot3_19_15,
  FIELD_fld_ae_slot3_19_17,
  FIELD_fld_ae_slot3_19_18,
  FIELD_fld_ae_slot3_19_19,
  FIELD_fld_ae_slot3_24_10,
  FIELD_fld_ae_slot3_24_19,
  FIELD_fld_ae_slot3_24_20,
  FIELD_fld_ae_slot3_36_12,
  FIELD_fld_ae_slot3_36_16,
  FIELD_fld_ae_slot3_36_19,
  FIELD_fld_ae_slot3_36_20,
  FIELD_fld_ae_slot3_36_22,
  FIELD_fld_ae_slot3_36_25,
  FIELD_fld_ae_slot3_36_30,
  FIELD_fld_ae_slot3_4_0,
  FIELD_fld_ae_slot3_9_0,
  FIELD_fld_ae_slot3_9_1,
  FIELD_fld_ae_slot3_9_3,
  FIELD_fld_ae_slot3_9_5,
  FIELD_fld_ae2_slot0_0_0,
  FIELD_fld_ae2_slot0_11_4,
  FIELD_fld_ae2_slot0_11_8,
  FIELD_fld_ae2_slot0_11_9,
  FIELD_fld_ae2_slot0_12_0,
  FIELD_fld_ae2_slot0_12_2,
  FIELD_fld_ae2_slot0_12_4,
  FIELD_fld_ae2_slot0_12_8,
  FIELD_fld_ae2_slot0_14_13,
  FIELD_fld_ae2_slot0_14_8,
  FIELD_fld_ae2_slot0_15_0,
  FIELD_fld_ae2_slot0_15_12,
  FIELD_fld_ae2_slot0_15_13,
  FIELD_fld_ae2_slot0_15_15,
  FIELD_fld_ae2_slot0_15_4,
  FIELD_fld_ae2_slot0_15_8,
  FIELD_fld_ae2_slot0_17_13,
  FIELD_fld_ae2_slot0_17_17,
  FIELD_fld_ae2_slot0_18_15,
  FIELD_fld_ae2_slot0_18_17,
  FIELD_fld_ae2_slot0_18_18,
  FIELD_fld_ae2_slot0_1_0,
  FIELD_fld_ae2_slot0_23_18,
  FIELD_fld_ae2_slot0_23_19,
  FIELD_fld_ae2_slot0_3_0,
  FIELD_fld_ae2_slot0_40_16,
  FIELD_fld_ae2_slot0_40_17,
  FIELD_fld_ae2_slot0_40_18,
  FIELD_fld_ae2_slot0_40_19,
  FIELD_fld_ae2_slot0_40_21,
  FIELD_fld_ae2_slot0_40_23,
  FIELD_fld_ae2_slot0_40_24,
  FIELD_fld_ae2_slot0_40_25,
  FIELD_fld_ae2_slot0_40_26,
  FIELD_fld_ae2_slot0_40_27,
  FIELD_fld_ae2_slot0_7_0,
  FIELD_fld_ae2_slot0_7_4,
  FIELD_fld_ae2_slot0_7_6,
  FIELD_fld_ae2_slot0_7_7,
  FIELD_fld_ae2_slot0_8_8,
  FIELD_fld_ae2_slot0_9_8,
  FIELD_fld_ae2_slot1_0_0,
  FIELD_fld_ae2_slot1_11_0,
  FIELD_fld_ae2_slot1_11_10,
  FIELD_fld_ae2_slot1_11_8,
  FIELD_fld_ae2_slot1_14_10,
  FIELD_fld_ae2_slot1_14_11,
  FIELD_fld_ae2_slot1_14_12,
  FIELD_fld_ae2_slot1_14_14,
  FIELD_fld_ae2_slot1_14_8,
  FIELD_fld_ae2_slot1_36_12,
  FIELD_fld_ae2_slot1_36_14,
  FIELD_fld_ae2_slot1_36_15,
  FIELD_fld_ae2_slot1_36_16,
  FIELD_fld_ae2_slot1_36_17,
  FIELD_fld_ae2_slot1_36_18,
  FIELD_fld_ae2_slot1_36_20,
  FIELD_fld_ae2_slot1_36_22,
  FIELD_fld_ae2_slot1_36_23,
  FIELD_fld_ae2_slot1_3_0,
  FIELD_fld_ae2_slot1_3_1,
  FIELD_fld_ae2_slot1_3_2,
  FIELD_fld_ae2_slot1_3_3,
  FIELD_fld_ae2_slot1_7_4,
  FIELD_fld_ae2_slot1_9_8,
  FIELD_fld_ae2_slot1_9_9,
  FIELD_fld_ae2_slot2_14_10,
  FIELD_fld_ae2_slot2_17_0,
  FIELD_fld_ae2_slot2_17_10,
  FIELD_fld_ae2_slot2_17_15,
  FIELD_fld_ae2_slot2_17_17,
  FIELD_fld_ae2_slot2_19_10,
  FIELD_fld_ae2_slot2_19_15,
  FIELD_fld_ae2_slot2_19_18,
  FIELD_fld_ae2_slot2_19_9,
  FIELD_fld_ae2_slot2_24_10,
  FIELD_fld_ae2_slot2_24_15,
  FIELD_fld_ae2_slot2_24_20,
  FIELD_fld_ae2_slot2_24_5,
  FIELD_fld_ae2_slot2_24_9,
  FIELD_fld_ae2_slot2_42_18,
  FIELD_fld_ae2_slot2_42_20,
  FIELD_fld_ae2_slot2_42_25,
  FIELD_fld_ae2_slot2_42_26,
  FIELD_fld_ae2_slot2_42_28,
  FIELD_fld_ae2_slot2_42_30,
  FIELD_fld_ae2_slot2_4_0,
  FIELD_fld_ae2_slot2_9_5,
  FIELD_fld_ae_sem_spaddsub_vp,
  FIELD_fld_ae_sem_spaddsub_vq,
  FIELD_fld_ae3_slot0_11_11,
  FIELD_fld_ae3_slot0_11_4,
  FIELD_fld_ae3_slot0_11_8,
  FIELD_fld_ae3_slot0_12_12,
  FIELD_fld_ae3_slot0_12_8,
  FIELD_fld_ae3_slot0_13_13,
  FIELD_fld_ae3_slot0_13_8,
  FIELD_fld_ae3_slot0_1_0,
  FIELD_fld_ae3_slot0_32_11,
  FIELD_fld_ae3_slot0_32_12,
  FIELD_fld_ae3_slot0_32_13,
  FIELD_fld_ae3_slot0_32_14,
  FIELD_fld_ae3_slot0_32_15,
  FIELD_fld_ae3_slot0_32_16,
  FIELD_fld_ae3_slot0_32_17,
  FIELD_fld_ae3_slot0_32_18,
  FIELD_fld_ae3_slot0_32_20,
  FIELD_fld_ae3_slot0_32_27,
  FIELD_fld_ae3_slot0_32_8,
  FIELD_fld_ae3_slot0_3_0,
  FIELD_fld_ae3_slot0_3_2,
  FIELD_fld_ae3_slot0_3_3,
  FIELD_fld_ae3_slot0_4_0,
  FIELD_fld_ae3_slot0_4_4,
  FIELD_fld_ae3_slot0_5_0,
  FIELD_fld_ae3_slot0_5_4,
  FIELD_fld_ae3_slot0_7_0,
  FIELD_fld_ae3_slot0_7_2,
  FIELD_fld_ae3_slot0_7_4,
  FIELD_fld_ae3_slot0_7_6,
  FIELD_fld_ae3_slot0_8_8,
  FIELD_fld_ae3_slot0_9_4,
  FIELD_fld_ae3_slot0_9_8,
  FIELD_fld_ae_sem_dr_to_ar_ar_s,
  FIELD_fld_ae_sem_sb_loads_stores_iba2,
  FIELD_fld_ae3_slot1_23_0,
  FIELD_fld_ae3_slot1_23_11,
  FIELD_fld_ae3_slot1_23_12,
  FIELD_fld_ae3_slot1_23_13,
  FIELD_fld_ae3_slot1_23_15,
  FIELD_fld_ae3_slot1_23_16,
  FIELD_fld_ae3_slot1_23_17,
  FIELD_fld_ae3_slot1_23_19,
  FIELD_fld_ae3_slot1_23_6,
  FIELD_fld_ae3_slot1_23_8,
  FIELD_fld_ae3_slot1_23_9,
  FIELD_fld_ae3_slot1_3_0,
  FIELD_fld_ae3_slot1_3_1,
  FIELD_fld_ae3_slot1_3_2,
  FIELD_fld_ae3_slot1_3_3,
  FIELD_fld_ae3_slot1_7_4,
  FIELD_fld_ae3_slot1_9_8,
  FIELD_fld_AE_ARDECNORM16_ar_u,
  FIELD_fld_ae5_slot0_11_10,
  FIELD_fld_ae5_slot0_11_4,
  FIELD_fld_ae5_slot0_11_8,
  FIELD_fld_ae5_slot0_11_9,
  FIELD_fld_ae5_slot0_12_10,
  FIELD_fld_ae5_slot0_12_4,
  FIELD_fld_ae5_slot0_12_6,
  FIELD_fld_ae5_slot0_12_8,
  FIELD_fld_ae5_slot0_12_9,
  FIELD_fld_ae5_slot0_1_0,
  FIELD_fld_ae5_slot0_1_1,
  FIELD_fld_ae5_slot0_29_12,
  FIELD_fld_ae5_slot0_29_13,
  FIELD_fld_ae5_slot0_29_15,
  FIELD_fld_ae5_slot0_29_16,
  FIELD_fld_ae5_slot0_29_17,
  FIELD_fld_ae5_slot0_29_18,
  FIELD_fld_ae5_slot0_29_19,
  FIELD_fld_ae5_slot0_29_20,
  FIELD_fld_ae5_slot0_29_27,
  FIELD_fld_ae5_slot0_29_5,
  FIELD_fld_ae5_slot0_29_6,
  FIELD_fld_ae5_slot0_29_8,
  FIELD_fld_ae5_slot0_2_0,
  FIELD_fld_ae5_slot0_3_0,
  FIELD_fld_ae5_slot0_3_2,
  FIELD_fld_ae5_slot0_4_0,
  FIELD_fld_ae5_slot0_4_4,
  FIELD_fld_ae5_slot0_7_0,
  FIELD_fld_ae5_slot0_7_4,
  FIELD_fld_ae5_slot0_7_7,
  FIELD_fld_ae5_slot0_8_8,
  FIELD_fld_ae_sem_lb_db_ops_ar_u,
  FIELD_fld_ae_sem_lb_db_ops_iba,
  FIELD_fld_ae_sem_rng_a,
  FIELD_fld_ae_sem_rng_art,
  FIELD_fld_ae_sem_rng_i2,
  FIELD_fld_ae_sem_rng_imm2,
  FIELD_fld_ae5_slot1_1_0,
  FIELD_fld_ae5_slot2_14_10,
  FIELD_fld_ae5_slot2_14_14,
  FIELD_fld_ae5_slot2_14_5,
  FIELD_fld_ae5_slot2_24_0,
  FIELD_fld_ae5_slot2_24_15,
  FIELD_fld_ae5_slot2_24_17,
  FIELD_fld_ae5_slot2_24_20,
  FIELD_fld_ae5_slot2_4_0,
  FIELD_fld_ae5_slot2_9_0,
  FIELD_fld_ae5_slot2_9_5,
  FIELD_fld_ae5_slot2_9_7,
  FIELD_fld_ae6_slot0_10_10,
  FIELD_fld_ae6_slot0_15_15,
  FIELD_fld_ae6_slot0_29_10,
  FIELD_fld_ae6_slot0_29_13,
  FIELD_fld_ae6_slot0_29_14,
  FIELD_fld_ae6_slot0_29_15,
  FIELD_fld_ae6_slot0_29_18,
  FIELD_fld_ae6_slot0_29_20,
  FIELD_fld_ae6_slot0_29_5,
  FIELD_fld_ae6_slot0_4_0,
  FIELD_fld_ae6_slot0_4_4,
  FIELD_fld_ae6_slot0_7_4,
  FIELD_fld_ae6_slot0_9_8,
  FIELD_fld_ae6_slot0_9_9,
  FIELD_fld_ae6_slot1_14_14,
  FIELD_fld_ae6_slot1_27_12,
  FIELD_fld_ae6_slot1_27_15,
  FIELD_fld_ae6_slot1_27_20,
  FIELD_fld_ae6_slot1_27_21,
  FIELD_fld_ae6_slot1_27_3,
  FIELD_fld_ae6_slot1_27_6,
  FIELD_fld_ae6_slot1_2_0,
  FIELD_fld_ae6_slot1_9_5,
  FIELD_fld_ae6_slot1_9_6,
  FIELD_fld_ae6_slot1_9_7,
  FIELD_fld_ae6_slot1_9_8,
  FIELD_fld_ae6_slot1_9_9,
  FIELD_fld_ae6_slot2_10_10,
  FIELD_fld_ae6_slot2_11_10,
  FIELD_fld_ae6_slot2_24_0,
  FIELD_fld_ae6_slot2_24_10,
  FIELD_fld_ae6_slot2_24_14,
  FIELD_fld_ae6_slot2_24_15,
  FIELD_fld_ae6_slot2_24_20,
  FIELD_fld_ae6_slot2_4_2,
  FIELD_fld_ae6_slot2_9_5,
  FIELD_fld_ae6_slot3_10_10,
  FIELD_fld_ae6_slot3_12_0,
  FIELD_fld_ae6_slot3_14_0,
  FIELD_fld_ae6_slot3_14_10,
  FIELD_fld_ae6_slot3_14_13,
  FIELD_fld_ae6_slot3_14_5,
  FIELD_fld_ae6_slot3_24_20,
  FIELD_fld_ae6_slot3_37_13,
  FIELD_fld_ae6_slot3_37_15,
  FIELD_fld_ae6_slot3_37_20,
  FIELD_fld_ae6_slot3_37_30,
  FIELD_fld_ae6_slot3_9_5,
  FIELD_fld_ae7_slot0_12_6,
  FIELD_fld_ae7_slot0_23_0,
  FIELD_fld_ae7_slot0_23_13,
  FIELD_fld_ae7_slot0_23_17,
  FIELD_fld_ae7_slot0_23_18,
  FIELD_fld_ae7_slot0_23_6,
  FIELD_fld_ae7_slot0_7_4,
  FIELD_fld_ae7_slot0_7_6,
  FIELD_fld_ae7_slot0_7_7,
  FIELD_fld_ae7_slot1_12_6,
  FIELD_fld_ae7_slot1_23_0,
  FIELD_fld_ae7_slot1_23_13,
  FIELD_fld_ae7_slot1_23_17,
  FIELD_fld_ae7_slot1_23_18,
  FIELD_fld_ae7_slot1_23_6,
  FIELD_fld_ae7_slot1_7_4,
  FIELD_fld_ae7_slot1_7_6,
  FIELD_fld_ae7_slot1_7_7,
  FIELD_fld_ae7_slot2_11_0,
  FIELD_fld_ae7_slot2_14_10,
  FIELD_fld_ae7_slot2_14_5,
  FIELD_fld_ae7_slot2_36_12,
  FIELD_fld_ae7_slot2_36_15,
  FIELD_fld_ae7_slot2_36_20,
  FIELD_fld_ae7_slot2_36_25,
  FIELD_fld_ae7_slot2_36_30,
  FIELD_fld_ae7_slot2_9_5,
  FIELD_fld_ae7_slot3_10_0,
  FIELD_fld_ae7_slot3_14_10,
  FIELD_fld_ae7_slot3_14_5,
  FIELD_fld_ae7_slot3_24_10,
  FIELD_fld_ae7_slot3_35_11,
  FIELD_fld_ae7_slot3_35_20,
  FIELD_fld_ae7_slot3_35_25,
  FIELD_fld_ae7_slot3_35_30,
  FIELD_fld_ae7_slot3_4_0,
  FIELD_fld_ae7_slot3_9_5,
  FIELD_fld_ae9_slot0_0_0,
  FIELD_fld_ae9_slot0_12_12,
  FIELD_fld_ae9_slot0_12_5,
  FIELD_fld_ae9_slot0_12_8,
  FIELD_fld_ae9_slot0_17_13,
  FIELD_fld_ae9_slot0_17_4,
  FIELD_fld_ae9_slot0_17_8,
  FIELD_fld_ae9_slot0_27_10,
  FIELD_fld_ae9_slot0_27_12,
  FIELD_fld_ae9_slot0_27_13,
  FIELD_fld_ae9_slot0_27_16,
  FIELD_fld_ae9_slot0_27_17,
  FIELD_fld_ae9_slot0_27_18,
  FIELD_fld_ae9_slot0_27_19,
  FIELD_fld_ae9_slot0_27_20,
  FIELD_fld_ae9_slot0_27_22,
  FIELD_fld_ae9_slot0_27_23,
  FIELD_fld_ae9_slot0_27_3,
  FIELD_fld_ae9_slot0_27_8,
  FIELD_fld_ae9_slot0_2_0,
  FIELD_fld_ae9_slot0_3_0,
  FIELD_fld_ae9_slot0_7_0,
  FIELD_fld_ae9_slot0_7_4,
  FIELD_fld_ae9_slot0_7_5,
  FIELD_fld_ae9_slot0_7_6,
  FIELD_fld_ae9_slot0_7_7,
  FIELD_fld_ae9_slot0_8_4,
  FIELD_fld_ae9_slot0_8_5,
  FIELD_fld_ae9_slot0_9_5,
  FIELD_fld_ae9_slot1_17_13,
  FIELD_fld_ae9_slot1_17_8,
  FIELD_fld_ae9_slot1_1_0,
  FIELD_fld_ae9_slot1_26_12,
  FIELD_fld_ae9_slot1_26_13,
  FIELD_fld_ae9_slot1_26_16,
  FIELD_fld_ae9_slot1_26_17,
  FIELD_fld_ae9_slot1_26_18,
  FIELD_fld_ae9_slot1_26_2,
  FIELD_fld_ae9_slot1_26_20,
  FIELD_fld_ae9_slot1_26_22,
  FIELD_fld_ae9_slot1_26_23,
  FIELD_fld_ae9_slot1_26_8,
  FIELD_fld_ae9_slot1_26_9,
  FIELD_fld_ae9_slot1_3_0,
  FIELD_fld_ae9_slot1_3_2,
  FIELD_fld_ae9_slot1_3_3,
  FIELD_fld_ae9_slot1_7_4,
  FIELD_fld_ae9_slot2_24_14,
  FIELD_fld_ae9_slot2_24_15,
  FIELD_fld_ae9_slot2_24_20,
  FIELD_fld_ae9_slot2_33_14,
  FIELD_fld_ae9_slot2_33_15,
  FIELD_fld_ae9_slot2_33_20,
  FIELD_fld_ae9_slot2_33_25,
  FIELD_fld_ae9_slot2_33_26,
  FIELD_fld_ae9_slot2_33_28,
  FIELD_fld_ae9_slot2_33_30,
  FIELD_fld_ae9_slot2_33_9,
  FIELD_fld_ae9_slot2_4_0,
  FIELD_fld_ae9_slot2_5_0,
  FIELD_fld_ae9_slot2_6_0,
  FIELD_fld_ae9_slot2_8_0,
  FIELD_fld_ae9_slot2_9_0,
  FIELD_fld_ae9_slot2_9_5,
  FIELD_fld_ae9_slot2_9_9,
  FIELD_fld_ae_sem_hpfma_vp,
  FIELD_fld_ae_sem_hpfma_vu,
  FIELD_fld_ae_sem_spfma_vu,
  FIELD_fld_ae9_slot3_19_15,
  FIELD_fld_ae9_slot3_24_20,
  FIELD_fld_ae9_slot3_31_14,
  FIELD_fld_ae9_slot3_31_15,
  FIELD_fld_ae9_slot3_31_20,
  FIELD_fld_ae9_slot3_31_25,
  FIELD_fld_ae9_slot3_31_26,
  FIELD_fld_ae9_slot3_31_28,
  FIELD_fld_ae9_slot3_31_7,
  FIELD_fld_ae9_slot3_4_0,
  FIELD_fld_ae9_slot3_4_3,
  FIELD_fld_ae9_slot3_4_4,
  FIELD_fld_ae9_slot3_6_0,
  FIELD_fld_ae9_slot3_9_0,
  FIELD_fld_ae9_slot3_9_5,
  FIELD_fld_ae10_slot0_17_13,
  FIELD_fld_ae10_slot0_17_4,
  FIELD_fld_ae10_slot0_17_8,
  FIELD_fld_ae10_slot0_24_0,
  FIELD_fld_ae10_slot0_24_10,
  FIELD_fld_ae10_slot0_24_12,
  FIELD_fld_ae10_slot0_24_13,
  FIELD_fld_ae10_slot0_24_16,
  FIELD_fld_ae10_slot0_24_17,
  FIELD_fld_ae10_slot0_24_18,
  FIELD_fld_ae10_slot0_24_20,
  FIELD_fld_ae10_slot0_24_8,
  FIELD_fld_ae10_slot0_3_0,
  FIELD_fld_ae10_slot0_7_4,
  FIELD_fld_ae10_slot0_7_6,
  FIELD_fld_ae10_slot0_7_7,
  FIELD_fld_ae10_slot0_8_4,
  FIELD_fld_ae10_slot1_0_0,
  FIELD_fld_ae10_slot1_17_13,
  FIELD_fld_ae10_slot1_17_8,
  FIELD_fld_ae10_slot1_25_1,
  FIELD_fld_ae10_slot1_25_12,
  FIELD_fld_ae10_slot1_25_13,
  FIELD_fld_ae10_slot1_25_16,
  FIELD_fld_ae10_slot1_25_17,
  FIELD_fld_ae10_slot1_25_18,
  FIELD_fld_ae10_slot1_25_20,
  FIELD_fld_ae10_slot1_25_22,
  FIELD_fld_ae10_slot1_25_23,
  FIELD_fld_ae10_slot1_25_8,
  FIELD_fld_ae10_slot1_25_9,
  FIELD_fld_ae10_slot1_3_0,
  FIELD_fld_ae10_slot1_3_2,
  FIELD_fld_ae10_slot1_3_3,
  FIELD_fld_ae10_slot1_7_4,
  FIELD_fld_ae10_slot2_24_20,
  FIELD_fld_ae10_slot2_29_20,
  FIELD_fld_ae10_slot2_29_25,
  FIELD_fld_ae10_slot2_34_10,
  FIELD_fld_ae10_slot2_34_14,
  FIELD_fld_ae10_slot2_34_15,
  FIELD_fld_ae10_slot2_34_20,
  FIELD_fld_ae10_slot2_34_25,
  FIELD_fld_ae10_slot2_34_30,
  FIELD_fld_ae10_slot2_34_31,
  FIELD_fld_ae10_slot2_34_33,
  FIELD_fld_ae10_slot2_4_0,
  FIELD_fld_ae10_slot2_9_0,
  FIELD_fld_ae10_slot2_9_5,
  FIELD_fld_ae_sem_hpfma_vq,
  FIELD_fld_ae_sem_spfma_vq,
  FIELD_fld_ae10_slot3_19_15,
  FIELD_fld_ae10_slot3_29_20,
  FIELD_fld_ae10_slot3_29_25,
  FIELD_fld_ae10_slot3_34_10,
  FIELD_fld_ae10_slot3_34_14,
  FIELD_fld_ae10_slot3_34_15,
  FIELD_fld_ae10_slot3_34_20,
  FIELD_fld_ae10_slot3_34_25,
  FIELD_fld_ae10_slot3_34_30,
  FIELD_fld_ae10_slot3_34_31,
  FIELD_fld_ae10_slot3_34_33,
  FIELD_fld_ae10_slot3_4_0,
  FIELD_fld_ae10_slot3_4_3,
  FIELD_fld_ae10_slot3_4_4,
  FIELD_fld_ae10_slot3_9_0,
  FIELD_fld_ae10_slot3_9_5,
  FIELD_fld_ae4_slot0_22_0,
  FIELD_fld_ae4_slot0_22_12,
  FIELD_fld_ae4_slot0_22_13,
  FIELD_fld_ae4_slot0_22_16,
  FIELD_fld_ae4_slot0_22_17,
  FIELD_fld_ae4_slot0_22_18,
  FIELD_fld_ae4_slot0_22_20,
  FIELD_fld_ae4_slot0_22_6,
  FIELD_fld_ae4_slot0_22_8,
  FIELD_fld_ae4_slot0_3_0,
  FIELD_fld_ae4_slot0_3_1,
  FIELD_fld_ae4_slot0_4_4,
  FIELD_fld_ae4_slot0_7_4,
  FIELD_fld_ae4_slot1_22_0,
  FIELD_fld_ae4_slot1_22_12,
  FIELD_fld_ae4_slot1_22_13,
  FIELD_fld_ae4_slot1_22_16,
  FIELD_fld_ae4_slot1_22_17,
  FIELD_fld_ae4_slot1_22_18,
  FIELD_fld_ae4_slot1_22_8,
  FIELD_fld_ae4_slot1_3_0,
  FIELD_fld_ae4_slot1_3_1,
  FIELD_fld_ae4_slot1_7_4,
  FIELD_fld_ae4_slot2_23_0,
  FIELD_fld_ae4_slot2_23_12,
  FIELD_fld_ae4_slot2_23_15,
  FIELD_fld_ae4_slot2_23_17,
  FIELD_fld_ae4_slot2_23_20,
  FIELD_fld_ae4_slot2_4_0,
  FIELD_fld_ae4_slot2_9_5,
  FIELD_fld_ae4_slot3_14_10,
  FIELD_fld_ae4_slot3_19_15,
  FIELD_fld_ae4_slot3_19_19,
  FIELD_fld_ae4_slot3_19_5,
  FIELD_fld_ae4_slot3_27_20,
  FIELD_fld_ae4_slot3_27_25,
  FIELD_fld_ae4_slot3_27_3,
  FIELD_fld_ae4_slot3_2_0,
  FIELD_fld_ae4_slot3_9_0,
  FIELD_fld_ae4_slot3_9_5,
  FIELD_fld_ae4_slot4_22_0,
  FIELD_fld_ae4_slot4_22_15,
  FIELD_fld_ae4_slot4_22_20,
  FIELD_fld_ae4_slot4_9_5,
  FIELD_fld_Inst_11_8,
  FIELD_fld_Inst_12_12,
  FIELD_fld_Inst_12_8,
  FIELD_fld_Inst_13_8,
  FIELD_fld_Inst_15_12,
  FIELD_fld_Inst_19_17,
  FIELD_fld_Inst_19_18,
  FIELD_fld_Inst_23_12,
  FIELD_fld_Inst_23_16,
  FIELD_fld_Inst_4_4,
  FIELD_fld_Inst_5_4,
  FIELD_fld_Inst_7_4,
  FIELD_fld_Inst_7_6,
  FIELD_fld_Inst_7_7,
  FIELD_fld_Inst_9_8,
  FIELD__ar0,
  FIELD__ar4,
  FIELD__ar8,
  FIELD__ar12,
  FIELD__bt16,
  FIELD__bs16,
  FIELD__br16,
  FIELD__brall
};


/* Functional units.  */

static xtensa_funcUnit_internal funcUnits[] = {
  {"XT_LOADSTORE_UNIT", 2},
  { "mul_function", 1 },
  { "mul_S2_function", 1 },
  { "ae_add32x27", 1 },
  { "ae_shift32x4", 1 },
  { "ae_shift32x5", 1 },
  { "ae_leftshift32x5", 2 }
};

enum xtensa_funcUnit_id {
  FUNCUNIT_XT_LOADSTORE_UNIT,
  FUNCUNIT_mul_function,
  FUNCUNIT_mul_S2_function,
  FUNCUNIT_ae_add32x27,
  FUNCUNIT_ae_shift32x4,
  FUNCUNIT_ae_shift32x5,
  FUNCUNIT_ae_leftshift32x5
};


/* Register files.  */

enum xtensa_regfile_id {
  REGFILE_AR,
  REGFILE_BR,
  REGFILE_AE_DR,
  REGFILE_AE_VALIGN,
  REGFILE_AE_EP,
  REGFILE_BR2,
  REGFILE_BR4,
  REGFILE_BR8,
  REGFILE_BR16
};

static xtensa_regfile_internal regfiles[] = {
  { "AR", "a", REGFILE_AR, 32, 64 },
  { "BR", "b", REGFILE_BR, 1, 16 },
  { "AE_DR", "aed", REGFILE_AE_DR, 64, 32 },
  { "AE_VALIGN", "u", REGFILE_AE_VALIGN, 128, 4 },
  { "AE_EP", "aep", REGFILE_AE_EP, 8, 4 },
  { "BR2", "b", REGFILE_BR, 2, 8 },
  { "BR4", "b", REGFILE_BR, 4, 4 },
  { "BR8", "b", REGFILE_BR, 8, 2 },
  { "BR16", "b", REGFILE_BR, 16, 1 }
};


/* Interfaces.  */

#define interfaces 0


/* Constant tables.  */

/* constant table ai4c */
static const unsigned CONST_TBL_ai4c_0[] = {
  0xffffffff,
  0x1,
  0x2,
  0x3,
  0x4,
  0x5,
  0x6,
  0x7,
  0x8,
  0x9,
  0xa,
  0xb,
  0xc,
  0xd,
  0xe,
  0xf,
  0
};

/* constant table b4c */
static const unsigned CONST_TBL_b4c_0[] = {
  0xffffffff,
  0x1,
  0x2,
  0x3,
  0x4,
  0x5,
  0x6,
  0x7,
  0x8,
  0xa,
  0xc,
  0x10,
  0x20,
  0x40,
  0x80,
  0x100,
  0
};

/* constant table b4cu */
static const unsigned CONST_TBL_b4cu_0[] = {
  0x8000,
  0x10000,
  0x2,
  0x3,
  0x4,
  0x5,
  0x6,
  0x7,
  0x8,
  0xa,
  0xc,
  0x10,
  0x20,
  0x40,
  0x80,
  0x100,
  0
};

/* constant table bitmask8 */
static const unsigned CONST_TBL_bitmask8_0[] = {
  0 & 0xff,
  0x1 & 0xff,
  0x3 & 0xff,
  0x7 & 0xff,
  0xf & 0xff,
  0x1f & 0xff,
  0x3f & 0xff,
  0x7f & 0xff,
  0
};

/* constant table bitmask16 */
static const unsigned CONST_TBL_bitmask16_0[] = {
  0 & 0xffff,
  0x1 & 0xffff,
  0x3 & 0xffff,
  0x7 & 0xffff,
  0xf & 0xffff,
  0x1f & 0xffff,
  0x3f & 0xffff,
  0x7f & 0xffff,
  0xff & 0xffff,
  0x1ff & 0xffff,
  0x3ff & 0xffff,
  0x7ff & 0xffff,
  0xfff & 0xffff,
  0x1fff & 0xffff,
  0x3fff & 0xffff,
  0x7fff & 0xffff,
  0
};

/* constant table ae_immls64neg */
static const unsigned CONST_TBL_ae_immls64neg_0[] = {
  0xffffffe0,
  0xffffffe8,
  0xfffffff0,
  0xfffffff8,
  0
};

/* constant table ae_ripimmtable */
static const unsigned CONST_TBL_ae_ripimmtable_0[] = {
  0xffffffe0,
  0xffffffe8,
  0xfffffff0,
  0xfffffff8,
  0
};

/* constant table ae_slai72table */
static const unsigned CONST_TBL_ae_slai72table_0[] = {
  0x1,
  0x2,
  0x3,
  0x4,
  0x5,
  0x6,
  0x7,
  0x8,
  0
};

/* constant table ae_seliencode */
static const unsigned CONST_TBL_ae_seliencode_0[] = {
  0x4e5 & 0xfff,
  0x65 & 0xfff,
  0x77 & 0xfff,
  0x4f7 & 0xfff,
  0x72e & 0xfff,
  0x29c & 0xfff,
  0xaf & 0xfff,
  0xa6 & 0xfff,
  0x2ef & 0xfff,
  0x10d & 0xfff,
  0x599 & 0xfff,
  0x59f & 0xfff,
  0xb3e & 0xfff,
  0x18f & 0xfff,
  0x51d & 0xfff,
  0xa6 & 0xfff,
  0
};

/* constant table ae_ohba */
static const unsigned CONST_TBL_ae_ohba_0[] = {
  0x1 & 0x1f,
  0x2 & 0x1f,
  0x3 & 0x1f,
  0x4 & 0x1f,
  0x5 & 0x1f,
  0x6 & 0x1f,
  0x7 & 0x1f,
  0x8 & 0x1f,
  0x9 & 0x1f,
  0xa & 0x1f,
  0xb & 0x1f,
  0xc & 0x1f,
  0xd & 0x1f,
  0xe & 0x1f,
  0xf & 0x1f,
  0x10 & 0x1f,
  0
};

/* constant table ae_ohba2 */
static const unsigned CONST_TBL_ae_ohba2_0[] = {
  0x1 & 0x1f,
  0x2 & 0x1f,
  0x3 & 0x1f,
  0x4 & 0x1f,
  0x5 & 0x1f,
  0x6 & 0x1f,
  0x7 & 0x1f,
  0x8 & 0x1f,
  0x9 & 0x1f,
  0xa & 0x1f,
  0xb & 0x1f,
  0xc & 0x1f,
  0xd & 0x1f,
  0xe & 0x1f,
  0xf & 0x1f,
  0x10 & 0x1f,
  0
};

/* constant table ae_opnd_tp7 */
static const unsigned CONST_TBL_ae_opnd_tp7_0[] = {
  0x7 & 0x1f,
  0x8 & 0x1f,
  0x9 & 0x1f,
  0xa & 0x1f,
  0xb & 0x1f,
  0xc & 0x1f,
  0xd & 0x1f,
  0xe & 0x1f,
  0xf & 0x1f,
  0x10 & 0x1f,
  0x11 & 0x1f,
  0x12 & 0x1f,
  0x13 & 0x1f,
  0x14 & 0x1f,
  0x15 & 0x1f,
  0x16 & 0x1f,
  0
};

/* constant table xd_seli_8x8_table0 */
static const unsigned CONST_TBL_xd_seli_8x8_table0_0[] = {
  0xba987654,
  0xfedc7654,
  0xfedc3210,
  0xba983210,
  0x98765432,
  0xdcba9876,
  0xfeba5410,
  0xfeba7632,
  0xdc985410,
  0xfe76dc54,
  0xba3298dc,
  0xba329810,
  0x54761032,
  0xfe32dc10,
  0xba769854,
  0xfeba7632,
  0xedcba987,
  0xcba98765,
  0xa9876543,
  0x87654321,
  0xf7e6d5c4,
  0xb3a29180,
  0xf3e2d1c0,
  0xb7a69584,
  0xfe76ba32,
  0xeca86420,
  0xfdb97531,
  0xeca87531,
  0xfdb96420,
  0xdc987632,
  0xefcdab89,
  0x32107654,
  0
};

/* constant table tab_lavunqz_8x8 */
static const unsigned CONST_TBL_tab_lavunqz_8x8_0[] = {
  0,
  0x7,
  0x70,
  0x76,
  0x700,
  0x706,
  0x760,
  0x765,
  0x7000,
  0x7006,
  0x7060,
  0x7065,
  0x7600,
  0x7605,
  0x7650,
  0x7654,
  0x70000,
  0x70006,
  0x70060,
  0x70065,
  0x70600,
  0x70605,
  0x70650,
  0x70654,
  0x76000,
  0x76005,
  0x76050,
  0x76054,
  0x76500,
  0x76504,
  0x76540,
  0x76543,
  0x700000,
  0x700006,
  0x700060,
  0x700065,
  0x700600,
  0x700605,
  0x700650,
  0x700654,
  0x706000,
  0x706005,
  0x706050,
  0x706054,
  0x706500,
  0x706504,
  0x706540,
  0x706543,
  0x760000,
  0x760005,
  0x760050,
  0x760054,
  0x760500,
  0x760504,
  0x760540,
  0x760543,
  0x765000,
  0x765004,
  0x765040,
  0x765043,
  0x765400,
  0x765403,
  0x765430,
  0x765432,
  0x7000000,
  0x7000006,
  0x7000060,
  0x7000065,
  0x7000600,
  0x7000605,
  0x7000650,
  0x7000654,
  0x7006000,
  0x7006005,
  0x7006050,
  0x7006054,
  0x7006500,
  0x7006504,
  0x7006540,
  0x7006543,
  0x7060000,
  0x7060005,
  0x7060050,
  0x7060054,
  0x7060500,
  0x7060504,
  0x7060540,
  0x7060543,
  0x7065000,
  0x7065004,
  0x7065040,
  0x7065043,
  0x7065400,
  0x7065403,
  0x7065430,
  0x7065432,
  0x7600000,
  0x7600005,
  0x7600050,
  0x7600054,
  0x7600500,
  0x7600504,
  0x7600540,
  0x7600543,
  0x7605000,
  0x7605004,
  0x7605040,
  0x7605043,
  0x7605400,
  0x7605403,
  0x7605430,
  0x7605432,
  0x7650000,
  0x7650004,
  0x7650040,
  0x7650043,
  0x7650400,
  0x7650403,
  0x7650430,
  0x7650432,
  0x7654000,
  0x7654003,
  0x7654030,
  0x7654032,
  0x7654300,
  0x7654302,
  0x7654320,
  0x7654321,
  0x70000000,
  0x70000006,
  0x70000060,
  0x70000065,
  0x70000600,
  0x70000605,
  0x70000650,
  0x70000654,
  0x70006000,
  0x70006005,
  0x70006050,
  0x70006054,
  0x70006500,
  0x70006504,
  0x70006540,
  0x70006543,
  0x70060000,
  0x70060005,
  0x70060050,
  0x70060054,
  0x70060500,
  0x70060504,
  0x70060540,
  0x70060543,
  0x70065000,
  0x70065004,
  0x70065040,
  0x70065043,
  0x70065400,
  0x70065403,
  0x70065430,
  0x70065432,
  0x70600000,
  0x70600005,
  0x70600050,
  0x70600054,
  0x70600500,
  0x70600504,
  0x70600540,
  0x70600543,
  0x70605000,
  0x70605004,
  0x70605040,
  0x70605043,
  0x70605400,
  0x70605403,
  0x70605430,
  0x70605432,
  0x70650000,
  0x70650004,
  0x70650040,
  0x70650043,
  0x70650400,
  0x70650403,
  0x70650430,
  0x70650432,
  0x70654000,
  0x70654003,
  0x70654030,
  0x70654032,
  0x70654300,
  0x70654302,
  0x70654320,
  0x70654321,
  0x76000000,
  0x76000005,
  0x76000050,
  0x76000054,
  0x76000500,
  0x76000504,
  0x76000540,
  0x76000543,
  0x76005000,
  0x76005004,
  0x76005040,
  0x76005043,
  0x76005400,
  0x76005403,
  0x76005430,
  0x76005432,
  0x76050000,
  0x76050004,
  0x76050040,
  0x76050043,
  0x76050400,
  0x76050403,
  0x76050430,
  0x76050432,
  0x76054000,
  0x76054003,
  0x76054030,
  0x76054032,
  0x76054300,
  0x76054302,
  0x76054320,
  0x76054321,
  0x76500000,
  0x76500004,
  0x76500040,
  0x76500043,
  0x76500400,
  0x76500403,
  0x76500430,
  0x76500432,
  0x76504000,
  0x76504003,
  0x76504030,
  0x76504032,
  0x76504300,
  0x76504302,
  0x76504320,
  0x76504321,
  0x76540000,
  0x76540003,
  0x76540030,
  0x76540032,
  0x76540300,
  0x76540302,
  0x76540320,
  0x76540321,
  0x76543000,
  0x76543002,
  0x76543020,
  0x76543021,
  0x76543200,
  0x76543201,
  0x76543210,
  0x76543210,
  0
};

/* constant table tab_lavunqz_16x4 */
static const unsigned CONST_TBL_tab_lavunqz_16x4_0[] = {
  0 & 0xff,
  0x3 & 0xff,
  0xc & 0xff,
  0xe & 0xff,
  0x30 & 0xff,
  0x32 & 0xff,
  0x38 & 0xff,
  0x39 & 0xff,
  0xc0 & 0xff,
  0xc2 & 0xff,
  0xc8 & 0xff,
  0xc9 & 0xff,
  0xe0 & 0xff,
  0xe1 & 0xff,
  0xe4 & 0xff,
  0xe4 & 0xff,
  0
};

/* constant table RECIP_Data8 */
static const unsigned CONST_TBL_RECIP_Data8_0[] = {
  0xff & 0xff,
  0xfd & 0xff,
  0xfb & 0xff,
  0xf9 & 0xff,
  0xf7 & 0xff,
  0xf5 & 0xff,
  0xf4 & 0xff,
  0xf2 & 0xff,
  0xf0 & 0xff,
  0xee & 0xff,
  0xed & 0xff,
  0xeb & 0xff,
  0xe9 & 0xff,
  0xe8 & 0xff,
  0xe6 & 0xff,
  0xe4 & 0xff,
  0xe3 & 0xff,
  0xe1 & 0xff,
  0xe0 & 0xff,
  0xde & 0xff,
  0xdd & 0xff,
  0xdb & 0xff,
  0xda & 0xff,
  0xd8 & 0xff,
  0xd7 & 0xff,
  0xd5 & 0xff,
  0xd4 & 0xff,
  0xd3 & 0xff,
  0xd1 & 0xff,
  0xd0 & 0xff,
  0xcf & 0xff,
  0xcd & 0xff,
  0xcc & 0xff,
  0xcb & 0xff,
  0xca & 0xff,
  0xc8 & 0xff,
  0xc7 & 0xff,
  0xc6 & 0xff,
  0xc5 & 0xff,
  0xc4 & 0xff,
  0xc2 & 0xff,
  0xc1 & 0xff,
  0xc0 & 0xff,
  0xbf & 0xff,
  0xbe & 0xff,
  0xbd & 0xff,
  0xbc & 0xff,
  0xbb & 0xff,
  0xba & 0xff,
  0xb9 & 0xff,
  0xb8 & 0xff,
  0xb7 & 0xff,
  0xb6 & 0xff,
  0xb5 & 0xff,
  0xb4 & 0xff,
  0xb3 & 0xff,
  0xb2 & 0xff,
  0xb1 & 0xff,
  0xb0 & 0xff,
  0xaf & 0xff,
  0xae & 0xff,
  0xad & 0xff,
  0xac & 0xff,
  0xab & 0xff,
  0xaa & 0xff,
  0xa9 & 0xff,
  0xa8 & 0xff,
  0xa8 & 0xff,
  0xa7 & 0xff,
  0xa6 & 0xff,
  0xa5 & 0xff,
  0xa4 & 0xff,
  0xa3 & 0xff,
  0xa3 & 0xff,
  0xa2 & 0xff,
  0xa1 & 0xff,
  0xa0 & 0xff,
  0x9f & 0xff,
  0x9f & 0xff,
  0x9e & 0xff,
  0x9d & 0xff,
  0x9c & 0xff,
  0x9c & 0xff,
  0x9b & 0xff,
  0x9a & 0xff,
  0x99 & 0xff,
  0x99 & 0xff,
  0x98 & 0xff,
  0x97 & 0xff,
  0x97 & 0xff,
  0x96 & 0xff,
  0x95 & 0xff,
  0x95 & 0xff,
  0x94 & 0xff,
  0x93 & 0xff,
  0x93 & 0xff,
  0x92 & 0xff,
  0x91 & 0xff,
  0x91 & 0xff,
  0x90 & 0xff,
  0x8f & 0xff,
  0x8f & 0xff,
  0x8e & 0xff,
  0x8e & 0xff,
  0x8d & 0xff,
  0x8c & 0xff,
  0x8c & 0xff,
  0x8b & 0xff,
  0x8b & 0xff,
  0x8a & 0xff,
  0x89 & 0xff,
  0x89 & 0xff,
  0x88 & 0xff,
  0x88 & 0xff,
  0x87 & 0xff,
  0x87 & 0xff,
  0x86 & 0xff,
  0x85 & 0xff,
  0x85 & 0xff,
  0x84 & 0xff,
  0x84 & 0xff,
  0x83 & 0xff,
  0x83 & 0xff,
  0x82 & 0xff,
  0x82 & 0xff,
  0x81 & 0xff,
  0x81 & 0xff,
  0x81 & 0xff,
  0
};

/* constant table RSQRT_Data8 */
static const unsigned CONST_TBL_RSQRT_Data8_0[] = {
  0xb4 & 0xff,
  0xb3 & 0xff,
  0xb2 & 0xff,
  0xb0 & 0xff,
  0xaf & 0xff,
  0xae & 0xff,
  0xac & 0xff,
  0xab & 0xff,
  0xaa & 0xff,
  0xa9 & 0xff,
  0xa8 & 0xff,
  0xa7 & 0xff,
  0xa6 & 0xff,
  0xa5 & 0xff,
  0xa3 & 0xff,
  0xa2 & 0xff,
  0xa1 & 0xff,
  0xa0 & 0xff,
  0x9f & 0xff,
  0x9e & 0xff,
  0x9e & 0xff,
  0x9d & 0xff,
  0x9c & 0xff,
  0x9b & 0xff,
  0x9a & 0xff,
  0x99 & 0xff,
  0x98 & 0xff,
  0x97 & 0xff,
  0x97 & 0xff,
  0x96 & 0xff,
  0x95 & 0xff,
  0x94 & 0xff,
  0x93 & 0xff,
  0x93 & 0xff,
  0x92 & 0xff,
  0x91 & 0xff,
  0x90 & 0xff,
  0x90 & 0xff,
  0x8f & 0xff,
  0x8e & 0xff,
  0x8e & 0xff,
  0x8d & 0xff,
  0x8c & 0xff,
  0x8c & 0xff,
  0x8b & 0xff,
  0x8a & 0xff,
  0x8a & 0xff,
  0x89 & 0xff,
  0x89 & 0xff,
  0x88 & 0xff,
  0x87 & 0xff,
  0x87 & 0xff,
  0x86 & 0xff,
  0x86 & 0xff,
  0x85 & 0xff,
  0x84 & 0xff,
  0x84 & 0xff,
  0x83 & 0xff,
  0x83 & 0xff,
  0x82 & 0xff,
  0x82 & 0xff,
  0x81 & 0xff,
  0x81 & 0xff,
  0x80 & 0xff,
  0xff & 0xff,
  0xfd & 0xff,
  0xfb & 0xff,
  0xf9 & 0xff,
  0xf7 & 0xff,
  0xf6 & 0xff,
  0xf4 & 0xff,
  0xf2 & 0xff,
  0xf1 & 0xff,
  0xef & 0xff,
  0xed & 0xff,
  0xec & 0xff,
  0xea & 0xff,
  0xe9 & 0xff,
  0xe7 & 0xff,
  0xe6 & 0xff,
  0xe4 & 0xff,
  0xe3 & 0xff,
  0xe1 & 0xff,
  0xe0 & 0xff,
  0xdf & 0xff,
  0xdd & 0xff,
  0xdc & 0xff,
  0xdb & 0xff,
  0xda & 0xff,
  0xd8 & 0xff,
  0xd7 & 0xff,
  0xd6 & 0xff,
  0xd5 & 0xff,
  0xd4 & 0xff,
  0xd3 & 0xff,
  0xd2 & 0xff,
  0xd0 & 0xff,
  0xcf & 0xff,
  0xce & 0xff,
  0xcd & 0xff,
  0xcc & 0xff,
  0xcb & 0xff,
  0xca & 0xff,
  0xc9 & 0xff,
  0xc8 & 0xff,
  0xc7 & 0xff,
  0xc6 & 0xff,
  0xc6 & 0xff,
  0xc5 & 0xff,
  0xc4 & 0xff,
  0xc3 & 0xff,
  0xc2 & 0xff,
  0xc1 & 0xff,
  0xc0 & 0xff,
  0xbf & 0xff,
  0xbf & 0xff,
  0xbe & 0xff,
  0xbd & 0xff,
  0xbc & 0xff,
  0xbb & 0xff,
  0xbb & 0xff,
  0xba & 0xff,
  0xb9 & 0xff,
  0xb8 & 0xff,
  0xb8 & 0xff,
  0xb7 & 0xff,
  0xb6 & 0xff,
  0xb5 & 0xff,
  0
};

/* constant table recip_tab */
static const unsigned CONST_TBL_recip_tab_0[] = {
  0xff & 0xff,
  0xfd & 0xff,
  0xfb & 0xff,
  0xf9 & 0xff,
  0xf7 & 0xff,
  0xf5 & 0xff,
  0xf4 & 0xff,
  0xf2 & 0xff,
  0xf0 & 0xff,
  0xee & 0xff,
  0xed & 0xff,
  0xeb & 0xff,
  0xe9 & 0xff,
  0xe8 & 0xff,
  0xe6 & 0xff,
  0xe4 & 0xff,
  0xe3 & 0xff,
  0xe1 & 0xff,
  0xe0 & 0xff,
  0xde & 0xff,
  0xdd & 0xff,
  0xdb & 0xff,
  0xda & 0xff,
  0xd8 & 0xff,
  0xd7 & 0xff,
  0xd5 & 0xff,
  0xd4 & 0xff,
  0xd3 & 0xff,
  0xd1 & 0xff,
  0xd0 & 0xff,
  0xcf & 0xff,
  0xcd & 0xff,
  0xcc & 0xff,
  0xcb & 0xff,
  0xca & 0xff,
  0xc8 & 0xff,
  0xc7 & 0xff,
  0xc6 & 0xff,
  0xc5 & 0xff,
  0xc4 & 0xff,
  0xc2 & 0xff,
  0xc1 & 0xff,
  0xc0 & 0xff,
  0xbf & 0xff,
  0xbe & 0xff,
  0xbd & 0xff,
  0xbc & 0xff,
  0xbb & 0xff,
  0xba & 0xff,
  0xb9 & 0xff,
  0xb8 & 0xff,
  0xb7 & 0xff,
  0xb6 & 0xff,
  0xb5 & 0xff,
  0xb4 & 0xff,
  0xb3 & 0xff,
  0xb2 & 0xff,
  0xb1 & 0xff,
  0xb0 & 0xff,
  0xaf & 0xff,
  0xae & 0xff,
  0xad & 0xff,
  0xac & 0xff,
  0xab & 0xff,
  0xaa & 0xff,
  0xa9 & 0xff,
  0xa8 & 0xff,
  0xa8 & 0xff,
  0xa7 & 0xff,
  0xa6 & 0xff,
  0xa5 & 0xff,
  0xa4 & 0xff,
  0xa3 & 0xff,
  0xa3 & 0xff,
  0xa2 & 0xff,
  0xa1 & 0xff,
  0xa0 & 0xff,
  0x9f & 0xff,
  0x9f & 0xff,
  0x9e & 0xff,
  0x9d & 0xff,
  0x9c & 0xff,
  0x9c & 0xff,
  0x9b & 0xff,
  0x9a & 0xff,
  0x99 & 0xff,
  0x99 & 0xff,
  0x98 & 0xff,
  0x97 & 0xff,
  0x97 & 0xff,
  0x96 & 0xff,
  0x95 & 0xff,
  0x95 & 0xff,
  0x94 & 0xff,
  0x93 & 0xff,
  0x93 & 0xff,
  0x92 & 0xff,
  0x91 & 0xff,
  0x91 & 0xff,
  0x90 & 0xff,
  0x8f & 0xff,
  0x8f & 0xff,
  0x8e & 0xff,
  0x8e & 0xff,
  0x8d & 0xff,
  0x8c & 0xff,
  0x8c & 0xff,
  0x8b & 0xff,
  0x8b & 0xff,
  0x8a & 0xff,
  0x89 & 0xff,
  0x89 & 0xff,
  0x88 & 0xff,
  0x88 & 0xff,
  0x87 & 0xff,
  0x87 & 0xff,
  0x86 & 0xff,
  0x85 & 0xff,
  0x85 & 0xff,
  0x84 & 0xff,
  0x84 & 0xff,
  0x83 & 0xff,
  0x83 & 0xff,
  0x82 & 0xff,
  0x82 & 0xff,
  0x81 & 0xff,
  0x81 & 0xff,
  0x81 & 0xff,
  0
};

/* constant table rsqrt_tab */
static const unsigned CONST_TBL_rsqrt_tab_0[] = {
  0xb4 & 0xff,
  0xb3 & 0xff,
  0xb2 & 0xff,
  0xb0 & 0xff,
  0xaf & 0xff,
  0xae & 0xff,
  0xac & 0xff,
  0xab & 0xff,
  0xaa & 0xff,
  0xa9 & 0xff,
  0xa8 & 0xff,
  0xa7 & 0xff,
  0xa6 & 0xff,
  0xa5 & 0xff,
  0xa3 & 0xff,
  0xa2 & 0xff,
  0xa1 & 0xff,
  0xa0 & 0xff,
  0x9f & 0xff,
  0x9e & 0xff,
  0x9e & 0xff,
  0x9d & 0xff,
  0x9c & 0xff,
  0x9b & 0xff,
  0x9a & 0xff,
  0x99 & 0xff,
  0x98 & 0xff,
  0x97 & 0xff,
  0x97 & 0xff,
  0x96 & 0xff,
  0x95 & 0xff,
  0x94 & 0xff,
  0x93 & 0xff,
  0x93 & 0xff,
  0x92 & 0xff,
  0x91 & 0xff,
  0x90 & 0xff,
  0x90 & 0xff,
  0x8f & 0xff,
  0x8e & 0xff,
  0x8e & 0xff,
  0x8d & 0xff,
  0x8c & 0xff,
  0x8c & 0xff,
  0x8b & 0xff,
  0x8a & 0xff,
  0x8a & 0xff,
  0x89 & 0xff,
  0x89 & 0xff,
  0x88 & 0xff,
  0x87 & 0xff,
  0x87 & 0xff,
  0x86 & 0xff,
  0x86 & 0xff,
  0x85 & 0xff,
  0x84 & 0xff,
  0x84 & 0xff,
  0x83 & 0xff,
  0x83 & 0xff,
  0x82 & 0xff,
  0x82 & 0xff,
  0x81 & 0xff,
  0x81 & 0xff,
  0x80 & 0xff,
  0xff & 0xff,
  0xfd & 0xff,
  0xfb & 0xff,
  0xf9 & 0xff,
  0xf7 & 0xff,
  0xf6 & 0xff,
  0xf4 & 0xff,
  0xf2 & 0xff,
  0xf1 & 0xff,
  0xef & 0xff,
  0xed & 0xff,
  0xec & 0xff,
  0xea & 0xff,
  0xe9 & 0xff,
  0xe7 & 0xff,
  0xe6 & 0xff,
  0xe4 & 0xff,
  0xe3 & 0xff,
  0xe1 & 0xff,
  0xe0 & 0xff,
  0xdf & 0xff,
  0xdd & 0xff,
  0xdc & 0xff,
  0xdb & 0xff,
  0xda & 0xff,
  0xd8 & 0xff,
  0xd7 & 0xff,
  0xd6 & 0xff,
  0xd5 & 0xff,
  0xd4 & 0xff,
  0xd3 & 0xff,
  0xd2 & 0xff,
  0xd0 & 0xff,
  0xcf & 0xff,
  0xce & 0xff,
  0xcd & 0xff,
  0xcc & 0xff,
  0xcb & 0xff,
  0xca & 0xff,
  0xc9 & 0xff,
  0xc8 & 0xff,
  0xc7 & 0xff,
  0xc6 & 0xff,
  0xc6 & 0xff,
  0xc5 & 0xff,
  0xc4 & 0xff,
  0xc3 & 0xff,
  0xc2 & 0xff,
  0xc1 & 0xff,
  0xc0 & 0xff,
  0xbf & 0xff,
  0xbf & 0xff,
  0xbe & 0xff,
  0xbd & 0xff,
  0xbc & 0xff,
  0xbb & 0xff,
  0xbb & 0xff,
  0xba & 0xff,
  0xb9 & 0xff,
  0xb8 & 0xff,
  0xb8 & 0xff,
  0xb7 & 0xff,
  0xb6 & 0xff,
  0xb5 & 0xff,
  0
};

/* constant table vfpu2_table_mulmux */
static const unsigned CONST_TBL_vfpu2_table_mulmux_0[] = {
  0xe & 0x3f,
  0x1e & 0x3f,
  0
};

/* constant table vfpu2_table_maddmux */
static const unsigned CONST_TBL_vfpu2_table_maddmux_0[] = {
  0xe & 0x3f,
  0x21 & 0x3f,
  0x3e & 0x3f,
  0x11 & 0x3f,
  0x1e & 0x3f,
  0x1 & 0x3f,
  0x2e & 0x3f,
  0x31 & 0x3f,
  0
};

/* constant table xdsem_tab_la_default */
static const unsigned CONST_TBL_xdsem_tab_la_default_0[] = {
  0xffff & 0xffff,
  0xfffe & 0xffff,
  0xfffc & 0xffff,
  0xfff8 & 0xffff,
  0xfff0 & 0xffff,
  0xffe0 & 0xffff,
  0xffc0 & 0xffff,
  0xff80 & 0xffff,
  0xff00 & 0xffff,
  0xfe00 & 0xffff,
  0xfc00 & 0xffff,
  0xf800 & 0xffff,
  0xf000 & 0xffff,
  0xe000 & 0xffff,
  0xc000 & 0xffff,
  0x8000 & 0xffff,
  0
};

/* constant table xdsem_tab_lahr */
static const unsigned CONST_TBL_xdsem_tab_lahr_0[] = {
  0xff & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0
};

/* constant table xdsem_tab_lahs */
static const unsigned CONST_TBL_xdsem_tab_lahs_0[] = {
  0xff00 & 0xffff,
  0xff00 & 0xffff,
  0xff00 & 0xffff,
  0xff00 & 0xffff,
  0xff00 & 0xffff,
  0xff00 & 0xffff,
  0xff00 & 0xffff,
  0xff00 & 0xffff,
  0xff00 & 0xffff,
  0xff00 & 0xffff,
  0xff00 & 0xffff,
  0xff00 & 0xffff,
  0xff00 & 0xffff,
  0xff00 & 0xffff,
  0xff00 & 0xffff,
  0xff00 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_rev8_m64 */
static const unsigned CONST_TBL_xdsem_tab_ld_rev8_m64_0[] = {
  0x100 & 0xffff,
  0x200 & 0xffff,
  0x400 & 0xffff,
  0x800 & 0xffff,
  0x1000 & 0xffff,
  0x2000 & 0xffff,
  0x4000 & 0xffff,
  0x8000 & 0xffff,
  0x1 & 0xffff,
  0x2 & 0xffff,
  0x4 & 0xffff,
  0x8 & 0xffff,
  0x10 & 0xffff,
  0x20 & 0xffff,
  0x40 & 0xffff,
  0x80 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_rev8_m32 */
static const unsigned CONST_TBL_xdsem_tab_ld_rev8_m32_0[] = {
  0x1010 & 0xffff,
  0x2020 & 0xffff,
  0x4040 & 0xffff,
  0x8080 & 0xffff,
  0x101 & 0xffff,
  0x202 & 0xffff,
  0x404 & 0xffff,
  0x808 & 0xffff,
  0x1010 & 0xffff,
  0x2020 & 0xffff,
  0x4040 & 0xffff,
  0x8080 & 0xffff,
  0x101 & 0xffff,
  0x202 & 0xffff,
  0x404 & 0xffff,
  0x808 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_rev8_m16 */
static const unsigned CONST_TBL_xdsem_tab_ld_rev8_m16_0[] = {
  0x4444 & 0xffff,
  0x8888 & 0xffff,
  0x1111 & 0xffff,
  0x2222 & 0xffff,
  0x4444 & 0xffff,
  0x8888 & 0xffff,
  0x1111 & 0xffff,
  0x2222 & 0xffff,
  0x4444 & 0xffff,
  0x8888 & 0xffff,
  0x1111 & 0xffff,
  0x2222 & 0xffff,
  0x4444 & 0xffff,
  0x8888 & 0xffff,
  0x1111 & 0xffff,
  0x2222 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_rev8_m8 */
static const unsigned CONST_TBL_xdsem_tab_ld_rev8_m8_0[] = {
  0xaaaa & 0xffff,
  0x5555 & 0xffff,
  0xaaaa & 0xffff,
  0x5555 & 0xffff,
  0xaaaa & 0xffff,
  0x5555 & 0xffff,
  0xaaaa & 0xffff,
  0x5555 & 0xffff,
  0xaaaa & 0xffff,
  0x5555 & 0xffff,
  0xaaaa & 0xffff,
  0x5555 & 0xffff,
  0xaaaa & 0xffff,
  0x5555 & 0xffff,
  0xaaaa & 0xffff,
  0x5555 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_rev16_m64 */
static const unsigned CONST_TBL_xdsem_tab_ld_rev16_m64_0[] = {
  0 & 0xffff,
  0 & 0xffff,
  0x3 & 0xffff,
  0x3 & 0xffff,
  0xf & 0xffff,
  0xf & 0xffff,
  0x3f & 0xffff,
  0x3f & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0xfc & 0xffff,
  0xfc & 0xffff,
  0xf0 & 0xffff,
  0xf0 & 0xffff,
  0xc0 & 0xffff,
  0xc0 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_rev16_m32 */
static const unsigned CONST_TBL_xdsem_tab_ld_rev16_m32_0[] = {
  0xff & 0xffff,
  0xff & 0xffff,
  0xcc & 0xffff,
  0xcc & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0x33 & 0xffff,
  0x33 & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0xcc & 0xffff,
  0xcc & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_rev16_m16 */
static const unsigned CONST_TBL_xdsem_tab_ld_rev16_m16_0[] = {
  0xff & 0xffff,
  0xff & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0xf0 & 0xffff,
  0xf0 & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_rev16_m8 */
static const unsigned CONST_TBL_xdsem_tab_ld_rev16_m8_0[] = {
  0 & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_128rev16_m32 */
static const unsigned CONST_TBL_xdsem_tab_ld_128rev16_m32_0[] = {
  0xffff & 0xffff,
  0xffff & 0xffff,
  0xcccc & 0xffff,
  0xcccc & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0x33 & 0xffff,
  0x33 & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0xcc & 0xffff,
  0xcc & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_128rev16_m16 */
static const unsigned CONST_TBL_xdsem_tab_ld_128rev16_m16_0[] = {
  0xffff & 0xffff,
  0xffff & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0xf0ff & 0xffff,
  0xf0ff & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0xf0 & 0xffff,
  0xf0 & 0xffff,
  0 & 0xffff,
  0 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_rev32_m64 */
static const unsigned CONST_TBL_xdsem_tab_ld_rev32_m64_0[] = {
  0xf00 & 0xffff,
  0xf00 & 0xffff,
  0xf00 & 0xffff,
  0xf00 & 0xffff,
  0xf000 & 0xffff,
  0xf000 & 0xffff,
  0xf000 & 0xffff,
  0xf000 & 0xffff,
  0xf & 0xffff,
  0xf & 0xffff,
  0xf & 0xffff,
  0xf & 0xffff,
  0xf0 & 0xffff,
  0xf0 & 0xffff,
  0xf0 & 0xffff,
  0xf0 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_rev32_m32 */
static const unsigned CONST_TBL_xdsem_tab_ld_rev32_m32_0[] = {
  0xf0f0 & 0xffff,
  0xf0f0 & 0xffff,
  0xf0f0 & 0xffff,
  0xf0f0 & 0xffff,
  0xf0f & 0xffff,
  0xf0f & 0xffff,
  0xf0f & 0xffff,
  0xf0f & 0xffff,
  0xf0f0 & 0xffff,
  0xf0f0 & 0xffff,
  0xf0f0 & 0xffff,
  0xf0f0 & 0xffff,
  0xf0f & 0xffff,
  0xf0f & 0xffff,
  0xf0f & 0xffff,
  0xf0f & 0xffff,
  0
};

/* constant table xdsem_tab_ld_rev64_m64 */
static const unsigned CONST_TBL_xdsem_tab_ld_rev64_m64_0[] = {
  0xff00 & 0xffff,
  0xff00 & 0xffff,
  0xff00 & 0xffff,
  0xff00 & 0xffff,
  0xff00 & 0xffff,
  0xff00 & 0xffff,
  0xff00 & 0xffff,
  0xff00 & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0xff & 0xffff,
  0
};

/* constant table xdsem_tab_ld_r16_m64 */
static const unsigned CONST_TBL_xdsem_tab_ld_r16_m64_0[] = {
  0x300 & 0xffff,
  0x300 & 0xffff,
  0xc00 & 0xffff,
  0xc00 & 0xffff,
  0x3000 & 0xffff,
  0x3000 & 0xffff,
  0xc000 & 0xffff,
  0xc000 & 0xffff,
  0x3 & 0xffff,
  0x3 & 0xffff,
  0xc & 0xffff,
  0xc & 0xffff,
  0x30 & 0xffff,
  0x30 & 0xffff,
  0xc0 & 0xffff,
  0xc0 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_r16_m32 */
static const unsigned CONST_TBL_xdsem_tab_ld_r16_m32_0[] = {
  0x3030 & 0xffff,
  0x3030 & 0xffff,
  0xc0c0 & 0xffff,
  0xc0c0 & 0xffff,
  0x303 & 0xffff,
  0x303 & 0xffff,
  0xc0c & 0xffff,
  0xc0c & 0xffff,
  0x3030 & 0xffff,
  0x3030 & 0xffff,
  0xc0c0 & 0xffff,
  0xc0c0 & 0xffff,
  0x303 & 0xffff,
  0x303 & 0xffff,
  0xc0c & 0xffff,
  0xc0c & 0xffff,
  0
};

/* constant table xdsem_tab_ld_r16_m16 */
static const unsigned CONST_TBL_xdsem_tab_ld_r16_m16_0[] = {
  0xcccc & 0xffff,
  0xcccc & 0xffff,
  0x3333 & 0xffff,
  0x3333 & 0xffff,
  0xcccc & 0xffff,
  0xcccc & 0xffff,
  0x3333 & 0xffff,
  0x3333 & 0xffff,
  0xcccc & 0xffff,
  0xcccc & 0xffff,
  0x3333 & 0xffff,
  0x3333 & 0xffff,
  0xcccc & 0xffff,
  0xcccc & 0xffff,
  0x3333 & 0xffff,
  0x3333 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_shiftrot_m64 */
static const unsigned CONST_TBL_xdsem_tab_ld_shiftrot_m64_0[] = {
  0 & 0xffff,
  0x101 & 0xffff,
  0x303 & 0xffff,
  0x707 & 0xffff,
  0xf0f & 0xffff,
  0x1f1f & 0xffff,
  0x3f3f & 0xffff,
  0x7f7f & 0xffff,
  0xffff & 0xffff,
  0xfefe & 0xffff,
  0xfcfc & 0xffff,
  0xf8f8 & 0xffff,
  0xf0f0 & 0xffff,
  0xe0e0 & 0xffff,
  0xc0c0 & 0xffff,
  0x8080 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_shiftrot_m32 */
static const unsigned CONST_TBL_xdsem_tab_ld_shiftrot_m32_0[] = {
  0 & 0xffff,
  0x1111 & 0xffff,
  0x3333 & 0xffff,
  0x7777 & 0xffff,
  0xffff & 0xffff,
  0xeeee & 0xffff,
  0xcccc & 0xffff,
  0x8888 & 0xffff,
  0 & 0xffff,
  0x1111 & 0xffff,
  0x3333 & 0xffff,
  0x7777 & 0xffff,
  0xffff & 0xffff,
  0xeeee & 0xffff,
  0xcccc & 0xffff,
  0x8888 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_shiftrot_m16 */
static const unsigned CONST_TBL_xdsem_tab_ld_shiftrot_m16_0[] = {
  0 & 0xffff,
  0x5555 & 0xffff,
  0xffff & 0xffff,
  0xaaaa & 0xffff,
  0 & 0xffff,
  0x5555 & 0xffff,
  0xffff & 0xffff,
  0xaaaa & 0xffff,
  0 & 0xffff,
  0x5555 & 0xffff,
  0xffff & 0xffff,
  0xaaaa & 0xffff,
  0 & 0xffff,
  0x5555 & 0xffff,
  0xffff & 0xffff,
  0xaaaa & 0xffff,
  0
};

/* constant table xdsem_tab_ld_shiftrot_m8 */
static const unsigned CONST_TBL_xdsem_tab_ld_shiftrot_m8_0[] = {
  0 & 0xffff,
  0xffff & 0xffff,
  0 & 0xffff,
  0xffff & 0xffff,
  0 & 0xffff,
  0xffff & 0xffff,
  0 & 0xffff,
  0xffff & 0xffff,
  0 & 0xffff,
  0xffff & 0xffff,
  0 & 0xffff,
  0xffff & 0xffff,
  0 & 0xffff,
  0xffff & 0xffff,
  0 & 0xffff,
  0xffff & 0xffff,
  0
};

/* constant table xdsem_tab_ld_exp8to16_m64 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp8to16_m64_0[] = {
  0xf000 & 0xffff,
  0xe000 & 0xffff,
  0xc000 & 0xffff,
  0x8000 & 0xffff,
  0 & 0xffff,
  0x1 & 0xffff,
  0x3 & 0xffff,
  0x7 & 0xffff,
  0xf & 0xffff,
  0x11e & 0xffff,
  0x33c & 0xffff,
  0x778 & 0xffff,
  0xff0 & 0xffff,
  0x1ee0 & 0xffff,
  0x3cc0 & 0xffff,
  0x7880 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_exp8to16_m32 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp8to16_m32_0[] = {
  0x3c0 & 0xffff,
  0x1680 & 0xffff,
  0x3c00 & 0xffff,
  0x6801 & 0xffff,
  0xc003 & 0xffff,
  0x8016 & 0xffff,
  0x3c & 0xffff,
  0x168 & 0xffff,
  0x3c0 & 0xffff,
  0x1680 & 0xffff,
  0x3c00 & 0xffff,
  0x6801 & 0xffff,
  0xc003 & 0xffff,
  0x8016 & 0xffff,
  0x3c & 0xffff,
  0x168 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_exp8to16_m16 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp8to16_m16_0[] = {
  0x1818 & 0xffff,
  0x6060 & 0xffff,
  0x8181 & 0xffff,
  0x606 & 0xffff,
  0x1818 & 0xffff,
  0x6060 & 0xffff,
  0x8181 & 0xffff,
  0x606 & 0xffff,
  0x1818 & 0xffff,
  0x6060 & 0xffff,
  0x8181 & 0xffff,
  0x606 & 0xffff,
  0x1818 & 0xffff,
  0x6060 & 0xffff,
  0x8181 & 0xffff,
  0x606 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_exp8to16_m8 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp8to16_m8_0[] = {
  0x6666 & 0xffff,
  0x9999 & 0xffff,
  0x6666 & 0xffff,
  0x9999 & 0xffff,
  0x6666 & 0xffff,
  0x9999 & 0xffff,
  0x6666 & 0xffff,
  0x9999 & 0xffff,
  0x6666 & 0xffff,
  0x9999 & 0xffff,
  0x6666 & 0xffff,
  0x9999 & 0xffff,
  0x6666 & 0xffff,
  0x9999 & 0xffff,
  0x6666 & 0xffff,
  0x9999 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_exp16to32_m16 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp16to32_m16_0[] = {
  0x3838 & 0xffff,
  0x6161 & 0xffff,
  0x8383 & 0xffff,
  0x1616 & 0xffff,
  0x3838 & 0xffff,
  0x6161 & 0xffff,
  0x8383 & 0xffff,
  0x1616 & 0xffff,
  0x3838 & 0xffff,
  0x6161 & 0xffff,
  0x8383 & 0xffff,
  0x1616 & 0xffff,
  0x3838 & 0xffff,
  0x6161 & 0xffff,
  0x8383 & 0xffff,
  0x1616 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_exp16to32_m8 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp16to32_m8_0[] = {
  0x4444 & 0xffff,
  0xbbbb & 0xffff,
  0x4444 & 0xffff,
  0xbbbb & 0xffff,
  0x4444 & 0xffff,
  0xbbbb & 0xffff,
  0x4444 & 0xffff,
  0xbbbb & 0xffff,
  0x4444 & 0xffff,
  0xbbbb & 0xffff,
  0x4444 & 0xffff,
  0xbbbb & 0xffff,
  0x4444 & 0xffff,
  0xbbbb & 0xffff,
  0x4444 & 0xffff,
  0xbbbb & 0xffff,
  0
};

/* constant table xdsem_tab_ld_exp8to32_m64 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp8to32_m64_0[] = {
  0xc00 & 0xffff,
  0x1800 & 0xffff,
  0x3000 & 0xffff,
  0x6000 & 0xffff,
  0xc000 & 0xffff,
  0x8000 & 0xffff,
  0 & 0xffff,
  0x1 & 0xffff,
  0x3 & 0xffff,
  0x6 & 0xffff,
  0xc & 0xffff,
  0x18 & 0xffff,
  0x30 & 0xffff,
  0x160 & 0xffff,
  0x3c0 & 0xffff,
  0x680 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_exp8to32_m32 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp8to32_m32_0[] = {
  0x8020 & 0xffff,
  0x40 & 0xffff,
  0x180 & 0xffff,
  0x200 & 0xffff,
  0x401 & 0xffff,
  0x1802 & 0xffff,
  0x2004 & 0xffff,
  0x4018 & 0xffff,
  0x8020 & 0xffff,
  0x40 & 0xffff,
  0x180 & 0xffff,
  0x200 & 0xffff,
  0x401 & 0xffff,
  0x1802 & 0xffff,
  0x2004 & 0xffff,
  0x4018 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_exp8to32_m16 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp8to32_m16_0[] = {
  0x2184 & 0xffff,
  0x4218 & 0xffff,
  0x8421 & 0xffff,
  0x1842 & 0xffff,
  0x2184 & 0xffff,
  0x4218 & 0xffff,
  0x8421 & 0xffff,
  0x1842 & 0xffff,
  0x2184 & 0xffff,
  0x4218 & 0xffff,
  0x8421 & 0xffff,
  0x1842 & 0xffff,
  0x2184 & 0xffff,
  0x4218 & 0xffff,
  0x8421 & 0xffff,
  0x1842 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_exp8to32_m8 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp8to32_m8_0[] = {
  0x5a5a & 0xffff,
  0xa5a5 & 0xffff,
  0x5a5a & 0xffff,
  0xa5a5 & 0xffff,
  0x5a5a & 0xffff,
  0xa5a5 & 0xffff,
  0x5a5a & 0xffff,
  0xa5a5 & 0xffff,
  0x5a5a & 0xffff,
  0xa5a5 & 0xffff,
  0x5a5a & 0xffff,
  0xa5a5 & 0xffff,
  0x5a5a & 0xffff,
  0xa5a5 & 0xffff,
  0x5a5a & 0xffff,
  0xa5a5 & 0xffff,
  0
};

/* constant table xdsem_tab_ld_exp16to32h_m16 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp16to32h_m16_0[] = {
  0x3c3c & 0xffff,
  0x6969 & 0xffff,
  0xc3c3 & 0xffff,
  0x9696 & 0xffff,
  0x3c3c & 0xffff,
  0x6969 & 0xffff,
  0xc3c3 & 0xffff,
  0x9696 & 0xffff,
  0x3c3c & 0xffff,
  0x6969 & 0xffff,
  0xc3c3 & 0xffff,
  0x9696 & 0xffff,
  0x3c3c & 0xffff,
  0x6969 & 0xffff,
  0xc3c3 & 0xffff,
  0x9696 & 0xffff,
  0
};

/* constant table xdsem_tab_st_compr16to8_m8 */
static const unsigned CONST_TBL_xdsem_tab_st_compr16to8_m8_0[] = {
  0x8888 & 0xffff,
  0x2222 & 0xffff,
  0x8888 & 0xffff,
  0x2222 & 0xffff,
  0x8888 & 0xffff,
  0x2222 & 0xffff,
  0x8888 & 0xffff,
  0x2222 & 0xffff,
  0x8888 & 0xffff,
  0x2222 & 0xffff,
  0x8888 & 0xffff,
  0x2222 & 0xffff,
  0x8888 & 0xffff,
  0x2222 & 0xffff,
  0x8888 & 0xffff,
  0x2222 & 0xffff,
  0
};

/* constant table xdsem_tab_st_compr16to8_m16 */
static const unsigned CONST_TBL_xdsem_tab_st_compr16to8_m16_0[] = {
  0x4242 & 0xffff,
  0x9090 & 0xffff,
  0x2424 & 0xffff,
  0x909 & 0xffff,
  0x4242 & 0xffff,
  0x9090 & 0xffff,
  0x2424 & 0xffff,
  0x909 & 0xffff,
  0x4242 & 0xffff,
  0x9090 & 0xffff,
  0x2424 & 0xffff,
  0x909 & 0xffff,
  0x4242 & 0xffff,
  0x9090 & 0xffff,
  0x2424 & 0xffff,
  0x909 & 0xffff,
  0
};

/* constant table xdsem_tab_st_compr16to8_m32 */
static const unsigned CONST_TBL_xdsem_tab_st_compr16to8_m32_0[] = {
  0x300c & 0xffff,
  0x6108 & 0xffff,
  0xc300 & 0xffff,
  0x8610 & 0xffff,
  0xc30 & 0xffff,
  0x861 & 0xffff,
  0xc3 & 0xffff,
  0x1086 & 0xffff,
  0x300c & 0xffff,
  0x6108 & 0xffff,
  0xc300 & 0xffff,
  0x8610 & 0xffff,
  0xc30 & 0xffff,
  0x861 & 0xffff,
  0xc3 & 0xffff,
  0x1086 & 0xffff,
  0
};

/* constant table xdsem_tab_st_compr16to8_m64 */
static const unsigned CONST_TBL_xdsem_tab_st_compr16to8_m64_0[] = {
  0xf0 & 0xffff,
  0xe0 & 0xffff,
  0xc0 & 0xffff,
  0x80 & 0xffff,
  0 & 0xffff,
  0x100 & 0xffff,
  0x300 & 0xffff,
  0x700 & 0xffff,
  0xf00 & 0xffff,
  0x1e01 & 0xffff,
  0x3c03 & 0xffff,
  0x7807 & 0xffff,
  0xf00f & 0xffff,
  0xe01e & 0xffff,
  0xc03c & 0xffff,
  0x8078 & 0xffff,
  0
};

/* constant table xdsem_tab_st_compr32to8_m8 */
static const unsigned CONST_TBL_xdsem_tab_st_compr32to8_m8_0[] = {
  0x2020 & 0xffff,
  0x202 & 0xffff,
  0x2020 & 0xffff,
  0x202 & 0xffff,
  0x2020 & 0xffff,
  0x202 & 0xffff,
  0x2020 & 0xffff,
  0x202 & 0xffff,
  0x2020 & 0xffff,
  0x202 & 0xffff,
  0x2020 & 0xffff,
  0x202 & 0xffff,
  0x2020 & 0xffff,
  0x202 & 0xffff,
  0x2020 & 0xffff,
  0x202 & 0xffff,
  0
};

/* constant table xdsem_tab_st_compr32to8_m16 */
static const unsigned CONST_TBL_xdsem_tab_st_compr32to8_m16_0[] = {
  0x8400 & 0xffff,
  0x840 & 0xffff,
  0x84 & 0xffff,
  0x4008 & 0xffff,
  0x8400 & 0xffff,
  0x840 & 0xffff,
  0x84 & 0xffff,
  0x4008 & 0xffff,
  0x8400 & 0xffff,
  0x840 & 0xffff,
  0x84 & 0xffff,
  0x4008 & 0xffff,
  0x8400 & 0xffff,
  0x840 & 0xffff,
  0x84 & 0xffff,
  0x4008 & 0xffff,
  0
};

/* constant table xdsem_tab_st_compr32to8_m32 */
static const unsigned CONST_TBL_xdsem_tab_st_compr32to8_m32_0[] = {
  0x802 & 0xffff,
  0x4 & 0xffff,
  0x1008 & 0xffff,
  0x2000 & 0xffff,
  0x4010 & 0xffff,
  0x8120 & 0xffff,
  0x240 & 0xffff,
  0x481 & 0xffff,
  0x802 & 0xffff,
  0x4 & 0xffff,
  0x1008 & 0xffff,
  0x2000 & 0xffff,
  0x4010 & 0xffff,
  0x8120 & 0xffff,
  0x240 & 0xffff,
  0x481 & 0xffff,
  0
};

/* constant table xdsem_tab_st_compr32to8_m64 */
static const unsigned CONST_TBL_xdsem_tab_st_compr32to8_m64_0[] = {
  0xc & 0xffff,
  0x18 & 0xffff,
  0x30 & 0xffff,
  0x60 & 0xffff,
  0xc0 & 0xffff,
  0x80 & 0xffff,
  0 & 0xffff,
  0x100 & 0xffff,
  0x300 & 0xffff,
  0x600 & 0xffff,
  0xc00 & 0xffff,
  0x1800 & 0xffff,
  0x3000 & 0xffff,
  0x6001 & 0xffff,
  0xc003 & 0xffff,
  0x8006 & 0xffff,
  0
};

/* constant table xdsem_tab_st_compr32to16_m8 */
static const unsigned CONST_TBL_xdsem_tab_st_compr32to16_m8_0[] = {
  0 & 0xffff,
  0x3333 & 0xffff,
  0 & 0xffff,
  0x3333 & 0xffff,
  0 & 0xffff,
  0x3333 & 0xffff,
  0 & 0xffff,
  0x3333 & 0xffff,
  0 & 0xffff,
  0x3333 & 0xffff,
  0 & 0xffff,
  0x3333 & 0xffff,
  0 & 0xffff,
  0x3333 & 0xffff,
  0 & 0xffff,
  0x3333 & 0xffff,
  0
};

/* constant table xdsem_tab_st_compr32to16_m16 */
static const unsigned CONST_TBL_xdsem_tab_st_compr32to16_m16_0[] = {
  0xc0c0 & 0xffff,
  0x8484 & 0xffff,
  0xc0c & 0xffff,
  0x4848 & 0xffff,
  0xc0c0 & 0xffff,
  0x8484 & 0xffff,
  0xc0c & 0xffff,
  0x4848 & 0xffff,
  0xc0c0 & 0xffff,
  0x8484 & 0xffff,
  0xc0c & 0xffff,
  0x4848 & 0xffff,
  0xc0c0 & 0xffff,
  0x8484 & 0xffff,
  0xc0c & 0xffff,
  0x4848 & 0xffff,
  0
};


/* Instruction operands.  */

static int
OperandSem_opnd_sem_soffsetx4_decode (uint32 *valp)
{
  unsigned soffsetx4_out_0;
  unsigned soffsetx4_in_0;
  soffsetx4_in_0 = *valp & 0x3ffff;
  soffsetx4_out_0 = 0x4 + ((((int) soffsetx4_in_0 << 14) >> 14) << 2);
  *valp = soffsetx4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_soffsetx4_encode (uint32 *valp)
{
  unsigned soffsetx4_in_0;
  unsigned soffsetx4_out_0;
  soffsetx4_out_0 = *valp;
  soffsetx4_in_0 = ((soffsetx4_out_0 - 0x4) >> 2) & 0x3ffff;
  *valp = soffsetx4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_immr_decode (uint32 *valp)
{
  unsigned immr_out_0;
  unsigned immr_in_0;
  immr_in_0 = *valp & 0xf;
  immr_out_0 = immr_in_0;
  *valp = immr_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_immr_encode (uint32 *valp)
{
  unsigned immr_in_0;
  unsigned immr_out_0;
  immr_out_0 = *valp;
  immr_in_0 = (immr_out_0 & 0xf);
  *valp = immr_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm12x8_decode (uint32 *valp)
{
  unsigned uimm12x8_out_0;
  unsigned uimm12x8_in_0;
  uimm12x8_in_0 = *valp & 0xfff;
  uimm12x8_out_0 = uimm12x8_in_0 << 3;
  *valp = uimm12x8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm12x8_encode (uint32 *valp)
{
  unsigned uimm12x8_in_0;
  unsigned uimm12x8_out_0;
  uimm12x8_out_0 = *valp;
  uimm12x8_in_0 = ((uimm12x8_out_0 >> 3) & 0xfff);
  *valp = uimm12x8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm4_decode (uint32 *valp)
{
  unsigned simm4_out_0;
  unsigned simm4_in_0;
  simm4_in_0 = *valp & 0xf;
  simm4_out_0 = ((int) simm4_in_0 << 28) >> 28;
  *valp = simm4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm4_encode (uint32 *valp)
{
  unsigned simm4_in_0;
  unsigned simm4_out_0;
  simm4_out_0 = *valp;
  simm4_in_0 = (simm4_out_0 & 0xf);
  *valp = simm4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_AR_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 64);
  return error;
}

static int
OperandSem_opnd_sem_AR_0_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_0_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 64);
  return error;
}

static int
OperandSem_opnd_sem_AR_4_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_4_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 64);
  return error;
}

static int
OperandSem_opnd_sem_AR_8_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_8_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 64);
  return error;
}

static int
OperandSem_opnd_sem_AR_12_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_12_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 64);
  return error;
}

static int
OperandSem_opnd_sem_AR_entry_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_entry_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 64);
  return error;
}

static int
OperandSem_opnd_sem_immrx4_decode (uint32 *valp)
{
  unsigned immrx4_out_0;
  unsigned immrx4_in_0;
  immrx4_in_0 = *valp & 0xf;
  immrx4_out_0 = (((0xfffffff) << 4) | immrx4_in_0) << 2;
  *valp = immrx4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_immrx4_encode (uint32 *valp)
{
  unsigned immrx4_in_0;
  unsigned immrx4_out_0;
  immrx4_out_0 = *valp;
  immrx4_in_0 = ((immrx4_out_0 >> 2) & 0xf);
  *valp = immrx4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_lsi4x4_decode (uint32 *valp)
{
  unsigned lsi4x4_out_0;
  unsigned lsi4x4_in_0;
  lsi4x4_in_0 = *valp & 0xf;
  lsi4x4_out_0 = lsi4x4_in_0 << 2;
  *valp = lsi4x4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_lsi4x4_encode (uint32 *valp)
{
  unsigned lsi4x4_in_0;
  unsigned lsi4x4_out_0;
  lsi4x4_out_0 = *valp;
  lsi4x4_in_0 = ((lsi4x4_out_0 >> 2) & 0xf);
  *valp = lsi4x4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm7_decode (uint32 *valp)
{
  unsigned simm7_out_0;
  unsigned simm7_in_0;
  simm7_in_0 = *valp & 0x7f;
  simm7_out_0 = ((((-((((simm7_in_0 >> 6) & 1)) & (((simm7_in_0 >> 5) & 1)))) & 0x1ffffff)) << 7) | simm7_in_0;
  *valp = simm7_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm7_encode (uint32 *valp)
{
  unsigned simm7_in_0;
  unsigned simm7_out_0;
  simm7_out_0 = *valp;
  simm7_in_0 = (simm7_out_0 & 0x7f);
  *valp = simm7_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm6_decode (uint32 *valp)
{
  unsigned uimm6_out_0;
  unsigned uimm6_in_0;
  uimm6_in_0 = *valp & 0x3f;
  uimm6_out_0 = 0x4 + (((0) << 6) | uimm6_in_0);
  *valp = uimm6_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm6_encode (uint32 *valp)
{
  unsigned uimm6_in_0;
  unsigned uimm6_out_0;
  uimm6_out_0 = *valp;
  uimm6_in_0 = (uimm6_out_0 - 0x4) & 0x3f;
  *valp = uimm6_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ai4const_decode (uint32 *valp)
{
  unsigned ai4const_out_0;
  unsigned ai4const_in_0;
  ai4const_in_0 = *valp & 0xf;
  ai4const_out_0 = CONST_TBL_ai4c_0[ai4const_in_0 & 0xf];
  *valp = ai4const_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ai4const_encode (uint32 *valp)
{
  unsigned ai4const_in_0;
  unsigned ai4const_out_0;
  ai4const_out_0 = *valp;
  switch (ai4const_out_0)
    {
    case 0xffffffff: ai4const_in_0 = 0; break;
    case 0x1: ai4const_in_0 = 0x1; break;
    case 0x2: ai4const_in_0 = 0x2; break;
    case 0x3: ai4const_in_0 = 0x3; break;
    case 0x4: ai4const_in_0 = 0x4; break;
    case 0x5: ai4const_in_0 = 0x5; break;
    case 0x6: ai4const_in_0 = 0x6; break;
    case 0x7: ai4const_in_0 = 0x7; break;
    case 0x8: ai4const_in_0 = 0x8; break;
    case 0x9: ai4const_in_0 = 0x9; break;
    case 0xa: ai4const_in_0 = 0xa; break;
    case 0xb: ai4const_in_0 = 0xb; break;
    case 0xc: ai4const_in_0 = 0xc; break;
    case 0xd: ai4const_in_0 = 0xd; break;
    case 0xe: ai4const_in_0 = 0xe; break;
    default: ai4const_in_0 = 0xf; break;
    }
  *valp = ai4const_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4const_decode (uint32 *valp)
{
  unsigned b4const_out_0;
  unsigned b4const_in_0;
  b4const_in_0 = *valp & 0xf;
  b4const_out_0 = CONST_TBL_b4c_0[b4const_in_0 & 0xf];
  *valp = b4const_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4const_encode (uint32 *valp)
{
  unsigned b4const_in_0;
  unsigned b4const_out_0;
  b4const_out_0 = *valp;
  switch (b4const_out_0)
    {
    case 0xffffffff: b4const_in_0 = 0; break;
    case 0x1: b4const_in_0 = 0x1; break;
    case 0x2: b4const_in_0 = 0x2; break;
    case 0x3: b4const_in_0 = 0x3; break;
    case 0x4: b4const_in_0 = 0x4; break;
    case 0x5: b4const_in_0 = 0x5; break;
    case 0x6: b4const_in_0 = 0x6; break;
    case 0x7: b4const_in_0 = 0x7; break;
    case 0x8: b4const_in_0 = 0x8; break;
    case 0xa: b4const_in_0 = 0x9; break;
    case 0xc: b4const_in_0 = 0xa; break;
    case 0x10: b4const_in_0 = 0xb; break;
    case 0x20: b4const_in_0 = 0xc; break;
    case 0x40: b4const_in_0 = 0xd; break;
    case 0x80: b4const_in_0 = 0xe; break;
    default: b4const_in_0 = 0xf; break;
    }
  *valp = b4const_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4constu_decode (uint32 *valp)
{
  unsigned b4constu_out_0;
  unsigned b4constu_in_0;
  b4constu_in_0 = *valp & 0xf;
  b4constu_out_0 = CONST_TBL_b4cu_0[b4constu_in_0 & 0xf];
  *valp = b4constu_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4constu_encode (uint32 *valp)
{
  unsigned b4constu_in_0;
  unsigned b4constu_out_0;
  b4constu_out_0 = *valp;
  switch (b4constu_out_0)
    {
    case 0x8000: b4constu_in_0 = 0; break;
    case 0x10000: b4constu_in_0 = 0x1; break;
    case 0x2: b4constu_in_0 = 0x2; break;
    case 0x3: b4constu_in_0 = 0x3; break;
    case 0x4: b4constu_in_0 = 0x4; break;
    case 0x5: b4constu_in_0 = 0x5; break;
    case 0x6: b4constu_in_0 = 0x6; break;
    case 0x7: b4constu_in_0 = 0x7; break;
    case 0x8: b4constu_in_0 = 0x8; break;
    case 0xa: b4constu_in_0 = 0x9; break;
    case 0xc: b4constu_in_0 = 0xa; break;
    case 0x10: b4constu_in_0 = 0xb; break;
    case 0x20: b4constu_in_0 = 0xc; break;
    case 0x40: b4constu_in_0 = 0xd; break;
    case 0x80: b4constu_in_0 = 0xe; break;
    default: b4constu_in_0 = 0xf; break;
    }
  *valp = b4constu_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_immt_decode (uint32 *valp)
{
  unsigned immt_out_0;
  unsigned immt_in_0;
  immt_in_0 = *valp & 0xf;
  immt_out_0 = immt_in_0;
  *valp = immt_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_immt_encode (uint32 *valp)
{
  unsigned immt_in_0;
  unsigned immt_out_0;
  immt_out_0 = *valp;
  immt_in_0 = immt_out_0 & 0xf;
  *valp = immt_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimms8_decode (uint32 *valp)
{
  unsigned uimms8_out_0;
  unsigned uimms8_in_0;
  uimms8_in_0 = *valp & 0x7;
  uimms8_out_0 = uimms8_in_0;
  *valp = uimms8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimms8_encode (uint32 *valp)
{
  unsigned uimms8_in_0;
  unsigned uimms8_out_0;
  uimms8_out_0 = *valp;
  uimms8_in_0 = uimms8_out_0 & 0x7;
  *valp = uimms8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8_decode (uint32 *valp)
{
  unsigned uimm8_out_0;
  unsigned uimm8_in_0;
  uimm8_in_0 = *valp & 0xff;
  uimm8_out_0 = uimm8_in_0;
  *valp = uimm8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8_encode (uint32 *valp)
{
  unsigned uimm8_in_0;
  unsigned uimm8_out_0;
  uimm8_out_0 = *valp;
  uimm8_in_0 = (uimm8_out_0 & 0xff);
  *valp = uimm8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x2_decode (uint32 *valp)
{
  unsigned uimm8x2_out_0;
  unsigned uimm8x2_in_0;
  uimm8x2_in_0 = *valp & 0xff;
  uimm8x2_out_0 = uimm8x2_in_0 << 1;
  *valp = uimm8x2_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x2_encode (uint32 *valp)
{
  unsigned uimm8x2_in_0;
  unsigned uimm8x2_out_0;
  uimm8x2_out_0 = *valp;
  uimm8x2_in_0 = ((uimm8x2_out_0 >> 1) & 0xff);
  *valp = uimm8x2_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x4_decode (uint32 *valp)
{
  unsigned uimm8x4_out_0;
  unsigned uimm8x4_in_0;
  uimm8x4_in_0 = *valp & 0xff;
  uimm8x4_out_0 = uimm8x4_in_0 << 2;
  *valp = uimm8x4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x4_encode (uint32 *valp)
{
  unsigned uimm8x4_in_0;
  unsigned uimm8x4_out_0;
  uimm8x4_out_0 = *valp;
  uimm8x4_in_0 = ((uimm8x4_out_0 >> 2) & 0xff);
  *valp = uimm8x4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm4x16_decode (uint32 *valp)
{
  unsigned uimm4x16_out_0;
  unsigned uimm4x16_in_0;
  uimm4x16_in_0 = *valp & 0xf;
  uimm4x16_out_0 = uimm4x16_in_0 << 4;
  *valp = uimm4x16_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm4x16_encode (uint32 *valp)
{
  unsigned uimm4x16_in_0;
  unsigned uimm4x16_out_0;
  uimm4x16_out_0 = *valp;
  uimm4x16_in_0 = ((uimm4x16_out_0 >> 4) & 0xf);
  *valp = uimm4x16_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimmrx4_decode (uint32 *valp)
{
  unsigned uimmrx4_out_0;
  unsigned uimmrx4_in_0;
  uimmrx4_in_0 = *valp & 0xf;
  uimmrx4_out_0 = uimmrx4_in_0 << 2;
  *valp = uimmrx4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimmrx4_encode (uint32 *valp)
{
  unsigned uimmrx4_in_0;
  unsigned uimmrx4_out_0;
  uimmrx4_out_0 = *valp;
  uimmrx4_in_0 = ((uimmrx4_out_0 >> 2) & 0xf);
  *valp = uimmrx4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8_decode (uint32 *valp)
{
  unsigned simm8_out_0;
  unsigned simm8_in_0;
  simm8_in_0 = *valp & 0xff;
  simm8_out_0 = ((int) simm8_in_0 << 24) >> 24;
  *valp = simm8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8_encode (uint32 *valp)
{
  unsigned simm8_in_0;
  unsigned simm8_out_0;
  simm8_out_0 = *valp;
  simm8_in_0 = (simm8_out_0 & 0xff);
  *valp = simm8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8x256_decode (uint32 *valp)
{
  unsigned simm8x256_out_0;
  unsigned simm8x256_in_0;
  simm8x256_in_0 = *valp & 0xff;
  simm8x256_out_0 = (((int) simm8x256_in_0 << 24) >> 24) << 8;
  *valp = simm8x256_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8x256_encode (uint32 *valp)
{
  unsigned simm8x256_in_0;
  unsigned simm8x256_out_0;
  simm8x256_out_0 = *valp;
  simm8x256_in_0 = ((simm8x256_out_0 >> 8) & 0xff);
  *valp = simm8x256_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm12b_decode (uint32 *valp)
{
  unsigned simm12b_out_0;
  unsigned simm12b_in_0;
  simm12b_in_0 = *valp & 0xfff;
  simm12b_out_0 = ((int) simm12b_in_0 << 20) >> 20;
  *valp = simm12b_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm12b_encode (uint32 *valp)
{
  unsigned simm12b_in_0;
  unsigned simm12b_out_0;
  simm12b_out_0 = *valp;
  simm12b_in_0 = (simm12b_out_0 & 0xfff);
  *valp = simm12b_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_msalp32_decode (uint32 *valp)
{
  unsigned msalp32_out_0;
  unsigned msalp32_in_0;
  msalp32_in_0 = *valp & 0x1f;
  msalp32_out_0 = 0x20 - msalp32_in_0;
  *valp = msalp32_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_msalp32_encode (uint32 *valp)
{
  unsigned msalp32_in_0;
  unsigned msalp32_out_0;
  msalp32_out_0 = *valp;
  msalp32_in_0 = (0x20 - msalp32_out_0) & 0x1f;
  *valp = msalp32_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_op2p1_decode (uint32 *valp)
{
  unsigned op2p1_out_0;
  unsigned op2p1_in_0;
  op2p1_in_0 = *valp & 0xf;
  op2p1_out_0 = op2p1_in_0 + 0x1;
  *valp = op2p1_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_op2p1_encode (uint32 *valp)
{
  unsigned op2p1_in_0;
  unsigned op2p1_out_0;
  op2p1_out_0 = *valp;
  op2p1_in_0 = (op2p1_out_0 - 0x1) & 0xf;
  *valp = op2p1_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_label8_decode (uint32 *valp)
{
  unsigned label8_out_0;
  unsigned label8_in_0;
  label8_in_0 = *valp & 0xff;
  label8_out_0 = 0x4 + (((int) label8_in_0 << 24) >> 24);
  *valp = label8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_label8_encode (uint32 *valp)
{
  unsigned label8_in_0;
  unsigned label8_out_0;
  label8_out_0 = *valp;
  label8_in_0 = (label8_out_0 - 0x4) & 0xff;
  *valp = label8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ulabel8_decode (uint32 *valp)
{
  unsigned ulabel8_out_0;
  unsigned ulabel8_in_0;
  ulabel8_in_0 = *valp & 0xff;
  ulabel8_out_0 = 0x4 + (((0) << 8) | ulabel8_in_0);
  *valp = ulabel8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ulabel8_encode (uint32 *valp)
{
  unsigned ulabel8_in_0;
  unsigned ulabel8_out_0;
  ulabel8_out_0 = *valp;
  ulabel8_in_0 = (ulabel8_out_0 - 0x4) & 0xff;
  *valp = ulabel8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_label12_decode (uint32 *valp)
{
  unsigned label12_out_0;
  unsigned label12_in_0;
  label12_in_0 = *valp & 0xfff;
  label12_out_0 = 0x4 + (((int) label12_in_0 << 20) >> 20);
  *valp = label12_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_label12_encode (uint32 *valp)
{
  unsigned label12_in_0;
  unsigned label12_out_0;
  label12_out_0 = *valp;
  label12_in_0 = (label12_out_0 - 0x4) & 0xfff;
  *valp = label12_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_soffset_decode (uint32 *valp)
{
  unsigned soffset_out_0;
  unsigned soffset_in_0;
  soffset_in_0 = *valp & 0x3ffff;
  soffset_out_0 = 0x4 + (((int) soffset_in_0 << 14) >> 14);
  *valp = soffset_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_soffset_encode (uint32 *valp)
{
  unsigned soffset_in_0;
  unsigned soffset_out_0;
  soffset_out_0 = *valp;
  soffset_in_0 = (soffset_out_0 - 0x4) & 0x3ffff;
  *valp = soffset_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm16x4_decode (uint32 *valp)
{
  unsigned uimm16x4_out_0;
  unsigned uimm16x4_in_0;
  uimm16x4_in_0 = *valp & 0xffff;
  uimm16x4_out_0 = (((0xffff) << 16) | uimm16x4_in_0) << 2;
  *valp = uimm16x4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm16x4_encode (uint32 *valp)
{
  unsigned uimm16x4_in_0;
  unsigned uimm16x4_out_0;
  uimm16x4_out_0 = *valp;
  uimm16x4_in_0 = (uimm16x4_out_0 >> 2) & 0xffff;
  *valp = uimm16x4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_imms_decode (uint32 *valp)
{
  unsigned imms_out_0;
  unsigned imms_in_0;
  imms_in_0 = *valp & 0xf;
  imms_out_0 = imms_in_0;
  *valp = imms_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_imms_encode (uint32 *valp)
{
  unsigned imms_in_0;
  unsigned imms_out_0;
  imms_out_0 = *valp;
  imms_in_0 = imms_out_0 & 0xf;
  *valp = imms_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_BR_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_BR_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 16);
  return error;
}

static int
OperandSem_opnd_sem_BR2_decode (uint32 *valp)
{
  *valp = *valp << 1;
  return 0;
}

static int
OperandSem_opnd_sem_BR2_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 16) || ((*valp & 1) != 0);
  *valp = *valp >> 1;
  return error;
}

static int
OperandSem_opnd_sem_BR4_decode (uint32 *valp)
{
  *valp = *valp << 2;
  return 0;
}

static int
OperandSem_opnd_sem_BR4_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 16) || ((*valp & 3) != 0);
  *valp = *valp >> 2;
  return error;
}

static int
OperandSem_opnd_sem_BR8_decode (uint32 *valp)
{
  *valp = *valp << 3;
  return 0;
}

static int
OperandSem_opnd_sem_BR8_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 16) || ((*valp & 7) != 0);
  *valp = *valp >> 3;
  return error;
}

static int
OperandSem_opnd_sem_BR16_decode (uint32 *valp)
{
  *valp = *valp << 4;
  return 0;
}

static int
OperandSem_opnd_sem_BR16_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 16) || ((*valp & 15) != 0);
  *valp = *valp >> 4;
  return error;
}

static int
OperandSem_opnd_sem_tp7_decode (uint32 *valp)
{
  unsigned tp7_out_0;
  unsigned tp7_in_0;
  tp7_in_0 = *valp & 0xf;
  tp7_out_0 = tp7_in_0 + 0x7;
  *valp = tp7_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_tp7_encode (uint32 *valp)
{
  unsigned tp7_in_0;
  unsigned tp7_out_0;
  tp7_out_0 = *valp;
  tp7_in_0 = (tp7_out_0 - 0x7) & 0xf;
  *valp = tp7_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_xt_wbr15_label_decode (uint32 *valp)
{
  unsigned xt_wbr15_label_out_0;
  unsigned xt_wbr15_label_in_0;
  xt_wbr15_label_in_0 = *valp & 0x7fff;
  xt_wbr15_label_out_0 = 0x4 + (((int) xt_wbr15_label_in_0 << 17) >> 17);
  *valp = xt_wbr15_label_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_xt_wbr15_label_encode (uint32 *valp)
{
  unsigned xt_wbr15_label_in_0;
  unsigned xt_wbr15_label_out_0;
  xt_wbr15_label_out_0 = *valp;
  xt_wbr15_label_in_0 = (xt_wbr15_label_out_0 - 0x4) & 0x7fff;
  *valp = xt_wbr15_label_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_uimm2x2_decode (uint32 *valp)
{
  unsigned ae_uimm2x2_out_0;
  unsigned ae_uimm2x2_in_0;
  ae_uimm2x2_in_0 = *valp & 0x1;
  ae_uimm2x2_out_0 = (0 << 2) | (ae_uimm2x2_in_0 << 1) | 0;
  *valp = ae_uimm2x2_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_uimm2x2_encode (uint32 *valp)
{
  unsigned ae_uimm2x2_in_0;
  unsigned ae_uimm2x2_out_0;
  ae_uimm2x2_out_0 = *valp;
  ae_uimm2x2_in_0 = (((ae_uimm2x2_out_0 >> 1) & 1)) & 0x1;
  *valp = ae_uimm2x2_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_AE_DR_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AE_DR_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i64_out_0;
  unsigned opnd_ae_sem_loads_stores_i64_in_0;
  opnd_ae_sem_loads_stores_i64_in_0 = *valp & 0xf;
  opnd_ae_sem_loads_stores_i64_out_0 = (((int) opnd_ae_sem_loads_stores_i64_in_0 << 28) >> 28) << 3;
  *valp = opnd_ae_sem_loads_stores_i64_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i64_in_0;
  unsigned opnd_ae_sem_loads_stores_i64_out_0;
  opnd_ae_sem_loads_stores_i64_out_0 = *valp;
  opnd_ae_sem_loads_stores_i64_in_0 = ((opnd_ae_sem_loads_stores_i64_out_0 >> 3) & 0xf);
  *valp = opnd_ae_sem_loads_stores_i64_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_sb_loads_stores_iba_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_sb_loads_stores_iba_out_0;
  unsigned opnd_ae_sem_sb_loads_stores_iba_in_0;
  opnd_ae_sem_sb_loads_stores_iba_in_0 = *valp & 0xf;
  opnd_ae_sem_sb_loads_stores_iba_out_0 = CONST_TBL_ae_ohba_0[opnd_ae_sem_sb_loads_stores_iba_in_0 & 0xf];
  *valp = opnd_ae_sem_sb_loads_stores_iba_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_sb_loads_stores_iba_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_sb_loads_stores_iba_in_0;
  unsigned opnd_ae_sem_sb_loads_stores_iba_out_0;
  opnd_ae_sem_sb_loads_stores_iba_out_0 = *valp;
  switch (opnd_ae_sem_sb_loads_stores_iba_out_0)
    {
    case 0x1: opnd_ae_sem_sb_loads_stores_iba_in_0 = 0; break;
    case 0x2: opnd_ae_sem_sb_loads_stores_iba_in_0 = 0x1; break;
    case 0x3: opnd_ae_sem_sb_loads_stores_iba_in_0 = 0x2; break;
    case 0x4: opnd_ae_sem_sb_loads_stores_iba_in_0 = 0x3; break;
    case 0x5: opnd_ae_sem_sb_loads_stores_iba_in_0 = 0x4; break;
    case 0x6: opnd_ae_sem_sb_loads_stores_iba_in_0 = 0x5; break;
    case 0x7: opnd_ae_sem_sb_loads_stores_iba_in_0 = 0x6; break;
    case 0x8: opnd_ae_sem_sb_loads_stores_iba_in_0 = 0x7; break;
    case 0x9: opnd_ae_sem_sb_loads_stores_iba_in_0 = 0x8; break;
    case 0xa: opnd_ae_sem_sb_loads_stores_iba_in_0 = 0x9; break;
    case 0xb: opnd_ae_sem_sb_loads_stores_iba_in_0 = 0xa; break;
    case 0xc: opnd_ae_sem_sb_loads_stores_iba_in_0 = 0xb; break;
    case 0xd: opnd_ae_sem_sb_loads_stores_iba_in_0 = 0xc; break;
    case 0xe: opnd_ae_sem_sb_loads_stores_iba_in_0 = 0xd; break;
    case 0xf: opnd_ae_sem_sb_loads_stores_iba_in_0 = 0xe; break;
    default: opnd_ae_sem_sb_loads_stores_iba_in_0 = 0xf; break;
    }
  *valp = opnd_ae_sem_sb_loads_stores_iba_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_imm2_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_imm2_out_0;
  unsigned opnd_ae_sem_loads_stores_imm2_in_0;
  opnd_ae_sem_loads_stores_imm2_in_0 = *valp & 0x3;
  opnd_ae_sem_loads_stores_imm2_out_0 = (0 << 2) | opnd_ae_sem_loads_stores_imm2_in_0;
  *valp = opnd_ae_sem_loads_stores_imm2_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_imm2_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_imm2_in_0;
  unsigned opnd_ae_sem_loads_stores_imm2_out_0;
  opnd_ae_sem_loads_stores_imm2_out_0 = *valp;
  opnd_ae_sem_loads_stores_imm2_in_0 = (opnd_ae_sem_loads_stores_imm2_out_0 & 0x3);
  *valp = opnd_ae_sem_loads_stores_imm2_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_dr_to_dr_movi_imm_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_dr_to_dr_movi_imm_out_0;
  unsigned opnd_ae_sem_dr_to_dr_movi_imm_in_0;
  opnd_ae_sem_dr_to_dr_movi_imm_in_0 = *valp & 0x3f;
  opnd_ae_sem_dr_to_dr_movi_imm_out_0 = (((-(( ( ((((opnd_ae_sem_dr_to_dr_movi_imm_in_0 >> 4) & 0x3)) | 0xfffffffc)) == 0xffffffff))) & 0x3ffffff) << 6) | opnd_ae_sem_dr_to_dr_movi_imm_in_0;
  *valp = opnd_ae_sem_dr_to_dr_movi_imm_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_dr_to_dr_movi_imm_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_dr_to_dr_movi_imm_in_0;
  unsigned opnd_ae_sem_dr_to_dr_movi_imm_out_0;
  opnd_ae_sem_dr_to_dr_movi_imm_out_0 = *valp;
  opnd_ae_sem_dr_to_dr_movi_imm_in_0 = (opnd_ae_sem_dr_to_dr_movi_imm_out_0 & 0x3f);
  *valp = opnd_ae_sem_dr_to_dr_movi_imm_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_spfma_i_imm3_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_spfma_i_imm3_out_0;
  unsigned opnd_ae_sem_spfma_i_imm3_in_0;
  opnd_ae_sem_spfma_i_imm3_in_0 = *valp & 0x7;
  opnd_ae_sem_spfma_i_imm3_out_0 = (0 << 3) | opnd_ae_sem_spfma_i_imm3_in_0;
  *valp = opnd_ae_sem_spfma_i_imm3_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_spfma_i_imm3_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_spfma_i_imm3_in_0;
  unsigned opnd_ae_sem_spfma_i_imm3_out_0;
  opnd_ae_sem_spfma_i_imm3_out_0 = *valp;
  opnd_ae_sem_spfma_i_imm3_in_0 = (opnd_ae_sem_spfma_i_imm3_out_0 & 0x7);
  *valp = opnd_ae_sem_spfma_i_imm3_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_AE_VALIGN_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AE_VALIGN_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i32_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i32_out_0;
  unsigned opnd_ae_sem_loads_stores_i32_in_0;
  opnd_ae_sem_loads_stores_i32_in_0 = *valp & 0xf;
  opnd_ae_sem_loads_stores_i32_out_0 = (((int) opnd_ae_sem_loads_stores_i32_in_0 << 28) >> 28) << 2;
  *valp = opnd_ae_sem_loads_stores_i32_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i32_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i32_in_0;
  unsigned opnd_ae_sem_loads_stores_i32_out_0;
  opnd_ae_sem_loads_stores_i32_out_0 = *valp;
  opnd_ae_sem_loads_stores_i32_in_0 = ((opnd_ae_sem_loads_stores_i32_out_0 >> 2) & 0xf);
  *valp = opnd_ae_sem_loads_stores_i32_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i16_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i16_out_0;
  unsigned opnd_ae_sem_loads_stores_i16_in_0;
  opnd_ae_sem_loads_stores_i16_in_0 = *valp & 0xf;
  opnd_ae_sem_loads_stores_i16_out_0 = (((int) opnd_ae_sem_loads_stores_i16_in_0 << 28) >> 28) << 1;
  *valp = opnd_ae_sem_loads_stores_i16_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i16_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i16_in_0;
  unsigned opnd_ae_sem_loads_stores_i16_out_0;
  opnd_ae_sem_loads_stores_i16_out_0 = *valp;
  opnd_ae_sem_loads_stores_i16_in_0 = ((opnd_ae_sem_loads_stores_i16_out_0 >> 1) & 0xf);
  *valp = opnd_ae_sem_loads_stores_i16_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i8_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i8_out_0;
  unsigned opnd_ae_sem_loads_stores_i8_in_0;
  opnd_ae_sem_loads_stores_i8_in_0 = *valp & 0xf;
  opnd_ae_sem_loads_stores_i8_out_0 = ((int) opnd_ae_sem_loads_stores_i8_in_0 << 28) >> 28;
  *valp = opnd_ae_sem_loads_stores_i8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i8_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i8_in_0;
  unsigned opnd_ae_sem_loads_stores_i8_out_0;
  opnd_ae_sem_loads_stores_i8_out_0 = *valp;
  opnd_ae_sem_loads_stores_i8_in_0 = (opnd_ae_sem_loads_stores_i8_out_0 & 0xf);
  *valp = opnd_ae_sem_loads_stores_i8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64pos_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i64pos_out_0;
  unsigned opnd_ae_sem_loads_stores_i64pos_in_0;
  opnd_ae_sem_loads_stores_i64pos_in_0 = *valp & 0x7;
  opnd_ae_sem_loads_stores_i64pos_out_0 = ((0 << 3) | opnd_ae_sem_loads_stores_i64pos_in_0) << 3;
  *valp = opnd_ae_sem_loads_stores_i64pos_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64pos_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i64pos_in_0;
  unsigned opnd_ae_sem_loads_stores_i64pos_out_0;
  opnd_ae_sem_loads_stores_i64pos_out_0 = *valp;
  opnd_ae_sem_loads_stores_i64pos_in_0 = ((opnd_ae_sem_loads_stores_i64pos_out_0 >> 3) & 0x7);
  *valp = opnd_ae_sem_loads_stores_i64pos_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64neg_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i64neg_out_0;
  unsigned opnd_ae_sem_loads_stores_i64neg_in_0;
  opnd_ae_sem_loads_stores_i64neg_in_0 = *valp & 0x3;
  opnd_ae_sem_loads_stores_i64neg_out_0 = CONST_TBL_ae_immls64neg_0[opnd_ae_sem_loads_stores_i64neg_in_0 & 0x3];
  *valp = opnd_ae_sem_loads_stores_i64neg_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64neg_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i64neg_in_0;
  unsigned opnd_ae_sem_loads_stores_i64neg_out_0;
  opnd_ae_sem_loads_stores_i64neg_out_0 = *valp;
  opnd_ae_sem_loads_stores_i64neg_in_0 = (((opnd_ae_sem_loads_stores_i64neg_out_0 == (CONST_TBL_ae_immls64neg_0[0]))) ? 0 : (((opnd_ae_sem_loads_stores_i64neg_out_0 == (CONST_TBL_ae_immls64neg_0[1]))) ? 0x1 : (((opnd_ae_sem_loads_stores_i64neg_out_0 == (CONST_TBL_ae_immls64neg_0[2]))) ? 0x2 : 0x3))) & 0x3;
  *valp = opnd_ae_sem_loads_stores_i64neg_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64half_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i64half_out_0;
  unsigned opnd_ae_sem_loads_stores_i64half_in_0;
  opnd_ae_sem_loads_stores_i64half_in_0 = *valp & 0x7;
  opnd_ae_sem_loads_stores_i64half_out_0 = (((int) opnd_ae_sem_loads_stores_i64half_in_0 << 29) >> 29) << 3;
  *valp = opnd_ae_sem_loads_stores_i64half_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64half_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i64half_in_0;
  unsigned opnd_ae_sem_loads_stores_i64half_out_0;
  opnd_ae_sem_loads_stores_i64half_out_0 = *valp;
  opnd_ae_sem_loads_stores_i64half_in_0 = ((opnd_ae_sem_loads_stores_i64half_out_0 >> 3) & 0x7);
  *valp = opnd_ae_sem_loads_stores_i64half_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_sp32cvt_i_imm5_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_sp32cvt_i_imm5_out_0;
  unsigned opnd_ae_sem_sp32cvt_i_imm5_in_0;
  opnd_ae_sem_sp32cvt_i_imm5_in_0 = *valp & 0x1f;
  opnd_ae_sem_sp32cvt_i_imm5_out_0 = (0 << 5) | opnd_ae_sem_sp32cvt_i_imm5_in_0;
  *valp = opnd_ae_sem_sp32cvt_i_imm5_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_sp32cvt_i_imm5_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_sp32cvt_i_imm5_in_0;
  unsigned opnd_ae_sem_sp32cvt_i_imm5_out_0;
  opnd_ae_sem_sp32cvt_i_imm5_out_0 = *valp;
  opnd_ae_sem_sp32cvt_i_imm5_in_0 = (opnd_ae_sem_sp32cvt_i_imm5_out_0 & 0x1f);
  *valp = opnd_ae_sem_sp32cvt_i_imm5_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_hpcnv_i_imm4_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_hpcnv_i_imm4_out_0;
  unsigned opnd_ae_sem_hpcnv_i_imm4_in_0;
  opnd_ae_sem_hpcnv_i_imm4_in_0 = *valp & 0xf;
  opnd_ae_sem_hpcnv_i_imm4_out_0 = (0 << 4) | opnd_ae_sem_hpcnv_i_imm4_in_0;
  *valp = opnd_ae_sem_hpcnv_i_imm4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_hpcnv_i_imm4_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_hpcnv_i_imm4_in_0;
  unsigned opnd_ae_sem_hpcnv_i_imm4_out_0;
  opnd_ae_sem_hpcnv_i_imm4_out_0 = *valp;
  opnd_ae_sem_hpcnv_i_imm4_in_0 = (opnd_ae_sem_hpcnv_i_imm4_out_0 & 0xf);
  *valp = opnd_ae_sem_hpcnv_i_imm4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_shift_i64_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_shift_i64_out_0;
  unsigned opnd_ae_sem_shift_i64_in_0;
  opnd_ae_sem_shift_i64_in_0 = *valp & 0x3f;
  opnd_ae_sem_shift_i64_out_0 = (0 << 6) | opnd_ae_sem_shift_i64_in_0;
  *valp = opnd_ae_sem_shift_i64_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_shift_i64_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_shift_i64_in_0;
  unsigned opnd_ae_sem_shift_i64_out_0;
  opnd_ae_sem_shift_i64_out_0 = *valp;
  opnd_ae_sem_shift_i64_in_0 = (opnd_ae_sem_shift_i64_out_0 & 0x3f);
  *valp = opnd_ae_sem_shift_i64_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i128_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i128_out_0;
  unsigned opnd_ae_sem_loads_stores_i128_in_0;
  opnd_ae_sem_loads_stores_i128_in_0 = *valp & 0xf;
  opnd_ae_sem_loads_stores_i128_out_0 = (((int) opnd_ae_sem_loads_stores_i128_in_0 << 28) >> 28) << 4;
  *valp = opnd_ae_sem_loads_stores_i128_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i128_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i128_in_0;
  unsigned opnd_ae_sem_loads_stores_i128_out_0;
  opnd_ae_sem_loads_stores_i128_out_0 = *valp;
  opnd_ae_sem_loads_stores_i128_in_0 = ((opnd_ae_sem_loads_stores_i128_out_0 >> 4) & 0xf);
  *valp = opnd_ae_sem_loads_stores_i128_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_AE_EP_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AE_EP_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_shift_i8_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_shift_i8_out_0;
  unsigned opnd_ae_sem_shift_i8_in_0;
  opnd_ae_sem_shift_i8_in_0 = *valp & 0x7;
  opnd_ae_sem_shift_i8_out_0 = CONST_TBL_ae_slai72table_0[opnd_ae_sem_shift_i8_in_0 & 0x7];
  *valp = opnd_ae_sem_shift_i8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_shift_i8_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_shift_i8_in_0;
  unsigned opnd_ae_sem_shift_i8_out_0;
  opnd_ae_sem_shift_i8_out_0 = *valp;
  switch (opnd_ae_sem_shift_i8_out_0)
    {
    case 0x1: opnd_ae_sem_shift_i8_in_0 = 0; break;
    case 0x2: opnd_ae_sem_shift_i8_in_0 = 0x1; break;
    case 0x3: opnd_ae_sem_shift_i8_in_0 = 0x2; break;
    case 0x4: opnd_ae_sem_shift_i8_in_0 = 0x3; break;
    case 0x5: opnd_ae_sem_shift_i8_in_0 = 0x4; break;
    case 0x6: opnd_ae_sem_shift_i8_in_0 = 0x5; break;
    case 0x7: opnd_ae_sem_shift_i8_in_0 = 0x6; break;
    default: opnd_ae_sem_shift_i8_in_0 = 0x7; break;
    }
  *valp = opnd_ae_sem_shift_i8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_dr_to_dr_imm_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_dr_to_dr_imm_out_0;
  unsigned opnd_ae_sem_dr_to_dr_imm_in_0;
  opnd_ae_sem_dr_to_dr_imm_in_0 = *valp & 0xf;
  opnd_ae_sem_dr_to_dr_imm_out_0 = CONST_TBL_ae_opnd_tp7_0[opnd_ae_sem_dr_to_dr_imm_in_0 & 0xf];
  *valp = opnd_ae_sem_dr_to_dr_imm_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_dr_to_dr_imm_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_dr_to_dr_imm_in_0;
  unsigned opnd_ae_sem_dr_to_dr_imm_out_0;
  opnd_ae_sem_dr_to_dr_imm_out_0 = *valp;
  switch (opnd_ae_sem_dr_to_dr_imm_out_0)
    {
    case 0x7: opnd_ae_sem_dr_to_dr_imm_in_0 = 0; break;
    case 0x8: opnd_ae_sem_dr_to_dr_imm_in_0 = 0x1; break;
    case 0x9: opnd_ae_sem_dr_to_dr_imm_in_0 = 0x2; break;
    case 0xa: opnd_ae_sem_dr_to_dr_imm_in_0 = 0x3; break;
    case 0xb: opnd_ae_sem_dr_to_dr_imm_in_0 = 0x4; break;
    case 0xc: opnd_ae_sem_dr_to_dr_imm_in_0 = 0x5; break;
    case 0xd: opnd_ae_sem_dr_to_dr_imm_in_0 = 0x6; break;
    case 0xe: opnd_ae_sem_dr_to_dr_imm_in_0 = 0x7; break;
    case 0xf: opnd_ae_sem_dr_to_dr_imm_in_0 = 0x8; break;
    case 0x10: opnd_ae_sem_dr_to_dr_imm_in_0 = 0x9; break;
    case 0x11: opnd_ae_sem_dr_to_dr_imm_in_0 = 0xa; break;
    case 0x12: opnd_ae_sem_dr_to_dr_imm_in_0 = 0xb; break;
    case 0x13: opnd_ae_sem_dr_to_dr_imm_in_0 = 0xc; break;
    case 0x14: opnd_ae_sem_dr_to_dr_imm_in_0 = 0xd; break;
    case 0x15: opnd_ae_sem_dr_to_dr_imm_in_0 = 0xe; break;
    default: opnd_ae_sem_dr_to_dr_imm_in_0 = 0xf; break;
    }
  *valp = opnd_ae_sem_dr_to_dr_imm_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_sb_loads_stores_iba2_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_sb_loads_stores_iba2_out_0;
  unsigned opnd_ae_sem_sb_loads_stores_iba2_in_0;
  opnd_ae_sem_sb_loads_stores_iba2_in_0 = *valp & 0xf;
  opnd_ae_sem_sb_loads_stores_iba2_out_0 = CONST_TBL_ae_ohba2_0[opnd_ae_sem_sb_loads_stores_iba2_in_0 & 0xf];
  *valp = opnd_ae_sem_sb_loads_stores_iba2_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_sb_loads_stores_iba2_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_sb_loads_stores_iba2_in_0;
  unsigned opnd_ae_sem_sb_loads_stores_iba2_out_0;
  opnd_ae_sem_sb_loads_stores_iba2_out_0 = *valp;
  switch (opnd_ae_sem_sb_loads_stores_iba2_out_0)
    {
    case 0x1: opnd_ae_sem_sb_loads_stores_iba2_in_0 = 0; break;
    case 0x2: opnd_ae_sem_sb_loads_stores_iba2_in_0 = 0x1; break;
    case 0x3: opnd_ae_sem_sb_loads_stores_iba2_in_0 = 0x2; break;
    case 0x4: opnd_ae_sem_sb_loads_stores_iba2_in_0 = 0x3; break;
    case 0x5: opnd_ae_sem_sb_loads_stores_iba2_in_0 = 0x4; break;
    case 0x6: opnd_ae_sem_sb_loads_stores_iba2_in_0 = 0x5; break;
    case 0x7: opnd_ae_sem_sb_loads_stores_iba2_in_0 = 0x6; break;
    case 0x8: opnd_ae_sem_sb_loads_stores_iba2_in_0 = 0x7; break;
    case 0x9: opnd_ae_sem_sb_loads_stores_iba2_in_0 = 0x8; break;
    case 0xa: opnd_ae_sem_sb_loads_stores_iba2_in_0 = 0x9; break;
    case 0xb: opnd_ae_sem_sb_loads_stores_iba2_in_0 = 0xa; break;
    case 0xc: opnd_ae_sem_sb_loads_stores_iba2_in_0 = 0xb; break;
    case 0xd: opnd_ae_sem_sb_loads_stores_iba2_in_0 = 0xc; break;
    case 0xe: opnd_ae_sem_sb_loads_stores_iba2_in_0 = 0xd; break;
    case 0xf: opnd_ae_sem_sb_loads_stores_iba2_in_0 = 0xe; break;
    default: opnd_ae_sem_sb_loads_stores_iba2_in_0 = 0xf; break;
    }
  *valp = opnd_ae_sem_sb_loads_stores_iba2_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_spfma_i_imm1_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_spfma_i_imm1_out_0;
  unsigned opnd_ae_sem_spfma_i_imm1_in_0;
  opnd_ae_sem_spfma_i_imm1_in_0 = *valp & 0x1;
  opnd_ae_sem_spfma_i_imm1_out_0 = (0 << 1) | opnd_ae_sem_spfma_i_imm1_in_0;
  *valp = opnd_ae_sem_spfma_i_imm1_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_spfma_i_imm1_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_spfma_i_imm1_in_0;
  unsigned opnd_ae_sem_spfma_i_imm1_out_0;
  opnd_ae_sem_spfma_i_imm1_out_0 = *valp;
  opnd_ae_sem_spfma_i_imm1_in_0 = (((opnd_ae_sem_spfma_i_imm1_out_0 >> 0) & 1)) & 0x1;
  *valp = opnd_ae_sem_spfma_i_imm1_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_bbi_decode (uint32 *valp)
{
  unsigned bbi_out_0;
  unsigned bbi_in_0;
  bbi_in_0 = *valp & 0x1f;
  bbi_out_0 = (0 << 5) | bbi_in_0;
  *valp = bbi_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_bbi_encode (uint32 *valp)
{
  unsigned bbi_in_0;
  unsigned bbi_out_0;
  bbi_out_0 = *valp;
  bbi_in_0 = (bbi_out_0 & 0x1f);
  *valp = bbi_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_s_decode (uint32 *valp)
{
  unsigned s_out_0;
  unsigned s_in_0;
  s_in_0 = *valp & 0xf;
  s_out_0 = (0 << 4) | s_in_0;
  *valp = s_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_s_encode (uint32 *valp)
{
  unsigned s_in_0;
  unsigned s_out_0;
  s_out_0 = *valp;
  s_in_0 = (s_out_0 & 0xf);
  *valp = s_in_0;
  return 0;
}

static int
Operand_soffsetx4_ator (uint32 *valp, uint32 pc)
{
  *valp -= (pc & ~0x3);
  return 0;
}

static int
Operand_soffsetx4_rtoa (uint32 *valp, uint32 pc)
{
  *valp += (pc & ~0x3);
  return 0;
}

static int
Operand_uimm6_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_uimm6_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_label8_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_label8_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_ulabel8_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_ulabel8_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_label12_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_label12_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_soffset_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_soffset_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_uimm16x4_ator (uint32 *valp, uint32 pc)
{
  *valp -= ((pc + 3) & ~0x3);
  return 0;
}

static int
Operand_uimm16x4_rtoa (uint32 *valp, uint32 pc)
{
  *valp += ((pc + 3) & ~0x3);
  return 0;
}

static int
Operand_xt_wbr15_label_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_xt_wbr15_label_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static xtensa_operand_internal operands[] = {
  { "soffsetx4", FIELD_offset, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_soffsetx4_encode, OperandSem_opnd_sem_soffsetx4_decode,
    Operand_soffsetx4_ator, Operand_soffsetx4_rtoa },
  { "immr", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_immr_encode, OperandSem_opnd_sem_immr_decode,
    0, 0 },
  { "uimm12x8", FIELD_imm12, -1, 0,
    0,
    OperandSem_opnd_sem_uimm12x8_encode, OperandSem_opnd_sem_uimm12x8_decode,
    0, 0 },
  { "simm4", FIELD_mn, -1, 0,
    0,
    OperandSem_opnd_sem_simm4_encode, OperandSem_opnd_sem_simm4_decode,
    0, 0 },
  { "arr", FIELD_r, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "ars", FIELD_s, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "*ars_invisible", FIELD_s, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "art", FIELD_t, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "ar0", FIELD__ar0, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_0_encode, OperandSem_opnd_sem_AR_0_decode,
    0, 0 },
  { "ar4", FIELD__ar4, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_4_encode, OperandSem_opnd_sem_AR_4_decode,
    0, 0 },
  { "ar8", FIELD__ar8, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_8_encode, OperandSem_opnd_sem_AR_8_decode,
    0, 0 },
  { "ar12", FIELD__ar12, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_12_encode, OperandSem_opnd_sem_AR_12_decode,
    0, 0 },
  { "ars_entry", FIELD_s, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_entry_encode, OperandSem_opnd_sem_AR_entry_decode,
    0, 0 },
  { "immrx4", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_immrx4_encode, OperandSem_opnd_sem_immrx4_decode,
    0, 0 },
  { "lsi4x4", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_lsi4x4_encode, OperandSem_opnd_sem_lsi4x4_decode,
    0, 0 },
  { "simm7", FIELD_imm7, -1, 0,
    0,
    OperandSem_opnd_sem_simm7_encode, OperandSem_opnd_sem_simm7_decode,
    0, 0 },
  { "uimm6", FIELD_imm6, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_uimm6_encode, OperandSem_opnd_sem_uimm6_decode,
    Operand_uimm6_ator, Operand_uimm6_rtoa },
  { "ai4const", FIELD_t, -1, 0,
    0,
    OperandSem_opnd_sem_ai4const_encode, OperandSem_opnd_sem_ai4const_decode,
    0, 0 },
  { "b4const", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_b4const_encode, OperandSem_opnd_sem_b4const_decode,
    0, 0 },
  { "b4constu", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_b4constu_encode, OperandSem_opnd_sem_b4constu_decode,
    0, 0 },
  { "immt", FIELD_t, -1, 0,
    0,
    OperandSem_opnd_sem_immt_encode, OperandSem_opnd_sem_immt_decode,
    0, 0 },
  { "uimms8", FIELD_imms8, -1, 0,
    0,
    OperandSem_opnd_sem_uimms8_encode, OperandSem_opnd_sem_uimms8_decode,
    0, 0 },
  { "uimm8", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_uimm8_encode, OperandSem_opnd_sem_uimm8_decode,
    0, 0 },
  { "uimm8x2", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_uimm8x2_encode, OperandSem_opnd_sem_uimm8x2_decode,
    0, 0 },
  { "uimm8x4", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_uimm8x4_encode, OperandSem_opnd_sem_uimm8x4_decode,
    0, 0 },
  { "uimm4x16", FIELD_op2, -1, 0,
    0,
    OperandSem_opnd_sem_uimm4x16_encode, OperandSem_opnd_sem_uimm4x16_decode,
    0, 0 },
  { "uimmrx4", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_uimmrx4_encode, OperandSem_opnd_sem_uimmrx4_decode,
    0, 0 },
  { "simm8", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_simm8_encode, OperandSem_opnd_sem_simm8_decode,
    0, 0 },
  { "simm8x256", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_simm8x256_encode, OperandSem_opnd_sem_simm8x256_decode,
    0, 0 },
  { "simm12b", FIELD_imm12b, -1, 0,
    0,
    OperandSem_opnd_sem_simm12b_encode, OperandSem_opnd_sem_simm12b_decode,
    0, 0 },
  { "msalp32", FIELD_sal, -1, 0,
    0,
    OperandSem_opnd_sem_msalp32_encode, OperandSem_opnd_sem_msalp32_decode,
    0, 0 },
  { "op2p1", FIELD_op2, -1, 0,
    0,
    OperandSem_opnd_sem_op2p1_encode, OperandSem_opnd_sem_op2p1_decode,
    0, 0 },
  { "label8", FIELD_imm8, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_label8_encode, OperandSem_opnd_sem_label8_decode,
    Operand_label8_ator, Operand_label8_rtoa },
  { "ulabel8", FIELD_imm8, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_ulabel8_encode, OperandSem_opnd_sem_ulabel8_decode,
    Operand_ulabel8_ator, Operand_ulabel8_rtoa },
  { "label12", FIELD_imm12, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_label12_encode, OperandSem_opnd_sem_label12_decode,
    Operand_label12_ator, Operand_label12_rtoa },
  { "soffset", FIELD_offset, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_soffset_encode, OperandSem_opnd_sem_soffset_decode,
    Operand_soffset_ator, Operand_soffset_rtoa },
  { "uimm16x4", FIELD_imm16, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_uimm16x4_encode, OperandSem_opnd_sem_uimm16x4_decode,
    Operand_uimm16x4_ator, Operand_uimm16x4_rtoa },
  { "imms", FIELD_s, -1, 0,
    0,
    OperandSem_opnd_sem_imms_encode, OperandSem_opnd_sem_imms_decode,
    0, 0 },
  { "imms1", FIELD_s, -1, 0,
    0,
    OperandSem_opnd_sem_imms_encode, OperandSem_opnd_sem_imms_decode,
    0, 0 },
  { "bt", FIELD_t, REGFILE_BR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR_encode, OperandSem_opnd_sem_BR_decode,
    0, 0 },
  { "bs", FIELD_s, REGFILE_BR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR_encode, OperandSem_opnd_sem_BR_decode,
    0, 0 },
  { "br", FIELD_r, REGFILE_BR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR_encode, OperandSem_opnd_sem_BR_decode,
    0, 0 },
  { "bt2", FIELD_t2, REGFILE_BR, 2,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR2_encode, OperandSem_opnd_sem_BR2_decode,
    0, 0 },
  { "bs2", FIELD_s2, REGFILE_BR, 2,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR2_encode, OperandSem_opnd_sem_BR2_decode,
    0, 0 },
  { "br2", FIELD_r2, REGFILE_BR, 2,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR2_encode, OperandSem_opnd_sem_BR2_decode,
    0, 0 },
  { "bt4", FIELD_t4, REGFILE_BR, 4,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR4_encode, OperandSem_opnd_sem_BR4_decode,
    0, 0 },
  { "bs4", FIELD_s4, REGFILE_BR, 4,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR4_encode, OperandSem_opnd_sem_BR4_decode,
    0, 0 },
  { "br4", FIELD_r4, REGFILE_BR, 4,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR4_encode, OperandSem_opnd_sem_BR4_decode,
    0, 0 },
  { "bt8", FIELD_t8, REGFILE_BR, 8,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR8_encode, OperandSem_opnd_sem_BR8_decode,
    0, 0 },
  { "bs8", FIELD_s8, REGFILE_BR, 8,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR8_encode, OperandSem_opnd_sem_BR8_decode,
    0, 0 },
  { "br8", FIELD_r8, REGFILE_BR, 8,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR8_encode, OperandSem_opnd_sem_BR8_decode,
    0, 0 },
  { "bt16", FIELD__bt16, REGFILE_BR, 16,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR16_encode, OperandSem_opnd_sem_BR16_decode,
    0, 0 },
  { "bs16", FIELD__bs16, REGFILE_BR, 16,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR16_encode, OperandSem_opnd_sem_BR16_decode,
    0, 0 },
  { "br16", FIELD__br16, REGFILE_BR, 16,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR16_encode, OperandSem_opnd_sem_BR16_decode,
    0, 0 },
  { "brall", FIELD__brall, REGFILE_BR, 16,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_BR16_encode, OperandSem_opnd_sem_BR16_decode,
    0, 0 },
  { "tp7", FIELD_t, -1, 0,
    0,
    OperandSem_opnd_sem_tp7_encode, OperandSem_opnd_sem_tp7_decode,
    0, 0 },
  { "xt_wbr15_label", FIELD_xt_wbr15_imm, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_xt_wbr15_label_encode, OperandSem_opnd_sem_xt_wbr15_label_decode,
    Operand_xt_wbr15_label_ator, Operand_xt_wbr15_label_rtoa },
  { "ae_uimm2x2", FIELD_ae_fld_Inst16b_12, -1, 0,
    0,
    OperandSem_opnd_sem_ae_uimm2x2_encode, OperandSem_opnd_sem_ae_uimm2x2_decode,
    0, 0 },
  { "opnd_ae_sem_mul_nn_c0", FIELD_fld_ae_sem_mul_nn_c0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_mul_nn_c1", FIELD_fld_ae_sem_mul_nn_c1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_mul_nn_c2", FIELD_fld_ae_sem_mul_nn_c2, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_mul_nn_c3", FIELD_fld_ae_sem_mul_nn_c3, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_mul_nn_q0", FIELD_fld_ae_sem_mul_nn_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_mul_nn_q1", FIELD_fld_ae_sem_mul_nn_q1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_mul_nn_v0", FIELD_fld_ae_sem_mul_nn_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_mul_nn_v1", FIELD_fld_ae_sem_mul_nn_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_mul_nn_q2", FIELD_fld_ae_sem_mul_nn_q2, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_mul_nn_q3", FIELD_fld_ae_sem_mul_nn_q3, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_mul_nn_v2", FIELD_fld_ae_sem_mul_nn_v2, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_mul_nn_v3", FIELD_fld_ae_sem_mul_nn_v3, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_dr_v", FIELD_fld_ae_sem_dr_to_dr_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_arithmetic_v", FIELD_fld_ae_sem_arithmetic_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_arithmetic_v0", FIELD_fld_ae_sem_arithmetic_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_arithmetic_v1", FIELD_fld_ae_sem_arithmetic_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_a", FIELD_fld_ae_sem_loads_stores_a, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_x", FIELD_fld_ae_sem_loads_stores_x, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_end", FIELD_fld_ae_sem_loads_stores_end, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_i64", FIELD_fld_ae_sem_loads_stores_i64, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64_decode,
    0, 0 },
  { "opnd_ae_sem_lb_ops_iba", FIELD_fld_ae_sem_lb_ops_iba, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_sb_loads_stores_iba_encode, OperandSem_opnd_sem_opnd_ae_sem_sb_loads_stores_iba_decode,
    0, 0 },
  { "opnd_ae_sem_sb_loads_stores_iba", FIELD_fld_ae_sem_sb_loads_stores_iba, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_sb_loads_stores_iba_encode, OperandSem_opnd_sem_opnd_ae_sem_sb_loads_stores_iba_decode,
    0, 0 },
  { "opnd_ae_sem_pks_d", FIELD_fld_ae_sem_pks_d, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_pks_pos", FIELD_fld_ae_sem_pks_pos, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_imm2_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_imm2_decode,
    0, 0 },
  { "opnd_ae_sem_pks_s", FIELD_fld_ae_sem_pks_s, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_ar_a", FIELD_fld_ae_sem_dr_to_ar_a, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_ar_v0", FIELD_fld_ae_sem_dr_to_ar_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_dr_v0", FIELD_fld_ae_sem_dr_to_dr_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_ar_ab", FIELD_fld_ae_sem_dr_to_ar_ab, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_ar_ai", FIELD_fld_ae_sem_dr_to_ar_ai, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_ar_aoe", FIELD_fld_ae_sem_dr_to_ar_aoe, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_dr_movi_imm", FIELD_fld_ae_sem_dr_to_dr_movi_imm, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_dr_to_dr_movi_imm_encode, OperandSem_opnd_sem_opnd_ae_sem_dr_to_dr_movi_imm_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_dr_ds", FIELD_fld_ae_sem_dr_to_dr_ds, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_dr_v1", FIELD_fld_ae_sem_dr_to_dr_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_ar_imm8", FIELD_fld_ae_sem_dr_to_ar_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_spfma_i_imm3_encode, OperandSem_opnd_sem_opnd_ae_sem_spfma_i_imm3_decode,
    0, 0 },
  { "opnd_ae_sem_shift_a0", FIELD_fld_ae_sem_shift_a0, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_shift_d", FIELD_fld_ae_sem_shift_d, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_shift_d0", FIELD_fld_ae_sem_shift_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_ar_d", FIELD_fld_ae_sem_dr_to_ar_d, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_ar_d0", FIELD_fld_ae_sem_dr_to_ar_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_ar_d1", FIELD_fld_ae_sem_dr_to_ar_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_dr_imm2", FIELD_fld_ae_sem_dr_to_dr_imm2, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_imm2_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_imm2_decode,
    0, 0 },
  { "opnd_ae_sem_arithmetic_ds", FIELD_fld_ae_sem_arithmetic_ds, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_uu", FIELD_fld_ae_sem_loads_stores_uu, REGFILE_AE_VALIGN, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_VALIGN_encode, OperandSem_opnd_sem_AE_VALIGN_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_vu", FIELD_fld_ae_sem_loads_stores_vu, REGFILE_AE_VALIGN, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_VALIGN_encode, OperandSem_opnd_sem_AE_VALIGN_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_i32", FIELD_fld_ae_sem_loads_stores_i32, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i32_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i32_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_v", FIELD_fld_ae_sem_loads_stores_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_i16", FIELD_fld_ae_sem_loads_stores_i16, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i16_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i16_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_i8", FIELD_fld_ae_sem_loads_stores_i8, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i8_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i8_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_i64pos", FIELD_fld_ae_sem_loads_stores_i64pos, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64pos_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64pos_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_i64neg", FIELD_fld_ae_sem_loads_stores_i64neg, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64neg_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64neg_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_i64half", FIELD_fld_ae_sem_loads_stores_i64half, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64half_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64half_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_su", FIELD_fld_ae_sem_loads_stores_su, REGFILE_AE_VALIGN, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_VALIGN_encode, OperandSem_opnd_sem_AE_VALIGN_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_v1", FIELD_fld_ae_sem_loads_stores_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_av", FIELD_fld_ae_sem_loads_stores_av, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_shift_sd", FIELD_fld_ae_sem_shift_sd, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_shift_i32", FIELD_fld_ae_sem_shift_i32, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_sp32cvt_i_imm5_encode, OperandSem_opnd_sem_opnd_ae_sem_sp32cvt_i_imm5_decode,
    0, 0 },
  { "opnd_ae_sem_shift_i16", FIELD_fld_ae_sem_shift_i16, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_hpcnv_i_imm4_encode, OperandSem_opnd_sem_opnd_ae_sem_hpcnv_i_imm4_decode,
    0, 0 },
  { "opnd_ae_sem_shift_i64", FIELD_fld_ae_sem_shift_i64, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_shift_i64_encode, OperandSem_opnd_sem_opnd_ae_sem_shift_i64_decode,
    0, 0 },
  { "opnd_ae_sem_shift_imm8", FIELD_fld_ae_sem_shift_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_spfma_i_imm3_encode, OperandSem_opnd_sem_opnd_ae_sem_spfma_i_imm3_decode,
    0, 0 },
  { "opnd_ae_sem_shift_d1", FIELD_fld_ae_sem_shift_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_shift_da", FIELD_fld_ae_sem_shift_da, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_shift_imm32", FIELD_fld_ae_sem_shift_imm32, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_sp32cvt_i_imm5_encode, OperandSem_opnd_sem_opnd_ae_sem_sp32cvt_i_imm5_decode,
    0, 0 },
  { "opnd_ae_sem_shift_a", FIELD_fld_ae_sem_shift_a, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_dr_immed", FIELD_fld_ae_sem_dr_to_dr_immed, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_hpcnv_i_imm4_encode, OperandSem_opnd_sem_opnd_ae_sem_hpcnv_i_imm4_decode,
    0, 0 },
  { "opnd_ae_sem_arithmetic_art", FIELD_fld_ae_sem_arithmetic_art, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_arithmetic_va", FIELD_fld_ae_sem_arithmetic_va, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_arithmetic_vs", FIELD_fld_ae_sem_arithmetic_vs, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_i128", FIELD_fld_ae_sem_loads_stores_i128, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i128_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i128_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_av1", FIELD_fld_ae_sem_loads_stores_av1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_imm2", FIELD_fld_ae_sem_loads_stores_imm2, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_imm2_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_imm2_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_i3", FIELD_fld_ae_sem_loads_stores_i3, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_spfma_i_imm3_encode, OperandSem_opnd_sem_opnd_ae_sem_spfma_i_imm3_decode,
    0, 0 },
  { "opnd_ae_sem_rng_v0", FIELD_fld_ae_sem_rng_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_rng_v1", FIELD_fld_ae_sem_rng_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_reduction_sort_v", FIELD_fld_ae_sem_reduction_sort_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_reduction_sort_v0", FIELD_fld_ae_sem_reduction_sort_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_reduction_sort_ds", FIELD_fld_ae_sem_reduction_sort_ds, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_multiply_d0", FIELD_fld_ae_sem_multiply_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_multiply_d2", FIELD_fld_ae_sem_multiply_d2, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_multiply_q0", FIELD_fld_ae_sem_multiply_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_multiply_q1", FIELD_fld_ae_sem_multiply_q1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_dr_immed.N", FIELD_fld_ae_sem_dr_to_dr_immed_N, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_imm2_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_imm2_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_ar_ei", FIELD_fld_ae_sem_dr_to_ar_ei, REGFILE_AE_EP, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_EP_encode, OperandSem_opnd_sem_AE_EP_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_ar_eo", FIELD_fld_ae_sem_dr_to_ar_eo, REGFILE_AE_EP, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_EP_encode, OperandSem_opnd_sem_AE_EP_decode,
    0, 0 },
  { "opnd_ae_sem_multiply_acc_ep", FIELD_fld_ae_sem_multiply_acc_ep, REGFILE_AE_EP, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_EP_encode, OperandSem_opnd_sem_AE_EP_decode,
    0, 0 },
  { "opnd_ae_sem_arithmetic_e", FIELD_fld_ae_sem_arithmetic_e, REGFILE_AE_EP, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_EP_encode, OperandSem_opnd_sem_AE_EP_decode,
    0, 0 },
  { "opnd_ae_sem_arithmetic_ep", FIELD_fld_ae_sem_arithmetic_ep, REGFILE_AE_EP, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_EP_encode, OperandSem_opnd_sem_AE_EP_decode,
    0, 0 },
  { "opnd_ae_sem_arithmetic_ep1", FIELD_fld_ae_sem_arithmetic_ep1, REGFILE_AE_EP, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_EP_encode, OperandSem_opnd_sem_AE_EP_decode,
    0, 0 },
  { "opnd_ae_sem_select_ss", FIELD_fld_ae_sem_select_ss, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_select_vr", FIELD_fld_ae_sem_select_vr, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_select_vs", FIELD_fld_ae_sem_select_vs, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_select_vt", FIELD_fld_ae_sem_select_vt, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_select_vu", FIELD_fld_ae_sem_select_vu, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_select_isel", FIELD_fld_ae_sem_select_isel, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_sp32cvt_i_imm5_encode, OperandSem_opnd_sem_opnd_ae_sem_sp32cvt_i_imm5_decode,
    0, 0 },
  { "opnd_ae_sem_shift_e", FIELD_fld_ae_sem_shift_e, REGFILE_AE_EP, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_EP_encode, OperandSem_opnd_sem_AE_EP_decode,
    0, 0 },
  { "opnd_ae_sem_shift_i8", FIELD_fld_ae_sem_shift_i8, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_shift_i8_encode, OperandSem_opnd_sem_opnd_ae_sem_shift_i8_decode,
    0, 0 },
  { "opnd_ae_sem_multiply_d1", FIELD_fld_ae_sem_multiply_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_multiply_d3", FIELD_fld_ae_sem_multiply_d3, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_dr_imm", FIELD_fld_ae_sem_dr_to_dr_imm, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_dr_to_dr_imm_encode, OperandSem_opnd_sem_opnd_ae_sem_dr_to_dr_imm_decode,
    0, 0 },
  { "opnd_ae_sem_rng_d", FIELD_fld_ae_sem_rng_d, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_sb_loads_stores_iba2", FIELD_fld_ae_sem_sb_loads_stores_iba2, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_sb_loads_stores_iba2_encode, OperandSem_opnd_sem_opnd_ae_sem_sb_loads_stores_iba2_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_ar_ar_s", FIELD_fld_ae_sem_dr_to_ar_ar_s, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_AE_ARDECNORM16_ar_u", FIELD_fld_AE_ARDECNORM16_ar_u, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_rng_a", FIELD_fld_ae_sem_rng_a, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_rng_art", FIELD_fld_ae_sem_rng_art, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_rng_i2", FIELD_fld_ae_sem_rng_i2, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_imm2_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_imm2_decode,
    0, 0 },
  { "opnd_ae_sem_rng_imm2", FIELD_fld_ae_sem_rng_imm2, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_imm2_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_imm2_decode,
    0, 0 },
  { "opnd_ae_sem_lb_db_ops_ar_u", FIELD_fld_ae_sem_lb_db_ops_ar_u, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_lb_db_ops_iba", FIELD_fld_ae_sem_lb_db_ops_iba, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_sb_loads_stores_iba_encode, OperandSem_opnd_sem_opnd_ae_sem_sb_loads_stores_iba_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_ar_vr", FIELD_fld_ae_sem_dr_to_ar_vr, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_spmisc_brt", FIELD_fld_ae_sem_spmisc_brt, REGFILE_BR, 2,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR2_encode, OperandSem_opnd_sem_BR2_decode,
    0, 0 },
  { "opnd_ae_sem_spmisc_vr", FIELD_fld_ae_sem_spmisc_vr, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_spmisc_vs", FIELD_fld_ae_sem_spmisc_vs, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_dr_arr", FIELD_fld_ae_sem_dr_to_dr_arr, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_dr_bt", FIELD_fld_ae_sem_dr_to_dr_bt, REGFILE_BR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR_encode, OperandSem_opnd_sem_BR_decode,
    0, 0 },
  { "opnd_ae_sem_sp32cvt_art", FIELD_fld_ae_sem_sp32cvt_art, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_sp32cvt_i_imm5", FIELD_fld_ae_sem_sp32cvt_i_imm5, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_sp32cvt_i_imm5_encode, OperandSem_opnd_sem_opnd_ae_sem_sp32cvt_i_imm5_decode,
    0, 0 },
  { "opnd_ae_sem_sp32cvt_vr", FIELD_fld_ae_sem_sp32cvt_vr, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_sp32cvt_vt", FIELD_fld_ae_sem_sp32cvt_vt, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_sp32cvt_arr", FIELD_fld_ae_sem_sp32cvt_arr, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_movfpstate_v", FIELD_fld_ae_sem_movfpstate_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_fpmov_vr", FIELD_fld_ae_sem_fpmov_vr, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_fpmov_vt", FIELD_fld_ae_sem_fpmov_vt, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_fpmov_i_imm4", FIELD_fld_ae_sem_fpmov_i_imm4, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_hpcnv_i_imm4_encode, OperandSem_opnd_sem_opnd_ae_sem_hpcnv_i_imm4_decode,
    0, 0 },
  { "opnd_ae_sem_fpmov_vs", FIELD_fld_ae_sem_fpmov_vs, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_fpmov_vu", FIELD_fld_ae_sem_fpmov_vu, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_spmisc_vsM", FIELD_fld_ae_sem_spmisc_vsM, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_spmisc_vtM", FIELD_fld_ae_sem_spmisc_vtM, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_spmisc_vt", FIELD_fld_ae_sem_spmisc_vt, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_spaddsub_vr", FIELD_fld_ae_sem_spaddsub_vr, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_spaddsub_vs", FIELD_fld_ae_sem_spaddsub_vs, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_spaddsub_vt", FIELD_fld_ae_sem_spaddsub_vt, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_spaddsub_vu", FIELD_fld_ae_sem_spaddsub_vu, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_spfma_vr", FIELD_fld_ae_sem_spfma_vr, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_spfma_vs", FIELD_fld_ae_sem_spfma_vs, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_spfma_vt", FIELD_fld_ae_sem_spfma_vt, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_spfma_vp", FIELD_fld_ae_sem_spfma_vp, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_spfma_i_imm1", FIELD_fld_ae_sem_spfma_i_imm1, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_spfma_i_imm1_encode, OperandSem_opnd_sem_opnd_ae_sem_spfma_i_imm1_decode,
    0, 0 },
  { "opnd_ae_sem_spfma_i_imm3", FIELD_fld_ae_sem_spfma_i_imm3, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_spfma_i_imm3_encode, OperandSem_opnd_sem_opnd_ae_sem_spfma_i_imm3_decode,
    0, 0 },
  { "opnd_ae_sem_spaddsub_vp", FIELD_fld_ae_sem_spaddsub_vp, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_spaddsub_vq", FIELD_fld_ae_sem_spaddsub_vq, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_spfma_vu", FIELD_fld_ae_sem_spfma_vu, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_spfma_vq", FIELD_fld_ae_sem_spfma_vq, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_hprminmaxnum_vr", FIELD_fld_ae_sem_hprminmaxnum_vr, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_hprminmaxnum_vt", FIELD_fld_ae_sem_hprminmaxnum_vt, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_hpcmp_br4t", FIELD_fld_ae_sem_hpcmp_br4t, REGFILE_BR, 4,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR4_encode, OperandSem_opnd_sem_BR4_decode,
    0, 0 },
  { "opnd_ae_sem_hpcmp_vr", FIELD_fld_ae_sem_hpcmp_vr, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_hpcmp_vs", FIELD_fld_ae_sem_hpcmp_vs, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_hpcnv_art", FIELD_fld_ae_sem_hpcnv_art, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_hpcnv_i_imm4", FIELD_fld_ae_sem_hpcnv_i_imm4, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_hpcnv_i_imm4_encode, OperandSem_opnd_sem_opnd_ae_sem_hpcnv_i_imm4_decode,
    0, 0 },
  { "opnd_ae_sem_hpcnv_vr", FIELD_fld_ae_sem_hpcnv_vr, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_hpcnv_arr", FIELD_fld_ae_sem_hpcnv_arr, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_hpcnv_vt", FIELD_fld_ae_sem_hpcnv_vt, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_hpcmp_vt", FIELD_fld_ae_sem_hpcmp_vt, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_hpcnv_vs", FIELD_fld_ae_sem_hpcnv_vs, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_hpfma_vr", FIELD_fld_ae_sem_hpfma_vr, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_hpfma_vs", FIELD_fld_ae_sem_hpfma_vs, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_hpfma_vt", FIELD_fld_ae_sem_hpfma_vt, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_hpfma_vp", FIELD_fld_ae_sem_hpfma_vp, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_hpfma_vu", FIELD_fld_ae_sem_hpfma_vu, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_hpfma_vq", FIELD_fld_ae_sem_hpfma_vq, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "bbi", FIELD_bbi, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0 },
  { "sae", FIELD_sae, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0 },
  { "sas", FIELD_sas, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0 },
  { "sargt", FIELD_sargt, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0 },
  { "s", FIELD_s, -1, 0,
    0,
    OperandSem_opnd_sem_s_encode, OperandSem_opnd_sem_s_decode,
    0, 0 },
  { "t", FIELD_t, -1, 0, 0, 0, 0, 0, 0 },
  { "bbi4", FIELD_bbi4, -1, 0, 0, 0, 0, 0, 0 },
  { "imm12", FIELD_imm12, -1, 0, 0, 0, 0, 0, 0 },
  { "imm8", FIELD_imm8, -1, 0, 0, 0, 0, 0, 0 },
  { "s8", FIELD_s8, -1, 0, 0, 0, 0, 0, 0 },
  { "imms8", FIELD_imms8, -1, 0, 0, 0, 0, 0, 0 },
  { "imm12b", FIELD_imm12b, -1, 0, 0, 0, 0, 0, 0 },
  { "imm16", FIELD_imm16, -1, 0, 0, 0, 0, 0, 0 },
  { "m", FIELD_m, -1, 0, 0, 0, 0, 0, 0 },
  { "n", FIELD_n, -1, 0, 0, 0, 0, 0, 0 },
  { "offset", FIELD_offset, -1, 0, 0, 0, 0, 0, 0 },
  { "op0", FIELD_op0, -1, 0, 0, 0, 0, 0, 0 },
  { "op1", FIELD_op1, -1, 0, 0, 0, 0, 0, 0 },
  { "op2", FIELD_op2, -1, 0, 0, 0, 0, 0, 0 },
  { "r", FIELD_r, -1, 0, 0, 0, 0, 0, 0 },
  { "r_disp", FIELD_r_disp, -1, 0, 0, 0, 0, 0, 0 },
  { "r_3", FIELD_r_3, -1, 0, 0, 0, 0, 0, 0 },
  { "sa4", FIELD_sa4, -1, 0, 0, 0, 0, 0, 0 },
  { "sae4", FIELD_sae4, -1, 0, 0, 0, 0, 0, 0 },
  { "sal", FIELD_sal, -1, 0, 0, 0, 0, 0, 0 },
  { "sas4", FIELD_sas4, -1, 0, 0, 0, 0, 0, 0 },
  { "sr", FIELD_sr, -1, 0, 0, 0, 0, 0, 0 },
  { "st", FIELD_st, -1, 0, 0, 0, 0, 0, 0 },
  { "thi3", FIELD_thi3, -1, 0, 0, 0, 0, 0, 0 },
  { "imm4", FIELD_imm4, -1, 0, 0, 0, 0, 0, 0 },
  { "mn", FIELD_mn, -1, 0, 0, 0, 0, 0, 0 },
  { "i", FIELD_i, -1, 0, 0, 0, 0, 0, 0 },
  { "imm6lo", FIELD_imm6lo, -1, 0, 0, 0, 0, 0, 0 },
  { "imm6hi", FIELD_imm6hi, -1, 0, 0, 0, 0, 0, 0 },
  { "imm7lo", FIELD_imm7lo, -1, 0, 0, 0, 0, 0, 0 },
  { "imm7hi", FIELD_imm7hi, -1, 0, 0, 0, 0, 0, 0 },
  { "z", FIELD_z, -1, 0, 0, 0, 0, 0, 0 },
  { "imm6", FIELD_imm6, -1, 0, 0, 0, 0, 0, 0 },
  { "imm7", FIELD_imm7, -1, 0, 0, 0, 0, 0, 0 },
  { "t2", FIELD_t2, -1, 0, 0, 0, 0, 0, 0 },
  { "s2", FIELD_s2, -1, 0, 0, 0, 0, 0, 0 },
  { "r2", FIELD_r2, -1, 0, 0, 0, 0, 0, 0 },
  { "t4", FIELD_t4, -1, 0, 0, 0, 0, 0, 0 },
  { "s4", FIELD_s4, -1, 0, 0, 0, 0, 0, 0 },
  { "r4", FIELD_r4, -1, 0, 0, 0, 0, 0, 0 },
  { "t8", FIELD_t8, -1, 0, 0, 0, 0, 0, 0 },
  { "r8", FIELD_r8, -1, 0, 0, 0, 0, 0, 0 },
  { "xt_wbr15_imm", FIELD_xt_wbr15_imm, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_Inst16b_12", FIELD_ae_fld_Inst16b_12, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_Inst16b_15_13", FIELD_ae_fld_Inst16b_15_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_13_12", FIELD_fld_ae8_slot0_13_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_13_13", FIELD_fld_ae8_slot0_13_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_13_4", FIELD_fld_ae8_slot0_13_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_13_9", FIELD_fld_ae8_slot0_13_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_17_4", FIELD_fld_ae8_slot0_17_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_17_8", FIELD_fld_ae8_slot0_17_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_31_12", FIELD_fld_ae8_slot0_31_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_31_15", FIELD_fld_ae8_slot0_31_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_31_18", FIELD_fld_ae8_slot0_31_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_31_19", FIELD_fld_ae8_slot0_31_19, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_31_20", FIELD_fld_ae8_slot0_31_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_31_21", FIELD_fld_ae8_slot0_31_21, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_31_22", FIELD_fld_ae8_slot0_31_22, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_31_23", FIELD_fld_ae8_slot0_31_23, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_31_7", FIELD_fld_ae8_slot0_31_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_31_8", FIELD_fld_ae8_slot0_31_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_31_9", FIELD_fld_ae8_slot0_31_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_3_0", FIELD_fld_ae8_slot0_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_6_0", FIELD_fld_ae8_slot0_6_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_7_4", FIELD_fld_ae8_slot0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_7_5", FIELD_fld_ae8_slot0_7_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_7_7", FIELD_fld_ae8_slot0_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot0_8_0", FIELD_fld_ae8_slot0_8_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_v", FIELD_fld_ae_sem_arithmetic_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_v0", FIELD_fld_ae_sem_arithmetic_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_v1", FIELD_fld_ae_sem_arithmetic_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_dr_immed", FIELD_fld_ae_sem_dr_to_dr_immed, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_dr_v", FIELD_fld_ae_sem_dr_to_dr_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_dr_v0", FIELD_fld_ae_sem_dr_to_dr_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_dr_v1", FIELD_fld_ae_sem_dr_to_dr_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_a", FIELD_fld_ae_sem_loads_stores_a, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_av", FIELD_fld_ae_sem_loads_stores_av, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_av1", FIELD_fld_ae_sem_loads_stores_av1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_i128", FIELD_fld_ae_sem_loads_stores_i128, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_i16", FIELD_fld_ae_sem_loads_stores_i16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_i3", FIELD_fld_ae_sem_loads_stores_i3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_i32", FIELD_fld_ae_sem_loads_stores_i32, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_i64", FIELD_fld_ae_sem_loads_stores_i64, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_i64pos", FIELD_fld_ae_sem_loads_stores_i64pos, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_i8", FIELD_fld_ae_sem_loads_stores_i8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_imm2", FIELD_fld_ae_sem_loads_stores_imm2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_su", FIELD_fld_ae_sem_loads_stores_su, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_uu", FIELD_fld_ae_sem_loads_stores_uu, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_v", FIELD_fld_ae_sem_loads_stores_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_v1", FIELD_fld_ae_sem_loads_stores_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_x", FIELD_fld_ae_sem_loads_stores_x, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_a0", FIELD_fld_ae_sem_shift_a0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_d", FIELD_fld_ae_sem_shift_d, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_d0", FIELD_fld_ae_sem_shift_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_i16", FIELD_fld_ae_sem_shift_i16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_i32", FIELD_fld_ae_sem_shift_i32, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_i64", FIELD_fld_ae_sem_shift_i64, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_sd", FIELD_fld_ae_sem_shift_sd, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot1_17_13", FIELD_fld_ae8_slot1_17_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot1_17_14", FIELD_fld_ae8_slot1_17_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot1_17_15", FIELD_fld_ae8_slot1_17_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot1_17_8", FIELD_fld_ae8_slot1_17_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot1_29_12", FIELD_fld_ae8_slot1_29_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot1_29_13", FIELD_fld_ae8_slot1_29_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot1_29_18", FIELD_fld_ae8_slot1_29_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot1_29_20", FIELD_fld_ae8_slot1_29_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot1_29_22", FIELD_fld_ae8_slot1_29_22, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot1_29_23", FIELD_fld_ae8_slot1_29_23, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot1_29_5", FIELD_fld_ae8_slot1_29_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot1_29_8", FIELD_fld_ae8_slot1_29_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot1_29_9", FIELD_fld_ae8_slot1_29_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot1_3_0", FIELD_fld_ae8_slot1_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot1_3_3", FIELD_fld_ae8_slot1_3_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot1_4_0", FIELD_fld_ae8_slot1_4_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot1_7_4", FIELD_fld_ae8_slot1_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot2_19_10", FIELD_fld_ae8_slot2_19_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot2_19_15", FIELD_fld_ae8_slot2_19_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot2_33_15", FIELD_fld_ae8_slot2_33_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot2_33_25", FIELD_fld_ae8_slot2_33_25, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot2_33_9", FIELD_fld_ae8_slot2_33_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot2_34_30", FIELD_fld_ae8_slot2_34_30, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot2_39_35", FIELD_fld_ae8_slot2_39_35, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot2_44_35", FIELD_fld_ae8_slot2_44_35, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot2_58_34", FIELD_fld_ae8_slot2_58_34, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot2_58_35", FIELD_fld_ae8_slot2_58_35, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot2_58_40", FIELD_fld_ae8_slot2_58_40, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot2_58_50", FIELD_fld_ae8_slot2_58_50, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot2_8_0", FIELD_fld_ae8_slot2_8_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae8_slot2_9_0", FIELD_fld_ae8_slot2_9_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_nn_c0", FIELD_fld_ae_sem_mul_nn_c0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_nn_c1", FIELD_fld_ae_sem_mul_nn_c1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_nn_c2", FIELD_fld_ae_sem_mul_nn_c2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_nn_c3", FIELD_fld_ae_sem_mul_nn_c3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_nn_q0", FIELD_fld_ae_sem_mul_nn_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_nn_q1", FIELD_fld_ae_sem_mul_nn_q1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_nn_q2", FIELD_fld_ae_sem_mul_nn_q2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_nn_q3", FIELD_fld_ae_sem_mul_nn_q3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_nn_v0", FIELD_fld_ae_sem_mul_nn_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_nn_v1", FIELD_fld_ae_sem_mul_nn_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_nn_v2", FIELD_fld_ae_sem_mul_nn_v2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_nn_v3", FIELD_fld_ae_sem_mul_nn_v3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_art", FIELD_fld_ae_sem_arithmetic_art, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_ds", FIELD_fld_ae_sem_arithmetic_ds, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_va", FIELD_fld_ae_sem_arithmetic_va, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_vs", FIELD_fld_ae_sem_arithmetic_vs, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_ar_a", FIELD_fld_ae_sem_dr_to_ar_a, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_ar_ab", FIELD_fld_ae_sem_dr_to_ar_ab, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_ar_ai", FIELD_fld_ae_sem_dr_to_ar_ai, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_ar_aoe", FIELD_fld_ae_sem_dr_to_ar_aoe, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_ar_d", FIELD_fld_ae_sem_dr_to_ar_d, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_ar_d0", FIELD_fld_ae_sem_dr_to_ar_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_ar_d1", FIELD_fld_ae_sem_dr_to_ar_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_ar_imm8", FIELD_fld_ae_sem_dr_to_ar_imm8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_ar_v0", FIELD_fld_ae_sem_dr_to_ar_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_ar_vr", FIELD_fld_ae_sem_dr_to_ar_vr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_dr_arr", FIELD_fld_ae_sem_dr_to_dr_arr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_dr_bt", FIELD_fld_ae_sem_dr_to_dr_bt, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_dr_ds", FIELD_fld_ae_sem_dr_to_dr_ds, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_dr_imm2", FIELD_fld_ae_sem_dr_to_dr_imm2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_dr_movi_imm", FIELD_fld_ae_sem_dr_to_dr_movi_imm, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_hpcmp_br4t", FIELD_fld_ae_sem_hpcmp_br4t, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_hpcmp_vr", FIELD_fld_ae_sem_hpcmp_vr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_hpcmp_vs", FIELD_fld_ae_sem_hpcmp_vs, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_hpcnv_arr", FIELD_fld_ae_sem_hpcnv_arr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_hpcnv_art", FIELD_fld_ae_sem_hpcnv_art, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_hpcnv_i_imm4", FIELD_fld_ae_sem_hpcnv_i_imm4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_hpcnv_vr", FIELD_fld_ae_sem_hpcnv_vr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_hpcnv_vt", FIELD_fld_ae_sem_hpcnv_vt, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_hprminmaxnum_vr", FIELD_fld_ae_sem_hprminmaxnum_vr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_hprminmaxnum_vt", FIELD_fld_ae_sem_hprminmaxnum_vt, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_lb_ops_iba", FIELD_fld_ae_sem_lb_ops_iba, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_end", FIELD_fld_ae_sem_loads_stores_end, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_i64half", FIELD_fld_ae_sem_loads_stores_i64half, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_i64neg", FIELD_fld_ae_sem_loads_stores_i64neg, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_vu", FIELD_fld_ae_sem_loads_stores_vu, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_pks_d", FIELD_fld_ae_sem_pks_d, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_pks_pos", FIELD_fld_ae_sem_pks_pos, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_pks_s", FIELD_fld_ae_sem_pks_s, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_rng_v0", FIELD_fld_ae_sem_rng_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_rng_v1", FIELD_fld_ae_sem_rng_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_sb_loads_stores_iba", FIELD_fld_ae_sem_sb_loads_stores_iba, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_a", FIELD_fld_ae_sem_shift_a, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_d1", FIELD_fld_ae_sem_shift_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_da", FIELD_fld_ae_sem_shift_da, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_imm32", FIELD_fld_ae_sem_shift_imm32, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_imm8", FIELD_fld_ae_sem_shift_imm8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_sp32cvt_arr", FIELD_fld_ae_sem_sp32cvt_arr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_sp32cvt_art", FIELD_fld_ae_sem_sp32cvt_art, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_sp32cvt_i_imm5", FIELD_fld_ae_sem_sp32cvt_i_imm5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_sp32cvt_vr", FIELD_fld_ae_sem_sp32cvt_vr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_sp32cvt_vt", FIELD_fld_ae_sem_sp32cvt_vt, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spmisc_brt", FIELD_fld_ae_sem_spmisc_brt, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spmisc_vr", FIELD_fld_ae_sem_spmisc_vr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spmisc_vs", FIELD_fld_ae_sem_spmisc_vs, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_11_10", FIELD_fld_ae_slot0_11_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_11_11", FIELD_fld_ae_slot0_11_11, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_11_8", FIELD_fld_ae_slot0_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_11_9", FIELD_fld_ae_slot0_11_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_12_0", FIELD_fld_ae_slot0_12_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_12_10", FIELD_fld_ae_slot0_12_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_12_12", FIELD_fld_ae_slot0_12_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_12_2", FIELD_fld_ae_slot0_12_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_12_6", FIELD_fld_ae_slot0_12_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_12_8", FIELD_fld_ae_slot0_12_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_12_9", FIELD_fld_ae_slot0_12_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_14_12", FIELD_fld_ae_slot0_14_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_14_13", FIELD_fld_ae_slot0_14_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_17_10", FIELD_fld_ae_slot0_17_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_17_12", FIELD_fld_ae_slot0_17_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_17_13", FIELD_fld_ae_slot0_17_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_17_14", FIELD_fld_ae_slot0_17_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_17_15", FIELD_fld_ae_slot0_17_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_17_16", FIELD_fld_ae_slot0_17_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_17_17", FIELD_fld_ae_slot0_17_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_17_8", FIELD_fld_ae_slot0_17_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_18_13", FIELD_fld_ae_slot0_18_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_18_15", FIELD_fld_ae_slot0_18_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_18_16", FIELD_fld_ae_slot0_18_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_18_8", FIELD_fld_ae_slot0_18_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_19_12", FIELD_fld_ae_slot0_19_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_19_15", FIELD_fld_ae_slot0_19_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_19_19", FIELD_fld_ae_slot0_19_19, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_19_8", FIELD_fld_ae_slot0_19_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_1_0", FIELD_fld_ae_slot0_1_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_20_16", FIELD_fld_ae_slot0_20_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_20_20", FIELD_fld_ae_slot0_20_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_23_15", FIELD_fld_ae_slot0_23_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_23_17", FIELD_fld_ae_slot0_23_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_23_19", FIELD_fld_ae_slot0_23_19, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_23_22", FIELD_fld_ae_slot0_23_22, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_28_10", FIELD_fld_ae_slot0_28_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_28_12", FIELD_fld_ae_slot0_28_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_28_14", FIELD_fld_ae_slot0_28_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_28_15", FIELD_fld_ae_slot0_28_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_28_16", FIELD_fld_ae_slot0_28_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_28_17", FIELD_fld_ae_slot0_28_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_28_19", FIELD_fld_ae_slot0_28_19, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_28_21", FIELD_fld_ae_slot0_28_21, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_28_22", FIELD_fld_ae_slot0_28_22, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_28_24", FIELD_fld_ae_slot0_28_24, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_28_26", FIELD_fld_ae_slot0_28_26, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_28_27", FIELD_fld_ae_slot0_28_27, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_28_4", FIELD_fld_ae_slot0_28_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_28_8", FIELD_fld_ae_slot0_28_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_3_0", FIELD_fld_ae_slot0_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_3_1", FIELD_fld_ae_slot0_3_1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_3_2", FIELD_fld_ae_slot0_3_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_3_3", FIELD_fld_ae_slot0_3_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_4_0", FIELD_fld_ae_slot0_4_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_4_4", FIELD_fld_ae_slot0_4_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_5_0", FIELD_fld_ae_slot0_5_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_5_4", FIELD_fld_ae_slot0_5_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_7_0", FIELD_fld_ae_slot0_7_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_7_2", FIELD_fld_ae_slot0_7_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_7_3", FIELD_fld_ae_slot0_7_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_7_4", FIELD_fld_ae_slot0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_8_8", FIELD_fld_ae_slot0_8_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_9_4", FIELD_fld_ae_slot0_9_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_9_8", FIELD_fld_ae_slot0_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_9_9", FIELD_fld_ae_slot0_9_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_0_0", FIELD_fld_ae_slot1_0_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_12_8", FIELD_fld_ae_slot1_12_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_17_13", FIELD_fld_ae_slot1_17_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_17_17", FIELD_fld_ae_slot1_17_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_17_8", FIELD_fld_ae_slot1_17_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_25_1", FIELD_fld_ae_slot1_25_1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_25_12", FIELD_fld_ae_slot1_25_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_25_13", FIELD_fld_ae_slot1_25_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_25_16", FIELD_fld_ae_slot1_25_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_25_17", FIELD_fld_ae_slot1_25_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_25_18", FIELD_fld_ae_slot1_25_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_25_20", FIELD_fld_ae_slot1_25_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_25_22", FIELD_fld_ae_slot1_25_22, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_25_23", FIELD_fld_ae_slot1_25_23, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_25_8", FIELD_fld_ae_slot1_25_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_25_9", FIELD_fld_ae_slot1_25_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_3_0", FIELD_fld_ae_slot1_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_3_2", FIELD_fld_ae_slot1_3_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_3_3", FIELD_fld_ae_slot1_3_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_7_4", FIELD_fld_ae_slot1_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_e", FIELD_fld_ae_sem_arithmetic_e, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_ep", FIELD_fld_ae_sem_arithmetic_ep, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_ep1", FIELD_fld_ae_sem_arithmetic_ep1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_ar_ei", FIELD_fld_ae_sem_dr_to_ar_ei, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_ar_eo", FIELD_fld_ae_sem_dr_to_ar_eo, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_dr_immed.N", FIELD_fld_ae_sem_dr_to_dr_immed_N, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_fpmov_i_imm4", FIELD_fld_ae_sem_fpmov_i_imm4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_fpmov_vr", FIELD_fld_ae_sem_fpmov_vr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_fpmov_vs", FIELD_fld_ae_sem_fpmov_vs, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_fpmov_vt", FIELD_fld_ae_sem_fpmov_vt, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_fpmov_vu", FIELD_fld_ae_sem_fpmov_vu, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_hpcmp_vt", FIELD_fld_ae_sem_hpcmp_vt, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_hpcnv_vs", FIELD_fld_ae_sem_hpcnv_vs, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_hpfma_vr", FIELD_fld_ae_sem_hpfma_vr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_hpfma_vs", FIELD_fld_ae_sem_hpfma_vs, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_hpfma_vt", FIELD_fld_ae_sem_hpfma_vt, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_movfpstate_v", FIELD_fld_ae_sem_movfpstate_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_multiply_acc_ep", FIELD_fld_ae_sem_multiply_acc_ep, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_multiply_d0", FIELD_fld_ae_sem_multiply_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_multiply_d2", FIELD_fld_ae_sem_multiply_d2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_multiply_q0", FIELD_fld_ae_sem_multiply_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_multiply_q1", FIELD_fld_ae_sem_multiply_q1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_reduction_sort_ds", FIELD_fld_ae_sem_reduction_sort_ds, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_reduction_sort_v", FIELD_fld_ae_sem_reduction_sort_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_reduction_sort_v0", FIELD_fld_ae_sem_reduction_sort_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_select_isel", FIELD_fld_ae_sem_select_isel, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_select_ss", FIELD_fld_ae_sem_select_ss, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_select_vr", FIELD_fld_ae_sem_select_vr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_select_vs", FIELD_fld_ae_sem_select_vs, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_select_vt", FIELD_fld_ae_sem_select_vt, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_select_vu", FIELD_fld_ae_sem_select_vu, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spaddsub_vr", FIELD_fld_ae_sem_spaddsub_vr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spaddsub_vs", FIELD_fld_ae_sem_spaddsub_vs, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spaddsub_vt", FIELD_fld_ae_sem_spaddsub_vt, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spaddsub_vu", FIELD_fld_ae_sem_spaddsub_vu, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spfma_i_imm1", FIELD_fld_ae_sem_spfma_i_imm1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spfma_i_imm3", FIELD_fld_ae_sem_spfma_i_imm3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spfma_vp", FIELD_fld_ae_sem_spfma_vp, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spfma_vr", FIELD_fld_ae_sem_spfma_vr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spfma_vs", FIELD_fld_ae_sem_spfma_vs, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spfma_vt", FIELD_fld_ae_sem_spfma_vt, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spmisc_vsM", FIELD_fld_ae_sem_spmisc_vsM, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spmisc_vt", FIELD_fld_ae_sem_spmisc_vt, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spmisc_vtM", FIELD_fld_ae_sem_spmisc_vtM, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_14_0", FIELD_fld_ae_slot2_14_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_14_10", FIELD_fld_ae_slot2_14_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_14_14", FIELD_fld_ae_slot2_14_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_14_5", FIELD_fld_ae_slot2_14_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_16_15", FIELD_fld_ae_slot2_16_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_19_15", FIELD_fld_ae_slot2_19_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_28_15", FIELD_fld_ae_slot2_28_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_28_17", FIELD_fld_ae_slot2_28_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_28_19", FIELD_fld_ae_slot2_28_19, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_28_20", FIELD_fld_ae_slot2_28_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_28_25", FIELD_fld_ae_slot2_28_25, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_28_4", FIELD_fld_ae_slot2_28_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_28_5", FIELD_fld_ae_slot2_28_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_3_0", FIELD_fld_ae_slot2_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_9_0", FIELD_fld_ae_slot2_9_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_9_1", FIELD_fld_ae_slot2_9_1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_9_2", FIELD_fld_ae_slot2_9_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_9_5", FIELD_fld_ae_slot2_9_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_9_6", FIELD_fld_ae_slot2_9_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_9_7", FIELD_fld_ae_slot2_9_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_9_8", FIELD_fld_ae_slot2_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_dr_imm", FIELD_fld_ae_sem_dr_to_dr_imm, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_multiply_d1", FIELD_fld_ae_sem_multiply_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_multiply_d3", FIELD_fld_ae_sem_multiply_d3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_rng_d", FIELD_fld_ae_sem_rng_d, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_e", FIELD_fld_ae_sem_shift_e, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_i8", FIELD_fld_ae_sem_shift_i8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_11_0", FIELD_fld_ae_slot3_11_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_14_0", FIELD_fld_ae_slot3_14_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_14_10", FIELD_fld_ae_slot3_14_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_14_12", FIELD_fld_ae_slot3_14_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_14_13", FIELD_fld_ae_slot3_14_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_16_13", FIELD_fld_ae_slot3_16_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_19_0", FIELD_fld_ae_slot3_19_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_19_10", FIELD_fld_ae_slot3_19_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_19_15", FIELD_fld_ae_slot3_19_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_19_17", FIELD_fld_ae_slot3_19_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_19_18", FIELD_fld_ae_slot3_19_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_19_19", FIELD_fld_ae_slot3_19_19, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_24_10", FIELD_fld_ae_slot3_24_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_24_19", FIELD_fld_ae_slot3_24_19, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_24_20", FIELD_fld_ae_slot3_24_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_36_12", FIELD_fld_ae_slot3_36_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_36_16", FIELD_fld_ae_slot3_36_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_36_19", FIELD_fld_ae_slot3_36_19, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_36_20", FIELD_fld_ae_slot3_36_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_36_22", FIELD_fld_ae_slot3_36_22, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_36_25", FIELD_fld_ae_slot3_36_25, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_36_30", FIELD_fld_ae_slot3_36_30, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_4_0", FIELD_fld_ae_slot3_4_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_9_0", FIELD_fld_ae_slot3_9_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_9_1", FIELD_fld_ae_slot3_9_1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_9_3", FIELD_fld_ae_slot3_9_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_9_5", FIELD_fld_ae_slot3_9_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_0_0", FIELD_fld_ae2_slot0_0_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_11_4", FIELD_fld_ae2_slot0_11_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_11_8", FIELD_fld_ae2_slot0_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_11_9", FIELD_fld_ae2_slot0_11_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_12_0", FIELD_fld_ae2_slot0_12_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_12_2", FIELD_fld_ae2_slot0_12_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_12_4", FIELD_fld_ae2_slot0_12_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_12_8", FIELD_fld_ae2_slot0_12_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_14_13", FIELD_fld_ae2_slot0_14_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_14_8", FIELD_fld_ae2_slot0_14_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_15_0", FIELD_fld_ae2_slot0_15_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_15_12", FIELD_fld_ae2_slot0_15_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_15_13", FIELD_fld_ae2_slot0_15_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_15_15", FIELD_fld_ae2_slot0_15_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_15_4", FIELD_fld_ae2_slot0_15_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_15_8", FIELD_fld_ae2_slot0_15_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_17_13", FIELD_fld_ae2_slot0_17_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_17_17", FIELD_fld_ae2_slot0_17_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_18_15", FIELD_fld_ae2_slot0_18_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_18_17", FIELD_fld_ae2_slot0_18_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_18_18", FIELD_fld_ae2_slot0_18_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_1_0", FIELD_fld_ae2_slot0_1_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_23_18", FIELD_fld_ae2_slot0_23_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_23_19", FIELD_fld_ae2_slot0_23_19, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_3_0", FIELD_fld_ae2_slot0_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_40_16", FIELD_fld_ae2_slot0_40_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_40_17", FIELD_fld_ae2_slot0_40_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_40_18", FIELD_fld_ae2_slot0_40_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_40_19", FIELD_fld_ae2_slot0_40_19, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_40_21", FIELD_fld_ae2_slot0_40_21, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_40_23", FIELD_fld_ae2_slot0_40_23, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_40_24", FIELD_fld_ae2_slot0_40_24, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_40_25", FIELD_fld_ae2_slot0_40_25, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_40_26", FIELD_fld_ae2_slot0_40_26, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_40_27", FIELD_fld_ae2_slot0_40_27, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_7_0", FIELD_fld_ae2_slot0_7_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_7_4", FIELD_fld_ae2_slot0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_7_6", FIELD_fld_ae2_slot0_7_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_7_7", FIELD_fld_ae2_slot0_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_8_8", FIELD_fld_ae2_slot0_8_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_9_8", FIELD_fld_ae2_slot0_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_0_0", FIELD_fld_ae2_slot1_0_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_11_0", FIELD_fld_ae2_slot1_11_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_11_10", FIELD_fld_ae2_slot1_11_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_11_8", FIELD_fld_ae2_slot1_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_14_10", FIELD_fld_ae2_slot1_14_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_14_11", FIELD_fld_ae2_slot1_14_11, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_14_12", FIELD_fld_ae2_slot1_14_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_14_14", FIELD_fld_ae2_slot1_14_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_14_8", FIELD_fld_ae2_slot1_14_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_36_12", FIELD_fld_ae2_slot1_36_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_36_14", FIELD_fld_ae2_slot1_36_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_36_15", FIELD_fld_ae2_slot1_36_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_36_16", FIELD_fld_ae2_slot1_36_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_36_17", FIELD_fld_ae2_slot1_36_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_36_18", FIELD_fld_ae2_slot1_36_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_36_20", FIELD_fld_ae2_slot1_36_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_36_22", FIELD_fld_ae2_slot1_36_22, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_36_23", FIELD_fld_ae2_slot1_36_23, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_3_0", FIELD_fld_ae2_slot1_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_3_1", FIELD_fld_ae2_slot1_3_1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_3_2", FIELD_fld_ae2_slot1_3_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_3_3", FIELD_fld_ae2_slot1_3_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_7_4", FIELD_fld_ae2_slot1_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_9_8", FIELD_fld_ae2_slot1_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_9_9", FIELD_fld_ae2_slot1_9_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_14_10", FIELD_fld_ae2_slot2_14_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_17_0", FIELD_fld_ae2_slot2_17_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_17_10", FIELD_fld_ae2_slot2_17_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_17_15", FIELD_fld_ae2_slot2_17_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_17_17", FIELD_fld_ae2_slot2_17_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_19_10", FIELD_fld_ae2_slot2_19_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_19_15", FIELD_fld_ae2_slot2_19_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_19_18", FIELD_fld_ae2_slot2_19_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_19_9", FIELD_fld_ae2_slot2_19_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_24_10", FIELD_fld_ae2_slot2_24_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_24_15", FIELD_fld_ae2_slot2_24_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_24_20", FIELD_fld_ae2_slot2_24_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_24_5", FIELD_fld_ae2_slot2_24_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_24_9", FIELD_fld_ae2_slot2_24_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_42_18", FIELD_fld_ae2_slot2_42_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_42_20", FIELD_fld_ae2_slot2_42_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_42_25", FIELD_fld_ae2_slot2_42_25, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_42_26", FIELD_fld_ae2_slot2_42_26, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_42_28", FIELD_fld_ae2_slot2_42_28, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_42_30", FIELD_fld_ae2_slot2_42_30, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_4_0", FIELD_fld_ae2_slot2_4_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_9_5", FIELD_fld_ae2_slot2_9_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spaddsub_vp", FIELD_fld_ae_sem_spaddsub_vp, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spaddsub_vq", FIELD_fld_ae_sem_spaddsub_vq, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_11_11", FIELD_fld_ae3_slot0_11_11, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_11_4", FIELD_fld_ae3_slot0_11_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_11_8", FIELD_fld_ae3_slot0_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_12_12", FIELD_fld_ae3_slot0_12_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_12_8", FIELD_fld_ae3_slot0_12_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_13_13", FIELD_fld_ae3_slot0_13_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_13_8", FIELD_fld_ae3_slot0_13_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_1_0", FIELD_fld_ae3_slot0_1_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_32_11", FIELD_fld_ae3_slot0_32_11, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_32_12", FIELD_fld_ae3_slot0_32_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_32_13", FIELD_fld_ae3_slot0_32_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_32_14", FIELD_fld_ae3_slot0_32_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_32_15", FIELD_fld_ae3_slot0_32_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_32_16", FIELD_fld_ae3_slot0_32_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_32_17", FIELD_fld_ae3_slot0_32_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_32_18", FIELD_fld_ae3_slot0_32_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_32_20", FIELD_fld_ae3_slot0_32_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_32_27", FIELD_fld_ae3_slot0_32_27, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_32_8", FIELD_fld_ae3_slot0_32_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_3_0", FIELD_fld_ae3_slot0_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_3_2", FIELD_fld_ae3_slot0_3_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_3_3", FIELD_fld_ae3_slot0_3_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_4_0", FIELD_fld_ae3_slot0_4_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_4_4", FIELD_fld_ae3_slot0_4_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_5_0", FIELD_fld_ae3_slot0_5_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_5_4", FIELD_fld_ae3_slot0_5_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_7_0", FIELD_fld_ae3_slot0_7_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_7_2", FIELD_fld_ae3_slot0_7_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_7_4", FIELD_fld_ae3_slot0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_7_6", FIELD_fld_ae3_slot0_7_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_8_8", FIELD_fld_ae3_slot0_8_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_9_4", FIELD_fld_ae3_slot0_9_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_9_8", FIELD_fld_ae3_slot0_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_ar_ar_s", FIELD_fld_ae_sem_dr_to_ar_ar_s, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_sb_loads_stores_iba2", FIELD_fld_ae_sem_sb_loads_stores_iba2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_23_0", FIELD_fld_ae3_slot1_23_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_23_11", FIELD_fld_ae3_slot1_23_11, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_23_12", FIELD_fld_ae3_slot1_23_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_23_13", FIELD_fld_ae3_slot1_23_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_23_15", FIELD_fld_ae3_slot1_23_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_23_16", FIELD_fld_ae3_slot1_23_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_23_17", FIELD_fld_ae3_slot1_23_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_23_19", FIELD_fld_ae3_slot1_23_19, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_23_6", FIELD_fld_ae3_slot1_23_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_23_8", FIELD_fld_ae3_slot1_23_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_23_9", FIELD_fld_ae3_slot1_23_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_3_0", FIELD_fld_ae3_slot1_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_3_1", FIELD_fld_ae3_slot1_3_1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_3_2", FIELD_fld_ae3_slot1_3_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_3_3", FIELD_fld_ae3_slot1_3_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_7_4", FIELD_fld_ae3_slot1_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_9_8", FIELD_fld_ae3_slot1_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_ARDECNORM16_ar_u", FIELD_fld_AE_ARDECNORM16_ar_u, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_11_10", FIELD_fld_ae5_slot0_11_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_11_4", FIELD_fld_ae5_slot0_11_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_11_8", FIELD_fld_ae5_slot0_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_11_9", FIELD_fld_ae5_slot0_11_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_12_10", FIELD_fld_ae5_slot0_12_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_12_4", FIELD_fld_ae5_slot0_12_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_12_6", FIELD_fld_ae5_slot0_12_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_12_8", FIELD_fld_ae5_slot0_12_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_12_9", FIELD_fld_ae5_slot0_12_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_1_0", FIELD_fld_ae5_slot0_1_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_1_1", FIELD_fld_ae5_slot0_1_1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_29_12", FIELD_fld_ae5_slot0_29_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_29_13", FIELD_fld_ae5_slot0_29_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_29_15", FIELD_fld_ae5_slot0_29_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_29_16", FIELD_fld_ae5_slot0_29_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_29_17", FIELD_fld_ae5_slot0_29_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_29_18", FIELD_fld_ae5_slot0_29_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_29_19", FIELD_fld_ae5_slot0_29_19, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_29_20", FIELD_fld_ae5_slot0_29_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_29_27", FIELD_fld_ae5_slot0_29_27, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_29_5", FIELD_fld_ae5_slot0_29_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_29_6", FIELD_fld_ae5_slot0_29_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_29_8", FIELD_fld_ae5_slot0_29_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_2_0", FIELD_fld_ae5_slot0_2_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_3_0", FIELD_fld_ae5_slot0_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_3_2", FIELD_fld_ae5_slot0_3_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_4_0", FIELD_fld_ae5_slot0_4_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_4_4", FIELD_fld_ae5_slot0_4_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_7_0", FIELD_fld_ae5_slot0_7_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_7_4", FIELD_fld_ae5_slot0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_7_7", FIELD_fld_ae5_slot0_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_8_8", FIELD_fld_ae5_slot0_8_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_lb_db_ops_ar_u", FIELD_fld_ae_sem_lb_db_ops_ar_u, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_lb_db_ops_iba", FIELD_fld_ae_sem_lb_db_ops_iba, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_rng_a", FIELD_fld_ae_sem_rng_a, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_rng_art", FIELD_fld_ae_sem_rng_art, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_rng_i2", FIELD_fld_ae_sem_rng_i2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_rng_imm2", FIELD_fld_ae_sem_rng_imm2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot1_1_0", FIELD_fld_ae5_slot1_1_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot2_14_10", FIELD_fld_ae5_slot2_14_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot2_14_14", FIELD_fld_ae5_slot2_14_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot2_14_5", FIELD_fld_ae5_slot2_14_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot2_24_0", FIELD_fld_ae5_slot2_24_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot2_24_15", FIELD_fld_ae5_slot2_24_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot2_24_17", FIELD_fld_ae5_slot2_24_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot2_24_20", FIELD_fld_ae5_slot2_24_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot2_4_0", FIELD_fld_ae5_slot2_4_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot2_9_0", FIELD_fld_ae5_slot2_9_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot2_9_5", FIELD_fld_ae5_slot2_9_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot2_9_7", FIELD_fld_ae5_slot2_9_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot0_10_10", FIELD_fld_ae6_slot0_10_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot0_15_15", FIELD_fld_ae6_slot0_15_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot0_29_10", FIELD_fld_ae6_slot0_29_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot0_29_13", FIELD_fld_ae6_slot0_29_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot0_29_14", FIELD_fld_ae6_slot0_29_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot0_29_15", FIELD_fld_ae6_slot0_29_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot0_29_18", FIELD_fld_ae6_slot0_29_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot0_29_20", FIELD_fld_ae6_slot0_29_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot0_29_5", FIELD_fld_ae6_slot0_29_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot0_4_0", FIELD_fld_ae6_slot0_4_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot0_4_4", FIELD_fld_ae6_slot0_4_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot0_7_4", FIELD_fld_ae6_slot0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot0_9_8", FIELD_fld_ae6_slot0_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot0_9_9", FIELD_fld_ae6_slot0_9_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot1_14_14", FIELD_fld_ae6_slot1_14_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot1_27_12", FIELD_fld_ae6_slot1_27_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot1_27_15", FIELD_fld_ae6_slot1_27_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot1_27_20", FIELD_fld_ae6_slot1_27_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot1_27_21", FIELD_fld_ae6_slot1_27_21, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot1_27_3", FIELD_fld_ae6_slot1_27_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot1_27_6", FIELD_fld_ae6_slot1_27_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot1_2_0", FIELD_fld_ae6_slot1_2_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot1_9_5", FIELD_fld_ae6_slot1_9_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot1_9_6", FIELD_fld_ae6_slot1_9_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot1_9_7", FIELD_fld_ae6_slot1_9_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot1_9_8", FIELD_fld_ae6_slot1_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot1_9_9", FIELD_fld_ae6_slot1_9_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot2_10_10", FIELD_fld_ae6_slot2_10_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot2_11_10", FIELD_fld_ae6_slot2_11_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot2_24_0", FIELD_fld_ae6_slot2_24_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot2_24_10", FIELD_fld_ae6_slot2_24_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot2_24_14", FIELD_fld_ae6_slot2_24_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot2_24_15", FIELD_fld_ae6_slot2_24_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot2_24_20", FIELD_fld_ae6_slot2_24_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot2_4_2", FIELD_fld_ae6_slot2_4_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot2_9_5", FIELD_fld_ae6_slot2_9_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot3_10_10", FIELD_fld_ae6_slot3_10_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot3_12_0", FIELD_fld_ae6_slot3_12_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot3_14_0", FIELD_fld_ae6_slot3_14_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot3_14_10", FIELD_fld_ae6_slot3_14_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot3_14_13", FIELD_fld_ae6_slot3_14_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot3_14_5", FIELD_fld_ae6_slot3_14_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot3_24_20", FIELD_fld_ae6_slot3_24_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot3_37_13", FIELD_fld_ae6_slot3_37_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot3_37_15", FIELD_fld_ae6_slot3_37_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot3_37_20", FIELD_fld_ae6_slot3_37_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot3_37_30", FIELD_fld_ae6_slot3_37_30, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot3_9_5", FIELD_fld_ae6_slot3_9_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot0_12_6", FIELD_fld_ae7_slot0_12_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot0_23_0", FIELD_fld_ae7_slot0_23_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot0_23_13", FIELD_fld_ae7_slot0_23_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot0_23_17", FIELD_fld_ae7_slot0_23_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot0_23_18", FIELD_fld_ae7_slot0_23_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot0_23_6", FIELD_fld_ae7_slot0_23_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot0_7_4", FIELD_fld_ae7_slot0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot0_7_6", FIELD_fld_ae7_slot0_7_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot0_7_7", FIELD_fld_ae7_slot0_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot1_12_6", FIELD_fld_ae7_slot1_12_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot1_23_0", FIELD_fld_ae7_slot1_23_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot1_23_13", FIELD_fld_ae7_slot1_23_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot1_23_17", FIELD_fld_ae7_slot1_23_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot1_23_18", FIELD_fld_ae7_slot1_23_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot1_23_6", FIELD_fld_ae7_slot1_23_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot1_7_4", FIELD_fld_ae7_slot1_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot1_7_6", FIELD_fld_ae7_slot1_7_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot1_7_7", FIELD_fld_ae7_slot1_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot2_11_0", FIELD_fld_ae7_slot2_11_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot2_14_10", FIELD_fld_ae7_slot2_14_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot2_14_5", FIELD_fld_ae7_slot2_14_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot2_36_12", FIELD_fld_ae7_slot2_36_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot2_36_15", FIELD_fld_ae7_slot2_36_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot2_36_20", FIELD_fld_ae7_slot2_36_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot2_36_25", FIELD_fld_ae7_slot2_36_25, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot2_36_30", FIELD_fld_ae7_slot2_36_30, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot2_9_5", FIELD_fld_ae7_slot2_9_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot3_10_0", FIELD_fld_ae7_slot3_10_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot3_14_10", FIELD_fld_ae7_slot3_14_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot3_14_5", FIELD_fld_ae7_slot3_14_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot3_24_10", FIELD_fld_ae7_slot3_24_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot3_35_11", FIELD_fld_ae7_slot3_35_11, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot3_35_20", FIELD_fld_ae7_slot3_35_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot3_35_25", FIELD_fld_ae7_slot3_35_25, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot3_35_30", FIELD_fld_ae7_slot3_35_30, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot3_4_0", FIELD_fld_ae7_slot3_4_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot3_9_5", FIELD_fld_ae7_slot3_9_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_0_0", FIELD_fld_ae9_slot0_0_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_12_12", FIELD_fld_ae9_slot0_12_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_12_5", FIELD_fld_ae9_slot0_12_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_12_8", FIELD_fld_ae9_slot0_12_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_17_13", FIELD_fld_ae9_slot0_17_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_17_4", FIELD_fld_ae9_slot0_17_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_17_8", FIELD_fld_ae9_slot0_17_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_27_10", FIELD_fld_ae9_slot0_27_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_27_12", FIELD_fld_ae9_slot0_27_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_27_13", FIELD_fld_ae9_slot0_27_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_27_16", FIELD_fld_ae9_slot0_27_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_27_17", FIELD_fld_ae9_slot0_27_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_27_18", FIELD_fld_ae9_slot0_27_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_27_19", FIELD_fld_ae9_slot0_27_19, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_27_20", FIELD_fld_ae9_slot0_27_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_27_22", FIELD_fld_ae9_slot0_27_22, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_27_23", FIELD_fld_ae9_slot0_27_23, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_27_3", FIELD_fld_ae9_slot0_27_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_27_8", FIELD_fld_ae9_slot0_27_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_2_0", FIELD_fld_ae9_slot0_2_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_3_0", FIELD_fld_ae9_slot0_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_7_0", FIELD_fld_ae9_slot0_7_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_7_4", FIELD_fld_ae9_slot0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_7_5", FIELD_fld_ae9_slot0_7_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_7_6", FIELD_fld_ae9_slot0_7_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_7_7", FIELD_fld_ae9_slot0_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_8_4", FIELD_fld_ae9_slot0_8_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_8_5", FIELD_fld_ae9_slot0_8_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot0_9_5", FIELD_fld_ae9_slot0_9_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot1_17_13", FIELD_fld_ae9_slot1_17_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot1_17_8", FIELD_fld_ae9_slot1_17_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot1_1_0", FIELD_fld_ae9_slot1_1_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot1_26_12", FIELD_fld_ae9_slot1_26_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot1_26_13", FIELD_fld_ae9_slot1_26_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot1_26_16", FIELD_fld_ae9_slot1_26_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot1_26_17", FIELD_fld_ae9_slot1_26_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot1_26_18", FIELD_fld_ae9_slot1_26_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot1_26_2", FIELD_fld_ae9_slot1_26_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot1_26_20", FIELD_fld_ae9_slot1_26_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot1_26_22", FIELD_fld_ae9_slot1_26_22, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot1_26_23", FIELD_fld_ae9_slot1_26_23, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot1_26_8", FIELD_fld_ae9_slot1_26_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot1_26_9", FIELD_fld_ae9_slot1_26_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot1_3_0", FIELD_fld_ae9_slot1_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot1_3_2", FIELD_fld_ae9_slot1_3_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot1_3_3", FIELD_fld_ae9_slot1_3_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot1_7_4", FIELD_fld_ae9_slot1_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot2_24_14", FIELD_fld_ae9_slot2_24_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot2_24_15", FIELD_fld_ae9_slot2_24_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot2_24_20", FIELD_fld_ae9_slot2_24_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot2_33_14", FIELD_fld_ae9_slot2_33_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot2_33_15", FIELD_fld_ae9_slot2_33_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot2_33_20", FIELD_fld_ae9_slot2_33_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot2_33_25", FIELD_fld_ae9_slot2_33_25, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot2_33_26", FIELD_fld_ae9_slot2_33_26, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot2_33_28", FIELD_fld_ae9_slot2_33_28, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot2_33_30", FIELD_fld_ae9_slot2_33_30, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot2_33_9", FIELD_fld_ae9_slot2_33_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot2_4_0", FIELD_fld_ae9_slot2_4_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot2_5_0", FIELD_fld_ae9_slot2_5_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot2_6_0", FIELD_fld_ae9_slot2_6_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot2_8_0", FIELD_fld_ae9_slot2_8_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot2_9_0", FIELD_fld_ae9_slot2_9_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot2_9_5", FIELD_fld_ae9_slot2_9_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot2_9_9", FIELD_fld_ae9_slot2_9_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_hpfma_vp", FIELD_fld_ae_sem_hpfma_vp, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_hpfma_vu", FIELD_fld_ae_sem_hpfma_vu, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spfma_vu", FIELD_fld_ae_sem_spfma_vu, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot3_19_15", FIELD_fld_ae9_slot3_19_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot3_24_20", FIELD_fld_ae9_slot3_24_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot3_31_14", FIELD_fld_ae9_slot3_31_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot3_31_15", FIELD_fld_ae9_slot3_31_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot3_31_20", FIELD_fld_ae9_slot3_31_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot3_31_25", FIELD_fld_ae9_slot3_31_25, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot3_31_26", FIELD_fld_ae9_slot3_31_26, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot3_31_28", FIELD_fld_ae9_slot3_31_28, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot3_31_7", FIELD_fld_ae9_slot3_31_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot3_4_0", FIELD_fld_ae9_slot3_4_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot3_4_3", FIELD_fld_ae9_slot3_4_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot3_4_4", FIELD_fld_ae9_slot3_4_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot3_6_0", FIELD_fld_ae9_slot3_6_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot3_9_0", FIELD_fld_ae9_slot3_9_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae9_slot3_9_5", FIELD_fld_ae9_slot3_9_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot0_17_13", FIELD_fld_ae10_slot0_17_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot0_17_4", FIELD_fld_ae10_slot0_17_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot0_17_8", FIELD_fld_ae10_slot0_17_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot0_24_0", FIELD_fld_ae10_slot0_24_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot0_24_10", FIELD_fld_ae10_slot0_24_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot0_24_12", FIELD_fld_ae10_slot0_24_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot0_24_13", FIELD_fld_ae10_slot0_24_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot0_24_16", FIELD_fld_ae10_slot0_24_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot0_24_17", FIELD_fld_ae10_slot0_24_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot0_24_18", FIELD_fld_ae10_slot0_24_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot0_24_20", FIELD_fld_ae10_slot0_24_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot0_24_8", FIELD_fld_ae10_slot0_24_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot0_3_0", FIELD_fld_ae10_slot0_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot0_7_4", FIELD_fld_ae10_slot0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot0_7_6", FIELD_fld_ae10_slot0_7_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot0_7_7", FIELD_fld_ae10_slot0_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot0_8_4", FIELD_fld_ae10_slot0_8_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot1_0_0", FIELD_fld_ae10_slot1_0_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot1_17_13", FIELD_fld_ae10_slot1_17_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot1_17_8", FIELD_fld_ae10_slot1_17_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot1_25_1", FIELD_fld_ae10_slot1_25_1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot1_25_12", FIELD_fld_ae10_slot1_25_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot1_25_13", FIELD_fld_ae10_slot1_25_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot1_25_16", FIELD_fld_ae10_slot1_25_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot1_25_17", FIELD_fld_ae10_slot1_25_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot1_25_18", FIELD_fld_ae10_slot1_25_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot1_25_20", FIELD_fld_ae10_slot1_25_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot1_25_22", FIELD_fld_ae10_slot1_25_22, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot1_25_23", FIELD_fld_ae10_slot1_25_23, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot1_25_8", FIELD_fld_ae10_slot1_25_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot1_25_9", FIELD_fld_ae10_slot1_25_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot1_3_0", FIELD_fld_ae10_slot1_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot1_3_2", FIELD_fld_ae10_slot1_3_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot1_3_3", FIELD_fld_ae10_slot1_3_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot1_7_4", FIELD_fld_ae10_slot1_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot2_24_20", FIELD_fld_ae10_slot2_24_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot2_29_20", FIELD_fld_ae10_slot2_29_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot2_29_25", FIELD_fld_ae10_slot2_29_25, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot2_34_10", FIELD_fld_ae10_slot2_34_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot2_34_14", FIELD_fld_ae10_slot2_34_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot2_34_15", FIELD_fld_ae10_slot2_34_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot2_34_20", FIELD_fld_ae10_slot2_34_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot2_34_25", FIELD_fld_ae10_slot2_34_25, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot2_34_30", FIELD_fld_ae10_slot2_34_30, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot2_34_31", FIELD_fld_ae10_slot2_34_31, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot2_34_33", FIELD_fld_ae10_slot2_34_33, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot2_4_0", FIELD_fld_ae10_slot2_4_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot2_9_0", FIELD_fld_ae10_slot2_9_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot2_9_5", FIELD_fld_ae10_slot2_9_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_hpfma_vq", FIELD_fld_ae_sem_hpfma_vq, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spfma_vq", FIELD_fld_ae_sem_spfma_vq, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot3_19_15", FIELD_fld_ae10_slot3_19_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot3_29_20", FIELD_fld_ae10_slot3_29_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot3_29_25", FIELD_fld_ae10_slot3_29_25, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot3_34_10", FIELD_fld_ae10_slot3_34_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot3_34_14", FIELD_fld_ae10_slot3_34_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot3_34_15", FIELD_fld_ae10_slot3_34_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot3_34_20", FIELD_fld_ae10_slot3_34_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot3_34_25", FIELD_fld_ae10_slot3_34_25, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot3_34_30", FIELD_fld_ae10_slot3_34_30, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot3_34_31", FIELD_fld_ae10_slot3_34_31, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot3_34_33", FIELD_fld_ae10_slot3_34_33, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot3_4_0", FIELD_fld_ae10_slot3_4_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot3_4_3", FIELD_fld_ae10_slot3_4_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot3_4_4", FIELD_fld_ae10_slot3_4_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot3_9_0", FIELD_fld_ae10_slot3_9_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae10_slot3_9_5", FIELD_fld_ae10_slot3_9_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot0_22_0", FIELD_fld_ae4_slot0_22_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot0_22_12", FIELD_fld_ae4_slot0_22_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot0_22_13", FIELD_fld_ae4_slot0_22_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot0_22_16", FIELD_fld_ae4_slot0_22_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot0_22_17", FIELD_fld_ae4_slot0_22_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot0_22_18", FIELD_fld_ae4_slot0_22_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot0_22_20", FIELD_fld_ae4_slot0_22_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot0_22_6", FIELD_fld_ae4_slot0_22_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot0_22_8", FIELD_fld_ae4_slot0_22_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot0_3_0", FIELD_fld_ae4_slot0_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot0_3_1", FIELD_fld_ae4_slot0_3_1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot0_4_4", FIELD_fld_ae4_slot0_4_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot0_7_4", FIELD_fld_ae4_slot0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot1_22_0", FIELD_fld_ae4_slot1_22_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot1_22_12", FIELD_fld_ae4_slot1_22_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot1_22_13", FIELD_fld_ae4_slot1_22_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot1_22_16", FIELD_fld_ae4_slot1_22_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot1_22_17", FIELD_fld_ae4_slot1_22_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot1_22_18", FIELD_fld_ae4_slot1_22_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot1_22_8", FIELD_fld_ae4_slot1_22_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot1_3_0", FIELD_fld_ae4_slot1_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot1_3_1", FIELD_fld_ae4_slot1_3_1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot1_7_4", FIELD_fld_ae4_slot1_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot2_23_0", FIELD_fld_ae4_slot2_23_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot2_23_12", FIELD_fld_ae4_slot2_23_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot2_23_15", FIELD_fld_ae4_slot2_23_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot2_23_17", FIELD_fld_ae4_slot2_23_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot2_23_20", FIELD_fld_ae4_slot2_23_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot2_4_0", FIELD_fld_ae4_slot2_4_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot2_9_5", FIELD_fld_ae4_slot2_9_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot3_14_10", FIELD_fld_ae4_slot3_14_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot3_19_15", FIELD_fld_ae4_slot3_19_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot3_19_19", FIELD_fld_ae4_slot3_19_19, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot3_19_5", FIELD_fld_ae4_slot3_19_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot3_27_20", FIELD_fld_ae4_slot3_27_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot3_27_25", FIELD_fld_ae4_slot3_27_25, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot3_27_3", FIELD_fld_ae4_slot3_27_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot3_2_0", FIELD_fld_ae4_slot3_2_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot3_9_0", FIELD_fld_ae4_slot3_9_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot3_9_5", FIELD_fld_ae4_slot3_9_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot4_22_0", FIELD_fld_ae4_slot4_22_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot4_22_15", FIELD_fld_ae4_slot4_22_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot4_22_20", FIELD_fld_ae4_slot4_22_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot4_9_5", FIELD_fld_ae4_slot4_9_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_11_8", FIELD_fld_Inst_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_12_12", FIELD_fld_Inst_12_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_12_8", FIELD_fld_Inst_12_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_13_8", FIELD_fld_Inst_13_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_15_12", FIELD_fld_Inst_15_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_19_17", FIELD_fld_Inst_19_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_19_18", FIELD_fld_Inst_19_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_23_12", FIELD_fld_Inst_23_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_23_16", FIELD_fld_Inst_23_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_4_4", FIELD_fld_Inst_4_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_5_4", FIELD_fld_Inst_5_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_7_4", FIELD_fld_Inst_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_7_6", FIELD_fld_Inst_7_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_7_7", FIELD_fld_Inst_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_9_8", FIELD_fld_Inst_9_8, -1, 0, 0, 0, 0, 0, 0 }
};

enum xtensa_operand_id {
  OPERAND_soffsetx4,
  OPERAND_immr,
  OPERAND_uimm12x8,
  OPERAND_simm4,
  OPERAND_arr,
  OPERAND_ars,
  OPERAND__ars_invisible,
  OPERAND_art,
  OPERAND_ar0,
  OPERAND_ar4,
  OPERAND_ar8,
  OPERAND_ar12,
  OPERAND_ars_entry,
  OPERAND_immrx4,
  OPERAND_lsi4x4,
  OPERAND_simm7,
  OPERAND_uimm6,
  OPERAND_ai4const,
  OPERAND_b4const,
  OPERAND_b4constu,
  OPERAND_immt,
  OPERAND_uimms8,
  OPERAND_uimm8,
  OPERAND_uimm8x2,
  OPERAND_uimm8x4,
  OPERAND_uimm4x16,
  OPERAND_uimmrx4,
  OPERAND_simm8,
  OPERAND_simm8x256,
  OPERAND_simm12b,
  OPERAND_msalp32,
  OPERAND_op2p1,
  OPERAND_label8,
  OPERAND_ulabel8,
  OPERAND_label12,
  OPERAND_soffset,
  OPERAND_uimm16x4,
  OPERAND_imms,
  OPERAND_imms1,
  OPERAND_bt,
  OPERAND_bs,
  OPERAND_br,
  OPERAND_bt2,
  OPERAND_bs2,
  OPERAND_br2,
  OPERAND_bt4,
  OPERAND_bs4,
  OPERAND_br4,
  OPERAND_bt8,
  OPERAND_bs8,
  OPERAND_br8,
  OPERAND_bt16,
  OPERAND_bs16,
  OPERAND_br16,
  OPERAND_brall,
  OPERAND_tp7,
  OPERAND_xt_wbr15_label,
  OPERAND_ae_uimm2x2,
  OPERAND_opnd_ae_sem_mul_nn_c0,
  OPERAND_opnd_ae_sem_mul_nn_c1,
  OPERAND_opnd_ae_sem_mul_nn_c2,
  OPERAND_opnd_ae_sem_mul_nn_c3,
  OPERAND_opnd_ae_sem_mul_nn_q0,
  OPERAND_opnd_ae_sem_mul_nn_q1,
  OPERAND_opnd_ae_sem_mul_nn_v0,
  OPERAND_opnd_ae_sem_mul_nn_v1,
  OPERAND_opnd_ae_sem_mul_nn_q2,
  OPERAND_opnd_ae_sem_mul_nn_q3,
  OPERAND_opnd_ae_sem_mul_nn_v2,
  OPERAND_opnd_ae_sem_mul_nn_v3,
  OPERAND_opnd_ae_sem_dr_to_dr_v,
  OPERAND_opnd_ae_sem_arithmetic_v,
  OPERAND_opnd_ae_sem_arithmetic_v0,
  OPERAND_opnd_ae_sem_arithmetic_v1,
  OPERAND_opnd_ae_sem_loads_stores_a,
  OPERAND_opnd_ae_sem_loads_stores_x,
  OPERAND_opnd_ae_sem_loads_stores_end,
  OPERAND_opnd_ae_sem_loads_stores_i64,
  OPERAND_opnd_ae_sem_lb_ops_iba,
  OPERAND_opnd_ae_sem_sb_loads_stores_iba,
  OPERAND_opnd_ae_sem_pks_d,
  OPERAND_opnd_ae_sem_pks_pos,
  OPERAND_opnd_ae_sem_pks_s,
  OPERAND_opnd_ae_sem_dr_to_ar_a,
  OPERAND_opnd_ae_sem_dr_to_ar_v0,
  OPERAND_opnd_ae_sem_dr_to_dr_v0,
  OPERAND_opnd_ae_sem_dr_to_ar_ab,
  OPERAND_opnd_ae_sem_dr_to_ar_ai,
  OPERAND_opnd_ae_sem_dr_to_ar_aoe,
  OPERAND_opnd_ae_sem_dr_to_dr_movi_imm,
  OPERAND_opnd_ae_sem_dr_to_dr_ds,
  OPERAND_opnd_ae_sem_dr_to_dr_v1,
  OPERAND_opnd_ae_sem_dr_to_ar_imm8,
  OPERAND_opnd_ae_sem_shift_a0,
  OPERAND_opnd_ae_sem_shift_d,
  OPERAND_opnd_ae_sem_shift_d0,
  OPERAND_opnd_ae_sem_dr_to_ar_d,
  OPERAND_opnd_ae_sem_dr_to_ar_d0,
  OPERAND_opnd_ae_sem_dr_to_ar_d1,
  OPERAND_opnd_ae_sem_dr_to_dr_imm2,
  OPERAND_opnd_ae_sem_arithmetic_ds,
  OPERAND_opnd_ae_sem_loads_stores_uu,
  OPERAND_opnd_ae_sem_loads_stores_vu,
  OPERAND_opnd_ae_sem_loads_stores_i32,
  OPERAND_opnd_ae_sem_loads_stores_v,
  OPERAND_opnd_ae_sem_loads_stores_i16,
  OPERAND_opnd_ae_sem_loads_stores_i8,
  OPERAND_opnd_ae_sem_loads_stores_i64pos,
  OPERAND_opnd_ae_sem_loads_stores_i64neg,
  OPERAND_opnd_ae_sem_loads_stores_i64half,
  OPERAND_opnd_ae_sem_loads_stores_su,
  OPERAND_opnd_ae_sem_loads_stores_v1,
  OPERAND_opnd_ae_sem_loads_stores_av,
  OPERAND_opnd_ae_sem_shift_sd,
  OPERAND_opnd_ae_sem_shift_i32,
  OPERAND_opnd_ae_sem_shift_i16,
  OPERAND_opnd_ae_sem_shift_i64,
  OPERAND_opnd_ae_sem_shift_imm8,
  OPERAND_opnd_ae_sem_shift_d1,
  OPERAND_opnd_ae_sem_shift_da,
  OPERAND_opnd_ae_sem_shift_imm32,
  OPERAND_opnd_ae_sem_shift_a,
  OPERAND_opnd_ae_sem_dr_to_dr_immed,
  OPERAND_opnd_ae_sem_arithmetic_art,
  OPERAND_opnd_ae_sem_arithmetic_va,
  OPERAND_opnd_ae_sem_arithmetic_vs,
  OPERAND_opnd_ae_sem_loads_stores_i128,
  OPERAND_opnd_ae_sem_loads_stores_av1,
  OPERAND_opnd_ae_sem_loads_stores_imm2,
  OPERAND_opnd_ae_sem_loads_stores_i3,
  OPERAND_opnd_ae_sem_rng_v0,
  OPERAND_opnd_ae_sem_rng_v1,
  OPERAND_opnd_ae_sem_reduction_sort_v,
  OPERAND_opnd_ae_sem_reduction_sort_v0,
  OPERAND_opnd_ae_sem_reduction_sort_ds,
  OPERAND_opnd_ae_sem_multiply_d0,
  OPERAND_opnd_ae_sem_multiply_d2,
  OPERAND_opnd_ae_sem_multiply_q0,
  OPERAND_opnd_ae_sem_multiply_q1,
  OPERAND_opnd_ae_sem_dr_to_dr_immed_N,
  OPERAND_opnd_ae_sem_dr_to_ar_ei,
  OPERAND_opnd_ae_sem_dr_to_ar_eo,
  OPERAND_opnd_ae_sem_multiply_acc_ep,
  OPERAND_opnd_ae_sem_arithmetic_e,
  OPERAND_opnd_ae_sem_arithmetic_ep,
  OPERAND_opnd_ae_sem_arithmetic_ep1,
  OPERAND_opnd_ae_sem_select_ss,
  OPERAND_opnd_ae_sem_select_vr,
  OPERAND_opnd_ae_sem_select_vs,
  OPERAND_opnd_ae_sem_select_vt,
  OPERAND_opnd_ae_sem_select_vu,
  OPERAND_opnd_ae_sem_select_isel,
  OPERAND_opnd_ae_sem_shift_e,
  OPERAND_opnd_ae_sem_shift_i8,
  OPERAND_opnd_ae_sem_multiply_d1,
  OPERAND_opnd_ae_sem_multiply_d3,
  OPERAND_opnd_ae_sem_dr_to_dr_imm,
  OPERAND_opnd_ae_sem_rng_d,
  OPERAND_opnd_ae_sem_sb_loads_stores_iba2,
  OPERAND_opnd_ae_sem_dr_to_ar_ar_s,
  OPERAND_opnd_AE_ARDECNORM16_ar_u,
  OPERAND_opnd_ae_sem_rng_a,
  OPERAND_opnd_ae_sem_rng_art,
  OPERAND_opnd_ae_sem_rng_i2,
  OPERAND_opnd_ae_sem_rng_imm2,
  OPERAND_opnd_ae_sem_lb_db_ops_ar_u,
  OPERAND_opnd_ae_sem_lb_db_ops_iba,
  OPERAND_opnd_ae_sem_dr_to_ar_vr,
  OPERAND_opnd_ae_sem_spmisc_brt,
  OPERAND_opnd_ae_sem_spmisc_vr,
  OPERAND_opnd_ae_sem_spmisc_vs,
  OPERAND_opnd_ae_sem_dr_to_dr_arr,
  OPERAND_opnd_ae_sem_dr_to_dr_bt,
  OPERAND_opnd_ae_sem_sp32cvt_art,
  OPERAND_opnd_ae_sem_sp32cvt_i_imm5,
  OPERAND_opnd_ae_sem_sp32cvt_vr,
  OPERAND_opnd_ae_sem_sp32cvt_vt,
  OPERAND_opnd_ae_sem_sp32cvt_arr,
  OPERAND_opnd_ae_sem_movfpstate_v,
  OPERAND_opnd_ae_sem_fpmov_vr,
  OPERAND_opnd_ae_sem_fpmov_vt,
  OPERAND_opnd_ae_sem_fpmov_i_imm4,
  OPERAND_opnd_ae_sem_fpmov_vs,
  OPERAND_opnd_ae_sem_fpmov_vu,
  OPERAND_opnd_ae_sem_spmisc_vsM,
  OPERAND_opnd_ae_sem_spmisc_vtM,
  OPERAND_opnd_ae_sem_spmisc_vt,
  OPERAND_opnd_ae_sem_spaddsub_vr,
  OPERAND_opnd_ae_sem_spaddsub_vs,
  OPERAND_opnd_ae_sem_spaddsub_vt,
  OPERAND_opnd_ae_sem_spaddsub_vu,
  OPERAND_opnd_ae_sem_spfma_vr,
  OPERAND_opnd_ae_sem_spfma_vs,
  OPERAND_opnd_ae_sem_spfma_vt,
  OPERAND_opnd_ae_sem_spfma_vp,
  OPERAND_opnd_ae_sem_spfma_i_imm1,
  OPERAND_opnd_ae_sem_spfma_i_imm3,
  OPERAND_opnd_ae_sem_spaddsub_vp,
  OPERAND_opnd_ae_sem_spaddsub_vq,
  OPERAND_opnd_ae_sem_spfma_vu,
  OPERAND_opnd_ae_sem_spfma_vq,
  OPERAND_opnd_ae_sem_hprminmaxnum_vr,
  OPERAND_opnd_ae_sem_hprminmaxnum_vt,
  OPERAND_opnd_ae_sem_hpcmp_br4t,
  OPERAND_opnd_ae_sem_hpcmp_vr,
  OPERAND_opnd_ae_sem_hpcmp_vs,
  OPERAND_opnd_ae_sem_hpcnv_art,
  OPERAND_opnd_ae_sem_hpcnv_i_imm4,
  OPERAND_opnd_ae_sem_hpcnv_vr,
  OPERAND_opnd_ae_sem_hpcnv_arr,
  OPERAND_opnd_ae_sem_hpcnv_vt,
  OPERAND_opnd_ae_sem_hpcmp_vt,
  OPERAND_opnd_ae_sem_hpcnv_vs,
  OPERAND_opnd_ae_sem_hpfma_vr,
  OPERAND_opnd_ae_sem_hpfma_vs,
  OPERAND_opnd_ae_sem_hpfma_vt,
  OPERAND_opnd_ae_sem_hpfma_vp,
  OPERAND_opnd_ae_sem_hpfma_vu,
  OPERAND_opnd_ae_sem_hpfma_vq,
  OPERAND_bbi,
  OPERAND_sae,
  OPERAND_sas,
  OPERAND_sargt,
  OPERAND_s,
  OPERAND_t,
  OPERAND_bbi4,
  OPERAND_imm12,
  OPERAND_imm8,
  OPERAND_s8,
  OPERAND_imms8,
  OPERAND_imm12b,
  OPERAND_imm16,
  OPERAND_m,
  OPERAND_n,
  OPERAND_offset,
  OPERAND_op0,
  OPERAND_op1,
  OPERAND_op2,
  OPERAND_r,
  OPERAND_r_disp,
  OPERAND_r_3,
  OPERAND_sa4,
  OPERAND_sae4,
  OPERAND_sal,
  OPERAND_sas4,
  OPERAND_sr,
  OPERAND_st,
  OPERAND_thi3,
  OPERAND_imm4,
  OPERAND_mn,
  OPERAND_i,
  OPERAND_imm6lo,
  OPERAND_imm6hi,
  OPERAND_imm7lo,
  OPERAND_imm7hi,
  OPERAND_z,
  OPERAND_imm6,
  OPERAND_imm7,
  OPERAND_t2,
  OPERAND_s2,
  OPERAND_r2,
  OPERAND_t4,
  OPERAND_s4,
  OPERAND_r4,
  OPERAND_t8,
  OPERAND_r8,
  OPERAND_xt_wbr15_imm,
  OPERAND_ae_fld_Inst16b_12,
  OPERAND_ae_fld_Inst16b_15_13,
  OPERAND_fld_ae8_slot0_13_12,
  OPERAND_fld_ae8_slot0_13_13,
  OPERAND_fld_ae8_slot0_13_4,
  OPERAND_fld_ae8_slot0_13_9,
  OPERAND_fld_ae8_slot0_17_4,
  OPERAND_fld_ae8_slot0_17_8,
  OPERAND_fld_ae8_slot0_31_12,
  OPERAND_fld_ae8_slot0_31_15,
  OPERAND_fld_ae8_slot0_31_18,
  OPERAND_fld_ae8_slot0_31_19,
  OPERAND_fld_ae8_slot0_31_20,
  OPERAND_fld_ae8_slot0_31_21,
  OPERAND_fld_ae8_slot0_31_22,
  OPERAND_fld_ae8_slot0_31_23,
  OPERAND_fld_ae8_slot0_31_7,
  OPERAND_fld_ae8_slot0_31_8,
  OPERAND_fld_ae8_slot0_31_9,
  OPERAND_fld_ae8_slot0_3_0,
  OPERAND_fld_ae8_slot0_6_0,
  OPERAND_fld_ae8_slot0_7_4,
  OPERAND_fld_ae8_slot0_7_5,
  OPERAND_fld_ae8_slot0_7_7,
  OPERAND_fld_ae8_slot0_8_0,
  OPERAND_fld_ae_sem_arithmetic_v,
  OPERAND_fld_ae_sem_arithmetic_v0,
  OPERAND_fld_ae_sem_arithmetic_v1,
  OPERAND_fld_ae_sem_dr_to_dr_immed,
  OPERAND_fld_ae_sem_dr_to_dr_v,
  OPERAND_fld_ae_sem_dr_to_dr_v0,
  OPERAND_fld_ae_sem_dr_to_dr_v1,
  OPERAND_fld_ae_sem_loads_stores_a,
  OPERAND_fld_ae_sem_loads_stores_av,
  OPERAND_fld_ae_sem_loads_stores_av1,
  OPERAND_fld_ae_sem_loads_stores_i128,
  OPERAND_fld_ae_sem_loads_stores_i16,
  OPERAND_fld_ae_sem_loads_stores_i3,
  OPERAND_fld_ae_sem_loads_stores_i32,
  OPERAND_fld_ae_sem_loads_stores_i64,
  OPERAND_fld_ae_sem_loads_stores_i64pos,
  OPERAND_fld_ae_sem_loads_stores_i8,
  OPERAND_fld_ae_sem_loads_stores_imm2,
  OPERAND_fld_ae_sem_loads_stores_su,
  OPERAND_fld_ae_sem_loads_stores_uu,
  OPERAND_fld_ae_sem_loads_stores_v,
  OPERAND_fld_ae_sem_loads_stores_v1,
  OPERAND_fld_ae_sem_loads_stores_x,
  OPERAND_fld_ae_sem_shift_a0,
  OPERAND_fld_ae_sem_shift_d,
  OPERAND_fld_ae_sem_shift_d0,
  OPERAND_fld_ae_sem_shift_i16,
  OPERAND_fld_ae_sem_shift_i32,
  OPERAND_fld_ae_sem_shift_i64,
  OPERAND_fld_ae_sem_shift_sd,
  OPERAND_fld_ae8_slot1_17_13,
  OPERAND_fld_ae8_slot1_17_14,
  OPERAND_fld_ae8_slot1_17_15,
  OPERAND_fld_ae8_slot1_17_8,
  OPERAND_fld_ae8_slot1_29_12,
  OPERAND_fld_ae8_slot1_29_13,
  OPERAND_fld_ae8_slot1_29_18,
  OPERAND_fld_ae8_slot1_29_20,
  OPERAND_fld_ae8_slot1_29_22,
  OPERAND_fld_ae8_slot1_29_23,
  OPERAND_fld_ae8_slot1_29_5,
  OPERAND_fld_ae8_slot1_29_8,
  OPERAND_fld_ae8_slot1_29_9,
  OPERAND_fld_ae8_slot1_3_0,
  OPERAND_fld_ae8_slot1_3_3,
  OPERAND_fld_ae8_slot1_4_0,
  OPERAND_fld_ae8_slot1_7_4,
  OPERAND_fld_ae8_slot2_19_10,
  OPERAND_fld_ae8_slot2_19_15,
  OPERAND_fld_ae8_slot2_33_15,
  OPERAND_fld_ae8_slot2_33_25,
  OPERAND_fld_ae8_slot2_33_9,
  OPERAND_fld_ae8_slot2_34_30,
  OPERAND_fld_ae8_slot2_39_35,
  OPERAND_fld_ae8_slot2_44_35,
  OPERAND_fld_ae8_slot2_58_34,
  OPERAND_fld_ae8_slot2_58_35,
  OPERAND_fld_ae8_slot2_58_40,
  OPERAND_fld_ae8_slot2_58_50,
  OPERAND_fld_ae8_slot2_8_0,
  OPERAND_fld_ae8_slot2_9_0,
  OPERAND_fld_ae_sem_mul_nn_c0,
  OPERAND_fld_ae_sem_mul_nn_c1,
  OPERAND_fld_ae_sem_mul_nn_c2,
  OPERAND_fld_ae_sem_mul_nn_c3,
  OPERAND_fld_ae_sem_mul_nn_q0,
  OPERAND_fld_ae_sem_mul_nn_q1,
  OPERAND_fld_ae_sem_mul_nn_q2,
  OPERAND_fld_ae_sem_mul_nn_q3,
  OPERAND_fld_ae_sem_mul_nn_v0,
  OPERAND_fld_ae_sem_mul_nn_v1,
  OPERAND_fld_ae_sem_mul_nn_v2,
  OPERAND_fld_ae_sem_mul_nn_v3,
  OPERAND_fld_ae_sem_arithmetic_art,
  OPERAND_fld_ae_sem_arithmetic_ds,
  OPERAND_fld_ae_sem_arithmetic_va,
  OPERAND_fld_ae_sem_arithmetic_vs,
  OPERAND_fld_ae_sem_dr_to_ar_a,
  OPERAND_fld_ae_sem_dr_to_ar_ab,
  OPERAND_fld_ae_sem_dr_to_ar_ai,
  OPERAND_fld_ae_sem_dr_to_ar_aoe,
  OPERAND_fld_ae_sem_dr_to_ar_d,
  OPERAND_fld_ae_sem_dr_to_ar_d0,
  OPERAND_fld_ae_sem_dr_to_ar_d1,
  OPERAND_fld_ae_sem_dr_to_ar_imm8,
  OPERAND_fld_ae_sem_dr_to_ar_v0,
  OPERAND_fld_ae_sem_dr_to_ar_vr,
  OPERAND_fld_ae_sem_dr_to_dr_arr,
  OPERAND_fld_ae_sem_dr_to_dr_bt,
  OPERAND_fld_ae_sem_dr_to_dr_ds,
  OPERAND_fld_ae_sem_dr_to_dr_imm2,
  OPERAND_fld_ae_sem_dr_to_dr_movi_imm,
  OPERAND_fld_ae_sem_hpcmp_br4t,
  OPERAND_fld_ae_sem_hpcmp_vr,
  OPERAND_fld_ae_sem_hpcmp_vs,
  OPERAND_fld_ae_sem_hpcnv_arr,
  OPERAND_fld_ae_sem_hpcnv_art,
  OPERAND_fld_ae_sem_hpcnv_i_imm4,
  OPERAND_fld_ae_sem_hpcnv_vr,
  OPERAND_fld_ae_sem_hpcnv_vt,
  OPERAND_fld_ae_sem_hprminmaxnum_vr,
  OPERAND_fld_ae_sem_hprminmaxnum_vt,
  OPERAND_fld_ae_sem_lb_ops_iba,
  OPERAND_fld_ae_sem_loads_stores_end,
  OPERAND_fld_ae_sem_loads_stores_i64half,
  OPERAND_fld_ae_sem_loads_stores_i64neg,
  OPERAND_fld_ae_sem_loads_stores_vu,
  OPERAND_fld_ae_sem_pks_d,
  OPERAND_fld_ae_sem_pks_pos,
  OPERAND_fld_ae_sem_pks_s,
  OPERAND_fld_ae_sem_rng_v0,
  OPERAND_fld_ae_sem_rng_v1,
  OPERAND_fld_ae_sem_sb_loads_stores_iba,
  OPERAND_fld_ae_sem_shift_a,
  OPERAND_fld_ae_sem_shift_d1,
  OPERAND_fld_ae_sem_shift_da,
  OPERAND_fld_ae_sem_shift_imm32,
  OPERAND_fld_ae_sem_shift_imm8,
  OPERAND_fld_ae_sem_sp32cvt_arr,
  OPERAND_fld_ae_sem_sp32cvt_art,
  OPERAND_fld_ae_sem_sp32cvt_i_imm5,
  OPERAND_fld_ae_sem_sp32cvt_vr,
  OPERAND_fld_ae_sem_sp32cvt_vt,
  OPERAND_fld_ae_sem_spmisc_brt,
  OPERAND_fld_ae_sem_spmisc_vr,
  OPERAND_fld_ae_sem_spmisc_vs,
  OPERAND_fld_ae_slot0_11_10,
  OPERAND_fld_ae_slot0_11_11,
  OPERAND_fld_ae_slot0_11_8,
  OPERAND_fld_ae_slot0_11_9,
  OPERAND_fld_ae_slot0_12_0,
  OPERAND_fld_ae_slot0_12_10,
  OPERAND_fld_ae_slot0_12_12,
  OPERAND_fld_ae_slot0_12_2,
  OPERAND_fld_ae_slot0_12_6,
  OPERAND_fld_ae_slot0_12_8,
  OPERAND_fld_ae_slot0_12_9,
  OPERAND_fld_ae_slot0_14_12,
  OPERAND_fld_ae_slot0_14_13,
  OPERAND_fld_ae_slot0_17_10,
  OPERAND_fld_ae_slot0_17_12,
  OPERAND_fld_ae_slot0_17_13,
  OPERAND_fld_ae_slot0_17_14,
  OPERAND_fld_ae_slot0_17_15,
  OPERAND_fld_ae_slot0_17_16,
  OPERAND_fld_ae_slot0_17_17,
  OPERAND_fld_ae_slot0_17_8,
  OPERAND_fld_ae_slot0_18_13,
  OPERAND_fld_ae_slot0_18_15,
  OPERAND_fld_ae_slot0_18_16,
  OPERAND_fld_ae_slot0_18_8,
  OPERAND_fld_ae_slot0_19_12,
  OPERAND_fld_ae_slot0_19_15,
  OPERAND_fld_ae_slot0_19_19,
  OPERAND_fld_ae_slot0_19_8,
  OPERAND_fld_ae_slot0_1_0,
  OPERAND_fld_ae_slot0_20_16,
  OPERAND_fld_ae_slot0_20_20,
  OPERAND_fld_ae_slot0_23_15,
  OPERAND_fld_ae_slot0_23_17,
  OPERAND_fld_ae_slot0_23_19,
  OPERAND_fld_ae_slot0_23_22,
  OPERAND_fld_ae_slot0_28_10,
  OPERAND_fld_ae_slot0_28_12,
  OPERAND_fld_ae_slot0_28_14,
  OPERAND_fld_ae_slot0_28_15,
  OPERAND_fld_ae_slot0_28_16,
  OPERAND_fld_ae_slot0_28_17,
  OPERAND_fld_ae_slot0_28_19,
  OPERAND_fld_ae_slot0_28_21,
  OPERAND_fld_ae_slot0_28_22,
  OPERAND_fld_ae_slot0_28_24,
  OPERAND_fld_ae_slot0_28_26,
  OPERAND_fld_ae_slot0_28_27,
  OPERAND_fld_ae_slot0_28_4,
  OPERAND_fld_ae_slot0_28_8,
  OPERAND_fld_ae_slot0_3_0,
  OPERAND_fld_ae_slot0_3_1,
  OPERAND_fld_ae_slot0_3_2,
  OPERAND_fld_ae_slot0_3_3,
  OPERAND_fld_ae_slot0_4_0,
  OPERAND_fld_ae_slot0_4_4,
  OPERAND_fld_ae_slot0_5_0,
  OPERAND_fld_ae_slot0_5_4,
  OPERAND_fld_ae_slot0_7_0,
  OPERAND_fld_ae_slot0_7_2,
  OPERAND_fld_ae_slot0_7_3,
  OPERAND_fld_ae_slot0_7_4,
  OPERAND_fld_ae_slot0_8_8,
  OPERAND_fld_ae_slot0_9_4,
  OPERAND_fld_ae_slot0_9_8,
  OPERAND_fld_ae_slot0_9_9,
  OPERAND_fld_ae_slot1_0_0,
  OPERAND_fld_ae_slot1_12_8,
  OPERAND_fld_ae_slot1_17_13,
  OPERAND_fld_ae_slot1_17_17,
  OPERAND_fld_ae_slot1_17_8,
  OPERAND_fld_ae_slot1_25_1,
  OPERAND_fld_ae_slot1_25_12,
  OPERAND_fld_ae_slot1_25_13,
  OPERAND_fld_ae_slot1_25_16,
  OPERAND_fld_ae_slot1_25_17,
  OPERAND_fld_ae_slot1_25_18,
  OPERAND_fld_ae_slot1_25_20,
  OPERAND_fld_ae_slot1_25_22,
  OPERAND_fld_ae_slot1_25_23,
  OPERAND_fld_ae_slot1_25_8,
  OPERAND_fld_ae_slot1_25_9,
  OPERAND_fld_ae_slot1_3_0,
  OPERAND_fld_ae_slot1_3_2,
  OPERAND_fld_ae_slot1_3_3,
  OPERAND_fld_ae_slot1_7_4,
  OPERAND_fld_ae_sem_arithmetic_e,
  OPERAND_fld_ae_sem_arithmetic_ep,
  OPERAND_fld_ae_sem_arithmetic_ep1,
  OPERAND_fld_ae_sem_dr_to_ar_ei,
  OPERAND_fld_ae_sem_dr_to_ar_eo,
  OPERAND_fld_ae_sem_dr_to_dr_immed_N,
  OPERAND_fld_ae_sem_fpmov_i_imm4,
  OPERAND_fld_ae_sem_fpmov_vr,
  OPERAND_fld_ae_sem_fpmov_vs,
  OPERAND_fld_ae_sem_fpmov_vt,
  OPERAND_fld_ae_sem_fpmov_vu,
  OPERAND_fld_ae_sem_hpcmp_vt,
  OPERAND_fld_ae_sem_hpcnv_vs,
  OPERAND_fld_ae_sem_hpfma_vr,
  OPERAND_fld_ae_sem_hpfma_vs,
  OPERAND_fld_ae_sem_hpfma_vt,
  OPERAND_fld_ae_sem_movfpstate_v,
  OPERAND_fld_ae_sem_multiply_acc_ep,
  OPERAND_fld_ae_sem_multiply_d0,
  OPERAND_fld_ae_sem_multiply_d2,
  OPERAND_fld_ae_sem_multiply_q0,
  OPERAND_fld_ae_sem_multiply_q1,
  OPERAND_fld_ae_sem_reduction_sort_ds,
  OPERAND_fld_ae_sem_reduction_sort_v,
  OPERAND_fld_ae_sem_reduction_sort_v0,
  OPERAND_fld_ae_sem_select_isel,
  OPERAND_fld_ae_sem_select_ss,
  OPERAND_fld_ae_sem_select_vr,
  OPERAND_fld_ae_sem_select_vs,
  OPERAND_fld_ae_sem_select_vt,
  OPERAND_fld_ae_sem_select_vu,
  OPERAND_fld_ae_sem_spaddsub_vr,
  OPERAND_fld_ae_sem_spaddsub_vs,
  OPERAND_fld_ae_sem_spaddsub_vt,
  OPERAND_fld_ae_sem_spaddsub_vu,
  OPERAND_fld_ae_sem_spfma_i_imm1,
  OPERAND_fld_ae_sem_spfma_i_imm3,
  OPERAND_fld_ae_sem_spfma_vp,
  OPERAND_fld_ae_sem_spfma_vr,
  OPERAND_fld_ae_sem_spfma_vs,
  OPERAND_fld_ae_sem_spfma_vt,
  OPERAND_fld_ae_sem_spmisc_vsM,
  OPERAND_fld_ae_sem_spmisc_vt,
  OPERAND_fld_ae_sem_spmisc_vtM,
  OPERAND_fld_ae_slot2_14_0,
  OPERAND_fld_ae_slot2_14_10,
  OPERAND_fld_ae_slot2_14_14,
  OPERAND_fld_ae_slot2_14_5,
  OPERAND_fld_ae_slot2_16_15,
  OPERAND_fld_ae_slot2_19_15,
  OPERAND_fld_ae_slot2_28_15,
  OPERAND_fld_ae_slot2_28_17,
  OPERAND_fld_ae_slot2_28_19,
  OPERAND_fld_ae_slot2_28_20,
  OPERAND_fld_ae_slot2_28_25,
  OPERAND_fld_ae_slot2_28_4,
  OPERAND_fld_ae_slot2_28_5,
  OPERAND_fld_ae_slot2_3_0,
  OPERAND_fld_ae_slot2_9_0,
  OPERAND_fld_ae_slot2_9_1,
  OPERAND_fld_ae_slot2_9_2,
  OPERAND_fld_ae_slot2_9_5,
  OPERAND_fld_ae_slot2_9_6,
  OPERAND_fld_ae_slot2_9_7,
  OPERAND_fld_ae_slot2_9_8,
  OPERAND_fld_ae_sem_dr_to_dr_imm,
  OPERAND_fld_ae_sem_multiply_d1,
  OPERAND_fld_ae_sem_multiply_d3,
  OPERAND_fld_ae_sem_rng_d,
  OPERAND_fld_ae_sem_shift_e,
  OPERAND_fld_ae_sem_shift_i8,
  OPERAND_fld_ae_slot3_11_0,
  OPERAND_fld_ae_slot3_14_0,
  OPERAND_fld_ae_slot3_14_10,
  OPERAND_fld_ae_slot3_14_12,
  OPERAND_fld_ae_slot3_14_13,
  OPERAND_fld_ae_slot3_16_13,
  OPERAND_fld_ae_slot3_19_0,
  OPERAND_fld_ae_slot3_19_10,
  OPERAND_fld_ae_slot3_19_15,
  OPERAND_fld_ae_slot3_19_17,
  OPERAND_fld_ae_slot3_19_18,
  OPERAND_fld_ae_slot3_19_19,
  OPERAND_fld_ae_slot3_24_10,
  OPERAND_fld_ae_slot3_24_19,
  OPERAND_fld_ae_slot3_24_20,
  OPERAND_fld_ae_slot3_36_12,
  OPERAND_fld_ae_slot3_36_16,
  OPERAND_fld_ae_slot3_36_19,
  OPERAND_fld_ae_slot3_36_20,
  OPERAND_fld_ae_slot3_36_22,
  OPERAND_fld_ae_slot3_36_25,
  OPERAND_fld_ae_slot3_36_30,
  OPERAND_fld_ae_slot3_4_0,
  OPERAND_fld_ae_slot3_9_0,
  OPERAND_fld_ae_slot3_9_1,
  OPERAND_fld_ae_slot3_9_3,
  OPERAND_fld_ae_slot3_9_5,
  OPERAND_fld_ae2_slot0_0_0,
  OPERAND_fld_ae2_slot0_11_4,
  OPERAND_fld_ae2_slot0_11_8,
  OPERAND_fld_ae2_slot0_11_9,
  OPERAND_fld_ae2_slot0_12_0,
  OPERAND_fld_ae2_slot0_12_2,
  OPERAND_fld_ae2_slot0_12_4,
  OPERAND_fld_ae2_slot0_12_8,
  OPERAND_fld_ae2_slot0_14_13,
  OPERAND_fld_ae2_slot0_14_8,
  OPERAND_fld_ae2_slot0_15_0,
  OPERAND_fld_ae2_slot0_15_12,
  OPERAND_fld_ae2_slot0_15_13,
  OPERAND_fld_ae2_slot0_15_15,
  OPERAND_fld_ae2_slot0_15_4,
  OPERAND_fld_ae2_slot0_15_8,
  OPERAND_fld_ae2_slot0_17_13,
  OPERAND_fld_ae2_slot0_17_17,
  OPERAND_fld_ae2_slot0_18_15,
  OPERAND_fld_ae2_slot0_18_17,
  OPERAND_fld_ae2_slot0_18_18,
  OPERAND_fld_ae2_slot0_1_0,
  OPERAND_fld_ae2_slot0_23_18,
  OPERAND_fld_ae2_slot0_23_19,
  OPERAND_fld_ae2_slot0_3_0,
  OPERAND_fld_ae2_slot0_40_16,
  OPERAND_fld_ae2_slot0_40_17,
  OPERAND_fld_ae2_slot0_40_18,
  OPERAND_fld_ae2_slot0_40_19,
  OPERAND_fld_ae2_slot0_40_21,
  OPERAND_fld_ae2_slot0_40_23,
  OPERAND_fld_ae2_slot0_40_24,
  OPERAND_fld_ae2_slot0_40_25,
  OPERAND_fld_ae2_slot0_40_26,
  OPERAND_fld_ae2_slot0_40_27,
  OPERAND_fld_ae2_slot0_7_0,
  OPERAND_fld_ae2_slot0_7_4,
  OPERAND_fld_ae2_slot0_7_6,
  OPERAND_fld_ae2_slot0_7_7,
  OPERAND_fld_ae2_slot0_8_8,
  OPERAND_fld_ae2_slot0_9_8,
  OPERAND_fld_ae2_slot1_0_0,
  OPERAND_fld_ae2_slot1_11_0,
  OPERAND_fld_ae2_slot1_11_10,
  OPERAND_fld_ae2_slot1_11_8,
  OPERAND_fld_ae2_slot1_14_10,
  OPERAND_fld_ae2_slot1_14_11,
  OPERAND_fld_ae2_slot1_14_12,
  OPERAND_fld_ae2_slot1_14_14,
  OPERAND_fld_ae2_slot1_14_8,
  OPERAND_fld_ae2_slot1_36_12,
  OPERAND_fld_ae2_slot1_36_14,
  OPERAND_fld_ae2_slot1_36_15,
  OPERAND_fld_ae2_slot1_36_16,
  OPERAND_fld_ae2_slot1_36_17,
  OPERAND_fld_ae2_slot1_36_18,
  OPERAND_fld_ae2_slot1_36_20,
  OPERAND_fld_ae2_slot1_36_22,
  OPERAND_fld_ae2_slot1_36_23,
  OPERAND_fld_ae2_slot1_3_0,
  OPERAND_fld_ae2_slot1_3_1,
  OPERAND_fld_ae2_slot1_3_2,
  OPERAND_fld_ae2_slot1_3_3,
  OPERAND_fld_ae2_slot1_7_4,
  OPERAND_fld_ae2_slot1_9_8,
  OPERAND_fld_ae2_slot1_9_9,
  OPERAND_fld_ae2_slot2_14_10,
  OPERAND_fld_ae2_slot2_17_0,
  OPERAND_fld_ae2_slot2_17_10,
  OPERAND_fld_ae2_slot2_17_15,
  OPERAND_fld_ae2_slot2_17_17,
  OPERAND_fld_ae2_slot2_19_10,
  OPERAND_fld_ae2_slot2_19_15,
  OPERAND_fld_ae2_slot2_19_18,
  OPERAND_fld_ae2_slot2_19_9,
  OPERAND_fld_ae2_slot2_24_10,
  OPERAND_fld_ae2_slot2_24_15,
  OPERAND_fld_ae2_slot2_24_20,
  OPERAND_fld_ae2_slot2_24_5,
  OPERAND_fld_ae2_slot2_24_9,
  OPERAND_fld_ae2_slot2_42_18,
  OPERAND_fld_ae2_slot2_42_20,
  OPERAND_fld_ae2_slot2_42_25,
  OPERAND_fld_ae2_slot2_42_26,
  OPERAND_fld_ae2_slot2_42_28,
  OPERAND_fld_ae2_slot2_42_30,
  OPERAND_fld_ae2_slot2_4_0,
  OPERAND_fld_ae2_slot2_9_5,
  OPERAND_fld_ae_sem_spaddsub_vp,
  OPERAND_fld_ae_sem_spaddsub_vq,
  OPERAND_fld_ae3_slot0_11_11,
  OPERAND_fld_ae3_slot0_11_4,
  OPERAND_fld_ae3_slot0_11_8,
  OPERAND_fld_ae3_slot0_12_12,
  OPERAND_fld_ae3_slot0_12_8,
  OPERAND_fld_ae3_slot0_13_13,
  OPERAND_fld_ae3_slot0_13_8,
  OPERAND_fld_ae3_slot0_1_0,
  OPERAND_fld_ae3_slot0_32_11,
  OPERAND_fld_ae3_slot0_32_12,
  OPERAND_fld_ae3_slot0_32_13,
  OPERAND_fld_ae3_slot0_32_14,
  OPERAND_fld_ae3_slot0_32_15,
  OPERAND_fld_ae3_slot0_32_16,
  OPERAND_fld_ae3_slot0_32_17,
  OPERAND_fld_ae3_slot0_32_18,
  OPERAND_fld_ae3_slot0_32_20,
  OPERAND_fld_ae3_slot0_