/* Xtensa configuration-specific ISA information.

   Copyright (c) 2003-2019 Tensilica Inc.

   Permission is hereby granted, free of charge, to any person obtaining
   a copy of this software and associated documentation files (the
   "Software"), to deal in the Software without restriction, including
   without limitation the rights to use, copy, modify, merge, publish,
   distribute, sublicense, and/or sell copies of the Software, and to
   permit persons to whom the Software is furnished to do so, subject to
   the following conditions:

   The above copyright notice and this permission notice shall be included
   in all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
   CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
   TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
   SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.  */

#include "ansidecl.h"
#include <xtensa-isa.h>
#include "xtensa-isa-internal.h"


/* Sysregs.  */

static xtensa_sysreg_internal sysregs[] = {
  { "LBEG", 0, 0 },
  { "LEND", 1, 0 },
  { "LCOUNT", 2, 0 },
  { "BR", 4, 0 },
  { "MMID", 89, 0 },
  { "DDR", 104, 0 },
  { "CONFIGID0", 176, 0 },
  { "CONFIGID1", 208, 0 },
  { "INTERRUPT", 226, 0 },
  { "INTCLEAR", 227, 0 },
  { "CCOUNT", 234, 0 },
  { "PRID", 235, 0 },
  { "ICOUNT", 236, 0 },
  { "CCOMPARE0", 240, 0 },
  { "CCOMPARE1", 241, 0 },
  { "CCOMPARE2", 242, 0 },
  { "VECBASE", 231, 0 },
  { "EPC1", 177, 0 },
  { "EPC2", 178, 0 },
  { "EPC3", 179, 0 },
  { "EPC4", 180, 0 },
  { "EPC5", 181, 0 },
  { "EPC6", 182, 0 },
  { "EPC7", 183, 0 },
  { "EXCSAVE1", 209, 0 },
  { "EXCSAVE2", 210, 0 },
  { "EXCSAVE3", 211, 0 },
  { "EXCSAVE4", 212, 0 },
  { "EXCSAVE5", 213, 0 },
  { "EXCSAVE6", 214, 0 },
  { "EXCSAVE7", 215, 0 },
  { "EPS2", 194, 0 },
  { "EPS3", 195, 0 },
  { "EPS4", 196, 0 },
  { "EPS5", 197, 0 },
  { "EPS6", 198, 0 },
  { "EPS7", 199, 0 },
  { "EXCCAUSE", 232, 0 },
  { "DEPC", 192, 0 },
  { "EXCVADDR", 238, 0 },
  { "WINDOWBASE", 72, 0 },
  { "WINDOWSTART", 73, 0 },
  { "MECR", 110, 0 },
  { "MEPC", 106, 0 },
  { "MEPS", 107, 0 },
  { "MESAVE", 108, 0 },
  { "MEVADDR", 111, 0 },
  { "MESR", 109, 0 },
  { "MEMCTL", 97, 0 },
  { "SAR", 3, 0 },
  { "PS", 230, 0 },
  { "INTENABLE", 228, 0 },
  { "DBREAKA0", 144, 0 },
  { "DBREAKC0", 160, 0 },
  { "DBREAKA1", 145, 0 },
  { "DBREAKC1", 161, 0 },
  { "IBREAKA0", 128, 0 },
  { "IBREAKA1", 129, 0 },
  { "IBREAKENABLE", 96, 0 },
  { "ICOUNTLEVEL", 237, 0 },
  { "DEBUGCAUSE", 233, 0 },
  { "PREFCTL", 40, 0 },
  { "CPENABLE", 224, 0 },
  { "SCOMPARE1", 12, 0 },
  { "ATOMCTL", 99, 0 },
  { "THREADPTR", 231, 1 },
  { "AE_OVF_SAR", 240, 1 },
  { "AE_BITHEAD", 241, 1 },
  { "AE_TS_FTS_BU_BP", 242, 1 },
  { "AE_CW_SD_NO", 243, 1 },
  { "AE_CBEGIN0", 246, 1 },
  { "AE_CEND0", 247, 1 },
  { "FCR", 232, 1 },
  { "FSR", 233, 1 }
};

#define NUM_SYSREGS 74
#define MAX_SPECIAL_REG 242
#define MAX_USER_REG 247


/* Processor states.  */

static xtensa_state_internal states[] = {
  { "LCOUNT", 32, 0 },
  { "PC", 32, 0 },
  { "ICOUNT", 32, 0 },
  { "DDR", 32, 0 },
  { "INTERRUPT", 21, 0 },
  { "CCOUNT", 32, 0 },
  { "XTSYNC", 1, 0 },
  { "VECBASE", 22, 0 },
  { "EPC1", 32, 0 },
  { "EPC2", 32, 0 },
  { "EPC3", 32, 0 },
  { "EPC4", 32, 0 },
  { "EPC5", 32, 0 },
  { "EPC6", 32, 0 },
  { "EPC7", 32, 0 },
  { "EXCSAVE1", 32, 0 },
  { "EXCSAVE2", 32, 0 },
  { "EXCSAVE3", 32, 0 },
  { "EXCSAVE4", 32, 0 },
  { "EXCSAVE5", 32, 0 },
  { "EXCSAVE6", 32, 0 },
  { "EXCSAVE7", 32, 0 },
  { "EPS2", 13, 0 },
  { "EPS3", 13, 0 },
  { "EPS4", 13, 0 },
  { "EPS5", 13, 0 },
  { "EPS6", 13, 0 },
  { "EPS7", 13, 0 },
  { "EXCCAUSE", 6, 0 },
  { "PSINTLEVEL", 4, 0 },
  { "PSUM", 1, 0 },
  { "PSWOE", 1, 0 },
  { "PSEXCM", 1, 0 },
  { "DEPC", 32, 0 },
  { "EXCVADDR", 32, 0 },
  { "WindowBase", 4, 0 },
  { "WindowStart", 16, 0 },
  { "PSCALLINC", 2, 0 },
  { "PSOWB", 4, 0 },
  { "MECR", 7, 0 },
  { "MEPC", 32, 0 },
  { "MEPS", 13, 0 },
  { "MESAVE", 32, 0 },
  { "MEVADDR", 32, 0 },
  { "MESRErrEnab", 1, 0 },
  { "MESRErrTest", 1, 0 },
  { "MESRMemE", 1, 0 },
  { "MESRDME", 1, 0 },
  { "MESRMemType", 4, 0 },
  { "MESRAccType", 2, 0 },
  { "MESRErrType", 2, 0 },
  { "MESRWay", 2, 0 },
  { "MESRDataExc", 1, 0 },
  { "MESRInstExc", 1, 0 },
  { "MESRRCE", 1, 0 },
  { "MESRDLCE", 1, 0 },
  { "MESRILCE", 1, 0 },
  { "LBEG", 32, 0 },
  { "LEND", 32, 0 },
  { "MEMCTL", 24, 0 },
  { "SAR", 6, 0 },
  { "THREADPTR", 32, 0 },
  { "InOCDMode", 1, 0 },
  { "INTENABLE", 21, 0 },
  { "DBREAKA0", 32, 0 },
  { "DBREAKC0", 8, 0 },
  { "DBREAKA1", 32, 0 },
  { "DBREAKC1", 8, 0 },
  { "IBREAKA0", 32, 0 },
  { "IBREAKA1", 32, 0 },
  { "IBREAKENABLE", 2, 0 },
  { "ICOUNTLEVEL", 4, 0 },
  { "DEBUGCAUSE", 6, 0 },
  { "DBNUM", 4, 0 },
  { "CCOMPARE0", 32, 0 },
  { "CCOMPARE1", 32, 0 },
  { "CCOMPARE2", 32, 0 },
  { "PREFCTL", 9, 0 },
  { "CPENABLE", 2, 0 },
  { "SCOMPARE1", 32, 0 },
  { "ATOMCTL", 6, 0 },
  { "AE_OVERFLOW", 1, XTENSA_STATE_IS_SHARED_OR },
  { "AE_CBEGIN0", 32, 0 },
  { "AE_CEND0", 32, 0 },
  { "AE_SAR", 7, 0 },
  { "AE_CWRAP", 1, 0 },
  { "AE_BITHEAD", 32, 0 },
  { "AE_BITPTR", 4, 0 },
  { "AE_BITSUSED", 4, 0 },
  { "AE_TABLESIZE", 4, 0 },
  { "AE_FIRST_TS", 4, 0 },
  { "AE_NEXTOFFSET", 27, 0 },
  { "AE_SEARCHDONE", 1, 0 },
  { "RoundMode", 2, 0 },
  { "InvalidEnable", 1, 0 },
  { "DivZeroEnable", 1, 0 },
  { "OverflowEnable", 1, 0 },
  { "UnderflowEnable", 1, 0 },
  { "InexactEnable", 1, 0 },
  { "InvalidFlag", 1, XTENSA_STATE_IS_SHARED_OR },
  { "DivZeroFlag", 1, XTENSA_STATE_IS_SHARED_OR },
  { "OverflowFlag", 1, XTENSA_STATE_IS_SHARED_OR },
  { "UnderflowFlag", 1, XTENSA_STATE_IS_SHARED_OR },
  { "InexactFlag", 1, XTENSA_STATE_IS_SHARED_OR },
  { "FPreserved20", 20, 0 },
  { "FPreserved20a", 20, 0 },
  { "FPreserved5", 5, 0 },
  { "FPreserved7", 7, 0 }
};

#define NUM_STATES 108

enum xtensa_state_id {
  STATE_LCOUNT,
  STATE_PC,
  STATE_ICOUNT,
  STATE_DDR,
  STATE_INTERRUPT,
  STATE_CCOUNT,
  STATE_XTSYNC,
  STATE_VECBASE,
  STATE_EPC1,
  STATE_EPC2,
  STATE_EPC3,
  STATE_EPC4,
  STATE_EPC5,
  STATE_EPC6,
  STATE_EPC7,
  STATE_EXCSAVE1,
  STATE_EXCSAVE2,
  STATE_EXCSAVE3,
  STATE_EXCSAVE4,
  STATE_EXCSAVE5,
  STATE_EXCSAVE6,
  STATE_EXCSAVE7,
  STATE_EPS2,
  STATE_EPS3,
  STATE_EPS4,
  STATE_EPS5,
  STATE_EPS6,
  STATE_EPS7,
  STATE_EXCCAUSE,
  STATE_PSINTLEVEL,
  STATE_PSUM,
  STATE_PSWOE,
  STATE_PSEXCM,
  STATE_DEPC,
  STATE_EXCVADDR,
  STATE_WindowBase,
  STATE_WindowStart,
  STATE_PSCALLINC,
  STATE_PSOWB,
  STATE_MECR,
  STATE_MEPC,
  STATE_MEPS,
  STATE_MESAVE,
  STATE_MEVADDR,
  STATE_MESRErrEnab,
  STATE_MESRErrTest,
  STATE_MESRMemE,
  STATE_MESRDME,
  STATE_MESRMemType,
  STATE_MESRAccType,
  STATE_MESRErrType,
  STATE_MESRWay,
  STATE_MESRDataExc,
  STATE_MESRInstExc,
  STATE_MESRRCE,
  STATE_MESRDLCE,
  STATE_MESRILCE,
  STATE_LBEG,
  STATE_LEND,
  STATE_MEMCTL,
  STATE_SAR,
  STATE_THREADPTR,
  STATE_InOCDMode,
  STATE_INTENABLE,
  STATE_DBREAKA0,
  STATE_DBREAKC0,
  STATE_DBREAKA1,
  STATE_DBREAKC1,
  STATE_IBREAKA0,
  STATE_IBREAKA1,
  STATE_IBREAKENABLE,
  STATE_ICOUNTLEVEL,
  STATE_DEBUGCAUSE,
  STATE_DBNUM,
  STATE_CCOMPARE0,
  STATE_CCOMPARE1,
  STATE_CCOMPARE2,
  STATE_PREFCTL,
  STATE_CPENABLE,
  STATE_SCOMPARE1,
  STATE_ATOMCTL,
  STATE_AE_OVERFLOW,
  STATE_AE_CBEGIN0,
  STATE_AE_CEND0,
  STATE_AE_SAR,
  STATE_AE_CWRAP,
  STATE_AE_BITHEAD,
  STATE_AE_BITPTR,
  STATE_AE_BITSUSED,
  STATE_AE_TABLESIZE,
  STATE_AE_FIRST_TS,
  STATE_AE_NEXTOFFSET,
  STATE_AE_SEARCHDONE,
  STATE_RoundMode,
  STATE_InvalidEnable,
  STATE_DivZeroEnable,
  STATE_OverflowEnable,
  STATE_UnderflowEnable,
  STATE_InexactEnable,
  STATE_InvalidFlag,
  STATE_DivZeroFlag,
  STATE_OverflowFlag,
  STATE_UnderflowFlag,
  STATE_InexactFlag,
  STATE_FPreserved20,
  STATE_FPreserved20a,
  STATE_FPreserved5,
  STATE_FPreserved7
};


/* Field definitions.  */

static unsigned
Field_op2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_op1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_op1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_op0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_op0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_inst_15_12_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_inst_15_12_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_inst_11_8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_inst_11_8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_inst_7_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_inst_7_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_inst_7_4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_inst_7_4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_inst_5_4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_inst_5_4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_inst_7_6_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_inst_7_6_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_inst_4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_inst_4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_inst_9_8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_inst_9_8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_inst_12_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_inst_12_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_inst_19_17_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  return tie_t;
}

static void
Field_inst_19_17_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_inst_19_18_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  return tie_t;
}

static void
Field_inst_19_18_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_r_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_r_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_t_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_s_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_n_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_n_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_m_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_m_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_sr_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sr_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_st_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_st_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_thi3_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_thi3_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_op0_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_op0_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_t_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_r_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_r_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_op0_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_op0_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_z_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_z_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_i_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_i_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_s_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_s_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot2_0_19_13_Slot_ae_slot2_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 12) >> 25);
  return tie_t;
}

static void
Field_fld_ae_slot2_0_19_13_Slot_ae_slot2_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0xfe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_slot2_0_19_12_Slot_ae_slot2_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 12) >> 24);
  return tie_t;
}

static void
Field_fld_ae_slot2_0_19_12_Slot_ae_slot2_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_slot2_0_7_4_Slot_ae_slot2_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot2_0_7_4_Slot_ae_slot2_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot2_0_19_14_Slot_ae_slot2_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  return tie_t;
}

static void
Field_fld_ae_slot2_0_19_14_Slot_ae_slot2_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_fld_ae_slot2_0_19_0_Slot_ae_slot2_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 20) | ((insn[0] << 12) >> 12);
  return tie_t;
}

static void
Field_fld_ae_slot2_0_19_0_Slot_ae_slot2_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 12) >> 12;
  insn[0] = (insn[0] & ~0xfffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot1_19_14_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  return tie_t;
}

static void
Field_fld_ae_slot1_19_14_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_fld_ae_slot1_19_12_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 12) >> 24);
  return tie_t;
}

static void
Field_fld_ae_slot1_19_12_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_slot1_9_8_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot1_9_8_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot1_7_4_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot1_7_4_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot1_3_3_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 28) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot1_3_3_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8) | (tie_t << 3);
}

static unsigned
Field_fld_ae_slot1_0_0_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot1_0_0_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot1_19_0_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 20) | ((insn[0] << 12) >> 12);
  return tie_t;
}

static void
Field_fld_ae_slot1_19_0_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 12) >> 12;
  insn[0] = (insn[0] & ~0xfffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot0_19_12_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 12) >> 24);
  return tie_t;
}

static void
Field_fld_ae_slot0_19_12_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_slot0_19_14_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 12) >> 26);
  return tie_t;
}

static void
Field_fld_ae_slot0_19_14_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc000) | (tie_t << 14);
}

static unsigned
Field_fld_ae_slot0_6_5_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 25) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot0_6_5_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60) | (tie_t << 5);
}

static unsigned
Field_fld_ae_slot0_7_7_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot0_7_7_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_ae_slot0_7_4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot0_7_4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot0_19_7_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 12) >> 19);
  return tie_t;
}

static void
Field_fld_ae_slot0_19_7_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0xfff80) | (tie_t << 7);
}

static unsigned
Field_fld_ae_slot0_4_0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot0_4_0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot0_11_8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot0_11_8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot0_4_2_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_fld_ae_slot0_4_2_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
}

static unsigned
Field_fld_ae_slot0_4_4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot0_4_4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot0_5_4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot0_5_4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot0_19_16_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot0_19_16_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae_slot0_19_17_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  return tie_t;
}

static void
Field_fld_ae_slot0_19_17_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae_slot0_19_0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 20) | ((insn[0] << 12) >> 12);
  return tie_t;
}

static void
Field_fld_ae_slot0_19_0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 12) >> 12;
  insn[0] = (insn[0] & ~0xfffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot2_1_18_16_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  return tie_t;
}

static void
Field_fld_ae_slot2_1_18_16_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static unsigned
Field_fld_ae_slot2_1_18_12_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 13) >> 25);
  return tie_t;
}

static void
Field_fld_ae_slot2_1_18_12_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_slot2_1_7_4_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot2_1_7_4_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot2_1_9_8_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot2_1_9_8_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot2_1_8_8_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot2_1_8_8_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot2_1_18_8_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 13) >> 21);
  return tie_t;
}

static void
Field_fld_ae_slot2_1_18_8_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x7ff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot2_1_1_0_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot2_1_1_0_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot2_1_0_0_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot2_1_0_0_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot2_1_18_0_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 19) | ((insn[0] << 13) >> 13);
  return tie_t;
}

static void
Field_fld_ae_slot2_1_18_0_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 13) >> 13;
  insn[0] = (insn[0] & ~0x7ffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot1_23_20_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot1_23_20_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae2_slot1_18_16_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  return tie_t;
}

static void
Field_fld_ae2_slot1_18_16_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static unsigned
Field_fld_ae2_slot1_7_7_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_ae2_slot1_7_7_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_ae2_slot1_23_16_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 8) >> 24);
  return tie_t;
}

static void
Field_fld_ae2_slot1_23_16_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae2_slot1_11_4_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_fld_ae2_slot1_11_4_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae2_slot1_13_11_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  return tie_t;
}

static void
Field_fld_ae2_slot1_13_11_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
}

static unsigned
Field_fld_ae2_slot1_7_4_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot1_7_4_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae2_slot1_7_3_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 24) >> 27);
  return tie_t;
}

static void
Field_fld_ae2_slot1_7_3_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf8) | (tie_t << 3);
}

static unsigned
Field_fld_ae2_slot1_1_0_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae2_slot1_1_0_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot1_23_0_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 24) | ((insn[0] << 8) >> 8);
  return tie_t;
}

static void
Field_fld_ae2_slot1_23_0_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 8) >> 8;
  insn[0] = (insn[0] & ~0xffffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot0_31_12_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 20) | ((insn[0] << 0) >> 12);
  return tie_t;
}

static void
Field_fld_ae2_slot0_31_12_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 12) >> 12;
  insn[0] = (insn[0] & ~0xfffff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae2_slot0_31_15_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 17) | ((insn[0] << 0) >> 15);
  return tie_t;
}

static void
Field_fld_ae2_slot0_31_15_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0xffff8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae2_slot0_6_4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae2_slot0_6_4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae2_slot0_7_4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot0_7_4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae2_slot0_31_7_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 25) | ((insn[0] << 0) >> 7);
  return tie_t;
}

static void
Field_fld_ae2_slot0_31_7_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0xffffff80) | (tie_t << 7);
}

static unsigned
Field_fld_ae2_slot0_4_0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae2_slot0_4_0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot0_11_8_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot0_11_8_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae2_slot0_4_4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_fld_ae2_slot0_4_4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_fld_ae2_slot0_4_2_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 27) >> 29);
  return tie_t;
}

static void
Field_fld_ae2_slot0_4_2_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c) | (tie_t << 2);
}

static unsigned
Field_fld_ae2_slot0_7_7_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_ae2_slot0_7_7_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_ae2_slot0_31_16_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 0) >> 16);
  return tie_t;
}

static void
Field_fld_ae2_slot0_31_16_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae2_slot0_14_12_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_fld_ae2_slot0_14_12_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_fld_ae2_slot0_5_4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae2_slot0_5_4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae2_slot0_3_0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot0_3_0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot0_9_8_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae2_slot0_9_8_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae2_slot0_8_8_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_fld_ae2_slot0_8_8_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_fld_ae2_slot0_11_11_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_fld_ae2_slot0_11_11_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_fld_ae2_slot0_1_0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae2_slot0_1_0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot0_0_0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_ae2_slot0_0_0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot0_31_17_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 0) >> 17);
  return tie_t;
}

static void
Field_fld_ae2_slot0_31_17_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0xfffe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae2_slot0_6_0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 25) >> 25);
  return tie_t;
}

static void
Field_fld_ae2_slot0_6_0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot0_31_30_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 0) >> 30);
  return tie_t;
}

static void
Field_fld_ae2_slot0_31_30_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0000000) | (tie_t << 30);
}

static unsigned
Field_fld_ae2_slot0_11_4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_fld_ae2_slot0_11_4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_minislot2_18_16_Slot_ae_minislot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  return tie_t;
}

static void
Field_fld_ae_minislot2_18_16_Slot_ae_minislot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static unsigned
Field_fld_ae_minislot2_11_4_Slot_ae_minislot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_fld_ae_minislot2_11_4_Slot_ae_minislot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_minislot2_9_8_Slot_ae_minislot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae_minislot2_9_8_Slot_ae_minislot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_minislot2_3_0_Slot_ae_minislot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_minislot2_3_0_Slot_ae_minislot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_minislot2_18_8_Slot_ae_minislot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 13) >> 21);
  return tie_t;
}

static void
Field_fld_ae_minislot2_18_8_Slot_ae_minislot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x7ff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_minislot2_11_8_Slot_ae_minislot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_minislot2_11_8_Slot_ae_minislot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_minislot2_18_0_Slot_ae_minislot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 19) | ((insn[0] << 13) >> 13);
  return tie_t;
}

static void
Field_fld_ae_minislot2_18_0_Slot_ae_minislot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 13) >> 13;
  insn[0] = (insn[0] & ~0x7ffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae_minislot1_0_0_Slot_ae_minislot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_ae_minislot1_0_0_Slot_ae_minislot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_fld_ae_minislot0_16_12_Slot_ae_minislot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 15) >> 27);
  return tie_t;
}

static void
Field_fld_ae_minislot0_16_12_Slot_ae_minislot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_minislot0_16_8_Slot_ae_minislot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 15) >> 23);
  return tie_t;
}

static void
Field_fld_ae_minislot0_16_8_Slot_ae_minislot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x1ff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_minislot0_16_10_Slot_ae_minislot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 15) >> 25);
  return tie_t;
}

static void
Field_fld_ae_minislot0_16_10_Slot_ae_minislot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_minislot0_16_0_Slot_ae_minislot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 17) | ((insn[0] << 15) >> 15);
  return tie_t;
}

static void
Field_fld_ae_minislot0_16_0_Slot_ae_minislot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0x1ffff) | (tie_t << 0);
}

static unsigned
Field_t_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_t_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_ae_minislot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae_minislot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_bbi4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_bbi4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_bbi_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_bbi_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_bbi_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_bbi_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_imm12_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 8) >> 20);
  return tie_t;
}

static void
Field_imm12_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff000) | (tie_t << 12);
}

static unsigned
Field_imm8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 8) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0000) | (tie_t << 16);
}

static unsigned
Field_imm8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm8_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm8_Slot_ae_minislot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_ae_minislot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_s_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_s_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_s_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_s_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_s_Slot_ae_minislot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae_minislot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_s_Slot_ae_minislot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae_minislot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_imm12b_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 8) >> 24);
  return tie_t;
}

static void
Field_imm12b_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0000) | (tie_t << 16);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_imm12b_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm12b_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm12b_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm12b_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm12b_Slot_ae_minislot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm12b_Slot_ae_minislot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm16_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 8) >> 16);
  return tie_t;
}

static void
Field_imm16_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff00) | (tie_t << 8);
}

static unsigned
Field_offset_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 8) >> 14);
  return tie_t;
}

static void
Field_offset_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xffffc0) | (tie_t << 6);
}

static unsigned
Field_op2_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_op2_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_op2_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_r_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_r_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_r_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_r_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae_minislot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae_minislot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_sa4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  return tie_t;
}

static void
Field_sa4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_sae4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_sae4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_sae_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_sae_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sae_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_sal_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_sargt_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_sas4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_sas4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_sas_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sas_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_sr_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sr_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_sr_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sr_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_st_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_st_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_st_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_st_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_imm4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm4_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm4_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm4_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm4_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_mn_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_mn_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_i_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_i_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_imm6lo_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm6lo_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm6lo_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm6lo_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm6hi_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_imm6hi_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_imm6hi_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_imm6hi_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_imm7lo_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm7lo_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm7lo_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm7lo_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm7hi_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_imm7hi_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_imm7hi_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_imm7hi_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_z_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_z_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_imm6_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm6_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_imm6_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm6_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_imm7_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm7_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_imm7_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm7_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_t2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_t2_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_t2_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_t2_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_t2_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_t2_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_s2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_s2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_s2_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_s2_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_s2_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_s2_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_r2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_r2_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_r2_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_r2_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_r2_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_t4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_t4_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_t4_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_t4_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_t4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_t4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_s4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_s4_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_s4_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_r4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_r4_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_r4_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_r4_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_r4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_t8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_t8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_t8_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_t8_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_t8_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_t8_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_s8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_s8_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_s8_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_r8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_r8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_r8_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_r8_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_r8_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_r8_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_xt_wbr15_imm_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 8) >> 17);
  return tie_t;
}

static void
Field_xt_wbr15_imm_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0xfffe00) | (tie_t << 9);
}

static unsigned
Field_xt_wbr18_imm_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 8) >> 14);
  return tie_t;
}

static void
Field_xt_wbr18_imm_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xffffc0) | (tie_t << 6);
}

static unsigned
Field_xt_wbr18_imm_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 2) >> 14);
  return tie_t;
}

static void
Field_xt_wbr18_imm_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0x3ffff000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_fhba4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_fhba4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_fhba4_2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_fhba4_2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_tp7_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_tp7_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_tp7_Slot_ae_slot2_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_tp7_Slot_ae_slot2_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_tp7_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_tp7_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_osa32_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa32_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_ae_fld_osa32_Slot_ae_slot2_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa32_Slot_ae_slot2_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_osa32_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 21) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_ae_fld_osa32_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0x700) | (tie_t << 8);
}

static unsigned
Field_ae_fld_osa64_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa64_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
}

static unsigned
Field_ae_fld_osa64_Slot_ae_slot2_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa64_Slot_ae_slot2_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_osa64_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 21) >> 29);
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_ae_fld_osa64_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
  tie_t = (val << 26) >> 29;
  insn[0] = (insn[0] & ~0x700) | (tie_t << 8);
}

static unsigned
Field_ae_fld_imm2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_ae_fld_imm2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_ae_fld_imm2_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 29) >> 30);
  return tie_t;
}

static void
Field_ae_fld_imm2_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x6) | (tie_t << 1);
}

static unsigned
Field_ae_fld_imm2_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 29) >> 31);
  return tie_t;
}

static void
Field_ae_fld_imm2_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4) | (tie_t << 2);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ae_fld_immls64_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls64_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_ae_fld_immls64_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 30) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_immls64_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_ae_fld_immls64_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_immls64_Slot_ae_minislot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls64_Slot_ae_minislot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_immls64pos_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64pos_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64pos_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64pos_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64pos_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64pos_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_immls32_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls32_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls32_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls32_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls32_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_ae_fld_immls32_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_immls32_Slot_ae_minislot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls32_Slot_ae_minislot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_immls16_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls16_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls16_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls16_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls16_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_ae_fld_immls16_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
  tie_t = (val << 28) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_immls16_Slot_ae_minislot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls16_Slot_ae_minislot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_ls_v_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_v_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_v_Slot_ae_minislot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v_Slot_ae_minislot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ls_uu_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_uu_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ls_uu_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 25) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_uu_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60) | (tie_t << 5);
}

static unsigned
Field_ae_fld_ls_uu_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 25) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_uu_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60) | (tie_t << 5);
}

static unsigned
Field_ae_fld_ls_su_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_su_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ls_su_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 25) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_su_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60) | (tie_t << 5);
}

static unsigned
Field_ae_fld_ls_su_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 25) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_su_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60) | (tie_t << 5);
}

static unsigned
Field_ae_fld_ls_av_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_av_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_ls_av_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_av_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_av_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_av_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_v1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_ls_v1_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v1_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_v1_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v1_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_v1_Slot_ae_minislot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v1_Slot_ae_minislot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ls_v2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ls_v2_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v2_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_cmpp_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmpp_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_cmpp_v0_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmpp_v0_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_cmpp_v0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmpp_v0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_cmpp_v1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmpp_v1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_cmpp_v1_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmpp_v1_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_cmpp_v1_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmpp_v1_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_cmpp_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmpp_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_cmpp_v_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmpp_v_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_cmpp_v_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmpp_v_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_uu_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_ae_fld_uu_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_ae_fld_uu_v_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_ae_fld_uu_v_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_ae_fld_uu_v_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_ae_fld_uu_v_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_ae_fld_uu_uu_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_ae_fld_uu_uu_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_ae_fld_uu_uu_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 25) >> 30);
  return tie_t;
}

static void
Field_ae_fld_uu_uu_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60) | (tie_t << 5);
}

static unsigned
Field_ae_fld_uu_uu_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 25) >> 30);
  return tie_t;
}

static void
Field_ae_fld_uu_uu_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60) | (tie_t << 5);
}

static unsigned
Field_ae_fld_dr_to_ar_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_ar_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_dr_to_ar_v0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_ar_v0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_dr_to_ar_v0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_ar_v0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_dr_to_ar_v0_Slot_ae_minislot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_ar_v0_Slot_ae_minislot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_cmov_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmov_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_cmov_v_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmov_v_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_cmov_v_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmov_v_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_cmov_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmov_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_cmov_v0_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmov_v0_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_cmov_v0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmov_v0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_pks_d_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_pks_d_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_pks_d_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_pks_d_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_pks_d_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_pks_d_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_pks_s_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_pks_s_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_pks_s_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_pks_s_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_pks_s_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_pks_s_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_shift_d_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_d_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_shift_d_Slot_ae_slot2_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_d_Slot_ae_slot2_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_shift_d_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_d_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_shift_d_Slot_ae_minislot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_d_Slot_ae_minislot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_shift_d0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_d0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_shift_d0_Slot_ae_slot2_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_d0_Slot_ae_slot2_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_shift_d0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_d0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_shift_d0_Slot_ae_minislot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_d0_Slot_ae_minislot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_shift_sd_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_sd_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_ae_fld_shift_sd_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_sd_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_shift_sd_Slot_ae_minislot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_sd_Slot_ae_minislot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_dr_to_dr_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_dr_to_dr_v_Slot_ae_slot2_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v_Slot_ae_slot2_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_dr_to_dr_v_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_dr_to_dr_v_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_dr_to_dr_v_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_dr_to_dr_v_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_dr_to_dr_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_dr_to_dr_v0_Slot_ae_slot2_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v0_Slot_ae_slot2_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_dr_to_dr_v0_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v0_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_dr_to_dr_v0_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v0_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_dr_to_dr_v0_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v0_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_dr_to_dr_v0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_dr_to_dr_v1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_dr_to_dr_v1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_dr_to_dr_v1_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v1_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_dr_to_dr_v1_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v1_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_dr_to_dr_v1_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v1_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_to_dr_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_to_dr_v_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_to_dr_v_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_to_dr_v_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_to_dr_v_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_to_dr_v_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_to_dr_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_to_dr_v0_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v0_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_to_dr_v0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_to_dr_v0_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v0_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_to_dr_v0_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v0_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_to_dr_v0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_selimm_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_ae_fld_selimm_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_ae_fld_selimm_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_selimm_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_selimm_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_ae_fld_selimm_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
  tie_t = (val << 28) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_ae_fld_selimm_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_selimm_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ar_to_dr_imm_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ar_to_dr_imm_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ar_to_dr_imm_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ar_to_dr_imm_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_fld_ar_to_dr_imm_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ar_to_dr_imm_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_ar_to_dr_imm_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ar_to_dr_imm_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_fld_ar_to_dr_imm_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 12) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 21) >> 29);
  return tie_t;
}

static void
Field_fld_ar_to_dr_imm_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700) | (tie_t << 8);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
  tie_t = (val << 26) >> 31;
  insn[0] = (insn[0] & ~0x80000) | (tie_t << 19);
}

static unsigned
Field_fld_ar_to_dr_imm_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ar_to_dr_imm_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_ar_to_dr_imm_Slot_ae_minislot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ar_to_dr_imm_Slot_ae_minislot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_fld_ar_to_dr_imm_Slot_ae_minislot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ar_to_dr_imm_Slot_ae_minislot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_ae_fld_arth_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_arth_v_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_arth_v_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_arth_v_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_arth_v_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_arth_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_arth_v0_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v0_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_arth_v0_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v0_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_arth_v0_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v0_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_arth_v0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_arth_v1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_arth_v1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_arth_v1_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v1_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_arth_v1_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v1_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_arth_v1_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v1_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ar_to_dr_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ar_to_dr_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_ar_to_dr_v_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ar_to_dr_v_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_ar_to_dr_v_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ar_to_dr_v_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ar_to_dr_v_Slot_ae_slot2_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ar_to_dr_v_Slot_ae_slot2_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_ar_to_dr_v_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ar_to_dr_v_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_ar_to_dr_v_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ar_to_dr_v_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ar_to_dr_v_Slot_ae_minislot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ar_to_dr_v_Slot_ae_minislot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_ar_to_dr_v_Slot_ae_minislot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ar_to_dr_v_Slot_ae_minislot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_osa16_Slot_ae_slot2_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa16_Slot_ae_slot2_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_osa16_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa16_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_mul_d0_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_mul_d0_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_mul_d0_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_mul_d0_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_mul_d1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_mul_d1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_mul_d1_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_mul_d1_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_mul_q0_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_mul_q0_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_mul_q0_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_mul_q0_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_mul_x2_s2_d1_Slot_ae_slot2_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_mul_x2_s2_d1_Slot_ae_slot2_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_mul_x2_s2_d0_Slot_ae_slot2_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_mul_x2_s2_d0_Slot_ae_slot2_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_mul_x2_s2_q0_Slot_ae_slot2_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_mul_x2_s2_q0_Slot_ae_slot2_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_mul_x4_d2_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_ae_fld_mul_x4_d2_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_ae_fld_mul_x4_q1_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_mul_x4_q1_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_selimm_n_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_ae_fld_selimm_n_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_fld_ae2_slot1_7_6_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_ae2_slot1_7_6_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static void
Implicit_Field_set (xtensa_insnbuf insn ATTRIBUTE_UNUSED,
		    uint32 val ATTRIBUTE_UNUSED)
{
  /* Do nothing.  */
}

static unsigned
Implicit_Field_ar0_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_ar4_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 4;
}

static unsigned
Implicit_Field_ar8_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 8;
}

static unsigned
Implicit_Field_ar12_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 12;
}

static unsigned
Implicit_Field_bt16_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_bs16_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_br16_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_brall_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

enum xtensa_field_id {
  FIELD_t,
  FIELD_bbi4,
  FIELD_bbi,
  FIELD_imm12,
  FIELD_imm8,
  FIELD_s,
  FIELD_imm12b,
  FIELD_imm16,
  FIELD_m,
  FIELD_n,
  FIELD_offset,
  FIELD_op0,
  FIELD_op1,
  FIELD_op2,
  FIELD_r,
  FIELD_sa4,
  FIELD_sae4,
  FIELD_sae,
  FIELD_sal,
  FIELD_sargt,
  FIELD_sas4,
  FIELD_sas,
  FIELD_sr,
  FIELD_st,
  FIELD_thi3,
  FIELD_imm4,
  FIELD_mn,
  FIELD_i,
  FIELD_imm6lo,
  FIELD_imm6hi,
  FIELD_imm7lo,
  FIELD_imm7hi,
  FIELD_z,
  FIELD_imm6,
  FIELD_imm7,
  FIELD_t2,
  FIELD_s2,
  FIELD_r2,
  FIELD_t4,
  FIELD_s4,
  FIELD_r4,
  FIELD_t8,
  FIELD_s8,
  FIELD_r8,
  FIELD_xt_wbr15_imm,
  FIELD_xt_wbr18_imm,
  FIELD_ae_fld_fhba4,
  FIELD_ae_fld_fhba4_2,
  FIELD_ae_fld_tp7,
  FIELD_ae_fld_osa32,
  FIELD_ae_fld_osa64,
  FIELD_ae_fld_imm2,
  FIELD_ae_fld_immls64,
  FIELD_ae_fld_immls64pos,
  FIELD_ae_fld_immls32,
  FIELD_ae_fld_immls16,
  FIELD_Inst_15_12,
  FIELD_Inst_11_8,
  FIELD_Inst_7_4,
  FIELD_Inst_12,
  FIELD_Inst_7,
  FIELD_Inst_5_4,
  FIELD_Inst_7_6,
  FIELD_Inst_19_17,
  FIELD_Inst_19_18,
  FIELD_Inst_9_8,
  FIELD_Inst_4,
  FIELD_ae_fld_ls_v,
  FIELD_ae_fld_ls_uu,
  FIELD_ae_fld_ls_su,
  FIELD_ae_fld_ls_av,
  FIELD_ae_fld_ls_v1,
  FIELD_ae_fld_ls_v2,
  FIELD_ae_fld_cmpp_v0,
  FIELD_ae_fld_cmpp_v1,
  FIELD_ae_fld_cmpp_v,
  FIELD_ae_fld_uu_v,
  FIELD_ae_fld_uu_uu,
  FIELD_ae_fld_dr_to_ar_v0,
  FIELD_ae_fld_cmov_v,
  FIELD_ae_fld_cmov_v0,
  FIELD_ae_fld_pks_d,
  FIELD_ae_fld_pks_s,
  FIELD_ae_fld_shift_d,
  FIELD_ae_fld_shift_d0,
  FIELD_ae_fld_shift_sd,
  FIELD_ae_fld_dr_to_dr_v,
  FIELD_ae_fld_dr_to_dr_v0,
  FIELD_ae_fld_dr_to_dr_v1,
  FIELD_ae_fld_to_dr_v,
  FIELD_ae_fld_to_dr_v0,
  FIELD_ae_fld_selimm,
  FIELD_fld_ar_to_dr_imm,
  FIELD_ae_fld_arth_v,
  FIELD_ae_fld_arth_v0,
  FIELD_ae_fld_arth_v1,
  FIELD_ae_fld_ar_to_dr_v,
  FIELD_fld_ae2_slot0_11_4,
  FIELD_fld_ae2_slot0_7_4,
  FIELD_fld_ae2_slot0_9_8,
  FIELD_fld_ae2_slot0_11_11,
  FIELD_fld_ae2_slot0_31_30,
  FIELD_fld_ae2_slot0_11_8,
  FIELD_fld_ae2_slot0_31_12,
  FIELD_fld_ae_slot0_19_12,
  FIELD_fld_ae_minislot2_18_16,
  FIELD_fld_ae_slot0_19_16,
  FIELD_fld_ae2_slot0_31_17,
  FIELD_fld_ae_slot0_19_17,
  FIELD_fld_ae_minislot0_16_0,
  FIELD_fld_ae_minislot1_0_0,
  FIELD_fld_ae_minislot2_18_0,
  FIELD_fld_ae2_slot0_6_0,
  FIELD_fld_ae2_slot1_23_0,
  FIELD_fld_ae_slot2_1_18_0,
  FIELD_fld_ae_slot0_19_0,
  FIELD_fld_ae_slot1_19_0,
  FIELD_fld_ae_slot2_0_19_0,
  FIELD_ae_fld_osa16,
  FIELD_ae_fld_mul_d0,
  FIELD_ae_fld_mul_d1,
  FIELD_ae_fld_mul_q0,
  FIELD_ae_fld_mul_x2_S2_d1,
  FIELD_ae_fld_mul_x2_S2_d0,
  FIELD_ae_fld_mul_x2_S2_q0,
  FIELD_ae_fld_mul_x4_d2,
  FIELD_ae_fld_mul_x4_q1,
  FIELD_fld_ae_slot0_7_4,
  FIELD_fld_ae_slot0_11_8,
  FIELD_fld_ae2_slot0_31_7,
  FIELD_fld_ae_slot0_19_7,
  FIELD_ae_fld_selimm_N,
  FIELD_fld_ae_slot1_19_14,
  FIELD_fld_ae_slot2_1_9_8,
  FIELD_fld_ae2_slot0_31_16,
  FIELD_fld_ae_slot2_1_7_4,
  FIELD_fld_ae_slot2_1_18_12,
  FIELD_fld_ae_slot2_1_1_0,
  FIELD_fld_ae2_slot1_7_4,
  FIELD_fld_ae_slot1_19_12,
  FIELD_fld_ae_slot2_0_19_12,
  FIELD_fld_ae2_slot1_23_16,
  FIELD_fld_ae2_slot1_23_20,
  FIELD_fld_ae2_slot0_3_0,
  FIELD_fld_ae2_slot1_11_4,
  FIELD_fld_ae_slot2_1_18_8,
  FIELD_fld_ae_slot1_7_4,
  FIELD_fld_ae_minislot2_11_4,
  FIELD_fld_ae_minislot0_16_10,
  FIELD_fld_ae_minislot2_3_0,
  FIELD_fld_ae_minislot2_9_8,
  FIELD_fld_ae2_slot1_13_11,
  FIELD_fld_ae_slot0_5_4,
  FIELD_fld_ae_slot1_9_8,
  FIELD_fld_ae_minislot0_16_8,
  FIELD_fld_ae2_slot1_7_7,
  FIELD_fld_ae2_slot1_18_16,
  FIELD_fld_ae_slot2_1_18_16,
  FIELD_fld_ae2_slot0_8_8,
  FIELD_fld_ae_slot2_1_0_0,
  FIELD_fld_ae_minislot0_16_12,
  FIELD_fld_ae2_slot0_6_4,
  FIELD_fld_ae2_slot0_31_15,
  FIELD_fld_ae_slot0_6_5,
  FIELD_fld_ae_slot0_19_14,
  FIELD_fld_ae_slot0_7_7,
  FIELD_fld_ae2_slot0_4_4,
  FIELD_fld_ae2_slot0_7_7,
  FIELD_fld_ae_slot0_4_4,
  FIELD_fld_ae2_slot0_4_2,
  FIELD_fld_ae_slot0_4_2,
  FIELD_fld_ae2_slot0_4_0,
  FIELD_fld_ae_slot0_4_0,
  FIELD_fld_ae_minislot2_18_8,
  FIELD_fld_ae2_slot0_5_4,
  FIELD_fld_ae2_slot0_14_12,
  FIELD_fld_ae_slot2_1_8_8,
  FIELD_fld_ae2_slot1_1_0,
  FIELD_fld_ae2_slot1_7_3,
  FIELD_fld_ae_slot1_0_0,
  FIELD_fld_ae_slot1_3_3,
  FIELD_fld_ae_minislot2_11_8,
  FIELD_fld_ae_slot2_0_7_4,
  FIELD_fld_ae2_slot0_1_0,
  FIELD_fld_ae_slot2_0_19_13,
  FIELD_fld_ae2_slot0_0_0,
  FIELD_fld_ae_slot2_0_19_14,
  FIELD_fld_ae2_slot1_7_6,
  FIELD__ar0,
  FIELD__ar4,
  FIELD__ar8,
  FIELD__ar12,
  FIELD__bt16,
  FIELD__bs16,
  FIELD__br16,
  FIELD__brall
};


/* Functional units.  */

static xtensa_funcUnit_internal funcUnits[] = {
  { "mul_function", 1 },
  { "mul_S2_function", 1 },
  { "ae_add32x27", 1 },
  { "ae_shift32x4", 1 },
  { "ae_shift32x5", 1 },
  { "ae_leftshift32x5", 1 },
  { "ae_mulpp33x24_1", 1 },
  { "ae_mulpp33x24_2", 1 }
};

enum xtensa_funcUnit_id {
  FUNCUNIT_mul_function,
  FUNCUNIT_mul_S2_function,
  FUNCUNIT_ae_add32x27,
  FUNCUNIT_ae_shift32x4,
  FUNCUNIT_ae_shift32x5,
  FUNCUNIT_ae_leftshift32x5,
  FUNCUNIT_ae_mulpp33x24_1,
  FUNCUNIT_ae_mulpp33x24_2
};


/* Register files.  */

enum xtensa_regfile_id {
  REGFILE_AR,
  REGFILE_BR,
  REGFILE_AE_DR,
  REGFILE_AE_VALIGN,
  REGFILE_FR,
  REGFILE_BR2,
  REGFILE_BR4,
  REGFILE_BR8,
  REGFILE_BR16
};

static xtensa_regfile_internal regfiles[] = {
  { "AR", "a", REGFILE_AR, 32, 64 },
  { "BR", "b", REGFILE_BR, 1, 16 },
  { "AE_DR", "aed", REGFILE_AE_DR, 64, 16 },
  { "AE_VALIGN", "u", REGFILE_AE_VALIGN, 64, 4 },
  { "FR", "f", REGFILE_FR, 32, 16 },
  { "BR2", "b", REGFILE_BR, 2, 8 },
  { "BR4", "b", REGFILE_BR, 4, 4 },
  { "BR8", "b", REGFILE_BR, 8, 2 },
  { "BR16", "b", REGFILE_BR, 16, 1 }
};


/* Interfaces.  */

#define interfaces 0


/* Constant tables.  */

/* constant table ai4c */
static const unsigned CONST_TBL_ai4c_0[] = {
  0xffffffff,
  0x1,
  0x2,
  0x3,
  0x4,
  0x5,
  0x6,
  0x7,
  0x8,
  0x9,
  0xa,
  0xb,
  0xc,
  0xd,
  0xe,
  0xf,
  0
};

/* constant table b4c */
static const unsigned CONST_TBL_b4c_0[] = {
  0xffffffff,
  0x1,
  0x2,
  0x3,
  0x4,
  0x5,
  0x6,
  0x7,
  0x8,
  0xa,
  0xc,
  0x10,
  0x20,
  0x40,
  0x80,
  0x100,
  0
};

/* constant table b4cu */
static const unsigned CONST_TBL_b4cu_0[] = {
  0x8000,
  0x10000,
  0x2,
  0x3,
  0x4,
  0x5,
  0x6,
  0x7,
  0x8,
  0xa,
  0xc,
  0x10,
  0x20,
  0x40,
  0x80,
  0x100,
  0
};

/* constant table bitmask8 */
static const unsigned CONST_TBL_bitmask8_0[] = {
  0 & 0xff,
  0x1 & 0xff,
  0x3 & 0xff,
  0x7 & 0xff,
  0xf & 0xff,
  0x1f & 0xff,
  0x3f & 0xff,
  0x7f & 0xff,
  0
};

/* constant table ae_seliencode */
static const unsigned CONST_TBL_ae_seliencode_0[] = {
  0x4e5 & 0xfff,
  0x65 & 0xfff,
  0x77 & 0xfff,
  0x4f7 & 0xfff,
  0x72e & 0xfff,
  0x29c & 0xfff,
  0xaf & 0xfff,
  0xa6 & 0xfff,
  0x2ef & 0xfff,
  0x10d & 0xfff,
  0x599 & 0xfff,
  0,
  0,
  0,
  0,
  0,
  0
};

/* constant table RECIP_Data8 */
static const unsigned CONST_TBL_RECIP_Data8_0[] = {
  0xff & 0xff,
  0xfd & 0xff,
  0xfb & 0xff,
  0xf9 & 0xff,
  0xf7 & 0xff,
  0xf5 & 0xff,
  0xf4 & 0xff,
  0xf2 & 0xff,
  0xf0 & 0xff,
  0xee & 0xff,
  0xed & 0xff,
  0xeb & 0xff,
  0xe9 & 0xff,
  0xe8 & 0xff,
  0xe6 & 0xff,
  0xe4 & 0xff,
  0xe3 & 0xff,
  0xe1 & 0xff,
  0xe0 & 0xff,
  0xde & 0xff,
  0xdd & 0xff,
  0xdb & 0xff,
  0xda & 0xff,
  0xd8 & 0xff,
  0xd7 & 0xff,
  0xd5 & 0xff,
  0xd4 & 0xff,
  0xd3 & 0xff,
  0xd1 & 0xff,
  0xd0 & 0xff,
  0xcf & 0xff,
  0xcd & 0xff,
  0xcc & 0xff,
  0xcb & 0xff,
  0xca & 0xff,
  0xc8 & 0xff,
  0xc7 & 0xff,
  0xc6 & 0xff,
  0xc5 & 0xff,
  0xc4 & 0xff,
  0xc2 & 0xff,
  0xc1 & 0xff,
  0xc0 & 0xff,
  0xbf & 0xff,
  0xbe & 0xff,
  0xbd & 0xff,
  0xbc & 0xff,
  0xbb & 0xff,
  0xba & 0xff,
  0xb9 & 0xff,
  0xb8 & 0xff,
  0xb7 & 0xff,
  0xb6 & 0xff,
  0xb5 & 0xff,
  0xb4 & 0xff,
  0xb3 & 0xff,
  0xb2 & 0xff,
  0xb1 & 0xff,
  0xb0 & 0xff,
  0xaf & 0xff,
  0xae & 0xff,
  0xad & 0xff,
  0xac & 0xff,
  0xab & 0xff,
  0xaa & 0xff,
  0xa9 & 0xff,
  0xa8 & 0xff,
  0xa8 & 0xff,
  0xa7 & 0xff,
  0xa6 & 0xff,
  0xa5 & 0xff,
  0xa4 & 0xff,
  0xa3 & 0xff,
  0xa3 & 0xff,
  0xa2 & 0xff,
  0xa1 & 0xff,
  0xa0 & 0xff,
  0x9f & 0xff,
  0x9f & 0xff,
  0x9e & 0xff,
  0x9d & 0xff,
  0x9c & 0xff,
  0x9c & 0xff,
  0x9b & 0xff,
  0x9a & 0xff,
  0x99 & 0xff,
  0x99 & 0xff,
  0x98 & 0xff,
  0x97 & 0xff,
  0x97 & 0xff,
  0x96 & 0xff,
  0x95 & 0xff,
  0x95 & 0xff,
  0x94 & 0xff,
  0x93 & 0xff,
  0x93 & 0xff,
  0x92 & 0xff,
  0x91 & 0xff,
  0x91 & 0xff,
  0x90 & 0xff,
  0x8f & 0xff,
  0x8f & 0xff,
  0x8e & 0xff,
  0x8e & 0xff,
  0x8d & 0xff,
  0x8c & 0xff,
  0x8c & 0xff,
  0x8b & 0xff,
  0x8b & 0xff,
  0x8a & 0xff,
  0x89 & 0xff,
  0x89 & 0xff,
  0x88 & 0xff,
  0x88 & 0xff,
  0x87 & 0xff,
  0x87 & 0xff,
  0x86 & 0xff,
  0x85 & 0xff,
  0x85 & 0xff,
  0x84 & 0xff,
  0x84 & 0xff,
  0x83 & 0xff,
  0x83 & 0xff,
  0x82 & 0xff,
  0x82 & 0xff,
  0x81 & 0xff,
  0x81 & 0xff,
  0x81 & 0xff,
  0
};

/* constant table RSQRT_Data8 */
static const unsigned CONST_TBL_RSQRT_Data8_0[] = {
  0xb4 & 0xff,
  0xb3 & 0xff,
  0xb2 & 0xff,
  0xb0 & 0xff,
  0xaf & 0xff,
  0xae & 0xff,
  0xac & 0xff,
  0xab & 0xff,
  0xaa & 0xff,
  0xa9 & 0xff,
  0xa8 & 0xff,
  0xa7 & 0xff,
  0xa6 & 0xff,
  0xa5 & 0xff,
  0xa3 & 0xff,
  0xa2 & 0xff,
  0xa1 & 0xff,
  0xa0 & 0xff,
  0x9f & 0xff,
  0x9e & 0xff,
  0x9e & 0xff,
  0x9d & 0xff,
  0x9c & 0xff,
  0x9b & 0xff,
  0x9a & 0xff,
  0x99 & 0xff,
  0x98 & 0xff,
  0x97 & 0xff,
  0x97 & 0xff,
  0x96 & 0xff,
  0x95 & 0xff,
  0x94 & 0xff,
  0x93 & 0xff,
  0x93 & 0xff,
  0x92 & 0xff,
  0x91 & 0xff,
  0x90 & 0xff,
  0x90 & 0xff,
  0x8f & 0xff,
  0x8e & 0xff,
  0x8e & 0xff,
  0x8d & 0xff,
  0x8c & 0xff,
  0x8c & 0xff,
  0x8b & 0xff,
  0x8a & 0xff,
  0x8a & 0xff,
  0x89 & 0xff,
  0x89 & 0xff,
  0x88 & 0xff,
  0x87 & 0xff,
  0x87 & 0xff,
  0x86 & 0xff,
  0x86 & 0xff,
  0x85 & 0xff,
  0x84 & 0xff,
  0x84 & 0xff,
  0x83 & 0xff,
  0x83 & 0xff,
  0x82 & 0xff,
  0x82 & 0xff,
  0x81 & 0xff,
  0x81 & 0xff,
  0x80 & 0xff,
  0xff & 0xff,
  0xfd & 0xff,
  0xfb & 0xff,
  0xf9 & 0xff,
  0xf7 & 0xff,
  0xf6 & 0xff,
  0xf4 & 0xff,
  0xf2 & 0xff,
  0xf1 & 0xff,
  0xef & 0xff,
  0xed & 0xff,
  0xec & 0xff,
  0xea & 0xff,
  0xe9 & 0xff,
  0xe7 & 0xff,
  0xe6 & 0xff,
  0xe4 & 0xff,
  0xe3 & 0xff,
  0xe1 & 0xff,
  0xe0 & 0xff,
  0xdf & 0xff,
  0xdd & 0xff,
  0xdc & 0xff,
  0xdb & 0xff,
  0xda & 0xff,
  0xd8 & 0xff,
  0xd7 & 0xff,
  0xd6 & 0xff,
  0xd5 & 0xff,
  0xd4 & 0xff,
  0xd3 & 0xff,
  0xd2 & 0xff,
  0xd0 & 0xff,
  0xcf & 0xff,
  0xce & 0xff,
  0xcd & 0xff,
  0xcc & 0xff,
  0xcb & 0xff,
  0xca & 0xff,
  0xc9 & 0xff,
  0xc8 & 0xff,
  0xc7 & 0xff,
  0xc6 & 0xff,
  0xc6 & 0xff,
  0xc5 & 0xff,
  0xc4 & 0xff,
  0xc3 & 0xff,
  0xc2 & 0xff,
  0xc1 & 0xff,
  0xc0 & 0xff,
  0xbf & 0xff,
  0xbf & 0xff,
  0xbe & 0xff,
  0xbd & 0xff,
  0xbc & 0xff,
  0xbb & 0xff,
  0xbb & 0xff,
  0xba & 0xff,
  0xb9 & 0xff,
  0xb8 & 0xff,
  0xb8 & 0xff,
  0xb7 & 0xff,
  0xb6 & 0xff,
  0xb5 & 0xff,
  0
};

/* constant table RECIP_Data10_2 */
static const unsigned CONST_TBL_RECIP_Data10_2_0[] = {
  0x3fc & 0x3ff,
  0x3f4 & 0x3ff,
  0x3ec & 0x3ff,
  0x3e5 & 0x3ff,
  0x3dd & 0x3ff,
  0x3d6 & 0x3ff,
  0x3cf & 0x3ff,
  0x3c7 & 0x3ff,
  0x3c0 & 0x3ff,
  0x3b9 & 0x3ff,
  0x3b2 & 0x3ff,
  0x3ac & 0x3ff,
  0x3a5 & 0x3ff,
  0x39e & 0x3ff,
  0x398 & 0x3ff,
  0x391 & 0x3ff,
  0x38b & 0x3ff,
  0x385 & 0x3ff,
  0x37f & 0x3ff,
  0x378 & 0x3ff,
  0x373 & 0x3ff,
  0x36c & 0x3ff,
  0x367 & 0x3ff,
  0x361 & 0x3ff,
  0x35c & 0x3ff,
  0x356 & 0x3ff,
  0x350 & 0x3ff,
  0x34b & 0x3ff,
  0x345 & 0x3ff,
  0x340 & 0x3ff,
  0x33b & 0x3ff,
  0x335 & 0x3ff,
  0x330 & 0x3ff,
  0x32c & 0x3ff,
  0x327 & 0x3ff,
  0x322 & 0x3ff,
  0x31c & 0x3ff,
  0x318 & 0x3ff,
  0x314 & 0x3ff,
  0x30e & 0x3ff,
  0x30a & 0x3ff,
  0x306 & 0x3ff,
  0x300 & 0x3ff,
  0x2fc & 0x3ff,
  0x2f8 & 0x3ff,
  0x2f4 & 0x3ff,
  0x2f0 & 0x3ff,
  0x2ea & 0x3ff,
  0x2e6 & 0x3ff,
  0x2e2 & 0x3ff,
  0x2de & 0x3ff,
  0x2da & 0x3ff,
  0x2d6 & 0x3ff,
  0x2d2 & 0x3ff,
  0x2ce & 0x3ff,
  0x2ca & 0x3ff,
  0x2c6 & 0x3ff,
  0x2c2 & 0x3ff,
  0x2be & 0x3ff,
  0x2ba & 0x3ff,
  0x2b8 & 0x3ff,
  0x2b4 & 0x3ff,
  0x2b0 & 0x3ff,
  0x2ac & 0x3ff,
  0x2a8 & 0x3ff,
  0x2a6 & 0x3ff,
  0x2a2 & 0x3ff,
  0x29e & 0x3ff,
  0x29c & 0x3ff,
  0x298 & 0x3ff,
  0x294 & 0x3ff,
  0x290 & 0x3ff,
  0x28e & 0x3ff,
  0x28a & 0x3ff,
  0x288 & 0x3ff,
  0x284 & 0x3ff,
  0x280 & 0x3ff,
  0x27e & 0x3ff,
  0x27a & 0x3ff,
  0x278 & 0x3ff,
  0x274 & 0x3ff,
  0x272 & 0x3ff,
  0x26e & 0x3ff,
  0x26c & 0x3ff,
  0x268 & 0x3ff,
  0x266 & 0x3ff,
  0x264 & 0x3ff,
  0x260 & 0x3ff,
  0x25e & 0x3ff,
  0x25a & 0x3ff,
  0x258 & 0x3ff,
  0x254 & 0x3ff,
  0x252 & 0x3ff,
  0x250 & 0x3ff,
  0x24c & 0x3ff,
  0x24a & 0x3ff,
  0x248 & 0x3ff,
  0x246 & 0x3ff,
  0x242 & 0x3ff,
  0x240 & 0x3ff,
  0x23e & 0x3ff,
  0x23c & 0x3ff,
  0x238 & 0x3ff,
  0x236 & 0x3ff,
  0x234 & 0x3ff,
  0x232 & 0x3ff,
  0x230 & 0x3ff,
  0x22c & 0x3ff,
  0x22a & 0x3ff,
  0x228 & 0x3ff,
  0x226 & 0x3ff,
  0x224 & 0x3ff,
  0x220 & 0x3ff,
  0x21e & 0x3ff,
  0x21c & 0x3ff,
  0x21a & 0x3ff,
  0x218 & 0x3ff,
  0x216 & 0x3ff,
  0x214 & 0x3ff,
  0x212 & 0x3ff,
  0x210 & 0x3ff,
  0x20e & 0x3ff,
  0x20c & 0x3ff,
  0x208 & 0x3ff,
  0x208 & 0x3ff,
  0x204 & 0x3ff,
  0x204 & 0x3ff,
  0x201 & 0x3ff,
  0
};

/* constant table RSQRT_10b_256 */
static const unsigned CONST_TBL_RSQRT_10b_256_0[] = {
  0x1a5 & 0x3ff,
  0x1a0 & 0x3ff,
  0x19a & 0x3ff,
  0x195 & 0x3ff,
  0x18f & 0x3ff,
  0x18a & 0x3ff,
  0x185 & 0x3ff,
  0x180 & 0x3ff,
  0x17a & 0x3ff,
  0x175 & 0x3ff,
  0x170 & 0x3ff,
  0x16b & 0x3ff,
  0x166 & 0x3ff,
  0x161 & 0x3ff,
  0x15d & 0x3ff,
  0x158 & 0x3ff,
  0x153 & 0x3ff,
  0x14e & 0x3ff,
  0x14a & 0x3ff,
  0x145 & 0x3ff,
  0x140 & 0x3ff,
  0x13c & 0x3ff,
  0x138 & 0x3ff,
  0x133 & 0x3ff,
  0x12f & 0x3ff,
  0x12a & 0x3ff,
  0x126 & 0x3ff,
  0x122 & 0x3ff,
  0x11e & 0x3ff,
  0x11a & 0x3ff,
  0x115 & 0x3ff,
  0x111 & 0x3ff,
  0x10d & 0x3ff,
  0x109 & 0x3ff,
  0x105 & 0x3ff,
  0x101 & 0x3ff,
  0xfd & 0x3ff,
  0xfa & 0x3ff,
  0xf6 & 0x3ff,
  0xf2 & 0x3ff,
  0xee & 0x3ff,
  0xea & 0x3ff,
  0xe7 & 0x3ff,
  0xe3 & 0x3ff,
  0xdf & 0x3ff,
  0xdc & 0x3ff,
  0xd8 & 0x3ff,
  0xd5 & 0x3ff,
  0xd1 & 0x3ff,
  0xce & 0x3ff,
  0xca & 0x3ff,
  0xc7 & 0x3ff,
  0xc3 & 0x3ff,
  0xc0 & 0x3ff,
  0xbd & 0x3ff,
  0xb9 & 0x3ff,
  0xb6 & 0x3ff,
  0xb3 & 0x3ff,
  0xb0 & 0x3ff,
  0xad & 0x3ff,
  0xa9 & 0x3ff,
  0xa6 & 0x3ff,
  0xa3 & 0x3ff,
  0xa0 & 0x3ff,
  0x9d & 0x3ff,
  0x9a & 0x3ff,
  0x97 & 0x3ff,
  0x94 & 0x3ff,
  0x91 & 0x3ff,
  0x8e & 0x3ff,
  0x8b & 0x3ff,
  0x88 & 0x3ff,
  0x85 & 0x3ff,
  0x82 & 0x3ff,
  0x7f & 0x3ff,
  0x7d & 0x3ff,
  0x7a & 0x3ff,
  0x77 & 0x3ff,
  0x74 & 0x3ff,
  0x71 & 0x3ff,
  0x6f & 0x3ff,
  0x6c & 0x3ff,
  0x69 & 0x3ff,
  0x67 & 0x3ff,
  0x64 & 0x3ff,
  0x61 & 0x3ff,
  0x5f & 0x3ff,
  0x5c & 0x3ff,
  0x5a & 0x3ff,
  0x57 & 0x3ff,
  0x54 & 0x3ff,
  0x52 & 0x3ff,
  0x4f & 0x3ff,
  0x4d & 0x3ff,
  0x4a & 0x3ff,
  0x48 & 0x3ff,
  0x45 & 0x3ff,
  0x43 & 0x3ff,
  0x41 & 0x3ff,
  0x3e & 0x3ff,
  0x3c & 0x3ff,
  0x3a & 0x3ff,
  0x37 & 0x3ff,
  0x35 & 0x3ff,
  0x33 & 0x3ff,
  0x30 & 0x3ff,
  0x2e & 0x3ff,
  0x2c & 0x3ff,
  0x29 & 0x3ff,
  0x27 & 0x3ff,
  0x25 & 0x3ff,
  0x23 & 0x3ff,
  0x20 & 0x3ff,
  0x1e & 0x3ff,
  0x1c & 0x3ff,
  0x1a & 0x3ff,
  0x18 & 0x3ff,
  0x16 & 0x3ff,
  0x14 & 0x3ff,
  0x11 & 0x3ff,
  0xf & 0x3ff,
  0xd & 0x3ff,
  0xb & 0x3ff,
  0x9 & 0x3ff,
  0x7 & 0x3ff,
  0x5 & 0x3ff,
  0x3 & 0x3ff,
  0x1 & 0x3ff,
  0x3fc & 0x3ff,
  0x3f4 & 0x3ff,
  0x3ec & 0x3ff,
  0x3e5 & 0x3ff,
  0x3dd & 0x3ff,
  0x3d5 & 0x3ff,
  0x3ce & 0x3ff,
  0x3c7 & 0x3ff,
  0x3bf & 0x3ff,
  0x3b8 & 0x3ff,
  0x3b1 & 0x3ff,
  0x3aa & 0x3ff,
  0x3a3 & 0x3ff,
  0x39c & 0x3ff,
  0x395 & 0x3ff,
  0x38e & 0x3ff,
  0x388 & 0x3ff,
  0x381 & 0x3ff,
  0x37a & 0x3ff,
  0x374 & 0x3ff,
  0x36d & 0x3ff,
  0x367 & 0x3ff,
  0x361 & 0x3ff,
  0x35a & 0x3ff,
  0x354 & 0x3ff,
  0x34e & 0x3ff,
  0x348 & 0x3ff,
  0x342 & 0x3ff,
  0x33c & 0x3ff,
  0x336 & 0x3ff,
  0x330 & 0x3ff,
  0x32b & 0x3ff,
  0x325 & 0x3ff,
  0x31f & 0x3ff,
  0x31a & 0x3ff,
  0x314 & 0x3ff,
  0x30f & 0x3ff,
  0x309 & 0x3ff,
  0x304 & 0x3ff,
  0x2fe & 0x3ff,
  0x2f9 & 0x3ff,
  0x2f4 & 0x3ff,
  0x2ee & 0x3ff,
  0x2e9 & 0x3ff,
  0x2e4 & 0x3ff,
  0x2df & 0x3ff,
  0x2da & 0x3ff,
  0x2d5 & 0x3ff,
  0x2d0 & 0x3ff,
  0x2cb & 0x3ff,
  0x2c6 & 0x3ff,
  0x2c1 & 0x3ff,
  0x2bd & 0x3ff,
  0x2b8 & 0x3ff,
  0x2b3 & 0x3ff,
  0x2ae & 0x3ff,
  0x2aa & 0x3ff,
  0x2a5 & 0x3ff,
  0x2a1 & 0x3ff,
  0x29c & 0x3ff,
  0x298 & 0x3ff,
  0x293 & 0x3ff,
  0x28f & 0x3ff,
  0x28a & 0x3ff,
  0x286 & 0x3ff,
  0x282 & 0x3ff,
  0x27d & 0x3ff,
  0x279 & 0x3ff,
  0x275 & 0x3ff,
  0x271 & 0x3ff,
  0x26d & 0x3ff,
  0x268 & 0x3ff,
  0x264 & 0x3ff,
  0x260 & 0x3ff,
  0x25c & 0x3ff,
  0x258 & 0x3ff,
  0x254 & 0x3ff,
  0x250 & 0x3ff,
  0x24c & 0x3ff,
  0x249 & 0x3ff,
  0x245 & 0x3ff,
  0x241 & 0x3ff,
  0x23d & 0x3ff,
  0x239 & 0x3ff,
  0x235 & 0x3ff,
  0x232 & 0x3ff,
  0x22e & 0x3ff,
  0x22a & 0x3ff,
  0x227 & 0x3ff,
  0x223 & 0x3ff,
  0x220 & 0x3ff,
  0x21c & 0x3ff,
  0x218 & 0x3ff,
  0x215 & 0x3ff,
  0x211 & 0x3ff,
  0x20e & 0x3ff,
  0x20a & 0x3ff,
  0x207 & 0x3ff,
  0x204 & 0x3ff,
  0x200 & 0x3ff,
  0x1fd & 0x3ff,
  0x1f9 & 0x3ff,
  0x1f6 & 0x3ff,
  0x1f3 & 0x3ff,
  0x1f0 & 0x3ff,
  0x1ec & 0x3ff,
  0x1e9 & 0x3ff,
  0x1e6 & 0x3ff,
  0x1e3 & 0x3ff,
  0x1df & 0x3ff,
  0x1dc & 0x3ff,
  0x1d9 & 0x3ff,
  0x1d6 & 0x3ff,
  0x1d3 & 0x3ff,
  0x1d0 & 0x3ff,
  0x1cd & 0x3ff,
  0x1ca & 0x3ff,
  0x1c7 & 0x3ff,
  0x1c4 & 0x3ff,
  0x1c1 & 0x3ff,
  0x1be & 0x3ff,
  0x1bb & 0x3ff,
  0x1b8 & 0x3ff,
  0x1b5 & 0x3ff,
  0x1b2 & 0x3ff,
  0x1af & 0x3ff,
  0x1ac & 0x3ff,
  0x1aa & 0x3ff,
  0
};

/* constant table RECIP_10b_256 */
static const unsigned CONST_TBL_RECIP_10b_256_0[] = {
  0x3fc & 0x3ff,
  0x3f4 & 0x3ff,
  0x3ec & 0x3ff,
  0x3e4 & 0x3ff,
  0x3dd & 0x3ff,
  0x3d5 & 0x3ff,
  0x3cd & 0x3ff,
  0x3c6 & 0x3ff,
  0x3be & 0x3ff,
  0x3b7 & 0x3ff,
  0x3af & 0x3ff,
  0x3a8 & 0x3ff,
  0x3a1 & 0x3ff,
  0x399 & 0x3ff,
  0x392 & 0x3ff,
  0x38b & 0x3ff,
  0x384 & 0x3ff,
  0x37d & 0x3ff,
  0x376 & 0x3ff,
  0x36f & 0x3ff,
  0x368 & 0x3ff,
  0x361 & 0x3ff,
  0x35b & 0x3ff,
  0x354 & 0x3ff,
  0x34d & 0x3ff,
  0x346 & 0x3ff,
  0x340 & 0x3ff,
  0x339 & 0x3ff,
  0x333 & 0x3ff,
  0x32c & 0x3ff,
  0x326 & 0x3ff,
  0x320 & 0x3ff,
  0x319 & 0x3ff,
  0x313 & 0x3ff,
  0x30d & 0x3ff,
  0x307 & 0x3ff,
  0x300 & 0x3ff,
  0x2fa & 0x3ff,
  0x2f4 & 0x3ff,
  0x2ee & 0x3ff,
  0x2e8 & 0x3ff,
  0x2e2 & 0x3ff,
  0x2dc & 0x3ff,
  0x2d7 & 0x3ff,
  0x2d1 & 0x3ff,
  0x2cb & 0x3ff,
  0x2c5 & 0x3ff,
  0x2bf & 0x3ff,
  0x2ba & 0x3ff,
  0x2b4 & 0x3ff,
  0x2af & 0x3ff,
  0x2a9 & 0x3ff,
  0x2a3 & 0x3ff,
  0x29e & 0x3ff,
  0x299 & 0x3ff,
  0x293 & 0x3ff,
  0x28e & 0x3ff,
  0x288 & 0x3ff,
  0x283 & 0x3ff,
  0x27e & 0x3ff,
  0x279 & 0x3ff,
  0x273 & 0x3ff,
  0x26e & 0x3ff,
  0x269 & 0x3ff,
  0x264 & 0x3ff,
  0x25f & 0x3ff,
  0x25a & 0x3ff,
  0x255 & 0x3ff,
  0x250 & 0x3ff,
  0x24b & 0x3ff,
  0x246 & 0x3ff,
  0x241 & 0x3ff,
  0x23c & 0x3ff,
  0x237 & 0x3ff,
  0x232 & 0x3ff,
  0x22e & 0x3ff,
  0x229 & 0x3ff,
  0x224 & 0x3ff,
  0x21f & 0x3ff,
  0x21b & 0x3ff,
  0x216 & 0x3ff,
  0x211 & 0x3ff,
  0x20d & 0x3ff,
  0x208 & 0x3ff,
  0x204 & 0x3ff,
  0x1ff & 0x3ff,
  0x1fb & 0x3ff,
  0x1f6 & 0x3ff,
  0x1f2 & 0x3ff,
  0x1ed & 0x3ff,
  0x1e9 & 0x3ff,
  0x1e5 & 0x3ff,
  0x1e0 & 0x3ff,
  0x1dc & 0x3ff,
  0x1d8 & 0x3ff,
  0x1d4 & 0x3ff,
  0x1cf & 0x3ff,
  0x1cb & 0x3ff,
  0x1c7 & 0x3ff,
  0x1c3 & 0x3ff,
  0x1bf & 0x3ff,
  0x1bb & 0x3ff,
  0x1b6 & 0x3ff,
  0x1b2 & 0x3ff,
  0x1ae & 0x3ff,
  0x1aa & 0x3ff,
  0x1a6 & 0x3ff,
  0x1a2 & 0x3ff,
  0x19e & 0x3ff,
  0x19a & 0x3ff,
  0x197 & 0x3ff,
  0x193 & 0x3ff,
  0x18f & 0x3ff,
  0x18b & 0x3ff,
  0x187 & 0x3ff,
  0x183 & 0x3ff,
  0x17f & 0x3ff,
  0x17c & 0x3ff,
  0x178 & 0x3ff,
  0x174 & 0x3ff,
  0x171 & 0x3ff,
  0x16d & 0x3ff,
  0x169 & 0x3ff,
  0x166 & 0x3ff,
  0x162 & 0x3ff,
  0x15e & 0x3ff,
  0x15b & 0x3ff,
  0x157 & 0x3ff,
  0x154 & 0x3ff,
  0x150 & 0x3ff,
  0x14d & 0x3ff,
  0x149 & 0x3ff,
  0x146 & 0x3ff,
  0x142 & 0x3ff,
  0x13f & 0x3ff,
  0x13b & 0x3ff,
  0x138 & 0x3ff,
  0x134 & 0x3ff,
  0x131 & 0x3ff,
  0x12e & 0x3ff,
  0x12a & 0x3ff,
  0x127 & 0x3ff,
  0x124 & 0x3ff,
  0x120 & 0x3ff,
  0x11d & 0x3ff,
  0x11a & 0x3ff,
  0x117 & 0x3ff,
  0x113 & 0x3ff,
  0x110 & 0x3ff,
  0x10d & 0x3ff,
  0x10a & 0x3ff,
  0x107 & 0x3ff,
  0x103 & 0x3ff,
  0x100 & 0x3ff,
  0xfd & 0x3ff,
  0xfa & 0x3ff,
  0xf7 & 0x3ff,
  0xf4 & 0x3ff,
  0xf1 & 0x3ff,
  0xee & 0x3ff,
  0xeb & 0x3ff,
  0xe8 & 0x3ff,
  0xe5 & 0x3ff,
  0xe2 & 0x3ff,
  0xdf & 0x3ff,
  0xdc & 0x3ff,
  0xd9 & 0x3ff,
  0xd6 & 0x3ff,
  0xd3 & 0x3ff,
  0xd0 & 0x3ff,
  0xcd & 0x3ff,
  0xca & 0x3ff,
  0xc8 & 0x3ff,
  0xc5 & 0x3ff,
  0xc2 & 0x3ff,
  0xbf & 0x3ff,
  0xbc & 0x3ff,
  0xb9 & 0x3ff,
  0xb7 & 0x3ff,
  0xb4 & 0x3ff,
  0xb1 & 0x3ff,
  0xae & 0x3ff,
  0xac & 0x3ff,
  0xa9 & 0x3ff,
  0xa6 & 0x3ff,
  0xa4 & 0x3ff,
  0xa1 & 0x3ff,
  0x9e & 0x3ff,
  0x9c & 0x3ff,
  0x99 & 0x3ff,
  0x96 & 0x3ff,
  0x94 & 0x3ff,
  0x91 & 0x3ff,
  0x8e & 0x3ff,
  0x8c & 0x3ff,
  0x89 & 0x3ff,
  0x87 & 0x3ff,
  0x84 & 0x3ff,
  0x82 & 0x3ff,
  0x7f & 0x3ff,
  0x7c & 0x3ff,
  0x7a & 0x3ff,
  0x77 & 0x3ff,
  0x75 & 0x3ff,
  0x73 & 0x3ff,
  0x70 & 0x3ff,
  0x6e & 0x3ff,
  0x6b & 0x3ff,
  0x69 & 0x3ff,
  0x66 & 0x3ff,
  0x64 & 0x3ff,
  0x61 & 0x3ff,
  0x5f & 0x3ff,
  0x5d & 0x3ff,
  0x5a & 0x3ff,
  0x58 & 0x3ff,
  0x56 & 0x3ff,
  0x53 & 0x3ff,
  0x51 & 0x3ff,
  0x4f & 0x3ff,
  0x4c & 0x3ff,
  0x4a & 0x3ff,
  0x48 & 0x3ff,
  0x45 & 0x3ff,
  0x43 & 0x3ff,
  0x41 & 0x3ff,
  0x3f & 0x3ff,
  0x3c & 0x3ff,
  0x3a & 0x3ff,
  0x38 & 0x3ff,
  0x36 & 0x3ff,
  0x33 & 0x3ff,
  0x31 & 0x3ff,
  0x2f & 0x3ff,
  0x2d & 0x3ff,
  0x2b & 0x3ff,
  0x29 & 0x3ff,
  0x26 & 0x3ff,
  0x24 & 0x3ff,
  0x22 & 0x3ff,
  0x20 & 0x3ff,
  0x1e & 0x3ff,
  0x1c & 0x3ff,
  0x1a & 0x3ff,
  0x18 & 0x3ff,
  0x15 & 0x3ff,
  0x13 & 0x3ff,
  0x11 & 0x3ff,
  0xf & 0x3ff,
  0xd & 0x3ff,
  0xb & 0x3ff,
  0x9 & 0x3ff,
  0x7 & 0x3ff,
  0x5 & 0x3ff,
  0x3 & 0x3ff,
  0x1 & 0x3ff,
  0
};


/* Instruction operands.  */

static int
OperandSem_opnd_sem_soffsetx4_decode (uint32 *valp)
{
  unsigned soffsetx4_out_0;
  unsigned soffsetx4_in_0;
  soffsetx4_in_0 = *valp & 0x3ffff;
  soffsetx4_out_0 = 0x4 + ((((int) soffsetx4_in_0 << 14) >> 14) << 2);
  *valp = soffsetx4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_soffsetx4_encode (uint32 *valp)
{
  unsigned soffsetx4_in_0;
  unsigned soffsetx4_out_0;
  soffsetx4_out_0 = *valp;
  soffsetx4_in_0 = ((soffsetx4_out_0 - 0x4) >> 2) & 0x3ffff;
  *valp = soffsetx4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm12x8_decode (uint32 *valp)
{
  unsigned uimm12x8_out_0;
  unsigned uimm12x8_in_0;
  uimm12x8_in_0 = *valp & 0xfff;
  uimm12x8_out_0 = uimm12x8_in_0 << 3;
  *valp = uimm12x8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm12x8_encode (uint32 *valp)
{
  unsigned uimm12x8_in_0;
  unsigned uimm12x8_out_0;
  uimm12x8_out_0 = *valp;
  uimm12x8_in_0 = ((uimm12x8_out_0 >> 3) & 0xfff);
  *valp = uimm12x8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm4_decode (uint32 *valp)
{
  unsigned simm4_out_0;
  unsigned simm4_in_0;
  simm4_in_0 = *valp & 0xf;
  simm4_out_0 = ((int) simm4_in_0 << 28) >> 28;
  *valp = simm4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm4_encode (uint32 *valp)
{
  unsigned simm4_in_0;
  unsigned simm4_out_0;
  simm4_out_0 = *valp;
  simm4_in_0 = (simm4_out_0 & 0xf);
  *valp = simm4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_AR_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 64);
  return error;
}

static int
OperandSem_opnd_sem_AR_0_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_0_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 64);
  return error;
}

static int
OperandSem_opnd_sem_AR_1_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_1_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 64);
  return error;
}

static int
OperandSem_opnd_sem_AR_2_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_2_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 64);
  return error;
}

static int
OperandSem_opnd_sem_AR_3_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_3_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 64);
  return error;
}

static int
OperandSem_opnd_sem_AR_4_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_4_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 64);
  return error;
}

static int
OperandSem_opnd_sem_immrx4_decode (uint32 *valp)
{
  unsigned immrx4_out_0;
  unsigned immrx4_in_0;
  immrx4_in_0 = *valp & 0xf;
  immrx4_out_0 = (((0xfffffff) << 4) | immrx4_in_0) << 2;
  *valp = immrx4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_immrx4_encode (uint32 *valp)
{
  unsigned immrx4_in_0;
  unsigned immrx4_out_0;
  immrx4_out_0 = *valp;
  immrx4_in_0 = ((immrx4_out_0 >> 2) & 0xf);
  *valp = immrx4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_lsi4x4_decode (uint32 *valp)
{
  unsigned lsi4x4_out_0;
  unsigned lsi4x4_in_0;
  lsi4x4_in_0 = *valp & 0xf;
  lsi4x4_out_0 = lsi4x4_in_0 << 2;
  *valp = lsi4x4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_lsi4x4_encode (uint32 *valp)
{
  unsigned lsi4x4_in_0;
  unsigned lsi4x4_out_0;
  lsi4x4_out_0 = *valp;
  lsi4x4_in_0 = ((lsi4x4_out_0 >> 2) & 0xf);
  *valp = lsi4x4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm7_decode (uint32 *valp)
{
  unsigned simm7_out_0;
  unsigned simm7_in_0;
  simm7_in_0 = *valp & 0x7f;
  simm7_out_0 = ((((-((((simm7_in_0 >> 6) & 1)) & (((simm7_in_0 >> 5) & 1)))) & 0x1ffffff)) << 7) | simm7_in_0;
  *valp = simm7_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm7_encode (uint32 *valp)
{
  unsigned simm7_in_0;
  unsigned simm7_out_0;
  simm7_out_0 = *valp;
  simm7_in_0 = (simm7_out_0 & 0x7f);
  *valp = simm7_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm6_decode (uint32 *valp)
{
  unsigned uimm6_out_0;
  unsigned uimm6_in_0;
  uimm6_in_0 = *valp & 0x3f;
  uimm6_out_0 = 0x4 + (((0) << 6) | uimm6_in_0);
  *valp = uimm6_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm6_encode (uint32 *valp)
{
  unsigned uimm6_in_0;
  unsigned uimm6_out_0;
  uimm6_out_0 = *valp;
  uimm6_in_0 = (uimm6_out_0 - 0x4) & 0x3f;
  *valp = uimm6_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ai4const_decode (uint32 *valp)
{
  unsigned ai4const_out_0;
  unsigned ai4const_in_0;
  ai4const_in_0 = *valp & 0xf;
  ai4const_out_0 = CONST_TBL_ai4c_0[ai4const_in_0 & 0xf];
  *valp = ai4const_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ai4const_encode (uint32 *valp)
{
  unsigned ai4const_in_0;
  unsigned ai4const_out_0;
  ai4const_out_0 = *valp;
  switch (ai4const_out_0)
    {
    case 0xffffffff: ai4const_in_0 = 0; break;
    case 0x1: ai4const_in_0 = 0x1; break;
    case 0x2: ai4const_in_0 = 0x2; break;
    case 0x3: ai4const_in_0 = 0x3; break;
    case 0x4: ai4const_in_0 = 0x4; break;
    case 0x5: ai4const_in_0 = 0x5; break;
    case 0x6: ai4const_in_0 = 0x6; break;
    case 0x7: ai4const_in_0 = 0x7; break;
    case 0x8: ai4const_in_0 = 0x8; break;
    case 0x9: ai4const_in_0 = 0x9; break;
    case 0xa: ai4const_in_0 = 0xa; break;
    case 0xb: ai4const_in_0 = 0xb; break;
    case 0xc: ai4const_in_0 = 0xc; break;
    case 0xd: ai4const_in_0 = 0xd; break;
    case 0xe: ai4const_in_0 = 0xe; break;
    default: ai4const_in_0 = 0xf; break;
    }
  *valp = ai4const_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4const_decode (uint32 *valp)
{
  unsigned b4const_out_0;
  unsigned b4const_in_0;
  b4const_in_0 = *valp & 0xf;
  b4const_out_0 = CONST_TBL_b4c_0[b4const_in_0 & 0xf];
  *valp = b4const_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4const_encode (uint32 *valp)
{
  unsigned b4const_in_0;
  unsigned b4const_out_0;
  b4const_out_0 = *valp;
  switch (b4const_out_0)
    {
    case 0xffffffff: b4const_in_0 = 0; break;
    case 0x1: b4const_in_0 = 0x1; break;
    case 0x2: b4const_in_0 = 0x2; break;
    case 0x3: b4const_in_0 = 0x3; break;
    case 0x4: b4const_in_0 = 0x4; break;
    case 0x5: b4const_in_0 = 0x5; break;
    case 0x6: b4const_in_0 = 0x6; break;
    case 0x7: b4const_in_0 = 0x7; break;
    case 0x8: b4const_in_0 = 0x8; break;
    case 0xa: b4const_in_0 = 0x9; break;
    case 0xc: b4const_in_0 = 0xa; break;
    case 0x10: b4const_in_0 = 0xb; break;
    case 0x20: b4const_in_0 = 0xc; break;
    case 0x40: b4const_in_0 = 0xd; break;
    case 0x80: b4const_in_0 = 0xe; break;
    default: b4const_in_0 = 0xf; break;
    }
  *valp = b4const_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4constu_decode (uint32 *valp)
{
  unsigned b4constu_out_0;
  unsigned b4constu_in_0;
  b4constu_in_0 = *valp & 0xf;
  b4constu_out_0 = CONST_TBL_b4cu_0[b4constu_in_0 & 0xf];
  *valp = b4constu_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4constu_encode (uint32 *valp)
{
  unsigned b4constu_in_0;
  unsigned b4constu_out_0;
  b4constu_out_0 = *valp;
  switch (b4constu_out_0)
    {
    case 0x8000: b4constu_in_0 = 0; break;
    case 0x10000: b4constu_in_0 = 0x1; break;
    case 0x2: b4constu_in_0 = 0x2; break;
    case 0x3: b4constu_in_0 = 0x3; break;
    case 0x4: b4constu_in_0 = 0x4; break;
    case 0x5: b4constu_in_0 = 0x5; break;
    case 0x6: b4constu_in_0 = 0x6; break;
    case 0x7: b4constu_in_0 = 0x7; break;
    case 0x8: b4constu_in_0 = 0x8; break;
    case 0xa: b4constu_in_0 = 0x9; break;
    case 0xc: b4constu_in_0 = 0xa; break;
    case 0x10: b4constu_in_0 = 0xb; break;
    case 0x20: b4constu_in_0 = 0xc; break;
    case 0x40: b4constu_in_0 = 0xd; break;
    case 0x80: b4constu_in_0 = 0xe; break;
    default: b4constu_in_0 = 0xf; break;
    }
  *valp = b4constu_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8_decode (uint32 *valp)
{
  unsigned uimm8_out_0;
  unsigned uimm8_in_0;
  uimm8_in_0 = *valp & 0xff;
  uimm8_out_0 = uimm8_in_0;
  *valp = uimm8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8_encode (uint32 *valp)
{
  unsigned uimm8_in_0;
  unsigned uimm8_out_0;
  uimm8_out_0 = *valp;
  uimm8_in_0 = (uimm8_out_0 & 0xff);
  *valp = uimm8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x2_decode (uint32 *valp)
{
  unsigned uimm8x2_out_0;
  unsigned uimm8x2_in_0;
  uimm8x2_in_0 = *valp & 0xff;
  uimm8x2_out_0 = uimm8x2_in_0 << 1;
  *valp = uimm8x2_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x2_encode (uint32 *valp)
{
  unsigned uimm8x2_in_0;
  unsigned uimm8x2_out_0;
  uimm8x2_out_0 = *valp;
  uimm8x2_in_0 = ((uimm8x2_out_0 >> 1) & 0xff);
  *valp = uimm8x2_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x4_decode (uint32 *valp)
{
  unsigned uimm8x4_out_0;
  unsigned uimm8x4_in_0;
  uimm8x4_in_0 = *valp & 0xff;
  uimm8x4_out_0 = uimm8x4_in_0 << 2;
  *valp = uimm8x4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x4_encode (uint32 *valp)
{
  unsigned uimm8x4_in_0;
  unsigned uimm8x4_out_0;
  uimm8x4_out_0 = *valp;
  uimm8x4_in_0 = ((uimm8x4_out_0 >> 2) & 0xff);
  *valp = uimm8x4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm4x16_decode (uint32 *valp)
{
  unsigned uimm4x16_out_0;
  unsigned uimm4x16_in_0;
  uimm4x16_in_0 = *valp & 0xf;
  uimm4x16_out_0 = uimm4x16_in_0 << 4;
  *valp = uimm4x16_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm4x16_encode (uint32 *valp)
{
  unsigned uimm4x16_in_0;
  unsigned uimm4x16_out_0;
  uimm4x16_out_0 = *valp;
  uimm4x16_in_0 = ((uimm4x16_out_0 >> 4) & 0xf);
  *valp = uimm4x16_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimmrx4_decode (uint32 *valp)
{
  unsigned uimmrx4_out_0;
  unsigned uimmrx4_in_0;
  uimmrx4_in_0 = *valp & 0xf;
  uimmrx4_out_0 = uimmrx4_in_0 << 2;
  *valp = uimmrx4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimmrx4_encode (uint32 *valp)
{
  unsigned uimmrx4_in_0;
  unsigned uimmrx4_out_0;
  uimmrx4_out_0 = *valp;
  uimmrx4_in_0 = ((uimmrx4_out_0 >> 2) & 0xf);
  *valp = uimmrx4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8_decode (uint32 *valp)
{
  unsigned simm8_out_0;
  unsigned simm8_in_0;
  simm8_in_0 = *valp & 0xff;
  simm8_out_0 = ((int) simm8_in_0 << 24) >> 24;
  *valp = simm8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8_encode (uint32 *valp)
{
  unsigned simm8_in_0;
  unsigned simm8_out_0;
  simm8_out_0 = *valp;
  simm8_in_0 = (simm8_out_0 & 0xff);
  *valp = simm8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8x256_decode (uint32 *valp)
{
  unsigned simm8x256_out_0;
  unsigned simm8x256_in_0;
  simm8x256_in_0 = *valp & 0xff;
  simm8x256_out_0 = (((int) simm8x256_in_0 << 24) >> 24) << 8;
  *valp = simm8x256_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8x256_encode (uint32 *valp)
{
  unsigned simm8x256_in_0;
  unsigned simm8x256_out_0;
  simm8x256_out_0 = *valp;
  simm8x256_in_0 = ((simm8x256_out_0 >> 8) & 0xff);
  *valp = simm8x256_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm12b_decode (uint32 *valp)
{
  unsigned simm12b_out_0;
  unsigned simm12b_in_0;
  simm12b_in_0 = *valp & 0xfff;
  simm12b_out_0 = ((int) simm12b_in_0 << 20) >> 20;
  *valp = simm12b_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm12b_encode (uint32 *valp)
{
  unsigned simm12b_in_0;
  unsigned simm12b_out_0;
  simm12b_out_0 = *valp;
  simm12b_in_0 = (simm12b_out_0 & 0xfff);
  *valp = simm12b_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_msalp32_decode (uint32 *valp)
{
  unsigned msalp32_out_0;
  unsigned msalp32_in_0;
  msalp32_in_0 = *valp & 0x1f;
  msalp32_out_0 = 0x20 - msalp32_in_0;
  *valp = msalp32_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_msalp32_encode (uint32 *valp)
{
  unsigned msalp32_in_0;
  unsigned msalp32_out_0;
  msalp32_out_0 = *valp;
  msalp32_in_0 = (0x20 - msalp32_out_0) & 0x1f;
  *valp = msalp32_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_op2p1_decode (uint32 *valp)
{
  unsigned op2p1_out_0;
  unsigned op2p1_in_0;
  op2p1_in_0 = *valp & 0xf;
  op2p1_out_0 = op2p1_in_0 + 0x1;
  *valp = op2p1_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_op2p1_encode (uint32 *valp)
{
  unsigned op2p1_in_0;
  unsigned op2p1_out_0;
  op2p1_out_0 = *valp;
  op2p1_in_0 = (op2p1_out_0 - 0x1) & 0xf;
  *valp = op2p1_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_label8_decode (uint32 *valp)
{
  unsigned label8_out_0;
  unsigned label8_in_0;
  label8_in_0 = *valp & 0xff;
  label8_out_0 = 0x4 + (((int) label8_in_0 << 24) >> 24);
  *valp = label8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_label8_encode (uint32 *valp)
{
  unsigned label8_in_0;
  unsigned label8_out_0;
  label8_out_0 = *valp;
  label8_in_0 = (label8_out_0 - 0x4) & 0xff;
  *valp = label8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ulabel8_decode (uint32 *valp)
{
  unsigned ulabel8_out_0;
  unsigned ulabel8_in_0;
  ulabel8_in_0 = *valp & 0xff;
  ulabel8_out_0 = 0x4 + (((0) << 8) | ulabel8_in_0);
  *valp = ulabel8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ulabel8_encode (uint32 *valp)
{
  unsigned ulabel8_in_0;
  unsigned ulabel8_out_0;
  ulabel8_out_0 = *valp;
  ulabel8_in_0 = (ulabel8_out_0 - 0x4) & 0xff;
  *valp = ulabel8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_label12_decode (uint32 *valp)
{
  unsigned label12_out_0;
  unsigned label12_in_0;
  label12_in_0 = *valp & 0xfff;
  label12_out_0 = 0x4 + (((int) label12_in_0 << 20) >> 20);
  *valp = label12_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_label12_encode (uint32 *valp)
{
  unsigned label12_in_0;
  unsigned label12_out_0;
  label12_out_0 = *valp;
  label12_in_0 = (label12_out_0 - 0x4) & 0xfff;
  *valp = label12_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_soffset_decode (uint32 *valp)
{
  unsigned soffset_out_0;
  unsigned soffset_in_0;
  soffset_in_0 = *valp & 0x3ffff;
  soffset_out_0 = 0x4 + (((int) soffset_in_0 << 14) >> 14);
  *valp = soffset_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_soffset_encode (uint32 *valp)
{
  unsigned soffset_in_0;
  unsigned soffset_out_0;
  soffset_out_0 = *valp;
  soffset_in_0 = (soffset_out_0 - 0x4) & 0x3ffff;
  *valp = soffset_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm16x4_decode (uint32 *valp)
{
  unsigned uimm16x4_out_0;
  unsigned uimm16x4_in_0;
  uimm16x4_in_0 = *valp & 0xffff;
  uimm16x4_out_0 = (((0xffff) << 16) | uimm16x4_in_0) << 2;
  *valp = uimm16x4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm16x4_encode (uint32 *valp)
{
  unsigned uimm16x4_in_0;
  unsigned uimm16x4_out_0;
  uimm16x4_out_0 = *valp;
  uimm16x4_in_0 = (uimm16x4_out_0 >> 2) & 0xffff;
  *valp = uimm16x4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_bbi_decode (uint32 *valp)
{
  unsigned bbi_out_0;
  unsigned bbi_in_0;
  bbi_in_0 = *valp & 0x1f;
  bbi_out_0 = (0 << 5) | bbi_in_0;
  *valp = bbi_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_bbi_encode (uint32 *valp)
{
  unsigned bbi_in_0;
  unsigned bbi_out_0;
  bbi_out_0 = *valp;
  bbi_in_0 = (bbi_out_0 & 0x1f);
  *valp = bbi_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_s_decode (uint32 *valp)
{
  unsigned s_out_0;
  unsigned s_in_0;
  s_in_0 = *valp & 0xf;
  s_out_0 = (0 << 4) | s_in_0;
  *valp = s_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_s_encode (uint32 *valp)
{
  unsigned s_in_0;
  unsigned s_out_0;
  s_out_0 = *valp;
  s_in_0 = (s_out_0 & 0xf);
  *valp = s_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_immt_decode (uint32 *valp)
{
  unsigned immt_out_0;
  unsigned immt_in_0;
  immt_in_0 = *valp & 0xf;
  immt_out_0 = immt_in_0;
  *valp = immt_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_immt_encode (uint32 *valp)
{
  unsigned immt_in_0;
  unsigned immt_out_0;
  immt_out_0 = *valp;
  immt_in_0 = immt_out_0 & 0xf;
  *valp = immt_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_BR_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_BR_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 16);
  return error;
}

static int
OperandSem_opnd_sem_BR2_decode (uint32 *valp)
{
  *valp = *valp << 1;
  return 0;
}

static int
OperandSem_opnd_sem_BR2_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 16) || ((*valp & 1) != 0);
  *valp = *valp >> 1;
  return error;
}

static int
OperandSem_opnd_sem_BR4_decode (uint32 *valp)
{
  *valp = *valp << 2;
  return 0;
}

static int
OperandSem_opnd_sem_BR4_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 16) || ((*valp & 3) != 0);
  *valp = *valp >> 2;
  return error;
}

static int
OperandSem_opnd_sem_BR8_decode (uint32 *valp)
{
  *valp = *valp << 3;
  return 0;
}

static int
OperandSem_opnd_sem_BR8_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 16) || ((*valp & 7) != 0);
  *valp = *valp >> 3;
  return error;
}

static int
OperandSem_opnd_sem_BR16_decode (uint32 *valp)
{
  *valp = *valp << 4;
  return 0;
}

static int
OperandSem_opnd_sem_BR16_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 16) || ((*valp & 15) != 0);
  *valp = *valp >> 4;
  return error;
}

static int
OperandSem_opnd_sem_tp7_decode (uint32 *valp)
{
  unsigned tp7_out_0;
  unsigned tp7_in_0;
  tp7_in_0 = *valp & 0xf;
  tp7_out_0 = tp7_in_0 + 0x7;
  *valp = tp7_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_tp7_encode (uint32 *valp)
{
  unsigned tp7_in_0;
  unsigned tp7_out_0;
  tp7_out_0 = *valp;
  tp7_in_0 = (tp7_out_0 - 0x7) & 0xf;
  *valp = tp7_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_xt_wbr15_label_decode (uint32 *valp)
{
  unsigned xt_wbr15_label_out_0;
  unsigned xt_wbr15_label_in_0;
  xt_wbr15_label_in_0 = *valp & 0x7fff;
  xt_wbr15_label_out_0 = 0x4 + (((int) xt_wbr15_label_in_0 << 17) >> 17);
  *valp = xt_wbr15_label_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_xt_wbr15_label_encode (uint32 *valp)
{
  unsigned xt_wbr15_label_in_0;
  unsigned xt_wbr15_label_out_0;
  xt_wbr15_label_out_0 = *valp;
  xt_wbr15_label_in_0 = (xt_wbr15_label_out_0 - 0x4) & 0x7fff;
  *valp = xt_wbr15_label_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_xt_wbr18_label_decode (uint32 *valp)
{
  unsigned xt_wbr18_label_out_0;
  unsigned xt_wbr18_label_in_0;
  xt_wbr18_label_in_0 = *valp & 0x3ffff;
  xt_wbr18_label_out_0 = 0x4 + (((int) xt_wbr18_label_in_0 << 14) >> 14);
  *valp = xt_wbr18_label_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_xt_wbr18_label_encode (uint32 *valp)
{
  unsigned xt_wbr18_label_in_0;
  unsigned xt_wbr18_label_out_0;
  xt_wbr18_label_out_0 = *valp;
  xt_wbr18_label_in_0 = (xt_wbr18_label_out_0 - 0x4) & 0x3ffff;
  *valp = xt_wbr18_label_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_ohba_decode (uint32 *valp)
{
  unsigned ae_ohba_out_0;
  unsigned ae_ohba_in_0;
  ae_ohba_in_0 = *valp & 0xf;
  ae_ohba_out_0 = (0 << 5) | (((((ae_ohba_in_0 & 0xf))) == 0) << 4) | ((ae_ohba_in_0 & 0xf));
  *valp = ae_ohba_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_ohba_encode (uint32 *valp)
{
  unsigned ae_ohba_in_0;
  unsigned ae_ohba_out_0;
  ae_ohba_out_0 = *valp;
  ae_ohba_in_0 = (ae_ohba_out_0 & 0xf);
  *valp = ae_ohba_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_opnd_tp7_decode (uint32 *valp)
{
  unsigned ae_opnd_tp7_out_0;
  unsigned ae_opnd_tp7_in_0;
  ae_opnd_tp7_in_0 = *valp & 0xf;
  ae_opnd_tp7_out_0 = ae_opnd_tp7_in_0 + 0x7;
  *valp = ae_opnd_tp7_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_opnd_tp7_encode (uint32 *valp)
{
  unsigned ae_opnd_tp7_in_0;
  unsigned ae_opnd_tp7_out_0;
  ae_opnd_tp7_out_0 = *valp;
  ae_opnd_tp7_in_0 = (ae_opnd_tp7_out_0 - 0x7) & 0xf;
  *valp = ae_opnd_tp7_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_imm2_decode (uint32 *valp)
{
  unsigned ae_imm2_out_0;
  unsigned ae_imm2_in_0;
  ae_imm2_in_0 = *valp & 0x3;
  ae_imm2_out_0 = (0 << 2) | ae_imm2_in_0;
  *valp = ae_imm2_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_imm2_encode (uint32 *valp)
{
  unsigned ae_imm2_in_0;
  unsigned ae_imm2_out_0;
  ae_imm2_out_0 = *valp;
  ae_imm2_in_0 = (ae_imm2_out_0 & 0x3);
  *valp = ae_imm2_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa32_decode (uint32 *valp)
{
  unsigned ae_osa32_out_0;
  unsigned ae_osa32_in_0;
  ae_osa32_in_0 = *valp & 0x1f;
  ae_osa32_out_0 = (0 << 5) | ae_osa32_in_0;
  *valp = ae_osa32_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa32_encode (uint32 *valp)
{
  unsigned ae_osa32_in_0;
  unsigned ae_osa32_out_0;
  ae_osa32_out_0 = *valp;
  ae_osa32_in_0 = (ae_osa32_out_0 & 0x1f);
  *valp = ae_osa32_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa64_decode (uint32 *valp)
{
  unsigned ae_osa64_out_0;
  unsigned ae_osa64_in_0;
  ae_osa64_in_0 = *valp & 0x3f;
  ae_osa64_out_0 = (0 << 6) | ae_osa64_in_0;
  *valp = ae_osa64_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa64_encode (uint32 *valp)
{
  unsigned ae_osa64_in_0;
  unsigned ae_osa64_out_0;
  ae_osa64_out_0 = *valp;
  ae_osa64_in_0 = (ae_osa64_out_0 & 0x3f);
  *valp = ae_osa64_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls64_decode (uint32 *valp)
{
  unsigned ae_immls64_out_0;
  unsigned ae_immls64_in_0;
  ae_immls64_in_0 = *valp & 0xf;
  ae_immls64_out_0 = (((int) ae_immls64_in_0 << 28) >> 28) << 3;
  *valp = ae_immls64_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls64_encode (uint32 *valp)
{
  unsigned ae_immls64_in_0;
  unsigned ae_immls64_out_0;
  ae_immls64_out_0 = *valp;
  ae_immls64_in_0 = ((ae_immls64_out_0 >> 3) & 0xf);
  *valp = ae_immls64_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls64pos_decode (uint32 *valp)
{
  unsigned ae_immls64pos_out_0;
  unsigned ae_immls64pos_in_0;
  ae_immls64pos_in_0 = *valp & 0x7;
  ae_immls64pos_out_0 = ((0 << 3) | ae_immls64pos_in_0) << 3;
  *valp = ae_immls64pos_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls64pos_encode (uint32 *valp)
{
  unsigned ae_immls64pos_in_0;
  unsigned ae_immls64pos_out_0;
  ae_immls64pos_out_0 = *valp;
  ae_immls64pos_in_0 = ((ae_immls64pos_out_0 >> 3) & 0x7);
  *valp = ae_immls64pos_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls32_decode (uint32 *valp)
{
  unsigned ae_immls32_out_0;
  unsigned ae_immls32_in_0;
  ae_immls32_in_0 = *valp & 0xf;
  ae_immls32_out_0 = (((int) ae_immls32_in_0 << 28) >> 28) << 2;
  *valp = ae_immls32_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls32_encode (uint32 *valp)
{
  unsigned ae_immls32_in_0;
  unsigned ae_immls32_out_0;
  ae_immls32_out_0 = *valp;
  ae_immls32_in_0 = ((ae_immls32_out_0 >> 2) & 0xf);
  *valp = ae_immls32_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls16_decode (uint32 *valp)
{
  unsigned ae_immls16_out_0;
  unsigned ae_immls16_in_0;
  ae_immls16_in_0 = *valp & 0xf;
  ae_immls16_out_0 = (((int) ae_immls16_in_0 << 28) >> 28) << 1;
  *valp = ae_immls16_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls16_encode (uint32 *valp)
{
  unsigned ae_immls16_in_0;
  unsigned ae_immls16_out_0;
  ae_immls16_out_0 = *valp;
  ae_immls16_in_0 = ((ae_immls16_out_0 >> 1) & 0xf);
  *valp = ae_immls16_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa16_decode (uint32 *valp)
{
  unsigned ae_osa16_out_0;
  unsigned ae_osa16_in_0;
  ae_osa16_in_0 = *valp & 0xf;
  ae_osa16_out_0 = (0 << 4) | ae_osa16_in_0;
  *valp = ae_osa16_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa16_encode (uint32 *valp)
{
  unsigned ae_osa16_in_0;
  unsigned ae_osa16_out_0;
  ae_osa16_out_0 = *valp;
  ae_osa16_in_0 = (ae_osa16_out_0 & 0xf);
  *valp = ae_osa16_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_selimm_N_decode (uint32 *valp)
{
  unsigned ae_selimm_N_out_0;
  unsigned ae_selimm_N_in_0;
  ae_selimm_N_in_0 = *valp & 0x3;
  ae_selimm_N_out_0 = (0 << 2) | ae_selimm_N_in_0;
  *valp = ae_selimm_N_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_selimm_N_encode (uint32 *valp)
{
  unsigned ae_selimm_N_in_0;
  unsigned ae_selimm_N_out_0;
  ae_selimm_N_out_0 = *valp;
  ae_selimm_N_in_0 = (ae_selimm_N_out_0 & 0x3);
  *valp = ae_selimm_N_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_movi_imm_decode (uint32 *valp)
{
  unsigned movi_imm_out_0;
  unsigned movi_imm_in_0;
  movi_imm_in_0 = *valp & 0x3f;
  movi_imm_out_0 = ((((-(( ( ((((movi_imm_in_0 >> 4) & 0x3)) | 0xfffffffc)) == 0xffffffff))) & 0x3ffffff)) << 6) | movi_imm_in_0;
  *valp = movi_imm_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_movi_imm_encode (uint32 *valp)
{
  unsigned movi_imm_in_0;
  unsigned movi_imm_out_0;
  movi_imm_out_0 = *valp;
  movi_imm_in_0 = (movi_imm_out_0 & 0x3f);
  *valp = movi_imm_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_AE_DR_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AE_DR_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 16);
  return error;
}

static int
OperandSem_opnd_sem_AE_VALIGN_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AE_VALIGN_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_FR_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_FR_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 16);
  return error;
}

static int
OperandSem_opnd_sem_imm_t_decode (uint32 *valp)
{
  unsigned imm_t_out_0;
  unsigned imm_t_in_0;
  imm_t_in_0 = *valp & 0xf;
  imm_t_out_0 = (0 << 4) | imm_t_in_0;
  *valp = imm_t_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_imm_t_encode (uint32 *valp)
{
  unsigned imm_t_in_0;
  unsigned imm_t_out_0;
  imm_t_out_0 = *valp;
  imm_t_in_0 = (imm_t_out_0 & 0xf);
  *valp = imm_t_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_imm8x4_decode (uint32 *valp)
{
  unsigned imm8x4_out_0;
  unsigned imm8x4_in_0;
  imm8x4_in_0 = *valp & 0xff;
  imm8x4_out_0 = (0 << 10) | (imm8x4_in_0 << 2) | 0;
  *valp = imm8x4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_imm8x4_encode (uint32 *valp)
{
  unsigned imm8x4_in_0;
  unsigned imm8x4_out_0;
  imm8x4_out_0 = *valp;
  imm8x4_in_0 = ((imm8x4_out_0 >> 2) & 0xff);
  *valp = imm8x4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_imm8x8_decode (uint32 *valp)
{
  unsigned imm8x8_out_0;
  unsigned imm8x8_in_0;
  imm8x8_in_0 = *valp & 0xff;
  imm8x8_out_0 = (0 << 11) | (imm8x8_in_0 << 3) | 0;
  *valp = imm8x8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_imm8x8_encode (uint32 *valp)
{
  unsigned imm8x8_in_0;
  unsigned imm8x8_out_0;
  imm8x8_out_0 = *valp;
  imm8x8_in_0 = ((imm8x8_out_0 >> 3) & 0xff);
  *valp = imm8x8_in_0;
  return 0;
}

static int
Operand_soffsetx4_ator (uint32 *valp, uint32 pc)
{
  *valp -= (pc & ~0x3);
  return 0;
}

static int
Operand_soffsetx4_rtoa (uint32 *valp, uint32 pc)
{
  *valp += (pc & ~0x3);
  return 0;
}

static int
Operand_uimm6_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_uimm6_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_label8_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_label8_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_ulabel8_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_ulabel8_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_label12_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_label12_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_soffset_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_soffset_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_uimm16x4_ator (uint32 *valp, uint32 pc)
{
  *valp -= ((pc + 3) & ~0x3);
  return 0;
}

static int
Operand_uimm16x4_rtoa (uint32 *valp, uint32 pc)
{
  *valp += ((pc + 3) & ~0x3);
  return 0;
}

static int
Operand_xt_wbr15_label_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_xt_wbr15_label_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_xt_wbr18_label_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_xt_wbr18_label_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static xtensa_operand_internal operands[] = {
  { "soffsetx4", FIELD_offset, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_soffsetx4_encode, OperandSem_opnd_sem_soffsetx4_decode,
    Operand_soffsetx4_ator, Operand_soffsetx4_rtoa },
  { "uimm12x8", FIELD_imm12, -1, 0,
    0,
    OperandSem_opnd_sem_uimm12x8_encode, OperandSem_opnd_sem_uimm12x8_decode,
    0, 0 },
  { "simm4", FIELD_mn, -1, 0,
    0,
    OperandSem_opnd_sem_simm4_encode, OperandSem_opnd_sem_simm4_decode,
    0, 0 },
  { "arr", FIELD_r, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "ars", FIELD_s, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "*ars_invisible", FIELD_s, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "art", FIELD_t, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "ar0", FIELD__ar0, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_0_encode, OperandSem_opnd_sem_AR_0_decode,
    0, 0 },
  { "ar4", FIELD__ar4, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_1_encode, OperandSem_opnd_sem_AR_1_decode,
    0, 0 },
  { "ar8", FIELD__ar8, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_2_encode, OperandSem_opnd_sem_AR_2_decode,
    0, 0 },
  { "ar12", FIELD__ar12, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_3_encode, OperandSem_opnd_sem_AR_3_decode,
    0, 0 },
  { "ars_entry", FIELD_s, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_4_encode, OperandSem_opnd_sem_AR_4_decode,
    0, 0 },
  { "immrx4", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_immrx4_encode, OperandSem_opnd_sem_immrx4_decode,
    0, 0 },
  { "lsi4x4", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_lsi4x4_encode, OperandSem_opnd_sem_lsi4x4_decode,
    0, 0 },
  { "simm7", FIELD_imm7, -1, 0,
    0,
    OperandSem_opnd_sem_simm7_encode, OperandSem_opnd_sem_simm7_decode,
    0, 0 },
  { "uimm6", FIELD_imm6, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_uimm6_encode, OperandSem_opnd_sem_uimm6_decode,
    Operand_uimm6_ator, Operand_uimm6_rtoa },
  { "ai4const", FIELD_t, -1, 0,
    0,
    OperandSem_opnd_sem_ai4const_encode, OperandSem_opnd_sem_ai4const_decode,
    0, 0 },
  { "b4const", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_b4const_encode, OperandSem_opnd_sem_b4const_decode,
    0, 0 },
  { "b4constu", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_b4constu_encode, OperandSem_opnd_sem_b4constu_decode,
    0, 0 },
  { "uimm8", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_uimm8_encode, OperandSem_opnd_sem_uimm8_decode,
    0, 0 },
  { "uimm8x2", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_uimm8x2_encode, OperandSem_opnd_sem_uimm8x2_decode,
    0, 0 },
  { "uimm8x4", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_uimm8x4_encode, OperandSem_opnd_sem_uimm8x4_decode,
    0, 0 },
  { "uimm4x16", FIELD_op2, -1, 0,
    0,
    OperandSem_opnd_sem_uimm4x16_encode, OperandSem_opnd_sem_uimm4x16_decode,
    0, 0 },
  { "uimmrx4", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_uimmrx4_encode, OperandSem_opnd_sem_uimmrx4_decode,
    0, 0 },
  { "simm8", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_simm8_encode, OperandSem_opnd_sem_simm8_decode,
    0, 0 },
  { "simm8x256", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_simm8x256_encode, OperandSem_opnd_sem_simm8x256_decode,
    0, 0 },
  { "simm12b", FIELD_imm12b, -1, 0,
    0,
    OperandSem_opnd_sem_simm12b_encode, OperandSem_opnd_sem_simm12b_decode,
    0, 0 },
  { "msalp32", FIELD_sal, -1, 0,
    0,
    OperandSem_opnd_sem_msalp32_encode, OperandSem_opnd_sem_msalp32_decode,
    0, 0 },
  { "op2p1", FIELD_op2, -1, 0,
    0,
    OperandSem_opnd_sem_op2p1_encode, OperandSem_opnd_sem_op2p1_decode,
    0, 0 },
  { "label8", FIELD_imm8, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_label8_encode, OperandSem_opnd_sem_label8_decode,
    Operand_label8_ator, Operand_label8_rtoa },
  { "ulabel8", FIELD_imm8, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_ulabel8_encode, OperandSem_opnd_sem_ulabel8_decode,
    Operand_ulabel8_ator, Operand_ulabel8_rtoa },
  { "label12", FIELD_imm12, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_label12_encode, OperandSem_opnd_sem_label12_decode,
    Operand_label12_ator, Operand_label12_rtoa },
  { "soffset", FIELD_offset, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_soffset_encode, OperandSem_opnd_sem_soffset_decode,
    Operand_soffset_ator, Operand_soffset_rtoa },
  { "uimm16x4", FIELD_imm16, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_uimm16x4_encode, OperandSem_opnd_sem_uimm16x4_decode,
    Operand_uimm16x4_ator, Operand_uimm16x4_rtoa },
  { "bbi", FIELD_bbi, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0 },
  { "sae", FIELD_sae, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0 },
  { "sas", FIELD_sas, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0 },
  { "sargt", FIELD_sargt, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0 },
  { "s", FIELD_s, -1, 0,
    0,
    OperandSem_opnd_sem_s_encode, OperandSem_opnd_sem_s_decode,
    0, 0 },
  { "immt", FIELD_t, -1, 0,
    0,
    OperandSem_opnd_sem_immt_encode, OperandSem_opnd_sem_immt_decode,
    0, 0 },
  { "imms", FIELD_s, -1, 0,
    0,
    OperandSem_opnd_sem_immt_encode, OperandSem_opnd_sem_immt_decode,
    0, 0 },
  { "bt", FIELD_t, REGFILE_BR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR_encode, OperandSem_opnd_sem_BR_decode,
    0, 0 },
  { "bs", FIELD_s, REGFILE_BR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR_encode, OperandSem_opnd_sem_BR_decode,
    0, 0 },
  { "br", FIELD_r, REGFILE_BR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR_encode, OperandSem_opnd_sem_BR_decode,
    0, 0 },
  { "bt2", FIELD_t2, REGFILE_BR, 2,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR2_encode, OperandSem_opnd_sem_BR2_decode,
    0, 0 },
  { "bs2", FIELD_s2, REGFILE_BR, 2,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR2_encode, OperandSem_opnd_sem_BR2_decode,
    0, 0 },
  { "br2", FIELD_r2, REGFILE_BR, 2,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR2_encode, OperandSem_opnd_sem_BR2_decode,
    0, 0 },
  { "bt4", FIELD_t4, REGFILE_BR, 4,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR4_encode, OperandSem_opnd_sem_BR4_decode,
    0, 0 },
  { "bs4", FIELD_s4, REGFILE_BR, 4,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR4_encode, OperandSem_opnd_sem_BR4_decode,
    0, 0 },
  { "br4", FIELD_r4, REGFILE_BR, 4,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR4_encode, OperandSem_opnd_sem_BR4_decode,
    0, 0 },
  { "bt8", FIELD_t8, REGFILE_BR, 8,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR8_encode, OperandSem_opnd_sem_BR8_decode,
    0, 0 },
  { "bs8", FIELD_s8, REGFILE_BR, 8,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR8_encode, OperandSem_opnd_sem_BR8_decode,
    0, 0 },
  { "br8", FIELD_r8, REGFILE_BR, 8,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR8_encode, OperandSem_opnd_sem_BR8_decode,
    0, 0 },
  { "bt16", FIELD__bt16, REGFILE_BR, 16,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR16_encode, OperandSem_opnd_sem_BR16_decode,
    0, 0 },
  { "bs16", FIELD__bs16, REGFILE_BR, 16,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR16_encode, OperandSem_opnd_sem_BR16_decode,
    0, 0 },
  { "br16", FIELD__br16, REGFILE_BR, 16,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR16_encode, OperandSem_opnd_sem_BR16_decode,
    0, 0 },
  { "brall", FIELD__brall, REGFILE_BR, 16,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_BR16_encode, OperandSem_opnd_sem_BR16_decode,
    0, 0 },
  { "tp7", FIELD_t, -1, 0,
    0,
    OperandSem_opnd_sem_tp7_encode, OperandSem_opnd_sem_tp7_decode,
    0, 0 },
  { "xt_wbr15_label", FIELD_xt_wbr15_imm, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_xt_wbr15_label_encode, OperandSem_opnd_sem_xt_wbr15_label_decode,
    Operand_xt_wbr15_label_ator, Operand_xt_wbr15_label_rtoa },
  { "xt_wbr18_label", FIELD_xt_wbr18_imm, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_xt_wbr18_label_encode, OperandSem_opnd_sem_xt_wbr18_label_decode,
    Operand_xt_wbr18_label_ator, Operand_xt_wbr18_label_rtoa },
  { "ae_ohba", FIELD_ae_fld_fhba4, -1, 0,
    0,
    OperandSem_opnd_sem_ae_ohba_encode, OperandSem_opnd_sem_ae_ohba_decode,
    0, 0 },
  { "ae_ohba2", FIELD_ae_fld_fhba4_2, -1, 0,
    0,
    OperandSem_opnd_sem_ae_ohba_encode, OperandSem_opnd_sem_ae_ohba_decode,
    0, 0 },
  { "ae_opnd_tp7", FIELD_ae_fld_tp7, -1, 0,
    0,
    OperandSem_opnd_sem_ae_opnd_tp7_encode, OperandSem_opnd_sem_ae_opnd_tp7_decode,
    0, 0 },
  { "ae_imm2", FIELD_ae_fld_imm2, -1, 0,
    0,
    OperandSem_opnd_sem_ae_imm2_encode, OperandSem_opnd_sem_ae_imm2_decode,
    0, 0 },
  { "ae_osa32", FIELD_ae_fld_osa32, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa32_encode, OperandSem_opnd_sem_ae_osa32_decode,
    0, 0 },
  { "ae_osa64", FIELD_ae_fld_osa64, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa64_encode, OperandSem_opnd_sem_ae_osa64_decode,
    0, 0 },
  { "ae_immls64", FIELD_ae_fld_immls64, -1, 0,
    0,
    OperandSem_opnd_sem_ae_immls64_encode, OperandSem_opnd_sem_ae_immls64_decode,
    0, 0 },
  { "ae_immls64pos", FIELD_ae_fld_immls64pos, -1, 0,
    0,
    OperandSem_opnd_sem_ae_immls64pos_encode, OperandSem_opnd_sem_ae_immls64pos_decode,
    0, 0 },
  { "ae_immls32", FIELD_ae_fld_immls32, -1, 0,
    0,
    OperandSem_opnd_sem_ae_immls32_encode, OperandSem_opnd_sem_ae_immls32_decode,
    0, 0 },
  { "ae_immls16", FIELD_ae_fld_immls16, -1, 0,
    0,
    OperandSem_opnd_sem_ae_immls16_encode, OperandSem_opnd_sem_ae_immls16_decode,
    0, 0 },
  { "ae_osa16", FIELD_ae_fld_osa16, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa16_encode, OperandSem_opnd_sem_ae_osa16_decode,
    0, 0 },
  { "ae_selimm", FIELD_ae_fld_selimm, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa16_encode, OperandSem_opnd_sem_ae_osa16_decode,
    0, 0 },
  { "ae_selimm.N", FIELD_ae_fld_selimm_N, -1, 0,
    0,
    OperandSem_opnd_sem_ae_selimm_N_encode, OperandSem_opnd_sem_ae_selimm_N_decode,
    0, 0 },
  { "movi_imm", FIELD_fld_ar_to_dr_imm, -1, 0,
    0,
    OperandSem_opnd_sem_movi_imm_encode, OperandSem_opnd_sem_movi_imm_decode,
    0, 0 },
  { "ae_mul_d0", FIELD_ae_fld_mul_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_mul_d1", FIELD_ae_fld_mul_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_mul_q0", FIELD_ae_fld_mul_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_mul_S2_q0", FIELD_ae_fld_mul_x2_S2_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_mul_S2_d0", FIELD_ae_fld_mul_x2_S2_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_mul_S2_d1", FIELD_ae_fld_mul_x2_S2_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_mul_d2", FIELD_ae_fld_mul_x4_d2, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_mul_q1", FIELD_ae_fld_mul_x4_q1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_arth_v", FIELD_ae_fld_arth_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_arth_v0", FIELD_ae_fld_arth_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_arth_v1", FIELD_ae_fld_arth_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_ar_to_dr_v", FIELD_ae_fld_ar_to_dr_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_to_dr_v", FIELD_ae_fld_to_dr_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_to_dr_v0", FIELD_ae_fld_to_dr_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_dr_to_dr_v", FIELD_ae_fld_dr_to_dr_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_dr_to_dr_v0", FIELD_ae_fld_dr_to_dr_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_dr_to_dr_v1", FIELD_ae_fld_dr_to_dr_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_cmpp_v0", FIELD_ae_fld_cmpp_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_cmpp_v1", FIELD_ae_fld_cmpp_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_cmpp_v", FIELD_ae_fld_cmpp_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_ls_v", FIELD_ae_fld_ls_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_ls_av", FIELD_ae_fld_ls_av, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_ls_v1", FIELD_ae_fld_ls_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_ls_v2", FIELD_ae_fld_ls_v2, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_ls_uu", FIELD_ae_fld_ls_uu, REGFILE_AE_VALIGN, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_VALIGN_encode, OperandSem_opnd_sem_AE_VALIGN_decode,
    0, 0 },
  { "ae_ls_su", FIELD_ae_fld_ls_su, REGFILE_AE_VALIGN, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_VALIGN_encode, OperandSem_opnd_sem_AE_VALIGN_decode,
    0, 0 },
  { "ae_uu_v", FIELD_ae_fld_uu_v, REGFILE_AE_VALIGN, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_VALIGN_encode, OperandSem_opnd_sem_AE_VALIGN_decode,
    0, 0 },
  { "ae_uu_uu", FIELD_ae_fld_uu_uu, REGFILE_AE_VALIGN, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_VALIGN_encode, OperandSem_opnd_sem_AE_VALIGN_decode,
    0, 0 },
  { "ae_dr_to_ar_v0", FIELD_ae_fld_dr_to_ar_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_cmov_v", FIELD_ae_fld_cmov_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_cmov_v0", FIELD_ae_fld_cmov_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_pks_d", FIELD_ae_fld_pks_d, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_pks_s", FIELD_ae_fld_pks_s, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_shift_d", FIELD_ae_fld_shift_d, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_shift_d0", FIELD_ae_fld_shift_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_shift_sd", FIELD_ae_fld_shift_sd, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "frr", FIELD_r, REGFILE_FR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_FR_encode, OperandSem_opnd_sem_FR_decode,
    0, 0 },
  { "frs", FIELD_s, REGFILE_FR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_FR_encode, OperandSem_opnd_sem_FR_decode,
    0, 0 },
  { "frt", FIELD_t, REGFILE_FR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_FR_encode, OperandSem_opnd_sem_FR_decode,
    0, 0 },
  { "imm_t", FIELD_t, -1, 0,
    0,
    OperandSem_opnd_sem_imm_t_encode, OperandSem_opnd_sem_imm_t_decode,
    0, 0 },
  { "imm_s", FIELD_s, -1, 0,
    0,
    OperandSem_opnd_sem_imm_t_encode, OperandSem_opnd_sem_imm_t_decode,
    0, 0 },
  { "imm8x4", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_imm8x4_encode, OperandSem_opnd_sem_imm8x4_decode,
    0, 0 },
  { "imm8x8", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_imm8x8_encode, OperandSem_opnd_sem_imm8x8_decode,
    0, 0 },
  { "t", FIELD_t, -1, 0, 0, 0, 0, 0, 0 },
  { "bbi4", FIELD_bbi4, -1, 0, 0, 0, 0, 0, 0 },
  { "imm12", FIELD_imm12, -1, 0, 0, 0, 0, 0, 0 },
  { "imm8", FIELD_imm8, -1, 0, 0, 0, 0, 0, 0 },
  { "imm12b", FIELD_imm12b, -1, 0, 0, 0, 0, 0, 0 },
  { "imm16", FIELD_imm16, -1, 0, 0, 0, 0, 0, 0 },
  { "m", FIELD_m, -1, 0, 0, 0, 0, 0, 0 },
  { "n", FIELD_n, -1, 0, 0, 0, 0, 0, 0 },
  { "offset", FIELD_offset, -1, 0, 0, 0, 0, 0, 0 },
  { "op0", FIELD_op0, -1, 0, 0, 0, 0, 0, 0 },
  { "op1", FIELD_op1, -1, 0, 0, 0, 0, 0, 0 },
  { "op2", FIELD_op2, -1, 0, 0, 0, 0, 0, 0 },
  { "r", FIELD_r, -1, 0, 0, 0, 0, 0, 0 },
  { "sa4", FIELD_sa4, -1, 0, 0, 0, 0, 0, 0 },
  { "sae4", FIELD_sae4, -1, 0, 0, 0, 0, 0, 0 },
  { "sal", FIELD_sal, -1, 0, 0, 0, 0, 0, 0 },
  { "sas4", FIELD_sas4, -1, 0, 0, 0, 0, 0, 0 },
  { "sr", FIELD_sr, -1, 0, 0, 0, 0, 0, 0 },
  { "st", FIELD_st, -1, 0, 0, 0, 0, 0, 0 },
  { "thi3", FIELD_thi3, -1, 0, 0, 0, 0, 0, 0 },
  { "imm4", FIELD_imm4, -1, 0, 0, 0, 0, 0, 0 },
  { "mn", FIELD_mn, -1, 0, 0, 0, 0, 0, 0 },
  { "i", FIELD_i, -1, 0, 0, 0, 0, 0, 0 },
  { "imm6lo", FIELD_imm6lo, -1, 0, 0, 0, 0, 0, 0 },
  { "imm6hi", FIELD_imm6hi, -1, 0, 0, 0, 0, 0, 0 },
  { "imm7lo", FIELD_imm7lo, -1, 0, 0, 0, 0, 0, 0 },
  { "imm7hi", FIELD_imm7hi, -1, 0, 0, 0, 0, 0, 0 },
  { "z", FIELD_z, -1, 0, 0, 0, 0, 0, 0 },
  { "imm6", FIELD_imm6, -1, 0, 0, 0, 0, 0, 0 },
  { "imm7", FIELD_imm7, -1, 0, 0, 0, 0, 0, 0 },
  { "t2", FIELD_t2, -1, 0, 0, 0, 0, 0, 0 },
  { "s2", FIELD_s2, -1, 0, 0, 0, 0, 0, 0 },
  { "r2", FIELD_r2, -1, 0, 0, 0, 0, 0, 0 },
  { "t4", FIELD_t4, -1, 0, 0, 0, 0, 0, 0 },
  { "s4", FIELD_s4, -1, 0, 0, 0, 0, 0, 0 },
  { "r4", FIELD_r4, -1, 0, 0, 0, 0, 0, 0 },
  { "t8", FIELD_t8, -1, 0, 0, 0, 0, 0, 0 },
  { "s8", FIELD_s8, -1, 0, 0, 0, 0, 0, 0 },
  { "r8", FIELD_r8, -1, 0, 0, 0, 0, 0, 0 },
  { "xt_wbr15_imm", FIELD_xt_wbr15_imm, -1, 0, 0, 0, 0, 0, 0 },
  { "xt_wbr18_imm", FIELD_xt_wbr18_imm, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_fhba4", FIELD_ae_fld_fhba4, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_fhba4_2", FIELD_ae_fld_fhba4_2, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_tp7", FIELD_ae_fld_tp7, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_osa32", FIELD_ae_fld_osa32, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_osa64", FIELD_ae_fld_osa64, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_imm2", FIELD_ae_fld_imm2, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_immls64", FIELD_ae_fld_immls64, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_immls64pos", FIELD_ae_fld_immls64pos, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_immls32", FIELD_ae_fld_immls32, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_immls16", FIELD_ae_fld_immls16, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_15_12", FIELD_Inst_15_12, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_11_8", FIELD_Inst_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_7_4", FIELD_Inst_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_12", FIELD_Inst_12, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_7", FIELD_Inst_7, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_5_4", FIELD_Inst_5_4, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_7_6", FIELD_Inst_7_6, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_19_17", FIELD_Inst_19_17, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_19_18", FIELD_Inst_19_18, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_9_8", FIELD_Inst_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_4", FIELD_Inst_4, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ls_v", FIELD_ae_fld_ls_v, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ls_uu", FIELD_ae_fld_ls_uu, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ls_su", FIELD_ae_fld_ls_su, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ls_av", FIELD_ae_fld_ls_av, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ls_v1", FIELD_ae_fld_ls_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ls_v2", FIELD_ae_fld_ls_v2, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_cmpp_v0", FIELD_ae_fld_cmpp_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_cmpp_v1", FIELD_ae_fld_cmpp_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_cmpp_v", FIELD_ae_fld_cmpp_v, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_uu_v", FIELD_ae_fld_uu_v, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_uu_uu", FIELD_ae_fld_uu_uu, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_dr_to_ar_v0", FIELD_ae_fld_dr_to_ar_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_cmov_v", FIELD_ae_fld_cmov_v, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_cmov_v0", FIELD_ae_fld_cmov_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_pks_d", FIELD_ae_fld_pks_d, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_pks_s", FIELD_ae_fld_pks_s, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_shift_d", FIELD_ae_fld_shift_d, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_shift_d0", FIELD_ae_fld_shift_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_shift_sd", FIELD_ae_fld_shift_sd, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_dr_to_dr_v", FIELD_ae_fld_dr_to_dr_v, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_dr_to_dr_v0", FIELD_ae_fld_dr_to_dr_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_dr_to_dr_v1", FIELD_ae_fld_dr_to_dr_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_to_dr_v", FIELD_ae_fld_to_dr_v, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_to_dr_v0", FIELD_ae_fld_to_dr_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_selimm", FIELD_ae_fld_selimm, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ar_to_dr_imm", FIELD_fld_ar_to_dr_imm, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_arth_v", FIELD_ae_fld_arth_v, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_arth_v0", FIELD_ae_fld_arth_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_arth_v1", FIELD_ae_fld_arth_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ar_to_dr_v", FIELD_ae_fld_ar_to_dr_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_11_4", FIELD_fld_ae2_slot0_11_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_7_4", FIELD_fld_ae2_slot0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_9_8", FIELD_fld_ae2_slot0_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_11_11", FIELD_fld_ae2_slot0_11_11, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_31_30", FIELD_fld_ae2_slot0_31_30, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_11_8", FIELD_fld_ae2_slot0_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_31_12", FIELD_fld_ae2_slot0_31_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_19_12", FIELD_fld_ae_slot0_19_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_minislot2_18_16", FIELD_fld_ae_minislot2_18_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_19_16", FIELD_fld_ae_slot0_19_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_31_17", FIELD_fld_ae2_slot0_31_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_19_17", FIELD_fld_ae_slot0_19_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_minislot0_16_0", FIELD_fld_ae_minislot0_16_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_minislot1_0_0", FIELD_fld_ae_minislot1_0_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_minislot2_18_0", FIELD_fld_ae_minislot2_18_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_6_0", FIELD_fld_ae2_slot0_6_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_23_0", FIELD_fld_ae2_slot1_23_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_1_18_0", FIELD_fld_ae_slot2_1_18_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_19_0", FIELD_fld_ae_slot0_19_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_19_0", FIELD_fld_ae_slot1_19_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_0_19_0", FIELD_fld_ae_slot2_0_19_0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_osa16", FIELD_ae_fld_osa16, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_mul_d0", FIELD_ae_fld_mul_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_mul_d1", FIELD_ae_fld_mul_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_mul_q0", FIELD_ae_fld_mul_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_mul_x2_S2_d1", FIELD_ae_fld_mul_x2_S2_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_mul_x2_S2_d0", FIELD_ae_fld_mul_x2_S2_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_mul_x2_S2_q0", FIELD_ae_fld_mul_x2_S2_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_mul_x4_d2", FIELD_ae_fld_mul_x4_d2, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_mul_x4_q1", FIELD_ae_fld_mul_x4_q1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_7_4", FIELD_fld_ae_slot0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_11_8", FIELD_fld_ae_slot0_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_31_7", FIELD_fld_ae2_slot0_31_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_19_7", FIELD_fld_ae_slot0_19_7, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_selimm.N", FIELD_ae_fld_selimm_N, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_19_14", FIELD_fld_ae_slot1_19_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_1_9_8", FIELD_fld_ae_slot2_1_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_31_16", FIELD_fld_ae2_slot0_31_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_1_7_4", FIELD_fld_ae_slot2_1_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_1_18_12", FIELD_fld_ae_slot2_1_18_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_1_1_0", FIELD_fld_ae_slot2_1_1_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_7_4", FIELD_fld_ae2_slot1_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_19_12", FIELD_fld_ae_slot1_19_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_0_19_12", FIELD_fld_ae_slot2_0_19_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_23_16", FIELD_fld_ae2_slot1_23_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_23_20", FIELD_fld_ae2_slot1_23_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_3_0", FIELD_fld_ae2_slot0_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_11_4", FIELD_fld_ae2_slot1_11_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_1_18_8", FIELD_fld_ae_slot2_1_18_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_7_4", FIELD_fld_ae_slot1_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_minislot2_11_4", FIELD_fld_ae_minislot2_11_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_minislot0_16_10", FIELD_fld_ae_minislot0_16_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_minislot2_3_0", FIELD_fld_ae_minislot2_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_minislot2_9_8", FIELD_fld_ae_minislot2_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_13_11", FIELD_fld_ae2_slot1_13_11, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_5_4", FIELD_fld_ae_slot0_5_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_9_8", FIELD_fld_ae_slot1_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_minislot0_16_8", FIELD_fld_ae_minislot0_16_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_7_7", FIELD_fld_ae2_slot1_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_18_16", FIELD_fld_ae2_slot1_18_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_1_18_16", FIELD_fld_ae_slot2_1_18_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_8_8", FIELD_fld_ae2_slot0_8_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_1_0_0", FIELD_fld_ae_slot2_1_0_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_minislot0_16_12", FIELD_fld_ae_minislot0_16_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_6_4", FIELD_fld_ae2_slot0_6_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_31_15", FIELD_fld_ae2_slot0_31_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_6_5", FIELD_fld_ae_slot0_6_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_19_14", FIELD_fld_ae_slot0_19_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_7_7", FIELD_fld_ae_slot0_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_4_4", FIELD_fld_ae2_slot0_4_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_7_7", FIELD_fld_ae2_slot0_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_4_4", FIELD_fld_ae_slot0_4_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_4_2", FIELD_fld_ae2_slot0_4_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_4_2", FIELD_fld_ae_slot0_4_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_4_0", FIELD_fld_ae2_slot0_4_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_4_0", FIELD_fld_ae_slot0_4_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_minislot2_18_8", FIELD_fld_ae_minislot2_18_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_5_4", FIELD_fld_ae2_slot0_5_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_14_12", FIELD_fld_ae2_slot0_14_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_1_8_8", FIELD_fld_ae_slot2_1_8_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_1_0", FIELD_fld_ae2_slot1_1_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_7_3", FIELD_fld_ae2_slot1_7_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_0_0", FIELD_fld_ae_slot1_0_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_3_3", FIELD_fld_ae_slot1_3_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_minislot2_11_8", FIELD_fld_ae_minislot2_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_0_7_4", FIELD_fld_ae_slot2_0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_1_0", FIELD_fld_ae2_slot0_1_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_0_19_13", FIELD_fld_ae_slot2_0_19_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_0_0", FIELD_fld_ae2_slot0_0_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_0_19_14", FIELD_fld_ae_slot2_0_19_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_7_6", FIELD_fld_ae2_slot1_7_6, -1, 0, 0, 0, 0, 0, 0 }
};

enum xtensa_operand_id {
  OPERAND_soffsetx4,
  OPERAND_uimm12x8,
  OPERAND_simm4,
  OPERAND_arr,
  OPERAND_ars,
  OPERAND__ars_invisible,
  OPERAND_art,
  OPERAND_ar0,
  OPERAND_ar4,
  OPERAND_ar8,
  OPERAND_ar12,
  OPERAND_ars_entry,
  OPERAND_immrx4,
  OPERAND_lsi4x4,
  OPERAND_simm7,
  OPERAND_uimm6,
  OPERAND_ai4const,
  OPERAND_b4const,
  OPERAND_b4constu,
  OPERAND_uimm8,
  OPERAND_uimm8x2,
  OPERAND_uimm8x4,
  OPERAND_uimm4x16,
  OPERAND_uimmrx4,
  OPERAND_simm8,
  OPERAND_simm8x256,
  OPERAND_simm12b,
  OPERAND_msalp32,
  OPERAND_op2p1,
  OPERAND_label8,
  OPERAND_ulabel8,
  OPERAND_label12,
  OPERAND_soffset,
  OPERAND_uimm16x4,
  OPERAND_bbi,
  OPERAND_sae,
  OPERAND_sas,
  OPERAND_sargt,
  OPERAND_s,
  OPERAND_immt,
  OPERAND_imms,
  OPERAND_bt,
  OPERAND_bs,
  OPERAND_br,
  OPERAND_bt2,
  OPERAND_bs2,
  OPERAND_br2,
  OPERAND_bt4,
  OPERAND_bs4,
  OPERAND_br4,
  OPERAND_bt8,
  OPERAND_bs8,
  OPERAND_br8,
  OPERAND_bt16,
  OPERAND_bs16,
  OPERAND_br16,
  OPERAND_brall,
  OPERAND_tp7,
  OPERAND_xt_wbr15_label,
  OPERAND_xt_wbr18_label,
  OPERAND_ae_ohba,
  OPERAND_ae_ohba2,
  OPERAND_ae_opnd_tp7,
  OPERAND_ae_imm2,
  OPERAND_ae_osa32,
  OPERAND_ae_osa64,
  OPERAND_ae_immls64,
  OPERAND_ae_immls64pos,
  OPERAND_ae_immls32,
  OPERAND_ae_immls16,
  OPERAND_ae_osa16,
  OPERAND_ae_selimm,
  OPERAND_ae_selimm_N,
  OPERAND_movi_imm,
  OPERAND_ae_mul_d0,
  OPERAND_ae_mul_d1,
  OPERAND_ae_mul_q0,
  OPERAND_ae_mul_S2_q0,
  OPERAND_ae_mul_S2_d0,
  OPERAND_ae_mul_S2_d1,
  OPERAND_ae_mul_d2,
  OPERAND_ae_mul_q1,
  OPERAND_ae_arth_v,
  OPERAND_ae_arth_v0,
  OPERAND_ae_arth_v1,
  OPERAND_ae_ar_to_dr_v,
  OPERAND_ae_to_dr_v,
  OPERAND_ae_to_dr_v0,
  OPERAND_ae_dr_to_dr_v,
  OPERAND_ae_dr_to_dr_v0,
  OPERAND_ae_dr_to_dr_v1,
  OPERAND_ae_cmpp_v0,
  OPERAND_ae_cmpp_v1,
  OPERAND_ae_cmpp_v,
  OPERAND_ae_ls_v,
  OPERAND_ae_ls_av,
  OPERAND_ae_ls_v1,
  OPERAND_ae_ls_v2,
  OPERAND_ae_ls_uu,
  OPERAND_ae_ls_su,
  OPERAND_ae_uu_v,
  OPERAND_ae_uu_uu,
  OPERAND_ae_dr_to_ar_v0,
  OPERAND_ae_cmov_v,
  OPERAND_ae_cmov_v0,
  OPERAND_ae_pks_d,
  OPERAND_ae_pks_s,
  OPERAND_ae_shift_d,
  OPERAND_ae_shift_d0,
  OPERAND_ae_shift_sd,
  OPERAND_frr,
  OPERAND_frs,
  OPERAND_frt,
  OPERAND_imm_t,
  OPERAND_imm_s,
  OPERAND_imm8x4,
  OPERAND_imm8x8,
  OPERAND_t,
  OPERAND_bbi4,
  OPERAND_imm12,
  OPERAND_imm8,
  OPERAND_imm12b,
  OPERAND_imm16,
  OPERAND_m,
  OPERAND_n,
  OPERAND_offset,
  OPERAND_op0,
  OPERAND_op1,
  OPERAND_op2,
  OPERAND_r,
  OPERAND_sa4,
  OPERAND_sae4,
  OPERAND_sal,
  OPERAND_sas4,
  OPERAND_sr,
  OPERAND_st,
  OPERAND_thi3,
  OPERAND_imm4,
  OPERAND_mn,
  OPERAND_i,
  OPERAND_imm6lo,
  OPERAND_imm6hi,
  OPERAND_imm7lo,
  OPERAND_imm7hi,
  OPERAND_z,
  OPERAND_imm6,
  OPERAND_imm7,
  OPERAND_t2,
  OPERAND_s2,
  OPERAND_r2,
  OPERAND_t4,
  OPERAND_s4,
  OPERAND_r4,
  OPERAND_t8,
  OPERAND_s8,
  OPERAND_r8,
  OPERAND_xt_wbr15_imm,
  OPERAND_xt_wbr18_imm,
  OPERAND_ae_fld_fhba4,
  OPERAND_ae_fld_fhba4_2,
  OPERAND_ae_fld_tp7,
  OPERAND_ae_fld_osa32,
  OPERAND_ae_fld_osa64,
  OPERAND_ae_fld_imm2,
  OPERAND_ae_fld_immls64,
  OPERAND_ae_fld_immls64pos,
  OPERAND_ae_fld_immls32,
  OPERAND_ae_fld_immls16,
  OPERAND_Inst_15_12,
  OPERAND_Inst_11_8,
  OPERAND_Inst_7_4,
  OPERAND_Inst_12,
  OPERAND_Inst_7,
  OPERAND_Inst_5_4,
  OPERAND_Inst_7_6,
  OPERAND_Inst_19_17,
  OPERAND_Inst_19_18,
  OPERAND_Inst_9_8,
  OPERAND_Inst_4,
  OPERAND_ae_fld_ls_v,
  OPERAND_ae_fld_ls_uu,
  OPERAND_ae_fld_ls_su,
  OPERAND_ae_fld_ls_av,
  OPERAND_ae_fld_ls_v1,
  OPERAND_ae_fld_ls_v2,
  OPERAND_ae_fld_cmpp_v0,
  OPERAND_ae_fld_cmpp_v1,
  OPERAND_ae_fld_cmpp_v,
  OPERAND_ae_fld_uu_v,
  OPERAND_ae_fld_uu_uu,
  OPERAND_ae_fld_dr_to_ar_v0,
  OPERAND_ae_fld_cmov_v,
  OPERAND_ae_fld_cmov_v0,
  OPERAND_ae_fld_pks_d,
  OPERAND_ae_fld_pks_s,
  OPERAND_ae_fld_shift_d,
  OPERAND_ae_fld_shift_d0,
  OPERAND_ae_fld_shift_sd,
  OPERAND_ae_fld_dr_to_dr_v,
  OPERAND_ae_fld_dr_to_dr_v0,
  OPERAND_ae_fld_dr_to_dr_v1,
  OPERAND_ae_fld_to_dr_v,
  OPERAND_ae_fld_to_dr_v0,
  OPERAND_ae_fld_selimm,
  OPERAND_fld_ar_to_dr_imm,
  OPERAND_ae_fld_arth_v,
  OPERAND_ae_fld_arth_v0,
  OPERAND_ae_fld_arth_v1,
  OPERAND_ae_fld_ar_to_dr_v,
  OPERAND_fld_ae2_slot0_11_4,
  OPERAND_fld_ae2_slot0_7_4,
  OPERAND_fld_ae2_slot0_9_8,
  OPERAND_fld_ae2_slot0_11_11,
  OPERAND_fld_ae2_slot0_31_30,
  OPERAND_fld_ae2_slot0_11_8,
  OPERAND_fld_ae2_slot0_31_12,
  OPERAND_fld_ae_slot0_19_12,
  OPERAND_fld_ae_minislot2_18_16,
  OPERAND_fld_ae_slot0_19_16,
  OPERAND_fld_ae2_slot0_31_17,
  OPERAND_fld_ae_slot0_19_17,
  OPERAND_fld_ae_minislot0_16_0,
  OPERAND_fld_ae_minislot1_0_0,
  OPERAND_fld_ae_minislot2_18_0,
  OPERAND_fld_ae2_slot0_6_0,
  OPERAND_fld_ae2_slot1_23_0,
  OPERAND_fld_ae_slot2_1_18_0,
  OPERAND_fld_ae_slot0_19_0,
  OPERAND_fld_ae_slot1_19_0,
  OPERAND_fld_ae_slot2_0_19_0,
  OPERAND_ae_fld_osa16,
  OPERAND_ae_fld_mul_d0,
  OPERAND_ae_fld_mul_d1,
  OPERAND_ae_fld_mul_q0,
  OPERAND_ae_fld_mul_x2_S2_d1,
  OPERAND_ae_fld_mul_x2_S2_d0,
  OPERAND_ae_fld_mul_x2_S2_q0,
  OPERAND_ae_fld_mul_x4_d2,
  OPERAND_ae_fld_mul_x4_q1,
  OPERAND_fld_ae_slot0_7_4,
  OPERAND_fld_ae_slot0_11_8,
  OPERAND_fld_ae2_slot0_31_7,
  OPERAND_fld_ae_slot0_19_7,
  OPERAND_ae_fld_selimm_N,
  OPERAND_fld_ae_slot1_19_14,
  OPERAND_fld_ae_slot2_1_9_8,
  OPERAND_fld_ae2_slot0_31_16,
  OPERAND_fld_ae_slot2_1_7_4,
  OPERAND_fld_ae_slot2_1_18_12,
  OPERAND_fld_ae_slot2_1_1_0,
  OPERAND_fld_ae2_slot1_7_4,
  OPERAND_fld_ae_slot1_19_12,
  OPERAND_fld_ae_slot2_0_19_12,
  OPERAND_fld_ae2_slot1_23_16,
  OPERAND_fld_ae2_slot1_23_20,
  OPERAND_fld_ae2_slot0_3_0,
  OPERAND_fld_ae2_slot1_11_4,
  OPERAND_fld_ae_slot2_1_18_8,
  OPERAND_fld_ae_slot1_7_4,
  OPERAND_fld_ae_minislot2_11_4,
  OPERAND_fld_ae_minislot0_16_10,
  OPERAND_fld_ae_minislot2_3_0,
  OPERAND_fld_ae_minislot2_9_8,
  OPERAND_fld_ae2_slot1_13_11,
  OPERAND_fld_ae_slot0_5_4,
  OPERAND_fld_ae_slot1_9_8,
  OPERAND_fld_ae_minislot0_16_8,
  OPERAND_fld_ae2_slot1_7_7,
  OPERAND_fld_ae2_slot1_18_16,
  OPERAND_fld_ae_slot2_1_18_16,
  OPERAND_fld_ae2_slot0_8_8,
  OPERAND_fld_ae_slot2_1_0_0,
  OPERAND_fld_ae_minislot0_16_12,
  OPERAND_fld_ae2_slot0_6_4,
  OPERAND_fld_ae2_slot0_31_15,
  OPERAND_fld_ae_slot0_6_5,
  OPERAND_fld_ae_slot0_19_14,
  OPERAND_fld_ae_slot0_7_7,
  OPERAND_fld_ae2_slot0_4_4,
  OPERAND_fld_ae2_slot0_7_7,
  OPERAND_fld_ae_slot0_4_4,
  OPERAND_fld_ae2_slot0_4_2,
  OPERAND_fld_ae_slot0_4_2,
  OPERAND_fld_ae2_slot0_4_0,
  OPERAND_fld_ae_slot0_4_0,
  OPERAND_fld_ae_minislot2_18_8,
  OPERAND_fld_ae2_slot0_5_4,
  OPERAND_fld_ae2_slot0_14_12,
  OPERAND_fld_ae_slot2_1_8_8,
  OPERAND_fld_ae2_slot1_1_0,
  OPERAND_fld_ae2_slot1_7_3,
  OPERAND_fld_ae_slot1_0_0,
  OPERAND_fld_ae_slot1_3_3,
  OPERAND_fld_ae_minislot2_11_8,
  OPERAND_fld_ae_slot2_0_7_4,
  OPERAND_fld_ae2_slot0_1_0,
  OPERAND_fld_ae_slot2_0_19_13,
  OPERAND_fld_ae2_slot0_0_0,
  OPERAND_fld_ae_slot2_0_19_14,
  OPERAND_fld_ae2_slot1_7_6
};


/* Iclass table.  */

static xtensa_arg_internal Iclass_RUR_AE_OVERFLOW_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_OVERFLOW_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_OVERFLOW_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_OVERFLOW_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_SAR_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_SAR_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_SAR_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_SAR_stateArgs[] = {
  { { STATE_AE_SAR }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_BITPTR_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_BITPTR_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_BITPTR_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_BITPTR_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_BITSUSED_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_BITSUSED_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_BITSUSED_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_BITSUSED_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_TABLESIZE_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_TABLESIZE_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_TABLESIZE_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_TABLESIZE_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_FIRST_TS_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_FIRST_TS_stateArgs[] = {
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_FIRST_TS_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_FIRST_TS_stateArgs[] = {
  { { STATE_AE_FIRST_TS }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_NEXTOFFSET_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_NEXTOFFSET_stateArgs[] = {
  { { STATE_AE_NEXTOFFSET }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_NEXTOFFSET_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_NEXTOFFSET_stateArgs[] = {
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_SEARCHDONE_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_SEARCHDONE_stateArgs[] = {
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_SEARCHDONE_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_SEARCHDONE_stateArgs[] = {
  { { STATE_AE_SEARCHDONE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_CWRAP_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_CWRAP_stateArgs[] = {
  { { STATE_AE_CWRAP }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_CWRAP_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_CWRAP_stateArgs[] = {
  { { STATE_AE_CWRAP }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_I_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_IU_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_X_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_XU_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_I_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_X_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_I_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_X_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_I_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_X_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_I_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_IU_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_X_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_XU_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_I_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_IU_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_X_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_XU_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_I_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64pos }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_RIP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_RIC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_X_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_I_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64pos }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_RIP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_L32X2_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_RIC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_L32X2_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_X_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_I_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64pos }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_RIP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_L16X4_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_RIC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_L16X4_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_X_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_I_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_X_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_I_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_IU_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_X_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_XU_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_I_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64pos }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_RIP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_RIC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_X_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_I_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64pos }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_RIP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S32X2_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_RIC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S32X2_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_X_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_I_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64pos }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_RIP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S16X4_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_RIC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S16X4_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_X_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_I_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_IU_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_X_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_XU_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_I_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_X_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_I_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_X_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_I_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_X_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_I_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_X_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_I_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_IU_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_X_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_XU_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ZALIGN64_args[] = {
  { { OPERAND_ae_uu_uu }, 'o' }
};

static xtensa_arg_internal Iclass_AE_ZALIGN64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LALIGN64_I_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LALIGN64_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SALIGN64_I_args[] = {
  { { OPERAND_ae_ls_su }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SALIGN64_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVALIGN_args[] = {
  { { OPERAND_ae_uu_uu }, 'o' },
  { { OPERAND_ae_uu_v }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVALIGN_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA64_PP_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA64_PP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24POS_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24POS_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24X2POS_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24X2POS_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2POS_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2POS_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4POS_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4POS_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24NEG_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24NEG_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24X2NEG_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24X2NEG_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2NEG_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2NEG_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4NEG_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4NEG_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA64POS_FP_args[] = {
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA64POS_FP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA64NEG_FP_args[] = {
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA64NEG_FP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_IC_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_IP_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_RIP_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_RIC_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_IC_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_IP_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_RIP_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_RIC_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_IC_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_IP_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_RIP_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_RIC_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24_IC_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24_IP_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24_RIP_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24_RIC_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_IC_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_IP_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_RIP_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_RIC_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_IC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_RIP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_RIC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_IC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_RIP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_RIC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_IC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_RIP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_RIC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_IC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_RIP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_RIC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_IC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_RIP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_RIC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_I_args[] = {
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_I_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_IP_args[] = {
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_IP_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_X_args[] = {
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_X_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_XP_args[] = {
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_XP_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_XC_args[] = {
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_I_args[] = {
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_I_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_IP_args[] = {
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_IP_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_X_args[] = {
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_X_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_XP_args[] = {
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_XP_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_XC_args[] = {
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2RA64S_IP_args[] = {
  { { OPERAND_ae_ls_v2 }, 'i' },
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S32X2RA64S_IP_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24X2RA64S_IP_args[] = {
  { { OPERAND_ae_ls_v2 }, 'i' },
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S24X2RA64S_IP_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDBRBA32_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEL16I_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' },
  { { OPERAND_ae_dr_to_dr_v1 }, 'i' },
  { { OPERAND_ae_selimm }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEL16I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEL16I_N_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' },
  { { OPERAND_ae_dr_to_dr_v1 }, 'i' },
  { { OPERAND_ae_selimm_N }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEL16I_N_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SHORTSWAP_args[] = {
  { { OPERAND_ae_to_dr_v }, 'o' },
  { { OPERAND_ae_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SHORTSWAP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT16X4_args[] = {
  { { OPERAND_ae_cmov_v }, 'm' },
  { { OPERAND_ae_cmov_v0 }, 'i' },
  { { OPERAND_bt4 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT16X4_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF16X4_args[] = {
  { { OPERAND_ae_cmov_v }, 'm' },
  { { OPERAND_ae_cmov_v0 }, 'i' },
  { { OPERAND_bt4 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF16X4_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT32X2_args[] = {
  { { OPERAND_ae_cmov_v }, 'm' },
  { { OPERAND_ae_cmov_v0 }, 'i' },
  { { OPERAND_bt2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT32X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF32X2_args[] = {
  { { OPERAND_ae_cmov_v }, 'm' },
  { { OPERAND_ae_cmov_v0 }, 'i' },
  { { OPERAND_bt2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF32X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA32X2_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA32X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA32_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA16X2_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA16X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA16_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVI_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_movi_imm }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVI_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCP24A32X2_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCP24A32X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT16X4_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT16X4_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT32X2F16_32_args[] = {
  { { OPERAND_ae_to_dr_v }, 'o' },
  { { OPERAND_ae_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT32X2F16_32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT32X2F16_10_args[] = {
  { { OPERAND_ae_to_dr_v }, 'o' },
  { { OPERAND_ae_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT32X2F16_10_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32X2D16_32_args[] = {
  { { OPERAND_ae_to_dr_v }, 'o' },
  { { OPERAND_ae_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32X2D16_32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32X2D16_10_args[] = {
  { { OPERAND_ae_to_dr_v }, 'o' },
  { { OPERAND_ae_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32X2D16_10_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTA32F24S_L_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTA32F24S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTA32F24S_H_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTA32F24S_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_LL_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_LH_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_HL_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_HL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_HH_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCP24Q48X2_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' },
  { { OPERAND_ae_dr_to_dr_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCP24Q48X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32X2F64S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_shift_sd }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32X2F64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCI32X2F64S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_shift_sd }, 'i' },
  { { OPERAND_ae_osa16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCI32X2F64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32F64S_L_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_shift_sd }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32F64S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCI32F64S_L_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_shift_sd }, 'i' },
  { { OPERAND_ae_osa16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCI32F64S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCP16_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCP16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F64SSYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F64SSYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F64SASYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F64SASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F48SSYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F48SSYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F48SASYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F48SASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND16X4F32SSYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' },
  { { OPERAND_ae_arth_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND16X4F32SSYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND16X4F32SASYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' },
  { { OPERAND_ae_arth_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND16X4F32SASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND24X2F48SSYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND24X2F48SSYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND24X2F48SASYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND24X2F48SASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16Q48X2SYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16Q48X2SYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16Q48X2ASYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16Q48X2ASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MINABS32S_args[] = {
  { { OPERAND_ae_cmpp_v }, 'o' },
  { { OPERAND_ae_cmpp_v0 }, 'i' },
  { { OPERAND_ae_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MINABS32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAXABS32S_args[] = {
  { { OPERAND_ae_cmpp_v }, 'o' },
  { { OPERAND_ae_cmpp_v0 }, 'i' },
  { { OPERAND_ae_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAXABS32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16F24SYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16F24SYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16F24ASYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16F24ASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOV_args[] = {
  { { OPERAND_ae_to_dr_v }, 'o' },
  { { OPERAND_ae_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOV_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT64_args[] = {
  { { OPERAND_ae_cmov_v }, 'm' },
  { { OPERAND_ae_cmov_v0 }, 'i' },
  { { OPERAND_bt }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF64_args[] = {
  { { OPERAND_ae_cmov_v }, 'm' },
  { { OPERAND_ae_cmov_v0 }, 'i' },
  { { OPERAND_bt }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTQ56A32S_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTQ56A32S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT48A32_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT48A32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT64A32_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT64A32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTQ56P32S_L_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTQ56P32S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTQ56P32S_H_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTQ56P32S_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT64F32_H_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT64F32_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT48S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT48S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SATQ56S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SATQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT24S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCQ32_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCQ32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MINABS64S_args[] = {
  { { OPERAND_ae_cmpp_v }, 'o' },
  { { OPERAND_ae_cmpp_v0 }, 'i' },
  { { OPERAND_ae_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MINABS64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAXABS64S_args[] = {
  { { OPERAND_ae_cmpp_v }, 'o' },
  { { OPERAND_ae_cmpp_v0 }, 'i' },
  { { OPERAND_ae_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAXABS64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSQ32F48SYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSQ32F48SYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSQ32F48ASYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSQ32F48ASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32Q48_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32Q48_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD32_L_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD32_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD32_H_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD32_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_3_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_2_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_1_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_0_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRA64_32_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRA64_32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_PKSR32_args[] = {
  { { OPERAND_ae_pks_d }, 'm' },
  { { OPERAND_ae_pks_s }, 'i' },
  { { OPERAND_ae_imm2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_PKSR32_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_PKSR24_args[] = {
  { { OPERAND_ae_pks_d }, 'm' },
  { { OPERAND_ae_pks_s }, 'i' },
  { { OPERAND_ae_imm2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_PKSR24_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA16P24S_L_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA16P24S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA16P24S_H_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA16P24S_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB32_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSUB32_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSUB32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBADD32_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBADD32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD16_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB16_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32_HL_LH_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG32_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS32_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD24S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB24S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB32S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSUB32S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSUB32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBADD32S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBADD32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD16S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB16S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG24S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS24S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG32S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG32S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS32S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS32S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG16S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG16S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS16S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS16S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT16_args[] = {
  { { OPERAND_br4 }, 'o' },
  { { OPERAND_ae_cmpp_v0 }, 'i' },
  { { OPERAND_ae_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE16_args[] = {
  { { OPERAND_br4 }, 'o' },
  { { OPERAND_ae_cmpp_v0 }, 'i' },
  { { OPERAND_ae_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ16_args[] = {
  { { OPERAND_br4 }, 'o' },
  { { OPERAND_ae_cmpp_v0 }, 'i' },
  { { OPERAND_ae_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT32_args[] = {
  { { OPERAND_br2 }, 'o' },
  { { OPERAND_ae_cmpp_v0 }, 'i' },
  { { OPERAND_ae_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE32_args[] = {
  { { OPERAND_br2 }, 'o' },
  { { OPERAND_ae_cmpp_v0 }, 'i' },
  { { OPERAND_ae_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ32_args[] = {
  { { OPERAND_br2 }, 'o' },
  { { OPERAND_ae_cmpp_v0 }, 'i' },
  { { OPERAND_ae_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MIN32_args[] = {
  { { OPERAND_ae_cmpp_v }, 'o' },
  { { OPERAND_ae_cmpp_v0 }, 'i' },
  { { OPERAND_ae_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MIN32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAX32_args[] = {
  { { OPERAND_ae_cmpp_v }, 'o' },
  { { OPERAND_ae_cmpp_v0 }, 'i' },
  { { OPERAND_ae_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAX32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD64_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB64_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG64_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS64_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSQ56S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBSQ56S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBSQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD64S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB64S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEGSQ56S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEGSQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABSSQ56S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABSSQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG64S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS64S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_AND_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' },
  { { OPERAND_ae_dr_to_dr_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_AND_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NAND_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' },
  { { OPERAND_ae_dr_to_dr_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NAND_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_OR_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' },
  { { OPERAND_ae_dr_to_dr_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_OR_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_XOR_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' },
  { { OPERAND_ae_dr_to_dr_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_XOR_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI24_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLI24_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLI24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI24_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS24_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS24_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLS24_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLS24_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAS24_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAS24_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI16_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI16R_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI16R_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI32_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLI32_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLI32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI32_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI32R_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI32R_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS32_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS32_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLS32_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLS32_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAS32_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAS32_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA32_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLA32_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLA32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI16S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA16S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA16S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA16RS_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA16RS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI24S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS24S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI32S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS32S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA32S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32RS_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32RS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLASQ56_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLASQ56_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLSQ56_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLSQ56_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRASQ56_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRASQ56_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAAQ56_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAAQ56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLAQ56_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLAQ56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAAQ56_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAAQ56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI64_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLI64_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLI64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI64_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS64_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS64_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLS64_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLS64_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAS64_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAS64_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA64_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLA64_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLA64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA64_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAISQ56S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAISQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLASSQ56S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLASSQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAASQ56S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAASQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI64S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS64S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA64S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT64_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_ae_cmpp_v0 }, 'i' },
  { { OPERAND_ae_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE64_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_ae_cmpp_v0 }, 'i' },
  { { OPERAND_ae_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ64_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_ae_cmpp_v0 }, 'i' },
  { { OPERAND_ae_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAX64_args[] = {
  { { OPERAND_ae_cmpp_v }, 'o' },
  { { OPERAND_ae_cmpp_v0 }, 'i' },
  { { OPERAND_ae_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAX64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MIN64_args[] = {
  { { OPERAND_ae_cmpp_v }, 'o' },
  { { OPERAND_ae_cmpp_v0 }, 'i' },
  { { OPERAND_ae_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MIN64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSA64_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSA64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSAZ16_0_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSAZ16_0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSAZ32_L_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSAZ32_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LL_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LH_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_HH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_HH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_HH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_HH_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_HH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_HH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LL_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LH_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_HH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_HH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_HH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_HH_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_HH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_HH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LL_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LH_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_HH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_HH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_HH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_HH_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_HH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_HH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_LL_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_LL_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32U_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32U_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32U_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32U_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32U_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32U_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_33_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_33_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_22_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_32_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_32_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_21_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_21_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_31_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_31_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_30_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_30_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_10_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_10_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_20_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_20_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_11_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_11_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_00_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_00_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_00_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_33_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_33_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_22_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_32_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_32_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_21_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_21_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_31_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_31_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_30_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_30_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_10_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_10_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_20_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_20_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_11_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_11_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_00_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_00_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_00_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_33_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_33_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_22_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_32_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_32_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_21_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_21_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_31_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_31_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_30_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_30_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_10_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_10_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_20_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_20_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_11_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_11_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_00_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_00_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_00_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_33_22_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_33_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_33_22_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_33_22_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_13_02_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_13_02_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_13_02_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_13_02_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_11_00_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_11_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_11_00_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_11_00_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_33_22_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_33_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_33_22_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_33_22_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_13_02_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_13_02_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_13_02_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_13_02_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_11_00_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_11_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_11_00_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_11_00_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_33_22_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_33_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_33_22_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_33_22_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_13_02_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_13_02_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_13_02_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_13_02_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_11_00_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_11_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_11_00_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_11_00_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_33_22_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_33_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_33_22_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_33_22_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_13_02_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_13_02_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_13_02_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_13_02_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_11_00_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_11_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_11_00_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_11_00_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16S_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16S_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16S_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16U_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16U_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16U_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16S_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16S_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16S_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16U_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16U_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16U_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16S_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16S_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16S_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16U_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16U_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16U_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16S_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16S_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16S_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16U_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16U_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16U_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16S_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16S_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16S_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16U_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16U_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16U_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16S_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16S_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16S_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16U_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16U_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16U_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP24X2RA_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP24X2RA_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP24X2R_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP24X2R_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP24X2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP24X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP24X2RA_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP24X2RA_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP24X2R_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP24X2R_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP24X2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP24X2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP24X2RA_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP24X2RA_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP24X2R_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP24X2R_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP24X2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP24X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP24X2RA_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP24X2RA_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP24X2R_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP24X2R_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP24X2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP24X2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP24X2RA_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP24X2RA_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP24X2R_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP24X2R_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP24X2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP24X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP24X2RA_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP24X2RA_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP24X2R_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP24X2R_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP24X2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP24X2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD24_HH_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD24_HH_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD24_HH_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD24_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD24_HH_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD24_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD24_HL_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD24_HL_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD24_HL_LH_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD24_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD24_HL_LH_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD24_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD24_HH_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD24_HH_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD24_HH_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD24_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD24_HH_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD24_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD24_HL_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD24_HL_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD24_HL_LH_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD24_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD24_HL_LH_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD24_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD24_HH_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD24_HH_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD24_HH_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD24_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD24_HH_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD24_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD24_HH_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD24_HH_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD24_HH_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD24_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD24_HH_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD24_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD24_HL_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD24_HL_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD24_HL_LH_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD24_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD24_HL_LH_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD24_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD24_HH_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD24_HH_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD24_HH_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD24_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD24_HH_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD24_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD24_HL_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD24_HL_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD24_HL_LH_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD24_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD24_HL_LH_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD24_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD24_HH_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD24_HH_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD24_HH_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD24_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD24_HH_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD24_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD24_HL_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD24_HL_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD24_HL_LH_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD24_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD24_HL_LH_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD24_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD24_HH_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD24_HH_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD24_HH_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD24_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD24_HH_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD24_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD24_HH_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD24_HH_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD24_HH_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD24_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD24_HH_LL_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD24_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD24_HL_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD24_HL_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD24_HL_LH_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD24_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD24_HL_LH_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD24_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSRFQ32SP24S_H_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSRFQ32SP24S_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSRFQ32SP24S_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSRFQ32SP24S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSRFQ32SP24S_H_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSRFQ32SP24S_H_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSRFQ32SP24S_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSRFQ32SP24S_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULARFQ32SP24S_H_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULARFQ32SP24S_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULARFQ32SP24S_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULARFQ32SP24S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULARFQ32SP24S_H_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULARFQ32SP24S_H_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULARFQ32SP24S_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULARFQ32SP24S_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULRFQ32SP24S_H_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULRFQ32SP24S_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULRFQ32SP24S_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULRFQ32SP24S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULRFQ32SP24S_H_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULRFQ32SP24S_H_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULRFQ32SP24S_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULRFQ32SP24S_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFQ32SP24S_H_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFQ32SP24S_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFQ32SP24S_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFQ32SP24S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFQ32SP24S_H_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFQ32SP24S_H_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFQ32SP24S_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFQ32SP24S_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFQ32SP24S_H_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFQ32SP24S_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFQ32SP24S_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFQ32SP24S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFQ32SP24S_H_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFQ32SP24S_H_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFQ32SP24S_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFQ32SP24S_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFQ32SP24S_H_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFQ32SP24S_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFQ32SP24S_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFQ32SP24S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFQ32SP24S_H_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFQ32SP24S_H_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFQ32SP24S_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFQ32SP24S_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L1_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L1_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L1_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L1_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L3_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L3_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L3_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L3_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H1_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H1_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H1_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H1_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H3_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H3_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H3_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H3_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L1_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L1_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L1_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L1_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L3_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L3_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L3_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L3_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H1_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H1_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H1_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H1_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H3_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H3_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H3_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H3_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L1_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L1_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L1_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L1_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L3_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L3_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L3_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L3_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H1_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H1_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H1_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H1_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H3_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H3_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H3_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H3_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H3_L2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H3_L2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H3_L2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H3_L2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H1_L0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H1_L0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H1_L0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H1_L0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H3_L2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H3_L2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H3_L2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H3_L2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H1_L0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H1_L0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H1_L0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H1_L0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H3_L2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H3_L2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H3_L2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H3_L2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H1_L0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H1_L0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H1_L0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H1_L0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H3_L2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H3_L2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H3_L2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H3_L2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H1_L0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H1_L0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H1_L0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H1_L0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H3_L2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H3_L2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H3_L2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H3_L2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H1_L0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H1_L0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H1_L0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H1_L0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H3_L2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H3_L2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H3_L2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H3_L2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H1_L0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H1_L0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H1_L0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H1_L0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H3_L2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H3_L2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H3_L2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H3_L2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H1_L0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H1_L0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H1_L0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H1_L0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H3_L2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H3_L2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H3_L2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H3_L2_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H1_L0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H1_L0_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H1_L0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H1_L0_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H2_L3_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H2_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H0_L1_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H0_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H2_L3_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H2_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H0_L1_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H0_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H2_L3_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H2_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H0_L1_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H0_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H2_L3_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H2_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H0_L1_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H0_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H2_L3_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H2_L3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H0_L1_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H0_L1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H2_L3_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H2_L3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H0_L1_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H0_L1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H2_L3_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H2_L3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H0_L1_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H0_L1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H2_L3_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H2_L3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H0_L1_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H0_L1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X16X2_H_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X16X2_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_H_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_H_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_H_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_H_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_H_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_H_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X16X2_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X16X2_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_L_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'o' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_L_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X16X2_H_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X16X2_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_H_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_H_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_H_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_H_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_H_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_H_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X16X2_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X16X2_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_L_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_L_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X16X2_H_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X16X2_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_H_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_H_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_H_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_H_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_H_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_H_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X16X2_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X16X2_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_L_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_L_S2_args[] = {
  { { OPERAND_ae_mul_S2_q0 }, 'm' },
  { { OPERAND_ae_mul_S2_d0 }, 'i' },
  { { OPERAND_ae_mul_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_L_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RS_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RAS_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RAS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RS_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RAS_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RAS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X2_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RS_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RAS_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RAS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4S_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4RAS_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4RAS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC24_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFC24RA_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFC24RA_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC32X16_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC32X16_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFC32X16RAS_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFC32X16RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC32X16_H_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC32X16_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFC32X16RAS_H_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFC32X16RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC24_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFC24RA_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFC24RA_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC32X16_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC32X16_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFC32X16RAS_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFC32X16RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC32X16_H_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC32X16_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFC32X16RAS_H_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFC32X16RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16X4SS_args[] = {
  { { OPERAND_ae_mul_q1 }, 'o' },
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d1 }, 'i' },
  { { OPERAND_ae_mul_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16X4SS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16X4SS_args[] = {
  { { OPERAND_ae_mul_q1 }, 'm' },
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d1 }, 'i' },
  { { OPERAND_ae_mul_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16X4SS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16X4SS_args[] = {
  { { OPERAND_ae_mul_q1 }, 'm' },
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d1 }, 'i' },
  { { OPERAND_ae_mul_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16X4SS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL16X4_args[] = {
  { { OPERAND_ae_mul_q1 }, 'o' },
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_d1 }, 'i' },
  { { OPERAND_ae_mul_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL16X4_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA16X4_args[] = {
  { { OPERAND_ae_mul_q1 }, 'm' },
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d1 }, 'i' },
  { { OPERAND_ae_mul_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA16X4_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS16X4_args[] = {
  { { OPERAND_ae_mul_q1 }, 'm' },
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_d1 }, 'i' },
  { { OPERAND_ae_mul_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS16X4_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD24X2_FIR_H_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_q1 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' },
  { { OPERAND_ae_mul_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD24X2_FIR_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD24X2_FIR_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_q1 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' },
  { { OPERAND_ae_mul_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD24X2_FIR_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_HH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_q1 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' },
  { { OPERAND_ae_mul_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_HL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_q1 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' },
  { { OPERAND_ae_mul_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_HL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_q1 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' },
  { { OPERAND_ae_mul_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'o' },
  { { OPERAND_ae_mul_q1 }, 'o' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' },
  { { OPERAND_ae_mul_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD24X2_FIR_H_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_q1 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' },
  { { OPERAND_ae_mul_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD24X2_FIR_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD24X2_FIR_L_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_q1 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' },
  { { OPERAND_ae_mul_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD24X2_FIR_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_HH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_q1 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' },
  { { OPERAND_ae_mul_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_HL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_q1 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' },
  { { OPERAND_ae_mul_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_HL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_LH_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_q1 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' },
  { { OPERAND_ae_mul_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_LL_args[] = {
  { { OPERAND_ae_mul_q0 }, 'm' },
  { { OPERAND_ae_mul_q1 }, 'm' },
  { { OPERAND_ae_mul_d0 }, 'i' },
  { { OPERAND_ae_mul_d1 }, 'i' },
  { { OPERAND_ae_mul_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DIV64D32_H_args[] = {
  { { OPERAND_ae_arth_v }, 'm' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DIV64D32_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DIV64D32_L_args[] = {
  { { OPERAND_ae_arth_v }, 'm' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DIV64D32_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SHA32_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL32T_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL32T_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_SEARCHDONE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL16T_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL16T_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_SEARCHDONE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_stateArgs[] = {
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_IP_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_IP_stateArgs[] = {
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_IC_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDSHT_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDSHT_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_AE_FIRST_TS }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_AE_TABLESIZE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LB_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LB_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBI_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBI_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBK_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBK_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBKI_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBKI_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBS_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBS_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBSI_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBSI_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_IC_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_IC_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_IP_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_IP_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_IP_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_IP_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLEL32T_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_art }, 'm' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLEL32T_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLEL16T_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_art }, 'm' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLEL16T_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_ae_ohba2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLES16C_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLES16C_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_NEXTOFFSET }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBF_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SBF_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_IC_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_IC_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_ae_ohba2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLES16C_IC_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLES16C_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_NEXTOFFSET }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBF_IC_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SBF_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_IP_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_IP_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_IP_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_ae_ohba2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_IP_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLES16C_IP_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLES16C_IP_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_NEXTOFFSET }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBF_IP_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SBF_IP_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' },
  { { OPERAND_ae_opnd_tp7 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_LSI_args[] = {
  { { OPERAND_frt }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_imm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_LSI_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_LSIP_args[] = {
  { { OPERAND_frt }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_imm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_LSIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_LSX_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_LSX_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_LSXP_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_LSXP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_SSI_args[] = {
  { { OPERAND_frt }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_imm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_SSI_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_SSIP_args[] = {
  { { OPERAND_frt }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_imm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_SSIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_SSX_args[] = {
  { { OPERAND_frr }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_SSX_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_SSXP_args[] = {
  { { OPERAND_frr }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_SSXP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ABS_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_ABS_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_NEG_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_NEG_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOV_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_MOV_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVEQZ_S_args[] = {
  { { OPERAND_frr }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_MOVEQZ_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVNEZ_S_args[] = {
  { { OPERAND_frr }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_MOVNEZ_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVLTZ_S_args[] = {
  { { OPERAND_frr }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_MOVLTZ_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVGEZ_S_args[] = {
  { { OPERAND_frr }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_MOVGEZ_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVF_S_args[] = {
  { { OPERAND_frr }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_bt }, 'i' }
};

static xtensa_arg_internal Iclass_MOVF_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVT_S_args[] = {
  { { OPERAND_frr }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_bt }, 'i' }
};

static xtensa_arg_internal Iclass_MOVT_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WFR_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_WFR_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RFR_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_RFR_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ROUND_S_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_imm_t }, 'i' }
};

static xtensa_arg_internal Iclass_ROUND_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_CEIL_S_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_imm_t }, 'i' }
};

static xtensa_arg_internal Iclass_CEIL_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_FLOOR_S_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_imm_t }, 'i' }
};

static xtensa_arg_internal Iclass_FLOOR_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_TRUNC_S_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_imm_t }, 'i' }
};

static xtensa_arg_internal Iclass_TRUNC_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_UTRUNC_S_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_imm_t }, 'i' }
};

static xtensa_arg_internal Iclass_UTRUNC_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_FLOAT_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_imm_t }, 'i' }
};

static xtensa_arg_internal Iclass_FLOAT_S_stateArgs[] = {
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_UFLOAT_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_imm_t }, 'i' }
};

static xtensa_arg_internal Iclass_UFLOAT_S_stateArgs[] = {
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_UN_S_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_UN_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ULT_S_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_ULT_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ULE_S_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_ULE_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_UEQ_S_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_UEQ_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_OLT_S_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_OLT_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_OLE_S_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_OLE_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_OEQ_S_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_OEQ_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ADD_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_ADD_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_SUB_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_SUB_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MUL_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_MUL_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MADD_S_args[] = {
  { { OPERAND_frr }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_MADD_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MSUB_S_args[] = {
  { { OPERAND_frr }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_MSUB_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_SQRT0_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_SQRT0_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_DIV0_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_DIV0_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RECIP0_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_RECIP0_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_DivZeroFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RSQRT0_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_RSQRT0_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_DivZeroFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MADDN_S_args[] = {
  { { OPERAND_frr }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_MADDN_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_DIVN_S_args[] = {
  { { OPERAND_frr }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_DIVN_S_stateArgs[] = {
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_CONST_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_imm_s }, 'i' }
};

static xtensa_arg_internal Iclass_CONST_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_NEXP01_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_NEXP01_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ADDEXP_S_args[] = {
  { { OPERAND_frr }, 'm' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_ADDEXP_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ADDEXPM_S_args[] = {
  { { OPERAND_frr }, 'm' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_ADDEXPM_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MKDADJ_S_args[] = {
  { { OPERAND_frr }, 'm' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_MKDADJ_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_DivZeroFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MKSADJ_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_MKSADJ_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfe_stateArgs[] = {
  { { STATE_PSEXCM }, 'o' },
  { { STATE_EPC1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfde_stateArgs[] = {
  { { STATE_DEPC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_call12_args[] = {
  { { OPERAND_soffsetx4 }, 'i' },
  { { OPERAND_ar12 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call12_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call8_args[] = {
  { { OPERAND_soffsetx4 }, 'i' },
  { { OPERAND_ar8 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call8_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call4_args[] = {
  { { OPERAND_soffsetx4 }, 'i' },
  { { OPERAND_ar4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call4_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx12_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ar12 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx12_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx8_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ar8 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx8_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx4_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ar4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx4_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_entry_args[] = {
  { { OPERAND_ars_entry }, 's' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm12x8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_entry_stateArgs[] = {
  { { STATE_PSCALLINC }, 'i' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSWOE }, 'i' },
  { { STATE_WindowBase }, 'm' },
  { { STATE_WindowStart }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_movsp_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_movsp_stateArgs[] = {
  { { STATE_WindowBase }, 'i' },
  { { STATE_WindowStart }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rotw_args[] = {
  { { OPERAND_simm4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rotw_stateArgs[] = {
  { { STATE_WindowBase }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_retw_args[] = {
  { { OPERAND__ars_invisible }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_retw_stateArgs[] = {
  { { STATE_WindowBase }, 'm' },
  { { STATE_WindowStart }, 'm' },
  { { STATE_PSCALLINC }, 'o' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSWOE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfwou_stateArgs[] = {
  { { STATE_EPC1 }, 'i' },
  { { STATE_PSEXCM }, 'o' },
  { { STATE_WindowBase }, 'm' },
  { { STATE_WindowStart }, 'm' },
  { { STATE_PSOWB }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l32e_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_immrx4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32e_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_immrx4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_windowbase_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_windowbase_stateArgs[] = {
  { { STATE_WindowBase }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_windowbase_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_windowbase_stateArgs[] = {
  { { STATE_WindowBase }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_windowbase_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_windowbase_stateArgs[] = {
  { { STATE_WindowBase }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_windowstart_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_windowstart_stateArgs[] = {
  { { STATE_WindowStart }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_windowstart_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_windowstart_stateArgs[] = {
  { { STATE_WindowStart }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_windowstart_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_windowstart_stateArgs[] = {
  { { STATE_WindowStart }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfme_stateArgs[] = {
  { { STATE_MESRMemE }, 'o' },
  { { STATE_MEPC }, 'i' },
  { { STATE_MEPS }, 'i' },
  { { STATE_PSWOE }, 'o' },
  { { STATE_PSCALLINC }, 'o' },
  { { STATE_PSOWB }, 'o' },
  { { STATE_PSUM }, 'o' },
  { { STATE_PSEXCM }, 'o' },
  { { STATE_PSINTLEVEL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_mesr_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_mesr_stateArgs[] = {
  { { STATE_MESRErrEnab }, 'i' },
  { { STATE_MESRErrTest }, 'i' },
  { { STATE_MESRMemE }, 'i' },
  { { STATE_MESRDME }, 'i' },
  { { STATE_MESRMemType }, 'i' },
  { { STATE_MESRAccType }, 'i' },
  { { STATE_MESRErrType }, 'i' },
  { { STATE_MESRWay }, 'i' },
  { { STATE_MESRDataExc }, 'i' },
  { { STATE_MESRInstExc }, 'i' },
  { { STATE_MESRRCE }, 'i' },
  { { STATE_MESRDLCE }, 'i' },
  { { STATE_MESRILCE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_mesr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_mesr_stateArgs[] = {
  { { STATE_MESRErrEnab }, 'o' },
  { { STATE_MESRErrTest }, 'o' },
  { { STATE_MESRMemE }, 'o' },
  { { STATE_MESRDME }, 'o' },
  { { STATE_MESRMemType }, 'o' },
  { { STATE_MESRAccType }, 'o' },
  { { STATE_MESRErrType }, 'o' },
  { { STATE_MESRWay }, 'o' },
  { { STATE_MESRDataExc }, 'o' },
  { { STATE_MESRInstExc }, 'o' },
  { { STATE_MESRRCE }, 'o' },
  { { STATE_MESRDLCE }, 'o' },
  { { STATE_MESRILCE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_mesr_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_mesr_stateArgs[] = {
  { { STATE_MESRErrEnab }, 'm' },
  { { STATE_MESRErrTest }, 'm' },
  { { STATE_MESRMemE }, 'm' },
  { { STATE_MESRDME }, 'm' },
  { { STATE_MESRMemType }, 'm' },
  { { STATE_MESRAccType }, 'm' },
  { { STATE_MESRErrType }, 'm' },
  { { STATE_MESRWay }, 'm' },
  { { STATE_MESRDataExc }, 'm' },
  { { STATE_MESRInstExc }, 'm' },
  { { STATE_MESRRCE }, 'm' },
  { { STATE_MESRDLCE }, 'm' },
  { { STATE_MESRILCE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_mecr_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_mecr_stateArgs[] = {
  { { STATE_MECR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_mecr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_mecr_stateArgs[] = {
  { { STATE_MECR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_mecr_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_mecr_stateArgs[] = {
  { { STATE_MECR }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_mepc_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_mepc_stateArgs[] = {
  { { STATE_MEPC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_mepc_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_mepc_stateArgs[] = {
  { { STATE_MEPC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_mepc_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_mepc_stateArgs[] = {
  { { STATE_MEPC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_meps_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_meps_stateArgs[] = {
  { { STATE_MEPS }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_meps_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_meps_stateArgs[] = {
  { { STATE_MEPS }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_meps_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_meps_stateArgs[] = {
  { { STATE_MEPS }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_mesave_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_mesave_stateArgs[] = {
  { { STATE_MESAVE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_mesave_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_mesave_stateArgs[] = {
  { { STATE_MESAVE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_mesave_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_mesave_stateArgs[] = {
  { { STATE_MESAVE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_mevaddr_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_mevaddr_stateArgs[] = {
  { { STATE_MEVADDR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_mevaddr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_mevaddr_stateArgs[] = {
  { { STATE_MEVADDR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_mevaddr_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_mevaddr_stateArgs[] = {
  { { STATE_MEVADDR }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_add_n_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_addi_n_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ai4const }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bz6_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm6 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_loadi4_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_lsi4x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mov_n_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_movi_n_args[] = {
  { { OPERAND_ars }, 'o' },
  { { OPERAND_simm7 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_retn_args[] = {
  { { OPERAND__ars_invisible }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_storei4_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_lsi4x4 }, 'i' }
};

static xtensa_arg_internal Iclass_rur_threadptr_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_threadptr_stateArgs[] = {
  { { STATE_THREADPTR }, 'i' }
};

static xtensa_arg_internal Iclass_wur_threadptr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_threadptr_stateArgs[] = {
  { { STATE_THREADPTR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_addi_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_simm8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_addmi_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_simm8x256 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_addsub_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bit_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bsi8_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_b4const }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bsi8b_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_bbi }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bsi8u_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_b4constu }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bst8_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bsz12_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_label12 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_call0_args[] = {
  { { OPERAND_soffsetx4 }, 'i' },
  { { OPERAND_ar0 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx0_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ar0 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_exti_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_sae }, 'i' },
  { { OPERAND_op2p1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_jump_args[] = {
  { { OPERAND_soffset }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_jumpx_args[] = {
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l16ui_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l16si_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l32i_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l32r_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_uimm16x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l8i_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_loop_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ulabel8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_loop_stateArgs[] = {
  { { STATE_LBEG }, 'o' },
  { { STATE_LEND }, 'o' },
  { { STATE_LCOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_loopz_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ulabel8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_loopz_stateArgs[] = {
  { { STATE_LBEG }, 'o' },
  { { STATE_LEND }, 'o' },
  { { STATE_LCOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_movi_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_simm12b }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_movz_args[] = {
  { { OPERAND_arr }, 'm' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_neg_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_return_args[] = {
  { { OPERAND__ars_invisible }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s16i_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32i_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32nb_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimmrx4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s8i_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sar_args[] = {
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sar_stateArgs[] = {
  { { STATE_SAR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_sari_args[] = {
  { { OPERAND_sas }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sari_stateArgs[] = {
  { { STATE_SAR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_shifts_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shifts_stateArgs[] = {
  { { STATE_SAR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shiftst_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shiftst_stateArgs[] = {
  { { STATE_SAR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shiftt_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shiftt_stateArgs[] = {
  { { STATE_SAR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_slli_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_msalp32 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_srai_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_sargt }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_srli_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_s }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sync_stateArgs[] = {
  { { STATE_XTSYNC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsil_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_s }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsil_stateArgs[] = {
  { { STATE_PSWOE }, 'i' },
  { { STATE_PSCALLINC }, 'i' },
  { { STATE_PSOWB }, 'i' },
  { { STATE_PSUM }, 'i' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSINTLEVEL }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lend_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lend_stateArgs[] = {
  { { STATE_LEND }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lend_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lend_stateArgs[] = {
  { { STATE_LEND }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lend_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lend_stateArgs[] = {
  { { STATE_LEND }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lcount_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lcount_stateArgs[] = {
  { { STATE_LCOUNT }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lcount_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lcount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_LCOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lcount_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lcount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_LCOUNT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lbeg_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lbeg_stateArgs[] = {
  { { STATE_LBEG }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lbeg_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lbeg_stateArgs[] = {
  { { STATE_LBEG }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lbeg_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lbeg_stateArgs[] = {
  { { STATE_LBEG }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_sar_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_sar_stateArgs[] = {
  { { STATE_SAR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_sar_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_sar_stateArgs[] = {
  { { STATE_SAR }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_sar_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_sar_stateArgs[] = {
  { { STATE_SAR }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_memctl_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_memctl_stateArgs[] = {
  { { STATE_MEMCTL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_memctl_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_memctl_stateArgs[] = {
  { { STATE_MEMCTL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_memctl_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_memctl_stateArgs[] = {
  { { STATE_MEMCTL }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_litbase_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_litbase_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_litbase_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_configid0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_configid0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_configid1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_243_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ps_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ps_stateArgs[] = {
  { { STATE_PSWOE }, 'i' },
  { { STATE_PSCALLINC }, 'i' },
  { { STATE_PSOWB }, 'i' },
  { { STATE_PSUM }, 'i' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSINTLEVEL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ps_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ps_stateArgs[] = {
  { { STATE_PSWOE }, 'o' },
  { { STATE_PSCALLINC }, 'o' },
  { { STATE_PSOWB }, 'o' },
  { { STATE_PSUM }, 'o' },
  { { STATE_PSEXCM }, 'o' },
  { { STATE_PSINTLEVEL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ps_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ps_stateArgs[] = {
  { { STATE_PSWOE }, 'm' },
  { { STATE_PSCALLINC }, 'm' },
  { { STATE_PSOWB }, 'm' },
  { { STATE_PSUM }, 'm' },
  { { STATE_PSEXCM }, 'm' },
  { { STATE_PSINTLEVEL }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc1_stateArgs[] = {
  { { STATE_EPC1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc1_stateArgs[] = {
  { { STATE_EPC1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc1_stateArgs[] = {
  { { STATE_EPC1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave1_stateArgs[] = {
  { { STATE_EXCSAVE1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave1_stateArgs[] = {
  { { STATE_EXCSAVE1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave1_stateArgs[] = {
  { { STATE_EXCSAVE1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc2_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc2_stateArgs[] = {
  { { STATE_EPC2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc2_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc2_stateArgs[] = {
  { { STATE_EPC2 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc2_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc2_stateArgs[] = {
  { { STATE_EPC2 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave2_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave2_stateArgs[] = {
  { { STATE_EXCSAVE2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave2_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave2_stateArgs[] = {
  { { STATE_EXCSAVE2 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave2_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave2_stateArgs[] = {
  { { STATE_EXCSAVE2 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc3_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc3_stateArgs[] = {
  { { STATE_EPC3 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc3_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc3_stateArgs[] = {
  { { STATE_EPC3 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc3_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc3_stateArgs[] = {
  { { STATE_EPC3 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave3_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave3_stateArgs[] = {
  { { STATE_EXCSAVE3 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave3_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave3_stateArgs[] = {
  { { STATE_EXCSAVE3 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave3_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave3_stateArgs[] = {
  { { STATE_EXCSAVE3 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc4_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc4_stateArgs[] = {
  { { STATE_EPC4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc4_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc4_stateArgs[] = {
  { { STATE_EPC4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc4_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc4_stateArgs[] = {
  { { STATE_EPC4 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave4_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave4_stateArgs[] = {
  { { STATE_EXCSAVE4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave4_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave4_stateArgs[] = {
  { { STATE_EXCSAVE4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave4_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave4_stateArgs[] = {
  { { STATE_EXCSAVE4 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc5_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc5_stateArgs[] = {
  { { STATE_EPC5 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc5_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc5_stateArgs[] = {
  { { STATE_EPC5 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc5_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc5_stateArgs[] = {
  { { STATE_EPC5 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave5_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave5_stateArgs[] = {
  { { STATE_EXCSAVE5 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave5_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave5_stateArgs[] = {
  { { STATE_EXCSAVE5 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave5_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave5_stateArgs[] = {
  { { STATE_EXCSAVE5 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc6_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc6_stateArgs[] = {
  { { STATE_EPC6 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc6_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc6_stateArgs[] = {
  { { STATE_EPC6 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc6_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc6_stateArgs[] = {
  { { STATE_EPC6 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave6_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave6_stateArgs[] = {
  { { STATE_EXCSAVE6 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave6_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave6_stateArgs[] = {
  { { STATE_EXCSAVE6 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave6_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave6_stateArgs[] = {
  { { STATE_EXCSAVE6 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc7_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc7_stateArgs[] = {
  { { STATE_EPC7 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc7_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc7_stateArgs[] = {
  { { STATE_EPC7 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc7_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc7_stateArgs[] = {
  { { STATE_EPC7 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave7_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave7_stateArgs[] = {
  { { STATE_EXCSAVE7 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave7_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave7_stateArgs[] = {
  { { STATE_EXCSAVE7 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave7_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave7_stateArgs[] = {
  { { STATE_EXCSAVE7 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps2_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps2_stateArgs[] = {
  { { STATE_EPS2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps2_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps2_stateArgs[] = {
  { { STATE_EPS2 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps2_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps2_stateArgs[] = {
  { { STATE_EPS2 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps3_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps3_stateArgs[] = {
  { { STATE_EPS3 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps3_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps3_stateArgs[] = {
  { { STATE_EPS3 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps3_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps3_stateArgs[] = {
  { { STATE_EPS3 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps4_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps4_stateArgs[] = {
  { { STATE_EPS4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps4_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps4_stateArgs[] = {
  { { STATE_EPS4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps4_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps4_stateArgs[] = {
  { { STATE_EPS4 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps5_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps5_stateArgs[] = {
  { { STATE_EPS5 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps5_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps5_stateArgs[] = {
  { { STATE_EPS5 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps5_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps5_stateArgs[] = {
  { { STATE_EPS5 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps6_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps6_stateArgs[] = {
  { { STATE_EPS6 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps6_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps6_stateArgs[] = {
  { { STATE_EPS6 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps6_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps6_stateArgs[] = {
  { { STATE_EPS6 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps7_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps7_stateArgs[] = {
  { { STATE_EPS7 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps7_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps7_stateArgs[] = {
  { { STATE_EPS7 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps7_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps7_stateArgs[] = {
  { { STATE_EPS7 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excvaddr_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excvaddr_stateArgs[] = {
  { { STATE_EXCVADDR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excvaddr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excvaddr_stateArgs[] = {
  { { STATE_EXCVADDR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excvaddr_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excvaddr_stateArgs[] = {
  { { STATE_EXCVADDR }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_depc_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_depc_stateArgs[] = {
  { { STATE_DEPC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_depc_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_depc_stateArgs[] = {
  { { STATE_DEPC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_depc_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_depc_stateArgs[] = {
  { { STATE_DEPC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_exccause_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_exccause_stateArgs[] = {
  { { STATE_EXCCAUSE }, 'i' },
  { { STATE_XTSYNC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_exccause_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_exccause_stateArgs[] = {
  { { STATE_EXCCAUSE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_exccause_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_exccause_stateArgs[] = {
  { { STATE_EXCCAUSE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_prid_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_vecbase_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_vecbase_stateArgs[] = {
  { { STATE_VECBASE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_vecbase_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_vecbase_stateArgs[] = {
  { { STATE_VECBASE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_vecbase_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_vecbase_stateArgs[] = {
  { { STATE_VECBASE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_mul16_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_mul32_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_mul32h_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfi_args[] = {
  { { OPERAND_s }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfi_stateArgs[] = {
  { { STATE_PSWOE }, 'o' },
  { { STATE_PSCALLINC }, 'o' },
  { { STATE_PSOWB }, 'o' },
  { { STATE_PSUM }, 'o' },
  { { STATE_PSEXCM }, 'o' },
  { { STATE_PSINTLEVEL }, 'o' },
  { { STATE_EPC1 }, 'i' },
  { { STATE_EPC2 }, 'i' },
  { { STATE_EPC3 }, 'i' },
  { { STATE_EPC4 }, 'i' },
  { { STATE_EPC5 }, 'i' },
  { { STATE_EPC6 }, 'i' },
  { { STATE_EPC7 }, 'i' },
  { { STATE_EPS2 }, 'i' },
  { { STATE_EPS3 }, 'i' },
  { { STATE_EPS4 }, 'i' },
  { { STATE_EPS5 }, 'i' },
  { { STATE_EPS6 }, 'i' },
  { { STATE_EPS7 }, 'i' },
  { { STATE_InOCDMode }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_wait_args[] = {
  { { OPERAND_s }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wait_stateArgs[] = {
  { { STATE_PSINTLEVEL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_interrupt_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_interrupt_stateArgs[] = {
  { { STATE_INTERRUPT }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intset_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intset_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intclear_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intclear_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_intenable_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_intenable_stateArgs[] = {
  { { STATE_INTENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intenable_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intenable_stateArgs[] = {
  { { STATE_INTENABLE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_intenable_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_intenable_stateArgs[] = {
  { { STATE_INTENABLE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_break_args[] = {
  { { OPERAND_imms }, 'i' },
  { { OPERAND_immt }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_break_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSINTLEVEL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_break_n_args[] = {
  { { OPERAND_imms }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_break_n_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSINTLEVEL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreaka0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreaka0_stateArgs[] = {
  { { STATE_DBREAKA0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreaka0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreaka0_stateArgs[] = {
  { { STATE_DBREAKA0 }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreaka0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreaka0_stateArgs[] = {
  { { STATE_DBREAKA0 }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreakc0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreakc0_stateArgs[] = {
  { { STATE_DBREAKC0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreakc0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreakc0_stateArgs[] = {
  { { STATE_DBREAKC0 }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreakc0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreakc0_stateArgs[] = {
  { { STATE_DBREAKC0 }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreaka1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreaka1_stateArgs[] = {
  { { STATE_DBREAKA1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreaka1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreaka1_stateArgs[] = {
  { { STATE_DBREAKA1 }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreaka1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreaka1_stateArgs[] = {
  { { STATE_DBREAKA1 }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreakc1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreakc1_stateArgs[] = {
  { { STATE_DBREAKC1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreakc1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreakc1_stateArgs[] = {
  { { STATE_DBREAKC1 }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreakc1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreakc1_stateArgs[] = {
  { { STATE_DBREAKC1 }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreaka0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreaka0_stateArgs[] = {
  { { STATE_IBREAKA0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreaka0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreaka0_stateArgs[] = {
  { { STATE_IBREAKA0 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreaka0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreaka0_stateArgs[] = {
  { { STATE_IBREAKA0 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreaka1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreaka1_stateArgs[] = {
  { { STATE_IBREAKA1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreaka1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreaka1_stateArgs[] = {
  { { STATE_IBREAKA1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreaka1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreaka1_stateArgs[] = {
  { { STATE_IBREAKA1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreakenable_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreakenable_stateArgs[] = {
  { { STATE_IBREAKENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreakenable_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreakenable_stateArgs[] = {
  { { STATE_IBREAKENABLE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreakenable_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreakenable_stateArgs[] = {
  { { STATE_IBREAKENABLE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_debugcause_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_debugcause_stateArgs[] = {
  { { STATE_DEBUGCAUSE }, 'i' },
  { { STATE_DBNUM }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_debugcause_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_debugcause_stateArgs[] = {
  { { STATE_DEBUGCAUSE }, 'o' },
  { { STATE_DBNUM }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_debugcause_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_debugcause_stateArgs[] = {
  { { STATE_DEBUGCAUSE }, 'm' },
  { { STATE_DBNUM }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_icount_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_icount_stateArgs[] = {
  { { STATE_ICOUNT }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_icount_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_icount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_ICOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_icount_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_icount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_ICOUNT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_icountlevel_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_icountlevel_stateArgs[] = {
  { { STATE_ICOUNTLEVEL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_icountlevel_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_icountlevel_stateArgs[] = {
  { { STATE_ICOUNTLEVEL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_icountlevel_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_icountlevel_stateArgs[] = {
  { { STATE_ICOUNTLEVEL }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ddr_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ddr_stateArgs[] = {
  { { STATE_DDR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ddr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ddr_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_DDR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ddr_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ddr_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_DDR }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_lddr32_p_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_lddr32_p_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_InOCDMode }, 'i' },
  { { STATE_DDR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_sddr32_p_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_sddr32_p_stateArgs[] = {
  { { STATE_InOCDMode }, 'i' },
  { { STATE_DDR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfdo_args[] = {
  { { OPERAND_imms }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfdo_stateArgs[] = {
  { { STATE_InOCDMode }, 'm' },
  { { STATE_EPC6 }, 'i' },
  { { STATE_PSWOE }, 'o' },
  { { STATE_PSCALLINC }, 'o' },
  { { STATE_PSOWB }, 'o' },
  { { STATE_PSUM }, 'o' },
  { { STATE_PSEXCM }, 'o' },
  { { STATE_PSINTLEVEL }, 'o' },
  { { STATE_EPS6 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfdd_stateArgs[] = {
  { { STATE_InOCDMode }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_mmid_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_mmid_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_bbool1_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_bs }, 'i' },
  { { OPERAND_bt }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bbool4_args[] = {
  { { OPERAND_bt }, 'o' },
  { { OPERAND_bs4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bbool8_args[] = {
  { { OPERAND_bt }, 'o' },
  { { OPERAND_bs8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bbranch_args[] = {
  { { OPERAND_bs }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bmove_args[] = {
  { { OPERAND_arr }, 'm' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_bt }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_RSR_BR_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_brall }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_WSR_BR_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_brall }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_XSR_BR_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_brall }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccount_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccount_stateArgs[] = {
  { { STATE_CCOUNT }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccount_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_CCOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccount_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_CCOUNT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare0_stateArgs[] = {
  { { STATE_CCOMPARE0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare0_stateArgs[] = {
  { { STATE_CCOMPARE0 }, 'o' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare0_stateArgs[] = {
  { { STATE_CCOMPARE0 }, 'm' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare1_stateArgs[] = {
  { { STATE_CCOMPARE1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare1_stateArgs[] = {
  { { STATE_CCOMPARE1 }, 'o' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare1_stateArgs[] = {
  { { STATE_CCOMPARE1 }, 'm' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare2_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare2_stateArgs[] = {
  { { STATE_CCOMPARE2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare2_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare2_stateArgs[] = {
  { { STATE_CCOMPARE2 }, 'o' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare2_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare2_stateArgs[] = {
  { { STATE_CCOMPARE2 }, 'm' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_icache_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_icache_lock_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm4x16 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_icache_inv_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_licx_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_licx_stateArgs[] = {
  { { STATE_MESRErrTest }, 'i' },
  { { STATE_MECR }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_sicx_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_dcache_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_dcache_dyn_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_dcache_ind_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm4x16 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_dcache_inv_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_dpf_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_dcache_lock_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm4x16 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sdct_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_ldct_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_ldct_stateArgs[] = {
  { { STATE_MESRErrTest }, 'i' },
  { { STATE_MECR }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_prefctl_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_prefctl_stateArgs[] = {
  { { STATE_PREFCTL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_prefctl_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_prefctl_stateArgs[] = {
  { { STATE_PREFCTL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_prefctl_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_prefctl_stateArgs[] = {
  { { STATE_PREFCTL }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_idtlb_args[] = {
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_idtlb_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rdtlb_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wdtlb_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wdtlb_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_iitlb_args[] = {
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_ritlb_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_witlb_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_cpenable_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_cpenable_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_cpenable_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_cpenable_stateArgs[] = {
  { { STATE_CPENABLE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_cpenable_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_cpenable_stateArgs[] = {
  { { STATE_CPENABLE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_clamp_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_tp7 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_minmax_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_nsa_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sx_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_tp7 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l32ai_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32ri_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32c1i_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32c1i_stateArgs[] = {
  { { STATE_SCOMPARE1 }, 'i' },
  { { STATE_XTSYNC }, 'i' },
  { { STATE_SCOMPARE1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_scompare1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_scompare1_stateArgs[] = {
  { { STATE_SCOMPARE1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_scompare1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_scompare1_stateArgs[] = {
  { { STATE_SCOMPARE1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_scompare1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_scompare1_stateArgs[] = {
  { { STATE_SCOMPARE1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_atomctl_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_atomctl_stateArgs[] = {
  { { STATE_ATOMCTL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_atomctl_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_atomctl_stateArgs[] = {
  { { STATE_ATOMCTL }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_atomctl_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_atomctl_stateArgs[] = {
  { { STATE_ATOMCTL }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_div_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rer_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wer_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wb18_0_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_xt_wbr18_label }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wb18_1_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_b4const }, 'i' },
  { { OPERAND_xt_wbr18_label }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wb18_2_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_b4constu }, 'i' },
  { { OPERAND_xt_wbr18_label }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wb18_3_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_bbi }, 'i' },
  { { OPERAND_xt_wbr18_label }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wb18_4_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_xt_wbr18_label }, 'i' }
};

static xtensa_arg_internal Iclass_rur_ae_ovf_sar_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_ovf_sar_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'i' },
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_ovf_sar_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_ovf_sar_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'o' },
  { { STATE_AE_SAR }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_ae_bithead_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_bithead_stateArgs[] = {
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_bithead_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_bithead_stateArgs[] = {
  { { STATE_AE_BITHEAD }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_ae_ts_fts_bu_bp_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_ts_fts_bu_bp_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_TABLESIZE }, 'i' },
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_ts_fts_bu_bp_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_ts_fts_bu_bp_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'o' },
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_AE_TABLESIZE }, 'o' },
  { { STATE_AE_FIRST_TS }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_ae_cw_sd_no_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_cw_sd_no_stateArgs[] = {
  { { STATE_AE_CWRAP }, 'i' },
  { { STATE_AE_NEXTOFFSET }, 'i' },
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cw_sd_no_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cw_sd_no_stateArgs[] = {
  { { STATE_AE_CWRAP }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_AE_SEARCHDONE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_ae_cbegin0_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_cbegin0_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cbegin0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cbegin0_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_ae_cend0_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_cend0_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cend0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cend0_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_fcr_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_fcr_stateArgs[] = {
  { { STATE_RoundMode }, 'i' },
  { { STATE_InvalidEnable }, 'i' },
  { { STATE_DivZeroEnable }, 'i' },
  { { STATE_OverflowEnable }, 'i' },
  { { STATE_UnderflowEnable }, 'i' },
  { { STATE_InexactEnable }, 'i' },
  { { STATE_FPreserved20 }, 'i' },
  { { STATE_FPreserved5 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_fcr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_fcr_stateArgs[] = {
  { { STATE_RoundMode }, 'o' },
  { { STATE_InvalidEnable }, 'o' },
  { { STATE_DivZeroEnable }, 'o' },
  { { STATE_OverflowEnable }, 'o' },
  { { STATE_UnderflowEnable }, 'o' },
  { { STATE_InexactEnable }, 'o' },
  { { STATE_FPreserved20 }, 'o' },
  { { STATE_FPreserved5 }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_fsr_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_fsr_stateArgs[] = {
  { { STATE_InvalidFlag }, 'i' },
  { { STATE_DivZeroFlag }, 'i' },
  { { STATE_OverflowFlag }, 'i' },
  { { STATE_UnderflowFlag }, 'i' },
  { { STATE_InexactFlag }, 'i' },
  { { STATE_FPreserved20a }, 'i' },
  { { STATE_FPreserved7 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_fsr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_fsr_stateArgs[] = {
  { { STATE_InvalidFlag }, 'o' },
  { { STATE_DivZeroFlag }, 'o' },
  { { STATE_OverflowFlag }, 'o' },
  { { STATE_UnderflowFlag }, 'o' },
  { { STATE_InexactFlag }, 'o' },
  { { STATE_FPreserved20a }, 'o' },
  { { STATE_FPreserved7 }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_iclass_internal iclasses[] = {
  { 1, Iclass_RUR_AE_OVERFLOW_args,
    2, Iclass_RUR_AE_OVERFLOW_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_OVERFLOW_args,
    2, Iclass_WUR_AE_OVERFLOW_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_SAR_args,
    2, Iclass_RUR_AE_SAR_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_SAR_args,
    2, Iclass_WUR_AE_SAR_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_BITPTR_args,
    2, Iclass_RUR_AE_BITPTR_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_BITPTR_args,
    2, Iclass_WUR_AE_BITPTR_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_BITSUSED_args,
    2, Iclass_RUR_AE_BITSUSED_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_BITSUSED_args,
    2, Iclass_WUR_AE_BITSUSED_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_TABLESIZE_args,
    2, Iclass_RUR_AE_TABLESIZE_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_TABLESIZE_args,
    2, Iclass_WUR_AE_TABLESIZE_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_FIRST_TS_args,
    2, Iclass_RUR_AE_FIRST_TS_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_FIRST_TS_args,
    2, Iclass_WUR_AE_FIRST_TS_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_NEXTOFFSET_args,
    2, Iclass_RUR_AE_NEXTOFFSET_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_NEXTOFFSET_args,
    2, Iclass_WUR_AE_NEXTOFFSET_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_SEARCHDONE_args,
    2, Iclass_RUR_AE_SEARCHDONE_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_SEARCHDONE_args,
    2, Iclass_WUR_AE_SEARCHDONE_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_CWRAP_args,
    2, Iclass_RUR_AE_CWRAP_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_CWRAP_args,
    2, Iclass_WUR_AE_CWRAP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16M_XC_args,
    3, Iclass_AE_L16M_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16M_I_args,
    1, Iclass_AE_L16M_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16M_IU_args,
    1, Iclass_AE_L16M_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16M_X_args,
    1, Iclass_AE_L16M_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16M_XU_args,
    1, Iclass_AE_L16M_XU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16_XC_args,
    3, Iclass_AE_L16_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16_I_args,
    1, Iclass_AE_L16_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16_IP_args,
    1, Iclass_AE_L16_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16_X_args,
    1, Iclass_AE_L16_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16_XP_args,
    1, Iclass_AE_L16_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32F24_XC_args,
    3, Iclass_AE_L32F24_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32F24_I_args,
    1, Iclass_AE_L32F24_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32F24_IP_args,
    1, Iclass_AE_L32F24_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32F24_X_args,
    1, Iclass_AE_L32F24_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32F24_XP_args,
    1, Iclass_AE_L32F24_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32_XC_args,
    3, Iclass_AE_L32_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32_I_args,
    1, Iclass_AE_L32_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32_IP_args,
    1, Iclass_AE_L32_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32_X_args,
    1, Iclass_AE_L32_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32_XP_args,
    1, Iclass_AE_L32_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32M_XC_args,
    3, Iclass_AE_L32M_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32M_I_args,
    1, Iclass_AE_L32M_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32M_IU_args,
    1, Iclass_AE_L32M_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32M_X_args,
    1, Iclass_AE_L32M_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32M_XU_args,
    1, Iclass_AE_L32M_XU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X2M_XC_args,
    3, Iclass_AE_L16X2M_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X2M_I_args,
    1, Iclass_AE_L16X2M_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X2M_IU_args,
    1, Iclass_AE_L16X2M_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X2M_X_args,
    1, Iclass_AE_L16X2M_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X2M_XU_args,
    1, Iclass_AE_L16X2M_XU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2F24_XC_args,
    3, Iclass_AE_L32X2F24_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2F24_I_args,
    1, Iclass_AE_L32X2F24_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2F24_IP_args,
    1, Iclass_AE_L32X2F24_IP_stateArgs, 0, 0 },
  { 2, Iclass_AE_L32X2F24_RIP_args,
    1, Iclass_AE_L32X2F24_RIP_stateArgs, 0, 0 },
  { 2, Iclass_AE_L32X2F24_RIC_args,
    3, Iclass_AE_L32X2F24_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2F24_X_args,
    1, Iclass_AE_L32X2F24_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2F24_XP_args,
    1, Iclass_AE_L32X2F24_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2_XC_args,
    3, Iclass_AE_L32X2_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2_I_args,
    1, Iclass_AE_L32X2_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2_IP_args,
    1, Iclass_AE_L32X2_IP_stateArgs, 0, 0 },
  { 2, Iclass_AE_L32X2_RIP_args,
    1, Iclass_AE_L32X2_RIP_stateArgs, 0, 0 },
  { 2, Iclass_AE_L32X2_RIC_args,
    3, Iclass_AE_L32X2_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2_X_args,
    1, Iclass_AE_L32X2_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2_XP_args,
    1, Iclass_AE_L32X2_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X4_XC_args,
    3, Iclass_AE_L16X4_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X4_I_args,
    1, Iclass_AE_L16X4_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X4_IP_args,
    1, Iclass_AE_L16X4_IP_stateArgs, 0, 0 },
  { 2, Iclass_AE_L16X4_RIP_args,
    1, Iclass_AE_L16X4_RIP_stateArgs, 0, 0 },
  { 2, Iclass_AE_L16X4_RIC_args,
    3, Iclass_AE_L16X4_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X4_X_args,
    1, Iclass_AE_L16X4_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X4_XP_args,
    1, Iclass_AE_L16X4_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L64_XC_args,
    3, Iclass_AE_L64_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L64_I_args,
    1, Iclass_AE_L64_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L64_IP_args,
    1, Iclass_AE_L64_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L64_X_args,
    1, Iclass_AE_L64_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L64_XP_args,
    1, Iclass_AE_L64_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X2M_XC_args,
    3, Iclass_AE_S16X2M_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X2M_I_args,
    1, Iclass_AE_S16X2M_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X2M_IU_args,
    1, Iclass_AE_S16X2M_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X2M_X_args,
    1, Iclass_AE_S16X2M_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X2M_XU_args,
    1, Iclass_AE_S16X2M_XU_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2F24_XC_args,
    3, Iclass_AE_S32X2F24_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2F24_I_args,
    1, Iclass_AE_S32X2F24_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2F24_IP_args,
    1, Iclass_AE_S32X2F24_IP_stateArgs, 0, 0 },
  { 2, Iclass_AE_S32X2F24_RIP_args,
    1, Iclass_AE_S32X2F24_RIP_stateArgs, 0, 0 },
  { 2, Iclass_AE_S32X2F24_RIC_args,
    3, Iclass_AE_S32X2F24_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2F24_X_args,
    1, Iclass_AE_S32X2F24_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2F24_XP_args,
    1, Iclass_AE_S32X2F24_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2_XC_args,
    3, Iclass_AE_S32X2_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2_I_args,
    1, Iclass_AE_S32X2_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2_IP_args,
    1, Iclass_AE_S32X2_IP_stateArgs, 0, 0 },
  { 2, Iclass_AE_S32X2_RIP_args,
    1, Iclass_AE_S32X2_RIP_stateArgs, 0, 0 },
  { 2, Iclass_AE_S32X2_RIC_args,
    3, Iclass_AE_S32X2_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2_X_args,
    1, Iclass_AE_S32X2_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2_XP_args,
    1, Iclass_AE_S32X2_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4_XC_args,
    3, Iclass_AE_S16X4_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4_I_args,
    1, Iclass_AE_S16X4_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4_IP_args,
    1, Iclass_AE_S16X4_IP_stateArgs, 0, 0 },
  { 2, Iclass_AE_S16X4_RIP_args,
    1, Iclass_AE_S16X4_RIP_stateArgs, 0, 0 },
  { 2, Iclass_AE_S16X4_RIC_args,
    3, Iclass_AE_S16X4_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4_X_args,
    1, Iclass_AE_S16X4_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4_XP_args,
    1, Iclass_AE_S16X4_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16M_L_XC_args,
    3, Iclass_AE_S16M_L_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16M_L_I_args,
    1, Iclass_AE_S16M_L_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16M_L_IU_args,
    1, Iclass_AE_S16M_L_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16M_L_X_args,
    1, Iclass_AE_S16M_L_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16M_L_XU_args,
    1, Iclass_AE_S16M_L_XU_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32F24_L_XC_args,
    3, Iclass_AE_S32F24_L_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32F24_L_I_args,
    1, Iclass_AE_S32F24_L_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32F24_L_IP_args,
    1, Iclass_AE_S32F24_L_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32F24_L_X_args,
    1, Iclass_AE_S32F24_L_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32F24_L_XP_args,
    1, Iclass_AE_S32F24_L_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_L_XC_args,
    3, Iclass_AE_S32_L_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_L_I_args,
    1, Iclass_AE_S32_L_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_L_IP_args,
    1, Iclass_AE_S32_L_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_L_X_args,
    1, Iclass_AE_S32_L_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_L_XP_args,
    1, Iclass_AE_S32_L_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16_0_XC_args,
    3, Iclass_AE_S16_0_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16_0_I_args,
    1, Iclass_AE_S16_0_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16_0_IP_args,
    1, Iclass_AE_S16_0_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16_0_X_args,
    1, Iclass_AE_S16_0_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16_0_XP_args,
    1, Iclass_AE_S16_0_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S64_XC_args,
    3, Iclass_AE_S64_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S64_I_args,
    1, Iclass_AE_S64_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S64_IP_args,
    1, Iclass_AE_S64_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S64_X_args,
    1, Iclass_AE_S64_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S64_XP_args,
    1, Iclass_AE_S64_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32M_XC_args,
    3, Iclass_AE_S32M_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32M_I_args,
    1, Iclass_AE_S32M_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32M_IU_args,
    1, Iclass_AE_S32M_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32M_X_args,
    1, Iclass_AE_S32M_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32M_XU_args,
    1, Iclass_AE_S32M_XU_stateArgs, 0, 0 },
  { 1, Iclass_AE_ZALIGN64_args,
    1, Iclass_AE_ZALIGN64_stateArgs, 0, 0 },
  { 3, Iclass_AE_LALIGN64_I_args,
    1, Iclass_AE_LALIGN64_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_SALIGN64_I_args,
    1, Iclass_AE_SALIGN64_I_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVALIGN_args,
    1, Iclass_AE_MOVALIGN_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA64_PP_args,
    1, Iclass_AE_LA64_PP_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA24POS_PC_args,
    3, Iclass_AE_LA24POS_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA24X2POS_PC_args,
    3, Iclass_AE_LA24X2POS_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA32X2POS_PC_args,
    3, Iclass_AE_LA32X2POS_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA16X4POS_PC_args,
    3, Iclass_AE_LA16X4POS_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA24NEG_PC_args,
    3, Iclass_AE_LA24NEG_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA24X2NEG_PC_args,
    3, Iclass_AE_LA24X2NEG_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA32X2NEG_PC_args,
    3, Iclass_AE_LA32X2NEG_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA16X4NEG_PC_args,
    3, Iclass_AE_LA16X4NEG_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_SA64POS_FP_args,
    1, Iclass_AE_SA64POS_FP_stateArgs, 0, 0 },
  { 2, Iclass_AE_SA64NEG_FP_args,
    1, Iclass_AE_SA64NEG_FP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2_IC_args,
    3, Iclass_AE_LA32X2_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2_IP_args,
    1, Iclass_AE_LA32X2_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2_RIP_args,
    1, Iclass_AE_LA32X2_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2_RIC_args,
    3, Iclass_AE_LA32X2_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA16X4_IC_args,
    3, Iclass_AE_LA16X4_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA16X4_IP_args,
    1, Iclass_AE_LA16X4_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA16X4_RIP_args,
    1, Iclass_AE_LA16X4_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA16X4_RIC_args,
    3, Iclass_AE_LA16X4_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2F24_IC_args,
    3, Iclass_AE_LA32X2F24_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2F24_IP_args,
    1, Iclass_AE_LA32X2F24_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2F24_RIP_args,
    1, Iclass_AE_LA32X2F24_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2F24_RIC_args,
    3, Iclass_AE_LA32X2F24_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24_IC_args,
    3, Iclass_AE_LA24_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24_IP_args,
    1, Iclass_AE_LA24_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24_RIP_args,
    1, Iclass_AE_LA24_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24_RIC_args,
    3, Iclass_AE_LA24_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24X2_IC_args,
    3, Iclass_AE_LA24X2_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24X2_IP_args,
    1, Iclass_AE_LA24X2_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24X2_RIP_args,
    1, Iclass_AE_LA24X2_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24X2_RIC_args,
    3, Iclass_AE_LA24X2_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2_IC_args,
    3, Iclass_AE_SA32X2_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2_IP_args,
    1, Iclass_AE_SA32X2_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2_RIP_args,
    1, Iclass_AE_SA32X2_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2_RIC_args,
    3, Iclass_AE_SA32X2_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA16X4_IC_args,
    3, Iclass_AE_SA16X4_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA16X4_IP_args,
    1, Iclass_AE_SA16X4_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA16X4_RIP_args,
    1, Iclass_AE_SA16X4_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA16X4_RIC_args,
    3, Iclass_AE_SA16X4_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2F24_IC_args,
    3, Iclass_AE_SA32X2F24_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2F24_IP_args,
    1, Iclass_AE_SA32X2F24_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2F24_RIP_args,
    1, Iclass_AE_SA32X2F24_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2F24_RIC_args,
    3, Iclass_AE_SA32X2F24_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24_L_IC_args,
    3, Iclass_AE_SA24_L_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24_L_IP_args,
    1, Iclass_AE_SA24_L_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24_L_RIP_args,
    1, Iclass_AE_SA24_L_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24_L_RIC_args,
    3, Iclass_AE_SA24_L_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24X2_IC_args,
    3, Iclass_AE_SA24X2_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24X2_IP_args,
    1, Iclass_AE_SA24X2_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24X2_RIP_args,
    1, Iclass_AE_SA24X2_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24X2_RIC_args,
    3, Iclass_AE_SA24X2_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32RA64S_I_args,
    2, Iclass_AE_S32RA64S_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32RA64S_IP_args,
    2, Iclass_AE_S32RA64S_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32RA64S_X_args,
    2, Iclass_AE_S32RA64S_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32RA64S_XP_args,
    2, Iclass_AE_S32RA64S_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32RA64S_XC_args,
    4, Iclass_AE_S32RA64S_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S24RA64S_I_args,
    2, Iclass_AE_S24RA64S_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S24RA64S_IP_args,
    2, Iclass_AE_S24RA64S_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S24RA64S_X_args,
    2, Iclass_AE_S24RA64S_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S24RA64S_XP_args,
    2, Iclass_AE_S24RA64S_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S24RA64S_XC_args,
    4, Iclass_AE_S24RA64S_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2RA64S_IP_args,
    2, Iclass_AE_S32X2RA64S_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S24X2RA64S_IP_args,
    2, Iclass_AE_S24X2RA64S_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADDBRBA32_args,
    0, 0, 0, 0 },
  { 4, Iclass_AE_SEL16I_args,
    1, Iclass_AE_SEL16I_stateArgs, 0, 0 },
  { 4, Iclass_AE_SEL16I_N_args,
    1, Iclass_AE_SEL16I_N_stateArgs, 0, 0 },
  { 2, Iclass_AE_SHORTSWAP_args,
    1, Iclass_AE_SHORTSWAP_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVT16X4_args,
    1, Iclass_AE_MOVT16X4_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVF16X4_args,
    1, Iclass_AE_MOVF16X4_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVT32X2_args,
    1, Iclass_AE_MOVT32X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVF32X2_args,
    1, Iclass_AE_MOVF32X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVDA32X2_args,
    1, Iclass_AE_MOVDA32X2_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVDA32_args,
    1, Iclass_AE_MOVDA32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVDA16X2_args,
    1, Iclass_AE_MOVDA16X2_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVDA16_args,
    1, Iclass_AE_MOVDA16_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVI_args,
    1, Iclass_AE_MOVI_stateArgs, 0, 0 },
  { 3, Iclass_AE_TRUNCP24A32X2_args,
    1, Iclass_AE_TRUNCP24A32X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_SAT16X4_args,
    2, Iclass_AE_SAT16X4_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVT32X2F16_32_args,
    1, Iclass_AE_CVT32X2F16_32_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVT32X2F16_10_args,
    1, Iclass_AE_CVT32X2F16_10_stateArgs, 0, 0 },
  { 2, Iclass_AE_SEXT32X2D16_32_args,
    1, Iclass_AE_SEXT32X2D16_32_stateArgs, 0, 0 },
  { 2, Iclass_AE_SEXT32X2D16_10_args,
    1, Iclass_AE_SEXT32X2D16_10_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVTA32F24S_L_args,
    1, Iclass_AE_CVTA32F24S_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVTA32F24S_H_args,
    1, Iclass_AE_CVTA32F24S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_CVTP24A16X2_LL_args,
    1, Iclass_AE_CVTP24A16X2_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_CVTP24A16X2_LH_args,
    1, Iclass_AE_CVTP24A16X2_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_CVTP24A16X2_HL_args,
    1, Iclass_AE_CVTP24A16X2_HL_stateArgs, 0, 0 },
  { 3, Iclass_AE_CVTP24A16X2_HH_args,
    1, Iclass_AE_CVTP24A16X2_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_TRUNCP24Q48X2_args,
    1, Iclass_AE_TRUNCP24Q48X2_stateArgs, 0, 0 },
  { 4, Iclass_AE_TRUNCA32X2F64S_args,
    2, Iclass_AE_TRUNCA32X2F64S_stateArgs, 0, 0 },
  { 4, Iclass_AE_TRUNCI32X2F64S_args,
    2, Iclass_AE_TRUNCI32X2F64S_stateArgs, 0, 0 },
  { 4, Iclass_AE_TRUNCA32F64S_L_args,
    2, Iclass_AE_TRUNCA32F64S_L_stateArgs, 0, 0 },
  { 4, Iclass_AE_TRUNCI32F64S_L_args,
    2, Iclass_AE_TRUNCI32F64S_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_TRUNCP16_args,
    1, Iclass_AE_TRUNCP16_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND32X2F64SSYM_args,
    2, Iclass_AE_ROUND32X2F64SSYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND32X2F64SASYM_args,
    2, Iclass_AE_ROUND32X2F64SASYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND32X2F48SSYM_args,
    2, Iclass_AE_ROUND32X2F48SSYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND32X2F48SASYM_args,
    2, Iclass_AE_ROUND32X2F48SASYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND16X4F32SSYM_args,
    2, Iclass_AE_ROUND16X4F32SSYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND16X4F32SASYM_args,
    2, Iclass_AE_ROUND16X4F32SASYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND24X2F48SSYM_args,
    2, Iclass_AE_ROUND24X2F48SSYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND24X2F48SASYM_args,
    2, Iclass_AE_ROUND24X2F48SASYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUNDSP16Q48X2SYM_args,
    2, Iclass_AE_ROUNDSP16Q48X2SYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUNDSP16Q48X2ASYM_args,
    2, Iclass_AE_ROUNDSP16Q48X2ASYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_MINABS32S_args,
    2, Iclass_AE_MINABS32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_MAXABS32S_args,
    2, Iclass_AE_MAXABS32S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ROUNDSP16F24SYM_args,
    2, Iclass_AE_ROUNDSP16F24SYM_stateArgs, 0, 0 },
  { 2, Iclass_AE_ROUNDSP16F24ASYM_args,
    2, Iclass_AE_ROUNDSP16F24ASYM_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOV_args,
    1, Iclass_AE_MOV_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVT64_args,
    1, Iclass_AE_MOVT64_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVF64_args,
    1, Iclass_AE_MOVF64_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVTQ56A32S_args,
    1, Iclass_AE_CVTQ56A32S_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVT48A32_args,
    1, Iclass_AE_CVT48A32_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVT64A32_args,
    1, Iclass_AE_CVT64A32_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVTQ56P32S_L_args,
    1, Iclass_AE_CVTQ56P32S_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVTQ56P32S_H_args,
    1, Iclass_AE_CVTQ56P32S_H_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVT64F32_H_args,
    1, Iclass_AE_CVT64F32_H_stateArgs, 0, 0 },
  { 2, Iclass_AE_SAT48S_args,
    2, Iclass_AE_SAT48S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SATQ56S_args,
    2, Iclass_AE_SATQ56S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SAT24S_args,
    2, Iclass_AE_SAT24S_stateArgs, 0, 0 },
  { 2, Iclass_AE_TRUNCQ32_args,
    1, Iclass_AE_TRUNCQ32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MINABS64S_args,
    2, Iclass_AE_MINABS64S_stateArgs, 0, 0 },
  { 3, Iclass_AE_MAXABS64S_args,
    2, Iclass_AE_MAXABS64S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ROUNDSQ32F48SYM_args,
    2, Iclass_AE_ROUNDSQ32F48SYM_stateArgs, 0, 0 },
  { 2, Iclass_AE_ROUNDSQ32F48ASYM_args,
    2, Iclass_AE_ROUNDSQ32F48ASYM_stateArgs, 0, 0 },
  { 2, Iclass_AE_TRUNCA32Q48_args,
    1, Iclass_AE_TRUNCA32Q48_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD32_L_args,
    1, Iclass_AE_MOVAD32_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD32_H_args,
    1, Iclass_AE_MOVAD32_H_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD16_3_args,
    1, Iclass_AE_MOVAD16_3_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD16_2_args,
    1, Iclass_AE_MOVAD16_2_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD16_1_args,
    1, Iclass_AE_MOVAD16_1_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD16_0_args,
    1, Iclass_AE_MOVAD16_0_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRA64_32_args,
    1, Iclass_AE_SRA64_32_stateArgs, 0, 0 },
  { 3, Iclass_AE_PKSR32_args,
    2, Iclass_AE_PKSR32_stateArgs, 0, 0 },
  { 3, Iclass_AE_PKSR24_args,
    2, Iclass_AE_PKSR24_stateArgs, 0, 0 },
  { 2, Iclass_AE_TRUNCA16P24S_L_args,
    1, Iclass_AE_TRUNCA16P24S_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_TRUNCA16P24S_H_args,
    1, Iclass_AE_TRUNCA16P24S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD32_args,
    1, Iclass_AE_ADD32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB32_args,
    1, Iclass_AE_SUB32_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADDSUB32_args,
    1, Iclass_AE_ADDSUB32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUBADD32_args,
    1, Iclass_AE_SUBADD32_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD16_args,
    1, Iclass_AE_ADD16_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB16_args,
    1, Iclass_AE_SUB16_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD32_HL_LH_args,
    1, Iclass_AE_ADD32_HL_LH_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG32_args,
    1, Iclass_AE_NEG32_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS32_args,
    1, Iclass_AE_ABS32_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD24S_args,
    2, Iclass_AE_ADD24S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB24S_args,
    2, Iclass_AE_SUB24S_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD32S_args,
    2, Iclass_AE_ADD32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB32S_args,
    2, Iclass_AE_SUB32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADDSUB32S_args,
    2, Iclass_AE_ADDSUB32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUBADD32S_args,
    2, Iclass_AE_SUBADD32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD16S_args,
    2, Iclass_AE_ADD16S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB16S_args,
    2, Iclass_AE_SUB16S_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG24S_args,
    2, Iclass_AE_NEG24S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS24S_args,
    2, Iclass_AE_ABS24S_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG32S_args,
    1, Iclass_AE_NEG32S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS32S_args,
    1, Iclass_AE_ABS32S_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG16S_args,
    1, Iclass_AE_NEG16S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS16S_args,
    1, Iclass_AE_ABS16S_stateArgs, 0, 0 },
  { 3, Iclass_AE_LT16_args,
    1, Iclass_AE_LT16_stateArgs, 0, 0 },
  { 3, Iclass_AE_LE16_args,
    1, Iclass_AE_LE16_stateArgs, 0, 0 },
  { 3, Iclass_AE_EQ16_args,
    1, Iclass_AE_EQ16_stateArgs, 0, 0 },
  { 3, Iclass_AE_LT32_args,
    1, Iclass_AE_LT32_stateArgs, 0, 0 },
  { 3, Iclass_AE_LE32_args,
    1, Iclass_AE_LE32_stateArgs, 0, 0 },
  { 3, Iclass_AE_EQ32_args,
    1, Iclass_AE_EQ32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MIN32_args,
    1, Iclass_AE_MIN32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MAX32_args,
    1, Iclass_AE_MAX32_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD64_args,
    1, Iclass_AE_ADD64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB64_args,
    1, Iclass_AE_SUB64_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG64_args,
    1, Iclass_AE_NEG64_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS64_args,
    1, Iclass_AE_ABS64_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADDSQ56S_args,
    2, Iclass_AE_ADDSQ56S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUBSQ56S_args,
    2, Iclass_AE_SUBSQ56S_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD64S_args,
    2, Iclass_AE_ADD64S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB64S_args,
    2, Iclass_AE_SUB64S_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEGSQ56S_args,
    2, Iclass_AE_NEGSQ56S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABSSQ56S_args,
    2, Iclass_AE_ABSSQ56S_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG64S_args,
    2, Iclass_AE_NEG64S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS64S_args,
    2, Iclass_AE_ABS64S_stateArgs, 0, 0 },
  { 3, Iclass_AE_AND_args,
    1, Iclass_AE_AND_stateArgs, 0, 0 },
  { 3, Iclass_AE_NAND_args,
    1, Iclass_AE_NAND_stateArgs, 0, 0 },
  { 3, Iclass_AE_OR_args,
    1, Iclass_AE_OR_stateArgs, 0, 0 },
  { 3, Iclass_AE_XOR_args,
    1, Iclass_AE_XOR_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI24_args,
    1, Iclass_AE_SLAI24_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRLI24_args,
    1, Iclass_AE_SRLI24_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI24_args,
    1, Iclass_AE_SRAI24_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLAS24_args,
    2, Iclass_AE_SLAS24_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRLS24_args,
    2, Iclass_AE_SRLS24_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRAS24_args,
    2, Iclass_AE_SRAS24_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI16_args,
    1, Iclass_AE_SRAI16_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI16R_args,
    1, Iclass_AE_SRAI16R_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI32_args,
    1, Iclass_AE_SLAI32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRLI32_args,
    1, Iclass_AE_SRLI32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI32_args,
    1, Iclass_AE_SRAI32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI32R_args,
    1, Iclass_AE_SRAI32R_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLAS32_args,
    2, Iclass_AE_SLAS32_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRLS32_args,
    2, Iclass_AE_SRLS32_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRAS32_args,
    2, Iclass_AE_SRAS32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAA32_args,
    1, Iclass_AE_SLAA32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRLA32_args,
    1, Iclass_AE_SRLA32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA32_args,
    1, Iclass_AE_SRAA32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI16S_args,
    2, Iclass_AE_SLAI16S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAA16S_args,
    2, Iclass_AE_SLAA16S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA16S_args,
    2, Iclass_AE_SRAA16S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA16RS_args,
    2, Iclass_AE_SRAA16RS_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI24S_args,
    2, Iclass_AE_SLAI24S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLAS24S_args,
    3, Iclass_AE_SLAS24S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI32S_args,
    2, Iclass_AE_SLAI32S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLAS32S_args,
    3, Iclass_AE_SLAS32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAA32S_args,
    2, Iclass_AE_SLAA32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA32S_args,
    2, Iclass_AE_SRAA32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA32RS_args,
    2, Iclass_AE_SRAA32RS_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLASQ56_args,
    2, Iclass_AE_SLASQ56_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRLSQ56_args,
    2, Iclass_AE_SRLSQ56_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRASQ56_args,
    2, Iclass_AE_SRASQ56_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAAQ56_args,
    1, Iclass_AE_SLAAQ56_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRLAQ56_args,
    1, Iclass_AE_SRLAQ56_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAAQ56_args,
    1, Iclass_AE_SRAAQ56_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI64_args,
    1, Iclass_AE_SLAI64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRLI64_args,
    1, Iclass_AE_SRLI64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI64_args,
    1, Iclass_AE_SRAI64_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLAS64_args,
    2, Iclass_AE_SLAS64_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRLS64_args,
    2, Iclass_AE_SRLS64_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRAS64_args,
    2, Iclass_AE_SRAS64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAA64_args,
    1, Iclass_AE_SLAA64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRLA64_args,
    1, Iclass_AE_SRLA64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA64_args,
    1, Iclass_AE_SRAA64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAISQ56S_args,
    2, Iclass_AE_SLAISQ56S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLASSQ56S_args,
    3, Iclass_AE_SLASSQ56S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAASQ56S_args,
    2, Iclass_AE_SLAASQ56S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI64S_args,
    2, Iclass_AE_SLAI64S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLAS64S_args,
    3, Iclass_AE_SLAS64S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAA64S_args,
    2, Iclass_AE_SLAA64S_stateArgs, 0, 0 },
  { 3, Iclass_AE_LT64_args,
    1, Iclass_AE_LT64_stateArgs, 0, 0 },
  { 3, Iclass_AE_LE64_args,
    1, Iclass_AE_LE64_stateArgs, 0, 0 },
  { 3, Iclass_AE_EQ64_args,
    1, Iclass_AE_EQ64_stateArgs, 0, 0 },
  { 3, Iclass_AE_MAX64_args,
    1, Iclass_AE_MAX64_stateArgs, 0, 0 },
  { 3, Iclass_AE_MIN64_args,
    1, Iclass_AE_MIN64_stateArgs, 0, 0 },
  { 2, Iclass_AE_NSA64_args,
    1, Iclass_AE_NSA64_stateArgs, 0, 0 },
  { 2, Iclass_AE_NSAZ16_0_args,
    1, Iclass_AE_NSAZ16_0_stateArgs, 0, 0 },
  { 2, Iclass_AE_NSAZ32_L_args,
    1, Iclass_AE_NSAZ32_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32F48P16S_LL_args,
    2, Iclass_AE_MULS32F48P16S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32S_LL_args,
    2, Iclass_AE_MULF32S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32_LL_args,
    1, Iclass_AE_MUL32_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32F48P16S_LL_S2_args,
    2, Iclass_AE_MULS32F48P16S_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32R_LL_args,
    1, Iclass_AE_MULF32R_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32F48P16S_LH_args,
    2, Iclass_AE_MULS32F48P16S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32S_LH_args,
    2, Iclass_AE_MULF32S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32_LH_args,
    1, Iclass_AE_MUL32_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32F48P16S_LH_S2_args,
    2, Iclass_AE_MULS32F48P16S_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32R_LH_args,
    1, Iclass_AE_MULF32R_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32F48P16S_HH_args,
    2, Iclass_AE_MULS32F48P16S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32S_HH_args,
    2, Iclass_AE_MULF32S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32_HH_args,
    1, Iclass_AE_MUL32_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32F48P16S_HH_S2_args,
    2, Iclass_AE_MULS32F48P16S_HH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32R_HH_args,
    1, Iclass_AE_MULF32R_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32R_LL_S2_args,
    1, Iclass_AE_MULF32R_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAS32F48P16S_LL_args,
    2, Iclass_AE_MULAS32F48P16S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32S_LL_args,
    2, Iclass_AE_MULAF32S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32_LL_args,
    1, Iclass_AE_MULA32_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAS32F48P16S_LL_S2_args,
    2, Iclass_AE_MULAS32F48P16S_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32R_LL_args,
    1, Iclass_AE_MULAF32R_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAS32F48P16S_LH_args,
    2, Iclass_AE_MULAS32F48P16S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32S_LH_args,
    2, Iclass_AE_MULAF32S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32_LH_args,
    1, Iclass_AE_MULA32_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAS32F48P16S_LH_S2_args,
    2, Iclass_AE_MULAS32F48P16S_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32R_LH_args,
    1, Iclass_AE_MULAF32R_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAS32F48P16S_HH_args,
    2, Iclass_AE_MULAS32F48P16S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32S_HH_args,
    2, Iclass_AE_MULAF32S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32_HH_args,
    1, Iclass_AE_MULA32_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAS32F48P16S_HH_S2_args,
    2, Iclass_AE_MULAS32F48P16S_HH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32R_HH_args,
    1, Iclass_AE_MULAF32R_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32R_LL_S2_args,
    1, Iclass_AE_MULAF32R_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSS32F48P16S_LL_args,
    2, Iclass_AE_MULSS32F48P16S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32S_LL_args,
    2, Iclass_AE_MULSF32S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32_LL_args,
    1, Iclass_AE_MULS32_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSS32F48P16S_LL_S2_args,
    2, Iclass_AE_MULSS32F48P16S_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32R_LL_args,
    1, Iclass_AE_MULSF32R_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSS32F48P16S_LH_args,
    2, Iclass_AE_MULSS32F48P16S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32S_LH_args,
    2, Iclass_AE_MULSF32S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32_LH_args,
    1, Iclass_AE_MULS32_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSS32F48P16S_LH_S2_args,
    2, Iclass_AE_MULSS32F48P16S_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32R_LH_args,
    1, Iclass_AE_MULSF32R_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSS32F48P16S_HH_args,
    2, Iclass_AE_MULSS32F48P16S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32S_HH_args,
    2, Iclass_AE_MULSF32S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32_HH_args,
    1, Iclass_AE_MULS32_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSS32F48P16S_HH_S2_args,
    2, Iclass_AE_MULSS32F48P16S_HH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32R_HH_args,
    1, Iclass_AE_MULSF32R_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32R_LL_S2_args,
    1, Iclass_AE_MULSF32R_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32S_LL_S2_args,
    2, Iclass_AE_MULF32S_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32S_LL_S2_args,
    2, Iclass_AE_MULAF32S_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32_LL_S2_args,
    1, Iclass_AE_MUL32_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32_LL_S2_args,
    1, Iclass_AE_MULA32_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32U_LL_args,
    1, Iclass_AE_MUL32U_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32U_LL_args,
    1, Iclass_AE_MULA32U_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32U_LL_args,
    1, Iclass_AE_MULS32U_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_33_args,
    2, Iclass_AE_MULF16SS_33_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_22_args,
    2, Iclass_AE_MULF16SS_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_32_args,
    2, Iclass_AE_MULF16SS_32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_21_args,
    2, Iclass_AE_MULF16SS_21_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_31_args,
    2, Iclass_AE_MULF16SS_31_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_30_args,
    2, Iclass_AE_MULF16SS_30_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_10_args,
    2, Iclass_AE_MULF16SS_10_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_20_args,
    2, Iclass_AE_MULF16SS_20_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_11_args,
    2, Iclass_AE_MULF16SS_11_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_00_args,
    2, Iclass_AE_MULF16SS_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_00_S2_args,
    2, Iclass_AE_MULF16SS_00_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_33_args,
    2, Iclass_AE_MULSF16SS_33_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_22_args,
    2, Iclass_AE_MULSF16SS_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_32_args,
    2, Iclass_AE_MULSF16SS_32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_21_args,
    2, Iclass_AE_MULSF16SS_21_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_31_args,
    2, Iclass_AE_MULSF16SS_31_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_30_args,
    2, Iclass_AE_MULSF16SS_30_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_10_args,
    2, Iclass_AE_MULSF16SS_10_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_20_args,
    2, Iclass_AE_MULSF16SS_20_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_11_args,
    2, Iclass_AE_MULSF16SS_11_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_00_args,
    2, Iclass_AE_MULSF16SS_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_00_S2_args,
    2, Iclass_AE_MULSF16SS_00_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_33_args,
    2, Iclass_AE_MULAF16SS_33_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_22_args,
    2, Iclass_AE_MULAF16SS_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_32_args,
    2, Iclass_AE_MULAF16SS_32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_21_args,
    2, Iclass_AE_MULAF16SS_21_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_31_args,
    2, Iclass_AE_MULAF16SS_31_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_30_args,
    2, Iclass_AE_MULAF16SS_30_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_10_args,
    2, Iclass_AE_MULAF16SS_10_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_20_args,
    2, Iclass_AE_MULAF16SS_20_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_11_args,
    2, Iclass_AE_MULAF16SS_11_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_00_args,
    2, Iclass_AE_MULAF16SS_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_00_S2_args,
    2, Iclass_AE_MULAF16SS_00_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD16SS_33_22_args,
    2, Iclass_AE_MULAAFD16SS_33_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD16SS_33_22_S2_args,
    2, Iclass_AE_MULAAFD16SS_33_22_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD16SS_13_02_args,
    2, Iclass_AE_MULAAFD16SS_13_02_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD16SS_13_02_S2_args,
    2, Iclass_AE_MULAAFD16SS_13_02_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD16SS_11_00_args,
    2, Iclass_AE_MULAAFD16SS_11_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD16SS_11_00_S2_args,
    2, Iclass_AE_MULAAFD16SS_11_00_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD16SS_33_22_args,
    2, Iclass_AE_MULSSFD16SS_33_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD16SS_33_22_S2_args,
    2, Iclass_AE_MULSSFD16SS_33_22_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD16SS_13_02_args,
    2, Iclass_AE_MULSSFD16SS_13_02_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD16SS_13_02_S2_args,
    2, Iclass_AE_MULSSFD16SS_13_02_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD16SS_11_00_args,
    2, Iclass_AE_MULSSFD16SS_11_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD16SS_11_00_S2_args,
    2, Iclass_AE_MULSSFD16SS_11_00_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD16SS_33_22_args,
    2, Iclass_AE_MULZAAFD16SS_33_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD16SS_33_22_S2_args,
    2, Iclass_AE_MULZAAFD16SS_33_22_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD16SS_13_02_args,
    2, Iclass_AE_MULZAAFD16SS_13_02_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD16SS_13_02_S2_args,
    2, Iclass_AE_MULZAAFD16SS_13_02_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD16SS_11_00_args,
    2, Iclass_AE_MULZAAFD16SS_11_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD16SS_11_00_S2_args,
    2, Iclass_AE_MULZAAFD16SS_11_00_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD16SS_33_22_args,
    2, Iclass_AE_MULZSSFD16SS_33_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD16SS_33_22_S2_args,
    2, Iclass_AE_MULZSSFD16SS_33_22_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD16SS_13_02_args,
    2, Iclass_AE_MULZSSFD16SS_13_02_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD16SS_13_02_S2_args,
    2, Iclass_AE_MULZSSFD16SS_13_02_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD16SS_11_00_args,
    2, Iclass_AE_MULZSSFD16SS_11_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD16SS_11_00_S2_args,
    2, Iclass_AE_MULZSSFD16SS_11_00_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF48Q32SP16S_L_args,
    1, Iclass_AE_MULF48Q32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF48Q32SP16S_L_S2_args,
    1, Iclass_AE_MULF48Q32SP16S_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF48Q32SP16U_L_args,
    1, Iclass_AE_MULF48Q32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF48Q32SP16U_L_S2_args,
    1, Iclass_AE_MULF48Q32SP16U_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULQ32SP16S_L_args,
    1, Iclass_AE_MULQ32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULQ32SP16S_L_S2_args,
    1, Iclass_AE_MULQ32SP16S_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULQ32SP16U_L_args,
    1, Iclass_AE_MULQ32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULQ32SP16U_L_S2_args,
    1, Iclass_AE_MULQ32SP16U_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF48Q32SP16S_L_args,
    1, Iclass_AE_MULAF48Q32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF48Q32SP16S_L_S2_args,
    1, Iclass_AE_MULAF48Q32SP16S_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF48Q32SP16U_L_args,
    1, Iclass_AE_MULAF48Q32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF48Q32SP16U_L_S2_args,
    1, Iclass_AE_MULAF48Q32SP16U_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAQ32SP16S_L_args,
    1, Iclass_AE_MULAQ32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAQ32SP16S_L_S2_args,
    1, Iclass_AE_MULAQ32SP16S_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAQ32SP16U_L_args,
    1, Iclass_AE_MULAQ32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAQ32SP16U_L_S2_args,
    1, Iclass_AE_MULAQ32SP16U_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF48Q32SP16S_L_args,
    1, Iclass_AE_MULSF48Q32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF48Q32SP16S_L_S2_args,
    1, Iclass_AE_MULSF48Q32SP16S_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF48Q32SP16U_L_args,
    1, Iclass_AE_MULSF48Q32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF48Q32SP16U_L_S2_args,
    1, Iclass_AE_MULSF48Q32SP16U_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSQ32SP16S_L_args,
    1, Iclass_AE_MULSQ32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSQ32SP16S_L_S2_args,
    1, Iclass_AE_MULSQ32SP16S_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSQ32SP16U_L_args,
    1, Iclass_AE_MULSQ32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSQ32SP16U_L_S2_args,
    1, Iclass_AE_MULSQ32SP16U_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP24X2RA_args,
    1, Iclass_AE_MULFP24X2RA_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP24X2R_args,
    1, Iclass_AE_MULFP24X2R_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULP24X2_args,
    1, Iclass_AE_MULP24X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP24X2RA_S2_args,
    1, Iclass_AE_MULFP24X2RA_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP24X2R_S2_args,
    1, Iclass_AE_MULFP24X2R_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULP24X2_S2_args,
    1, Iclass_AE_MULP24X2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP24X2RA_args,
    1, Iclass_AE_MULAFP24X2RA_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP24X2R_args,
    1, Iclass_AE_MULAFP24X2R_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAP24X2_args,
    1, Iclass_AE_MULAP24X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP24X2RA_S2_args,
    1, Iclass_AE_MULAFP24X2RA_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP24X2R_S2_args,
    1, Iclass_AE_MULAFP24X2R_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAP24X2_S2_args,
    1, Iclass_AE_MULAP24X2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP24X2RA_args,
    1, Iclass_AE_MULSFP24X2RA_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP24X2R_args,
    1, Iclass_AE_MULSFP24X2R_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSP24X2_args,
    1, Iclass_AE_MULSP24X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP24X2RA_S2_args,
    1, Iclass_AE_MULSFP24X2RA_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP24X2R_S2_args,
    1, Iclass_AE_MULSFP24X2R_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSP24X2_S2_args,
    1, Iclass_AE_MULSP24X2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD24_HH_LL_args,
    1, Iclass_AE_MULZAAFD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD24_HH_LL_args,
    1, Iclass_AE_MULZAAD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD24_HH_LL_S2_args,
    1, Iclass_AE_MULZAAFD24_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD24_HH_LL_S2_args,
    1, Iclass_AE_MULZAAD24_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD24_HL_LH_args,
    1, Iclass_AE_MULZAAFD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD24_HL_LH_args,
    1, Iclass_AE_MULZAAD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD24_HL_LH_S2_args,
    1, Iclass_AE_MULZAAFD24_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD24_HL_LH_S2_args,
    1, Iclass_AE_MULZAAD24_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD24_HH_LL_args,
    1, Iclass_AE_MULZASFD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASD24_HH_LL_args,
    1, Iclass_AE_MULZASD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD24_HH_LL_S2_args,
    1, Iclass_AE_MULZASFD24_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASD24_HH_LL_S2_args,
    1, Iclass_AE_MULZASD24_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD24_HL_LH_args,
    1, Iclass_AE_MULZASFD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASD24_HL_LH_args,
    1, Iclass_AE_MULZASD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD24_HL_LH_S2_args,
    1, Iclass_AE_MULZASFD24_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASD24_HL_LH_S2_args,
    1, Iclass_AE_MULZASD24_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAFD24_HH_LL_args,
    1, Iclass_AE_MULZSAFD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAD24_HH_LL_args,
    1, Iclass_AE_MULZSAD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAFD24_HH_LL_S2_args,
    1, Iclass_AE_MULZSAFD24_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAD24_HH_LL_S2_args,
    1, Iclass_AE_MULZSAD24_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD24_HH_LL_args,
    1, Iclass_AE_MULZSSFD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSD24_HH_LL_args,
    1, Iclass_AE_MULZSSD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD24_HH_LL_S2_args,
    1, Iclass_AE_MULZSSFD24_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSD24_HH_LL_S2_args,
    1, Iclass_AE_MULZSSD24_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD24_HL_LH_args,
    1, Iclass_AE_MULZSSFD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSD24_HL_LH_args,
    1, Iclass_AE_MULZSSD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD24_HL_LH_S2_args,
    1, Iclass_AE_MULZSSFD24_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSD24_HL_LH_S2_args,
    1, Iclass_AE_MULZSSD24_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD24_HH_LL_args,
    1, Iclass_AE_MULAAFD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD24_HH_LL_args,
    1, Iclass_AE_MULAAD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD24_HH_LL_S2_args,
    1, Iclass_AE_MULAAFD24_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD24_HH_LL_S2_args,
    1, Iclass_AE_MULAAD24_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD24_HL_LH_args,
    1, Iclass_AE_MULAAFD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD24_HL_LH_args,
    1, Iclass_AE_MULAAD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD24_HL_LH_S2_args,
    1, Iclass_AE_MULAAFD24_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD24_HL_LH_S2_args,
    1, Iclass_AE_MULAAD24_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD24_HH_LL_args,
    1, Iclass_AE_MULASFD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASD24_HH_LL_args,
    1, Iclass_AE_MULASD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD24_HH_LL_S2_args,
    1, Iclass_AE_MULASFD24_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASD24_HH_LL_S2_args,
    1, Iclass_AE_MULASD24_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD24_HL_LH_args,
    1, Iclass_AE_MULASFD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASD24_HL_LH_args,
    1, Iclass_AE_MULASD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD24_HL_LH_S2_args,
    1, Iclass_AE_MULASFD24_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASD24_HL_LH_S2_args,
    1, Iclass_AE_MULASD24_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAFD24_HH_LL_args,
    1, Iclass_AE_MULSAFD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAD24_HH_LL_args,
    1, Iclass_AE_MULSAD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAFD24_HH_LL_S2_args,
    1, Iclass_AE_MULSAFD24_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAD24_HH_LL_S2_args,
    1, Iclass_AE_MULSAD24_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD24_HH_LL_args,
    1, Iclass_AE_MULSSFD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSD24_HH_LL_args,
    1, Iclass_AE_MULSSD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD24_HH_LL_S2_args,
    1, Iclass_AE_MULSSFD24_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSD24_HH_LL_S2_args,
    1, Iclass_AE_MULSSD24_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD24_HL_LH_args,
    1, Iclass_AE_MULSSFD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSD24_HL_LH_args,
    1, Iclass_AE_MULSSD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD24_HL_LH_S2_args,
    1, Iclass_AE_MULSSFD24_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSD24_HL_LH_S2_args,
    1, Iclass_AE_MULSSD24_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSRFQ32SP24S_H_args,
    1, Iclass_AE_MULSRFQ32SP24S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSRFQ32SP24S_L_args,
    1, Iclass_AE_MULSRFQ32SP24S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSRFQ32SP24S_H_S2_args,
    1, Iclass_AE_MULSRFQ32SP24S_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSRFQ32SP24S_L_S2_args,
    1, Iclass_AE_MULSRFQ32SP24S_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULARFQ32SP24S_H_args,
    1, Iclass_AE_MULARFQ32SP24S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULARFQ32SP24S_L_args,
    1, Iclass_AE_MULARFQ32SP24S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULARFQ32SP24S_H_S2_args,
    1, Iclass_AE_MULARFQ32SP24S_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULARFQ32SP24S_L_S2_args,
    1, Iclass_AE_MULARFQ32SP24S_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULRFQ32SP24S_H_args,
    1, Iclass_AE_MULRFQ32SP24S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULRFQ32SP24S_L_args,
    1, Iclass_AE_MULRFQ32SP24S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULRFQ32SP24S_H_S2_args,
    1, Iclass_AE_MULRFQ32SP24S_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULRFQ32SP24S_L_S2_args,
    1, Iclass_AE_MULRFQ32SP24S_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFQ32SP24S_H_args,
    1, Iclass_AE_MULSFQ32SP24S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFQ32SP24S_L_args,
    1, Iclass_AE_MULSFQ32SP24S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFQ32SP24S_H_S2_args,
    1, Iclass_AE_MULSFQ32SP24S_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFQ32SP24S_L_S2_args,
    1, Iclass_AE_MULSFQ32SP24S_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFQ32SP24S_H_args,
    1, Iclass_AE_MULAFQ32SP24S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFQ32SP24S_L_args,
    1, Iclass_AE_MULAFQ32SP24S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFQ32SP24S_H_S2_args,
    1, Iclass_AE_MULAFQ32SP24S_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFQ32SP24S_L_S2_args,
    1, Iclass_AE_MULAFQ32SP24S_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFQ32SP24S_H_args,
    1, Iclass_AE_MULFQ32SP24S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFQ32SP24S_L_args,
    1, Iclass_AE_MULFQ32SP24S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFQ32SP24S_H_S2_args,
    1, Iclass_AE_MULFQ32SP24S_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFQ32SP24S_L_S2_args,
    1, Iclass_AE_MULFQ32SP24S_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L0_args,
    1, Iclass_AE_MULF32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L0_args,
    1, Iclass_AE_MUL32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L0_S2_args,
    1, Iclass_AE_MULF32X16_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L0_S2_args,
    1, Iclass_AE_MUL32X16_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L1_args,
    1, Iclass_AE_MULF32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L1_args,
    1, Iclass_AE_MUL32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L1_S2_args,
    1, Iclass_AE_MULF32X16_L1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L1_S2_args,
    1, Iclass_AE_MUL32X16_L1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L2_args,
    1, Iclass_AE_MULF32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L2_args,
    1, Iclass_AE_MUL32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L2_S2_args,
    1, Iclass_AE_MULF32X16_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L2_S2_args,
    1, Iclass_AE_MUL32X16_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L3_args,
    1, Iclass_AE_MULF32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L3_args,
    1, Iclass_AE_MUL32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L3_S2_args,
    1, Iclass_AE_MULF32X16_L3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L3_S2_args,
    1, Iclass_AE_MUL32X16_L3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H0_args,
    1, Iclass_AE_MULF32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H0_args,
    1, Iclass_AE_MUL32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H0_S2_args,
    1, Iclass_AE_MULF32X16_H0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H0_S2_args,
    1, Iclass_AE_MUL32X16_H0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H1_args,
    1, Iclass_AE_MULF32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H1_args,
    1, Iclass_AE_MUL32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H1_S2_args,
    1, Iclass_AE_MULF32X16_H1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H1_S2_args,
    1, Iclass_AE_MUL32X16_H1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H2_args,
    1, Iclass_AE_MULF32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H2_args,
    1, Iclass_AE_MUL32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H2_S2_args,
    1, Iclass_AE_MULF32X16_H2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H2_S2_args,
    1, Iclass_AE_MUL32X16_H2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H3_args,
    1, Iclass_AE_MULF32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H3_args,
    1, Iclass_AE_MUL32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H3_S2_args,
    1, Iclass_AE_MULF32X16_H3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H3_S2_args,
    1, Iclass_AE_MUL32X16_H3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L0_args,
    1, Iclass_AE_MULAF32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L0_args,
    1, Iclass_AE_MULA32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L0_S2_args,
    1, Iclass_AE_MULAF32X16_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L0_S2_args,
    1, Iclass_AE_MULA32X16_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L1_args,
    1, Iclass_AE_MULAF32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L1_args,
    1, Iclass_AE_MULA32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L1_S2_args,
    1, Iclass_AE_MULAF32X16_L1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L1_S2_args,
    1, Iclass_AE_MULA32X16_L1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L2_args,
    1, Iclass_AE_MULAF32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L2_args,
    1, Iclass_AE_MULA32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L2_S2_args,
    1, Iclass_AE_MULAF32X16_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L2_S2_args,
    1, Iclass_AE_MULA32X16_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L3_args,
    1, Iclass_AE_MULAF32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L3_args,
    1, Iclass_AE_MULA32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L3_S2_args,
    1, Iclass_AE_MULAF32X16_L3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L3_S2_args,
    1, Iclass_AE_MULA32X16_L3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H0_args,
    1, Iclass_AE_MULAF32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H0_args,
    1, Iclass_AE_MULA32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H0_S2_args,
    1, Iclass_AE_MULAF32X16_H0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H0_S2_args,
    1, Iclass_AE_MULA32X16_H0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H1_args,
    1, Iclass_AE_MULAF32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H1_args,
    1, Iclass_AE_MULA32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H1_S2_args,
    1, Iclass_AE_MULAF32X16_H1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H1_S2_args,
    1, Iclass_AE_MULA32X16_H1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H2_args,
    1, Iclass_AE_MULAF32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H2_args,
    1, Iclass_AE_MULA32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H2_S2_args,
    1, Iclass_AE_MULAF32X16_H2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H2_S2_args,
    1, Iclass_AE_MULA32X16_H2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H3_args,
    1, Iclass_AE_MULAF32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H3_args,
    1, Iclass_AE_MULA32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H3_S2_args,
    1, Iclass_AE_MULAF32X16_H3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H3_S2_args,
    1, Iclass_AE_MULA32X16_H3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L0_args,
    1, Iclass_AE_MULSF32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L0_args,
    1, Iclass_AE_MULS32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L0_S2_args,
    1, Iclass_AE_MULSF32X16_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L0_S2_args,
    1, Iclass_AE_MULS32X16_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L1_args,
    1, Iclass_AE_MULSF32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L1_args,
    1, Iclass_AE_MULS32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L1_S2_args,
    1, Iclass_AE_MULSF32X16_L1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L1_S2_args,
    1, Iclass_AE_MULS32X16_L1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L2_args,
    1, Iclass_AE_MULSF32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L2_args,
    1, Iclass_AE_MULS32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L2_S2_args,
    1, Iclass_AE_MULSF32X16_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L2_S2_args,
    1, Iclass_AE_MULS32X16_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L3_args,
    1, Iclass_AE_MULSF32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L3_args,
    1, Iclass_AE_MULS32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L3_S2_args,
    1, Iclass_AE_MULSF32X16_L3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L3_S2_args,
    1, Iclass_AE_MULS32X16_L3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H0_args,
    1, Iclass_AE_MULSF32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H0_args,
    1, Iclass_AE_MULS32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H0_S2_args,
    1, Iclass_AE_MULSF32X16_H0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H0_S2_args,
    1, Iclass_AE_MULS32X16_H0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H1_args,
    1, Iclass_AE_MULSF32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H1_args,
    1, Iclass_AE_MULS32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H1_S2_args,
    1, Iclass_AE_MULSF32X16_H1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H1_S2_args,
    1, Iclass_AE_MULS32X16_H1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H2_args,
    1, Iclass_AE_MULSF32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H2_args,
    1, Iclass_AE_MULS32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H2_S2_args,
    1, Iclass_AE_MULSF32X16_H2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H2_S2_args,
    1, Iclass_AE_MULS32X16_H2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H3_args,
    1, Iclass_AE_MULSF32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H3_args,
    1, Iclass_AE_MULS32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H3_S2_args,
    1, Iclass_AE_MULSF32X16_H3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H3_S2_args,
    1, Iclass_AE_MULS32X16_H3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H3_L2_args,
    1, Iclass_AE_MULAAFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H3_L2_args,
    1, Iclass_AE_MULAAD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULAAFD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULAAD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H1_L0_args,
    1, Iclass_AE_MULAAFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H1_L0_args,
    1, Iclass_AE_MULAAD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULAAFD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULAAD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD32X16_H3_L2_args,
    1, Iclass_AE_MULASFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASD32X16_H3_L2_args,
    1, Iclass_AE_MULASD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULASFD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULASD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD32X16_H1_L0_args,
    1, Iclass_AE_MULASFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASD32X16_H1_L0_args,
    1, Iclass_AE_MULASD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULASFD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULASD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAFD32X16_H3_L2_args,
    1, Iclass_AE_MULSAFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAD32X16_H3_L2_args,
    1, Iclass_AE_MULSAD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAFD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULSAFD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULSAD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAFD32X16_H1_L0_args,
    1, Iclass_AE_MULSAFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAD32X16_H1_L0_args,
    1, Iclass_AE_MULSAD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAFD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULSAFD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULSAD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD32X16_H3_L2_args,
    1, Iclass_AE_MULSSFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSD32X16_H3_L2_args,
    1, Iclass_AE_MULSSD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULSSFD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULSSD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD32X16_H1_L0_args,
    1, Iclass_AE_MULSSFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSD32X16_H1_L0_args,
    1, Iclass_AE_MULSSD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULSSFD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULSSD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H3_L2_args,
    1, Iclass_AE_MULZAAFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H3_L2_args,
    1, Iclass_AE_MULZAAD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULZAAFD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULZAAD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H1_L0_args,
    1, Iclass_AE_MULZAAFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H1_L0_args,
    1, Iclass_AE_MULZAAD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULZAAFD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULZAAD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD32X16_H3_L2_args,
    1, Iclass_AE_MULZASFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASD32X16_H3_L2_args,
    1, Iclass_AE_MULZASD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULZASFD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULZASD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD32X16_H1_L0_args,
    1, Iclass_AE_MULZASFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASD32X16_H1_L0_args,
    1, Iclass_AE_MULZASD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULZASFD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULZASD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAFD32X16_H3_L2_args,
    1, Iclass_AE_MULZSAFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAD32X16_H3_L2_args,
    1, Iclass_AE_MULZSAD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAFD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULZSAFD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULZSAD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAFD32X16_H1_L0_args,
    1, Iclass_AE_MULZSAFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAD32X16_H1_L0_args,
    1, Iclass_AE_MULZSAD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAFD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULZSAFD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULZSAD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD32X16_H3_L2_args,
    1, Iclass_AE_MULZSSFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSD32X16_H3_L2_args,
    1, Iclass_AE_MULZSSD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULZSSFD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULZSSD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD32X16_H1_L0_args,
    1, Iclass_AE_MULZSSFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSD32X16_H1_L0_args,
    1, Iclass_AE_MULZSSD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULZSSFD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULZSSD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H2_L3_args,
    1, Iclass_AE_MULZAAFD32X16_H2_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H0_L1_args,
    1, Iclass_AE_MULZAAFD32X16_H0_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H2_L3_args,
    1, Iclass_AE_MULAAFD32X16_H2_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H0_L1_args,
    1, Iclass_AE_MULAAFD32X16_H0_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H2_L3_args,
    1, Iclass_AE_MULZAAD32X16_H2_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H0_L1_args,
    1, Iclass_AE_MULZAAD32X16_H0_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H2_L3_args,
    1, Iclass_AE_MULAAD32X16_H2_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H0_L1_args,
    1, Iclass_AE_MULAAD32X16_H0_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H2_L3_S2_args,
    1, Iclass_AE_MULZAAFD32X16_H2_L3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H0_L1_S2_args,
    1, Iclass_AE_MULZAAFD32X16_H0_L1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H2_L3_S2_args,
    1, Iclass_AE_MULAAFD32X16_H2_L3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H0_L1_S2_args,
    1, Iclass_AE_MULAAFD32X16_H0_L1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H2_L3_S2_args,
    1, Iclass_AE_MULZAAD32X16_H2_L3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H0_L1_S2_args,
    1, Iclass_AE_MULZAAD32X16_H0_L1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H2_L3_S2_args,
    1, Iclass_AE_MULAAD32X16_H2_L3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H0_L1_S2_args,
    1, Iclass_AE_MULAAD32X16_H0_L1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULP32X16X2_H_args,
    1, Iclass_AE_MULP32X16X2_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RS_H_args,
    2, Iclass_AE_MULFP32X16X2RS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RAS_H_args,
    2, Iclass_AE_MULFP32X16X2RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RS_H_S2_args,
    2, Iclass_AE_MULFP32X16X2RS_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RAS_H_S2_args,
    2, Iclass_AE_MULFP32X16X2RAS_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULP32X16X2_L_args,
    1, Iclass_AE_MULP32X16X2_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RS_L_args,
    2, Iclass_AE_MULFP32X16X2RS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RAS_L_args,
    2, Iclass_AE_MULFP32X16X2RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RS_L_S2_args,
    2, Iclass_AE_MULFP32X16X2RS_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RAS_L_S2_args,
    2, Iclass_AE_MULFP32X16X2RAS_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAP32X16X2_H_args,
    1, Iclass_AE_MULAP32X16X2_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RS_H_args,
    2, Iclass_AE_MULAFP32X16X2RS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RAS_H_args,
    2, Iclass_AE_MULAFP32X16X2RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RS_H_S2_args,
    2, Iclass_AE_MULAFP32X16X2RS_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RAS_H_S2_args,
    2, Iclass_AE_MULAFP32X16X2RAS_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAP32X16X2_L_args,
    1, Iclass_AE_MULAP32X16X2_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RS_L_args,
    2, Iclass_AE_MULAFP32X16X2RS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RAS_L_args,
    2, Iclass_AE_MULAFP32X16X2RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RS_L_S2_args,
    2, Iclass_AE_MULAFP32X16X2RS_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RAS_L_S2_args,
    2, Iclass_AE_MULAFP32X16X2RAS_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSP32X16X2_H_args,
    1, Iclass_AE_MULSP32X16X2_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RS_H_args,
    2, Iclass_AE_MULSFP32X16X2RS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RAS_H_args,
    2, Iclass_AE_MULSFP32X16X2RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RS_H_S2_args,
    2, Iclass_AE_MULSFP32X16X2RS_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RAS_H_S2_args,
    2, Iclass_AE_MULSFP32X16X2RAS_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSP32X16X2_L_args,
    1, Iclass_AE_MULSP32X16X2_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RS_L_args,
    2, Iclass_AE_MULSFP32X16X2RS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RAS_L_args,
    2, Iclass_AE_MULSFP32X16X2RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RS_L_S2_args,
    2, Iclass_AE_MULSFP32X16X2RS_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RAS_L_S2_args,
    2, Iclass_AE_MULSFP32X16X2RAS_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULP32X2_args,
    1, Iclass_AE_MULP32X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X2RS_args,
    2, Iclass_AE_MULFP32X2RS_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X2RAS_args,
    2, Iclass_AE_MULFP32X2RAS_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAP32X2_args,
    1, Iclass_AE_MULAP32X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X2RS_args,
    2, Iclass_AE_MULAFP32X2RS_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X2RAS_args,
    2, Iclass_AE_MULAFP32X2RAS_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSP32X2_args,
    1, Iclass_AE_MULSP32X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X2RS_args,
    2, Iclass_AE_MULSFP32X2RS_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X2RAS_args,
    2, Iclass_AE_MULSFP32X2RAS_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP16X4S_args,
    2, Iclass_AE_MULFP16X4S_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP16X4RAS_args,
    2, Iclass_AE_MULFP16X4RAS_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULC24_args,
    1, Iclass_AE_MULC24_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFC24RA_args,
    1, Iclass_AE_MULFC24RA_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULC32X16_L_args,
    1, Iclass_AE_MULC32X16_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFC32X16RAS_L_args,
    2, Iclass_AE_MULFC32X16RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULC32X16_H_args,
    1, Iclass_AE_MULC32X16_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFC32X16RAS_H_args,
    2, Iclass_AE_MULFC32X16RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAC24_args,
    1, Iclass_AE_MULAC24_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFC24RA_args,
    1, Iclass_AE_MULAFC24RA_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAC32X16_L_args,
    1, Iclass_AE_MULAC32X16_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFC32X16RAS_L_args,
    2, Iclass_AE_MULAFC32X16RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAC32X16_H_args,
    1, Iclass_AE_MULAC32X16_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFC32X16RAS_H_args,
    2, Iclass_AE_MULAFC32X16RAS_H_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULF16X4SS_args,
    2, Iclass_AE_MULF16X4SS_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULAF16X4SS_args,
    2, Iclass_AE_MULAF16X4SS_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULSF16X4SS_args,
    2, Iclass_AE_MULSF16X4SS_stateArgs, 0, 0 },
  { 4, Iclass_AE_MUL16X4_args,
    1, Iclass_AE_MUL16X4_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULA16X4_args,
    1, Iclass_AE_MULA16X4_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULS16X4_args,
    1, Iclass_AE_MULS16X4_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULFD24X2_FIR_H_args,
    1, Iclass_AE_MULFD24X2_FIR_H_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULFD24X2_FIR_L_args,
    1, Iclass_AE_MULFD24X2_FIR_L_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULFD32X16X2_FIR_HH_args,
    1, Iclass_AE_MULFD32X16X2_FIR_HH_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULFD32X16X2_FIR_HL_args,
    1, Iclass_AE_MULFD32X16X2_FIR_HL_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULFD32X16X2_FIR_LH_args,
    1, Iclass_AE_MULFD32X16X2_FIR_LH_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULFD32X16X2_FIR_LL_args,
    1, Iclass_AE_MULFD32X16X2_FIR_LL_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULAFD24X2_FIR_H_args,
    1, Iclass_AE_MULAFD24X2_FIR_H_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULAFD24X2_FIR_L_args,
    1, Iclass_AE_MULAFD24X2_FIR_L_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULAFD32X16X2_FIR_HH_args,
    1, Iclass_AE_MULAFD32X16X2_FIR_HH_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULAFD32X16X2_FIR_HL_args,
    1, Iclass_AE_MULAFD32X16X2_FIR_HL_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULAFD32X16X2_FIR_LH_args,
    1, Iclass_AE_MULAFD32X16X2_FIR_LH_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULAFD32X16X2_FIR_LL_args,
    1, Iclass_AE_MULAFD32X16X2_FIR_LL_stateArgs, 0, 0 },
  { 2, Iclass_AE_DIV64D32_H_args,
    1, Iclass_AE_DIV64D32_H_stateArgs, 0, 0 },
  { 2, Iclass_AE_DIV64D32_L_args,
    1, Iclass_AE_DIV64D32_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_SHA32_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_VLDL32T_args,
    5, Iclass_AE_VLDL32T_stateArgs, 0, 0 },
  { 3, Iclass_AE_VLDL16T_args,
    5, Iclass_AE_VLDL16T_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLDL16C_args,
    8, Iclass_AE_VLDL16C_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLDL16C_IP_args,
    8, Iclass_AE_VLDL16C_IP_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLDL16C_IC_args,
    11, Iclass_AE_VLDL16C_IC_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLDSHT_args,
    6, Iclass_AE_VLDSHT_stateArgs, 0, 0 },
  { 2, Iclass_AE_LB_args,
    3, Iclass_AE_LB_stateArgs, 0, 0 },
  { 2, Iclass_AE_LBI_args,
    3, Iclass_AE_LBI_stateArgs, 0, 0 },
  { 3, Iclass_AE_LBK_args,
    3, Iclass_AE_LBK_stateArgs, 0, 0 },
  { 3, Iclass_AE_LBKI_args,
    3, Iclass_AE_LBKI_stateArgs, 0, 0 },
  { 2, Iclass_AE_LBS_args,
    3, Iclass_AE_LBS_stateArgs, 0, 0 },
  { 2, Iclass_AE_LBSI_args,
    3, Iclass_AE_LBSI_stateArgs, 0, 0 },
  { 2, Iclass_AE_DB_args,
    3, Iclass_AE_DB_stateArgs, 0, 0 },
  { 2, Iclass_AE_DBI_args,
    3, Iclass_AE_DBI_stateArgs, 0, 0 },
  { 2, Iclass_AE_DB_IC_args,
    6, Iclass_AE_DB_IC_stateArgs, 0, 0 },
  { 2, Iclass_AE_DBI_IC_args,
    6, Iclass_AE_DBI_IC_stateArgs, 0, 0 },
  { 2, Iclass_AE_DB_IP_args,
    3, Iclass_AE_DB_IP_stateArgs, 0, 0 },
  { 2, Iclass_AE_DBI_IP_args,
    3, Iclass_AE_DBI_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_VLEL32T_args,
    3, Iclass_AE_VLEL32T_stateArgs, 0, 0 },
  { 3, Iclass_AE_VLEL16T_args,
    3, Iclass_AE_VLEL16T_stateArgs, 0, 0 },
  { 2, Iclass_AE_SB_args,
    4, Iclass_AE_SB_stateArgs, 0, 0 },
  { 3, Iclass_AE_SBI_args,
    3, Iclass_AE_SBI_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLES16C_args,
    5, Iclass_AE_VLES16C_stateArgs, 0, 0 },
  { 1, Iclass_AE_SBF_args,
    3, Iclass_AE_SBF_stateArgs, 0, 0 },
  { 2, Iclass_AE_SB_IC_args,
    7, Iclass_AE_SB_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SBI_IC_args,
    6, Iclass_AE_SBI_IC_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLES16C_IC_args,
    8, Iclass_AE_VLES16C_IC_stateArgs, 0, 0 },
  { 1, Iclass_AE_SBF_IC_args,
    6, Iclass_AE_SBF_IC_stateArgs, 0, 0 },
  { 2, Iclass_AE_SB_IP_args,
    4, Iclass_AE_SB_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SBI_IP_args,
    3, Iclass_AE_SBI_IP_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLES16C_IP_args,
    5, Iclass_AE_VLES16C_IP_stateArgs, 0, 0 },
  { 1, Iclass_AE_SBF_IP_args,
    3, Iclass_AE_SBF_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SEXT32_args,
    1, Iclass_AE_SEXT32_stateArgs, 0, 0 },
  { 3, Iclass_LSI_args,
    1, Iclass_LSI_stateArgs, 0, 0 },
  { 3, Iclass_LSIP_args,
    1, Iclass_LSIP_stateArgs, 0, 0 },
  { 3, Iclass_LSX_args,
    1, Iclass_LSX_stateArgs, 0, 0 },
  { 3, Iclass_LSXP_args,
    1, Iclass_LSXP_stateArgs, 0, 0 },
  { 3, Iclass_SSI_args,
    1, Iclass_SSI_stateArgs, 0, 0 },
  { 3, Iclass_SSIP_args,
    1, Iclass_SSIP_stateArgs, 0, 0 },
  { 3, Iclass_SSX_args,
    1, Iclass_SSX_stateArgs, 0, 0 },
  { 3, Iclass_SSXP_args,
    1, Iclass_SSXP_stateArgs, 0, 0 },
  { 2, Iclass_ABS_S_args,
    1, Iclass_ABS_S_stateArgs, 0, 0 },
  { 2, Iclass_NEG_S_args,
    1, Iclass_NEG_S_stateArgs, 0, 0 },
  { 2, Iclass_MOV_S_args,
    1, Iclass_MOV_S_stateArgs, 0, 0 },
  { 3, Iclass_MOVEQZ_S_args,
    1, Iclass_MOVEQZ_S_stateArgs, 0, 0 },
  { 3, Iclass_MOVNEZ_S_args,
    1, Iclass_MOVNEZ_S_stateArgs, 0, 0 },
  { 3, Iclass_MOVLTZ_S_args,
    1, Iclass_MOVLTZ_S_stateArgs, 0, 0 },
  { 3, Iclass_MOVGEZ_S_args,
    1, Iclass_MOVGEZ_S_stateArgs, 0, 0 },
  { 3, Iclass_MOVF_S_args,
    1, Iclass_MOVF_S_stateArgs, 0, 0 },
  { 3, Iclass_MOVT_S_args,
    1, Iclass_MOVT_S_stateArgs, 0, 0 },
  { 2, Iclass_WFR_args,
    1, Iclass_WFR_stateArgs, 0, 0 },
  { 2, Iclass_RFR_args,
    1, Iclass_RFR_stateArgs, 0, 0 },
  { 3, Iclass_ROUND_S_args,
    3, Iclass_ROUND_S_stateArgs, 0, 0 },
  { 3, Iclass_CEIL_S_args,
    3, Iclass_CEIL_S_stateArgs, 0, 0 },
  { 3, Iclass_FLOOR_S_args,
    3, Iclass_FLOOR_S_stateArgs, 0, 0 },
  { 3, Iclass_TRUNC_S_args,
    3, Iclass_TRUNC_S_stateArgs, 0, 0 },
  { 3, Iclass_UTRUNC_S_args,
    3, Iclass_UTRUNC_S_stateArgs, 0, 0 },
  { 3, Iclass_FLOAT_S_args,
    3, Iclass_FLOAT_S_stateArgs, 0, 0 },
  { 3, Iclass_UFLOAT_S_args,
    3, Iclass_UFLOAT_S_stateArgs, 0, 0 },
  { 3, Iclass_UN_S_args,
    2, Iclass_UN_S_stateArgs, 0, 0 },
  { 3, Iclass_ULT_S_args,
    2, Iclass_ULT_S_stateArgs, 0, 0 },
  { 3, Iclass_ULE_S_args,
    2, Iclass_ULE_S_stateArgs, 0, 0 },
  { 3, Iclass_UEQ_S_args,
    2, Iclass_UEQ_S_stateArgs, 0, 0 },
  { 3, Iclass_OLT_S_args,
    2, Iclass_OLT_S_stateArgs, 0, 0 },
  { 3, Iclass_OLE_S_args,
    2, Iclass_OLE_S_stateArgs, 0, 0 },
  { 3, Iclass_OEQ_S_args,
    2, Iclass_OEQ_S_stateArgs, 0, 0 },
  { 3, Iclass_ADD_S_args,
    6, Iclass_ADD_S_stateArgs, 0, 0 },
  { 3, Iclass_SUB_S_args,
    6, Iclass_SUB_S_stateArgs, 0, 0 },
  { 3, Iclass_MUL_S_args,
    6, Iclass_MUL_S_stateArgs, 0, 0 },
  { 3, Iclass_MADD_S_args,
    6, Iclass_MADD_S_stateArgs, 0, 0 },
  { 3, Iclass_MSUB_S_args,
    6, Iclass_MSUB_S_stateArgs, 0, 0 },
  { 2, Iclass_SQRT0_S_args,
    1, Iclass_SQRT0_S_stateArgs, 0, 0 },
  { 2, Iclass_DIV0_S_args,
    1, Iclass_DIV0_S_stateArgs, 0, 0 },
  { 2, Iclass_RECIP0_S_args,
    3, Iclass_RECIP0_S_stateArgs, 0, 0 },
  { 2, Iclass_RSQRT0_S_args,
    3, Iclass_RSQRT0_S_stateArgs, 0, 0 },
  { 3, Iclass_MADDN_S_args,
    1, Iclass_MADDN_S_stateArgs, 0, 0 },
  { 3, Iclass_DIVN_S_args,
    5, Iclass_DIVN_S_stateArgs, 0, 0 },
  { 2, Iclass_CONST_S_args,
    1, Iclass_CONST_S_stateArgs, 0, 0 },
  { 2, Iclass_NEXP01_S_args,
    1, Iclass_NEXP01_S_stateArgs, 0, 0 },
  { 2, Iclass_ADDEXP_S_args,
    1, Iclass_ADDEXP_S_stateArgs, 0, 0 },
  { 2, Iclass_ADDEXPM_S_args,
    1, Iclass_ADDEXPM_S_stateArgs, 0, 0 },
  { 2, Iclass_MKDADJ_S_args,
    3, Iclass_MKDADJ_S_stateArgs, 0, 0 },
  { 2, Iclass_MKSADJ_S_args,
    2, Iclass_MKSADJ_S_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_excw */,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_rfe */,
    2, Iclass_xt_iclass_rfe_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_rfde */,
    1, Iclass_xt_iclass_rfde_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_syscall */,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_call12_args,
    1, Iclass_xt_iclass_call12_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_call8_args,
    1, Iclass_xt_iclass_call8_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_call4_args,
    1, Iclass_xt_iclass_call4_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_callx12_args,
    1, Iclass_xt_iclass_callx12_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_callx8_args,
    1, Iclass_xt_iclass_callx8_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_callx4_args,
    1, Iclass_xt_iclass_callx4_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_entry_args,
    5, Iclass_xt_iclass_entry_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_movsp_args,
    2, Iclass_xt_iclass_movsp_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rotw_args,
    1, Iclass_xt_iclass_rotw_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_retw_args,
    5, Iclass_xt_iclass_retw_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_rfwou */,
    5, Iclass_xt_iclass_rfwou_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_l32e_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32e_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_windowbase_args,
    1, Iclass_xt_iclass_rsr_windowbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_windowbase_args,
    1, Iclass_xt_iclass_wsr_windowbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_windowbase_args,
    1, Iclass_xt_iclass_xsr_windowbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_windowstart_args,
    1, Iclass_xt_iclass_rsr_windowstart_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_windowstart_args,
    1, Iclass_xt_iclass_wsr_windowstart_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_windowstart_args,
    1, Iclass_xt_iclass_xsr_windowstart_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_rfme */,
    9, Iclass_xt_iclass_rfme_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_mesr_args,
    13, Iclass_xt_iclass_rsr_mesr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_mesr_args,
    13, Iclass_xt_iclass_wsr_mesr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_mesr_args,
    13, Iclass_xt_iclass_xsr_mesr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_mecr_args,
    1, Iclass_xt_iclass_rsr_mecr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_mecr_args,
    1, Iclass_xt_iclass_wsr_mecr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_mecr_args,
    1, Iclass_xt_iclass_xsr_mecr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_mepc_args,
    1, Iclass_xt_iclass_rsr_mepc_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_mepc_args,
    1, Iclass_xt_iclass_wsr_mepc_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_mepc_args,
    1, Iclass_xt_iclass_xsr_mepc_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_meps_args,
    1, Iclass_xt_iclass_rsr_meps_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_meps_args,
    1, Iclass_xt_iclass_wsr_meps_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_meps_args,
    1, Iclass_xt_iclass_xsr_meps_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_mesave_args,
    1, Iclass_xt_iclass_rsr_mesave_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_mesave_args,
    1, Iclass_xt_iclass_wsr_mesave_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_mesave_args,
    1, Iclass_xt_iclass_xsr_mesave_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_mevaddr_args,
    1, Iclass_xt_iclass_rsr_mevaddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_mevaddr_args,
    1, Iclass_xt_iclass_wsr_mevaddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_mevaddr_args,
    1, Iclass_xt_iclass_xsr_mevaddr_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_add_n_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_addi_n_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_bz6_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_ill_n */,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_loadi4_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_mov_n_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_movi_n_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_nopn */,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_retn_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_storei4_args,
    0, 0, 0, 0 },
  { 1, Iclass_rur_threadptr_args,
    1, Iclass_rur_threadptr_stateArgs, 0, 0 },
  { 1, Iclass_wur_threadptr_args,
    1, Iclass_wur_threadptr_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_addi_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_addmi_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_addsub_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bit_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bsi8_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bsi8b_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bsi8u_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bst8_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_bsz12_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_call0_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_callx0_args,
    0, 0, 0, 0 },
  { 4, Iclass_xt_iclass_exti_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_ill */,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_jump_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_jumpx_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l16ui_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l16si_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l32i_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_l32r_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l8i_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_loop_args,
    3, Iclass_xt_iclass_loop_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_loopz_args,
    3, Iclass_xt_iclass_loopz_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_movi_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_movz_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_neg_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_nop */,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_return_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_simcall */,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s16i_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32i_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32nb_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s8i_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_sar_args,
    1, Iclass_xt_iclass_sar_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_sari_args,
    1, Iclass_xt_iclass_sari_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_shifts_args,
    1, Iclass_xt_iclass_shifts_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_shiftst_args,
    1, Iclass_xt_iclass_shiftst_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_shiftt_args,
    1, Iclass_xt_iclass_shiftt_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_slli_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_srai_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_srli_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_memw */,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_extw */,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_isync */,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_sync */,
    1, Iclass_xt_iclass_sync_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_rsil_args,
    6, Iclass_xt_iclass_rsil_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_lend_args,
    1, Iclass_xt_iclass_rsr_lend_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_lend_args,
    1, Iclass_xt_iclass_wsr_lend_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_lend_args,
    1, Iclass_xt_iclass_xsr_lend_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_lcount_args,
    1, Iclass_xt_iclass_rsr_lcount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_lcount_args,
    2, Iclass_xt_iclass_wsr_lcount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_lcount_args,
    2, Iclass_xt_iclass_xsr_lcount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_lbeg_args,
    1, Iclass_xt_iclass_rsr_lbeg_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_lbeg_args,
    1, Iclass_xt_iclass_wsr_lbeg_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_lbeg_args,
    1, Iclass_xt_iclass_xsr_lbeg_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_sar_args,
    1, Iclass_xt_iclass_rsr_sar_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_sar_args,
    2, Iclass_xt_iclass_wsr_sar_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_sar_args,
    1, Iclass_xt_iclass_xsr_sar_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_memctl_args,
    1, Iclass_xt_iclass_rsr_memctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_memctl_args,
    1, Iclass_xt_iclass_wsr_memctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_memctl_args,
    1, Iclass_xt_iclass_xsr_memctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_litbase_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_litbase_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_litbase_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_configid0_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_configid0_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_configid1_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_243_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ps_args,
    6, Iclass_xt_iclass_rsr_ps_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ps_args,
    6, Iclass_xt_iclass_wsr_ps_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ps_args,
    6, Iclass_xt_iclass_xsr_ps_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc1_args,
    1, Iclass_xt_iclass_rsr_epc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc1_args,
    1, Iclass_xt_iclass_wsr_epc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc1_args,
    1, Iclass_xt_iclass_xsr_epc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave1_args,
    1, Iclass_xt_iclass_rsr_excsave1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave1_args,
    1, Iclass_xt_iclass_wsr_excsave1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave1_args,
    1, Iclass_xt_iclass_xsr_excsave1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc2_args,
    1, Iclass_xt_iclass_rsr_epc2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc2_args,
    1, Iclass_xt_iclass_wsr_epc2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc2_args,
    1, Iclass_xt_iclass_xsr_epc2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave2_args,
    1, Iclass_xt_iclass_rsr_excsave2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave2_args,
    1, Iclass_xt_iclass_wsr_excsave2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave2_args,
    1, Iclass_xt_iclass_xsr_excsave2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc3_args,
    1, Iclass_xt_iclass_rsr_epc3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc3_args,
    1, Iclass_xt_iclass_wsr_epc3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc3_args,
    1, Iclass_xt_iclass_xsr_epc3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave3_args,
    1, Iclass_xt_iclass_rsr_excsave3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave3_args,
    1, Iclass_xt_iclass_wsr_excsave3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave3_args,
    1, Iclass_xt_iclass_xsr_excsave3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc4_args,
    1, Iclass_xt_iclass_rsr_epc4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc4_args,
    1, Iclass_xt_iclass_wsr_epc4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc4_args,
    1, Iclass_xt_iclass_xsr_epc4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave4_args,
    1, Iclass_xt_iclass_rsr_excsave4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave4_args,
    1, Iclass_xt_iclass_wsr_excsave4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave4_args,
    1, Iclass_xt_iclass_xsr_excsave4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc5_args,
    1, Iclass_xt_iclass_rsr_epc5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc5_args,
    1, Iclass_xt_iclass_wsr_epc5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc5_args,
    1, Iclass_xt_iclass_xsr_epc5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave5_args,
    1, Iclass_xt_iclass_rsr_excsave5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave5_args,
    1, Iclass_xt_iclass_wsr_excsave5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave5_args,
    1, Iclass_xt_iclass_xsr_excsave5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc6_args,
    1, Iclass_xt_iclass_rsr_epc6_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc6_args,
    1, Iclass_xt_iclass_wsr_epc6_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc6_args,
    1, Iclass_xt_iclass_xsr_epc6_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave6_args,
    1, Iclass_xt_iclass_rsr_excsave6_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave6_args,
    1, Iclass_xt_iclass_wsr_excsave6_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave6_args,
    1, Iclass_xt_iclass_xsr_excsave6_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc7_args,
    1, Iclass_xt_iclass_rsr_epc7_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc7_args,
    1, Iclass_xt_iclass_wsr_epc7_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc7_args,
    1, Iclass_xt_iclass_xsr_epc7_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave7_args,
    1, Iclass_xt_iclass_rsr_excsave7_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave7_args,
    1, Iclass_xt_iclass_wsr_excsave7_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave7_args,
    1, Iclass_xt_iclass_xsr_excsave7_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps2_args,
    1, Iclass_xt_iclass_rsr_eps2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps2_args,
    1, Iclass_xt_iclass_wsr_eps2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps2_args,
    1, Iclass_xt_iclass_xsr_eps2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps3_args,
    1, Iclass_xt_iclass_rsr_eps3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps3_args,
    1, Iclass_xt_iclass_wsr_eps3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps3_args,
    1, Iclass_xt_iclass_xsr_eps3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps4_args,
    1, Iclass_xt_iclass_rsr_eps4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps4_args,
    1, Iclass_xt_iclass_wsr_eps4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps4_args,
    1, Iclass_xt_iclass_xsr_eps4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps5_args,
    1, Iclass_xt_iclass_rsr_eps5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps5_args,
    1, Iclass_xt_iclass_wsr_eps5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps5_args,
    1, Iclass_xt_iclass_xsr_eps5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps6_args,
    1, Iclass_xt_iclass_rsr_eps6_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps6_args,
    1, Iclass_xt_iclass_wsr_eps6_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps6_args,
    1, Iclass_xt_iclass_xsr_eps6_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps7_args,
    1, Iclass_xt_iclass_rsr_eps7_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps7_args,
    1, Iclass_xt_iclass_wsr_eps7_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps7_args,
    1, Iclass_xt_iclass_xsr_eps7_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excvaddr_args,
    1, Iclass_xt_iclass_rsr_excvaddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excvaddr_args,
    1, Iclass_xt_iclass_wsr_excvaddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excvaddr_args,
    1, Iclass_xt_iclass_xsr_excvaddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_depc_args,
    1, Iclass_xt_iclass_rsr_depc_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_depc_args,
    1, Iclass_xt_iclass_wsr_depc_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_depc_args,
    1, Iclass_xt_iclass_xsr_depc_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_exccause_args,
    2, Iclass_xt_iclass_rsr_exccause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_exccause_args,
    1, Iclass_xt_iclass_wsr_exccause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_exccause_args,
    1, Iclass_xt_iclass_xsr_exccause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_prid_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_vecbase_args,
    1, Iclass_xt_iclass_rsr_vecbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_vecbase_args,
    1, Iclass_xt_iclass_wsr_vecbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_vecbase_args,
    1, Iclass_xt_iclass_xsr_vecbase_stateArgs, 0, 0 },
  { 3, Iclass_xt_mul16_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_mul32_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_mul32h_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rfi_args,
    20, Iclass_xt_iclass_rfi_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wait_args,
    1, Iclass_xt_iclass_wait_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_interrupt_args,
    1, Iclass_xt_iclass_rsr_interrupt_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_intset_args,
    2, Iclass_xt_iclass_wsr_intset_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_intclear_args,
    2, Iclass_xt_iclass_wsr_intclear_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_intenable_args,
    1, Iclass_xt_iclass_rsr_intenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_intenable_args,
    1, Iclass_xt_iclass_wsr_intenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_intenable_args,
    1, Iclass_xt_iclass_xsr_intenable_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_break_args,
    2, Iclass_xt_iclass_break_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_break_n_args,
    2, Iclass_xt_iclass_break_n_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_dbreaka0_args,
    1, Iclass_xt_iclass_rsr_dbreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_dbreaka0_args,
    2, Iclass_xt_iclass_wsr_dbreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_dbreaka0_args,
    2, Iclass_xt_iclass_xsr_dbreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_dbreakc0_args,
    1, Iclass_xt_iclass_rsr_dbreakc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_dbreakc0_args,
    2, Iclass_xt_iclass_wsr_dbreakc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_dbreakc0_args,
    2, Iclass_xt_iclass_xsr_dbreakc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_dbreaka1_args,
    1, Iclass_xt_iclass_rsr_dbreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_dbreaka1_args,
    2, Iclass_xt_iclass_wsr_dbreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_dbreaka1_args,
    2, Iclass_xt_iclass_xsr_dbreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_dbreakc1_args,
    1, Iclass_xt_iclass_rsr_dbreakc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_dbreakc1_args,
    2, Iclass_xt_iclass_wsr_dbreakc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_dbreakc1_args,
    2, Iclass_xt_iclass_xsr_dbreakc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ibreaka0_args,
    1, Iclass_xt_iclass_rsr_ibreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ibreaka0_args,
    1, Iclass_xt_iclass_wsr_ibreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ibreaka0_args,
    1, Iclass_xt_iclass_xsr_ibreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ibreaka1_args,
    1, Iclass_xt_iclass_rsr_ibreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ibreaka1_args,
    1, Iclass_xt_iclass_wsr_ibreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ibreaka1_args,
    1, Iclass_xt_iclass_xsr_ibreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ibreakenable_args,
    1, Iclass_xt_iclass_rsr_ibreakenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ibreakenable_args,
    1, Iclass_xt_iclass_wsr_ibreakenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ibreakenable_args,
    1, Iclass_xt_iclass_xsr_ibreakenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_debugcause_args,
    2, Iclass_xt_iclass_rsr_debugcause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_debugcause_args,
    2, Iclass_xt_iclass_wsr_debugcause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_debugcause_args,
    2, Iclass_xt_iclass_xsr_debugcause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_icount_args,
    1, Iclass_xt_iclass_rsr_icount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_icount_args,
    2, Iclass_xt_iclass_wsr_icount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_icount_args,
    2, Iclass_xt_iclass_xsr_icount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_icountlevel_args,
    1, Iclass_xt_iclass_rsr_icountlevel_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_icountlevel_args,
    1, Iclass_xt_iclass_wsr_icountlevel_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_icountlevel_args,
    1, Iclass_xt_iclass_xsr_icountlevel_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ddr_args,
    1, Iclass_xt_iclass_rsr_ddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ddr_args,
    2, Iclass_xt_iclass_wsr_ddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ddr_args,
    2, Iclass_xt_iclass_xsr_ddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_lddr32_p_args,
    3, Iclass_xt_iclass_lddr32_p_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_sddr32_p_args,
    2, Iclass_xt_iclass_sddr32_p_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rfdo_args,
    9, Iclass_xt_iclass_rfdo_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_rfdd */,
    1, Iclass_xt_iclass_rfdd_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_mmid_args,
    1, Iclass_xt_iclass_wsr_mmid_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_bbool1_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_bbool4_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_bbool8_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_bbranch_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bmove_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_RSR_BR_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_WSR_BR_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_XSR_BR_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ccount_args,
    1, Iclass_xt_iclass_rsr_ccount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ccount_args,
    2, Iclass_xt_iclass_wsr_ccount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ccount_args,
    2, Iclass_xt_iclass_xsr_ccount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ccompare0_args,
    1, Iclass_xt_iclass_rsr_ccompare0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ccompare0_args,
    2, Iclass_xt_iclass_wsr_ccompare0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ccompare0_args,
    2, Iclass_xt_iclass_xsr_ccompare0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ccompare1_args,
    1, Iclass_xt_iclass_rsr_ccompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ccompare1_args,
    2, Iclass_xt_iclass_wsr_ccompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ccompare1_args,
    2, Iclass_xt_iclass_xsr_ccompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ccompare2_args,
    1, Iclass_xt_iclass_rsr_ccompare2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ccompare2_args,
    2, Iclass_xt_iclass_wsr_ccompare2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ccompare2_args,
    2, Iclass_xt_iclass_xsr_ccompare2_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_icache_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_icache_lock_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_icache_inv_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_licx_args,
    2, Iclass_xt_iclass_licx_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_sicx_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_dcache_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_dcache_dyn_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_dcache_ind_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_dcache_inv_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_dpf_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_dcache_lock_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_sdct_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_ldct_args,
    2, Iclass_xt_iclass_ldct_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_prefctl_args,
    1, Iclass_xt_iclass_rsr_prefctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_prefctl_args,
    1, Iclass_xt_iclass_wsr_prefctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_prefctl_args,
    1, Iclass_xt_iclass_xsr_prefctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_idtlb_args,
    1, Iclass_xt_iclass_idtlb_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_rdtlb_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_wdtlb_args,
    1, Iclass_xt_iclass_wdtlb_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_iitlb_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_ritlb_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_witlb_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_cpenable_args,
    1, Iclass_xt_iclass_rsr_cpenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_cpenable_args,
    1, Iclass_xt_iclass_wsr_cpenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_cpenable_args,
    1, Iclass_xt_iclass_xsr_cpenable_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_clamp_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_minmax_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_nsa_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_sx_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l32ai_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32ri_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32c1i_args,
    3, Iclass_xt_iclass_s32c1i_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_scompare1_args,
    1, Iclass_xt_iclass_rsr_scompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_scompare1_args,
    1, Iclass_xt_iclass_wsr_scompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_scompare1_args,
    1, Iclass_xt_iclass_xsr_scompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_atomctl_args,
    1, Iclass_xt_iclass_rsr_atomctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_atomctl_args,
    2, Iclass_xt_iclass_wsr_atomctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_atomctl_args,
    2, Iclass_xt_iclass_xsr_atomctl_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_div_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_rer_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_wer_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_wb18_0_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_wb18_1_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_wb18_2_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_wb18_3_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_wb18_4_args,
    0, 0, 0, 0 },
  { 1, Iclass_rur_ae_ovf_sar_args,
    3, Iclass_rur_ae_ovf_sar_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_ovf_sar_args,
    3, Iclass_wur_ae_ovf_sar_stateArgs, 0, 0 },
  { 1, Iclass_rur_ae_bithead_args,
    2, Iclass_rur_ae_bithead_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_bithead_args,
    2, Iclass_wur_ae_bithead_stateArgs, 0, 0 },
  { 1, Iclass_rur_ae_ts_fts_bu_bp_args,
    5, Iclass_rur_ae_ts_fts_bu_bp_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_ts_fts_bu_bp_args,
    5, Iclass_wur_ae_ts_fts_bu_bp_stateArgs, 0, 0 },
  { 1, Iclass_rur_ae_cw_sd_no_args,
    4, Iclass_rur_ae_cw_sd_no_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_cw_sd_no_args,
    4, Iclass_wur_ae_cw_sd_no_stateArgs, 0, 0 },
  { 1, Iclass_rur_ae_cbegin0_args,
    2, Iclass_rur_ae_cbegin0_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_cbegin0_args,
    2, Iclass_wur_ae_cbegin0_stateArgs, 0, 0 },
  { 1, Iclass_rur_ae_cend0_args,
    2, Iclass_rur_ae_cend0_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_cend0_args,
    2, Iclass_wur_ae_cend0_stateArgs, 0, 0 },
  { 1, Iclass_rur_fcr_args,
    9, Iclass_rur_fcr_stateArgs, 0, 0 },
  { 1, Iclass_wur_fcr_args,
    9, Iclass_wur_fcr_stateArgs, 0, 0 },
  { 1, Iclass_rur_fsr_args,
    8, Iclass_rur_fsr_stateArgs, 0, 0 },
  { 1, Iclass_wur_fsr_args,
    8, Iclass_wur_fsr_stateArgs, 0, 0 }
};

enum xtensa_iclass_id {
  ICLASS_RUR_AE_OVERFLOW,
  ICLASS_WUR_AE_OVERFLOW,
  ICLASS_RUR_AE_SAR,
  ICLASS_WUR_AE_SAR,
  ICLASS_RUR_AE_BITPTR,
  ICLASS_WUR_AE_BITPTR,
  ICLASS_RUR_AE_BITSUSED,
  ICLASS_WUR_AE_BITSUSED,
  ICLASS_RUR_AE_TABLESIZE,
  ICLASS_WUR_AE_TABLESIZE,
  ICLASS_RUR_AE_FIRST_TS,
  ICLASS_WUR_AE_FIRST_TS,
  ICLASS_RUR_AE_NEXTOFFSET,
  ICLASS_WUR_AE_NEXTOFFSET,
  ICLASS_RUR_AE_SEARCHDONE,
  ICLASS_WUR_AE_SEARCHDONE,
  ICLASS_RUR_AE_CWRAP,
  ICLASS_WUR_AE_CWRAP,
  ICLASS_AE_L16M_XC,
  ICLASS_AE_L16M_I,
  ICLASS_AE_L16M_IU,
  ICLASS_AE_L16M_X,
  ICLASS_AE_L16M_XU,
  ICLASS_AE_L16_XC,
  ICLASS_AE_L16_I,
  ICLASS_AE_L16_IP,
  ICLASS_AE_L16_X,
  ICLASS_AE_L16_XP,
  ICLASS_AE_L32F24_XC,
  ICLASS_AE_L32F24_I,
  ICLASS_AE_L32F24_IP,
  ICLASS_AE_L32F24_X,
  ICLASS_AE_L32F24_XP,
  ICLASS_AE_L32_XC,
  ICLASS_AE_L32_I,
  ICLASS_AE_L32_IP,
  ICLASS_AE_L32_X,
  ICLASS_AE_L32_XP,
  ICLASS_AE_L32M_XC,
  ICLASS_AE_L32M_I,
  ICLASS_AE_L32M_IU,
  ICLASS_AE_L32M_X,
  ICLASS_AE_L32M_XU,
  ICLASS_AE_L16X2M_XC,
  ICLASS_AE_L16X2M_I,
  ICLASS_AE_L16X2M_IU,
  ICLASS_AE_L16X2M_X,
  ICLASS_AE_L16X2M_XU,
  ICLASS_AE_L32X2F24_XC,
  ICLASS_AE_L32X2F24_I,
  ICLASS_AE_L32X2F24_IP,
  ICLASS_AE_L32X2F24_RIP,
  ICLASS_AE_L32X2F24_RIC,
  ICLASS_AE_L32X2F24_X,
  ICLASS_AE_L32X2F24_XP,
  ICLASS_AE_L32X2_XC,
  ICLASS_AE_L32X2_I,
  ICLASS_AE_L32X2_IP,
  ICLASS_AE_L32X2_RIP,
  ICLASS_AE_L32X2_RIC,
  ICLASS_AE_L32X2_X,
  ICLASS_AE_L32X2_XP,
  ICLASS_AE_L16X4_XC,
  ICLASS_AE_L16X4_I,
  ICLASS_AE_L16X4_IP,
  ICLASS_AE_L16X4_RIP,
  ICLASS_AE_L16X4_RIC,
  ICLASS_AE_L16X4_X,
  ICLASS_AE_L16X4_XP,
  ICLASS_AE_L64_XC,
  ICLASS_AE_L64_I,
  ICLASS_AE_L64_IP,
  ICLASS_AE_L64_X,
  ICLASS_AE_L64_XP,
  ICLASS_AE_S16X2M_XC,
  ICLASS_AE_S16X2M_I,
  ICLASS_AE_S16X2M_IU,
  ICLASS_AE_S16X2M_X,
  ICLASS_AE_S16X2M_XU,
  ICLASS_AE_S32X2F24_XC,
  ICLASS_AE_S32X2F24_I,
  ICLASS_AE_S32X2F24_IP,
  ICLASS_AE_S32X2F24_RIP,
  ICLASS_AE_S32X2F24_RIC,
  ICLASS_AE_S32X2F24_X,
  ICLASS_AE_S32X2F24_XP,
  ICLASS_AE_S32X2_XC,
  ICLASS_AE_S32X2_I,
  ICLASS_AE_S32X2_IP,
  ICLASS_AE_S32X2_RIP,
  ICLASS_AE_S32X2_RIC,
  ICLASS_AE_S32X2_X,
  ICLASS_AE_S32X2_XP,
  ICLASS_AE_S16X4_XC,
  ICLASS_AE_S16X4_I,
  ICLASS_AE_S16X4_IP,
  ICLASS_AE_S16X4_RIP,
  ICLASS_AE_S16X4_RIC,
  ICLASS_AE_S16X4_X,
  ICLASS_AE_S16X4_XP,
  ICLASS_AE_S16M_L_XC,
  ICLASS_AE_S16M_L_I,
  ICLASS_AE_S16M_L_IU,
  ICLASS_AE_S16M_L_X,
  ICLASS_AE_S16M_L_XU,
  ICLASS_AE_S32F24_L_XC,
  ICLASS_AE_S32F24_L_I,
  ICLASS_AE_S32F24_L_IP,
  ICLASS_AE_S32F24_L_X,
  ICLASS_AE_S32F24_L_XP,
  ICLASS_AE_S32_L_XC,
  ICLASS_AE_S32_L_I,
  ICLASS_AE_S32_L_IP,
  ICLASS_AE_S32_L_X,
  ICLASS_AE_S32_L_XP,
  ICLASS_AE_S16_0_XC,
  ICLASS_AE_S16_0_I,
  ICLASS_AE_S16_0_IP,
  ICLASS_AE_S16_0_X,
  ICLASS_AE_S16_0_XP,
  ICLASS_AE_S64_XC,
  ICLASS_AE_S64_I,
  ICLASS_AE_S64_IP,
  ICLASS_AE_S64_X,
  ICLASS_AE_S64_XP,
  ICLASS_AE_S32M_XC,
  ICLASS_AE_S32M_I,
  ICLASS_AE_S32M_IU,
  ICLASS_AE_S32M_X,
  ICLASS_AE_S32M_XU,
  ICLASS_AE_ZALIGN64,
  ICLASS_AE_LALIGN64_I,
  ICLASS_AE_SALIGN64_I,
  ICLASS_AE_MOVALIGN,
  ICLASS_AE_LA64_PP,
  ICLASS_AE_LA24POS_PC,
  ICLASS_AE_LA24X2POS_PC,
  ICLASS_AE_LA32X2POS_PC,
  ICLASS_AE_LA16X4POS_PC,
  ICLASS_AE_LA24NEG_PC,
  ICLASS_AE_LA24X2NEG_PC,
  ICLASS_AE_LA32X2NEG_PC,
  ICLASS_AE_LA16X4NEG_PC,
  ICLASS_AE_SA64POS_FP,
  ICLASS_AE_SA64NEG_FP,
  ICLASS_AE_LA32X2_IC,
  ICLASS_AE_LA32X2_IP,
  ICLASS_AE_LA32X2_RIP,
  ICLASS_AE_LA32X2_RIC,
  ICLASS_AE_LA16X4_IC,
  ICLASS_AE_LA16X4_IP,
  ICLASS_AE_LA16X4_RIP,
  ICLASS_AE_LA16X4_RIC,
  ICLASS_AE_LA32X2F24_IC,
  ICLASS_AE_LA32X2F24_IP,
  ICLASS_AE_LA32X2F24_RIP,
  ICLASS_AE_LA32X2F24_RIC,
  ICLASS_AE_LA24_IC,
  ICLASS_AE_LA24_IP,
  ICLASS_AE_LA24_RIP,
  ICLASS_AE_LA24_RIC,
  ICLASS_AE_LA24X2_IC,
  ICLASS_AE_LA24X2_IP,
  ICLASS_AE_LA24X2_RIP,
  ICLASS_AE_LA24X2_RIC,
  ICLASS_AE_SA32X2_IC,
  ICLASS_AE_SA32X2_IP,
  ICLASS_AE_SA32X2_RIP,
  ICLASS_AE_SA32X2_RIC,
  ICLASS_AE_SA16X4_IC,
  ICLASS_AE_SA16X4_IP,
  ICLASS_AE_SA16X4_RIP,
  ICLASS_AE_SA16X4_RIC,
  ICLASS_AE_SA32X2F24_IC,
  ICLASS_AE_SA32X2F24_IP,
  ICLASS_AE_SA32X2F24_RIP,
  ICLASS_AE_SA32X2F24_RIC,
  ICLASS_AE_SA24_L_IC,
  ICLASS_AE_SA24_L_IP,
  ICLASS_AE_SA24_L_RIP,
  ICLASS_AE_SA24_L_RIC,
  ICLASS_AE_SA24X2_IC,
  ICLASS_AE_SA24X2_IP,
  ICLASS_AE_SA24X2_RIP,
  ICLASS_AE_SA24X2_RIC,
  ICLASS_AE_S32RA64S_I,
  ICLASS_AE_S32RA64S_IP,
  ICLASS_AE_S32RA64S_X,
  ICLASS_AE_S32RA64S_XP,
  ICLASS_AE_S32RA64S_XC,
  ICLASS_AE_S24RA64S_I,
  ICLASS_AE_S24RA64S_IP,
  ICLASS_AE_S24RA64S_X,
  ICLASS_AE_S24RA64S_XP,
  ICLASS_AE_S24RA64S_XC,
  ICLASS_AE_S32X2RA64S_IP,
  ICLASS_AE_S24X2RA64S_IP,
  ICLASS_AE_ADDBRBA32,
  ICLASS_AE_SEL16I,
  ICLASS_AE_SEL16I_N,
  ICLASS_AE_SHORTSWAP,
  ICLASS_AE_MOVT16X4,
  ICLASS_AE_MOVF16X4,
  ICLASS_AE_MOVT32X2,
  ICLASS_AE_MOVF32X2,
  ICLASS_AE_MOVDA32X2,
  ICLASS_AE_MOVDA32,
  ICLASS_AE_MOVDA16X2,
  ICLASS_AE_MOVDA16,
  ICLASS_AE_MOVI,
  ICLASS_AE_TRUNCP24A32X2,
  ICLASS_AE_SAT16X4,
  ICLASS_AE_CVT32X2F16_32,
  ICLASS_AE_CVT32X2F16_10,
  ICLASS_AE_SEXT32X2D16_32,
  ICLASS_AE_SEXT32X2D16_10,
  ICLASS_AE_CVTA32F24S_L,
  ICLASS_AE_CVTA32F24S_H,
  ICLASS_AE_CVTP24A16X2_LL,
  ICLASS_AE_CVTP24A16X2_LH,
  ICLASS_AE_CVTP24A16X2_HL,
  ICLASS_AE_CVTP24A16X2_HH,
  ICLASS_AE_TRUNCP24Q48X2,
  ICLASS_AE_TRUNCA32X2F64S,
  ICLASS_AE_TRUNCI32X2F64S,
  ICLASS_AE_TRUNCA32F64S_L,
  ICLASS_AE_TRUNCI32F64S_L,
  ICLASS_AE_TRUNCP16,
  ICLASS_AE_ROUND32X2F64SSYM,
  ICLASS_AE_ROUND32X2F64SASYM,
  ICLASS_AE_ROUND32X2F48SSYM,
  ICLASS_AE_ROUND32X2F48SASYM,
  ICLASS_AE_ROUND16X4F32SSYM,
  ICLASS_AE_ROUND16X4F32SASYM,
  ICLASS_AE_ROUND24X2F48SSYM,
  ICLASS_AE_ROUND24X2F48SASYM,
  ICLASS_AE_ROUNDSP16Q48X2SYM,
  ICLASS_AE_ROUNDSP16Q48X2ASYM,
  ICLASS_AE_MINABS32S,
  ICLASS_AE_MAXABS32S,
  ICLASS_AE_ROUNDSP16F24SYM,
  ICLASS_AE_ROUNDSP16F24ASYM,
  ICLASS_AE_MOV,
  ICLASS_AE_MOVT64,
  ICLASS_AE_MOVF64,
  ICLASS_AE_CVTQ56A32S,
  ICLASS_AE_CVT48A32,
  ICLASS_AE_CVT64A32,
  ICLASS_AE_CVTQ56P32S_L,
  ICLASS_AE_CVTQ56P32S_H,
  ICLASS_AE_CVT64F32_H,
  ICLASS_AE_SAT48S,
  ICLASS_AE_SATQ56S,
  ICLASS_AE_SAT24S,
  ICLASS_AE_TRUNCQ32,
  ICLASS_AE_MINABS64S,
  ICLASS_AE_MAXABS64S,
  ICLASS_AE_ROUNDSQ32F48SYM,
  ICLASS_AE_ROUNDSQ32F48ASYM,
  ICLASS_AE_TRUNCA32Q48,
  ICLASS_AE_MOVAD32_L,
  ICLASS_AE_MOVAD32_H,
  ICLASS_AE_MOVAD16_3,
  ICLASS_AE_MOVAD16_2,
  ICLASS_AE_MOVAD16_1,
  ICLASS_AE_MOVAD16_0,
  ICLASS_AE_SRA64_32,
  ICLASS_AE_PKSR32,
  ICLASS_AE_PKSR24,
  ICLASS_AE_TRUNCA16P24S_L,
  ICLASS_AE_TRUNCA16P24S_H,
  ICLASS_AE_ADD32,
  ICLASS_AE_SUB32,
  ICLASS_AE_ADDSUB32,
  ICLASS_AE_SUBADD32,
  ICLASS_AE_ADD16,
  ICLASS_AE_SUB16,
  ICLASS_AE_ADD32_HL_LH,
  ICLASS_AE_NEG32,
  ICLASS_AE_ABS32,
  ICLASS_AE_ADD24S,
  ICLASS_AE_SUB24S,
  ICLASS_AE_ADD32S,
  ICLASS_AE_SUB32S,
  ICLASS_AE_ADDSUB32S,
  ICLASS_AE_SUBADD32S,
  ICLASS_AE_ADD16S,
  ICLASS_AE_SUB16S,
  ICLASS_AE_NEG24S,
  ICLASS_AE_ABS24S,
  ICLASS_AE_NEG32S,
  ICLASS_AE_ABS32S,
  ICLASS_AE_NEG16S,
  ICLASS_AE_ABS16S,
  ICLASS_AE_LT16,
  ICLASS_AE_LE16,
  ICLASS_AE_EQ16,
  ICLASS_AE_LT32,
  ICLASS_AE_LE32,
  ICLASS_AE_EQ32,
  ICLASS_AE_MIN32,
  ICLASS_AE_MAX32,
  ICLASS_AE_ADD64,
  ICLASS_AE_SUB64,
  ICLASS_AE_NEG64,
  ICLASS_AE_ABS64,
  ICLASS_AE_ADDSQ56S,
  ICLASS_AE_SUBSQ56S,
  ICLASS_AE_ADD64S,
  ICLASS_AE_SUB64S,
  ICLASS_AE_NEGSQ56S,
  ICLASS_AE_ABSSQ56S,
  ICLASS_AE_NEG64S,
  ICLASS_AE_ABS64S,
  ICLASS_AE_AND,
  ICLASS_AE_NAND,
  ICLASS_AE_OR,
  ICLASS_AE_XOR,
  ICLASS_AE_SLAI24,
  ICLASS_AE_SRLI24,
  ICLASS_AE_SRAI24,
  ICLASS_AE_SLAS24,
  ICLASS_AE_SRLS24,
  ICLASS_AE_SRAS24,
  ICLASS_AE_SRAI16,
  ICLASS_AE_SRAI16R,
  ICLASS_AE_SLAI32,
  ICLASS_AE_SRLI32,
  ICLASS_AE_SRAI32,
  ICLASS_AE_SRAI32R,
  ICLASS_AE_SLAS32,
  ICLASS_AE_SRLS32,
  ICLASS_AE_SRAS32,
  ICLASS_AE_SLAA32,
  ICLASS_AE_SRLA32,
  ICLASS_AE_SRAA32,
  ICLASS_AE_SLAI16S,
  ICLASS_AE_SLAA16S,
  ICLASS_AE_SRAA16S,
  ICLASS_AE_SRAA16RS,
  ICLASS_AE_SLAI24S,
  ICLASS_AE_SLAS24S,
  ICLASS_AE_SLAI32S,
  ICLASS_AE_SLAS32S,
  ICLASS_AE_SLAA32S,
  ICLASS_AE_SRAA32S,
  ICLASS_AE_SRAA32RS,
  ICLASS_AE_SLASQ56,
  ICLASS_AE_SRLSQ56,
  ICLASS_AE_SRASQ56,
  ICLASS_AE_SLAAQ56,
  ICLASS_AE_SRLAQ56,
  ICLASS_AE_SRAAQ56,
  ICLASS_AE_SLAI64,
  ICLASS_AE_SRLI64,
  ICLASS_AE_SRAI64,
  ICLASS_AE_SLAS64,
  ICLASS_AE_SRLS64,
  ICLASS_AE_SRAS64,
  ICLASS_AE_SLAA64,
  ICLASS_AE_SRLA64,
  ICLASS_AE_SRAA64,
  ICLASS_AE_SLAISQ56S,
  ICLASS_AE_SLASSQ56S,
  ICLASS_AE_SLAASQ56S,
  ICLASS_AE_SLAI64S,
  ICLASS_AE_SLAS64S,
  ICLASS_AE_SLAA64S,
  ICLASS_AE_LT64,
  ICLASS_AE_LE64,
  ICLASS_AE_EQ64,
  ICLASS_AE_MAX64,
  ICLASS_AE_MIN64,
  ICLASS_AE_NSA64,
  ICLASS_AE_NSAZ16_0,
  ICLASS_AE_NSAZ32_L,
  ICLASS_AE_MULS32F48P16S_LL,
  ICLASS_AE_MULF32S_LL,
  ICLASS_AE_MUL32_LL,
  ICLASS_AE_MULS32F48P16S_LL_S2,
  ICLASS_AE_MULF32R_LL,
  ICLASS_AE_MULS32F48P16S_LH,
  ICLASS_AE_MULF32S_LH,
  ICLASS_AE_MUL32_LH,
  ICLASS_AE_MULS32F48P16S_LH_S2,
  ICLASS_AE_MULF32R_LH,
  ICLASS_AE_MULS32F48P16S_HH,
  ICLASS_AE_MULF32S_HH,
  ICLASS_AE_MUL32_HH,
  ICLASS_AE_MULS32F48P16S_HH_S2,
  ICLASS_AE_MULF32R_HH,
  ICLASS_AE_MULF32R_LL_S2,
  ICLASS_AE_MULAS32F48P16S_LL,
  ICLASS_AE_MULAF32S_LL,
  ICLASS_AE_MULA32_LL,
  ICLASS_AE_MULAS32F48P16S_LL_S2,
  ICLASS_AE_MULAF32R_LL,
  ICLASS_AE_MULAS32F48P16S_LH,
  ICLASS_AE_MULAF32S_LH,
  ICLASS_AE_MULA32_LH,
  ICLASS_AE_MULAS32F48P16S_LH_S2,
  ICLASS_AE_MULAF32R_LH,
  ICLASS_AE_MULAS32F48P16S_HH,
  ICLASS_AE_MULAF32S_HH,
  ICLASS_AE_MULA32_HH,
  ICLASS_AE_MULAS32F48P16S_HH_S2,
  ICLASS_AE_MULAF32R_HH,
  ICLASS_AE_MULAF32R_LL_S2,
  ICLASS_AE_MULSS32F48P16S_LL,
  ICLASS_AE_MULSF32S_LL,
  ICLASS_AE_MULS32_LL,
  ICLASS_AE_MULSS32F48P16S_LL_S2,
  ICLASS_AE_MULSF32R_LL,
  ICLASS_AE_MULSS32F48P16S_LH,
  ICLASS_AE_MULSF32S_LH,
  ICLASS_AE_MULS32_LH,
  ICLASS_AE_MULSS32F48P16S_LH_S2,
  ICLASS_AE_MULSF32R_LH,
  ICLASS_AE_MULSS32F48P16S_HH,
  ICLASS_AE_MULSF32S_HH,
  ICLASS_AE_MULS32_HH,
  ICLASS_AE_MULSS32F48P16S_HH_S2,
  ICLASS_AE_MULSF32R_HH,
  ICLASS_AE_MULSF32R_LL_S2,
  ICLASS_AE_MULF32S_LL_S2,
  ICLASS_AE_MULAF32S_LL_S2,
  ICLASS_AE_MUL32_LL_S2,
  ICLASS_AE_MULA32_LL_S2,
  ICLASS_AE_MUL32U_LL,
  ICLASS_AE_MULA32U_LL,
  ICLASS_AE_MULS32U_LL,
  ICLASS_AE_MULF16SS_33,
  ICLASS_AE_MULF16SS_22,
  ICLASS_AE_MULF16SS_32,
  ICLASS_AE_MULF16SS_21,
  ICLASS_AE_MULF16SS_31,
  ICLASS_AE_MULF16SS_30,
  ICLASS_AE_MULF16SS_10,
  ICLASS_AE_MULF16SS_20,
  ICLASS_AE_MULF16SS_11,
  ICLASS_AE_MULF16SS_00,
  ICLASS_AE_MULF16SS_00_S2,
  ICLASS_AE_MULSF16SS_33,
  ICLASS_AE_MULSF16SS_22,
  ICLASS_AE_MULSF16SS_32,
  ICLASS_AE_MULSF16SS_21,
  ICLASS_AE_MULSF16SS_31,
  ICLASS_AE_MULSF16SS_30,
  ICLASS_AE_MULSF16SS_10,
  ICLASS_AE_MULSF16SS_20,
  ICLASS_AE_MULSF16SS_11,
  ICLASS_AE_MULSF16SS_00,
  ICLASS_AE_MULSF16SS_00_S2,
  ICLASS_AE_MULAF16SS_33,
  ICLASS_AE_MULAF16SS_22,
  ICLASS_AE_MULAF16SS_32,
  ICLASS_AE_MULAF16SS_21,
  ICLASS_AE_MULAF16SS_31,
  ICLASS_AE_MULAF16SS_30,
  ICLASS_AE_MULAF16SS_10,
  ICLASS_AE_MULAF16SS_20,
  ICLASS_AE_MULAF16SS_11,
  ICLASS_AE_MULAF16SS_00,
  ICLASS_AE_MULAF16SS_00_S2,
  ICLASS_AE_MULAAFD16SS_33_22,
  ICLASS_AE_MULAAFD16SS_33_22_S2,
  ICLASS_AE_MULAAFD16SS_13_02,
  ICLASS_AE_MULAAFD16SS_13_02_S2,
  ICLASS_AE_MULAAFD16SS_11_00,
  ICLASS_AE_MULAAFD16SS_11_00_S2,
  ICLASS_AE_MULSSFD16SS_33_22,
  ICLASS_AE_MULSSFD16SS_33_22_S2,
  ICLASS_AE_MULSSFD16SS_13_02,
  ICLASS_AE_MULSSFD16SS_13_02_S2,
  ICLASS_AE_MULSSFD16SS_11_00,
  ICLASS_AE_MULSSFD16SS_11_00_S2,
  ICLASS_AE_MULZAAFD16SS_33_22,
  ICLASS_AE_MULZAAFD16SS_33_22_S2,
  ICLASS_AE_MULZAAFD16SS_13_02,
  ICLASS_AE_MULZAAFD16SS_13_02_S2,
  ICLASS_AE_MULZAAFD16SS_11_00,
  ICLASS_AE_MULZAAFD16SS_11_00_S2,
  ICLASS_AE_MULZSSFD16SS_33_22,
  ICLASS_AE_MULZSSFD16SS_33_22_S2,
  ICLASS_AE_MULZSSFD16SS_13_02,
  ICLASS_AE_MULZSSFD16SS_13_02_S2,
  ICLASS_AE_MULZSSFD16SS_11_00,
  ICLASS_AE_MULZSSFD16SS_11_00_S2,
  ICLASS_AE_MULF48Q32SP16S_L,
  ICLASS_AE_MULF48Q32SP16S_L_S2,
  ICLASS_AE_MULF48Q32SP16U_L,
  ICLASS_AE_MULF48Q32SP16U_L_S2,
  ICLASS_AE_MULQ32SP16S_L,
  ICLASS_AE_MULQ32SP16S_L_S2,
  ICLASS_AE_MULQ32SP16U_L,
  ICLASS_AE_MULQ32SP16U_L_S2,
  ICLASS_AE_MULAF48Q32SP16S_L,
  ICLASS_AE_MULAF48Q32SP16S_L_S2,
  ICLASS_AE_MULAF48Q32SP16U_L,
  ICLASS_AE_MULAF48Q32SP16U_L_S2,
  ICLASS_AE_MULAQ32SP16S_L,
  ICLASS_AE_MULAQ32SP16S_L_S2,
  ICLASS_AE_MULAQ32SP16U_L,
  ICLASS_AE_MULAQ32SP16U_L_S2,
  ICLASS_AE_MULSF48Q32SP16S_L,
  ICLASS_AE_MULSF48Q32SP16S_L_S2,
  ICLASS_AE_MULSF48Q32SP16U_L,
  ICLASS_AE_MULSF48Q32SP16U_L_S2,
  ICLASS_AE_MULSQ32SP16S_L,
  ICLASS_AE_MULSQ32SP16S_L_S2,
  ICLASS_AE_MULSQ32SP16U_L,
  ICLASS_AE_MULSQ32SP16U_L_S2,
  ICLASS_AE_MULFP24X2RA,
  ICLASS_AE_MULFP24X2R,
  ICLASS_AE_MULP24X2,
  ICLASS_AE_MULFP24X2RA_S2,
  ICLASS_AE_MULFP24X2R_S2,
  ICLASS_AE_MULP24X2_S2,
  ICLASS_AE_MULAFP24X2RA,
  ICLASS_AE_MULAFP24X2R,
  ICLASS_AE_MULAP24X2,
  ICLASS_AE_MULAFP24X2RA_S2,
  ICLASS_AE_MULAFP24X2R_S2,
  ICLASS_AE_MULAP24X2_S2,
  ICLASS_AE_MULSFP24X2RA,
  ICLASS_AE_MULSFP24X2R,
  ICLASS_AE_MULSP24X2,
  ICLASS_AE_MULSFP24X2RA_S2,
  ICLASS_AE_MULSFP24X2R_S2,
  ICLASS_AE_MULSP24X2_S2,
  ICLASS_AE_MULZAAFD24_HH_LL,
  ICLASS_AE_MULZAAD24_HH_LL,
  ICLASS_AE_MULZAAFD24_HH_LL_S2,
  ICLASS_AE_MULZAAD24_HH_LL_S2,
  ICLASS_AE_MULZAAFD24_HL_LH,
  ICLASS_AE_MULZAAD24_HL_LH,
  ICLASS_AE_MULZAAFD24_HL_LH_S2,
  ICLASS_AE_MULZAAD24_HL_LH_S2,
  ICLASS_AE_MULZASFD24_HH_LL,
  ICLASS_AE_MULZASD24_HH_LL,
  ICLASS_AE_MULZASFD24_HH_LL_S2,
  ICLASS_AE_MULZASD24_HH_LL_S2,
  ICLASS_AE_MULZASFD24_HL_LH,
  ICLASS_AE_MULZASD24_HL_LH,
  ICLASS_AE_MULZASFD24_HL_LH_S2,
  ICLASS_AE_MULZASD24_HL_LH_S2,
  ICLASS_AE_MULZSAFD24_HH_LL,
  ICLASS_AE_MULZSAD24_HH_LL,
  ICLASS_AE_MULZSAFD24_HH_LL_S2,
  ICLASS_AE_MULZSAD24_HH_LL_S2,
  ICLASS_AE_MULZSSFD24_HH_LL,
  ICLASS_AE_MULZSSD24_HH_LL,
  ICLASS_AE_MULZSSFD24_HH_LL_S2,
  ICLASS_AE_MULZSSD24_HH_LL_S2,
  ICLASS_AE_MULZSSFD24_HL_LH,
  ICLASS_AE_MULZSSD24_HL_LH,
  ICLASS_AE_MULZSSFD24_HL_LH_S2,
  ICLASS_AE_MULZSSD24_HL_LH_S2,
  ICLASS_AE_MULAAFD24_HH_LL,
  ICLASS_AE_MULAAD24_HH_LL,
  ICLASS_AE_MULAAFD24_HH_LL_S2,
  ICLASS_AE_MULAAD24_HH_LL_S2,
  ICLASS_AE_MULAAFD24_HL_LH,
  ICLASS_AE_MULAAD24_HL_LH,
  ICLASS_AE_MULAAFD24_HL_LH_S2,
  ICLASS_AE_MULAAD24_HL_LH_S2,
  ICLASS_AE_MULASFD24_HH_LL,
  ICLASS_AE_MULASD24_HH_LL,
  ICLASS_AE_MULASFD24_HH_LL_S2,
  ICLASS_AE_MULASD24_HH_LL_S2,
  ICLASS_AE_MULASFD24_HL_LH,
  ICLASS_AE_MULASD24_HL_LH,
  ICLASS_AE_MULASFD24_HL_LH_S2,
  ICLASS_AE_MULASD24_HL_LH_S2,
  ICLASS_AE_MULSAFD24_HH_LL,
  ICLASS_AE_MULSAD24_HH_LL,
  ICLASS_AE_MULSAFD24_HH_LL_S2,
  ICLASS_AE_MULSAD24_HH_LL_S2,
  ICLASS_AE_MULSSFD24_HH_LL,
  ICLASS_AE_MULSSD24_HH_LL,
  ICLASS_AE_MULSSFD24_HH_LL_S2,
  ICLASS_AE_MULSSD24_HH_LL_S2,
  ICLASS_AE_MULSSFD24_HL_LH,
  ICLASS_AE_MULSSD24_HL_LH,
  ICLASS_AE_MULSSFD24_HL_LH_S2,
  ICLASS_AE_MULSSD24_HL_LH_S2,
  ICLASS_AE_MULSRFQ32SP24S_H,
  ICLASS_AE_MULSRFQ32SP24S_L,
  ICLASS_AE_MULSRFQ32SP24S_H_S2,
  ICLASS_AE_MULSRFQ32SP24S_L_S2,
  ICLASS_AE_MULARFQ32SP24S_H,
  ICLASS_AE_MULARFQ32SP24S_L,
  ICLASS_AE_MULARFQ32SP24S_H_S2,
  ICLASS_AE_MULARFQ32SP24S_L_S2,
  ICLASS_AE_MULRFQ32SP24S_H,
  ICLASS_AE_MULRFQ32SP24S_L,
  ICLASS_AE_MULRFQ32SP24S_H_S2,
  ICLASS_AE_MULRFQ32SP24S_L_S2,
  ICLASS_AE_MULSFQ32SP24S_H,
  ICLASS_AE_MULSFQ32SP24S_L,
  ICLASS_AE_MULSFQ32SP24S_H_S2,
  ICLASS_AE_MULSFQ32SP24S_L_S2,
  ICLASS_AE_MULAFQ32SP24S_H,
  ICLASS_AE_MULAFQ32SP24S_L,
  ICLASS_AE_MULAFQ32SP24S_H_S2,
  ICLASS_AE_MULAFQ32SP24S_L_S2,
  ICLASS_AE_MULFQ32SP24S_H,
  ICLASS_AE_MULFQ32SP24S_L,
  ICLASS_AE_MULFQ32SP24S_H_S2,
  ICLASS_AE_MULFQ32SP24S_L_S2,
  ICLASS_AE_MULF32X16_L0,
  ICLASS_AE_MUL32X16_L0,
  ICLASS_AE_MULF32X16_L0_S2,
  ICLASS_AE_MUL32X16_L0_S2,
  ICLASS_AE_MULF32X16_L1,
  ICLASS_AE_MUL32X16_L1,
  ICLASS_AE_MULF32X16_L1_S2,
  ICLASS_AE_MUL32X16_L1_S2,
  ICLASS_AE_MULF32X16_L2,
  ICLASS_AE_MUL32X16_L2,
  ICLASS_AE_MULF32X16_L2_S2,
  ICLASS_AE_MUL32X16_L2_S2,
  ICLASS_AE_MULF32X16_L3,
  ICLASS_AE_MUL32X16_L3,
  ICLASS_AE_MULF32X16_L3_S2,
  ICLASS_AE_MUL32X16_L3_S2,
  ICLASS_AE_MULF32X16_H0,
  ICLASS_AE_MUL32X16_H0,
  ICLASS_AE_MULF32X16_H0_S2,
  ICLASS_AE_MUL32X16_H0_S2,
  ICLASS_AE_MULF32X16_H1,
  ICLASS_AE_MUL32X16_H1,
  ICLASS_AE_MULF32X16_H1_S2,
  ICLASS_AE_MUL32X16_H1_S2,
  ICLASS_AE_MULF32X16_H2,
  ICLASS_AE_MUL32X16_H2,
  ICLASS_AE_MULF32X16_H2_S2,
  ICLASS_AE_MUL32X16_H2_S2,
  ICLASS_AE_MULF32X16_H3,
  ICLASS_AE_MUL32X16_H3,
  ICLASS_AE_MULF32X16_H3_S2,
  ICLASS_AE_MUL32X16_H3_S2,
  ICLASS_AE_MULAF32X16_L0,
  ICLASS_AE_MULA32X16_L0,
  ICLASS_AE_MULAF32X16_L0_S2,
  ICLASS_AE_MULA32X16_L0_S2,
  ICLASS_AE_MULAF32X16_L1,
  ICLASS_AE_MULA32X16_L1,
  ICLASS_AE_MULAF32X16_L1_S2,
  ICLASS_AE_MULA32X16_L1_S2,
  ICLASS_AE_MULAF32X16_L2,
  ICLASS_AE_MULA32X16_L2,
  ICLASS_AE_MULAF32X16_L2_S2,
  ICLASS_AE_MULA32X16_L2_S2,
  ICLASS_AE_MULAF32X16_L3,
  ICLASS_AE_MULA32X16_L3,
  ICLASS_AE_MULAF32X16_L3_S2,
  ICLASS_AE_MULA32X16_L3_S2,
  ICLASS_AE_MULAF32X16_H0,
  ICLASS_AE_MULA32X16_H0,
  ICLASS_AE_MULAF32X16_H0_S2,
  ICLASS_AE_MULA32X16_H0_S2,
  ICLASS_AE_MULAF32X16_H1,
  ICLASS_AE_MULA32X16_H1,
  ICLASS_AE_MULAF32X16_H1_S2,
  ICLASS_AE_MULA32X16_H1_S2,
  ICLASS_AE_MULAF32X16_H2,
  ICLASS_AE_MULA32X16_H2,
  ICLASS_AE_MULAF32X16_H2_S2,
  ICLASS_AE_MULA32X16_H2_S2,
  ICLASS_AE_MULAF32X16_H3,
  ICLASS_AE_MULA32X16_H3,
  ICLASS_AE_MULAF32X16_H3_S2,
  ICLASS_AE_MULA32X16_H3_S2,
  ICLASS_AE_MULSF32X16_L0,
  ICLASS_AE_MULS32X16_L0,
  ICLASS_AE_MULSF32X16_L0_S2,
  ICLASS_AE_MULS32X16_L0_S2,
  ICLASS_AE_MULSF32X16_L1,
  ICLASS_AE_MULS32X16_L1,
  ICLASS_AE_MULSF32X16_L1_S2,
  ICLASS_AE_MULS32X16_L1_S2,
  ICLASS_AE_MULSF32X16_L2,
  ICLASS_AE_MULS32X16_L2,
  ICLASS_AE_MULSF32X16_L2_S2,
  ICLASS_AE_MULS32X16_L2_S2,
  ICLASS_AE_MULSF32X16_L3,
  ICLASS_AE_MULS32X16_L3,
  ICLASS_AE_MULSF32X16_L3_S2,
  ICLASS_AE_MULS32X16_L3_S2,
  ICLASS_AE_MULSF32X16_H0,
  ICLASS_AE_MULS32X16_H0,
  ICLASS_AE_MULSF32X16_H0_S2,
  ICLASS_AE_MULS32X16_H0_S2,
  ICLASS_AE_MULSF32X16_H1,
  ICLASS_AE_MULS32X16_H1,
  ICLASS_AE_MULSF32X16_H1_S2,
  ICLASS_AE_MULS32X16_H1_S2,
  ICLASS_AE_MULSF32X16_H2,
  ICLASS_AE_MULS32X16_H2,
  ICLASS_AE_MULSF32X16_H2_S2,
  ICLASS_AE_MULS32X16_H2_S2,
  ICLASS_AE_MULSF32X16_H3,
  ICLASS_AE_MULS32X16_H3,
  ICLASS_AE_MULSF32X16_H3_S2,
  ICLASS_AE_MULS32X16_H3_S2,
  ICLASS_AE_MULAAFD32X16_H3_L2,
  ICLASS_AE_MULAAD32X16_H3_L2,
  ICLASS_AE_MULAAFD32X16_H3_L2_S2,
  ICLASS_AE_MULAAD32X16_H3_L2_S2,
  ICLASS_AE_MULAAFD32X16_H1_L0,
  ICLASS_AE_MULAAD32X16_H1_L0,
  ICLASS_AE_MULAAFD32X16_H1_L0_S2,
  ICLASS_AE_MULAAD32X16_H1_L0_S2,
  ICLASS_AE_MULASFD32X16_H3_L2,
  ICLASS_AE_MULASD32X16_H3_L2,
  ICLASS_AE_MULASFD32X16_H3_L2_S2,
  ICLASS_AE_MULASD32X16_H3_L2_S2,
  ICLASS_AE_MULASFD32X16_H1_L0,
  ICLASS_AE_MULASD32X16_H1_L0,
  ICLASS_AE_MULASFD32X16_H1_L0_S2,
  ICLASS_AE_MULASD32X16_H1_L0_S2,
  ICLASS_AE_MULSAFD32X16_H3_L2,
  ICLASS_AE_MULSAD32X16_H3_L2,
  ICLASS_AE_MULSAFD32X16_H3_L2_S2,
  ICLASS_AE_MULSAD32X16_H3_L2_S2,
  ICLASS_AE_MULSAFD32X16_H1_L0,
  ICLASS_AE_MULSAD32X16_H1_L0,
  ICLASS_AE_MULSAFD32X16_H1_L0_S2,
  ICLASS_AE_MULSAD32X16_H1_L0_S2,
  ICLASS_AE_MULSSFD32X16_H3_L2,
  ICLASS_AE_MULSSD32X16_H3_L2,
  ICLASS_AE_MULSSFD32X16_H3_L2_S2,
  ICLASS_AE_MULSSD32X16_H3_L2_S2,
  ICLASS_AE_MULSSFD32X16_H1_L0,
  ICLASS_AE_MULSSD32X16_H1_L0,
  ICLASS_AE_MULSSFD32X16_H1_L0_S2,
  ICLASS_AE_MULSSD32X16_H1_L0_S2,
  ICLASS_AE_MULZAAFD32X16_H3_L2,
  ICLASS_AE_MULZAAD32X16_H3_L2,
  ICLASS_AE_MULZAAFD32X16_H3_L2_S2,
  ICLASS_AE_MULZAAD32X16_H3_L2_S2,
  ICLASS_AE_MULZAAFD32X16_H1_L0,
  ICLASS_AE_MULZAAD32X16_H1_L0,
  ICLASS_AE_MULZAAFD32X16_H1_L0_S2,
  ICLASS_AE_MULZAAD32X16_H1_L0_S2,
  ICLASS_AE_MULZASFD32X16_H3_L2,
  ICLASS_AE_MULZASD32X16_H3_L2,
  ICLASS_AE_MULZASFD32X16_H3_L2_S2,
  ICLASS_AE_MULZASD32X16_H3_L2_S2,
  ICLASS_AE_MULZASFD32X16_H1_L0,
  ICLASS_AE_MULZASD32X16_H1_L0,
  ICLASS_AE_MULZASFD32X16_H1_L0_S2,
  ICLASS_AE_MULZASD32X16_H1_L0_S2,
  ICLASS_AE_MULZSAFD32X16_H3_L2,
  ICLASS_AE_MULZSAD32X16_H3_L2,
  ICLASS_AE_MULZSAFD32X16_H3_L2_S2,
  ICLASS_AE_MULZSAD32X16_H3_L2_S2,
  ICLASS_AE_MULZSAFD32X16_H1_L0,
  ICLASS_AE_MULZSAD32X16_H1_L0,
  ICLASS_AE_MULZSAFD32X16_H1_L0_S2,
  ICLASS_AE_MULZSAD32X16_H1_L0_S2,
  ICLASS_AE_MULZSSFD32X16_H3_L2,
  ICLASS_AE_MULZSSD32X16_H3_L2,
  ICLASS_AE_MULZSSFD32X16_H3_L2_S2,
  ICLASS_AE_MULZSSD32X16_H3_L2_S2,
  ICLASS_AE_MULZSSFD32X16_H1_L0,
  ICLASS_AE_MULZSSD32X16_H1_L0,
  ICLASS_AE_MULZSSFD32X16_H1_L0_S2,
  ICLASS_AE_MULZSSD32X16_H1_L0_S2,
  ICLASS_AE_MULZAAFD32X16_H2_L3,
  ICLASS_AE_MULZAAFD32X16_H0_L1,
  ICLASS_AE_MULAAFD32X16_H2_L3,
  ICLASS_AE_MULAAFD32X16_H0_L1,
  ICLASS_AE_MULZAAD32X16_H2_L3,
  ICLASS_AE_MULZAAD32X16_H0_L1,
  ICLASS_AE_MULAAD32X16_H2_L3,
  ICLASS_AE_MULAAD32X16_H0_L1,
  ICLASS_AE_MULZAAFD32X16_H2_L3_S2,
  ICLASS_AE_MULZAAFD32X16_H0_L1_S2,
  ICLASS_AE_MULAAFD32X16_H2_L3_S2,
  ICLASS_AE_MULAAFD32X16_H0_L1_S2,
  ICLASS_AE_MULZAAD32X16_H2_L3_S2,
  ICLASS_AE_MULZAAD32X16_H0_L1_S2,
  ICLASS_AE_MULAAD32X16_H2_L3_S2,
  ICLASS_AE_MULAAD32X16_H0_L1_S2,
  ICLASS_AE_MULP32X16X2_H,
  ICLASS_AE_MULFP32X16X2RS_H,
  ICLASS_AE_MULFP32X16X2RAS_H,
  ICLASS_AE_MULFP32X16X2RS_H_S2,
  ICLASS_AE_MULFP32X16X2RAS_H_S2,
  ICLASS_AE_MULP32X16X2_L,
  ICLASS_AE_MULFP32X16X2RS_L,
  ICLASS_AE_MULFP32X16X2RAS_L,
  ICLASS_AE_MULFP32X16X2RS_L_S2,
  ICLASS_AE_MULFP32X16X2RAS_L_S2,
  ICLASS_AE_MULAP32X16X2_H,
  ICLASS_AE_MULAFP32X16X2RS_H,
  ICLASS_AE_MULAFP32X16X2RAS_H,
  ICLASS_AE_MULAFP32X16X2RS_H_S2,
  ICLASS_AE_MULAFP32X16X2RAS_H_S2,
  ICLASS_AE_MULAP32X16X2_L,
  ICLASS_AE_MULAFP32X16X2RS_L,
  ICLASS_AE_MULAFP32X16X2RAS_L,
  ICLASS_AE_MULAFP32X16X2RS_L_S2,
  ICLASS_AE_MULAFP32X16X2RAS_L_S2,
  ICLASS_AE_MULSP32X16X2_H,
  ICLASS_AE_MULSFP32X16X2RS_H,
  ICLASS_AE_MULSFP32X16X2RAS_H,
  ICLASS_AE_MULSFP32X16X2RS_H_S2,
  ICLASS_AE_MULSFP32X16X2RAS_H_S2,
  ICLASS_AE_MULSP32X16X2_L,
  ICLASS_AE_MULSFP32X16X2RS_L,
  ICLASS_AE_MULSFP32X16X2RAS_L,
  ICLASS_AE_MULSFP32X16X2RS_L_S2,
  ICLASS_AE_MULSFP32X16X2RAS_L_S2,
  ICLASS_AE_MULP32X2,
  ICLASS_AE_MULFP32X2RS,
  ICLASS_AE_MULFP32X2RAS,
  ICLASS_AE_MULAP32X2,
  ICLASS_AE_MULAFP32X2RS,
  ICLASS_AE_MULAFP32X2RAS,
  ICLASS_AE_MULSP32X2,
  ICLASS_AE_MULSFP32X2RS,
  ICLASS_AE_MULSFP32X2RAS,
  ICLASS_AE_MULFP16X4S,
  ICLASS_AE_MULFP16X4RAS,
  ICLASS_AE_MULC24,
  ICLASS_AE_MULFC24RA,
  ICLASS_AE_MULC32X16_L,
  ICLASS_AE_MULFC32X16RAS_L,
  ICLASS_AE_MULC32X16_H,
  ICLASS_AE_MULFC32X16RAS_H,
  ICLASS_AE_MULAC24,
  ICLASS_AE_MULAFC24RA,
  ICLASS_AE_MULAC32X16_L,
  ICLASS_AE_MULAFC32X16RAS_L,
  ICLASS_AE_MULAC32X16_H,
  ICLASS_AE_MULAFC32X16RAS_H,
  ICLASS_AE_MULF16X4SS,
  ICLASS_AE_MULAF16X4SS,
  ICLASS_AE_MULSF16X4SS,
  ICLASS_AE_MUL16X4,
  ICLASS_AE_MULA16X4,
  ICLASS_AE_MULS16X4,
  ICLASS_AE_MULFD24X2_FIR_H,
  ICLASS_AE_MULFD24X2_FIR_L,
  ICLASS_AE_MULFD32X16X2_FIR_HH,
  ICLASS_AE_MULFD32X16X2_FIR_HL,
  ICLASS_AE_MULFD32X16X2_FIR_LH,
  ICLASS_AE_MULFD32X16X2_FIR_LL,
  ICLASS_AE_MULAFD24X2_FIR_H,
  ICLASS_AE_MULAFD24X2_FIR_L,
  ICLASS_AE_MULAFD32X16X2_FIR_HH,
  ICLASS_AE_MULAFD32X16X2_FIR_HL,
  ICLASS_AE_MULAFD32X16X2_FIR_LH,
  ICLASS_AE_MULAFD32X16X2_FIR_LL,
  ICLASS_AE_DIV64D32_H,
  ICLASS_AE_DIV64D32_L,
  ICLASS_AE_SHA32,
  ICLASS_AE_VLDL32T,
  ICLASS_AE_VLDL16T,
  ICLASS_AE_VLDL16C,
  ICLASS_AE_VLDL16C_IP,
  ICLASS_AE_VLDL16C_IC,
  ICLASS_AE_VLDSHT,
  ICLASS_AE_LB,
  ICLASS_AE_LBI,
  ICLASS_AE_LBK,
  ICLASS_AE_LBKI,
  ICLASS_AE_LBS,
  ICLASS_AE_LBSI,
  ICLASS_AE_DB,
  ICLASS_AE_DBI,
  ICLASS_AE_DB_IC,
  ICLASS_AE_DBI_IC,
  ICLASS_AE_DB_IP,
  ICLASS_AE_DBI_IP,
  ICLASS_AE_VLEL32T,
  ICLASS_AE_VLEL16T,
  ICLASS_AE_SB,
  ICLASS_AE_SBI,
  ICLASS_AE_VLES16C,
  ICLASS_AE_SBF,
  ICLASS_AE_SB_IC,
  ICLASS_AE_SBI_IC,
  ICLASS_AE_VLES16C_IC,
  ICLASS_AE_SBF_IC,
  ICLASS_AE_SB_IP,
  ICLASS_AE_SBI_IP,
  ICLASS_AE_VLES16C_IP,
  ICLASS_AE_SBF_IP,
  ICLASS_AE_SEXT32,
  ICLASS_LSI,
  ICLASS_LSIP,
  ICLASS_LSX,
  ICLASS_LSXP,
  ICLASS_SSI,
  ICLASS_SSIP,
  ICLASS_SSX,
  ICLASS_SSXP,
  ICLASS_ABS_S,
  ICLASS_NEG_S,
  ICLASS_MOV_S,
  ICLASS_MOVEQZ_S,
  ICLASS_MOVNEZ_S,
  ICLASS_MOVLTZ_S,
  ICLASS_MOVGEZ_S,
  ICLASS_MOVF_S,
  ICLASS_MOVT_S,
  ICLASS_WFR,
  ICLASS_RFR,
  ICLASS_ROUND_S,
  ICLASS_CEIL_S,
  ICLASS_FLOOR_S,
  ICLASS_TRUNC_S,
  ICLASS_UTRUNC_S,
  ICLASS_FLOAT_S,
  ICLASS_UFLOAT_S,
  ICLASS_UN_S,
  ICLASS_ULT_S,
  ICLASS_ULE_S,
  ICLASS_UEQ_S,
  ICLASS_OLT_S,
  ICLASS_OLE_S,
  ICLASS_OEQ_S,
  ICLASS_ADD_S,
  ICLASS_SUB_S,
  ICLASS_MUL_S,
  ICLASS_MADD_S,
  ICLASS_MSUB_S,
  ICLASS_SQRT0_S,
  ICLASS_DIV0_S,
  ICLASS_RECIP0_S,
  ICLASS_RSQRT0_S,
  ICLASS_MADDN_S,
  ICLASS_DIVN_S,
  ICLASS_CONST_S,
  ICLASS_NEXP01_S,
  ICLASS_ADDEXP_S,
  ICLASS_ADDEXPM_S,
  ICLASS_MKDADJ_S,
  ICLASS_MKSADJ_S,
  ICLASS_xt_iclass_excw,
  ICLASS_xt_iclass_rfe,
  ICLASS_xt_iclass_rfde,
  ICLASS_xt_iclass_syscall,
  ICLASS_xt_iclass_call12,
  ICLASS_xt_iclass_call8,
  ICLASS_xt_iclass_call4,
  ICLASS_xt_iclass_callx12,
  ICLASS_xt_iclass_callx8,
  ICLASS_xt_iclass_callx4,
  ICLASS_xt_iclass_entry,
  ICLASS_xt_iclass_movsp,
  ICLASS_xt_iclass_rotw,
  ICLASS_xt_iclass_retw,
  ICLASS_xt_iclass_rfwou,
  ICLASS_xt_iclass_l32e,
  ICLASS_xt_iclass_s32e,
  ICLASS_xt_iclass_rsr_windowbase,
  ICLASS_xt_iclass_wsr_windowbase,
  ICLASS_xt_iclass_xsr_windowbase,
  ICLASS_xt_iclass_rsr_windowstart,
  ICLASS_xt_iclass_wsr_windowstart,
  ICLASS_xt_iclass_xsr_windowstart,
  ICLASS_xt_iclass_rfme,
  ICLASS_xt_iclass_rsr_mesr,
  ICLASS_xt_iclass_wsr_mesr,
  ICLASS_xt_iclass_xsr_mesr,
  ICLASS_xt_iclass_rsr_mecr,
  ICLASS_xt_iclass_wsr_mecr,
  ICLASS_xt_iclass_xsr_mecr,
  ICLASS_xt_iclass_rsr_mepc,
  ICLASS_xt_iclass_wsr_mepc,
  ICLASS_xt_iclass_xsr_mepc,
  ICLASS_xt_iclass_rsr_meps,
  ICLASS_xt_iclass_wsr_meps,
  ICLASS_xt_iclass_xsr_meps,
  ICLASS_xt_iclass_rsr_mesave,
  ICLASS_xt_iclass_wsr_mesave,
  ICLASS_xt_iclass_xsr_mesave,
  ICLASS_xt_iclass_rsr_mevaddr,
  ICLASS_xt_iclass_wsr_mevaddr,
  ICLASS_xt_iclass_xsr_mevaddr,
  ICLASS_xt_iclass_add_n,
  ICLASS_xt_iclass_addi_n,
  ICLASS_xt_iclass_bz6,
  ICLASS_xt_iclass_ill_n,
  ICLASS_xt_iclass_loadi4,
  ICLASS_xt_iclass_mov_n,
  ICLASS_xt_iclass_movi_n,
  ICLASS_xt_iclass_nopn,
  ICLASS_xt_iclass_retn,
  ICLASS_xt_iclass_storei4,
  ICLASS_rur_threadptr,
  ICLASS_wur_threadptr,
  ICLASS_xt_iclass_addi,
  ICLASS_xt_iclass_addmi,
  ICLASS_xt_iclass_addsub,
  ICLASS_xt_iclass_bit,
  ICLASS_xt_iclass_bsi8,
  ICLASS_xt_iclass_bsi8b,
  ICLASS_xt_iclass_bsi8u,
  ICLASS_xt_iclass_bst8,
  ICLASS_xt_iclass_bsz12,
  ICLASS_xt_iclass_call0,
  ICLASS_xt_iclass_callx0,
  ICLASS_xt_iclass_exti,
  ICLASS_xt_iclass_ill,
  ICLASS_xt_iclass_jump,
  ICLASS_xt_iclass_jumpx,
  ICLASS_xt_iclass_l16ui,
  ICLASS_xt_iclass_l16si,
  ICLASS_xt_iclass_l32i,
  ICLASS_xt_iclass_l32r,
  ICLASS_xt_iclass_l8i,
  ICLASS_xt_iclass_loop,
  ICLASS_xt_iclass_loopz,
  ICLASS_xt_iclass_movi,
  ICLASS_xt_iclass_movz,
  ICLASS_xt_iclass_neg,
  ICLASS_xt_iclass_nop,
  ICLASS_xt_iclass_return,
  ICLASS_xt_iclass_simcall,
  ICLASS_xt_iclass_s16i,
  ICLASS_xt_iclass_s32i,
  ICLASS_xt_iclass_s32nb,
  ICLASS_xt_iclass_s8i,
  ICLASS_xt_iclass_sar,
  ICLASS_xt_iclass_sari,
  ICLASS_xt_iclass_shifts,
  ICLASS_xt_iclass_shiftst,
  ICLASS_xt_iclass_shiftt,
  ICLASS_xt_iclass_slli,
  ICLASS_xt_iclass_srai,
  ICLASS_xt_iclass_srli,
  ICLASS_xt_iclass_memw,
  ICLASS_xt_iclass_extw,
  ICLASS_xt_iclass_isync,
  ICLASS_xt_iclass_sync,
  ICLASS_xt_iclass_rsil,
  ICLASS_xt_iclass_rsr_lend,
  ICLASS_xt_iclass_wsr_lend,
  ICLASS_xt_iclass_xsr_lend,
  ICLASS_xt_iclass_rsr_lcount,
  ICLASS_xt_iclass_wsr_lcount,
  ICLASS_xt_iclass_xsr_lcount,
  ICLASS_xt_iclass_rsr_lbeg,
  ICLASS_xt_iclass_wsr_lbeg,
  ICLASS_xt_iclass_xsr_lbeg,
  ICLASS_xt_iclass_rsr_sar,
  ICLASS_xt_iclass_wsr_sar,
  ICLASS_xt_iclass_xsr_sar,
  ICLASS_xt_iclass_rsr_memctl,
  ICLASS_xt_iclass_wsr_memctl,
  ICLASS_xt_iclass_xsr_memctl,
  ICLASS_xt_iclass_rsr_litbase,
  ICLASS_xt_iclass_wsr_litbase,
  ICLASS_xt_iclass_xsr_litbase,
  ICLASS_xt_iclass_rsr_configid0,
  ICLASS_xt_iclass_wsr_configid0,
  ICLASS_xt_iclass_rsr_configid1,
  ICLASS_xt_iclass_rsr_243,
  ICLASS_xt_iclass_rsr_ps,
  ICLASS_xt_iclass_wsr_ps,
  ICLASS_xt_iclass_xsr_ps,
  ICLASS_xt_iclass_rsr_epc1,
  ICLASS_xt_iclass_wsr_epc1,
  ICLASS_xt_iclass_xsr_epc1,
  ICLASS_xt_iclass_rsr_excsave1,
  ICLASS_xt_iclass_wsr_excsave1,
  ICLASS_xt_iclass_xsr_excsave1,
  ICLASS_xt_iclass_rsr_epc2,
  ICLASS_xt_iclass_wsr_epc2,
  ICLASS_xt_iclass_xsr_epc2,
  ICLASS_xt_iclass_rsr_excsave2,
  ICLASS_xt_iclass_wsr_excsave2,
  ICLASS_xt_iclass_xsr_excsave2,
  ICLASS_xt_iclass_rsr_epc3,
  ICLASS_xt_iclass_wsr_epc3,
  ICLASS_xt_iclass_xsr_epc3,
  ICLASS_xt_iclass_rsr_excsave3,
  ICLASS_xt_iclass_wsr_excsave3,
  ICLASS_xt_iclass_xsr_excsave3,
  ICLASS_xt_iclass_rsr_epc4,
  ICLASS_xt_iclass_wsr_epc4,
  ICLASS_xt_iclass_xsr_epc4,
  ICLASS_xt_iclass_rsr_excsave4,
  ICLASS_xt_iclass_wsr_excsave4,
  ICLASS_xt_iclass_xsr_excsave4,
  ICLASS_xt_iclass_rsr_epc5,
  ICLASS_xt_iclass_wsr_epc5,
  ICLASS_xt_iclass_xsr_epc5,
  ICLASS_xt_iclass_rsr_excsave5,
  ICLASS_xt_iclass_wsr_excsave5,
  ICLASS_xt_iclass_xsr_excsave5,
  ICLASS_xt_iclass_rsr_epc6,
  ICLASS_xt_iclass_wsr_epc6,
  ICLASS_xt_iclass_xsr_epc6,
  ICLASS_xt_iclass_rsr_excsave6,
  ICLASS_xt_iclass_wsr_excsave6,
  ICLASS_xt_iclass_xsr_excsave6,
  ICLASS_xt_iclass_rsr_epc7,
  ICLASS_xt_iclass_wsr_epc7,
  ICLASS_xt_iclass_xsr_epc7,
  ICLASS_xt_iclass_rsr_excsave7,
  ICLASS_xt_iclass_wsr_excsave7,
  ICLASS_xt_iclass_xsr_excsave7,
  ICLASS_xt_iclass_rsr_eps2,
  ICLASS_xt_iclass_wsr_eps2,
  ICLASS_xt_iclass_xsr_eps2,
  ICLASS_xt_iclass_rsr_eps3,
  ICLASS_xt_iclass_wsr_eps3,
  ICLASS_xt_iclass_xsr_eps3,
  ICLASS_xt_iclass_rsr_eps4,
  ICLASS_xt_iclass_wsr_eps4,
  ICLASS_xt_iclass_xsr_eps4,
  ICLASS_xt_iclass_rsr_eps5,
  ICLASS_xt_iclass_wsr_eps5,
  ICLASS_xt_iclass_xsr_eps5,
  ICLASS_xt_iclass_rsr_eps6,
  ICLASS_xt_iclass_wsr_eps6,
  ICLASS_xt_iclass_xsr_eps6,
  ICLASS_xt_iclass_rsr_eps7,
  ICLASS_xt_iclass_wsr_eps7,
  ICLASS_xt_iclass_xsr_eps7,
  ICLASS_xt_iclass_rsr_excvaddr,
  ICLASS_xt_iclass_wsr_excvaddr,
  ICLASS_xt_iclass_xsr_excvaddr,
  ICLASS_xt_iclass_rsr_depc,
  ICLASS_xt_iclass_wsr_depc,
  ICLASS_xt_iclass_xsr_depc,
  ICLASS_xt_iclass_rsr_exccause,
  ICLASS_xt_iclass_wsr_exccause,
  ICLASS_xt_iclass_xsr_exccause,
  ICLASS_xt_iclass_rsr_prid,
  ICLASS_xt_iclass_rsr_vecbase,
  ICLASS_xt_iclass_wsr_vecbase,
  ICLASS_xt_iclass_xsr_vecbase,
  ICLASS_xt_mul16,
  ICLASS_xt_mul32,
  ICLASS_xt_mul32h,
  ICLASS_xt_iclass_rfi,
  ICLASS_xt_iclass_wait,
  ICLASS_xt_iclass_rsr_interrupt,
  ICLASS_xt_iclass_wsr_intset,
  ICLASS_xt_iclass_wsr_intclear,
  ICLASS_xt_iclass_rsr_intenable,
  ICLASS_xt_iclass_wsr_intenable,
  ICLASS_xt_iclass_xsr_intenable,
  ICLASS_xt_iclass_break,
  ICLASS_xt_iclass_break_n,
  ICLASS_xt_iclass_rsr_dbreaka0,
  ICLASS_xt_iclass_wsr_dbreaka0,
  ICLASS_xt_iclass_xsr_dbreaka0,
  ICLASS_xt_iclass_rsr_dbreakc0,
  ICLASS_xt_iclass_wsr_dbreakc0,
  ICLASS_xt_iclass_xsr_dbreakc0,
  ICLASS_xt_iclass_rsr_dbreaka1,
  ICLASS_xt_iclass_wsr_dbreaka1,
  ICLASS_xt_iclass_xsr_dbreaka1,
  ICLASS_xt_iclass_rsr_dbreakc1,
  ICLASS_xt_iclass_wsr_dbreakc1,
  ICLASS_xt_iclass_xsr_dbreakc1,
  ICLASS_xt_iclass_rsr_ibreaka0,
  ICLASS_xt_iclass_wsr_ibreaka0,
  ICLASS_xt_iclass_xsr_ibreaka0,
  ICLASS_xt_iclass_rsr_ibreaka1,
  ICLASS_xt_iclass_wsr_ibreaka1,
  ICLASS_xt_iclass_xsr_ibreaka1,
  ICLASS_xt_iclass_rsr_ibreakenable,
  ICLASS_xt_iclass_wsr_ibreakenable,
  ICLASS_xt_iclass_xsr_ibreakenable,
  ICLASS_xt_iclass_rsr_debugcause,
  ICLASS_xt_iclass_wsr_debugcause,
  ICLASS_xt_iclass_xsr_debugcause,
  ICLASS_xt_iclass_rsr_icount,
  ICLASS_xt_iclass_wsr_icount,
  ICLASS_xt_iclass_xsr_icount,
  ICLASS_xt_iclass_rsr_icountlevel,
  ICLASS_xt_iclass_wsr_icountlevel,
  ICLASS_xt_iclass_xsr_icountlevel,
  ICLASS_xt_iclass_rsr_ddr,
  ICLASS_xt_iclass_wsr_ddr,
  ICLASS_xt_iclass_xsr_ddr,
  ICLASS_xt_iclass_lddr32_p,
  ICLASS_xt_iclass_sddr32_p,
  ICLASS_xt_iclass_rfdo,
  ICLASS_xt_iclass_rfdd,
  ICLASS_xt_iclass_wsr_mmid,
  ICLASS_xt_iclass_bbool1,
  ICLASS_xt_iclass_bbool4,
  ICLASS_xt_iclass_bbool8,
  ICLASS_xt_iclass_bbranch,
  ICLASS_xt_iclass_bmove,
  ICLASS_xt_iclass_RSR_BR,
  ICLASS_xt_iclass_WSR_BR,
  ICLASS_xt_iclass_XSR_BR,
  ICLASS_xt_iclass_rsr_ccount,
  ICLASS_xt_iclass_wsr_ccount,
  ICLASS_xt_iclass_xsr_ccount,
  ICLASS_xt_iclass_rsr_ccompare0,
  ICLASS_xt_iclass_wsr_ccompare0,
  ICLASS_xt_iclass_xsr_ccompare0,
  ICLASS_xt_iclass_rsr_ccompare1,
  ICLASS_xt_iclass_wsr_ccompare1,
  ICLASS_xt_iclass_xsr_ccompare1,
  ICLASS_xt_iclass_rsr_ccompare2,
  ICLASS_xt_iclass_wsr_ccompare2,
  ICLASS_xt_iclass_xsr_ccompare2,
  ICLASS_xt_iclass_icache,
  ICLASS_xt_iclass_icache_lock,
  ICLASS_xt_iclass_icache_inv,
  ICLASS_xt_iclass_licx,
  ICLASS_xt_iclass_sicx,
  ICLASS_xt_iclass_dcache,
  ICLASS_xt_iclass_dcache_dyn,
  ICLASS_xt_iclass_dcache_ind,
  ICLASS_xt_iclass_dcache_inv,
  ICLASS_xt_iclass_dpf,
  ICLASS_xt_iclass_dcache_lock,
  ICLASS_xt_iclass_sdct,
  ICLASS_xt_iclass_ldct,
  ICLASS_xt_iclass_rsr_prefctl,
  ICLASS_xt_iclass_wsr_prefctl,
  ICLASS_xt_iclass_xsr_prefctl,
  ICLASS_xt_iclass_idtlb,
  ICLASS_xt_iclass_rdtlb,
  ICLASS_xt_iclass_wdtlb,
  ICLASS_xt_iclass_iitlb,
  ICLASS_xt_iclass_ritlb,
  ICLASS_xt_iclass_witlb,
  ICLASS_xt_iclass_rsr_cpenable,
  ICLASS_xt_iclass_wsr_cpenable,
  ICLASS_xt_iclass_xsr_cpenable,
  ICLASS_xt_iclass_clamp,
  ICLASS_xt_iclass_minmax,
  ICLASS_xt_iclass_nsa,
  ICLASS_xt_iclass_sx,
  ICLASS_xt_iclass_l32ai,
  ICLASS_xt_iclass_s32ri,
  ICLASS_xt_iclass_s32c1i,
  ICLASS_xt_iclass_rsr_scompare1,
  ICLASS_xt_iclass_wsr_scompare1,
  ICLASS_xt_iclass_xsr_scompare1,
  ICLASS_xt_iclass_rsr_atomctl,
  ICLASS_xt_iclass_wsr_atomctl,
  ICLASS_xt_iclass_xsr_atomctl,
  ICLASS_xt_iclass_div,
  ICLASS_xt_iclass_rer,
  ICLASS_xt_iclass_wer,
  ICLASS_xt_iclass_wb18_0,
  ICLASS_xt_iclass_wb18_1,
  ICLASS_xt_iclass_wb18_2,
  ICLASS_xt_iclass_wb18_3,
  ICLASS_xt_iclass_wb18_4,
  ICLASS_rur_ae_ovf_sar,
  ICLASS_wur_ae_ovf_sar,
  ICLASS_rur_ae_bithead,
  ICLASS_wur_ae_bithead,
  ICLASS_rur_ae_ts_fts_bu_bp,
  ICLASS_wur_ae_ts_fts_bu_bp,
  ICLASS_rur_ae_cw_sd_no,
  ICLASS_wur_ae_cw_sd_no,
  ICLASS_rur_ae_cbegin0,
  ICLASS_wur_ae_cbegin0,
  ICLASS_rur_ae_cend0,
  ICLASS_wur_ae_cend0,
  ICLASS_rur_fcr,
  ICLASS_wur_fcr,
  ICLASS_rur_fsr,
  ICLASS_wur_fsr
};


/*  Opcode encodings.  */

static void
Opcode_rur_ae_overflow_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67ea04;
}

static void
Opcode_wur_ae_overflow_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67eb04;
}

static void
Opcode_rur_ae_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67ec04;
}

static void
Opcode_wur_ae_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67ed04;
}

static void
Opcode_rur_ae_bitptr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67ee04;
}

static void
Opcode_wur_ae_bitptr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67ef04;
}

static void
Opcode_rur_ae_bitsused_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67f004;
}

static void
Opcode_wur_ae_bitsused_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67f104;
}

static void
Opcode_rur_ae_tablesize_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67f204;
}

static void
Opcode_wur_ae_tablesize_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67f304;
}

static void
Opcode_rur_ae_first_ts_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67f404;
}

static void
Opcode_wur_ae_first_ts_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67f504;
}

static void
Opcode_rur_ae_nextoffset_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67f604;
}

static void
Opcode_wur_ae_nextoffset_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67f704;
}

static void
Opcode_rur_ae_searchdone_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67f804;
}

static void
Opcode_wur_ae_searchdone_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67f904;
}

static void
Opcode_rur_ae_cwrap_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67fa04;
}

static void
Opcode_wur_ae_cwrap_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67fb04;
}

static void
Opcode_ae_l16m_xc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x63000;
}

static void
Opcode_ae_l16m_xc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800e8000;
}

static void
Opcode_ae_l16m_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb10004;
}

static void
Opcode_ae_l16m_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa4000;
}

static void
Opcode_ae_l16m_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80160000;
}

static void
Opcode_ae_l16m_i_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_ae_l16m_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb20004;
}

static void
Opcode_ae_l16m_iu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa5000;
}

static void
Opcode_ae_l16m_iu_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80160040;
}

static void
Opcode_ae_l16m_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x62000;
}

static void
Opcode_ae_l16m_x_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800e7000;
}

static void
Opcode_ae_l16m_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb30004;
}

static void
Opcode_ae_l16m_xu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x64000;
}

static void
Opcode_ae_l16m_xu_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800e9000;
}

static void
Opcode_ae_l16_xc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6c000;
}

static void
Opcode_ae_l16_xc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800f1000;
}

static void
Opcode_ae_l16_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb00004;
}

static void
Opcode_ae_l16_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa8000;
}

static void
Opcode_ae_l16_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80160050;
}

static void
Opcode_ae_l16_i_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2000;
}

static void
Opcode_ae_l16_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb40004;
}

static void
Opcode_ae_l16_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa9000;
}

static void
Opcode_ae_l16_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80160030;
}

static void
Opcode_ae_l16_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6b000;
}

static void
Opcode_ae_l16_x_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800f0000;
}

static void
Opcode_ae_l16_xp_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6d000;
}

static void
Opcode_ae_l16_xp_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800f2000;
}

static void
Opcode_ae_l32f24_xc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb50004;
}

static void
Opcode_ae_l32f24_xc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6f000;
}

static void
Opcode_ae_l32f24_xc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800f4000;
}

static void
Opcode_ae_l32f24_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb60004;
}

static void
Opcode_ae_l32f24_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xaa000;
}

static void
Opcode_ae_l32f24_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80160070;
}

static void
Opcode_ae_l32f24_i_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3000;
}

static void
Opcode_ae_l32f24_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb70004;
}

static void
Opcode_ae_l32f24_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xab000;
}

static void
Opcode_ae_l32f24_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80168000;
}

static void
Opcode_ae_l32f24_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6e000;
}

static void
Opcode_ae_l32f24_x_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800f3000;
}

static void
Opcode_ae_l32f24_xp_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70000;
}

static void
Opcode_ae_l32f24_xp_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800f5000;
}

static void
Opcode_ae_l32_xc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbc0004;
}

static void
Opcode_ae_l32_xc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7b000;
}

static void
Opcode_ae_l32_xc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80100000;
}

static void
Opcode_ae_l32_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbd0004;
}

static void
Opcode_ae_l32_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xae000;
}

static void
Opcode_ae_l32_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80168050;
}

static void
Opcode_ae_l32_i_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7000;
}

static void
Opcode_ae_l32_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbe0004;
}

static void
Opcode_ae_l32_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xaf000;
}

static void
Opcode_ae_l32_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80168030;
}

static void
Opcode_ae_l32_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbf0004;
}

static void
Opcode_ae_l32_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7a000;
}

static void
Opcode_ae_l32_x_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800ff000;
}

static void
Opcode_ae_l32_xp_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7c000;
}

static void
Opcode_ae_l32_xp_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80101000;
}

static void
Opcode_ae_l32m_xc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x72000;
}

static void
Opcode_ae_l32m_xc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800f7000;
}

static void
Opcode_ae_l32m_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc80004;
}

static void
Opcode_ae_l32m_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xac000;
}

static void
Opcode_ae_l32m_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80168040;
}

static void
Opcode_ae_l32m_i_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000;
}

static void
Opcode_ae_l32m_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc90004;
}

static void
Opcode_ae_l32m_iu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xad000;
}

static void
Opcode_ae_l32m_iu_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80168020;
}

static void
Opcode_ae_l32m_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xca0004;
}

static void
Opcode_ae_l32m_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x71000;
}

static void
Opcode_ae_l32m_x_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800f6000;
}

static void
Opcode_ae_l32m_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcb0004;
}

static void
Opcode_ae_l32m_xu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73000;
}

static void
Opcode_ae_l32m_xu_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800f8000;
}

static void
Opcode_ae_l16x2m_xc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x66000;
}

static void
Opcode_ae_l16x2m_xc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800eb000;
}

static void
Opcode_ae_l16x2m_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb80004;
}

static void
Opcode_ae_l16x2m_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa6000;
}

static void
Opcode_ae_l16x2m_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80160020;
}

static void
Opcode_ae_l16x2m_i_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1000;
}

static void
Opcode_ae_l16x2m_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb90004;
}

static void
Opcode_ae_l16x2m_iu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa7000;
}

static void
Opcode_ae_l16x2m_iu_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80160060;
}

static void
Opcode_ae_l16x2m_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0004;
}

static void
Opcode_ae_l16x2m_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x65000;
}

static void
Opcode_ae_l16x2m_x_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800ea000;
}

static void
Opcode_ae_l16x2m_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbb0004;
}

static void
Opcode_ae_l16x2m_xu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67000;
}

static void
Opcode_ae_l16x2m_xu_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800ec000;
}

static void
Opcode_ae_l32x2f24_xc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc40004;
}

static void
Opcode_ae_l32x2f24_xc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x75000;
}

static void
Opcode_ae_l32x2f24_xc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800fa000;
}

static void
Opcode_ae_l32x2f24_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc50004;
}

static void
Opcode_ae_l32x2f24_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0040;
}

static void
Opcode_ae_l32x2f24_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80168060;
}

static void
Opcode_ae_l32x2f24_i_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5000;
}

static void
Opcode_ae_l32x2f24_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2c0084;
}

static void
Opcode_ae_l32x2f24_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc080;
}

static void
Opcode_ae_l32x2f24_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80180070;
}

static void
Opcode_ae_l32x2f24_rip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d0024;
}

static void
Opcode_ae_l32x2f24_rip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd90e0;
}

static void
Opcode_ae_l32x2f24_rip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018a020;
}

static void
Opcode_ae_l32x2f24_ric_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd90a0;
}

static void
Opcode_ae_l32x2f24_ric_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80189060;
}

static void
Opcode_ae_l32x2f24_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc60004;
}

static void
Opcode_ae_l32x2f24_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x74000;
}

static void
Opcode_ae_l32x2f24_x_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800f9000;
}

static void
Opcode_ae_l32x2f24_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc70004;
}

static void
Opcode_ae_l32x2f24_xp_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x76000;
}

static void
Opcode_ae_l32x2f24_xp_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800fb000;
}

static void
Opcode_ae_l32x2_xc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc00004;
}

static void
Opcode_ae_l32x2_xc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x78000;
}

static void
Opcode_ae_l32x2_xc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800fd000;
}

static void
Opcode_ae_l32x2_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc10004;
}

static void
Opcode_ae_l32x2_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0020;
}

static void
Opcode_ae_l32x2_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80168010;
}

static void
Opcode_ae_l32x2_i_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6000;
}

static void
Opcode_ae_l32x2_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e0084;
}

static void
Opcode_ae_l32x2_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd000;
}

static void
Opcode_ae_l32x2_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801800b0;
}

static void
Opcode_ae_l32x2_rip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d0014;
}

static void
Opcode_ae_l32x2_rip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd9030;
}

static void
Opcode_ae_l32x2_rip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018b020;
}

static void
Opcode_ae_l32x2_ric_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd9010;
}

static void
Opcode_ae_l32x2_ric_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018a060;
}

static void
Opcode_ae_l32x2_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc20004;
}

static void
Opcode_ae_l32x2_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x77000;
}

static void
Opcode_ae_l32x2_x_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800fc000;
}

static void
Opcode_ae_l32x2_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc30004;
}

static void
Opcode_ae_l32x2_xp_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x79000;
}

static void
Opcode_ae_l32x2_xp_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800fe000;
}

static void
Opcode_ae_l16x4_xc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x69000;
}

static void
Opcode_ae_l16x4_xc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800ee000;
}

static void
Opcode_ae_l16x4_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc0004;
}

static void
Opcode_ae_l16x4_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0000;
}

static void
Opcode_ae_l16x4_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80160010;
}

static void
Opcode_ae_l16x4_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x900084;
}

static void
Opcode_ae_l16x4_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc000;
}

static void
Opcode_ae_l16x4_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80180030;
}

static void
Opcode_ae_l16x4_rip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd9060;
}

static void
Opcode_ae_l16x4_rip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80189020;
}

static void
Opcode_ae_l16x4_ric_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd9020;
}

static void
Opcode_ae_l16x4_ric_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80188060;
}

static void
Opcode_ae_l16x4_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x68000;
}

static void
Opcode_ae_l16x4_x_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800ed000;
}

static void
Opcode_ae_l16x4_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd0004;
}

static void
Opcode_ae_l16x4_xp_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a000;
}

static void
Opcode_ae_l16x4_xp_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800ef000;
}

static void
Opcode_ae_l64_xc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7e000;
}

static void
Opcode_ae_l64_xc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80103000;
}

static void
Opcode_ae_l64_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf0004;
}

static void
Opcode_ae_l64_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0060;
}

static void
Opcode_ae_l64_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80168070;
}

static void
Opcode_ae_l64_i_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8000;
}

static void
Opcode_ae_l64_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc4000;
}

static void
Opcode_ae_l64_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80170000;
}

static void
Opcode_ae_l64_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7d000;
}

static void
Opcode_ae_l64_x_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80102000;
}

static void
Opcode_ae_l64_xp_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7f000;
}

static void
Opcode_ae_l64_xp_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80104000;
}

static void
Opcode_ae_s16x2m_xc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x84000;
}

static void
Opcode_ae_s16x2m_xc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80109000;
}

static void
Opcode_ae_s16x2m_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd80004;
}

static void
Opcode_ae_s16x2m_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb2000;
}

static void
Opcode_ae_s16x2m_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80170060;
}

static void
Opcode_ae_s16x2m_i_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa000;
}

static void
Opcode_ae_s16x2m_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd90004;
}

static void
Opcode_ae_s16x2m_iu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb3000;
}

static void
Opcode_ae_s16x2m_iu_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80170010;
}

static void
Opcode_ae_s16x2m_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda0004;
}

static void
Opcode_ae_s16x2m_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x83000;
}

static void
Opcode_ae_s16x2m_x_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80108000;
}

static void
Opcode_ae_s16x2m_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb0004;
}

static void
Opcode_ae_s16x2m_xu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x85000;
}

static void
Opcode_ae_s16x2m_xu_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8010a000;
}

static void
Opcode_ae_s32x2f24_xc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xec0004;
}

static void
Opcode_ae_s32x2f24_xc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x99000;
}

static void
Opcode_ae_s32x2f24_xc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8011e000;
}

static void
Opcode_ae_s32x2f24_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xed0004;
}

static void
Opcode_ae_s32x2f24_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc4020;
}

static void
Opcode_ae_s32x2f24_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80180000;
}

static void
Opcode_ae_s32x2f24_i_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10000;
}

static void
Opcode_ae_s32x2f24_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x620084;
}

static void
Opcode_ae_s32x2f24_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce000;
}

static void
Opcode_ae_s32x2f24_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80188000;
}

static void
Opcode_ae_s32x2f24_rip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd90b0;
}

static void
Opcode_ae_s32x2f24_rip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018d020;
}

static void
Opcode_ae_s32x2f24_ric_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd9090;
}

static void
Opcode_ae_s32x2f24_ric_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018c060;
}

static void
Opcode_ae_s32x2f24_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xee0004;
}

static void
Opcode_ae_s32x2f24_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x98000;
}

static void
Opcode_ae_s32x2f24_x_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8011d000;
}

static void
Opcode_ae_s32x2f24_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xef0004;
}

static void
Opcode_ae_s32x2f24_xp_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9a000;
}

static void
Opcode_ae_s32x2f24_xp_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8011f000;
}

static void
Opcode_ae_s32x2_xc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe80004;
}

static void
Opcode_ae_s32x2_xc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9c000;
}

static void
Opcode_ae_s32x2_xc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80121000;
}

static void
Opcode_ae_s32x2_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe90004;
}

static void
Opcode_ae_s32x2_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc4060;
}

static void
Opcode_ae_s32x2_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80180040;
}

static void
Opcode_ae_s32x2_i_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x11000;
}

static void
Opcode_ae_s32x2_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x620004;
}

static void
Opcode_ae_s32x2_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce080;
}

static void
Opcode_ae_s32x2_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80188040;
}

static void
Opcode_ae_s32x2_rip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd90f0;
}

static void
Opcode_ae_s32x2_rip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018e020;
}

static void
Opcode_ae_s32x2_ric_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd90d0;
}

static void
Opcode_ae_s32x2_ric_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018d060;
}

static void
Opcode_ae_s32x2_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea0004;
}

static void
Opcode_ae_s32x2_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9b000;
}

static void
Opcode_ae_s32x2_x_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80120000;
}

static void
Opcode_ae_s32x2_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xeb0004;
}

static void
Opcode_ae_s32x2_xp_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9d000;
}

static void
Opcode_ae_s32x2_xp_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80122000;
}

static void
Opcode_ae_s16x4_xc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x87000;
}

static void
Opcode_ae_s16x4_xc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8010c000;
}

static void
Opcode_ae_s16x4_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc0004;
}

static void
Opcode_ae_s16x4_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc4040;
}

static void
Opcode_ae_s16x4_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80170050;
}

static void
Opcode_ae_s16x4_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800084;
}

static void
Opcode_ae_s16x4_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd080;
}

static void
Opcode_ae_s16x4_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801800f0;
}

static void
Opcode_ae_s16x4_rip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd9070;
}

static void
Opcode_ae_s16x4_rip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018c020;
}

static void
Opcode_ae_s16x4_ric_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd9050;
}

static void
Opcode_ae_s16x4_ric_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018b060;
}

static void
Opcode_ae_s16x4_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x86000;
}

static void
Opcode_ae_s16x4_x_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8010b000;
}

static void
Opcode_ae_s16x4_xp_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x88000;
}

static void
Opcode_ae_s16x4_xp_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8010d000;
}

static void
Opcode_ae_s16m_l_xc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x81000;
}

static void
Opcode_ae_s16m_l_xc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80106000;
}

static void
Opcode_ae_s16m_l_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd50004;
}

static void
Opcode_ae_s16m_l_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb0000;
}

static void
Opcode_ae_s16m_l_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80170040;
}

static void
Opcode_ae_s16m_l_i_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9000;
}

static void
Opcode_ae_s16m_l_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd60004;
}

static void
Opcode_ae_s16m_l_iu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb1000;
}

static void
Opcode_ae_s16m_l_iu_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80170020;
}

static void
Opcode_ae_s16m_l_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd70004;
}

static void
Opcode_ae_s16m_l_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80000;
}

static void
Opcode_ae_s16m_l_x_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80105000;
}

static void
Opcode_ae_s16m_l_xu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x82000;
}

static void
Opcode_ae_s16m_l_xu_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80107000;
}

static void
Opcode_ae_s32f24_l_xc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90000;
}

static void
Opcode_ae_s32f24_l_xc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80115000;
}

static void
Opcode_ae_s32f24_l_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xde0004;
}

static void
Opcode_ae_s32f24_l_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb8000;
}

static void
Opcode_ae_s32f24_l_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80178020;
}

static void
Opcode_ae_s32f24_l_i_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd000;
}

static void
Opcode_ae_s32f24_l_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdf0004;
}

static void
Opcode_ae_s32f24_l_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9000;
}

static void
Opcode_ae_s32f24_l_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80178060;
}

static void
Opcode_ae_s32f24_l_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8f000;
}

static void
Opcode_ae_s32f24_l_x_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80114000;
}

static void
Opcode_ae_s32f24_l_xp_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x91000;
}

static void
Opcode_ae_s32f24_l_xp_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80116000;
}

static void
Opcode_ae_s32_l_xc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9f000;
}

static void
Opcode_ae_s32_l_xc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80124000;
}

static void
Opcode_ae_s32_l_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe00004;
}

static void
Opcode_ae_s32_l_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbe000;
}

static void
Opcode_ae_s32_l_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80180020;
}

static void
Opcode_ae_s32_l_i_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x12000;
}

static void
Opcode_ae_s32_l_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe10004;
}

static void
Opcode_ae_s32_l_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbf000;
}

static void
Opcode_ae_s32_l_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80180060;
}

static void
Opcode_ae_s32_l_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe20004;
}

static void
Opcode_ae_s32_l_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9e000;
}

static void
Opcode_ae_s32_l_x_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80123000;
}

static void
Opcode_ae_s32_l_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe30004;
}

static void
Opcode_ae_s32_l_xp_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0000;
}

static void
Opcode_ae_s32_l_xp_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80125000;
}

static void
Opcode_ae_s16_0_xc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8a000;
}

static void
Opcode_ae_s16_0_xc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8010f000;
}

static void
Opcode_ae_s16_0_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd20004;
}

static void
Opcode_ae_s16_0_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb4000;
}

static void
Opcode_ae_s16_0_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80170030;
}

static void
Opcode_ae_s16_0_i_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb000;
}

static void
Opcode_ae_s16_0_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd30004;
}

static void
Opcode_ae_s16_0_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb5000;
}

static void
Opcode_ae_s16_0_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80170070;
}

static void
Opcode_ae_s16_0_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x89000;
}

static void
Opcode_ae_s16_0_x_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8010e000;
}

static void
Opcode_ae_s16_0_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd40004;
}

static void
Opcode_ae_s16_0_xp_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8b000;
}

static void
Opcode_ae_s16_0_xp_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80110000;
}

static void
Opcode_ae_s64_xc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa2000;
}

static void
Opcode_ae_s64_xc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80127000;
}

static void
Opcode_ae_s64_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10004;
}

static void
Opcode_ae_s64_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc8000;
}

static void
Opcode_ae_s64_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80180010;
}

static void
Opcode_ae_s64_i_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13000;
}

static void
Opcode_ae_s64_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20004;
}

static void
Opcode_ae_s64_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc8040;
}

static void
Opcode_ae_s64_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80180050;
}

static void
Opcode_ae_s64_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa1000;
}

static void
Opcode_ae_s64_x_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80126000;
}

static void
Opcode_ae_s64_xp_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa3000;
}

static void
Opcode_ae_s64_xp_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80128000;
}

static void
Opcode_ae_s32m_xc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x93000;
}

static void
Opcode_ae_s32m_xc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80118000;
}

static void
Opcode_ae_s32m_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe40004;
}

static void
Opcode_ae_s32m_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba000;
}

static void
Opcode_ae_s32m_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80178010;
}

static void
Opcode_ae_s32m_i_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe000;
}

static void
Opcode_ae_s32m_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe50004;
}

static void
Opcode_ae_s32m_iu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbb000;
}

static void
Opcode_ae_s32m_iu_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80178050;
}

static void
Opcode_ae_s32m_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe60004;
}

static void
Opcode_ae_s32m_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x92000;
}

static void
Opcode_ae_s32m_x_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80117000;
}

static void
Opcode_ae_s32m_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe70004;
}

static void
Opcode_ae_s32m_xu_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x94000;
}

static void
Opcode_ae_s32m_xu_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80119000;
}

static void
Opcode_ae_zalign64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x281304;
}

static void
Opcode_ae_zalign64_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdd294;
}

static void
Opcode_ae_zalign64_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a3994;
}

static void
Opcode_ae_lalign64_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc000;
}

static void
Opcode_ae_lalign64_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190700;
}

static void
Opcode_ae_salign64_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc100;
}

static void
Opcode_ae_salign64_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190710;
}

static void
Opcode_ae_movalign_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x280304;
}

static void
Opcode_ae_movalign_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdd290;
}

static void
Opcode_ae_movalign_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a3990;
}

static void
Opcode_ae_la64_pp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7720c4;
}

static void
Opcode_ae_la64_pp_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdd200;
}

static void
Opcode_ae_la64_pp_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a3900;
}

static void
Opcode_ae_la24pos_pc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc290;
}

static void
Opcode_ae_la24pos_pc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a3190;
}

static void
Opcode_ae_la24x2pos_pc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc310;
}

static void
Opcode_ae_la24x2pos_pc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a3510;
}

static void
Opcode_ae_la32x2pos_pc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7710c4;
}

static void
Opcode_ae_la32x2pos_pc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc390;
}

static void
Opcode_ae_la32x2pos_pc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a3590;
}

static void
Opcode_ae_la16x4pos_pc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc210;
}

static void
Opcode_ae_la16x4pos_pc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a3110;
}

static void
Opcode_ae_la24neg_pc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc280;
}

static void
Opcode_ae_la24neg_pc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a3180;
}

static void
Opcode_ae_la24x2neg_pc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc300;
}

static void
Opcode_ae_la24x2neg_pc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a3500;
}

static void
Opcode_ae_la32x2neg_pc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc380;
}

static void
Opcode_ae_la32x2neg_pc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a3580;
}

static void
Opcode_ae_la16x4neg_pc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc200;
}

static void
Opcode_ae_la16x4neg_pc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a3100;
}

static void
Opcode_ae_sa64pos_fp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7730c4;
}

static void
Opcode_ae_sa64pos_fp_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdd280;
}

static void
Opcode_ae_sa64pos_fp_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a3980;
}

static void
Opcode_ae_sa64neg_fp_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdd210;
}

static void
Opcode_ae_sa64neg_fp_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a3910;
}

static void
Opcode_ae_la32x2_ic_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0084;
}

static void
Opcode_ae_la32x2_ic_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd3000;
}

static void
Opcode_ae_la32x2_ic_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a9000;
}

static void
Opcode_ae_la32x2_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00c4;
}

static void
Opcode_ae_la32x2_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd3080;
}

static void
Opcode_ae_la32x2_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a9080;
}

static void
Opcode_ae_la32x2_rip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd3090;
}

static void
Opcode_ae_la32x2_rip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a9090;
}

static void
Opcode_ae_la32x2_ric_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd3010;
}

static void
Opcode_ae_la32x2_ric_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a9010;
}

static void
Opcode_ae_la16x4_ic_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x370084;
}

static void
Opcode_ae_la16x4_ic_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf000;
}

static void
Opcode_ae_la16x4_ic_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a0010;
}

static void
Opcode_ae_la16x4_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3700c4;
}

static void
Opcode_ae_la16x4_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf080;
}

static void
Opcode_ae_la16x4_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a0090;
}

static void
Opcode_ae_la16x4_rip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x350084;
}

static void
Opcode_ae_la16x4_rip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf090;
}

static void
Opcode_ae_la16x4_rip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a8090;
}

static void
Opcode_ae_la16x4_ric_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf010;
}

static void
Opcode_ae_la16x4_ric_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a8010;
}

static void
Opcode_ae_la32x2f24_ic_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0004;
}

static void
Opcode_ae_la32x2f24_ic_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd2000;
}

static void
Opcode_ae_la32x2f24_ic_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a1000;
}

static void
Opcode_ae_la32x2f24_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0044;
}

static void
Opcode_ae_la32x2f24_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd2080;
}

static void
Opcode_ae_la32x2f24_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a1080;
}

static void
Opcode_ae_la32x2f24_rip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd2090;
}

static void
Opcode_ae_la32x2f24_rip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a1090;
}

static void
Opcode_ae_la32x2f24_ric_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd2010;
}

static void
Opcode_ae_la32x2f24_ric_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a1010;
}

static void
Opcode_ae_la24_ic_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd1000;
}

static void
Opcode_ae_la24_ic_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018c080;
}

static void
Opcode_ae_la24_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd1080;
}

static void
Opcode_ae_la24_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018d080;
}

static void
Opcode_ae_la24_rip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd1090;
}

static void
Opcode_ae_la24_rip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018f080;
}

static void
Opcode_ae_la24_ric_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd1010;
}

static void
Opcode_ae_la24_ric_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018e080;
}

static void
Opcode_ae_la24x2_ic_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0004;
}

static void
Opcode_ae_la24x2_ic_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0000;
}

static void
Opcode_ae_la24x2_ic_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80188080;
}

static void
Opcode_ae_la24x2_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0044;
}

static void
Opcode_ae_la24x2_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0080;
}

static void
Opcode_ae_la24x2_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80189080;
}

static void
Opcode_ae_la24x2_rip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0090;
}

static void
Opcode_ae_la24x2_rip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018b080;
}

static void
Opcode_ae_la24x2_ric_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0010;
}

static void
Opcode_ae_la24x2_ric_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018a080;
}

static void
Opcode_ae_sa32x2_ic_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd8000;
}

static void
Opcode_ae_sa32x2_ic_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a2000;
}

static void
Opcode_ae_sa32x2_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc00c4;
}

static void
Opcode_ae_sa32x2_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd8080;
}

static void
Opcode_ae_sa32x2_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a2080;
}

static void
Opcode_ae_sa32x2_rip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd8090;
}

static void
Opcode_ae_sa32x2_rip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a2090;
}

static void
Opcode_ae_sa32x2_ric_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd8010;
}

static void
Opcode_ae_sa32x2_ric_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a2010;
}

static void
Opcode_ae_sa16x4_ic_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd4000;
}

static void
Opcode_ae_sa16x4_ic_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80188010;
}

static void
Opcode_ae_sa16x4_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0084;
}

static void
Opcode_ae_sa16x4_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd4080;
}

static void
Opcode_ae_sa16x4_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80188090;
}

static void
Opcode_ae_sa16x4_rip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd4090;
}

static void
Opcode_ae_sa16x4_rip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80189090;
}

static void
Opcode_ae_sa16x4_ric_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd4010;
}

static void
Opcode_ae_sa16x4_ric_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80189010;
}

static void
Opcode_ae_sa32x2f24_ic_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd7000;
}

static void
Opcode_ae_sa32x2f24_ic_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018e010;
}

static void
Opcode_ae_sa32x2f24_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f00c4;
}

static void
Opcode_ae_sa32x2f24_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd7080;
}

static void
Opcode_ae_sa32x2f24_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018e090;
}

static void
Opcode_ae_sa32x2f24_rip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd7090;
}

static void
Opcode_ae_sa32x2f24_rip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018f090;
}

static void
Opcode_ae_sa32x2f24_ric_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd7010;
}

static void
Opcode_ae_sa32x2f24_ric_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018f010;
}

static void
Opcode_ae_sa24_l_ic_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd6000;
}

static void
Opcode_ae_sa24_l_ic_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018c010;
}

static void
Opcode_ae_sa24_l_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd6080;
}

static void
Opcode_ae_sa24_l_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018c090;
}

static void
Opcode_ae_sa24_l_rip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd6090;
}

static void
Opcode_ae_sa24_l_rip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018d090;
}

static void
Opcode_ae_sa24_l_ric_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd6010;
}

static void
Opcode_ae_sa24_l_ric_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018d010;
}

static void
Opcode_ae_sa24x2_ic_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd5000;
}

static void
Opcode_ae_sa24x2_ic_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018a010;
}

static void
Opcode_ae_sa24x2_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd5080;
}

static void
Opcode_ae_sa24x2_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018a090;
}

static void
Opcode_ae_sa24x2_rip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd5090;
}

static void
Opcode_ae_sa24x2_rip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018b090;
}

static void
Opcode_ae_sa24x2_ric_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd5010;
}

static void
Opcode_ae_sa24x2_ric_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018b010;
}

static void
Opcode_ae_s32ra64s_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbc000;
}

static void
Opcode_ae_s32ra64s_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80178030;
}

static void
Opcode_ae_s32ra64s_i_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf000;
}

static void
Opcode_ae_s32ra64s_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbd000;
}

static void
Opcode_ae_s32ra64s_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80178070;
}

static void
Opcode_ae_s32ra64s_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x95000;
}

static void
Opcode_ae_s32ra64s_x_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8011a000;
}

static void
Opcode_ae_s32ra64s_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40004;
}

static void
Opcode_ae_s32ra64s_xp_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x97000;
}

static void
Opcode_ae_s32ra64s_xp_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8011c000;
}

static void
Opcode_ae_s32ra64s_xc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x96000;
}

static void
Opcode_ae_s32ra64s_xc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8011b000;
}

static void
Opcode_ae_s24ra64s_i_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb6000;
}

static void
Opcode_ae_s24ra64s_i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80178000;
}

static void
Opcode_ae_s24ra64s_i_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc000;
}

static void
Opcode_ae_s24ra64s_ip_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb7000;
}

static void
Opcode_ae_s24ra64s_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80178040;
}

static void
Opcode_ae_s24ra64s_x_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8c000;
}

static void
Opcode_ae_s24ra64s_x_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80111000;
}

static void
Opcode_ae_s24ra64s_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdd0004;
}

static void
Opcode_ae_s24ra64s_xp_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8e000;
}

static void
Opcode_ae_s24ra64s_xp_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80113000;
}

static void
Opcode_ae_s24ra64s_xc_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8d000;
}

static void
Opcode_ae_s24ra64s_xc_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80112000;
}

static void
Opcode_ae_s32x2ra64s_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4;
}

static void
Opcode_ae_s32x2ra64s_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8012a000;
}

static void
Opcode_ae_s24x2ra64s_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30004;
}

static void
Opcode_ae_s24x2ra64s_ip_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80129000;
}

static void
Opcode_ae_addbrba32_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x54000;
}

static void
Opcode_ae_addbrba32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800d4000;
}

static void
Opcode_ae_sel16i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa00004;
}

static void
Opcode_ae_sel16i_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_ae_sel16i_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc30000;
}

static void
Opcode_ae_sel16i_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80090000;
}

static void
Opcode_ae_sel16i_n_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_ae_shortswap_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x49070;
}

static void
Opcode_ae_shortswap_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc0fb0;
}

static void
Opcode_ae_movt16x4_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x45100;
}

static void
Opcode_ae_movt16x4_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a4040;
}

static void
Opcode_ae_movf16x4_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x45000;
}

static void
Opcode_ae_movf16x4_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a4000;
}

static void
Opcode_ae_movt32x2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b0014;
}

static void
Opcode_ae_movt32x2_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x44100;
}

static void
Opcode_ae_movt32x2_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a0020;
}

static void
Opcode_ae_movf32x2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3a0014;
}

static void
Opcode_ae_movf32x2_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x44000;
}

static void
Opcode_ae_movf32x2_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a0000;
}

static void
Opcode_ae_movda32x2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x150004;
}

static void
Opcode_ae_movda32x2_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x60000;
}

static void
Opcode_ae_movda32x2_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800e5000;
}

static void
Opcode_ae_movda32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c0034;
}

static void
Opcode_ae_movda32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80188020;
}

static void
Opcode_ae_movda32_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50b40;
}

static void
Opcode_ae_movda32_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x14500;
}

static void
Opcode_ae_movda16x2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x140004;
}

static void
Opcode_ae_movda16x2_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800e4000;
}

static void
Opcode_ae_movda16_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c0024;
}

static void
Opcode_ae_movda16_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ac0e0;
}

static void
Opcode_ae_movda16_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50b30;
}

static void
Opcode_ae_movda16_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x14400;
}

static void
Opcode_ae_movi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d0084;
}

static void
Opcode_ae_movi_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfa000;
}

static void
Opcode_ae_movi_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd9000;
}

static void
Opcode_ae_movi_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x45200;
}

static void
Opcode_ae_movi_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd400b0;
}

static void
Opcode_ae_movi_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a4020;
}

static void
Opcode_ae_movi_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x60000;
}

static void
Opcode_ae_movi_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x14000;
}

static void
Opcode_ae_truncp24a32x2_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61000;
}

static void
Opcode_ae_truncp24a32x2_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800e6000;
}

static void
Opcode_ae_sat16x4_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x25000;
}

static void
Opcode_ae_sat16x4_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80140000;
}

static void
Opcode_ae_cvt32x2f16_32_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc9070;
}

static void
Opcode_ae_cvt32x2f16_32_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x49030;
}

static void
Opcode_ae_cvt32x2f16_32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801aa060;
}

static void
Opcode_ae_cvt32x2f16_10_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc9030;
}

static void
Opcode_ae_cvt32x2f16_10_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x49020;
}

static void
Opcode_ae_cvt32x2f16_10_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801aa040;
}

static void
Opcode_ae_sext32x2d16_32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c0014;
}

static void
Opcode_ae_sext32x2d16_32_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc90b0;
}

static void
Opcode_ae_sext32x2d16_32_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x49060;
}

static void
Opcode_ae_sext32x2d16_32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801aa050;
}

static void
Opcode_ae_sext32x2d16_10_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc90e0;
}

static void
Opcode_ae_sext32x2d16_10_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x49050;
}

static void
Opcode_ae_sext32x2d16_10_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801aa030;
}

static void
Opcode_ae_cvta32f24s_l_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc8060;
}

static void
Opcode_ae_cvta32f24s_l_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a4010;
}

static void
Opcode_ae_cvta32f24s_h_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc8020;
}

static void
Opcode_ae_cvta32f24s_h_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018f060;
}

static void
Opcode_ae_cvtp24a16x2_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130004;
}

static void
Opcode_ae_cvtp24a16x2_ll_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800e3000;
}

static void
Opcode_ae_cvtp24a16x2_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x120004;
}

static void
Opcode_ae_cvtp24a16x2_lh_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800e2000;
}

static void
Opcode_ae_cvtp24a16x2_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110004;
}

static void
Opcode_ae_cvtp24a16x2_hl_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800e1000;
}

static void
Opcode_ae_cvtp24a16x2_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100004;
}

static void
Opcode_ae_cvtp24a16x2_hh_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800e0000;
}

static void
Opcode_ae_truncp24q48x2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d0004;
}

static void
Opcode_ae_truncp24q48x2_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e000;
}

static void
Opcode_ae_truncp24q48x2_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8015a000;
}

static void
Opcode_ae_trunca32x2f64s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf00004;
}

static void
Opcode_ae_trunca32x2f64s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80030000;
}

static void
Opcode_ae_trunca32x2f64s_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30000;
}

static void
Opcode_ae_trunci32x2f64s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80080000;
}

static void
Opcode_ae_trunca32f64s_l_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80020000;
}

static void
Opcode_ae_trunca32f64s_l_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20000;
}

static void
Opcode_ae_trunci32f64s_l_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80070000;
}

static void
Opcode_ae_truncp16_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c0004;
}

static void
Opcode_ae_truncp16_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x48400;
}

static void
Opcode_ae_truncp16_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801aa000;
}

static void
Opcode_ae_round32x2f64ssym_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x22000;
}

static void
Opcode_ae_round32x2f64ssym_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8013d000;
}

static void
Opcode_ae_round32x2f64sasym_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x470004;
}

static void
Opcode_ae_round32x2f64sasym_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x21000;
}

static void
Opcode_ae_round32x2f64sasym_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8013c000;
}

static void
Opcode_ae_round32x2f48ssym_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20000;
}

static void
Opcode_ae_round32x2f48ssym_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8013b000;
}

static void
Opcode_ae_round32x2f48sasym_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f000;
}

static void
Opcode_ae_round32x2f48sasym_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8013a000;
}

static void
Opcode_ae_round16x4f32ssym_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c000;
}

static void
Opcode_ae_round16x4f32ssym_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80137000;
}

static void
Opcode_ae_round16x4f32sasym_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x420004;
}

static void
Opcode_ae_round16x4f32sasym_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b000;
}

static void
Opcode_ae_round16x4f32sasym_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80136000;
}

static void
Opcode_ae_round24x2f48ssym_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x450004;
}

static void
Opcode_ae_round24x2f48ssym_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e000;
}

static void
Opcode_ae_round24x2f48ssym_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80139000;
}

static void
Opcode_ae_round24x2f48sasym_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x440004;
}

static void
Opcode_ae_round24x2f48sasym_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d000;
}

static void
Opcode_ae_round24x2f48sasym_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80138000;
}

static void
Opcode_ae_roundsp16q48x2sym_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x24000;
}

static void
Opcode_ae_roundsp16q48x2sym_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8013f000;
}

static void
Opcode_ae_roundsp16q48x2asym_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x430004;
}

static void
Opcode_ae_roundsp16q48x2asym_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x23000;
}

static void
Opcode_ae_roundsp16q48x2asym_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8013e000;
}

static void
Opcode_ae_minabs32s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x39000;
}

static void
Opcode_ae_minabs32s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80154000;
}

static void
Opcode_ae_maxabs32s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x35000;
}

static void
Opcode_ae_maxabs32s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80150000;
}

static void
Opcode_ae_roundsp16f24sym_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x49010;
}

static void
Opcode_ae_roundsp16f24sym_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018f020;
}

static void
Opcode_ae_roundsp16f24asym_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x49000;
}

static void
Opcode_ae_roundsp16f24asym_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8018e060;
}

static void
Opcode_ae_mov_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e0014;
}

static void
Opcode_ae_mov_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfb0e0;
}

static void
Opcode_ae_mov_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc90a0;
}

static void
Opcode_ae_mov_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x49040;
}

static void
Opcode_ae_mov_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc0eb0;
}

static void
Opcode_ae_mov_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801aa010;
}

static void
Opcode_ae_movt64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x600004;
}

static void
Opcode_ae_movt64_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x41000;
}

static void
Opcode_ae_movt64_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8015d000;
}

static void
Opcode_ae_movf64_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40000;
}

static void
Opcode_ae_movf64_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8015c000;
}

static void
Opcode_ae_cvtq56a32s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ac0a0;
}

static void
Opcode_ae_cvtq56a32s_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50b20;
}

static void
Opcode_ae_cvt48a32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c0014;
}

static void
Opcode_ae_cvt48a32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ac020;
}

static void
Opcode_ae_cvt48a32_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50b00;
}

static void
Opcode_ae_cvt64a32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ac060;
}

static void
Opcode_ae_cvt64a32_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50b10;
}

static void
Opcode_ae_cvtq56p32s_l_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e0034;
}

static void
Opcode_ae_cvtq56p32s_l_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x48300;
}

static void
Opcode_ae_cvtq56p32s_l_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ac0f0;
}

static void
Opcode_ae_cvtq56p32s_h_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e0024;
}

static void
Opcode_ae_cvtq56p32s_h_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x48200;
}

static void
Opcode_ae_cvtq56p32s_h_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ac0d0;
}

static void
Opcode_ae_cvt64f32_h_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x48100;
}

static void
Opcode_ae_cvt64f32_h_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ac0b0;
}

static void
Opcode_ae_sat48s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0a04;
}

static void
Opcode_ae_sat48s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x47f00;
}

static void
Opcode_ae_sat48s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ad001;
}

static void
Opcode_ae_satq56s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x48000;
}

static void
Opcode_ae_satq56s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a5002;
}

static void
Opcode_ae_sat24s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x47e00;
}

static void
Opcode_ae_sat24s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a5001;
}

static void
Opcode_ae_truncq32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c0024;
}

static void
Opcode_ae_truncq32_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x48500;
}

static void
Opcode_ae_truncq32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801aa020;
}

static void
Opcode_ae_minabs64s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3a000;
}

static void
Opcode_ae_minabs64s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80155000;
}

static void
Opcode_ae_maxabs64s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36000;
}

static void
Opcode_ae_maxabs64s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80151000;
}

static void
Opcode_ae_roundsq32f48sym_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0904;
}

static void
Opcode_ae_roundsq32f48sym_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x47d00;
}

static void
Opcode_ae_roundsq32f48sym_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ad000;
}

static void
Opcode_ae_roundsq32f48asym_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0804;
}

static void
Opcode_ae_roundsq32f48asym_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x47c00;
}

static void
Opcode_ae_roundsq32f48asym_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a5000;
}

static void
Opcode_ae_trunca32q48_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x250034;
}

static void
Opcode_ae_trunca32q48_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc9060;
}

static void
Opcode_ae_trunca32q48_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ac090;
}

static void
Opcode_ae_movad32_l_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2500c4;
}

static void
Opcode_ae_movad32_l_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc8070;
}

static void
Opcode_ae_movad32_l_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a40d0;
}

static void
Opcode_ae_movad32_l_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x55700;
}

static void
Opcode_ae_movad32_h_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2500b4;
}

static void
Opcode_ae_movad32_h_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc8030;
}

static void
Opcode_ae_movad32_h_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a40b0;
}

static void
Opcode_ae_movad32_h_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x54700;
}

static void
Opcode_ae_movad16_3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2500a4;
}

static void
Opcode_ae_movad16_3_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a4090;
}

static void
Opcode_ae_movad16_3_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x53700;
}

static void
Opcode_ae_movad16_2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x250094;
}

static void
Opcode_ae_movad16_2_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a4070;
}

static void
Opcode_ae_movad16_2_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x52700;
}

static void
Opcode_ae_movad16_1_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a4050;
}

static void
Opcode_ae_movad16_1_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x51700;
}

static void
Opcode_ae_movad16_0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x250084;
}

static void
Opcode_ae_movad16_0_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a4030;
}

static void
Opcode_ae_movad16_0_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50700;
}

static void
Opcode_ae_sra64_32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800c0f00;
}

static void
Opcode_ae_pksr32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x270204;
}

static void
Opcode_ae_pksr32_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf9001;
}

static void
Opcode_ae_pksr32_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd400a1;
}

static void
Opcode_ae_pksr24_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x260204;
}

static void
Opcode_ae_pksr24_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf9000;
}

static void
Opcode_ae_pksr24_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd400a0;
}

static void
Opcode_ae_trunca16p24s_l_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x250024;
}

static void
Opcode_ae_trunca16p24s_l_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc9020;
}

static void
Opcode_ae_trunca16p24s_l_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ac070;
}

static void
Opcode_ae_trunca16p24s_h_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x250014;
}

static void
Opcode_ae_trunca16p24s_h_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc80f0;
}

static void
Opcode_ae_trunca16p24s_h_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ac050;
}

static void
Opcode_ae_add32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300004;
}

static void
Opcode_ae_add32_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe7000;
}

static void
Opcode_ae_add32_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13000;
}

static void
Opcode_ae_add32_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd40010;
}

static void
Opcode_ae_add32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8012e000;
}

static void
Opcode_ae_sub32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4c0004;
}

static void
Opcode_ae_sub32_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf2000;
}

static void
Opcode_ae_sub32_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x29000;
}

static void
Opcode_ae_sub32_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc0060;
}

static void
Opcode_ae_sub32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80144000;
}

static void
Opcode_ae_addsub32_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xed000;
}

static void
Opcode_ae_addsub32_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x19000;
}

static void
Opcode_ae_addsub32_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd40040;
}

static void
Opcode_ae_addsub32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80134000;
}

static void
Opcode_ae_subadd32_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf6000;
}

static void
Opcode_ae_subadd32_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d000;
}

static void
Opcode_ae_subadd32_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc0080;
}

static void
Opcode_ae_subadd32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80148000;
}

static void
Opcode_ae_add16_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe4000;
}

static void
Opcode_ae_add16_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10000;
}

static void
Opcode_ae_add16_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb00f0;
}

static void
Opcode_ae_add16_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8012b000;
}

static void
Opcode_ae_sub16_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xef000;
}

static void
Opcode_ae_sub16_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x26000;
}

static void
Opcode_ae_sub16_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd40050;
}

static void
Opcode_ae_sub16_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80141000;
}

static void
Opcode_ae_add32_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe9000;
}

static void
Opcode_ae_add32_hl_lh_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x15000;
}

static void
Opcode_ae_add32_hl_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd40020;
}

static void
Opcode_ae_add32_hl_lh_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80130000;
}

static void
Opcode_ae_neg32_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfb090;
}

static void
Opcode_ae_neg32_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x47700;
}

static void
Opcode_ae_neg32_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc09b0;
}

static void
Opcode_ae_neg32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ab00b;
}

static void
Opcode_ae_abs32_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfb020;
}

static void
Opcode_ae_abs32_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x45b00;
}

static void
Opcode_ae_abs32_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd40ab0;
}

static void
Opcode_ae_abs32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ab002;
}

static void
Opcode_ae_add24s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x320004;
}

static void
Opcode_ae_add24s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe6000;
}

static void
Opcode_ae_add24s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x12000;
}

static void
Opcode_ae_add24s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc0000;
}

static void
Opcode_ae_add24s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8012d000;
}

static void
Opcode_ae_sub24s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf1000;
}

static void
Opcode_ae_sub24s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x28000;
}

static void
Opcode_ae_sub24s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd40060;
}

static void
Opcode_ae_sub24s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80143000;
}

static void
Opcode_ae_add32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400004;
}

static void
Opcode_ae_add32s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe8000;
}

static void
Opcode_ae_add32s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x14000;
}

static void
Opcode_ae_add32s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc0010;
}

static void
Opcode_ae_add32s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8012f000;
}

static void
Opcode_ae_sub32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4f0004;
}

static void
Opcode_ae_sub32s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf3000;
}

static void
Opcode_ae_sub32s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2a000;
}

static void
Opcode_ae_sub32s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd40070;
}

static void
Opcode_ae_sub32s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80145000;
}

static void
Opcode_ae_addsub32s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xee000;
}

static void
Opcode_ae_addsub32s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a000;
}

static void
Opcode_ae_addsub32s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc0040;
}

static void
Opcode_ae_addsub32s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80135000;
}

static void
Opcode_ae_subadd32s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf7000;
}

static void
Opcode_ae_subadd32s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e000;
}

static void
Opcode_ae_subadd32s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd40090;
}

static void
Opcode_ae_subadd32s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80149000;
}

static void
Opcode_ae_add16s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x330004;
}

static void
Opcode_ae_add16s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe5000;
}

static void
Opcode_ae_add16s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x11000;
}

static void
Opcode_ae_add16s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd40000;
}

static void
Opcode_ae_add16s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8012c000;
}

static void
Opcode_ae_sub16s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4e0004;
}

static void
Opcode_ae_sub16s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf0000;
}

static void
Opcode_ae_sub16s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x27000;
}

static void
Opcode_ae_sub16s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc0050;
}

static void
Opcode_ae_sub16s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80142000;
}

static void
Opcode_ae_neg24s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfb080;
}

static void
Opcode_ae_neg24s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x47600;
}

static void
Opcode_ae_neg24s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc08b0;
}

static void
Opcode_ae_neg24s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ab00a;
}

static void
Opcode_ae_abs24s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0104;
}

static void
Opcode_ae_abs24s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfb010;
}

static void
Opcode_ae_abs24s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x45700;
}

static void
Opcode_ae_abs24s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd409b0;
}

static void
Opcode_ae_abs24s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ab001;
}

static void
Opcode_ae_neg32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0704;
}

static void
Opcode_ae_neg32s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfb0a0;
}

static void
Opcode_ae_neg32s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x47800;
}

static void
Opcode_ae_neg32s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc0ab0;
}

static void
Opcode_ae_neg32s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ab00c;
}

static void
Opcode_ae_abs32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0304;
}

static void
Opcode_ae_abs32s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfb030;
}

static void
Opcode_ae_abs32s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x45f00;
}

static void
Opcode_ae_abs32s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd40bb0;
}

static void
Opcode_ae_abs32s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ab003;
}

static void
Opcode_ae_neg16s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0604;
}

static void
Opcode_ae_neg16s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfb070;
}

static void
Opcode_ae_neg16s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x47500;
}

static void
Opcode_ae_neg16s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd40fb0;
}

static void
Opcode_ae_neg16s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ab009;
}

static void
Opcode_ae_abs16s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0204;
}

static void
Opcode_ae_abs16s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfb000;
}

static void
Opcode_ae_abs16s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x45300;
}

static void
Opcode_ae_abs16s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd408b0;
}

static void
Opcode_ae_abs16s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ab000;
}

static void
Opcode_ae_lt16_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x46000;
}

static void
Opcode_ae_lt16_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a3000;
}

static void
Opcode_ae_le16_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x43003;
}

static void
Opcode_ae_le16_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8015f300;
}

static void
Opcode_ae_eq16_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x43001;
}

static void
Opcode_ae_eq16_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8015f100;
}

static void
Opcode_ae_lt32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x541004;
}

static void
Opcode_ae_lt32_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x43000;
}

static void
Opcode_ae_lt32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8015f000;
}

static void
Opcode_ae_le32_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x42001;
}

static void
Opcode_ae_le32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8015e100;
}

static void
Opcode_ae_eq32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x540004;
}

static void
Opcode_ae_eq32_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x42000;
}

static void
Opcode_ae_eq32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8015e000;
}

static void
Opcode_ae_min32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x530004;
}

static void
Opcode_ae_min32_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x37000;
}

static void
Opcode_ae_min32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80152000;
}

static void
Opcode_ae_max32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x520004;
}

static void
Opcode_ae_max32_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x33000;
}

static void
Opcode_ae_max32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8014e000;
}

static void
Opcode_ae_add64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x310004;
}

static void
Opcode_ae_add64_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea000;
}

static void
Opcode_ae_add64_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16000;
}

static void
Opcode_ae_add64_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc0020;
}

static void
Opcode_ae_add64_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80131000;
}

static void
Opcode_ae_sub64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4d0004;
}

static void
Opcode_ae_sub64_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf4000;
}

static void
Opcode_ae_sub64_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b000;
}

static void
Opcode_ae_sub64_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc0070;
}

static void
Opcode_ae_sub64_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80146000;
}

static void
Opcode_ae_neg64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0504;
}

static void
Opcode_ae_neg64_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfb0b0;
}

static void
Opcode_ae_neg64_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x47900;
}

static void
Opcode_ae_neg64_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc0bb0;
}

static void
Opcode_ae_neg64_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ab00d;
}

static void
Opcode_ae_abs64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x270804;
}

static void
Opcode_ae_abs64_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfb040;
}

static void
Opcode_ae_abs64_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x47000;
}

static void
Opcode_ae_abs64_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd40cb0;
}

static void
Opcode_ae_abs64_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ab004;
}

static void
Opcode_ae_addsq56s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xec000;
}

static void
Opcode_ae_addsq56s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x18000;
}

static void
Opcode_ae_addsq56s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc0030;
}

static void
Opcode_ae_addsq56s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80133000;
}

static void
Opcode_ae_subsq56s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf8000;
}

static void
Opcode_ae_subsq56s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2f000;
}

static void
Opcode_ae_subsq56s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc0090;
}

static void
Opcode_ae_subsq56s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8014a000;
}

static void
Opcode_ae_add64s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xeb000;
}

static void
Opcode_ae_add64s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x17000;
}

static void
Opcode_ae_add64s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd40030;
}

static void
Opcode_ae_add64s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80132000;
}

static void
Opcode_ae_sub64s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf5000;
}

static void
Opcode_ae_sub64s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2c000;
}

static void
Opcode_ae_sub64s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd40080;
}

static void
Opcode_ae_sub64s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80147000;
}

static void
Opcode_ae_negsq56s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfb0d0;
}

static void
Opcode_ae_negsq56s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x47b00;
}

static void
Opcode_ae_negsq56s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc0db0;
}

static void
Opcode_ae_negsq56s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ab00f;
}

static void
Opcode_ae_abssq56s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfb060;
}

static void
Opcode_ae_abssq56s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x47200;
}

static void
Opcode_ae_abssq56s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd40eb0;
}

static void
Opcode_ae_abssq56s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ab006;
}

static void
Opcode_ae_neg64s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfb0c0;
}

static void
Opcode_ae_neg64s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x47a00;
}

static void
Opcode_ae_neg64s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc0cb0;
}

static void
Opcode_ae_neg64s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ab00e;
}

static void
Opcode_ae_abs64s_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfb050;
}

static void
Opcode_ae_abs64s_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x47100;
}

static void
Opcode_ae_abs64s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd40db0;
}

static void
Opcode_ae_abs64s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ab005;
}

static void
Opcode_ae_and_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x410004;
}

static void
Opcode_ae_and_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b000;
}

static void
Opcode_ae_and_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80156000;
}

static void
Opcode_ae_nand_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c000;
}

static void
Opcode_ae_nand_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80157000;
}

static void
Opcode_ae_or_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x160004;
}

static void
Opcode_ae_or_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d000;
}

static void
Opcode_ae_or_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80158000;
}

static void
Opcode_ae_xor_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e0004;
}

static void
Opcode_ae_xor_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f000;
}

static void
Opcode_ae_xor_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8015b000;
}

static void
Opcode_ae_slai24_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x940004;
}

static void
Opcode_ae_slai24_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x14000;
}

static void
Opcode_ae_slai24_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800b0001;
}

static void
Opcode_ae_srli24_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x22000;
}

static void
Opcode_ae_srli24_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800c0001;
}

static void
Opcode_ae_srai24_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9c0004;
}

static void
Opcode_ae_srai24_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c000;
}

static void
Opcode_ae_srai24_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800b0802;
}

static void
Opcode_ae_slas24_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x240b04;
}

static void
Opcode_ae_slas24_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea000;
}

static void
Opcode_ae_slas24_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190b00;
}

static void
Opcode_ae_srls24_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea0c0;
}

static void
Opcode_ae_srls24_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190b0c;
}

static void
Opcode_ae_sras24_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x240e04;
}

static void
Opcode_ae_sras24_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea080;
}

static void
Opcode_ae_sras24_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190b08;
}

static void
Opcode_ae_srai16_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe7000;
}

static void
Opcode_ae_srai16_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190d00;
}

static void
Opcode_ae_srai16r_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe8000;
}

static void
Opcode_ae_srai16r_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190300;
}

static void
Opcode_ae_slai32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x960004;
}

static void
Opcode_ae_slai32_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x18000;
}

static void
Opcode_ae_slai32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800b0800;
}

static void
Opcode_ae_srli32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x920004;
}

static void
Opcode_ae_srli32_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x24000;
}

static void
Opcode_ae_srli32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800c0002;
}

static void
Opcode_ae_srai32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9e0004;
}

static void
Opcode_ae_srai32_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e000;
}

static void
Opcode_ae_srai32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800b0803;
}

static void
Opcode_ae_srai32r_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20000;
}

static void
Opcode_ae_srai32r_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800c0000;
}

static void
Opcode_ae_slas32_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea020;
}

static void
Opcode_ae_slas32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190b02;
}

static void
Opcode_ae_srls32_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea0d0;
}

static void
Opcode_ae_srls32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190b0d;
}

static void
Opcode_ae_sras32_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea090;
}

static void
Opcode_ae_sras32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190b09;
}

static void
Opcode_ae_slaa32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200004;
}

static void
Opcode_ae_slaa32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800c0c00;
}

static void
Opcode_ae_slaa32_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50400;
}

static void
Opcode_ae_srla32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190e00;
}

static void
Opcode_ae_sraa32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70004;
}

static void
Opcode_ae_sraa32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190800;
}

static void
Opcode_ae_sraa32_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50200;
}

static void
Opcode_ae_slai16s_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe6000;
}

static void
Opcode_ae_slai16s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190900;
}

static void
Opcode_ae_slaa16s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x230004;
}

static void
Opcode_ae_slaa16s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800c0800;
}

static void
Opcode_ae_slaa16s_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50000;
}

static void
Opcode_ae_sraa16s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190400;
}

static void
Opcode_ae_sraa16s_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50d00;
}

static void
Opcode_ae_sraa16rs_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190000;
}

static void
Opcode_ae_sraa16rs_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50900;
}

static void
Opcode_ae_slai24s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x980004;
}

static void
Opcode_ae_slai24s_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16000;
}

static void
Opcode_ae_slai24s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800b0003;
}

static void
Opcode_ae_slas24s_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea010;
}

static void
Opcode_ae_slas24s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190b01;
}

static void
Opcode_ae_slai32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9a0004;
}

static void
Opcode_ae_slai32s_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a000;
}

static void
Opcode_ae_slai32s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800b0801;
}

static void
Opcode_ae_slas32s_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea030;
}

static void
Opcode_ae_slas32s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190b03;
}

static void
Opcode_ae_slaa32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50004;
}

static void
Opcode_ae_slaa32s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800c0a00;
}

static void
Opcode_ae_slaa32s_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50800;
}

static void
Opcode_ae_sraa32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x820004;
}

static void
Opcode_ae_sraa32s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190200;
}

static void
Opcode_ae_sraa32s_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50a00;
}

static void
Opcode_ae_sraa32rs_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190c00;
}

static void
Opcode_ae_sraa32rs_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50600;
}

static void
Opcode_ae_slasq56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x240c04;
}

static void
Opcode_ae_slasq56_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea060;
}

static void
Opcode_ae_slasq56_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190b06;
}

static void
Opcode_ae_srlsq56_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea0f0;
}

static void
Opcode_ae_srlsq56_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190b0f;
}

static void
Opcode_ae_srasq56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x240f04;
}

static void
Opcode_ae_srasq56_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea0b0;
}

static void
Opcode_ae_srasq56_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190b0b;
}

static void
Opcode_ae_slaaq56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x210004;
}

static void
Opcode_ae_slaaq56_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800c0d00;
}

static void
Opcode_ae_slaaq56_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50500;
}

static void
Opcode_ae_srlaq56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610004;
}

static void
Opcode_ae_srlaq56_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190500;
}

static void
Opcode_ae_sraaq56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x910004;
}

static void
Opcode_ae_sraaq56_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190a00;
}

static void
Opcode_ae_sraaq56_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50300;
}

static void
Opcode_ae_slai64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x880004;
}

static void
Opcode_ae_slai64_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_ae_slai64_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800a0000;
}

static void
Opcode_ae_srli64_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10000;
}

static void
Opcode_ae_srli64_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800b0000;
}

static void
Opcode_ae_srai64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8c0004;
}

static void
Opcode_ae_srai64_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc000;
}

static void
Opcode_ae_srai64_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800a0801;
}

static void
Opcode_ae_slas64_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea040;
}

static void
Opcode_ae_slas64_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190b04;
}

static void
Opcode_ae_srls64_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea0e0;
}

static void
Opcode_ae_srls64_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190b0e;
}

static void
Opcode_ae_sras64_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea0a0;
}

static void
Opcode_ae_sras64_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190b0a;
}

static void
Opcode_ae_slaa64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x220004;
}

static void
Opcode_ae_slaa64_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800c0e00;
}

static void
Opcode_ae_slaa64_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50c00;
}

static void
Opcode_ae_srla64_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190100;
}

static void
Opcode_ae_sraa64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x810004;
}

static void
Opcode_ae_sraa64_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190600;
}

static void
Opcode_ae_sraa64_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50e00;
}

static void
Opcode_ae_slaisq56s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x840004;
}

static void
Opcode_ae_slaisq56s_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8000;
}

static void
Opcode_ae_slaisq56s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800a0800;
}

static void
Opcode_ae_slassq56s_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea070;
}

static void
Opcode_ae_slassq56s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190b07;
}

static void
Opcode_ae_slaasq56s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x60004;
}

static void
Opcode_ae_slaasq56s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800c0b00;
}

static void
Opcode_ae_slai64s_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000;
}

static void
Opcode_ae_slai64s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800a0001;
}

static void
Opcode_ae_slas64s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x240d04;
}

static void
Opcode_ae_slas64s_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea050;
}

static void
Opcode_ae_slas64s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80190b05;
}

static void
Opcode_ae_slaa64s_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800c0900;
}

static void
Opcode_ae_slaa64s_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50100;
}

static void
Opcode_ae_lt64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x510004;
}

static void
Opcode_ae_lt64_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x32000;
}

static void
Opcode_ae_lt64_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8014d000;
}

static void
Opcode_ae_le64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x500004;
}

static void
Opcode_ae_le64_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x31000;
}

static void
Opcode_ae_le64_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8014c000;
}

static void
Opcode_ae_eq64_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30000;
}

static void
Opcode_ae_eq64_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8014b000;
}

static void
Opcode_ae_max64_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x34000;
}

static void
Opcode_ae_max64_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8014f000;
}

static void
Opcode_ae_min64_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x38000;
}

static void
Opcode_ae_min64_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80153000;
}

static void
Opcode_ae_nsa64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2500d4;
}

static void
Opcode_ae_nsa64_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc80a0;
}

static void
Opcode_ae_nsa64_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a40f0;
}

static void
Opcode_ae_nsaz16_0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2500e4;
}

static void
Opcode_ae_nsaz16_0_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc80e0;
}

static void
Opcode_ae_nsaz16_0_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ac010;
}

static void
Opcode_ae_nsaz32_l_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2500f4;
}

static void
Opcode_ae_nsaz32_l_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc80b0;
}

static void
Opcode_ae_nsaz32_l_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ac030;
}

static void
Opcode_ae_muls32f48p16s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80000;
}

static void
Opcode_ae_muls32f48p16s_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00050;
}

static void
Opcode_ae_mulf32s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x62000;
}

static void
Opcode_ae_mulf32s_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc70030;
}

static void
Opcode_ae_mul32_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf000;
}

static void
Opcode_ae_mul32_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcb00d0;
}

static void
Opcode_ae_muls32f48p16s_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x88000;
}

static void
Opcode_ae_mulf32r_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5f000;
}

static void
Opcode_ae_mulf32r_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf0010;
}

static void
Opcode_ae_muls32f48p16s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7f000;
}

static void
Opcode_ae_muls32f48p16s_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd80040;
}

static void
Opcode_ae_mulf32s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61000;
}

static void
Opcode_ae_mulf32s_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf0020;
}

static void
Opcode_ae_mul32_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe000;
}

static void
Opcode_ae_mul32_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc300d0;
}

static void
Opcode_ae_muls32f48p16s_lh_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x87000;
}

static void
Opcode_ae_mulf32r_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5e000;
}

static void
Opcode_ae_mulf32r_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc70010;
}

static void
Opcode_ae_muls32f48p16s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7e000;
}

static void
Opcode_ae_muls32f48p16s_hh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00040;
}

static void
Opcode_ae_mulf32s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x60000;
}

static void
Opcode_ae_mulf32s_hh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc70020;
}

static void
Opcode_ae_mul32_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd000;
}

static void
Opcode_ae_mul32_hh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcb00c0;
}

static void
Opcode_ae_muls32f48p16s_hh_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x86000;
}

static void
Opcode_ae_mulf32r_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5d000;
}

static void
Opcode_ae_mulf32r_hh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf0000;
}

static void
Opcode_ae_mulf32r_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6d000;
}

static void
Opcode_ae_mulas32f48p16s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50000;
}

static void
Opcode_ae_mulas32f48p16s_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce0050;
}

static void
Opcode_ae_mulaf32s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x34000;
}

static void
Opcode_ae_mulaf32s_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd0040;
}

static void
Opcode_ae_mula32_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b000;
}

static void
Opcode_ae_mula32_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc0030;
}

static void
Opcode_ae_mulas32f48p16s_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x63000;
}

static void
Opcode_ae_mulaf32r_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x31000;
}

static void
Opcode_ae_mulaf32r_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc50030;
}

static void
Opcode_ae_mulas32f48p16s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4f000;
}

static void
Opcode_ae_mulas32f48p16s_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc60050;
}

static void
Opcode_ae_mulaf32s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x33000;
}

static void
Opcode_ae_mulaf32s_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc50040;
}

static void
Opcode_ae_mula32_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a000;
}

static void
Opcode_ae_mula32_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc40030;
}

static void
Opcode_ae_mulas32f48p16s_lh_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x62000;
}

static void
Opcode_ae_mulaf32r_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30000;
}

static void
Opcode_ae_mulaf32r_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd0020;
}

static void
Opcode_ae_mulas32f48p16s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4e000;
}

static void
Opcode_ae_mulas32f48p16s_hh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce0040;
}

static void
Opcode_ae_mulaf32s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x32000;
}

static void
Opcode_ae_mulaf32s_hh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd0030;
}

static void
Opcode_ae_mula32_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x19000;
}

static void
Opcode_ae_mula32_hh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc0020;
}

static void
Opcode_ae_mulas32f48p16s_hh_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61000;
}

static void
Opcode_ae_mulaf32r_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2f000;
}

static void
Opcode_ae_mulaf32r_hh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc50020;
}

static void
Opcode_ae_mulaf32r_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x48000;
}

static void
Opcode_ae_mulss32f48p16s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb2000;
}

static void
Opcode_ae_mulss32f48p16s_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda0050;
}

static void
Opcode_ae_mulsf32s_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x97000;
}

static void
Opcode_ae_mulsf32s_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd10060;
}

static void
Opcode_ae_muls32_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8c000;
}

static void
Opcode_ae_muls32_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd000b0;
}

static void
Opcode_ae_mulss32f48p16s_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb2000;
}

static void
Opcode_ae_mulsf32r_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x94000;
}

static void
Opcode_ae_mulsf32r_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd90040;
}

static void
Opcode_ae_mulss32f48p16s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb1000;
}

static void
Opcode_ae_mulss32f48p16s_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd20050;
}

static void
Opcode_ae_mulsf32s_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x96000;
}

static void
Opcode_ae_mulsf32s_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd90050;
}

static void
Opcode_ae_muls32_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8b000;
}

static void
Opcode_ae_muls32_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd800a0;
}

static void
Opcode_ae_mulss32f48p16s_lh_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb1000;
}

static void
Opcode_ae_mulsf32r_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x93000;
}

static void
Opcode_ae_mulsf32r_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd10040;
}

static void
Opcode_ae_mulss32f48p16s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb0000;
}

static void
Opcode_ae_mulss32f48p16s_hh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda0040;
}

static void
Opcode_ae_mulsf32s_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x95000;
}

static void
Opcode_ae_mulsf32s_hh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd10050;
}

static void
Opcode_ae_muls32_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8a000;
}

static void
Opcode_ae_muls32_hh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd000a0;
}

static void
Opcode_ae_mulss32f48p16s_hh_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb0000;
}

static void
Opcode_ae_mulsf32r_hh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x92000;
}

static void
Opcode_ae_mulsf32r_hh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd90030;
}

static void
Opcode_ae_mulsf32r_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x98000;
}

static void
Opcode_ae_mulf32s_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6e000;
}

static void
Opcode_ae_mulaf32s_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x49000;
}

static void
Opcode_ae_mul32_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e000;
}

static void
Opcode_ae_mula32_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x37000;
}

static void
Opcode_ae_mul32u_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000;
}

static void
Opcode_ae_mul32u_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc30080;
}

static void
Opcode_ae_mula32u_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10000;
}

static void
Opcode_ae_mula32u_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc300e0;
}

static void
Opcode_ae_muls32u_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x81000;
}

static void
Opcode_ae_muls32u_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd80050;
}

static void
Opcode_ae_mulf16ss_33_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc70000;
}

static void
Opcode_ae_mulf16ss_22_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc600e0;
}

static void
Opcode_ae_mulf16ss_32_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce00f0;
}

static void
Opcode_ae_mulf16ss_21_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce00d0;
}

static void
Opcode_ae_mulf16ss_31_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc600f0;
}

static void
Opcode_ae_mulf16ss_30_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce00e0;
}

static void
Opcode_ae_mulf16ss_10_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc600c0;
}

static void
Opcode_ae_mulf16ss_20_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc600d0;
}

static void
Opcode_ae_mulf16ss_11_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce00c0;
}

static void
Opcode_ae_mulf16ss_00_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5c000;
}

static void
Opcode_ae_mulf16ss_00_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce00b0;
}

static void
Opcode_ae_mulf16ss_00_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6c000;
}

static void
Opcode_ae_mulsf16ss_33_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd10030;
}

static void
Opcode_ae_mulsf16ss_22_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd10010;
}

static void
Opcode_ae_mulsf16ss_32_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd90020;
}

static void
Opcode_ae_mulsf16ss_21_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd90000;
}

static void
Opcode_ae_mulsf16ss_31_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd10020;
}

static void
Opcode_ae_mulsf16ss_30_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd90010;
}

static void
Opcode_ae_mulsf16ss_10_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd000f0;
}

static void
Opcode_ae_mulsf16ss_20_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd10000;
}

static void
Opcode_ae_mulsf16ss_11_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd800f0;
}

static void
Opcode_ae_mulsf16ss_00_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x91000;
}

static void
Opcode_ae_mulsf16ss_00_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd800e0;
}

static void
Opcode_ae_mulsf16ss_00_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x97000;
}

static void
Opcode_ae_mulaf16ss_33_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd0010;
}

static void
Opcode_ae_mulaf16ss_22_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc00f0;
}

static void
Opcode_ae_mulaf16ss_32_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc50010;
}

static void
Opcode_ae_mulaf16ss_21_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc400f0;
}

static void
Opcode_ae_mulaf16ss_31_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd0000;
}

static void
Opcode_ae_mulaf16ss_30_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc50000;
}

static void
Opcode_ae_mulaf16ss_10_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc00d0;
}

static void
Opcode_ae_mulaf16ss_20_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc00e0;
}

static void
Opcode_ae_mulaf16ss_11_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc400e0;
}

static void
Opcode_ae_mulaf16ss_00_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e000;
}

static void
Opcode_ae_mulaf16ss_00_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc400d0;
}

static void
Opcode_ae_mulaf16ss_00_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x47000;
}

static void
Opcode_ae_mulaafd16ss_33_22_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x24000;
}

static void
Opcode_ae_mulaafd16ss_33_22_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc40080;
}

static void
Opcode_ae_mulaafd16ss_33_22_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40000;
}

static void
Opcode_ae_mulaafd16ss_13_02_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x23000;
}

static void
Opcode_ae_mulaafd16ss_13_02_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc0070;
}

static void
Opcode_ae_mulaafd16ss_13_02_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f000;
}

static void
Opcode_ae_mulaafd16ss_11_00_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x22000;
}

static void
Opcode_ae_mulaafd16ss_11_00_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc40070;
}

static void
Opcode_ae_mulaafd16ss_11_00_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e000;
}

static void
Opcode_ae_mulssfd16ss_33_22_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9000;
}

static void
Opcode_ae_mulssfd16ss_33_22_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd20090;
}

static void
Opcode_ae_mulssfd16ss_33_22_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9000;
}

static void
Opcode_ae_mulssfd16ss_13_02_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb8000;
}

static void
Opcode_ae_mulssfd16ss_13_02_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda0080;
}

static void
Opcode_ae_mulssfd16ss_13_02_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb8000;
}

static void
Opcode_ae_mulssfd16ss_11_00_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb7000;
}

static void
Opcode_ae_mulssfd16ss_11_00_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd20080;
}

static void
Opcode_ae_mulssfd16ss_11_00_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb7000;
}

static void
Opcode_ae_mulzaafd16ss_33_22_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc6000;
}

static void
Opcode_ae_mulzaafd16ss_33_22_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda00f0;
}

static void
Opcode_ae_mulzaafd16ss_33_22_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc6000;
}

static void
Opcode_ae_mulzaafd16ss_13_02_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc5000;
}

static void
Opcode_ae_mulzaafd16ss_13_02_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd200f0;
}

static void
Opcode_ae_mulzaafd16ss_13_02_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc5000;
}

static void
Opcode_ae_mulzaafd16ss_11_00_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc4000;
}

static void
Opcode_ae_mulzaafd16ss_11_00_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda00e0;
}

static void
Opcode_ae_mulzaafd16ss_11_00_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc4000;
}

static void
Opcode_ae_mulzssfd16ss_33_22_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdf000;
}

static void
Opcode_ae_mulzssfd16ss_33_22_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd300d0;
}

static void
Opcode_ae_mulzssfd16ss_33_22_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe1000;
}

static void
Opcode_ae_mulzssfd16ss_13_02_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xde000;
}

static void
Opcode_ae_mulzssfd16ss_13_02_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb00c0;
}

static void
Opcode_ae_mulzssfd16ss_13_02_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0000;
}

static void
Opcode_ae_mulzssfd16ss_11_00_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdd000;
}

static void
Opcode_ae_mulzssfd16ss_11_00_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd300c0;
}

static void
Opcode_ae_mulzssfd16ss_11_00_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdf000;
}

static void
Opcode_ae_mulf48q32sp16s_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6b000;
}

static void
Opcode_ae_mulf48q32sp16s_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf0070;
}

static void
Opcode_ae_mulf48q32sp16s_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x77000;
}

static void
Opcode_ae_mulf48q32sp16u_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6c000;
}

static void
Opcode_ae_mulf48q32sp16u_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc70080;
}

static void
Opcode_ae_mulf48q32sp16u_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x78000;
}

static void
Opcode_ae_mulq32sp16s_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7c000;
}

static void
Opcode_ae_mulq32sp16s_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00020;
}

static void
Opcode_ae_mulq32sp16s_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x82000;
}

static void
Opcode_ae_mulq32sp16u_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7d000;
}

static void
Opcode_ae_mulq32sp16u_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd80020;
}

static void
Opcode_ae_mulq32sp16u_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x83000;
}

static void
Opcode_ae_mulaf48q32sp16s_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d000;
}

static void
Opcode_ae_mulaf48q32sp16s_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc50090;
}

static void
Opcode_ae_mulaf48q32sp16s_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x52000;
}

static void
Opcode_ae_mulaf48q32sp16u_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e000;
}

static void
Opcode_ae_mulaf48q32sp16u_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd0090;
}

static void
Opcode_ae_mulaf48q32sp16u_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x53000;
}

static void
Opcode_ae_mulaq32sp16s_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4c000;
}

static void
Opcode_ae_mulaq32sp16s_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce0020;
}

static void
Opcode_ae_mulaq32sp16s_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5d000;
}

static void
Opcode_ae_mulaq32sp16u_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4d000;
}

static void
Opcode_ae_mulaq32sp16u_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc60030;
}

static void
Opcode_ae_mulaq32sp16u_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5e000;
}

static void
Opcode_ae_mulsf48q32sp16s_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0000;
}

static void
Opcode_ae_mulsf48q32sp16s_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd900a0;
}

static void
Opcode_ae_mulsf48q32sp16s_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa1000;
}

static void
Opcode_ae_mulsf48q32sp16u_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa1000;
}

static void
Opcode_ae_mulsf48q32sp16u_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd100b0;
}

static void
Opcode_ae_mulsf48q32sp16u_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa2000;
}

static void
Opcode_ae_mulsq32sp16s_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xac000;
}

static void
Opcode_ae_mulsq32sp16s_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda0020;
}

static void
Opcode_ae_mulsq32sp16s_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xac000;
}

static void
Opcode_ae_mulsq32sp16u_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xad000;
}

static void
Opcode_ae_mulsq32sp16u_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd20030;
}

static void
Opcode_ae_mulsq32sp16u_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xad000;
}

static void
Opcode_ae_mulfp24x2ra_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x71000;
}

static void
Opcode_ae_mulfp24x2ra_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf00b0;
}

static void
Opcode_ae_mulfp24x2r_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70000;
}

static void
Opcode_ae_mulfp24x2r_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc700b0;
}

static void
Opcode_ae_mulp24x2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7a000;
}

static void
Opcode_ae_mulp24x2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00000;
}

static void
Opcode_ae_mulfp24x2ra_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x79000;
}

static void
Opcode_ae_mulfp24x2r_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7a000;
}

static void
Opcode_ae_mulp24x2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x81000;
}

static void
Opcode_ae_mulafp24x2ra_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x43000;
}

static void
Opcode_ae_mulafp24x2ra_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc500c0;
}

static void
Opcode_ae_mulafp24x2r_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x42000;
}

static void
Opcode_ae_mulafp24x2r_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd00b0;
}

static void
Opcode_ae_mulap24x2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4a000;
}

static void
Opcode_ae_mulap24x2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce0000;
}

static void
Opcode_ae_mulafp24x2ra_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x54000;
}

static void
Opcode_ae_mulafp24x2r_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x55000;
}

static void
Opcode_ae_mulap24x2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5c000;
}

static void
Opcode_ae_mulsfp24x2ra_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa3000;
}

static void
Opcode_ae_mulsfp24x2ra_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd100c0;
}

static void
Opcode_ae_mulsfp24x2r_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa2000;
}

static void
Opcode_ae_mulsfp24x2r_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd900b0;
}

static void
Opcode_ae_mulsp24x2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xaa000;
}

static void
Opcode_ae_mulsp24x2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda0000;
}

static void
Opcode_ae_mulsfp24x2ra_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa3000;
}

static void
Opcode_ae_mulsfp24x2r_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa4000;
}

static void
Opcode_ae_mulsp24x2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xab000;
}

static void
Opcode_ae_mulzaafd24_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc7000;
}

static void
Opcode_ae_mulzaafd24_hh_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd30000;
}

static void
Opcode_ae_mulzaad24_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbe000;
}

static void
Opcode_ae_mulzaad24_hh_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda00b0;
}

static void
Opcode_ae_mulzaafd24_hh_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc7000;
}

static void
Opcode_ae_mulzaad24_hh_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbe000;
}

static void
Opcode_ae_mulzaafd24_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc8000;
}

static void
Opcode_ae_mulzaafd24_hl_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb0000;
}

static void
Opcode_ae_mulzaad24_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbf000;
}

static void
Opcode_ae_mulzaad24_hl_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd200c0;
}

static void
Opcode_ae_mulzaafd24_hl_lh_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc8000;
}

static void
Opcode_ae_mulzaad24_hl_lh_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbf000;
}

static void
Opcode_ae_mulzasfd24_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd1000;
}

static void
Opcode_ae_mulzasfd24_hh_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd30050;
}

static void
Opcode_ae_mulzasd24_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd000;
}

static void
Opcode_ae_mulzasd24_hh_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd30030;
}

static void
Opcode_ae_mulzasfd24_hh_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd1000;
}

static void
Opcode_ae_mulzasd24_hh_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd000;
}

static void
Opcode_ae_mulzasfd24_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd2000;
}

static void
Opcode_ae_mulzasfd24_hl_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb0050;
}

static void
Opcode_ae_mulzasd24_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce000;
}

static void
Opcode_ae_mulzasd24_hl_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb0030;
}

static void
Opcode_ae_mulzasfd24_hl_lh_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd2000;
}

static void
Opcode_ae_mulzasd24_hl_lh_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce000;
}

static void
Opcode_ae_mulzsafd24_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd6000;
}

static void
Opcode_ae_mulzsafd24_hh_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb0080;
}

static void
Opcode_ae_mulzsad24_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd5000;
}

static void
Opcode_ae_mulzsad24_hh_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd30070;
}

static void
Opcode_ae_mulzsafd24_hh_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd8000;
}

static void
Opcode_ae_mulzsad24_hh_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd5000;
}

static void
Opcode_ae_mulzssfd24_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0000;
}

static void
Opcode_ae_mulzssfd24_hh_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb00d0;
}

static void
Opcode_ae_mulzssd24_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd9000;
}

static void
Opcode_ae_mulzssd24_hh_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd300a0;
}

static void
Opcode_ae_mulzssfd24_hh_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe2000;
}

static void
Opcode_ae_mulzssd24_hh_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb000;
}

static void
Opcode_ae_mulzssfd24_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe1000;
}

static void
Opcode_ae_mulzssfd24_hl_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd300e0;
}

static void
Opcode_ae_mulzssd24_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda000;
}

static void
Opcode_ae_mulzssd24_hl_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb00a0;
}

static void
Opcode_ae_mulzssfd24_hl_lh_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe3000;
}

static void
Opcode_ae_mulzssd24_hl_lh_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc000;
}

static void
Opcode_ae_mulaafd24_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x25000;
}

static void
Opcode_ae_mulaafd24_hh_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc0080;
}

static void
Opcode_ae_mulaad24_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c000;
}

static void
Opcode_ae_mulaad24_hh_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc40040;
}

static void
Opcode_ae_mulaafd24_hh_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x41000;
}

static void
Opcode_ae_mulaad24_hh_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x38000;
}

static void
Opcode_ae_mulaafd24_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x26000;
}

static void
Opcode_ae_mulaafd24_hl_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc40090;
}

static void
Opcode_ae_mulaad24_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d000;
}

static void
Opcode_ae_mulaad24_hl_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc0040;
}

static void
Opcode_ae_mulaafd24_hl_lh_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x42000;
}

static void
Opcode_ae_mulaad24_hl_lh_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x39000;
}

static void
Opcode_ae_mulasfd24_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x55000;
}

static void
Opcode_ae_mulasfd24_hh_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc60080;
}

static void
Opcode_ae_mulasd24_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x51000;
}

static void
Opcode_ae_mulasd24_hh_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc60060;
}

static void
Opcode_ae_mulasfd24_hh_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x68000;
}

static void
Opcode_ae_mulasd24_hh_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x64000;
}

static void
Opcode_ae_mulasfd24_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x56000;
}

static void
Opcode_ae_mulasfd24_hl_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce0080;
}

static void
Opcode_ae_mulasd24_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x52000;
}

static void
Opcode_ae_mulasd24_hl_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce0060;
}

static void
Opcode_ae_mulasfd24_hl_lh_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x69000;
}

static void
Opcode_ae_mulasd24_hl_lh_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x65000;
}

static void
Opcode_ae_mulsafd24_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8e000;
}

static void
Opcode_ae_mulsafd24_hh_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd000d0;
}

static void
Opcode_ae_mulsad24_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8d000;
}

static void
Opcode_ae_mulsad24_hh_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd800b0;
}

static void
Opcode_ae_mulsafd24_hh_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x94000;
}

static void
Opcode_ae_mulsad24_hh_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x91000;
}

static void
Opcode_ae_mulssfd24_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba000;
}

static void
Opcode_ae_mulssfd24_hh_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda0090;
}

static void
Opcode_ae_mulssd24_hh_ll_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb3000;
}

static void
Opcode_ae_mulssd24_hh_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd20060;
}

static void
Opcode_ae_mulssfd24_hh_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba000;
}

static void
Opcode_ae_mulssd24_hh_ll_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb3000;
}

static void
Opcode_ae_mulssfd24_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbb000;
}

static void
Opcode_ae_mulssfd24_hl_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd200a0;
}

static void
Opcode_ae_mulssd24_hl_lh_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb4000;
}

static void
Opcode_ae_mulssd24_hl_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda0060;
}

static void
Opcode_ae_mulssfd24_hl_lh_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbb000;
}

static void
Opcode_ae_mulssd24_hl_lh_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb4000;
}

static void
Opcode_ae_mulsrfq32sp24s_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xae000;
}

static void
Opcode_ae_mulsrfq32sp24s_h_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda0030;
}

static void
Opcode_ae_mulsrfq32sp24s_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xaf000;
}

static void
Opcode_ae_mulsrfq32sp24s_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd20040;
}

static void
Opcode_ae_mulsrfq32sp24s_h_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xae000;
}

static void
Opcode_ae_mulsrfq32sp24s_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xaf000;
}

static void
Opcode_ae_mularfq32sp24s_h_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce0030;
}

static void
Opcode_ae_mularfq32sp24s_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc60040;
}

static void
Opcode_ae_mularfq32sp24s_h_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5f000;
}

static void
Opcode_ae_mularfq32sp24s_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x60000;
}

static void
Opcode_ae_mulrfq32sp24s_h_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00030;
}

static void
Opcode_ae_mulrfq32sp24s_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd80030;
}

static void
Opcode_ae_mulrfq32sp24s_h_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x84000;
}

static void
Opcode_ae_mulrfq32sp24s_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x85000;
}

static void
Opcode_ae_mulsfq32sp24s_h_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd900f0;
}

static void
Opcode_ae_mulsfq32sp24s_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd20000;
}

static void
Opcode_ae_mulsfq32sp24s_h_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa9000;
}

static void
Opcode_ae_mulsfq32sp24s_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xaa000;
}

static void
Opcode_ae_mulafq32sp24s_h_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd00f0;
}

static void
Opcode_ae_mulafq32sp24s_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc60000;
}

static void
Opcode_ae_mulafq32sp24s_h_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a000;
}

static void
Opcode_ae_mulafq32sp24s_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5b000;
}

static void
Opcode_ae_mulfq32sp24s_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x78000;
}

static void
Opcode_ae_mulfq32sp24s_h_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc700f0;
}

static void
Opcode_ae_mulfq32sp24s_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x79000;
}

static void
Opcode_ae_mulfq32sp24s_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf00f0;
}

static void
Opcode_ae_mulfq32sp24s_h_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7f000;
}

static void
Opcode_ae_mulfq32sp24s_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80000;
}

static void
Opcode_ae_mulf32x16_l0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67000;
}

static void
Opcode_ae_mulf32x16_l0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf0050;
}

static void
Opcode_ae_mul32x16_l0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9000;
}

static void
Opcode_ae_mul32x16_l0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcb00a0;
}

static void
Opcode_ae_mulf32x16_l0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73000;
}

static void
Opcode_ae_mul32x16_l0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2a000;
}

static void
Opcode_ae_mulf32x16_l1_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x68000;
}

static void
Opcode_ae_mulf32x16_l1_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc70060;
}

static void
Opcode_ae_mul32x16_l1_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa000;
}

static void
Opcode_ae_mul32x16_l1_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc300b0;
}

static void
Opcode_ae_mulf32x16_l1_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x74000;
}

static void
Opcode_ae_mul32x16_l1_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b000;
}

static void
Opcode_ae_mulf32x16_l2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x69000;
}

static void
Opcode_ae_mulf32x16_l2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf0060;
}

static void
Opcode_ae_mul32x16_l2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb000;
}

static void
Opcode_ae_mul32x16_l2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcb00b0;
}

static void
Opcode_ae_mulf32x16_l2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x75000;
}

static void
Opcode_ae_mul32x16_l2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2c000;
}

static void
Opcode_ae_mulf32x16_l3_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a000;
}

static void
Opcode_ae_mulf32x16_l3_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc70070;
}

static void
Opcode_ae_mul32x16_l3_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc000;
}

static void
Opcode_ae_mul32x16_l3_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc300c0;
}

static void
Opcode_ae_mulf32x16_l3_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x76000;
}

static void
Opcode_ae_mul32x16_l3_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d000;
}

static void
Opcode_ae_mulf32x16_h0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x63000;
}

static void
Opcode_ae_mulf32x16_h0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf0030;
}

static void
Opcode_ae_mul32x16_h0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5000;
}

static void
Opcode_ae_mul32x16_h0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcb0080;
}

static void
Opcode_ae_mulf32x16_h0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6f000;
}

static void
Opcode_ae_mul32x16_h0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x26000;
}

static void
Opcode_ae_mulf32x16_h1_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x64000;
}

static void
Opcode_ae_mulf32x16_h1_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc70040;
}

static void
Opcode_ae_mul32x16_h1_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6000;
}

static void
Opcode_ae_mul32x16_h1_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc30090;
}

static void
Opcode_ae_mulf32x16_h1_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70000;
}

static void
Opcode_ae_mul32x16_h1_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x27000;
}

static void
Opcode_ae_mulf32x16_h2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x65000;
}

static void
Opcode_ae_mulf32x16_h2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf0040;
}

static void
Opcode_ae_mul32x16_h2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7000;
}

static void
Opcode_ae_mul32x16_h2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcb0090;
}

static void
Opcode_ae_mulf32x16_h2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x71000;
}

static void
Opcode_ae_mul32x16_h2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x28000;
}

static void
Opcode_ae_mulf32x16_h3_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x66000;
}

static void
Opcode_ae_mulf32x16_h3_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc70050;
}

static void
Opcode_ae_mul32x16_h3_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8000;
}

static void
Opcode_ae_mul32x16_h3_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc300a0;
}

static void
Opcode_ae_mulf32x16_h3_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x72000;
}

static void
Opcode_ae_mul32x16_h3_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x29000;
}

static void
Opcode_ae_mulaf32x16_l0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x39000;
}

static void
Opcode_ae_mulaf32x16_l0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc50070;
}

static void
Opcode_ae_mula32x16_l0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x15000;
}

static void
Opcode_ae_mula32x16_l0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc0000;
}

static void
Opcode_ae_mulaf32x16_l0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4e000;
}

static void
Opcode_ae_mula32x16_l0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x33000;
}

static void
Opcode_ae_mulaf32x16_l1_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3a000;
}

static void
Opcode_ae_mulaf32x16_l1_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd0070;
}

static void
Opcode_ae_mula32x16_l1_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16000;
}

static void
Opcode_ae_mula32x16_l1_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc40010;
}

static void
Opcode_ae_mulaf32x16_l1_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4f000;
}

static void
Opcode_ae_mula32x16_l1_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x34000;
}

static void
Opcode_ae_mulaf32x16_l2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b000;
}

static void
Opcode_ae_mulaf32x16_l2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc50080;
}

static void
Opcode_ae_mula32x16_l2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x17000;
}

static void
Opcode_ae_mula32x16_l2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc0010;
}

static void
Opcode_ae_mulaf32x16_l2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50000;
}

static void
Opcode_ae_mula32x16_l2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x35000;
}

static void
Opcode_ae_mulaf32x16_l3_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c000;
}

static void
Opcode_ae_mulaf32x16_l3_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd0080;
}

static void
Opcode_ae_mula32x16_l3_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x18000;
}

static void
Opcode_ae_mula32x16_l3_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc40020;
}

static void
Opcode_ae_mulaf32x16_l3_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x51000;
}

static void
Opcode_ae_mula32x16_l3_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36000;
}

static void
Opcode_ae_mulaf32x16_h0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x35000;
}

static void
Opcode_ae_mulaf32x16_h0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc50050;
}

static void
Opcode_ae_mula32x16_h0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x11000;
}

static void
Opcode_ae_mula32x16_h0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcb00e0;
}

static void
Opcode_ae_mulaf32x16_h0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4a000;
}

static void
Opcode_ae_mula32x16_h0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2f000;
}

static void
Opcode_ae_mulaf32x16_h1_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36000;
}

static void
Opcode_ae_mulaf32x16_h1_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd0050;
}

static void
Opcode_ae_mula32x16_h1_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x12000;
}

static void
Opcode_ae_mula32x16_h1_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc300f0;
}

static void
Opcode_ae_mulaf32x16_h1_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4b000;
}

static void
Opcode_ae_mula32x16_h1_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30000;
}

static void
Opcode_ae_mulaf32x16_h2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x37000;
}

static void
Opcode_ae_mulaf32x16_h2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc50060;
}

static void
Opcode_ae_mula32x16_h2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13000;
}

static void
Opcode_ae_mula32x16_h2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcb00f0;
}

static void
Opcode_ae_mulaf32x16_h2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4c000;
}

static void
Opcode_ae_mula32x16_h2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x31000;
}

static void
Opcode_ae_mulaf32x16_h3_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x38000;
}

static void
Opcode_ae_mulaf32x16_h3_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd0060;
}

static void
Opcode_ae_mula32x16_h3_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x14000;
}

static void
Opcode_ae_mula32x16_h3_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc40000;
}

static void
Opcode_ae_mulaf32x16_h3_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4d000;
}

static void
Opcode_ae_mula32x16_h3_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x32000;
}

static void
Opcode_ae_mulsf32x16_l0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9c000;
}

static void
Opcode_ae_mulsf32x16_l0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd90080;
}

static void
Opcode_ae_muls32x16_l0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x86000;
}

static void
Opcode_ae_muls32x16_l0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00080;
}

static void
Opcode_ae_mulsf32x16_l0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9d000;
}

static void
Opcode_ae_muls32x16_l0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8d000;
}

static void
Opcode_ae_mulsf32x16_l1_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9d000;
}

static void
Opcode_ae_mulsf32x16_l1_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd10090;
}

static void
Opcode_ae_muls32x16_l1_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x87000;
}

static void
Opcode_ae_muls32x16_l1_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd80080;
}

static void
Opcode_ae_mulsf32x16_l1_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9e000;
}

static void
Opcode_ae_muls32x16_l1_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8e000;
}

static void
Opcode_ae_mulsf32x16_l2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9e000;
}

static void
Opcode_ae_mulsf32x16_l2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd90090;
}

static void
Opcode_ae_muls32x16_l2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x88000;
}

static void
Opcode_ae_muls32x16_l2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00090;
}

static void
Opcode_ae_mulsf32x16_l2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9f000;
}

static void
Opcode_ae_muls32x16_l2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8f000;
}

static void
Opcode_ae_mulsf32x16_l3_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9f000;
}

static void
Opcode_ae_mulsf32x16_l3_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd100a0;
}

static void
Opcode_ae_muls32x16_l3_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x89000;
}

static void
Opcode_ae_muls32x16_l3_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd80090;
}

static void
Opcode_ae_mulsf32x16_l3_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0000;
}

static void
Opcode_ae_muls32x16_l3_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90000;
}

static void
Opcode_ae_mulsf32x16_h0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x98000;
}

static void
Opcode_ae_mulsf32x16_h0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd90060;
}

static void
Opcode_ae_muls32x16_h0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x82000;
}

static void
Opcode_ae_muls32x16_h0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00060;
}

static void
Opcode_ae_mulsf32x16_h0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x99000;
}

static void
Opcode_ae_muls32x16_h0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x89000;
}

static void
Opcode_ae_mulsf32x16_h1_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x99000;
}

static void
Opcode_ae_mulsf32x16_h1_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd10070;
}

static void
Opcode_ae_muls32x16_h1_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x83000;
}

static void
Opcode_ae_muls32x16_h1_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd80060;
}

static void
Opcode_ae_mulsf32x16_h1_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9a000;
}

static void
Opcode_ae_muls32x16_h1_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8a000;
}

static void
Opcode_ae_mulsf32x16_h2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9a000;
}

static void
Opcode_ae_mulsf32x16_h2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd90070;
}

static void
Opcode_ae_muls32x16_h2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x84000;
}

static void
Opcode_ae_muls32x16_h2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00070;
}

static void
Opcode_ae_mulsf32x16_h2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9b000;
}

static void
Opcode_ae_muls32x16_h2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8b000;
}

static void
Opcode_ae_mulsf32x16_h3_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9b000;
}

static void
Opcode_ae_mulsf32x16_h3_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd10080;
}

static void
Opcode_ae_muls32x16_h3_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x85000;
}

static void
Opcode_ae_muls32x16_h3_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd80070;
}

static void
Opcode_ae_mulsf32x16_h3_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9c000;
}

static void
Opcode_ae_muls32x16_h3_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8c000;
}

static void
Opcode_ae_mulaafd32x16_h3_l2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2a000;
}

static void
Opcode_ae_mulaafd32x16_h3_l2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc400b0;
}

static void
Opcode_ae_mulaad32x16_h3_l2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x21000;
}

static void
Opcode_ae_mulaad32x16_h3_l2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc0060;
}

static void
Opcode_ae_mulaafd32x16_h3_l2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x46000;
}

static void
Opcode_ae_mulaad32x16_h3_l2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d000;
}

static void
Opcode_ae_mulaafd32x16_h1_l0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x28000;
}

static void
Opcode_ae_mulaafd32x16_h1_l0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc400a0;
}

static void
Opcode_ae_mulaad32x16_h1_l0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f000;
}

static void
Opcode_ae_mulaad32x16_h1_l0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc0050;
}

static void
Opcode_ae_mulaafd32x16_h1_l0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x44000;
}

static void
Opcode_ae_mulaad32x16_h1_l0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b000;
}

static void
Opcode_ae_mulasfd32x16_h3_l2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x58000;
}

static void
Opcode_ae_mulasfd32x16_h3_l2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce0090;
}

static void
Opcode_ae_mulasd32x16_h3_l2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x54000;
}

static void
Opcode_ae_mulasd32x16_h3_l2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce0070;
}

static void
Opcode_ae_mulasfd32x16_h3_l2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6b000;
}

static void
Opcode_ae_mulasd32x16_h3_l2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67000;
}

static void
Opcode_ae_mulasfd32x16_h1_l0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x57000;
}

static void
Opcode_ae_mulasfd32x16_h1_l0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc60090;
}

static void
Opcode_ae_mulasd32x16_h1_l0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x53000;
}

static void
Opcode_ae_mulasd32x16_h1_l0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc60070;
}

static void
Opcode_ae_mulasfd32x16_h1_l0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a000;
}

static void
Opcode_ae_mulasd32x16_h1_l0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x66000;
}

static void
Opcode_ae_mulsafd32x16_h3_l2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90000;
}

static void
Opcode_ae_mulsafd32x16_h3_l2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd000e0;
}

static void
Opcode_ae_mulsad32x16_h3_l2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd800c0;
}

static void
Opcode_ae_mulsafd32x16_h3_l2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x96000;
}

static void
Opcode_ae_mulsad32x16_h3_l2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x93000;
}

static void
Opcode_ae_mulsafd32x16_h1_l0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8f000;
}

static void
Opcode_ae_mulsafd32x16_h1_l0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd800d0;
}

static void
Opcode_ae_mulsad32x16_h1_l0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd000c0;
}

static void
Opcode_ae_mulsafd32x16_h1_l0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x95000;
}

static void
Opcode_ae_mulsad32x16_h1_l0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x92000;
}

static void
Opcode_ae_mulssfd32x16_h3_l2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbd000;
}

static void
Opcode_ae_mulssfd32x16_h3_l2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd200b0;
}

static void
Opcode_ae_mulssd32x16_h3_l2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb6000;
}

static void
Opcode_ae_mulssd32x16_h3_l2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda0070;
}

static void
Opcode_ae_mulssfd32x16_h3_l2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbd000;
}

static void
Opcode_ae_mulssd32x16_h3_l2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb6000;
}

static void
Opcode_ae_mulssfd32x16_h1_l0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbc000;
}

static void
Opcode_ae_mulssfd32x16_h1_l0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda00a0;
}

static void
Opcode_ae_mulssd32x16_h1_l0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb5000;
}

static void
Opcode_ae_mulssd32x16_h1_l0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd20070;
}

static void
Opcode_ae_mulssfd32x16_h1_l0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbc000;
}

static void
Opcode_ae_mulssd32x16_h1_l0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb5000;
}

static void
Opcode_ae_mulzaafd32x16_h3_l2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc000;
}

static void
Opcode_ae_mulzaafd32x16_h3_l2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb0020;
}

static void
Opcode_ae_mulzaad32x16_h3_l2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc3000;
}

static void
Opcode_ae_mulzaad32x16_h3_l2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd200e0;
}

static void
Opcode_ae_mulzaafd32x16_h3_l2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc000;
}

static void
Opcode_ae_mulzaad32x16_h3_l2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc3000;
}

static void
Opcode_ae_mulzaafd32x16_h1_l0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xca000;
}

static void
Opcode_ae_mulzaafd32x16_h1_l0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb0010;
}

static void
Opcode_ae_mulzaad32x16_h1_l0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc1000;
}

static void
Opcode_ae_mulzaad32x16_h1_l0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd200d0;
}

static void
Opcode_ae_mulzaafd32x16_h1_l0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xca000;
}

static void
Opcode_ae_mulzaad32x16_h1_l0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc1000;
}

static void
Opcode_ae_mulzasfd32x16_h3_l2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd4000;
}

static void
Opcode_ae_mulzasfd32x16_h3_l2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb0060;
}

static void
Opcode_ae_mulzasd32x16_h3_l2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0000;
}

static void
Opcode_ae_mulzasd32x16_h3_l2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb0040;
}

static void
Opcode_ae_mulzasfd32x16_h3_l2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd4000;
}

static void
Opcode_ae_mulzasd32x16_h3_l2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0000;
}

static void
Opcode_ae_mulzasfd32x16_h1_l0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd3000;
}

static void
Opcode_ae_mulzasfd32x16_h1_l0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd30060;
}

static void
Opcode_ae_mulzasd32x16_h1_l0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf000;
}

static void
Opcode_ae_mulzasd32x16_h1_l0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd30040;
}

static void
Opcode_ae_mulzasfd32x16_h1_l0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd3000;
}

static void
Opcode_ae_mulzasd32x16_h1_l0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf000;
}

static void
Opcode_ae_mulzsafd32x16_h3_l2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd8000;
}

static void
Opcode_ae_mulzsafd32x16_h3_l2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb0090;
}

static void
Opcode_ae_mulzsad32x16_h3_l2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd30080;
}

static void
Opcode_ae_mulzsafd32x16_h3_l2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda000;
}

static void
Opcode_ae_mulzsad32x16_h3_l2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd7000;
}

static void
Opcode_ae_mulzsafd32x16_h1_l0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd7000;
}

static void
Opcode_ae_mulzsafd32x16_h1_l0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd30090;
}

static void
Opcode_ae_mulzsad32x16_h1_l0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb0070;
}

static void
Opcode_ae_mulzsafd32x16_h1_l0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd9000;
}

static void
Opcode_ae_mulzsad32x16_h1_l0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd6000;
}

static void
Opcode_ae_mulzssfd32x16_h3_l2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe3000;
}

static void
Opcode_ae_mulzssfd32x16_h3_l2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd300f0;
}

static void
Opcode_ae_mulzssd32x16_h3_l2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc000;
}

static void
Opcode_ae_mulzssd32x16_h3_l2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb00b0;
}

static void
Opcode_ae_mulzssfd32x16_h3_l2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe5000;
}

static void
Opcode_ae_mulzssd32x16_h3_l2_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xde000;
}

static void
Opcode_ae_mulzssfd32x16_h1_l0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe2000;
}

static void
Opcode_ae_mulzssfd32x16_h1_l0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb00e0;
}

static void
Opcode_ae_mulzssd32x16_h1_l0_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb000;
}

static void
Opcode_ae_mulzssd32x16_h1_l0_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd300b0;
}

static void
Opcode_ae_mulzssfd32x16_h1_l0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe4000;
}

static void
Opcode_ae_mulzssd32x16_h1_l0_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdd000;
}

static void
Opcode_ae_mulzaafd32x16_h2_l3_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcb000;
}

static void
Opcode_ae_mulzaafd32x16_h2_l3_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd30020;
}

static void
Opcode_ae_mulzaafd32x16_h0_l1_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc9000;
}

static void
Opcode_ae_mulzaafd32x16_h0_l1_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd30010;
}

static void
Opcode_ae_mulaafd32x16_h2_l3_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x29000;
}

static void
Opcode_ae_mulaafd32x16_h2_l3_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc00a0;
}

static void
Opcode_ae_mulaafd32x16_h0_l1_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x27000;
}

static void
Opcode_ae_mulaafd32x16_h0_l1_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc0090;
}

static void
Opcode_ae_mulzaad32x16_h2_l3_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc2000;
}

static void
Opcode_ae_mulzaad32x16_h2_l3_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda00d0;
}

static void
Opcode_ae_mulzaad32x16_h0_l1_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0000;
}

static void
Opcode_ae_mulzaad32x16_h0_l1_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda00c0;
}

static void
Opcode_ae_mulaad32x16_h2_l3_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20000;
}

static void
Opcode_ae_mulaad32x16_h2_l3_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc40060;
}

static void
Opcode_ae_mulaad32x16_h0_l1_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e000;
}

static void
Opcode_ae_mulaad32x16_h0_l1_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc40050;
}

static void
Opcode_ae_mulzaafd32x16_h2_l3_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcb000;
}

static void
Opcode_ae_mulzaafd32x16_h0_l1_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc9000;
}

static void
Opcode_ae_mulaafd32x16_h2_l3_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x45000;
}

static void
Opcode_ae_mulaafd32x16_h0_l1_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x43000;
}

static void
Opcode_ae_mulzaad32x16_h2_l3_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc2000;
}

static void
Opcode_ae_mulzaad32x16_h0_l1_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0000;
}

static void
Opcode_ae_mulaad32x16_h2_l3_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c000;
}

static void
Opcode_ae_mulaad32x16_h0_l1_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3a000;
}

static void
Opcode_ae_mulp32x16x2_h_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd80000;
}

static void
Opcode_ae_mulfp32x16x2rs_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x74000;
}

static void
Opcode_ae_mulfp32x16x2rs_h_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc700d0;
}

static void
Opcode_ae_mulfp32x16x2ras_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x72000;
}

static void
Opcode_ae_mulfp32x16x2ras_h_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc700c0;
}

static void
Opcode_ae_mulfp32x16x2rs_h_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7d000;
}

static void
Opcode_ae_mulfp32x16x2ras_h_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7b000;
}

static void
Opcode_ae_mulp32x16x2_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00010;
}

static void
Opcode_ae_mulfp32x16x2rs_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x75000;
}

static void
Opcode_ae_mulfp32x16x2rs_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf00d0;
}

static void
Opcode_ae_mulfp32x16x2ras_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73000;
}

static void
Opcode_ae_mulfp32x16x2ras_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf00c0;
}

static void
Opcode_ae_mulfp32x16x2rs_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7e000;
}

static void
Opcode_ae_mulfp32x16x2ras_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7c000;
}

static void
Opcode_ae_mulap32x16x2_h_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc60010;
}

static void
Opcode_ae_mulafp32x16x2rs_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x46000;
}

static void
Opcode_ae_mulafp32x16x2rs_h_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd00d0;
}

static void
Opcode_ae_mulafp32x16x2ras_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x44000;
}

static void
Opcode_ae_mulafp32x16x2ras_h_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd00c0;
}

static void
Opcode_ae_mulafp32x16x2rs_h_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x58000;
}

static void
Opcode_ae_mulafp32x16x2ras_h_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x56000;
}

static void
Opcode_ae_mulap32x16x2_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce0010;
}

static void
Opcode_ae_mulafp32x16x2rs_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x47000;
}

static void
Opcode_ae_mulafp32x16x2rs_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc500e0;
}

static void
Opcode_ae_mulafp32x16x2ras_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x45000;
}

static void
Opcode_ae_mulafp32x16x2ras_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc500d0;
}

static void
Opcode_ae_mulafp32x16x2rs_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x59000;
}

static void
Opcode_ae_mulafp32x16x2ras_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x57000;
}

static void
Opcode_ae_mulsp32x16x2_h_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd20010;
}

static void
Opcode_ae_mulsfp32x16x2rs_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa6000;
}

static void
Opcode_ae_mulsfp32x16x2rs_h_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd900d0;
}

static void
Opcode_ae_mulsfp32x16x2ras_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa4000;
}

static void
Opcode_ae_mulsfp32x16x2ras_h_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd900c0;
}

static void
Opcode_ae_mulsfp32x16x2rs_h_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa7000;
}

static void
Opcode_ae_mulsfp32x16x2ras_h_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa5000;
}

static void
Opcode_ae_mulsp32x16x2_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda0010;
}

static void
Opcode_ae_mulsfp32x16x2rs_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa7000;
}

static void
Opcode_ae_mulsfp32x16x2rs_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd100e0;
}

static void
Opcode_ae_mulsfp32x16x2ras_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa5000;
}

static void
Opcode_ae_mulsfp32x16x2ras_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd100d0;
}

static void
Opcode_ae_mulsfp32x16x2rs_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa8000;
}

static void
Opcode_ae_mulsfp32x16x2ras_l_s2_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa6000;
}

static void
Opcode_ae_mulp32x2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7b000;
}

static void
Opcode_ae_mulp32x2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd80010;
}

static void
Opcode_ae_mulfp32x2rs_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x77000;
}

static void
Opcode_ae_mulfp32x2rs_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf00e0;
}

static void
Opcode_ae_mulfp32x2ras_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x76000;
}

static void
Opcode_ae_mulfp32x2ras_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc700e0;
}

static void
Opcode_ae_mulap32x2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4b000;
}

static void
Opcode_ae_mulap32x2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc60020;
}

static void
Opcode_ae_mulafp32x2rs_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x49000;
}

static void
Opcode_ae_mulafp32x2rs_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc500f0;
}

static void
Opcode_ae_mulafp32x2ras_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x48000;
}

static void
Opcode_ae_mulafp32x2ras_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd00e0;
}

static void
Opcode_ae_mulsp32x2_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xab000;
}

static void
Opcode_ae_mulsp32x2_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd20020;
}

static void
Opcode_ae_mulsfp32x2rs_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa9000;
}

static void
Opcode_ae_mulsfp32x2rs_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd100f0;
}

static void
Opcode_ae_mulsfp32x2ras_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa8000;
}

static void
Opcode_ae_mulsfp32x2ras_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd900e0;
}

static void
Opcode_ae_mulfp16x4s_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf00a0;
}

static void
Opcode_ae_mulfp16x4ras_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc700a0;
}

static void
Opcode_ae_mulc24_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x59000;
}

static void
Opcode_ae_mulc24_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc600a0;
}

static void
Opcode_ae_mulfc24ra_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6d000;
}

static void
Opcode_ae_mulfc24ra_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf0080;
}

static void
Opcode_ae_mulc32x16_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5b000;
}

static void
Opcode_ae_mulc32x16_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc600b0;
}

static void
Opcode_ae_mulfc32x16ras_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6f000;
}

static void
Opcode_ae_mulfc32x16ras_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf0090;
}

static void
Opcode_ae_mulc32x16_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a000;
}

static void
Opcode_ae_mulc32x16_h_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce00a0;
}

static void
Opcode_ae_mulfc32x16ras_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6e000;
}

static void
Opcode_ae_mulfc32x16ras_h_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc70090;
}

static void
Opcode_ae_mulac24_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b000;
}

static void
Opcode_ae_mulac24_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc00b0;
}

static void
Opcode_ae_mulafc24ra_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f000;
}

static void
Opcode_ae_mulafc24ra_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc500a0;
}

static void
Opcode_ae_mulac32x16_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d000;
}

static void
Opcode_ae_mulac32x16_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc00c0;
}

static void
Opcode_ae_mulafc32x16ras_l_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x41000;
}

static void
Opcode_ae_mulafc32x16ras_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc500b0;
}

static void
Opcode_ae_mulac32x16_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2c000;
}

static void
Opcode_ae_mulac32x16_h_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc400c0;
}

static void
Opcode_ae_mulafc32x16ras_h_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40000;
}

static void
Opcode_ae_mulafc32x16ras_h_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd00a0;
}

static void
Opcode_ae_mulf16x4ss_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc90000;
}

static void
Opcode_ae_mulaf16x4ss_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc10000;
}

static void
Opcode_ae_mulsf16x4ss_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xca0000;
}

static void
Opcode_ae_mul16x4_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc00000;
}

static void
Opcode_ae_mula16x4_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc80000;
}

static void
Opcode_ae_muls16x4_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc20000;
}

static void
Opcode_ae_mulfd24x2_fir_h_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x600000;
}

static void
Opcode_ae_mulfd24x2_fir_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700000;
}

static void
Opcode_ae_mulfd32x16x2_fir_hh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800000;
}

static void
Opcode_ae_mulfd32x16x2_fir_hl_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x900000;
}

static void
Opcode_ae_mulfd32x16x2_fir_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa00000;
}

static void
Opcode_ae_mulfd32x16x2_fir_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb00000;
}

static void
Opcode_ae_mulafd24x2_fir_h_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_ae_mulafd24x2_fir_l_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100000;
}

static void
Opcode_ae_mulafd32x16x2_fir_hh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200000;
}

static void
Opcode_ae_mulafd32x16x2_fir_hl_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300000;
}

static void
Opcode_ae_mulafd32x16x2_fir_lh_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400000;
}

static void
Opcode_ae_mulafd32x16x2_fir_ll_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x500000;
}

static void
Opcode_ae_div64d32_h_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x47300;
}

static void
Opcode_ae_div64d32_h_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ab007;
}

static void
Opcode_ae_div64d32_l_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0404;
}

static void
Opcode_ae_div64d32_l_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x47400;
}

static void
Opcode_ae_div64d32_l_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801ab008;
}

static void
Opcode_ae_sha32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x360084;
}

static void
Opcode_ae_vldl32t_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0004;
}

static void
Opcode_ae_vldl16t_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf0004;
}

static void
Opcode_ae_vldl16c_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x77e064;
}

static void
Opcode_ae_vldl16c_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x77e084;
}

static void
Opcode_ae_vldl16c_ic_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x77e074;
}

static void
Opcode_ae_vldsht_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x341004;
}

static void
Opcode_ae_lb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x690204;
}

static void
Opcode_ae_lbi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x690304;
}

static void
Opcode_ae_lbk_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x830004;
}

static void
Opcode_ae_lbki_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce0004;
}

static void
Opcode_ae_lbs_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x690604;
}

static void
Opcode_ae_lbsi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x690704;
}

static void
Opcode_ae_db_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x774004;
}

static void
Opcode_ae_dbi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x775004;
}

static void
Opcode_ae_db_ic_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x776004;
}

static void
Opcode_ae_dbi_ic_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x777004;
}

static void
Opcode_ae_db_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x778004;
}

static void
Opcode_ae_dbi_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x779004;
}

static void
Opcode_ae_vlel32t_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00004;
}

static void
Opcode_ae_vlel16t_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd10004;
}

static void
Opcode_ae_sb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x77a004;
}

static void
Opcode_ae_sbi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x630004;
}

static void
Opcode_ae_vles16c_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x77e004;
}

static void
Opcode_ae_sbf_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x77e014;
}

static void
Opcode_ae_sb_ic_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x77b004;
}

static void
Opcode_ae_sbi_ic_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x560004;
}

static void
Opcode_ae_vles16c_ic_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x77e024;
}

static void
Opcode_ae_sbf_ic_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x77e034;
}

static void
Opcode_ae_sb_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x77c004;
}

static void
Opcode_ae_sbi_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x570004;
}

static void
Opcode_ae_vles16c_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x77e044;
}

static void
Opcode_ae_sbf_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x77e054;
}

static void
Opcode_ae_sext32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x170004;
}

static void
Opcode_ae_sext32_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe9000;
}

static void
Opcode_ae_sext32_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80159000;
}

static void
Opcode_lsi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3;
}

static void
Opcode_lsip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8003;
}

static void
Opcode_lsx_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80000;
}

static void
Opcode_lsxp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x180000;
}

static void
Opcode_ssi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4003;
}

static void
Opcode_ssip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc003;
}

static void
Opcode_ssx_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x480000;
}

static void
Opcode_ssxp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x580000;
}

static void
Opcode_abs_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfa0010;
}

static void
Opcode_neg_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfa0060;
}

static void
Opcode_mov_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfa0000;
}

static void
Opcode_moveqz_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8b0000;
}

static void
Opcode_movnez_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9b0000;
}

static void
Opcode_movltz_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xab0000;
}

static void
Opcode_movgez_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbb0000;
}

static void
Opcode_movf_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcb0000;
}

static void
Opcode_movt_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb0000;
}

static void
Opcode_wfr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfa0050;
}

static void
Opcode_rfr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfa0040;
}

static void
Opcode_round_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8a0000;
}

static void
Opcode_ceil_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0000;
}

static void
Opcode_floor_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xaa0000;
}

static void
Opcode_trunc_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9a0000;
}

static void
Opcode_utrunc_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea0000;
}

static void
Opcode_float_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xca0000;
}

static void
Opcode_ufloat_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda0000;
}

static void
Opcode_un_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b0000;
}

static void
Opcode_ult_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5b0000;
}

static void
Opcode_ule_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7b0000;
}

static void
Opcode_ueq_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b0000;
}

static void
Opcode_olt_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4b0000;
}

static void
Opcode_ole_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6b0000;
}

static void
Opcode_oeq_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0000;
}

static void
Opcode_add_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0000;
}

static void
Opcode_sub_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a0000;
}

static void
Opcode_mul_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2a0000;
}

static void
Opcode_madd_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4a0000;
}

static void
Opcode_msub_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a0000;
}

static void
Opcode_sqrt0_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfa0090;
}

static void
Opcode_div0_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfa0070;
}

static void
Opcode_recip0_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfa0080;
}

static void
Opcode_rsqrt0_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfa00a0;
}

static void
Opcode_maddn_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a0000;
}

static void
Opcode_divn_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7a0000;
}

static void
Opcode_const_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfa0030;
}

static void
Opcode_nexp01_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfa00b0;
}

static void
Opcode_addexp_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfa00e0;
}

static void
Opcode_addexpm_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfa00f0;
}

static void
Opcode_mkdadj_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfa00d0;
}

static void
Opcode_mksadj_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfa00c0;
}

static void
Opcode_excw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2080;
}

static void
Opcode_rfe_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3000;
}

static void
Opcode_rfde_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3200;
}

static void
Opcode_syscall_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5000;
}

static void
Opcode_call12_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x35;
}

static void
Opcode_call8_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x25;
}

static void
Opcode_call4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x15;
}

static void
Opcode_callx12_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf0;
}

static void
Opcode_callx8_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0;
}

static void
Opcode_callx4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0;
}

static void
Opcode_entry_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36;
}

static void
Opcode_movsp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1000;
}

static void
Opcode_rotw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x408000;
}

static void
Opcode_retw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90;
}

static void
Opcode_retw_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf01d;
}

static void
Opcode_rfwo_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3400;
}

static void
Opcode_rfwu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3500;
}

static void
Opcode_l32e_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90000;
}

static void
Opcode_s32e_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x490000;
}

static void
Opcode_rsr_windowbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x34800;
}

static void
Opcode_wsr_windowbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x134800;
}

static void
Opcode_xsr_windowbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x614800;
}

static void
Opcode_rsr_windowstart_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x34900;
}

static void
Opcode_wsr_windowstart_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x134900;
}

static void
Opcode_xsr_windowstart_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x614900;
}

static void
Opcode_rfme_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3020;
}

static void
Opcode_rsr_mesr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36d00;
}

static void
Opcode_wsr_mesr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x136d00;
}

static void
Opcode_xsr_mesr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x616d00;
}

static void
Opcode_rsr_mecr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36e00;
}

static void
Opcode_wsr_mecr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x136e00;
}

static void
Opcode_xsr_mecr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x616e00;
}

static void
Opcode_rsr_mepc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36a00;
}

static void
Opcode_wsr_mepc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x136a00;
}

static void
Opcode_xsr_mepc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x616a00;
}

static void
Opcode_rsr_meps_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36b00;
}

static void
Opcode_wsr_meps_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x136b00;
}

static void
Opcode_xsr_meps_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x616b00;
}

static void
Opcode_rsr_mesave_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36c00;
}

static void
Opcode_wsr_mesave_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x136c00;
}

static void
Opcode_xsr_mesave_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x616c00;
}

static void
Opcode_rsr_mevaddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36f00;
}

static void
Opcode_wsr_mevaddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x136f00;
}

static void
Opcode_xsr_mevaddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x616f00;
}

static void
Opcode_add_n_Slot_inst16a_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa;
}

static void
Opcode_addi_n_Slot_inst16a_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb;
}

static void
Opcode_beqz_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8c;
}

static void
Opcode_bnez_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc;
}

static void
Opcode_ill_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf06d;
}

static void
Opcode_l32i_n_Slot_inst16a_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8;
}

static void
Opcode_mov_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd;
}

static void
Opcode_movi_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc;
}

static void
Opcode_nop_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf03d;
}

static void
Opcode_ret_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf00d;
}

static void
Opcode_s32i_n_Slot_inst16a_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9;
}

static void
Opcode_rur_threadptr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe30e70;
}

static void
Opcode_wur_threadptr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf3e700;
}

static void
Opcode_addi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc002;
}

static void
Opcode_addi_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20000;
}

static void
Opcode_addi_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80040000;
}

static void
Opcode_addi_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_addmi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd002;
}

static void
Opcode_addmi_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30000;
}

static void
Opcode_addmi_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80050000;
}

static void
Opcode_addmi_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10000;
}

static void
Opcode_add_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800000;
}

static void
Opcode_add_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50000;
}

static void
Opcode_add_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800d0000;
}

static void
Opcode_sub_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc00000;
}

static void
Opcode_sub_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a000;
}

static void
Opcode_sub_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800da000;
}

static void
Opcode_addx2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x900000;
}

static void
Opcode_addx2_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x51000;
}

static void
Opcode_addx2_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800d1000;
}

static void
Opcode_addx4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa00000;
}

static void
Opcode_addx4_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x52000;
}

static void
Opcode_addx4_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800d2000;
}

static void
Opcode_addx8_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb00000;
}

static void
Opcode_addx8_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x53000;
}

static void
Opcode_addx8_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800d3000;
}

static void
Opcode_subx2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00000;
}

static void
Opcode_subx2_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5b000;
}

static void
Opcode_subx2_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800db000;
}

static void
Opcode_subx4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe00000;
}

static void
Opcode_subx4_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5c000;
}

static void
Opcode_subx4_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800dc000;
}

static void
Opcode_subx8_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf00000;
}

static void
Opcode_subx8_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5d000;
}

static void
Opcode_subx8_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800dd000;
}

static void
Opcode_and_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100000;
}

static void
Opcode_or_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200000;
}

static void
Opcode_or_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x59000;
}

static void
Opcode_or_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800d9000;
}

static void
Opcode_xor_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300000;
}

static void
Opcode_beqi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x26;
}

static void
Opcode_bnei_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x66;
}

static void
Opcode_bgei_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe6;
}

static void
Opcode_blti_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa6;
}

static void
Opcode_bbci_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6007;
}

static void
Opcode_bbsi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe007;
}

static void
Opcode_bgeui_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf6;
}

static void
Opcode_bltui_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb6;
}

static void
Opcode_beq_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1007;
}

static void
Opcode_bne_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9007;
}

static void
Opcode_bge_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa007;
}

static void
Opcode_blt_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2007;
}

static void
Opcode_bgeu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb007;
}

static void
Opcode_bltu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3007;
}

static void
Opcode_bany_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8007;
}

static void
Opcode_bnone_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7;
}

static void
Opcode_ball_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4007;
}

static void
Opcode_bnall_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc007;
}

static void
Opcode_bbc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5007;
}

static void
Opcode_bbs_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd007;
}

static void
Opcode_beqz_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16;
}

static void
Opcode_bnez_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x56;
}

static void
Opcode_bgez_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd6;
}

static void
Opcode_bltz_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x96;
}

static void
Opcode_call0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5;
}

static void
Opcode_callx0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0;
}

static void
Opcode_extui_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40000;
}

static void
Opcode_extui_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_extui_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80000000;
}

static void
Opcode_ill_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_j_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6;
}

static void
Opcode_jx_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0;
}

static void
Opcode_l16ui_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1002;
}

static void
Opcode_l16si_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9002;
}

static void
Opcode_l32i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2002;
}

static void
Opcode_l32r_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1;
}

static void
Opcode_l8ui_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2;
}

static void
Opcode_loop_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8076;
}

static void
Opcode_loopnez_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9076;
}

static void
Opcode_loopgtz_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa076;
}

static void
Opcode_movi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa002;
}

static void
Opcode_movi_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40000;
}

static void
Opcode_movi_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80060000;
}

static void
Opcode_movi_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40000;
}

static void
Opcode_moveqz_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x830000;
}

static void
Opcode_moveqz_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x55000;
}

static void
Opcode_moveqz_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800d5000;
}

static void
Opcode_movnez_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x930000;
}

static void
Opcode_movnez_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x58000;
}

static void
Opcode_movnez_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800d8000;
}

static void
Opcode_movltz_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa30000;
}

static void
Opcode_movltz_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x57000;
}

static void
Opcode_movltz_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800d7000;
}

static void
Opcode_movgez_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb30000;
}

static void
Opcode_movgez_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x56000;
}

static void
Opcode_movgez_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800d6000;
}

static void
Opcode_neg_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x600000;
}

static void
Opcode_abs_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x600100;
}

static void
Opcode_nop_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20f0;
}

static void
Opcode_nop_Slot_ae_slot2_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xeb000;
}

static void
Opcode_nop_Slot_ae_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfb0f0;
}

static void
Opcode_nop_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdd295;
}

static void
Opcode_nop_Slot_ae_slot2_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x48600;
}

static void
Opcode_nop_Slot_ae2_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd410b0;
}

static void
Opcode_nop_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x801a3995;
}

static void
Opcode_nop_Slot_ae_minislot2_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50b50;
}

static void
Opcode_nop_Slot_ae_minislot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_nop_Slot_ae_minislot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x14600;
}

static void
Opcode_ret_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80;
}

static void
Opcode_simcall_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5100;
}

static void
Opcode_s16i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5002;
}

static void
Opcode_s32i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6002;
}

static void
Opcode_s32nb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x590000;
}

static void
Opcode_s8i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4002;
}

static void
Opcode_ssr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400000;
}

static void
Opcode_ssl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x401000;
}

static void
Opcode_ssa8l_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x402000;
}

static void
Opcode_ssa8b_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x403000;
}

static void
Opcode_ssai_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x404000;
}

static void
Opcode_sll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa10000;
}

static void
Opcode_src_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x810000;
}

static void
Opcode_srl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x910000;
}

static void
Opcode_sra_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb10000;
}

static void
Opcode_slli_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10000;
}

static void
Opcode_srai_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x210000;
}

static void
Opcode_srli_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x410000;
}

static void
Opcode_memw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20c0;
}

static void
Opcode_extw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20d0;
}

static void
Opcode_isync_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2000;
}

static void
Opcode_rsync_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2010;
}

static void
Opcode_esync_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2020;
}

static void
Opcode_dsync_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2030;
}

static void
Opcode_rsil_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6000;
}

static void
Opcode_rsr_lend_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30100;
}

static void
Opcode_wsr_lend_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130100;
}

static void
Opcode_xsr_lend_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610100;
}

static void
Opcode_rsr_lcount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30200;
}

static void
Opcode_wsr_lcount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130200;
}

static void
Opcode_xsr_lcount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610200;
}

static void
Opcode_rsr_lbeg_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30000;
}

static void
Opcode_wsr_lbeg_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130000;
}

static void
Opcode_xsr_lbeg_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610000;
}

static void
Opcode_rsr_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30300;
}

static void
Opcode_wsr_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130300;
}

static void
Opcode_xsr_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610300;
}

static void
Opcode_rsr_memctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36100;
}

static void
Opcode_wsr_memctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x136100;
}

static void
Opcode_xsr_memctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x616100;
}

static void
Opcode_rsr_litbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30500;
}

static void
Opcode_wsr_litbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130500;
}

static void
Opcode_xsr_litbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610500;
}

static void
Opcode_rsr_configid0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b000;
}

static void
Opcode_wsr_configid0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13b000;
}

static void
Opcode_rsr_configid1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d000;
}

static void
Opcode_rsr_243_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f300;
}

static void
Opcode_rsr_ps_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e600;
}

static void
Opcode_wsr_ps_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e600;
}

static void
Opcode_xsr_ps_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61e600;
}

static void
Opcode_rsr_epc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b100;
}

static void
Opcode_wsr_epc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13b100;
}

static void
Opcode_xsr_epc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61b100;
}

static void
Opcode_rsr_excsave1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d100;
}

static void
Opcode_wsr_excsave1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13d100;
}

static void
Opcode_xsr_excsave1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61d100;
}

static void
Opcode_rsr_epc2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b200;
}

static void
Opcode_wsr_epc2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13b200;
}

static void
Opcode_xsr_epc2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61b200;
}

static void
Opcode_rsr_excsave2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d200;
}

static void
Opcode_wsr_excsave2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13d200;
}

static void
Opcode_xsr_excsave2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61d200;
}

static void
Opcode_rsr_epc3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b300;
}

static void
Opcode_wsr_epc3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13b300;
}

static void
Opcode_xsr_epc3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61b300;
}

static void
Opcode_rsr_excsave3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d300;
}

static void
Opcode_wsr_excsave3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13d300;
}

static void
Opcode_xsr_excsave3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61d300;
}

static void
Opcode_rsr_epc4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b400;
}

static void
Opcode_wsr_epc4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13b400;
}

static void
Opcode_xsr_epc4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61b400;
}

static void
Opcode_rsr_excsave4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d400;
}

static void
Opcode_wsr_excsave4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13d400;
}

static void
Opcode_xsr_excsave4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61d400;
}

static void
Opcode_rsr_epc5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b500;
}

static void
Opcode_wsr_epc5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13b500;
}

static void
Opcode_xsr_epc5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61b500;
}

static void
Opcode_rsr_excsave5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d500;
}

static void
Opcode_wsr_excsave5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13d500;
}

static void
Opcode_xsr_excsave5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61d500;
}

static void
Opcode_rsr_epc6_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b600;
}

static void
Opcode_wsr_epc6_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13b600;
}

static void
Opcode_xsr_epc6_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61b600;
}

static void
Opcode_rsr_excsave6_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d600;
}

static void
Opcode_wsr_excsave6_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13d600;
}

static void
Opcode_xsr_excsave6_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61d600;
}

static void
Opcode_rsr_epc7_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b700;
}

static void
Opcode_wsr_epc7_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13b700;
}

static void
Opcode_xsr_epc7_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61b700;
}

static void
Opcode_rsr_excsave7_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d700;
}

static void
Opcode_wsr_excsave7_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13d700;
}

static void
Opcode_xsr_excsave7_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61d700;
}

static void
Opcode_rsr_eps2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c200;
}

static void
Opcode_wsr_eps2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13c200;
}

static void
Opcode_xsr_eps2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61c200;
}

static void
Opcode_rsr_eps3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c300;
}

static void
Opcode_wsr_eps3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13c300;
}

static void
Opcode_xsr_eps3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61c300;
}

static void
Opcode_rsr_eps4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c400;
}

static void
Opcode_wsr_eps4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13c400;
}

static void
Opcode_xsr_eps4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61c400;
}

static void
Opcode_rsr_eps5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c500;
}

static void
Opcode_wsr_eps5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13c500;
}

static void
Opcode_xsr_eps5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61c500;
}

static void
Opcode_rsr_eps6_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c600;
}

static void
Opcode_wsr_eps6_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13c600;
}

static void
Opcode_xsr_eps6_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61c600;
}

static void
Opcode_rsr_eps7_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c700;
}

static void
Opcode_wsr_eps7_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13c700;
}

static void
Opcode_xsr_eps7_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61c700;
}

static void
Opcode_rsr_excvaddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3ee00;
}

static void
Opcode_wsr_excvaddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13ee00;
}

static void
Opcode_xsr_excvaddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61ee00;
}

static void
Opcode_rsr_depc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c000;
}

static void
Opcode_wsr_depc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13c000;
}

static void
Opcode_xsr_depc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61c000;
}

static void
Opcode_rsr_exccause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e800;
}

static void
Opcode_wsr_exccause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e800;
}

static void
Opcode_xsr_exccause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61e800;
}

static void
Opcode_rsr_prid_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3eb00;
}

static void
Opcode_rsr_vecbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e700;
}

static void
Opcode_wsr_vecbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e700;
}

static void
Opcode_xsr_vecbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61e700;
}

static void
Opcode_mul16u_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc10000;
}

static void
Opcode_mul16s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd10000;
}

static void
Opcode_mull_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x820000;
}

static void
Opcode_muluh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa20000;
}

static void
Opcode_mulsh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb20000;
}

static void
Opcode_rfi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3010;
}

static void
Opcode_waiti_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7000;
}

static void
Opcode_rsr_interrupt_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e200;
}

static void
Opcode_wsr_intset_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e200;
}

static void
Opcode_wsr_intclear_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e300;
}

static void
Opcode_rsr_intenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e400;
}

static void
Opcode_wsr_intenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e400;
}

static void
Opcode_xsr_intenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61e400;
}

static void
Opcode_break_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000;
}

static void
Opcode_break_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf02d;
}

static void
Opcode_rsr_dbreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x39000;
}

static void
Opcode_wsr_dbreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x139000;
}

static void
Opcode_xsr_dbreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x619000;
}

static void
Opcode_rsr_dbreakc0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3a000;
}

static void
Opcode_wsr_dbreakc0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13a000;
}

static void
Opcode_xsr_dbreakc0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61a000;
}

static void
Opcode_rsr_dbreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x39100;
}

static void
Opcode_wsr_dbreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x139100;
}

static void
Opcode_xsr_dbreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x619100;
}

static void
Opcode_rsr_dbreakc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3a100;
}

static void
Opcode_wsr_dbreakc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13a100;
}

static void
Opcode_xsr_dbreakc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61a100;
}

static void
Opcode_rsr_ibreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x38000;
}

static void
Opcode_wsr_ibreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x138000;
}

static void
Opcode_xsr_ibreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x618000;
}

static void
Opcode_rsr_ibreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x38100;
}

static void
Opcode_wsr_ibreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x138100;
}

static void
Opcode_xsr_ibreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x618100;
}

static void
Opcode_rsr_ibreakenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36000;
}

static void
Opcode_wsr_ibreakenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x136000;
}

static void
Opcode_xsr_ibreakenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x616000;
}

static void
Opcode_rsr_debugcause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e900;
}

static void
Opcode_wsr_debugcause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e900;
}

static void
Opcode_xsr_debugcause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61e900;
}

static void
Opcode_rsr_icount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3ec00;
}

static void
Opcode_wsr_icount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13ec00;
}

static void
Opcode_xsr_icount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61ec00;
}

static void
Opcode_rsr_icountlevel_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3ed00;
}

static void
Opcode_wsr_icountlevel_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13ed00;
}

static void
Opcode_xsr_icountlevel_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61ed00;
}

static void
Opcode_rsr_ddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36800;
}

static void
Opcode_wsr_ddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x136800;
}

static void
Opcode_xsr_ddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x616800;
}

static void
Opcode_lddr32_p_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70e0;
}

static void
Opcode_sddr32_p_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70f0;
}

static void
Opcode_rfdo_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf1e000;
}

static void
Opcode_rfdd_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf1e010;
}

static void
Opcode_wsr_mmid_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x135900;
}

static void
Opcode_andb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20000;
}

static void
Opcode_andbc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x120000;
}

static void
Opcode_orb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x220000;
}

static void
Opcode_orbc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x320000;
}

static void
Opcode_xorb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x420000;
}

static void
Opcode_any4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8000;
}

static void
Opcode_all4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9000;
}

static void
Opcode_any8_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa000;
}

static void
Opcode_all8_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb000;
}

static void
Opcode_bf_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x76;
}

static void
Opcode_bt_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1076;
}

static void
Opcode_movf_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc30000;
}

static void
Opcode_movt_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd30000;
}

static void
Opcode_rsr_br_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30400;
}

static void
Opcode_wsr_br_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130400;
}

static void
Opcode_xsr_br_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610400;
}

static void
Opcode_rsr_ccount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3ea00;
}

static void
Opcode_wsr_ccount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13ea00;
}

static void
Opcode_xsr_ccount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61ea00;
}

static void
Opcode_rsr_ccompare0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f000;
}

static void
Opcode_wsr_ccompare0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13f000;
}

static void
Opcode_xsr_ccompare0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61f000;
}

static void
Opcode_rsr_ccompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f100;
}

static void
Opcode_wsr_ccompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13f100;
}

static void
Opcode_xsr_ccompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61f100;
}

static void
Opcode_rsr_ccompare2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f200;
}

static void
Opcode_wsr_ccompare2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13f200;
}

static void
Opcode_xsr_ccompare2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61f200;
}

static void
Opcode_ipf_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70c2;
}

static void
Opcode_ihi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70e2;
}

static void
Opcode_ipfl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70d2;
}

static void
Opcode_ihu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x270d2;
}

static void
Opcode_iiu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x370d2;
}

static void
Opcode_iii_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70f2;
}

static void
Opcode_lict_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf10000;
}

static void
Opcode_licw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf12000;
}

static void
Opcode_sict_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf11000;
}

static void
Opcode_sicw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf13000;
}

static void
Opcode_dhwb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7042;
}

static void
Opcode_dhwbi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7052;
}

static void
Opcode_diwbui_p_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf7082;
}

static void
Opcode_diwb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x47082;
}

static void
Opcode_diwbi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x57082;
}

static void
Opcode_dhi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7062;
}

static void
Opcode_dii_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7072;
}

static void
Opcode_dpfr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7002;
}

static void
Opcode_dpfw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7012;
}

static void
Opcode_dpfro_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7022;
}

static void
Opcode_dpfwo_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7032;
}

static void
Opcode_dpfl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7082;
}

static void
Opcode_dhu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x27082;
}

static void
Opcode_diu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x37082;
}

static void
Opcode_sdct_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf19000;
}

static void
Opcode_ldct_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf18000;
}

static void
Opcode_rsr_prefctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x32800;
}

static void
Opcode_wsr_prefctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x132800;
}

static void
Opcode_xsr_prefctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x612800;
}

static void
Opcode_idtlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50c000;
}

static void
Opcode_pdtlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50d000;
}

static void
Opcode_rdtlb0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50b000;
}

static void
Opcode_rdtlb1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50f000;
}

static void
Opcode_wdtlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50e000;
}

static void
Opcode_iitlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x504000;
}

static void
Opcode_pitlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x505000;
}

static void
Opcode_ritlb0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x503000;
}

static void
Opcode_ritlb1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x507000;
}

static void
Opcode_witlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x506000;
}

static void
Opcode_rsr_cpenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e000;
}

static void
Opcode_wsr_cpenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e000;
}

static void
Opcode_xsr_cpenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61e000;
}

static void
Opcode_clamps_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x330000;
}

static void
Opcode_clamps_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5e000;
}

static void
Opcode_clamps_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800de000;
}

static void
Opcode_min_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x430000;
}

static void
Opcode_max_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x530000;
}

static void
Opcode_minu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x630000;
}

static void
Opcode_maxu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x730000;
}

static void
Opcode_nsa_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40e000;
}

static void
Opcode_nsau_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40f000;
}

static void
Opcode_sext_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x230000;
}

static void
Opcode_sext_Slot_ae_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5f000;
}

static void
Opcode_sext_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800df000;
}

static void
Opcode_l32ai_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb002;
}

static void
Opcode_s32ri_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf002;
}

static void
Opcode_s32c1i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe002;
}

static void
Opcode_rsr_scompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30c00;
}

static void
Opcode_wsr_scompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130c00;
}

static void
Opcode_xsr_scompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610c00;
}

static void
Opcode_rsr_atomctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36300;
}

static void
Opcode_wsr_atomctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x136300;
}

static void
Opcode_xsr_atomctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x616300;
}

static void
Opcode_quou_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc20000;
}

static void
Opcode_quos_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd20000;
}

static void
Opcode_remu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe20000;
}

static void
Opcode_rems_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf20000;
}

static void
Opcode_rer_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x406000;
}

static void
Opcode_wer_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x407000;
}

static void
Opcode_beqz_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400000a0;
}

static void
Opcode_bnez_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400006a0;
}

static void
Opcode_bgez_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400004a0;
}

static void
Opcode_bltz_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400002a0;
}

static void
Opcode_beqi_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40000000;
}

static void
Opcode_bnei_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400000c0;
}

static void
Opcode_bgei_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40000040;
}

static void
Opcode_blti_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40000060;
}

static void
Opcode_bgeui_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40000020;
}

static void
Opcode_bltui_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40000080;
}

static void
Opcode_bbci_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_bbsi_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200;
}

static void
Opcode_beq_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800;
}

static void
Opcode_bne_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb00;
}

static void
Opcode_bge_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa00;
}

static void
Opcode_blt_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x900;
}

static void
Opcode_bgeu_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc00;
}

static void
Opcode_bltu_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe00;
}

static void
Opcode_bany_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x500;
}

static void
Opcode_bnone_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf00;
}

static void
Opcode_ball_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100;
}

static void
Opcode_bnall_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00;
}

static void
Opcode_bbc_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300;
}

static void
Opcode_bbs_w18_Slot_ae2_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700;
}

static void
Opcode_rur_ae_ovf_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe30f00;
}

static void
Opcode_wur_ae_ovf_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf3f000;
}

static void
Opcode_rur_ae_bithead_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe30f10;
}

static void
Opcode_wur_ae_bithead_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf3f100;
}

static void
Opcode_rur_ae_ts_fts_bu_bp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe30f20;
}

static void
Opcode_wur_ae_ts_fts_bu_bp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf3f200;
}

static void
Opcode_rur_ae_cw_sd_no_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe30f30;
}

static void
Opcode_wur_ae_cw_sd_no_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf3f300;
}

static void
Opcode_rur_ae_cbegin0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe30f60;
}

static void
Opcode_wur_ae_cbegin0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf3f600;
}

static void
Opcode_rur_ae_cend0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe30f70;
}

static void
Opcode_wur_ae_cend0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf3f700;
}

static void
Opcode_rur_fcr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe30e80;
}

static void
Opcode_wur_fcr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf3e800;
}

static void
Opcode_rur_fsr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe30e90;
}

static void
Opcode_wur_fsr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf3e900;
}

xtensa_opcode_encode_fn Opcode_rur_ae_overflow_encode_fns[] = {
  Opcode_rur_ae_overflow_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_wur_ae_overflow_encode_fns[] = {
  Opcode_wur_ae_overflow_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_rur_ae_sar_encode_fns[] = {
  Opcode_rur_ae_sar_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_wur_ae_sar_encode_fns[] = {
  Opcode_wur_ae_sar_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_rur_ae_bitptr_encode_fns[] = {
  Opcode_rur_ae_bitptr_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_wur_ae_bitptr_encode_fns[] = {
  Opcode_wur_ae_bitptr_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_rur_ae_bitsused_encode_fns[] = {
  Opcode_rur_ae_bitsused_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_wur_ae_bitsused_encode_fns[] = {
  Opcode_wur_ae_bitsused_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_rur_ae_tablesize_encode_fns[] = {
  Opcode_rur_ae_tablesize_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_wur_ae_tablesize_encode_fns[] = {
  Opcode_wur_ae_tablesize_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_rur_ae_first_ts_encode_fns[] = {
  Opcode_rur_ae_first_ts_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_wur_ae_first_ts_encode_fns[] = {
  Opcode_wur_ae_first_ts_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_rur_ae_nextoffset_encode_fns[] = {
  Opcode_rur_ae_nextoffset_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_wur_ae_nextoffset_encode_fns[] = {
  Opcode_wur_ae_nextoffset_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_rur_ae_searchdone_encode_fns[] = {
  Opcode_rur_ae_searchdone_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_wur_ae_searchdone_encode_fns[] = {
  Opcode_wur_ae_searchdone_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_rur_ae_cwrap_encode_fns[] = {
  Opcode_rur_ae_cwrap_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_wur_ae_cwrap_encode_fns[] = {
  Opcode_wur_ae_cwrap_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l16m_xc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_l16m_xc_Slot_ae_slot0_encode, Opcode_ae_l16m_xc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l16m_xc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l16m_i_encode_fns[] = {
  Opcode_ae_l16m_i_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l16m_i_Slot_ae_slot0_encode, Opcode_ae_l16m_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l16m_i_Slot_ae2_slot0_encode, 0, 0, Opcode_ae_l16m_i_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_l16m_iu_encode_fns[] = {
  Opcode_ae_l16m_iu_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l16m_iu_Slot_ae_slot0_encode, Opcode_ae_l16m_iu_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l16m_iu_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l16m_x_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_l16m_x_Slot_ae_slot0_encode, Opcode_ae_l16m_x_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l16m_x_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l16m_xu_encode_fns[] = {
  Opcode_ae_l16m_xu_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l16m_xu_Slot_ae_slot0_encode, Opcode_ae_l16m_xu_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l16m_xu_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l16_xc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_l16_xc_Slot_ae_slot0_encode, Opcode_ae_l16_xc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l16_xc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l16_i_encode_fns[] = {
  Opcode_ae_l16_i_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l16_i_Slot_ae_slot0_encode, Opcode_ae_l16_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l16_i_Slot_ae2_slot0_encode, 0, 0, Opcode_ae_l16_i_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_l16_ip_encode_fns[] = {
  Opcode_ae_l16_ip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l16_ip_Slot_ae_slot0_encode, Opcode_ae_l16_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l16_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l16_x_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_l16_x_Slot_ae_slot0_encode, Opcode_ae_l16_x_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l16_x_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l16_xp_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_l16_xp_Slot_ae_slot0_encode, Opcode_ae_l16_xp_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l16_xp_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32f24_xc_encode_fns[] = {
  Opcode_ae_l32f24_xc_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32f24_xc_Slot_ae_slot0_encode, Opcode_ae_l32f24_xc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32f24_xc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32f24_i_encode_fns[] = {
  Opcode_ae_l32f24_i_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32f24_i_Slot_ae_slot0_encode, Opcode_ae_l32f24_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32f24_i_Slot_ae2_slot0_encode, 0, 0, Opcode_ae_l32f24_i_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_l32f24_ip_encode_fns[] = {
  Opcode_ae_l32f24_ip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32f24_ip_Slot_ae_slot0_encode, Opcode_ae_l32f24_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32f24_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32f24_x_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_l32f24_x_Slot_ae_slot0_encode, Opcode_ae_l32f24_x_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32f24_x_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32f24_xp_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_l32f24_xp_Slot_ae_slot0_encode, Opcode_ae_l32f24_xp_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32f24_xp_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32_xc_encode_fns[] = {
  Opcode_ae_l32_xc_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32_xc_Slot_ae_slot0_encode, Opcode_ae_l32_xc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32_xc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32_i_encode_fns[] = {
  Opcode_ae_l32_i_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32_i_Slot_ae_slot0_encode, Opcode_ae_l32_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32_i_Slot_ae2_slot0_encode, 0, 0, Opcode_ae_l32_i_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_l32_ip_encode_fns[] = {
  Opcode_ae_l32_ip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32_ip_Slot_ae_slot0_encode, Opcode_ae_l32_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32_x_encode_fns[] = {
  Opcode_ae_l32_x_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32_x_Slot_ae_slot0_encode, Opcode_ae_l32_x_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32_x_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32_xp_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_l32_xp_Slot_ae_slot0_encode, Opcode_ae_l32_xp_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32_xp_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32m_xc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_l32m_xc_Slot_ae_slot0_encode, Opcode_ae_l32m_xc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32m_xc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32m_i_encode_fns[] = {
  Opcode_ae_l32m_i_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32m_i_Slot_ae_slot0_encode, Opcode_ae_l32m_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32m_i_Slot_ae2_slot0_encode, 0, 0, Opcode_ae_l32m_i_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_l32m_iu_encode_fns[] = {
  Opcode_ae_l32m_iu_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32m_iu_Slot_ae_slot0_encode, Opcode_ae_l32m_iu_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32m_iu_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32m_x_encode_fns[] = {
  Opcode_ae_l32m_x_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32m_x_Slot_ae_slot0_encode, Opcode_ae_l32m_x_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32m_x_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32m_xu_encode_fns[] = {
  Opcode_ae_l32m_xu_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32m_xu_Slot_ae_slot0_encode, Opcode_ae_l32m_xu_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32m_xu_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l16x2m_xc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_l16x2m_xc_Slot_ae_slot0_encode, Opcode_ae_l16x2m_xc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l16x2m_xc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l16x2m_i_encode_fns[] = {
  Opcode_ae_l16x2m_i_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l16x2m_i_Slot_ae_slot0_encode, Opcode_ae_l16x2m_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l16x2m_i_Slot_ae2_slot0_encode, 0, 0, Opcode_ae_l16x2m_i_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_l16x2m_iu_encode_fns[] = {
  Opcode_ae_l16x2m_iu_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l16x2m_iu_Slot_ae_slot0_encode, Opcode_ae_l16x2m_iu_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l16x2m_iu_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l16x2m_x_encode_fns[] = {
  Opcode_ae_l16x2m_x_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l16x2m_x_Slot_ae_slot0_encode, Opcode_ae_l16x2m_x_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l16x2m_x_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l16x2m_xu_encode_fns[] = {
  Opcode_ae_l16x2m_xu_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l16x2m_xu_Slot_ae_slot0_encode, Opcode_ae_l16x2m_xu_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l16x2m_xu_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32x2f24_xc_encode_fns[] = {
  Opcode_ae_l32x2f24_xc_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32x2f24_xc_Slot_ae_slot0_encode, Opcode_ae_l32x2f24_xc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32x2f24_xc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32x2f24_i_encode_fns[] = {
  Opcode_ae_l32x2f24_i_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32x2f24_i_Slot_ae_slot0_encode, Opcode_ae_l32x2f24_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32x2f24_i_Slot_ae2_slot0_encode, 0, 0, Opcode_ae_l32x2f24_i_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_l32x2f24_ip_encode_fns[] = {
  Opcode_ae_l32x2f24_ip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32x2f24_ip_Slot_ae_slot0_encode, Opcode_ae_l32x2f24_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32x2f24_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32x2f24_rip_encode_fns[] = {
  Opcode_ae_l32x2f24_rip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32x2f24_rip_Slot_ae_slot0_encode, Opcode_ae_l32x2f24_rip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32x2f24_rip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32x2f24_ric_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_l32x2f24_ric_Slot_ae_slot0_encode, Opcode_ae_l32x2f24_ric_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32x2f24_ric_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32x2f24_x_encode_fns[] = {
  Opcode_ae_l32x2f24_x_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32x2f24_x_Slot_ae_slot0_encode, Opcode_ae_l32x2f24_x_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32x2f24_x_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32x2f24_xp_encode_fns[] = {
  Opcode_ae_l32x2f24_xp_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32x2f24_xp_Slot_ae_slot0_encode, Opcode_ae_l32x2f24_xp_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32x2f24_xp_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32x2_xc_encode_fns[] = {
  Opcode_ae_l32x2_xc_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32x2_xc_Slot_ae_slot0_encode, Opcode_ae_l32x2_xc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32x2_xc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32x2_i_encode_fns[] = {
  Opcode_ae_l32x2_i_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32x2_i_Slot_ae_slot0_encode, Opcode_ae_l32x2_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32x2_i_Slot_ae2_slot0_encode, 0, 0, Opcode_ae_l32x2_i_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_l32x2_ip_encode_fns[] = {
  Opcode_ae_l32x2_ip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32x2_ip_Slot_ae_slot0_encode, Opcode_ae_l32x2_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32x2_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32x2_rip_encode_fns[] = {
  Opcode_ae_l32x2_rip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32x2_rip_Slot_ae_slot0_encode, Opcode_ae_l32x2_rip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32x2_rip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32x2_ric_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_l32x2_ric_Slot_ae_slot0_encode, Opcode_ae_l32x2_ric_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32x2_ric_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32x2_x_encode_fns[] = {
  Opcode_ae_l32x2_x_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32x2_x_Slot_ae_slot0_encode, Opcode_ae_l32x2_x_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32x2_x_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l32x2_xp_encode_fns[] = {
  Opcode_ae_l32x2_xp_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l32x2_xp_Slot_ae_slot0_encode, Opcode_ae_l32x2_xp_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l32x2_xp_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l16x4_xc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_l16x4_xc_Slot_ae_slot0_encode, Opcode_ae_l16x4_xc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l16x4_xc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l16x4_i_encode_fns[] = {
  Opcode_ae_l16x4_i_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l16x4_i_Slot_ae_slot0_encode, Opcode_ae_l16x4_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l16x4_i_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l16x4_ip_encode_fns[] = {
  Opcode_ae_l16x4_ip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l16x4_ip_Slot_ae_slot0_encode, Opcode_ae_l16x4_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l16x4_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l16x4_rip_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_l16x4_rip_Slot_ae_slot0_encode, Opcode_ae_l16x4_rip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l16x4_rip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l16x4_ric_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_l16x4_ric_Slot_ae_slot0_encode, Opcode_ae_l16x4_ric_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l16x4_ric_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l16x4_x_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_l16x4_x_Slot_ae_slot0_encode, Opcode_ae_l16x4_x_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l16x4_x_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l16x4_xp_encode_fns[] = {
  Opcode_ae_l16x4_xp_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l16x4_xp_Slot_ae_slot0_encode, Opcode_ae_l16x4_xp_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l16x4_xp_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l64_xc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_l64_xc_Slot_ae_slot0_encode, Opcode_ae_l64_xc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l64_xc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l64_i_encode_fns[] = {
  Opcode_ae_l64_i_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_l64_i_Slot_ae_slot0_encode, Opcode_ae_l64_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l64_i_Slot_ae2_slot0_encode, 0, 0, Opcode_ae_l64_i_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_l64_ip_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_l64_ip_Slot_ae_slot0_encode, Opcode_ae_l64_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l64_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l64_x_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_l64_x_Slot_ae_slot0_encode, Opcode_ae_l64_x_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l64_x_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_l64_xp_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_l64_xp_Slot_ae_slot0_encode, Opcode_ae_l64_xp_Slot_ae_slot0_encode, 0, 0, Opcode_ae_l64_xp_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s16x2m_xc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s16x2m_xc_Slot_ae_slot0_encode, Opcode_ae_s16x2m_xc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s16x2m_xc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s16x2m_i_encode_fns[] = {
  Opcode_ae_s16x2m_i_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s16x2m_i_Slot_ae_slot0_encode, Opcode_ae_s16x2m_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s16x2m_i_Slot_ae2_slot0_encode, 0, 0, Opcode_ae_s16x2m_i_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_s16x2m_iu_encode_fns[] = {
  Opcode_ae_s16x2m_iu_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s16x2m_iu_Slot_ae_slot0_encode, Opcode_ae_s16x2m_iu_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s16x2m_iu_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s16x2m_x_encode_fns[] = {
  Opcode_ae_s16x2m_x_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s16x2m_x_Slot_ae_slot0_encode, Opcode_ae_s16x2m_x_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s16x2m_x_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s16x2m_xu_encode_fns[] = {
  Opcode_ae_s16x2m_xu_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s16x2m_xu_Slot_ae_slot0_encode, Opcode_ae_s16x2m_xu_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s16x2m_xu_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32x2f24_xc_encode_fns[] = {
  Opcode_ae_s32x2f24_xc_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s32x2f24_xc_Slot_ae_slot0_encode, Opcode_ae_s32x2f24_xc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32x2f24_xc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32x2f24_i_encode_fns[] = {
  Opcode_ae_s32x2f24_i_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s32x2f24_i_Slot_ae_slot0_encode, Opcode_ae_s32x2f24_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32x2f24_i_Slot_ae2_slot0_encode, 0, 0, Opcode_ae_s32x2f24_i_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_s32x2f24_ip_encode_fns[] = {
  Opcode_ae_s32x2f24_ip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s32x2f24_ip_Slot_ae_slot0_encode, Opcode_ae_s32x2f24_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32x2f24_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32x2f24_rip_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s32x2f24_rip_Slot_ae_slot0_encode, Opcode_ae_s32x2f24_rip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32x2f24_rip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32x2f24_ric_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s32x2f24_ric_Slot_ae_slot0_encode, Opcode_ae_s32x2f24_ric_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32x2f24_ric_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32x2f24_x_encode_fns[] = {
  Opcode_ae_s32x2f24_x_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s32x2f24_x_Slot_ae_slot0_encode, Opcode_ae_s32x2f24_x_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32x2f24_x_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32x2f24_xp_encode_fns[] = {
  Opcode_ae_s32x2f24_xp_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s32x2f24_xp_Slot_ae_slot0_encode, Opcode_ae_s32x2f24_xp_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32x2f24_xp_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32x2_xc_encode_fns[] = {
  Opcode_ae_s32x2_xc_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s32x2_xc_Slot_ae_slot0_encode, Opcode_ae_s32x2_xc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32x2_xc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32x2_i_encode_fns[] = {
  Opcode_ae_s32x2_i_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s32x2_i_Slot_ae_slot0_encode, Opcode_ae_s32x2_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32x2_i_Slot_ae2_slot0_encode, 0, 0, Opcode_ae_s32x2_i_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_s32x2_ip_encode_fns[] = {
  Opcode_ae_s32x2_ip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s32x2_ip_Slot_ae_slot0_encode, Opcode_ae_s32x2_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32x2_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32x2_rip_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s32x2_rip_Slot_ae_slot0_encode, Opcode_ae_s32x2_rip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32x2_rip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32x2_ric_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s32x2_ric_Slot_ae_slot0_encode, Opcode_ae_s32x2_ric_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32x2_ric_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32x2_x_encode_fns[] = {
  Opcode_ae_s32x2_x_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s32x2_x_Slot_ae_slot0_encode, Opcode_ae_s32x2_x_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32x2_x_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32x2_xp_encode_fns[] = {
  Opcode_ae_s32x2_xp_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s32x2_xp_Slot_ae_slot0_encode, Opcode_ae_s32x2_xp_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32x2_xp_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s16x4_xc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s16x4_xc_Slot_ae_slot0_encode, Opcode_ae_s16x4_xc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s16x4_xc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s16x4_i_encode_fns[] = {
  Opcode_ae_s16x4_i_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s16x4_i_Slot_ae_slot0_encode, Opcode_ae_s16x4_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s16x4_i_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s16x4_ip_encode_fns[] = {
  Opcode_ae_s16x4_ip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s16x4_ip_Slot_ae_slot0_encode, Opcode_ae_s16x4_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s16x4_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s16x4_rip_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s16x4_rip_Slot_ae_slot0_encode, Opcode_ae_s16x4_rip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s16x4_rip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s16x4_ric_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s16x4_ric_Slot_ae_slot0_encode, Opcode_ae_s16x4_ric_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s16x4_ric_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s16x4_x_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s16x4_x_Slot_ae_slot0_encode, Opcode_ae_s16x4_x_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s16x4_x_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s16x4_xp_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s16x4_xp_Slot_ae_slot0_encode, Opcode_ae_s16x4_xp_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s16x4_xp_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s16m_l_xc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s16m_l_xc_Slot_ae_slot0_encode, Opcode_ae_s16m_l_xc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s16m_l_xc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s16m_l_i_encode_fns[] = {
  Opcode_ae_s16m_l_i_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s16m_l_i_Slot_ae_slot0_encode, Opcode_ae_s16m_l_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s16m_l_i_Slot_ae2_slot0_encode, 0, 0, Opcode_ae_s16m_l_i_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_s16m_l_iu_encode_fns[] = {
  Opcode_ae_s16m_l_iu_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s16m_l_iu_Slot_ae_slot0_encode, Opcode_ae_s16m_l_iu_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s16m_l_iu_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s16m_l_x_encode_fns[] = {
  Opcode_ae_s16m_l_x_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s16m_l_x_Slot_ae_slot0_encode, Opcode_ae_s16m_l_x_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s16m_l_x_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s16m_l_xu_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s16m_l_xu_Slot_ae_slot0_encode, Opcode_ae_s16m_l_xu_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s16m_l_xu_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32f24_l_xc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s32f24_l_xc_Slot_ae_slot0_encode, Opcode_ae_s32f24_l_xc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32f24_l_xc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32f24_l_i_encode_fns[] = {
  Opcode_ae_s32f24_l_i_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s32f24_l_i_Slot_ae_slot0_encode, Opcode_ae_s32f24_l_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32f24_l_i_Slot_ae2_slot0_encode, 0, 0, Opcode_ae_s32f24_l_i_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_s32f24_l_ip_encode_fns[] = {
  Opcode_ae_s32f24_l_ip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s32f24_l_ip_Slot_ae_slot0_encode, Opcode_ae_s32f24_l_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32f24_l_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32f24_l_x_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s32f24_l_x_Slot_ae_slot0_encode, Opcode_ae_s32f24_l_x_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32f24_l_x_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32f24_l_xp_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s32f24_l_xp_Slot_ae_slot0_encode, Opcode_ae_s32f24_l_xp_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32f24_l_xp_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32_l_xc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s32_l_xc_Slot_ae_slot0_encode, Opcode_ae_s32_l_xc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32_l_xc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32_l_i_encode_fns[] = {
  Opcode_ae_s32_l_i_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s32_l_i_Slot_ae_slot0_encode, Opcode_ae_s32_l_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32_l_i_Slot_ae2_slot0_encode, 0, 0, Opcode_ae_s32_l_i_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_s32_l_ip_encode_fns[] = {
  Opcode_ae_s32_l_ip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s32_l_ip_Slot_ae_slot0_encode, Opcode_ae_s32_l_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32_l_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32_l_x_encode_fns[] = {
  Opcode_ae_s32_l_x_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s32_l_x_Slot_ae_slot0_encode, Opcode_ae_s32_l_x_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32_l_x_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32_l_xp_encode_fns[] = {
  Opcode_ae_s32_l_xp_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s32_l_xp_Slot_ae_slot0_encode, Opcode_ae_s32_l_xp_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32_l_xp_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s16_0_xc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s16_0_xc_Slot_ae_slot0_encode, Opcode_ae_s16_0_xc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s16_0_xc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s16_0_i_encode_fns[] = {
  Opcode_ae_s16_0_i_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s16_0_i_Slot_ae_slot0_encode, Opcode_ae_s16_0_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s16_0_i_Slot_ae2_slot0_encode, 0, 0, Opcode_ae_s16_0_i_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_s16_0_ip_encode_fns[] = {
  Opcode_ae_s16_0_ip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s16_0_ip_Slot_ae_slot0_encode, Opcode_ae_s16_0_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s16_0_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s16_0_x_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s16_0_x_Slot_ae_slot0_encode, Opcode_ae_s16_0_x_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s16_0_x_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s16_0_xp_encode_fns[] = {
  Opcode_ae_s16_0_xp_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s16_0_xp_Slot_ae_slot0_encode, Opcode_ae_s16_0_xp_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s16_0_xp_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s64_xc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s64_xc_Slot_ae_slot0_encode, Opcode_ae_s64_xc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s64_xc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s64_i_encode_fns[] = {
  Opcode_ae_s64_i_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s64_i_Slot_ae_slot0_encode, Opcode_ae_s64_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s64_i_Slot_ae2_slot0_encode, 0, 0, Opcode_ae_s64_i_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_s64_ip_encode_fns[] = {
  Opcode_ae_s64_ip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s64_ip_Slot_ae_slot0_encode, Opcode_ae_s64_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s64_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s64_x_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s64_x_Slot_ae_slot0_encode, Opcode_ae_s64_x_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s64_x_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s64_xp_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s64_xp_Slot_ae_slot0_encode, Opcode_ae_s64_xp_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s64_xp_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32m_xc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s32m_xc_Slot_ae_slot0_encode, Opcode_ae_s32m_xc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32m_xc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32m_i_encode_fns[] = {
  Opcode_ae_s32m_i_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s32m_i_Slot_ae_slot0_encode, Opcode_ae_s32m_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32m_i_Slot_ae2_slot0_encode, 0, 0, Opcode_ae_s32m_i_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_s32m_iu_encode_fns[] = {
  Opcode_ae_s32m_iu_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s32m_iu_Slot_ae_slot0_encode, Opcode_ae_s32m_iu_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32m_iu_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32m_x_encode_fns[] = {
  Opcode_ae_s32m_x_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s32m_x_Slot_ae_slot0_encode, Opcode_ae_s32m_x_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32m_x_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32m_xu_encode_fns[] = {
  Opcode_ae_s32m_xu_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s32m_xu_Slot_ae_slot0_encode, Opcode_ae_s32m_xu_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32m_xu_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_zalign64_encode_fns[] = {
  Opcode_ae_zalign64_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_zalign64_Slot_ae_slot0_encode, Opcode_ae_zalign64_Slot_ae_slot0_encode, 0, 0, Opcode_ae_zalign64_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_lalign64_i_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_lalign64_i_Slot_ae_slot0_encode, Opcode_ae_lalign64_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_lalign64_i_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_salign64_i_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_salign64_i_Slot_ae_slot0_encode, Opcode_ae_salign64_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_salign64_i_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_movalign_encode_fns[] = {
  Opcode_ae_movalign_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_movalign_Slot_ae_slot0_encode, Opcode_ae_movalign_Slot_ae_slot0_encode, 0, 0, Opcode_ae_movalign_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la64_pp_encode_fns[] = {
  Opcode_ae_la64_pp_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_la64_pp_Slot_ae_slot0_encode, Opcode_ae_la64_pp_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la64_pp_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la24pos_pc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_la24pos_pc_Slot_ae_slot0_encode, Opcode_ae_la24pos_pc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la24pos_pc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la24x2pos_pc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_la24x2pos_pc_Slot_ae_slot0_encode, Opcode_ae_la24x2pos_pc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la24x2pos_pc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la32x2pos_pc_encode_fns[] = {
  Opcode_ae_la32x2pos_pc_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_la32x2pos_pc_Slot_ae_slot0_encode, Opcode_ae_la32x2pos_pc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la32x2pos_pc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la16x4pos_pc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_la16x4pos_pc_Slot_ae_slot0_encode, Opcode_ae_la16x4pos_pc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la16x4pos_pc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la24neg_pc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_la24neg_pc_Slot_ae_slot0_encode, Opcode_ae_la24neg_pc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la24neg_pc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la24x2neg_pc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_la24x2neg_pc_Slot_ae_slot0_encode, Opcode_ae_la24x2neg_pc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la24x2neg_pc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la32x2neg_pc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_la32x2neg_pc_Slot_ae_slot0_encode, Opcode_ae_la32x2neg_pc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la32x2neg_pc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la16x4neg_pc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_la16x4neg_pc_Slot_ae_slot0_encode, Opcode_ae_la16x4neg_pc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la16x4neg_pc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sa64pos_fp_encode_fns[] = {
  Opcode_ae_sa64pos_fp_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_sa64pos_fp_Slot_ae_slot0_encode, Opcode_ae_sa64pos_fp_Slot_ae_slot0_encode, 0, 0, Opcode_ae_sa64pos_fp_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sa64neg_fp_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_sa64neg_fp_Slot_ae_slot0_encode, Opcode_ae_sa64neg_fp_Slot_ae_slot0_encode, 0, 0, Opcode_ae_sa64neg_fp_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la32x2_ic_encode_fns[] = {
  Opcode_ae_la32x2_ic_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_la32x2_ic_Slot_ae_slot0_encode, Opcode_ae_la32x2_ic_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la32x2_ic_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la32x2_ip_encode_fns[] = {
  Opcode_ae_la32x2_ip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_la32x2_ip_Slot_ae_slot0_encode, Opcode_ae_la32x2_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la32x2_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la32x2_rip_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_la32x2_rip_Slot_ae_slot0_encode, Opcode_ae_la32x2_rip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la32x2_rip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la32x2_ric_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_la32x2_ric_Slot_ae_slot0_encode, Opcode_ae_la32x2_ric_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la32x2_ric_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la16x4_ic_encode_fns[] = {
  Opcode_ae_la16x4_ic_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_la16x4_ic_Slot_ae_slot0_encode, Opcode_ae_la16x4_ic_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la16x4_ic_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la16x4_ip_encode_fns[] = {
  Opcode_ae_la16x4_ip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_la16x4_ip_Slot_ae_slot0_encode, Opcode_ae_la16x4_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la16x4_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la16x4_rip_encode_fns[] = {
  Opcode_ae_la16x4_rip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_la16x4_rip_Slot_ae_slot0_encode, Opcode_ae_la16x4_rip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la16x4_rip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la16x4_ric_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_la16x4_ric_Slot_ae_slot0_encode, Opcode_ae_la16x4_ric_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la16x4_ric_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la32x2f24_ic_encode_fns[] = {
  Opcode_ae_la32x2f24_ic_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_la32x2f24_ic_Slot_ae_slot0_encode, Opcode_ae_la32x2f24_ic_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la32x2f24_ic_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la32x2f24_ip_encode_fns[] = {
  Opcode_ae_la32x2f24_ip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_la32x2f24_ip_Slot_ae_slot0_encode, Opcode_ae_la32x2f24_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la32x2f24_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la32x2f24_rip_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_la32x2f24_rip_Slot_ae_slot0_encode, Opcode_ae_la32x2f24_rip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la32x2f24_rip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la32x2f24_ric_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_la32x2f24_ric_Slot_ae_slot0_encode, Opcode_ae_la32x2f24_ric_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la32x2f24_ric_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la24_ic_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_la24_ic_Slot_ae_slot0_encode, Opcode_ae_la24_ic_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la24_ic_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la24_ip_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_la24_ip_Slot_ae_slot0_encode, Opcode_ae_la24_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la24_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la24_rip_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_la24_rip_Slot_ae_slot0_encode, Opcode_ae_la24_rip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la24_rip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la24_ric_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_la24_ric_Slot_ae_slot0_encode, Opcode_ae_la24_ric_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la24_ric_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la24x2_ic_encode_fns[] = {
  Opcode_ae_la24x2_ic_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_la24x2_ic_Slot_ae_slot0_encode, Opcode_ae_la24x2_ic_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la24x2_ic_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la24x2_ip_encode_fns[] = {
  Opcode_ae_la24x2_ip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_la24x2_ip_Slot_ae_slot0_encode, Opcode_ae_la24x2_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la24x2_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la24x2_rip_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_la24x2_rip_Slot_ae_slot0_encode, Opcode_ae_la24x2_rip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la24x2_rip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_la24x2_ric_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_la24x2_ric_Slot_ae_slot0_encode, Opcode_ae_la24x2_ric_Slot_ae_slot0_encode, 0, 0, Opcode_ae_la24x2_ric_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sa32x2_ic_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_sa32x2_ic_Slot_ae_slot0_encode, Opcode_ae_sa32x2_ic_Slot_ae_slot0_encode, 0, 0, Opcode_ae_sa32x2_ic_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sa32x2_ip_encode_fns[] = {
  Opcode_ae_sa32x2_ip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_sa32x2_ip_Slot_ae_slot0_encode, Opcode_ae_sa32x2_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_sa32x2_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sa32x2_rip_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_sa32x2_rip_Slot_ae_slot0_encode, Opcode_ae_sa32x2_rip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_sa32x2_rip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sa32x2_ric_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_sa32x2_ric_Slot_ae_slot0_encode, Opcode_ae_sa32x2_ric_Slot_ae_slot0_encode, 0, 0, Opcode_ae_sa32x2_ric_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sa16x4_ic_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_sa16x4_ic_Slot_ae_slot0_encode, Opcode_ae_sa16x4_ic_Slot_ae_slot0_encode, 0, 0, Opcode_ae_sa16x4_ic_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sa16x4_ip_encode_fns[] = {
  Opcode_ae_sa16x4_ip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_sa16x4_ip_Slot_ae_slot0_encode, Opcode_ae_sa16x4_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_sa16x4_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sa16x4_rip_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_sa16x4_rip_Slot_ae_slot0_encode, Opcode_ae_sa16x4_rip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_sa16x4_rip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sa16x4_ric_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_sa16x4_ric_Slot_ae_slot0_encode, Opcode_ae_sa16x4_ric_Slot_ae_slot0_encode, 0, 0, Opcode_ae_sa16x4_ric_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sa32x2f24_ic_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_sa32x2f24_ic_Slot_ae_slot0_encode, Opcode_ae_sa32x2f24_ic_Slot_ae_slot0_encode, 0, 0, Opcode_ae_sa32x2f24_ic_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sa32x2f24_ip_encode_fns[] = {
  Opcode_ae_sa32x2f24_ip_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_sa32x2f24_ip_Slot_ae_slot0_encode, Opcode_ae_sa32x2f24_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_sa32x2f24_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sa32x2f24_rip_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_sa32x2f24_rip_Slot_ae_slot0_encode, Opcode_ae_sa32x2f24_rip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_sa32x2f24_rip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sa32x2f24_ric_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_sa32x2f24_ric_Slot_ae_slot0_encode, Opcode_ae_sa32x2f24_ric_Slot_ae_slot0_encode, 0, 0, Opcode_ae_sa32x2f24_ric_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sa24_l_ic_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_sa24_l_ic_Slot_ae_slot0_encode, Opcode_ae_sa24_l_ic_Slot_ae_slot0_encode, 0, 0, Opcode_ae_sa24_l_ic_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sa24_l_ip_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_sa24_l_ip_Slot_ae_slot0_encode, Opcode_ae_sa24_l_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_sa24_l_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sa24_l_rip_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_sa24_l_rip_Slot_ae_slot0_encode, Opcode_ae_sa24_l_rip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_sa24_l_rip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sa24_l_ric_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_sa24_l_ric_Slot_ae_slot0_encode, Opcode_ae_sa24_l_ric_Slot_ae_slot0_encode, 0, 0, Opcode_ae_sa24_l_ric_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sa24x2_ic_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_sa24x2_ic_Slot_ae_slot0_encode, Opcode_ae_sa24x2_ic_Slot_ae_slot0_encode, 0, 0, Opcode_ae_sa24x2_ic_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sa24x2_ip_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_sa24x2_ip_Slot_ae_slot0_encode, Opcode_ae_sa24x2_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_sa24x2_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sa24x2_rip_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_sa24x2_rip_Slot_ae_slot0_encode, Opcode_ae_sa24x2_rip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_sa24x2_rip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sa24x2_ric_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_sa24x2_ric_Slot_ae_slot0_encode, Opcode_ae_sa24x2_ric_Slot_ae_slot0_encode, 0, 0, Opcode_ae_sa24x2_ric_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32ra64s_i_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s32ra64s_i_Slot_ae_slot0_encode, Opcode_ae_s32ra64s_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32ra64s_i_Slot_ae2_slot0_encode, 0, 0, Opcode_ae_s32ra64s_i_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_s32ra64s_ip_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s32ra64s_ip_Slot_ae_slot0_encode, Opcode_ae_s32ra64s_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32ra64s_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32ra64s_x_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s32ra64s_x_Slot_ae_slot0_encode, Opcode_ae_s32ra64s_x_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32ra64s_x_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32ra64s_xp_encode_fns[] = {
  Opcode_ae_s32ra64s_xp_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s32ra64s_xp_Slot_ae_slot0_encode, Opcode_ae_s32ra64s_xp_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32ra64s_xp_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32ra64s_xc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s32ra64s_xc_Slot_ae_slot0_encode, Opcode_ae_s32ra64s_xc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s32ra64s_xc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s24ra64s_i_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s24ra64s_i_Slot_ae_slot0_encode, Opcode_ae_s24ra64s_i_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s24ra64s_i_Slot_ae2_slot0_encode, 0, 0, Opcode_ae_s24ra64s_i_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_s24ra64s_ip_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s24ra64s_ip_Slot_ae_slot0_encode, Opcode_ae_s24ra64s_ip_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s24ra64s_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s24ra64s_x_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s24ra64s_x_Slot_ae_slot0_encode, Opcode_ae_s24ra64s_x_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s24ra64s_x_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s24ra64s_xp_encode_fns[] = {
  Opcode_ae_s24ra64s_xp_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_s24ra64s_xp_Slot_ae_slot0_encode, Opcode_ae_s24ra64s_xp_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s24ra64s_xp_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s24ra64s_xc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_s24ra64s_xc_Slot_ae_slot0_encode, Opcode_ae_s24ra64s_xc_Slot_ae_slot0_encode, 0, 0, Opcode_ae_s24ra64s_xc_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s32x2ra64s_ip_encode_fns[] = {
  Opcode_ae_s32x2ra64s_ip_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, Opcode_ae_s32x2ra64s_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_s24x2ra64s_ip_encode_fns[] = {
  Opcode_ae_s24x2ra64s_ip_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, Opcode_ae_s24x2ra64s_ip_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_addbrba32_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_addbrba32_Slot_ae_slot0_encode, Opcode_ae_addbrba32_Slot_ae_slot0_encode, 0, 0, Opcode_ae_addbrba32_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sel16i_encode_fns[] = {
  Opcode_ae_sel16i_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, Opcode_ae_sel16i_Slot_ae_slot2_1_encode, Opcode_ae_sel16i_Slot_ae2_slot1_encode, Opcode_ae_sel16i_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sel16i_n_encode_fns[] = {
  0, 0, 0, 0, Opcode_ae_sel16i_n_Slot_ae_slot1_encode, Opcode_ae_sel16i_n_Slot_ae_slot1_encode, 0, 0, 0, 0, 0, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_shortswap_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, 0, Opcode_ae_shortswap_Slot_ae_slot2_1_encode, Opcode_ae_shortswap_Slot_ae2_slot1_encode, 0, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_movt16x4_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, 0, Opcode_ae_movt16x4_Slot_ae_slot2_1_encode, 0, Opcode_ae_movt16x4_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_movf16x4_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, 0, Opcode_ae_movf16x4_Slot_ae_slot2_1_encode, 0, Opcode_ae_movf16x4_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_movt32x2_encode_fns[] = {
  Opcode_ae_movt32x2_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, Opcode_ae_movt32x2_Slot_ae_slot2_1_encode, 0, Opcode_ae_movt32x2_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_movf32x2_encode_fns[] = {
  Opcode_ae_movf32x2_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, Opcode_ae_movf32x2_Slot_ae_slot2_1_encode, 0, Opcode_ae_movf32x2_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_movda32x2_encode_fns[] = {
  Opcode_ae_movda32x2_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_movda32x2_Slot_ae_slot0_encode, Opcode_ae_movda32x2_Slot_ae_slot0_encode, 0, 0, Opcode_ae_movda32x2_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_movda32_encode_fns[] = {
  Opcode_ae_movda32_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, Opcode_ae_movda32_Slot_ae2_slot0_encode, Opcode_ae_movda32_Slot_ae_minislot2_encode, 0, Opcode_ae_movda32_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_movda16x2_encode_fns[] = {
  Opcode_ae_movda16x2_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, Opcode_ae_movda16x2_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_movda16_encode_fns[] = {
  Opcode_ae_movda16_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, Opcode_ae_movda16_Slot_ae2_slot0_encode, Opcode_ae_movda16_Slot_ae_minislot2_encode, 0, Opcode_ae_movda16_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_movi_encode_fns[] = {
  Opcode_ae_movi_Slot_inst_encode, 0, 0, 0, Opcode_ae_movi_Slot_ae_slot1_encode, Opcode_ae_movi_Slot_ae_slot1_encode, Opcode_ae_movi_Slot_ae_slot0_encode, Opcode_ae_movi_Slot_ae_slot0_encode, Opcode_ae_movi_Slot_ae_slot2_1_encode, Opcode_ae_movi_Slot_ae2_slot1_encode, Opcode_ae_movi_Slot_ae2_slot0_encode, Opcode_ae_movi_Slot_ae_minislot2_encode, 0, Opcode_ae_movi_Slot_ae_minislot0_encode
};

xtensa_opcode_encode_fn Opcode_ae_truncp24a32x2_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_truncp24a32x2_Slot_ae_slot0_encode, Opcode_ae_truncp24a32x2_Slot_ae_slot0_encode, 0, 0, Opcode_ae_truncp24a32x2_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sat16x4_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, 0, Opcode_ae_sat16x4_Slot_ae_slot2_1_encode, 0, Opcode_ae_sat16x4_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_cvt32x2f16_32_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_cvt32x2f16_32_Slot_ae_slot0_encode, Opcode_ae_cvt32x2f16_32_Slot_ae_slot0_encode, Opcode_ae_cvt32x2f16_32_Slot_ae_slot2_1_encode, 0, Opcode_ae_cvt32x2f16_32_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_cvt32x2f16_10_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_cvt32x2f16_10_Slot_ae_slot0_encode, Opcode_ae_cvt32x2f16_10_Slot_ae_slot0_encode, Opcode_ae_cvt32x2f16_10_Slot_ae_slot2_1_encode, 0, Opcode_ae_cvt32x2f16_10_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sext32x2d16_32_encode_fns[] = {
  Opcode_ae_sext32x2d16_32_Slot_inst_encode, 0, 0, 0, 0, 0, Opcode_ae_sext32x2d16_32_Slot_ae_slot0_encode, Opcode_ae_sext32x2d16_32_Slot_ae_slot0_encode, Opcode_ae_sext32x2d16_32_Slot_ae_slot2_1_encode, 0, Opcode_ae_sext32x2d16_32_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_sext32x2d16_10_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_sext32x2d16_10_Slot_ae_slot0_encode, Opcode_ae_sext32x2d16_10_Slot_ae_slot0_encode, Opcode_ae_sext32x2d16_10_Slot_ae_slot2_1_encode, 0, Opcode_ae_sext32x2d16_10_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_cvta32f24s_l_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_cvta32f24s_l_Slot_ae_slot0_encode, Opcode_ae_cvta32f24s_l_Slot_ae_slot0_encode, 0, 0, Opcode_ae_cvta32f24s_l_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_cvta32f24s_h_encode_fns[] = {
  0, 0, 0, 0, 0, 0, Opcode_ae_cvta32f24s_h_Slot_ae_slot0_encode, Opcode_ae_cvta32f24s_h_Slot_ae_slot0_encode, 0, 0, Opcode_ae_cvta32f24s_h_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_cvtp24a16x2_ll_encode_fns[] = {
  Opcode_ae_cvtp24a16x2_ll_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, Opcode_ae_cvtp24a16x2_ll_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_cvtp24a16x2_lh_encode_fns[] = {
  Opcode_ae_cvtp24a16x2_lh_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, Opcode_ae_cvtp24a16x2_lh_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_cvtp24a16x2_hl_encode_fns[] = {
  Opcode_ae_cvtp24a16x2_hl_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, Opcode_ae_cvtp24a16x2_hl_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_cvtp24a16x2_hh_encode_fns[] = {
  Opcode_ae_cvtp24a16x2_hh_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, Opcode_ae_cvtp24a16x2_hh_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_truncp24q48x2_encode_fns[] = {
  Opcode_ae_truncp24q48x2_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, Opcode_ae_truncp24q48x2_Slot_ae_slot2_1_encode, 0, Opcode_ae_truncp24q48x2_Slot_ae2_slot0_encode, 0, 0, 0
};

xtensa_opcode_encode_fn Opcode_ae_trunca32x2f64s_encode_fns[] = {
  Opcode_ae_trunca32x2f64s_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0, Opcode_ae_trunca32x2f64s_Slot_ae2_slot0_en