/* Configuration for the Xtensa architecture for GDB, the GNU debugger.

   Copyright (c) 2003-2024 Cadence Design Systems, Inc.

   Permission is hereby granted, free of charge, to any person obtaining
   a copy of this software and associated documentation files (the
   "Software"), to deal in the Software without restriction, including
   without limitation the rights to use, copy, modify, merge, publish,
   distribute, sublicense, and/or sell copies of the Software, and to
   permit persons to whom the Software is furnished to do so, subject to
   the following conditions:

   The above copyright notice and this permission notice shall be included
   in all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
   CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
   TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
   SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.  */

#define XTENSA_CONFIG_VERSION 0x70

#include "defs.h"
#include "xtensa-config.h"
#include "xtensa-tdep.h"



/* Masked registers.  */
xtensa_reg_mask_t xtensa_submask0[] = { { 76, 0, 1 } };
const xtensa_mask_t xtensa_mask0 = { 1, xtensa_submask0 };
xtensa_reg_mask_t xtensa_submask1[] = { { 76, 1, 1 } };
const xtensa_mask_t xtensa_mask1 = { 1, xtensa_submask1 };
xtensa_reg_mask_t xtensa_submask2[] = { { 76, 2, 1 } };
const xtensa_mask_t xtensa_mask2 = { 1, xtensa_submask2 };
xtensa_reg_mask_t xtensa_submask3[] = { { 76, 3, 1 } };
const xtensa_mask_t xtensa_mask3 = { 1, xtensa_submask3 };
xtensa_reg_mask_t xtensa_submask4[] = { { 76, 4, 1 } };
const xtensa_mask_t xtensa_mask4 = { 1, xtensa_submask4 };
xtensa_reg_mask_t xtensa_submask5[] = { { 76, 5, 1 } };
const xtensa_mask_t xtensa_mask5 = { 1, xtensa_submask5 };
xtensa_reg_mask_t xtensa_submask6[] = { { 76, 6, 1 } };
const xtensa_mask_t xtensa_mask6 = { 1, xtensa_submask6 };
xtensa_reg_mask_t xtensa_submask7[] = { { 76, 7, 1 } };
const xtensa_mask_t xtensa_mask7 = { 1, xtensa_submask7 };
xtensa_reg_mask_t xtensa_submask8[] = { { 76, 8, 1 } };
const xtensa_mask_t xtensa_mask8 = { 1, xtensa_submask8 };
xtensa_reg_mask_t xtensa_submask9[] = { { 76, 9, 1 } };
const xtensa_mask_t xtensa_mask9 = { 1, xtensa_submask9 };
xtensa_reg_mask_t xtensa_submask10[] = { { 76, 10, 1 } };
const xtensa_mask_t xtensa_mask10 = { 1, xtensa_submask10 };
xtensa_reg_mask_t xtensa_submask11[] = { { 76, 11, 1 } };
const xtensa_mask_t xtensa_mask11 = { 1, xtensa_submask11 };
xtensa_reg_mask_t xtensa_submask12[] = { { 76, 12, 1 } };
const xtensa_mask_t xtensa_mask12 = { 1, xtensa_submask12 };
xtensa_reg_mask_t xtensa_submask13[] = { { 76, 13, 1 } };
const xtensa_mask_t xtensa_mask13 = { 1, xtensa_submask13 };
xtensa_reg_mask_t xtensa_submask14[] = { { 76, 14, 1 } };
const xtensa_mask_t xtensa_mask14 = { 1, xtensa_submask14 };
xtensa_reg_mask_t xtensa_submask15[] = { { 76, 15, 1 } };
const xtensa_mask_t xtensa_mask15 = { 1, xtensa_submask15 };
xtensa_reg_mask_t xtensa_submask16[] = { { 169, 0, 1 } };
const xtensa_mask_t xtensa_mask16 = { 1, xtensa_submask16 };
xtensa_reg_mask_t xtensa_submask17[] = { { 74, 0, 4 } };
const xtensa_mask_t xtensa_mask17 = { 1, xtensa_submask17 };
xtensa_reg_mask_t xtensa_submask18[] = { { 74, 5, 1 } };
const xtensa_mask_t xtensa_mask18 = { 1, xtensa_submask18 };
xtensa_reg_mask_t xtensa_submask19[] = { { 74, 18, 1 } };
const xtensa_mask_t xtensa_mask19 = { 1, xtensa_submask19 };
xtensa_reg_mask_t xtensa_submask20[] = { { 74, 6, 2 } };
const xtensa_mask_t xtensa_mask20 = { 1, xtensa_submask20 };
xtensa_reg_mask_t xtensa_submask21[] = { { 74, 4, 1 } };
const xtensa_mask_t xtensa_mask21 = { 1, xtensa_submask21 };
xtensa_reg_mask_t xtensa_submask22[] = { { 74, 16, 2 } };
const xtensa_mask_t xtensa_mask22 = { 1, xtensa_submask22 };
xtensa_reg_mask_t xtensa_submask23[] = { { 74, 8, 4 } };
const xtensa_mask_t xtensa_mask23 = { 1, xtensa_submask23 };
xtensa_reg_mask_t xtensa_submask24[] = { { 132, 0, 6 } };
const xtensa_mask_t xtensa_mask24 = { 1, xtensa_submask24 };
xtensa_reg_mask_t xtensa_submask25[] = { { 139, 0, 2 } };
const xtensa_mask_t xtensa_mask25 = { 1, xtensa_submask25 };
xtensa_reg_mask_t xtensa_submask26[] = { { 171, 8, 4 } };
const xtensa_mask_t xtensa_mask26 = { 1, xtensa_submask26 };
xtensa_reg_mask_t xtensa_submask27[] = { { 78, 7, 1 } };
const xtensa_mask_t xtensa_mask27 = { 1, xtensa_submask27 };
xtensa_reg_mask_t xtensa_submask28[] = { { 78, 0, 7 }, { 78, 8, 7 } };
const xtensa_mask_t xtensa_mask28 = { 2, xtensa_submask28 };
xtensa_reg_mask_t xtensa_submask29[] = { { 81, 28, 1 } };
const xtensa_mask_t xtensa_mask29 = { 1, xtensa_submask29 };
xtensa_reg_mask_t xtensa_submask30[] = { { 80, 0, 4 } };
const xtensa_mask_t xtensa_mask30 = { 1, xtensa_submask30 };
xtensa_reg_mask_t xtensa_submask31[] = { { 80, 4, 4 } };
const xtensa_mask_t xtensa_mask31 = { 1, xtensa_submask31 };
xtensa_reg_mask_t xtensa_submask32[] = { { 80, 12, 4 } };
const xtensa_mask_t xtensa_mask32 = { 1, xtensa_submask32 };
xtensa_reg_mask_t xtensa_submask33[] = { { 80, 8, 4 } };
const xtensa_mask_t xtensa_mask33 = { 1, xtensa_submask33 };
xtensa_reg_mask_t xtensa_submask34[] = { { 81, 0, 27 } };
const xtensa_mask_t xtensa_mask34 = { 1, xtensa_submask34 };
xtensa_reg_mask_t xtensa_submask35[] = { { 81, 27, 1 } };
const xtensa_mask_t xtensa_mask35 = { 1, xtensa_submask35 };
xtensa_reg_mask_t xtensa_submask36[] = { { 128, 8, 8 } };
const xtensa_mask_t xtensa_mask36 = { 1, xtensa_submask36 };
xtensa_reg_mask_t xtensa_submask37[] = { { 128, 0, 8 } };
const xtensa_mask_t xtensa_mask37 = { 1, xtensa_submask37 };
xtensa_reg_mask_t xtensa_submask38[] = { { 129, 5, 2 } };
const xtensa_mask_t xtensa_mask38 = { 1, xtensa_submask38 };
xtensa_reg_mask_t xtensa_submask39[] = { { 129, 4, 1 } };
const xtensa_mask_t xtensa_mask39 = { 1, xtensa_submask39 };
xtensa_reg_mask_t xtensa_submask40[] = { { 129, 3, 1 } };
const xtensa_mask_t xtensa_mask40 = { 1, xtensa_submask40 };
xtensa_reg_mask_t xtensa_submask41[] = { { 129, 2, 1 } };
const xtensa_mask_t xtensa_mask41 = { 1, xtensa_submask41 };
xtensa_reg_mask_t xtensa_submask42[] = { { 129, 1, 1 } };
const xtensa_mask_t xtensa_mask42 = { 1, xtensa_submask42 };
xtensa_reg_mask_t xtensa_submask43[] = { { 129, 0, 1 } };
const xtensa_mask_t xtensa_mask43 = { 1, xtensa_submask43 };


/* Register map.  */
xtensa_register_t rmap[] = 
{
  /*    idx ofs bi sz al targno  flags cp typ group name  */
  XTREG(  0,  0,32, 4, 4,0x0020,0x0006,-2, 9,0x2100,pc,          0,0,0,0,0,0)
  XTREG(  1,  4,32, 4, 4,0x0100,0x0006,-2, 1,0x0002,ar0,         0,0,0,0,0,0)
  XTREG(  2,  8,32, 4, 4,0x0101,0x0006,-2, 1,0x0002,ar1,         0,0,0,0,0,0)
  XTREG(  3, 12,32, 4, 4,0x0102,0x0006,-2, 1,0x0002,ar2,         0,0,0,0,0,0)
  XTREG(  4, 16,32, 4, 4,0x0103,0x0006,-2, 1,0x0002,ar3,         0,0,0,0,0,0)
  XTREG(  5, 20,32, 4, 4,0x0104,0x0006,-2, 1,0x0002,ar4,         0,0,0,0,0,0)
  XTREG(  6, 24,32, 4, 4,0x0105,0x0006,-2, 1,0x0002,ar5,         0,0,0,0,0,0)
  XTREG(  7, 28,32, 4, 4,0x0106,0x0006,-2, 1,0x0002,ar6,         0,0,0,0,0,0)
  XTREG(  8, 32,32, 4, 4,0x0107,0x0006,-2, 1,0x0002,ar7,         0,0,0,0,0,0)
  XTREG(  9, 36,32, 4, 4,0x0108,0x0006,-2, 1,0x0002,ar8,         0,0,0,0,0,0)
  XTREG( 10, 40,32, 4, 4,0x0109,0x0006,-2, 1,0x0002,ar9,         0,0,0,0,0,0)
  XTREG( 11, 44,32, 4, 4,0x010a,0x0006,-2, 1,0x0002,ar10,        0,0,0,0,0,0)
  XTREG( 12, 48,32, 4, 4,0x010b,0x0006,-2, 1,0x0002,ar11,        0,0,0,0,0,0)
  XTREG( 13, 52,32, 4, 4,0x010c,0x0006,-2, 1,0x0002,ar12,        0,0,0,0,0,0)
  XTREG( 14, 56,32, 4, 4,0x010d,0x0006,-2, 1,0x0002,ar13,        0,0,0,0,0,0)
  XTREG( 15, 60,32, 4, 4,0x010e,0x0006,-2, 1,0x0002,ar14,        0,0,0,0,0,0)
  XTREG( 16, 64,32, 4, 4,0x010f,0x0006,-2, 1,0x0002,ar15,        0,0,0,0,0,0)
  XTREG( 17, 68,32, 4, 4,0x0110,0x0006,-2, 1,0x0002,ar16,        0,0,0,0,0,0)
  XTREG( 18, 72,32, 4, 4,0x0111,0x0006,-2, 1,0x0002,ar17,        0,0,0,0,0,0)
  XTREG( 19, 76,32, 4, 4,0x0112,0x0006,-2, 1,0x0002,ar18,        0,0,0,0,0,0)
  XTREG( 20, 80,32, 4, 4,0x0113,0x0006,-2, 1,0x0002,ar19,        0,0,0,0,0,0)
  XTREG( 21, 84,32, 4, 4,0x0114,0x0006,-2, 1,0x0002,ar20,        0,0,0,0,0,0)
  XTREG( 22, 88,32, 4, 4,0x0115,0x0006,-2, 1,0x0002,ar21,        0,0,0,0,0,0)
  XTREG( 23, 92,32, 4, 4,0x0116,0x0006,-2, 1,0x0002,ar22,        0,0,0,0,0,0)
  XTREG( 24, 96,32, 4, 4,0x0117,0x0006,-2, 1,0x0002,ar23,        0,0,0,0,0,0)
  XTREG( 25,100,32, 4, 4,0x0118,0x0006,-2, 1,0x0002,ar24,        0,0,0,0,0,0)
  XTREG( 26,104,32, 4, 4,0x0119,0x0006,-2, 1,0x0002,ar25,        0,0,0,0,0,0)
  XTREG( 27,108,32, 4, 4,0x011a,0x0006,-2, 1,0x0002,ar26,        0,0,0,0,0,0)
  XTREG( 28,112,32, 4, 4,0x011b,0x0006,-2, 1,0x0002,ar27,        0,0,0,0,0,0)
  XTREG( 29,116,32, 4, 4,0x011c,0x0006,-2, 1,0x0002,ar28,        0,0,0,0,0,0)
  XTREG( 30,120,32, 4, 4,0x011d,0x0006,-2, 1,0x0002,ar29,        0,0,0,0,0,0)
  XTREG( 31,124,32, 4, 4,0x011e,0x0006,-2, 1,0x0002,ar30,        0,0,0,0,0,0)
  XTREG( 32,128,32, 4, 4,0x011f,0x0006,-2, 1,0x0002,ar31,        0,0,0,0,0,0)
  XTREG( 33,132,32, 4, 4,0x0120,0x0006,-2, 1,0x0002,ar32,        0,0,0,0,0,0)
  XTREG( 34,136,32, 4, 4,0x0121,0x0006,-2, 1,0x0002,ar33,        0,0,0,0,0,0)
  XTREG( 35,140,32, 4, 4,0x0122,0x0006,-2, 1,0x0002,ar34,        0,0,0,0,0,0)
  XTREG( 36,144,32, 4, 4,0x0123,0x0006,-2, 1,0x0002,ar35,        0,0,0,0,0,0)
  XTREG( 37,148,32, 4, 4,0x0124,0x0006,-2, 1,0x0002,ar36,        0,0,0,0,0,0)
  XTREG( 38,152,32, 4, 4,0x0125,0x0006,-2, 1,0x0002,ar37,        0,0,0,0,0,0)
  XTREG( 39,156,32, 4, 4,0x0126,0x0006,-2, 1,0x0002,ar38,        0,0,0,0,0,0)
  XTREG( 40,160,32, 4, 4,0x0127,0x0006,-2, 1,0x0002,ar39,        0,0,0,0,0,0)
  XTREG( 41,164,32, 4, 4,0x0128,0x0006,-2, 1,0x0002,ar40,        0,0,0,0,0,0)
  XTREG( 42,168,32, 4, 4,0x0129,0x0006,-2, 1,0x0002,ar41,        0,0,0,0,0,0)
  XTREG( 43,172,32, 4, 4,0x012a,0x0006,-2, 1,0x0002,ar42,        0,0,0,0,0,0)
  XTREG( 44,176,32, 4, 4,0x012b,0x0006,-2, 1,0x0002,ar43,        0,0,0,0,0,0)
  XTREG( 45,180,32, 4, 4,0x012c,0x0006,-2, 1,0x0002,ar44,        0,0,0,0,0,0)
  XTREG( 46,184,32, 4, 4,0x012d,0x0006,-2, 1,0x0002,ar45,        0,0,0,0,0,0)
  XTREG( 47,188,32, 4, 4,0x012e,0x0006,-2, 1,0x0002,ar46,        0,0,0,0,0,0)
  XTREG( 48,192,32, 4, 4,0x012f,0x0006,-2, 1,0x0002,ar47,        0,0,0,0,0,0)
  XTREG( 49,196,32, 4, 4,0x0130,0x0006,-2, 1,0x0002,ar48,        0,0,0,0,0,0)
  XTREG( 50,200,32, 4, 4,0x0131,0x0006,-2, 1,0x0002,ar49,        0,0,0,0,0,0)
  XTREG( 51,204,32, 4, 4,0x0132,0x0006,-2, 1,0x0002,ar50,        0,0,0,0,0,0)
  XTREG( 52,208,32, 4, 4,0x0133,0x0006,-2, 1,0x0002,ar51,        0,0,0,0,0,0)
  XTREG( 53,212,32, 4, 4,0x0134,0x0006,-2, 1,0x0002,ar52,        0,0,0,0,0,0)
  XTREG( 54,216,32, 4, 4,0x0135,0x0006,-2, 1,0x0002,ar53,        0,0,0,0,0,0)
  XTREG( 55,220,32, 4, 4,0x0136,0x0006,-2, 1,0x0002,ar54,        0,0,0,0,0,0)
  XTREG( 56,224,32, 4, 4,0x0137,0x0006,-2, 1,0x0002,ar55,        0,0,0,0,0,0)
  XTREG( 57,228,32, 4, 4,0x0138,0x0006,-2, 1,0x0002,ar56,        0,0,0,0,0,0)
  XTREG( 58,232,32, 4, 4,0x0139,0x0006,-2, 1,0x0002,ar57,        0,0,0,0,0,0)
  XTREG( 59,236,32, 4, 4,0x013a,0x0006,-2, 1,0x0002,ar58,        0,0,0,0,0,0)
  XTREG( 60,240,32, 4, 4,0x013b,0x0006,-2, 1,0x0002,ar59,        0,0,0,0,0,0)
  XTREG( 61,244,32, 4, 4,0x013c,0x0006,-2, 1,0x0002,ar60,        0,0,0,0,0,0)
  XTREG( 62,248,32, 4, 4,0x013d,0x0006,-2, 1,0x0002,ar61,        0,0,0,0,0,0)
  XTREG( 63,252,32, 4, 4,0x013e,0x0006,-2, 1,0x0002,ar62,        0,0,0,0,0,0)
  XTREG( 64,256,32, 4, 4,0x013f,0x0006,-2, 1,0x0002,ar63,        0,0,0,0,0,0)
  XTREG( 65,260,32, 4, 4,0x0200,0x0006,-2, 2,0x1100,lbeg,        0,0,0,0,0,0)
  XTREG( 66,264,32, 4, 4,0x0201,0x0006,-2, 2,0x1100,lend,        0,0,0,0,0,0)
  XTREG( 67,268,32, 4, 4,0x0202,0x0006,-2, 2,0x1100,lcount,      0,0,0,0,0,0)
  XTREG( 68,272, 6, 4, 4,0x0203,0x0006,-2, 2,0x1100,sar,         0,0,0,0,0,0)
  XTREG( 69,276,20, 4, 4,0x0228,0x0006,-2, 2,0x1100,prefctl,     0,0,0,0,0,0)
  XTREG( 70,280, 4, 4, 4,0x0248,0x0006,-2, 2,0x1002,windowbase,  0,0,0,0,0,0)
  XTREG( 71,284,16, 4, 4,0x0249,0x0006,-2, 2,0x1002,windowstart, 0,0,0,0,0,0)
  XTREG( 72,288,32, 4, 4,0x02b0,0x0002,-2, 2,0x1000,configid0,   0,0,0,0,0,0)
  XTREG( 73,292,32, 4, 4,0x02d0,0x0002,-2, 2,0x1000,configid1,   0,0,0,0,0,0)
  XTREG( 74,296,19, 4, 4,0x02e6,0x0006,-2, 2,0x1100,ps,          0,0,0,0,0,0)
  XTREG( 75,300,32, 4, 4,0x03e7,0x0006,-2, 3,0x0110,threadptr,   0,0,0,0,0,0)
  XTREG( 76,304,16, 4, 4,0x0204,0x0006,-1, 2,0x1100,br,          0,0,0,0,0,0)
  XTREG( 77,308,32, 4, 4,0x03e6,0x000e,-1, 3,0x0110,expstate,    0,0,0,0,0,0)
  XTREG( 78,312,15, 4, 4,0x03f0,0x0006, 1, 3,0x0100,ae_ovf_sar,  0,0,0,0,0,0)
  XTREG( 79,316,32, 4, 4,0x03f1,0x0006, 1, 3,0x0110,ae_bithead,  0,0,0,0,0,0)
  XTREG( 80,320,16, 4, 4,0x03f2,0x0006, 1, 3,0x0100,ae_ts_fts_bu_bp,0,0,0,0,0,0)
  XTREG( 81,324,29, 4, 4,0x03f3,0x0006, 1, 3,0x0100,ae_cw_sd_no, 0,0,0,0,0,0)
  XTREG( 82,328,32, 4, 4,0x03f6,0x0006, 1, 3,0x0110,ae_cbegin0,  0,0,0,0,0,0)
  XTREG( 83,332,32, 4, 4,0x03f7,0x0006, 1, 3,0x0110,ae_cend0,    0,0,0,0,0,0)
  XTREG( 84,336,32, 4, 4,0x03f8,0x0006, 1, 3,0x0110,ae_cbegin1,  0,0,0,0,0,0)
  XTREG( 85,340,32, 4, 4,0x03f9,0x0006, 1, 3,0x0110,ae_cend1,    0,0,0,0,0,0)
  XTREG( 86,344,32, 4, 4,0x03fa,0x0006, 1, 3,0x0110,ae_cbegin2,  0,0,0,0,0,0)
  XTREG( 87,348,32, 4, 4,0x03fb,0x0006, 1, 3,0x0110,ae_cend2,    0,0,0,0,0,0)
  XTREG( 88,352,64, 8, 8,0x1000,0x0006, 1, 4,0x0101,aed0,
            "10:4f:03:01:00:3c:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:03:01:00:3d:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG( 89,360,64, 8, 8,0x1001,0x0006, 1, 4,0x0101,aed1,
            "10:4f:43:01:00:3c:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:43:01:00:3d:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG( 90,368,64, 8, 8,0x1002,0x0006, 1, 4,0x0101,aed2,
            "10:4f:83:01:00:3c:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:83:01:00:3d:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG( 91,376,64, 8, 8,0x1003,0x0006, 1, 4,0x0101,aed3,
            "10:4f:c3:01:00:3c:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:c3:01:00:3d:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG( 92,384,64, 8, 8,0x1004,0x0006, 1, 4,0x0101,aed4,
            "10:4f:07:01:00:3c:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:07:01:00:3d:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG( 93,392,64, 8, 8,0x1005,0x0006, 1, 4,0x0101,aed5,
            "10:4f:47:01:00:3c:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:47:01:00:3d:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG( 94,400,64, 8, 8,0x1006,0x0006, 1, 4,0x0101,aed6,
            "10:4f:87:01:00:3c:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:87:01:00:3d:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG( 95,408,64, 8, 8,0x1007,0x0006, 1, 4,0x0101,aed7,
            "10:4f:c7:01:00:3c:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:c7:01:00:3d:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG( 96,416,64, 8, 8,0x1008,0x0006, 1, 4,0x0101,aed8,
            "10:4f:0b:01:00:3c:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:0b:01:00:3d:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG( 97,424,64, 8, 8,0x1009,0x0006, 1, 4,0x0101,aed9,
            "10:4f:4b:01:00:3c:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:4b:01:00:3d:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG( 98,432,64, 8, 8,0x100a,0x0006, 1, 4,0x0101,aed10,
            "10:4f:8b:01:00:3c:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:8b:01:00:3d:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG( 99,440,64, 8, 8,0x100b,0x0006, 1, 4,0x0101,aed11,
            "10:4f:cb:01:00:3c:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:cb:01:00:3d:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(100,448,64, 8, 8,0x100c,0x0006, 1, 4,0x0101,aed12,
            "10:4f:0f:01:00:3c:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:0f:01:00:3d:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(101,456,64, 8, 8,0x100d,0x0006, 1, 4,0x0101,aed13,
            "10:4f:4f:01:00:3c:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:4f:01:00:3d:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(102,464,64, 8, 8,0x100e,0x0006, 1, 4,0x0101,aed14,
            "10:4f:8f:01:00:3c:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:8f:01:00:3d:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(103,472,64, 8, 8,0x100f,0x0006, 1, 4,0x0101,aed15,
            "10:4f:cf:01:00:3c:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:cf:01:00:3d:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(104,480,64, 8, 8,0x1010,0x0006, 1, 4,0x0101,aed16,
            "10:4f:03:01:00:3e:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:03:01:00:3f:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(105,488,64, 8, 8,0x1011,0x0006, 1, 4,0x0101,aed17,
            "10:4f:43:01:00:3e:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:43:01:00:3f:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(106,496,64, 8, 8,0x1012,0x0006, 1, 4,0x0101,aed18,
            "10:4f:83:01:00:3e:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:83:01:00:3f:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(107,504,64, 8, 8,0x1013,0x0006, 1, 4,0x0101,aed19,
            "10:4f:c3:01:00:3e:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:c3:01:00:3f:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(108,512,64, 8, 8,0x1014,0x0006, 1, 4,0x0101,aed20,
            "10:4f:07:01:00:3e:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:07:01:00:3f:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(109,520,64, 8, 8,0x1015,0x0006, 1, 4,0x0101,aed21,
            "10:4f:47:01:00:3e:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:47:01:00:3f:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(110,528,64, 8, 8,0x1016,0x0006, 1, 4,0x0101,aed22,
            "10:4f:87:01:00:3e:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:87:01:00:3f:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(111,536,64, 8, 8,0x1017,0x0006, 1, 4,0x0101,aed23,
            "10:4f:c7:01:00:3e:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:c7:01:00:3f:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(112,544,64, 8, 8,0x1018,0x0006, 1, 4,0x0101,aed24,
            "10:4f:0b:01:00:3e:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:0b:01:00:3f:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(113,552,64, 8, 8,0x1019,0x0006, 1, 4,0x0101,aed25,
            "10:4f:4b:01:00:3e:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:4b:01:00:3f:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(114,560,64, 8, 8,0x101a,0x0006, 1, 4,0x0101,aed26,
            "10:4f:8b:01:00:3e:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:8b:01:00:3f:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(115,568,64, 8, 8,0x101b,0x0006, 1, 4,0x0101,aed27,
            "10:4f:cb:01:00:3e:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:cb:01:00:3f:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(116,576,64, 8, 8,0x101c,0x0006, 1, 4,0x0101,aed28,
            "10:4f:0f:01:00:3e:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:0f:01:00:3f:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(117,584,64, 8, 8,0x101d,0x0006, 1, 4,0x0101,aed29,
            "10:4f:4f:01:00:3e:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:4f:01:00:3f:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(118,592,64, 8, 8,0x101e,0x0006, 1, 4,0x0101,aed30,
            "10:4f:8f:01:00:3e:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:8f:01:00:3f:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(119,600,64, 8, 8,0x101f,0x0006, 1, 4,0x0101,aed31,
            "10:4f:cf:01:00:3e:81:00:c5:d0:0c:25:0d:7b:25:ad:0e","10:4f:cf:01:00:3f:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(120,608,128,16,16,0x1020,0x0006, 1, 4,0x0101,u0,
            "10:4f:00:01:00:3b:81:80:c4:d0:0c:e4:09:7b:05:ad:0e","10:4f:c0:01:00:3f:81:00:c4:d0:0c:24:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(121,624,128,16,16,0x1021,0x0006, 1, 4,0x0101,u1,
            "10:4f:00:01:00:3b:81:80:c4:d0:0c:e5:09:7b:05:ad:0e","10:4f:c4:01:00:3f:81:00:c4:d0:0c:24:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(122,640,128,16,16,0x1022,0x0006, 1, 4,0x0101,u2,
            "10:4f:00:01:04:3b:81:80:c4:d0:0c:e4:09:7b:05:ad:0e","10:4f:c8:01:00:3f:81:00:c4:d0:0c:24:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(123,656,128,16,16,0x1023,0x0006, 1, 4,0x0101,u3,
            "10:4f:00:01:04:3b:81:80:c4:d0:0c:e5:09:7b:05:ad:0e","10:4f:cc:01:00:3f:81:00:c4:d0:0c:24:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(124,672, 8, 1, 1,0x1024,0x0006, 1, 4,0x0101,aep0,
            "03:52:64:01:08:5e:79:a5:14:c4:40:07:23:03:52:44:00:03:52:24:01","03:52:64:01:03:52:04:00:08:ce:35:a5:00:c4:40:07:23:03:52:24:01",0,0,0,0)
  XTREG(125,673, 8, 1, 1,0x1025,0x0006, 1, 4,0x0101,aep1,
            "03:52:64:01:08:5e:79:a5:14:c5:40:07:23:03:52:44:00:03:52:24:01","03:52:64:01:03:52:04:00:08:ce:35:a5:00:c5:40:07:23:03:52:24:01",0,0,0,0)
  XTREG(126,674, 8, 1, 1,0x1026,0x0006, 1, 4,0x0101,aep2,
            "03:52:64:01:08:5e:79:a5:14:c6:40:07:23:03:52:44:00:03:52:24:01","03:52:64:01:03:52:04:00:08:ce:35:a5:00:c6:40:07:23:03:52:24:01",0,0,0,0)
  XTREG(127,675, 8, 1, 1,0x1027,0x0006, 1, 4,0x0101,aep3,
            "03:52:64:01:08:5e:79:a5:14:c7:40:07:23:03:52:44:00:03:52:24:01","03:52:64:01:03:52:04:00:08:ce:35:a5:00:c7:40:07:23:03:52:24:01",0,0,0,0)
  XTREG(128,676,16, 4, 4,0x1029,0x0006, 1, 3,0x0200,ae_zbiasv8c,
            "10:4f:03:01:08:3c:81:00:c5:d0:0c:25:0d:7b:25:ad:0e:10:5f:01:00:0c:30:81:00:c5:d0:0c:44:0d:7b:25:ad:0e:10:4f:03:01:00:3c:81:00:c5:d0:0c:25:0d:7b:25:ad:0e:10:4f:03:01:08:3d:81:00:c4:d0:0c:25:0d:7b:25:ad:0e","10:4f:03:01:08:3c:81:00:c5:d0:0c:25:0d:7b:25:ad:0e:10:4f:03:01:00:3d:81:00:c4:d0:0c:25:0d:7b:25:ad:0e:10:5f:01:00:0c:38:81:00:c5:d0:0c:44:0d:7b:25:ad:0e:10:4f:03:01:08:3d:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(129,680, 7, 4, 4,0x102a,0x0006, 1, 3,0x0200,fcr_fsr,
            "10:4f:03:01:08:3c:81:00:c5:d0:0c:25:0d:7b:25:ad:0e:10:5f:01:a0:0e:00:80:00:c5:d0:0c:44:0d:9b:24:ad:0e:10:4f:03:01:00:3c:81:00:c5:d0:0c:25:0d:7b:25:ad:0e:10:4f:03:01:08:3d:81:00:c4:d0:0c:25:0d:7b:25:ad:0e","10:4f:03:01:08:3c:81:00:c5:d0:0c:25:0d:7b:25:ad:0e:10:4f:03:01:00:3d:81:00:c4:d0:0c:25:0d:7b:25:ad:0e:10:5f:01:80:0e:00:80:00:c5:d0:0c:44:0d:9b:24:ad:0e:10:4f:03:01:08:3d:81:00:c4:d0:0c:25:0d:7b:25:ad:0e",0,0,0,0)
  XTREG(130,684,32, 4, 4,0x0259,0x000d,-2, 2,0x1000,mmid,        0,0,0,0,0,0)
  XTREG(131,688,32, 4, 4,0x025a,0x0007,-2, 2,0x1000,mpuenb,      0,0,0,0,0,0)
  XTREG(132,692, 6, 4, 4,0x025c,0x0007,-2, 2,0x1000,mpucfg,      0,0,0,0,0,0)
  XTREG(133,696,16, 4, 4,0x025f,0x0007,-2, 2,0x1000,eraccess,    0,0,0,0,0,0)
  XTREG(134,700, 2, 4, 4,0x0260,0x0007,-2, 2,0x1000,ibreakenable,0,0,0,0,0,0)
  XTREG(135,704,24, 4, 4,0x0261,0x0007,-2, 2,0x1000,memctl,      0,0,0,0,0,0)
  XTREG(136,708, 8, 4, 4,0x0262,0x0007,-2, 2,0x1000,cacheadrdis, 0,0,0,0,0,0)
  XTREG(137,712, 9, 4, 4,0x0263,0x0007,-2, 2,0x1000,atomctl,     0,0,0,0,0,0)
  XTREG(138,716,32, 4, 4,0x0268,0x0007,-2, 2,0x1000,ddr,         0,0,0,0,0,0)
  XTREG(139,720, 2, 4, 4,0x0277,0x0007,-2, 2,0x1000,opmode,      0,0,0,0,0,0)
  XTREG(140,724,32, 4, 4,0x0280,0x0007,-2, 2,0x1000,ibreaka0,    0,0,0,0,0,0)
  XTREG(141,728,32, 4, 4,0x0281,0x0007,-2, 2,0x1000,ibreaka1,    0,0,0,0,0,0)
  XTREG(142,732,32, 4, 4,0x0290,0x0007,-2, 2,0x1000,dbreaka0,    0,0,0,0,0,0)
  XTREG(143,736,32, 4, 4,0x0291,0x0007,-2, 2,0x1000,dbreaka1,    0,0,0,0,0,0)
  XTREG(144,740,32, 4, 4,0x02a0,0x0007,-2, 2,0x1000,dbreakc0,    0,0,0,0,0,0)
  XTREG(145,744,32, 4, 4,0x02a1,0x0007,-2, 2,0x1000,dbreakc1,    0,0,0,0,0,0)
  XTREG(146,748,32, 4, 4,0x02b1,0x0007,-2, 2,0x1000,epc1,        0,0,0,0,0,0)
  XTREG(147,752,32, 4, 4,0x02b2,0x0007,-2, 2,0x1000,epc2,        0,0,0,0,0,0)
  XTREG(148,756,32, 4, 4,0x02b3,0x0007,-2, 2,0x1000,epc3,        0,0,0,0,0,0)
  XTREG(149,760,32, 4, 4,0x02b4,0x0007,-2, 2,0x1000,epc4,        0,0,0,0,0,0)
  XTREG(150,764,32, 4, 4,0x02b5,0x0007,-2, 2,0x1000,epc5,        0,0,0,0,0,0)
  XTREG(151,768,32, 4, 4,0x02b6,0x0007,-2, 2,0x1000,epc6,        0,0,0,0,0,0)
  XTREG(152,772,32, 4, 4,0x02c0,0x0007,-2, 2,0x1000,depc,        0,0,0,0,0,0)
  XTREG(153,776,19, 4, 4,0x02c2,0x0007,-2, 2,0x1000,eps2,        0,0,0,0,0,0)
  XTREG(154,780,19, 4, 4,0x02c3,0x0007,-2, 2,0x1000,eps3,        0,0,0,0,0,0)
  XTREG(155,784,19, 4, 4,0x02c4,0x0007,-2, 2,0x1000,eps4,        0,0,0,0,0,0)
  XTREG(156,788,19, 4, 4,0x02c5,0x0007,-2, 2,0x1000,eps5,        0,0,0,0,0,0)
  XTREG(157,792,19, 4, 4,0x02c6,0x0007,-2, 2,0x1000,eps6,        0,0,0,0,0,0)
  XTREG(158,796,32, 4, 4,0x02d1,0x0007,-2, 2,0x1000,excsave1,    0,0,0,0,0,0)
  XTREG(159,800,32, 4, 4,0x02d2,0x0007,-2, 2,0x1000,excsave2,    0,0,0,0,0,0)
  XTREG(160,804,32, 4, 4,0x02d3,0x0007,-2, 2,0x1000,excsave3,    0,0,0,0,0,0)
  XTREG(161,808,32, 4, 4,0x02d4,0x0007,-2, 2,0x1000,excsave4,    0,0,0,0,0,0)
  XTREG(162,812,32, 4, 4,0x02d5,0x0007,-2, 2,0x1000,excsave5,    0,0,0,0,0,0)
  XTREG(163,816,32, 4, 4,0x02d6,0x0007,-2, 2,0x1000,excsave6,    0,0,0,0,0,0)
  XTREG(164,820, 2, 4, 4,0x02e0,0x0007,-2, 2,0x1000,cpenable,    0,0,0,0,0,0)
  XTREG(165,824,32, 4, 4,0x02e2,0x000b,-2, 2,0x1000,interrupt,   0,0,0,0,0,0)
  XTREG(166,828,32, 4, 4,0x02e2,0x000d,-2, 2,0x1000,intset,      0,0,0,0,0,0)
  XTREG(167,832,32, 4, 4,0x02e3,0x000d,-2, 2,0x1000,intclear,    0,0,0,0,0,0)
  XTREG(168,836,32, 4, 4,0x02e4,0x0007,-2, 2,0x1000,intenable,   0,0,0,0,0,0)
  XTREG(169,840,32, 4, 4,0x02e7,0x0007,-2, 2,0x1000,vecbase,     0,0,0,0,0,0)
  XTREG(170,844, 6, 4, 4,0x02e8,0x0007,-2, 2,0x1000,exccause,    0,0,0,0,0,0)
  XTREG(171,848,12, 4, 4,0x02e9,0x0003,-2, 2,0x1000,debugcause,  0,0,0,0,0,0)
  XTREG(172,852,32, 4, 4,0x02ea,0x000f,-2, 2,0x1000,ccount,      0,0,0,0,0,0)
  XTREG(173,856,32, 4, 4,0x02eb,0x0003,-2, 2,0x1000,prid,        0,0,0,0,0,0)
  XTREG(174,860,32, 4, 4,0x02ec,0x000f,-2, 2,0x1000,icount,      0,0,0,0,0,0)
  XTREG(175,864, 4, 4, 4,0x02ed,0x0007,-2, 2,0x1000,icountlevel, 0,0,0,0,0,0)
  XTREG(176,868,32, 4, 4,0x02ee,0x0007,-2, 2,0x1000,excvaddr,    0,0,0,0,0,0)
  XTREG(177,872,32, 4, 4,0x02f0,0x000f,-2, 2,0x1000,ccompare0,   0,0,0,0,0,0)
  XTREG(178,876,32, 4, 4,0x02f1,0x000f,-2, 2,0x1000,ccompare1,   0,0,0,0,0,0)
  XTREG(179,880,32, 4, 4,0x02f2,0x000f,-2, 2,0x1000,ccompare2,   0,0,0,0,0,0)
  XTREG(180,884,32, 4, 4,0x02f4,0x0007,-2, 2,0x1000,misc0,       0,0,0,0,0,0)
  XTREG(181,888,32, 4, 4,0x02f5,0x0007,-2, 2,0x1000,misc1,       0,0,0,0,0,0)
  XTREG(182,892,32, 4, 4,0x02f6,0x0007,-2, 2,0x1000,misc2,       0,0,0,0,0,0)
  XTREG(183,896,32, 4, 4,0x02f7,0x0007,-2, 2,0x1000,misc3,       0,0,0,0,0,0)
  XTREG(184,900,32, 4, 4,0x2029,0x000f,-2, 4,0x0101,pwrctl,
            "03:52:64:01:03:62:64:02:03:52:a4:0c:03:60:55:11:03:52:c5:20:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:0c:03:60:55:11:03:52:c5:20:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(185,904,32, 4, 4,0x202a,0x000f,-2, 4,0x0101,pwrstat,
            "03:52:64:01:03:62:64:02:03:52:a4:0c:03:60:55:11:03:52:c5:24:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:0c:03:60:55:11:03:52:c5:24:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(186,908, 1, 4, 4,0x202b,0x000f,-2, 4,0x0101,eristat,
            "03:52:64:01:03:62:64:02:03:52:a4:0c:03:60:55:11:03:52:c5:28:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:0c:03:60:55:11:03:52:c5:28:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(187,912,32, 4, 4,0x202c,0x000f,-2, 4,0x0101,cs_itctrl,
            "03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:d5:03:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:d5:03:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(188,916,16, 4, 4,0x202d,0x000f,-2, 4,0x0101,cs_claimset,
            "03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:c5:a0:03:52:d5:04:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:c5:a0:03:52:d5:04:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(189,920,16, 4, 4,0x202e,0x000f,-2, 4,0x0101,cs_claimclr,
            "03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:c5:a4:03:52:d5:04:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:c5:a4:03:52:d5:04:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(190,924,32, 4, 4,0x202f,0x000d,-2, 4,0x0101,cs_lockaccess,
            "03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:c5:b0:03:52:d5:04:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:c5:b0:03:52:d5:04:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(191,928,32, 4, 4,0x2030,0x000b,-2, 4,0x0101,cs_lockstatus,
            "03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:c5:b4:03:52:d5:04:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:c5:b4:03:52:d5:04:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(192,932, 1, 4, 4,0x2031,0x000b,-2, 4,0x0101,cs_authstatus,
            "03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:c5:b8:03:52:d5:04:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:c5:b8:03:52:d5:04:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(193,936,32, 4, 4,0x2040,0x000f,-2, 4,0x0101,fault_info,
            "03:52:64:01:03:62:64:02:03:52:a4:0c:03:60:55:11:03:52:c5:30:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:0c:03:60:55:11:03:52:c5:30:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(194,940,32, 4, 4,0x2041,0x0003,-2, 4,0x0101,trax_id,
            "03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(195,944,32, 4, 4,0x2042,0x000f,-2, 4,0x0101,trax_control,
            "03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:04:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:04:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(196,948,32, 4, 4,0x2043,0x000b,-2, 4,0x0101,trax_status,
            "03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:08:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:08:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(197,952,32, 4, 4,0x2044,0x000f,-2, 4,0x0101,trax_data,
            "03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:0c:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:0c:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(198,956,32, 4, 4,0x2045,0x000f,-2, 4,0x0101,trax_address,
            "03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:10:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:10:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(199,960,32, 4, 4,0x2046,0x000f,-2, 4,0x0101,trax_pctrigger,
            "03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:14:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:14:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(200,964,32, 4, 4,0x2047,0x000f,-2, 4,0x0101,trax_pcmatch,
            "03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:18:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:18:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(201,968,32, 4, 4,0x2048,0x000f,-2, 4,0x0101,trax_delay,
            "03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:1c:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:1c:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(202,972,32, 4, 4,0x2049,0x000f,-2, 4,0x0101,trax_memstart,
            "03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:20:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:20:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(203,976,32, 4, 4,0x204a,0x000f,-2, 4,0x0101,trax_memend,
            "03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:24:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:24:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(204,980,32, 4, 4,0x2058,0x000f,-2, 4,0x0101,pmg,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(205,984,32, 4, 4,0x2059,0x000f,-2, 4,0x0101,pmpc,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:04:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:04:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(206,988,32, 4, 4,0x205a,0x000f,-2, 4,0x0101,pm0,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:01:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:01:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(207,992,32, 4, 4,0x205b,0x000f,-2, 4,0x0101,pm1,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:01:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:01:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(208,996,32, 4, 4,0x205c,0x000f,-2, 4,0x0101,pm2,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:01:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:01:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(209,1000,32, 4, 4,0x205d,0x000f,-2, 4,0x0101,pm3,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:01:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:01:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(210,1004,32, 4, 4,0x205e,0x000f,-2, 4,0x0101,pm4,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:01:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:01:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(211,1008,32, 4, 4,0x205f,0x000f,-2, 4,0x0101,pm5,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:01:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:01:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(212,1012,32, 4, 4,0x2060,0x000f,-2, 4,0x0101,pm6,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:01:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:01:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(213,1016,32, 4, 4,0x2061,0x000f,-2, 4,0x0101,pm7,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:01:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:01:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(214,1020,32, 4, 4,0x2062,0x000f,-2, 4,0x0101,pmctrl0,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:d5:01:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:d5:01:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(215,1024,32, 4, 4,0x2063,0x000f,-2, 4,0x0101,pmctrl1,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:d5:01:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:d5:01:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(216,1028,32, 4, 4,0x2064,0x000f,-2, 4,0x0101,pmctrl2,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:d5:01:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:d5:01:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(217,1032,32, 4, 4,0x2065,0x000f,-2, 4,0x0101,pmctrl3,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:d5:01:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:d5:01:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(218,1036,32, 4, 4,0x2066,0x000f,-2, 4,0x0101,pmctrl4,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:d5:01:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:d5:01:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(219,1040,32, 4, 4,0x2067,0x000f,-2, 4,0x0101,pmctrl5,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:d5:01:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:d5:01:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(220,1044,32, 4, 4,0x2068,0x000f,-2, 4,0x0101,pmctrl6,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:d5:01:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:d5:01:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(221,1048,32, 4, 4,0x2069,0x000f,-2, 4,0x0101,pmctrl7,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:d5:01:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:d5:01:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(222,1052,32, 4, 4,0x206a,0x000f,-2, 4,0x0101,pmstat0,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:02:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:02:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(223,1056,32, 4, 4,0x206b,0x000f,-2, 4,0x0101,pmstat1,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:02:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:02:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(224,1060,32, 4, 4,0x206c,0x000f,-2, 4,0x0101,pmstat2,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:02:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:02:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(225,1064,32, 4, 4,0x206d,0x000f,-2, 4,0x0101,pmstat3,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:02:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:02:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(226,1068,32, 4, 4,0x206e,0x000f,-2, 4,0x0101,pmstat4,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:02:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:02:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(227,1072,32, 4, 4,0x206f,0x000f,-2, 4,0x0101,pmstat5,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:02:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:02:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(228,1076,32, 4, 4,0x2070,0x000f,-2, 4,0x0101,pmstat6,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:02:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:02:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(229,1080,32, 4, 4,0x2071,0x000f,-2, 4,0x0101,pmstat7,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:02:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:02:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(230,1084,32, 4, 4,0x2072,0x0003,-2, 4,0x0101,ocdid,
            "03:52:64:01:03:62:64:02:03:52:a4:08:03:60:55:11:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:08:03:60:55:11:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(231,1088,32, 4, 4,0x2073,0x000f,-2, 4,0x0101,ocd_dcrclr,
            "03:52:64:01:03:62:64:02:03:52:a4:08:03:60:55:11:03:52:c5:08:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:08:03:60:55:11:03:52:c5:08:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(232,1092,32, 4, 4,0x2074,0x000f,-2, 4,0x0101,ocd_dcrset,
            "03:52:64:01:03:62:64:02:03:52:a4:08:03:60:55:11:03:52:c5:0c:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:08:03:60:55:11:03:52:c5:0c:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(233,1096,32, 4, 4,0x2075,0x000f,-2, 4,0x0101,ocd_dsr,
            "03:52:64:01:03:62:64:02:03:52:a4:08:03:60:55:11:03:52:c5:10:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:08:03:60:55:11:03:52:c5:10:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(234,1100,32, 4, 4,0x0000,0x0006,-2, 8,0x2100,a0,          0,0,0,0,0,0)
  XTREG(235,1104,32, 4, 4,0x0001,0x0006,-2, 8,0x2100,a1,          0,0,0,0,0,0)
  XTREG(236,1108,32, 4, 4,0x0002,0x0006,-2, 8,0x2100,a2,          0,0,0,0,0,0)
  XTREG(237,1112,32, 4, 4,0x0003,0x0006,-2, 8,0x2100,a3,          0,0,0,0,0,0)
  XTREG(238,1116,32, 4, 4,0x0004,0x0006,-2, 8,0x2100,a4,          0,0,0,0,0,0)
  XTREG(239,1120,32, 4, 4,0x0005,0x0006,-2, 8,0x2100,a5,          0,0,0,0,0,0)
  XTREG(240,1124,32, 4, 4,0x0006,0x0006,-2, 8,0x2100,a6,          0,0,0,0,0,0)
  XTREG(241,1128,32, 4, 4,0x0007,0x0006,-2, 8,0x2100,a7,          0,0,0,0,0,0)
  XTREG(242,1132,32, 4, 4,0x0008,0x0006,-2, 8,0x2100,a8,          0,0,0,0,0,0)
  XTREG(243,1136,32, 4, 4,0x0009,0x0006,-2, 8,0x2100,a9,          0,0,0,0,0,0)
  XTREG(244,1140,32, 4, 4,0x000a,0x0006,-2, 8,0x2100,a10,         0,0,0,0,0,0)
  XTREG(245,1144,32, 4, 4,0x000b,0x0006,-2, 8,0x2100,a11,         0,0,0,0,0,0)
  XTREG(246,1148,32, 4, 4,0x000c,0x0006,-2, 8,0x2100,a12,         0,0,0,0,0,0)
  XTREG(247,1152,32, 4, 4,0x000d,0x0006,-2, 8,0x2100,a13,         0,0,0,0,0,0)
  XTREG(248,1156,32, 4, 4,0x000e,0x0006,-2, 8,0x2100,a14,         0,0,0,0,0,0)
  XTREG(249,1160,32, 4, 4,0x000f,0x0006,-2, 8,0x2100,a15,         0,0,0,0,0,0)
  XTREG(250,1164, 1, 1, 1,0x0010,0x0006,-2, 6,0x1010,b0,
            0,0,&xtensa_mask0,0,0,0)
  XTREG(251,1165, 1, 1, 1,0x0011,0x0006,-2, 6,0x1010,b1,
            0,0,&xtensa_mask1,0,0,0)
  XTREG(252,1166, 1, 1, 1,0x0012,0x0006,-2, 6,0x1010,b2,
            0,0,&xtensa_mask2,0,0,0)
  XTREG(253,1167, 1, 1, 1,0x0013,0x0006,-2, 6,0x1010,b3,
            0,0,&xtensa_mask3,0,0,0)
  XTREG(254,1168, 1, 1, 1,0x0014,0x0006,-2, 6,0x1010,b4,
            0,0,&xtensa_mask4,0,0,0)
  XTREG(255,1169, 1, 1, 1,0x0015,0x0006,-2, 6,0x1010,b5,
            0,0,&xtensa_mask5,0,0,0)
  XTREG(256,1170, 1, 1, 1,0x0016,0x0006,-2, 6,0x1010,b6,
            0,0,&xtensa_mask6,0,0,0)
  XTREG(257,1171, 1, 1, 1,0x0017,0x0006,-2, 6,0x1010,b7,
            0,0,&xtensa_mask7,0,0,0)
  XTREG(258,1172, 1, 1, 1,0x0018,0x0006,-2, 6,0x1010,b8,
            0,0,&xtensa_mask8,0,0,0)
  XTREG(259,1173, 1, 1, 1,0x0019,0x0006,-2, 6,0x1010,b9,
            0,0,&xtensa_mask9,0,0,0)
  XTREG(260,1174, 1, 1, 1,0x001a,0x0006,-2, 6,0x1010,b10,
            0,0,&xtensa_mask10,0,0,0)
  XTREG(261,1175, 1, 1, 1,0x001b,0x0006,-2, 6,0x1010,b11,
            0,0,&xtensa_mask11,0,0,0)
  XTREG(262,1176, 1, 1, 1,0x001c,0x0006,-2, 6,0x1010,b12,
            0,0,&xtensa_mask12,0,0,0)
  XTREG(263,1177, 1, 1, 1,0x001d,0x0006,-2, 6,0x1010,b13,
            0,0,&xtensa_mask13,0,0,0)
  XTREG(264,1178, 1, 1, 1,0x001e,0x0006,-2, 6,0x1010,b14,
            0,0,&xtensa_mask14,0,0,0)
  XTREG(265,1179, 1, 1, 1,0x001f,0x0006,-2, 6,0x1010,b15,
            0,0,&xtensa_mask15,0,0,0)
  XTREG(266,1180, 1, 4, 4,0x2002,0x0006,-2, 6,0x1010,vecbaselock,
            0,0,&xtensa_mask16,0,0,0)
  XTREG(267,1184, 4, 4, 4,0x2008,0x0006,-2, 6,0x1010,psintlevel,
            0,0,&xtensa_mask17,0,0,0)
  XTREG(268,1188, 1, 4, 4,0x2009,0x0006,-2, 6,0x1010,psum,
            0,0,&xtensa_mask18,0,0,0)
  XTREG(269,1192, 1, 4, 4,0x200a,0x0006,-2, 6,0x1010,pswoe,
            0,0,&xtensa_mask19,0,0,0)
  XTREG(270,1196, 2, 4, 4,0x200b,0x0006,-2, 6,0x1010,psring,
            0,0,&xtensa_mask20,0,0,0)
  XTREG(271,1200, 1, 4, 4,0x200c,0x0006,-2, 6,0x1010,psexcm,
            0,0,&xtensa_mask21,0,0,0)
  XTREG(272,1204, 2, 4, 4,0x200d,0x0006,-2, 6,0x1010,pscallinc,
            0,0,&xtensa_mask22,0,0,0)
  XTREG(273,1208, 4, 4, 4,0x200e,0x0006,-2, 6,0x1010,psowb,
            0,0,&xtensa_mask23,0,0,0)
  XTREG(274,1212, 6, 4, 4,0x200f,0x0006,-2, 6,0x1010,mpunumentries,
            0,0,&xtensa_mask24,0,0,0)
  XTREG(275,1216, 2, 4, 4,0x2010,0x0006,-2, 6,0x1010,opmodeeccfence,
            0,0,&xtensa_mask25,0,0,0)
  XTREG(276,1220, 4, 4, 4,0x2015,0x0006,-2, 6,0x1010,dbnum,
            0,0,&xtensa_mask26,0,0,0)
  XTREG(277,1224, 1, 4, 4,0x2018,0x0006, 1, 6,0x1010,ae_overflow,
            0,0,&xtensa_mask27,0,0,0)
  XTREG(278,1228,14, 4, 4,0x2019,0x0006, 1, 6,0x1010,ae_sar,
            0,0,&xtensa_mask28,0,0,0)
  XTREG(279,1232, 1, 4, 4,0x201a,0x0006, 1, 6,0x1010,ae_cwrap,
            0,0,&xtensa_mask29,0,0,0)
  XTREG(280,1236, 4, 4, 4,0x201b,0x0006, 1, 6,0x1010,ae_bitptr,
            0,0,&xtensa_mask30,0,0,0)
  XTREG(281,1240, 4, 4, 4,0x201c,0x0006, 1, 6,0x1010,ae_bitsused,
            0,0,&xtensa_mask31,0,0,0)
  XTREG(282,1244, 4, 4, 4,0x201d,0x0006, 1, 6,0x1010,ae_tablesize,
            0,0,&xtensa_mask32,0,0,0)
  XTREG(283,1248, 4, 4, 4,0x201e,0x0006, 1, 6,0x1010,ae_first_ts,
            0,0,&xtensa_mask33,0,0,0)
  XTREG(284,1252,27, 4, 4,0x201f,0x0006, 1, 6,0x1010,ae_nextoffset,
            0,0,&xtensa_mask34,0,0,0)
  XTREG(285,1256, 1, 4, 4,0x2020,0x0006, 1, 6,0x1010,ae_searchdone,
            0,0,&xtensa_mask35,0,0,0)
  XTREG(286,1260, 8, 4, 4,0x2021,0x0006, 1, 6,0x1010,ae_zbiasv8,
            0,0,&xtensa_mask36,0,0,0)
  XTREG(287,1264, 8, 4, 4,0x2022,0x0006, 1, 6,0x1010,ae_zbiasc8,
            0,0,&xtensa_mask37,0,0,0)
  XTREG(288,1268, 2, 4, 4,0x2023,0x0006, 1, 6,0x1010,roundmode,
            0,0,&xtensa_mask38,0,0,0)
  XTREG(289,1272, 1, 4, 4,0x2024,0x0006, 1, 6,0x1010,invalidflag,
            0,0,&xtensa_mask39,0,0,0)
  XTREG(290,1276, 1, 4, 4,0x2025,0x0006, 1, 6,0x1010,divzeroflag,
            0,0,&xtensa_mask40,0,0,0)
  XTREG(291,1280, 1, 4, 4,0x2026,0x0006, 1, 6,0x1010,overflowflag,
            0,0,&xtensa_mask41,0,0,0)
  XTREG(292,1284, 1, 4, 4,0x2027,0x0006, 1, 6,0x1010,underflowflag,
            0,0,&xtensa_mask42,0,0,0)
  XTREG_END
};


xtensa_gdbarch_tdep xtensa_tdep (rmap);

#ifdef XTENSA_CONFIG_INSTANTIATE
XTENSA_CONFIG_INSTANTIATE(rmap,16)
#endif

