/* Xtensa configuration-specific ISA information.

   Copyright (c) 2003-2022 Tensilica Inc.

   Permission is hereby granted, free of charge, to any person obtaining
   a copy of this software and associated documentation files (the
   "Software"), to deal in the Software without restriction, including
   without limitation the rights to use, copy, modify, merge, publish,
   distribute, sublicense, and/or sell copies of the Software, and to
   permit persons to whom the Software is furnished to do so, subject to
   the following conditions:

   The above copyright notice and this permission notice shall be included
   in all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
   CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
   TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
   SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.  */

#include "ansidecl.h"
#include <xtensa-isa.h>
#include "xtensa-isa-internal.h"


/* Sysregs.  */

static xtensa_sysreg_internal sysregs[] = {
  { "LBEG", 0, 0 },
  { "LEND", 1, 0 },
  { "LCOUNT", 2, 0 },
  { "BR", 4, 0 },
  { "ACCLO", 16, 0 },
  { "ACCHI", 17, 0 },
  { "M0", 32, 0 },
  { "M1", 33, 0 },
  { "M2", 34, 0 },
  { "M3", 35, 0 },
  { "MMID", 89, 0 },
  { "DDR", 104, 0 },
  { "CONFIGID0", 176, 0 },
  { "CONFIGID1", 208, 0 },
  { "INTERRUPT", 226, 0 },
  { "INTCLEAR", 227, 0 },
  { "CCOUNT", 234, 0 },
  { "PRID", 235, 0 },
  { "ICOUNT", 236, 0 },
  { "CCOMPARE0", 240, 0 },
  { "CCOMPARE1", 241, 0 },
  { "VECBASE", 231, 0 },
  { "EPC1", 177, 0 },
  { "EPC2", 178, 0 },
  { "EPC3", 179, 0 },
  { "EPC4", 180, 0 },
  { "EPC5", 181, 0 },
  { "EXCSAVE1", 209, 0 },
  { "EXCSAVE2", 210, 0 },
  { "EXCSAVE3", 211, 0 },
  { "EXCSAVE4", 212, 0 },
  { "EXCSAVE5", 213, 0 },
  { "EPS2", 194, 0 },
  { "EPS3", 195, 0 },
  { "EPS4", 196, 0 },
  { "EPS5", 197, 0 },
  { "EXCCAUSE", 232, 0 },
  { "DEPC", 192, 0 },
  { "EXCVADDR", 238, 0 },
  { "WINDOWBASE", 72, 0 },
  { "WINDOWSTART", 73, 0 },
  { "MEMCTL", 97, 0 },
  { "SAR", 3, 0 },
  { "PS", 230, 0 },
  { "MISC0", 244, 0 },
  { "MISC1", 245, 0 },
  { "INTENABLE", 228, 0 },
  { "DBREAKA0", 144, 0 },
  { "DBREAKC0", 160, 0 },
  { "DBREAKA1", 145, 0 },
  { "DBREAKC1", 161, 0 },
  { "IBREAKA0", 128, 0 },
  { "IBREAKA1", 129, 0 },
  { "IBREAKENABLE", 96, 0 },
  { "ICOUNTLEVEL", 237, 0 },
  { "DEBUGCAUSE", 233, 0 },
  { "CPENABLE", 224, 0 },
  { "SCOMPARE1", 12, 0 },
  { "ATOMCTL", 99, 0 },
  { "THREADPTR", 231, 1 },
  { "CIRC", -1, 1 },
  { "TABLEFIRSTSEARCHNEXT", -1, 1 },
  { "FUSIONMISC", -1, 1 },
  { "FCR_FSR", -1, 1 },
  { "EXPSTATE", 230, 1 }
};

#define NUM_SYSREGS 65
#define MAX_SPECIAL_REG 245
#define MAX_USER_REG 231


/* Processor states.  */

static xtensa_state_internal states[] = {
  { "LCOUNT", 32, 0 },
  { "PC", 32, 0 },
  { "DDR", 32, 0 },
  { "ICOUNT", 32, 0 },
  { "INTERRUPT", 32, 0 },
  { "CCOUNT", 32, 0 },
  { "XTSYNC", 1, 0 },
  { "VECBASE", 22, 0 },
  { "EPC1", 32, 0 },
  { "EPC2", 32, 0 },
  { "EPC3", 32, 0 },
  { "EPC4", 32, 0 },
  { "EPC5", 32, 0 },
  { "EXCSAVE1", 32, 0 },
  { "EXCSAVE2", 32, 0 },
  { "EXCSAVE3", 32, 0 },
  { "EXCSAVE4", 32, 0 },
  { "EXCSAVE5", 32, 0 },
  { "EPS2", 13, 0 },
  { "EPS3", 13, 0 },
  { "EPS4", 13, 0 },
  { "EPS5", 13, 0 },
  { "EXCCAUSE", 6, 0 },
  { "PSINTLEVEL", 4, 0 },
  { "PSUM", 1, 0 },
  { "PSWOE", 1, 0 },
  { "PSEXCM", 1, 0 },
  { "DEPC", 32, 0 },
  { "EXCVADDR", 32, 0 },
  { "WindowBase", 3, 0 },
  { "WindowStart", 8, 0 },
  { "PSCALLINC", 2, 0 },
  { "PSOWB", 4, 0 },
  { "LBEG", 32, 0 },
  { "LEND", 32, 0 },
  { "MEMCTL", 1, 0 },
  { "SAR", 6, 0 },
  { "THREADPTR", 32, 0 },
  { "MISC0", 32, 0 },
  { "MISC1", 32, 0 },
  { "ACC", 40, 0 },
  { "InOCDMode", 1, 0 },
  { "INTENABLE", 32, 0 },
  { "DBREAKA0", 32, 0 },
  { "DBREAKC0", 8, 0 },
  { "DBREAKA1", 32, 0 },
  { "DBREAKC1", 8, 0 },
  { "IBREAKA0", 32, 0 },
  { "IBREAKA1", 32, 0 },
  { "IBREAKENABLE", 2, 0 },
  { "ICOUNTLEVEL", 4, 0 },
  { "DEBUGCAUSE", 6, 0 },
  { "DBNUM", 4, 0 },
  { "CCOMPARE0", 32, 0 },
  { "CCOMPARE1", 32, 0 },
  { "CPENABLE", 2, 0 },
  { "SCOMPARE1", 32, 0 },
  { "ATOMCTL", 6, 0 },
  { "ERI_RAW_INTERLOCK", 1, 0 },
  { "AE_OVERFLOW", 1, XTENSA_STATE_IS_SHARED_OR },
  { "AE_CBEGIN0", 32, 0 },
  { "AE_CEND0", 32, 0 },
  { "AE_SAR", 7, 0 },
  { "AE_CWRAP", 1, 0 },
  { "AE_BITHEAD", 32, 0 },
  { "AE_BITPTR", 4, 0 },
  { "AE_BITSUSED", 4, 0 },
  { "AE_TABLESIZE", 4, 0 },
  { "AE_FIRST_TS", 4, 0 },
  { "AE_NEXTOFFSET", 27, 0 },
  { "AE_SEARCHDONE", 1, 0 },
  { "RoundMode", 2, 0 },
  { "InvalidFlag", 1, XTENSA_STATE_IS_SHARED_OR },
  { "DivZeroFlag", 1, XTENSA_STATE_IS_SHARED_OR },
  { "OverflowFlag", 1, XTENSA_STATE_IS_SHARED_OR },
  { "UnderflowFlag", 1, XTENSA_STATE_IS_SHARED_OR },
  { "InexactFlag", 1, XTENSA_STATE_IS_SHARED_OR },
  { "EXPSTATE", 32, XTENSA_STATE_IS_EXPORTED }
};

#define NUM_STATES 78

enum xtensa_state_id {
  STATE_LCOUNT,
  STATE_PC,
  STATE_DDR,
  STATE_ICOUNT,
  STATE_INTERRUPT,
  STATE_CCOUNT,
  STATE_XTSYNC,
  STATE_VECBASE,
  STATE_EPC1,
  STATE_EPC2,
  STATE_EPC3,
  STATE_EPC4,
  STATE_EPC5,
  STATE_EXCSAVE1,
  STATE_EXCSAVE2,
  STATE_EXCSAVE3,
  STATE_EXCSAVE4,
  STATE_EXCSAVE5,
  STATE_EPS2,
  STATE_EPS3,
  STATE_EPS4,
  STATE_EPS5,
  STATE_EXCCAUSE,
  STATE_PSINTLEVEL,
  STATE_PSUM,
  STATE_PSWOE,
  STATE_PSEXCM,
  STATE_DEPC,
  STATE_EXCVADDR,
  STATE_WindowBase,
  STATE_WindowStart,
  STATE_PSCALLINC,
  STATE_PSOWB,
  STATE_LBEG,
  STATE_LEND,
  STATE_MEMCTL,
  STATE_SAR,
  STATE_THREADPTR,
  STATE_MISC0,
  STATE_MISC1,
  STATE_ACC,
  STATE_InOCDMode,
  STATE_INTENABLE,
  STATE_DBREAKA0,
  STATE_DBREAKC0,
  STATE_DBREAKA1,
  STATE_DBREAKC1,
  STATE_IBREAKA0,
  STATE_IBREAKA1,
  STATE_IBREAKENABLE,
  STATE_ICOUNTLEVEL,
  STATE_DEBUGCAUSE,
  STATE_DBNUM,
  STATE_CCOMPARE0,
  STATE_CCOMPARE1,
  STATE_CPENABLE,
  STATE_SCOMPARE1,
  STATE_ATOMCTL,
  STATE_ERI_RAW_INTERLOCK,
  STATE_AE_OVERFLOW,
  STATE_AE_CBEGIN0,
  STATE_AE_CEND0,
  STATE_AE_SAR,
  STATE_AE_CWRAP,
  STATE_AE_BITHEAD,
  STATE_AE_BITPTR,
  STATE_AE_BITSUSED,
  STATE_AE_TABLESIZE,
  STATE_AE_FIRST_TS,
  STATE_AE_NEXTOFFSET,
  STATE_AE_SEARCHDONE,
  STATE_RoundMode,
  STATE_InvalidFlag,
  STATE_DivZeroFlag,
  STATE_OverflowFlag,
  STATE_UnderflowFlag,
  STATE_InexactFlag,
  STATE_EXPSTATE
};


/* Field definitions.  */

static unsigned
Field_t_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_s_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_r_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_op2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_op1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_op1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_op0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_op0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_n_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_n_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_m_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_m_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_sr_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sr_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_st_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_st_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_thi3_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_thi3_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_t3_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_t3_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_tlo_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_tlo_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_w_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_w_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_r3_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_r3_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_rhi_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_rhi_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_s3to1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_s3to1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_inst_15_12_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_inst_15_12_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_inst_11_8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_inst_11_8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_inst_7_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_inst_7_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_inst_7_4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_inst_7_4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_inst_5_4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_inst_5_4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_inst_7_6_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_inst_7_6_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_inst_4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_inst_4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_inst_12_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_inst_12_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_inst_19_17_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  return tie_t;
}

static void
Field_inst_19_17_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_inst_19_18_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  return tie_t;
}

static void
Field_inst_19_18_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_op0_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_op0_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_t_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_r_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_r_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_op0_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_op0_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_z_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_z_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_i_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_i_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_s_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_s_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_inst16b_15_13_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_ae_fld_inst16b_15_13_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_ae_fld_inst16b_12_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_ae_fld_inst16b_12_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_fusion_slot1_20_8_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 11) >> 19);
  return tie_t;
}

static void
Field_fld_fusion_slot1_20_8_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x1fff00) | (tie_t << 8);
}

static unsigned
Field_fld_fusion_slot1_20_16_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 11) >> 27);
  return tie_t;
}

static void
Field_fld_fusion_slot1_20_16_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0000) | (tie_t << 16);
}

static unsigned
Field_fld_fusion_slot1_20_12_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 11) >> 23);
  return tie_t;
}

static void
Field_fld_fusion_slot1_20_12_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x1ff000) | (tie_t << 12);
}

static unsigned
Field_fld_fusion_slot1_7_4_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_fusion_slot1_7_4_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_fusion_slot1_20_0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 21) | ((insn[0] << 11) >> 11);
  return tie_t;
}

static void
Field_fld_fusion_slot1_20_0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 11) >> 11;
  insn[0] = (insn[0] & ~0x1fffff) | (tie_t << 0);
}

static unsigned
Field_fld_fusion_slot1_3_0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_fusion_slot1_3_0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_fusion_slot1_20_13_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 11) >> 24);
  return tie_t;
}

static void
Field_fld_fusion_slot1_20_13_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x1fe000) | (tie_t << 13);
}

static unsigned
Field_fld_fusion_slot1_1_0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_fusion_slot1_1_0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_fusion_slot1_0_0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_fusion_slot1_0_0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_fld_fusion_slot1_7_6_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_fusion_slot1_7_6_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_fusion_slot1_9_8_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_fusion_slot1_9_8_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_fusion_slot1_8_8_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_fld_fusion_slot1_8_8_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_fld_fusion_slot1_20_4_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 17) | ((insn[0] << 11) >> 15);
  return tie_t;
}

static void
Field_fld_fusion_slot1_20_4_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0x1ffff0) | (tie_t << 4);
}

static unsigned
Field_fld_fusion_slot0_22_18_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 9) >> 27);
  return tie_t;
}

static void
Field_fld_fusion_slot0_22_18_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c0000) | (tie_t << 18);
}

static unsigned
Field_fld_fusion_slot0_22_4_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 19) | ((insn[0] << 9) >> 13);
  return tie_t;
}

static void
Field_fld_fusion_slot0_22_4_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 13) >> 13;
  insn[0] = (insn[0] & ~0x7ffff0) | (tie_t << 4);
}

static unsigned
Field_fld_fusion_slot0_22_8_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 9) >> 17);
  return tie_t;
}

static void
Field_fld_fusion_slot0_22_8_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x7fff00) | (tie_t << 8);
}

static unsigned
Field_fld_fusion_slot0_22_20_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 9) >> 29);
  return tie_t;
}

static void
Field_fld_fusion_slot0_22_20_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700000) | (tie_t << 20);
}

static unsigned
Field_fld_fusion_slot0_11_8_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_fusion_slot0_11_8_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_fusion_slot0_22_12_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 9) >> 21);
  return tie_t;
}

static void
Field_fld_fusion_slot0_22_12_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x7ff000) | (tie_t << 12);
}

static unsigned
Field_fld_fusion_slot0_7_4_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_fusion_slot0_7_4_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_fusion_slot0_11_9_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_fld_fusion_slot0_11_9_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_fld_fusion_slot0_22_16_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 9) >> 25);
  return tie_t;
}

static void
Field_fld_fusion_slot0_22_16_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f0000) | (tie_t << 16);
}

static unsigned
Field_fld_fusion_slot0_22_17_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 9) >> 26);
  return tie_t;
}

static void
Field_fld_fusion_slot0_22_17_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x7e0000) | (tie_t << 17);
}

static unsigned
Field_fld_fusion_slot0_3_0_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_fusion_slot0_3_0_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_fusion_slot0_22_0_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 23) | ((insn[0] << 9) >> 9);
  return tie_t;
}

static void
Field_fld_fusion_slot0_22_0_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 9) >> 9;
  insn[0] = (insn[0] & ~0x7fffff) | (tie_t << 0);
}

static unsigned
Field_fld_fusion_slot0_22_10_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 9) >> 19);
  return tie_t;
}

static void
Field_fld_fusion_slot0_22_10_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x7ffc00) | (tie_t << 10);
}

static unsigned
Field_fld_fusion_slot0_8_4_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 23) >> 27);
  return tie_t;
}

static void
Field_fld_fusion_slot0_8_4_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0) | (tie_t << 4);
}

static unsigned
Field_fld_fusion_slot0_22_13_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 9) >> 22);
  return tie_t;
}

static void
Field_fld_fusion_slot0_22_13_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x7fe000) | (tie_t << 13);
}

static unsigned
Field_fld_fusion_slot0_11_4_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_fld_fusion_slot0_11_4_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
}

static unsigned
Field_fld_fusion_slot0_22_14_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 9) >> 23);
  return tie_t;
}

static void
Field_fld_fusion_slot0_22_14_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x7fc000) | (tie_t << 14);
}

static unsigned
Field_fld_fusion_slot0_5_4_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_fusion_slot0_5_4_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_fusion_slot0_7_7_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_fusion_slot0_7_7_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_fusion_slot0_22_6_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 17) | ((insn[0] << 9) >> 15);
  return tie_t;
}

static void
Field_fld_fusion_slot0_22_6_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0x7fffc0) | (tie_t << 6);
}

static unsigned
Field_fld_fusion_slot0_11_6_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 20) >> 26);
  return tie_t;
}

static void
Field_fld_fusion_slot0_11_6_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0xfc0) | (tie_t << 6);
}

static unsigned
Field_fld_fusion_slot0_7_6_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_fusion_slot0_7_6_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_fusion_slot0_11_10_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_fld_fusion_slot0_11_10_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_fld_fusion_slot0_7_5_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_fld_fusion_slot0_7_5_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_fld_fusion_slot0_7_0_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 24) >> 24);
  return tie_t;
}

static void
Field_fld_fusion_slot0_7_0_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff) | (tie_t << 0);
}

static unsigned
Field_fld_fusion_slot0_22_9_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 9) >> 18);
  return tie_t;
}

static void
Field_fld_fusion_slot0_22_9_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0x7ffe00) | (tie_t << 9);
}

static unsigned
Field_fld_fusion_slot40_27_3_Slot_fusion_slot40_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 25) | ((insn[0] << 4) >> 7);
  return tie_t;
}

static void
Field_fld_fusion_slot40_27_3_Slot_fusion_slot40_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0xffffff8) | (tie_t << 3);
}

static unsigned
Field_fld_fusion_slot40_2_0_Slot_fusion_slot40_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_fusion_slot40_2_0_Slot_fusion_slot40_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_fusion_slot40_27_23_Slot_fusion_slot40_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 4) >> 27);
  return tie_t;
}

static void
Field_fld_fusion_slot40_27_23_Slot_fusion_slot40_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf800000) | (tie_t << 23);
}

static unsigned
Field_fld_fusion_slot40_7_4_Slot_fusion_slot40_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_fusion_slot40_7_4_Slot_fusion_slot40_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_fusion_slot40_27_24_Slot_fusion_slot40_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 4) >> 28);
  return tie_t;
}

static void
Field_fld_fusion_slot40_27_24_Slot_fusion_slot40_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000000) | (tie_t << 24);
}

static unsigned
Field_fld_fusion_slot40_27_16_Slot_fusion_slot40_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 4) >> 20);
  return tie_t;
}

static void
Field_fld_fusion_slot40_27_16_Slot_fusion_slot40_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0000) | (tie_t << 16);
}

static unsigned
Field_fld_fusion_slot40_27_12_Slot_fusion_slot40_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 4) >> 16);
  return tie_t;
}

static void
Field_fld_fusion_slot40_27_12_Slot_fusion_slot40_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff000) | (tie_t << 12);
}

static unsigned
Field_fld_fusion_slot_fir_1_18_0_Slot_fusion_slot_fir_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 19) | ((insn[0] << 13) >> 13);
  return tie_t;
}

static void
Field_fld_fusion_slot_fir_1_18_0_Slot_fusion_slot_fir_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 13) >> 13;
  insn[0] = (insn[0] & ~0x7ffff) | (tie_t << 0);
}

static unsigned
Field_fld_fusion_slot_fir_1_18_16_Slot_fusion_slot_fir_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  return tie_t;
}

static void
Field_fld_fusion_slot_fir_1_18_16_Slot_fusion_slot_fir_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static unsigned
Field_fld_fusion_slot_fir_0_14_0_Slot_fusion_slot_fir_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 17) >> 17);
  return tie_t;
}

static void
Field_fld_fusion_slot_fir_0_14_0_Slot_fusion_slot_fir_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x7fff) | (tie_t << 0);
}

static unsigned
Field_fld_fusion_slot_fir_0_14_12_Slot_fusion_slot_fir_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_fld_fusion_slot_fir_0_14_12_Slot_fusion_slot_fir_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_fld_fusion_slot_fir_0_7_7_Slot_fusion_slot_fir_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_fusion_slot_fir_0_7_7_Slot_fusion_slot_fir_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_fusion_slot_fir_0_7_6_Slot_fusion_slot_fir_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_fusion_slot_fir_0_7_6_Slot_fusion_slot_fir_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_fusion_slot40_1_9_0_Slot_fusion_slot40_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 22) >> 22);
  return tie_t;
}

static void
Field_fld_fusion_slot40_1_9_0_Slot_fusion_slot40_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff) | (tie_t << 0);
}

static unsigned
Field_fld_fusion_slot40_1_9_8_Slot_fusion_slot40_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_fusion_slot40_1_9_8_Slot_fusion_slot40_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_fusion_slot40_0_14_0_Slot_fusion_slot40_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 17) >> 17);
  return tie_t;
}

static void
Field_fld_fusion_slot40_0_14_0_Slot_fusion_slot40_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x7fff) | (tie_t << 0);
}

static unsigned
Field_fld_fusion_slot40_0_14_12_Slot_fusion_slot40_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_fld_fusion_slot40_0_14_12_Slot_fusion_slot40_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_fld_fusion_slot40_0_7_7_Slot_fusion_slot40_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_fusion_slot40_0_7_7_Slot_fusion_slot40_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_t_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_t_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_t_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_fusion_slot40_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_fusion_slot40_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_fusion_slot_fir_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_fusion_slot_fir_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_fusion_slot40_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_fusion_slot40_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_bbi4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_bbi4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_bbi_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_bbi_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_bbi_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 23) >> 27);
  return tie_t;
}

static void
Field_bbi_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0) | (tie_t << 4);
}

static unsigned
Field_bbi_Slot_fusion_slot40_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 8) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_bbi_Slot_fusion_slot40_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x800000) | (tie_t << 23);
}

static unsigned
Field_imm12_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 8) >> 20);
  return tie_t;
}

static void
Field_imm12_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff000) | (tie_t << 12);
}

static unsigned
Field_imm12_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 16) >> 20);
  return tie_t;
}

static void
Field_imm12_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0) | (tie_t << 4);
}

static unsigned
Field_imm8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 8) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0000) | (tie_t << 16);
}

static unsigned
Field_imm8_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm8_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 12) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff000) | (tie_t << 12);
}

static unsigned
Field_s_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_s_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_s_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_s_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_s_Slot_fusion_slot40_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_fusion_slot40_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_s_Slot_fusion_slot_fir_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_fusion_slot_fir_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_s_Slot_fusion_slot40_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_fusion_slot40_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_imm12b_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 8) >> 24);
  return tie_t;
}

static void
Field_imm12b_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0000) | (tie_t << 16);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_imm12b_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 16) >> 20);
  return tie_t;
}

static void
Field_imm12b_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0) | (tie_t << 4);
}

static unsigned
Field_imm12b_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm12b_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm16_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 8) >> 16);
  return tie_t;
}

static void
Field_imm16_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff00) | (tie_t << 8);
}

static unsigned
Field_imm16_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 12) >> 20);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm16_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 16) >> 20;
  insn[0] = (insn[0] & ~0xfff00) | (tie_t << 8);
}

static unsigned
Field_offset_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 8) >> 14);
  return tie_t;
}

static void
Field_offset_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xffffc0) | (tie_t << 6);
}

static unsigned
Field_offset_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 14) >> 14);
  return tie_t;
}

static void
Field_offset_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0x3ffff) | (tie_t << 0);
}

static unsigned
Field_op2_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_r_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_r_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_r_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_fusion_slot40_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_r_Slot_fusion_slot40_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_r_Slot_fusion_slot40_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_fusion_slot40_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_disp_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_r_disp_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_r_3_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_r_3_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_sa4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  return tie_t;
}

static void
Field_sa4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_sae4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_sae4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_sae_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_sae_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_sal_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_sargt_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sas4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_sas4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_sas_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sas_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_sas_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sas_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_imm4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_mn_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_mn_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_i_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_i_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_imm6lo_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm6lo_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm6lo_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm6lo_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm6hi_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_imm6hi_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_imm6hi_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_imm6hi_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_imm7lo_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm7lo_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm7lo_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm7lo_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm7hi_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_imm7hi_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_imm7hi_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_imm7hi_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_z_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_z_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_imm6_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm6_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_imm7_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm7_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_rbit2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  return tie_t;
}

static void
Field_rbit2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_tbit2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_tbit2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_y_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_y_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_x_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  return tie_t;
}

static void
Field_x_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_t2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_t2_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_s2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_s2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_r2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_r2_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_t4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_t4_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_s4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_s4_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_r4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_r4_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_t8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_t8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_s8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_s8_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_r8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_r8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_xt_wbr15_imm_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 8) >> 17);
  return tie_t;
}

static void
Field_xt_wbr15_imm_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0xfffe00) | (tie_t << 9);
}

static unsigned
Field_xt_wbr15_imm_Slot_fusion_slot40_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 9) >> 17);
  return tie_t;
}

static void
Field_xt_wbr15_imm_Slot_fusion_slot40_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x7fff00) | (tie_t << 8);
}

static unsigned
Field_xt_wbr18_imm_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 8) >> 14);
  return tie_t;
}

static void
Field_xt_wbr18_imm_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xffffc0) | (tie_t << 6);
}

static unsigned
Field_ae_fld_fhba4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_fhba4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_fhba4_2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_fhba4_2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_tp7_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_tp7_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_tp7_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_tp7_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_osa32_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa32_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_ae_fld_osa32_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_ae_fld_osa32_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_ae_fld_osa64_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa64_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
}

static unsigned
Field_ae_fld_osa64_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 26) >> 26);
  return tie_t;
}

static void
Field_ae_fld_osa64_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f) | (tie_t << 0);
}

static unsigned
Field_ae_fld_imm2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_ae_fld_imm2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_ae_fld_imm2_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_ae_fld_imm2_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_imm2_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_ae_fld_imm2_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_ae_fld_immls64_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls64_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_ae_fld_immls64_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_immls64_Slot_fusion_slot_fir_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls64_Slot_fusion_slot_fir_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64_Slot_fusion_slot40_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls64_Slot_fusion_slot40_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64pos_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64pos_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64pos_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64pos_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64pos_Slot_fusion_slot_fir_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64pos_Slot_fusion_slot_fir_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64pos_Slot_fusion_slot40_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64pos_Slot_fusion_slot40_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls32_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls32_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls32_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls32_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls16_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls16_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls16_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls16_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_osa16_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa16_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_osa16_Slot_fusion_slot40_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa16_Slot_fusion_slot40_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_inst_9_8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_inst_9_8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_ls_uu_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_uu_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ls_uu_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_uu_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ls_uu_Slot_fusion_slot_fir_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_uu_Slot_fusion_slot_fir_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ls_su_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_su_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ls_su_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_su_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ls_av_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_av_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_ls_v1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_ls_v2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_cmpp_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmpp_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_cmpp_v1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmpp_v1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_cmpp_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmpp_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_uu_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_ae_fld_uu_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_ae_fld_uu_uu_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_ae_fld_uu_uu_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_ae_fld_dr_to_ar_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_ar_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_cmov_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmov_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_cmov_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmov_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_pks_d_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_pks_d_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_pks_s_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_pks_s_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_shift_d_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_d_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_shift_d0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_d0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_shift_sd_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_sd_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_ae_fld_dr_to_dr_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_dr_to_dr_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_dr_to_dr_v1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_to_dr_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_to_dr_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_selimm_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_ae_fld_selimm_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_ae_fld_selimm_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_selimm_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ar_to_dr_imm_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ar_to_dr_imm_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ar_to_dr_imm_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ar_to_dr_imm_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ar_to_dr_imm_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ar_to_dr_imm_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_stage3_ar_operand_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_stage3_ar_operand_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_stage3_ar_operand_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_stage3_ar_operand_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_lsip_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_fld_lsip_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_lsip_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_fld_lsip_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_fld_ae_l8x4f_x_x_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_l8x4f_x_x_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_l8x4f_x_a_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_l8x4f_x_a_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_l8x4f_x_v_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_l8x4f_x_v_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_l8x4f_xp_x_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_l8x4f_xp_x_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_l8x4f_xp_a_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_l8x4f_xp_a_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_l8x4f_xp_v_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_l8x4f_xp_v_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_pks_s_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_s_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_pks_d_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_pks_d_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_zerob_v1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_zerob_v1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_zerob_v0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_zerob_v0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_fusion_slot0_8_8_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_fld_fusion_slot0_8_8_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_fusion_slot_fir_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_fusion_slot_fir_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_fusion_slot40_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_fusion_slot40_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_av_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_av_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_av_Slot_fusion_slot_fir_0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_av_Slot_fusion_slot_fir_0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_v1_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v1_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_v1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_v1_Slot_fusion_slot40_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v1_Slot_fusion_slot40_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_cmov_v0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_v0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_cmov_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_cmov_v_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_v_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_cmov_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_ar_to_dr_a0_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_dr_a0_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_ar_to_dr_a0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_dr_a0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_ar_to_dr_v_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_dr_v_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_ar_to_dr_v_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_dr_v_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_ar_to_dr_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_dr_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_ar_to_dr_a1_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_dr_a1_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_ar_to_dr_a1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_dr_a1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_to_dr_v0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_to_dr_v0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_to_dr_v0_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_to_dr_v0_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_to_dr_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_to_dr_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_to_dr_v_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_to_dr_v_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_to_dr_v_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_to_dr_v_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_to_dr_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_to_dr_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_shift_a0_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_a0_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_shift_a0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_a0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_shift_a0_Slot_fusion_slot40_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_a0_Slot_fusion_slot40_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_shift_sd_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_sd_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_shift_sd_Slot_fusion_slot40_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_sd_Slot_fusion_slot40_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_shift_sd_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_sd_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae_sem_shift_d0_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d0_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_shift_d0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_shift_d0_Slot_fusion_slot40_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d0_Slot_fusion_slot40_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_shift_d_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_shift_d_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_shift_d_Slot_fusion_slot40_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d_Slot_fusion_slot40_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_v0_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_v0_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_a_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_a_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_a_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_a_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_arithmetic_v0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_arithmetic_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_arithmetic_v_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_arithmetic_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_cmpp_v1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmpp_v1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_cmpp_v1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmpp_v1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_cmpp_v0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmpp_v0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_cmpp_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmpp_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_cmpp_v_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmpp_v_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_cmpp_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmpp_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_d1_Slot_fusion_slot_fir_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_d1_Slot_fusion_slot_fir_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_d0_Slot_fusion_slot_fir_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_d0_Slot_fusion_slot_fir_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_q1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_q1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_q1_Slot_fusion_slot_fir_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_q1_Slot_fusion_slot_fir_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_d2_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_d2_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_d2_Slot_fusion_slot_fir_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_d2_Slot_fusion_slot_fir_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_v2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_v2_Slot_fusion_slot40_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v2_Slot_fusion_slot40_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_inst_9_8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_inst_9_8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_inst_19_12_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 12) >> 24);
  return tie_t;
}

static void
Field_fld_inst_19_12_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff000) | (tie_t << 12);
}

static unsigned
Field_fld_inst_23_16_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 8) >> 24);
  return tie_t;
}

static void
Field_fld_inst_23_16_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0000) | (tie_t << 16);
}

static unsigned
Field_fld_inst_12_8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_inst_12_8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_fld_inst_11_8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_inst_11_8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_inst_7_0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 24) >> 24);
  return tie_t;
}

static void
Field_fld_inst_7_0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff) | (tie_t << 0);
}

static unsigned
Field_fld_inst_3_0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_inst_3_0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_inst_19_16_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_fld_inst_19_16_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_fld_fusion_slot40_27_18_Slot_fusion_slot40_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 4) >> 22);
  return tie_t;
}

static void
Field_fld_fusion_slot40_27_18_Slot_fusion_slot40_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0xffc0000) | (tie_t << 18);
}

static unsigned
Field_fld_ae_mulfcr32x16ras_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfcr32x16ras_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulfcr32x16ras_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfcr32x16ras_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulfcr32x16ras_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfcr32x16ras_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulfcr32x16ras_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfcr32x16ras_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulfcr32x16ras_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfcr32x16ras_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulfcr32x16ras_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfcr32x16ras_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulafcr32x16ras_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafcr32x16ras_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulafcr32x16ras_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafcr32x16ras_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulafcr32x16ras_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafcr32x16ras_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulafcr32x16ras_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafcr32x16ras_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulafcr32x16ras_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafcr32x16ras_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulafcr32x16ras_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafcr32x16ras_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulfci32x16ras_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfci32x16ras_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulfci32x16ras_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfci32x16ras_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulfci32x16ras_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfci32x16ras_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulfci32x16ras_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfci32x16ras_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulfci32x16ras_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfci32x16ras_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulfci32x16ras_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfci32x16ras_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulafci32x16ras_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafci32x16ras_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulafci32x16ras_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafci32x16ras_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulafci32x16ras_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafci32x16ras_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulafci32x16ras_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafci32x16ras_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulafci32x16ras_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafci32x16ras_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulafci32x16ras_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafci32x16ras_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulp32x2_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulp32x2_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulp32x2_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulp32x2_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulp32x2_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulp32x2_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulap32x2_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulap32x2_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulap32x2_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulap32x2_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulap32x2_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulap32x2_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulsp32x2_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsp32x2_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulsp32x2_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsp32x2_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulsp32x2_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsp32x2_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulp32x2_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulp32x2_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulp32x2_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulp32x2_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulp32x2_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulp32x2_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulap32x2_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulap32x2_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulap32x2_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulap32x2_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulap32x2_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulap32x2_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulsp32x2_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsp32x2_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulsp32x2_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsp32x2_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulsp32x2_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsp32x2_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_d2_0_Slot_fusion_slot_fir_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_d2_0_Slot_fusion_slot_fir_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_d3_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_d3_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulfp32x2rs_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp32x2rs_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulfp32x2rs_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp32x2rs_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulfp32x2rs_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp32x2rs_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulfp32x2ras_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp32x2ras_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulfp32x2ras_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp32x2ras_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulfp32x2ras_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp32x2ras_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulafp32x2rs_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafp32x2rs_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulafp32x2rs_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafp32x2rs_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulafp32x2rs_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafp32x2rs_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulafp32x2ras_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafp32x2ras_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulafp32x2ras_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafp32x2ras_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulafp32x2ras_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafp32x2ras_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulsfp32x2rs_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsfp32x2rs_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulsfp32x2rs_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsfp32x2rs_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulsfp32x2rs_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsfp32x2rs_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulsfp32x2ras_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsfp32x2ras_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulsfp32x2ras_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsfp32x2ras_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulsfp32x2ras_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsfp32x2ras_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulfp32x2rs_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp32x2rs_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulfp32x2rs_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp32x2rs_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulfp32x2rs_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp32x2rs_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulfp32x2ras_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp32x2ras_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulfp32x2ras_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp32x2ras_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulfp32x2ras_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp32x2ras_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulafp32x2rs_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafp32x2rs_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulafp32x2rs_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafp32x2rs_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulafp32x2rs_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafp32x2rs_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulafp32x2ras_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafp32x2ras_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulafp32x2ras_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafp32x2ras_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulafp32x2ras_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafp32x2ras_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulsfp32x2rs_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsfp32x2rs_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulsfp32x2rs_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsfp32x2rs_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulsfp32x2rs_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsfp32x2rs_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulsfp32x2ras_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsfp32x2ras_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulsfp32x2ras_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsfp32x2ras_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulsfp32x2ras_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsfp32x2ras_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulcr24_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulcr24_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulcr24_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulcr24_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulcr24_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulcr24_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulfcr24ra_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfcr24ra_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulfcr24ra_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfcr24ra_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulfcr24ra_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfcr24ra_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulcr32x16_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulcr32x16_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulcr32x16_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulcr32x16_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulcr32x16_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulcr32x16_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulcr32x16_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulcr32x16_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulcr32x16_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulcr32x16_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulcr32x16_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulcr32x16_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulci24_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulci24_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulci24_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulci24_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulci24_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulci24_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulfci24ra_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfci24ra_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulfci24ra_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfci24ra_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulfci24ra_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfci24ra_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulci32x16_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulci32x16_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulci32x16_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulci32x16_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulci32x16_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulci32x16_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulci32x16_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulci32x16_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulci32x16_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulci32x16_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulci32x16_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulci32x16_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulacr24_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulacr24_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulacr24_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulacr24_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulacr24_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulacr24_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulafcr24ra_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafcr24ra_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulafcr24ra_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafcr24ra_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulafcr24ra_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafcr24ra_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulacr32x16_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulacr32x16_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulacr32x16_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulacr32x16_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulacr32x16_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulacr32x16_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulacr32x16_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulacr32x16_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulacr32x16_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulacr32x16_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulacr32x16_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulacr32x16_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulaci24_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulaci24_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulaci24_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulaci24_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulaci24_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulaci24_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulafci24ra_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafci24ra_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulafci24ra_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafci24ra_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulafci24ra_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafci24ra_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulaci32x16_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulaci32x16_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulaci32x16_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulaci32x16_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulaci32x16_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulaci32x16_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulaci32x16_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulaci32x16_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulaci32x16_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulaci32x16_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulaci32x16_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulaci32x16_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulf16x4ss_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulf16x4ss_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulf16x4ss_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulf16x4ss_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulf16x4ss_h_q1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulf16x4ss_h_q1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulaf16x4ss_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulaf16x4ss_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulaf16x4ss_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulaf16x4ss_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulaf16x4ss_h_q1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulaf16x4ss_h_q1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulsf16x4ss_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsf16x4ss_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulsf16x4ss_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsf16x4ss_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulsf16x4ss_h_q1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsf16x4ss_h_q1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulf16x4ss_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulf16x4ss_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulf16x4ss_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulf16x4ss_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulf16x4ss_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulf16x4ss_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulaf16x4ss_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulaf16x4ss_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulaf16x4ss_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulaf16x4ss_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulaf16x4ss_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulaf16x4ss_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulsf16x4ss_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsf16x4ss_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulsf16x4ss_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsf16x4ss_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulsf16x4ss_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulsf16x4ss_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mul16x4_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mul16x4_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mul16x4_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mul16x4_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mul16x4_h_q1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mul16x4_h_q1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mula16x4_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mula16x4_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mula16x4_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mula16x4_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mula16x4_h_q1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mula16x4_h_q1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_muls16x4_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_muls16x4_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_muls16x4_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_muls16x4_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_muls16x4_h_q1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_muls16x4_h_q1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mul16x4_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mul16x4_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mul16x4_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mul16x4_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mul16x4_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mul16x4_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mula16x4_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mula16x4_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mula16x4_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mula16x4_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mula16x4_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mula16x4_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_muls16x4_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_muls16x4_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_muls16x4_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_muls16x4_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_muls16x4_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_muls16x4_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulfp16x4s_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp16x4s_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulfp16x4s_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp16x4s_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulfp16x4s_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp16x4s_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulfp16x4ras_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp16x4ras_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulfp16x4ras_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp16x4ras_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulfp16x4ras_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp16x4ras_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulfp16x4s_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp16x4s_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulfp16x4s_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp16x4s_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulfp16x4s_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp16x4s_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulfp16x4ras_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp16x4ras_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulfp16x4ras_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp16x4ras_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulfp16x4ras_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfp16x4ras_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_fp_sem_sp32cvt_arr_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_fp_sem_sp32cvt_arr_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_fp_sem_sp32cvt_i_imm5_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 15) >> 27);
  return tie_t;
}

static void
Field_fld_fp_sem_sp32cvt_i_imm5_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f000) | (tie_t << 12);
}

static unsigned
Field_fld_fp_sem_sp32cvt_ars_Slot_fusion_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_fp_sem_sp32cvt_ars_Slot_fusion_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_maxabs16s_v1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_maxabs16s_v1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_maxabs16s_v0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_maxabs16s_v0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_maxabs16s_v_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_maxabs16s_v_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_addandsubrng16ras_s1_vs_Slot_fusion_slot40_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_addandsubrng16ras_s1_vs_Slot_fusion_slot40_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_addandsubrng16ras_s1_va_Slot_fusion_slot40_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_addandsubrng16ras_s1_va_Slot_fusion_slot40_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_addandsubrng16ras_s2_vs_Slot_fusion_slot40_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_addandsubrng16ras_s2_vs_Slot_fusion_slot40_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_addandsubrng16ras_s2_va_Slot_fusion_slot40_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_addandsubrng16ras_s2_va_Slot_fusion_slot40_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_arithmetic_va_Slot_fusion_slot40_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_va_Slot_fusion_slot40_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_arithmetic_vs_Slot_fusion_slot40_1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_vs_Slot_fusion_slot40_1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulfc16ras_h_d1_0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfc16ras_h_d1_0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulfc16ras_h_d0_0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfc16ras_h_d0_0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulfc16ras_h_q0_0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfc16ras_h_q0_0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulfc16ras_l_d1_0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfc16ras_l_d1_0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulfc16ras_l_d0_0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfc16ras_l_d0_0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulfc16ras_l_q0_0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfc16ras_l_q0_0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulafc16ras_h_d1_0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafc16ras_h_d1_0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulafc16ras_h_d0_0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafc16ras_h_d0_0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulafc16ras_h_q0_0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafc16ras_h_q0_0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulafc16ras_l_d1_0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafc16ras_l_d1_0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulafc16ras_l_d0_0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafc16ras_l_d0_0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulafc16ras_l_q0_0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafc16ras_l_q0_0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulfc16ras_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfc16ras_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulfc16ras_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfc16ras_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulfc16ras_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfc16ras_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulfc16ras_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfc16ras_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulfc16ras_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfc16ras_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulfc16ras_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulfc16ras_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulafc16ras_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafc16ras_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulafc16ras_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafc16ras_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulafc16ras_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafc16ras_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulafc16ras_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafc16ras_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulafc16ras_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafc16ras_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulafc16ras_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulafc16ras_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulzaaaaq16_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulzaaaaq16_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulzaaaaq16_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulzaaaaq16_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulzaaaaq16_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulzaaaaq16_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulaaaaq16_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulaaaaq16_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulaaaaq16_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulaaaaq16_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulaaaaq16_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulaaaaq16_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulc16s_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulc16s_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulc16s_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulc16s_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulc16s_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulc16s_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulc16s_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulc16s_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulc16s_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulc16s_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulc16s_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulc16s_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulac16s_l_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulac16s_l_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulac16s_l_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulac16s_l_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulac16s_l_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulac16s_l_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_mulac16s_h_d1_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulac16s_h_d1_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_mulac16s_h_d0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulac16s_h_d0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_mulac16s_h_q0_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_mulac16s_h_q0_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_calcrng3_a_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_calcrng3_a_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_movfusionmiscv_v_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_movfusionmiscv_v_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_movstate1_v_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_movstate1_v_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_movstate2_v_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_movstate2_v_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_movvfusionmisc_v_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_movvfusionmisc_v_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_movfcrfsrv_v_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_movfcrfsrv_v_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_movvfcrfsr_v_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_movvfcrfsr_v_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_fp_sem_movfpstate_v_Slot_fusion_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_fp_sem_movfpstate_v_Slot_fusion_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_arth_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_arth_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_arth_v1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ar_to_dr_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ar_to_dr_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_bitindex_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 23) >> 27);
  return tie_t;
}

static void
Field_bitindex_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0) | (tie_t << 4);
}

static void
Implicit_Field_set (xtensa_insnbuf insn ATTRIBUTE_UNUSED,
		    uint32 val ATTRIBUTE_UNUSED)
{
  /* Do nothing.  */
}

static unsigned
Implicit_Field_ar0_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_ar4_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 4;
}

static unsigned
Implicit_Field_ar8_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 8;
}

static unsigned
Implicit_Field_ar12_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 12;
}

static unsigned
Implicit_Field_mr0_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_mr1_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 1;
}

static unsigned
Implicit_Field_mr2_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 2;
}

static unsigned
Implicit_Field_mr3_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 3;
}

static unsigned
Implicit_Field_bt16_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_bs16_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_br16_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_brall_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

enum xtensa_field_id {
  FIELD_t,
  FIELD_bbi4,
  FIELD_bbi,
  FIELD_imm12,
  FIELD_imm8,
  FIELD_s,
  FIELD_imm12b,
  FIELD_imm16,
  FIELD_m,
  FIELD_n,
  FIELD_offset,
  FIELD_op0,
  FIELD_op1,
  FIELD_op2,
  FIELD_r,
  FIELD_r_disp,
  FIELD_r_3,
  FIELD_sa4,
  FIELD_sae4,
  FIELD_sae,
  FIELD_sal,
  FIELD_sargt,
  FIELD_sas4,
  FIELD_sas,
  FIELD_sr,
  FIELD_st,
  FIELD_thi3,
  FIELD_imm4,
  FIELD_mn,
  FIELD_i,
  FIELD_imm6lo,
  FIELD_imm6hi,
  FIELD_imm7lo,
  FIELD_imm7hi,
  FIELD_z,
  FIELD_imm6,
  FIELD_imm7,
  FIELD_r3,
  FIELD_rbit2,
  FIELD_rhi,
  FIELD_t3,
  FIELD_tbit2,
  FIELD_tlo,
  FIELD_w,
  FIELD_y,
  FIELD_x,
  FIELD_t2,
  FIELD_s2,
  FIELD_r2,
  FIELD_t4,
  FIELD_s4,
  FIELD_r4,
  FIELD_t8,
  FIELD_s8,
  FIELD_r8,
  FIELD_xt_wbr15_imm,
  FIELD_xt_wbr18_imm,
  FIELD_ae_fld_fhba4,
  FIELD_ae_fld_fhba4_2,
  FIELD_ae_fld_tp7,
  FIELD_ae_fld_osa32,
  FIELD_ae_fld_osa64,
  FIELD_ae_fld_imm2,
  FIELD_ae_fld_immls64,
  FIELD_ae_fld_immls64pos,
  FIELD_ae_fld_immls32,
  FIELD_ae_fld_immls16,
  FIELD_ae_fld_osa16,
  FIELD_Inst_15_12,
  FIELD_Inst_11_8,
  FIELD_Inst_7_4,
  FIELD_Inst_12,
  FIELD_Inst_7,
  FIELD_Inst_5_4,
  FIELD_Inst_7_6,
  FIELD_Inst_19_17,
  FIELD_Inst_19_18,
  FIELD_Inst_9_8,
  FIELD_Inst_4,
  FIELD_ae_fld_ls_v,
  FIELD_ae_fld_ls_uu,
  FIELD_ae_fld_ls_su,
  FIELD_ae_fld_ls_av,
  FIELD_ae_fld_ls_v1,
  FIELD_ae_fld_ls_v2,
  FIELD_ae_fld_cmpp_v0,
  FIELD_ae_fld_cmpp_v1,
  FIELD_ae_fld_cmpp_v,
  FIELD_ae_fld_uu_v,
  FIELD_ae_fld_uu_uu,
  FIELD_ae_fld_dr_to_ar_v0,
  FIELD_ae_fld_cmov_v,
  FIELD_ae_fld_cmov_v0,
  FIELD_ae_fld_pks_d,
  FIELD_ae_fld_pks_s,
  FIELD_ae_fld_shift_d,
  FIELD_ae_fld_shift_d0,
  FIELD_ae_fld_shift_sd,
  FIELD_ae_fld_dr_to_dr_v,
  FIELD_ae_fld_dr_to_dr_v0,
  FIELD_ae_fld_dr_to_dr_v1,
  FIELD_ae_fld_to_dr_v,
  FIELD_ae_fld_to_dr_v0,
  FIELD_ae_fld_selimm,
  FIELD_fld_ar_to_dr_imm,
  FIELD_fld_stage3_ar_operand,
  FIELD_fld_lsip,
  FIELD_ae_fld_Inst16b_12,
  FIELD_ae_fld_Inst16b_15_13,
  FIELD_fld_AE_L8X4F_X_x,
  FIELD_fld_AE_L8X4F_X_a,
  FIELD_fld_AE_L8X4F_X_v,
  FIELD_fld_AE_L8X4F_XP_x,
  FIELD_fld_AE_L8X4F_XP_a,
  FIELD_fld_AE_L8X4F_XP_v,
  FIELD_fld_ae_sem_pks_s,
  FIELD_fld_ae_sem_pks_d,
  FIELD_fld_AE_ZEROB_v1,
  FIELD_fld_AE_ZEROB_v0,
  FIELD_fld_fusion_slot0_22_6,
  FIELD_fld_fusion_slot0_22_8,
  FIELD_fld_fusion_slot1_20_16,
  FIELD_fld_fusion_slot0_11_8,
  FIELD_fld_fusion_slot0_11_9,
  FIELD_fld_fusion_slot0_7_4,
  FIELD_fld_fusion_slot0_22_16,
  FIELD_fld_fusion_slot0_22_17,
  FIELD_fld_fusion_slot0_22_18,
  FIELD_fld_fusion_slot0_22_4,
  FIELD_fld_fusion_slot0_22_20,
  FIELD_fld_fusion_slot0_22_0,
  FIELD_fld_fusion_slot1_20_0,
  FIELD_fld_fusion_slot1_3_0,
  FIELD_fld_fusion_slot0_22_13,
  FIELD_fld_fusion_slot1_20_13,
  FIELD_fld_fusion_slot0_8_4,
  FIELD_fld_fusion_slot0_22_10,
  FIELD_fld_fusion_slot0_8_8,
  FIELD_fld_fusion_slot0_11_4,
  FIELD_fld_fusion_slot0_22_12,
  FIELD_fld_ae_sem_loads_stores_v,
  FIELD_fld_ae_sem_loads_stores_av,
  FIELD_fld_ae_sem_loads_stores_v1,
  FIELD_fld_fusion_slot1_1_0,
  FIELD_fld_ae_sem_cmov_v0,
  FIELD_fld_ae_sem_cmov_v,
  FIELD_fld_ae_sem_ar_to_dr_a0,
  FIELD_fld_ae_sem_ar_to_dr_v,
  FIELD_fld_ae_sem_ar_to_dr_a1,
  FIELD_fld_ae_sem_to_dr_v0,
  FIELD_fld_ae_sem_to_dr_v,
  FIELD_fld_ae_sem_shift_a0,
  FIELD_fld_ae_sem_shift_sd,
  FIELD_fld_ae_sem_shift_d0,
  FIELD_fld_ae_sem_shift_d,
  FIELD_fld_fusion_slot1_20_8,
  FIELD_fld_ae_sem_dr_to_dr_v0,
  FIELD_fld_ae_sem_dr_to_dr_v,
  FIELD_fld_ae_sem_dr_to_ar_v0,
  FIELD_fld_ae_sem_dr_to_ar_a,
  FIELD_fld_ae_sem_arithmetic_v0,
  FIELD_fld_ae_sem_arithmetic_v1,
  FIELD_fld_ae_sem_arithmetic_v,
  FIELD_fld_fusion_slot1_7_4,
  FIELD_fld_fusion_slot1_9_8,
  FIELD_fld_ae_sem_cmpp_v1,
  FIELD_fld_ae_sem_cmpp_v0,
  FIELD_fld_fusion_slot1_8_8,
  FIELD_fld_ae_sem_cmpp_v,
  FIELD_fld_ae_sem_dr_to_dr_v1,
  FIELD_fld_fusion_slot1_20_12,
  FIELD_fld_ae_sem_mul_x2_S1_d1,
  FIELD_fld_ae_sem_mul_x2_S1_d0,
  FIELD_fld_ae_sem_mul_x2_S1_q0,
  FIELD_fld_ae_sem_mul_x2_S1_q1,
  FIELD_fld_ae_sem_mul_x2_S1_d2,
  FIELD_fld_fusion_slot0_11_10,
  FIELD_fld_fusion_slot1_7_6,
  FIELD_fld_fusion_slot0_5_4,
  FIELD_fld_fusion_slot0_22_14,
  FIELD_fld_fusion_slot0_7_7,
  FIELD_fld_fusion_slot0_11_6,
  FIELD_fld_fusion_slot1_0_0,
  FIELD_fld_fusion_slot0_3_0,
  FIELD_fld_fusion_slot0_7_0,
  FIELD_fld_fusion_slot0_7_5,
  FIELD_fld_fusion_slot0_7_6,
  FIELD_fld_fusion_slot0_22_9,
  FIELD_fld_ae_sem_loads_stores_v2,
  FIELD_fld_Inst_9_8,
  FIELD_fld_Inst_19_12,
  FIELD_fld_Inst_23_16,
  FIELD_fld_Inst_12_8,
  FIELD_fld_Inst_11_8,
  FIELD_fld_Inst_7_0,
  FIELD_fld_Inst_3_0,
  FIELD_fld_Inst_19_16,
  FIELD_fld_fusion_slot40_27_12,
  FIELD_fld_fusion_slot40_27_18,
  FIELD_fld_fusion_slot40_7_4,
  FIELD_fld_fusion_slot40_27_24,
  FIELD_fld_fusion_slot40_27_23,
  FIELD_fld_fusion_slot40_2_0,
  FIELD_fld_fusion_slot40_27_3,
  FIELD_fld_fusion_slot40_27_16,
  FIELD_fld_AE_MULFCR32X16RAS_L_d1,
  FIELD_fld_AE_MULFCR32X16RAS_L_d0,
  FIELD_fld_AE_MULFCR32X16RAS_L_q0,
  FIELD_fld_AE_MULFCR32X16RAS_H_d1,
  FIELD_fld_AE_MULFCR32X16RAS_H_d0,
  FIELD_fld_AE_MULFCR32X16RAS_H_q0,
  FIELD_fld_AE_MULAFCR32X16RAS_L_d1,
  FIELD_fld_AE_MULAFCR32X16RAS_L_d0,
  FIELD_fld_AE_MULAFCR32X16RAS_L_q0,
  FIELD_fld_AE_MULAFCR32X16RAS_H_d1,
  FIELD_fld_AE_MULAFCR32X16RAS_H_d0,
  FIELD_fld_AE_MULAFCR32X16RAS_H_q0,
  FIELD_fld_AE_MULFCI32X16RAS_L_d1,
  FIELD_fld_AE_MULFCI32X16RAS_L_d0,
  FIELD_fld_AE_MULFCI32X16RAS_L_q0,
  FIELD_fld_AE_MULFCI32X16RAS_H_d1,
  FIELD_fld_AE_MULFCI32X16RAS_H_d0,
  FIELD_fld_AE_MULFCI32X16RAS_H_q0,
  FIELD_fld_AE_MULAFCI32X16RAS_L_d1,
  FIELD_fld_AE_MULAFCI32X16RAS_L_d0,
  FIELD_fld_AE_MULAFCI32X16RAS_L_q0,
  FIELD_fld_AE_MULAFCI32X16RAS_H_d1,
  FIELD_fld_AE_MULAFCI32X16RAS_H_d0,
  FIELD_fld_AE_MULAFCI32X16RAS_H_q0,
  FIELD_fld_AE_MULP32X2_H_d1,
  FIELD_fld_AE_MULP32X2_H_d0,
  FIELD_fld_AE_MULP32X2_H_q0,
  FIELD_fld_AE_MULAP32X2_H_d1,
  FIELD_fld_AE_MULAP32X2_H_d0,
  FIELD_fld_AE_MULAP32X2_H_q0,
  FIELD_fld_AE_MULSP32X2_H_d1,
  FIELD_fld_AE_MULSP32X2_H_d0,
  FIELD_fld_AE_MULSP32X2_H_q0,
  FIELD_fld_AE_MULP32X2_L_d1,
  FIELD_fld_AE_MULP32X2_L_d0,
  FIELD_fld_AE_MULP32X2_L_q0,
  FIELD_fld_AE_MULAP32X2_L_d1,
  FIELD_fld_AE_MULAP32X2_L_d0,
  FIELD_fld_AE_MULAP32X2_L_q0,
  FIELD_fld_AE_MULSP32X2_L_d1,
  FIELD_fld_AE_MULSP32X2_L_d0,
  FIELD_fld_AE_MULSP32X2_L_q0,
  FIELD_fld_ae_sem_mul_x2_S1_d2_0,
  FIELD_fld_ae_sem_mul_x2_S1_d3,
  FIELD_fld_fusion_slot_fir_0_14_0,
  FIELD_fld_fusion_slot_fir_1_18_0,
  FIELD_fld_fusion_slot_fir_1_18_16,
  FIELD_fld_fusion_slot_fir_0_14_12,
  FIELD_fld_fusion_slot_fir_0_7_7,
  FIELD_fld_fusion_slot_fir_0_7_6,
  FIELD_fld_AE_MULFP32X2RS_H_d1,
  FIELD_fld_AE_MULFP32X2RS_H_d0,
  FIELD_fld_AE_MULFP32X2RS_H_q0,
  FIELD_fld_AE_MULFP32X2RAS_H_d1,
  FIELD_fld_AE_MULFP32X2RAS_H_d0,
  FIELD_fld_AE_MULFP32X2RAS_H_q0,
  FIELD_fld_AE_MULAFP32X2RS_H_d1,
  FIELD_fld_AE_MULAFP32X2RS_H_d0,
  FIELD_fld_AE_MULAFP32X2RS_H_q0,
  FIELD_fld_AE_MULAFP32X2RAS_H_d1,
  FIELD_fld_AE_MULAFP32X2RAS_H_d0,
  FIELD_fld_AE_MULAFP32X2RAS_H_q0,
  FIELD_fld_AE_MULSFP32X2RS_H_d1,
  FIELD_fld_AE_MULSFP32X2RS_H_d0,
  FIELD_fld_AE_MULSFP32X2RS_H_q0,
  FIELD_fld_AE_MULSFP32X2RAS_H_d1,
  FIELD_fld_AE_MULSFP32X2RAS_H_d0,
  FIELD_fld_AE_MULSFP32X2RAS_H_q0,
  FIELD_fld_AE_MULFP32X2RS_L_d1,
  FIELD_fld_AE_MULFP32X2RS_L_d0,
  FIELD_fld_AE_MULFP32X2RS_L_q0,
  FIELD_fld_AE_MULFP32X2RAS_L_d1,
  FIELD_fld_AE_MULFP32X2RAS_L_d0,
  FIELD_fld_AE_MULFP32X2RAS_L_q0,
  FIELD_fld_AE_MULAFP32X2RS_L_d1,
  FIELD_fld_AE_MULAFP32X2RS_L_d0,
  FIELD_fld_AE_MULAFP32X2RS_L_q0,
  FIELD_fld_AE_MULAFP32X2RAS_L_d1,
  FIELD_fld_AE_MULAFP32X2RAS_L_d0,
  FIELD_fld_AE_MULAFP32X2RAS_L_q0,
  FIELD_fld_AE_MULSFP32X2RS_L_d1,
  FIELD_fld_AE_MULSFP32X2RS_L_d0,
  FIELD_fld_AE_MULSFP32X2RS_L_q0,
  FIELD_fld_AE_MULSFP32X2RAS_L_d1,
  FIELD_fld_AE_MULSFP32X2RAS_L_d0,
  FIELD_fld_AE_MULSFP32X2RAS_L_q0,
  FIELD_fld_AE_MULCR24_d1,
  FIELD_fld_AE_MULCR24_d0,
  FIELD_fld_AE_MULCR24_q0,
  FIELD_fld_AE_MULFCR24RA_d1,
  FIELD_fld_AE_MULFCR24RA_d0,
  FIELD_fld_AE_MULFCR24RA_q0,
  FIELD_fld_AE_MULCR32X16_L_d1,
  FIELD_fld_AE_MULCR32X16_L_d0,
  FIELD_fld_AE_MULCR32X16_L_q0,
  FIELD_fld_AE_MULCR32X16_H_d1,
  FIELD_fld_AE_MULCR32X16_H_d0,
  FIELD_fld_AE_MULCR32X16_H_q0,
  FIELD_fld_AE_MULCI24_d1,
  FIELD_fld_AE_MULCI24_d0,
  FIELD_fld_AE_MULCI24_q0,
  FIELD_fld_AE_MULFCI24RA_d1,
  FIELD_fld_AE_MULFCI24RA_d0,
  FIELD_fld_AE_MULFCI24RA_q0,
  FIELD_fld_AE_MULCI32X16_L_d1,
  FIELD_fld_AE_MULCI32X16_L_d0,
  FIELD_fld_AE_MULCI32X16_L_q0,
  FIELD_fld_AE_MULCI32X16_H_d1,
  FIELD_fld_AE_MULCI32X16_H_d0,
  FIELD_fld_AE_MULCI32X16_H_q0,
  FIELD_fld_AE_MULACR24_d1,
  FIELD_fld_AE_MULACR24_d0,
  FIELD_fld_AE_MULACR24_q0,
  FIELD_fld_AE_MULAFCR24RA_d1,
  FIELD_fld_AE_MULAFCR24RA_d0,
  FIELD_fld_AE_MULAFCR24RA_q0,
  FIELD_fld_AE_MULACR32X16_L_d1,
  FIELD_fld_AE_MULACR32X16_L_d0,
  FIELD_fld_AE_MULACR32X16_L_q0,
  FIELD_fld_AE_MULACR32X16_H_d1,
  FIELD_fld_AE_MULACR32X16_H_d0,
  FIELD_fld_AE_MULACR32X16_H_q0,
  FIELD_fld_AE_MULACI24_d1,
  FIELD_fld_AE_MULACI24_d0,
  FIELD_fld_AE_MULACI24_q0,
  FIELD_fld_AE_MULAFCI24RA_d1,
  FIELD_fld_AE_MULAFCI24RA_d0,
  FIELD_fld_AE_MULAFCI24RA_q0,
  FIELD_fld_AE_MULACI32X16_L_d1,
  FIELD_fld_AE_MULACI32X16_L_d0,
  FIELD_fld_AE_MULACI32X16_L_q0,
  FIELD_fld_AE_MULACI32X16_H_d1,
  FIELD_fld_AE_MULACI32X16_H_d0,
  FIELD_fld_AE_MULACI32X16_H_q0,
  FIELD_fld_AE_MULF16X4SS_H_d0,
  FIELD_fld_AE_MULF16X4SS_H_d1,
  FIELD_fld_AE_MULF16X4SS_H_q1,
  FIELD_fld_AE_MULAF16X4SS_H_d0,
  FIELD_fld_AE_MULAF16X4SS_H_d1,
  FIELD_fld_AE_MULAF16X4SS_H_q1,
  FIELD_fld_AE_MULSF16X4SS_H_d0,
  FIELD_fld_AE_MULSF16X4SS_H_d1,
  FIELD_fld_AE_MULSF16X4SS_H_q1,
  FIELD_fld_AE_MULF16X4SS_L_d0,
  FIELD_fld_AE_MULF16X4SS_L_d1,
  FIELD_fld_AE_MULF16X4SS_L_q0,
  FIELD_fld_AE_MULAF16X4SS_L_d0,
  FIELD_fld_AE_MULAF16X4SS_L_d1,
  FIELD_fld_AE_MULAF16X4SS_L_q0,
  FIELD_fld_AE_MULSF16X4SS_L_d0,
  FIELD_fld_AE_MULSF16X4SS_L_d1,
  FIELD_fld_AE_MULSF16X4SS_L_q0,
  FIELD_fld_AE_MUL16X4_H_d0,
  FIELD_fld_AE_MUL16X4_H_d1,
  FIELD_fld_AE_MUL16X4_H_q1,
  FIELD_fld_AE_MULA16X4_H_d0,
  FIELD_fld_AE_MULA16X4_H_d1,
  FIELD_fld_AE_MULA16X4_H_q1,
  FIELD_fld_AE_MULS16X4_H_d0,
  FIELD_fld_AE_MULS16X4_H_d1,
  FIELD_fld_AE_MULS16X4_H_q1,
  FIELD_fld_AE_MUL16X4_L_d0,
  FIELD_fld_AE_MUL16X4_L_d1,
  FIELD_fld_AE_MUL16X4_L_q0,
  FIELD_fld_AE_MULA16X4_L_d0,
  FIELD_fld_AE_MULA16X4_L_d1,
  FIELD_fld_AE_MULA16X4_L_q0,
  FIELD_fld_AE_MULS16X4_L_d0,
  FIELD_fld_AE_MULS16X4_L_d1,
  FIELD_fld_AE_MULS16X4_L_q0,
  FIELD_fld_AE_MULFP16X4S_H_d1,
  FIELD_fld_AE_MULFP16X4S_H_d0,
  FIELD_fld_AE_MULFP16X4S_H_q0,
  FIELD_fld_AE_MULFP16X4RAS_H_d1,
  FIELD_fld_AE_MULFP16X4RAS_H_d0,
  FIELD_fld_AE_MULFP16X4RAS_H_q0,
  FIELD_fld_AE_MULFP16X4S_L_d1,
  FIELD_fld_AE_MULFP16X4S_L_d0,
  FIELD_fld_AE_MULFP16X4S_L_q0,
  FIELD_fld_AE_MULFP16X4RAS_L_d1,
  FIELD_fld_AE_MULFP16X4RAS_L_d0,
  FIELD_fld_AE_MULFP16X4RAS_L_q0,
  FIELD_fld_fp_sem_sp32cvt_arr,
  FIELD_fld_fp_sem_sp32cvt_i_imm5,
  FIELD_fld_fp_sem_sp32cvt_ars,
  FIELD_fld_AE_MAXABS16S_v1,
  FIELD_fld_AE_MAXABS16S_v0,
  FIELD_fld_AE_MAXABS16S_v,
  FIELD_fld_fusion_slot40_0_14_0,
  FIELD_fld_fusion_slot40_0_7_7,
  FIELD_fld_fusion_slot40_0_14_12,
  FIELD_fld_fusion_slot40_1_9_0,
  FIELD_fld_fusion_slot40_1_9_8,
  FIELD_fld_AE_ADDANDSUBRNG16RAS_S1_vs,
  FIELD_fld_AE_ADDANDSUBRNG16RAS_S1_va,
  FIELD_fld_AE_ADDANDSUBRNG16RAS_S2_vs,
  FIELD_fld_AE_ADDANDSUBRNG16RAS_S2_va,
  FIELD_fld_ae_sem_arithmetic_va,
  FIELD_fld_ae_sem_arithmetic_vs,
  FIELD_fld_AE_MULFC16RAS_H_d1_0,
  FIELD_fld_AE_MULFC16RAS_H_d0_0,
  FIELD_fld_AE_MULFC16RAS_H_q0_0,
  FIELD_fld_AE_MULFC16RAS_L_d1_0,
  FIELD_fld_AE_MULFC16RAS_L_d0_0,
  FIELD_fld_AE_MULFC16RAS_L_q0_0,
  FIELD_fld_AE_MULAFC16RAS_H_d1_0,
  FIELD_fld_AE_MULAFC16RAS_H_d0_0,
  FIELD_fld_AE_MULAFC16RAS_H_q0_0,
  FIELD_fld_AE_MULAFC16RAS_L_d1_0,
  FIELD_fld_AE_MULAFC16RAS_L_d0_0,
  FIELD_fld_AE_MULAFC16RAS_L_q0_0,
  FIELD_fld_AE_MULFC16RAS_H_d1,
  FIELD_fld_AE_MULFC16RAS_H_d0,
  FIELD_fld_AE_MULFC16RAS_H_q0,
  FIELD_fld_AE_MULFC16RAS_L_d1,
  FIELD_fld_AE_MULFC16RAS_L_d0,
  FIELD_fld_AE_MULFC16RAS_L_q0,
  FIELD_fld_AE_MULAFC16RAS_H_d1,
  FIELD_fld_AE_MULAFC16RAS_H_d0,
  FIELD_fld_AE_MULAFC16RAS_H_q0,
  FIELD_fld_AE_MULAFC16RAS_L_d1,
  FIELD_fld_AE_MULAFC16RAS_L_d0,
  FIELD_fld_AE_MULAFC16RAS_L_q0,
  FIELD_fld_AE_MULZAAAAQ16_d1,
  FIELD_fld_AE_MULZAAAAQ16_d0,
  FIELD_fld_AE_MULZAAAAQ16_q0,
  FIELD_fld_AE_MULAAAAQ16_d1,
  FIELD_fld_AE_MULAAAAQ16_d0,
  FIELD_fld_AE_MULAAAAQ16_q0,
  FIELD_fld_AE_MULC16S_L_d1,
  FIELD_fld_AE_MULC16S_L_d0,
  FIELD_fld_AE_MULC16S_L_q0,
  FIELD_fld_AE_MULC16S_H_d1,
  FIELD_fld_AE_MULC16S_H_d0,
  FIELD_fld_AE_MULC16S_H_q0,
  FIELD_fld_AE_MULAC16S_L_d1,
  FIELD_fld_AE_MULAC16S_L_d0,
  FIELD_fld_AE_MULAC16S_L_q0,
  FIELD_fld_AE_MULAC16S_H_d1,
  FIELD_fld_AE_MULAC16S_H_d0,
  FIELD_fld_AE_MULAC16S_H_q0,
  FIELD_fld_AE_CALCRNG3_a,
  FIELD_fld_fusion_slot1_20_4,
  FIELD_fld_AE_MOVFUSIONMISCV_v,
  FIELD_fld_ae_sem_movstate1_v,
  FIELD_fld_ae_sem_movstate2_v,
  FIELD_fld_AE_MOVVFUSIONMISC_v,
  FIELD_fld_AE_MOVFCRFSRV_v,
  FIELD_fld_AE_MOVVFCRFSR_v,
  FIELD_fld_fp_sem_movfpstate_v,
  FIELD_ae_fld_arth_v,
  FIELD_ae_fld_arth_v0,
  FIELD_ae_fld_arth_v1,
  FIELD_ae_fld_ar_to_dr_v,
  FIELD_bitindex,
  FIELD_s3to1,
  FIELD__ar0,
  FIELD__ar4,
  FIELD__ar8,
  FIELD__ar12,
  FIELD__mr0,
  FIELD__mr1,
  FIELD__mr2,
  FIELD__mr3,
  FIELD__bt16,
  FIELD__bs16,
  FIELD__br16,
  FIELD__brall
};


/* Functional units.  */

static xtensa_funcUnit_internal funcUnits[] = {
  {"XT_LOADSTORE_UNIT", 1},
  { "ae_mul_S2_function", 1 },
  { "ae_add32x27", 1 },
  { "ae_shift32x4", 1 },
  { "ae_shift32x5", 1 },
  { "ae_leftshift32x5", 1 }
};

enum xtensa_funcUnit_id {
  FUNCUNIT_XT_LOADSTORE_UNIT,
  FUNCUNIT_ae_mul_S2_function,
  FUNCUNIT_ae_add32x27,
  FUNCUNIT_ae_shift32x4,
  FUNCUNIT_ae_shift32x5,
  FUNCUNIT_ae_leftshift32x5
};


/* Register files.  */

enum xtensa_regfile_id {
  REGFILE_AR,
  REGFILE_MR,
  REGFILE_BR,
  REGFILE_AE_DR,
  REGFILE_AE_VALIGN,
  REGFILE_BR2,
  REGFILE_BR4,
  REGFILE_BR8,
  REGFILE_BR16
};

static xtensa_regfile_internal regfiles[] = {
  { "AR", "a", REGFILE_AR, 32, 32 },
  { "MR", "m", REGFILE_MR, 32, 4 },
  { "BR", "b", REGFILE_BR, 1, 16 },
  { "AE_DR", "aed", REGFILE_AE_DR, 64, 12 },
  { "AE_VALIGN", "u", REGFILE_AE_VALIGN, 64, 4 },
  { "BR2", "b", REGFILE_BR, 2, 8 },
  { "BR4", "b", REGFILE_BR, 4, 4 },
  { "BR8", "b", REGFILE_BR, 8, 2 },
  { "BR16", "b", REGFILE_BR, 16, 1 }
};


/* Interfaces.  */

static xtensa_interface_internal interfaces[] = {
  { "ERI_RD_Out", 14, 0, 0, 'o' },
  { "ERI_RD_In", 32, 0, 1, 'i' },
  { "ERI_RD_Rdy", 1, 0, 0, 'i' },
  { "ERI_WR_Out", 46, 0, 2, 'o' },
  { "ERI_WR_In", 1, 0, 3, 'i' },
  { "IMPWIRE", 32, 0, 4, 'i' }
};

enum xtensa_interface_id {
  INTERFACE_ERI_RD_Out,
  INTERFACE_ERI_RD_In,
  INTERFACE_ERI_RD_Rdy,
  INTERFACE_ERI_WR_Out,
  INTERFACE_ERI_WR_In,
  INTERFACE_IMPWIRE
};


/* Constant tables.  */

/* constant table ai4c */
static const unsigned CONST_TBL_ai4c_0[] = {
  0xffffffff,
  0x1,
  0x2,
  0x3,
  0x4,
  0x5,
  0x6,
  0x7,
  0x8,
  0x9,
  0xa,
  0xb,
  0xc,
  0xd,
  0xe,
  0xf,
  0
};

/* constant table b4c */
static const unsigned CONST_TBL_b4c_0[] = {
  0xffffffff,
  0x1,
  0x2,
  0x3,
  0x4,
  0x5,
  0x6,
  0x7,
  0x8,
  0xa,
  0xc,
  0x10,
  0x20,
  0x40,
  0x80,
  0x100,
  0
};

/* constant table b4cu */
static const unsigned CONST_TBL_b4cu_0[] = {
  0x8000,
  0x10000,
  0x2,
  0x3,
  0x4,
  0x5,
  0x6,
  0x7,
  0x8,
  0xa,
  0xc,
  0x10,
  0x20,
  0x40,
  0x80,
  0x100,
  0
};

/* constant table bitmask8 */
static const unsigned CONST_TBL_bitmask8_0[] = {
  0 & 0xff,
  0x1 & 0xff,
  0x3 & 0xff,
  0x7 & 0xff,
  0xf & 0xff,
  0x1f & 0xff,
  0x3f & 0xff,
  0x7f & 0xff,
  0
};

/* constant table ae_seliencode */
static const unsigned CONST_TBL_ae_seliencode_0[] = {
  0x4e5 & 0xfff,
  0x65 & 0xfff,
  0x77 & 0xfff,
  0x4f7 & 0xfff,
  0x72e & 0xfff,
  0x29c & 0xfff,
  0xaf & 0xfff,
  0xa6 & 0xfff,
  0x2ef & 0xfff,
  0x10d & 0xfff,
  0x599 & 0xfff,
  0x59f & 0xfff,
  0xb3e & 0xfff,
  0x18f & 0xfff,
  0x51d & 0xfff,
  0x116 & 0xfff,
  0
};

/* constant table ae_updating_store_table8 */
static const unsigned CONST_TBL_ae_updating_store_table8_0[] = {
  0x1 & 0x7,
  0x2 & 0x7,
  0
};

/* constant table ae_updating_store_table16 */
static const unsigned CONST_TBL_ae_updating_store_table16_0[] = {
  0x2 & 0x7,
  0x4 & 0x7,
  0
};

/* constant table ae_updating_store_table32 */
static const unsigned CONST_TBL_ae_updating_store_table32_0[] = {
  0x4 & 0xf,
  0x8 & 0xf,
  0
};

/* constant table RECIP_Data8 */
static const unsigned CONST_TBL_RECIP_Data8_0[] = {
  0xff & 0xff,
  0xfd & 0xff,
  0xfb & 0xff,
  0xf9 & 0xff,
  0xf7 & 0xff,
  0xf5 & 0xff,
  0xf4 & 0xff,
  0xf2 & 0xff,
  0xf0 & 0xff,
  0xee & 0xff,
  0xed & 0xff,
  0xeb & 0xff,
  0xe9 & 0xff,
  0xe8 & 0xff,
  0xe6 & 0xff,
  0xe4 & 0xff,
  0xe3 & 0xff,
  0xe1 & 0xff,
  0xe0 & 0xff,
  0xde & 0xff,
  0xdd & 0xff,
  0xdb & 0xff,
  0xda & 0xff,
  0xd8 & 0xff,
  0xd7 & 0xff,
  0xd5 & 0xff,
  0xd4 & 0xff,
  0xd3 & 0xff,
  0xd1 & 0xff,
  0xd0 & 0xff,
  0xcf & 0xff,
  0xcd & 0xff,
  0xcc & 0xff,
  0xcb & 0xff,
  0xca & 0xff,
  0xc8 & 0xff,
  0xc7 & 0xff,
  0xc6 & 0xff,
  0xc5 & 0xff,
  0xc4 & 0xff,
  0xc2 & 0xff,
  0xc1 & 0xff,
  0xc0 & 0xff,
  0xbf & 0xff,
  0xbe & 0xff,
  0xbd & 0xff,
  0xbc & 0xff,
  0xbb & 0xff,
  0xba & 0xff,
  0xb9 & 0xff,
  0xb8 & 0xff,
  0xb7 & 0xff,
  0xb6 & 0xff,
  0xb5 & 0xff,
  0xb4 & 0xff,
  0xb3 & 0xff,
  0xb2 & 0xff,
  0xb1 & 0xff,
  0xb0 & 0xff,
  0xaf & 0xff,
  0xae & 0xff,
  0xad & 0xff,
  0xac & 0xff,
  0xab & 0xff,
  0xaa & 0xff,
  0xa9 & 0xff,
  0xa8 & 0xff,
  0xa8 & 0xff,
  0xa7 & 0xff,
  0xa6 & 0xff,
  0xa5 & 0xff,
  0xa4 & 0xff,
  0xa3 & 0xff,
  0xa3 & 0xff,
  0xa2 & 0xff,
  0xa1 & 0xff,
  0xa0 & 0xff,
  0x9f & 0xff,
  0x9f & 0xff,
  0x9e & 0xff,
  0x9d & 0xff,
  0x9c & 0xff,
  0x9c & 0xff,
  0x9b & 0xff,
  0x9a & 0xff,
  0x99 & 0xff,
  0x99 & 0xff,
  0x98 & 0xff,
  0x97 & 0xff,
  0x97 & 0xff,
  0x96 & 0xff,
  0x95 & 0xff,
  0x95 & 0xff,
  0x94 & 0xff,
  0x93 & 0xff,
  0x93 & 0xff,
  0x92 & 0xff,
  0x91 & 0xff,
  0x91 & 0xff,
  0x90 & 0xff,
  0x8f & 0xff,
  0x8f & 0xff,
  0x8e & 0xff,
  0x8e & 0xff,
  0x8d & 0xff,
  0x8c & 0xff,
  0x8c & 0xff,
  0x8b & 0xff,
  0x8b & 0xff,
  0x8a & 0xff,
  0x89 & 0xff,
  0x89 & 0xff,
  0x88 & 0xff,
  0x88 & 0xff,
  0x87 & 0xff,
  0x87 & 0xff,
  0x86 & 0xff,
  0x85 & 0xff,
  0x85 & 0xff,
  0x84 & 0xff,
  0x84 & 0xff,
  0x83 & 0xff,
  0x83 & 0xff,
  0x82 & 0xff,
  0x82 & 0xff,
  0x81 & 0xff,
  0x81 & 0xff,
  0x81 & 0xff,
  0
};

/* constant table RSQRT_Data8 */
static const unsigned CONST_TBL_RSQRT_Data8_0[] = {
  0xb4 & 0xff,
  0xb3 & 0xff,
  0xb2 & 0xff,
  0xb0 & 0xff,
  0xaf & 0xff,
  0xae & 0xff,
  0xac & 0xff,
  0xab & 0xff,
  0xaa & 0xff,
  0xa9 & 0xff,
  0xa8 & 0xff,
  0xa7 & 0xff,
  0xa6 & 0xff,
  0xa5 & 0xff,
  0xa3 & 0xff,
  0xa2 & 0xff,
  0xa1 & 0xff,
  0xa0 & 0xff,
  0x9f & 0xff,
  0x9e & 0xff,
  0x9e & 0xff,
  0x9d & 0xff,
  0x9c & 0xff,
  0x9b & 0xff,
  0x9a & 0xff,
  0x99 & 0xff,
  0x98 & 0xff,
  0x97 & 0xff,
  0x97 & 0xff,
  0x96 & 0xff,
  0x95 & 0xff,
  0x94 & 0xff,
  0x93 & 0xff,
  0x93 & 0xff,
  0x92 & 0xff,
  0x91 & 0xff,
  0x90 & 0xff,
  0x90 & 0xff,
  0x8f & 0xff,
  0x8e & 0xff,
  0x8e & 0xff,
  0x8d & 0xff,
  0x8c & 0xff,
  0x8c & 0xff,
  0x8b & 0xff,
  0x8a & 0xff,
  0x8a & 0xff,
  0x89 & 0xff,
  0x89 & 0xff,
  0x88 & 0xff,
  0x87 & 0xff,
  0x87 & 0xff,
  0x86 & 0xff,
  0x86 & 0xff,
  0x85 & 0xff,
  0x84 & 0xff,
  0x84 & 0xff,
  0x83 & 0xff,
  0x83 & 0xff,
  0x82 & 0xff,
  0x82 & 0xff,
  0x81 & 0xff,
  0x81 & 0xff,
  0x80 & 0xff,
  0xff & 0xff,
  0xfd & 0xff,
  0xfb & 0xff,
  0xf9 & 0xff,
  0xf7 & 0xff,
  0xf6 & 0xff,
  0xf4 & 0xff,
  0xf2 & 0xff,
  0xf1 & 0xff,
  0xef & 0xff,
  0xed & 0xff,
  0xec & 0xff,
  0xea & 0xff,
  0xe9 & 0xff,
  0xe7 & 0xff,
  0xe6 & 0xff,
  0xe4 & 0xff,
  0xe3 & 0xff,
  0xe1 & 0xff,
  0xe0 & 0xff,
  0xdf & 0xff,
  0xdd & 0xff,
  0xdc & 0xff,
  0xdb & 0xff,
  0xda & 0xff,
  0xd8 & 0xff,
  0xd7 & 0xff,
  0xd6 & 0xff,
  0xd5 & 0xff,
  0xd4 & 0xff,
  0xd3 & 0xff,
  0xd2 & 0xff,
  0xd0 & 0xff,
  0xcf & 0xff,
  0xce & 0xff,
  0xcd & 0xff,
  0xcc & 0xff,
  0xcb & 0xff,
  0xca & 0xff,
  0xc9 & 0xff,
  0xc8 & 0xff,
  0xc7 & 0xff,
  0xc6 & 0xff,
  0xc6 & 0xff,
  0xc5 & 0xff,
  0xc4 & 0xff,
  0xc3 & 0xff,
  0xc2 & 0xff,
  0xc1 & 0xff,
  0xc0 & 0xff,
  0xbf & 0xff,
  0xbf & 0xff,
  0xbe & 0xff,
  0xbd & 0xff,
  0xbc & 0xff,
  0xbb & 0xff,
  0xbb & 0xff,
  0xba & 0xff,
  0xb9 & 0xff,
  0xb8 & 0xff,
  0xb8 & 0xff,
  0xb7 & 0xff,
  0xb6 & 0xff,
  0xb5 & 0xff,
  0
};

/* constant table RECIP_Data10_2 */
static const unsigned CONST_TBL_RECIP_Data10_2_0[] = {
  0x3fc & 0x3ff,
  0x3f4 & 0x3ff,
  0x3ec & 0x3ff,
  0x3e5 & 0x3ff,
  0x3dd & 0x3ff,
  0x3d6 & 0x3ff,
  0x3cf & 0x3ff,
  0x3c7 & 0x3ff,
  0x3c0 & 0x3ff,
  0x3b9 & 0x3ff,
  0x3b2 & 0x3ff,
  0x3ac & 0x3ff,
  0x3a5 & 0x3ff,
  0x39e & 0x3ff,
  0x398 & 0x3ff,
  0x391 & 0x3ff,
  0x38b & 0x3ff,
  0x385 & 0x3ff,
  0x37f & 0x3ff,
  0x378 & 0x3ff,
  0x373 & 0x3ff,
  0x36c & 0x3ff,
  0x367 & 0x3ff,
  0x361 & 0x3ff,
  0x35c & 0x3ff,
  0x356 & 0x3ff,
  0x350 & 0x3ff,
  0x34b & 0x3ff,
  0x345 & 0x3ff,
  0x340 & 0x3ff,
  0x33b & 0x3ff,
  0x335 & 0x3ff,
  0x330 & 0x3ff,
  0x32c & 0x3ff,
  0x327 & 0x3ff,
  0x322 & 0x3ff,
  0x31c & 0x3ff,
  0x318 & 0x3ff,
  0x314 & 0x3ff,
  0x30e & 0x3ff,
  0x30a & 0x3ff,
  0x306 & 0x3ff,
  0x300 & 0x3ff,
  0x2fc & 0x3ff,
  0x2f8 & 0x3ff,
  0x2f4 & 0x3ff,
  0x2f0 & 0x3ff,
  0x2ea & 0x3ff,
  0x2e6 & 0x3ff,
  0x2e2 & 0x3ff,
  0x2de & 0x3ff,
  0x2da & 0x3ff,
  0x2d6 & 0x3ff,
  0x2d2 & 0x3ff,
  0x2ce & 0x3ff,
  0x2ca & 0x3ff,
  0x2c6 & 0x3ff,
  0x2c2 & 0x3ff,
  0x2be & 0x3ff,
  0x2ba & 0x3ff,
  0x2b8 & 0x3ff,
  0x2b4 & 0x3ff,
  0x2b0 & 0x3ff,
  0x2ac & 0x3ff,
  0x2a8 & 0x3ff,
  0x2a6 & 0x3ff,
  0x2a2 & 0x3ff,
  0x29e & 0x3ff,
  0x29c & 0x3ff,
  0x298 & 0x3ff,
  0x294 & 0x3ff,
  0x290 & 0x3ff,
  0x28e & 0x3ff,
  0x28a & 0x3ff,
  0x288 & 0x3ff,
  0x284 & 0x3ff,
  0x280 & 0x3ff,
  0x27e & 0x3ff,
  0x27a & 0x3ff,
  0x278 & 0x3ff,
  0x274 & 0x3ff,
  0x272 & 0x3ff,
  0x26e & 0x3ff,
  0x26c & 0x3ff,
  0x268 & 0x3ff,
  0x266 & 0x3ff,
  0x264 & 0x3ff,
  0x260 & 0x3ff,
  0x25e & 0x3ff,
  0x25a & 0x3ff,
  0x258 & 0x3ff,
  0x254 & 0x3ff,
  0x252 & 0x3ff,
  0x250 & 0x3ff,
  0x24c & 0x3ff,
  0x24a & 0x3ff,
  0x248 & 0x3ff,
  0x246 & 0x3ff,
  0x242 & 0x3ff,
  0x240 & 0x3ff,
  0x23e & 0x3ff,
  0x23c & 0x3ff,
  0x238 & 0x3ff,
  0x236 & 0x3ff,
  0x234 & 0x3ff,
  0x232 & 0x3ff,
  0x230 & 0x3ff,
  0x22c & 0x3ff,
  0x22a & 0x3ff,
  0x228 & 0x3ff,
  0x226 & 0x3ff,
  0x224 & 0x3ff,
  0x220 & 0x3ff,
  0x21e & 0x3ff,
  0x21c & 0x3ff,
  0x21a & 0x3ff,
  0x218 & 0x3ff,
  0x216 & 0x3ff,
  0x214 & 0x3ff,
  0x212 & 0x3ff,
  0x210 & 0x3ff,
  0x20e & 0x3ff,
  0x20c & 0x3ff,
  0x208 & 0x3ff,
  0x208 & 0x3ff,
  0x204 & 0x3ff,
  0x204 & 0x3ff,
  0x201 & 0x3ff,
  0
};

/* constant table RSQRT_10b_256 */
static const unsigned CONST_TBL_RSQRT_10b_256_0[] = {
  0x1a5 & 0x3ff,
  0x1a0 & 0x3ff,
  0x19a & 0x3ff,
  0x195 & 0x3ff,
  0x18f & 0x3ff,
  0x18a & 0x3ff,
  0x185 & 0x3ff,
  0x180 & 0x3ff,
  0x17a & 0x3ff,
  0x175 & 0x3ff,
  0x170 & 0x3ff,
  0x16b & 0x3ff,
  0x166 & 0x3ff,
  0x161 & 0x3ff,
  0x15d & 0x3ff,
  0x158 & 0x3ff,
  0x153 & 0x3ff,
  0x14e & 0x3ff,
  0x14a & 0x3ff,
  0x145 & 0x3ff,
  0x140 & 0x3ff,
  0x13c & 0x3ff,
  0x138 & 0x3ff,
  0x133 & 0x3ff,
  0x12f & 0x3ff,
  0x12a & 0x3ff,
  0x126 & 0x3ff,
  0x122 & 0x3ff,
  0x11e & 0x3ff,
  0x11a & 0x3ff,
  0x115 & 0x3ff,
  0x111 & 0x3ff,
  0x10d & 0x3ff,
  0x109 & 0x3ff,
  0x105 & 0x3ff,
  0x101 & 0x3ff,
  0xfd & 0x3ff,
  0xfa & 0x3ff,
  0xf6 & 0x3ff,
  0xf2 & 0x3ff,
  0xee & 0x3ff,
  0xea & 0x3ff,
  0xe7 & 0x3ff,
  0xe3 & 0x3ff,
  0xdf & 0x3ff,
  0xdc & 0x3ff,
  0xd8 & 0x3ff,
  0xd5 & 0x3ff,
  0xd1 & 0x3ff,
  0xce & 0x3ff,
  0xca & 0x3ff,
  0xc7 & 0x3ff,
  0xc3 & 0x3ff,
  0xc0 & 0x3ff,
  0xbd & 0x3ff,
  0xb9 & 0x3ff,
  0xb6 & 0x3ff,
  0xb3 & 0x3ff,
  0xb0 & 0x3ff,
  0xad & 0x3ff,
  0xa9 & 0x3ff,
  0xa6 & 0x3ff,
  0xa3 & 0x3ff,
  0xa0 & 0x3ff,
  0x9d & 0x3ff,
  0x9a & 0x3ff,
  0x97 & 0x3ff,
  0x94 & 0x3ff,
  0x91 & 0x3ff,
  0x8e & 0x3ff,
  0x8b & 0x3ff,
  0x88 & 0x3ff,
  0x85 & 0x3ff,
  0x82 & 0x3ff,
  0x7f & 0x3ff,
  0x7d & 0x3ff,
  0x7a & 0x3ff,
  0x77 & 0x3ff,
  0x74 & 0x3ff,
  0x71 & 0x3ff,
  0x6f & 0x3ff,
  0x6c & 0x3ff,
  0x69 & 0x3ff,
  0x67 & 0x3ff,
  0x64 & 0x3ff,
  0x61 & 0x3ff,
  0x5f & 0x3ff,
  0x5c & 0x3ff,
  0x5a & 0x3ff,
  0x57 & 0x3ff,
  0x54 & 0x3ff,
  0x52 & 0x3ff,
  0x4f & 0x3ff,
  0x4d & 0x3ff,
  0x4a & 0x3ff,
  0x48 & 0x3ff,
  0x45 & 0x3ff,
  0x43 & 0x3ff,
  0x41 & 0x3ff,
  0x3e & 0x3ff,
  0x3c & 0x3ff,
  0x3a & 0x3ff,
  0x37 & 0x3ff,
  0x35 & 0x3ff,
  0x33 & 0x3ff,
  0x30 & 0x3ff,
  0x2e & 0x3ff,
  0x2c & 0x3ff,
  0x29 & 0x3ff,
  0x27 & 0x3ff,
  0x25 & 0x3ff,
  0x23 & 0x3ff,
  0x20 & 0x3ff,
  0x1e & 0x3ff,
  0x1c & 0x3ff,
  0x1a & 0x3ff,
  0x18 & 0x3ff,
  0x16 & 0x3ff,
  0x14 & 0x3ff,
  0x11 & 0x3ff,
  0xf & 0x3ff,
  0xd & 0x3ff,
  0xb & 0x3ff,
  0x9 & 0x3ff,
  0x7 & 0x3ff,
  0x5 & 0x3ff,
  0x3 & 0x3ff,
  0x1 & 0x3ff,
  0x3fc & 0x3ff,
  0x3f4 & 0x3ff,
  0x3ec & 0x3ff,
  0x3e5 & 0x3ff,
  0x3dd & 0x3ff,
  0x3d5 & 0x3ff,
  0x3ce & 0x3ff,
  0x3c7 & 0x3ff,
  0x3bf & 0x3ff,
  0x3b8 & 0x3ff,
  0x3b1 & 0x3ff,
  0x3aa & 0x3ff,
  0x3a3 & 0x3ff,
  0x39c & 0x3ff,
  0x395 & 0x3ff,
  0x38e & 0x3ff,
  0x388 & 0x3ff,
  0x381 & 0x3ff,
  0x37a & 0x3ff,
  0x374 & 0x3ff,
  0x36d & 0x3ff,
  0x367 & 0x3ff,
  0x361 & 0x3ff,
  0x35a & 0x3ff,
  0x354 & 0x3ff,
  0x34e & 0x3ff,
  0x348 & 0x3ff,
  0x342 & 0x3ff,
  0x33c & 0x3ff,
  0x336 & 0x3ff,
  0x330 & 0x3ff,
  0x32b & 0x3ff,
  0x325 & 0x3ff,
  0x31f & 0x3ff,
  0x31a & 0x3ff,
  0x314 & 0x3ff,
  0x30f & 0x3ff,
  0x309 & 0x3ff,
  0x304 & 0x3ff,
  0x2fe & 0x3ff,
  0x2f9 & 0x3ff,
  0x2f4 & 0x3ff,
  0x2ee & 0x3ff,
  0x2e9 & 0x3ff,
  0x2e4 & 0x3ff,
  0x2df & 0x3ff,
  0x2da & 0x3ff,
  0x2d5 & 0x3ff,
  0x2d0 & 0x3ff,
  0x2cb & 0x3ff,
  0x2c6 & 0x3ff,
  0x2c1 & 0x3ff,
  0x2bd & 0x3ff,
  0x2b8 & 0x3ff,
  0x2b3 & 0x3ff,
  0x2ae & 0x3ff,
  0x2aa & 0x3ff,
  0x2a5 & 0x3ff,
  0x2a1 & 0x3ff,
  0x29c & 0x3ff,
  0x298 & 0x3ff,
  0x293 & 0x3ff,
  0x28f & 0x3ff,
  0x28a & 0x3ff,
  0x286 & 0x3ff,
  0x282 & 0x3ff,
  0x27d & 0x3ff,
  0x279 & 0x3ff,
  0x275 & 0x3ff,
  0x271 & 0x3ff,
  0x26d & 0x3ff,
  0x268 & 0x3ff,
  0x264 & 0x3ff,
  0x260 & 0x3ff,
  0x25c & 0x3ff,
  0x258 & 0x3ff,
  0x254 & 0x3ff,
  0x250 & 0x3ff,
  0x24c & 0x3ff,
  0x249 & 0x3ff,
  0x245 & 0x3ff,
  0x241 & 0x3ff,
  0x23d & 0x3ff,
  0x239 & 0x3ff,
  0x235 & 0x3ff,
  0x232 & 0x3ff,
  0x22e & 0x3ff,
  0x22a & 0x3ff,
  0x227 & 0x3ff,
  0x223 & 0x3ff,
  0x220 & 0x3ff,
  0x21c & 0x3ff,
  0x218 & 0x3ff,
  0x215 & 0x3ff,
  0x211 & 0x3ff,
  0x20e & 0x3ff,
  0x20a & 0x3ff,
  0x207 & 0x3ff,
  0x204 & 0x3ff,
  0x200 & 0x3ff,
  0x1fd & 0x3ff,
  0x1f9 & 0x3ff,
  0x1f6 & 0x3ff,
  0x1f3 & 0x3ff,
  0x1f0 & 0x3ff,
  0x1ec & 0x3ff,
  0x1e9 & 0x3ff,
  0x1e6 & 0x3ff,
  0x1e3 & 0x3ff,
  0x1df & 0x3ff,
  0x1dc & 0x3ff,
  0x1d9 & 0x3ff,
  0x1d6 & 0x3ff,
  0x1d3 & 0x3ff,
  0x1d0 & 0x3ff,
  0x1cd & 0x3ff,
  0x1ca & 0x3ff,
  0x1c7 & 0x3ff,
  0x1c4 & 0x3ff,
  0x1c1 & 0x3ff,
  0x1be & 0x3ff,
  0x1bb & 0x3ff,
  0x1b8 & 0x3ff,
  0x1b5 & 0x3ff,
  0x1b2 & 0x3ff,
  0x1af & 0x3ff,
  0x1ac & 0x3ff,
  0x1aa & 0x3ff,
  0
};

/* constant table RECIP_10b_256 */
static const unsigned CONST_TBL_RECIP_10b_256_0[] = {
  0x3fc & 0x3ff,
  0x3f4 & 0x3ff,
  0x3ec & 0x3ff,
  0x3e4 & 0x3ff,
  0x3dd & 0x3ff,
  0x3d5 & 0x3ff,
  0x3cd & 0x3ff,
  0x3c6 & 0x3ff,
  0x3be & 0x3ff,
  0x3b7 & 0x3ff,
  0x3af & 0x3ff,
  0x3a8 & 0x3ff,
  0x3a1 & 0x3ff,
  0x399 & 0x3ff,
  0x392 & 0x3ff,
  0x38b & 0x3ff,
  0x384 & 0x3ff,
  0x37d & 0x3ff,
  0x376 & 0x3ff,
  0x36f & 0x3ff,
  0x368 & 0x3ff,
  0x361 & 0x3ff,
  0x35b & 0x3ff,
  0x354 & 0x3ff,
  0x34d & 0x3ff,
  0x346 & 0x3ff,
  0x340 & 0x3ff,
  0x339 & 0x3ff,
  0x333 & 0x3ff,
  0x32c & 0x3ff,
  0x326 & 0x3ff,
  0x320 & 0x3ff,
  0x319 & 0x3ff,
  0x313 & 0x3ff,
  0x30d & 0x3ff,
  0x307 & 0x3ff,
  0x300 & 0x3ff,
  0x2fa & 0x3ff,
  0x2f4 & 0x3ff,
  0x2ee & 0x3ff,
  0x2e8 & 0x3ff,
  0x2e2 & 0x3ff,
  0x2dc & 0x3ff,
  0x2d7 & 0x3ff,
  0x2d1 & 0x3ff,
  0x2cb & 0x3ff,
  0x2c5 & 0x3ff,
  0x2bf & 0x3ff,
  0x2ba & 0x3ff,
  0x2b4 & 0x3ff,
  0x2af & 0x3ff,
  0x2a9 & 0x3ff,
  0x2a3 & 0x3ff,
  0x29e & 0x3ff,
  0x299 & 0x3ff,
  0x293 & 0x3ff,
  0x28e & 0x3ff,
  0x288 & 0x3ff,
  0x283 & 0x3ff,
  0x27e & 0x3ff,
  0x279 & 0x3ff,
  0x273 & 0x3ff,
  0x26e & 0x3ff,
  0x269 & 0x3ff,
  0x264 & 0x3ff,
  0x25f & 0x3ff,
  0x25a & 0x3ff,
  0x255 & 0x3ff,
  0x250 & 0x3ff,
  0x24b & 0x3ff,
  0x246 & 0x3ff,
  0x241 & 0x3ff,
  0x23c & 0x3ff,
  0x237 & 0x3ff,
  0x232 & 0x3ff,
  0x22e & 0x3ff,
  0x229 & 0x3ff,
  0x224 & 0x3ff,
  0x21f & 0x3ff,
  0x21b & 0x3ff,
  0x216 & 0x3ff,
  0x211 & 0x3ff,
  0x20d & 0x3ff,
  0x208 & 0x3ff,
  0x204 & 0x3ff,
  0x1ff & 0x3ff,
  0x1fb & 0x3ff,
  0x1f6 & 0x3ff,
  0x1f2 & 0x3ff,
  0x1ed & 0x3ff,
  0x1e9 & 0x3ff,
  0x1e5 & 0x3ff,
  0x1e0 & 0x3ff,
  0x1dc & 0x3ff,
  0x1d8 & 0x3ff,
  0x1d4 & 0x3ff,
  0x1cf & 0x3ff,
  0x1cb & 0x3ff,
  0x1c7 & 0x3ff,
  0x1c3 & 0x3ff,
  0x1bf & 0x3ff,
  0x1bb & 0x3ff,
  0x1b6 & 0x3ff,
  0x1b2 & 0x3ff,
  0x1ae & 0x3ff,
  0x1aa & 0x3ff,
  0x1a6 & 0x3ff,
  0x1a2 & 0x3ff,
  0x19e & 0x3ff,
  0x19a & 0x3ff,
  0x197 & 0x3ff,
  0x193 & 0x3ff,
  0x18f & 0x3ff,
  0x18b & 0x3ff,
  0x187 & 0x3ff,
  0x183 & 0x3ff,
  0x17f & 0x3ff,
  0x17c & 0x3ff,
  0x178 & 0x3ff,
  0x174 & 0x3ff,
  0x171 & 0x3ff,
  0x16d & 0x3ff,
  0x169 & 0x3ff,
  0x166 & 0x3ff,
  0x162 & 0x3ff,
  0x15e & 0x3ff,
  0x15b & 0x3ff,
  0x157 & 0x3ff,
  0x154 & 0x3ff,
  0x150 & 0x3ff,
  0x14d & 0x3ff,
  0x149 & 0x3ff,
  0x146 & 0x3ff,
  0x142 & 0x3ff,
  0x13f & 0x3ff,
  0x13b & 0x3ff,
  0x138 & 0x3ff,
  0x134 & 0x3ff,
  0x131 & 0x3ff,
  0x12e & 0x3ff,
  0x12a & 0x3ff,
  0x127 & 0x3ff,
  0x124 & 0x3ff,
  0x120 & 0x3ff,
  0x11d & 0x3ff,
  0x11a & 0x3ff,
  0x117 & 0x3ff,
  0x113 & 0x3ff,
  0x110 & 0x3ff,
  0x10d & 0x3ff,
  0x10a & 0x3ff,
  0x107 & 0x3ff,
  0x103 & 0x3ff,
  0x100 & 0x3ff,
  0xfd & 0x3ff,
  0xfa & 0x3ff,
  0xf7 & 0x3ff,
  0xf4 & 0x3ff,
  0xf1 & 0x3ff,
  0xee & 0x3ff,
  0xeb & 0x3ff,
  0xe8 & 0x3ff,
  0xe5 & 0x3ff,
  0xe2 & 0x3ff,
  0xdf & 0x3ff,
  0xdc & 0x3ff,
  0xd9 & 0x3ff,
  0xd6 & 0x3ff,
  0xd3 & 0x3ff,
  0xd0 & 0x3ff,
  0xcd & 0x3ff,
  0xca & 0x3ff,
  0xc8 & 0x3ff,
  0xc5 & 0x3ff,
  0xc2 & 0x3ff,
  0xbf & 0x3ff,
  0xbc & 0x3ff,
  0xb9 & 0x3ff,
  0xb7 & 0x3ff,
  0xb4 & 0x3ff,
  0xb1 & 0x3ff,
  0xae & 0x3ff,
  0xac & 0x3ff,
  0xa9 & 0x3ff,
  0xa6 & 0x3ff,
  0xa4 & 0x3ff,
  0xa1 & 0x3ff,
  0x9e & 0x3ff,
  0x9c & 0x3ff,
  0x99 & 0x3ff,
  0x96 & 0x3ff,
  0x94 & 0x3ff,
  0x91 & 0x3ff,
  0x8e & 0x3ff,
  0x8c & 0x3ff,
  0x89 & 0x3ff,
  0x87 & 0x3ff,
  0x84 & 0x3ff,
  0x82 & 0x3ff,
  0x7f & 0x3ff,
  0x7c & 0x3ff,
  0x7a & 0x3ff,
  0x77 & 0x3ff,
  0x75 & 0x3ff,
  0x73 & 0x3ff,
  0x70 & 0x3ff,
  0x6e & 0x3ff,
  0x6b & 0x3ff,
  0x69 & 0x3ff,
  0x66 & 0x3ff,
  0x64 & 0x3ff,
  0x61 & 0x3ff,
  0x5f & 0x3ff,
  0x5d & 0x3ff,
  0x5a & 0x3ff,
  0x58 & 0x3ff,
  0x56 & 0x3ff,
  0x53 & 0x3ff,
  0x51 & 0x3ff,
  0x4f & 0x3ff,
  0x4c & 0x3ff,
  0x4a & 0x3ff,
  0x48 & 0x3ff,
  0x45 & 0x3ff,
  0x43 & 0x3ff,
  0x41 & 0x3ff,
  0x3f & 0x3ff,
  0x3c & 0x3ff,
  0x3a & 0x3ff,
  0x38 & 0x3ff,
  0x36 & 0x3ff,
  0x33 & 0x3ff,
  0x31 & 0x3ff,
  0x2f & 0x3ff,
  0x2d & 0x3ff,
  0x2b & 0x3ff,
  0x29 & 0x3ff,
  0x26 & 0x3ff,
  0x24 & 0x3ff,
  0x22 & 0x3ff,
  0x20 & 0x3ff,
  0x1e & 0x3ff,
  0x1c & 0x3ff,
  0x1a & 0x3ff,
  0x18 & 0x3ff,
  0x15 & 0x3ff,
  0x13 & 0x3ff,
  0x11 & 0x3ff,
  0xf & 0x3ff,
  0xd & 0x3ff,
  0xb & 0x3ff,
  0x9 & 0x3ff,
  0x7 & 0x3ff,
  0x5 & 0x3ff,
  0x3 & 0x3ff,
  0x1 & 0x3ff,
  0
};


/* Instruction operands.  */

static int
OperandSem_opnd_sem_MR_0_decode (uint32 *valp)
{
  *valp += 2;
  return 0;
}

static int
OperandSem_opnd_sem_MR_0_encode (uint32 *valp)
{
  int error;
  error = ((*valp & ~0x3) != 0) || ((*valp & 0x2) == 0);
  *valp = *valp & 1;
  return error;
}

static int
OperandSem_opnd_sem_soffsetx4_decode (uint32 *valp)
{
  unsigned soffsetx4_out_0;
  unsigned soffsetx4_in_0;
  soffsetx4_in_0 = *valp & 0x3ffff;
  soffsetx4_out_0 = 0x4 + ((((int) soffsetx4_in_0 << 14) >> 14) << 2);
  *valp = soffsetx4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_soffsetx4_encode (uint32 *valp)
{
  unsigned soffsetx4_in_0;
  unsigned soffsetx4_out_0;
  soffsetx4_out_0 = *valp;
  soffsetx4_in_0 = ((soffsetx4_out_0 - 0x4) >> 2) & 0x3ffff;
  *valp = soffsetx4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_immr_decode (uint32 *valp)
{
  unsigned immr_out_0;
  unsigned immr_in_0;
  immr_in_0 = *valp & 0xf;
  immr_out_0 = immr_in_0;
  *valp = immr_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_immr_encode (uint32 *valp)
{
  unsigned immr_in_0;
  unsigned immr_out_0;
  immr_out_0 = *valp;
  immr_in_0 = (immr_out_0 & 0xf);
  *valp = immr_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm12x8_decode (uint32 *valp)
{
  unsigned uimm12x8_out_0;
  unsigned uimm12x8_in_0;
  uimm12x8_in_0 = *valp & 0xfff;
  uimm12x8_out_0 = uimm12x8_in_0 << 3;
  *valp = uimm12x8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm12x8_encode (uint32 *valp)
{
  unsigned uimm12x8_in_0;
  unsigned uimm12x8_out_0;
  uimm12x8_out_0 = *valp;
  uimm12x8_in_0 = ((uimm12x8_out_0 >> 3) & 0xfff);
  *valp = uimm12x8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm4_decode (uint32 *valp)
{
  unsigned simm4_out_0;
  unsigned simm4_in_0;
  simm4_in_0 = *valp & 0xf;
  simm4_out_0 = ((int) simm4_in_0 << 28) >> 28;
  *valp = simm4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm4_encode (uint32 *valp)
{
  unsigned simm4_in_0;
  unsigned simm4_out_0;
  simm4_out_0 = *valp;
  simm4_in_0 = (simm4_out_0 & 0xf);
  *valp = simm4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_AR_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_AR_0_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_0_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_AR_4_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_4_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_AR_8_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_8_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_AR_12_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_12_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_AR_entry_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_entry_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_immrx4_decode (uint32 *valp)
{
  unsigned immrx4_out_0;
  unsigned immrx4_in_0;
  immrx4_in_0 = *valp & 0xf;
  immrx4_out_0 = (((0xfffffff) << 4) | immrx4_in_0) << 2;
  *valp = immrx4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_immrx4_encode (uint32 *valp)
{
  unsigned immrx4_in_0;
  unsigned immrx4_out_0;
  immrx4_out_0 = *valp;
  immrx4_in_0 = ((immrx4_out_0 >> 2) & 0xf);
  *valp = immrx4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_lsi4x4_decode (uint32 *valp)
{
  unsigned lsi4x4_out_0;
  unsigned lsi4x4_in_0;
  lsi4x4_in_0 = *valp & 0xf;
  lsi4x4_out_0 = lsi4x4_in_0 << 2;
  *valp = lsi4x4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_lsi4x4_encode (uint32 *valp)
{
  unsigned lsi4x4_in_0;
  unsigned lsi4x4_out_0;
  lsi4x4_out_0 = *valp;
  lsi4x4_in_0 = ((lsi4x4_out_0 >> 2) & 0xf);
  *valp = lsi4x4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm7_decode (uint32 *valp)
{
  unsigned simm7_out_0;
  unsigned simm7_in_0;
  simm7_in_0 = *valp & 0x7f;
  simm7_out_0 = ((((-((((simm7_in_0 >> 6) & 1)) & (((simm7_in_0 >> 5) & 1)))) & 0x1ffffff)) << 7) | simm7_in_0;
  *valp = simm7_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm7_encode (uint32 *valp)
{
  unsigned simm7_in_0;
  unsigned simm7_out_0;
  simm7_out_0 = *valp;
  simm7_in_0 = (simm7_out_0 & 0x7f);
  *valp = simm7_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm6_decode (uint32 *valp)
{
  unsigned uimm6_out_0;
  unsigned uimm6_in_0;
  uimm6_in_0 = *valp & 0x3f;
  uimm6_out_0 = 0x4 + (((0) << 6) | uimm6_in_0);
  *valp = uimm6_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm6_encode (uint32 *valp)
{
  unsigned uimm6_in_0;
  unsigned uimm6_out_0;
  uimm6_out_0 = *valp;
  uimm6_in_0 = (uimm6_out_0 - 0x4) & 0x3f;
  *valp = uimm6_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ai4const_decode (uint32 *valp)
{
  unsigned ai4const_out_0;
  unsigned ai4const_in_0;
  ai4const_in_0 = *valp & 0xf;
  ai4const_out_0 = CONST_TBL_ai4c_0[ai4const_in_0 & 0xf];
  *valp = ai4const_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ai4const_encode (uint32 *valp)
{
  unsigned ai4const_in_0;
  unsigned ai4const_out_0;
  ai4const_out_0 = *valp;
  switch (ai4const_out_0)
    {
    case 0xffffffff: ai4const_in_0 = 0; break;
    case 0x1: ai4const_in_0 = 0x1; break;
    case 0x2: ai4const_in_0 = 0x2; break;
    case 0x3: ai4const_in_0 = 0x3; break;
    case 0x4: ai4const_in_0 = 0x4; break;
    case 0x5: ai4const_in_0 = 0x5; break;
    case 0x6: ai4const_in_0 = 0x6; break;
    case 0x7: ai4const_in_0 = 0x7; break;
    case 0x8: ai4const_in_0 = 0x8; break;
    case 0x9: ai4const_in_0 = 0x9; break;
    case 0xa: ai4const_in_0 = 0xa; break;
    case 0xb: ai4const_in_0 = 0xb; break;
    case 0xc: ai4const_in_0 = 0xc; break;
    case 0xd: ai4const_in_0 = 0xd; break;
    case 0xe: ai4const_in_0 = 0xe; break;
    default: ai4const_in_0 = 0xf; break;
    }
  *valp = ai4const_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4const_decode (uint32 *valp)
{
  unsigned b4const_out_0;
  unsigned b4const_in_0;
  b4const_in_0 = *valp & 0xf;
  b4const_out_0 = CONST_TBL_b4c_0[b4const_in_0 & 0xf];
  *valp = b4const_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4const_encode (uint32 *valp)
{
  unsigned b4const_in_0;
  unsigned b4const_out_0;
  b4const_out_0 = *valp;
  switch (b4const_out_0)
    {
    case 0xffffffff: b4const_in_0 = 0; break;
    case 0x1: b4const_in_0 = 0x1; break;
    case 0x2: b4const_in_0 = 0x2; break;
    case 0x3: b4const_in_0 = 0x3; break;
    case 0x4: b4const_in_0 = 0x4; break;
    case 0x5: b4const_in_0 = 0x5; break;
    case 0x6: b4const_in_0 = 0x6; break;
    case 0x7: b4const_in_0 = 0x7; break;
    case 0x8: b4const_in_0 = 0x8; break;
    case 0xa: b4const_in_0 = 0x9; break;
    case 0xc: b4const_in_0 = 0xa; break;
    case 0x10: b4const_in_0 = 0xb; break;
    case 0x20: b4const_in_0 = 0xc; break;
    case 0x40: b4const_in_0 = 0xd; break;
    case 0x80: b4const_in_0 = 0xe; break;
    default: b4const_in_0 = 0xf; break;
    }
  *valp = b4const_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4constu_decode (uint32 *valp)
{
  unsigned b4constu_out_0;
  unsigned b4constu_in_0;
  b4constu_in_0 = *valp & 0xf;
  b4constu_out_0 = CONST_TBL_b4cu_0[b4constu_in_0 & 0xf];
  *valp = b4constu_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4constu_encode (uint32 *valp)
{
  unsigned b4constu_in_0;
  unsigned b4constu_out_0;
  b4constu_out_0 = *valp;
  switch (b4constu_out_0)
    {
    case 0x8000: b4constu_in_0 = 0; break;
    case 0x10000: b4constu_in_0 = 0x1; break;
    case 0x2: b4constu_in_0 = 0x2; break;
    case 0x3: b4constu_in_0 = 0x3; break;
    case 0x4: b4constu_in_0 = 0x4; break;
    case 0x5: b4constu_in_0 = 0x5; break;
    case 0x6: b4constu_in_0 = 0x6; break;
    case 0x7: b4constu_in_0 = 0x7; break;
    case 0x8: b4constu_in_0 = 0x8; break;
    case 0xa: b4constu_in_0 = 0x9; break;
    case 0xc: b4constu_in_0 = 0xa; break;
    case 0x10: b4constu_in_0 = 0xb; break;
    case 0x20: b4constu_in_0 = 0xc; break;
    case 0x40: b4constu_in_0 = 0xd; break;
    case 0x80: b4constu_in_0 = 0xe; break;
    default: b4constu_in_0 = 0xf; break;
    }
  *valp = b4constu_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_immt_decode (uint32 *valp)
{
  unsigned immt_out_0;
  unsigned immt_in_0;
  immt_in_0 = *valp & 0xf;
  immt_out_0 = immt_in_0;
  *valp = immt_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_immt_encode (uint32 *valp)
{
  unsigned immt_in_0;
  unsigned immt_out_0;
  immt_out_0 = *valp;
  immt_in_0 = immt_out_0 & 0xf;
  *valp = immt_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8_decode (uint32 *valp)
{
  unsigned uimm8_out_0;
  unsigned uimm8_in_0;
  uimm8_in_0 = *valp & 0xff;
  uimm8_out_0 = uimm8_in_0;
  *valp = uimm8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8_encode (uint32 *valp)
{
  unsigned uimm8_in_0;
  unsigned uimm8_out_0;
  uimm8_out_0 = *valp;
  uimm8_in_0 = (uimm8_out_0 & 0xff);
  *valp = uimm8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x2_decode (uint32 *valp)
{
  unsigned uimm8x2_out_0;
  unsigned uimm8x2_in_0;
  uimm8x2_in_0 = *valp & 0xff;
  uimm8x2_out_0 = uimm8x2_in_0 << 1;
  *valp = uimm8x2_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x2_encode (uint32 *valp)
{
  unsigned uimm8x2_in_0;
  unsigned uimm8x2_out_0;
  uimm8x2_out_0 = *valp;
  uimm8x2_in_0 = ((uimm8x2_out_0 >> 1) & 0xff);
  *valp = uimm8x2_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x4_decode (uint32 *valp)
{
  unsigned uimm8x4_out_0;
  unsigned uimm8x4_in_0;
  uimm8x4_in_0 = *valp & 0xff;
  uimm8x4_out_0 = uimm8x4_in_0 << 2;
  *valp = uimm8x4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x4_encode (uint32 *valp)
{
  unsigned uimm8x4_in_0;
  unsigned uimm8x4_out_0;
  uimm8x4_out_0 = *valp;
  uimm8x4_in_0 = ((uimm8x4_out_0 >> 2) & 0xff);
  *valp = uimm8x4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm4x16_decode (uint32 *valp)
{
  unsigned uimm4x16_out_0;
  unsigned uimm4x16_in_0;
  uimm4x16_in_0 = *valp & 0xf;
  uimm4x16_out_0 = ((0 << 4) | uimm4x16_in_0) << 4;
  *valp = uimm4x16_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm4x16_encode (uint32 *valp)
{
  unsigned uimm4x16_in_0;
  unsigned uimm4x16_out_0;
  uimm4x16_out_0 = *valp;
  uimm4x16_in_0 = ((uimm4x16_out_0 >> 4) & 0xf);
  *valp = uimm4x16_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimmrx4_decode (uint32 *valp)
{
  unsigned uimmrx4_out_0;
  unsigned uimmrx4_in_0;
  uimmrx4_in_0 = *valp & 0xf;
  uimmrx4_out_0 = ((0 << 4) | uimmrx4_in_0) << 2;
  *valp = uimmrx4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimmrx4_encode (uint32 *valp)
{
  unsigned uimmrx4_in_0;
  unsigned uimmrx4_out_0;
  uimmrx4_out_0 = *valp;
  uimmrx4_in_0 = ((uimmrx4_out_0 >> 2) & 0xf);
  *valp = uimmrx4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8_decode (uint32 *valp)
{
  unsigned simm8_out_0;
  unsigned simm8_in_0;
  simm8_in_0 = *valp & 0xff;
  simm8_out_0 = ((int) simm8_in_0 << 24) >> 24;
  *valp = simm8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8_encode (uint32 *valp)
{
  unsigned simm8_in_0;
  unsigned simm8_out_0;
  simm8_out_0 = *valp;
  simm8_in_0 = (simm8_out_0 & 0xff);
  *valp = simm8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8x256_decode (uint32 *valp)
{
  unsigned simm8x256_out_0;
  unsigned simm8x256_in_0;
  simm8x256_in_0 = *valp & 0xff;
  simm8x256_out_0 = (((int) simm8x256_in_0 << 24) >> 24) << 8;
  *valp = simm8x256_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8x256_encode (uint32 *valp)
{
  unsigned simm8x256_in_0;
  unsigned simm8x256_out_0;
  simm8x256_out_0 = *valp;
  simm8x256_in_0 = ((simm8x256_out_0 >> 8) & 0xff);
  *valp = simm8x256_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm12b_decode (uint32 *valp)
{
  unsigned simm12b_out_0;
  unsigned simm12b_in_0;
  simm12b_in_0 = *valp & 0xfff;
  simm12b_out_0 = ((int) simm12b_in_0 << 20) >> 20;
  *valp = simm12b_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm12b_encode (uint32 *valp)
{
  unsigned simm12b_in_0;
  unsigned simm12b_out_0;
  simm12b_out_0 = *valp;
  simm12b_in_0 = (simm12b_out_0 & 0xfff);
  *valp = simm12b_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_msalp32_decode (uint32 *valp)
{
  unsigned msalp32_out_0;
  unsigned msalp32_in_0;
  msalp32_in_0 = *valp & 0x1f;
  msalp32_out_0 = 0x20 - msalp32_in_0;
  *valp = msalp32_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_msalp32_encode (uint32 *valp)
{
  unsigned msalp32_in_0;
  unsigned msalp32_out_0;
  msalp32_out_0 = *valp;
  msalp32_in_0 = (0x20 - msalp32_out_0) & 0x1f;
  *valp = msalp32_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_op2p1_decode (uint32 *valp)
{
  unsigned op2p1_out_0;
  unsigned op2p1_in_0;
  op2p1_in_0 = *valp & 0xf;
  op2p1_out_0 = op2p1_in_0 + 0x1;
  *valp = op2p1_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_op2p1_encode (uint32 *valp)
{
  unsigned op2p1_in_0;
  unsigned op2p1_out_0;
  op2p1_out_0 = *valp;
  op2p1_in_0 = (op2p1_out_0 - 0x1) & 0xf;
  *valp = op2p1_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_label8_decode (uint32 *valp)
{
  unsigned label8_out_0;
  unsigned label8_in_0;
  label8_in_0 = *valp & 0xff;
  label8_out_0 = 0x4 + (((int) label8_in_0 << 24) >> 24);
  *valp = label8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_label8_encode (uint32 *valp)
{
  unsigned label8_in_0;
  unsigned label8_out_0;
  label8_out_0 = *valp;
  label8_in_0 = (label8_out_0 - 0x4) & 0xff;
  *valp = label8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ulabel8_decode (uint32 *valp)
{
  unsigned ulabel8_out_0;
  unsigned ulabel8_in_0;
  ulabel8_in_0 = *valp & 0xff;
  ulabel8_out_0 = 0x4 + (((0) << 8) | ulabel8_in_0);
  *valp = ulabel8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ulabel8_encode (uint32 *valp)
{
  unsigned ulabel8_in_0;
  unsigned ulabel8_out_0;
  ulabel8_out_0 = *valp;
  ulabel8_in_0 = (ulabel8_out_0 - 0x4) & 0xff;
  *valp = ulabel8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_label12_decode (uint32 *valp)
{
  unsigned label12_out_0;
  unsigned label12_in_0;
  label12_in_0 = *valp & 0xfff;
  label12_out_0 = 0x4 + (((int) label12_in_0 << 20) >> 20);
  *valp = label12_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_label12_encode (uint32 *valp)
{
  unsigned label12_in_0;
  unsigned label12_out_0;
  label12_out_0 = *valp;
  label12_in_0 = (label12_out_0 - 0x4) & 0xfff;
  *valp = label12_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_soffset_decode (uint32 *valp)
{
  unsigned soffset_out_0;
  unsigned soffset_in_0;
  soffset_in_0 = *valp & 0x3ffff;
  soffset_out_0 = 0x4 + (((int) soffset_in_0 << 14) >> 14);
  *valp = soffset_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_soffset_encode (uint32 *valp)
{
  unsigned soffset_in_0;
  unsigned soffset_out_0;
  soffset_out_0 = *valp;
  soffset_in_0 = (soffset_out_0 - 0x4) & 0x3ffff;
  *valp = soffset_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm16x4_decode (uint32 *valp)
{
  unsigned uimm16x4_out_0;
  unsigned uimm16x4_in_0;
  uimm16x4_in_0 = *valp & 0xffff;
  uimm16x4_out_0 = (((0xffff) << 16) | uimm16x4_in_0) << 2;
  *valp = uimm16x4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm16x4_encode (uint32 *valp)
{
  unsigned uimm16x4_in_0;
  unsigned uimm16x4_out_0;
  uimm16x4_out_0 = *valp;
  uimm16x4_in_0 = (uimm16x4_out_0 >> 2) & 0xffff;
  *valp = uimm16x4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_bbi_decode (uint32 *valp)
{
  unsigned bbi_out_0;
  unsigned bbi_in_0;
  bbi_in_0 = *valp & 0x1f;
  bbi_out_0 = (0 << 5) | bbi_in_0;
  *valp = bbi_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_bbi_encode (uint32 *valp)
{
  unsigned bbi_in_0;
  unsigned bbi_out_0;
  bbi_out_0 = *valp;
  bbi_in_0 = (bbi_out_0 & 0x1f);
  *valp = bbi_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_s_decode (uint32 *valp)
{
  unsigned s_out_0;
  unsigned s_in_0;
  s_in_0 = *valp & 0xf;
  s_out_0 = (0 << 4) | s_in_0;
  *valp = s_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_s_encode (uint32 *valp)
{
  unsigned s_in_0;
  unsigned s_out_0;
  s_out_0 = *valp;
  s_in_0 = (s_out_0 & 0xf);
  *valp = s_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_MR_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_MR_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_MR_1_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_MR_1_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_MR_2_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_MR_2_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_MR_3_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_MR_3_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_MR_4_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_MR_4_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_MR_5_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_MR_5_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_imms_decode (uint32 *valp)
{
  unsigned imms_out_0;
  unsigned imms_in_0;
  imms_in_0 = *valp & 0xf;
  imms_out_0 = imms_in_0;
  *valp = imms_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_imms_encode (uint32 *valp)
{
  unsigned imms_in_0;
  unsigned imms_out_0;
  imms_out_0 = *valp;
  imms_in_0 = imms_out_0 & 0xf;
  *valp = imms_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_BR_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_BR_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 16);
  return error;
}

static int
OperandSem_opnd_sem_BR2_decode (uint32 *valp)
{
  *valp = *valp << 1;
  return 0;
}

static int
OperandSem_opnd_sem_BR2_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 16) || ((*valp & 1) != 0);
  *valp = *valp >> 1;
  return error;
}

static int
OperandSem_opnd_sem_BR4_decode (uint32 *valp)
{
  *valp = *valp << 2;
  return 0;
}

static int
OperandSem_opnd_sem_BR4_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 16) || ((*valp & 3) != 0);
  *valp = *valp >> 2;
  return error;
}

static int
OperandSem_opnd_sem_BR8_decode (uint32 *valp)
{
  *valp = *valp << 3;
  return 0;
}

static int
OperandSem_opnd_sem_BR8_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 16) || ((*valp & 7) != 0);
  *valp = *valp >> 3;
  return error;
}

static int
OperandSem_opnd_sem_BR16_decode (uint32 *valp)
{
  *valp = *valp << 4;
  return 0;
}

static int
OperandSem_opnd_sem_BR16_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 16) || ((*valp & 15) != 0);
  *valp = *valp >> 4;
  return error;
}

static int
OperandSem_opnd_sem_tp7_decode (uint32 *valp)
{
  unsigned tp7_out_0;
  unsigned tp7_in_0;
  tp7_in_0 = *valp & 0xf;
  tp7_out_0 = tp7_in_0 + 0x7;
  *valp = tp7_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_tp7_encode (uint32 *valp)
{
  unsigned tp7_in_0;
  unsigned tp7_out_0;
  tp7_out_0 = *valp;
  tp7_in_0 = (tp7_out_0 - 0x7) & 0xf;
  *valp = tp7_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_xt_wbr15_label_decode (uint32 *valp)
{
  unsigned xt_wbr15_label_out_0;
  unsigned xt_wbr15_label_in_0;
  xt_wbr15_label_in_0 = *valp & 0x7fff;
  xt_wbr15_label_out_0 = 0x4 + (((int) xt_wbr15_label_in_0 << 17) >> 17);
  *valp = xt_wbr15_label_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_xt_wbr15_label_encode (uint32 *valp)
{
  unsigned xt_wbr15_label_in_0;
  unsigned xt_wbr15_label_out_0;
  xt_wbr15_label_out_0 = *valp;
  xt_wbr15_label_in_0 = (xt_wbr15_label_out_0 - 0x4) & 0x7fff;
  *valp = xt_wbr15_label_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_xt_wbr18_label_decode (uint32 *valp)
{
  unsigned xt_wbr18_label_out_0;
  unsigned xt_wbr18_label_in_0;
  xt_wbr18_label_in_0 = *valp & 0x3ffff;
  xt_wbr18_label_out_0 = 0x4 + (((int) xt_wbr18_label_in_0 << 14) >> 14);
  *valp = xt_wbr18_label_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_xt_wbr18_label_encode (uint32 *valp)
{
  unsigned xt_wbr18_label_in_0;
  unsigned xt_wbr18_label_out_0;
  xt_wbr18_label_out_0 = *valp;
  xt_wbr18_label_in_0 = (xt_wbr18_label_out_0 - 0x4) & 0x3ffff;
  *valp = xt_wbr18_label_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_ohba_decode (uint32 *valp)
{
  unsigned ae_ohba_out_0;
  unsigned ae_ohba_in_0;
  ae_ohba_in_0 = *valp & 0xf;
  ae_ohba_out_0 = (0 << 5) | (((((ae_ohba_in_0 & 0xf))) == 0) << 4) | ((ae_ohba_in_0 & 0xf));
  *valp = ae_ohba_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_ohba_encode (uint32 *valp)
{
  unsigned ae_ohba_in_0;
  unsigned ae_ohba_out_0;
  ae_ohba_out_0 = *valp;
  ae_ohba_in_0 = (ae_ohba_out_0 & 0xf);
  *valp = ae_ohba_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_opnd_tp7_decode (uint32 *valp)
{
  unsigned ae_opnd_tp7_out_0;
  unsigned ae_opnd_tp7_in_0;
  ae_opnd_tp7_in_0 = *valp & 0xf;
  ae_opnd_tp7_out_0 = ae_opnd_tp7_in_0 + 0x7;
  *valp = ae_opnd_tp7_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_opnd_tp7_encode (uint32 *valp)
{
  unsigned ae_opnd_tp7_in_0;
  unsigned ae_opnd_tp7_out_0;
  ae_opnd_tp7_out_0 = *valp;
  ae_opnd_tp7_in_0 = (ae_opnd_tp7_out_0 - 0x7) & 0xf;
  *valp = ae_opnd_tp7_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_imm2_decode (uint32 *valp)
{
  unsigned ae_imm2_out_0;
  unsigned ae_imm2_in_0;
  ae_imm2_in_0 = *valp & 0x3;
  ae_imm2_out_0 = (0 << 2) | ae_imm2_in_0;
  *valp = ae_imm2_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_imm2_encode (uint32 *valp)
{
  unsigned ae_imm2_in_0;
  unsigned ae_imm2_out_0;
  ae_imm2_out_0 = *valp;
  ae_imm2_in_0 = (ae_imm2_out_0 & 0x3);
  *valp = ae_imm2_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa32_decode (uint32 *valp)
{
  unsigned ae_osa32_out_0;
  unsigned ae_osa32_in_0;
  ae_osa32_in_0 = *valp & 0x1f;
  ae_osa32_out_0 = (0 << 5) | ae_osa32_in_0;
  *valp = ae_osa32_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa32_encode (uint32 *valp)
{
  unsigned ae_osa32_in_0;
  unsigned ae_osa32_out_0;
  ae_osa32_out_0 = *valp;
  ae_osa32_in_0 = (ae_osa32_out_0 & 0x1f);
  *valp = ae_osa32_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa64_decode (uint32 *valp)
{
  unsigned ae_osa64_out_0;
  unsigned ae_osa64_in_0;
  ae_osa64_in_0 = *valp & 0x3f;
  ae_osa64_out_0 = (0 << 6) | ae_osa64_in_0;
  *valp = ae_osa64_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa64_encode (uint32 *valp)
{
  unsigned ae_osa64_in_0;
  unsigned ae_osa64_out_0;
  ae_osa64_out_0 = *valp;
  ae_osa64_in_0 = (ae_osa64_out_0 & 0x3f);
  *valp = ae_osa64_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls64_decode (uint32 *valp)
{
  unsigned ae_immls64_out_0;
  unsigned ae_immls64_in_0;
  ae_immls64_in_0 = *valp & 0xf;
  ae_immls64_out_0 = (((int) ae_immls64_in_0 << 28) >> 28) << 3;
  *valp = ae_immls64_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls64_encode (uint32 *valp)
{
  unsigned ae_immls64_in_0;
  unsigned ae_immls64_out_0;
  ae_immls64_out_0 = *valp;
  ae_immls64_in_0 = ((ae_immls64_out_0 >> 3) & 0xf);
  *valp = ae_immls64_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls64pos_decode (uint32 *valp)
{
  unsigned ae_immls64pos_out_0;
  unsigned ae_immls64pos_in_0;
  ae_immls64pos_in_0 = *valp & 0x7;
  ae_immls64pos_out_0 = ((0 << 3) | ae_immls64pos_in_0) << 3;
  *valp = ae_immls64pos_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls64pos_encode (uint32 *valp)
{
  unsigned ae_immls64pos_in_0;
  unsigned ae_immls64pos_out_0;
  ae_immls64pos_out_0 = *valp;
  ae_immls64pos_in_0 = ((ae_immls64pos_out_0 >> 3) & 0x7);
  *valp = ae_immls64pos_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls32_decode (uint32 *valp)
{
  unsigned ae_immls32_out_0;
  unsigned ae_immls32_in_0;
  ae_immls32_in_0 = *valp & 0xf;
  ae_immls32_out_0 = (((int) ae_immls32_in_0 << 28) >> 28) << 2;
  *valp = ae_immls32_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls32_encode (uint32 *valp)
{
  unsigned ae_immls32_in_0;
  unsigned ae_immls32_out_0;
  ae_immls32_out_0 = *valp;
  ae_immls32_in_0 = ((ae_immls32_out_0 >> 2) & 0xf);
  *valp = ae_immls32_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls16_decode (uint32 *valp)
{
  unsigned ae_immls16_out_0;
  unsigned ae_immls16_in_0;
  ae_immls16_in_0 = *valp & 0xf;
  ae_immls16_out_0 = (((int) ae_immls16_in_0 << 28) >> 28) << 1;
  *valp = ae_immls16_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls16_encode (uint32 *valp)
{
  unsigned ae_immls16_in_0;
  unsigned ae_immls16_out_0;
  ae_immls16_out_0 = *valp;
  ae_immls16_in_0 = ((ae_immls16_out_0 >> 1) & 0xf);
  *valp = ae_immls16_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa16_decode (uint32 *valp)
{
  unsigned ae_osa16_out_0;
  unsigned ae_osa16_in_0;
  ae_osa16_in_0 = *valp & 0xf;
  ae_osa16_out_0 = (0 << 4) | ae_osa16_in_0;
  *valp = ae_osa16_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa16_encode (uint32 *valp)
{
  unsigned ae_osa16_in_0;
  unsigned ae_osa16_out_0;
  ae_osa16_out_0 = *valp;
  ae_osa16_in_0 = (ae_osa16_out_0 & 0xf);
  *valp = ae_osa16_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_movi_imm_decode (uint32 *valp)
{
  unsigned movi_imm_out_0;
  unsigned movi_imm_in_0;
  movi_imm_in_0 = *valp & 0x3f;
  movi_imm_out_0 = ((((-(( ( ((((movi_imm_in_0 >> 4) & 0x3)) | 0xfffffffc)) == 0xffffffff))) & 0x3ffffff)) << 6) | movi_imm_in_0;
  *valp = movi_imm_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_movi_imm_encode (uint32 *valp)
{
  unsigned movi_imm_in_0;
  unsigned movi_imm_out_0;
  movi_imm_out_0 = *valp;
  movi_imm_in_0 = (movi_imm_out_0 & 0x3f);
  *valp = movi_imm_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_lsimm8_2_decode (uint32 *valp)
{
  unsigned ae_lsimm8_2_out_0;
  unsigned ae_lsimm8_2_in_0;
  ae_lsimm8_2_in_0 = *valp & 0x1;
  ae_lsimm8_2_out_0 = CONST_TBL_ae_updating_store_table8_0[ae_lsimm8_2_in_0 & 0x1];
  *valp = ae_lsimm8_2_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_lsimm8_2_encode (uint32 *valp)
{
  unsigned ae_lsimm8_2_in_0;
  unsigned ae_lsimm8_2_out_0;
  ae_lsimm8_2_out_0 = *valp;
  ae_lsimm8_2_in_0 = (((ae_lsimm8_2_out_0 == (CONST_TBL_ae_updating_store_table8_0[0]))) ? 0 : 0x1) & 0x1;
  *valp = ae_lsimm8_2_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_lsimm16_2_decode (uint32 *valp)
{
  unsigned ae_lsimm16_2_out_0;
  unsigned ae_lsimm16_2_in_0;
  ae_lsimm16_2_in_0 = *valp & 0x1;
  ae_lsimm16_2_out_0 = CONST_TBL_ae_updating_store_table16_0[ae_lsimm16_2_in_0 & 0x1];
  *valp = ae_lsimm16_2_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_lsimm16_2_encode (uint32 *valp)
{
  unsigned ae_lsimm16_2_in_0;
  unsigned ae_lsimm16_2_out_0;
  ae_lsimm16_2_out_0 = *valp;
  ae_lsimm16_2_in_0 = (((ae_lsimm16_2_out_0 == (CONST_TBL_ae_updating_store_table16_0[0]))) ? 0 : 0x1) & 0x1;
  *valp = ae_lsimm16_2_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_lsimm32_2_decode (uint32 *valp)
{
  unsigned ae_lsimm32_2_out_0;
  unsigned ae_lsimm32_2_in_0;
  ae_lsimm32_2_in_0 = *valp & 0x1;
  ae_lsimm32_2_out_0 = CONST_TBL_ae_updating_store_table32_0[ae_lsimm32_2_in_0 & 0x1];
  *valp = ae_lsimm32_2_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_lsimm32_2_encode (uint32 *valp)
{
  unsigned ae_lsimm32_2_in_0;
  unsigned ae_lsimm32_2_out_0;
  ae_lsimm32_2_out_0 = *valp;
  ae_lsimm32_2_in_0 = (((ae_lsimm32_2_out_0 == (CONST_TBL_ae_updating_store_table32_0[0]))) ? 0 : 0x1) & 0x1;
  *valp = ae_lsimm32_2_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_uimm2x2_decode (uint32 *valp)
{
  unsigned ae_uimm2x2_out_0;
  unsigned ae_uimm2x2_in_0;
  ae_uimm2x2_in_0 = *valp & 0x1;
  ae_uimm2x2_out_0 = (0 << 2) | (ae_uimm2x2_in_0 << 1) | 0;
  *valp = ae_uimm2x2_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_uimm2x2_encode (uint32 *valp)
{
  unsigned ae_uimm2x2_in_0;
  unsigned ae_uimm2x2_out_0;
  ae_uimm2x2_out_0 = *valp;
  ae_uimm2x2_in_0 = (((ae_uimm2x2_out_0 >> 1) & 1)) & 0x1;
  *valp = ae_uimm2x2_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_AE_DR_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AE_DR_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 12);
  return error;
}

static int
OperandSem_opnd_sem_imm_s_decode (uint32 *valp)
{
  unsigned imm_s_out_0;
  unsigned imm_s_in_0;
  imm_s_in_0 = *valp & 0xf;
  imm_s_out_0 = (0 << 4) | imm_s_in_0;
  *valp = imm_s_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_imm_s_encode (uint32 *valp)
{
  unsigned imm_s_in_0;
  unsigned imm_s_out_0;
  imm_s_out_0 = *valp;
  imm_s_in_0 = (imm_s_out_0 & 0xf);
  *valp = imm_s_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_imm8x4_decode (uint32 *valp)
{
  unsigned imm8x4_out_0;
  unsigned imm8x4_in_0;
  imm8x4_in_0 = *valp & 0xff;
  imm8x4_out_0 = (0 << 10) | (imm8x4_in_0 << 2) | 0;
  *valp = imm8x4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_imm8x4_encode (uint32 *valp)
{
  unsigned imm8x4_in_0;
  unsigned imm8x4_out_0;
  imm8x4_out_0 = *valp;
  imm8x4_in_0 = ((imm8x4_out_0 >> 2) & 0xff);
  *valp = imm8x4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_imm8x8_decode (uint32 *valp)
{
  unsigned imm8x8_out_0;
  unsigned imm8x8_in_0;
  imm8x8_in_0 = *valp & 0xff;
  imm8x8_out_0 = (0 << 11) | (imm8x8_in_0 << 3) | 0;
  *valp = imm8x8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_imm8x8_encode (uint32 *valp)
{
  unsigned imm8x8_in_0;
  unsigned imm8x8_out_0;
  imm8x8_out_0 = *valp;
  imm8x8_in_0 = ((imm8x8_out_0 >> 3) & 0xff);
  *valp = imm8x8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_AE_VALIGN_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AE_VALIGN_encode (uint32 *valp)
{
  int error;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_bitindex_decode (uint32 *valp)
{
  unsigned bitindex_out_0;
  unsigned bitindex_in_0;
  bitindex_in_0 = *valp & 0x1f;
  bitindex_out_0 = (0 << 5) | bitindex_in_0;
  *valp = bitindex_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_bitindex_encode (uint32 *valp)
{
  unsigned bitindex_in_0;
  unsigned bitindex_out_0;
  bitindex_out_0 = *valp;
  bitindex_in_0 = (bitindex_out_0 & 0x1f);
  *valp = bitindex_in_0;
  return 0;
}

static int
Operand_soffsetx4_ator (uint32 *valp, uint32 pc)
{
  *valp -= (pc & ~0x3);
  return 0;
}

static int
Operand_soffsetx4_rtoa (uint32 *valp, uint32 pc)
{
  *valp += (pc & ~0x3);
  return 0;
}

static int
Operand_uimm6_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_uimm6_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_label8_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_label8_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_ulabel8_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_ulabel8_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_label12_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_label12_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_soffset_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_soffset_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_uimm16x4_ator (uint32 *valp, uint32 pc)
{
  *valp -= ((pc + 3) & ~0x3);
  return 0;
}

static int
Operand_uimm16x4_rtoa (uint32 *valp, uint32 pc)
{
  *valp += ((pc + 3) & ~0x3);
  return 0;
}

static int
Operand_xt_wbr15_label_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_xt_wbr15_label_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_xt_wbr18_label_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_xt_wbr18_label_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static xtensa_operand_internal operands[] = {
  { "soffsetx4", FIELD_offset, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_soffsetx4_encode, OperandSem_opnd_sem_soffsetx4_decode,
    Operand_soffsetx4_ator, Operand_soffsetx4_rtoa },
  { "immr", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_immr_encode, OperandSem_opnd_sem_immr_decode,
    0, 0 },
  { "uimm12x8", FIELD_imm12, -1, 0,
    0,
    OperandSem_opnd_sem_uimm12x8_encode, OperandSem_opnd_sem_uimm12x8_decode,
    0, 0 },
  { "simm4", FIELD_mn, -1, 0,
    0,
    OperandSem_opnd_sem_simm4_encode, OperandSem_opnd_sem_simm4_decode,
    0, 0 },
  { "arr", FIELD_r, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "ars", FIELD_s, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "*ars_invisible", FIELD_s, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "art", FIELD_t, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "ar0", FIELD__ar0, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_0_encode, OperandSem_opnd_sem_AR_0_decode,
    0, 0 },
  { "ar4", FIELD__ar4, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_4_encode, OperandSem_opnd_sem_AR_4_decode,
    0, 0 },
  { "ar8", FIELD__ar8, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_8_encode, OperandSem_opnd_sem_AR_8_decode,
    0, 0 },
  { "ar12", FIELD__ar12, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_12_encode, OperandSem_opnd_sem_AR_12_decode,
    0, 0 },
  { "ars_entry", FIELD_s, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_entry_encode, OperandSem_opnd_sem_AR_entry_decode,
    0, 0 },
  { "immrx4", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_immrx4_encode, OperandSem_opnd_sem_immrx4_decode,
    0, 0 },
  { "lsi4x4", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_lsi4x4_encode, OperandSem_opnd_sem_lsi4x4_decode,
    0, 0 },
  { "simm7", FIELD_imm7, -1, 0,
    0,
    OperandSem_opnd_sem_simm7_encode, OperandSem_opnd_sem_simm7_decode,
    0, 0 },
  { "uimm6", FIELD_imm6, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_uimm6_encode, OperandSem_opnd_sem_uimm6_decode,
    Operand_uimm6_ator, Operand_uimm6_rtoa },
  { "ai4const", FIELD_t, -1, 0,
    0,
    OperandSem_opnd_sem_ai4const_encode, OperandSem_opnd_sem_ai4const_decode,
    0, 0 },
  { "b4const", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_b4const_encode, OperandSem_opnd_sem_b4const_decode,
    0, 0 },
  { "b4constu", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_b4constu_encode, OperandSem_opnd_sem_b4constu_decode,
    0, 0 },
  { "immt", FIELD_t, -1, 0,
    0,
    OperandSem_opnd_sem_immt_encode, OperandSem_opnd_sem_immt_decode,
    0, 0 },
  { "uimm8", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_uimm8_encode, OperandSem_opnd_sem_uimm8_decode,
    0, 0 },
  { "uimm8x2", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_uimm8x2_encode, OperandSem_opnd_sem_uimm8x2_decode,
    0, 0 },
  { "uimm8x4", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_uimm8x4_encode, OperandSem_opnd_sem_uimm8x4_decode,
    0, 0 },
  { "uimm4x16", FIELD_op2, -1, 0,
    0,
    OperandSem_opnd_sem_uimm4x16_encode, OperandSem_opnd_sem_uimm4x16_decode,
    0, 0 },
  { "uimmrx4", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_uimmrx4_encode, OperandSem_opnd_sem_uimmrx4_decode,
    0, 0 },
  { "simm8", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_simm8_encode, OperandSem_opnd_sem_simm8_decode,
    0, 0 },
  { "simm8x256", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_simm8x256_encode, OperandSem_opnd_sem_simm8x256_decode,
    0, 0 },
  { "simm12b", FIELD_imm12b, -1, 0,
    0,
    OperandSem_opnd_sem_simm12b_encode, OperandSem_opnd_sem_simm12b_decode,
    0, 0 },
  { "msalp32", FIELD_sal, -1, 0,
    0,
    OperandSem_opnd_sem_msalp32_encode, OperandSem_opnd_sem_msalp32_decode,
    0, 0 },
  { "op2p1", FIELD_op2, -1, 0,
    0,
    OperandSem_opnd_sem_op2p1_encode, OperandSem_opnd_sem_op2p1_decode,
    0, 0 },
  { "label8", FIELD_imm8, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_label8_encode, OperandSem_opnd_sem_label8_decode,
    Operand_label8_ator, Operand_label8_rtoa },
  { "ulabel8", FIELD_imm8, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_ulabel8_encode, OperandSem_opnd_sem_ulabel8_decode,
    Operand_ulabel8_ator, Operand_ulabel8_rtoa },
  { "label12", FIELD_imm12, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_label12_encode, OperandSem_opnd_sem_label12_decode,
    Operand_label12_ator, Operand_label12_rtoa },
  { "soffset", FIELD_offset, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_soffset_encode, OperandSem_opnd_sem_soffset_decode,
    Operand_soffset_ator, Operand_soffset_rtoa },
  { "uimm16x4", FIELD_imm16, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_uimm16x4_encode, OperandSem_opnd_sem_uimm16x4_decode,
    Operand_uimm16x4_ator, Operand_uimm16x4_rtoa },
  { "bbi", FIELD_bbi, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0 },
  { "sae", FIELD_sae, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0 },
  { "sas", FIELD_sas, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0 },
  { "sargt", FIELD_sargt, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0 },
  { "s", FIELD_s, -1, 0,
    0,
    OperandSem_opnd_sem_s_encode, OperandSem_opnd_sem_s_decode,
    0, 0 },
  { "mx", FIELD_x, REGFILE_MR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_UNKNOWN,
    OperandSem_opnd_sem_MR_encode, OperandSem_opnd_sem_MR_decode,
    0, 0 },
  { "my", FIELD_y, REGFILE_MR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_UNKNOWN,
    OperandSem_opnd_sem_MR_0_encode, OperandSem_opnd_sem_MR_0_decode,
    0, 0 },
  { "mw", FIELD_w, REGFILE_MR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_MR_1_encode, OperandSem_opnd_sem_MR_1_decode,
    0, 0 },
  { "mr0", FIELD__mr0, REGFILE_MR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_MR_2_encode, OperandSem_opnd_sem_MR_2_decode,
    0, 0 },
  { "mr1", FIELD__mr1, REGFILE_MR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_MR_3_encode, OperandSem_opnd_sem_MR_3_decode,
    0, 0 },
  { "mr2", FIELD__mr2, REGFILE_MR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_MR_4_encode, OperandSem_opnd_sem_MR_4_decode,
    0, 0 },
  { "mr3", FIELD__mr3, REGFILE_MR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_MR_5_encode, OperandSem_opnd_sem_MR_5_decode,
    0, 0 },
  { "imms", FIELD_s, -1, 0,
    0,
    OperandSem_opnd_sem_imms_encode, OperandSem_opnd_sem_imms_decode,
    0, 0 },
  { "imms1", FIELD_s, -1, 0,
    0,
    OperandSem_opnd_sem_imms_encode, OperandSem_opnd_sem_imms_decode,
    0, 0 },
  { "bt", FIELD_t, REGFILE_BR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR_encode, OperandSem_opnd_sem_BR_decode,
    0, 0 },
  { "bs", FIELD_s, REGFILE_BR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR_encode, OperandSem_opnd_sem_BR_decode,
    0, 0 },
  { "br", FIELD_r, REGFILE_BR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR_encode, OperandSem_opnd_sem_BR_decode,
    0, 0 },
  { "bt2", FIELD_t2, REGFILE_BR, 2,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR2_encode, OperandSem_opnd_sem_BR2_decode,
    0, 0 },
  { "bs2", FIELD_s2, REGFILE_BR, 2,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR2_encode, OperandSem_opnd_sem_BR2_decode,
    0, 0 },
  { "br2", FIELD_r2, REGFILE_BR, 2,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR2_encode, OperandSem_opnd_sem_BR2_decode,
    0, 0 },
  { "bt4", FIELD_t4, REGFILE_BR, 4,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR4_encode, OperandSem_opnd_sem_BR4_decode,
    0, 0 },
  { "bs4", FIELD_s4, REGFILE_BR, 4,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR4_encode, OperandSem_opnd_sem_BR4_decode,
    0, 0 },
  { "br4", FIELD_r4, REGFILE_BR, 4,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR4_encode, OperandSem_opnd_sem_BR4_decode,
    0, 0 },
  { "bt8", FIELD_t8, REGFILE_BR, 8,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR8_encode, OperandSem_opnd_sem_BR8_decode,
    0, 0 },
  { "bs8", FIELD_s8, REGFILE_BR, 8,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR8_encode, OperandSem_opnd_sem_BR8_decode,
    0, 0 },
  { "br8", FIELD_r8, REGFILE_BR, 8,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR8_encode, OperandSem_opnd_sem_BR8_decode,
    0, 0 },
  { "bt16", FIELD__bt16, REGFILE_BR, 16,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR16_encode, OperandSem_opnd_sem_BR16_decode,
    0, 0 },
  { "bs16", FIELD__bs16, REGFILE_BR, 16,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR16_encode, OperandSem_opnd_sem_BR16_decode,
    0, 0 },
  { "br16", FIELD__br16, REGFILE_BR, 16,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR16_encode, OperandSem_opnd_sem_BR16_decode,
    0, 0 },
  { "brall", FIELD__brall, REGFILE_BR, 16,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_BR16_encode, OperandSem_opnd_sem_BR16_decode,
    0, 0 },
  { "tp7", FIELD_t, -1, 0,
    0,
    OperandSem_opnd_sem_tp7_encode, OperandSem_opnd_sem_tp7_decode,
    0, 0 },
  { "xt_wbr15_label", FIELD_xt_wbr15_imm, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_xt_wbr15_label_encode, OperandSem_opnd_sem_xt_wbr15_label_decode,
    Operand_xt_wbr15_label_ator, Operand_xt_wbr15_label_rtoa },
  { "xt_wbr18_label", FIELD_xt_wbr18_imm, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_xt_wbr18_label_encode, OperandSem_opnd_sem_xt_wbr18_label_decode,
    Operand_xt_wbr18_label_ator, Operand_xt_wbr18_label_rtoa },
  { "ae_ohba", FIELD_ae_fld_fhba4, -1, 0,
    0,
    OperandSem_opnd_sem_ae_ohba_encode, OperandSem_opnd_sem_ae_ohba_decode,
    0, 0 },
  { "ae_ohba2", FIELD_ae_fld_fhba4_2, -1, 0,
    0,
    OperandSem_opnd_sem_ae_ohba_encode, OperandSem_opnd_sem_ae_ohba_decode,
    0, 0 },
  { "ae_opnd_tp7", FIELD_ae_fld_tp7, -1, 0,
    0,
    OperandSem_opnd_sem_ae_opnd_tp7_encode, OperandSem_opnd_sem_ae_opnd_tp7_decode,
    0, 0 },
  { "ae_imm2", FIELD_ae_fld_imm2, -1, 0,
    0,
    OperandSem_opnd_sem_ae_imm2_encode, OperandSem_opnd_sem_ae_imm2_decode,
    0, 0 },
  { "ae_osa32", FIELD_ae_fld_osa32, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa32_encode, OperandSem_opnd_sem_ae_osa32_decode,
    0, 0 },
  { "ae_osa64", FIELD_ae_fld_osa64, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa64_encode, OperandSem_opnd_sem_ae_osa64_decode,
    0, 0 },
  { "ae_immls64", FIELD_ae_fld_immls64, -1, 0,
    0,
    OperandSem_opnd_sem_ae_immls64_encode, OperandSem_opnd_sem_ae_immls64_decode,
    0, 0 },
  { "ae_immls64pos", FIELD_ae_fld_immls64pos, -1, 0,
    0,
    OperandSem_opnd_sem_ae_immls64pos_encode, OperandSem_opnd_sem_ae_immls64pos_decode,
    0, 0 },
  { "ae_immls32", FIELD_ae_fld_immls32, -1, 0,
    0,
    OperandSem_opnd_sem_ae_immls32_encode, OperandSem_opnd_sem_ae_immls32_decode,
    0, 0 },
  { "ae_immls16", FIELD_ae_fld_immls16, -1, 0,
    0,
    OperandSem_opnd_sem_ae_immls16_encode, OperandSem_opnd_sem_ae_immls16_decode,
    0, 0 },
  { "ae_osa16", FIELD_ae_fld_osa16, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa16_encode, OperandSem_opnd_sem_ae_osa16_decode,
    0, 0 },
  { "ae_selimm", FIELD_ae_fld_selimm, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa16_encode, OperandSem_opnd_sem_ae_osa16_decode,
    0, 0 },
  { "movi_imm", FIELD_fld_ar_to_dr_imm, -1, 0,
    0,
    OperandSem_opnd_sem_movi_imm_encode, OperandSem_opnd_sem_movi_imm_decode,
    0, 0 },
  { "stage3_ar_operand", FIELD_fld_stage3_ar_operand, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "ae_lsimm8_2", FIELD_fld_lsip, -1, 0,
    0,
    OperandSem_opnd_sem_ae_lsimm8_2_encode, OperandSem_opnd_sem_ae_lsimm8_2_decode,
    0, 0 },
  { "ae_lsimm16_2", FIELD_fld_lsip, -1, 0,
    0,
    OperandSem_opnd_sem_ae_lsimm16_2_encode, OperandSem_opnd_sem_ae_lsimm16_2_decode,
    0, 0 },
  { "ae_lsimm32_2", FIELD_fld_lsip, -1, 0,
    0,
    OperandSem_opnd_sem_ae_lsimm32_2_encode, OperandSem_opnd_sem_ae_lsimm32_2_decode,
    0, 0 },
  { "ae_uimm2x2", FIELD_ae_fld_Inst16b_12, -1, 0,
    0,
    OperandSem_opnd_sem_ae_uimm2x2_encode, OperandSem_opnd_sem_ae_uimm2x2_decode,
    0, 0 },
  { "opnd_AE_L8X4F.X_x", FIELD_fld_AE_L8X4F_X_x, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_AE_L8X4F.X_a", FIELD_fld_AE_L8X4F_X_a, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_AE_L8X4F.X_v", FIELD_fld_AE_L8X4F_X_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_L8X4F.XP_x", FIELD_fld_AE_L8X4F_XP_x, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_AE_L8X4F.XP_a", FIELD_fld_AE_L8X4F_XP_a, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_AE_L8X4F.XP_v", FIELD_fld_AE_L8X4F_XP_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_pks_s", FIELD_fld_ae_sem_pks_s, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_pks_d", FIELD_fld_ae_sem_pks_d, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_ZEROB_v1", FIELD_fld_AE_ZEROB_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_ZEROB_v0", FIELD_fld_AE_ZEROB_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_ar_to_dr_a0", FIELD_fld_ae_sem_ar_to_dr_a0, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_ar_to_dr_a1", FIELD_fld_ae_sem_ar_to_dr_a1, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_shift_a0", FIELD_fld_ae_sem_shift_a0, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_ar_a", FIELD_fld_ae_sem_dr_to_ar_a, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_av", FIELD_fld_ae_sem_loads_stores_av, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_v", FIELD_fld_ae_sem_loads_stores_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_v1", FIELD_fld_ae_sem_loads_stores_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_loads_stores_v2", FIELD_fld_ae_sem_loads_stores_v2, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_dr_v0", FIELD_fld_ae_sem_dr_to_dr_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_dr_v", FIELD_fld_ae_sem_dr_to_dr_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_ar_v0", FIELD_fld_ae_sem_dr_to_ar_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_shift_sd", FIELD_fld_ae_sem_shift_sd, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_shift_d0", FIELD_fld_ae_sem_shift_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_shift_d", FIELD_fld_ae_sem_shift_d, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_cmov_v0", FIELD_fld_ae_sem_cmov_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_cmov_v", FIELD_fld_ae_sem_cmov_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_cmpp_v1", FIELD_fld_ae_sem_cmpp_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_cmpp_v0", FIELD_fld_ae_sem_cmpp_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_cmpp_v", FIELD_fld_ae_sem_cmpp_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_arithmetic_v0", FIELD_fld_ae_sem_arithmetic_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_arithmetic_v1", FIELD_fld_ae_sem_arithmetic_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_arithmetic_v", FIELD_fld_ae_sem_arithmetic_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_mul_x2_S1_d1", FIELD_fld_ae_sem_mul_x2_S1_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_mul_x2_S1_d0", FIELD_fld_ae_sem_mul_x2_S1_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_mul_x2_S1_q0", FIELD_fld_ae_sem_mul_x2_S1_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_mul_x2_S1_q1", FIELD_fld_ae_sem_mul_x2_S1_q1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_mul_x2_S1_d2", FIELD_fld_ae_sem_mul_x2_S1_d2, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_to_dr_v0", FIELD_fld_ae_sem_to_dr_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_to_dr_v", FIELD_fld_ae_sem_to_dr_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_dr_to_dr_v1", FIELD_fld_ae_sem_dr_to_dr_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_ar_to_dr_v", FIELD_fld_ae_sem_ar_to_dr_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFCR32X16RAS.L_d1", FIELD_fld_AE_MULFCR32X16RAS_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFCR32X16RAS.L_d0", FIELD_fld_AE_MULFCR32X16RAS_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFCR32X16RAS.L_q0", FIELD_fld_AE_MULFCR32X16RAS_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFCR32X16RAS.H_d1", FIELD_fld_AE_MULFCR32X16RAS_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFCR32X16RAS.H_d0", FIELD_fld_AE_MULFCR32X16RAS_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFCR32X16RAS.H_q0", FIELD_fld_AE_MULFCR32X16RAS_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFCR32X16RAS.L_d1", FIELD_fld_AE_MULAFCR32X16RAS_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFCR32X16RAS.L_d0", FIELD_fld_AE_MULAFCR32X16RAS_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFCR32X16RAS.L_q0", FIELD_fld_AE_MULAFCR32X16RAS_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFCR32X16RAS.H_d1", FIELD_fld_AE_MULAFCR32X16RAS_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFCR32X16RAS.H_d0", FIELD_fld_AE_MULAFCR32X16RAS_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFCR32X16RAS.H_q0", FIELD_fld_AE_MULAFCR32X16RAS_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFCI32X16RAS.L_d1", FIELD_fld_AE_MULFCI32X16RAS_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFCI32X16RAS.L_d0", FIELD_fld_AE_MULFCI32X16RAS_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFCI32X16RAS.L_q0", FIELD_fld_AE_MULFCI32X16RAS_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFCI32X16RAS.H_d1", FIELD_fld_AE_MULFCI32X16RAS_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFCI32X16RAS.H_d0", FIELD_fld_AE_MULFCI32X16RAS_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFCI32X16RAS.H_q0", FIELD_fld_AE_MULFCI32X16RAS_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFCI32X16RAS.L_d1", FIELD_fld_AE_MULAFCI32X16RAS_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFCI32X16RAS.L_d0", FIELD_fld_AE_MULAFCI32X16RAS_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFCI32X16RAS.L_q0", FIELD_fld_AE_MULAFCI32X16RAS_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFCI32X16RAS.H_d1", FIELD_fld_AE_MULAFCI32X16RAS_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFCI32X16RAS.H_d0", FIELD_fld_AE_MULAFCI32X16RAS_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFCI32X16RAS.H_q0", FIELD_fld_AE_MULAFCI32X16RAS_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULP32X2.H_d1", FIELD_fld_AE_MULP32X2_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULP32X2.H_d0", FIELD_fld_AE_MULP32X2_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULP32X2.H_q0", FIELD_fld_AE_MULP32X2_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAP32X2.H_d1", FIELD_fld_AE_MULAP32X2_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAP32X2.H_d0", FIELD_fld_AE_MULAP32X2_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAP32X2.H_q0", FIELD_fld_AE_MULAP32X2_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSP32X2.H_d1", FIELD_fld_AE_MULSP32X2_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSP32X2.H_d0", FIELD_fld_AE_MULSP32X2_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSP32X2.H_q0", FIELD_fld_AE_MULSP32X2_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULP32X2.L_d1", FIELD_fld_AE_MULP32X2_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULP32X2.L_d0", FIELD_fld_AE_MULP32X2_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULP32X2.L_q0", FIELD_fld_AE_MULP32X2_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAP32X2.L_d1", FIELD_fld_AE_MULAP32X2_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAP32X2.L_d0", FIELD_fld_AE_MULAP32X2_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAP32X2.L_q0", FIELD_fld_AE_MULAP32X2_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSP32X2.L_d1", FIELD_fld_AE_MULSP32X2_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSP32X2.L_d0", FIELD_fld_AE_MULSP32X2_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSP32X2.L_q0", FIELD_fld_AE_MULSP32X2_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_mul_x2_S1_d2.0", FIELD_fld_ae_sem_mul_x2_S1_d2_0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_mul_x2_S1_d3", FIELD_fld_ae_sem_mul_x2_S1_d3, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP32X2RS.H_d1", FIELD_fld_AE_MULFP32X2RS_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP32X2RS.H_d0", FIELD_fld_AE_MULFP32X2RS_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP32X2RS.H_q0", FIELD_fld_AE_MULFP32X2RS_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP32X2RAS.H_d1", FIELD_fld_AE_MULFP32X2RAS_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP32X2RAS.H_d0", FIELD_fld_AE_MULFP32X2RAS_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP32X2RAS.H_q0", FIELD_fld_AE_MULFP32X2RAS_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFP32X2RS.H_d1", FIELD_fld_AE_MULAFP32X2RS_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFP32X2RS.H_d0", FIELD_fld_AE_MULAFP32X2RS_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFP32X2RS.H_q0", FIELD_fld_AE_MULAFP32X2RS_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFP32X2RAS.H_d1", FIELD_fld_AE_MULAFP32X2RAS_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFP32X2RAS.H_d0", FIELD_fld_AE_MULAFP32X2RAS_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFP32X2RAS.H_q0", FIELD_fld_AE_MULAFP32X2RAS_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSFP32X2RS.H_d1", FIELD_fld_AE_MULSFP32X2RS_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSFP32X2RS.H_d0", FIELD_fld_AE_MULSFP32X2RS_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSFP32X2RS.H_q0", FIELD_fld_AE_MULSFP32X2RS_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSFP32X2RAS.H_d1", FIELD_fld_AE_MULSFP32X2RAS_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSFP32X2RAS.H_d0", FIELD_fld_AE_MULSFP32X2RAS_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSFP32X2RAS.H_q0", FIELD_fld_AE_MULSFP32X2RAS_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP32X2RS.L_d1", FIELD_fld_AE_MULFP32X2RS_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP32X2RS.L_d0", FIELD_fld_AE_MULFP32X2RS_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP32X2RS.L_q0", FIELD_fld_AE_MULFP32X2RS_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP32X2RAS.L_d1", FIELD_fld_AE_MULFP32X2RAS_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP32X2RAS.L_d0", FIELD_fld_AE_MULFP32X2RAS_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP32X2RAS.L_q0", FIELD_fld_AE_MULFP32X2RAS_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFP32X2RS.L_d1", FIELD_fld_AE_MULAFP32X2RS_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFP32X2RS.L_d0", FIELD_fld_AE_MULAFP32X2RS_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFP32X2RS.L_q0", FIELD_fld_AE_MULAFP32X2RS_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFP32X2RAS.L_d1", FIELD_fld_AE_MULAFP32X2RAS_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFP32X2RAS.L_d0", FIELD_fld_AE_MULAFP32X2RAS_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFP32X2RAS.L_q0", FIELD_fld_AE_MULAFP32X2RAS_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSFP32X2RS.L_d1", FIELD_fld_AE_MULSFP32X2RS_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSFP32X2RS.L_d0", FIELD_fld_AE_MULSFP32X2RS_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSFP32X2RS.L_q0", FIELD_fld_AE_MULSFP32X2RS_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSFP32X2RAS.L_d1", FIELD_fld_AE_MULSFP32X2RAS_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSFP32X2RAS.L_d0", FIELD_fld_AE_MULSFP32X2RAS_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSFP32X2RAS.L_q0", FIELD_fld_AE_MULSFP32X2RAS_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULCR24_d1", FIELD_fld_AE_MULCR24_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULCR24_d0", FIELD_fld_AE_MULCR24_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULCR24_q0", FIELD_fld_AE_MULCR24_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFCR24RA_d1", FIELD_fld_AE_MULFCR24RA_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFCR24RA_d0", FIELD_fld_AE_MULFCR24RA_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFCR24RA_q0", FIELD_fld_AE_MULFCR24RA_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULCR32X16.L_d1", FIELD_fld_AE_MULCR32X16_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULCR32X16.L_d0", FIELD_fld_AE_MULCR32X16_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULCR32X16.L_q0", FIELD_fld_AE_MULCR32X16_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULCR32X16.H_d1", FIELD_fld_AE_MULCR32X16_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULCR32X16.H_d0", FIELD_fld_AE_MULCR32X16_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULCR32X16.H_q0", FIELD_fld_AE_MULCR32X16_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULCI24_d1", FIELD_fld_AE_MULCI24_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULCI24_d0", FIELD_fld_AE_MULCI24_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULCI24_q0", FIELD_fld_AE_MULCI24_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFCI24RA_d1", FIELD_fld_AE_MULFCI24RA_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFCI24RA_d0", FIELD_fld_AE_MULFCI24RA_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFCI24RA_q0", FIELD_fld_AE_MULFCI24RA_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULCI32X16.L_d1", FIELD_fld_AE_MULCI32X16_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULCI32X16.L_d0", FIELD_fld_AE_MULCI32X16_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULCI32X16.L_q0", FIELD_fld_AE_MULCI32X16_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULCI32X16.H_d1", FIELD_fld_AE_MULCI32X16_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULCI32X16.H_d0", FIELD_fld_AE_MULCI32X16_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULCI32X16.H_q0", FIELD_fld_AE_MULCI32X16_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULACR24_d1", FIELD_fld_AE_MULACR24_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULACR24_d0", FIELD_fld_AE_MULACR24_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULACR24_q0", FIELD_fld_AE_MULACR24_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFCR24RA_d1", FIELD_fld_AE_MULAFCR24RA_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFCR24RA_d0", FIELD_fld_AE_MULAFCR24RA_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFCR24RA_q0", FIELD_fld_AE_MULAFCR24RA_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULACR32X16.L_d1", FIELD_fld_AE_MULACR32X16_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULACR32X16.L_d0", FIELD_fld_AE_MULACR32X16_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULACR32X16.L_q0", FIELD_fld_AE_MULACR32X16_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULACR32X16.H_d1", FIELD_fld_AE_MULACR32X16_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULACR32X16.H_d0", FIELD_fld_AE_MULACR32X16_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULACR32X16.H_q0", FIELD_fld_AE_MULACR32X16_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULACI24_d1", FIELD_fld_AE_MULACI24_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULACI24_d0", FIELD_fld_AE_MULACI24_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULACI24_q0", FIELD_fld_AE_MULACI24_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFCI24RA_d1", FIELD_fld_AE_MULAFCI24RA_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFCI24RA_d0", FIELD_fld_AE_MULAFCI24RA_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFCI24RA_q0", FIELD_fld_AE_MULAFCI24RA_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULACI32X16.L_d1", FIELD_fld_AE_MULACI32X16_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULACI32X16.L_d0", FIELD_fld_AE_MULACI32X16_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULACI32X16.L_q0", FIELD_fld_AE_MULACI32X16_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULACI32X16.H_d1", FIELD_fld_AE_MULACI32X16_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULACI32X16.H_d0", FIELD_fld_AE_MULACI32X16_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULACI32X16.H_q0", FIELD_fld_AE_MULACI32X16_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULF16X4SS.H_d0", FIELD_fld_AE_MULF16X4SS_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULF16X4SS.H_d1", FIELD_fld_AE_MULF16X4SS_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULF16X4SS.H_q1", FIELD_fld_AE_MULF16X4SS_H_q1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAF16X4SS.H_d0", FIELD_fld_AE_MULAF16X4SS_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAF16X4SS.H_d1", FIELD_fld_AE_MULAF16X4SS_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAF16X4SS.H_q1", FIELD_fld_AE_MULAF16X4SS_H_q1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSF16X4SS.H_d0", FIELD_fld_AE_MULSF16X4SS_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSF16X4SS.H_d1", FIELD_fld_AE_MULSF16X4SS_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSF16X4SS.H_q1", FIELD_fld_AE_MULSF16X4SS_H_q1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULF16X4SS.L_d0", FIELD_fld_AE_MULF16X4SS_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULF16X4SS.L_d1", FIELD_fld_AE_MULF16X4SS_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULF16X4SS.L_q0", FIELD_fld_AE_MULF16X4SS_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAF16X4SS.L_d0", FIELD_fld_AE_MULAF16X4SS_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAF16X4SS.L_d1", FIELD_fld_AE_MULAF16X4SS_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAF16X4SS.L_q0", FIELD_fld_AE_MULAF16X4SS_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSF16X4SS.L_d0", FIELD_fld_AE_MULSF16X4SS_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSF16X4SS.L_d1", FIELD_fld_AE_MULSF16X4SS_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULSF16X4SS.L_q0", FIELD_fld_AE_MULSF16X4SS_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MUL16X4.H_d0", FIELD_fld_AE_MUL16X4_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MUL16X4.H_d1", FIELD_fld_AE_MUL16X4_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MUL16X4.H_q1", FIELD_fld_AE_MUL16X4_H_q1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULA16X4.H_d0", FIELD_fld_AE_MULA16X4_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULA16X4.H_d1", FIELD_fld_AE_MULA16X4_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULA16X4.H_q1", FIELD_fld_AE_MULA16X4_H_q1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULS16X4.H_d0", FIELD_fld_AE_MULS16X4_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULS16X4.H_d1", FIELD_fld_AE_MULS16X4_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULS16X4.H_q1", FIELD_fld_AE_MULS16X4_H_q1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MUL16X4.L_d0", FIELD_fld_AE_MUL16X4_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MUL16X4.L_d1", FIELD_fld_AE_MUL16X4_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MUL16X4.L_q0", FIELD_fld_AE_MUL16X4_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULA16X4.L_d0", FIELD_fld_AE_MULA16X4_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULA16X4.L_d1", FIELD_fld_AE_MULA16X4_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULA16X4.L_q0", FIELD_fld_AE_MULA16X4_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULS16X4.L_d0", FIELD_fld_AE_MULS16X4_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULS16X4.L_d1", FIELD_fld_AE_MULS16X4_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULS16X4.L_q0", FIELD_fld_AE_MULS16X4_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP16X4S.H_d1", FIELD_fld_AE_MULFP16X4S_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP16X4S.H_d0", FIELD_fld_AE_MULFP16X4S_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP16X4S.H_q0", FIELD_fld_AE_MULFP16X4S_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP16X4RAS.H_d1", FIELD_fld_AE_MULFP16X4RAS_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP16X4RAS.H_d0", FIELD_fld_AE_MULFP16X4RAS_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP16X4RAS.H_q0", FIELD_fld_AE_MULFP16X4RAS_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP16X4S.L_d1", FIELD_fld_AE_MULFP16X4S_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP16X4S.L_d0", FIELD_fld_AE_MULFP16X4S_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP16X4S.L_q0", FIELD_fld_AE_MULFP16X4S_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP16X4RAS.L_d1", FIELD_fld_AE_MULFP16X4RAS_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP16X4RAS.L_d0", FIELD_fld_AE_MULFP16X4RAS_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFP16X4RAS.L_q0", FIELD_fld_AE_MULFP16X4RAS_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_fp_sem_sp32cvt_i_imm5", FIELD_fld_fp_sem_sp32cvt_i_imm5, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa32_encode, OperandSem_opnd_sem_ae_osa32_decode,
    0, 0 },
  { "opnd_fp_sem_sp32cvt_ars", FIELD_fld_fp_sem_sp32cvt_ars, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_AE_MAXABS16S_v1", FIELD_fld_AE_MAXABS16S_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MAXABS16S_v0", FIELD_fld_AE_MAXABS16S_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MAXABS16S_v", FIELD_fld_AE_MAXABS16S_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFC16RAS.H_d1.0", FIELD_fld_AE_MULFC16RAS_H_d1_0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFC16RAS.H_d0.0", FIELD_fld_AE_MULFC16RAS_H_d0_0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFC16RAS.H_q0.0", FIELD_fld_AE_MULFC16RAS_H_q0_0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFC16RAS.L_d1.0", FIELD_fld_AE_MULFC16RAS_L_d1_0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFC16RAS.L_d0.0", FIELD_fld_AE_MULFC16RAS_L_d0_0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFC16RAS.L_q0.0", FIELD_fld_AE_MULFC16RAS_L_q0_0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFC16RAS.H_d1.0", FIELD_fld_AE_MULAFC16RAS_H_d1_0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFC16RAS.H_d0.0", FIELD_fld_AE_MULAFC16RAS_H_d0_0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFC16RAS.H_q0.0", FIELD_fld_AE_MULAFC16RAS_H_q0_0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFC16RAS.L_d1.0", FIELD_fld_AE_MULAFC16RAS_L_d1_0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFC16RAS.L_d0.0", FIELD_fld_AE_MULAFC16RAS_L_d0_0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFC16RAS.L_q0.0", FIELD_fld_AE_MULAFC16RAS_L_q0_0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFC16RAS.H_d1", FIELD_fld_AE_MULFC16RAS_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFC16RAS.H_d0", FIELD_fld_AE_MULFC16RAS_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFC16RAS.H_q0", FIELD_fld_AE_MULFC16RAS_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFC16RAS.L_d1", FIELD_fld_AE_MULFC16RAS_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFC16RAS.L_d0", FIELD_fld_AE_MULFC16RAS_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULFC16RAS.L_q0", FIELD_fld_AE_MULFC16RAS_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFC16RAS.H_d1", FIELD_fld_AE_MULAFC16RAS_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFC16RAS.H_d0", FIELD_fld_AE_MULAFC16RAS_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFC16RAS.H_q0", FIELD_fld_AE_MULAFC16RAS_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFC16RAS.L_d1", FIELD_fld_AE_MULAFC16RAS_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFC16RAS.L_d0", FIELD_fld_AE_MULAFC16RAS_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAFC16RAS.L_q0", FIELD_fld_AE_MULAFC16RAS_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULZAAAAQ16_d1", FIELD_fld_AE_MULZAAAAQ16_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULZAAAAQ16_d0", FIELD_fld_AE_MULZAAAAQ16_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULZAAAAQ16_q0", FIELD_fld_AE_MULZAAAAQ16_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAAAAQ16_d1", FIELD_fld_AE_MULAAAAQ16_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAAAAQ16_d0", FIELD_fld_AE_MULAAAAQ16_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAAAAQ16_q0", FIELD_fld_AE_MULAAAAQ16_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULC16S.L_d1", FIELD_fld_AE_MULC16S_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULC16S.L_d0", FIELD_fld_AE_MULC16S_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULC16S.L_q0", FIELD_fld_AE_MULC16S_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULC16S.H_d1", FIELD_fld_AE_MULC16S_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULC16S.H_d0", FIELD_fld_AE_MULC16S_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULC16S.H_q0", FIELD_fld_AE_MULC16S_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAC16S.L_d1", FIELD_fld_AE_MULAC16S_L_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAC16S.L_d0", FIELD_fld_AE_MULAC16S_L_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAC16S.L_q0", FIELD_fld_AE_MULAC16S_L_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAC16S.H_d1", FIELD_fld_AE_MULAC16S_H_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAC16S.H_d0", FIELD_fld_AE_MULAC16S_H_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MULAC16S.H_q0", FIELD_fld_AE_MULAC16S_H_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_ADDANDSUBRNG16RAS_S1_vs", FIELD_fld_AE_ADDANDSUBRNG16RAS_S1_vs, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_ADDANDSUBRNG16RAS_S1_va", FIELD_fld_AE_ADDANDSUBRNG16RAS_S1_va, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_ADDANDSUBRNG16RAS_S2_vs", FIELD_fld_AE_ADDANDSUBRNG16RAS_S2_vs, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_ADDANDSUBRNG16RAS_S2_va", FIELD_fld_AE_ADDANDSUBRNG16RAS_S2_va, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_CALCRNG3_a", FIELD_fld_AE_CALCRNG3_a, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0 },
  { "opnd_ae_sem_arithmetic_va", FIELD_fld_ae_sem_arithmetic_va, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_arithmetic_vs", FIELD_fld_ae_sem_arithmetic_vs, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MOVFUSIONMISCV_v", FIELD_fld_AE_MOVFUSIONMISCV_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_movstate1_v", FIELD_fld_ae_sem_movstate1_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_ae_sem_movstate2_v", FIELD_fld_ae_sem_movstate2_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MOVVFUSIONMISC_v", FIELD_fld_AE_MOVVFUSIONMISC_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "frr", FIELD_r, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "frr1", FIELD_r, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "frs", FIELD_s, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "frt", FIELD_t, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "imm_s", FIELD_s, -1, 0,
    0,
    OperandSem_opnd_sem_imm_s_encode, OperandSem_opnd_sem_imm_s_decode,
    0, 0 },
  { "imm8x4", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_imm8x4_encode, OperandSem_opnd_sem_imm8x4_decode,
    0, 0 },
  { "imm8x8", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_imm8x8_encode, OperandSem_opnd_sem_imm8x8_decode,
    0, 0 },
  { "opnd_AE_MOVFCRFSRV_v", FIELD_fld_AE_MOVFCRFSRV_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_AE_MOVVFCRFSR_v", FIELD_fld_AE_MOVVFCRFSR_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "opnd_fp_sem_movfpstate_v", FIELD_fld_fp_sem_movfpstate_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_ar_to_dr_v", FIELD_ae_fld_ar_to_dr_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_ls_uu", FIELD_ae_fld_ls_uu, REGFILE_AE_VALIGN, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_VALIGN_encode, OperandSem_opnd_sem_AE_VALIGN_decode,
    0, 0 },
  { "ae_ls_su", FIELD_ae_fld_ls_su, REGFILE_AE_VALIGN, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_VALIGN_encode, OperandSem_opnd_sem_AE_VALIGN_decode,
    0, 0 },
  { "ae_uu_v", FIELD_ae_fld_uu_v, REGFILE_AE_VALIGN, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_VALIGN_encode, OperandSem_opnd_sem_AE_VALIGN_decode,
    0, 0 },
  { "ae_uu_uu", FIELD_ae_fld_uu_uu, REGFILE_AE_VALIGN, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_VALIGN_encode, OperandSem_opnd_sem_AE_VALIGN_decode,
    0, 0 },
  { "ae_cmpp_v0", FIELD_ae_fld_cmpp_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_cmpp_v1", FIELD_ae_fld_cmpp_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_cmpp_v", FIELD_ae_fld_cmpp_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_ls_v", FIELD_ae_fld_ls_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_ls_av", FIELD_ae_fld_ls_av, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_ls_v1", FIELD_ae_fld_ls_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_ls_v2", FIELD_ae_fld_ls_v2, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_arth_v", FIELD_ae_fld_arth_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_arth_v0", FIELD_ae_fld_arth_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_arth_v1", FIELD_ae_fld_arth_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_cmov_v", FIELD_ae_fld_cmov_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_cmov_v0", FIELD_ae_fld_cmov_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_shift_d", FIELD_ae_fld_shift_d, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_shift_d0", FIELD_ae_fld_shift_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "ae_shift_sd", FIELD_ae_fld_shift_sd, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0 },
  { "bitindex", FIELD_bitindex, -1, 0,
    0,
    OperandSem_opnd_sem_bitindex_encode, OperandSem_opnd_sem_bitindex_decode,
    0, 0 },
  { "t", FIELD_t, -1, 0, 0, 0, 0, 0, 0 },
  { "bbi4", FIELD_bbi4, -1, 0, 0, 0, 0, 0, 0 },
  { "imm12", FIELD_imm12, -1, 0, 0, 0, 0, 0, 0 },
  { "imm8", FIELD_imm8, -1, 0, 0, 0, 0, 0, 0 },
  { "imm12b", FIELD_imm12b, -1, 0, 0, 0, 0, 0, 0 },
  { "imm16", FIELD_imm16, -1, 0, 0, 0, 0, 0, 0 },
  { "m", FIELD_m, -1, 0, 0, 0, 0, 0, 0 },
  { "n", FIELD_n, -1, 0, 0, 0, 0, 0, 0 },
  { "offset", FIELD_offset, -1, 0, 0, 0, 0, 0, 0 },
  { "op0", FIELD_op0, -1, 0, 0, 0, 0, 0, 0 },
  { "op1", FIELD_op1, -1, 0, 0, 0, 0, 0, 0 },
  { "op2", FIELD_op2, -1, 0, 0, 0, 0, 0, 0 },
  { "r", FIELD_r, -1, 0, 0, 0, 0, 0, 0 },
  { "r_disp", FIELD_r_disp, -1, 0, 0, 0, 0, 0, 0 },
  { "r_3", FIELD_r_3, -1, 0, 0, 0, 0, 0, 0 },
  { "sa4", FIELD_sa4, -1, 0, 0, 0, 0, 0, 0 },
  { "sae4", FIELD_sae4, -1, 0, 0, 0, 0, 0, 0 },
  { "sal", FIELD_sal, -1, 0, 0, 0, 0, 0, 0 },
  { "sas4", FIELD_sas4, -1, 0, 0, 0, 0, 0, 0 },
  { "sr", FIELD_sr, -1, 0, 0, 0, 0, 0, 0 },
  { "st", FIELD_st, -1, 0, 0, 0, 0, 0, 0 },
  { "thi3", FIELD_thi3, -1, 0, 0, 0, 0, 0, 0 },
  { "imm4", FIELD_imm4, -1, 0, 0, 0, 0, 0, 0 },
  { "mn", FIELD_mn, -1, 0, 0, 0, 0, 0, 0 },
  { "i", FIELD_i, -1, 0, 0, 0, 0, 0, 0 },
  { "imm6lo", FIELD_imm6lo, -1, 0, 0, 0, 0, 0, 0 },
  { "imm6hi", FIELD_imm6hi, -1, 0, 0, 0, 0, 0, 0 },
  { "imm7lo", FIELD_imm7lo, -1, 0, 0, 0, 0, 0, 0 },
  { "imm7hi", FIELD_imm7hi, -1, 0, 0, 0, 0, 0, 0 },
  { "z", FIELD_z, -1, 0, 0, 0, 0, 0, 0 },
  { "imm6", FIELD_imm6, -1, 0, 0, 0, 0, 0, 0 },
  { "imm7", FIELD_imm7, -1, 0, 0, 0, 0, 0, 0 },
  { "r3", FIELD_r3, -1, 0, 0, 0, 0, 0, 0 },
  { "rbit2", FIELD_rbit2, -1, 0, 0, 0, 0, 0, 0 },
  { "rhi", FIELD_rhi, -1, 0, 0, 0, 0, 0, 0 },
  { "t3", FIELD_t3, -1, 0, 0, 0, 0, 0, 0 },
  { "tbit2", FIELD_tbit2, -1, 0, 0, 0, 0, 0, 0 },
  { "tlo", FIELD_tlo, -1, 0, 0, 0, 0, 0, 0 },
  { "w", FIELD_w, -1, 0, 0, 0, 0, 0, 0 },
  { "y", FIELD_y, -1, 0, 0, 0, 0, 0, 0 },
  { "x", FIELD_x, -1, 0, 0, 0, 0, 0, 0 },
  { "t2", FIELD_t2, -1, 0, 0, 0, 0, 0, 0 },
  { "s2", FIELD_s2, -1, 0, 0, 0, 0, 0, 0 },
  { "r2", FIELD_r2, -1, 0, 0, 0, 0, 0, 0 },
  { "t4", FIELD_t4, -1, 0, 0, 0, 0, 0, 0 },
  { "s4", FIELD_s4, -1, 0, 0, 0, 0, 0, 0 },
  { "r4", FIELD_r4, -1, 0, 0, 0, 0, 0, 0 },
  { "t8", FIELD_t8, -1, 0, 0, 0, 0, 0, 0 },
  { "s8", FIELD_s8, -1, 0, 0, 0, 0, 0, 0 },
  { "r8", FIELD_r8, -1, 0, 0, 0, 0, 0, 0 },
  { "xt_wbr15_imm", FIELD_xt_wbr15_imm, -1, 0, 0, 0, 0, 0, 0 },
  { "xt_wbr18_imm", FIELD_xt_wbr18_imm, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_fhba4", FIELD_ae_fld_fhba4, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_fhba4_2", FIELD_ae_fld_fhba4_2, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_tp7", FIELD_ae_fld_tp7, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_osa32", FIELD_ae_fld_osa32, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_osa64", FIELD_ae_fld_osa64, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_imm2", FIELD_ae_fld_imm2, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_immls64", FIELD_ae_fld_immls64, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_immls64pos", FIELD_ae_fld_immls64pos, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_immls32", FIELD_ae_fld_immls32, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_immls16", FIELD_ae_fld_immls16, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_osa16", FIELD_ae_fld_osa16, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_15_12", FIELD_Inst_15_12, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_11_8", FIELD_Inst_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_7_4", FIELD_Inst_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_12", FIELD_Inst_12, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_7", FIELD_Inst_7, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_5_4", FIELD_Inst_5_4, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_7_6", FIELD_Inst_7_6, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_19_17", FIELD_Inst_19_17, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_19_18", FIELD_Inst_19_18, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_9_8", FIELD_Inst_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_4", FIELD_Inst_4, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ls_v", FIELD_ae_fld_ls_v, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ls_uu", FIELD_ae_fld_ls_uu, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ls_su", FIELD_ae_fld_ls_su, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ls_av", FIELD_ae_fld_ls_av, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ls_v1", FIELD_ae_fld_ls_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ls_v2", FIELD_ae_fld_ls_v2, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_cmpp_v0", FIELD_ae_fld_cmpp_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_cmpp_v1", FIELD_ae_fld_cmpp_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_cmpp_v", FIELD_ae_fld_cmpp_v, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_uu_v", FIELD_ae_fld_uu_v, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_uu_uu", FIELD_ae_fld_uu_uu, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_dr_to_ar_v0", FIELD_ae_fld_dr_to_ar_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_cmov_v", FIELD_ae_fld_cmov_v, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_cmov_v0", FIELD_ae_fld_cmov_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_pks_d", FIELD_ae_fld_pks_d, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_pks_s", FIELD_ae_fld_pks_s, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_shift_d", FIELD_ae_fld_shift_d, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_shift_d0", FIELD_ae_fld_shift_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_shift_sd", FIELD_ae_fld_shift_sd, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_dr_to_dr_v", FIELD_ae_fld_dr_to_dr_v, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_dr_to_dr_v0", FIELD_ae_fld_dr_to_dr_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_dr_to_dr_v1", FIELD_ae_fld_dr_to_dr_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_to_dr_v", FIELD_ae_fld_to_dr_v, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_to_dr_v0", FIELD_ae_fld_to_dr_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_selimm", FIELD_ae_fld_selimm, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ar_to_dr_imm", FIELD_fld_ar_to_dr_imm, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_stage3_ar_operand", FIELD_fld_stage3_ar_operand, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_lsip", FIELD_fld_lsip, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_Inst16b_12", FIELD_ae_fld_Inst16b_12, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_Inst16b_15_13", FIELD_ae_fld_Inst16b_15_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_L8X4F.X_x", FIELD_fld_AE_L8X4F_X_x, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_L8X4F.X_a", FIELD_fld_AE_L8X4F_X_a, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_L8X4F.X_v", FIELD_fld_AE_L8X4F_X_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_L8X4F.XP_x", FIELD_fld_AE_L8X4F_XP_x, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_L8X4F.XP_a", FIELD_fld_AE_L8X4F_XP_a, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_L8X4F.XP_v", FIELD_fld_AE_L8X4F_XP_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_pks_s", FIELD_fld_ae_sem_pks_s, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_pks_d", FIELD_fld_ae_sem_pks_d, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_ZEROB_v1", FIELD_fld_AE_ZEROB_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_ZEROB_v0", FIELD_fld_AE_ZEROB_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_22_6", FIELD_fld_fusion_slot0_22_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_22_8", FIELD_fld_fusion_slot0_22_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot1_20_16", FIELD_fld_fusion_slot1_20_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_11_8", FIELD_fld_fusion_slot0_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_11_9", FIELD_fld_fusion_slot0_11_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_7_4", FIELD_fld_fusion_slot0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_22_16", FIELD_fld_fusion_slot0_22_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_22_17", FIELD_fld_fusion_slot0_22_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_22_18", FIELD_fld_fusion_slot0_22_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_22_4", FIELD_fld_fusion_slot0_22_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_22_20", FIELD_fld_fusion_slot0_22_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_22_0", FIELD_fld_fusion_slot0_22_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot1_20_0", FIELD_fld_fusion_slot1_20_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot1_3_0", FIELD_fld_fusion_slot1_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_22_13", FIELD_fld_fusion_slot0_22_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot1_20_13", FIELD_fld_fusion_slot1_20_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_8_4", FIELD_fld_fusion_slot0_8_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_22_10", FIELD_fld_fusion_slot0_22_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_8_8", FIELD_fld_fusion_slot0_8_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_11_4", FIELD_fld_fusion_slot0_11_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_22_12", FIELD_fld_fusion_slot0_22_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_v", FIELD_fld_ae_sem_loads_stores_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_av", FIELD_fld_ae_sem_loads_stores_av, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_v1", FIELD_fld_ae_sem_loads_stores_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot1_1_0", FIELD_fld_fusion_slot1_1_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_cmov_v0", FIELD_fld_ae_sem_cmov_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_cmov_v", FIELD_fld_ae_sem_cmov_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_ar_to_dr_a0", FIELD_fld_ae_sem_ar_to_dr_a0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_ar_to_dr_v", FIELD_fld_ae_sem_ar_to_dr_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_ar_to_dr_a1", FIELD_fld_ae_sem_ar_to_dr_a1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_to_dr_v0", FIELD_fld_ae_sem_to_dr_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_to_dr_v", FIELD_fld_ae_sem_to_dr_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_a0", FIELD_fld_ae_sem_shift_a0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_sd", FIELD_fld_ae_sem_shift_sd, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_d0", FIELD_fld_ae_sem_shift_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_d", FIELD_fld_ae_sem_shift_d, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot1_20_8", FIELD_fld_fusion_slot1_20_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_dr_v0", FIELD_fld_ae_sem_dr_to_dr_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_dr_v", FIELD_fld_ae_sem_dr_to_dr_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_ar_v0", FIELD_fld_ae_sem_dr_to_ar_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_ar_a", FIELD_fld_ae_sem_dr_to_ar_a, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_v0", FIELD_fld_ae_sem_arithmetic_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_v1", FIELD_fld_ae_sem_arithmetic_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_v", FIELD_fld_ae_sem_arithmetic_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot1_7_4", FIELD_fld_fusion_slot1_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot1_9_8", FIELD_fld_fusion_slot1_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_cmpp_v1", FIELD_fld_ae_sem_cmpp_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_cmpp_v0", FIELD_fld_ae_sem_cmpp_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot1_8_8", FIELD_fld_fusion_slot1_8_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_cmpp_v", FIELD_fld_ae_sem_cmpp_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_dr_v1", FIELD_fld_ae_sem_dr_to_dr_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot1_20_12", FIELD_fld_fusion_slot1_20_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x2_S1_d1", FIELD_fld_ae_sem_mul_x2_S1_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x2_S1_d0", FIELD_fld_ae_sem_mul_x2_S1_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x2_S1_q0", FIELD_fld_ae_sem_mul_x2_S1_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x2_S1_q1", FIELD_fld_ae_sem_mul_x2_S1_q1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x2_S1_d2", FIELD_fld_ae_sem_mul_x2_S1_d2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_11_10", FIELD_fld_fusion_slot0_11_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot1_7_6", FIELD_fld_fusion_slot1_7_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_5_4", FIELD_fld_fusion_slot0_5_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_22_14", FIELD_fld_fusion_slot0_22_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_7_7", FIELD_fld_fusion_slot0_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_11_6", FIELD_fld_fusion_slot0_11_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot1_0_0", FIELD_fld_fusion_slot1_0_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_3_0", FIELD_fld_fusion_slot0_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_7_0", FIELD_fld_fusion_slot0_7_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_7_5", FIELD_fld_fusion_slot0_7_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_7_6", FIELD_fld_fusion_slot0_7_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot0_22_9", FIELD_fld_fusion_slot0_22_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_v2", FIELD_fld_ae_sem_loads_stores_v2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_9_8", FIELD_fld_Inst_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_19_12", FIELD_fld_Inst_19_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_23_16", FIELD_fld_Inst_23_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_12_8", FIELD_fld_Inst_12_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_11_8", FIELD_fld_Inst_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_7_0", FIELD_fld_Inst_7_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_3_0", FIELD_fld_Inst_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_19_16", FIELD_fld_Inst_19_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot40_27_12", FIELD_fld_fusion_slot40_27_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot40_27_18", FIELD_fld_fusion_slot40_27_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot40_7_4", FIELD_fld_fusion_slot40_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot40_27_24", FIELD_fld_fusion_slot40_27_24, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot40_27_23", FIELD_fld_fusion_slot40_27_23, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot40_2_0", FIELD_fld_fusion_slot40_2_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot40_27_3", FIELD_fld_fusion_slot40_27_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot40_27_16", FIELD_fld_fusion_slot40_27_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFCR32X16RAS.L_d1", FIELD_fld_AE_MULFCR32X16RAS_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFCR32X16RAS.L_d0", FIELD_fld_AE_MULFCR32X16RAS_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFCR32X16RAS.L_q0", FIELD_fld_AE_MULFCR32X16RAS_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFCR32X16RAS.H_d1", FIELD_fld_AE_MULFCR32X16RAS_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFCR32X16RAS.H_d0", FIELD_fld_AE_MULFCR32X16RAS_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFCR32X16RAS.H_q0", FIELD_fld_AE_MULFCR32X16RAS_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFCR32X16RAS.L_d1", FIELD_fld_AE_MULAFCR32X16RAS_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFCR32X16RAS.L_d0", FIELD_fld_AE_MULAFCR32X16RAS_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFCR32X16RAS.L_q0", FIELD_fld_AE_MULAFCR32X16RAS_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFCR32X16RAS.H_d1", FIELD_fld_AE_MULAFCR32X16RAS_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFCR32X16RAS.H_d0", FIELD_fld_AE_MULAFCR32X16RAS_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFCR32X16RAS.H_q0", FIELD_fld_AE_MULAFCR32X16RAS_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFCI32X16RAS.L_d1", FIELD_fld_AE_MULFCI32X16RAS_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFCI32X16RAS.L_d0", FIELD_fld_AE_MULFCI32X16RAS_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFCI32X16RAS.L_q0", FIELD_fld_AE_MULFCI32X16RAS_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFCI32X16RAS.H_d1", FIELD_fld_AE_MULFCI32X16RAS_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFCI32X16RAS.H_d0", FIELD_fld_AE_MULFCI32X16RAS_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFCI32X16RAS.H_q0", FIELD_fld_AE_MULFCI32X16RAS_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFCI32X16RAS.L_d1", FIELD_fld_AE_MULAFCI32X16RAS_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFCI32X16RAS.L_d0", FIELD_fld_AE_MULAFCI32X16RAS_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFCI32X16RAS.L_q0", FIELD_fld_AE_MULAFCI32X16RAS_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFCI32X16RAS.H_d1", FIELD_fld_AE_MULAFCI32X16RAS_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFCI32X16RAS.H_d0", FIELD_fld_AE_MULAFCI32X16RAS_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFCI32X16RAS.H_q0", FIELD_fld_AE_MULAFCI32X16RAS_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULP32X2.H_d1", FIELD_fld_AE_MULP32X2_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULP32X2.H_d0", FIELD_fld_AE_MULP32X2_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULP32X2.H_q0", FIELD_fld_AE_MULP32X2_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAP32X2.H_d1", FIELD_fld_AE_MULAP32X2_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAP32X2.H_d0", FIELD_fld_AE_MULAP32X2_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAP32X2.H_q0", FIELD_fld_AE_MULAP32X2_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSP32X2.H_d1", FIELD_fld_AE_MULSP32X2_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSP32X2.H_d0", FIELD_fld_AE_MULSP32X2_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSP32X2.H_q0", FIELD_fld_AE_MULSP32X2_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULP32X2.L_d1", FIELD_fld_AE_MULP32X2_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULP32X2.L_d0", FIELD_fld_AE_MULP32X2_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULP32X2.L_q0", FIELD_fld_AE_MULP32X2_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAP32X2.L_d1", FIELD_fld_AE_MULAP32X2_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAP32X2.L_d0", FIELD_fld_AE_MULAP32X2_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAP32X2.L_q0", FIELD_fld_AE_MULAP32X2_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSP32X2.L_d1", FIELD_fld_AE_MULSP32X2_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSP32X2.L_d0", FIELD_fld_AE_MULSP32X2_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSP32X2.L_q0", FIELD_fld_AE_MULSP32X2_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x2_S1_d2.0", FIELD_fld_ae_sem_mul_x2_S1_d2_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x2_S1_d3", FIELD_fld_ae_sem_mul_x2_S1_d3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot_fir_0_14_0", FIELD_fld_fusion_slot_fir_0_14_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot_fir_1_18_0", FIELD_fld_fusion_slot_fir_1_18_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot_fir_1_18_16", FIELD_fld_fusion_slot_fir_1_18_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot_fir_0_14_12", FIELD_fld_fusion_slot_fir_0_14_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot_fir_0_7_7", FIELD_fld_fusion_slot_fir_0_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot_fir_0_7_6", FIELD_fld_fusion_slot_fir_0_7_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP32X2RS.H_d1", FIELD_fld_AE_MULFP32X2RS_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP32X2RS.H_d0", FIELD_fld_AE_MULFP32X2RS_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP32X2RS.H_q0", FIELD_fld_AE_MULFP32X2RS_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP32X2RAS.H_d1", FIELD_fld_AE_MULFP32X2RAS_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP32X2RAS.H_d0", FIELD_fld_AE_MULFP32X2RAS_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP32X2RAS.H_q0", FIELD_fld_AE_MULFP32X2RAS_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFP32X2RS.H_d1", FIELD_fld_AE_MULAFP32X2RS_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFP32X2RS.H_d0", FIELD_fld_AE_MULAFP32X2RS_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFP32X2RS.H_q0", FIELD_fld_AE_MULAFP32X2RS_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFP32X2RAS.H_d1", FIELD_fld_AE_MULAFP32X2RAS_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFP32X2RAS.H_d0", FIELD_fld_AE_MULAFP32X2RAS_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFP32X2RAS.H_q0", FIELD_fld_AE_MULAFP32X2RAS_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSFP32X2RS.H_d1", FIELD_fld_AE_MULSFP32X2RS_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSFP32X2RS.H_d0", FIELD_fld_AE_MULSFP32X2RS_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSFP32X2RS.H_q0", FIELD_fld_AE_MULSFP32X2RS_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSFP32X2RAS.H_d1", FIELD_fld_AE_MULSFP32X2RAS_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSFP32X2RAS.H_d0", FIELD_fld_AE_MULSFP32X2RAS_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSFP32X2RAS.H_q0", FIELD_fld_AE_MULSFP32X2RAS_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP32X2RS.L_d1", FIELD_fld_AE_MULFP32X2RS_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP32X2RS.L_d0", FIELD_fld_AE_MULFP32X2RS_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP32X2RS.L_q0", FIELD_fld_AE_MULFP32X2RS_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP32X2RAS.L_d1", FIELD_fld_AE_MULFP32X2RAS_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP32X2RAS.L_d0", FIELD_fld_AE_MULFP32X2RAS_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP32X2RAS.L_q0", FIELD_fld_AE_MULFP32X2RAS_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFP32X2RS.L_d1", FIELD_fld_AE_MULAFP32X2RS_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFP32X2RS.L_d0", FIELD_fld_AE_MULAFP32X2RS_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFP32X2RS.L_q0", FIELD_fld_AE_MULAFP32X2RS_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFP32X2RAS.L_d1", FIELD_fld_AE_MULAFP32X2RAS_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFP32X2RAS.L_d0", FIELD_fld_AE_MULAFP32X2RAS_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFP32X2RAS.L_q0", FIELD_fld_AE_MULAFP32X2RAS_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSFP32X2RS.L_d1", FIELD_fld_AE_MULSFP32X2RS_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSFP32X2RS.L_d0", FIELD_fld_AE_MULSFP32X2RS_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSFP32X2RS.L_q0", FIELD_fld_AE_MULSFP32X2RS_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSFP32X2RAS.L_d1", FIELD_fld_AE_MULSFP32X2RAS_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSFP32X2RAS.L_d0", FIELD_fld_AE_MULSFP32X2RAS_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSFP32X2RAS.L_q0", FIELD_fld_AE_MULSFP32X2RAS_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULCR24_d1", FIELD_fld_AE_MULCR24_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULCR24_d0", FIELD_fld_AE_MULCR24_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULCR24_q0", FIELD_fld_AE_MULCR24_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFCR24RA_d1", FIELD_fld_AE_MULFCR24RA_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFCR24RA_d0", FIELD_fld_AE_MULFCR24RA_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFCR24RA_q0", FIELD_fld_AE_MULFCR24RA_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULCR32X16.L_d1", FIELD_fld_AE_MULCR32X16_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULCR32X16.L_d0", FIELD_fld_AE_MULCR32X16_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULCR32X16.L_q0", FIELD_fld_AE_MULCR32X16_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULCR32X16.H_d1", FIELD_fld_AE_MULCR32X16_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULCR32X16.H_d0", FIELD_fld_AE_MULCR32X16_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULCR32X16.H_q0", FIELD_fld_AE_MULCR32X16_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULCI24_d1", FIELD_fld_AE_MULCI24_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULCI24_d0", FIELD_fld_AE_MULCI24_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULCI24_q0", FIELD_fld_AE_MULCI24_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFCI24RA_d1", FIELD_fld_AE_MULFCI24RA_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFCI24RA_d0", FIELD_fld_AE_MULFCI24RA_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFCI24RA_q0", FIELD_fld_AE_MULFCI24RA_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULCI32X16.L_d1", FIELD_fld_AE_MULCI32X16_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULCI32X16.L_d0", FIELD_fld_AE_MULCI32X16_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULCI32X16.L_q0", FIELD_fld_AE_MULCI32X16_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULCI32X16.H_d1", FIELD_fld_AE_MULCI32X16_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULCI32X16.H_d0", FIELD_fld_AE_MULCI32X16_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULCI32X16.H_q0", FIELD_fld_AE_MULCI32X16_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULACR24_d1", FIELD_fld_AE_MULACR24_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULACR24_d0", FIELD_fld_AE_MULACR24_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULACR24_q0", FIELD_fld_AE_MULACR24_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFCR24RA_d1", FIELD_fld_AE_MULAFCR24RA_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFCR24RA_d0", FIELD_fld_AE_MULAFCR24RA_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFCR24RA_q0", FIELD_fld_AE_MULAFCR24RA_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULACR32X16.L_d1", FIELD_fld_AE_MULACR32X16_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULACR32X16.L_d0", FIELD_fld_AE_MULACR32X16_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULACR32X16.L_q0", FIELD_fld_AE_MULACR32X16_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULACR32X16.H_d1", FIELD_fld_AE_MULACR32X16_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULACR32X16.H_d0", FIELD_fld_AE_MULACR32X16_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULACR32X16.H_q0", FIELD_fld_AE_MULACR32X16_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULACI24_d1", FIELD_fld_AE_MULACI24_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULACI24_d0", FIELD_fld_AE_MULACI24_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULACI24_q0", FIELD_fld_AE_MULACI24_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFCI24RA_d1", FIELD_fld_AE_MULAFCI24RA_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFCI24RA_d0", FIELD_fld_AE_MULAFCI24RA_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFCI24RA_q0", FIELD_fld_AE_MULAFCI24RA_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULACI32X16.L_d1", FIELD_fld_AE_MULACI32X16_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULACI32X16.L_d0", FIELD_fld_AE_MULACI32X16_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULACI32X16.L_q0", FIELD_fld_AE_MULACI32X16_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULACI32X16.H_d1", FIELD_fld_AE_MULACI32X16_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULACI32X16.H_d0", FIELD_fld_AE_MULACI32X16_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULACI32X16.H_q0", FIELD_fld_AE_MULACI32X16_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULF16X4SS.H_d0", FIELD_fld_AE_MULF16X4SS_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULF16X4SS.H_d1", FIELD_fld_AE_MULF16X4SS_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULF16X4SS.H_q1", FIELD_fld_AE_MULF16X4SS_H_q1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAF16X4SS.H_d0", FIELD_fld_AE_MULAF16X4SS_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAF16X4SS.H_d1", FIELD_fld_AE_MULAF16X4SS_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAF16X4SS.H_q1", FIELD_fld_AE_MULAF16X4SS_H_q1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSF16X4SS.H_d0", FIELD_fld_AE_MULSF16X4SS_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSF16X4SS.H_d1", FIELD_fld_AE_MULSF16X4SS_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSF16X4SS.H_q1", FIELD_fld_AE_MULSF16X4SS_H_q1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULF16X4SS.L_d0", FIELD_fld_AE_MULF16X4SS_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULF16X4SS.L_d1", FIELD_fld_AE_MULF16X4SS_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULF16X4SS.L_q0", FIELD_fld_AE_MULF16X4SS_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAF16X4SS.L_d0", FIELD_fld_AE_MULAF16X4SS_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAF16X4SS.L_d1", FIELD_fld_AE_MULAF16X4SS_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAF16X4SS.L_q0", FIELD_fld_AE_MULAF16X4SS_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSF16X4SS.L_d0", FIELD_fld_AE_MULSF16X4SS_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSF16X4SS.L_d1", FIELD_fld_AE_MULSF16X4SS_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULSF16X4SS.L_q0", FIELD_fld_AE_MULSF16X4SS_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MUL16X4.H_d0", FIELD_fld_AE_MUL16X4_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MUL16X4.H_d1", FIELD_fld_AE_MUL16X4_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MUL16X4.H_q1", FIELD_fld_AE_MUL16X4_H_q1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULA16X4.H_d0", FIELD_fld_AE_MULA16X4_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULA16X4.H_d1", FIELD_fld_AE_MULA16X4_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULA16X4.H_q1", FIELD_fld_AE_MULA16X4_H_q1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULS16X4.H_d0", FIELD_fld_AE_MULS16X4_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULS16X4.H_d1", FIELD_fld_AE_MULS16X4_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULS16X4.H_q1", FIELD_fld_AE_MULS16X4_H_q1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MUL16X4.L_d0", FIELD_fld_AE_MUL16X4_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MUL16X4.L_d1", FIELD_fld_AE_MUL16X4_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MUL16X4.L_q0", FIELD_fld_AE_MUL16X4_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULA16X4.L_d0", FIELD_fld_AE_MULA16X4_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULA16X4.L_d1", FIELD_fld_AE_MULA16X4_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULA16X4.L_q0", FIELD_fld_AE_MULA16X4_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULS16X4.L_d0", FIELD_fld_AE_MULS16X4_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULS16X4.L_d1", FIELD_fld_AE_MULS16X4_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULS16X4.L_q0", FIELD_fld_AE_MULS16X4_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP16X4S.H_d1", FIELD_fld_AE_MULFP16X4S_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP16X4S.H_d0", FIELD_fld_AE_MULFP16X4S_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP16X4S.H_q0", FIELD_fld_AE_MULFP16X4S_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP16X4RAS.H_d1", FIELD_fld_AE_MULFP16X4RAS_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP16X4RAS.H_d0", FIELD_fld_AE_MULFP16X4RAS_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP16X4RAS.H_q0", FIELD_fld_AE_MULFP16X4RAS_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP16X4S.L_d1", FIELD_fld_AE_MULFP16X4S_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP16X4S.L_d0", FIELD_fld_AE_MULFP16X4S_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP16X4S.L_q0", FIELD_fld_AE_MULFP16X4S_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP16X4RAS.L_d1", FIELD_fld_AE_MULFP16X4RAS_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP16X4RAS.L_d0", FIELD_fld_AE_MULFP16X4RAS_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFP16X4RAS.L_q0", FIELD_fld_AE_MULFP16X4RAS_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fp_sem_sp32cvt_arr", FIELD_fld_fp_sem_sp32cvt_arr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fp_sem_sp32cvt_i_imm5", FIELD_fld_fp_sem_sp32cvt_i_imm5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fp_sem_sp32cvt_ars", FIELD_fld_fp_sem_sp32cvt_ars, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MAXABS16S_v1", FIELD_fld_AE_MAXABS16S_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MAXABS16S_v0", FIELD_fld_AE_MAXABS16S_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MAXABS16S_v", FIELD_fld_AE_MAXABS16S_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot40_0_14_0", FIELD_fld_fusion_slot40_0_14_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot40_0_7_7", FIELD_fld_fusion_slot40_0_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot40_0_14_12", FIELD_fld_fusion_slot40_0_14_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot40_1_9_0", FIELD_fld_fusion_slot40_1_9_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot40_1_9_8", FIELD_fld_fusion_slot40_1_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_ADDANDSUBRNG16RAS_S1_vs", FIELD_fld_AE_ADDANDSUBRNG16RAS_S1_vs, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_ADDANDSUBRNG16RAS_S1_va", FIELD_fld_AE_ADDANDSUBRNG16RAS_S1_va, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_ADDANDSUBRNG16RAS_S2_vs", FIELD_fld_AE_ADDANDSUBRNG16RAS_S2_vs, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_ADDANDSUBRNG16RAS_S2_va", FIELD_fld_AE_ADDANDSUBRNG16RAS_S2_va, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_va", FIELD_fld_ae_sem_arithmetic_va, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_vs", FIELD_fld_ae_sem_arithmetic_vs, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFC16RAS.H_d1.0", FIELD_fld_AE_MULFC16RAS_H_d1_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFC16RAS.H_d0.0", FIELD_fld_AE_MULFC16RAS_H_d0_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFC16RAS.H_q0.0", FIELD_fld_AE_MULFC16RAS_H_q0_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFC16RAS.L_d1.0", FIELD_fld_AE_MULFC16RAS_L_d1_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFC16RAS.L_d0.0", FIELD_fld_AE_MULFC16RAS_L_d0_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFC16RAS.L_q0.0", FIELD_fld_AE_MULFC16RAS_L_q0_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFC16RAS.H_d1.0", FIELD_fld_AE_MULAFC16RAS_H_d1_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFC16RAS.H_d0.0", FIELD_fld_AE_MULAFC16RAS_H_d0_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFC16RAS.H_q0.0", FIELD_fld_AE_MULAFC16RAS_H_q0_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFC16RAS.L_d1.0", FIELD_fld_AE_MULAFC16RAS_L_d1_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFC16RAS.L_d0.0", FIELD_fld_AE_MULAFC16RAS_L_d0_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFC16RAS.L_q0.0", FIELD_fld_AE_MULAFC16RAS_L_q0_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFC16RAS.H_d1", FIELD_fld_AE_MULFC16RAS_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFC16RAS.H_d0", FIELD_fld_AE_MULFC16RAS_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFC16RAS.H_q0", FIELD_fld_AE_MULFC16RAS_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFC16RAS.L_d1", FIELD_fld_AE_MULFC16RAS_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFC16RAS.L_d0", FIELD_fld_AE_MULFC16RAS_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULFC16RAS.L_q0", FIELD_fld_AE_MULFC16RAS_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFC16RAS.H_d1", FIELD_fld_AE_MULAFC16RAS_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFC16RAS.H_d0", FIELD_fld_AE_MULAFC16RAS_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFC16RAS.H_q0", FIELD_fld_AE_MULAFC16RAS_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFC16RAS.L_d1", FIELD_fld_AE_MULAFC16RAS_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFC16RAS.L_d0", FIELD_fld_AE_MULAFC16RAS_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAFC16RAS.L_q0", FIELD_fld_AE_MULAFC16RAS_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULZAAAAQ16_d1", FIELD_fld_AE_MULZAAAAQ16_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULZAAAAQ16_d0", FIELD_fld_AE_MULZAAAAQ16_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULZAAAAQ16_q0", FIELD_fld_AE_MULZAAAAQ16_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAAAAQ16_d1", FIELD_fld_AE_MULAAAAQ16_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAAAAQ16_d0", FIELD_fld_AE_MULAAAAQ16_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAAAAQ16_q0", FIELD_fld_AE_MULAAAAQ16_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULC16S.L_d1", FIELD_fld_AE_MULC16S_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULC16S.L_d0", FIELD_fld_AE_MULC16S_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULC16S.L_q0", FIELD_fld_AE_MULC16S_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULC16S.H_d1", FIELD_fld_AE_MULC16S_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULC16S.H_d0", FIELD_fld_AE_MULC16S_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULC16S.H_q0", FIELD_fld_AE_MULC16S_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAC16S.L_d1", FIELD_fld_AE_MULAC16S_L_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAC16S.L_d0", FIELD_fld_AE_MULAC16S_L_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAC16S.L_q0", FIELD_fld_AE_MULAC16S_L_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAC16S.H_d1", FIELD_fld_AE_MULAC16S_H_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAC16S.H_d0", FIELD_fld_AE_MULAC16S_H_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MULAC16S.H_q0", FIELD_fld_AE_MULAC16S_H_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_CALCRNG3_a", FIELD_fld_AE_CALCRNG3_a, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fusion_slot1_20_4", FIELD_fld_fusion_slot1_20_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MOVFUSIONMISCV_v", FIELD_fld_AE_MOVFUSIONMISCV_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_movstate1_v", FIELD_fld_ae_sem_movstate1_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_movstate2_v", FIELD_fld_ae_sem_movstate2_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MOVVFUSIONMISC_v", FIELD_fld_AE_MOVVFUSIONMISC_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MOVFCRFSRV_v", FIELD_fld_AE_MOVFCRFSRV_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_AE_MOVVFCRFSR_v", FIELD_fld_AE_MOVVFCRFSR_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_fp_sem_movfpstate_v", FIELD_fld_fp_sem_movfpstate_v, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_arth_v", FIELD_ae_fld_arth_v, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_arth_v0", FIELD_ae_fld_arth_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_arth_v1", FIELD_ae_fld_arth_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ar_to_dr_v", FIELD_ae_fld_ar_to_dr_v, -1, 0, 0, 0, 0, 0, 0 },
  { "s3to1", FIELD_s3to1, -1, 0, 0, 0, 0, 0, 0 }
};

enum xtensa_operand_id {
  OPERAND_soffsetx4,
  OPERAND_immr,
  OPERAND_uimm12x8,
  OPERAND_simm4,
  OPERAND_arr,
  OPERAND_ars,
  OPERAND__ars_invisible,
  OPERAND_art,
  OPERAND_ar0,
  OPERAND_ar4,
  OPERAND_ar8,
  OPERAND_ar12,
  OPERAND_ars_entry,
  OPERAND_immrx4,
  OPERAND_lsi4x4,
  OPERAND_simm7,
  OPERAND_uimm6,
  OPERAND_ai4const,
  OPERAND_b4const,
  OPERAND_b4constu,
  OPERAND_immt,
  OPERAND_uimm8,
  OPERAND_uimm8x2,
  OPERAND_uimm8x4,
  OPERAND_uimm4x16,
  OPERAND_uimmrx4,
  OPERAND_simm8,
  OPERAND_simm8x256,
  OPERAND_simm12b,
  OPERAND_msalp32,
  OPERAND_op2p1,
  OPERAND_label8,
  OPERAND_ulabel8,
  OPERAND_label12,
  OPERAND_soffset,
  OPERAND_uimm16x4,
  OPERAND_bbi,
  OPERAND_sae,
  OPERAND_sas,
  OPERAND_sargt,
  OPERAND_s,
  OPERAND_mx,
  OPERAND_my,
  OPERAND_mw,
  OPERAND_mr0,
  OPERAND_mr1,
  OPERAND_mr2,
  OPERAND_mr3,
  OPERAND_imms,
  OPERAND_imms1,
  OPERAND_bt,
  OPERAND_bs,
  OPERAND_br,
  OPERAND_bt2,
  OPERAND_bs2,
  OPERAND_br2,
  OPERAND_bt4,
  OPERAND_bs4,
  OPERAND_br4,
  OPERAND_bt8,
  OPERAND_bs8,
  OPERAND_br8,
  OPERAND_bt16,
  OPERAND_bs16,
  OPERAND_br16,
  OPERAND_brall,
  OPERAND_tp7,
  OPERAND_xt_wbr15_label,
  OPERAND_xt_wbr18_label,
  OPERAND_ae_ohba,
  OPERAND_ae_ohba2,
  OPERAND_ae_opnd_tp7,
  OPERAND_ae_imm2,
  OPERAND_ae_osa32,
  OPERAND_ae_osa64,
  OPERAND_ae_immls64,
  OPERAND_ae_immls64pos,
  OPERAND_ae_immls32,
  OPERAND_ae_immls16,
  OPERAND_ae_osa16,
  OPERAND_ae_selimm,
  OPERAND_movi_imm,
  OPERAND_stage3_ar_operand,
  OPERAND_ae_lsimm8_2,
  OPERAND_ae_lsimm16_2,
  OPERAND_ae_lsimm32_2,
  OPERAND_ae_uimm2x2,
  OPERAND_opnd_AE_L8X4F_X_x,
  OPERAND_opnd_AE_L8X4F_X_a,
  OPERAND_opnd_AE_L8X4F_X_v,
  OPERAND_opnd_AE_L8X4F_XP_x,
  OPERAND_opnd_AE_L8X4F_XP_a,
  OPERAND_opnd_AE_L8X4F_XP_v,
  OPERAND_opnd_ae_sem_pks_s,
  OPERAND_opnd_ae_sem_pks_d,
  OPERAND_opnd_AE_ZEROB_v1,
  OPERAND_opnd_AE_ZEROB_v0,
  OPERAND_opnd_ae_sem_ar_to_dr_a0,
  OPERAND_opnd_ae_sem_ar_to_dr_a1,
  OPERAND_opnd_ae_sem_shift_a0,
  OPERAND_opnd_ae_sem_dr_to_ar_a,
  OPERAND_opnd_ae_sem_loads_stores_av,
  OPERAND_opnd_ae_sem_loads_stores_v,
  OPERAND_opnd_ae_sem_loads_stores_v1,
  OPERAND_opnd_ae_sem_loads_stores_v2,
  OPERAND_opnd_ae_sem_dr_to_dr_v0,
  OPERAND_opnd_ae_sem_dr_to_dr_v,
  OPERAND_opnd_ae_sem_dr_to_ar_v0,
  OPERAND_opnd_ae_sem_shift_sd,
  OPERAND_opnd_ae_sem_shift_d0,
  OPERAND_opnd_ae_sem_shift_d,
  OPERAND_opnd_ae_sem_cmov_v0,
  OPERAND_opnd_ae_sem_cmov_v,
  OPERAND_opnd_ae_sem_cmpp_v1,
  OPERAND_opnd_ae_sem_cmpp_v0,
  OPERAND_opnd_ae_sem_cmpp_v,
  OPERAND_opnd_ae_sem_arithmetic_v0,
  OPERAND_opnd_ae_sem_arithmetic_v1,
  OPERAND_opnd_ae_sem_arithmetic_v,
  OPERAND_opnd_ae_sem_mul_x2_S1_d1,
  OPERAND_opnd_ae_sem_mul_x2_S1_d0,
  OPERAND_opnd_ae_sem_mul_x2_S1_q0,
  OPERAND_opnd_ae_sem_mul_x2_S1_q1,
  OPERAND_opnd_ae_sem_mul_x2_S1_d2,
  OPERAND_opnd_ae_sem_to_dr_v0,
  OPERAND_opnd_ae_sem_to_dr_v,
  OPERAND_opnd_ae_sem_dr_to_dr_v1,
  OPERAND_opnd_ae_sem_ar_to_dr_v,
  OPERAND_opnd_AE_MULFCR32X16RAS_L_d1,
  OPERAND_opnd_AE_MULFCR32X16RAS_L_d0,
  OPERAND_opnd_AE_MULFCR32X16RAS_L_q0,
  OPERAND_opnd_AE_MULFCR32X16RAS_H_d1,
  OPERAND_opnd_AE_MULFCR32X16RAS_H_d0,
  OPERAND_opnd_AE_MULFCR32X16RAS_H_q0,
  OPERAND_opnd_AE_MULAFCR32X16RAS_L_d1,
  OPERAND_opnd_AE_MULAFCR32X16RAS_L_d0,
  OPERAND_opnd_AE_MULAFCR32X16RAS_L_q0,
  OPERAND_opnd_AE_MULAFCR32X16RAS_H_d1,
  OPERAND_opnd_AE_MULAFCR32X16RAS_H_d0,
  OPERAND_opnd_AE_MULAFCR32X16RAS_H_q0,
  OPERAND_opnd_AE_MULFCI32X16RAS_L_d1,
  OPERAND_opnd_AE_MULFCI32X16RAS_L_d0,
  OPERAND_opnd_AE_MULFCI32X16RAS_L_q0,
  OPERAND_opnd_AE_MULFCI32X16RAS_H_d1,
  OPERAND_opnd_AE_MULFCI32X16RAS_H_d0,
  OPERAND_opnd_AE_MULFCI32X16RAS_H_q0,
  OPERAND_opnd_AE_MULAFCI32X16RAS_L_d1,
  OPERAND_opnd_AE_MULAFCI32X16RAS_L_d0,
  OPERAND_opnd_AE_MULAFCI32X16RAS_L_q0,
  OPERAND_opnd_AE_MULAFCI32X16RAS_H_d1,
  OPERAND_opnd_AE_MULAFCI32X16RAS_H_d0,
  OPERAND_opnd_AE_MULAFCI32X16RAS_H_q0,
  OPERAND_opnd_AE_MULP32X2_H_d1,
  OPERAND_opnd_AE_MULP32X2_H_d0,
  OPERAND_opnd_AE_MULP32X2_H_q0,
  OPERAND_opnd_AE_MULAP32X2_H_d1,
  OPERAND_opnd_AE_MULAP32X2_H_d0,
  OPERAND_opnd_AE_MULAP32X2_H_q0,
  OPERAND_opnd_AE_MULSP32X2_H_d1,
  OPERAND_opnd_AE_MULSP32X2_H_d0,
  OPERAND_opnd_AE_MULSP32X2_H_q0,
  OPERAND_opnd_AE_MULP32X2_L_d1,
  OPERAND_opnd_AE_MULP32X2_L_d0,
  OPERAND_opnd_AE_MULP32X2_L_q0,
  OPERAND_opnd_AE_MULAP32X2_L_d1,
  OPERAND_opnd_AE_MULAP32X2_L_d0,
  OPERAND_opnd_AE_MULAP32X2_L_q0,
  OPERAND_opnd_AE_MULSP32X2_L_d1,
  OPERAND_opnd_AE_MULSP32X2_L_d0,
  OPERAND_opnd_AE_MULSP32X2_L_q0,
  OPERAND_opnd_ae_sem_mul_x2_S1_d2_0,
  OPERAND_opnd_ae_sem_mul_x2_S1_d3,
  OPERAND_opnd_AE_MULFP32X2RS_H_d1,
  OPERAND_opnd_AE_MULFP32X2RS_H_d0,
  OPERAND_opnd_AE_MULFP32X2RS_H_q0,
  OPERAND_opnd_AE_MULFP32X2RAS_H_d1,
  OPERAND_opnd_AE_MULFP32X2RAS_H_d0,
  OPERAND_opnd_AE_MULFP32X2RAS_H_q0,
  OPERAND_opnd_AE_MULAFP32X2RS_H_d1,
  OPERAND_opnd_AE_MULAFP32X2RS_H_d0,
  OPERAND_opnd_AE_MULAFP32X2RS_H_q0,
  OPERAND_opnd_AE_MULAFP32X2RAS_H_d1,
  OPERAND_opnd_AE_MULAFP32X2RAS_H_d0,
  OPERAND_opnd_AE_MULAFP32X2RAS_H_q0,
  OPERAND_opnd_AE_MULSFP32X2RS_H_d1,
  OPERAND_opnd_AE_MULSFP32X2RS_H_d0,
  OPERAND_opnd_AE_MULSFP32X2RS_H_q0,
  OPERAND_opnd_AE_MULSFP32X2RAS_H_d1,
  OPERAND_opnd_AE_MULSFP32X2RAS_H_d0,
  OPERAND_opnd_AE_MULSFP32X2RAS_H_q0,
  OPERAND_opnd_AE_MULFP32X2RS_L_d1,
  OPERAND_opnd_AE_MULFP32X2RS_L_d0,
  OPERAND_opnd_AE_MULFP32X2RS_L_q0,
  OPERAND_opnd_AE_MULFP32X2RAS_L_d1,
  OPERAND_opnd_AE_MULFP32X2RAS_L_d0,
  OPERAND_opnd_AE_MULFP32X2RAS_L_q0,
  OPERAND_opnd_AE_MULAFP32X2RS_L_d1,
  OPERAND_opnd_AE_MULAFP32X2RS_L_d0,
  OPERAND_opnd_AE_MULAFP32X2RS_L_q0,
  OPERAND_opnd_AE_MULAFP32X2RAS_L_d1,
  OPERAND_opnd_AE_MULAFP32X2RAS_L_d0,
  OPERAND_opnd_AE_MULAFP32X2RAS_L_q0,
  OPERAND_opnd_AE_MULSFP32X2RS_L_d1,
  OPERAND_opnd_AE_MULSFP32X2RS_L_d0,
  OPERAND_opnd_AE_MULSFP32X2RS_L_q0,
  OPERAND_opnd_AE_MULSFP32X2RAS_L_d1,
  OPERAND_opnd_AE_MULSFP32X2RAS_L_d0,
  OPERAND_opnd_AE_MULSFP32X2RAS_L_q0,
  OPERAND_opnd_AE_MULCR24_d1,
  OPERAND_opnd_AE_MULCR24_d0,
  OPERAND_opnd_AE_MULCR24_q0,
  OPERAND_opnd_AE_MULFCR24RA_d1,
  OPERAND_opnd_AE_MULFCR24RA_d0,
  OPERAND_opnd_AE_MULFCR24RA_q0,
  OPERAND_opnd_AE_MULCR32X16_L_d1,
  OPERAND_opnd_AE_MULCR32X16_L_d0,
  OPERAND_opnd_AE_MULCR32X16_L_q0,
  OPERAND_opnd_AE_MULCR32X16_H_d1,
  OPERAND_opnd_AE_MULCR32X16_H_d0,
  OPERAND_opnd_AE_MULCR32X16_H_q0,
  OPERAND_opnd_AE_MULCI24_d1,
  OPERAND_opnd_AE_MULCI24_d0,
  OPERAND_opnd_AE_MULCI24_q0,
  OPERAND_opnd_AE_MULFCI24RA_d1,
  OPERAND_opnd_AE_MULFCI24RA_d0,
  OPERAND_opnd_AE_MULFCI24RA_q0,
  OPERAND_opnd_AE_MULCI32X16_L_d1,
  OPERAND_opnd_AE_MULCI32X16_L_d0,
  OPERAND_opnd_AE_MULCI32X16_L_q0,
  OPERAND_opnd_AE_MULCI32X16_H_d1,
  OPERAND_opnd_AE_MULCI32X16_H_d0,
  OPERAND_opnd_AE_MULCI32X16_H_q0,
  OPERAND_opnd_AE_MULACR24_d1,
  OPERAND_opnd_AE_MULACR24_d0,
  OPERAND_opnd_AE_MULACR24_q0,
  OPERAND_opnd_AE_MULAFCR24RA_d1,
  OPERAND_opnd_AE_MULAFCR24RA_d0,
  OPERAND_opnd_AE_MULAFCR24RA_q0,
  OPERAND_opnd_AE_MULACR32X16_L_d1,
  OPERAND_opnd_AE_MULACR32X16_L_d0,
  OPERAND_opnd_AE_MULACR32X16_L_q0,
  OPERAND_opnd_AE_MULACR32X16_H_d1,
  OPERAND_opnd_AE_MULACR32X16_H_d0,
  OPERAND_opnd_AE_MULACR32X16_H_q0,
  OPERAND_opnd_AE_MULACI24_d1,
  OPERAND_opnd_AE_MULACI24_d0,
  OPERAND_opnd_AE_MULACI24_q0,
  OPERAND_opnd_AE_MULAFCI24RA_d1,
  OPERAND_opnd_AE_MULAFCI24RA_d0,
  OPERAND_opnd_AE_MULAFCI24RA_q0,
  OPERAND_opnd_AE_MULACI32X16_L_d1,
  OPERAND_opnd_AE_MULACI32X16_L_d0,
  OPERAND_opnd_AE_MULACI32X16_L_q0,
  OPERAND_opnd_AE_MULACI32X16_H_d1,
  OPERAND_opnd_AE_MULACI32X16_H_d0,
  OPERAND_opnd_AE_MULACI32X16_H_q0,
  OPERAND_opnd_AE_MULF16X4SS_H_d0,
  OPERAND_opnd_AE_MULF16X4SS_H_d1,
  OPERAND_opnd_AE_MULF16X4SS_H_q1,
  OPERAND_opnd_AE_MULAF16X4SS_H_d0,
  OPERAND_opnd_AE_MULAF16X4SS_H_d1,
  OPERAND_opnd_AE_MULAF16X4SS_H_q1,
  OPERAND_opnd_AE_MULSF16X4SS_H_d0,
  OPERAND_opnd_AE_MULSF16X4SS_H_d1,
  OPERAND_opnd_AE_MULSF16X4SS_H_q1,
  OPERAND_opnd_AE_MULF16X4SS_L_d0,
  OPERAND_opnd_AE_MULF16X4SS_L_d1,
  OPERAND_opnd_AE_MULF16X4SS_L_q0,
  OPERAND_opnd_AE_MULAF16X4SS_L_d0,
  OPERAND_opnd_AE_MULAF16X4SS_L_d1,
  OPERAND_opnd_AE_MULAF16X4SS_L_q0,
  OPERAND_opnd_AE_MULSF16X4SS_L_d0,
  OPERAND_opnd_AE_MULSF16X4SS_L_d1,
  OPERAND_opnd_AE_MULSF16X4SS_L_q0,
  OPERAND_opnd_AE_MUL16X4_H_d0,
  OPERAND_opnd_AE_MUL16X4_H_d1,
  OPERAND_opnd_AE_MUL16X4_H_q1,
  OPERAND_opnd_AE_MULA16X4_H_d0,
  OPERAND_opnd_AE_MULA16X4_H_d1,
  OPERAND_opnd_AE_MULA16X4_H_q1,
  OPERAND_opnd_AE_MULS16X4_H_d0,
  OPERAND_opnd_AE_MULS16X4_H_d1,
  OPERAND_opnd_AE_MULS16X4_H_q1,
  OPERAND_opnd_AE_MUL16X4_L_d0,
  OPERAND_opnd_AE_MUL16X4_L_d1,
  OPERAND_opnd_AE_MUL16X4_L_q0,
  OPERAND_opnd_AE_MULA16X4_L_d0,
  OPERAND_opnd_AE_MULA16X4_L_d1,
  OPERAND_opnd_AE_MULA16X4_L_q0,
  OPERAND_opnd_AE_MULS16X4_L_d0,
  OPERAND_opnd_AE_MULS16X4_L_d1,
  OPERAND_opnd_AE_MULS16X4_L_q0,
  OPERAND_opnd_AE_MULFP16X4S_H_d1,
  OPERAND_opnd_AE_MULFP16X4S_H_d0,
  OPERAND_opnd_AE_MULFP16X4S_H_q0,
  OPERAND_opnd_AE_MULFP16X4RAS_H_d1,
  OPERAND_opnd_AE_MULFP16X4RAS_H_d0,
  OPERAND_opnd_AE_MULFP16X4RAS_H_q0,
  OPERAND_opnd_AE_MULFP16X4S_L_d1,
  OPERAND_opnd_AE_MULFP16X4S_L_d0,
  OPERAND_opnd_AE_MULFP16X4S_L_q0,
  OPERAND_opnd_AE_MULFP16X4RAS_L_d1,
  OPERAND_opnd_AE_MULFP16X4RAS_L_d0,
  OPERAND_opnd_AE_MULFP16X4RAS_L_q0,
  OPERAND_opnd_fp_sem_sp32cvt_i_imm5,
  OPERAND_opnd_fp_sem_sp32cvt_ars,
  OPERAND_opnd_AE_MAXABS16S_v1,
  OPERAND_opnd_AE_MAXABS16S_v0,
  OPERAND_opnd_AE_MAXABS16S_v,
  OPERAND_opnd_AE_MULFC16RAS_H_d1_0,
  OPERAND_opnd_AE_MULFC16RAS_H_d0_0,
  OPERAND_opnd_AE_MULFC16RAS_H_q0_0,
  OPERAND_opnd_AE_MULFC16RAS_L_d1_0,
  OPERAND_opnd_AE_MULFC16RAS_L_d0_0,
  OPERAND_opnd_AE_MULFC16RAS_L_q0_0,
  OPERAND_opnd_AE_MULAFC16RAS_H_d1_0,
  OPERAND_opnd_AE_MULAFC16RAS_H_d0_0,
  OPERAND_opnd_AE_MULAFC16RAS_H_q0_0,
  OPERAND_opnd_AE_MULAFC16RAS_L_d1_0,
  OPERAND_opnd_AE_MULAFC16RAS_L_d0_0,
  OPERAND_opnd_AE_MULAFC16RAS_L_q0_0,
  OPERAND_opnd_AE_MULFC16RAS_H_d1,
  OPERAND_opnd_AE_MULFC16RAS_H_d0,
  OPERAND_opnd_AE_MULFC16RAS_H_q0,
  OPERAND_opnd_AE_MULFC16RAS_L_d1,
  OPERAND_opnd_AE_MULFC16RAS_L_d0,
  OPERAND_opnd_AE_MULFC16RAS_L_q0,
  OPERAND_opnd_AE_MULAFC16RAS_H_d1,
  OPERAND_opnd_AE_MULAFC16RAS_H_d0,
  OPERAND_opnd_AE_MULAFC16RAS_H_q0,
  OPERAND_opnd_AE_MULAFC16RAS_L_d1,
  OPERAND_opnd_AE_MULAFC16RAS_L_d0,
  OPERAND_opnd_AE_MULAFC16RAS_L_q0,
  OPERAND_opnd_AE_MULZAAAAQ16_d1,
  OPERAND_opnd_AE_MULZAAAAQ16_d0,
  OPERAND_opnd_AE_MULZAAAAQ16_q0,
  OPERAND_opnd_AE_MULAAAAQ16_d1,
  OPERAND_opnd_AE_MULAAAAQ16_d0,
  OPERAND_opnd_AE_MULAAAAQ16_q0,
  OPERAND_opnd_AE_MULC16S_L_d1,
  OPERAND_opnd_AE_MULC16S_L_d0,
  OPERAND_opnd_AE_MULC16S_L_q0,
  OPERAND_opnd_AE_MULC16S_H_d1,
  OPERAND_opnd_AE_MULC16S_H_d0,
  OPERAND_opnd_AE_MULC16S_H_q0,
  OPERAND_opnd_AE_MULAC16S_L_d1,
  OPERAND_opnd_AE_MULAC16S_L_d0,
  OPERAND_opnd_AE_MULAC16S_L_q0,
  OPERAND_opnd_AE_MULAC16S_H_d1,
  OPERAND_opnd_AE_MULAC16S_H_d0,
  OPERAND_opnd_AE_MULAC16S_H_q0,
  OPERAND_opnd_AE_ADDANDSUBRNG16RAS_S1_vs,
  OPERAND_opnd_AE_ADDANDSUBRNG16RAS_S1_va,
  OPERAND_opnd_AE_ADDANDSUBRNG16RAS_S2_vs,
  OPERAND_opnd_AE_ADDANDSUBRNG16RAS_S2_va,
  OPERAND_opnd_AE_CALCRNG3_a,
  OPERAND_opnd_ae_sem_arithmetic_va,
  OPERAND_opnd_ae_sem_arithmetic_vs,
  OPERAND_opnd_AE_MOVFUSIONMISCV_v,
  OPERAND_opnd_ae_sem_movstate1_v,
  OPERAND_opnd_ae_sem_movstate2_v,
  OPERAND_opnd_AE_MOVVFUSIONMISC_v,
  OPERAND_frr,
  OPERAND_frr1,
  OPERAND_frs,
  OPERAND_frt,
  OPERAND_imm_s,
  OPERAND_imm8x4,
  OPERAND_imm8x8,
  OPERAND_opnd_AE_MOVFCRFSRV_v,
  OPERAND_opnd_AE_MOVVFCRFSR_v,
  OPERAND_opnd_fp_sem_movfpstate_v,
  OPERAND_ae_ar_to_dr_v,
  OPERAND_ae_ls_uu,
  OPERAND_ae_ls_su,
  OPERAND_ae_uu_v,
  OPERAND_ae_uu_uu,
  OPERAND_ae_cmpp_v0,
  OPERAND_ae_cmpp_v1,
  OPERAND_ae_cmpp_v,
  OPERAND_ae_ls_v,
  OPERAND_ae_ls_av,
  OPERAND_ae_ls_v1,
  OPERAND_ae_ls_v2,
  OPERAND_ae_arth_v,
  OPERAND_ae_arth_v0,
  OPERAND_ae_arth_v1,
  OPERAND_ae_cmov_v,
  OPERAND_ae_cmov_v0,
  OPERAND_ae_shift_d,
  OPERAND_ae_shift_d0,
  OPERAND_ae_shift_sd,
  OPERAND_bitindex,
  OPERAND_t,
  OPERAND_bbi4,
  OPERAND_imm12,
  OPERAND_imm8,
  OPERAND_imm12b,
  OPERAND_imm16,
  OPERAND_m,
  OPERAND_n,
  OPERAND_offset,
  OPERAND_op0,
  OPERAND_op1,
  OPERAND_op2,
  OPERAND_r,
  OPERAND_r_disp,
  OPERAND_r_3,
  OPERAND_sa4,
  OPERAND_sae4,
  OPERAND_sal,
  OPERAND_sas4,
  OPERAND_sr,
  OPERAND_st,
  OPERAND_thi3,
  OPERAND_imm4,
  OPERAND_mn,
  OPERAND_i,
  OPERAND_imm6lo,
  OPERAND_imm6hi,
  OPERAND_imm7lo,
  OPERAND_imm7hi,
  OPERAND_z,
  OPERAND_imm6,
  OPERAND_imm7,
  OPERAND_r3,
  OPERAND_rbit2,
  OPERAND_rhi,
  OPERAND_t3,
  OPERAND_tbit2,
  OPERAND_tlo,
  OPERAND_w,
  OPERAND_y,
  OPERAND_x,
  OPERAND_t2,
  OPERAND_s2,
  OPERAND_r2,
  OPERAND_t4,
  OPERAND_s4,
  OPERAND_r4,
  OPERAND_t8,
  OPERAND_s8,
  OPERAND_r8,
  OPERAND_xt_wbr15_imm,
  OPERAND_xt_wbr18_imm,
  OPERAND_ae_fld_fhba4,
  OPERAND_ae_fld_fhba4_2,
  OPERAND_ae_fld_tp7,
  OPERAND_ae_fld_osa32,
  OPERAND_ae_fld_osa64,
  OPERAND_ae_fld_imm2,
  OPERAND_ae_fld_immls64,
  OPERAND_ae_fld_immls64pos,
  OPERAND_ae_fld_immls32,
  OPERAND_ae_fld_immls16,
  OPERAND_ae_fld_osa16,
  OPERAND_Inst_15_12,
  OPERAND_Inst_11_8,
  OPERAND_Inst_7_4,
  OPERAND_Inst_12,
  OPERAND_Inst_7,
  OPERAND_Inst_5_4,
  OPERAND_Inst_7_6,
  OPERAND_Inst_19_17,
  OPERAND_Inst_19_18,
  OPERAND_Inst_9_8,
  OPERAND_Inst_4,
  OPERAND_ae_fld_ls_v,
  OPERAND_ae_fld_ls_uu,
  OPERAND_ae_fld_ls_su,
  OPERAND_ae_fld_ls_av,
  OPERAND_ae_fld_ls_v1,
  OPERAND_ae_fld_ls_v2,
  OPERAND_ae_fld_cmpp_v0,
  OPERAND_ae_fld_cmpp_v1,
  OPERAND_ae_fld_cmpp_v,
  OPERAND_ae_fld_uu_v,
  OPERAND_ae_fld_uu_uu,
  OPERAND_ae_fld_dr_to_ar_v0,
  OPERAND_ae_fld_cmov_v,
  OPERAND_ae_fld_cmov_v0,
  OPERAND_ae_fld_pks_d,
  OPERAND_ae_fld_pks_s,
  OPERAND_ae_fld_shift_d,
  OPERAND_ae_fld_shift_d0,
  OPERAND_ae_fld_shift_sd,
  OPERAND_ae_fld_dr_to_dr_v,
  OPERAND_ae_fld_dr_to_dr_v0,
  OPERAND_ae_fld_dr_to_dr_v1,
  OPERAND_ae_fld_to_dr_v,
  OPERAND_ae_fld_to_dr_v0,
  OPERAND_ae_fld_selimm,
  OPERAND_fld_ar_to_dr_imm,
  OPERAND_fld_stage3_ar_operand,
  OPERAND_fld_lsip,
  OPERAND_ae_fld_Inst16b_12,
  OPERAND_ae_fld_Inst16b_15_13,
  OPERAND_fld_AE_L8X4F_X_x,
  OPERAND_fld_AE_L8X4F_X_a,
  OPERAND_fld_AE_L8X4F_X_v,
  OPERAND_fld_AE_L8X4F_XP_x,
  OPERAND_fld_AE_L8X4F_XP_a,
  OPERAND_fld_AE_L8X4F_XP_v,
  OPERAND_fld_ae_sem_pks_s,
  OPERAND_fld_ae_sem_pks_d,
  OPERAND_fld_AE_ZEROB_v1,
  OPERAND_fld_AE_ZEROB_v0,
  OPERAND_fld_fusion_slot0_22_6,
  OPERAND_fld_fusion_slot0_22_8,
  OPERAND_fld_fusion_slot1_20_16,
  OPERAND_fld_fusion_slot0_11_8,
  OPERAND_fld_fusion_slot0_11_9,
  OPERAND_fld_fusion_slot0_7_4,
  OPERAND_fld_fusion_slot0_22_16,
  OPERAND_fld_fusion_slot0_22_17,
  OPERAND_fld_fusion_slot0_22_18,
  OPERAND_fld_fusion_slot0_22_4,
  OPERAND_fld_fusion_slot0_22_20,
  OPERAND_fld_fusion_slot0_22_0,
  OPERAND_fld_fusion_slot1_20_0,
  OPERAND_fld_fusion_slot1_3_0,
  OPERAND_fld_fusion_slot0_22_13,
  OPERAND_fld_fusion_slot1_20_13,
  OPERAND_fld_fusion_slot0_8_4,
  OPERAND_fld_fusion_slot0_22_10,
  OPERAND_fld_fusion_slot0_8_8,
  OPERAND_fld_fusion_slot0_11_4,
  OPERAND_fld_fusion_slot0_22_12,
  OPERAND_fld_ae_sem_loads_stores_v,
  OPERAND_fld_ae_sem_loads_stores_av,
  OPERAND_fld_ae_sem_loads_stores_v1,
  OPERAND_fld_fusion_slot1_1_0,
  OPERAND_fld_ae_sem_cmov_v0,
  OPERAND_fld_ae_sem_cmov_v,
  OPERAND_fld_ae_sem_ar_to_dr_a0,
  OPERAND_fld_ae_sem_ar_to_dr_v,
  OPERAND_fld_ae_sem_ar_to_dr_a1,
  OPERAND_fld_ae_sem_to_dr_v0,
  OPERAND_fld_ae_sem_to_dr_v,
  OPERAND_fld_ae_sem_shift_a0,
  OPERAND_fld_ae_sem_shift_sd,
  OPERAND_fld_ae_sem_shift_d0,
  OPERAND_fld_ae_sem_shift_d,
  OPERAND_fld_fusion_slot1_20_8,
  OPERAND_fld_ae_sem_dr_to_dr_v0,
  OPERAND_fld_ae_sem_dr_to_dr_v,
  OPERAND_fld_ae_sem_dr_to_ar_v0,
  OPERAND_fld_ae_sem_dr_to_ar_a,
  OPERAND_fld_ae_sem_arithmetic_v0,
  OPERAND_fld_ae_sem_arithmetic_v1,
  OPERAND_fld_ae_sem_arithmetic_v,
  OPERAND_fld_fusion_slot1_7_4,
  OPERAND_fld_fusion_slot1_9_8,
  OPERAND_fld_ae_sem_cmpp_v1,
  OPERAND_fld_ae_sem_cmpp_v0,
  OPERAND_fld_fusion_slot1_8_8,
  OPERAND_fld_ae_sem_cmpp_v,
  OPERAND_fld_ae_sem_dr_to_dr_v1,
  OPERAND_fld_fusion_slot1_20_12,
  OPERAND_fld_ae_sem_mul_x2_S1_d1,
  OPERAND_fld_ae_sem_mul_x2_S1_d0,
  OPERAND_fld_ae_sem_mul_x2_S1_q0,
  OPERAND_fld_ae_sem_mul_x2_S1_q1,
  OPERAND_fld_ae_sem_mul_x2_S1_d2,
  OPERAND_fld_fusion_slot0_11_10,
  OPERAND_fld_fusion_slot1_7_6,
  OPERAND_fld_fusion_slot0_5_4,
  OPERAND_fld_fusion_slot0_22_14,
  OPERAND_fld_fusion_slot0_7_7,
  OPERAND_fld_fusion_slot0_11_6,
  OPERAND_fld_fusion_slot1_0_0,
  OPERAND_fld_fusion_slot0_3_0,
  OPERAND_fld_fusion_slot0_7_0,
  OPERAND_fld_fusion_slot0_7_5,
  OPERAND_fld_fusion_slot0_7_6,
  OPERAND_fld_fusion_slot0_22_9,
  OPERAND_fld_ae_sem_loads_stores_v2,
  OPERAND_fld_Inst_9_8,
  OPERAND_fld_Inst_19_12,
  OPERAND_fld_Inst_23_16,
  OPERAND_fld_Inst_12_8,
  OPERAND_fld_Inst_11_8,
  OPERAND_fld_Inst_7_0,
  OPERAND_fld_Inst_3_0,
  OPERAND_fld_Inst_19_16,
  OPERAND_fld_fusion_slot40_27_12,
  OPERAND_fld_fusion_slot40_27_18,
  OPERAND_fld_fusion_slot40_7_4,
  OPERAND_fld_fusion_slot40_27_24,
  OPERAND_fld_fusion_slot40_27_23,
  OPERAND_fld_fusion_slot40_2_0,
  OPERAND_fld_fusion_slot40_27_3,
  OPERAND_fld_fusion_slot40_27_16,
  OPERAND_fld_AE_MULFCR32X16RAS_L_d1,
  OPERAND_fld_AE_MULFCR32X16RAS_L_d0,
  OPERAND_fld_AE_MULFCR32X16RAS_L_q0,
  OPERAND_fld_AE_MULFCR32X16RAS_H_d1,
  OPERAND_fld_AE_MULFCR32X16RAS_H_d0,
  OPERAND_fld_AE_MULFCR32X16RAS_H_q0,
  OPERAND_fld_AE_MULAFCR32X16RAS_L_d1,
  OPERAND_fld_AE_MULAFCR32X16RAS_L_d0,
  OPERAND_fld_AE_MULAFCR32X16RAS_L_q0,
  OPERAND_fld_AE_MULAFCR32X16RAS_H_d1,
  OPERAND_fld_AE_MULAFCR32X16RAS_H_d0,
  OPERAND_fld_AE_MULAFCR32X16RAS_H_q0,
  OPERAND_fld_AE_MULFCI32X16RAS_L_d1,
  OPERAND_fld_AE_MULFCI32X16RAS_L_d0,
  OPERAND_fld_AE_MULFCI32X16RAS_L_q0,
  OPERAND_fld_AE_MULFCI32X16RAS_H_d1,
  OPERAND_fld_AE_MULFCI32X16RAS_H_d0,
  OPERAND_fld_AE_MULFCI32X16RAS_H_q0,
  OPERAND_fld_AE_MULAFCI32X16RAS_L_d1,
  OPERAND_fld_AE_MULAFCI32X16RAS_L_d0,
  OPERAND_fld_AE_MULAFCI32X16RAS_L_q0,
  OPERAND_fld_AE_MULAFCI32X16RAS_H_d1,
  OPERAND_fld_AE_MULAFCI32X16RAS_H_d0,
  OPERAND_fld_AE_MULAFCI32X16RAS_H_q0,
  OPERAND_fld_AE_MULP32X2_H_d1,
  OPERAND_fld_AE_MULP32X2_H_d0,
  OPERAND_fld_AE_MULP32X2_H_q0,
  OPERAND_fld_AE_MULAP32X2_H_d1,
  OPERAND_fld_AE_MULAP32X2_H_d0,
  OPERAND_fld_AE_MULAP32X2_H_q0,
  OPERAND_fld_AE_MULSP32X2_H_d1,
  OPERAND_fld_AE_MULSP32X2_H_d0,
  OPERAND_fld_AE_MULSP32X2_H_q0,
  OPERAND_fld_AE_MULP32X2_L_d1,
  OPERAND_fld_AE_MULP32X2_L_d0,
  OPERAND_fld_AE_MULP32X2_L_q0,
  OPERAND_fld_AE_MULAP32X2_L_d1,
  OPERAND_fld_AE_MULAP32X2_L_d0,
  OPERAND_fld_AE_MULAP32X2_L_q0,
  OPERAND_fld_AE_MULSP32X2_L_d1,
  OPERAND_fld_AE_MULSP32X2_L_d0,
  OPERAND_fld_AE_MULSP32X2_L_q0,
  OPERAND_fld_ae_sem_mul_x2_S1_d2_0,
  OPERAND_fld_ae_sem_mul_x2_S1_d3,
  OPERAND_fld_fusion_slot_fir_0_14_0,
  OPERAND_fld_fusion_slot_fir_1_18_0,
  OPERAND_fld_fusion_slot_fir_1_18_16,
  OPERAND_fld_fusion_slot_fir_0_14_12,
  OPERAND_fld_fusion_slot_fir_0_7_7,
  OPERAND_fld_fusion_slot_fir_0_7_6,
  OPERAND_fld_AE_MULFP32X2RS_H_d1,
  OPERAND_fld_AE_MULFP32X2RS_H_d0,
  OPERAND_fld_AE_MULFP32X2RS_H_q0,
  OPERAND_fld_AE_MULFP32X2RAS_H_d1,
  OPERAND_fld_AE_MULFP32X2RAS_H_d0,
  OPERAND_fld_AE_MULFP32X2RAS_H_q0,
  OPERAND_fld_AE_MULAFP32X2RS_H_d1,
  OPERAND_fld_AE_MULAFP32X2RS_H_d0,
  OPERAND_fld_AE_MULAFP32X2RS_H_q0,
  OPERAND_fld_AE_MULAFP32X2RAS_H_d1,
  OPERAND_fld_AE_MULAFP32X2RAS_H_d0,
  OPERAND_fld_AE_MULAFP32X2RAS_H_q0,
  OPERAND_fld_AE_MULSFP32X2RS_H_d1,
  OPERAND_fld_AE_MULSFP32X2RS_H_d0,
  OPERAND_fld_AE_MULSFP32X2RS_H_q0,
  OPERAND_fld_AE_MULSFP32X2RAS_H_d1,
  OPERAND_fld_AE_MULSFP32X2RAS_H_d0,
  OPERAND_fld_AE_MULSFP32X2RAS_H_q0,
  OPERAND_fld_AE_MULFP32X2RS_L_d1,
  OPERAND_fld_AE_MULFP32X2RS_L_d0,
  OPERAND_fld_AE_MULFP32X2RS_L_q0,
  OPERAND_fld_AE_MULFP32X2RAS_L_d1,
  OPERAND_fld_AE_MULFP32X2RAS_L_d0,
  OPERAND_fld_AE_MULFP32X2RAS_L_q0,
  OPERAND_fld_AE_MULAFP32X2RS_L_d1,
  OPERAND_fld_AE_MULAFP32X2RS_L_d0,
  OPERAND_fld_AE_MULAFP32X2RS_L_q0,
  OPERAND_fld_AE_MULAFP32X2RAS_L_d1,
  OPERAND_fld_AE_MULAFP32X2RAS_L_d0,
  OPERAND_fld_AE_MULAFP32X2RAS_L_q0,
  OPERAND_fld_AE_MULSFP32X2RS_L_d1,
  OPERAND_fld_AE_MULSFP32X2RS_L_d0,
  OPERAND_fld_AE_MULSFP32X2RS_L_q0,
  OPERAND_fld_AE_MULSFP32X2RAS_L_d1,
  OPERAND_fld_AE_MULSFP32X2RAS_L_d0,
  OPERAND_fld_AE_MULSFP32X2RAS_L_q0,
  OPERAND_fld_AE_MULCR24_d1,
  OPERAND_fld_AE_MULCR24_d0,
  OPERAND_fld_AE_MULCR24_q0,
  OPERAND_fld_AE_MULFCR24RA_d1,
  OPERAND_fld_AE_MULFCR24RA_d0,
  OPERAND_fld_AE_MULFCR24RA_q0,
  OPERAND_fld_AE_MULCR32X16_L_d1,
  OPERAND_fld_AE_MULCR32X16_L_d0,
  OPERAND_fld_AE_MULCR32X16_L_q0,
  OPERAND_fld_AE_MULCR32X16_H_d1,
  OPERAND_fld_AE_MULCR32X16_H_d0,
  OPERAND_fld_AE_MULCR32X16_H_q0,
  OPERAND_fld_AE_MULCI24_d1,
  OPERAND_fld_AE_MULCI24_d0,
  OPERAND_fld_AE_MULCI24_q0,
  OPERAND_fld_AE_MULFCI24RA_d1,
  OPERAND_fld_AE_MULFCI24RA_d0,
  OPERAND_fld_AE_MULFCI24RA_q0,
  OPERAND_fld_AE_MULCI32X16_L_d1,
  OPERAND_fld_AE_MULCI32X16_L_d0,
  OPERAND_fld_AE_MULCI32X16_L_q0,
  OPERAND_fld_AE_MULCI32X16_H_d1,
  OPERAND_fld_AE_MULCI32X16_H_d0,
  OPERAND_fld_AE_MULCI32X16_H_q0,
  OPERAND_fld_AE_MULACR24_d1,
  OPERAND_fld_AE_MULACR24_d0,
  OPERAND_fld_AE_MULACR24_q0,
  OPERAND_fld_AE_MULAFCR24RA_d1,
  OPERAND_fld_AE_MULAFCR24RA_d0,
  OPERAND_fld_AE_MULAFCR24RA_q0,
  OPERAND_fld_AE_MULACR32X16_L_d1,
  OPERAND_fld_AE_MULACR32X16_L_d0,
  OPERAND_fld_AE_MULACR32X16_L_q0,
  OPERAND_fld_AE_MULACR32X16_H_d1,
  OPERAND_fld_AE_MULACR32X16_H_d0,
  OPERAND_fld_AE_MULACR32X16_H_q0,
  OPERAND_fld_AE_MULACI24_d1,
  OPERAND_fld_AE_MULACI24_d0,
  OPERAND_fld_AE_MULACI24_q0,
  OPERAND_fld_AE_MULAFCI24RA_d1,
  OPERAND_fld_AE_MULAFCI24RA_d0,
  OPERAND_fld_AE_MULAFCI24RA_q0,
  OPERAND_fld_AE_MULACI32X16_L_d1,
  OPERAND_fld_AE_MULACI32X16_L_d0,
  OPERAND_fld_AE_MULACI32X16_L_q0,
  OPERAND_fld_AE_MULACI32X16_H_d1,
  OPERAND_fld_AE_MULACI32X16_H_d0,
  OPERAND_fld_AE_MULACI32X16_H_q0,
  OPERAND_fld_AE_MULF16X4SS_H_d0,
  OPERAND_fld_AE_MULF16X4SS_H_d1,
  OPERAND_fld_AE_MULF16X4SS_H_q1,
  OPERAND_fld_AE_MULAF16X4SS_H_d0,
  OPERAND_fld_AE_MULAF16X4SS_H_d1,
  OPERAND_fld_AE_MULAF16X4SS_H_q1,
  OPERAND_fld_AE_MULSF16X4SS_H_d0,
  OPERAND_fld_AE_MULSF16X4SS_H_d1,
  OPERAND_fld_AE_MULSF16X4SS_H_q1,
  OPERAND_fld_AE_MULF16X4SS_L_d0,
  OPERAND_fld_AE_MULF16X4SS_L_d1,
  OPERAND_fld_AE_MULF16X4SS_L_q0,
  OPERAND_fld_AE_MULAF16X4SS_L_d0,
  OPERAND_fld_AE_MULAF16X4SS_L_d1,
  OPERAND_fld_AE_MULAF16X4SS_L_q0,
  OPERAND_fld_AE_MULSF16X4SS_L_d0,
  OPERAND_fld_AE_MULSF16X4SS_L_d1,
  OPERAND_fld_AE_MULSF16X4SS_L_q0,
  OPERAND_fld_AE_MUL16X4_H_d0,
  OPERAND_fld_AE_MUL16X4_H_d1,
  OPERAND_fld_AE_MUL16X4_H_q1,
  OPERAND_fld_AE_MULA16X4_H_d0,
  OPERAND_fld_AE_MULA16X4_H_d1,
  OPERAND_fld_AE_MULA16X4_H_q1,
  OPERAND_fld_AE_MULS16X4_H_d0,
  OPERAND_fld_AE_MULS16X4_H_d1,
  OPERAND_fld_AE_MULS16X4_H_q1,
  OPERAND_fld_AE_MUL16X4_L_d0,
  OPERAND_fld_AE_MUL16X4_L_d1,
  OPERAND_fld_AE_MUL16X4_L_q0,
  OPERAND_fld_AE_MULA16X4_L_d0,
  OPERAND_fld_AE_MULA16X4_L_d1,
  OPERAND_fld_AE_MULA16X4_L_q0,
  OPERAND_fld_AE_MULS16X4_L_d0,
  OPERAND_fld_AE_MULS16X4_L_d1,
  OPERAND_fld_AE_MULS16X4_L_q0,
  OPERAND_fld_AE_MULFP16X4S_H_d1,
  OPERAND_fld_AE_MULFP16X4S_H_d0,
  OPERAND_fld_AE_MULFP16X4S_H_q0,
  OPERAND_fld_AE_MULFP16X4RAS_H_d1,
  OPERAND_fld_AE_MULFP16X4RAS_H_d0,
  OPERAND_fld_AE_MULFP16X4RAS_H_q0,
  OPERAND_fld_AE_MULFP16X4S_L_d1,
  OPERAND_fld_AE_MULFP16X4S_L_d0,
  OPERAND_fld_AE_MULFP16X4S_L_q0,
  OPERAND_fld_AE_MULFP16X4RAS_L_d1,
  OPERAND_fld_AE_MULFP16X4RAS_L_d0,
  OPERAND_fld_AE_MULFP16X4RAS_L_q0,
  OPERAND_fld_fp_sem_sp32cvt_arr,
  OPERAND_fld_fp_sem_sp32cvt_i_imm5,
  OPERAND_fld_fp_sem_sp32cvt_ars,
  OPERAND_fld_AE_MAXABS16S_v1,
  OPERAND_fld_AE_MAXABS16S_v0,
  OPERAND_fld_AE_MAXABS16S_v,
  OPERAND_fld_fusion_slot40_0_14_0,
  OPERAND_fld_fusion_slot40_0_7_7,
  OPERAND_fld_fusion_slot40_0_14_12,
  OPERAND_fld_fusion_slot40_1_9_0,
  OPERAND_fld_fusion_slot40_1_9_8,
  OPERAND_fld_AE_ADDANDSUBRNG16RAS_S1_vs,
  OPERAND_fld_AE_ADDANDSUBRNG16RAS_S1_va,
  OPERAND_fld_AE_ADDANDSUBRNG16RAS_S2_vs,
  OPERAND_fld_AE_ADDANDSUBRNG16RAS_S2_va,
  OPERAND_fld_ae_sem_arithmetic_va,
  OPERAND_fld_ae_sem_arithmetic_vs,
  OPERAND_fld_AE_MULFC16RAS_H_d1_0,
  OPERAND_fld_AE_MULFC16RAS_H_d0_0,
  OPERAND_fld_AE_MULFC16RAS_H_q0_0,
  OPERAND_fld_AE_MULFC16RAS_L_d1_0,
  OPERAND_fld_AE_MULFC16RAS_L_d0_0,
  OPERAND_fld_AE_MULFC16RAS_L_q0_0,
  OPERAND_fld_AE_MULAFC16RAS_H_d1_0,
  OPERAND_fld_AE_MULAFC16RAS_H_d0_0,
  OPERAND_fld_AE_MULAFC16RAS_H_q0_0,
  OPERAND_fld_AE_MULAFC16RAS_L_d1_0,
  OPERAND_fld_AE_MULAFC16RAS_L_d0_0,
  OPERAND_fld_AE_MULAFC16RAS_L_q0_0,
  OPERAND_fld_AE_MULFC16RAS_H_d1,
  OPERAND_fld_AE_MULFC16RAS_H_d0,
  OPERAND_fld_AE_MULFC16RAS_H_q0,
  OPERAND_fld_AE_MULFC16RAS_L_d1,
  OPERAND_fld_AE_MULFC16RAS_L_d0,
  OPERAND_fld_AE_MULFC16RAS_L_q0,
  OPERAND_fld_AE_MULAFC16RAS_H_d1,
  OPERAND_fld_AE_MULAFC16RAS_H_d0,
  OPERAND_fld_AE_MULAFC16RAS_H_q0,
  OPERAND_fld_AE_MULAFC16RAS_L_d1,
  OPERAND_fld_AE_MULAFC16RAS_L_d0,
  OPERAND_fld_AE_MULAFC16RAS_L_q0,
  OPERAND_fld_AE_MULZAAAAQ16_d1,
  OPERAND_fld_AE_MULZAAAAQ16_d0,
  OPERAND_fld_AE_MULZAAAAQ16_q0,
  OPERAND_fld_AE_MULAAAAQ16_d1,
  OPERAND_fld_AE_MULAAAAQ16_d0,
  OPERAND_fld_AE_MULAAAAQ16_q0,
  OPERAND_fld_AE_MULC16S_L_d1,
  OPERAND_fld_AE_MULC16S_L_d0,
  OPERAND_fld_AE_MULC16S_L_q0,
  OPERAND_fld_AE_MULC16S_H_d1,
  OPERAND_fld_AE_MULC16S_H_d0,
  OPERAND_fld_AE_MULC16S_H_q0,
  OPERAND_fld_AE_MULAC16S_L_d1,
  OPERAND_fld_AE_MULAC16S_L_d0,
  OPERAND_fld_AE_MULAC16S_L_q0,
  OPERAND_fld_AE_MULAC16S_H_d1,
  OPERAND_fld_AE_MULAC16S_H_d0,
  OPERAND_fld_AE_MULAC16S_H_q0,
  OPERAND_fld_AE_CALCRNG3_a,
  OPERAND_fld_fusion_slot1_20_4,
  OPERAND_fld_AE_MOVFUSIONMISCV_v,
  OPERAND_fld_ae_sem_movstate1_v,
  OPERAND_fld_ae_sem_movstate2_v,
  OPERAND_fld_AE_MOVVFUSIONMISC_v,
  OPERAND_fld_AE_MOVFCRFSRV_v,
  OPERAND_fld_AE_MOVVFCRFSR_v,
  OPERAND_fld_fp_sem_movfpstate_v,
  OPERAND_ae_fld_arth_v,
  OPERAND_ae_fld_arth_v0,
  OPERAND_ae_fld_arth_v1,
  OPERAND_ae_fld_ar_to_dr_v,
  OPERAND_s3to1
};


/* Iclass table.  */

static xtensa_arg_internal Iclass_xt_iclass_rfe_stateArgs[] = {
  { { STATE_PSEXCM }, 'o' },
  { { STATE_EPC1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfde_stateArgs[] = {
  { { STATE_DEPC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_call12_args[] = {
  { { OPERAND_soffsetx4 }, 'i' },
  { { OPERAND_ar12 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call12_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call8_args[] = {
  { { OPERAND_soffsetx4 }, 'i' },
  { { OPERAND_ar8 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call8_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call4_args[] = {
  { { OPERAND_soffsetx4 }, 'i' },
  { { OPERAND_ar4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call4_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx12_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ar12 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx12_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx8_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ar8 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx8_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx4_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ar4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx4_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_entry_args[] = {
  { { OPERAND_ars_entry }, 's' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm12x8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_entry_stateArgs[] = {
  { { STATE_PSCALLINC }, 'i' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSWOE }, 'i' },
  { { STATE_WindowBase }, 'm' },
  { { STATE_WindowStart }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_movsp_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_movsp_stateArgs[] = {
  { { STATE_WindowBase }, 'i' },
  { { STATE_WindowStart }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rotw_args[] = {
  { { OPERAND_simm4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rotw_stateArgs[] = {
  { { STATE_WindowBase }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_retw_args[] = {
  { { OPERAND__ars_invisible }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_retw_stateArgs[] = {
  { { STATE_WindowBase }, 'm' },
  { { STATE_WindowStart }, 'm' },
  { { STATE_PSCALLINC }, 'o' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSWOE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfwou_stateArgs[] = {
  { { STATE_EPC1 }, 'i' },
  { { STATE_PSEXCM }, 'o' },
  { { STATE_WindowBase }, 'm' },
  { { STATE_WindowStart }, 'm' },
  { { STATE_PSOWB }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l32e_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_immrx4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32e_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_immrx4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_windowbase_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_windowbase_stateArgs[] = {
  { { STATE_WindowBase }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_windowbase_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_windowbase_stateArgs[] = {
  { { STATE_WindowBase }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_windowbase_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_windowbase_stateArgs[] = {
  { { STATE_WindowBase }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_windowstart_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_windowstart_stateArgs[] = {
  { { STATE_WindowStart }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_windowstart_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_windowstart_stateArgs[] = {
  { { STATE_WindowStart }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_windowstart_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_windowstart_stateArgs[] = {
  { { STATE_WindowStart }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_add_n_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_addi_n_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ai4const }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bz6_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm6 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_loadi4_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_lsi4x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mov_n_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_movi_n_args[] = {
  { { OPERAND_ars }, 'o' },
  { { OPERAND_simm7 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_retn_args[] = {
  { { OPERAND__ars_invisible }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_storei4_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_lsi4x4 }, 'i' }
};

static xtensa_arg_internal Iclass_rur_threadptr_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_threadptr_stateArgs[] = {
  { { STATE_THREADPTR }, 'i' }
};

static xtensa_arg_internal Iclass_wur_threadptr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_threadptr_stateArgs[] = {
  { { STATE_THREADPTR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_addi_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_simm8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_addmi_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_simm8x256 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_addsub_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bit_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bsi8_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_b4const }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bsi8b_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_bbi }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bsi8u_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_b4constu }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bst8_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bsz12_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_label12 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_call0_args[] = {
  { { OPERAND_soffsetx4 }, 'i' },
  { { OPERAND_ar0 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx0_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ar0 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_exti_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_sae }, 'i' },
  { { OPERAND_op2p1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_jump_args[] = {
  { { OPERAND_soffset }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_jumpx_args[] = {
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l16ui_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l16si_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l32i_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l32r_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_uimm16x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l8i_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_loop_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ulabel8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_loop_stateArgs[] = {
  { { STATE_LBEG }, 'o' },
  { { STATE_LEND }, 'o' },
  { { STATE_LCOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_loopz_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ulabel8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_loopz_stateArgs[] = {
  { { STATE_LBEG }, 'o' },
  { { STATE_LEND }, 'o' },
  { { STATE_LCOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_movi_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_simm12b }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_movz_args[] = {
  { { OPERAND_arr }, 'm' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_neg_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_return_args[] = {
  { { OPERAND__ars_invisible }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s16i_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32i_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32nb_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimmrx4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s8i_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sar_args[] = {
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sar_stateArgs[] = {
  { { STATE_SAR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_sari_args[] = {
  { { OPERAND_sas }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sari_stateArgs[] = {
  { { STATE_SAR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_shifts_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shifts_stateArgs[] = {
  { { STATE_SAR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shiftst_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shiftst_stateArgs[] = {
  { { STATE_SAR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shiftt_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shiftt_stateArgs[] = {
  { { STATE_SAR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_slli_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_msalp32 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_srai_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_sargt }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_srli_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_s }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sync_stateArgs[] = {
  { { STATE_XTSYNC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsil_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_s }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsil_stateArgs[] = {
  { { STATE_PSWOE }, 'i' },
  { { STATE_PSCALLINC }, 'i' },
  { { STATE_PSOWB }, 'i' },
  { { STATE_PSUM }, 'i' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSINTLEVEL }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lend_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lend_stateArgs[] = {
  { { STATE_LEND }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lend_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lend_stateArgs[] = {
  { { STATE_LEND }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lend_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lend_stateArgs[] = {
  { { STATE_LEND }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lcount_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lcount_stateArgs[] = {
  { { STATE_LCOUNT }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lcount_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lcount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_LCOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lcount_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lcount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_LCOUNT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lbeg_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lbeg_stateArgs[] = {
  { { STATE_LBEG }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lbeg_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lbeg_stateArgs[] = {
  { { STATE_LBEG }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lbeg_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lbeg_stateArgs[] = {
  { { STATE_LBEG }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_sar_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_sar_stateArgs[] = {
  { { STATE_SAR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_sar_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_sar_stateArgs[] = {
  { { STATE_SAR }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_sar_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_sar_stateArgs[] = {
  { { STATE_SAR }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_memctl_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_memctl_stateArgs[] = {
  { { STATE_MEMCTL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_memctl_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_memctl_stateArgs[] = {
  { { STATE_MEMCTL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_memctl_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_memctl_stateArgs[] = {
  { { STATE_MEMCTL }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_litbase_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_litbase_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_litbase_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_configid0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_configid0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_configid1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ps_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ps_stateArgs[] = {
  { { STATE_PSWOE }, 'i' },
  { { STATE_PSCALLINC }, 'i' },
  { { STATE_PSOWB }, 'i' },
  { { STATE_PSUM }, 'i' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSINTLEVEL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ps_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ps_stateArgs[] = {
  { { STATE_PSWOE }, 'o' },
  { { STATE_PSCALLINC }, 'o' },
  { { STATE_PSOWB }, 'o' },
  { { STATE_PSUM }, 'o' },
  { { STATE_PSEXCM }, 'o' },
  { { STATE_PSINTLEVEL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ps_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ps_stateArgs[] = {
  { { STATE_PSWOE }, 'm' },
  { { STATE_PSCALLINC }, 'm' },
  { { STATE_PSOWB }, 'm' },
  { { STATE_PSUM }, 'm' },
  { { STATE_PSEXCM }, 'm' },
  { { STATE_PSINTLEVEL }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc1_stateArgs[] = {
  { { STATE_EPC1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc1_stateArgs[] = {
  { { STATE_EPC1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc1_stateArgs[] = {
  { { STATE_EPC1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave1_stateArgs[] = {
  { { STATE_EXCSAVE1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave1_stateArgs[] = {
  { { STATE_EXCSAVE1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave1_stateArgs[] = {
  { { STATE_EXCSAVE1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc2_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc2_stateArgs[] = {
  { { STATE_EPC2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc2_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc2_stateArgs[] = {
  { { STATE_EPC2 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc2_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc2_stateArgs[] = {
  { { STATE_EPC2 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave2_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave2_stateArgs[] = {
  { { STATE_EXCSAVE2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave2_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave2_stateArgs[] = {
  { { STATE_EXCSAVE2 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave2_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave2_stateArgs[] = {
  { { STATE_EXCSAVE2 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc3_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc3_stateArgs[] = {
  { { STATE_EPC3 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc3_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc3_stateArgs[] = {
  { { STATE_EPC3 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc3_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc3_stateArgs[] = {
  { { STATE_EPC3 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave3_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave3_stateArgs[] = {
  { { STATE_EXCSAVE3 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave3_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave3_stateArgs[] = {
  { { STATE_EXCSAVE3 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave3_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave3_stateArgs[] = {
  { { STATE_EXCSAVE3 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc4_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc4_stateArgs[] = {
  { { STATE_EPC4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc4_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc4_stateArgs[] = {
  { { STATE_EPC4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc4_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc4_stateArgs[] = {
  { { STATE_EPC4 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave4_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave4_stateArgs[] = {
  { { STATE_EXCSAVE4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave4_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave4_stateArgs[] = {
  { { STATE_EXCSAVE4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave4_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave4_stateArgs[] = {
  { { STATE_EXCSAVE4 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc5_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc5_stateArgs[] = {
  { { STATE_EPC5 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc5_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc5_stateArgs[] = {
  { { STATE_EPC5 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc5_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc5_stateArgs[] = {
  { { STATE_EPC5 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave5_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave5_stateArgs[] = {
  { { STATE_EXCSAVE5 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave5_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave5_stateArgs[] = {
  { { STATE_EXCSAVE5 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave5_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave5_stateArgs[] = {
  { { STATE_EXCSAVE5 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps2_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps2_stateArgs[] = {
  { { STATE_EPS2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps2_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps2_stateArgs[] = {
  { { STATE_EPS2 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps2_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps2_stateArgs[] = {
  { { STATE_EPS2 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps3_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps3_stateArgs[] = {
  { { STATE_EPS3 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps3_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps3_stateArgs[] = {
  { { STATE_EPS3 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps3_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps3_stateArgs[] = {
  { { STATE_EPS3 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps4_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps4_stateArgs[] = {
  { { STATE_EPS4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps4_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps4_stateArgs[] = {
  { { STATE_EPS4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps4_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps4_stateArgs[] = {
  { { STATE_EPS4 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps5_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps5_stateArgs[] = {
  { { STATE_EPS5 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps5_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps5_stateArgs[] = {
  { { STATE_EPS5 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps5_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps5_stateArgs[] = {
  { { STATE_EPS5 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excvaddr_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excvaddr_stateArgs[] = {
  { { STATE_EXCVADDR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excvaddr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excvaddr_stateArgs[] = {
  { { STATE_EXCVADDR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excvaddr_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excvaddr_stateArgs[] = {
  { { STATE_EXCVADDR }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_depc_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_depc_stateArgs[] = {
  { { STATE_DEPC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_depc_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_depc_stateArgs[] = {
  { { STATE_DEPC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_depc_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_depc_stateArgs[] = {
  { { STATE_DEPC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_exccause_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_exccause_stateArgs[] = {
  { { STATE_EXCCAUSE }, 'i' },
  { { STATE_XTSYNC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_exccause_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_exccause_stateArgs[] = {
  { { STATE_EXCCAUSE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_exccause_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_exccause_stateArgs[] = {
  { { STATE_EXCCAUSE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_misc0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_misc0_stateArgs[] = {
  { { STATE_MISC0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_misc0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_misc0_stateArgs[] = {
  { { STATE_MISC0 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_misc0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_misc0_stateArgs[] = {
  { { STATE_MISC0 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_misc1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_misc1_stateArgs[] = {
  { { STATE_MISC1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_misc1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_misc1_stateArgs[] = {
  { { STATE_MISC1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_misc1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_misc1_stateArgs[] = {
  { { STATE_MISC1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_prid_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_vecbase_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_vecbase_stateArgs[] = {
  { { STATE_VECBASE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_vecbase_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_vecbase_stateArgs[] = {
  { { STATE_VECBASE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_vecbase_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_vecbase_stateArgs[] = {
  { { STATE_VECBASE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_aa_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_aa_stateArgs[] = {
  { { STATE_ACC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_ad_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_my }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_ad_stateArgs[] = {
  { { STATE_ACC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_da_args[] = {
  { { OPERAND_mx }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_da_stateArgs[] = {
  { { STATE_ACC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_dd_args[] = {
  { { OPERAND_mx }, 'i' },
  { { OPERAND_my }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_dd_stateArgs[] = {
  { { STATE_ACC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_aa_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_aa_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_ad_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_my }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_ad_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_da_args[] = {
  { { OPERAND_mx }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_da_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_dd_args[] = {
  { { OPERAND_mx }, 'i' },
  { { OPERAND_my }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_dd_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16al_da_args[] = {
  { { OPERAND_mw }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_mx }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16al_da_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16al_dd_args[] = {
  { { OPERAND_mw }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_mx }, 'i' },
  { { OPERAND_my }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16al_dd_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_l_args[] = {
  { { OPERAND_mw }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_m0_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_mr0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_m0_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_mr0 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_m0_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_mr0 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_m1_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_mr1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_m1_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_mr1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_m1_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_mr1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_m2_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_mr2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_m2_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_mr2 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_m2_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_mr2 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_m3_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_mr3 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_m3_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_mr3 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_m3_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_mr3 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_acclo_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_acclo_stateArgs[] = {
  { { STATE_ACC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_acclo_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_acclo_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_acclo_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_acclo_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_acchi_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_acchi_stateArgs[] = {
  { { STATE_ACC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_acchi_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_acchi_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_acchi_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_acchi_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfi_args[] = {
  { { OPERAND_s }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfi_stateArgs[] = {
  { { STATE_PSWOE }, 'o' },
  { { STATE_PSCALLINC }, 'o' },
  { { STATE_PSOWB }, 'o' },
  { { STATE_PSUM }, 'o' },
  { { STATE_PSEXCM }, 'o' },
  { { STATE_PSINTLEVEL }, 'o' },
  { { STATE_EPC1 }, 'i' },
  { { STATE_EPC2 }, 'i' },
  { { STATE_EPC3 }, 'i' },
  { { STATE_EPC4 }, 'i' },
  { { STATE_EPC5 }, 'i' },
  { { STATE_EPS2 }, 'i' },
  { { STATE_EPS3 }, 'i' },
  { { STATE_EPS4 }, 'i' },
  { { STATE_EPS5 }, 'i' },
  { { STATE_InOCDMode }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_wait_args[] = {
  { { OPERAND_s }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wait_stateArgs[] = {
  { { STATE_PSINTLEVEL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_interrupt_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_interrupt_stateArgs[] = {
  { { STATE_INTERRUPT }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intset_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intset_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intclear_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intclear_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_intenable_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_intenable_stateArgs[] = {
  { { STATE_INTENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intenable_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intenable_stateArgs[] = {
  { { STATE_INTENABLE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_intenable_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_intenable_stateArgs[] = {
  { { STATE_INTENABLE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_break_args[] = {
  { { OPERAND_imms }, 'i' },
  { { OPERAND_immt }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_break_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSINTLEVEL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_break_n_args[] = {
  { { OPERAND_imms }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_break_n_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSINTLEVEL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreaka0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreaka0_stateArgs[] = {
  { { STATE_DBREAKA0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreaka0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreaka0_stateArgs[] = {
  { { STATE_DBREAKA0 }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreaka0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreaka0_stateArgs[] = {
  { { STATE_DBREAKA0 }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreakc0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreakc0_stateArgs[] = {
  { { STATE_DBREAKC0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreakc0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreakc0_stateArgs[] = {
  { { STATE_DBREAKC0 }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreakc0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreakc0_stateArgs[] = {
  { { STATE_DBREAKC0 }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreaka1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreaka1_stateArgs[] = {
  { { STATE_DBREAKA1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreaka1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreaka1_stateArgs[] = {
  { { STATE_DBREAKA1 }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreaka1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreaka1_stateArgs[] = {
  { { STATE_DBREAKA1 }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreakc1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreakc1_stateArgs[] = {
  { { STATE_DBREAKC1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreakc1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreakc1_stateArgs[] = {
  { { STATE_DBREAKC1 }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreakc1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreakc1_stateArgs[] = {
  { { STATE_DBREAKC1 }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreaka0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreaka0_stateArgs[] = {
  { { STATE_IBREAKA0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreaka0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreaka0_stateArgs[] = {
  { { STATE_IBREAKA0 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreaka0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreaka0_stateArgs[] = {
  { { STATE_IBREAKA0 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreaka1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreaka1_stateArgs[] = {
  { { STATE_IBREAKA1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreaka1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreaka1_stateArgs[] = {
  { { STATE_IBREAKA1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreaka1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreaka1_stateArgs[] = {
  { { STATE_IBREAKA1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreakenable_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreakenable_stateArgs[] = {
  { { STATE_IBREAKENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreakenable_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreakenable_stateArgs[] = {
  { { STATE_IBREAKENABLE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreakenable_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreakenable_stateArgs[] = {
  { { STATE_IBREAKENABLE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_debugcause_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_debugcause_stateArgs[] = {
  { { STATE_DEBUGCAUSE }, 'i' },
  { { STATE_DBNUM }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_debugcause_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_debugcause_stateArgs[] = {
  { { STATE_DEBUGCAUSE }, 'o' },
  { { STATE_DBNUM }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_debugcause_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_debugcause_stateArgs[] = {
  { { STATE_DEBUGCAUSE }, 'm' },
  { { STATE_DBNUM }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_icount_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_icount_stateArgs[] = {
  { { STATE_ICOUNT }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_icount_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_icount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_ICOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_icount_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_icount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_ICOUNT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_icountlevel_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_icountlevel_stateArgs[] = {
  { { STATE_ICOUNTLEVEL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_icountlevel_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_icountlevel_stateArgs[] = {
  { { STATE_ICOUNTLEVEL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_icountlevel_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_icountlevel_stateArgs[] = {
  { { STATE_ICOUNTLEVEL }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ddr_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ddr_stateArgs[] = {
  { { STATE_DDR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ddr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ddr_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_DDR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ddr_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ddr_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_DDR }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_lddr32_p_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_lddr32_p_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_InOCDMode }, 'i' },
  { { STATE_DDR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_sddr32_p_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_sddr32_p_stateArgs[] = {
  { { STATE_InOCDMode }, 'i' },
  { { STATE_DDR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfdo_args[] = {
  { { OPERAND_imms }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfdo_stateArgs[] = {
  { { STATE_InOCDMode }, 'm' },
  { { STATE_EPC4 }, 'i' },
  { { STATE_PSWOE }, 'o' },
  { { STATE_PSCALLINC }, 'o' },
  { { STATE_PSOWB }, 'o' },
  { { STATE_PSUM }, 'o' },
  { { STATE_PSEXCM }, 'o' },
  { { STATE_PSINTLEVEL }, 'o' },
  { { STATE_EPS4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfdd_stateArgs[] = {
  { { STATE_InOCDMode }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_mmid_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_mmid_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_bbool1_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_bs }, 'i' },
  { { OPERAND_bt }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bbool4_args[] = {
  { { OPERAND_bt }, 'o' },
  { { OPERAND_bs4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bbool8_args[] = {
  { { OPERAND_bt }, 'o' },
  { { OPERAND_bs8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bbranch_args[] = {
  { { OPERAND_bs }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bmove_args[] = {
  { { OPERAND_arr }, 'm' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_bt }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_RSR_BR_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_brall }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_WSR_BR_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_brall }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_XSR_BR_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_brall }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccount_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccount_stateArgs[] = {
  { { STATE_CCOUNT }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccount_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_CCOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccount_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_CCOUNT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare0_stateArgs[] = {
  { { STATE_CCOMPARE0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare0_stateArgs[] = {
  { { STATE_CCOMPARE0 }, 'o' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare0_stateArgs[] = {
  { { STATE_CCOMPARE0 }, 'm' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare1_stateArgs[] = {
  { { STATE_CCOMPARE1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare1_stateArgs[] = {
  { { STATE_CCOMPARE1 }, 'o' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare1_stateArgs[] = {
  { { STATE_CCOMPARE1 }, 'm' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_idtlb_args[] = {
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_idtlb_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rdtlb_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wdtlb_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wdtlb_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_iitlb_args[] = {
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_ritlb_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_witlb_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_cpenable_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_cpenable_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_cpenable_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_cpenable_stateArgs[] = {
  { { STATE_CPENABLE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_cpenable_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_cpenable_stateArgs[] = {
  { { STATE_CPENABLE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_clamp_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_tp7 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_minmax_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_nsa_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sx_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_tp7 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l32ai_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32ri_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32c1i_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32c1i_stateArgs[] = {
  { { STATE_SCOMPARE1 }, 'i' },
  { { STATE_XTSYNC }, 'i' },
  { { STATE_SCOMPARE1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_scompare1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_scompare1_stateArgs[] = {
  { { STATE_SCOMPARE1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_scompare1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_scompare1_stateArgs[] = {
  { { STATE_SCOMPARE1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_scompare1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_scompare1_stateArgs[] = {
  { { STATE_SCOMPARE1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_atomctl_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_atomctl_stateArgs[] = {
  { { STATE_ATOMCTL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_atomctl_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_atomctl_stateArgs[] = {
  { { STATE_ATOMCTL }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_atomctl_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_atomctl_stateArgs[] = {
  { { STATE_ATOMCTL }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_div_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rer_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rer_stateArgs[] = {
  { { STATE_ERI_RAW_INTERLOCK }, 'i' }
};

static xtensa_interface Iclass_xt_iclass_rer_intfArgs[] = {
  INTERFACE_ERI_RD_In,
  INTERFACE_ERI_RD_Out
};

static xtensa_arg_internal Iclass_xt_iclass_wer_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wer_stateArgs[] = {
  { { STATE_ERI_RAW_INTERLOCK }, 'o' }
};

static xtensa_interface Iclass_xt_iclass_wer_intfArgs[] = {
  INTERFACE_ERI_WR_In,
  INTERFACE_ERI_WR_Out
};

static xtensa_arg_internal Iclass_xt_iclass_wb15_0_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_xt_wbr15_label }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wb15_1_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_b4const }, 'i' },
  { { OPERAND_xt_wbr15_label }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wb15_2_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_b4constu }, 'i' },
  { { OPERAND_xt_wbr15_label }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wb15_3_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_bbi }, 'i' },
  { { OPERAND_xt_wbr15_label }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wb15_4_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_xt_wbr15_label }, 'i' }
};

static xtensa_arg_internal Iclass_rur_ae_bithead_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_bithead_stateArgs[] = {
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_bithead_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_bithead_stateArgs[] = {
  { { STATE_AE_BITHEAD }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_ae_cbegin0_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_cbegin0_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cbegin0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cbegin0_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_ae_cend0_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_cend0_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cend0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cend0_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ic_sext16_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_ic_zext16_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_ic_zext8_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_ic_clamps16_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_rur_fcr_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_fcr_stateArgs[] = {
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_fcr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_fcr_stateArgs[] = {
  { { STATE_RoundMode }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_fsr_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_fsr_stateArgs[] = {
  { { STATE_InvalidFlag }, 'i' },
  { { STATE_DivZeroFlag }, 'i' },
  { { STATE_OverflowFlag }, 'i' },
  { { STATE_UnderflowFlag }, 'i' },
  { { STATE_InexactFlag }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_fsr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_fsr_stateArgs[] = {
  { { STATE_InvalidFlag }, 'o' },
  { { STATE_DivZeroFlag }, 'o' },
  { { STATE_OverflowFlag }, 'o' },
  { { STATE_UnderflowFlag }, 'o' },
  { { STATE_InexactFlag }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_expstate_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_expstate_stateArgs[] = {
  { { STATE_EXPSTATE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_expstate_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_expstate_stateArgs[] = {
  { { STATE_EXPSTATE }, 'o' }
};

static xtensa_arg_internal Iclass_iclass_READ_IMPWIRE_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_interface Iclass_iclass_READ_IMPWIRE_intfArgs[] = {
  INTERFACE_IMPWIRE
};

static xtensa_arg_internal Iclass_iclass_SETB_EXPSTATE_args[] = {
  { { OPERAND_bitindex }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_SETB_EXPSTATE_stateArgs[] = {
  { { STATE_EXPSTATE }, 'm' }
};

static xtensa_arg_internal Iclass_iclass_CLRB_EXPSTATE_args[] = {
  { { OPERAND_bitindex }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_CLRB_EXPSTATE_stateArgs[] = {
  { { STATE_EXPSTATE }, 'm' }
};

static xtensa_arg_internal Iclass_iclass_WRMSK_EXPSTATE_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_WRMSK_EXPSTATE_stateArgs[] = {
  { { STATE_EXPSTATE }, 'm' }
};

static xtensa_arg_internal Iclass_RUR_AE_OVERFLOW_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_OVERFLOW_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_OVERFLOW_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_OVERFLOW_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_SAR_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_SAR_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_SAR_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_SAR_stateArgs[] = {
  { { STATE_AE_SAR }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_BITPTR_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_BITPTR_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_BITPTR_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_BITPTR_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_BITSUSED_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_BITSUSED_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_BITSUSED_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_BITSUSED_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_TABLESIZE_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_TABLESIZE_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_TABLESIZE_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_TABLESIZE_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_FIRST_TS_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_FIRST_TS_stateArgs[] = {
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_FIRST_TS_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_FIRST_TS_stateArgs[] = {
  { { STATE_AE_FIRST_TS }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_NEXTOFFSET_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_NEXTOFFSET_stateArgs[] = {
  { { STATE_AE_NEXTOFFSET }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_NEXTOFFSET_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_NEXTOFFSET_stateArgs[] = {
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_SEARCHDONE_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_SEARCHDONE_stateArgs[] = {
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_SEARCHDONE_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_SEARCHDONE_stateArgs[] = {
  { { STATE_AE_SEARCHDONE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_CWRAP_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_CWRAP_stateArgs[] = {
  { { STATE_AE_CWRAP }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_CWRAP_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_CWRAP_stateArgs[] = {
  { { STATE_AE_CWRAP }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVCIRCV_args[] = {
  { { OPERAND_opnd_ae_sem_movstate1_v }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVCIRCV_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'o' },
  { { STATE_AE_CEND0 }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVVCIRC_args[] = {
  { { OPERAND_opnd_ae_sem_movstate1_v }, 'o' }
};

static xtensa_arg_internal Iclass_AE_MOVVCIRC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVFUSIONMISCV_args[] = {
  { { OPERAND_opnd_ae_sem_movstate2_v }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVFUSIONMISCV_stateArgs[] = {
  { { STATE_AE_CWRAP }, 'o' },
  { { STATE_AE_OVERFLOW }, 'o' },
  { { STATE_AE_SAR }, 'o' },
  { { STATE_AE_BITHEAD }, 'o' },
  { { STATE_AE_BITPTR }, 'o' },
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVVFUSIONMISC_args[] = {
  { { OPERAND_opnd_ae_sem_movstate2_v }, 'o' }
};

static xtensa_arg_internal Iclass_AE_MOVVFUSIONMISC_stateArgs[] = {
  { { STATE_AE_CWRAP }, 'i' },
  { { STATE_AE_OVERFLOW }, 'i' },
  { { STATE_AE_SAR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVTABLEFIRSTSEARCHNEXTV_args[] = {
  { { OPERAND_opnd_ae_sem_movstate1_v }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVTABLEFIRSTSEARCHNEXTV_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'o' },
  { { STATE_AE_FIRST_TS }, 'o' },
  { { STATE_AE_SEARCHDONE }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVVTABLEFIRSTSEARCHNEXT_args[] = {
  { { OPERAND_opnd_ae_sem_movstate1_v }, 'o' }
};

static xtensa_arg_internal Iclass_AE_MOVVTABLEFIRSTSEARCHNEXT_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'i' },
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_AE_NEXTOFFSET }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4F_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4F_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4F_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4F_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4F_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4F_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4F_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4F_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X8_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X8_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X8_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64pos }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X8_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_IU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_XU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_IU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_XU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_IU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_XU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64pos }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64pos }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_L32X2_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_L32X2_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64pos }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_L16X4_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_L16X4_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8X4F_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8X4F_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8X4F_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8X4F_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_IU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_XU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64pos }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64pos }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S32X2_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S32X2_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64pos }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S16X4_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S16X4_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4RNG_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4RNG_I_stateArgs[] = {
  { { STATE_AE_SAR }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4RNG_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64pos }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4RNG_IP_stateArgs[] = {
  { { STATE_AE_SAR }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4RNG_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4RNG_X_stateArgs[] = {
  { { STATE_AE_SAR }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4RNG_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4RNG_XP_stateArgs[] = {
  { { STATE_AE_SAR }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_IU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_XU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_IU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_XU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ZALIGN64_args[] = {
  { { OPERAND_ae_uu_uu }, 'o' }
};

static xtensa_arg_internal Iclass_AE_ZALIGN64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LALIGN64_I_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LALIGN64_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SALIGN64_I_args[] = {
  { { OPERAND_ae_ls_su }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SALIGN64_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVALIGN_args[] = {
  { { OPERAND_ae_uu_uu }, 'o' },
  { { OPERAND_ae_uu_v }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVALIGN_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA64_PP_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA64_PP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24POS_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24POS_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24X2POS_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24X2POS_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2POS_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2POS_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4POS_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4POS_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24NEG_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24NEG_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24X2NEG_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24X2NEG_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2NEG_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2NEG_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4NEG_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4NEG_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA64POS_FP_args[] = {
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA64POS_FP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA64NEG_FP_args[] = {
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA64NEG_FP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_IC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_IC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_IC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24_IC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_IC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_IC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_IC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_IC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_IC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_IC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v1 }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_I_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v1 }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_IP_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v1 }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_X_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v1 }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_XP_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v1 }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v1 }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_I_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v1 }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_IP_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v1 }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_X_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v1 }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_XP_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v1 }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2RA64S_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v2 }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_v1 }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S32X2RA64S_IP_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24X2RA64S_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v2 }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_v1 }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S24X2RA64S_IP_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDBRBA32_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEL16I_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v1 }, 'i' },
  { { OPERAND_ae_selimm }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEL16I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SHORTSWAP_args[] = {
  { { OPERAND_opnd_ae_sem_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SHORTSWAP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_INTSWAP_args[] = {
  { { OPERAND_opnd_ae_sem_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_INTSWAP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT16X4_args[] = {
  { { OPERAND_opnd_ae_sem_cmov_v }, 'm' },
  { { OPERAND_opnd_ae_sem_cmov_v0 }, 'i' },
  { { OPERAND_bt4 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT16X4_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF16X4_args[] = {
  { { OPERAND_opnd_ae_sem_cmov_v }, 'm' },
  { { OPERAND_opnd_ae_sem_cmov_v0 }, 'i' },
  { { OPERAND_bt4 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF16X4_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT32X2_args[] = {
  { { OPERAND_opnd_ae_sem_cmov_v }, 'm' },
  { { OPERAND_opnd_ae_sem_cmov_v0 }, 'i' },
  { { OPERAND_bt2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT32X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF32X2_args[] = {
  { { OPERAND_opnd_ae_sem_cmov_v }, 'm' },
  { { OPERAND_opnd_ae_sem_cmov_v0 }, 'i' },
  { { OPERAND_bt2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF32X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA32X2_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA32X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA32_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA16X2_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA16X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA16_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVI_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_movi_imm }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVI_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCP24A32X2_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCP24A32X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT16X4_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT16X4_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT32X2F16_32_args[] = {
  { { OPERAND_opnd_ae_sem_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT32X2F16_32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT32X2F16_10_args[] = {
  { { OPERAND_opnd_ae_sem_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT32X2F16_10_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32X2D16_32_args[] = {
  { { OPERAND_opnd_ae_sem_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32X2D16_32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32X2D16_10_args[] = {
  { { OPERAND_opnd_ae_sem_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32X2D16_10_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTA32F24S_L_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTA32F24S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTA32F24S_H_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTA32F24S_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_LL_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_LH_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_HL_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_HL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_HH_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCP24Q48X2_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCP24Q48X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32X2F64S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_sd }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32X2F64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCI32X2F64S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_sd }, 'i' },
  { { OPERAND_ae_osa16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCI32X2F64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCI16X4F32S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_sd }, 'i' },
  { { OPERAND_ae_osa16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCI16X4F32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32F64S_L_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_sd }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32F64S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCI32F64S_L_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_sd }, 'i' },
  { { OPERAND_ae_osa16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCI32F64S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCP16_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCP16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F64SSYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F64SSYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F64SASYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F64SASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F48SSYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F48SSYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F48SASYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F48SASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND16X4F32SSYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND16X4F32SSYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND16X4F32SASYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND16X4F32SASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND24X2F48SSYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND24X2F48SSYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND24X2F48SASYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND24X2F48SASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16Q48X2SYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16Q48X2SYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16Q48X2ASYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16Q48X2ASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MINABS32S_args[] = {
  { { OPERAND_opnd_ae_sem_cmpp_v }, 'o' },
  { { OPERAND_opnd_ae_sem_cmpp_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MINABS32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAXABS32S_args[] = {
  { { OPERAND_opnd_ae_sem_cmpp_v }, 'o' },
  { { OPERAND_opnd_ae_sem_cmpp_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAXABS32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16F24SYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16F24SYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16F24ASYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16F24ASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOV_args[] = {
  { { OPERAND_opnd_ae_sem_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOV_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT64_args[] = {
  { { OPERAND_opnd_ae_sem_cmov_v }, 'm' },
  { { OPERAND_opnd_ae_sem_cmov_v0 }, 'i' },
  { { OPERAND_bt }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF64_args[] = {
  { { OPERAND_opnd_ae_sem_cmov_v }, 'm' },
  { { OPERAND_opnd_ae_sem_cmov_v0 }, 'i' },
  { { OPERAND_bt }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTQ56A32S_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTQ56A32S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT48A32_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT48A32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT64A32_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT64A32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTQ56P32S_L_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTQ56P32S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTQ56P32S_H_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTQ56P32S_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT64F32_H_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT64F32_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT48S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT48S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SATQ56S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SATQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT24S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCQ32_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCQ32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MINABS64S_args[] = {
  { { OPERAND_opnd_ae_sem_cmpp_v }, 'o' },
  { { OPERAND_opnd_ae_sem_cmpp_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MINABS64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAXABS64S_args[] = {
  { { OPERAND_opnd_ae_sem_cmpp_v }, 'o' },
  { { OPERAND_opnd_ae_sem_cmpp_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAXABS64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSQ32F48SYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSQ32F48SYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSQ32F48ASYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSQ32F48ASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32Q48_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32Q48_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD32_L_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD32_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD32_H_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD32_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_3_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_2_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_1_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_0_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRA64_32_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRA64_32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_PKSR32_0_args[] = {
  { { OPERAND_opnd_ae_sem_pks_d }, 'o' },
  { { OPERAND_opnd_ae_sem_pks_s }, 'i' },
  { { OPERAND_ae_imm2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_PKSR32_0_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_PKSR24_0_args[] = {
  { { OPERAND_opnd_ae_sem_pks_d }, 'o' },
  { { OPERAND_opnd_ae_sem_pks_s }, 'i' },
  { { OPERAND_ae_imm2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_PKSR24_0_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA16P24S_L_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA16P24S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA16P24S_H_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA16P24S_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB32_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSUB32_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSUB32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBADD32_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBADD32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD16_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB16_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG32_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS32_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD24S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB24S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB32S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSUB32S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSUB32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBADD32S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBADD32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD16S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB16S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG24S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS24S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG32S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG32S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS32S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS32S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG16S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG16S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS16S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS16S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CONJ16S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CONJ16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC16JS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC16JS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC16JS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC16JS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC16JS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC16JS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC16JS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC16JS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT16_args[] = {
  { { OPERAND_br4 }, 'o' },
  { { OPERAND_opnd_ae_sem_cmpp_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE16_args[] = {
  { { OPERAND_br4 }, 'o' },
  { { OPERAND_opnd_ae_sem_cmpp_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ16_args[] = {
  { { OPERAND_br4 }, 'o' },
  { { OPERAND_opnd_ae_sem_cmpp_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT32_args[] = {
  { { OPERAND_br2 }, 'o' },
  { { OPERAND_opnd_ae_sem_cmpp_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE32_args[] = {
  { { OPERAND_br2 }, 'o' },
  { { OPERAND_opnd_ae_sem_cmpp_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ32_args[] = {
  { { OPERAND_br2 }, 'o' },
  { { OPERAND_opnd_ae_sem_cmpp_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MIN32_args[] = {
  { { OPERAND_opnd_ae_sem_cmpp_v }, 'o' },
  { { OPERAND_opnd_ae_sem_cmpp_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MIN32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAX32_args[] = {
  { { OPERAND_opnd_ae_sem_cmpp_v }, 'o' },
  { { OPERAND_opnd_ae_sem_cmpp_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAX32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD64_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB64_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG64_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS64_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSQ56S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBSQ56S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBSQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD64S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB64S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEGSQ56S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEGSQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABSSQ56S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABSSQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG64S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS64S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_AND_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_AND_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NAND_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NAND_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_OR_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_OR_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_XOR_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_XOR_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI24_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLI24_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLI24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI24_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS24_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS24_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLS24_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLS24_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAS24_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAS24_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI16_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI16R_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI16R_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI32_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLI32_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLI32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI32_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI32R_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI32R_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS32_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS32_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLS32_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLS32_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAS32_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAS32_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA32_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLA32_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLA32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI16S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA16S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA16S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA16RS_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA16RS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI24S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS24S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI32S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS32S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA32S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32RS_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32RS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLASQ56_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLASQ56_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLSQ56_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLSQ56_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRASQ56_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRASQ56_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAAQ56_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAAQ56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLAQ56_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLAQ56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAAQ56_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAAQ56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI64_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLI64_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLI64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI64_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS64_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS64_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLS64_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLS64_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAS64_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAS64_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA64_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLA64_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLA64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA64_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAISQ56S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAISQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLASSQ56S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLASSQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAASQ56S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAASQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI64S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS64S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA64S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT64_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_opnd_ae_sem_cmpp_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE64_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_opnd_ae_sem_cmpp_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ64_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_opnd_ae_sem_cmpp_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAX64_args[] = {
  { { OPERAND_opnd_ae_sem_cmpp_v }, 'o' },
  { { OPERAND_opnd_ae_sem_cmpp_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAX64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MIN64_args[] = {
  { { OPERAND_opnd_ae_sem_cmpp_v }, 'o' },
  { { OPERAND_opnd_ae_sem_cmpp_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MIN64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSA64_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSA64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSAZ16_0_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSAZ16_0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSAZ32_L_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSAZ32_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32U_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32U_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32U_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32U_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32U_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32U_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_33_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_33_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_22_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_32_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_32_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_21_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_21_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_31_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_31_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_30_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_30_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_10_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_10_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_20_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_20_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_11_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_11_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_33_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_33_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_22_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_32_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_32_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_21_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_21_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_31_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_31_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_30_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_30_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_10_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_10_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_20_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_20_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_11_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_11_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_33_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_33_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_22_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_32_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_32_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_21_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_21_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_31_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_31_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_30_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_30_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_10_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_10_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_20_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_20_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_11_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_11_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_33_22_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_33_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_13_02_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_13_02_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_11_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_11_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_33_22_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_33_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_13_02_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_13_02_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_11_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_11_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_33_22_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_33_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_13_02_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_13_02_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_11_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_11_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_33_22_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_33_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_13_02_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_13_02_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_11_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_11_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16U_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16U_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16U_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16U_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16U_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16U_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP24X2RA_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP24X2RA_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP24X2R_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP24X2R_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP24X2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP24X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP24X2RA_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP24X2RA_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP24X2R_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP24X2R_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP24X2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP24X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP24X2RA_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP24X2RA_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP24X2R_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP24X2R_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP24X2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP24X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD24_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD24_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD24_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD24_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD24_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD24_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD24_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD24_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD24_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD24_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD24_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD24_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD24_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD24_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD24_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD24_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD24_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD24_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD24_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD24_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD24_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD24_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD24_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD24_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD24_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD24_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD24_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD24_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD24_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD24_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H2_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H2_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H0_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H0_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H2_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H2_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H0_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H0_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H2_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H2_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H0_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H0_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H2_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H2_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H0_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H0_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X16X2_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X16X2_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X16X2_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X16X2_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X16X2_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X16X2_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X16X2_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X16X2_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X16X2_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X16X2_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X16X2_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X16X2_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCR32X16RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCR32X16RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCR32X16RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCR32X16RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCI32X16RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCI32X16RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCI32X16RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCI32X16RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCR32X16RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCR32X16RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCR32X16RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCR32X16RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCI32X16RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCI32X16RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCI32X16RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCI32X16RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X2_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X2_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X2_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X2_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X2_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X2_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X2_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X2_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X2_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X2_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X2_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X2_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4S_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4S_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULCR24_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULCR24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCR24RA_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCR24RA_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULCR32X16_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULCR32X16_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULCR32X16_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULCR32X16_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULCI24_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULCI24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCI24RA_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCI24RA_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULCI32X16_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULCI32X16_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULCI32X16_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULCI32X16_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULACR24_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULACR24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCR24RA_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCR24RA_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULACR32X16_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULACR32X16_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULACR32X16_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULACR32X16_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULACI24_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULACI24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCI24RA_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCI24RA_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULACI32X16_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULACI32X16_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULACI32X16_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULACI32X16_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16X4SS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q1 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16X4SS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16X4SS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q1 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16X4SS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16X4SS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q1 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16X4SS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16X4SS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16X4SS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16X4SS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16X4SS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16X4SS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16X4SS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD24X2_FIR_H_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q1 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d2_0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD24X2_FIR_H_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD24X2_FIR_H_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d3 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD24X2_FIR_H_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_HH_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q1 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d2_0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_HH_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_HH_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d3 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_HH_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_HL_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q1 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d2_0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_HL_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_HL_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d3 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_HL_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD24X2_FIR_H_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q1 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d2_0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD24X2_FIR_H_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD24X2_FIR_H_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d3 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD24X2_FIR_H_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_HH_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q1 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d2_0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_HH_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_HH_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d3 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_HH_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_HL_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q1 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d2_0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_HL_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_HL_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d3 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_HL_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL16X4_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q1 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL16X4_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA16X4_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q1 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA16X4_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS16X4_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q1 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS16X4_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL16X4_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL16X4_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA16X4_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA16X4_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS16X4_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS16X4_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC16S_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC16S_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC16S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC16S_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC16S_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC16S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFC16RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFC16RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFC16RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFC16RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFC16RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFC16RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFC16RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFC16RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAAAQ16_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAAAQ16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAAAQ16_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAAAQ16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL16JS_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL16JS_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CALCRNG3_args[] = {
  { { OPERAND_opnd_AE_CALCRNG3_a }, 'o' }
};

static xtensa_arg_internal Iclass_AE_CALCRNG3_stateArgs[] = {
  { { STATE_AE_SAR }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDANDSUBRNG16RAS_S1_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_va }, 'm' },
  { { OPERAND_opnd_ae_sem_arithmetic_vs }, 'm' }
};

static xtensa_arg_internal Iclass_AE_ADDANDSUBRNG16RAS_S1_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDANDSUBRNG16RAS_S2_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_va }, 'm' },
  { { OPERAND_opnd_ae_sem_arithmetic_vs }, 'm' }
};

static xtensa_arg_internal Iclass_AE_ADDANDSUBRNG16RAS_S2_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAXABS16S_args[] = {
  { { OPERAND_opnd_ae_sem_cmpp_v }, 'o' },
  { { OPERAND_opnd_ae_sem_cmpp_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmpp_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAXABS16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MULL_args[] = {
  { { OPERAND_stage3_ar_operand }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_MULUH_args[] = {
  { { OPERAND_stage3_ar_operand }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_MULSH_args[] = {
  { { OPERAND_stage3_ar_operand }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DIV64D32_H_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'm' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DIV64D32_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DIV64D32_L_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'm' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DIV64D32_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SHA32_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL32T_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL32T_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_SEARCHDONE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL16T_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL16T_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_SEARCHDONE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_stateArgs[] = {
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_IP_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_IP_stateArgs[] = {
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_IC_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDSHT_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDSHT_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_AE_FIRST_TS }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_AE_TABLESIZE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LB_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LB_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBI_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBI_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBK_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBK_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBKI_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBKI_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBS_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBS_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBSI_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBSI_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_IC_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_IC_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_IP_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_IP_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_IP_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_IP_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLEL32T_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_stage3_ar_operand }, 'm' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLEL32T_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLEL16T_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_stage3_ar_operand }, 'm' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLEL16T_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_ae_ohba2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLES16C_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLES16C_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_NEXTOFFSET }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBF_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SBF_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_IC_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_IC_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_ae_ohba2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLES16C_IC_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLES16C_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_NEXTOFFSET }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBF_IC_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SBF_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_IP_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_IP_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_IP_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_ae_ohba2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_IP_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLES16C_IP_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLES16C_IP_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_NEXTOFFSET }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBF_IP_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SBF_IP_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8IP_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_lsimm8_2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16IP_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_lsimm16_2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32IP_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_lsimm32_2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16SI_N_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_uimm2x2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16UI_N_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_uimm2x2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16I_N_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_uimm2x2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ZEROB_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_opnd_AE_ZEROB_v0 }, 'i' },
  { { OPERAND_opnd_AE_ZEROB_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ZEROB_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' },
  { { OPERAND_ae_opnd_tp7 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_L_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v2 }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_v1 }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S32X2_L_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVFCRFSRV_args[] = {
  { { OPERAND_opnd_fp_sem_movfpstate_v }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVFCRFSRV_stateArgs[] = {
  { { STATE_RoundMode }, 'o' },
  { { STATE_InvalidFlag }, 'o' },
  { { STATE_DivZeroFlag }, 'o' },
  { { STATE_OverflowFlag }, 'o' },
  { { STATE_UnderflowFlag }, 'o' },
  { { STATE_InexactFlag }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVVFCRFSR_args[] = {
  { { OPERAND_opnd_fp_sem_movfpstate_v }, 'o' }
};

static xtensa_arg_internal Iclass_AE_MOVVFCRFSR_stateArgs[] = {
  { { STATE_RoundMode }, 'i' },
  { { STATE_InvalidFlag }, 'i' },
  { { STATE_DivZeroFlag }, 'i' },
  { { STATE_OverflowFlag }, 'i' },
  { { STATE_UnderflowFlag }, 'i' },
  { { STATE_InexactFlag }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ABS_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_ABS_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_NEG_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_NEG_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_NEG_LH_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_NEG_LH_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVEQZ_S_args[] = {
  { { OPERAND_frr }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_MOVEQZ_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVNEZ_S_args[] = {
  { { OPERAND_frr }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_MOVNEZ_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVLTZ_S_args[] = {
  { { OPERAND_frr }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_MOVLTZ_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVGEZ_S_args[] = {
  { { OPERAND_frr }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_MOVGEZ_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVF_S_args[] = {
  { { OPERAND_frr }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_bt }, 'i' }
};

static xtensa_arg_internal Iclass_MOVF_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVT_S_args[] = {
  { { OPERAND_frr }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_bt }, 'i' }
};

static xtensa_arg_internal Iclass_MOVT_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WFR_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_WFR_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RFR_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_RFR_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_TRUNC_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_opnd_fp_sem_sp32cvt_i_imm5 }, 'i' }
};

static xtensa_arg_internal Iclass_TRUNC_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_UTRUNC_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_opnd_fp_sem_sp32cvt_i_imm5 }, 'i' }
};

static xtensa_arg_internal Iclass_UTRUNC_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_FLOAT_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_opnd_fp_sem_sp32cvt_i_imm5 }, 'i' }
};

static xtensa_arg_internal Iclass_FLOAT_S_stateArgs[] = {
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_UFLOAT_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_opnd_fp_sem_sp32cvt_i_imm5 }, 'i' }
};

static xtensa_arg_internal Iclass_UFLOAT_S_stateArgs[] = {
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_FICEIL_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_FICEIL_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_FIFLOOR_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_FIFLOOR_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_FIROUND_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_FIROUND_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_FITRUNC_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_FITRUNC_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_FIRINT_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_FIRINT_S_stateArgs[] = {
  { { STATE_RoundMode }, 'i' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_UN_S_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_UN_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ULT_S_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_ULT_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ULE_S_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_ULE_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_UEQ_S_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_UEQ_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_OLT_S_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_OLT_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_OLE_S_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_OLE_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_OEQ_S_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_OEQ_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ADD_S_args[] = {
  { { OPERAND_frr1 }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_ADD_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ADD_LLH_S_args[] = {
  { { OPERAND_frr1 }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_ADD_LLH_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ADD_LHH_S_args[] = {
  { { OPERAND_frr1 }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_ADD_LHH_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_SUB_S_args[] = {
  { { OPERAND_frr1 }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_SUB_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_SUB_LLH_S_args[] = {
  { { OPERAND_frr1 }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_SUB_LLH_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_SUB_LHH_S_args[] = {
  { { OPERAND_frr1 }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_SUB_LHH_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MUL_S_args[] = {
  { { OPERAND_frr1 }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_MUL_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MUL_LLH_S_args[] = {
  { { OPERAND_frr1 }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_MUL_LLH_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MUL_LHH_S_args[] = {
  { { OPERAND_frr1 }, 'o' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_MUL_LHH_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MADD_S_args[] = {
  { { OPERAND_frr1 }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_MADD_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MADD_LLH_S_args[] = {
  { { OPERAND_frr1 }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_MADD_LLH_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MADD_LHH_S_args[] = {
  { { OPERAND_frr1 }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_MADD_LHH_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MSUB_S_args[] = {
  { { OPERAND_frr1 }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_MSUB_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MSUB_LLH_S_args[] = {
  { { OPERAND_frr1 }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_MSUB_LLH_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MSUB_LHH_S_args[] = {
  { { OPERAND_frr1 }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_MSUB_LHH_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_SQRT0_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_SQRT0_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_DIV0_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_DIV0_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RECIP0_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_RECIP0_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_DivZeroFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RSQRT0_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_RSQRT0_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_DivZeroFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MADDN_S_args[] = {
  { { OPERAND_frr1 }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_MADDN_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MSUBN_S_args[] = {
  { { OPERAND_frr1 }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_MSUBN_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_DIVN_S_args[] = {
  { { OPERAND_frr1 }, 'm' },
  { { OPERAND_frs }, 'i' },
  { { OPERAND_frt }, 'i' }
};

static xtensa_arg_internal Iclass_DIVN_S_stateArgs[] = {
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_CONST_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_imm_s }, 'i' }
};

static xtensa_arg_internal Iclass_CONST_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_NEXP01_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_NEXP01_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ADDEXP_S_args[] = {
  { { OPERAND_frr }, 'm' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_ADDEXP_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ADDEXPM_S_args[] = {
  { { OPERAND_frr }, 'm' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_ADDEXPM_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MKDADJ_S_args[] = {
  { { OPERAND_frr }, 'm' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_MKDADJ_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_DivZeroFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MKSADJ_S_args[] = {
  { { OPERAND_frr }, 'o' },
  { { OPERAND_frs }, 'i' }
};

static xtensa_arg_internal Iclass_MKSADJ_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_iclass_internal iclasses[] = {
  { 0, 0 /* xt_iclass_excw */,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_rfe */,
    2, Iclass_xt_iclass_rfe_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_rfde */,
    1, Iclass_xt_iclass_rfde_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_syscall */,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_call12_args,
    1, Iclass_xt_iclass_call12_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_call8_args,
    1, Iclass_xt_iclass_call8_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_call4_args,
    1, Iclass_xt_iclass_call4_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_callx12_args,
    1, Iclass_xt_iclass_callx12_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_callx8_args,
    1, Iclass_xt_iclass_callx8_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_callx4_args,
    1, Iclass_xt_iclass_callx4_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_entry_args,
    5, Iclass_xt_iclass_entry_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_movsp_args,
    2, Iclass_xt_iclass_movsp_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rotw_args,
    1, Iclass_xt_iclass_rotw_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_retw_args,
    5, Iclass_xt_iclass_retw_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_rfwou */,
    5, Iclass_xt_iclass_rfwou_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_l32e_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32e_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_windowbase_args,
    1, Iclass_xt_iclass_rsr_windowbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_windowbase_args,
    1, Iclass_xt_iclass_wsr_windowbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_windowbase_args,
    1, Iclass_xt_iclass_xsr_windowbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_windowstart_args,
    1, Iclass_xt_iclass_rsr_windowstart_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_windowstart_args,
    1, Iclass_xt_iclass_wsr_windowstart_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_windowstart_args,
    1, Iclass_xt_iclass_xsr_windowstart_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_add_n_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_addi_n_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_bz6_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_ill_n */,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_loadi4_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_mov_n_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_movi_n_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_nopn */,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_retn_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_storei4_args,
    0, 0, 0, 0 },
  { 1, Iclass_rur_threadptr_args,
    1, Iclass_rur_threadptr_stateArgs, 0, 0 },
  { 1, Iclass_wur_threadptr_args,
    1, Iclass_wur_threadptr_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_addi_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_addmi_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_addsub_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bit_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bsi8_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bsi8b_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bsi8u_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bst8_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_bsz12_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_call0_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_callx0_args,
    0, 0, 0, 0 },
  { 4, Iclass_xt_iclass_exti_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_ill */,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_jump_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_jumpx_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l16ui_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l16si_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l32i_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_l32r_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l8i_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_loop_args,
    3, Iclass_xt_iclass_loop_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_loopz_args,
    3, Iclass_xt_iclass_loopz_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_movi_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_movz_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_neg_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_nop */,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_return_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_simcall */,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s16i_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32i_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32nb_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s8i_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_sar_args,
    1, Iclass_xt_iclass_sar_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_sari_args,
    1, Iclass_xt_iclass_sari_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_shifts_args,
    1, Iclass_xt_iclass_shifts_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_shiftst_args,
    1, Iclass_xt_iclass_shiftst_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_shiftt_args,
    1, Iclass_xt_iclass_shiftt_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_slli_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_srai_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_srli_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_memw */,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_extw */,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_isync */,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_sync */,
    1, Iclass_xt_iclass_sync_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_rsil_args,
    6, Iclass_xt_iclass_rsil_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_lend_args,
    1, Iclass_xt_iclass_rsr_lend_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_lend_args,
    1, Iclass_xt_iclass_wsr_lend_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_lend_args,
    1, Iclass_xt_iclass_xsr_lend_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_lcount_args,
    1, Iclass_xt_iclass_rsr_lcount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_lcount_args,
    2, Iclass_xt_iclass_wsr_lcount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_lcount_args,
    2, Iclass_xt_iclass_xsr_lcount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_lbeg_args,
    1, Iclass_xt_iclass_rsr_lbeg_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_lbeg_args,
    1, Iclass_xt_iclass_wsr_lbeg_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_lbeg_args,
    1, Iclass_xt_iclass_xsr_lbeg_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_sar_args,
    1, Iclass_xt_iclass_rsr_sar_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_sar_args,
    2, Iclass_xt_iclass_wsr_sar_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_sar_args,
    1, Iclass_xt_iclass_xsr_sar_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_memctl_args,
    1, Iclass_xt_iclass_rsr_memctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_memctl_args,
    1, Iclass_xt_iclass_wsr_memctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_memctl_args,
    1, Iclass_xt_iclass_xsr_memctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_litbase_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_litbase_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_litbase_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_configid0_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_configid0_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_configid1_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ps_args,
    6, Iclass_xt_iclass_rsr_ps_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ps_args,
    6, Iclass_xt_iclass_wsr_ps_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ps_args,
    6, Iclass_xt_iclass_xsr_ps_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc1_args,
    1, Iclass_xt_iclass_rsr_epc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc1_args,
    1, Iclass_xt_iclass_wsr_epc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc1_args,
    1, Iclass_xt_iclass_xsr_epc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave1_args,
    1, Iclass_xt_iclass_rsr_excsave1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave1_args,
    1, Iclass_xt_iclass_wsr_excsave1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave1_args,
    1, Iclass_xt_iclass_xsr_excsave1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc2_args,
    1, Iclass_xt_iclass_rsr_epc2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc2_args,
    1, Iclass_xt_iclass_wsr_epc2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc2_args,
    1, Iclass_xt_iclass_xsr_epc2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave2_args,
    1, Iclass_xt_iclass_rsr_excsave2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave2_args,
    1, Iclass_xt_iclass_wsr_excsave2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave2_args,
    1, Iclass_xt_iclass_xsr_excsave2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc3_args,
    1, Iclass_xt_iclass_rsr_epc3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc3_args,
    1, Iclass_xt_iclass_wsr_epc3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc3_args,
    1, Iclass_xt_iclass_xsr_epc3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave3_args,
    1, Iclass_xt_iclass_rsr_excsave3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave3_args,
    1, Iclass_xt_iclass_wsr_excsave3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave3_args,
    1, Iclass_xt_iclass_xsr_excsave3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc4_args,
    1, Iclass_xt_iclass_rsr_epc4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc4_args,
    1, Iclass_xt_iclass_wsr_epc4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc4_args,
    1, Iclass_xt_iclass_xsr_epc4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave4_args,
    1, Iclass_xt_iclass_rsr_excsave4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave4_args,
    1, Iclass_xt_iclass_wsr_excsave4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave4_args,
    1, Iclass_xt_iclass_xsr_excsave4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc5_args,
    1, Iclass_xt_iclass_rsr_epc5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc5_args,
    1, Iclass_xt_iclass_wsr_epc5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc5_args,
    1, Iclass_xt_iclass_xsr_epc5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave5_args,
    1, Iclass_xt_iclass_rsr_excsave5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave5_args,
    1, Iclass_xt_iclass_wsr_excsave5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave5_args,
    1, Iclass_xt_iclass_xsr_excsave5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps2_args,
    1, Iclass_xt_iclass_rsr_eps2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps2_args,
    1, Iclass_xt_iclass_wsr_eps2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps2_args,
    1, Iclass_xt_iclass_xsr_eps2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps3_args,
    1, Iclass_xt_iclass_rsr_eps3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps3_args,
    1, Iclass_xt_iclass_wsr_eps3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps3_args,
    1, Iclass_xt_iclass_xsr_eps3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps4_args,
    1, Iclass_xt_iclass_rsr_eps4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps4_args,
    1, Iclass_xt_iclass_wsr_eps4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps4_args,
    1, Iclass_xt_iclass_xsr_eps4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps5_args,
    1, Iclass_xt_iclass_rsr_eps5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps5_args,
    1, Iclass_xt_iclass_wsr_eps5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps5_args,
    1, Iclass_xt_iclass_xsr_eps5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excvaddr_args,
    1, Iclass_xt_iclass_rsr_excvaddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excvaddr_args,
    1, Iclass_xt_iclass_wsr_excvaddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excvaddr_args,
    1, Iclass_xt_iclass_xsr_excvaddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_depc_args,
    1, Iclass_xt_iclass_rsr_depc_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_depc_args,
    1, Iclass_xt_iclass_wsr_depc_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_depc_args,
    1, Iclass_xt_iclass_xsr_depc_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_exccause_args,
    2, Iclass_xt_iclass_rsr_exccause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_exccause_args,
    1, Iclass_xt_iclass_wsr_exccause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_exccause_args,
    1, Iclass_xt_iclass_xsr_exccause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_misc0_args,
    1, Iclass_xt_iclass_rsr_misc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_misc0_args,
    1, Iclass_xt_iclass_wsr_misc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_misc0_args,
    1, Iclass_xt_iclass_xsr_misc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_misc1_args,
    1, Iclass_xt_iclass_rsr_misc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_misc1_args,
    1, Iclass_xt_iclass_wsr_misc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_misc1_args,
    1, Iclass_xt_iclass_xsr_misc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_prid_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_vecbase_args,
    1, Iclass_xt_iclass_rsr_vecbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_vecbase_args,
    1, Iclass_xt_iclass_wsr_vecbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_vecbase_args,
    1, Iclass_xt_iclass_xsr_vecbase_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16_aa_args,
    1, Iclass_xt_iclass_mac16_aa_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16_ad_args,
    1, Iclass_xt_iclass_mac16_ad_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16_da_args,
    1, Iclass_xt_iclass_mac16_da_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16_dd_args,
    1, Iclass_xt_iclass_mac16_dd_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16a_aa_args,
    1, Iclass_xt_iclass_mac16a_aa_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16a_ad_args,
    1, Iclass_xt_iclass_mac16a_ad_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16a_da_args,
    1, Iclass_xt_iclass_mac16a_da_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16a_dd_args,
    1, Iclass_xt_iclass_mac16a_dd_stateArgs, 0, 0 },
  { 4, Iclass_xt_iclass_mac16al_da_args,
    1, Iclass_xt_iclass_mac16al_da_stateArgs, 0, 0 },
  { 4, Iclass_xt_iclass_mac16al_dd_args,
    1, Iclass_xt_iclass_mac16al_dd_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16_l_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_rsr_m0_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_wsr_m0_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_xsr_m0_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_rsr_m1_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_wsr_m1_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_xsr_m1_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_rsr_m2_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_wsr_m2_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_xsr_m2_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_rsr_m3_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_wsr_m3_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_xsr_m3_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_acclo_args,
    1, Iclass_xt_iclass_rsr_acclo_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_acclo_args,
    1, Iclass_xt_iclass_wsr_acclo_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_acclo_args,
    1, Iclass_xt_iclass_xsr_acclo_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_acchi_args,
    1, Iclass_xt_iclass_rsr_acchi_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_acchi_args,
    1, Iclass_xt_iclass_wsr_acchi_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_acchi_args,
    1, Iclass_xt_iclass_xsr_acchi_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rfi_args,
    16, Iclass_xt_iclass_rfi_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wait_args,
    1, Iclass_xt_iclass_wait_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_interrupt_args,
    1, Iclass_xt_iclass_rsr_interrupt_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_intset_args,
    2, Iclass_xt_iclass_wsr_intset_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_intclear_args,
    2, Iclass_xt_iclass_wsr_intclear_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_intenable_args,
    1, Iclass_xt_iclass_rsr_intenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_intenable_args,
    1, Iclass_xt_iclass_wsr_intenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_intenable_args,
    1, Iclass_xt_iclass_xsr_intenable_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_break_args,
    2, Iclass_xt_iclass_break_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_break_n_args,
    2, Iclass_xt_iclass_break_n_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_dbreaka0_args,
    1, Iclass_xt_iclass_rsr_dbreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_dbreaka0_args,
    2, Iclass_xt_iclass_wsr_dbreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_dbreaka0_args,
    2, Iclass_xt_iclass_xsr_dbreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_dbreakc0_args,
    1, Iclass_xt_iclass_rsr_dbreakc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_dbreakc0_args,
    2, Iclass_xt_iclass_wsr_dbreakc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_dbreakc0_args,
    2, Iclass_xt_iclass_xsr_dbreakc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_dbreaka1_args,
    1, Iclass_xt_iclass_rsr_dbreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_dbreaka1_args,
    2, Iclass_xt_iclass_wsr_dbreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_dbreaka1_args,
    2, Iclass_xt_iclass_xsr_dbreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_dbreakc1_args,
    1, Iclass_xt_iclass_rsr_dbreakc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_dbreakc1_args,
    2, Iclass_xt_iclass_wsr_dbreakc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_dbreakc1_args,
    2, Iclass_xt_iclass_xsr_dbreakc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ibreaka0_args,
    1, Iclass_xt_iclass_rsr_ibreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ibreaka0_args,
    1, Iclass_xt_iclass_wsr_ibreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ibreaka0_args,
    1, Iclass_xt_iclass_xsr_ibreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ibreaka1_args,
    1, Iclass_xt_iclass_rsr_ibreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ibreaka1_args,
    1, Iclass_xt_iclass_wsr_ibreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ibreaka1_args,
    1, Iclass_xt_iclass_xsr_ibreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ibreakenable_args,
    1, Iclass_xt_iclass_rsr_ibreakenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ibreakenable_args,
    1, Iclass_xt_iclass_wsr_ibreakenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ibreakenable_args,
    1, Iclass_xt_iclass_xsr_ibreakenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_debugcause_args,
    2, Iclass_xt_iclass_rsr_debugcause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_debugcause_args,
    2, Iclass_xt_iclass_wsr_debugcause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_debugcause_args,
    2, Iclass_xt_iclass_xsr_debugcause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_icount_args,
    1, Iclass_xt_iclass_rsr_icount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_icount_args,
    2, Iclass_xt_iclass_wsr_icount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_icount_args,
    2, Iclass_xt_iclass_xsr_icount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_icountlevel_args,
    1, Iclass_xt_iclass_rsr_icountlevel_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_icountlevel_args,
    1, Iclass_xt_iclass_wsr_icountlevel_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_icountlevel_args,
    1, Iclass_xt_iclass_xsr_icountlevel_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ddr_args,
    1, Iclass_xt_iclass_rsr_ddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ddr_args,
    2, Iclass_xt_iclass_wsr_ddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ddr_args,
    2, Iclass_xt_iclass_xsr_ddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_lddr32_p_args,
    3, Iclass_xt_iclass_lddr32_p_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_sddr32_p_args,
    2, Iclass_xt_iclass_sddr32_p_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rfdo_args,
    9, Iclass_xt_iclass_rfdo_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_rfdd */,
    1, Iclass_xt_iclass_rfdd_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_mmid_args,
    1, Iclass_xt_iclass_wsr_mmid_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_bbool1_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_bbool4_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_bbool8_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_bbranch_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bmove_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_RSR_BR_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_WSR_BR_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_XSR_BR_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ccount_args,
    1, Iclass_xt_iclass_rsr_ccount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ccount_args,
    2, Iclass_xt_iclass_wsr_ccount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ccount_args,
    2, Iclass_xt_iclass_xsr_ccount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ccompare0_args,
    1, Iclass_xt_iclass_rsr_ccompare0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ccompare0_args,
    2, Iclass_xt_iclass_wsr_ccompare0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ccompare0_args,
    2, Iclass_xt_iclass_xsr_ccompare0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ccompare1_args,
    1, Iclass_xt_iclass_rsr_ccompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ccompare1_args,
    2, Iclass_xt_iclass_wsr_ccompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ccompare1_args,
    2, Iclass_xt_iclass_xsr_ccompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_idtlb_args,
    1, Iclass_xt_iclass_idtlb_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_rdtlb_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_wdtlb_args,
    1, Iclass_xt_iclass_wdtlb_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_iitlb_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_ritlb_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_witlb_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_cpenable_args,
    1, Iclass_xt_iclass_rsr_cpenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_cpenable_args,
    1, Iclass_xt_iclass_wsr_cpenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_cpenable_args,
    1, Iclass_xt_iclass_xsr_cpenable_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_clamp_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_minmax_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_nsa_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_sx_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l32ai_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32ri_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32c1i_args,
    3, Iclass_xt_iclass_s32c1i_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_scompare1_args,
    1, Iclass_xt_iclass_rsr_scompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_scompare1_args,
    1, Iclass_xt_iclass_wsr_scompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_scompare1_args,
    1, Iclass_xt_iclass_xsr_scompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_atomctl_args,
    1, Iclass_xt_iclass_rsr_atomctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_atomctl_args,
    2, Iclass_xt_iclass_wsr_atomctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_atomctl_args,
    2, Iclass_xt_iclass_xsr_atomctl_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_div_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_rer_args,
    1, Iclass_xt_iclass_rer_stateArgs, 2, Iclass_xt_iclass_rer_intfArgs },
  { 2, Iclass_xt_iclass_wer_args,
    1, Iclass_xt_iclass_wer_stateArgs, 2, Iclass_xt_iclass_wer_intfArgs },
  { 2, Iclass_xt_iclass_wb15_0_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_wb15_1_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_wb15_2_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_wb15_3_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_wb15_4_args,
    0, 0, 0, 0 },
  { 1, Iclass_rur_ae_bithead_args,
    2, Iclass_rur_ae_bithead_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_bithead_args,
    2, Iclass_wur_ae_bithead_stateArgs, 0, 0 },
  { 1, Iclass_rur_ae_cbegin0_args,
    2, Iclass_rur_ae_cbegin0_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_cbegin0_args,
    2, Iclass_wur_ae_cbegin0_stateArgs, 0, 0 },
  { 1, Iclass_rur_ae_cend0_args,
    2, Iclass_rur_ae_cend0_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_cend0_args,
    2, Iclass_wur_ae_cend0_stateArgs, 0, 0 },
  { 2, Iclass_ic_sext16_args,
    0, 0, 0, 0 },
  { 2, Iclass_ic_zext16_args,
    0, 0, 0, 0 },
  { 2, Iclass_ic_zext8_args,
    0, 0, 0, 0 },
  { 2, Iclass_ic_clamps16_args,
    0, 0, 0, 0 },
  { 1, Iclass_rur_fcr_args,
    2, Iclass_rur_fcr_stateArgs, 0, 0 },
  { 1, Iclass_wur_fcr_args,
    2, Iclass_wur_fcr_stateArgs, 0, 0 },
  { 1, Iclass_rur_fsr_args,
    6, Iclass_rur_fsr_stateArgs, 0, 0 },
  { 1, Iclass_wur_fsr_args,
    6, Iclass_wur_fsr_stateArgs, 0, 0 },
  { 1, Iclass_rur_expstate_args,
    1, Iclass_rur_expstate_stateArgs, 0, 0 },
  { 1, Iclass_wur_expstate_args,
    1, Iclass_wur_expstate_stateArgs, 0, 0 },
  { 1, Iclass_iclass_READ_IMPWIRE_args,
    0, 0, 1, Iclass_iclass_READ_IMPWIRE_intfArgs },
  { 1, Iclass_iclass_SETB_EXPSTATE_args,
    1, Iclass_iclass_SETB_EXPSTATE_stateArgs, 0, 0 },
  { 1, Iclass_iclass_CLRB_EXPSTATE_args,
    1, Iclass_iclass_CLRB_EXPSTATE_stateArgs, 0, 0 },
  { 2, Iclass_iclass_WRMSK_EXPSTATE_args,
    1, Iclass_iclass_WRMSK_EXPSTATE_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_OVERFLOW_args,
    2, Iclass_RUR_AE_OVERFLOW_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_OVERFLOW_args,
    2, Iclass_WUR_AE_OVERFLOW_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_SAR_args,
    2, Iclass_RUR_AE_SAR_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_SAR_args,
    2, Iclass_WUR_AE_SAR_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_BITPTR_args,
    2, Iclass_RUR_AE_BITPTR_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_BITPTR_args,
    2, Iclass_WUR_AE_BITPTR_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_BITSUSED_args,
    2, Iclass_RUR_AE_BITSUSED_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_BITSUSED_args,
    2, Iclass_WUR_AE_BITSUSED_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_TABLESIZE_args,
    2, Iclass_RUR_AE_TABLESIZE_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_TABLESIZE_args,
    2, Iclass_WUR_AE_TABLESIZE_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_FIRST_TS_args,
    2, Iclass_RUR_AE_FIRST_TS_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_FIRST_TS_args,
    2, Iclass_WUR_AE_FIRST_TS_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_NEXTOFFSET_args,
    2, Iclass_RUR_AE_NEXTOFFSET_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_NEXTOFFSET_args,
    2, Iclass_WUR_AE_NEXTOFFSET_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_SEARCHDONE_args,
    2, Iclass_RUR_AE_SEARCHDONE_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_SEARCHDONE_args,
    2, Iclass_WUR_AE_SEARCHDONE_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_CWRAP_args,
    2, Iclass_RUR_AE_CWRAP_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_CWRAP_args,
    2, Iclass_WUR_AE_CWRAP_stateArgs, 0, 0 },
  { 1, Iclass_AE_MOVCIRCV_args,
    3, Iclass_AE_MOVCIRCV_stateArgs, 0, 0 },
  { 1, Iclass_AE_MOVVCIRC_args,
    3, Iclass_AE_MOVVCIRC_stateArgs, 0, 0 },
  { 1, Iclass_AE_MOVFUSIONMISCV_args,
    7, Iclass_AE_MOVFUSIONMISCV_stateArgs, 0, 0 },
  { 1, Iclass_AE_MOVVFUSIONMISC_args,
    7, Iclass_AE_MOVVFUSIONMISC_stateArgs, 0, 0 },
  { 1, Iclass_AE_MOVTABLEFIRSTSEARCHNEXTV_args,
    5, Iclass_AE_MOVTABLEFIRSTSEARCHNEXTV_stateArgs, 0, 0 },
  { 1, Iclass_AE_MOVVTABLEFIRSTSEARCHNEXT_args,
    5, Iclass_AE_MOVVTABLEFIRSTSEARCHNEXT_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X4F_I_args,
    1, Iclass_AE_L8X4F_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X4F_IP_args,
    1, Iclass_AE_L8X4F_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X4F_X_args,
    1, Iclass_AE_L8X4F_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X4F_XP_args,
    1, Iclass_AE_L8X4F_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X8_I_args,
    1, Iclass_AE_L8X8_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X8_IP_args,
    1, Iclass_AE_L8X8_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16M_XC_args,
    3, Iclass_AE_L16M_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16M_I_args,
    1, Iclass_AE_L16M_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16M_IU_args,
    1, Iclass_AE_L16M_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16M_X_args,
    1, Iclass_AE_L16M_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16M_XU_args,
    1, Iclass_AE_L16M_XU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16_XC_args,
    3, Iclass_AE_L16_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16_I_args,
    1, Iclass_AE_L16_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16_IP_args,
    1, Iclass_AE_L16_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16_X_args,
    1, Iclass_AE_L16_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16_XP_args,
    1, Iclass_AE_L16_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32F24_XC_args,
    3, Iclass_AE_L32F24_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32F24_I_args,
    1, Iclass_AE_L32F24_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32F24_IP_args,
    1, Iclass_AE_L32F24_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32F24_X_args,
    1, Iclass_AE_L32F24_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32F24_XP_args,
    1, Iclass_AE_L32F24_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32_XC_args,
    3, Iclass_AE_L32_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32_I_args,
    1, Iclass_AE_L32_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32_IP_args,
    1, Iclass_AE_L32_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32_X_args,
    1, Iclass_AE_L32_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32_XP_args,
    1, Iclass_AE_L32_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32M_XC_args,
    3, Iclass_AE_L32M_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32M_I_args,
    1, Iclass_AE_L32M_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32M_IU_args,
    1, Iclass_AE_L32M_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32M_X_args,
    1, Iclass_AE_L32M_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32M_XU_args,
    1, Iclass_AE_L32M_XU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X2M_XC_args,
    3, Iclass_AE_L16X2M_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X2M_I_args,
    1, Iclass_AE_L16X2M_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X2M_IU_args,
    1, Iclass_AE_L16X2M_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X2M_X_args,
    1, Iclass_AE_L16X2M_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X2M_XU_args,
    1, Iclass_AE_L16X2M_XU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2F24_XC_args,
    3, Iclass_AE_L32X2F24_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2F24_I_args,
    1, Iclass_AE_L32X2F24_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2F24_IP_args,
    1, Iclass_AE_L32X2F24_IP_stateArgs, 0, 0 },
  { 2, Iclass_AE_L32X2F24_RIP_args,
    1, Iclass_AE_L32X2F24_RIP_stateArgs, 0, 0 },
  { 2, Iclass_AE_L32X2F24_RIC_args,
    3, Iclass_AE_L32X2F24_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2F24_X_args,
    1, Iclass_AE_L32X2F24_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2F24_XP_args,
    1, Iclass_AE_L32X2F24_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2_XC_args,
    3, Iclass_AE_L32X2_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2_I_args,
    1, Iclass_AE_L32X2_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2_IP_args,
    1, Iclass_AE_L32X2_IP_stateArgs, 0, 0 },
  { 2, Iclass_AE_L32X2_RIP_args,
    1, Iclass_AE_L32X2_RIP_stateArgs, 0, 0 },
  { 2, Iclass_AE_L32X2_RIC_args,
    3, Iclass_AE_L32X2_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2_X_args,
    1, Iclass_AE_L32X2_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2_XP_args,
    1, Iclass_AE_L32X2_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X4_XC_args,
    3, Iclass_AE_L16X4_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X4_I_args,
    1, Iclass_AE_L16X4_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X4_IP_args,
    1, Iclass_AE_L16X4_IP_stateArgs, 0, 0 },
  { 2, Iclass_AE_L16X4_RIP_args,
    1, Iclass_AE_L16X4_RIP_stateArgs, 0, 0 },
  { 2, Iclass_AE_L16X4_RIC_args,
    3, Iclass_AE_L16X4_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X4_X_args,
    1, Iclass_AE_L16X4_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X4_XP_args,
    1, Iclass_AE_L16X4_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L64_XC_args,
    3, Iclass_AE_L64_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L64_I_args,
    1, Iclass_AE_L64_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L64_IP_args,
    1, Iclass_AE_L64_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L64_X_args,
    1, Iclass_AE_L64_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L64_XP_args,
    1, Iclass_AE_L64_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S8X4F_I_args,
    1, Iclass_AE_S8X4F_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S8X4F_IP_args,
    1, Iclass_AE_S8X4F_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X2M_XC_args,
    3, Iclass_AE_S16X2M_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X2M_I_args,
    1, Iclass_AE_S16X2M_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X2M_IU_args,
    1, Iclass_AE_S16X2M_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X2M_X_args,
    1, Iclass_AE_S16X2M_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X2M_XU_args,
    1, Iclass_AE_S16X2M_XU_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2F24_XC_args,
    3, Iclass_AE_S32X2F24_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2F24_I_args,
    1, Iclass_AE_S32X2F24_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2F24_IP_args,
    1, Iclass_AE_S32X2F24_IP_stateArgs, 0, 0 },
  { 2, Iclass_AE_S32X2F24_RIP_args,
    1, Iclass_AE_S32X2F24_RIP_stateArgs, 0, 0 },
  { 2, Iclass_AE_S32X2F24_RIC_args,
    3, Iclass_AE_S32X2F24_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2F24_X_args,
    1, Iclass_AE_S32X2F24_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2F24_XP_args,
    1, Iclass_AE_S32X2F24_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2_XC_args,
    3, Iclass_AE_S32X2_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2_I_args,
    1, Iclass_AE_S32X2_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2_IP_args,
    1, Iclass_AE_S32X2_IP_stateArgs, 0, 0 },
  { 2, Iclass_AE_S32X2_RIP_args,
    1, Iclass_AE_S32X2_RIP_stateArgs, 0, 0 },
  { 2, Iclass_AE_S32X2_RIC_args,
    3, Iclass_AE_S32X2_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2_X_args,
    1, Iclass_AE_S32X2_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2_XP_args,
    1, Iclass_AE_S32X2_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4_XC_args,
    3, Iclass_AE_S16X4_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4_I_args,
    1, Iclass_AE_S16X4_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4_IP_args,
    1, Iclass_AE_S16X4_IP_stateArgs, 0, 0 },
  { 2, Iclass_AE_S16X4_RIP_args,
    1, Iclass_AE_S16X4_RIP_stateArgs, 0, 0 },
  { 2, Iclass_AE_S16X4_RIC_args,
    3, Iclass_AE_S16X4_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4_X_args,
    1, Iclass_AE_S16X4_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4_XP_args,
    1, Iclass_AE_S16X4_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4RNG_I_args,
    2, Iclass_AE_S16X4RNG_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4RNG_IP_args,
    2, Iclass_AE_S16X4RNG_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4RNG_X_args,
    2, Iclass_AE_S16X4RNG_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4RNG_XP_args,
    2, Iclass_AE_S16X4RNG_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16M_L_XC_args,
    3, Iclass_AE_S16M_L_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16M_L_I_args,
    1, Iclass_AE_S16M_L_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16M_L_IU_args,
    1, Iclass_AE_S16M_L_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16M_L_X_args,
    1, Iclass_AE_S16M_L_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16M_L_XU_args,
    1, Iclass_AE_S16M_L_XU_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32F24_L_XC_args,
    3, Iclass_AE_S32F24_L_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32F24_L_I_args,
    1, Iclass_AE_S32F24_L_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32F24_L_IP_args,
    1, Iclass_AE_S32F24_L_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32F24_L_X_args,
    1, Iclass_AE_S32F24_L_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32F24_L_XP_args,
    1, Iclass_AE_S32F24_L_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_L_XC_args,
    3, Iclass_AE_S32_L_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_L_I_args,
    1, Iclass_AE_S32_L_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_L_IP_args,
    1, Iclass_AE_S32_L_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_L_X_args,
    1, Iclass_AE_S32_L_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_L_XP_args,
    1, Iclass_AE_S32_L_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16_0_XC_args,
    3, Iclass_AE_S16_0_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16_0_I_args,
    1, Iclass_AE_S16_0_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16_0_IP_args,
    1, Iclass_AE_S16_0_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16_0_X_args,
    1, Iclass_AE_S16_0_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16_0_XP_args,
    1, Iclass_AE_S16_0_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S64_XC_args,
    3, Iclass_AE_S64_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S64_I_args,
    1, Iclass_AE_S64_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S64_IP_args,
    1, Iclass_AE_S64_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S64_X_args,
    1, Iclass_AE_S64_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S64_XP_args,
    1, Iclass_AE_S64_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32M_XC_args,
    3, Iclass_AE_S32M_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32M_I_args,
    1, Iclass_AE_S32M_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32M_IU_args,
    1, Iclass_AE_S32M_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32M_X_args,
    1, Iclass_AE_S32M_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32M_XU_args,
    1, Iclass_AE_S32M_XU_stateArgs, 0, 0 },
  { 1, Iclass_AE_ZALIGN64_args,
    1, Iclass_AE_ZALIGN64_stateArgs, 0, 0 },
  { 3, Iclass_AE_LALIGN64_I_args,
    1, Iclass_AE_LALIGN64_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_SALIGN64_I_args,
    1, Iclass_AE_SALIGN64_I_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVALIGN_args,
    1, Iclass_AE_MOVALIGN_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA64_PP_args,
    1, Iclass_AE_LA64_PP_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA24POS_PC_args,
    3, Iclass_AE_LA24POS_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA24X2POS_PC_args,
    3, Iclass_AE_LA24X2POS_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA32X2POS_PC_args,
    3, Iclass_AE_LA32X2POS_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA16X4POS_PC_args,
    3, Iclass_AE_LA16X4POS_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA24NEG_PC_args,
    3, Iclass_AE_LA24NEG_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA24X2NEG_PC_args,
    3, Iclass_AE_LA24X2NEG_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA32X2NEG_PC_args,
    3, Iclass_AE_LA32X2NEG_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA16X4NEG_PC_args,
    3, Iclass_AE_LA16X4NEG_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_SA64POS_FP_args,
    1, Iclass_AE_SA64POS_FP_stateArgs, 0, 0 },
  { 2, Iclass_AE_SA64NEG_FP_args,
    1, Iclass_AE_SA64NEG_FP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2_IC_args,
    3, Iclass_AE_LA32X2_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2_IP_args,
    1, Iclass_AE_LA32X2_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2_RIP_args,
    1, Iclass_AE_LA32X2_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2_RIC_args,
    3, Iclass_AE_LA32X2_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA16X4_IC_args,
    3, Iclass_AE_LA16X4_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA16X4_IP_args,
    1, Iclass_AE_LA16X4_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA16X4_RIP_args,
    1, Iclass_AE_LA16X4_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA16X4_RIC_args,
    3, Iclass_AE_LA16X4_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2F24_IC_args,
    3, Iclass_AE_LA32X2F24_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2F24_IP_args,
    1, Iclass_AE_LA32X2F24_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2F24_RIP_args,
    1, Iclass_AE_LA32X2F24_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2F24_RIC_args,
    3, Iclass_AE_LA32X2F24_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24_IC_args,
    3, Iclass_AE_LA24_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24_IP_args,
    1, Iclass_AE_LA24_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24_RIP_args,
    1, Iclass_AE_LA24_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24_RIC_args,
    3, Iclass_AE_LA24_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24X2_IC_args,
    3, Iclass_AE_LA24X2_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24X2_IP_args,
    1, Iclass_AE_LA24X2_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24X2_RIP_args,
    1, Iclass_AE_LA24X2_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24X2_RIC_args,
    3, Iclass_AE_LA24X2_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2_IC_args,
    3, Iclass_AE_SA32X2_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2_IP_args,
    1, Iclass_AE_SA32X2_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2_RIP_args,
    1, Iclass_AE_SA32X2_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2_RIC_args,
    3, Iclass_AE_SA32X2_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA16X4_IC_args,
    3, Iclass_AE_SA16X4_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA16X4_IP_args,
    1, Iclass_AE_SA16X4_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA16X4_RIP_args,
    1, Iclass_AE_SA16X4_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA16X4_RIC_args,
    3, Iclass_AE_SA16X4_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2F24_IC_args,
    3, Iclass_AE_SA32X2F24_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2F24_IP_args,
    1, Iclass_AE_SA32X2F24_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2F24_RIP_args,
    1, Iclass_AE_SA32X2F24_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2F24_RIC_args,
    3, Iclass_AE_SA32X2F24_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24_L_IC_args,
    3, Iclass_AE_SA24_L_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24_L_IP_args,
    1, Iclass_AE_SA24_L_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24_L_RIP_args,
    1, Iclass_AE_SA24_L_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24_L_RIC_args,
    3, Iclass_AE_SA24_L_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24X2_IC_args,
    3, Iclass_AE_SA24X2_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24X2_IP_args,
    1, Iclass_AE_SA24X2_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24X2_RIP_args,
    1, Iclass_AE_SA24X2_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24X2_RIC_args,
    3, Iclass_AE_SA24X2_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32RA64S_I_args,
    2, Iclass_AE_S32RA64S_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32RA64S_IP_args,
    2, Iclass_AE_S32RA64S_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32RA64S_X_args,
    2, Iclass_AE_S32RA64S_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32RA64S_XP_args,
    2, Iclass_AE_S32RA64S_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32RA64S_XC_args,
    4, Iclass_AE_S32RA64S_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S24RA64S_I_args,
    2, Iclass_AE_S24RA64S_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S24RA64S_IP_args,
    2, Iclass_AE_S24RA64S_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S24RA64S_X_args,
    2, Iclass_AE_S24RA64S_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S24RA64S_XP_args,
    2, Iclass_AE_S24RA64S_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S24RA64S_XC_args,
    4, Iclass_AE_S24RA64S_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2RA64S_IP_args,
    2, Iclass_AE_S32X2RA64S_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S24X2RA64S_IP_args,
    2, Iclass_AE_S24X2RA64S_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADDBRBA32_args,
    0, 0, 0, 0 },
  { 4, Iclass_AE_SEL16I_args,
    1, Iclass_AE_SEL16I_stateArgs, 0, 0 },
  { 2, Iclass_AE_SHORTSWAP_args,
    1, Iclass_AE_SHORTSWAP_stateArgs, 0, 0 },
  { 2, Iclass_AE_INTSWAP_args,
    1, Iclass_AE_INTSWAP_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVT16X4_args,
    1, Iclass_AE_MOVT16X4_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVF16X4_args,
    1, Iclass_AE_MOVF16X4_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVT32X2_args,
    1, Iclass_AE_MOVT32X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVF32X2_args,
    1, Iclass_AE_MOVF32X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVDA32X2_args,
    1, Iclass_AE_MOVDA32X2_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVDA32_args,
    1, Iclass_AE_MOVDA32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVDA16X2_args,
    1, Iclass_AE_MOVDA16X2_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVDA16_args,
    1, Iclass_AE_MOVDA16_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVI_args,
    1, Iclass_AE_MOVI_stateArgs, 0, 0 },
  { 3, Iclass_AE_TRUNCP24A32X2_args,
    1, Iclass_AE_TRUNCP24A32X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_SAT16X4_args,
    2, Iclass_AE_SAT16X4_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVT32X2F16_32_args,
    1, Iclass_AE_CVT32X2F16_32_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVT32X2F16_10_args,
    1, Iclass_AE_CVT32X2F16_10_stateArgs, 0, 0 },
  { 2, Iclass_AE_SEXT32X2D16_32_args,
    1, Iclass_AE_SEXT32X2D16_32_stateArgs, 0, 0 },
  { 2, Iclass_AE_SEXT32X2D16_10_args,
    1, Iclass_AE_SEXT32X2D16_10_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVTA32F24S_L_args,
    1, Iclass_AE_CVTA32F24S_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVTA32F24S_H_args,
    1, Iclass_AE_CVTA32F24S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_CVTP24A16X2_LL_args,
    1, Iclass_AE_CVTP24A16X2_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_CVTP24A16X2_LH_args,
    1, Iclass_AE_CVTP24A16X2_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_CVTP24A16X2_HL_args,
    1, Iclass_AE_CVTP24A16X2_HL_stateArgs, 0, 0 },
  { 3, Iclass_AE_CVTP24A16X2_HH_args,
    1, Iclass_AE_CVTP24A16X2_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_TRUNCP24Q48X2_args,
    1, Iclass_AE_TRUNCP24Q48X2_stateArgs, 0, 0 },
  { 4, Iclass_AE_TRUNCA32X2F64S_args,
    2, Iclass_AE_TRUNCA32X2F64S_stateArgs, 0, 0 },
  { 4, Iclass_AE_TRUNCI32X2F64S_args,
    2, Iclass_AE_TRUNCI32X2F64S_stateArgs, 0, 0 },
  { 4, Iclass_AE_TRUNCI16X4F32S_args,
    2, Iclass_AE_TRUNCI16X4F32S_stateArgs, 0, 0 },
  { 4, Iclass_AE_TRUNCA32F64S_L_args,
    2, Iclass_AE_TRUNCA32F64S_L_stateArgs, 0, 0 },
  { 4, Iclass_AE_TRUNCI32F64S_L_args,
    2, Iclass_AE_TRUNCI32F64S_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_TRUNCP16_args,
    1, Iclass_AE_TRUNCP16_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND32X2F64SSYM_args,
    2, Iclass_AE_ROUND32X2F64SSYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND32X2F64SASYM_args,
    2, Iclass_AE_ROUND32X2F64SASYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND32X2F48SSYM_args,
    2, Iclass_AE_ROUND32X2F48SSYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND32X2F48SASYM_args,
    2, Iclass_AE_ROUND32X2F48SASYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND16X4F32SSYM_args,
    2, Iclass_AE_ROUND16X4F32SSYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND16X4F32SASYM_args,
    2, Iclass_AE_ROUND16X4F32SASYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND24X2F48SSYM_args,
    2, Iclass_AE_ROUND24X2F48SSYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND24X2F48SASYM_args,
    2, Iclass_AE_ROUND24X2F48SASYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUNDSP16Q48X2SYM_args,
    2, Iclass_AE_ROUNDSP16Q48X2SYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUNDSP16Q48X2ASYM_args,
    2, Iclass_AE_ROUNDSP16Q48X2ASYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_MINABS32S_args,
    2, Iclass_AE_MINABS32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_MAXABS32S_args,
    2, Iclass_AE_MAXABS32S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ROUNDSP16F24SYM_args,
    2, Iclass_AE_ROUNDSP16F24SYM_stateArgs, 0, 0 },
  { 2, Iclass_AE_ROUNDSP16F24ASYM_args,
    2, Iclass_AE_ROUNDSP16F24ASYM_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOV_args,
    1, Iclass_AE_MOV_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVT64_args,
    1, Iclass_AE_MOVT64_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVF64_args,
    1, Iclass_AE_MOVF64_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVTQ56A32S_args,
    1, Iclass_AE_CVTQ56A32S_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVT48A32_args,
    1, Iclass_AE_CVT48A32_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVT64A32_args,
    1, Iclass_AE_CVT64A32_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVTQ56P32S_L_args,
    1, Iclass_AE_CVTQ56P32S_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVTQ56P32S_H_args,
    1, Iclass_AE_CVTQ56P32S_H_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVT64F32_H_args,
    1, Iclass_AE_CVT64F32_H_stateArgs, 0, 0 },
  { 2, Iclass_AE_SAT48S_args,
    2, Iclass_AE_SAT48S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SATQ56S_args,
    2, Iclass_AE_SATQ56S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SAT24S_args,
    2, Iclass_AE_SAT24S_stateArgs, 0, 0 },
  { 2, Iclass_AE_TRUNCQ32_args,
    1, Iclass_AE_TRUNCQ32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MINABS64S_args,
    2, Iclass_AE_MINABS64S_stateArgs, 0, 0 },
  { 3, Iclass_AE_MAXABS64S_args,
    2, Iclass_AE_MAXABS64S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ROUNDSQ32F48SYM_args,
    2, Iclass_AE_ROUNDSQ32F48SYM_stateArgs, 0, 0 },
  { 2, Iclass_AE_ROUNDSQ32F48ASYM_args,
    2, Iclass_AE_ROUNDSQ32F48ASYM_stateArgs, 0, 0 },
  { 2, Iclass_AE_TRUNCA32Q48_args,
    1, Iclass_AE_TRUNCA32Q48_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD32_L_args,
    1, Iclass_AE_MOVAD32_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD32_H_args,
    1, Iclass_AE_MOVAD32_H_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD16_3_args,
    1, Iclass_AE_MOVAD16_3_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD16_2_args,
    1, Iclass_AE_MOVAD16_2_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD16_1_args,
    1, Iclass_AE_MOVAD16_1_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD16_0_args,
    1, Iclass_AE_MOVAD16_0_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRA64_32_args,
    1, Iclass_AE_SRA64_32_stateArgs, 0, 0 },
  { 3, Iclass_AE_PKSR32_0_args,
    2, Iclass_AE_PKSR32_0_stateArgs, 0, 0 },
  { 3, Iclass_AE_PKSR24_0_args,
    2, Iclass_AE_PKSR24_0_stateArgs, 0, 0 },
  { 2, Iclass_AE_TRUNCA16P24S_L_args,
    1, Iclass_AE_TRUNCA16P24S_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_TRUNCA16P24S_H_args,
    1, Iclass_AE_TRUNCA16P24S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD32_args,
    1, Iclass_AE_ADD32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB32_args,
    1, Iclass_AE_SUB32_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADDSUB32_args,
    1, Iclass_AE_ADDSUB32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUBADD32_args,
    1, Iclass_AE_SUBADD32_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD16_args,
    1, Iclass_AE_ADD16_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB16_args,
    1, Iclass_AE_SUB16_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD32_HL_LH_args,
    1, Iclass_AE_ADD32_HL_LH_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG32_args,
    1, Iclass_AE_NEG32_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS32_args,
    1, Iclass_AE_ABS32_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD24S_args,
    2, Iclass_AE_ADD24S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB24S_args,
    2, Iclass_AE_SUB24S_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD32S_args,
    2, Iclass_AE_ADD32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB32S_args,
    2, Iclass_AE_SUB32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADDSUB32S_args,
    2, Iclass_AE_ADDSUB32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUBADD32S_args,
    2, Iclass_AE_SUBADD32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD16S_args,
    2, Iclass_AE_ADD16S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB16S_args,
    2, Iclass_AE_SUB16S_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG24S_args,
    2, Iclass_AE_NEG24S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS24S_args,
    2, Iclass_AE_ABS24S_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG32S_args,
    1, Iclass_AE_NEG32S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS32S_args,
    1, Iclass_AE_ABS32S_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG16S_args,
    1, Iclass_AE_NEG16S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS16S_args,
    1, Iclass_AE_ABS16S_stateArgs, 0, 0 },
  { 2, Iclass_AE_CONJ16S_args,
    2, Iclass_AE_CONJ16S_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULC16JS_H_args,
    2, Iclass_AE_MULC16JS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULC16JS_L_args,
    2, Iclass_AE_MULC16JS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAC16JS_H_args,
    2, Iclass_AE_MULAC16JS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAC16JS_L_args,
    2, Iclass_AE_MULAC16JS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_LT16_args,
    1, Iclass_AE_LT16_stateArgs, 0, 0 },
  { 3, Iclass_AE_LE16_args,
    1, Iclass_AE_LE16_stateArgs, 0, 0 },
  { 3, Iclass_AE_EQ16_args,
    1, Iclass_AE_EQ16_stateArgs, 0, 0 },
  { 3, Iclass_AE_LT32_args,
    1, Iclass_AE_LT32_stateArgs, 0, 0 },
  { 3, Iclass_AE_LE32_args,
    1, Iclass_AE_LE32_stateArgs, 0, 0 },
  { 3, Iclass_AE_EQ32_args,
    1, Iclass_AE_EQ32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MIN32_args,
    1, Iclass_AE_MIN32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MAX32_args,
    1, Iclass_AE_MAX32_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD64_args,
    1, Iclass_AE_ADD64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB64_args,
    1, Iclass_AE_SUB64_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG64_args,
    1, Iclass_AE_NEG64_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS64_args,
    1, Iclass_AE_ABS64_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADDSQ56S_args,
    2, Iclass_AE_ADDSQ56S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUBSQ56S_args,
    2, Iclass_AE_SUBSQ56S_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD64S_args,
    2, Iclass_AE_ADD64S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB64S_args,
    2, Iclass_AE_SUB64S_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEGSQ56S_args,
    2, Iclass_AE_NEGSQ56S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABSSQ56S_args,
    2, Iclass_AE_ABSSQ56S_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG64S_args,
    2, Iclass_AE_NEG64S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS64S_args,
    2, Iclass_AE_ABS64S_stateArgs, 0, 0 },
  { 3, Iclass_AE_AND_args,
    1, Iclass_AE_AND_stateArgs, 0, 0 },
  { 3, Iclass_AE_NAND_args,
    1, Iclass_AE_NAND_stateArgs, 0, 0 },
  { 3, Iclass_AE_OR_args,
    1, Iclass_AE_OR_stateArgs, 0, 0 },
  { 3, Iclass_AE_XOR_args,
    1, Iclass_AE_XOR_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI24_args,
    1, Iclass_AE_SLAI24_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRLI24_args,
    1, Iclass_AE_SRLI24_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI24_args,
    1, Iclass_AE_SRAI24_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLAS24_args,
    2, Iclass_AE_SLAS24_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRLS24_args,
    2, Iclass_AE_SRLS24_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRAS24_args,
    2, Iclass_AE_SRAS24_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI16_args,
    1, Iclass_AE_SRAI16_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI16R_args,
    1, Iclass_AE_SRAI16R_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI32_args,
    1, Iclass_AE_SLAI32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRLI32_args,
    1, Iclass_AE_SRLI32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI32_args,
    1, Iclass_AE_SRAI32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI32R_args,
    1, Iclass_AE_SRAI32R_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLAS32_args,
    2, Iclass_AE_SLAS32_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRLS32_args,
    2, Iclass_AE_SRLS32_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRAS32_args,
    2, Iclass_AE_SRAS32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAA32_args,
    1, Iclass_AE_SLAA32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRLA32_args,
    1, Iclass_AE_SRLA32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA32_args,
    1, Iclass_AE_SRAA32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI16S_args,
    2, Iclass_AE_SLAI16S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAA16S_args,
    2, Iclass_AE_SLAA16S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA16S_args,
    2, Iclass_AE_SRAA16S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA16RS_args,
    2, Iclass_AE_SRAA16RS_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI24S_args,
    2, Iclass_AE_SLAI24S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLAS24S_args,
    3, Iclass_AE_SLAS24S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI32S_args,
    2, Iclass_AE_SLAI32S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLAS32S_args,
    3, Iclass_AE_SLAS32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAA32S_args,
    2, Iclass_AE_SLAA32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA32S_args,
    2, Iclass_AE_SRAA32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA32RS_args,
    2, Iclass_AE_SRAA32RS_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLASQ56_args,
    2, Iclass_AE_SLASQ56_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRLSQ56_args,
    2, Iclass_AE_SRLSQ56_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRASQ56_args,
    2, Iclass_AE_SRASQ56_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAAQ56_args,
    1, Iclass_AE_SLAAQ56_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRLAQ56_args,
    1, Iclass_AE_SRLAQ56_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAAQ56_args,
    1, Iclass_AE_SRAAQ56_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI64_args,
    1, Iclass_AE_SLAI64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRLI64_args,
    1, Iclass_AE_SRLI64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI64_args,
    1, Iclass_AE_SRAI64_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLAS64_args,
    2, Iclass_AE_SLAS64_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRLS64_args,
    2, Iclass_AE_SRLS64_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRAS64_args,
    2, Iclass_AE_SRAS64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAA64_args,
    1, Iclass_AE_SLAA64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRLA64_args,
    1, Iclass_AE_SRLA64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA64_args,
    1, Iclass_AE_SRAA64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAISQ56S_args,
    2, Iclass_AE_SLAISQ56S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLASSQ56S_args,
    3, Iclass_AE_SLASSQ56S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAASQ56S_args,
    2, Iclass_AE_SLAASQ56S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI64S_args,
    2, Iclass_AE_SLAI64S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLAS64S_args,
    3, Iclass_AE_SLAS64S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAA64S_args,
    2, Iclass_AE_SLAA64S_stateArgs, 0, 0 },
  { 3, Iclass_AE_LT64_args,
    1, Iclass_AE_LT64_stateArgs, 0, 0 },
  { 3, Iclass_AE_LE64_args,
    1, Iclass_AE_LE64_stateArgs, 0, 0 },
  { 3, Iclass_AE_EQ64_args,
    1, Iclass_AE_EQ64_stateArgs, 0, 0 },
  { 3, Iclass_AE_MAX64_args,
    1, Iclass_AE_MAX64_stateArgs, 0, 0 },
  { 3, Iclass_AE_MIN64_args,
    1, Iclass_AE_MIN64_stateArgs, 0, 0 },
  { 2, Iclass_AE_NSA64_args,
    1, Iclass_AE_NSA64_stateArgs, 0, 0 },
  { 2, Iclass_AE_NSAZ16_0_args,
    1, Iclass_AE_NSAZ16_0_stateArgs, 0, 0 },
  { 2, Iclass_AE_NSAZ32_L_args,
    1, Iclass_AE_NSAZ32_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32F48P16S_LL_args,
    2, Iclass_AE_MULS32F48P16S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32S_LL_args,
    2, Iclass_AE_MULF32S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32_LL_args,
    1, Iclass_AE_MUL32_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32R_LL_args,
    1, Iclass_AE_MULF32R_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32F48P16S_LH_args,
    2, Iclass_AE_MULS32F48P16S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32S_LH_args,
    2, Iclass_AE_MULF32S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32_LH_args,
    1, Iclass_AE_MUL32_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32R_LH_args,
    1, Iclass_AE_MULF32R_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32F48P16S_HH_args,
    2, Iclass_AE_MULS32F48P16S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32S_HH_args,
    2, Iclass_AE_MULF32S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32_HH_args,
    1, Iclass_AE_MUL32_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32R_HH_args,
    1, Iclass_AE_MULF32R_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAS32F48P16S_LL_args,
    2, Iclass_AE_MULAS32F48P16S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32S_LL_args,
    2, Iclass_AE_MULAF32S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32_LL_args,
    1, Iclass_AE_MULA32_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32R_LL_args,
    1, Iclass_AE_MULAF32R_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAS32F48P16S_LH_args,
    2, Iclass_AE_MULAS32F48P16S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32S_LH_args,
    2, Iclass_AE_MULAF32S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32_LH_args,
    1, Iclass_AE_MULA32_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32R_LH_args,
    1, Iclass_AE_MULAF32R_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAS32F48P16S_HH_args,
    2, Iclass_AE_MULAS32F48P16S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32S_HH_args,
    2, Iclass_AE_MULAF32S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32_HH_args,
    1, Iclass_AE_MULA32_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32R_HH_args,
    1, Iclass_AE_MULAF32R_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSS32F48P16S_LL_args,
    2, Iclass_AE_MULSS32F48P16S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32S_LL_args,
    2, Iclass_AE_MULSF32S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32_LL_args,
    1, Iclass_AE_MULS32_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32R_LL_args,
    1, Iclass_AE_MULSF32R_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSS32F48P16S_LH_args,
    2, Iclass_AE_MULSS32F48P16S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32S_LH_args,
    2, Iclass_AE_MULSF32S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32_LH_args,
    1, Iclass_AE_MULS32_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32R_LH_args,
    1, Iclass_AE_MULSF32R_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSS32F48P16S_HH_args,
    2, Iclass_AE_MULSS32F48P16S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32S_HH_args,
    2, Iclass_AE_MULSF32S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32_HH_args,
    1, Iclass_AE_MULS32_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32R_HH_args,
    1, Iclass_AE_MULSF32R_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32U_LL_args,
    1, Iclass_AE_MUL32U_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32U_LL_args,
    1, Iclass_AE_MULA32U_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32U_LL_args,
    1, Iclass_AE_MULS32U_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_33_args,
    2, Iclass_AE_MULF16SS_33_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_22_args,
    2, Iclass_AE_MULF16SS_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_32_args,
    2, Iclass_AE_MULF16SS_32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_21_args,
    2, Iclass_AE_MULF16SS_21_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_31_args,
    2, Iclass_AE_MULF16SS_31_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_30_args,
    2, Iclass_AE_MULF16SS_30_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_10_args,
    2, Iclass_AE_MULF16SS_10_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_20_args,
    2, Iclass_AE_MULF16SS_20_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_11_args,
    2, Iclass_AE_MULF16SS_11_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_00_args,
    2, Iclass_AE_MULF16SS_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_33_args,
    2, Iclass_AE_MULSF16SS_33_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_22_args,
    2, Iclass_AE_MULSF16SS_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_32_args,
    2, Iclass_AE_MULSF16SS_32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_21_args,
    2, Iclass_AE_MULSF16SS_21_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_31_args,
    2, Iclass_AE_MULSF16SS_31_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_30_args,
    2, Iclass_AE_MULSF16SS_30_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_10_args,
    2, Iclass_AE_MULSF16SS_10_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_20_args,
    2, Iclass_AE_MULSF16SS_20_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_11_args,
    2, Iclass_AE_MULSF16SS_11_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_00_args,
    2, Iclass_AE_MULSF16SS_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_33_args,
    2, Iclass_AE_MULAF16SS_33_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_22_args,
    2, Iclass_AE_MULAF16SS_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_32_args,
    2, Iclass_AE_MULAF16SS_32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_21_args,
    2, Iclass_AE_MULAF16SS_21_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_31_args,
    2, Iclass_AE_MULAF16SS_31_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_30_args,
    2, Iclass_AE_MULAF16SS_30_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_10_args,
    2, Iclass_AE_MULAF16SS_10_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_20_args,
    2, Iclass_AE_MULAF16SS_20_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_11_args,
    2, Iclass_AE_MULAF16SS_11_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_00_args,
    2, Iclass_AE_MULAF16SS_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD16SS_33_22_args,
    2, Iclass_AE_MULAAFD16SS_33_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD16SS_13_02_args,
    2, Iclass_AE_MULAAFD16SS_13_02_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD16SS_11_00_args,
    2, Iclass_AE_MULAAFD16SS_11_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD16SS_33_22_args,
    2, Iclass_AE_MULSSFD16SS_33_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD16SS_13_02_args,
    2, Iclass_AE_MULSSFD16SS_13_02_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD16SS_11_00_args,
    2, Iclass_AE_MULSSFD16SS_11_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD16SS_33_22_args,
    2, Iclass_AE_MULZAAFD16SS_33_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD16SS_13_02_args,
    2, Iclass_AE_MULZAAFD16SS_13_02_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD16SS_11_00_args,
    2, Iclass_AE_MULZAAFD16SS_11_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD16SS_33_22_args,
    2, Iclass_AE_MULZSSFD16SS_33_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD16SS_13_02_args,
    2, Iclass_AE_MULZSSFD16SS_13_02_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD16SS_11_00_args,
    2, Iclass_AE_MULZSSFD16SS_11_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF48Q32SP16S_L_args,
    1, Iclass_AE_MULF48Q32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF48Q32SP16U_L_args,
    1, Iclass_AE_MULF48Q32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULQ32SP16S_L_args,
    1, Iclass_AE_MULQ32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULQ32SP16U_L_args,
    1, Iclass_AE_MULQ32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF48Q32SP16S_L_args,
    1, Iclass_AE_MULAF48Q32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF48Q32SP16U_L_args,
    1, Iclass_AE_MULAF48Q32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAQ32SP16S_L_args,
    1, Iclass_AE_MULAQ32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAQ32SP16U_L_args,
    1, Iclass_AE_MULAQ32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF48Q32SP16S_L_args,
    1, Iclass_AE_MULSF48Q32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF48Q32SP16U_L_args,
    1, Iclass_AE_MULSF48Q32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSQ32SP16S_L_args,
    1, Iclass_AE_MULSQ32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSQ32SP16U_L_args,
    1, Iclass_AE_MULSQ32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP24X2RA_args,
    1, Iclass_AE_MULFP24X2RA_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP24X2R_args,
    1, Iclass_AE_MULFP24X2R_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULP24X2_args,
    1, Iclass_AE_MULP24X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP24X2RA_args,
    1, Iclass_AE_MULAFP24X2RA_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP24X2R_args,
    1, Iclass_AE_MULAFP24X2R_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAP24X2_args,
    1, Iclass_AE_MULAP24X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP24X2RA_args,
    1, Iclass_AE_MULSFP24X2RA_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP24X2R_args,
    1, Iclass_AE_MULSFP24X2R_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSP24X2_args,
    1, Iclass_AE_MULSP24X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD24_HH_LL_args,
    1, Iclass_AE_MULZAAFD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD24_HH_LL_args,
    1, Iclass_AE_MULZAAD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD24_HL_LH_args,
    1, Iclass_AE_MULZAAFD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD24_HL_LH_args,
    1, Iclass_AE_MULZAAD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD24_HH_LL_args,
    1, Iclass_AE_MULZASFD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASD24_HH_LL_args,
    1, Iclass_AE_MULZASD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD24_HL_LH_args,
    1, Iclass_AE_MULZASFD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASD24_HL_LH_args,
    1, Iclass_AE_MULZASD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAFD24_HH_LL_args,
    1, Iclass_AE_MULZSAFD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAD24_HH_LL_args,
    1, Iclass_AE_MULZSAD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD24_HH_LL_args,
    1, Iclass_AE_MULZSSFD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSD24_HH_LL_args,
    1, Iclass_AE_MULZSSD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD24_HL_LH_args,
    1, Iclass_AE_MULZSSFD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSD24_HL_LH_args,
    1, Iclass_AE_MULZSSD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD24_HH_LL_args,
    1, Iclass_AE_MULAAFD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD24_HH_LL_args,
    1, Iclass_AE_MULAAD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD24_HL_LH_args,
    1, Iclass_AE_MULAAFD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD24_HL_LH_args,
    1, Iclass_AE_MULAAD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD24_HH_LL_args,
    1, Iclass_AE_MULASFD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASD24_HH_LL_args,
    1, Iclass_AE_MULASD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD24_HL_LH_args,
    1, Iclass_AE_MULASFD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASD24_HL_LH_args,
    1, Iclass_AE_MULASD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAFD24_HH_LL_args,
    1, Iclass_AE_MULSAFD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAD24_HH_LL_args,
    1, Iclass_AE_MULSAD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD24_HH_LL_args,
    1, Iclass_AE_MULSSFD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSD24_HH_LL_args,
    1, Iclass_AE_MULSSD24_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD24_HL_LH_args,
    1, Iclass_AE_MULSSFD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSD24_HL_LH_args,
    1, Iclass_AE_MULSSD24_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L0_args,
    1, Iclass_AE_MULF32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L0_args,
    1, Iclass_AE_MUL32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L1_args,
    1, Iclass_AE_MULF32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L1_args,
    1, Iclass_AE_MUL32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L2_args,
    1, Iclass_AE_MULF32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L2_args,
    1, Iclass_AE_MUL32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L3_args,
    1, Iclass_AE_MULF32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L3_args,
    1, Iclass_AE_MUL32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H0_args,
    1, Iclass_AE_MULF32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H0_args,
    1, Iclass_AE_MUL32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H1_args,
    1, Iclass_AE_MULF32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H1_args,
    1, Iclass_AE_MUL32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H2_args,
    1, Iclass_AE_MULF32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H2_args,
    1, Iclass_AE_MUL32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H3_args,
    1, Iclass_AE_MULF32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H3_args,
    1, Iclass_AE_MUL32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L0_args,
    1, Iclass_AE_MULAF32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L0_args,
    1, Iclass_AE_MULA32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L1_args,
    1, Iclass_AE_MULAF32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L1_args,
    1, Iclass_AE_MULA32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L2_args,
    1, Iclass_AE_MULAF32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L2_args,
    1, Iclass_AE_MULA32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L3_args,
    1, Iclass_AE_MULAF32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L3_args,
    1, Iclass_AE_MULA32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H0_args,
    1, Iclass_AE_MULAF32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H0_args,
    1, Iclass_AE_MULA32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H1_args,
    1, Iclass_AE_MULAF32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H1_args,
    1, Iclass_AE_MULA32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H2_args,
    1, Iclass_AE_MULAF32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H2_args,
    1, Iclass_AE_MULA32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H3_args,
    1, Iclass_AE_MULAF32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H3_args,
    1, Iclass_AE_MULA32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L0_args,
    1, Iclass_AE_MULSF32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L0_args,
    1, Iclass_AE_MULS32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L1_args,
    1, Iclass_AE_MULSF32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L1_args,
    1, Iclass_AE_MULS32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L2_args,
    1, Iclass_AE_MULSF32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L2_args,
    1, Iclass_AE_MULS32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L3_args,
    1, Iclass_AE_MULSF32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L3_args,
    1, Iclass_AE_MULS32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H0_args,
    1, Iclass_AE_MULSF32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H0_args,
    1, Iclass_AE_MULS32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H1_args,
    1, Iclass_AE_MULSF32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H1_args,
    1, Iclass_AE_MULS32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H2_args,
    1, Iclass_AE_MULSF32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H2_args,
    1, Iclass_AE_MULS32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H3_args,
    1, Iclass_AE_MULSF32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H3_args,
    1, Iclass_AE_MULS32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H3_L2_args,
    1, Iclass_AE_MULAAFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H3_L2_args,
    1, Iclass_AE_MULAAD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H1_L0_args,
    1, Iclass_AE_MULAAFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H1_L0_args,
    1, Iclass_AE_MULAAD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD32X16_H3_L2_args,
    1, Iclass_AE_MULASFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASD32X16_H3_L2_args,
    1, Iclass_AE_MULASD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD32X16_H1_L0_args,
    1, Iclass_AE_MULASFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASD32X16_H1_L0_args,
    1, Iclass_AE_MULASD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAFD32X16_H3_L2_args,
    1, Iclass_AE_MULSAFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAD32X16_H3_L2_args,
    1, Iclass_AE_MULSAD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAFD32X16_H1_L0_args,
    1, Iclass_AE_MULSAFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAD32X16_H1_L0_args,
    1, Iclass_AE_MULSAD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD32X16_H3_L2_args,
    1, Iclass_AE_MULSSFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSD32X16_H3_L2_args,
    1, Iclass_AE_MULSSD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD32X16_H1_L0_args,
    1, Iclass_AE_MULSSFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSD32X16_H1_L0_args,
    1, Iclass_AE_MULSSD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H3_L2_args,
    1, Iclass_AE_MULZAAFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H3_L2_args,
    1, Iclass_AE_MULZAAD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H1_L0_args,
    1, Iclass_AE_MULZAAFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H1_L0_args,
    1, Iclass_AE_MULZAAD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD32X16_H3_L2_args,
    1, Iclass_AE_MULZASFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASD32X16_H3_L2_args,
    1, Iclass_AE_MULZASD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD32X16_H1_L0_args,
    1, Iclass_AE_MULZASFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASD32X16_H1_L0_args,
    1, Iclass_AE_MULZASD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAFD32X16_H3_L2_args,
    1, Iclass_AE_MULZSAFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAD32X16_H3_L2_args,
    1, Iclass_AE_MULZSAD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAFD32X16_H1_L0_args,
    1, Iclass_AE_MULZSAFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAD32X16_H1_L0_args,
    1, Iclass_AE_MULZSAD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD32X16_H3_L2_args,
    1, Iclass_AE_MULZSSFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSD32X16_H3_L2_args,
    1, Iclass_AE_MULZSSD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD32X16_H1_L0_args,
    1, Iclass_AE_MULZSSFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSD32X16_H1_L0_args,
    1, Iclass_AE_MULZSSD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H2_L3_args,
    1, Iclass_AE_MULZAAFD32X16_H2_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H0_L1_args,
    1, Iclass_AE_MULZAAFD32X16_H0_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H2_L3_args,
    1, Iclass_AE_MULAAFD32X16_H2_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H0_L1_args,
    1, Iclass_AE_MULAAFD32X16_H0_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H2_L3_args,
    1, Iclass_AE_MULZAAD32X16_H2_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H0_L1_args,
    1, Iclass_AE_MULZAAD32X16_H0_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H2_L3_args,
    1, Iclass_AE_MULAAD32X16_H2_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H0_L1_args,
    1, Iclass_AE_MULAAD32X16_H0_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULP32X16X2_H_args,
    1, Iclass_AE_MULP32X16X2_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RS_H_args,
    2, Iclass_AE_MULFP32X16X2RS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RAS_H_args,
    2, Iclass_AE_MULFP32X16X2RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULP32X16X2_L_args,
    1, Iclass_AE_MULP32X16X2_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RS_L_args,
    2, Iclass_AE_MULFP32X16X2RS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RAS_L_args,
    2, Iclass_AE_MULFP32X16X2RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAP32X16X2_H_args,
    1, Iclass_AE_MULAP32X16X2_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RS_H_args,
    2, Iclass_AE_MULAFP32X16X2RS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RAS_H_args,
    2, Iclass_AE_MULAFP32X16X2RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAP32X16X2_L_args,
    1, Iclass_AE_MULAP32X16X2_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RS_L_args,
    2, Iclass_AE_MULAFP32X16X2RS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RAS_L_args,
    2, Iclass_AE_MULAFP32X16X2RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSP32X16X2_H_args,
    1, Iclass_AE_MULSP32X16X2_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RS_H_args,
    2, Iclass_AE_MULSFP32X16X2RS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RAS_H_args,
    2, Iclass_AE_MULSFP32X16X2RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSP32X16X2_L_args,
    1, Iclass_AE_MULSP32X16X2_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RS_L_args,
    2, Iclass_AE_MULSFP32X16X2RS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RAS_L_args,
    2, Iclass_AE_MULSFP32X16X2RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFCR32X16RAS_L_args,
    2, Iclass_AE_MULFCR32X16RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFCR32X16RAS_H_args,
    2, Iclass_AE_MULFCR32X16RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFCI32X16RAS_L_args,
    2, Iclass_AE_MULFCI32X16RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFCI32X16RAS_H_args,
    2, Iclass_AE_MULFCI32X16RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFCR32X16RAS_L_args,
    2, Iclass_AE_MULAFCR32X16RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFCR32X16RAS_H_args,
    2, Iclass_AE_MULAFCR32X16RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFCI32X16RAS_L_args,
    2, Iclass_AE_MULAFCI32X16RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFCI32X16RAS_H_args,
    2, Iclass_AE_MULAFCI32X16RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULP32X2_H_args,
    1, Iclass_AE_MULP32X2_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAP32X2_H_args,
    1, Iclass_AE_MULAP32X2_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSP32X2_H_args,
    1, Iclass_AE_MULSP32X2_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULP32X2_L_args,
    1, Iclass_AE_MULP32X2_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAP32X2_L_args,
    1, Iclass_AE_MULAP32X2_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSP32X2_L_args,
    1, Iclass_AE_MULSP32X2_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X2RS_H_args,
    2, Iclass_AE_MULFP32X2RS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X2RAS_H_args,
    2, Iclass_AE_MULFP32X2RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X2RS_H_args,
    2, Iclass_AE_MULAFP32X2RS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X2RAS_H_args,
    2, Iclass_AE_MULAFP32X2RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X2RS_H_args,
    2, Iclass_AE_MULSFP32X2RS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X2RAS_H_args,
    2, Iclass_AE_MULSFP32X2RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X2RS_L_args,
    2, Iclass_AE_MULFP32X2RS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X2RAS_L_args,
    2, Iclass_AE_MULFP32X2RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X2RS_L_args,
    2, Iclass_AE_MULAFP32X2RS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X2RAS_L_args,
    2, Iclass_AE_MULAFP32X2RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X2RS_L_args,
    2, Iclass_AE_MULSFP32X2RS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X2RAS_L_args,
    2, Iclass_AE_MULSFP32X2RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP16X4S_H_args,
    2, Iclass_AE_MULFP16X4S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP16X4RAS_H_args,
    2, Iclass_AE_MULFP16X4RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP16X4S_L_args,
    2, Iclass_AE_MULFP16X4S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP16X4RAS_L_args,
    2, Iclass_AE_MULFP16X4RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULCR24_args,
    1, Iclass_AE_MULCR24_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFCR24RA_args,
    1, Iclass_AE_MULFCR24RA_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULCR32X16_L_args,
    1, Iclass_AE_MULCR32X16_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULCR32X16_H_args,
    1, Iclass_AE_MULCR32X16_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULCI24_args,
    1, Iclass_AE_MULCI24_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFCI24RA_args,
    1, Iclass_AE_MULFCI24RA_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULCI32X16_L_args,
    1, Iclass_AE_MULCI32X16_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULCI32X16_H_args,
    1, Iclass_AE_MULCI32X16_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULACR24_args,
    1, Iclass_AE_MULACR24_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFCR24RA_args,
    1, Iclass_AE_MULAFCR24RA_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULACR32X16_L_args,
    1, Iclass_AE_MULACR32X16_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULACR32X16_H_args,
    1, Iclass_AE_MULACR32X16_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULACI24_args,
    1, Iclass_AE_MULACI24_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFCI24RA_args,
    1, Iclass_AE_MULAFCI24RA_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULACI32X16_L_args,
    1, Iclass_AE_MULACI32X16_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULACI32X16_H_args,
    1, Iclass_AE_MULACI32X16_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16X4SS_H_args,
    2, Iclass_AE_MULF16X4SS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16X4SS_H_args,
    2, Iclass_AE_MULAF16X4SS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16X4SS_H_args,
    2, Iclass_AE_MULSF16X4SS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16X4SS_L_args,
    2, Iclass_AE_MULF16X4SS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16X4SS_L_args,
    2, Iclass_AE_MULAF16X4SS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16X4SS_L_args,
    2, Iclass_AE_MULSF16X4SS_L_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULFD24X2_FIR_H_H_args,
    1, Iclass_AE_MULFD24X2_FIR_H_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFD24X2_FIR_H_L_args,
    1, Iclass_AE_MULFD24X2_FIR_H_L_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULFD32X16X2_FIR_HH_H_args,
    1, Iclass_AE_MULFD32X16X2_FIR_HH_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFD32X16X2_FIR_HH_L_args,
    1, Iclass_AE_MULFD32X16X2_FIR_HH_L_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULFD32X16X2_FIR_HL_H_args,
    1, Iclass_AE_MULFD32X16X2_FIR_HL_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFD32X16X2_FIR_HL_L_args,
    1, Iclass_AE_MULFD32X16X2_FIR_HL_L_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULAFD24X2_FIR_H_H_args,
    1, Iclass_AE_MULAFD24X2_FIR_H_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFD24X2_FIR_H_L_args,
    1, Iclass_AE_MULAFD24X2_FIR_H_L_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULAFD32X16X2_FIR_HH_H_args,
    1, Iclass_AE_MULAFD32X16X2_FIR_HH_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFD32X16X2_FIR_HH_L_args,
    1, Iclass_AE_MULAFD32X16X2_FIR_HH_L_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULAFD32X16X2_FIR_HL_H_args,
    1, Iclass_AE_MULAFD32X16X2_FIR_HL_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFD32X16X2_FIR_HL_L_args,
    1, Iclass_AE_MULAFD32X16X2_FIR_HL_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL16X4_H_args,
    1, Iclass_AE_MUL16X4_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA16X4_H_args,
    1, Iclass_AE_MULA16X4_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS16X4_H_args,
    1, Iclass_AE_MULS16X4_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL16X4_L_args,
    1, Iclass_AE_MUL16X4_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA16X4_L_args,
    1, Iclass_AE_MULA16X4_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS16X4_L_args,
    1, Iclass_AE_MULS16X4_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULC16S_H_args,
    2, Iclass_AE_MULC16S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULC16S_L_args,
    2, Iclass_AE_MULC16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAC16S_H_args,
    2, Iclass_AE_MULAC16S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAC16S_L_args,
    2, Iclass_AE_MULAC16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFC16RAS_H_args,
    2, Iclass_AE_MULFC16RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFC16RAS_L_args,
    2, Iclass_AE_MULFC16RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFC16RAS_H_args,
    2, Iclass_AE_MULAFC16RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFC16RAS_L_args,
    2, Iclass_AE_MULAFC16RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAAAQ16_args,
    1, Iclass_AE_MULZAAAAQ16_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAAAQ16_args,
    1, Iclass_AE_MULAAAAQ16_stateArgs, 0, 0 },
  { 2, Iclass_AE_MUL16JS_args,
    1, Iclass_AE_MUL16JS_stateArgs, 0, 0 },
  { 1, Iclass_AE_CALCRNG3_args,
    2, Iclass_AE_CALCRNG3_stateArgs, 0, 0 },
  { 2, Iclass_AE_ADDANDSUBRNG16RAS_S1_args,
    3, Iclass_AE_ADDANDSUBRNG16RAS_S1_stateArgs, 0, 0 },
  { 2, Iclass_AE_ADDANDSUBRNG16RAS_S2_args,
    3, Iclass_AE_ADDANDSUBRNG16RAS_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MAXABS16S_args,
    2, Iclass_AE_MAXABS16S_stateArgs, 0, 0 },
  { 3, Iclass_MULL_args,
    0, 0, 0, 0 },
  { 3, Iclass_MULUH_args,
    0, 0, 0, 0 },
  { 3, Iclass_MULSH_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_DIV64D32_H_args,
    1, Iclass_AE_DIV64D32_H_stateArgs, 0, 0 },
  { 2, Iclass_AE_DIV64D32_L_args,
    1, Iclass_AE_DIV64D32_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_SHA32_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_VLDL32T_args,
    5, Iclass_AE_VLDL32T_stateArgs, 0, 0 },
  { 3, Iclass_AE_VLDL16T_args,
    5, Iclass_AE_VLDL16T_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLDL16C_args,
    8, Iclass_AE_VLDL16C_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLDL16C_IP_args,
    8, Iclass_AE_VLDL16C_IP_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLDL16C_IC_args,
    11, Iclass_AE_VLDL16C_IC_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLDSHT_args,
    6, Iclass_AE_VLDSHT_stateArgs, 0, 0 },
  { 2, Iclass_AE_LB_args,
    3, Iclass_AE_LB_stateArgs, 0, 0 },
  { 2, Iclass_AE_LBI_args,
    3, Iclass_AE_LBI_stateArgs, 0, 0 },
  { 3, Iclass_AE_LBK_args,
    3, Iclass_AE_LBK_stateArgs, 0, 0 },
  { 3, Iclass_AE_LBKI_args,
    3, Iclass_AE_LBKI_stateArgs, 0, 0 },
  { 2, Iclass_AE_LBS_args,
    3, Iclass_AE_LBS_stateArgs, 0, 0 },
  { 2, Iclass_AE_LBSI_args,
    3, Iclass_AE_LBSI_stateArgs, 0, 0 },
  { 2, Iclass_AE_DB_args,
    3, Iclass_AE_DB_stateArgs, 0, 0 },
  { 2, Iclass_AE_DBI_args,
    3, Iclass_AE_DBI_stateArgs, 0, 0 },
  { 2, Iclass_AE_DB_IC_args,
    6, Iclass_AE_DB_IC_stateArgs, 0, 0 },
  { 2, Iclass_AE_DBI_IC_args,
    6, Iclass_AE_DBI_IC_stateArgs, 0, 0 },
  { 2, Iclass_AE_DB_IP_args,
    3, Iclass_AE_DB_IP_stateArgs, 0, 0 },
  { 2, Iclass_AE_DBI_IP_args,
    3, Iclass_AE_DBI_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_VLEL32T_args,
    3, Iclass_AE_VLEL32T_stateArgs, 0, 0 },
  { 3, Iclass_AE_VLEL16T_args,
    3, Iclass_AE_VLEL16T_stateArgs, 0, 0 },
  { 2, Iclass_AE_SB_args,
    4, Iclass_AE_SB_stateArgs, 0, 0 },
  { 3, Iclass_AE_SBI_args,
    3, Iclass_AE_SBI_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLES16C_args,
    5, Iclass_AE_VLES16C_stateArgs, 0, 0 },
  { 1, Iclass_AE_SBF_args,
    3, Iclass_AE_SBF_stateArgs, 0, 0 },
  { 2, Iclass_AE_SB_IC_args,
    7, Iclass_AE_SB_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SBI_IC_args,
    6, Iclass_AE_SBI_IC_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLES16C_IC_args,
    8, Iclass_AE_VLES16C_IC_stateArgs, 0, 0 },
  { 1, Iclass_AE_SBF_IC_args,
    6, Iclass_AE_SBF_IC_stateArgs, 0, 0 },
  { 2, Iclass_AE_SB_IP_args,
    4, Iclass_AE_SB_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SBI_IP_args,
    3, Iclass_AE_SBI_IP_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLES16C_IP_args,
    5, Iclass_AE_VLES16C_IP_stateArgs, 0, 0 },
  { 1, Iclass_AE_SBF_IP_args,
    3, Iclass_AE_SBF_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S8IP_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_S16IP_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_S32IP_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_L16SI_N_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_L16UI_N_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_S16I_N_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_ZEROB_args,
    1, Iclass_AE_ZEROB_stateArgs, 0, 0 },
  { 3, Iclass_AE_SEXT32_args,
    1, Iclass_AE_SEXT32_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2_L_IP_args,
    1, Iclass_AE_S32X2_L_IP_stateArgs, 0, 0 },
  { 1, Iclass_AE_MOVFCRFSRV_args,
    7, Iclass_AE_MOVFCRFSRV_stateArgs, 0, 0 },
  { 1, Iclass_AE_MOVVFCRFSR_args,
    7, Iclass_AE_MOVVFCRFSR_stateArgs, 0, 0 },
  { 2, Iclass_ABS_S_args,
    1, Iclass_ABS_S_stateArgs, 0, 0 },
  { 2, Iclass_NEG_S_args,
    1, Iclass_NEG_S_stateArgs, 0, 0 },
  { 2, Iclass_NEG_LH_S_args,
    1, Iclass_NEG_LH_S_stateArgs, 0, 0 },
  { 3, Iclass_MOVEQZ_S_args,
    1, Iclass_MOVEQZ_S_stateArgs, 0, 0 },
  { 3, Iclass_MOVNEZ_S_args,
    1, Iclass_MOVNEZ_S_stateArgs, 0, 0 },
  { 3, Iclass_MOVLTZ_S_args,
    1, Iclass_MOVLTZ_S_stateArgs, 0, 0 },
  { 3, Iclass_MOVGEZ_S_args,
    1, Iclass_MOVGEZ_S_stateArgs, 0, 0 },
  { 3, Iclass_MOVF_S_args,
    1, Iclass_MOVF_S_stateArgs, 0, 0 },
  { 3, Iclass_MOVT_S_args,
    1, Iclass_MOVT_S_stateArgs, 0, 0 },
  { 2, Iclass_WFR_args,
    1, Iclass_WFR_stateArgs, 0, 0 },
  { 2, Iclass_RFR_args,
    1, Iclass_RFR_stateArgs, 0, 0 },
  { 3, Iclass_TRUNC_S_args,
    3, Iclass_TRUNC_S_stateArgs, 0, 0 },
  { 3, Iclass_UTRUNC_S_args,
    3, Iclass_UTRUNC_S_stateArgs, 0, 0 },
  { 3, Iclass_FLOAT_S_args,
    3, Iclass_FLOAT_S_stateArgs, 0, 0 },
  { 3, Iclass_UFLOAT_S_args,
    3, Iclass_UFLOAT_S_stateArgs, 0, 0 },
  { 2, Iclass_FICEIL_S_args,
    2, Iclass_FICEIL_S_stateArgs, 0, 0 },
  { 2, Iclass_FIFLOOR_S_args,
    2, Iclass_FIFLOOR_S_stateArgs, 0, 0 },
  { 2, Iclass_FIROUND_S_args,
    2, Iclass_FIROUND_S_stateArgs, 0, 0 },
  { 2, Iclass_FITRUNC_S_args,
    2, Iclass_FITRUNC_S_stateArgs, 0, 0 },
  { 2, Iclass_FIRINT_S_args,
    4, Iclass_FIRINT_S_stateArgs, 0, 0 },
  { 3, Iclass_UN_S_args,
    2, Iclass_UN_S_stateArgs, 0, 0 },
  { 3, Iclass_ULT_S_args,
    2, Iclass_ULT_S_stateArgs, 0, 0 },
  { 3, Iclass_ULE_S_args,
    2, Iclass_ULE_S_stateArgs, 0, 0 },
  { 3, Iclass_UEQ_S_args,
    2, Iclass_UEQ_S_stateArgs, 0, 0 },
  { 3, Iclass_OLT_S_args,
    2, Iclass_OLT_S_stateArgs, 0, 0 },
  { 3, Iclass_OLE_S_args,
    2, Iclass_OLE_S_stateArgs, 0, 0 },
  { 3, Iclass_OEQ_S_args,
    2, Iclass_OEQ_S_stateArgs, 0, 0 },
  { 3, Iclass_ADD_S_args,
    6, Iclass_ADD_S_stateArgs, 0, 0 },
  { 3, Iclass_ADD_LLH_S_args,
    6, Iclass_ADD_LLH_S_stateArgs, 0, 0 },
  { 3, Iclass_ADD_LHH_S_args,
    6, Iclass_ADD_LHH_S_stateArgs, 0, 0 },
  { 3, Iclass_SUB_S_args,
    6, Iclass_SUB_S_stateArgs, 0, 0 },
  { 3, Iclass_SUB_LLH_S_args,
    6, Iclass_SUB_LLH_S_stateArgs, 0, 0 },
  { 3, Iclass_SUB_LHH_S_args,
    6, Iclass_SUB_LHH_S_stateArgs, 0, 0 },
  { 3, Iclass_MUL_S_args,
    6, Iclass_MUL_S_stateArgs, 0, 0 },
  { 3, Iclass_MUL_LLH_S_args,
    6, Iclass_MUL_LLH_S_stateArgs, 0, 0 },
  { 3, Iclass_MUL_LHH_S_args,
    6, Iclass_MUL_LHH_S_stateArgs, 0, 0 },
  { 3, Iclass_MADD_S_args,
    6, Iclass_MADD_S_stateArgs, 0, 0 },
  { 3, Iclass_MADD_LLH_S_args,
    6, Iclass_MADD_LLH_S_stateArgs, 0, 0 },
  { 3, Iclass_MADD_LHH_S_args,
    6, Iclass_MADD_LHH_S_stateArgs, 0, 0 },
  { 3, Iclass_MSUB_S_args,
    6, Iclass_MSUB_S_stateArgs, 0, 0 },
  { 3, Iclass_MSUB_LLH_S_args,
    6, Iclass_MSUB_LLH_S_stateArgs, 0, 0 },
  { 3, Iclass_MSUB_LHH_S_args,
    6, Iclass_MSUB_LHH_S_stateArgs, 0, 0 },
  { 2, Iclass_SQRT0_S_args,
    1, Iclass_SQRT0_S_stateArgs, 0, 0 },
  { 2, Iclass_DIV0_S_args,
    1, Iclass_DIV0_S_stateArgs, 0, 0 },
  { 2, Iclass_RECIP0_S_args,
    3, Iclass_RECIP0_S_stateArgs, 0, 0 },
  { 2, Iclass_RSQRT0_S_args,
    3, Iclass_RSQRT0_S_stateArgs, 0, 0 },
  { 3, Iclass_MADDN_S_args,
    1, Iclass_MADDN_S_stateArgs, 0, 0 },
  { 3, Iclass_MSUBN_S_args,
    1, Iclass_MSUBN_S_stateArgs, 0, 0 },
  { 3, Iclass_DIVN_S_args,
    5, Iclass_DIVN_S_stateArgs, 0, 0 },
  { 2, Iclass_CONST_S_args,
    1, Iclass_CONST_S_stateArgs, 0, 0 },
  { 2, Iclass_NEXP01_S_args,
    1, Iclass_NEXP01_S_stateArgs, 0, 0 },
  { 2, Iclass_ADDEXP_S_args,
    1, Iclass_ADDEXP_S_stateArgs, 0, 0 },
  { 2, Iclass_ADDEXPM_S_args,
    1, Iclass_ADDEXPM_S_stateArgs, 0, 0 },
  { 2, Iclass_MKDADJ_S_args,
    3, Iclass_MKDADJ_S_stateArgs, 0, 0 },
  { 2, Iclass_MKSADJ_S_args,
    2, Iclass_MKSADJ_S_stateArgs, 0, 0 }
};

enum xtensa_iclass_id {
  ICLASS_xt_iclass_excw,
  ICLASS_xt_iclass_rfe,
  ICLASS_xt_iclass_rfde,
  ICLASS_xt_iclass_syscall,
  ICLASS_xt_iclass_call12,
  ICLASS_xt_iclass_call8,
  ICLASS_xt_iclass_call4,
  ICLASS_xt_iclass_callx12,
  ICLASS_xt_iclass_callx8,
  ICLASS_xt_iclass_callx4,
  ICLASS_xt_iclass_entry,
  ICLASS_xt_iclass_movsp,
  ICLASS_xt_iclass_rotw,
  ICLASS_xt_iclass_retw,
  ICLASS_xt_iclass_rfwou,
  ICLASS_xt_iclass_l32e,
  ICLASS_xt_iclass_s32e,
  ICLASS_xt_iclass_rsr_windowbase,
  ICLASS_xt_iclass_wsr_windowbase,
  ICLASS_xt_iclass_xsr_windowbase,
  ICLASS_xt_iclass_rsr_windowstart,
  ICLASS_xt_iclass_wsr_windowstart,
  ICLASS_xt_iclass_xsr_windowstart,
  ICLASS_xt_iclass_add_n,
  ICLASS_xt_iclass_addi_n,
  ICLASS_xt_iclass_bz6,
  ICLASS_xt_iclass_ill_n,
  ICLASS_xt_iclass_loadi4,
  ICLASS_xt_iclass_mov_n,
  ICLASS_xt_iclass_movi_n,
  ICLASS_xt_iclass_nopn,
  ICLASS_xt_iclass_retn,
  ICLASS_xt_iclass_storei4,
  ICLASS_rur_threadptr,
  ICLASS_wur_threadptr,
  ICLASS_xt_iclass_addi,
  ICLASS_xt_iclass_addmi,
  ICLASS_xt_iclass_addsub,
  ICLASS_xt_iclass_bit,
  ICLASS_xt_iclass_bsi8,
  ICLASS_xt_iclass_bsi8b,
  ICLASS_xt_iclass_bsi8u,
  ICLASS_xt_iclass_bst8,
  ICLASS_xt_iclass_bsz12,
  ICLASS_xt_iclass_call0,
  ICLASS_xt_iclass_callx0,
  ICLASS_xt_iclass_exti,
  ICLASS_xt_iclass_ill,
  ICLASS_xt_iclass_jump,
  ICLASS_xt_iclass_jumpx,
  ICLASS_xt_iclass_l16ui,
  ICLASS_xt_iclass_l16si,
  ICLASS_xt_iclass_l32i,
  ICLASS_xt_iclass_l32r,
  ICLASS_xt_iclass_l8i,
  ICLASS_xt_iclass_loop,
  ICLASS_xt_iclass_loopz,
  ICLASS_xt_iclass_movi,
  ICLASS_xt_iclass_movz,
  ICLASS_xt_iclass_neg,
  ICLASS_xt_iclass_nop,
  ICLASS_xt_iclass_return,
  ICLASS_xt_iclass_simcall,
  ICLASS_xt_iclass_s16i,
  ICLASS_xt_iclass_s32i,
  ICLASS_xt_iclass_s32nb,
  ICLASS_xt_iclass_s8i,
  ICLASS_xt_iclass_sar,
  ICLASS_xt_iclass_sari,
  ICLASS_xt_iclass_shifts,
  ICLASS_xt_iclass_shiftst,
  ICLASS_xt_iclass_shiftt,
  ICLASS_xt_iclass_slli,
  ICLASS_xt_iclass_srai,
  ICLASS_xt_iclass_srli,
  ICLASS_xt_iclass_memw,
  ICLASS_xt_iclass_extw,
  ICLASS_xt_iclass_isync,
  ICLASS_xt_iclass_sync,
  ICLASS_xt_iclass_rsil,
  ICLASS_xt_iclass_rsr_lend,
  ICLASS_xt_iclass_wsr_lend,
  ICLASS_xt_iclass_xsr_lend,
  ICLASS_xt_iclass_rsr_lcount,
  ICLASS_xt_iclass_wsr_lcount,
  ICLASS_xt_iclass_xsr_lcount,
  ICLASS_xt_iclass_rsr_lbeg,
  ICLASS_xt_iclass_wsr_lbeg,
  ICLASS_xt_iclass_xsr_lbeg,
  ICLASS_xt_iclass_rsr_sar,
  ICLASS_xt_iclass_wsr_sar,
  ICLASS_xt_iclass_xsr_sar,
  ICLASS_xt_iclass_rsr_memctl,
  ICLASS_xt_iclass_wsr_memctl,
  ICLASS_xt_iclass_xsr_memctl,
  ICLASS_xt_iclass_rsr_litbase,
  ICLASS_xt_iclass_wsr_litbase,
  ICLASS_xt_iclass_xsr_litbase,
  ICLASS_xt_iclass_rsr_configid0,
  ICLASS_xt_iclass_wsr_configid0,
  ICLASS_xt_iclass_rsr_configid1,
  ICLASS_xt_iclass_rsr_ps,
  ICLASS_xt_iclass_wsr_ps,
  ICLASS_xt_iclass_xsr_ps,
  ICLASS_xt_iclass_rsr_epc1,
  ICLASS_xt_iclass_wsr_epc1,
  ICLASS_xt_iclass_xsr_epc1,
  ICLASS_xt_iclass_rsr_excsave1,
  ICLASS_xt_iclass_wsr_excsave1,
  ICLASS_xt_iclass_xsr_excsave1,
  ICLASS_xt_iclass_rsr_epc2,
  ICLASS_xt_iclass_wsr_epc2,
  ICLASS_xt_iclass_xsr_epc2,
  ICLASS_xt_iclass_rsr_excsave2,
  ICLASS_xt_iclass_wsr_excsave2,
  ICLASS_xt_iclass_xsr_excsave2,
  ICLASS_xt_iclass_rsr_epc3,
  ICLASS_xt_iclass_wsr_epc3,
  ICLASS_xt_iclass_xsr_epc3,
  ICLASS_xt_iclass_rsr_excsave3,
  ICLASS_xt_iclass_wsr_excsave3,
  ICLASS_xt_iclass_xsr_excsave3,
  ICLASS_xt_iclass_rsr_epc4,
  ICLASS_xt_iclass_wsr_epc4,
  ICLASS_xt_iclass_xsr_epc4,
  ICLASS_xt_iclass_rsr_excsave4,
  ICLASS_xt_iclass_wsr_excsave4,
  ICLASS_xt_iclass_xsr_excsave4,
  ICLASS_xt_iclass_rsr_epc5,
  ICLASS_xt_iclass_wsr_epc5,
  ICLASS_xt_iclass_xsr_epc5,
  ICLASS_xt_iclass_rsr_excsave5,
  ICLASS_xt_iclass_wsr_excsave5,
  ICLASS_xt_iclass_xsr_excsave5,
  ICLASS_xt_iclass_rsr_eps2,
  ICLASS_xt_iclass_wsr_eps2,
  ICLASS_xt_iclass_xsr_eps2,
  ICLASS_xt_iclass_rsr_eps3,
  ICLASS_xt_iclass_wsr_eps3,
  ICLASS_xt_iclass_xsr_eps3,
  ICLASS_xt_iclass_rsr_eps4,
  ICLASS_xt_iclass_wsr_eps4,
  ICLASS_xt_iclass_xsr_eps4,
  ICLASS_xt_iclass_rsr_eps5,
  ICLASS_xt_iclass_wsr_eps5,
  ICLASS_xt_iclass_xsr_eps5,
  ICLASS_xt_iclass_rsr_excvaddr,
  ICLASS_xt_iclass_wsr_excvaddr,
  ICLASS_xt_iclass_xsr_excvaddr,
  ICLASS_xt_iclass_rsr_depc,
  ICLASS_xt_iclass_wsr_depc,
  ICLASS_xt_iclass_xsr_depc,
  ICLASS_xt_iclass_rsr_exccause,
  ICLASS_xt_iclass_wsr_exccause,
  ICLASS_xt_iclass_xsr_exccause,
  ICLASS_xt_iclass_rsr_misc0,
  ICLASS_xt_iclass_wsr_misc0,
  ICLASS_xt_iclass_xsr_misc0,
  ICLASS_xt_iclass_rsr_misc1,
  ICLASS_xt_iclass_wsr_misc1,
  ICLASS_xt_iclass_xsr_misc1,
  ICLASS_xt_iclass_rsr_prid,
  ICLASS_xt_iclass_rsr_vecbase,
  ICLASS_xt_iclass_wsr_vecbase,
  ICLASS_xt_iclass_xsr_vecbase,
  ICLASS_xt_iclass_mac16_aa,
  ICLASS_xt_iclass_mac16_ad,
  ICLASS_xt_iclass_mac16_da,
  ICLASS_xt_iclass_mac16_dd,
  ICLASS_xt_iclass_mac16a_aa,
  ICLASS_xt_iclass_mac16a_ad,
  ICLASS_xt_iclass_mac16a_da,
  ICLASS_xt_iclass_mac16a_dd,
  ICLASS_xt_iclass_mac16al_da,
  ICLASS_xt_iclass_mac16al_dd,
  ICLASS_xt_iclass_mac16_l,
  ICLASS_xt_iclass_rsr_m0,
  ICLASS_xt_iclass_wsr_m0,
  ICLASS_xt_iclass_xsr_m0,
  ICLASS_xt_iclass_rsr_m1,
  ICLASS_xt_iclass_wsr_m1,
  ICLASS_xt_iclass_xsr_m1,
  ICLASS_xt_iclass_rsr_m2,
  ICLASS_xt_iclass_wsr_m2,
  ICLASS_xt_iclass_xsr_m2,
  ICLASS_xt_iclass_rsr_m3,
  ICLASS_xt_iclass_wsr_m3,
  ICLASS_xt_iclass_xsr_m3,
  ICLASS_xt_iclass_rsr_acclo,
  ICLASS_xt_iclass_wsr_acclo,
  ICLASS_xt_iclass_xsr_acclo,
  ICLASS_xt_iclass_rsr_acchi,
  ICLASS_xt_iclass_wsr_acchi,
  ICLASS_xt_iclass_xsr_acchi,
  ICLASS_xt_iclass_rfi,
  ICLASS_xt_iclass_wait,
  ICLASS_xt_iclass_rsr_interrupt,
  ICLASS_xt_iclass_wsr_intset,
  ICLASS_xt_iclass_wsr_intclear,
  ICLASS_xt_iclass_rsr_intenable,
  ICLASS_xt_iclass_wsr_intenable,
  ICLASS_xt_iclass_xsr_intenable,
  ICLASS_xt_iclass_break,
  ICLASS_xt_iclass_break_n,
  ICLASS_xt_iclass_rsr_dbreaka0,
  ICLASS_xt_iclass_wsr_dbreaka0,
  ICLASS_xt_iclass_xsr_dbreaka0,
  ICLASS_xt_iclass_rsr_dbreakc0,
  ICLASS_xt_iclass_wsr_dbreakc0,
  ICLASS_xt_iclass_xsr_dbreakc0,
  ICLASS_xt_iclass_rsr_dbreaka1,
  ICLASS_xt_iclass_wsr_dbreaka1,
  ICLASS_xt_iclass_xsr_dbreaka1,
  ICLASS_xt_iclass_rsr_dbreakc1,
  ICLASS_xt_iclass_wsr_dbreakc1,
  ICLASS_xt_iclass_xsr_dbreakc1,
  ICLASS_xt_iclass_rsr_ibreaka0,
  ICLASS_xt_iclass_wsr_ibreaka0,
  ICLASS_xt_iclass_xsr_ibreaka0,
  ICLASS_xt_iclass_rsr_ibreaka1,
  ICLASS_xt_iclass_wsr_ibreaka1,
  ICLASS_xt_iclass_xsr_ibreaka1,
  ICLASS_xt_iclass_rsr_ibreakenable,
  ICLASS_xt_iclass_wsr_ibreakenable,
  ICLASS_xt_iclass_xsr_ibreakenable,
  ICLASS_xt_iclass_rsr_debugcause,
  ICLASS_xt_iclass_wsr_debugcause,
  ICLASS_xt_iclass_xsr_debugcause,
  ICLASS_xt_iclass_rsr_icount,
  ICLASS_xt_iclass_wsr_icount,
  ICLASS_xt_iclass_xsr_icount,
  ICLASS_xt_iclass_rsr_icountlevel,
  ICLASS_xt_iclass_wsr_icountlevel,
  ICLASS_xt_iclass_xsr_icountlevel,
  ICLASS_xt_iclass_rsr_ddr,
  ICLASS_xt_iclass_wsr_ddr,
  ICLASS_xt_iclass_xsr_ddr,
  ICLASS_xt_iclass_lddr32_p,
  ICLASS_xt_iclass_sddr32_p,
  ICLASS_xt_iclass_rfdo,
  ICLASS_xt_iclass_rfdd,
  ICLASS_xt_iclass_wsr_mmid,
  ICLASS_xt_iclass_bbool1,
  ICLASS_xt_iclass_bbool4,
  ICLASS_xt_iclass_bbool8,
  ICLASS_xt_iclass_bbranch,
  ICLASS_xt_iclass_bmove,
  ICLASS_xt_iclass_RSR_BR,
  ICLASS_xt_iclass_WSR_BR,
  ICLASS_xt_iclass_XSR_BR,
  ICLASS_xt_iclass_rsr_ccount,
  ICLASS_xt_iclass_wsr_ccount,
  ICLASS_xt_iclass_xsr_ccount,
  ICLASS_xt_iclass_rsr_ccompare0,
  ICLASS_xt_iclass_wsr_ccompare0,
  ICLASS_xt_iclass_xsr_ccompare0,
  ICLASS_xt_iclass_rsr_ccompare1,
  ICLASS_xt_iclass_wsr_ccompare1,
  ICLASS_xt_iclass_xsr_ccompare1,
  ICLASS_xt_iclass_idtlb,
  ICLASS_xt_iclass_rdtlb,
  ICLASS_xt_iclass_wdtlb,
  ICLASS_xt_iclass_iitlb,
  ICLASS_xt_iclass_ritlb,
  ICLASS_xt_iclass_witlb,
  ICLASS_xt_iclass_rsr_cpenable,
  ICLASS_xt_iclass_wsr_cpenable,
  ICLASS_xt_iclass_xsr_cpenable,
  ICLASS_xt_iclass_clamp,
  ICLASS_xt_iclass_minmax,
  ICLASS_xt_iclass_nsa,
  ICLASS_xt_iclass_sx,
  ICLASS_xt_iclass_l32ai,
  ICLASS_xt_iclass_s32ri,
  ICLASS_xt_iclass_s32c1i,
  ICLASS_xt_iclass_rsr_scompare1,
  ICLASS_xt_iclass_wsr_scompare1,
  ICLASS_xt_iclass_xsr_scompare1,
  ICLASS_xt_iclass_rsr_atomctl,
  ICLASS_xt_iclass_wsr_atomctl,
  ICLASS_xt_iclass_xsr_atomctl,
  ICLASS_xt_iclass_div,
  ICLASS_xt_iclass_rer,
  ICLASS_xt_iclass_wer,
  ICLASS_xt_iclass_wb15_0,
  ICLASS_xt_iclass_wb15_1,
  ICLASS_xt_iclass_wb15_2,
  ICLASS_xt_iclass_wb15_3,
  ICLASS_xt_iclass_wb15_4,
  ICLASS_rur_ae_bithead,
  ICLASS_wur_ae_bithead,
  ICLASS_rur_ae_cbegin0,
  ICLASS_wur_ae_cbegin0,
  ICLASS_rur_ae_cend0,
  ICLASS_wur_ae_cend0,
  ICLASS_ic_sext16,
  ICLASS_ic_zext16,
  ICLASS_ic_zext8,
  ICLASS_ic_clamps16,
  ICLASS_rur_fcr,
  ICLASS_wur_fcr,
  ICLASS_rur_fsr,
  ICLASS_wur_fsr,
  ICLASS_rur_expstate,
  ICLASS_wur_expstate,
  ICLASS_iclass_READ_IMPWIRE,
  ICLASS_iclass_SETB_EXPSTATE,
  ICLASS_iclass_CLRB_EXPSTATE,
  ICLASS_iclass_WRMSK_EXPSTATE,
  ICLASS_RUR_AE_OVERFLOW,
  ICLASS_WUR_AE_OVERFLOW,
  ICLASS_RUR_AE_SAR,
  ICLASS_WUR_AE_SAR,
  ICLASS_RUR_AE_BITPTR,
  ICLASS_WUR_AE_BITPTR,
  ICLASS_RUR_AE_BITSUSED,
  ICLASS_WUR_AE_BITSUSED,
  ICLASS_RUR_AE_TABLESIZE,
  ICLASS_WUR_AE_TABLESIZE,
  ICLASS_RUR_AE_FIRST_TS,
  ICLASS_WUR_AE_FIRST_TS,
  ICLASS_RUR_AE_NEXTOFFSET,
  ICLASS_WUR_AE_NEXTOFFSET,
  ICLASS_RUR_AE_SEARCHDONE,
  ICLASS_WUR_AE_SEARCHDONE,
  ICLASS_RUR_AE_CWRAP,
  ICLASS_WUR_AE_CWRAP,
  ICLASS_AE_MOVCIRCV,
  ICLASS_AE_MOVVCIRC,
  ICLASS_AE_MOVFUSIONMISCV,
  ICLASS_AE_MOVVFUSIONMISC,
  ICLASS_AE_MOVTABLEFIRSTSEARCHNEXTV,
  ICLASS_AE_MOVVTABLEFIRSTSEARCHNEXT,
  ICLASS_AE_L8X4F_I,
  ICLASS_AE_L8X4F_IP,
  ICLASS_AE_L8X4F_X,
  ICLASS_AE_L8X4F_XP,
  ICLASS_AE_L8X8_I,
  ICLASS_AE_L8X8_IP,
  ICLASS_AE_L16M_XC,
  ICLASS_AE_L16M_I,
  ICLASS_AE_L16M_IU,
  ICLASS_AE_L16M_X,
  ICLASS_AE_L16M_XU,
  ICLASS_AE_L16_XC,
  ICLASS_AE_L16_I,
  ICLASS_AE_L16_IP,
  ICLASS_AE_L16_X,
  ICLASS_AE_L16_XP,
  ICLASS_AE_L32F24_XC,
  ICLASS_AE_L32F24_I,
  ICLASS_AE_L32F24_IP,
  ICLASS_AE_L32F24_X,
  ICLASS_AE_L32F24_XP,
  ICLASS_AE_L32_XC,
  ICLASS_AE_L32_I,
  ICLASS_AE_L32_IP,
  ICLASS_AE_L32_X,
  ICLASS_AE_L32_XP,
  ICLASS_AE_L32M_XC,
  ICLASS_AE_L32M_I,
  ICLASS_AE_L32M_IU,
  ICLASS_AE_L32M_X,
  ICLASS_AE_L32M_XU,
  ICLASS_AE_L16X2M_XC,
  ICLASS_AE_L16X2M_I,
  ICLASS_AE_L16X2M_IU,
  ICLASS_AE_L16X2M_X,
  ICLASS_AE_L16X2M_XU,
  ICLASS_AE_L32X2F24_XC,
  ICLASS_AE_L32X2F24_I,
  ICLASS_AE_L32X2F24_IP,
  ICLASS_AE_L32X2F24_RIP,
  ICLASS_AE_L32X2F24_RIC,
  ICLASS_AE_L32X2F24_X,
  ICLASS_AE_L32X2F24_XP,
  ICLASS_AE_L32X2_XC,
  ICLASS_AE_L32X2_I,
  ICLASS_AE_L32X2_IP,
  ICLASS_AE_L32X2_RIP,
  ICLASS_AE_L32X2_RIC,
  ICLASS_AE_L32X2_X,
  ICLASS_AE_L32X2_XP,
  ICLASS_AE_L16X4_XC,
  ICLASS_AE_L16X4_I,
  ICLASS_AE_L16X4_IP,
  ICLASS_AE_L16X4_RIP,
  ICLASS_AE_L16X4_RIC,
  ICLASS_AE_L16X4_X,
  ICLASS_AE_L16X4_XP,
  ICLASS_AE_L64_XC,
  ICLASS_AE_L64_I,
  ICLASS_AE_L64_IP,
  ICLASS_AE_L64_X,
  ICLASS_AE_L64_XP,
  ICLASS_AE_S8X4F_I,
  ICLASS_AE_S8X4F_IP,
  ICLASS_AE_S16X2M_XC,
  ICLASS_AE_S16X2M_I,
  ICLASS_AE_S16X2M_IU,
  ICLASS_AE_S16X2M_X,
  ICLASS_AE_S16X2M_XU,
  ICLASS_AE_S32X2F24_XC,
  ICLASS_AE_S32X2F24_I,
  ICLASS_AE_S32X2F24_IP,
  ICLASS_AE_S32X2F24_RIP,
  ICLASS_AE_S32X2F24_RIC,
  ICLASS_AE_S32X2F24_X,
  ICLASS_AE_S32X2F24_XP,
  ICLASS_AE_S32X2_XC,
  ICLASS_AE_S32X2_I,
  ICLASS_AE_S32X2_IP,
  ICLASS_AE_S32X2_RIP,
  ICLASS_AE_S32X2_RIC,
  ICLASS_AE_S32X2_X,
  ICLASS_AE_S32X2_XP,
  ICLASS_AE_S16X4_XC,
  ICLASS_AE_S16X4_I,
  ICLASS_AE_S16X4_IP,
  ICLASS_AE_S16X4_RIP,
  ICLASS_AE_S16X4_RIC,
  ICLASS_AE_S16X4_X,
  ICLASS_AE_S16X4_XP,
  ICLASS_AE_S16X4RNG_I,
  ICLASS_AE_S16X4RNG_IP,
  ICLASS_AE_S16X4RNG_X,
  ICLASS_AE_S16X4RNG_XP,
  ICLASS_AE_S16M_L_XC,
  ICLASS_AE_S16M_L_I,
  ICLASS_AE_S16M_L_IU,
  ICLASS_AE_S16M_L_X,
  ICLASS_AE_S16M_L_XU,
  ICLASS_AE_S32F24_L_XC,
  ICLASS_AE_S32F24_L_I,
  ICLASS_AE_S32F24_L_IP,
  ICLASS_AE_S32F24_L_X,
  ICLASS_AE_S32F24_L_XP,
  ICLASS_AE_S32_L_XC,
  ICLASS_AE_S32_L_I,
  ICLASS_AE_S32_L_IP,
  ICLASS_AE_S32_L_X,
  ICLASS_AE_S32_L_XP,
  ICLASS_AE_S16_0_XC,
  ICLASS_AE_S16_0_I,
  ICLASS_AE_S16_0_IP,
  ICLASS_AE_S16_0_X,
  ICLASS_AE_S16_0_XP,
  ICLASS_AE_S64_XC,
  ICLASS_AE_S64_I,
  ICLASS_AE_S64_IP,
  ICLASS_AE_S64_X,
  ICLASS_AE_S64_XP,
  ICLASS_AE_S32M_XC,
  ICLASS_AE_S32M_I,
  ICLASS_AE_S32M_IU,
  ICLASS_AE_S32M_X,
  ICLASS_AE_S32M_XU,
  ICLASS_AE_ZALIGN64,
  ICLASS_AE_LALIGN64_I,
  ICLASS_AE_SALIGN64_I,
  ICLASS_AE_MOVALIGN,
  ICLASS_AE_LA64_PP,
  ICLASS_AE_LA24POS_PC,
  ICLASS_AE_LA24X2POS_PC,
  ICLASS_AE_LA32X2POS_PC,
  ICLASS_AE_LA16X4POS_PC,
  ICLASS_AE_LA24NEG_PC,
  ICLASS_AE_LA24X2NEG_PC,
  ICLASS_AE_LA32X2NEG_PC,
  ICLASS_AE_LA16X4NEG_PC,
  ICLASS_AE_SA64POS_FP,
  ICLASS_AE_SA64NEG_FP,
  ICLASS_AE_LA32X2_IC,
  ICLASS_AE_LA32X2_IP,
  ICLASS_AE_LA32X2_RIP,
  ICLASS_AE_LA32X2_RIC,
  ICLASS_AE_LA16X4_IC,
  ICLASS_AE_LA16X4_IP,
  ICLASS_AE_LA16X4_RIP,
  ICLASS_AE_LA16X4_RIC,
  ICLASS_AE_LA32X2F24_IC,
  ICLASS_AE_LA32X2F24_IP,
  ICLASS_AE_LA32X2F24_RIP,
  ICLASS_AE_LA32X2F24_RIC,
  ICLASS_AE_LA24_IC,
  ICLASS_AE_LA24_IP,
  ICLASS_AE_LA24_RIP,
  ICLASS_AE_LA24_RIC,
  ICLASS_AE_LA24X2_IC,
  ICLASS_AE_LA24X2_IP,
  ICLASS_AE_LA24X2_RIP,
  ICLASS_AE_LA24X2_RIC,
  ICLASS_AE_SA32X2_IC,
  ICLASS_AE_SA32X2_IP,
  ICLASS_AE_SA32X2_RIP,
  ICLASS_AE_SA32X2_RIC,
  ICLASS_AE_SA16X4_IC,
  ICLASS_AE_SA16X4_IP,
  ICLASS_AE_SA16X4_RIP,
  ICLASS_AE_SA16X4_RIC,
  ICLASS_AE_SA32X2F24_IC,
  ICLASS_AE_SA32X2F24_IP,
  ICLASS_AE_SA32X2F24_RIP,
  ICLASS_AE_SA32X2F24_RIC,
  ICLASS_AE_SA24_L_IC,
  ICLASS_AE_SA24_L_IP,
  ICLASS_AE_SA24_L_RIP,
  ICLASS_AE_SA24_L_RIC,
  ICLASS_AE_SA24X2_IC,
  ICLASS_AE_SA24X2_IP,
  ICLASS_AE_SA24X2_RIP,
  ICLASS_AE_SA24X2_RIC,
  ICLASS_AE_S32RA64S_I,
  ICLASS_AE_S32RA64S_IP,
  ICLASS_AE_S32RA64S_X,
  ICLASS_AE_S32RA64S_XP,
  ICLASS_AE_S32RA64S_XC,
  ICLASS_AE_S24RA64S_I,
  ICLASS_AE_S24RA64S_IP,
  ICLASS_AE_S24RA64S_X,
  ICLASS_AE_S24RA64S_XP,
  ICLASS_AE_S24RA64S_XC,
  ICLASS_AE_S32X2RA64S_IP,
  ICLASS_AE_S24X2RA64S_IP,
  ICLASS_AE_ADDBRBA32,
  ICLASS_AE_SEL16I,
  ICLASS_AE_SHORTSWAP,
  ICLASS_AE_INTSWAP,
  ICLASS_AE_MOVT16X4,
  ICLASS_AE_MOVF16X4,
  ICLASS_AE_MOVT32X2,
  ICLASS_AE_MOVF32X2,
  ICLASS_AE_MOVDA32X2,
  ICLASS_AE_MOVDA32,
  ICLASS_AE_MOVDA16X2,
  ICLASS_AE_MOVDA16,
  ICLASS_AE_MOVI,
  ICLASS_AE_TRUNCP24A32X2,
  ICLASS_AE_SAT16X4,
  ICLASS_AE_CVT32X2F16_32,
  ICLASS_AE_CVT32X2F16_10,
  ICLASS_AE_SEXT32X2D16_32,
  ICLASS_AE_SEXT32X2D16_10,
  ICLASS_AE_CVTA32F24S_L,
  ICLASS_AE_CVTA32F24S_H,
  ICLASS_AE_CVTP24A16X2_LL,
  ICLASS_AE_CVTP24A16X2_LH,
  ICLASS_AE_CVTP24A16X2_HL,
  ICLASS_AE_CVTP24A16X2_HH,
  ICLASS_AE_TRUNCP24Q48X2,
  ICLASS_AE_TRUNCA32X2F64S,
  ICLASS_AE_TRUNCI32X2F64S,
  ICLASS_AE_TRUNCI16X4F32S,
  ICLASS_AE_TRUNCA32F64S_L,
  ICLASS_AE_TRUNCI32F64S_L,
  ICLASS_AE_TRUNCP16,
  ICLASS_AE_ROUND32X2F64SSYM,
  ICLASS_AE_ROUND32X2F64SASYM,
  ICLASS_AE_ROUND32X2F48SSYM,
  ICLASS_AE_ROUND32X2F48SASYM,
  ICLASS_AE_ROUND16X4F32SSYM,
  ICLASS_AE_ROUND16X4F32SASYM,
  ICLASS_AE_ROUND24X2F48SSYM,
  ICLASS_AE_ROUND24X2F48SASYM,
  ICLASS_AE_ROUNDSP16Q48X2SYM,
  ICLASS_AE_ROUNDSP16Q48X2ASYM,
  ICLASS_AE_MINABS32S,
  ICLASS_AE_MAXABS32S,
  ICLASS_AE_ROUNDSP16F24SYM,
  ICLASS_AE_ROUNDSP16F24ASYM,
  ICLASS_AE_MOV,
  ICLASS_AE_MOVT64,
  ICLASS_AE_MOVF64,
  ICLASS_AE_CVTQ56A32S,
  ICLASS_AE_CVT48A32,
  ICLASS_AE_CVT64A32,
  ICLASS_AE_CVTQ56P32S_L,
  ICLASS_AE_CVTQ56P32S_H,
  ICLASS_AE_CVT64F32_H,
  ICLASS_AE_SAT48S,
  ICLASS_AE_SATQ56S,
  ICLASS_AE_SAT24S,
  ICLASS_AE_TRUNCQ32,
  ICLASS_AE_MINABS64S,
  ICLASS_AE_MAXABS64S,
  ICLASS_AE_ROUNDSQ32F48SYM,
  ICLASS_AE_ROUNDSQ32F48ASYM,
  ICLASS_AE_TRUNCA32Q48,
  ICLASS_AE_MOVAD32_L,
  ICLASS_AE_MOVAD32_H,
  ICLASS_AE_MOVAD16_3,
  ICLASS_AE_MOVAD16_2,
  ICLASS_AE_MOVAD16_1,
  ICLASS_AE_MOVAD16_0,
  ICLASS_AE_SRA64_32,
  ICLASS_AE_PKSR32_0,
  ICLASS_AE_PKSR24_0,
  ICLASS_AE_TRUNCA16P24S_L,
  ICLASS_AE_TRUNCA16P24S_H,
  ICLASS_AE_ADD32,
  ICLASS_AE_SUB32,
  ICLASS_AE_ADDSUB32,
  ICLASS_AE_SUBADD32,
  ICLASS_AE_ADD16,
  ICLASS_AE_SUB16,
  ICLASS_AE_ADD32_HL_LH,
  ICLASS_AE_NEG32,
  ICLASS_AE_ABS32,
  ICLASS_AE_ADD24S,
  ICLASS_AE_SUB24S,
  ICLASS_AE_ADD32S,
  ICLASS_AE_SUB32S,
  ICLASS_AE_ADDSUB32S,
  ICLASS_AE_SUBADD32S,
  ICLASS_AE_ADD16S,
  ICLASS_AE_SUB16S,
  ICLASS_AE_NEG24S,
  ICLASS_AE_ABS24S,
  ICLASS_AE_NEG32S,
  ICLASS_AE_ABS32S,
  ICLASS_AE_NEG16S,
  ICLASS_AE_ABS16S,
  ICLASS_AE_CONJ16S,
  ICLASS_AE_MULC16JS_H,
  ICLASS_AE_MULC16JS_L,
  ICLASS_AE_MULAC16JS_H,
  ICLASS_AE_MULAC16JS_L,
  ICLASS_AE_LT16,
  ICLASS_AE_LE16,
  ICLASS_AE_EQ16,
  ICLASS_AE_LT32,
  ICLASS_AE_LE32,
  ICLASS_AE_EQ32,
  ICLASS_AE_MIN32,
  ICLASS_AE_MAX32,
  ICLASS_AE_ADD64,
  ICLASS_AE_SUB64,
  ICLASS_AE_NEG64,
  ICLASS_AE_ABS64,
  ICLASS_AE_ADDSQ56S,
  ICLASS_AE_SUBSQ56S,
  ICLASS_AE_ADD64S,
  ICLASS_AE_SUB64S,
  ICLASS_AE_NEGSQ56S,
  ICLASS_AE_ABSSQ56S,
  ICLASS_AE_NEG64S,
  ICLASS_AE_ABS64S,
  ICLASS_AE_AND,
  ICLASS_AE_NAND,
  ICLASS_AE_OR,
  ICLASS_AE_XOR,
  ICLASS_AE_SLAI24,
  ICLASS_AE_SRLI24,
  ICLASS_AE_SRAI24,
  ICLASS_AE_SLAS24,
  ICLASS_AE_SRLS24,
  ICLASS_AE_SRAS24,
  ICLASS_AE_SRAI16,
  ICLASS_AE_SRAI16R,
  ICLASS_AE_SLAI32,
  ICLASS_AE_SRLI32,
  ICLASS_AE_SRAI32,
  ICLASS_AE_SRAI32R,
  ICLASS_AE_SLAS32,
  ICLASS_AE_SRLS32,
  ICLASS_AE_SRAS32,
  ICLASS_AE_SLAA32,
  ICLASS_AE_SRLA32,
  ICLASS_AE_SRAA32,
  ICLASS_AE_SLAI16S,
  ICLASS_AE_SLAA16S,
  ICLASS_AE_SRAA16S,
  ICLASS_AE_SRAA16RS,
  ICLASS_AE_SLAI24S,
  ICLASS_AE_SLAS24S,
  ICLASS_AE_SLAI32S,
  ICLASS_AE_SLAS32S,
  ICLASS_AE_SLAA32S,
  ICLASS_AE_SRAA32S,
  ICLASS_AE_SRAA32RS,
  ICLASS_AE_SLASQ56,
  ICLASS_AE_SRLSQ56,
  ICLASS_AE_SRASQ56,
  ICLASS_AE_SLAAQ56,
  ICLASS_AE_SRLAQ56,
  ICLASS_AE_SRAAQ56,
  ICLASS_AE_SLAI64,
  ICLASS_AE_SRLI64,
  ICLASS_AE_SRAI64,
  ICLASS_AE_SLAS64,
  ICLASS_AE_SRLS64,
  ICLASS_AE_SRAS64,
  ICLASS_AE_SLAA64,
  ICLASS_AE_SRLA64,
  ICLASS_AE_SRAA64,
  ICLASS_AE_SLAISQ56S,
  ICLASS_AE_SLASSQ56S,
  ICLASS_AE_SLAASQ56S,
  ICLASS_AE_SLAI64S,
  ICLASS_AE_SLAS64S,
  ICLASS_AE_SLAA64S,
  ICLASS_AE_LT64,
  ICLASS_AE_LE64,
  ICLASS_AE_EQ64,
  ICLASS_AE_MAX64,
  ICLASS_AE_MIN64,
  ICLASS_AE_NSA64,
  ICLASS_AE_NSAZ16_0,
  ICLASS_AE_NSAZ32_L,
  ICLASS_AE_MULS32F48P16S_LL,
  ICLASS_AE_MULF32S_LL,
  ICLASS_AE_MUL32_LL,
  ICLASS_AE_MULF32R_LL,
  ICLASS_AE_MULS32F48P16S_LH,
  ICLASS_AE_MULF32S_LH,
  ICLASS_AE_MUL32_LH,
  ICLASS_AE_MULF32R_LH,
  ICLASS_AE_MULS32F48P16S_HH,
  ICLASS_AE_MULF32S_HH,
  ICLASS_AE_MUL32_HH,
  ICLASS_AE_MULF32R_HH,
  ICLASS_AE_MULAS32F48P16S_LL,
  ICLASS_AE_MULAF32S_LL,
  ICLASS_AE_MULA32_LL,
  ICLASS_AE_MULAF32R_LL,
  ICLASS_AE_MULAS32F48P16S_LH,
  ICLASS_AE_MULAF32S_LH,
  ICLASS_AE_MULA32_LH,
  ICLASS_AE_MULAF32R_LH,
  ICLASS_AE_MULAS32F48P16S_HH,
  ICLASS_AE_MULAF32S_HH,
  ICLASS_AE_MULA32_HH,
  ICLASS_AE_MULAF32R_HH,
  ICLASS_AE_MULSS32F48P16S_LL,
  ICLASS_AE_MULSF32S_LL,
  ICLASS_AE_MULS32_LL,
  ICLASS_AE_MULSF32R_LL,
  ICLASS_AE_MULSS32F48P16S_LH,
  ICLASS_AE_MULSF32S_LH,
  ICLASS_AE_MULS32_LH,
  ICLASS_AE_MULSF32R_LH,
  ICLASS_AE_MULSS32F48P16S_HH,
  ICLASS_AE_MULSF32S_HH,
  ICLASS_AE_MULS32_HH,
  ICLASS_AE_MULSF32R_HH,
  ICLASS_AE_MUL32U_LL,
  ICLASS_AE_MULA32U_LL,
  ICLASS_AE_MULS32U_LL,
  ICLASS_AE_MULF16SS_33,
  ICLASS_AE_MULF16SS_22,
  ICLASS_AE_MULF16SS_32,
  ICLASS_AE_MULF16SS_21,
  ICLASS_AE_MULF16SS_31,
  ICLASS_AE_MULF16SS_30,
  ICLASS_AE_MULF16SS_10,
  ICLASS_AE_MULF16SS_20,
  ICLASS_AE_MULF16SS_11,
  ICLASS_AE_MULF16SS_00,
  ICLASS_AE_MULSF16SS_33,
  ICLASS_AE_MULSF16SS_22,
  ICLASS_AE_MULSF16SS_32,
  ICLASS_AE_MULSF16SS_21,
  ICLASS_AE_MULSF16SS_31,
  ICLASS_AE_MULSF16SS_30,
  ICLASS_AE_MULSF16SS_10,
  ICLASS_AE_MULSF16SS_20,
  ICLASS_AE_MULSF16SS_11,
  ICLASS_AE_MULSF16SS_00,
  ICLASS_AE_MULAF16SS_33,
  ICLASS_AE_MULAF16SS_22,
  ICLASS_AE_MULAF16SS_32,
  ICLASS_AE_MULAF16SS_21,
  ICLASS_AE_MULAF16SS_31,
  ICLASS_AE_MULAF16SS_30,
  ICLASS_AE_MULAF16SS_10,
  ICLASS_AE_MULAF16SS_20,
  ICLASS_AE_MULAF16SS_11,
  ICLASS_AE_MULAF16SS_00,
  ICLASS_AE_MULAAFD16SS_33_22,
  ICLASS_AE_MULAAFD16SS_13_02,
  ICLASS_AE_MULAAFD16SS_11_00,
  ICLASS_AE_MULSSFD16SS_33_22,
  ICLASS_AE_MULSSFD16SS_13_02,
  ICLASS_AE_MULSSFD16SS_11_00,
  ICLASS_AE_MULZAAFD16SS_33_22,
  ICLASS_AE_MULZAAFD16SS_13_02,
  ICLASS_AE_MULZAAFD16SS_11_00,
  ICLASS_AE_MULZSSFD16SS_33_22,
  ICLASS_AE_MULZSSFD16SS_13_02,
  ICLASS_AE_MULZSSFD16SS_11_00,
  ICLASS_AE_MULF48Q32SP16S_L,
  ICLASS_AE_MULF48Q32SP16U_L,
  ICLASS_AE_MULQ32SP16S_L,
  ICLASS_AE_MULQ32SP16U_L,
  ICLASS_AE_MULAF48Q32SP16S_L,
  ICLASS_AE_MULAF48Q32SP16U_L,
  ICLASS_AE_MULAQ32SP16S_L,
  ICLASS_AE_MULAQ32SP16U_L,
  ICLASS_AE_MULSF48Q32SP16S_L,
  ICLASS_AE_MULSF48Q32SP16U_L,
  ICLASS_AE_MULSQ32SP16S_L,
  ICLASS_AE_MULSQ32SP16U_L,
  ICLASS_AE_MULFP24X2RA,
  ICLASS_AE_MULFP24X2R,
  ICLASS_AE_MULP24X2,
  ICLASS_AE_MULAFP24X2RA,
  ICLASS_AE_MULAFP24X2R,
  ICLASS_AE_MULAP24X2,
  ICLASS_AE_MULSFP24X2RA,
  ICLASS_AE_MULSFP24X2R,
  ICLASS_AE_MULSP24X2,
  ICLASS_AE_MULZAAFD24_HH_LL,
  ICLASS_AE_MULZAAD24_HH_LL,
  ICLASS_AE_MULZAAFD24_HL_LH,
  ICLASS_AE_MULZAAD24_HL_LH,
  ICLASS_AE_MULZASFD24_HH_LL,
  ICLASS_AE_MULZASD24_HH_LL,
  ICLASS_AE_MULZASFD24_HL_LH,
  ICLASS_AE_MULZASD24_HL_LH,
  ICLASS_AE_MULZSAFD24_HH_LL,
  ICLASS_AE_MULZSAD24_HH_LL,
  ICLASS_AE_MULZSSFD24_HH_LL,
  ICLASS_AE_MULZSSD24_HH_LL,
  ICLASS_AE_MULZSSFD24_HL_LH,
  ICLASS_AE_MULZSSD24_HL_LH,
  ICLASS_AE_MULAAFD24_HH_LL,
  ICLASS_AE_MULAAD24_HH_LL,
  ICLASS_AE_MULAAFD24_HL_LH,
  ICLASS_AE_MULAAD24_HL_LH,
  ICLASS_AE_MULASFD24_HH_LL,
  ICLASS_AE_MULASD24_HH_LL,
  ICLASS_AE_MULASFD24_HL_LH,
  ICLASS_AE_MULASD24_HL_LH,
  ICLASS_AE_MULSAFD24_HH_LL,
  ICLASS_AE_MULSAD24_HH_LL,
  ICLASS_AE_MULSSFD24_HH_LL,
  ICLASS_AE_MULSSD24_HH_LL,
  ICLASS_AE_MULSSFD24_HL_LH,
  ICLASS_AE_MULSSD24_HL_LH,
  ICLASS_AE_MULF32X16_L0,
  ICLASS_AE_MUL32X16_L0,
  ICLASS_AE_MULF32X16_L1,
  ICLASS_AE_MUL32X16_L1,
  ICLASS_AE_MULF32X16_L2,
  ICLASS_AE_MUL32X16_L2,
  ICLASS_AE_MULF32X16_L3,
  ICLASS_AE_MUL32X16_L3,
  ICLASS_AE_MULF32X16_H0,
  ICLASS_AE_MUL32X16_H0,
  ICLASS_AE_MULF32X16_H1,
  ICLASS_AE_MUL32X16_H1,
  ICLASS_AE_MULF32X16_H2,
  ICLASS_AE_MUL32X16_H2,
  ICLASS_AE_MULF32X16_H3,
  ICLASS_AE_MUL32X16_H3,
  ICLASS_AE_MULAF32X16_L0,
  ICLASS_AE_MULA32X16_L0,
  ICLASS_AE_MULAF32X16_L1,
  ICLASS_AE_MULA32X16_L1,
  ICLASS_AE_MULAF32X16_L2,
  ICLASS_AE_MULA32X16_L2,
  ICLASS_AE_MULAF32X16_L3,
  ICLASS_AE_MULA32X16_L3,
  ICLASS_AE_MULAF32X16_H0,
  ICLASS_AE_MULA32X16_H0,
  ICLASS_AE_MULAF32X16_H1,
  ICLASS_AE_MULA32X16_H1,
  ICLASS_AE_MULAF32X16_H2,
  ICLASS_AE_MULA32X16_H2,
  ICLASS_AE_MULAF32X16_H3,
  ICLASS_AE_MULA32X16_H3,
  ICLASS_AE_MULSF32X16_L0,
  ICLASS_AE_MULS32X16_L0,
  ICLASS_AE_MULSF32X16_L1,
  ICLASS_AE_MULS32X16_L1,
  ICLASS_AE_MULSF32X16_L2,
  ICLASS_AE_MULS32X16_L2,
  ICLASS_AE_MULSF32X16_L3,
  ICLASS_AE_MULS32X16_L3,
  ICLASS_AE_MULSF32X16_H0,
  ICLASS_AE_MULS32X16_H0,
  ICLASS_AE_MULSF32X16_H1,
  ICLASS_AE_MULS32X16_H1,
  ICLASS_AE_MULSF32X16_H2,
  ICLASS_AE_MULS32X16_H2,
  ICLASS_AE_MULSF32X16_H3,
  ICLASS_AE_MULS32X16_H3,
  ICLASS_AE_MULAAFD32X16_H3_L2,
  ICLASS_AE_MULAAD32X16_H3_L2,
  ICLASS_AE_MULAAFD32X16_H1_L0,
  ICLASS_AE_MULAAD32X16_H1_L0,
  ICLASS_AE_MULASFD32X16_H3_L2,
  ICLASS_AE_MULASD32X16_H3_L2,
  ICLASS_AE_MULASFD32X16_H1_L0,
  ICLASS_AE_MULASD32X16_H1_L0,
  ICLASS_AE_MULSAFD32X16_H3_L2,
  ICLASS_AE_MULSAD32X16_H3_L2,
  ICLASS_AE_MULSAFD32X16_H1_L0,
  ICLASS_AE_MULSAD32X16_H1_L0,
  ICLASS_AE_MULSSFD32X16_H3_L2,
  ICLASS_AE_MULSSD32X16_H3_L2,
  ICLASS_AE_MULSSFD32X16_H1_L0,
  ICLASS_AE_MULSSD32X16_H1_L0,
  ICLASS_AE_MULZAAFD32X16_H3_L2,
  ICLASS_AE_MULZAAD32X16_H3_L2,
  ICLASS_AE_MULZAAFD32X16_H1_L0,
  ICLASS_AE_MULZAAD32X16_H1_L0,
  ICLASS_AE_MULZASFD32X16_H3_L2,
  ICLASS_AE_MULZASD32X16_H3_L2,
  ICLASS_AE_MULZASFD32X16_H1_L0,
  ICLASS_AE_MULZASD32X16_H1_L0,
  ICLASS_AE_MULZSAFD32X16_H3_L2,
  ICLASS_AE_MULZSAD32X16_H3_L2,
  ICLASS_AE_MULZSAFD32X16_H1_L0,
  ICLASS_AE_MULZSAD32X16_H1_L0,
  ICLASS_AE_MULZSSFD32X16_H3_L2,
  ICLASS_AE_MULZSSD32X16_H3_L2,
  ICLASS_AE_MULZSSFD32X16_H1_L0,
  ICLASS_AE_MULZSSD32X16_H1_L0,
  ICLASS_AE_MULZAAFD32X16_H2_L3,
  ICLASS_AE_MULZAAFD32X16_H0_L1,
  ICLASS_AE_MULAAFD32X16_H2_L3,
  ICLASS_AE_MULAAFD32X16_H0_L1,
  ICLASS_AE_MULZAAD32X16_H2_L3,
  ICLASS_AE_MULZAAD32X16_H0_L1,
  ICLASS_AE_MULAAD32X16_H2_L3,
  ICLASS_AE_MULAAD32X16_H0_L1,
  ICLASS_AE_MULP32X16X2_H,
  ICLASS_AE_MULFP32X16X2RS_H,
  ICLASS_AE_MULFP32X16X2RAS_H,
  ICLASS_AE_MULP32X16X2_L,
  ICLASS_AE_MULFP32X16X2RS_L,
  ICLASS_AE_MULFP32X16X2RAS_L,
  ICLASS_AE_MULAP32X16X2_H,
  ICLASS_AE_MULAFP32X16X2RS_H,
  ICLASS_AE_MULAFP32X16X2RAS_H,
  ICLASS_AE_MULAP32X16X2_L,
  ICLASS_AE_MULAFP32X16X2RS_L,
  ICLASS_AE_MULAFP32X16X2RAS_L,
  ICLASS_AE_MULSP32X16X2_H,
  ICLASS_AE_MULSFP32X16X2RS_H,
  ICLASS_AE_MULSFP32X16X2RAS_H,
  ICLASS_AE_MULSP32X16X2_L,
  ICLASS_AE_MULSFP32X16X2RS_L,
  ICLASS_AE_MULSFP32X16X2RAS_L,
  ICLASS_AE_MULFCR32X16RAS_L,
  ICLASS_AE_MULFCR32X16RAS_H,
  ICLASS_AE_MULFCI32X16RAS_L,
  ICLASS_AE_MULFCI32X16RAS_H,
  ICLASS_AE_MULAFCR32X16RAS_L,
  ICLASS_AE_MULAFCR32X16RAS_H,
  ICLASS_AE_MULAFCI32X16RAS_L,
  ICLASS_AE_MULAFCI32X16RAS_H,
  ICLASS_AE_MULP32X2_H,
  ICLASS_AE_MULAP32X2_H,
  ICLASS_AE_MULSP32X2_H,
  ICLASS_AE_MULP32X2_L,
  ICLASS_AE_MULAP32X2_L,
  ICLASS_AE_MULSP32X2_L,
  ICLASS_AE_MULFP32X2RS_H,
  ICLASS_AE_MULFP32X2RAS_H,
  ICLASS_AE_MULAFP32X2RS_H,
  ICLASS_AE_MULAFP32X2RAS_H,
  ICLASS_AE_MULSFP32X2RS_H,
  ICLASS_AE_MULSFP32X2RAS_H,
  ICLASS_AE_MULFP32X2RS_L,
  ICLASS_AE_MULFP32X2RAS_L,
  ICLASS_AE_MULAFP32X2RS_L,
  ICLASS_AE_MULAFP32X2RAS_L,
  ICLASS_AE_MULSFP32X2RS_L,
  ICLASS_AE_MULSFP32X2RAS_L,
  ICLASS_AE_MULFP16X4S_H,
  ICLASS_AE_MULFP16X4RAS_H,
  ICLASS_AE_MULFP16X4S_L,
  ICLASS_AE_MULFP16X4RAS_L,
  ICLASS_AE_MULCR24,
  ICLASS_AE_MULFCR24RA,
  ICLASS_AE_MULCR32X16_L,
  ICLASS_AE_MULCR32X16_H,
  ICLASS_AE_MULCI24,
  ICLASS_AE_MULFCI24RA,
  ICLASS_AE_MULCI32X16_L,
  ICLASS_AE_MULCI32X16_H,
  ICLASS_AE_MULACR24,
  ICLASS_AE_MULAFCR24RA,
  ICLASS_AE_MULACR32X16_L,
  ICLASS_AE_MULACR32X16_H,
  ICLASS_AE_MULACI24,
  ICLASS_AE_MULAFCI24RA,
  ICLASS_AE_MULACI32X16_L,
  ICLASS_AE_MULACI32X16_H,
  ICLASS_AE_MULF16X4SS_H,
  ICLASS_AE_MULAF16X4SS_H,
  ICLASS_AE_MULSF16X4SS_H,
  ICLASS_AE_MULF16X4SS_L,
  ICLASS_AE_MULAF16X4SS_L,
  ICLASS_AE_MULSF16X4SS_L,
  ICLASS_AE_MULFD24X2_FIR_H_H,
  ICLASS_AE_MULFD24X2_FIR_H_L,
  ICLASS_AE_MULFD32X16X2_FIR_HH_H,
  ICLASS_AE_MULFD32X16X2_FIR_HH_L,
  ICLASS_AE_MULFD32X16X2_FIR_HL_H,
  ICLASS_AE_MULFD32X16X2_FIR_HL_L,
  ICLASS_AE_MULAFD24X2_FIR_H_H,
  ICLASS_AE_MULAFD24X2_FIR_H_L,
  ICLASS_AE_MULAFD32X16X2_FIR_HH_H,
  ICLASS_AE_MULAFD32X16X2_FIR_HH_L,
  ICLASS_AE_MULAFD32X16X2_FIR_HL_H,
  ICLASS_AE_MULAFD32X16X2_FIR_HL_L,
  ICLASS_AE_MUL16X4_H,
  ICLASS_AE_MULA16X4_H,
  ICLASS_AE_MULS16X4_H,
  ICLASS_AE_MUL16X4_L,
  ICLASS_AE_MULA16X4_L,
  ICLASS_AE_MULS16X4_L,
  ICLASS_AE_MULC16S_H,
  ICLASS_AE_MULC16S_L,
  ICLASS_AE_MULAC16S_H,
  ICLASS_AE_MULAC16S_L,
  ICLASS_AE_MULFC16RAS_H,
  ICLASS_AE_MULFC16RAS_L,
  ICLASS_AE_MULAFC16RAS_H,
  ICLASS_AE_MULAFC16RAS_L,
  ICLASS_AE_MULZAAAAQ16,
  ICLASS_AE_MULAAAAQ16,
  ICLASS_AE_MUL16JS,
  ICLASS_AE_CALCRNG3,
  ICLASS_AE_ADDANDSUBRNG16RAS_S1,
  ICLASS_AE_ADDANDSUBRNG16RAS_S2,
  ICLASS_AE_MAXABS16S,
  ICLASS_MULL,
  ICLASS_MULUH,
  ICLASS_MULSH,
  ICLASS_AE_DIV64D32_H,
  ICLASS_AE_DIV64D32_L,
  ICLASS_AE_SHA32,
  ICLASS_AE_VLDL32T,
  ICLASS_AE_VLDL16T,
  ICLASS_AE_VLDL16C,
  ICLASS_AE_VLDL16C_IP,
  ICLASS_AE_VLDL16C_IC,
  ICLASS_AE_VLDSHT,
  ICLASS_AE_LB,
  ICLASS_AE_LBI,
  ICLASS_AE_LBK,
  ICLASS_AE_LBKI,
  ICLASS_AE_LBS,
  ICLASS_AE_LBSI,
  ICLASS_AE_DB,
  ICLASS_AE_DBI,
  ICLASS_AE_DB_IC,
  ICLASS_AE_DBI_IC,
  ICLASS_AE_DB_IP,
  ICLASS_AE_DBI_IP,
  ICLASS_AE_VLEL32T,
  ICLASS_AE_VLEL16T,
  ICLASS_AE_SB,
  ICLASS_AE_SBI,
  ICLASS_AE_VLES16C,
  ICLASS_AE_SBF,
  ICLASS_AE_SB_IC,
  ICLASS_AE_SBI_IC,
  ICLASS_AE_VLES16C_IC,
  ICLASS_AE_SBF_IC,
  ICLASS_AE_SB_IP,
  ICLASS_AE_SBI_IP,
  ICLASS_AE_VLES16C_IP,
  ICLASS_AE_SBF_IP,
  ICLASS_AE_S8IP,
  ICLASS_AE_S16IP,
  ICLASS_AE_S32IP,
  ICLASS_AE_L16SI_N,
  ICLASS_AE_L16UI_N,
  ICLASS_AE_S16I_N,
  ICLASS_AE_ZEROB,
  ICLASS_AE_SEXT32,
  ICLASS_AE_S32X2_L_IP,
  ICLASS_AE_MOVFCRFSRV,
  ICLASS_AE_MOVVFCRFSR,
  ICLASS_ABS_S,
  ICLASS_NEG_S,
  ICLASS_NEG_LH_S,
  ICLASS_MOVEQZ_S,
  ICLASS_MOVNEZ_S,
  ICLASS_MOVLTZ_S,
  ICLASS_MOVGEZ_S,
  ICLASS_MOVF_S,
  ICLASS_MOVT_S,
  ICLASS_WFR,
  ICLASS_RFR,
  ICLASS_TRUNC_S,
  ICLASS_UTRUNC_S,
  ICLASS_FLOAT_S,
  ICLASS_UFLOAT_S,
  ICLASS_FICEIL_S,
  ICLASS_FIFLOOR_S,
  ICLASS_FIROUND_S,
  ICLASS_FITRUNC_S,
  ICLASS_FIRINT_S,
  ICLASS_UN_S,
  ICLASS_ULT_S,
  ICLASS_ULE_S,
  ICLASS_UEQ_S,
  ICLASS_OLT_S,
  ICLASS_OLE_S,
  ICLASS_OEQ_S,
  ICLASS_ADD_S,
  ICLASS_ADD_LLH_S,
  ICLASS_ADD_LHH_S,
  ICLASS_SUB_S,
  ICLASS_SUB_LLH_S,
  ICLASS_SUB_LHH_S,
  ICLASS_MUL_S,
  ICLASS_MUL_LLH_S,
  ICLASS_MUL_LHH_S,
  ICLASS_MADD_S,
  ICLASS_MADD_LLH_S,
  ICLASS_MADD_LHH_S,
  ICLASS_MSUB_S,
  ICLASS_MSUB_LLH_S,
  ICLASS_MSUB_LHH_S,
  ICLASS_SQRT0_S,
  ICLASS_DIV0_S,
  ICLASS_RECIP0_S,
  ICLASS_RSQRT0_S,
  ICLASS_MADDN_S,
  ICLASS_MSUBN_S,
  ICLASS_DIVN_S,
  ICLASS_CONST_S,
  ICLASS_NEXP01_S,
  ICLASS_ADDEXP_S,
  ICLASS_ADDEXPM_S,
  ICLASS_MKDADJ_S,
  ICLASS_MKSADJ_S
};


/*  Opcode encodings.  */

static void
Opcode_excw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2080;
}

static void
Opcode_rfe_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3000;
}

static void
Opcode_rfde_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3200;
}

static void
Opcode_syscall_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5000;
}

static void
Opcode_call12_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x35;
}

static void
Opcode_call8_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x25;
}

static void
Opcode_call8_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x640000;
}

static void
Opcode_call4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x15;
}

static void
Opcode_callx12_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf0;
}

static void
Opcode_callx8_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0;
}

static void
Opcode_callx8_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3bda10;
}

static void
Opcode_callx4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0;
}

static void
Opcode_entry_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36;
}

static void
Opcode_movsp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1000;
}

static void
Opcode_rotw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x408000;
}

static void
Opcode_retw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90;
}

static void
Opcode_retw_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf01d;
}

static void
Opcode_rfwo_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3400;
}

static void
Opcode_rfwu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3500;
}

static void
Opcode_l32e_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90000;
}

static void
Opcode_s32e_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x490000;
}

static void
Opcode_rsr_windowbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x34800;
}

static void
Opcode_wsr_windowbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x134800;
}

static void
Opcode_xsr_windowbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x614800;
}

static void
Opcode_rsr_windowstart_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x34900;
}

static void
Opcode_wsr_windowstart_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x134900;
}

static void
Opcode_xsr_windowstart_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x614900;
}

static void
Opcode_add_n_Slot_inst16a_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa;
}

static void
Opcode_addi_n_Slot_inst16a_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb;
}

static void
Opcode_beqz_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8c;
}

static void
Opcode_bnez_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc;
}

static void
Opcode_ill_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf06d;
}

static void
Opcode_l32i_n_Slot_inst16a_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8;
}

static void
Opcode_mov_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd;
}

static void
Opcode_mov_n_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b8a00;
}

static void
Opcode_mov_n_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x173900;
}

static void
Opcode_movi_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc;
}

static void
Opcode_nop_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf03d;
}

static void
Opcode_ret_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf00d;
}

static void
Opcode_s32i_n_Slot_inst16a_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9;
}

static void
Opcode_rur_threadptr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe30e70;
}

static void
Opcode_wur_threadptr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf3e700;
}

static void
Opcode_addi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc002;
}

static void
Opcode_addi_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200400;
}

static void
Opcode_addi_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_addmi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd002;
}

static void
Opcode_addmi_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200600;
}

static void
Opcode_addmi_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10000;
}

static void
Opcode_add_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800000;
}

static void
Opcode_add_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x504000;
}

static void
Opcode_add_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x150000;
}

static void
Opcode_addx2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x900000;
}

static void
Opcode_addx2_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x505000;
}

static void
Opcode_addx2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x151000;
}

static void
Opcode_addx4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa00000;
}

static void
Opcode_addx4_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x506000;
}

static void
Opcode_addx4_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x152000;
}

static void
Opcode_addx8_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb00000;
}

static void
Opcode_addx8_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x507000;
}

static void
Opcode_addx8_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x153000;
}

static void
Opcode_sub_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc00000;
}

static void
Opcode_sub_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x556000;
}

static void
Opcode_sub_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x15a000;
}

static void
Opcode_subx2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00000;
}

static void
Opcode_subx2_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x557000;
}

static void
Opcode_subx4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe00000;
}

static void
Opcode_subx4_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x558000;
}

static void
Opcode_subx8_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf00000;
}

static void
Opcode_subx8_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x559000;
}

static void
Opcode_and_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100000;
}

static void
Opcode_and_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x54b000;
}

static void
Opcode_or_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200000;
}

static void
Opcode_or_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x554000;
}

static void
Opcode_or_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x158000;
}

static void
Opcode_xor_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300000;
}

static void
Opcode_xor_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x55a000;
}

static void
Opcode_beqi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x26;
}

static void
Opcode_beqi_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400000;
}

static void
Opcode_bgei_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe6;
}

static void
Opcode_bgei_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400010;
}

static void
Opcode_blti_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa6;
}

static void
Opcode_blti_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400030;
}

static void
Opcode_bnei_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x66;
}

static void
Opcode_bnei_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400050;
}

static void
Opcode_bbci_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6007;
}

static void
Opcode_bbci_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200000;
}

static void
Opcode_bbsi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe007;
}

static void
Opcode_bbsi_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200200;
}

static void
Opcode_bgeui_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf6;
}

static void
Opcode_bgeui_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400020;
}

static void
Opcode_bltui_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb6;
}

static void
Opcode_bltui_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400040;
}

static void
Opcode_ball_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4007;
}

static void
Opcode_ball_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200500;
}

static void
Opcode_bany_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8007;
}

static void
Opcode_bany_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200700;
}

static void
Opcode_bbc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5007;
}

static void
Opcode_bbc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200800;
}

static void
Opcode_bbs_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd007;
}

static void
Opcode_bbs_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200a00;
}

static void
Opcode_beq_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1007;
}

static void
Opcode_beq_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200900;
}

static void
Opcode_bge_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa007;
}

static void
Opcode_bge_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200b00;
}

static void
Opcode_bgeu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb007;
}

static void
Opcode_bgeu_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200c00;
}

static void
Opcode_blt_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2007;
}

static void
Opcode_blt_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200e00;
}

static void
Opcode_bltu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3007;
}

static void
Opcode_bltu_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200d00;
}

static void
Opcode_bnall_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc007;
}

static void
Opcode_bnall_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200f00;
}

static void
Opcode_bne_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9007;
}

static void
Opcode_bne_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300000;
}

static void
Opcode_bnone_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7;
}

static void
Opcode_bnone_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300200;
}

static void
Opcode_beqz_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16;
}

static void
Opcode_beqz_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x160000;
}

static void
Opcode_bgez_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd6;
}

static void
Opcode_bgez_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x170000;
}

static void
Opcode_bltz_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x96;
}

static void
Opcode_bltz_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x180000;
}

static void
Opcode_bnez_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x56;
}

static void
Opcode_bnez_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x190000;
}

static void
Opcode_call0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5;
}

static void
Opcode_call0_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x600000;
}

static void
Opcode_callx0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0;
}

static void
Opcode_callx0_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3bda00;
}

static void
Opcode_extui_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40000;
}

static void
Opcode_extui_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x140000;
}

static void
Opcode_ill_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_j_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6;
}

static void
Opcode_j_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100000;
}

static void
Opcode_jx_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0;
}

static void
Opcode_jx_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f51f0;
}

static void
Opcode_l16ui_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1002;
}

static void
Opcode_l16ui_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300300;
}

static void
Opcode_l16si_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9002;
}

static void
Opcode_l16si_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300100;
}

static void
Opcode_l32i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2002;
}

static void
Opcode_l32i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300400;
}

static void
Opcode_l32r_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1;
}

static void
Opcode_l32r_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_l8ui_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2;
}

static void
Opcode_l8ui_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300600;
}

static void
Opcode_loop_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8076;
}

static void
Opcode_loopgtz_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa076;
}

static void
Opcode_loopnez_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9076;
}

static void
Opcode_movi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa002;
}

static void
Opcode_movi_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a0000;
}

static void
Opcode_movi_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20000;
}

static void
Opcode_moveqz_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x830000;
}

static void
Opcode_moveqz_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x550000;
}

static void
Opcode_moveqz_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x154000;
}

static void
Opcode_movgez_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb30000;
}

static void
Opcode_movgez_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x551000;
}

static void
Opcode_movgez_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x155000;
}

static void
Opcode_movltz_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa30000;
}

static void
Opcode_movltz_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x552000;
}

static void
Opcode_movltz_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x156000;
}

static void
Opcode_movnez_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x930000;
}

static void
Opcode_movnez_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x553000;
}

static void
Opcode_movnez_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x157000;
}

static void
Opcode_abs_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x600100;
}

static void
Opcode_abs_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a0005;
}

static void
Opcode_neg_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x600000;
}

static void
Opcode_neg_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a1005;
}

static void
Opcode_neg_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x175090;
}

static void
Opcode_nop_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20f0;
}

static void
Opcode_nop_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f57f0;
}

static void
Opcode_nop_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x173301;
}

static void
Opcode_nop_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb912010;
}

static void
Opcode_nop_Slot_fusion_slot40_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4080;
}

static void
Opcode_nop_Slot_fusion_slot40_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200;
}

static void
Opcode_nop_Slot_fusion_slot_fir_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7080;
}

static void
Opcode_nop_Slot_fusion_slot_fir_1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x60000;
}

static void
Opcode_ret_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80;
}

static void
Opcode_simcall_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5100;
}

static void
Opcode_s16i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5002;
}

static void
Opcode_s16i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300500;
}

static void
Opcode_s32i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6002;
}

static void
Opcode_s32i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300700;
}

static void
Opcode_s32nb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x590000;
}

static void
Opcode_s8i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4002;
}

static void
Opcode_s8i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300800;
}

static void
Opcode_ssa8b_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x403000;
}

static void
Opcode_ssa8b_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f53f0;
}

static void
Opcode_ssa8l_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x402000;
}

static void
Opcode_ssa8l_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f54f0;
}

static void
Opcode_ssl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x401000;
}

static void
Opcode_ssl_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f55f0;
}

static void
Opcode_ssl_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x173300;
}

static void
Opcode_ssr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400000;
}

static void
Opcode_ssr_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f56f0;
}

static void
Opcode_ssai_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x404000;
}

static void
Opcode_ssai_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f50f0;
}

static void
Opcode_sll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa10000;
}

static void
Opcode_sll_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f40c0;
}

static void
Opcode_sll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x176000;
}

static void
Opcode_src_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x810000;
}

static void
Opcode_src_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x555000;
}

static void
Opcode_src_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x159000;
}

static void
Opcode_sra_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb10000;
}

static void
Opcode_sra_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a2005;
}

static void
Opcode_sra_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1750a0;
}

static void
Opcode_srl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x910000;
}

static void
Opcode_srl_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a3005;
}

static void
Opcode_srl_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1750b0;
}

static void
Opcode_slli_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10000;
}

static void
Opcode_slli_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x500000;
}

static void
Opcode_slli_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x42000;
}

static void
Opcode_srai_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x210000;
}

static void
Opcode_srai_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x502000;
}

static void
Opcode_srai_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40000;
}

static void
Opcode_srli_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x410000;
}

static void
Opcode_srli_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x57b000;
}

static void
Opcode_srli_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x15b000;
}

static void
Opcode_memw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20c0;
}

static void
Opcode_extw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20d0;
}

static void
Opcode_isync_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2000;
}

static void
Opcode_dsync_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2030;
}

static void
Opcode_esync_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2020;
}

static void
Opcode_rsync_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2010;
}

static void
Opcode_rsil_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6000;
}

static void
Opcode_rsr_lend_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30100;
}

static void
Opcode_wsr_lend_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130100;
}

static void
Opcode_xsr_lend_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610100;
}

static void
Opcode_rsr_lcount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30200;
}

static void
Opcode_wsr_lcount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130200;
}

static void
Opcode_xsr_lcount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610200;
}

static void
Opcode_rsr_lbeg_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30000;
}

static void
Opcode_wsr_lbeg_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130000;
}

static void
Opcode_xsr_lbeg_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610000;
}

static void
Opcode_rsr_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30300;
}

static void
Opcode_wsr_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130300;
}

static void
Opcode_xsr_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610300;
}

static void
Opcode_rsr_memctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36100;
}

static void
Opcode_wsr_memctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x136100;
}

static void
Opcode_xsr_memctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x616100;
}

static void
Opcode_rsr_litbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30500;
}

static void
Opcode_wsr_litbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130500;
}

static void
Opcode_xsr_litbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610500;
}

static void
Opcode_rsr_configid0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b000;
}

static void
Opcode_wsr_configid0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13b000;
}

static void
Opcode_rsr_configid1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d000;
}

static void
Opcode_rsr_ps_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e600;
}

static void
Opcode_wsr_ps_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e600;
}

static void
Opcode_xsr_ps_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61e600;
}

static void
Opcode_rsr_epc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b100;
}

static void
Opcode_wsr_epc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13b100;
}

static void
Opcode_xsr_epc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61b100;
}

static void
Opcode_rsr_excsave1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d100;
}

static void
Opcode_wsr_excsave1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13d100;
}

static void
Opcode_xsr_excsave1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61d100;
}

static void
Opcode_rsr_epc2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b200;
}

static void
Opcode_wsr_epc2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13b200;
}

static void
Opcode_xsr_epc2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61b200;
}

static void
Opcode_rsr_excsave2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d200;
}

static void
Opcode_wsr_excsave2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13d200;
}

static void
Opcode_xsr_excsave2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61d200;
}

static void
Opcode_rsr_epc3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b300;
}

static void
Opcode_wsr_epc3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13b300;
}

static void
Opcode_xsr_epc3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61b300;
}

static void
Opcode_rsr_excsave3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d300;
}

static void
Opcode_wsr_excsave3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13d300;
}

static void
Opcode_xsr_excsave3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61d300;
}

static void
Opcode_rsr_epc4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b400;
}

static void
Opcode_wsr_epc4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13b400;
}

static void
Opcode_xsr_epc4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61b400;
}

static void
Opcode_rsr_excsave4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d400;
}

static void
Opcode_wsr_excsave4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13d400;
}

static void
Opcode_xsr_excsave4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61d400;
}

static void
Opcode_rsr_epc5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b500;
}

static void
Opcode_wsr_epc5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13b500;
}

static void
Opcode_xsr_epc5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61b500;
}

static void
Opcode_rsr_excsave5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d500;
}

static void
Opcode_wsr_excsave5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13d500;
}

static void
Opcode_xsr_excsave5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61d500;
}

static void
Opcode_rsr_eps2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c200;
}

static void
Opcode_wsr_eps2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13c200;
}

static void
Opcode_xsr_eps2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61c200;
}

static void
Opcode_rsr_eps3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c300;
}

static void
Opcode_wsr_eps3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13c300;
}

static void
Opcode_xsr_eps3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61c300;
}

static void
Opcode_rsr_eps4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c400;
}

static void
Opcode_wsr_eps4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13c400;
}

static void
Opcode_xsr_eps4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61c400;
}

static void
Opcode_rsr_eps5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c500;
}

static void
Opcode_wsr_eps5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13c500;
}

static void
Opcode_xsr_eps5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61c500;
}

static void
Opcode_rsr_excvaddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3ee00;
}

static void
Opcode_wsr_excvaddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13ee00;
}

static void
Opcode_xsr_excvaddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61ee00;
}

static void
Opcode_rsr_depc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c000;
}

static void
Opcode_wsr_depc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13c000;
}

static void
Opcode_xsr_depc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61c000;
}

static void
Opcode_rsr_exccause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e800;
}

static void
Opcode_wsr_exccause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e800;
}

static void
Opcode_xsr_exccause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61e800;
}

static void
Opcode_rsr_misc0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f400;
}

static void
Opcode_wsr_misc0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13f400;
}

static void
Opcode_xsr_misc0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61f400;
}

static void
Opcode_rsr_misc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f500;
}

static void
Opcode_wsr_misc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13f500;
}

static void
Opcode_xsr_misc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61f500;
}

static void
Opcode_rsr_prid_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3eb00;
}

static void
Opcode_rsr_vecbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e700;
}

static void
Opcode_wsr_vecbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e700;
}

static void
Opcode_xsr_vecbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61e700;
}

static void
Opcode_mul_aa_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x770004;
}

static void
Opcode_mul_aa_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x750004;
}

static void
Opcode_mul_aa_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x760004;
}

static void
Opcode_mul_aa_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x740004;
}

static void
Opcode_umul_aa_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x730004;
}

static void
Opcode_umul_aa_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x710004;
}

static void
Opcode_umul_aa_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x720004;
}

static void
Opcode_umul_aa_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700004;
}

static void
Opcode_mul_ad_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x370004;
}

static void
Opcode_mul_ad_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x350004;
}

static void
Opcode_mul_ad_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x360004;
}

static void
Opcode_mul_ad_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x340004;
}

static void
Opcode_mul_da_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x670004;
}

static void
Opcode_mul_da_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x650004;
}

static void
Opcode_mul_da_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x660004;
}

static void
Opcode_mul_da_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x640004;
}

static void
Opcode_mul_dd_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x270004;
}

static void
Opcode_mul_dd_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x250004;
}

static void
Opcode_mul_dd_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x260004;
}

static void
Opcode_mul_dd_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x240004;
}

static void
Opcode_mula_aa_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7b0004;
}

static void
Opcode_mula_aa_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x790004;
}

static void
Opcode_mula_aa_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7a0004;
}

static void
Opcode_mula_aa_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x780004;
}

static void
Opcode_muls_aa_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7f0004;
}

static void
Opcode_muls_aa_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7d0004;
}

static void
Opcode_muls_aa_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7e0004;
}

static void
Opcode_muls_aa_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7c0004;
}

static void
Opcode_mula_ad_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b0004;
}

static void
Opcode_mula_ad_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x390004;
}

static void
Opcode_mula_ad_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3a0004;
}

static void
Opcode_mula_ad_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x380004;
}

static void
Opcode_muls_ad_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f0004;
}

static void
Opcode_muls_ad_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d0004;
}

static void
Opcode_muls_ad_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e0004;
}

static void
Opcode_muls_ad_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c0004;
}

static void
Opcode_mula_da_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6b0004;
}

static void
Opcode_mula_da_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x690004;
}

static void
Opcode_mula_da_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a0004;
}

static void
Opcode_mula_da_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x680004;
}

static void
Opcode_muls_da_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6f0004;
}

static void
Opcode_muls_da_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6d0004;
}

static void
Opcode_muls_da_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6e0004;
}

static void
Opcode_muls_da_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6c0004;
}

static void
Opcode_mula_dd_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0004;
}

static void
Opcode_mula_dd_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x290004;
}

static void
Opcode_mula_dd_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2a0004;
}

static void
Opcode_mula_dd_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x280004;
}

static void
Opcode_muls_dd_hh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2f0004;
}

static void
Opcode_muls_dd_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d0004;
}

static void
Opcode_muls_dd_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e0004;
}

static void
Opcode_muls_dd_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2c0004;
}

static void
Opcode_mula_da_hh_lddec_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5b0004;
}

static void
Opcode_mula_da_hh_ldinc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4b0004;
}

static void
Opcode_mula_da_hl_lddec_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x590004;
}

static void
Opcode_mula_da_hl_ldinc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x490004;
}

static void
Opcode_mula_da_lh_lddec_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a0004;
}

static void
Opcode_mula_da_lh_ldinc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4a0004;
}

static void
Opcode_mula_da_ll_lddec_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x580004;
}

static void
Opcode_mula_da_ll_ldinc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x480004;
}

static void
Opcode_mula_dd_hh_lddec_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b0004;
}

static void
Opcode_mula_dd_hh_ldinc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb0004;
}

static void
Opcode_mula_dd_hl_lddec_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x190004;
}

static void
Opcode_mula_dd_hl_ldinc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90004;
}

static void
Opcode_mula_dd_lh_lddec_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a0004;
}

static void
Opcode_mula_dd_lh_ldinc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0004;
}

static void
Opcode_mula_dd_ll_lddec_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x180004;
}

static void
Opcode_mula_dd_ll_ldinc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80004;
}

static void
Opcode_lddec_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x900004;
}

static void
Opcode_ldinc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800004;
}

static void
Opcode_rsr_m0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x32000;
}

static void
Opcode_wsr_m0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x132000;
}

static void
Opcode_xsr_m0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x612000;
}

static void
Opcode_rsr_m1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x32100;
}

static void
Opcode_wsr_m1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x132100;
}

static void
Opcode_xsr_m1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x612100;
}

static void
Opcode_rsr_m2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x32200;
}

static void
Opcode_wsr_m2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x132200;
}

static void
Opcode_xsr_m2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x612200;
}

static void
Opcode_rsr_m3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x32300;
}

static void
Opcode_wsr_m3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x132300;
}

static void
Opcode_xsr_m3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x612300;
}

static void
Opcode_rsr_acclo_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x31000;
}

static void
Opcode_wsr_acclo_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x131000;
}

static void
Opcode_xsr_acclo_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x611000;
}

static void
Opcode_rsr_acchi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x31100;
}

static void
Opcode_wsr_acchi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x131100;
}

static void
Opcode_xsr_acchi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x611100;
}

static void
Opcode_rfi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3010;
}

static void
Opcode_waiti_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7000;
}

static void
Opcode_rsr_interrupt_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e200;
}

static void
Opcode_wsr_intset_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e200;
}

static void
Opcode_wsr_intclear_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e300;
}

static void
Opcode_rsr_intenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e400;
}

static void
Opcode_wsr_intenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e400;
}

static void
Opcode_xsr_intenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61e400;
}

static void
Opcode_break_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000;
}

static void
Opcode_break_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf02d;
}

static void
Opcode_rsr_dbreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x39000;
}

static void
Opcode_wsr_dbreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x139000;
}

static void
Opcode_xsr_dbreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x619000;
}

static void
Opcode_rsr_dbreakc0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3a000;
}

static void
Opcode_wsr_dbreakc0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13a000;
}

static void
Opcode_xsr_dbreakc0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61a000;
}

static void
Opcode_rsr_dbreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x39100;
}

static void
Opcode_wsr_dbreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x139100;
}

static void
Opcode_xsr_dbreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x619100;
}

static void
Opcode_rsr_dbreakc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3a100;
}

static void
Opcode_wsr_dbreakc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13a100;
}

static void
Opcode_xsr_dbreakc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61a100;
}

static void
Opcode_rsr_ibreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x38000;
}

static void
Opcode_wsr_ibreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x138000;
}

static void
Opcode_xsr_ibreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x618000;
}

static void
Opcode_rsr_ibreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x38100;
}

static void
Opcode_wsr_ibreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x138100;
}

static void
Opcode_xsr_ibreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x618100;
}

static void
Opcode_rsr_ibreakenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36000;
}

static void
Opcode_wsr_ibreakenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x136000;
}

static void
Opcode_xsr_ibreakenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x616000;
}

static void
Opcode_rsr_debugcause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e900;
}

static void
Opcode_wsr_debugcause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e900;
}

static void
Opcode_xsr_debugcause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61e900;
}

static void
Opcode_rsr_icount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3ec00;
}

static void
Opcode_wsr_icount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13ec00;
}

static void
Opcode_xsr_icount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61ec00;
}

static void
Opcode_rsr_icountlevel_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3ed00;
}

static void
Opcode_wsr_icountlevel_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13ed00;
}

static void
Opcode_xsr_icountlevel_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61ed00;
}

static void
Opcode_rsr_ddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36800;
}

static void
Opcode_wsr_ddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x136800;
}

static void
Opcode_xsr_ddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x616800;
}

static void
Opcode_lddr32_p_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70e0;
}

static void
Opcode_sddr32_p_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70f0;
}

static void
Opcode_rfdo_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf1e000;
}

static void
Opcode_rfdd_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf1e010;
}

static void
Opcode_wsr_mmid_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x135900;
}

static void
Opcode_andb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20000;
}

static void
Opcode_andbc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x120000;
}

static void
Opcode_orb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x220000;
}

static void
Opcode_orbc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x320000;
}

static void
Opcode_xorb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x420000;
}

static void
Opcode_all4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9000;
}

static void
Opcode_any4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8000;
}

static void
Opcode_all8_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb000;
}

static void
Opcode_any8_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa000;
}

static void
Opcode_bf_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x76;
}

static void
Opcode_bf_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400060;
}

static void
Opcode_bt_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1076;
}

static void
Opcode_bt_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400260;
}

static void
Opcode_movf_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc30000;
}

static void
Opcode_movf_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x55b000;
}

static void
Opcode_movt_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd30000;
}

static void
Opcode_movt_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x55c000;
}

static void
Opcode_rsr_br_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30400;
}

static void
Opcode_wsr_br_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130400;
}

static void
Opcode_xsr_br_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610400;
}

static void
Opcode_rsr_ccount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3ea00;
}

static void
Opcode_wsr_ccount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13ea00;
}

static void
Opcode_xsr_ccount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61ea00;
}

static void
Opcode_rsr_ccompare0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f000;
}

static void
Opcode_wsr_ccompare0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13f000;
}

static void
Opcode_xsr_ccompare0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61f000;
}

static void
Opcode_rsr_ccompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f100;
}

static void
Opcode_wsr_ccompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13f100;
}

static void
Opcode_xsr_ccompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61f100;
}

static void
Opcode_idtlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50c000;
}

static void
Opcode_pdtlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50d000;
}

static void
Opcode_rdtlb0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50b000;
}

static void
Opcode_rdtlb1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50f000;
}

static void
Opcode_wdtlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50e000;
}

static void
Opcode_iitlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x504000;
}

static void
Opcode_pitlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x505000;
}

static void
Opcode_ritlb0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x503000;
}

static void
Opcode_ritlb1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x507000;
}

static void
Opcode_witlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x506000;
}

static void
Opcode_rsr_cpenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e000;
}

static void
Opcode_wsr_cpenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e000;
}

static void
Opcode_xsr_cpenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61e000;
}

static void
Opcode_clamps_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x330000;
}

static void
Opcode_clamps_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x55d000;
}

static void
Opcode_max_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x530000;
}

static void
Opcode_max_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x54c000;
}

static void
Opcode_maxu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x730000;
}

static void
Opcode_maxu_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x54d000;
}

static void
Opcode_min_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x430000;
}

static void
Opcode_min_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x54e000;
}

static void
Opcode_minu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x630000;
}

static void
Opcode_minu_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x54f000;
}

static void
Opcode_nsa_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40e000;
}

static void
Opcode_nsa_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b9a00;
}

static void
Opcode_nsau_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40f000;
}

static void
Opcode_nsau_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3baa00;
}

static void
Opcode_sext_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x230000;
}

static void
Opcode_sext_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x55e000;
}

static void
Opcode_sext_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x15c000;
}

static void
Opcode_l32ai_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb002;
}

static void
Opcode_s32ri_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf002;
}

static void
Opcode_s32c1i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe002;
}

static void
Opcode_rsr_scompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30c00;
}

static void
Opcode_wsr_scompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130c00;
}

static void
Opcode_xsr_scompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610c00;
}

static void
Opcode_rsr_atomctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36300;
}

static void
Opcode_wsr_atomctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x136300;
}

static void
Opcode_xsr_atomctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x616300;
}

static void
Opcode_quos_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd20000;
}

static void
Opcode_quou_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc20000;
}

static void
Opcode_rems_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf20000;
}

static void
Opcode_remu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe20000;
}

static void
Opcode_rer_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x406000;
}

static void
Opcode_wer_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x407000;
}

static void
Opcode_beqz_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb000000;
}

static void
Opcode_bgez_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb000010;
}

static void
Opcode_bltz_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb000020;
}

static void
Opcode_bnez_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb000030;
}

static void
Opcode_beqi_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000000;
}

static void
Opcode_bgei_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5000000;
}

static void
Opcode_blti_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7000000;
}

static void
Opcode_bnei_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9800000;
}

static void
Opcode_bgeui_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5800000;
}

static void
Opcode_bltui_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7800000;
}

static void
Opcode_bbci_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_bbsi_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1000000;
}

static void
Opcode_ball_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2000000;
}

static void
Opcode_bany_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2800000;
}

static void
Opcode_bbc_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3000000;
}

static void
Opcode_bbs_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3800000;
}

static void
Opcode_beq_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4800000;
}

static void
Opcode_bgeu_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6000000;
}

static void
Opcode_bge_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6800000;
}

static void
Opcode_bltu_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8000000;
}

static void
Opcode_blt_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8800000;
}

static void
Opcode_bnall_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9000000;
}

static void
Opcode_bne_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa000000;
}

static void
Opcode_bnone_w15_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa800000;
}

static void
Opcode_rur_ae_bithead_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe30f10;
}

static void
Opcode_wur_ae_bithead_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf3f100;
}

static void
Opcode_rur_ae_cbegin0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe30f60;
}

static void
Opcode_wur_ae_cbegin0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf3f600;
}

static void
Opcode_rur_ae_cend0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe30f70;
}

static void
Opcode_wur_ae_cend0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf3f700;
}

static void
Opcode_ae_sext16_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800d;
}

static void
Opcode_ae_sext16_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5d1100;
}

static void
Opcode_ae_sext16_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x173a00;
}

static void
Opcode_ae_zext16_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x900d;
}

static void
Opcode_ae_zext16_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b8b00;
}

static void
Opcode_ae_zext16_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x173e00;
}

static void
Opcode_ae_zext8_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb00d;
}

static void
Opcode_ae_zext8_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b9b00;
}

static void
Opcode_ae_zext8_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x198000;
}

static void
Opcode_ae_clamps16_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa00d;
}

static void
Opcode_ae_clamps16_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5d1000;
}

static void
Opcode_rur_fcr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe30e80;
}

static void
Opcode_wur_fcr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf3e800;
}

static void
Opcode_rur_fsr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe30e90;
}

static void
Opcode_wur_fsr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf3e900;
}

static void
Opcode_rur_expstate_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe30e60;
}

static void
Opcode_wur_expstate_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf3e600;
}

static void
Opcode_read_impwire_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0000;
}

static void
Opcode_setb_expstate_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe1000;
}

static void
Opcode_clrb_expstate_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe1200;
}

static void
Opcode_wrmsk_expstate_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe2000;
}

static void
Opcode_rur_ae_overflow_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67ea04;
}

static void
Opcode_wur_ae_overflow_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67eb04;
}

static void
Opcode_rur_ae_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67ec04;
}

static void
Opcode_wur_ae_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67ed04;
}

static void
Opcode_rur_ae_bitptr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67ee04;
}

static void
Opcode_wur_ae_bitptr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67ef04;
}

static void
Opcode_rur_ae_bitsused_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67f004;
}

static void
Opcode_wur_ae_bitsused_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67f104;
}

static void
Opcode_rur_ae_tablesize_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67f204;
}

static void
Opcode_wur_ae_tablesize_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67f304;
}

static void
Opcode_rur_ae_first_ts_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67f404;
}

static void
Opcode_wur_ae_first_ts_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67f504;
}

static void
Opcode_rur_ae_nextoffset_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67f604;
}

static void
Opcode_wur_ae_nextoffset_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67f704;
}

static void
Opcode_rur_ae_searchdone_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67f804;
}

static void
Opcode_wur_ae_searchdone_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67f904;
}

static void
Opcode_rur_ae_cwrap_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67fa04;
}

static void
Opcode_wur_ae_cwrap_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67fb04;
}

static void
Opcode_ae_movcircv_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x173304;
}

static void
Opcode_ae_movvcirc_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x17330c;
}

static void
Opcode_ae_movfusionmiscv_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x173306;
}

static void
Opcode_ae_movvfusionmisc_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x198501;
}

static void
Opcode_ae_movtablefirstsearchnextv_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x173308;
}

static void
Opcode_ae_movvtablefirstsearchnext_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x173302;
}

static void
Opcode_ae_l8x4f_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5e0000;
}

static void
Opcode_ae_l8x4f_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5e1000;
}

static void
Opcode_ae_l8x4f_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x57f000;
}

static void
Opcode_ae_l8x4f_xp_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5e4000;
}

static void
Opcode_ae_l8x8_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x58c030;
}

static void
Opcode_ae_l8x8_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x580000;
}

static void
Opcode_ae_l16m_xc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50a000;
}

static void
Opcode_ae_l16m_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb10004;
}

static void
Opcode_ae_l16m_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x55f000;
}

static void
Opcode_ae_l16m_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb20004;
}

static void
Opcode_ae_l16m_iu_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x560000;
}

static void
Opcode_ae_l16m_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x509000;
}

static void
Opcode_ae_l16m_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb30004;
}

static void
Opcode_ae_l16m_xu_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50b000;
}

static void
Opcode_ae_l16_xc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x513000;
}

static void
Opcode_ae_l16_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb00004;
}

static void
Opcode_ae_l16_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x563000;
}

static void
Opcode_ae_l16_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb40004;
}

static void
Opcode_ae_l16_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x564000;
}

static void
Opcode_ae_l16_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x512000;
}

static void
Opcode_ae_l16_xp_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x514000;
}

static void
Opcode_ae_l32f24_xc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb50004;
}

static void
Opcode_ae_l32f24_xc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x516000;
}

static void
Opcode_ae_l32f24_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb60004;
}

static void
Opcode_ae_l32f24_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x565000;
}

static void
Opcode_ae_l32f24_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb70004;
}

static void
Opcode_ae_l32f24_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x566000;
}

static void
Opcode_ae_l32f24_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x515000;
}

static void
Opcode_ae_l32f24_xp_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x517000;
}

static void
Opcode_ae_l32_xc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbc0004;
}

static void
Opcode_ae_l32_xc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x522000;
}

static void
Opcode_ae_l32_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbd0004;
}

static void
Opcode_ae_l32_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x569000;
}

static void
Opcode_ae_l32_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbe0004;
}

static void
Opcode_ae_l32_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x56a000;
}

static void
Opcode_ae_l32_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbf0004;
}

static void
Opcode_ae_l32_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x521000;
}

static void
Opcode_ae_l32_xp_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x523000;
}

static void
Opcode_ae_l32m_xc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x519000;
}

static void
Opcode_ae_l32m_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc80004;
}

static void
Opcode_ae_l32m_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x567000;
}

static void
Opcode_ae_l32m_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc90004;
}

static void
Opcode_ae_l32m_iu_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x568000;
}

static void
Opcode_ae_l32m_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xca0004;
}

static void
Opcode_ae_l32m_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x518000;
}

static void
Opcode_ae_l32m_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcb0004;
}

static void
Opcode_ae_l32m_xu_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x51a000;
}

static void
Opcode_ae_l16x2m_xc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50d000;
}

static void
Opcode_ae_l16x2m_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb80004;
}

static void
Opcode_ae_l16x2m_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x561000;
}

static void
Opcode_ae_l16x2m_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb90004;
}

static void
Opcode_ae_l16x2m_iu_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x562000;
}

static void
Opcode_ae_l16x2m_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0004;
}

static void
Opcode_ae_l16x2m_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50c000;
}

static void
Opcode_ae_l16x2m_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbb0004;
}

static void
Opcode_ae_l16x2m_xu_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50e000;
}

static void
Opcode_ae_l32x2f24_xc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc40004;
}

static void
Opcode_ae_l32x2f24_xc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x51c000;
}

static void
Opcode_ae_l32x2f24_xc_Slot_fusion_slot_fir_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2000;
}

static void
Opcode_ae_l32x2f24_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc50004;
}

static void
Opcode_ae_l32x2f24_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x584010;
}

static void
Opcode_ae_l32x2f24_i_Slot_fusion_slot_fir_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1000;
}

static void
Opcode_ae_l32x2f24_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2c0084;
}

static void
Opcode_ae_l32x2f24_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x581080;
}

static void
Opcode_ae_l32x2f24_ip_Slot_fusion_slot_fir_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5080;
}

static void
Opcode_ae_l32x2f24_rip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d0024;
}

static void
Opcode_ae_l32x2f24_rip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f40d0;
}

static void
Opcode_ae_l32x2f24_ric_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f70c0;
}

static void
Opcode_ae_l32x2f24_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc60004;
}

static void
Opcode_ae_l32x2f24_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x51b000;
}

static void
Opcode_ae_l32x2f24_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc70004;
}

static void
Opcode_ae_l32x2f24_xp_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x51d000;
}

static void
Opcode_ae_l32x2_xc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc00004;
}

static void
Opcode_ae_l32x2_xc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x51f000;
}

static void
Opcode_ae_l32x2_xc_Slot_fusion_slot_fir_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000;
}

static void
Opcode_ae_l32x2_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc10004;
}

static void
Opcode_ae_l32x2_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x584020;
}

static void
Opcode_ae_l32x2_i_Slot_fusion_slot_fir_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3000;
}

static void
Opcode_ae_l32x2_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e0084;
}

static void
Opcode_ae_l32x2_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x582000;
}

static void
Opcode_ae_l32x2_ip_Slot_fusion_slot_fir_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6000;
}

static void
Opcode_ae_l32x2_rip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d0014;
}

static void
Opcode_ae_l32x2_rip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f60d0;
}

static void
Opcode_ae_l32x2_ric_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f50d0;
}

static void
Opcode_ae_l32x2_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc20004;
}

static void
Opcode_ae_l32x2_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x51e000;
}

static void
Opcode_ae_l32x2_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc30004;
}

static void
Opcode_ae_l32x2_xp_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x520000;
}

static void
Opcode_ae_l16x4_xc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x510000;
}

static void
Opcode_ae_l16x4_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc0004;
}

static void
Opcode_ae_l16x4_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x584000;
}

static void
Opcode_ae_l16x4_i_Slot_fusion_slot_fir_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_ae_l16x4_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x900084;
}

static void
Opcode_ae_l16x4_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x581000;
}

static void
Opcode_ae_l16x4_ip_Slot_fusion_slot_fir_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5000;
}

static void
Opcode_ae_l16x4_rip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f60c0;
}

static void
Opcode_ae_l16x4_ric_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f50c0;
}

static void
Opcode_ae_l16x4_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50f000;
}

static void
Opcode_ae_l16x4_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd0004;
}

static void
Opcode_ae_l16x4_xp_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x511000;
}

static void
Opcode_ae_l64_xc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x525000;
}

static void
Opcode_ae_l64_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf0004;
}

static void
Opcode_ae_l64_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x584030;
}

static void
Opcode_ae_l64_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x588000;
}

static void
Opcode_ae_l64_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x524000;
}

static void
Opcode_ae_l64_xp_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x526000;
}

static void
Opcode_ae_s8x4f_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5e2000;
}

static void
Opcode_ae_s8x4f_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5e3000;
}

static void
Opcode_ae_s16x2m_xc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x52b000;
}

static void
Opcode_ae_s16x2m_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd80004;
}

static void
Opcode_ae_s16x2m_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x56d000;
}

static void
Opcode_ae_s16x2m_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd90004;
}

static void
Opcode_ae_s16x2m_iu_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x56e000;
}

static void
Opcode_ae_s16x2m_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda0004;
}

static void
Opcode_ae_s16x2m_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x52a000;
}

static void
Opcode_ae_s16x2m_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb0004;
}

static void
Opcode_ae_s16x2m_xu_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x52c000;
}

static void
Opcode_ae_s32x2f24_xc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xec0004;
}

static void
Opcode_ae_s32x2f24_xc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x540000;
}

static void
Opcode_ae_s32x2f24_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xed0004;
}

static void
Opcode_ae_s32x2f24_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x588020;
}

static void
Opcode_ae_s32x2f24_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x620084;
}

static void
Opcode_ae_s32x2f24_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x582080;
}

static void
Opcode_ae_s32x2f24_rip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f60e0;
}

static void
Opcode_ae_s32x2f24_ric_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f50e0;
}

static void
Opcode_ae_s32x2f24_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xee0004;
}

static void
Opcode_ae_s32x2f24_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x53f000;
}

static void
Opcode_ae_s32x2f24_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xef0004;
}

static void
Opcode_ae_s32x2f24_xp_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x541000;
}

static void
Opcode_ae_s32x2_xc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe80004;
}

static void
Opcode_ae_s32x2_xc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x543000;
}

static void
Opcode_ae_s32x2_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe90004;
}

static void
Opcode_ae_s32x2_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x588030;
}

static void
Opcode_ae_s32x2_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x620004;
}

static void
Opcode_ae_s32x2_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x583080;
}

static void
Opcode_ae_s32x2_rip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f40f0;
}

static void
Opcode_ae_s32x2_ric_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f70e0;
}

static void
Opcode_ae_s32x2_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea0004;
}

static void
Opcode_ae_s32x2_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x542000;
}

static void
Opcode_ae_s32x2_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xeb0004;
}

static void
Opcode_ae_s32x2_xp_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x544000;
}

static void
Opcode_ae_s16x4_xc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x52e000;
}

static void
Opcode_ae_s16x4_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc0004;
}

static void
Opcode_ae_s16x4_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x588010;
}

static void
Opcode_ae_s16x4_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800084;
}

static void
Opcode_ae_s16x4_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x583000;
}

static void
Opcode_ae_s16x4_rip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f40e0;
}

static void
Opcode_ae_s16x4_ric_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f70d0;
}

static void
Opcode_ae_s16x4_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x52d000;
}

static void
Opcode_ae_s16x4_xp_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x52f000;
}

static void
Opcode_ae_s16x4rng_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x58c020;
}

static void
Opcode_ae_s16x4rng_i_Slot_fusion_slot40_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1000;
}

static void
Opcode_ae_s16x4rng_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x580080;
}

static void
Opcode_ae_s16x4rng_ip_Slot_fusion_slot40_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000;
}

static void
Opcode_ae_s16x4rng_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x57c000;
}

static void
Opcode_ae_s16x4rng_x_Slot_fusion_slot40_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2000;
}

static void
Opcode_ae_s16x4rng_xp_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x57d000;
}

static void
Opcode_ae_s16x4rng_xp_Slot_fusion_slot40_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3000;
}

static void
Opcode_ae_s16m_l_xc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x528000;
}

static void
Opcode_ae_s16m_l_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd50004;
}

static void
Opcode_ae_s16m_l_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x56b000;
}

static void
Opcode_ae_s16m_l_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd60004;
}

static void
Opcode_ae_s16m_l_iu_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x56c000;
}

static void
Opcode_ae_s16m_l_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd70004;
}

static void
Opcode_ae_s16m_l_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x527000;
}

static void
Opcode_ae_s16m_l_xu_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x529000;
}

static void
Opcode_ae_s32f24_l_xc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x537000;
}

static void
Opcode_ae_s32f24_l_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xde0004;
}

static void
Opcode_ae_s32f24_l_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x573000;
}

static void
Opcode_ae_s32f24_l_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdf0004;
}

static void
Opcode_ae_s32f24_l_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x574000;
}

static void
Opcode_ae_s32f24_l_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x536000;
}

static void
Opcode_ae_s32f24_l_xp_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x538000;
}

static void
Opcode_ae_s32_l_xc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x546000;
}

static void
Opcode_ae_s32_l_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe00004;
}

static void
Opcode_ae_s32_l_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x579000;
}

static void
Opcode_ae_s32_l_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe10004;
}

static void
Opcode_ae_s32_l_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x57a000;
}

static void
Opcode_ae_s32_l_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe20004;
}

static void
Opcode_ae_s32_l_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x545000;
}

static void
Opcode_ae_s32_l_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe30004;
}

static void
Opcode_ae_s32_l_xp_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x547000;
}

static void
Opcode_ae_s16_0_xc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x531000;
}

static void
Opcode_ae_s16_0_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd20004;
}

static void
Opcode_ae_s16_0_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x56f000;
}

static void
Opcode_ae_s16_0_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd30004;
}

static void
Opcode_ae_s16_0_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x570000;
}

static void
Opcode_ae_s16_0_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x530000;
}

static void
Opcode_ae_s16_0_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd40004;
}

static void
Opcode_ae_s16_0_xp_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x532000;
}

static void
Opcode_ae_s64_xc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x549000;
}

static void
Opcode_ae_s64_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10004;
}

static void
Opcode_ae_s64_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x58c000;
}

static void
Opcode_ae_s64_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20004;
}

static void
Opcode_ae_s64_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x58c010;
}

static void
Opcode_ae_s64_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x548000;
}

static void
Opcode_ae_s64_xp_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x54a000;
}

static void
Opcode_ae_s32m_xc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x53a000;
}

static void
Opcode_ae_s32m_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe40004;
}

static void
Opcode_ae_s32m_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x575000;
}

static void
Opcode_ae_s32m_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe50004;
}

static void
Opcode_ae_s32m_iu_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x576000;
}

static void
Opcode_ae_s32m_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe60004;
}

static void
Opcode_ae_s32m_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x539000;
}

static void
Opcode_ae_s32m_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe70004;
}

static void
Opcode_ae_s32m_xu_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x53b000;
}

static void
Opcode_ae_zalign64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x281304;
}

static void
Opcode_ae_lalign64_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b0a00;
}

static void
Opcode_ae_salign64_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b4a00;
}

static void
Opcode_ae_movalign_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x280304;
}

static void
Opcode_ae_la64_pp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7720c4;
}

static void
Opcode_ae_la24pos_pc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3bbac0;
}

static void
Opcode_ae_la24x2pos_pc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3bca40;
}

static void
Opcode_ae_la32x2pos_pc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7710c4;
}

static void
Opcode_ae_la32x2pos_pc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3bcac0;
}

static void
Opcode_ae_la16x4pos_pc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3bba40;
}

static void
Opcode_ae_la24neg_pc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3bba80;
}

static void
Opcode_ae_la24x2neg_pc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3bca00;
}

static void
Opcode_ae_la32x2neg_pc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3bca80;
}

static void
Opcode_ae_la16x4neg_pc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3bba00;
}

static void
Opcode_ae_sa64pos_fp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7730c4;
}

static void
Opcode_ae_sa64neg_fp_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3bda80;
}

static void
Opcode_ae_la32x2_ic_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0084;
}

static void
Opcode_ae_la32x2_ic_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c0a40;
}

static void
Opcode_ae_la32x2_ic_Slot_fusion_slot_fir_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7000;
}

static void
Opcode_ae_la32x2_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00c4;
}

static void
Opcode_ae_la32x2_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c0a80;
}

static void
Opcode_ae_la32x2_ip_Slot_fusion_slot_fir_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7040;
}

static void
Opcode_ae_la32x2_rip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d0a00;
}

static void
Opcode_ae_la32x2_ric_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c0ac0;
}

static void
Opcode_ae_la16x4_ic_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x370084;
}

static void
Opcode_ae_la16x4_ic_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c0a00;
}

static void
Opcode_ae_la16x4_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3700c4;
}

static void
Opcode_ae_la16x4_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x370a00;
}

static void
Opcode_ae_la16x4_rip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x350084;
}

static void
Opcode_ae_la16x4_rip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x370a80;
}

static void
Opcode_ae_la16x4_ric_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x370a40;
}

static void
Opcode_ae_la32x2f24_ic_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0004;
}

static void
Opcode_ae_la32x2f24_ic_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x390ac0;
}

static void
Opcode_ae_la32x2f24_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0044;
}

static void
Opcode_ae_la32x2f24_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3a0a00;
}

static void
Opcode_ae_la32x2f24_rip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3a0a80;
}

static void
Opcode_ae_la32x2f24_ric_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3a0a40;
}

static void
Opcode_ae_la24_ic_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x380ac0;
}

static void
Opcode_ae_la24_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x390a00;
}

static void
Opcode_ae_la24_rip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x390a80;
}

static void
Opcode_ae_la24_ric_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x390a40;
}

static void
Opcode_ae_la24x2_ic_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0004;
}

static void
Opcode_ae_la24x2_ic_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x370ac0;
}

static void
Opcode_ae_la24x2_ic_Slot_fusion_slot_fir_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6080;
}

static void
Opcode_ae_la24x2_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0044;
}

static void
Opcode_ae_la24x2_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x380a00;
}

static void
Opcode_ae_la24x2_ip_Slot_fusion_slot_fir_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x60c0;
}

static void
Opcode_ae_la24x2_rip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x380a80;
}

static void
Opcode_ae_la24x2_ric_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x380a40;
}

static void
Opcode_ae_sa32x2_ic_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f00c0;
}

static void
Opcode_ae_sa32x2_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc00c4;
}

static void
Opcode_ae_sa32x2_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f10c0;
}

static void
Opcode_ae_sa32x2_rip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f30c0;
}

static void
Opcode_ae_sa32x2_ric_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f20c0;
}

static void
Opcode_ae_sa16x4_ic_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f0080;
}

static void
Opcode_ae_sa16x4_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0084;
}

static void
Opcode_ae_sa16x4_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f1080;
}

static void
Opcode_ae_sa16x4_rip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f3080;
}

static void
Opcode_ae_sa16x4_ric_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f2080;
}

static void
Opcode_ae_sa32x2f24_ic_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1fc080;
}

static void
Opcode_ae_sa32x2f24_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f00c4;
}

static void
Opcode_ae_sa32x2f24_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1fd080;
}

static void
Opcode_ae_sa32x2f24_rip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ff080;
}

static void
Opcode_ae_sa32x2f24_ric_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1fe080;
}

static void
Opcode_ae_sa24_l_ic_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f8080;
}

static void
Opcode_ae_sa24_l_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f9080;
}

static void
Opcode_ae_sa24_l_rip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1fb080;
}

static void
Opcode_ae_sa24_l_ric_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1fa080;
}

static void
Opcode_ae_sa24x2_ic_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f4080;
}

static void
Opcode_ae_sa24x2_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f5080;
}

static void
Opcode_ae_sa24x2_rip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f7080;
}

static void
Opcode_ae_sa24x2_ric_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f6080;
}

static void
Opcode_ae_s32ra64s_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x577000;
}

static void
Opcode_ae_s32ra64s_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x578000;
}

static void
Opcode_ae_s32ra64s_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x53c000;
}

static void
Opcode_ae_s32ra64s_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40004;
}

static void
Opcode_ae_s32ra64s_xp_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x53e000;
}

static void
Opcode_ae_s32ra64s_xc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x53d000;
}

static void
Opcode_ae_s24ra64s_i_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x571000;
}

static void
Opcode_ae_s24ra64s_ip_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x572000;
}

static void
Opcode_ae_s24ra64s_x_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x533000;
}

static void
Opcode_ae_s24ra64s_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdd0004;
}

static void
Opcode_ae_s24ra64s_xp_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x535000;
}

static void
Opcode_ae_s24ra64s_xc_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x534000;
}

static void
Opcode_ae_s32x2ra64s_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4;
}

static void
Opcode_ae_s24x2ra64s_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30004;
}

static void
Opcode_ae_addbrba32_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x508000;
}

static void
Opcode_ae_addbrba32_Slot_fusion_slot40_0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_ae_sel16i_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30000;
}

static void
Opcode_ae_shortswap_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x173200;
}

static void
Opcode_ae_intswap_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f0d70;
}

static void
Opcode_ae_intswap_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x173600;
}

static void
Opcode_ae_movt16x4_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x172001;
}

static void
Opcode_ae_movf16x4_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x172000;
}

static void
Opcode_ae_movt32x2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b0014;
}

static void
Opcode_ae_movt32x2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x171001;
}

static void
Opcode_ae_movf32x2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3a0014;
}

static void
Opcode_ae_movf32x2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x171000;
}

static void
Opcode_ae_movda32x2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x150004;
}

static void
Opcode_ae_movda32x2_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x350a00;
}

static void
Opcode_ae_movda32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c0034;
}

static void
Opcode_ae_movda32_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f0470;
}

static void
Opcode_ae_movda16x2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x140004;
}

static void
Opcode_ae_movda16x2_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x340a00;
}

static void
Opcode_ae_movda16_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c0024;
}

static void
Opcode_ae_movda16_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3a0af0;
}

static void
Opcode_ae_movi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d0084;
}

static void
Opcode_ae_movi_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f0070;
}

static void
Opcode_ae_movi_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x174000;
}

static void
Opcode_ae_truncp24a32x2_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x360a00;
}

static void
Opcode_ae_sat16x4_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x145000;
}

static void
Opcode_ae_cvt32x2f16_32_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f0570;
}

static void
Opcode_ae_cvt32x2f16_10_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f0670;
}

static void
Opcode_ae_sext32x2d16_32_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f0a70;
}

static void
Opcode_ae_sext32x2d16_10_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f0870;
}

static void
Opcode_ae_cvta32f24s_l_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a5005;
}

static void
Opcode_ae_cvta32f24s_h_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a4005;
}

static void
Opcode_ae_cvtp24a16x2_ll_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x330a00;
}

static void
Opcode_ae_cvtp24a16x2_lh_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x320a00;
}

static void
Opcode_ae_cvtp24a16x2_hl_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x310a00;
}

static void
Opcode_ae_cvtp24a16x2_hh_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300a00;
}

static void
Opcode_ae_truncp24q48x2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16b000;
}

static void
Opcode_ae_trunca32x2f64s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf00004;
}

static void
Opcode_ae_trunci32x2f64s_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb900000;
}

static void
Opcode_ae_trunci16x4f32s_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb8c0000;
}

static void
Opcode_ae_trunca32f64s_l_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb8e0000;
}

static void
Opcode_ae_trunci32f64s_l_Slot_fusion_slot40_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb8f0000;
}

static void
Opcode_ae_truncp16_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1750c0;
}

static void
Opcode_ae_round32x2f64ssym_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x142000;
}

static void
Opcode_ae_round32x2f64sasym_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x470004;
}

static void
Opcode_ae_round32x2f64sasym_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x141000;
}

static void
Opcode_ae_round32x2f48ssym_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x140000;
}

static void
Opcode_ae_round32x2f48sasym_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13f000;
}

static void
Opcode_ae_round16x4f32ssym_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13c000;
}

static void
Opcode_ae_round16x4f32sasym_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x420004;
}

static void
Opcode_ae_round16x4f32sasym_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13b000;
}

static void
Opcode_ae_round24x2f48ssym_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x450004;
}

static void
Opcode_ae_round24x2f48ssym_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e000;
}

static void
Opcode_ae_round24x2f48sasym_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x440004;
}

static void
Opcode_ae_round24x2f48sasym_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13d000;
}

static void
Opcode_ae_roundsp16q48x2sym_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x144000;
}

static void
Opcode_ae_roundsp16q48x2asym_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x430004;
}

static void
Opcode_ae_roundsp16q48x2asym_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x143000;
}

static void
Opcode_ae_minabs32s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x166000;
}

static void
Opcode_ae_maxabs32s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x162000;
}

static void
Opcode_ae_roundsp16f24sym_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x173500;
}

static void
Opcode_ae_roundsp16f24asym_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x173100;
}

static void
Opcode_ae_mov_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e0014;
}

static void
Opcode_ae_mov_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f0770;
}

static void
Opcode_ae_mov_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x173d00;
}

static void
Opcode_ae_movt64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x600004;
}

static void
Opcode_ae_movt64_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16e000;
}

static void
Opcode_ae_movf64_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16d000;
}

static void
Opcode_ae_cvtq56a32s_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3a0ae0;
}

static void
Opcode_ae_cvt48a32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c0014;
}

static void
Opcode_ae_cvt48a32_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3a0ac0;
}

static void
Opcode_ae_cvt64a32_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3a0ad0;
}

static void
Opcode_ae_cvtq56p32s_l_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f0c70;
}

static void
Opcode_ae_cvtq56p32s_h_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f0b70;
}

static void
Opcode_ae_cvt64f32_h_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f0970;
}

static void
Opcode_ae_sat48s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0a04;
}

static void
Opcode_ae_sat48s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x175070;
}

static void
Opcode_ae_satq56s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x175080;
}

static void
Opcode_ae_sat24s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x175060;
}

static void
Opcode_ae_truncq32_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1750d0;
}

static void
Opcode_ae_minabs64s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x167000;
}

static void
Opcode_ae_maxabs64s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x163000;
}

static void
Opcode_ae_roundsq32f48sym_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0904;
}

static void
Opcode_ae_roundsq32f48sym_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x175050;
}

static void
Opcode_ae_roundsq32f48asym_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0804;
}

static void
Opcode_ae_roundsq32f48asym_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x175040;
}

static void
Opcode_ae_trunca32q48_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x250034;
}

static void
Opcode_ae_trunca32q48_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a0007;
}

static void
Opcode_ae_movad32_l_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2500c4;
}

static void
Opcode_ae_movad32_l_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5ab005;
}

static void
Opcode_ae_movad32_h_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2500b4;
}

static void
Opcode_ae_movad32_h_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5aa005;
}

static void
Opcode_ae_movad16_3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2500a4;
}

static void
Opcode_ae_movad16_3_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a9005;
}

static void
Opcode_ae_movad16_2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x250094;
}

static void
Opcode_ae_movad16_2_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a8005;
}

static void
Opcode_ae_movad16_1_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a7005;
}

static void
Opcode_ae_movad16_0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x250084;
}

static void
Opcode_ae_movad16_0_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a6005;
}

static void
Opcode_ae_sra64_32_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x590008;
}

static void
Opcode_ae_pksr32_0_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f80d0;
}

static void
Opcode_ae_pksr24_0_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f80c0;
}

static void
Opcode_ae_trunca16p24s_l_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x250024;
}

static void
Opcode_ae_trunca16p24s_l_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a0006;
}

static void
Opcode_ae_trunca16p24s_h_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x250014;
}

static void
Opcode_ae_trunca16p24s_h_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5af005;
}

static void
Opcode_ae_add32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300004;
}

static void
Opcode_ae_add32_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x133000;
}

static void
Opcode_ae_sub32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4c0004;
}

static void
Opcode_ae_sub32_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x149000;
}

static void
Opcode_ae_addsub32_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x139000;
}

static void
Opcode_ae_subadd32_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x14d000;
}

static void
Opcode_ae_add16_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130000;
}

static void
Opcode_ae_sub16_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x146000;
}

static void
Opcode_ae_add32_hl_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x135000;
}

static void
Opcode_ae_neg32_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1740f0;
}

static void
Opcode_ae_abs32_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x174060;
}

static void
Opcode_ae_add24s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x320004;
}

static void
Opcode_ae_add24s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x132000;
}

static void
Opcode_ae_sub24s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x148000;
}

static void
Opcode_ae_add32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400004;
}

static void
Opcode_ae_add32s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x134000;
}

static void
Opcode_ae_sub32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4f0004;
}

static void
Opcode_ae_sub32s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x14a000;
}

static void
Opcode_ae_addsub32s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13a000;
}

static void
Opcode_ae_subadd32s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x14e000;
}

static void
Opcode_ae_add16s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x330004;
}

static void
Opcode_ae_add16s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x131000;
}

static void
Opcode_ae_sub16s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4e0004;
}

static void
Opcode_ae_sub16s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x147000;
}

static void
Opcode_ae_neg24s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1740e0;
}

static void
Opcode_ae_abs24s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0104;
}

static void
Opcode_ae_abs24s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x174050;
}

static void
Opcode_ae_neg32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0704;
}

static void
Opcode_ae_neg32s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x175000;
}

static void
Opcode_ae_abs32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0304;
}

static void
Opcode_ae_abs32s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x174070;
}

static void
Opcode_ae_neg16s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0604;
}

static void
Opcode_ae_neg16s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1740d0;
}

static void
Opcode_ae_abs16s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0204;
}

static void
Opcode_ae_abs16s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x174040;
}

static void
Opcode_ae_conj16s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1750f0;
}

static void
Opcode_ae_mulc16js_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x189000;
}

static void
Opcode_ae_mulc16js_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x18a000;
}

static void
Opcode_ae_mulac16js_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x186000;
}

static void
Opcode_ae_mulac16js_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x188000;
}

static void
Opcode_ae_lt16_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x173000;
}

static void
Opcode_ae_le16_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x170300;
}

static void
Opcode_ae_eq16_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x170100;
}

static void
Opcode_ae_lt32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x541004;
}

static void
Opcode_ae_lt32_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x170000;
}

static void
Opcode_ae_le32_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16f100;
}

static void
Opcode_ae_eq32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x540004;
}

static void
Opcode_ae_eq32_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16f000;
}

static void
Opcode_ae_min32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x530004;
}

static void
Opcode_ae_min32_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x164000;
}

static void
Opcode_ae_max32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x520004;
}

static void
Opcode_ae_max32_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x160000;
}

static void
Opcode_ae_add64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x310004;
}

static void
Opcode_ae_add64_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x136000;
}

static void
Opcode_ae_sub64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4d0004;
}

static void
Opcode_ae_sub64_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x14b000;
}

static void
Opcode_ae_neg64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0504;
}

static void
Opcode_ae_neg64_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x175010;
}

static void
Opcode_ae_abs64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x270804;
}

static void
Opcode_ae_abs64_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x174080;
}

static void
Opcode_ae_addsq56s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x138000;
}

static void
Opcode_ae_subsq56s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x14f000;
}

static void
Opcode_ae_add64s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x137000;
}

static void
Opcode_ae_sub64s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x14c000;
}

static void
Opcode_ae_negsq56s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x175030;
}

static void
Opcode_ae_abssq56s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1740a0;
}

static void
Opcode_ae_neg64s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x175020;
}

static void
Opcode_ae_abs64s_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x174090;
}

static void
Opcode_ae_and_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x168000;
}

static void
Opcode_ae_nand_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x169000;
}

static void
Opcode_ae_or_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16a000;
}

static void
Opcode_ae_xor_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e0004;
}

static void
Opcode_ae_xor_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16c000;
}

static void
Opcode_ae_slai24_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x940004;
}

static void
Opcode_ae_slai24_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e0040;
}

static void
Opcode_ae_srli24_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f0020;
}

static void
Opcode_ae_srai24_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9c0004;
}

static void
Opcode_ae_srai24_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e00c0;
}

static void
Opcode_ae_slas24_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x240b04;
}

static void
Opcode_ae_slas24_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a0008;
}

static void
Opcode_ae_srls24_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a001c;
}

static void
Opcode_ae_sras24_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x240e04;
}

static void
Opcode_ae_sras24_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a0018;
}

static void
Opcode_ae_srai16_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a0000;
}

static void
Opcode_ae_srai16r_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a0001;
}

static void
Opcode_ae_slai32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x960004;
}

static void
Opcode_ae_slai32_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e0080;
}

static void
Opcode_ae_srli32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x920004;
}

static void
Opcode_ae_srli32_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f0040;
}

static void
Opcode_ae_srai32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9e0004;
}

static void
Opcode_ae_srai32_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e00e0;
}

static void
Opcode_ae_srai32r_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f0000;
}

static void
Opcode_ae_slas32_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a000a;
}

static void
Opcode_ae_srls32_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a001d;
}

static void
Opcode_ae_sras32_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a0019;
}

static void
Opcode_ae_slaa32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200004;
}

static void
Opcode_ae_slaa32_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x590001;
}

static void
Opcode_ae_srla32_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a0002;
}

static void
Opcode_ae_sraa32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70004;
}

static void
Opcode_ae_sraa32_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x59000b;
}

static void
Opcode_ae_slai16s_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x590007;
}

static void
Opcode_ae_slaa16s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x230004;
}

static void
Opcode_ae_slaa16s_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x590000;
}

static void
Opcode_ae_sraa16s_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x59000a;
}

static void
Opcode_ae_sraa16rs_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x590009;
}

static void
Opcode_ae_slai24s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x980004;
}

static void
Opcode_ae_slai24s_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e0060;
}

static void
Opcode_ae_slas24s_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a0009;
}

static void
Opcode_ae_slai32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9a0004;
}

static void
Opcode_ae_slai32s_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e00a0;
}

static void
Opcode_ae_slas32s_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a000b;
}

static void
Opcode_ae_slaa32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50004;
}

static void
Opcode_ae_slaa32s_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x590002;
}

static void
Opcode_ae_sraa32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x820004;
}

static void
Opcode_ae_sraa32s_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x59000d;
}

static void
Opcode_ae_sraa32rs_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x59000c;
}

static void
Opcode_ae_slasq56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x240c04;
}

static void
Opcode_ae_slasq56_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a000e;
}

static void
Opcode_ae_srlsq56_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a001f;
}

static void
Opcode_ae_srasq56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x240f04;
}

static void
Opcode_ae_srasq56_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a001b;
}

static void
Opcode_ae_slaaq56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x210004;
}

static void
Opcode_ae_slaaq56_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x590005;
}

static void
Opcode_ae_srlaq56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610004;
}

static void
Opcode_ae_srlaq56_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a0004;
}

static void
Opcode_ae_sraaq56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x910004;
}

static void
Opcode_ae_sraaq56_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x59000f;
}

static void
Opcode_ae_slai64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x880004;
}

static void
Opcode_ae_slai64_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d0000;
}

static void
Opcode_ae_srli64_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e0000;
}

static void
Opcode_ae_srai64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8c0004;
}

static void
Opcode_ae_srai64_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d00c0;
}

static void
Opcode_ae_slas64_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a000c;
}

static void
Opcode_ae_srls64_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a001e;
}

static void
Opcode_ae_sras64_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a001a;
}

static void
Opcode_ae_slaa64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x220004;
}

static void
Opcode_ae_slaa64_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x590003;
}

static void
Opcode_ae_srla64_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a0003;
}

static void
Opcode_ae_sraa64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x810004;
}

static void
Opcode_ae_sraa64_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x59000e;
}

static void
Opcode_ae_slaisq56s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x840004;
}

static void
Opcode_ae_slaisq56s_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d0080;
}

static void
Opcode_ae_slassq56s_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a000f;
}

static void
Opcode_ae_slaasq56s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x60004;
}

static void
Opcode_ae_slaasq56s_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x590006;
}

static void
Opcode_ae_slai64s_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d0040;
}

static void
Opcode_ae_slas64s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x240d04;
}

static void
Opcode_ae_slas64s_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a000d;
}

static void
Opcode_ae_slaa64s_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x590004;
}

static void
Opcode_ae_lt64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x510004;
}

static void
Opcode_ae_lt64_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x15f000;
}

static void
Opcode_ae_le64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x500004;
}

static void
Opcode_ae_le64_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x15e000;
}

static void
Opcode_ae_eq64_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x15d000;
}

static void
Opcode_ae_max64_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x161000;
}

static void
Opcode_ae_min64_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x165000;
}

static void
Opcode_ae_nsa64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2500d4;
}

static void
Opcode_ae_nsa64_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5ac005;
}

static void
Opcode_ae_nsaz16_0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2500e4;
}

static void
Opcode_ae_nsaz16_0_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5ad005;
}

static void
Opcode_ae_nsaz32_l_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2500f4;
}

static void
Opcode_ae_nsaz32_l_Slot_fusion_slot0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5ae005;
}

static void
Opcode_ae_muls32f48p16s_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc2000;
}

static void
Opcode_ae_mulf32s_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xaa000;
}

static void
Opcode_ae_mul32_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4f000;
}

static void
Opcode_ae_mulf32r_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa7000;
}

static void
Opcode_ae_muls32f48p16s_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc1000;
}

static void
Opcode_ae_mulf32s_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa9000;
}

static void
Opcode_ae_mul32_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4e000;
}

static void
Opcode_ae_mulf32r_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa6000;
}

static void
Opcode_ae_muls32f48p16s_hh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0000;
}

static void
Opcode_ae_mulf32s_hh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa8000;
}

static void
Opcode_ae_mul32_hh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4d000;
}

static void
Opcode_ae_mulf32r_hh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa5000;
}

static void
Opcode_ae_mulas32f48p16s_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x92000;
}

static void
Opcode_ae_mulaf32s_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7a000;
}

static void
Opcode_ae_mula32_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5b000;
}

static void
Opcode_ae_mulaf32r_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x77000;
}

static void
Opcode_ae_mulas32f48p16s_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x91000;
}

static void
Opcode_ae_mulaf32s_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x79000;
}

static void
Opcode_ae_mula32_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a000;
}

static void
Opcode_ae_mulaf32r_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x76000;
}

static void
Opcode_ae_mulas32f48p16s_hh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90000;
}

static void
Opcode_ae_mulaf32s_hh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x78000;
}

static void
Opcode_ae_mula32_hh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x59000;
}

static void
Opcode_ae_mulaf32r_hh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x75000;
}

static void
Opcode_ae_mulss32f48p16s_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfc000;
}

static void
Opcode_ae_mulsf32s_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe4000;
}

static void
Opcode_ae_muls32_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce000;
}

static void
Opcode_ae_mulsf32r_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe1000;
}

static void
Opcode_ae_mulss32f48p16s_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfb000;
}

static void
Opcode_ae_mulsf32s_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe3000;
}

static void
Opcode_ae_muls32_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd000;
}

static void
Opcode_ae_mulsf32r_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0000;
}

static void
Opcode_ae_mulss32f48p16s_hh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfa000;
}

static void
Opcode_ae_mulsf32s_hh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe2000;
}

static void
Opcode_ae_muls32_hh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc000;
}

static void
Opcode_ae_mulsf32r_hh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdf000;
}

static void
Opcode_ae_mul32u_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x44000;
}

static void
Opcode_ae_mula32u_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50000;
}

static void
Opcode_ae_muls32u_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc3000;
}

static void
Opcode_ae_mulf16ss_33_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa4000;
}

static void
Opcode_ae_mulf16ss_22_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0000;
}

static void
Opcode_ae_mulf16ss_32_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa3000;
}

static void
Opcode_ae_mulf16ss_21_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9f000;
}

static void
Opcode_ae_mulf16ss_31_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa2000;
}

static void
Opcode_ae_mulf16ss_30_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa1000;
}

static void
Opcode_ae_mulf16ss_10_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9c000;
}

static void
Opcode_ae_mulf16ss_20_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9e000;
}

static void
Opcode_ae_mulf16ss_11_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9d000;
}

static void
Opcode_ae_mulf16ss_00_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9b000;
}

static void
Opcode_ae_mulsf16ss_33_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xde000;
}

static void
Opcode_ae_mulsf16ss_22_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda000;
}

static void
Opcode_ae_mulsf16ss_32_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdd000;
}

static void
Opcode_ae_mulsf16ss_21_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd9000;
}

static void
Opcode_ae_mulsf16ss_31_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc000;
}

static void
Opcode_ae_mulsf16ss_30_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb000;
}

static void
Opcode_ae_mulsf16ss_10_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd6000;
}

static void
Opcode_ae_mulsf16ss_20_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd8000;
}

static void
Opcode_ae_mulsf16ss_11_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd7000;
}

static void
Opcode_ae_mulsf16ss_00_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd5000;
}

static void
Opcode_ae_mulaf16ss_33_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x74000;
}

static void
Opcode_ae_mulaf16ss_22_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70000;
}

static void
Opcode_ae_mulaf16ss_32_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73000;
}

static void
Opcode_ae_mulaf16ss_21_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6f000;
}

static void
Opcode_ae_mulaf16ss_31_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x72000;
}

static void
Opcode_ae_mulaf16ss_30_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x71000;
}

static void
Opcode_ae_mulaf16ss_10_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6c000;
}

static void
Opcode_ae_mulaf16ss_20_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6e000;
}

static void
Opcode_ae_mulaf16ss_11_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6d000;
}

static void
Opcode_ae_mulaf16ss_00_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6b000;
}

static void
Opcode_ae_mulaafd16ss_33_22_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x64000;
}

static void
Opcode_ae_mulaafd16ss_13_02_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x63000;
}

static void
Opcode_ae_mulaafd16ss_11_00_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x62000;
}

static void
Opcode_ae_mulssfd16ss_33_22_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x103000;
}

static void
Opcode_ae_mulssfd16ss_13_02_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x102000;
}

static void
Opcode_ae_mulssfd16ss_11_00_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x101000;
}

static void
Opcode_ae_mulzaafd16ss_33_22_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110000;
}

static void
Opcode_ae_mulzaafd16ss_13_02_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10f000;
}

static void
Opcode_ae_mulzaafd16ss_11_00_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10e000;
}

static void
Opcode_ae_mulzssfd16ss_33_22_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x12b000;
}

static void
Opcode_ae_mulzssfd16ss_13_02_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x12a000;
}

static void
Opcode_ae_mulzssfd16ss_11_00_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x129000;
}

static void
Opcode_ae_mulf48q32sp16s_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb3000;
}

static void
Opcode_ae_mulf48q32sp16u_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb4000;
}

static void
Opcode_ae_mulq32sp16s_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbe000;
}

static void
Opcode_ae_mulq32sp16u_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbf000;
}

static void
Opcode_ae_mulaf48q32sp16s_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x83000;
}

static void
Opcode_ae_mulaf48q32sp16u_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x84000;
}

static void
Opcode_ae_mulaq32sp16s_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8e000;
}

static void
Opcode_ae_mulaq32sp16u_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8f000;
}

static void
Opcode_ae_mulsf48q32sp16s_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xed000;
}

static void
Opcode_ae_mulsf48q32sp16u_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xee000;
}

static void
Opcode_ae_mulsq32sp16s_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf8000;
}

static void
Opcode_ae_mulsq32sp16u_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf9000;
}

static void
Opcode_ae_mulfp24x2ra_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb6000;
}

static void
Opcode_ae_mulfp24x2r_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb5000;
}

static void
Opcode_ae_mulp24x2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbb000;
}

static void
Opcode_ae_mulafp24x2ra_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x86000;
}

static void
Opcode_ae_mulafp24x2r_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x85000;
}

static void
Opcode_ae_mulap24x2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8b000;
}

static void
Opcode_ae_mulsfp24x2ra_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf0000;
}

static void
Opcode_ae_mulsfp24x2r_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xef000;
}

static void
Opcode_ae_mulsp24x2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf5000;
}

static void
Opcode_ae_mulzaafd24_hh_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x111000;
}

static void
Opcode_ae_mulzaad24_hh_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x108000;
}

static void
Opcode_ae_mulzaafd24_hl_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x112000;
}

static void
Opcode_ae_mulzaad24_hl_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x109000;
}

static void
Opcode_ae_mulzasfd24_hh_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x11b000;
}

static void
Opcode_ae_mulzasd24_hh_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x117000;
}

static void
Opcode_ae_mulzasfd24_hl_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x11c000;
}

static void
Opcode_ae_mulzasd24_hl_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x118000;
}

static void
Opcode_ae_mulzsafd24_hh_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x122000;
}

static void
Opcode_ae_mulzsad24_hh_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x11f000;
}

static void
Opcode_ae_mulzssfd24_hh_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x12c000;
}

static void
Opcode_ae_mulzssd24_hh_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x125000;
}

static void
Opcode_ae_mulzssfd24_hl_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x12d000;
}

static void
Opcode_ae_mulzssd24_hl_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x126000;
}

static void
Opcode_ae_mulaafd24_hh_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x65000;
}

static void
Opcode_ae_mulaad24_hh_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5c000;
}

static void
Opcode_ae_mulaafd24_hl_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x66000;
}

static void
Opcode_ae_mulaad24_hl_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5d000;
}

static void
Opcode_ae_mulasfd24_hh_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x97000;
}

static void
Opcode_ae_mulasd24_hh_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x93000;
}

static void
Opcode_ae_mulasfd24_hl_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x98000;
}

static void
Opcode_ae_mulasd24_hl_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x94000;
}

static void
Opcode_ae_mulsafd24_hh_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd2000;
}

static void
Opcode_ae_mulsad24_hh_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf000;
}

static void
Opcode_ae_mulssfd24_hh_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x104000;
}

static void
Opcode_ae_mulssd24_hh_ll_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfd000;
}

static void
Opcode_ae_mulssfd24_hl_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x105000;
}

static void
Opcode_ae_mulssd24_hl_lh_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfe000;
}

static void
Opcode_ae_mulf32x16_l0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xaf000;
}

static void
Opcode_ae_mul32x16_l0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x49000;
}

static void
Opcode_ae_mulf32x16_l1_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb0000;
}

static void
Opcode_ae_mul32x16_l1_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4a000;
}

static void
Opcode_ae_mulf32x16_l2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb1000;
}

static void
Opcode_ae_mul32x16_l2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4b000;
}

static void
Opcode_ae_mulf32x16_l3_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb2000;
}

static void
Opcode_ae_mul32x16_l3_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4c000;
}

static void
Opcode_ae_mulf32x16_h0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xab000;
}

static void
Opcode_ae_mul32x16_h0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x45000;
}

static void
Opcode_ae_mulf32x16_h1_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xac000;
}

static void
Opcode_ae_mul32x16_h1_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x46000;
}

static void
Opcode_ae_mulf32x16_h2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xad000;
}

static void
Opcode_ae_mul32x16_h2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x47000;
}

static void
Opcode_ae_mulf32x16_h3_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xae000;
}

static void
Opcode_ae_mul32x16_h3_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x48000;
}

static void
Opcode_ae_mulaf32x16_l0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7f000;
}

static void
Opcode_ae_mula32x16_l0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x55000;
}

static void
Opcode_ae_mulaf32x16_l1_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80000;
}

static void
Opcode_ae_mula32x16_l1_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x56000;
}

static void
Opcode_ae_mulaf32x16_l2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x81000;
}

static void
Opcode_ae_mula32x16_l2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x57000;
}

static void
Opcode_ae_mulaf32x16_l3_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x82000;
}

static void
Opcode_ae_mula32x16_l3_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x58000;
}

static void
Opcode_ae_mulaf32x16_h0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7b000;
}

static void
Opcode_ae_mula32x16_h0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x51000;
}

static void
Opcode_ae_mulaf32x16_h1_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7c000;
}

static void
Opcode_ae_mula32x16_h1_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x52000;
}

static void
Opcode_ae_mulaf32x16_h2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7d000;
}

static void
Opcode_ae_mula32x16_h2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x53000;
}

static void
Opcode_ae_mulaf32x16_h3_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7e000;
}

static void
Opcode_ae_mula32x16_h3_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x54000;
}

static void
Opcode_ae_mulsf32x16_l0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe9000;
}

static void
Opcode_ae_muls32x16_l0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc8000;
}

static void
Opcode_ae_mulsf32x16_l1_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea000;
}

static void
Opcode_ae_muls32x16_l1_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc9000;
}

static void
Opcode_ae_mulsf32x16_l2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xeb000;
}

static void
Opcode_ae_muls32x16_l2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xca000;
}

static void
Opcode_ae_mulsf32x16_l3_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xec000;
}

static void
Opcode_ae_muls32x16_l3_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcb000;
}

static void
Opcode_ae_mulsf32x16_h0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe5000;
}

static void
Opcode_ae_muls32x16_h0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc4000;
}

static void
Opcode_ae_mulsf32x16_h1_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe6000;
}

static void
Opcode_ae_muls32x16_h1_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc5000;
}

static void
Opcode_ae_mulsf32x16_h2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe7000;
}

static void
Opcode_ae_muls32x16_h2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc6000;
}

static void
Opcode_ae_mulsf32x16_h3_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe8000;
}

static void
Opcode_ae_muls32x16_h3_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc7000;
}

static void
Opcode_ae_mulaafd32x16_h3_l2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a000;
}

static void
Opcode_ae_mulaad32x16_h3_l2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61000;
}

static void
Opcode_ae_mulaafd32x16_h1_l0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x68000;
}

static void
Opcode_ae_mulaad32x16_h1_l0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5f000;
}

static void
Opcode_ae_mulasfd32x16_h3_l2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9a000;
}

static void
Opcode_ae_mulasd32x16_h3_l2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x96000;
}

static void
Opcode_ae_mulasfd32x16_h1_l0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x99000;
}

static void
Opcode_ae_mulasd32x16_h1_l0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x95000;
}

static void
Opcode_ae_mulsafd32x16_h3_l2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd4000;
}

static void
Opcode_ae_mulsad32x16_h3_l2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd1000;
}

static void
Opcode_ae_mulsafd32x16_h1_l0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd3000;
}

static void
Opcode_ae_mulsad32x16_h1_l0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0000;
}

static void
Opcode_ae_mulssfd32x16_h3_l2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x107000;
}

static void
Opcode_ae_mulssd32x16_h3_l2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100000;
}

static void
Opcode_ae_mulssfd32x16_h1_l0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x106000;
}

static void
Opcode_ae_mulssd32x16_h1_l0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xff000;
}

static void
Opcode_ae_mulzaafd32x16_h3_l2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x116000;
}

static void
Opcode_ae_mulzaad32x16_h3_l2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10d000;
}

static void
Opcode_ae_mulzaafd32x16_h1_l0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x114000;
}

static void
Opcode_ae_mulzaad32x16_h1_l0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10b000;
}

static void
Opcode_ae_mulzasfd32x16_h3_l2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x11e000;
}

static void
Opcode_ae_mulzasd32x16_h3_l2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x11a000;
}

static void
Opcode_ae_mulzasfd32x16_h1_l0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x11d000;
}

static void
Opcode_ae_mulzasd32x16_h1_l0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x119000;
}

static void
Opcode_ae_mulzsafd32x16_h3_l2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x124000;
}

static void
Opcode_ae_mulzsad32x16_h3_l2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x121000;
}

static void
Opcode_ae_mulzsafd32x16_h1_l0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x123000;
}

static void
Opcode_ae_mulzsad32x16_h1_l0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x120000;
}

static void
Opcode_ae_mulzssfd32x16_h3_l2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x12f000;
}

static void
Opcode_ae_mulzssd32x16_h3_l2_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x128000;
}

static void
Opcode_ae_mulzssfd32x16_h1_l0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x12e000;
}

static void
Opcode_ae_mulzssd32x16_h1_l0_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x127000;
}

static void
Opcode_ae_mulzaafd32x16_h2_l3_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x115000;
}

static void
Opcode_ae_mulzaafd32x16_h0_l1_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x113000;
}

static void
Opcode_ae_mulaafd32x16_h2_l3_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x69000;
}

static void
Opcode_ae_mulaafd32x16_h0_l1_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67000;
}

static void
Opcode_ae_mulzaad32x16_h2_l3_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10c000;
}

static void
Opcode_ae_mulzaad32x16_h0_l1_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10a000;
}

static void
Opcode_ae_mulaad32x16_h2_l3_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x60000;
}

static void
Opcode_ae_mulaad32x16_h0_l1_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5e000;
}

static void
Opcode_ae_mulp32x16x2_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbc000;
}

static void
Opcode_ae_mulfp32x16x2rs_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9000;
}

static void
Opcode_ae_mulfp32x16x2ras_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb7000;
}

static void
Opcode_ae_mulp32x16x2_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbd000;
}

static void
Opcode_ae_mulfp32x16x2rs_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba000;
}

static void
Opcode_ae_mulfp32x16x2ras_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb8000;
}

static void
Opcode_ae_mulap32x16x2_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8c000;
}

static void
Opcode_ae_mulafp32x16x2rs_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x89000;
}

static void
Opcode_ae_mulafp32x16x2ras_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x87000;
}

static void
Opcode_ae_mulap32x16x2_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8d000;
}

static void
Opcode_ae_mulafp32x16x2rs_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8a000;
}

static void
Opcode_ae_mulafp32x16x2ras_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x88000;
}

static void
Opcode_ae_mulsp32x16x2_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf6000;
}

static void
Opcode_ae_mulsfp32x16x2rs_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf3000;
}

static void
Opcode_ae_mulsfp32x16x2ras_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf1000;
}

static void
Opcode_ae_mulsp32x16x2_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf7000;
}

static void
Opcode_ae_mulsfp32x16x2rs_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf4000;
}

static void
Opcode_ae_mulsfp32x16x2ras_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf2000;
}

static void
Opcode_ae_mulfcr32x16ras_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ae000;
}

static void
Opcode_ae_mulfcr32x16ras_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ad000;
}

static void
Opcode_ae_mulfci32x16ras_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ab000;
}

static void
Opcode_ae_mulfci32x16ras_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1aa000;
}

static void
Opcode_ae_mulafcr32x16ras_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x197000;
}

static void
Opcode_ae_mulafcr32x16ras_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x196000;
}

static void
Opcode_ae_mulafci32x16ras_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x194000;
}

static void
Opcode_ae_mulafci32x16ras_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x193000;
}

static void
Opcode_ae_mulp32x2_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d8000;
}

static void
Opcode_ae_mulap32x2_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x19f000;
}

static void
Opcode_ae_mulsp32x2_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c2000;
}

static void
Opcode_ae_mulp32x2_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d9000;
}

static void
Opcode_ae_mulap32x2_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a0000;
}

static void
Opcode_ae_mulsp32x2_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c3000;
}

static void
Opcode_ae_mulfp32x2rs_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d6000;
}

static void
Opcode_ae_mulfp32x2ras_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d4000;
}

static void
Opcode_ae_mulafp32x2rs_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x19d000;
}

static void
Opcode_ae_mulafp32x2ras_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x19b000;
}

static void
Opcode_ae_mulsfp32x2rs_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c0000;
}

static void
Opcode_ae_mulsfp32x2ras_h_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1de000;
}

static void
Opcode_ae_mulfp32x2rs_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d7000;
}

static void
Opcode_ae_mulfp32x2ras_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d5000;
}

static void
Opcode_ae_mulafp32x2rs_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x19e000;
}

static void
Opcode_ae_mulafp32x2ras_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x19c000;
}

static void
Opcode_ae_mulsfp32x2rs_l_Slot_fusion_slot1_encode (xtensa_insnbuf slotbuf)
{
  