/* Xtensa configuration-specific ISA information.

   Copyright (c) 2003-2023 Cadence Design Systems, Inc.

   Permission is hereby granted, free of charge, to any person obtaining
   a copy of this software and associated documentation files (the
   "Software"), to deal in the Software without restriction, including
   without limitation the rights to use, copy, modify, merge, publish,
   distribute, sublicense, and/or sell copies of the Software, and to
   permit persons to whom the Software is furnished to do so, subject to
   the following conditions:

   The above copyright notice and this permission notice shall be included
   in all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
   CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
   TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
   SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.  */

#include "ansidecl.h"
#include <xtensa-isa.h>
#include "xtensa-isa-internal.h"


/* Sysregs.  */

static xtensa_sysreg_internal sysregs[] = {
  { "LBEG", 0, 0 },
  { "LEND", 1, 0 },
  { "LCOUNT", 2, 0 },
  { "BR", 4, 0 },
  { "ACCLO", 16, 0 },
  { "ACCHI", 17, 0 },
  { "M0", 32, 0 },
  { "M1", 33, 0 },
  { "M2", 34, 0 },
  { "M3", 35, 0 },
  { "MMID", 89, 0 },
  { "DDR", 104, 0 },
  { "CONFIGID0", 176, 0 },
  { "CONFIGID1", 208, 0 },
  { "INTERRUPT", 226, 0 },
  { "INTCLEAR", 227, 0 },
  { "CCOUNT", 234, 0 },
  { "PRID", 235, 0 },
  { "ICOUNT", 236, 0 },
  { "CCOMPARE0", 240, 0 },
  { "CCOMPARE1", 241, 0 },
  { "VECBASE", 231, 0 },
  { "EPC1", 177, 0 },
  { "EPC2", 178, 0 },
  { "EPC3", 179, 0 },
  { "EPC4", 180, 0 },
  { "EPC5", 181, 0 },
  { "EXCSAVE1", 209, 0 },
  { "EXCSAVE2", 210, 0 },
  { "EXCSAVE3", 211, 0 },
  { "EXCSAVE4", 212, 0 },
  { "EXCSAVE5", 213, 0 },
  { "EPS2", 194, 0 },
  { "EPS3", 195, 0 },
  { "EPS4", 196, 0 },
  { "EPS5", 197, 0 },
  { "EXCCAUSE", 232, 0 },
  { "DEPC", 192, 0 },
  { "EXCVADDR", 238, 0 },
  { "WINDOWBASE", 72, 0 },
  { "WINDOWSTART", 73, 0 },
  { "MEMCTL", 97, 0 },
  { "SAR", 3, 0 },
  { "PS", 230, 0 },
  { "MISC0", 244, 0 },
  { "MISC1", 245, 0 },
  { "INTENABLE", 228, 0 },
  { "DBREAKA0", 144, 0 },
  { "DBREAKC0", 160, 0 },
  { "DBREAKA1", 145, 0 },
  { "DBREAKC1", 161, 0 },
  { "IBREAKA0", 128, 0 },
  { "IBREAKA1", 129, 0 },
  { "IBREAKENABLE", 96, 0 },
  { "ICOUNTLEVEL", 237, 0 },
  { "DEBUGCAUSE", 233, 0 },
  { "PREFCTL", 40, 0 },
  { "CPENABLE", 224, 0 },
  { "SCOMPARE1", 12, 0 },
  { "ATOMCTL", 99, 0 },
  { "THREADPTR", 231, 1 },
  { "AE_OVF_SAR", 240, 1 },
  { "AE_BITHEAD", 241, 1 },
  { "AE_TS_FTS_BU_BP", 242, 1 },
  { "AE_CW_SD_NO", 243, 1 },
  { "AE_CBEGIN0", 246, 1 },
  { "AE_CEND0", 247, 1 },
  { "AE_CBEGIN1", 248, 1 },
  { "AE_CEND1", 249, 1 },
  { "FCR_FSR", -1, 1 },
  { "F64R_LO", 234, 1 },
  { "F64R_HI", 235, 1 },
  { "F64S", 236, 1 },
  { "EXPSTATE", 230, 1 }
};

#define NUM_SYSREGS 74
#define MAX_SPECIAL_REG 245
#define MAX_USER_REG 249


/* Processor states.  */

static xtensa_state_internal states[] = {
  { "LCOUNT", 32, 0 },
  { "PC", 32, 0 },
  { "DDR", 32, 0 },
  { "ICOUNT", 32, 0 },
  { "INTERRUPT", 32, 0 },
  { "CCOUNT", 32, 0 },
  { "XTSYNC", 1, 0 },
  { "VECBASE", 22, 0 },
  { "EPC1", 32, 0 },
  { "EPC2", 32, 0 },
  { "EPC3", 32, 0 },
  { "EPC4", 32, 0 },
  { "EPC5", 32, 0 },
  { "EXCSAVE1", 32, 0 },
  { "EXCSAVE2", 32, 0 },
  { "EXCSAVE3", 32, 0 },
  { "EXCSAVE4", 32, 0 },
  { "EXCSAVE5", 32, 0 },
  { "EPS2", 13, 0 },
  { "EPS3", 13, 0 },
  { "EPS4", 13, 0 },
  { "EPS5", 13, 0 },
  { "EXCCAUSE", 6, 0 },
  { "PSINTLEVEL", 4, 0 },
  { "PSUM", 1, 0 },
  { "PSWOE", 1, 0 },
  { "PSEXCM", 1, 0 },
  { "DEPC", 32, 0 },
  { "EXCVADDR", 32, 0 },
  { "WindowBase", 3, 0 },
  { "WindowStart", 8, 0 },
  { "PSCALLINC", 2, 0 },
  { "PSOWB", 4, 0 },
  { "LBEG", 32, 0 },
  { "LEND", 32, 0 },
  { "MEMCTL", 1, 0 },
  { "SAR", 6, 0 },
  { "THREADPTR", 32, 0 },
  { "MISC0", 32, 0 },
  { "MISC1", 32, 0 },
  { "ACC", 40, 0 },
  { "InOCDMode", 1, 0 },
  { "INTENABLE", 32, 0 },
  { "DBREAKA0", 32, 0 },
  { "DBREAKC0", 8, 0 },
  { "DBREAKA1", 32, 0 },
  { "DBREAKC1", 8, 0 },
  { "IBREAKA0", 32, 0 },
  { "IBREAKA1", 32, 0 },
  { "IBREAKENABLE", 2, 0 },
  { "ICOUNTLEVEL", 4, 0 },
  { "DEBUGCAUSE", 6, 0 },
  { "DBNUM", 4, 0 },
  { "CCOMPARE0", 32, 0 },
  { "CCOMPARE1", 32, 0 },
  { "PREFCTL", 13, 0 },
  { "CPENABLE", 2, 0 },
  { "SCOMPARE1", 32, 0 },
  { "ATOMCTL", 6, 0 },
  { "ERI_RAW_INTERLOCK", 1, 0 },
  { "AE_OVERFLOW", 1, XTENSA_STATE_IS_SHARED_OR },
  { "AE_CBEGIN0", 32, 0 },
  { "AE_CEND0", 32, 0 },
  { "AE_CBEGIN1", 32, 0 },
  { "AE_CEND1", 32, 0 },
  { "AE_SAR", 14, 0 },
  { "AE_CWRAP", 1, 0 },
  { "AE_BITHEAD", 32, 0 },
  { "AE_BITPTR", 4, 0 },
  { "AE_BITSUSED", 4, 0 },
  { "AE_TABLESIZE", 4, 0 },
  { "AE_FIRST_TS", 4, 0 },
  { "AE_NEXTOFFSET", 27, 0 },
  { "AE_SEARCHDONE", 1, 0 },
  { "RoundMode", 2, 0 },
  { "InvalidFlag", 1, XTENSA_STATE_IS_SHARED_OR },
  { "DivZeroFlag", 1, XTENSA_STATE_IS_SHARED_OR },
  { "OverflowFlag", 1, XTENSA_STATE_IS_SHARED_OR },
  { "UnderflowFlag", 1, XTENSA_STATE_IS_SHARED_OR },
  { "InexactFlag", 1, XTENSA_STATE_IS_SHARED_OR },
  { "F64R", 64, 0 },
  { "F64S", 32, 0 },
  { "EXPSTATE", 32, XTENSA_STATE_IS_EXPORTED }
};

#define NUM_STATES 83

enum xtensa_state_id {
  STATE_LCOUNT,
  STATE_PC,
  STATE_DDR,
  STATE_ICOUNT,
  STATE_INTERRUPT,
  STATE_CCOUNT,
  STATE_XTSYNC,
  STATE_VECBASE,
  STATE_EPC1,
  STATE_EPC2,
  STATE_EPC3,
  STATE_EPC4,
  STATE_EPC5,
  STATE_EXCSAVE1,
  STATE_EXCSAVE2,
  STATE_EXCSAVE3,
  STATE_EXCSAVE4,
  STATE_EXCSAVE5,
  STATE_EPS2,
  STATE_EPS3,
  STATE_EPS4,
  STATE_EPS5,
  STATE_EXCCAUSE,
  STATE_PSINTLEVEL,
  STATE_PSUM,
  STATE_PSWOE,
  STATE_PSEXCM,
  STATE_DEPC,
  STATE_EXCVADDR,
  STATE_WindowBase,
  STATE_WindowStart,
  STATE_PSCALLINC,
  STATE_PSOWB,
  STATE_LBEG,
  STATE_LEND,
  STATE_MEMCTL,
  STATE_SAR,
  STATE_THREADPTR,
  STATE_MISC0,
  STATE_MISC1,
  STATE_ACC,
  STATE_InOCDMode,
  STATE_INTENABLE,
  STATE_DBREAKA0,
  STATE_DBREAKC0,
  STATE_DBREAKA1,
  STATE_DBREAKC1,
  STATE_IBREAKA0,
  STATE_IBREAKA1,
  STATE_IBREAKENABLE,
  STATE_ICOUNTLEVEL,
  STATE_DEBUGCAUSE,
  STATE_DBNUM,
  STATE_CCOMPARE0,
  STATE_CCOMPARE1,
  STATE_PREFCTL,
  STATE_CPENABLE,
  STATE_SCOMPARE1,
  STATE_ATOMCTL,
  STATE_ERI_RAW_INTERLOCK,
  STATE_AE_OVERFLOW,
  STATE_AE_CBEGIN0,
  STATE_AE_CEND0,
  STATE_AE_CBEGIN1,
  STATE_AE_CEND1,
  STATE_AE_SAR,
  STATE_AE_CWRAP,
  STATE_AE_BITHEAD,
  STATE_AE_BITPTR,
  STATE_AE_BITSUSED,
  STATE_AE_TABLESIZE,
  STATE_AE_FIRST_TS,
  STATE_AE_NEXTOFFSET,
  STATE_AE_SEARCHDONE,
  STATE_RoundMode,
  STATE_InvalidFlag,
  STATE_DivZeroFlag,
  STATE_OverflowFlag,
  STATE_UnderflowFlag,
  STATE_InexactFlag,
  STATE_F64R,
  STATE_F64S,
  STATE_EXPSTATE
};


/* Field definitions.  */

static unsigned
Field_t_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_s_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_r_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_op2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_op1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_op1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_op0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_op0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_n_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_n_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_m_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_m_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_sr_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sr_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_st_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_st_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_thi3_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_thi3_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_t3_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_t3_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_tlo_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_tlo_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_w_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_w_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_r3_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_r3_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_rhi_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_rhi_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_dfp_fld_op2_3_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 8) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_op2_3_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800000) | (tie_t << 23);
}

static unsigned
Field_dfp_fld_op1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_dfp_fld_op1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_dfp_fld_op2_3_2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 8) >> 30);
  return tie_t;
}

static void
Field_dfp_fld_op2_3_2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00000) | (tie_t << 22);
}

static unsigned
Field_dfp_fld_r_3_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_3_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_dfp_fld_op2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  return tie_t;
}

static void
Field_dfp_fld_op2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_dfp_fld_op2_3_1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 8) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_op2_3_1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00000) | (tie_t << 21);
}

static unsigned
Field_dfp_fld_s_3_1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_s_3_1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_dfp_fld_r_3_1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_r_3_1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_s3to1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_s3to1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_inst_15_12_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_inst_15_12_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_inst_11_8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_inst_11_8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_inst_7_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_inst_7_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_inst_23_16_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 8) >> 24);
  return tie_t;
}

static void
Field_fld_inst_23_16_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0000) | (tie_t << 16);
}

static unsigned
Field_fld_inst_7_7_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_inst_7_7_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_inst_4_4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_fld_inst_4_4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_inst_5_4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_inst_5_4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_inst_7_6_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_inst_7_6_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_inst_11_8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_inst_11_8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_inst_5_4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_inst_5_4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_inst_13_8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 18) >> 26);
  return tie_t;
}

static void
Field_fld_inst_13_8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f00) | (tie_t << 8);
}

static unsigned
Field_fld_inst_12_8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_fld_inst_12_8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_inst_4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_inst_4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_inst_7_4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_inst_7_4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_inst_9_8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_inst_9_8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_inst_9_8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_inst_9_8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_inst_12_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_inst_12_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_inst_19_17_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  return tie_t;
}

static void
Field_inst_19_17_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_inst_19_18_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  return tie_t;
}

static void
Field_inst_19_18_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_fld_inst_23_12_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 8) >> 20);
  return tie_t;
}

static void
Field_fld_inst_23_12_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff000) | (tie_t << 12);
}

static unsigned
Field_fld_inst_7_4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_inst_7_4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_inst_3_0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_inst_3_0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_op0_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_op0_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_t_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_r_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_r_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_op0_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_op0_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_z_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_z_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_i_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_i_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_s_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_s_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_inst16b_15_13_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_ae_fld_inst16b_15_13_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_ae_fld_inst16b_12_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_ae_fld_inst16b_12_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_slot3_20_0_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 21) | ((insn[0] << 11) >> 11);
  return tie_t;
}

static void
Field_fld_ae_slot3_20_0_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 11) >> 11;
  insn[0] = (insn[0] & ~0x1fffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot3_20_12_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 11) >> 23);
  return tie_t;
}

static void
Field_fld_ae_slot3_20_12_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x1ff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_slot3_20_8_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 11) >> 19);
  return tie_t;
}

static void
Field_fld_ae_slot3_20_8_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x1fff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot3_3_0_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot3_3_0_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot3_20_16_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 11) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot3_20_16_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae_slot3_1_0_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot3_1_0_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot3_0_0_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot3_0_0_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot3_20_10_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 11) >> 21);
  return tie_t;
}

static void
Field_fld_ae_slot3_20_10_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x1ffc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_slot3_7_4_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot3_7_4_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot3_20_13_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 11) >> 24);
  return tie_t;
}

static void
Field_fld_ae_slot3_20_13_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x1fe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_slot3_13_12_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot3_13_12_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_slot3_20_14_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 11) >> 25);
  return tie_t;
}

static void
Field_fld_ae_slot3_20_14_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc000) | (tie_t << 14);
}

static unsigned
Field_fld_ae_slot3_11_4_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_fld_ae_slot3_11_4_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot3_11_11_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot3_11_11_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_fld_ae_slot3_20_15_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 11) >> 26);
  return tie_t;
}

static void
Field_fld_ae_slot3_20_15_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x1f8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_slot2_20_0_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 21) | ((insn[0] << 11) >> 11);
  return tie_t;
}

static void
Field_fld_ae_slot2_20_0_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 11) >> 11;
  insn[0] = (insn[0] & ~0x1fffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot2_20_14_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 11) >> 25);
  return tie_t;
}

static void
Field_fld_ae_slot2_20_14_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc000) | (tie_t << 14);
}

static unsigned
Field_fld_ae_slot2_20_10_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 11) >> 21);
  return tie_t;
}

static void
Field_fld_ae_slot2_20_10_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x1ffc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_slot2_20_12_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 11) >> 23);
  return tie_t;
}

static void
Field_fld_ae_slot2_20_12_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x1ff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_slot2_7_4_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot2_7_4_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot2_20_8_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 11) >> 19);
  return tie_t;
}

static void
Field_fld_ae_slot2_20_8_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x1fff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot2_3_2_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot2_3_2_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_ae_slot2_7_0_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 24) >> 24);
  return tie_t;
}

static void
Field_fld_ae_slot2_7_0_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot2_3_0_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot2_3_0_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot2_9_8_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot2_9_8_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot2_20_4_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 17) | ((insn[0] << 11) >> 15);
  return tie_t;
}

static void
Field_fld_ae_slot2_20_4_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0x1ffff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot2_20_13_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 11) >> 24);
  return tie_t;
}

static void
Field_fld_ae_slot2_20_13_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x1fe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_slot2_20_15_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 11) >> 26);
  return tie_t;
}

static void
Field_fld_ae_slot2_20_15_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x1f8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_slot1_19_8_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 12) >> 20);
  return tie_t;
}

static void
Field_fld_ae_slot1_19_8_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot1_19_16_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot1_19_16_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae_slot1_19_12_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 12) >> 24);
  return tie_t;
}

static void
Field_fld_ae_slot1_19_12_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_slot1_19_17_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  return tie_t;
}

static void
Field_fld_ae_slot1_19_17_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae_slot1_3_0_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot1_3_0_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot1_19_0_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 20) | ((insn[0] << 12) >> 12);
  return tie_t;
}

static void
Field_fld_ae_slot1_19_0_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 12) >> 12;
  insn[0] = (insn[0] & ~0xfffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot1_19_4_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 12) >> 16);
  return tie_t;
}

static void
Field_fld_ae_slot1_19_4_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot1_19_9_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 12) >> 21);
  return tie_t;
}

static void
Field_fld_ae_slot1_19_9_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0xffe00) | (tie_t << 9);
}

static unsigned
Field_fld_ae_slot1_7_4_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot1_7_4_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot1_19_13_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 12) >> 25);
  return tie_t;
}

static void
Field_fld_ae_slot1_19_13_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0xfe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_slot1_7_7_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot1_7_7_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_ae_slot1_7_6_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot1_7_6_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae_slot0_20_8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 11) >> 19);
  return tie_t;
}

static void
Field_fld_ae_slot0_20_8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x1fff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot0_20_16_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 11) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot0_20_16_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae_slot0_20_12_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 11) >> 23);
  return tie_t;
}

static void
Field_fld_ae_slot0_20_12_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x1ff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_slot0_3_0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot0_3_0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot0_20_0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 21) | ((insn[0] << 11) >> 11);
  return tie_t;
}

static void
Field_fld_ae_slot0_20_0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 11) >> 11;
  insn[0] = (insn[0] & ~0x1fffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot0_20_4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 17) | ((insn[0] << 11) >> 15);
  return tie_t;
}

static void
Field_fld_ae_slot0_20_4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0x1ffff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot0_20_13_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 11) >> 24);
  return tie_t;
}

static void
Field_fld_ae_slot0_20_13_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x1fe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae_slot0_11_4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_fld_ae_slot0_11_4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot0_7_4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot0_7_4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot0_20_15_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 11) >> 26);
  return tie_t;
}

static void
Field_fld_ae_slot0_20_15_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x1f8000) | (tie_t << 15);
}

static unsigned
Field_fld_ae_slot0_5_4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot0_5_4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot0_3_2_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot0_3_2_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_ae_slot0_0_0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot0_0_0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot0_11_8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot0_11_8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot0_4_4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot0_4_4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot0_5_0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 26) >> 26);
  return tie_t;
}

static void
Field_fld_ae_slot0_5_0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot0_5_2_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_fld_ae_slot0_5_2_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_fld_ae_slot0_4_0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot0_4_0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot0_8_8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot0_8_8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot0_9_8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae_slot0_9_8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot0_11_0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 20) >> 20);
  return tie_t;
}

static void
Field_fld_ae_slot0_11_0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot0_7_0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 24) >> 24);
  return tie_t;
}

static void
Field_fld_ae_slot0_7_0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff) | (tie_t << 0);
}

static unsigned
Field_fld_ae_slot0_9_4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 22) >> 26);
  return tie_t;
}

static void
Field_fld_ae_slot0_9_4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot0_8_4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 23) >> 27);
  return tie_t;
}

static void
Field_fld_ae_slot0_8_4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_slot0_7_7_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot0_7_7_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_ae_slot0_20_14_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 11) >> 25);
  return tie_t;
}

static void
Field_fld_ae_slot0_20_14_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x1fc000) | (tie_t << 14);
}

static unsigned
Field_fld_ae_slot0_11_11_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_fld_ae_slot0_11_11_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_fld_ae2_slot2_24_0_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 25) | ((insn[0] << 7) >> 7);
  return tie_t;
}

static void
Field_fld_ae2_slot2_24_0_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0x1ffffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot2_24_16_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 7) >> 23);
  return tie_t;
}

static void
Field_fld_ae2_slot2_24_16_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x1ff0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae2_slot2_7_4_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot2_7_4_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae2_slot2_24_20_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 7) >> 27);
  return tie_t;
}

static void
Field_fld_ae2_slot2_24_20_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae2_slot1_19_8_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 12) >> 20);
  return tie_t;
}

static void
Field_fld_ae2_slot1_19_8_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae2_slot1_19_16_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot1_19_16_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae2_slot1_19_12_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 12) >> 24);
  return tie_t;
}

static void
Field_fld_ae2_slot1_19_12_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae2_slot1_19_17_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  return tie_t;
}

static void
Field_fld_ae2_slot1_19_17_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae2_slot1_3_0_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot1_3_0_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot1_19_0_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 20) | ((insn[0] << 12) >> 12);
  return tie_t;
}

static void
Field_fld_ae2_slot1_19_0_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 12) >> 12;
  insn[0] = (insn[0] & ~0xfffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot1_19_4_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 12) >> 16);
  return tie_t;
}

static void
Field_fld_ae2_slot1_19_4_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae2_slot1_19_9_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 12) >> 21);
  return tie_t;
}

static void
Field_fld_ae2_slot1_19_9_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0xffe00) | (tie_t << 9);
}

static unsigned
Field_fld_ae2_slot1_7_4_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot1_7_4_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae2_slot1_19_13_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 12) >> 25);
  return tie_t;
}

static void
Field_fld_ae2_slot1_19_13_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0xfe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae2_slot1_7_7_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_ae2_slot1_7_7_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_ae2_slot1_7_6_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_ae2_slot1_7_6_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae2_slot1_7_0_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 24) >> 24);
  return tie_t;
}

static void
Field_fld_ae2_slot1_7_0_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot0_28_8_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 21) | ((insn[0] << 3) >> 11);
  return tie_t;
}

static void
Field_fld_ae2_slot0_28_8_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 11) >> 11;
  insn[0] = (insn[0] & ~0x1fffff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae2_slot0_28_16_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 3) >> 19);
  return tie_t;
}

static void
Field_fld_ae2_slot0_28_16_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x1fff0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae2_slot0_28_12_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 17) | ((insn[0] << 3) >> 15);
  return tie_t;
}

static void
Field_fld_ae2_slot0_28_12_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0x1ffff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae2_slot0_28_17_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 3) >> 20);
  return tie_t;
}

static void
Field_fld_ae2_slot0_28_17_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x1ffe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae2_slot0_28_20_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 3) >> 23);
  return tie_t;
}

static void
Field_fld_ae2_slot0_28_20_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x1ff00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae2_slot0_7_4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot0_7_4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae2_slot0_3_0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot0_3_0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot0_28_4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 25) | ((insn[0] << 3) >> 7);
  return tie_t;
}

static void
Field_fld_ae2_slot0_28_4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0x1ffffff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae2_slot0_28_13_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 3) >> 16);
  return tie_t;
}

static void
Field_fld_ae2_slot0_28_13_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0x1fffe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae2_slot0_11_4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_fld_ae2_slot0_11_4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae2_slot0_3_2_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae2_slot0_3_2_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_ae2_slot0_0_0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_ae2_slot0_0_0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot0_28_27_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 3) >> 30);
  return tie_t;
}

static void
Field_fld_ae2_slot0_28_27_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x18000000) | (tie_t << 27);
}

static unsigned
Field_fld_ae2_slot0_11_9_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_fld_ae2_slot0_11_9_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_fld_ae2_slot0_11_8_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot0_11_8_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae2_slot0_4_4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_fld_ae2_slot0_4_4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_fld_ae2_slot0_5_4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae2_slot0_5_4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae2_slot0_5_0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 26) >> 26);
  return tie_t;
}

static void
Field_fld_ae2_slot0_5_0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot0_5_2_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_fld_ae2_slot0_5_2_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_fld_ae2_slot0_11_0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 20) >> 20);
  return tie_t;
}

static void
Field_fld_ae2_slot0_11_0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot0_7_0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 24) >> 24);
  return tie_t;
}

static void
Field_fld_ae2_slot0_7_0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff) | (tie_t << 0);
}

static unsigned
Field_fld_ae2_slot0_9_4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 22) >> 26);
  return tie_t;
}

static void
Field_fld_ae2_slot0_9_4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f0) | (tie_t << 4);
}

static unsigned
Field_fld_ae2_slot0_8_4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 23) >> 27);
  return tie_t;
}

static void
Field_fld_ae2_slot0_8_4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0) | (tie_t << 4);
}

static unsigned
Field_fld_ae2_slot0_7_7_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_ae2_slot0_7_7_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_ae3_slot1_19_8_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 12) >> 20);
  return tie_t;
}

static void
Field_fld_ae3_slot1_19_8_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae3_slot1_19_16_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_fld_ae3_slot1_19_16_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae3_slot1_19_12_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 12) >> 24);
  return tie_t;
}

static void
Field_fld_ae3_slot1_19_12_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae3_slot1_19_17_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  return tie_t;
}

static void
Field_fld_ae3_slot1_19_17_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae3_slot1_3_0_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae3_slot1_3_0_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae3_slot1_19_0_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 20) | ((insn[0] << 12) >> 12);
  return tie_t;
}

static void
Field_fld_ae3_slot1_19_0_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 12) >> 12;
  insn[0] = (insn[0] & ~0xfffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae3_slot1_19_4_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 12) >> 16);
  return tie_t;
}

static void
Field_fld_ae3_slot1_19_4_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae3_slot1_7_1_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 24) >> 25);
  return tie_t;
}

static void
Field_fld_ae3_slot1_7_1_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0xfe) | (tie_t << 1);
}

static unsigned
Field_fld_ae3_slot1_7_4_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae3_slot1_7_4_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae3_slot1_19_13_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 12) >> 25);
  return tie_t;
}

static void
Field_fld_ae3_slot1_19_13_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0xfe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae3_slot1_7_7_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_ae3_slot1_7_7_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_ae3_slot1_7_6_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_ae3_slot1_7_6_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae3_slot1_3_2_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae3_slot1_3_2_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_ae3_slot0_21_8_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 10) >> 18);
  return tie_t;
}

static void
Field_fld_ae3_slot0_21_8_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0x3fff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae3_slot0_21_16_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 10) >> 26);
  return tie_t;
}

static void
Field_fld_ae3_slot0_21_16_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae3_slot0_21_12_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 10) >> 22);
  return tie_t;
}

static void
Field_fld_ae3_slot0_21_12_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae3_slot0_21_17_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 10) >> 27);
  return tie_t;
}

static void
Field_fld_ae3_slot0_21_17_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae3_slot0_21_20_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  return tie_t;
}

static void
Field_fld_ae3_slot0_21_20_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_fld_ae3_slot0_7_4_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae3_slot0_7_4_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae3_slot0_3_0_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae3_slot0_3_0_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae3_slot0_21_0_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 22) | ((insn[0] << 10) >> 10);
  return tie_t;
}

static void
Field_fld_ae3_slot0_21_0_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 10) >> 10;
  insn[0] = (insn[0] & ~0x3fffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae3_slot0_21_13_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  return tie_t;
}

static void
Field_fld_ae3_slot0_21_13_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae3_slot0_21_14_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  return tie_t;
}

static void
Field_fld_ae3_slot0_21_14_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_fld_ae3_slot0_7_6_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_ae3_slot0_7_6_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae3_slot0_5_5_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 26) >> 31);
  return tie_t;
}

static void
Field_fld_ae3_slot0_5_5_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x20) | (tie_t << 5);
}

static unsigned
Field_fld_ae3_slot0_5_4_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae3_slot0_5_4_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae3_slot0_21_2_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 20) | ((insn[0] << 10) >> 12);
  return tie_t;
}

static void
Field_fld_ae3_slot0_21_2_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 12) >> 12;
  insn[0] = (insn[0] & ~0x3ffffc) | (tie_t << 2);
}

static unsigned
Field_fld_ae3_slot0_11_8_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae3_slot0_11_8_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae3_slot0_5_2_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 26) >> 28);
  return tie_t;
}

static void
Field_fld_ae3_slot0_5_2_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c) | (tie_t << 2);
}

static unsigned
Field_fld_ae3_slot0_5_0_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 26) >> 26);
  return tie_t;
}

static void
Field_fld_ae3_slot0_5_0_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f) | (tie_t << 0);
}

static unsigned
Field_fld_ae3_slot0_4_0_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 27) >> 27);
  return tie_t;
}

static void
Field_fld_ae3_slot0_4_0_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f) | (tie_t << 0);
}

static unsigned
Field_fld_ae3_slot0_8_8_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_fld_ae3_slot0_8_8_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_fld_ae3_slot0_9_8_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae3_slot0_9_8_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae3_slot0_21_4_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 10) >> 14);
  return tie_t;
}

static void
Field_fld_ae3_slot0_21_4_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0x3ffff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae3_slot0_3_2_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae3_slot0_3_2_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_ae4_slot1_13_12_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_fld_ae4_slot1_13_12_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_fld_ae4_slot1_13_8_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 18) >> 26);
  return tie_t;
}

static void
Field_fld_ae4_slot1_13_8_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f00) | (tie_t << 8);
}

static unsigned
Field_fld_ae4_slot1_13_11_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  return tie_t;
}

static void
Field_fld_ae4_slot1_13_11_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
}

static unsigned
Field_fld_ae4_slot1_13_0_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 18) >> 18);
  return tie_t;
}

static void
Field_fld_ae4_slot1_13_0_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0x3fff) | (tie_t << 0);
}

static unsigned
Field_fld_ae4_slot0_27_3_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 25) | ((insn[0] << 4) >> 7);
  return tie_t;
}

static void
Field_fld_ae4_slot0_27_3_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0xffffff8) | (tie_t << 3);
}

static unsigned
Field_fld_ae4_slot0_2_0_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae4_slot0_2_0_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae4_slot0_27_23_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 4) >> 27);
  return tie_t;
}

static void
Field_fld_ae4_slot0_27_23_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf800000) | (tie_t << 23);
}

static unsigned
Field_fld_ae4_slot0_7_4_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae4_slot0_7_4_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae4_slot0_27_24_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 4) >> 28);
  return tie_t;
}

static void
Field_fld_ae4_slot0_27_24_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000000) | (tie_t << 24);
}

static unsigned
Field_fld_ae5_slot2_19_0_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 20) | ((insn[0] << 12) >> 12);
  return tie_t;
}

static void
Field_fld_ae5_slot2_19_0_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 12) >> 12;
  insn[0] = (insn[0] & ~0xfffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae5_slot2_19_12_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 12) >> 24);
  return tie_t;
}

static void
Field_fld_ae5_slot2_19_12_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae5_slot1_0_0_Slot_ae5_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_fld_ae5_slot1_0_0_Slot_ae5_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_fld_ae5_slot0_21_8_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 10) >> 18);
  return tie_t;
}

static void
Field_fld_ae5_slot0_21_8_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0x3fff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae5_slot0_21_16_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 10) >> 26);
  return tie_t;
}

static void
Field_fld_ae5_slot0_21_16_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae5_slot0_21_12_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 10) >> 22);
  return tie_t;
}

static void
Field_fld_ae5_slot0_21_12_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff000) | (tie_t << 12);
}

static unsigned
Field_fld_ae5_slot0_21_17_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 10) >> 27);
  return tie_t;
}

static void
Field_fld_ae5_slot0_21_17_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0000) | (tie_t << 17);
}

static unsigned
Field_fld_ae5_slot0_21_20_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  return tie_t;
}

static void
Field_fld_ae5_slot0_21_20_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_fld_ae5_slot0_7_4_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae5_slot0_7_4_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae5_slot0_3_0_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae5_slot0_3_0_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae5_slot0_21_0_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 22) | ((insn[0] << 10) >> 10);
  return tie_t;
}

static void
Field_fld_ae5_slot0_21_0_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 10) >> 10;
  insn[0] = (insn[0] & ~0x3fffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae5_slot0_21_13_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  return tie_t;
}

static void
Field_fld_ae5_slot0_21_13_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_fld_ae5_slot0_21_14_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  return tie_t;
}

static void
Field_fld_ae5_slot0_21_14_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_fld_ae5_slot0_5_4_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae5_slot0_5_4_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae5_slot0_7_7_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_ae5_slot0_7_7_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_ae5_slot0_7_6_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_ae5_slot0_7_6_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae5_slot0_21_6_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 10) >> 16);
  return tie_t;
}

static void
Field_fld_ae5_slot0_21_6_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0x3fffc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae5_slot0_11_8_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae5_slot0_11_8_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae5_slot0_3_2_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae5_slot0_3_2_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_ae5_slot0_21_4_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 10) >> 14);
  return tie_t;
}

static void
Field_fld_ae5_slot0_21_4_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0x3ffff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae6_slot3_17_0_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 14) >> 14);
  return tie_t;
}

static void
Field_fld_ae6_slot3_17_0_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0x3ffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae6_slot3_17_16_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  return tie_t;
}

static void
Field_fld_ae6_slot3_17_16_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
}

static unsigned
Field_fld_ae6_slot2_13_0_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 18) >> 18);
  return tie_t;
}

static void
Field_fld_ae6_slot2_13_0_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0x3fff) | (tie_t << 0);
}

static unsigned
Field_fld_ae6_slot2_13_12_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_fld_ae6_slot2_13_12_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_fld_ae6_slot2_3_0_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae6_slot2_3_0_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae6_slot1_14_0_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 17) >> 17);
  return tie_t;
}

static void
Field_fld_ae6_slot1_14_0_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x7fff) | (tie_t << 0);
}

static unsigned
Field_fld_ae6_slot1_14_12_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_fld_ae6_slot1_14_12_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_fld_ae6_slot1_7_7_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_ae6_slot1_7_7_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_ae6_slot1_14_6_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 17) >> 23);
  return tie_t;
}

static void
Field_fld_ae6_slot1_14_6_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x7fc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae6_slot1_7_6_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_ae6_slot1_7_6_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae6_slot0_15_0_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 16) >> 16);
  return tie_t;
}

static void
Field_fld_ae6_slot0_15_0_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae6_slot0_15_12_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae6_slot0_15_12_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae6_slot0_7_7_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_ae6_slot0_7_7_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_ae7_slot3_18_0_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 19) | ((insn[0] << 13) >> 13);
  return tie_t;
}

static void
Field_fld_ae7_slot3_18_0_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 13) >> 13;
  insn[0] = (insn[0] & ~0x7ffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae7_slot3_18_16_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  return tie_t;
}

static void
Field_fld_ae7_slot3_18_16_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static unsigned
Field_fld_ae7_slot2_18_0_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 19) | ((insn[0] << 13) >> 13);
  return tie_t;
}

static void
Field_fld_ae7_slot2_18_0_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 13) >> 13;
  insn[0] = (insn[0] & ~0x7ffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae7_slot2_18_16_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 13) >> 29);
  return tie_t;
}

static void
Field_fld_ae7_slot2_18_16_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70000) | (tie_t << 16);
}

static unsigned
Field_fld_ae7_slot1_15_0_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 16) >> 16);
  return tie_t;
}

static void
Field_fld_ae7_slot1_15_0_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae7_slot1_15_12_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae7_slot1_15_12_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae7_slot1_7_7_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_ae7_slot1_7_7_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_ae7_slot1_7_4_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae7_slot1_7_4_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae7_slot0_15_0_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 16) >> 16);
  return tie_t;
}

static void
Field_fld_ae7_slot0_15_0_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff) | (tie_t << 0);
}

static unsigned
Field_fld_ae7_slot0_15_12_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae7_slot0_15_12_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae7_slot0_7_7_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_ae7_slot0_7_7_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_ae7_slot0_7_4_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae7_slot0_7_4_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae7_slot0_7_6_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_ae7_slot0_7_6_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_t_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_t_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_bbi4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_bbi4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_bbi_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_bbi_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_bbi_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 23) >> 27);
  return tie_t;
}

static void
Field_bbi_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0) | (tie_t << 4);
}

static unsigned
Field_bbi_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 8) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_bbi_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x800000) | (tie_t << 23);
}

static unsigned
Field_imm12_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 8) >> 20);
  return tie_t;
}

static void
Field_imm12_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff000) | (tie_t << 12);
}

static unsigned
Field_imm8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 8) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0000) | (tie_t << 16);
}

static unsigned
Field_imm8_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm8_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm8_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm8_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm8_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm8_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_s_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_s_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_s_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_s_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_s_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_s_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_s_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_s_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_s_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_s_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_s_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_s_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_s_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_s_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_s_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_imm12b_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 8) >> 24);
  return tie_t;
}

static void
Field_imm12b_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0000) | (tie_t << 16);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_imm12b_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm12b_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm12b_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm12b_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm12b_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm12b_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm12b_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm12b_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm12b_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm12b_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm12b_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm12b_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm12b_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm12b_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm16_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 8) >> 16);
  return tie_t;
}

static void
Field_imm16_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff00) | (tie_t << 8);
}

static unsigned
Field_imm16_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 12) >> 20);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm16_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 16) >> 20;
  insn[0] = (insn[0] & ~0xfff00) | (tie_t << 8);
}

static unsigned
Field_imm16_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 12) >> 20);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm16_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 16) >> 20;
  insn[0] = (insn[0] & ~0xfff00) | (tie_t << 8);
}

static unsigned
Field_imm16_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 12) >> 20);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm16_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 16) >> 20;
  insn[0] = (insn[0] & ~0xfff00) | (tie_t << 8);
}

static unsigned
Field_offset_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 8) >> 14);
  return tie_t;
}

static void
Field_offset_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xffffc0) | (tie_t << 6);
}

static unsigned
Field_op2_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_op2_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_op2_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_op2_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_op2_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_op2_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_r_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_r_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_r_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_r_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_disp_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_r_disp_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_r_3_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_r_3_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_sa4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  return tie_t;
}

static void
Field_sa4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_sae4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_sae4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_sae_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_sae_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sae_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sae_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sae_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sae_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sae_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_sal_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_sal_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
  tie_t = (val << 27) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_sargt_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sas4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_sas4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_sas_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sas_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_sas_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sas_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_sas_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sas_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sas_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sas_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_sas_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sas_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sas_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_sas_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_imm4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_mn_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_mn_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_i_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_i_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_imm6lo_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm6lo_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm6lo_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm6lo_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm6hi_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_imm6hi_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_imm6hi_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_imm6hi_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_imm7lo_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm7lo_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm7lo_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm7lo_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm7hi_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_imm7hi_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_imm7hi_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_imm7hi_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_z_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_z_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_imm6_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm6_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_imm7_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm7_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_imm7_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 21) >> 25);
  return tie_t;
}

static void
Field_imm7_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f0) | (tie_t << 4);
}

static unsigned
Field_rbit2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  return tie_t;
}

static void
Field_rbit2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_tbit2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_tbit2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_y_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_y_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_x_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 17) >> 31);
  return tie_t;
}

static void
Field_x_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x4000) | (tie_t << 14);
}

static unsigned
Field_t2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_t2_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_t2_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_t2_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_t2_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_t2_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_s2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_s2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_r2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_r2_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_r2_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_r2_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_r2_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_t4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_t4_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_t4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_t4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_t4_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_t4_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_s4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_s4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_s4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_s4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_r4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_r4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_r4_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_r4_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_r4_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_t8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_t8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_s8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_s8_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 30) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2) | (tie_t << 1);
}

static unsigned
Field_s8_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 30) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x2) | (tie_t << 1);
}

static unsigned
Field_r8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_r8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_xt_wbr15_imm_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 8) >> 17);
  return tie_t;
}

static void
Field_xt_wbr15_imm_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0xfffe00) | (tie_t << 9);
}

static unsigned
Field_xt_wbr15_imm_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 5) >> 17);
  return tie_t;
}

static void
Field_xt_wbr15_imm_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x7fff000) | (tie_t << 12);
}

static unsigned
Field_xt_wbr15_imm_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 9) >> 17);
  return tie_t;
}

static void
Field_xt_wbr15_imm_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x7fff00) | (tie_t << 8);
}

static unsigned
Field_xt_wbr18_imm_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 8) >> 14);
  return tie_t;
}

static void
Field_xt_wbr18_imm_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xffffc0) | (tie_t << 6);
}

static unsigned
Field_ae_fld_fhba4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_fhba4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_fhba4_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_fhba4_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_fhba4_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_ae_fld_fhba4_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_fhba4_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_fhba4_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_fhba4_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_fhba4_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_fhba4_2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_fhba4_2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_fhba4_2_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_fhba4_2_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_tp7_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_tp7_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_tp7_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_tp7_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_osa32_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa32_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_ae_fld_osa32_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 19) >> 27);
  return tie_t;
}

static void
Field_ae_fld_osa32_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_osa32_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa32_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_ae_fld_osa32_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa32_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_ae_fld_osa64_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa64_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
}

static unsigned
Field_ae_fld_osa64_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 16) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa64_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc000) | (tie_t << 14);
}

static unsigned
Field_ae_fld_osa64_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa64_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_ae_fld_osa64_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa64_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_ae_fld_imm2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_ae_fld_imm2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_ae_fld_imm2_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_ae_fld_imm2_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_ae_fld_imm2_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_ae_fld_imm2_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_ae_fld_immls64_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls64_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls64_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_immls64_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls64_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_immls64_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls64_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_immls64_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls64_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_immls64_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls64_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_ae_fld_immls64_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_immls64_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_ae_fld_immls64_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_immls64_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls64_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls64_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls64_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls64_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64pos_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64pos_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64pos_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64pos_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64pos_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64pos_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_ae_fld_immls64pos_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64pos_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64pos_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64pos_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_ae_fld_immls64pos_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64pos_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64pos_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_ae_fld_immls64pos_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_ae_fld_immls64pos_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64pos_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64pos_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64pos_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64pos_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64pos_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64pos_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64pos_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64pos_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64pos_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64half_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64half_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64half_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64half_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64half_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64half_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_ae_fld_immls64half_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64half_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64half_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64half_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_ae_fld_immls64half_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64half_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls64half_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_ae_fld_immls64half_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_ae_fld_immls64half_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_ae_fld_immls64half_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls32_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls32_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls32_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls32_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls32_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls32_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls32_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls32_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls32_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls32_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls32_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls32_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls32_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls32_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls32_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls32_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls16_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls16_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls16_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls16_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls16_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls16_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls16_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls16_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls16_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls16_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls16_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls16_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls16_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls16_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_immls16_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_immls16_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_osa16_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa16_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_osa16_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa16_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_osa16_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa16_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_ls_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_ls_v_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_v_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_ls_v_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_v_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_ls_v_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_v_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_v_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_v_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_v_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_v_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_v_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_uu_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_uu_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ls_uu_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_uu_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_ae_fld_ls_uu_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_uu_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_ae_fld_ls_uu_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_uu_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_ae_fld_ls_uu_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_uu_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ls_uu_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_uu_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ls_uu_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_uu_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ls_su_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_su_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ls_su_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_su_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_ae_fld_ls_su_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_su_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_ae_fld_ls_su_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_su_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_ae_fld_ls_su_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_ae_fld_ls_su_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ls_av_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_av_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_ls_av_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_av_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_ls_av_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_av_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_av_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_av_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_av_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_av_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_av_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_av_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_av_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_av_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_v1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_ls_v1_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v1_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_ls_v1_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v1_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_ls_v1_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v1_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_v1_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v1_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ls_v2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ls_v2_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v2_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ls_v2_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v2_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ls_v2_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v2_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ls_v2_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ls_v2_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_cmpp_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmpp_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_cmpp_v1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmpp_v1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_cmpp_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmpp_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_uu_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_ae_fld_uu_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_ae_fld_uu_v_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_ae_fld_uu_v_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_ae_fld_uu_v_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_ae_fld_uu_v_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_ae_fld_uu_v_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_ae_fld_uu_v_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_ae_fld_uu_v_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_ae_fld_uu_v_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_ae_fld_uu_uu_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_ae_fld_uu_uu_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_ae_fld_uu_uu_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_ae_fld_uu_uu_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_ae_fld_uu_uu_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_ae_fld_uu_uu_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_ae_fld_uu_uu_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_ae_fld_uu_uu_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_ae_fld_uu_uu_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_ae_fld_uu_uu_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_ae_fld_dr_to_ar_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_ar_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_dr_to_ar_v0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_ar_v0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_dr_to_ar_v0_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_ar_v0_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_dr_to_ar_v0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_ar_v0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_dr_to_ar_v0_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_ar_v0_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_dr_to_ar_v0_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_ar_v0_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_cmov_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmov_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_cmov_v_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmov_v_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_cmov_v_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmov_v_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_cmov_v_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmov_v_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_cmov_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmov_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_cmov_v0_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmov_v0_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_cmov_v0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmov_v0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_cmov_v0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_cmov_v0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_pks_d_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_pks_d_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_pks_d_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_pks_d_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_pks_d_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_pks_d_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_pks_s_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_pks_s_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_pks_s_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_pks_s_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_pks_s_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_pks_s_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_shift_d_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_d_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_shift_d_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_d_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_shift_d_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_d_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_shift_d_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_d_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_shift_d0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_d0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_shift_d0_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_d0_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_shift_d0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_d0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_shift_d0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_d0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_shift_sd_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_sd_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_ae_fld_shift_sd_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_sd_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_shift_sd_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_shift_sd_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_dr_to_dr_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_dr_to_dr_v_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_dr_to_dr_v_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_dr_to_dr_v_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_dr_to_dr_v_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_dr_to_dr_v_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_dr_to_dr_v_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_dr_to_dr_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_dr_to_dr_v0_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v0_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_dr_to_dr_v0_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v0_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_dr_to_dr_v0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_dr_to_dr_v0_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v0_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_dr_to_dr_v0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_dr_to_dr_v0_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v0_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_dr_to_dr_v1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_dr_to_dr_v1_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v1_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_dr_to_dr_v1_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v1_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_dr_to_dr_v1_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v1_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_dr_to_dr_v1_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v1_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_dr_to_dr_v1_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_dr_to_dr_v1_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_to_dr_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_to_dr_v_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_to_dr_v_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_to_dr_v_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_to_dr_v_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_to_dr_v_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_to_dr_v_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_to_dr_v_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_to_dr_v_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_to_dr_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_to_dr_v0_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v0_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_to_dr_v0_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v0_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_to_dr_v0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_to_dr_v0_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v0_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_to_dr_v0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_to_dr_v0_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v0_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_to_dr_v0_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v0_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_to_dr_v0_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_to_dr_v0_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_immls64neg_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 25) >> 30);
  return tie_t;
}

static void
Field_fld_ae_immls64neg_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60) | (tie_t << 5);
}

static unsigned
Field_fld_ae_immls64neg_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae_immls64neg_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae_immls64neg_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_ae_immls64neg_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae_immls64neg_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae_immls64neg_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae_immls64neg_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_ae_immls64neg_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae_immls64neg_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae_immls64neg_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae_immls64neg_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_ae_immls64neg_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_ae_immls64neg_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae_immls64neg_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_ae_fld_selimm_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_ae_fld_selimm_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_ae_fld_selimm_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_selimm_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_selimm_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_selimm_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_selimm_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_selimm_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_selimm_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_selimm_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_selimm_n_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_ae_fld_selimm_n_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_fld_ar_to_dr_imm_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ar_to_dr_imm_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ar_to_dr_imm_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 22) >> 26);
  return tie_t;
}

static void
Field_fld_ar_to_dr_imm_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f0) | (tie_t << 4);
}

static unsigned
Field_fld_ar_to_dr_imm_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 22) >> 26);
  return tie_t;
}

static void
Field_fld_ar_to_dr_imm_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f0) | (tie_t << 4);
}

static unsigned
Field_fld_ar_to_dr_imm_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 26) >> 26);
  return tie_t;
}

static void
Field_fld_ar_to_dr_imm_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f) | (tie_t << 0);
}

static unsigned
Field_fld_ar_to_dr_imm_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ar_to_dr_imm_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_ar_to_dr_imm_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 26) >> 26);
  return tie_t;
}

static void
Field_fld_ar_to_dr_imm_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f) | (tie_t << 0);
}

static unsigned
Field_fld_ar_to_dr_imm_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ar_to_dr_imm_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_ar_to_dr_imm_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 26) >> 26);
  return tie_t;
}

static void
Field_fld_ar_to_dr_imm_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f) | (tie_t << 0);
}

static unsigned
Field_fld_ar_to_dr_imm_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ar_to_dr_imm_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_ar_to_dr_imm_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 26) >> 26);
  return tie_t;
}

static void
Field_fld_ar_to_dr_imm_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f) | (tie_t << 0);
}

static unsigned
Field_ae_fld_arth_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_arth_v_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_arth_v_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_arth_v_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_arth_v_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_arth_v_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_arth_v_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_arth_v_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_arth_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_arth_v0_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v0_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_arth_v0_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v0_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_arth_v0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_arth_v0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_arth_v0_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v0_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_arth_v0_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v0_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_arth_v1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_arth_v1_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v1_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_arth_v1_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v1_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_arth_v1_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v1_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_arth_v1_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v1_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_arth_v1_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v1_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_arth_v1_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v1_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_arth_v1_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_arth_v1_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_ar_to_dr_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ar_to_dr_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_ar_to_dr_v_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ar_to_dr_v_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_ar_to_dr_v_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ar_to_dr_v_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_ar_to_dr_v_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ar_to_dr_v_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ar_to_dr_v_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ar_to_dr_v_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_ar_to_dr_v_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ar_to_dr_v_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ar_to_dr_v_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ar_to_dr_v_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ar_to_dr_v_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ar_to_dr_v_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ar_to_dr_v_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ar_to_dr_v_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_ar_to_dr_v_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_ar_to_dr_v_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_end_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_end_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_end_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_end_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_end_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_end_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_end_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_end_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_arithmetic_ds_Slot_ae6_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_ds_Slot_ae6_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_rng_d_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_rng_d_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_d1_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_d1_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_d1_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_d1_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_d1_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_d1_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_d0_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_d0_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_d0_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_d0_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_d0_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_d0_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_d0_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_d0_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_q0_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_q0_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_q0_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_q0_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_q0_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_q0_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_q0_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_q0_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_mul_x2_s2_d1_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s2_d1_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_mul_x2_s2_d0_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s2_d0_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_mul_x2_s2_d0_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s2_d0_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_mul_x2_s2_q0_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s2_q0_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_mul_x2_s2_q0_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s2_q0_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_mul_x4_d1_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x4_d1_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_mul_x4_d1_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x4_d1_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_mul_x4_d1_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x4_d1_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_mul_x4_d1_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x4_d1_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_mul_x4_d0_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x4_d0_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_mul_x4_d0_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x4_d0_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_mul_x4_d0_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x4_d0_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_mul_x4_d0_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x4_d0_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_mul_x4_q0_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x4_q0_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_mul_x4_q0_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x4_q0_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_mul_x4_q0_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x4_q0_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_mul_x4_q0_Slot_ae6_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x4_q0_Slot_ae6_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_mul_x4_q1_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x4_q1_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_mul_x4_d2_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x4_d2_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_d2_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_d2_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_d2_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_d2_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_v1_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_v1_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_v1_Slot_ae7_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_v1_Slot_ae7_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_mul_x2_s2_d2_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s2_d2_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_mul_x2_s2_v1_Slot_ae7_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s2_v1_Slot_ae7_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_ep_ls_ei_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_ep_ls_ei_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_ae_sem_ep_ls_ei_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_ep_ls_ei_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_ep_ls_ei_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_ep_ls_ei_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_ep_ls_ei_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_ep_ls_ei_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_ep_ls_ar_s_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ep_ls_ar_s_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_ep_ls_ar_s_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ep_ls_ar_s_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_ep_ls_eo_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_ep_ls_eo_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_ep_ls_eo_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_ep_ls_eo_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_ep_ls_eo_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_ep_ls_eo_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_ep_ls_eo_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_ep_ls_eo_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_arithmetic_ep_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_ep_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_arithmetic_ep1_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_ep1_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_acc_ep_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_acc_ep_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_mul_x2_s2_acc_ep_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s2_acc_ep_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_shift_e_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_e_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_shift_i8_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 21) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_i8_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_arithmetic_e_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_e_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_arithmetic_e_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_e_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_vr_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_vr_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_cmov_bt_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_bt_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_cmov_bt_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_bt_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_cmov_arr_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_arr_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_cmov_arr_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_arr_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_vfpu2_sem_mov_vt_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_mov_vt_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_vfpu2_sem_mov_vt_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_mov_vt_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_vfpu2_sem_mov_vt_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_mov_vt_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_vfpu2_sem_mov_vr_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_mov_vr_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_vfpu2_sem_mov_vr_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_mov_vr_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_vfpu2_sem_mov_vr_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_mov_vr_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_vfpu2_sem_spfma_vt_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spfma_vt_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_vfpu2_sem_spfma_vt_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spfma_vt_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_vfpu2_sem_spfma_vt_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spfma_vt_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_vfpu2_sem_spfma_vt_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spfma_vt_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_vfpu2_sem_spfma_vt_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spfma_vt_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_vfpu2_sem_spfma_vs_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spfma_vs_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_vfpu2_sem_spfma_vs_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spfma_vs_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_vfpu2_sem_spfma_vs_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spfma_vs_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_vfpu2_sem_spfma_vs_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spfma_vs_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_vfpu2_sem_spfma_vs_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spfma_vs_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_vfpu2_sem_spfma_vr_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spfma_vr_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_vfpu2_sem_spfma_vr_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spfma_vr_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_vfpu2_sem_spfma_vr_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spfma_vr_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_vfpu2_sem_spfma_vr_Slot_ae5_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spfma_vr_Slot_ae5_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_vfpu2_sem_spfma_vr_Slot_ae2_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spfma_vr_Slot_ae2_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_vfpu2_sem_spmisc_brt_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spmisc_brt_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_fld_vfpu2_sem_spmisc_brt_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spmisc_brt_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_fld_vfpu2_sem_spmisc_vs_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spmisc_vs_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_vfpu2_sem_spmisc_vs_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spmisc_vs_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_vfpu2_sem_spmisc_vs_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spmisc_vs_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_vfpu2_sem_spmisc_vr_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spmisc_vr_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_vfpu2_sem_spmisc_vr_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spmisc_vr_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_vfpu2_sem_spmisc_vr_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spmisc_vr_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_vfpu2_sem_mov_i_imm4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_mov_i_imm4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_vfpu2_sem_mov_i_imm4_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_mov_i_imm4_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_vfpu2_sem_sp32cvt_vr_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_sp32cvt_vr_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_vfpu2_sem_sp32cvt_vr_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_sp32cvt_vr_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_vfpu2_sem_sp32cvt_vt_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_sp32cvt_vt_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_vfpu2_sem_sp32cvt_vt_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_sp32cvt_vt_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_vfpu2_sem_sp32cvt_i_imm5_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 21) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_sp32cvt_i_imm5_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x400) | (tie_t << 10);
}

static unsigned
Field_fld_vfpu2_sem_sp32cvt_i_imm5_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_sp32cvt_i_imm5_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_vfpu2_sem_sp32cvt_arr_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_sp32cvt_arr_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_vfpu2_sem_spmisc_vt_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spmisc_vt_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_vfpu2_sem_spmisc_vsm_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spmisc_vsm_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_slot2_20_18_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 11) >> 29);
  return tie_t;
}

static void
Field_fld_ae_slot2_20_18_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c0000) | (tie_t << 18);
}

static unsigned
Field_fld_vfpu2_sem_spmisc_vtm_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spmisc_vtm_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_vfpu2_sem_spfma_i_imm1_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spfma_i_imm1_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_vfpu2_sem_spfma_i_imm1_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spfma_i_imm1_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_vfpu2_sem_spfma_i_imm3_Slot_ae_slot3_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spfma_i_imm3_Slot_ae_slot3_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_fld_vfpu2_sem_spfma_i_imm3_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_fld_vfpu2_sem_spfma_i_imm3_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_movfpstate_v_Slot_ae_slot2_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_movfpstate_v_Slot_ae_slot2_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_dfp_fld_r_0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_dfp_fld_r_0_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_0_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_dfp_fld_r_0_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_0_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_dfp_fld_r_0_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_0_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_dfp_fld_r_0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_dfp_fld_r_0_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_0_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_dfp_fld_r_0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_dfp_fld_r_0_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_0_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_dfp_fld_r_0_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_0_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_dfp_fld_r_0_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_0_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_dfp_fld_r_0_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_0_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_dfp_fld_r_0_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_0_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_dfp_fld_r_0_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_0_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_dfp_fld_r_2_1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  return tie_t;
}

static void
Field_dfp_fld_r_2_1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_dfp_fld_r_2_1_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  return tie_t;
}

static void
Field_dfp_fld_r_2_1_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_dfp_fld_r_2_1_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 17) >> 30);
  return tie_t;
}

static void
Field_dfp_fld_r_2_1_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x6000) | (tie_t << 13);
}

static unsigned
Field_dfp_fld_r_2_1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 21) >> 30);
  return tie_t;
}

static void
Field_dfp_fld_r_2_1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x600) | (tie_t << 9);
}

static unsigned
Field_dfp_fld_r_2_1_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 21) >> 30);
  return tie_t;
}

static void
Field_dfp_fld_r_2_1_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x600) | (tie_t << 9);
}

static unsigned
Field_dfp_fld_r_2_1_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 21) >> 30);
  return tie_t;
}

static void
Field_dfp_fld_r_2_1_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x600) | (tie_t << 9);
}

static unsigned
Field_dfp_fld_r_2_1_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 21) >> 30);
  return tie_t;
}

static void
Field_dfp_fld_r_2_1_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x600) | (tie_t << 9);
}

static unsigned
Field_dfp_fld_r_2_1_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 21) >> 30);
  return tie_t;
}

static void
Field_dfp_fld_r_2_1_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x600) | (tie_t << 9);
}

static unsigned
Field_dfp_fld_r_2_1_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 21) >> 30);
  return tie_t;
}

static void
Field_dfp_fld_r_2_1_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x600) | (tie_t << 9);
}

static unsigned
Field_dfp_fld_r_2_1_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 21) >> 30);
  return tie_t;
}

static void
Field_dfp_fld_r_2_1_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x600) | (tie_t << 9);
}

static unsigned
Field_dfp_fld_r_2_1_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 25) >> 30);
  return tie_t;
}

static void
Field_dfp_fld_r_2_1_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x60) | (tie_t << 5);
}

static unsigned
Field_dfp_fld_r_2_1_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 21) >> 30);
  return tie_t;
}

static void
Field_dfp_fld_r_2_1_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x600) | (tie_t << 9);
}

static unsigned
Field_dfp_fld_r_2_1_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 21) >> 30);
  return tie_t;
}

static void
Field_dfp_fld_r_2_1_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x600) | (tie_t << 9);
}

static unsigned
Field_dfp_fld_r_3_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_3_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_dfp_fld_r_3_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_3_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_dfp_fld_r_3_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_3_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_dfp_fld_r_3_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_3_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_dfp_fld_r_3_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_3_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_dfp_fld_r_3_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_3_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_dfp_fld_r_3_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_3_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_dfp_fld_r_3_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_3_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_dfp_fld_r_3_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_3_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_dfp_fld_r_3_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_3_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_dfp_fld_r_3_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_3_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_dfp_fld_r_3_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_r_3_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_dfp_fld_r_3_1_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_r_3_1_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_dfp_fld_r_3_1_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_r_3_1_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_dfp_fld_r_3_1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_r_3_1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_dfp_fld_r_3_1_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_r_3_1_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_dfp_fld_r_3_1_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_r_3_1_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_dfp_fld_r_3_1_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_r_3_1_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_dfp_fld_r_3_1_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_r_3_1_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_dfp_fld_r_3_1_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_r_3_1_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_dfp_fld_r_3_1_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_r_3_1_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_dfp_fld_r_3_1_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_r_3_1_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_dfp_fld_r_3_1_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_r_3_1_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_dfp_fld_r_3_1_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_r_3_1_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_dfp_fld_s_0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_s_0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_dfp_fld_s_0_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_s_0_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_dfp_fld_s_0_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_s_0_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_dfp_fld_s_0_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_s_0_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_dfp_fld_s_0_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_s_0_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_dfp_fld_s_0_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_s_0_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_dfp_fld_s_0_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_s_0_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_dfp_fld_s_0_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_s_0_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_dfp_fld_s_0_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_s_0_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_dfp_fld_s_0_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_s_0_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_dfp_fld_s_0_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_s_0_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_dfp_fld_s_0_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_s_0_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_dfp_fld_s_0_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_s_0_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_dfp_fld_s_0_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_s_0_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_dfp_fld_s_0_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_s_0_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_dfp_fld_s_0_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 31) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_s_0_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1) | (tie_t << 0);
}

static unsigned
Field_dfp_fld_s_3_1_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_s_3_1_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_dfp_fld_s_3_1_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_s_3_1_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_dfp_fld_s_3_1_Slot_ae_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_s_3_1_Slot_ae_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_dfp_fld_s_3_1_Slot_ae_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_s_3_1_Slot_ae_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_dfp_fld_s_3_1_Slot_ae2_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_s_3_1_Slot_ae2_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_dfp_fld_s_3_1_Slot_ae2_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_s_3_1_Slot_ae2_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_dfp_fld_s_3_1_Slot_ae3_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_s_3_1_Slot_ae3_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_dfp_fld_s_3_1_Slot_ae3_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_s_3_1_Slot_ae3_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_dfp_fld_s_3_1_Slot_ae4_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_s_3_1_Slot_ae4_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_dfp_fld_s_3_1_Slot_ae4_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_s_3_1_Slot_ae4_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_dfp_fld_s_3_1_Slot_ae5_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_s_3_1_Slot_ae5_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_dfp_fld_s_3_1_Slot_ae6_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_s_3_1_Slot_ae6_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_dfp_fld_s_3_1_Slot_ae6_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_s_3_1_Slot_ae6_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_dfp_fld_s_3_1_Slot_ae7_slot1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_s_3_1_Slot_ae7_slot1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_dfp_fld_s_3_1_Slot_ae7_slot0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 28) >> 29);
  return tie_t;
}

static void
Field_dfp_fld_s_3_1_Slot_ae7_slot0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe) | (tie_t << 1);
}

static unsigned
Field_dfp_fld_op2_0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_op2_0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_dfp_fld_op2_1_0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 10) >> 30);
  return tie_t;
}

static void
Field_dfp_fld_op2_1_0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300000) | (tie_t << 20);
}

static unsigned
Field_dfp_fld_op2_2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 9) >> 31);
  return tie_t;
}

static void
Field_dfp_fld_op2_2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x400000) | (tie_t << 22);
}

static unsigned
Field_bitindex_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 23) >> 27);
  return tie_t;
}

static void
Field_bitindex_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0) | (tie_t << 4);
}

static unsigned
Field_fld_sigmoid_q15_x_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_sigmoid_q15_x_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_sigmoid_q15_y_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_sigmoid_q15_y_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_sigmoid_fp32_x_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_sigmoid_fp32_x_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_sigmoid_fp32_y_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_sigmoid_fp32_y_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static void
Implicit_Field_set (xtensa_insnbuf insn ATTRIBUTE_UNUSED,
		    uint32 val ATTRIBUTE_UNUSED)
{
  /* Do nothing.  */
}

static unsigned
Implicit_Field_ar0_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_ar4_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 4;
}

static unsigned
Implicit_Field_ar8_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 8;
}

static unsigned
Implicit_Field_ar12_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 12;
}

static unsigned
Implicit_Field_mr0_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_mr1_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 1;
}

static unsigned
Implicit_Field_mr2_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 2;
}

static unsigned
Implicit_Field_mr3_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 3;
}

static unsigned
Implicit_Field_bt16_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_bs16_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_br16_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_brall_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

enum xtensa_field_id {
  FIELD_t,
  FIELD_bbi4,
  FIELD_bbi,
  FIELD_imm12,
  FIELD_imm8,
  FIELD_s,
  FIELD_imm12b,
  FIELD_imm16,
  FIELD_m,
  FIELD_n,
  FIELD_offset,
  FIELD_op0,
  FIELD_op1,
  FIELD_op2,
  FIELD_r,
  FIELD_r_disp,
  FIELD_r_3,
  FIELD_sa4,
  FIELD_sae4,
  FIELD_sae,
  FIELD_sal,
  FIELD_sargt,
  FIELD_sas4,
  FIELD_sas,
  FIELD_sr,
  FIELD_st,
  FIELD_thi3,
  FIELD_imm4,
  FIELD_mn,
  FIELD_i,
  FIELD_imm6lo,
  FIELD_imm6hi,
  FIELD_imm7lo,
  FIELD_imm7hi,
  FIELD_z,
  FIELD_imm6,
  FIELD_imm7,
  FIELD_r3,
  FIELD_rbit2,
  FIELD_rhi,
  FIELD_t3,
  FIELD_tbit2,
  FIELD_tlo,
  FIELD_w,
  FIELD_y,
  FIELD_x,
  FIELD_t2,
  FIELD_s2,
  FIELD_r2,
  FIELD_t4,
  FIELD_s4,
  FIELD_r4,
  FIELD_t8,
  FIELD_s8,
  FIELD_r8,
  FIELD_xt_wbr15_imm,
  FIELD_xt_wbr18_imm,
  FIELD_ae_fld_fhba4,
  FIELD_ae_fld_fhba4_2,
  FIELD_ae_fld_tp7,
  FIELD_ae_fld_osa32,
  FIELD_ae_fld_osa64,
  FIELD_ae_fld_imm2,
  FIELD_ae_fld_immls64,
  FIELD_ae_fld_immls64pos,
  FIELD_ae_fld_immls64half,
  FIELD_ae_fld_immls32,
  FIELD_ae_fld_immls16,
  FIELD_ae_fld_osa16,
  FIELD_Inst_15_12,
  FIELD_Inst_11_8,
  FIELD_Inst_7_4,
  FIELD_Inst_12,
  FIELD_Inst_7,
  FIELD_Inst_5_4,
  FIELD_Inst_7_6,
  FIELD_Inst_19_17,
  FIELD_Inst_19_18,
  FIELD_Inst_9_8,
  FIELD_Inst_4,
  FIELD_ae_fld_ls_v,
  FIELD_ae_fld_ls_uu,
  FIELD_ae_fld_ls_su,
  FIELD_ae_fld_ls_av,
  FIELD_ae_fld_ls_v1,
  FIELD_ae_fld_ls_v2,
  FIELD_ae_fld_cmpp_v0,
  FIELD_ae_fld_cmpp_v1,
  FIELD_ae_fld_cmpp_v,
  FIELD_ae_fld_uu_v,
  FIELD_ae_fld_uu_uu,
  FIELD_ae_fld_dr_to_ar_v0,
  FIELD_ae_fld_cmov_v,
  FIELD_ae_fld_cmov_v0,
  FIELD_ae_fld_pks_d,
  FIELD_ae_fld_pks_s,
  FIELD_ae_fld_shift_d,
  FIELD_ae_fld_shift_d0,
  FIELD_ae_fld_shift_sd,
  FIELD_ae_fld_dr_to_dr_v,
  FIELD_ae_fld_dr_to_dr_v0,
  FIELD_ae_fld_dr_to_dr_v1,
  FIELD_ae_fld_to_dr_v,
  FIELD_ae_fld_to_dr_v0,
  FIELD_fld_ae_immls64neg,
  FIELD_ae_fld_selimm,
  FIELD_ae_fld_selimm_N,
  FIELD_fld_ar_to_dr_imm,
  FIELD_ae_fld_arth_v,
  FIELD_ae_fld_arth_v0,
  FIELD_ae_fld_arth_v1,
  FIELD_ae_fld_ar_to_dr_v,
  FIELD_fld_Inst_23_12,
  FIELD_fld_Inst_23_16,
  FIELD_fld_Inst_7_7,
  FIELD_fld_Inst_11_8,
  FIELD_fld_Inst_13_8,
  FIELD_fld_Inst_12_8,
  FIELD_fld_Inst_9_8,
  FIELD_fld_Inst_4_4,
  FIELD_fld_Inst_5_4,
  FIELD_fld_Inst_7_4,
  FIELD_ae_fld_Inst16b_12,
  FIELD_ae_fld_Inst16b_15_13,
  FIELD_fld_ae4_slot0_7_4,
  FIELD_fld_ae2_slot0_11_4,
  FIELD_fld_ae2_slot0_7_4,
  FIELD_fld_ae4_slot0_27_24,
  FIELD_fld_ae2_slot0_11_9,
  FIELD_fld_ae2_slot0_28_27,
  FIELD_fld_ae4_slot0_27_23,
  FIELD_fld_ae2_slot0_11_8,
  FIELD_fld_ae5_slot0_21_8,
  FIELD_fld_ae4_slot1_13_8,
  FIELD_fld_ae3_slot1_19_8,
  FIELD_fld_ae4_slot1_13_11,
  FIELD_fld_ae5_slot0_3_0,
  FIELD_fld_ae3_slot0_3_0,
  FIELD_fld_ae3_slot1_3_0,
  FIELD_fld_ae2_slot0_3_0,
  FIELD_fld_ae2_slot1_3_0,
  FIELD_fld_ae_slot0_3_0,
  FIELD_fld_ae_slot1_3_0,
  FIELD_fld_ae5_slot0_21_12,
  FIELD_fld_ae4_slot1_13_12,
  FIELD_fld_ae3_slot0_21_12,
  FIELD_fld_ae3_slot1_19_12,
  FIELD_fld_ae2_slot1_19_12,
  FIELD_fld_ae_slot1_19_12,
  FIELD_fld_ae5_slot0_21_16,
  FIELD_fld_ae3_slot0_21_16,
  FIELD_fld_ae3_slot1_19_16,
  FIELD_fld_ae2_slot1_19_16,
  FIELD_fld_ae_slot1_19_16,
  FIELD_fld_ae5_slot0_21_17,
  FIELD_fld_ae3_slot0_21_17,
  FIELD_fld_ae3_slot1_19_17,
  FIELD_fld_ae2_slot0_28_17,
  FIELD_fld_ae2_slot1_19_17,
  FIELD_fld_ae_slot1_19_17,
  FIELD_fld_ae5_slot0_21_20,
  FIELD_fld_ae3_slot0_21_20,
  FIELD_fld_ae2_slot0_28_20,
  FIELD_fld_ae5_slot0_7_4,
  FIELD_fld_ae3_slot0_7_4,
  FIELD_fld_ae7_slot0_15_0,
  FIELD_fld_ae7_slot1_15_0,
  FIELD_fld_ae7_slot2_18_0,
  FIELD_fld_ae7_slot3_18_0,
  FIELD_fld_ae6_slot0_15_0,
  FIELD_fld_ae6_slot1_14_0,
  FIELD_fld_ae6_slot2_13_0,
  FIELD_fld_ae6_slot3_17_0,
  FIELD_fld_ae5_slot0_21_0,
  FIELD_fld_ae5_slot1_0_0,
  FIELD_fld_ae5_slot2_19_0,
  FIELD_fld_ae4_slot0_2_0,
  FIELD_fld_ae4_slot0_27_3,
  FIELD_fld_ae4_slot1_13_0,
  FIELD_fld_ae3_slot0_21_0,
  FIELD_fld_ae3_slot1_19_0,
  FIELD_fld_ae2_slot1_19_0,
  FIELD_fld_ae2_slot2_24_0,
  FIELD_fld_ae_slot0_20_0,
  FIELD_fld_ae_slot1_19_0,
  FIELD_fld_ae_slot2_20_0,
  FIELD_fld_ae3_slot1_7_4,
  FIELD_fld_ae5_slot0_21_13,
  FIELD_fld_ae3_slot0_21_13,
  FIELD_fld_ae3_slot1_19_13,
  FIELD_fld_ae2_slot0_28_13,
  FIELD_fld_ae2_slot1_19_13,
  FIELD_fld_ae_slot0_20_15,
  FIELD_fld_ae_slot1_19_13,
  FIELD_fld_ae_slot0_20_13,
  FIELD_fld_ae3_slot1_19_4,
  FIELD_fld_ae2_slot0_28_4,
  FIELD_fld_ae2_slot1_19_4,
  FIELD_fld_ae_slot0_20_4,
  FIELD_fld_ae_slot1_19_4,
  FIELD_fld_ae3_slot1_7_1,
  FIELD_fld_ae2_slot1_19_9,
  FIELD_fld_ae_slot1_19_9,
  FIELD_fld_ae2_slot0_3_2,
  FIELD_fld_ae_slot0_3_2,
  FIELD_fld_ae2_slot0_0_0,
  FIELD_fld_ae_slot0_0_0,
  FIELD_fld_ae2_slot0_28_12,
  FIELD_fld_ae_slot0_20_12,
  FIELD_fld_ae7_slot0_7_4,
  FIELD_fld_ae7_slot1_7_4,
  FIELD_fld_ae5_slot0_11_8,
  FIELD_fld_ae3_slot0_11_8,
  FIELD_fld_ae5_slot0_21_6,
  FIELD_fld_ae_sem_loads_stores_end,
  FIELD_fld_ae2_slot1_7_4,
  FIELD_fld_ae_slot1_7_4,
  FIELD_fld_ae2_slot0_28_8,
  FIELD_fld_ae2_slot1_19_8,
  FIELD_fld_ae_slot0_20_8,
  FIELD_fld_ae_slot1_19_8,
  FIELD_fld_ae6_slot1_14_12,
  FIELD_fld_ae6_slot2_3_0,
  FIELD_fld_ae_sem_arithmetic_ds,
  FIELD_fld_ae6_slot3_17_16,
  FIELD_fld_ae_slot3_20_0,
  FIELD_fld_ae_sem_rng_d,
  FIELD_fld_ae_slot3_3_0,
  FIELD_fld_ae3_slot0_8_8,
  FIELD_fld_ae_slot0_8_8,
  FIELD_fld_ae_slot3_1_0,
  FIELD_fld_ae2_slot0_11_0,
  FIELD_fld_ae_slot0_11_0,
  FIELD_fld_ae2_slot1_7_0,
  FIELD_fld_ae_slot0_7_0,
  FIELD_fld_ae2_slot0_28_16,
  FIELD_fld_ae_slot0_20_16,
  FIELD_fld_ae_slot3_20_8,
  FIELD_fld_ae2_slot0_9_4,
  FIELD_fld_ae_slot0_9_4,
  FIELD_fld_ae_sem_mul_x2_S1_d1,
  FIELD_fld_ae_sem_mul_x2_S1_d0,
  FIELD_fld_ae_sem_mul_x2_S1_q0,
  FIELD_fld_ae_sem_mul_x2_S2_d1,
  FIELD_fld_ae_sem_mul_x2_S2_d0,
  FIELD_fld_ae_sem_mul_x2_S2_q0,
  FIELD_fld_ae_sem_mul_x4_d1,
  FIELD_fld_ae_sem_mul_x4_d0,
  FIELD_fld_ae_sem_mul_x4_q0,
  FIELD_fld_ae6_slot2_13_12,
  FIELD_fld_ae_sem_mul_x4_q1,
  FIELD_fld_ae2_slot2_24_16,
  FIELD_fld_ae_sem_mul_x4_d2,
  FIELD_fld_ae2_slot2_24_20,
  FIELD_fld_ae7_slot2_18_16,
  FIELD_fld_ae2_slot2_7_4,
  FIELD_fld_ae7_slot3_18_16,
  FIELD_fld_ae_sem_mul_x2_S1_d2,
  FIELD_fld_ae_sem_mul_x2_S1_v1,
  FIELD_fld_ae_sem_mul_x2_S2_d2,
  FIELD_fld_ae_sem_mul_x2_S2_v1,
  FIELD_fld_ae5_slot2_19_12,
  FIELD_fld_ae_slot2_20_12,
  FIELD_fld_ae_slot3_20_12,
  FIELD_fld_ae5_slot0_21_4,
  FIELD_fld_ae_sem_ep_ls_ei,
  FIELD_fld_ae3_slot0_3_2,
  FIELD_fld_ae3_slot1_3_2,
  FIELD_fld_ae_sem_ep_ls_ar_s,
  FIELD_fld_ae_sem_ep_ls_eo,
  FIELD_fld_ae_slot2_7_0,
  FIELD_fld_ae_slot3_11_4,
  FIELD_fld_ae_sem_arithmetic_ep,
  FIELD_fld_ae_slot2_3_0,
  FIELD_fld_ae_sem_arithmetic_ep1,
  FIELD_fld_ae_slot2_20_10,
  FIELD_fld_ae_sem_mul_x2_S1_acc_ep,
  FIELD_fld_ae_slot2_20_14,
  FIELD_fld_ae_sem_mul_x2_S2_acc_ep,
  FIELD_fld_ae_slot3_20_14,
  FIELD_fld_ae_sem_shift_e,
  FIELD_fld_ae_slot3_20_16,
  FIELD_fld_ae_sem_shift_i8,
  FIELD_fld_ae_slot3_11_11,
  FIELD_fld_ae_sem_arithmetic_e,
  FIELD_fld_ae_slot2_9_8,
  FIELD_fld_ae_slot3_7_4,
  FIELD_fld_ae_slot2_20_8,
  FIELD_fld_ae_slot0_11_8,
  FIELD_fld_ae_slot0_11_4,
  FIELD_fld_ae_slot3_20_10,
  FIELD_fld_ae_slot2_7_4,
  FIELD_fld_ae2_slot0_8_4,
  FIELD_fld_ae_slot0_8_4,
  FIELD_fld_ae5_slot0_7_6,
  FIELD_fld_ae3_slot0_5_4,
  FIELD_fld_ae3_slot1_7_6,
  FIELD_fld_ae2_slot1_7_6,
  FIELD_fld_ae_slot1_7_6,
  FIELD_fld_ae3_slot0_5_0,
  FIELD_fld_ae3_slot0_4_0,
  FIELD_fld_ae_slot0_4_0,
  FIELD_fld_ae3_slot0_9_8,
  FIELD_fld_ae_slot0_9_8,
  FIELD_fld_ae7_slot0_15_12,
  FIELD_fld_ae7_slot1_15_12,
  FIELD_fld_ae5_slot0_5_4,
  FIELD_fld_ae5_slot0_21_14,
  FIELD_fld_ae3_slot0_7_6,
  FIELD_fld_ae3_slot0_21_14,
  FIELD_fld_ae7_slot0_7_7,
  FIELD_fld_ae7_slot1_7_7,
  FIELD_fld_ae6_slot1_7_7,
  FIELD_fld_ae5_slot0_7_7,
  FIELD_fld_ae3_slot0_5_5,
  FIELD_fld_ae3_slot1_7_7,
  FIELD_fld_ae2_slot0_4_4,
  FIELD_fld_ae2_slot1_7_7,
  FIELD_fld_ae_slot0_4_4,
  FIELD_fld_ae_slot1_7_7,
  FIELD_fld_ae6_slot0_15_12,
  FIELD_fld_ae6_slot0_7_7,
  FIELD_fld_ae7_slot0_7_6,
  FIELD_fld_ae6_slot1_7_6,
  FIELD_fld_ae6_slot1_14_6,
  FIELD_fld_ae5_slot0_3_2,
  FIELD_fld_ae3_slot0_5_2,
  FIELD_fld_ae2_slot0_5_2,
  FIELD_fld_ae_slot0_5_2,
  FIELD_fld_ae3_slot0_21_2,
  FIELD_fld_ae2_slot0_5_0,
  FIELD_fld_ae_slot3_0_0,
  FIELD_fld_ae_slot2_3_2,
  FIELD_fld_ae_slot0_7_4,
  FIELD_fld_ae2_slot0_7_0,
  FIELD_fld_ae2_slot0_7_7,
  FIELD_fld_ae_slot0_7_7,
  FIELD_fld_ae_slot3_20_13,
  FIELD_fld_ae2_slot0_5_4,
  FIELD_fld_ae_slot0_5_4,
  FIELD_fld_ae_slot3_13_12,
  FIELD_fld_ae3_slot0_21_8,
  FIELD_fld_ae_slot0_20_14,
  FIELD_fld_ae_slot0_5_0,
  FIELD_fld_ae3_slot0_21_4,
  FIELD_fld_ae_sem_dr_to_ar_vr,
  FIELD_fld_ae_sem_cmov_bt,
  FIELD_fld_ae_sem_cmov_arr,
  FIELD_fld_vfpu2_sem_mov_vt,
  FIELD_fld_vfpu2_sem_mov_vr,
  FIELD_fld_vfpu2_sem_spfma_vt,
  FIELD_fld_vfpu2_sem_spfma_vs,
  FIELD_fld_vfpu2_sem_spfma_vr,
  FIELD_fld_vfpu2_sem_spmisc_brt,
  FIELD_fld_vfpu2_sem_spmisc_vs,
  FIELD_fld_vfpu2_sem_spmisc_vr,
  FIELD_fld_vfpu2_sem_mov_i_imm4,
  FIELD_fld_vfpu2_sem_sp32cvt_vr,
  FIELD_fld_vfpu2_sem_sp32cvt_vt,
  FIELD_fld_vfpu2_sem_sp32cvt_i_imm5,
  FIELD_fld_vfpu2_sem_sp32cvt_arr,
  FIELD_fld_ae_slot0_11_11,
  FIELD_fld_vfpu2_sem_spmisc_vt,
  FIELD_fld_vfpu2_sem_spmisc_vsM,
  FIELD_fld_ae_slot2_20_18,
  FIELD_fld_vfpu2_sem_spmisc_vtM,
  FIELD_fld_vfpu2_sem_spfma_i_imm1,
  FIELD_fld_vfpu2_sem_spfma_i_imm3,
  FIELD_fld_ae_slot2_20_13,
  FIELD_fld_ae_slot3_20_15,
  FIELD_fld_ae_slot2_20_15,
  FIELD_fld_ae_sem_movfpstate_v,
  FIELD_fld_ae_slot2_20_4,
  FIELD_dfp_fld_op1,
  FIELD_dfp_fld_op2,
  FIELD_dfp_fld_r_0,
  FIELD_dfp_fld_r_2_1,
  FIELD_dfp_fld_r_3,
  FIELD_dfp_fld_r_3_1,
  FIELD_dfp_fld_s_0,
  FIELD_dfp_fld_s_3_1,
  FIELD_dfp_fld_op2_0,
  FIELD_dfp_fld_op2_1_0,
  FIELD_dfp_fld_op2_2,
  FIELD_dfp_fld_op2_3,
  FIELD_dfp_fld_op2_3_2,
  FIELD_dfp_fld_op2_3_1,
  FIELD_bitindex,
  FIELD_s3to1,
  FIELD_fld_SIGMOID_Q15_x,
  FIELD_fld_SIGMOID_Q15_y,
  FIELD_fld_Inst_3_0,
  FIELD_fld_SIGMOID_FP32_x,
  FIELD_fld_SIGMOID_FP32_y,
  FIELD__ar0,
  FIELD__ar4,
  FIELD__ar8,
  FIELD__ar12,
  FIELD__mr0,
  FIELD__mr1,
  FIELD__mr2,
  FIELD__mr3,
  FIELD__bt16,
  FIELD__bs16,
  FIELD__br16,
  FIELD__brall
};


/* Functional units.  */

static xtensa_funcUnit_internal funcUnits[] = {
  {"XT_LOADSTORE_UNIT", 2},
  { "mul_function", 1 },
  { "mul_S2_function", 1 },
  { "ae_add32x27", 1 },
  { "ae_shift32x4", 1 },
  { "ae_shift32x5", 1 },
  { "ae_leftshift32x5", 2 },
  { "ae_mulpp_32x32x2_1", 1 },
  { "ae_mulpp_32x32x2_2", 1 }
};

enum xtensa_funcUnit_id {
  FUNCUNIT_XT_LOADSTORE_UNIT,
  FUNCUNIT_mul_function,
  FUNCUNIT_mul_S2_function,
  FUNCUNIT_ae_add32x27,
  FUNCUNIT_ae_shift32x4,
  FUNCUNIT_ae_shift32x5,
  FUNCUNIT_ae_leftshift32x5,
  FUNCUNIT_ae_mulpp_32x32x2_1,
  FUNCUNIT_ae_mulpp_32x32x2_2
};


/* Register files.  */

enum xtensa_regfile_id {
  REGFILE_AR,
  REGFILE_MR,
  REGFILE_BR,
  REGFILE_AE_DR,
  REGFILE_AE_VALIGN,
  REGFILE_AE_EP,
  REGFILE_BR2,
  REGFILE_BR4,
  REGFILE_BR8,
  REGFILE_BR16
};

static xtensa_regfile_internal regfiles[] = {
  { "AR", "a", REGFILE_AR, 32, 32 },
  { "MR", "m", REGFILE_MR, 32, 4 },
  { "BR", "b", REGFILE_BR, 1, 16 },
  { "AE_DR", "aed", REGFILE_AE_DR, 64, 16 },
  { "AE_VALIGN", "u", REGFILE_AE_VALIGN, 64, 4 },
  { "AE_EP", "aep", REGFILE_AE_EP, 8, 4 },
  { "BR2", "b", REGFILE_BR, 2, 8 },
  { "BR4", "b", REGFILE_BR, 4, 4 },
  { "BR8", "b", REGFILE_BR, 8, 2 },
  { "BR16", "b", REGFILE_BR, 16, 1 }
};


/* Interfaces.  */

static xtensa_interface_internal interfaces[] = {
  { "ERI_RD_Out", 14, 0, 0, 'o' },
  { "ERI_RD_In", 32, 0, 1, 'i' },
  { "ERI_RD_Rdy", 1, 0, 0, 'i' },
  { "ERI_WR_Out", 46, 0, 2, 'o' },
  { "ERI_WR_In", 1, 0, 3, 'i' },
  { "IMPWIRE", 32, 0, 4, 'i' }
};

enum xtensa_interface_id {
  INTERFACE_ERI_RD_Out,
  INTERFACE_ERI_RD_In,
  INTERFACE_ERI_RD_Rdy,
  INTERFACE_ERI_WR_Out,
  INTERFACE_ERI_WR_In,
  INTERFACE_IMPWIRE
};


/* Constant tables.  */

/* constant table ai4c */
static const unsigned CONST_TBL_ai4c_0[] = {
  0xffffffff,
  0x1,
  0x2,
  0x3,
  0x4,
  0x5,
  0x6,
  0x7,
  0x8,
  0x9,
  0xa,
  0xb,
  0xc,
  0xd,
  0xe,
  0xf,
  0
};

/* constant table b4c */
static const unsigned CONST_TBL_b4c_0[] = {
  0xffffffff,
  0x1,
  0x2,
  0x3,
  0x4,
  0x5,
  0x6,
  0x7,
  0x8,
  0xa,
  0xc,
  0x10,
  0x20,
  0x40,
  0x80,
  0x100,
  0
};

/* constant table b4cu */
static const unsigned CONST_TBL_b4cu_0[] = {
  0x8000,
  0x10000,
  0x2,
  0x3,
  0x4,
  0x5,
  0x6,
  0x7,
  0x8,
  0xa,
  0xc,
  0x10,
  0x20,
  0x40,
  0x80,
  0x100,
  0
};

/* constant table bitmask8 */
static const unsigned CONST_TBL_bitmask8_0[] = {
  0 & 0xff,
  0x1 & 0xff,
  0x3 & 0xff,
  0x7 & 0xff,
  0xf & 0xff,
  0x1f & 0xff,
  0x3f & 0xff,
  0x7f & 0xff,
  0
};

/* constant table ae_ripimmtable */
static const unsigned CONST_TBL_ae_ripimmtable_0[] = {
  0xffffffe0,
  0xffffffe8,
  0xfffffff0,
  0xfffffff8,
  0
};

/* constant table ae_slai72table */
static const unsigned CONST_TBL_ae_slai72table_0[] = {
  0x1,
  0x2,
  0x3,
  0x4,
  0x5,
  0x6,
  0x7,
  0x8,
  0
};

/* constant table ae_seliencode */
static const unsigned CONST_TBL_ae_seliencode_0[] = {
  0x4e5 & 0xfff,
  0x65 & 0xfff,
  0x77 & 0xfff,
  0x4f7 & 0xfff,
  0x72e & 0xfff,
  0x29c & 0xfff,
  0xaf & 0xfff,
  0xa6 & 0xfff,
  0x2ef & 0xfff,
  0x10d & 0xfff,
  0x599 & 0xfff,
  0x59f & 0xfff,
  0xb3e & 0xfff,
  0x18f & 0xfff,
  0x51d & 0xfff,
  0xa6 & 0xfff,
  0
};

/* constant table xd_recip0_table128_8 */
static const unsigned CONST_TBL_xd_recip0_table128_8_0[] = {
  0xff & 0xff,
  0xfd & 0xff,
  0xfb & 0xff,
  0xf9 & 0xff,
  0xf7 & 0xff,
  0xf5 & 0xff,
  0xf4 & 0xff,
  0xf2 & 0xff,
  0xf0 & 0xff,
  0xee & 0xff,
  0xed & 0xff,
  0xeb & 0xff,
  0xe9 & 0xff,
  0xe8 & 0xff,
  0xe6 & 0xff,
  0xe4 & 0xff,
  0xe3 & 0xff,
  0xe1 & 0xff,
  0xe0 & 0xff,
  0xde & 0xff,
  0xdd & 0xff,
  0xdb & 0xff,
  0xda & 0xff,
  0xd8 & 0xff,
  0xd7 & 0xff,
  0xd5 & 0xff,
  0xd4 & 0xff,
  0xd3 & 0xff,
  0xd1 & 0xff,
  0xd0 & 0xff,
  0xcf & 0xff,
  0xcd & 0xff,
  0xcc & 0xff,
  0xcb & 0xff,
  0xca & 0xff,
  0xc8 & 0xff,
  0xc7 & 0xff,
  0xc6 & 0xff,
  0xc5 & 0xff,
  0xc4 & 0xff,
  0xc2 & 0xff,
  0xc1 & 0xff,
  0xc0 & 0xff,
  0xbf & 0xff,
  0xbe & 0xff,
  0xbd & 0xff,
  0xbc & 0xff,
  0xbb & 0xff,
  0xba & 0xff,
  0xb9 & 0xff,
  0xb8 & 0xff,
  0xb7 & 0xff,
  0xb6 & 0xff,
  0xb5 & 0xff,
  0xb4 & 0xff,
  0xb3 & 0xff,
  0xb2 & 0xff,
  0xb1 & 0xff,
  0xb0 & 0xff,
  0xaf & 0xff,
  0xae & 0xff,
  0xad & 0xff,
  0xac & 0xff,
  0xab & 0xff,
  0xaa & 0xff,
  0xa9 & 0xff,
  0xa8 & 0xff,
  0xa8 & 0xff,
  0xa7 & 0xff,
  0xa6 & 0xff,
  0xa5 & 0xff,
  0xa4 & 0xff,
  0xa3 & 0xff,
  0xa3 & 0xff,
  0xa2 & 0xff,
  0xa1 & 0xff,
  0xa0 & 0xff,
  0x9f & 0xff,
  0x9f & 0xff,
  0x9e & 0xff,
  0x9d & 0xff,
  0x9c & 0xff,
  0x9c & 0xff,
  0x9b & 0xff,
  0x9a & 0xff,
  0x99 & 0xff,
  0x99 & 0xff,
  0x98 & 0xff,
  0x97 & 0xff,
  0x97 & 0xff,
  0x96 & 0xff,
  0x95 & 0xff,
  0x95 & 0xff,
  0x94 & 0xff,
  0x93 & 0xff,
  0x93 & 0xff,
  0x92 & 0xff,
  0x91 & 0xff,
  0x91 & 0xff,
  0x90 & 0xff,
  0x8f & 0xff,
  0x8f & 0xff,
  0x8e & 0xff,
  0x8e & 0xff,
  0x8d & 0xff,
  0x8c & 0xff,
  0x8c & 0xff,
  0x8b & 0xff,
  0x8b & 0xff,
  0x8a & 0xff,
  0x89 & 0xff,
  0x89 & 0xff,
  0x88 & 0xff,
  0x88 & 0xff,
  0x87 & 0xff,
  0x87 & 0xff,
  0x86 & 0xff,
  0x85 & 0xff,
  0x85 & 0xff,
  0x84 & 0xff,
  0x84 & 0xff,
  0x83 & 0xff,
  0x83 & 0xff,
  0x82 & 0xff,
  0x82 & 0xff,
  0x81 & 0xff,
  0x81 & 0xff,
  0x81 & 0xff,
  0
};

/* constant table xd_rsqrt0_table128_8 */
static const unsigned CONST_TBL_xd_rsqrt0_table128_8_0[] = {
  0xb4 & 0xff,
  0xb3 & 0xff,
  0xb2 & 0xff,
  0xb0 & 0xff,
  0xaf & 0xff,
  0xae & 0xff,
  0xac & 0xff,
  0xab & 0xff,
  0xaa & 0xff,
  0xa9 & 0xff,
  0xa8 & 0xff,
  0xa7 & 0xff,
  0xa6 & 0xff,
  0xa5 & 0xff,
  0xa3 & 0xff,
  0xa2 & 0xff,
  0xa1 & 0xff,
  0xa0 & 0xff,
  0x9f & 0xff,
  0x9e & 0xff,
  0x9e & 0xff,
  0x9d & 0xff,
  0x9c & 0xff,
  0x9b & 0xff,
  0x9a & 0xff,
  0x99 & 0xff,
  0x98 & 0xff,
  0x97 & 0xff,
  0x97 & 0xff,
  0x96 & 0xff,
  0x95 & 0xff,
  0x94 & 0xff,
  0x93 & 0xff,
  0x93 & 0xff,
  0x92 & 0xff,
  0x91 & 0xff,
  0x90 & 0xff,
  0x90 & 0xff,
  0x8f & 0xff,
  0x8e & 0xff,
  0x8e & 0xff,
  0x8d & 0xff,
  0x8c & 0xff,
  0x8c & 0xff,
  0x8b & 0xff,
  0x8a & 0xff,
  0x8a & 0xff,
  0x89 & 0xff,
  0x89 & 0xff,
  0x88 & 0xff,
  0x87 & 0xff,
  0x87 & 0xff,
  0x86 & 0xff,
  0x86 & 0xff,
  0x85 & 0xff,
  0x84 & 0xff,
  0x84 & 0xff,
  0x83 & 0xff,
  0x83 & 0xff,
  0x82 & 0xff,
  0x82 & 0xff,
  0x81 & 0xff,
  0x81 & 0xff,
  0x80 & 0xff,
  0xff & 0xff,
  0xfd & 0xff,
  0xfb & 0xff,
  0xf9 & 0xff,
  0xf7 & 0xff,
  0xf6 & 0xff,
  0xf4 & 0xff,
  0xf2 & 0xff,
  0xf1 & 0xff,
  0xef & 0xff,
  0xed & 0xff,
  0xec & 0xff,
  0xea & 0xff,
  0xe9 & 0xff,
  0xe7 & 0xff,
  0xe6 & 0xff,
  0xe4 & 0xff,
  0xe3 & 0xff,
  0xe1 & 0xff,
  0xe0 & 0xff,
  0xdf & 0xff,
  0xdd & 0xff,
  0xdc & 0xff,
  0xdb & 0xff,
  0xda & 0xff,
  0xd8 & 0xff,
  0xd7 & 0xff,
  0xd6 & 0xff,
  0xd5 & 0xff,
  0xd4 & 0xff,
  0xd3 & 0xff,
  0xd2 & 0xff,
  0xd0 & 0xff,
  0xcf & 0xff,
  0xce & 0xff,
  0xcd & 0xff,
  0xcc & 0xff,
  0xcb & 0xff,
  0xca & 0xff,
  0xc9 & 0xff,
  0xc8 & 0xff,
  0xc7 & 0xff,
  0xc6 & 0xff,
  0xc6 & 0xff,
  0xc5 & 0xff,
  0xc4 & 0xff,
  0xc3 & 0xff,
  0xc2 & 0xff,
  0xc1 & 0xff,
  0xc0 & 0xff,
  0xbf & 0xff,
  0xbf & 0xff,
  0xbe & 0xff,
  0xbd & 0xff,
  0xbc & 0xff,
  0xbb & 0xff,
  0xbb & 0xff,
  0xba & 0xff,
  0xb9 & 0xff,
  0xb8 & 0xff,
  0xb8 & 0xff,
  0xb7 & 0xff,
  0xb6 & 0xff,
  0xb5 & 0xff,
  0
};

/* constant table vfpu2_table_mulmux */
static const unsigned CONST_TBL_vfpu2_table_mulmux_0[] = {
  0xe & 0x3f,
  0x1e & 0x3f,
  0
};

/* constant table vfpu2_table_maddmux */
static const unsigned CONST_TBL_vfpu2_table_maddmux_0[] = {
  0xe & 0x3f,
  0x21 & 0x3f,
  0x3e & 0x3f,
  0x11 & 0x3f,
  0x1e & 0x3f,
  0x1 & 0x3f,
  0x2e & 0x3f,
  0x31 & 0x3f,
  0
};


/* Instruction operands.  */

static int
OperandSem_opnd_sem_MR_0_decode (uint32 *valp)
{
  *valp += 2;
  return 0;
}

static int
OperandSem_opnd_sem_MR_0_encode (uint32 *valp)
{
  int error;
  error = ((*valp & ~0x3) != 0) || ((*valp & 0x2) == 0);
  *valp = *valp & 1;
  return error;
}

static int
OperandSem_opnd_sem_soffsetx4_decode (uint32 *valp)
{
  unsigned soffsetx4_out_0;
  unsigned soffsetx4_in_0;
  soffsetx4_in_0 = *valp & 0x3ffff;
  soffsetx4_out_0 = 0x4 + ((((int) soffsetx4_in_0 << 14) >> 14) << 2);
  *valp = soffsetx4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_soffsetx4_encode (uint32 *valp)
{
  unsigned soffsetx4_in_0;
  unsigned soffsetx4_out_0;
  soffsetx4_out_0 = *valp;
  soffsetx4_in_0 = ((soffsetx4_out_0 - 0x4) >> 2) & 0x3ffff;
  *valp = soffsetx4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_immr_decode (uint32 *valp)
{
  unsigned immr_out_0;
  unsigned immr_in_0;
  immr_in_0 = *valp & 0xf;
  immr_out_0 = immr_in_0;
  *valp = immr_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_immr_encode (uint32 *valp)
{
  unsigned immr_in_0;
  unsigned immr_out_0;
  immr_out_0 = *valp;
  immr_in_0 = (immr_out_0 & 0xf);
  *valp = immr_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm12x8_decode (uint32 *valp)
{
  unsigned uimm12x8_out_0;
  unsigned uimm12x8_in_0;
  uimm12x8_in_0 = *valp & 0xfff;
  uimm12x8_out_0 = uimm12x8_in_0 << 3;
  *valp = uimm12x8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm12x8_encode (uint32 *valp)
{
  unsigned uimm12x8_in_0;
  unsigned uimm12x8_out_0;
  uimm12x8_out_0 = *valp;
  uimm12x8_in_0 = ((uimm12x8_out_0 >> 3) & 0xfff);
  *valp = uimm12x8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm4_decode (uint32 *valp)
{
  unsigned simm4_out_0;
  unsigned simm4_in_0;
  simm4_in_0 = *valp & 0xf;
  simm4_out_0 = ((int) simm4_in_0 << 28) >> 28;
  *valp = simm4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm4_encode (uint32 *valp)
{
  unsigned simm4_in_0;
  unsigned simm4_out_0;
  simm4_out_0 = *valp;
  simm4_in_0 = (simm4_out_0 & 0xf);
  *valp = simm4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_AR_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_AR_0_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_0_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_AR_4_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_4_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_AR_8_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_8_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_AR_12_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_12_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_AR_entry_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_entry_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_immrx4_decode (uint32 *valp)
{
  unsigned immrx4_out_0;
  unsigned immrx4_in_0;
  immrx4_in_0 = *valp & 0xf;
  immrx4_out_0 = (((0xfffffff) << 4) | immrx4_in_0) << 2;
  *valp = immrx4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_immrx4_encode (uint32 *valp)
{
  unsigned immrx4_in_0;
  unsigned immrx4_out_0;
  immrx4_out_0 = *valp;
  immrx4_in_0 = ((immrx4_out_0 >> 2) & 0xf);
  *valp = immrx4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_lsi4x4_decode (uint32 *valp)
{
  unsigned lsi4x4_out_0;
  unsigned lsi4x4_in_0;
  lsi4x4_in_0 = *valp & 0xf;
  lsi4x4_out_0 = lsi4x4_in_0 << 2;
  *valp = lsi4x4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_lsi4x4_encode (uint32 *valp)
{
  unsigned lsi4x4_in_0;
  unsigned lsi4x4_out_0;
  lsi4x4_out_0 = *valp;
  lsi4x4_in_0 = ((lsi4x4_out_0 >> 2) & 0xf);
  *valp = lsi4x4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm7_decode (uint32 *valp)
{
  unsigned simm7_out_0;
  unsigned simm7_in_0;
  simm7_in_0 = *valp & 0x7f;
  simm7_out_0 = ((((-((((simm7_in_0 >> 6) & 1)) & (((simm7_in_0 >> 5) & 1)))) & 0x1ffffff)) << 7) | simm7_in_0;
  *valp = simm7_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm7_encode (uint32 *valp)
{
  unsigned simm7_in_0;
  unsigned simm7_out_0;
  simm7_out_0 = *valp;
  simm7_in_0 = (simm7_out_0 & 0x7f);
  *valp = simm7_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm6_decode (uint32 *valp)
{
  unsigned uimm6_out_0;
  unsigned uimm6_in_0;
  uimm6_in_0 = *valp & 0x3f;
  uimm6_out_0 = 0x4 + (((0) << 6) | uimm6_in_0);
  *valp = uimm6_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm6_encode (uint32 *valp)
{
  unsigned uimm6_in_0;
  unsigned uimm6_out_0;
  uimm6_out_0 = *valp;
  uimm6_in_0 = (uimm6_out_0 - 0x4) & 0x3f;
  *valp = uimm6_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ai4const_decode (uint32 *valp)
{
  unsigned ai4const_out_0;
  unsigned ai4const_in_0;
  ai4const_in_0 = *valp & 0xf;
  ai4const_out_0 = CONST_TBL_ai4c_0[ai4const_in_0 & 0xf];
  *valp = ai4const_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ai4const_encode (uint32 *valp)
{
  unsigned ai4const_in_0;
  unsigned ai4const_out_0;
  ai4const_out_0 = *valp;
  switch (ai4const_out_0)
    {
    case 0xffffffff: ai4const_in_0 = 0; break;
    case 0x1: ai4const_in_0 = 0x1; break;
    case 0x2: ai4const_in_0 = 0x2; break;
    case 0x3: ai4const_in_0 = 0x3; break;
    case 0x4: ai4const_in_0 = 0x4; break;
    case 0x5: ai4const_in_0 = 0x5; break;
    case 0x6: ai4const_in_0 = 0x6; break;
    case 0x7: ai4const_in_0 = 0x7; break;
    case 0x8: ai4const_in_0 = 0x8; break;
    case 0x9: ai4const_in_0 = 0x9; break;
    case 0xa: ai4const_in_0 = 0xa; break;
    case 0xb: ai4const_in_0 = 0xb; break;
    case 0xc: ai4const_in_0 = 0xc; break;
    case 0xd: ai4const_in_0 = 0xd; break;
    case 0xe: ai4const_in_0 = 0xe; break;
    default: ai4const_in_0 = 0xf; break;
    }
  *valp = ai4const_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4const_decode (uint32 *valp)
{
  unsigned b4const_out_0;
  unsigned b4const_in_0;
  b4const_in_0 = *valp & 0xf;
  b4const_out_0 = CONST_TBL_b4c_0[b4const_in_0 & 0xf];
  *valp = b4const_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4const_encode (uint32 *valp)
{
  unsigned b4const_in_0;
  unsigned b4const_out_0;
  b4const_out_0 = *valp;
  switch (b4const_out_0)
    {
    case 0xffffffff: b4const_in_0 = 0; break;
    case 0x1: b4const_in_0 = 0x1; break;
    case 0x2: b4const_in_0 = 0x2; break;
    case 0x3: b4const_in_0 = 0x3; break;
    case 0x4: b4const_in_0 = 0x4; break;
    case 0x5: b4const_in_0 = 0x5; break;
    case 0x6: b4const_in_0 = 0x6; break;
    case 0x7: b4const_in_0 = 0x7; break;
    case 0x8: b4const_in_0 = 0x8; break;
    case 0xa: b4const_in_0 = 0x9; break;
    case 0xc: b4const_in_0 = 0xa; break;
    case 0x10: b4const_in_0 = 0xb; break;
    case 0x20: b4const_in_0 = 0xc; break;
    case 0x40: b4const_in_0 = 0xd; break;
    case 0x80: b4const_in_0 = 0xe; break;
    default: b4const_in_0 = 0xf; break;
    }
  *valp = b4const_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4constu_decode (uint32 *valp)
{
  unsigned b4constu_out_0;
  unsigned b4constu_in_0;
  b4constu_in_0 = *valp & 0xf;
  b4constu_out_0 = CONST_TBL_b4cu_0[b4constu_in_0 & 0xf];
  *valp = b4constu_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4constu_encode (uint32 *valp)
{
  unsigned b4constu_in_0;
  unsigned b4constu_out_0;
  b4constu_out_0 = *valp;
  switch (b4constu_out_0)
    {
    case 0x8000: b4constu_in_0 = 0; break;
    case 0x10000: b4constu_in_0 = 0x1; break;
    case 0x2: b4constu_in_0 = 0x2; break;
    case 0x3: b4constu_in_0 = 0x3; break;
    case 0x4: b4constu_in_0 = 0x4; break;
    case 0x5: b4constu_in_0 = 0x5; break;
    case 0x6: b4constu_in_0 = 0x6; break;
    case 0x7: b4constu_in_0 = 0x7; break;
    case 0x8: b4constu_in_0 = 0x8; break;
    case 0xa: b4constu_in_0 = 0x9; break;
    case 0xc: b4constu_in_0 = 0xa; break;
    case 0x10: b4constu_in_0 = 0xb; break;
    case 0x20: b4constu_in_0 = 0xc; break;
    case 0x40: b4constu_in_0 = 0xd; break;
    case 0x80: b4constu_in_0 = 0xe; break;
    default: b4constu_in_0 = 0xf; break;
    }
  *valp = b4constu_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_immt_decode (uint32 *valp)
{
  unsigned immt_out_0;
  unsigned immt_in_0;
  immt_in_0 = *valp & 0xf;
  immt_out_0 = immt_in_0;
  *valp = immt_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_immt_encode (uint32 *valp)
{
  unsigned immt_in_0;
  unsigned immt_out_0;
  immt_out_0 = *valp;
  immt_in_0 = immt_out_0 & 0xf;
  *valp = immt_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8_decode (uint32 *valp)
{
  unsigned uimm8_out_0;
  unsigned uimm8_in_0;
  uimm8_in_0 = *valp & 0xff;
  uimm8_out_0 = uimm8_in_0;
  *valp = uimm8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8_encode (uint32 *valp)
{
  unsigned uimm8_in_0;
  unsigned uimm8_out_0;
  uimm8_out_0 = *valp;
  uimm8_in_0 = (uimm8_out_0 & 0xff);
  *valp = uimm8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x2_decode (uint32 *valp)
{
  unsigned uimm8x2_out_0;
  unsigned uimm8x2_in_0;
  uimm8x2_in_0 = *valp & 0xff;
  uimm8x2_out_0 = uimm8x2_in_0 << 1;
  *valp = uimm8x2_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x2_encode (uint32 *valp)
{
  unsigned uimm8x2_in_0;
  unsigned uimm8x2_out_0;
  uimm8x2_out_0 = *valp;
  uimm8x2_in_0 = ((uimm8x2_out_0 >> 1) & 0xff);
  *valp = uimm8x2_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x4_decode (uint32 *valp)
{
  unsigned uimm8x4_out_0;
  unsigned uimm8x4_in_0;
  uimm8x4_in_0 = *valp & 0xff;
  uimm8x4_out_0 = uimm8x4_in_0 << 2;
  *valp = uimm8x4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x4_encode (uint32 *valp)
{
  unsigned uimm8x4_in_0;
  unsigned uimm8x4_out_0;
  uimm8x4_out_0 = *valp;
  uimm8x4_in_0 = ((uimm8x4_out_0 >> 2) & 0xff);
  *valp = uimm8x4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm4x16_decode (uint32 *valp)
{
  unsigned uimm4x16_out_0;
  unsigned uimm4x16_in_0;
  uimm4x16_in_0 = *valp & 0xf;
  uimm4x16_out_0 = ((0 << 4) | uimm4x16_in_0) << 4;
  *valp = uimm4x16_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm4x16_encode (uint32 *valp)
{
  unsigned uimm4x16_in_0;
  unsigned uimm4x16_out_0;
  uimm4x16_out_0 = *valp;
  uimm4x16_in_0 = ((uimm4x16_out_0 >> 4) & 0xf);
  *valp = uimm4x16_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimmrx4_decode (uint32 *valp)
{
  unsigned uimmrx4_out_0;
  unsigned uimmrx4_in_0;
  uimmrx4_in_0 = *valp & 0xf;
  uimmrx4_out_0 = ((0 << 4) | uimmrx4_in_0) << 2;
  *valp = uimmrx4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimmrx4_encode (uint32 *valp)
{
  unsigned uimmrx4_in_0;
  unsigned uimmrx4_out_0;
  uimmrx4_out_0 = *valp;
  uimmrx4_in_0 = ((uimmrx4_out_0 >> 2) & 0xf);
  *valp = uimmrx4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8_decode (uint32 *valp)
{
  unsigned simm8_out_0;
  unsigned simm8_in_0;
  simm8_in_0 = *valp & 0xff;
  simm8_out_0 = ((int) simm8_in_0 << 24) >> 24;
  *valp = simm8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8_encode (uint32 *valp)
{
  unsigned simm8_in_0;
  unsigned simm8_out_0;
  simm8_out_0 = *valp;
  simm8_in_0 = (simm8_out_0 & 0xff);
  *valp = simm8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8x256_decode (uint32 *valp)
{
  unsigned simm8x256_out_0;
  unsigned simm8x256_in_0;
  simm8x256_in_0 = *valp & 0xff;
  simm8x256_out_0 = (((int) simm8x256_in_0 << 24) >> 24) << 8;
  *valp = simm8x256_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8x256_encode (uint32 *valp)
{
  unsigned simm8x256_in_0;
  unsigned simm8x256_out_0;
  simm8x256_out_0 = *valp;
  simm8x256_in_0 = ((simm8x256_out_0 >> 8) & 0xff);
  *valp = simm8x256_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm12b_decode (uint32 *valp)
{
  unsigned simm12b_out_0;
  unsigned simm12b_in_0;
  simm12b_in_0 = *valp & 0xfff;
  simm12b_out_0 = ((int) simm12b_in_0 << 20) >> 20;
  *valp = simm12b_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm12b_encode (uint32 *valp)
{
  unsigned simm12b_in_0;
  unsigned simm12b_out_0;
  simm12b_out_0 = *valp;
  simm12b_in_0 = (simm12b_out_0 & 0xfff);
  *valp = simm12b_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_msalp32_decode (uint32 *valp)
{
  unsigned msalp32_out_0;
  unsigned msalp32_in_0;
  msalp32_in_0 = *valp & 0x1f;
  msalp32_out_0 = 0x20 - msalp32_in_0;
  *valp = msalp32_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_msalp32_encode (uint32 *valp)
{
  unsigned msalp32_in_0;
  unsigned msalp32_out_0;
  msalp32_out_0 = *valp;
  msalp32_in_0 = (0x20 - msalp32_out_0) & 0x1f;
  *valp = msalp32_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_op2p1_decode (uint32 *valp)
{
  unsigned op2p1_out_0;
  unsigned op2p1_in_0;
  op2p1_in_0 = *valp & 0xf;
  op2p1_out_0 = op2p1_in_0 + 0x1;
  *valp = op2p1_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_op2p1_encode (uint32 *valp)
{
  unsigned op2p1_in_0;
  unsigned op2p1_out_0;
  op2p1_out_0 = *valp;
  op2p1_in_0 = (op2p1_out_0 - 0x1) & 0xf;
  *valp = op2p1_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_label8_decode (uint32 *valp)
{
  unsigned label8_out_0;
  unsigned label8_in_0;
  label8_in_0 = *valp & 0xff;
  label8_out_0 = 0x4 + (((int) label8_in_0 << 24) >> 24);
  *valp = label8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_label8_encode (uint32 *valp)
{
  unsigned label8_in_0;
  unsigned label8_out_0;
  label8_out_0 = *valp;
  label8_in_0 = (label8_out_0 - 0x4) & 0xff;
  *valp = label8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ulabel8_decode (uint32 *valp)
{
  unsigned ulabel8_out_0;
  unsigned ulabel8_in_0;
  ulabel8_in_0 = *valp & 0xff;
  ulabel8_out_0 = 0x4 + (((0) << 8) | ulabel8_in_0);
  *valp = ulabel8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ulabel8_encode (uint32 *valp)
{
  unsigned ulabel8_in_0;
  unsigned ulabel8_out_0;
  ulabel8_out_0 = *valp;
  ulabel8_in_0 = (ulabel8_out_0 - 0x4) & 0xff;
  *valp = ulabel8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_label12_decode (uint32 *valp)
{
  unsigned label12_out_0;
  unsigned label12_in_0;
  label12_in_0 = *valp & 0xfff;
  label12_out_0 = 0x4 + (((int) label12_in_0 << 20) >> 20);
  *valp = label12_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_label12_encode (uint32 *valp)
{
  unsigned label12_in_0;
  unsigned label12_out_0;
  label12_out_0 = *valp;
  label12_in_0 = (label12_out_0 - 0x4) & 0xfff;
  *valp = label12_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_soffset_decode (uint32 *valp)
{
  unsigned soffset_out_0;
  unsigned soffset_in_0;
  soffset_in_0 = *valp & 0x3ffff;
  soffset_out_0 = 0x4 + (((int) soffset_in_0 << 14) >> 14);
  *valp = soffset_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_soffset_encode (uint32 *valp)
{
  unsigned soffset_in_0;
  unsigned soffset_out_0;
  soffset_out_0 = *valp;
  soffset_in_0 = (soffset_out_0 - 0x4) & 0x3ffff;
  *valp = soffset_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm16x4_decode (uint32 *valp)
{
  unsigned uimm16x4_out_0;
  unsigned uimm16x4_in_0;
  uimm16x4_in_0 = *valp & 0xffff;
  uimm16x4_out_0 = (((0xffff) << 16) | uimm16x4_in_0) << 2;
  *valp = uimm16x4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm16x4_encode (uint32 *valp)
{
  unsigned uimm16x4_in_0;
  unsigned uimm16x4_out_0;
  uimm16x4_out_0 = *valp;
  uimm16x4_in_0 = (uimm16x4_out_0 >> 2) & 0xffff;
  *valp = uimm16x4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_bbi_decode (uint32 *valp)
{
  unsigned bbi_out_0;
  unsigned bbi_in_0;
  bbi_in_0 = *valp & 0x1f;
  bbi_out_0 = (0 << 5) | bbi_in_0;
  *valp = bbi_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_bbi_encode (uint32 *valp)
{
  unsigned bbi_in_0;
  unsigned bbi_out_0;
  bbi_out_0 = *valp;
  bbi_in_0 = (bbi_out_0 & 0x1f);
  *valp = bbi_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_s_decode (uint32 *valp)
{
  unsigned s_out_0;
  unsigned s_in_0;
  s_in_0 = *valp & 0xf;
  s_out_0 = (0 << 4) | s_in_0;
  *valp = s_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_s_encode (uint32 *valp)
{
  unsigned s_in_0;
  unsigned s_out_0;
  s_out_0 = *valp;
  s_in_0 = (s_out_0 & 0xf);
  *valp = s_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_MR_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_MR_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_MR_1_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_MR_1_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_MR_2_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_MR_2_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_MR_3_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_MR_3_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_MR_4_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_MR_4_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_MR_5_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_MR_5_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_imms_decode (uint32 *valp)
{
  unsigned imms_out_0;
  unsigned imms_in_0;
  imms_in_0 = *valp & 0xf;
  imms_out_0 = imms_in_0;
  *valp = imms_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_imms_encode (uint32 *valp)
{
  unsigned imms_in_0;
  unsigned imms_out_0;
  imms_out_0 = *valp;
  imms_in_0 = imms_out_0 & 0xf;
  *valp = imms_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_BR_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_BR_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 16);
  return error;
}

static int
OperandSem_opnd_sem_BR2_decode (uint32 *valp)
{
  *valp = *valp << 1;
  return 0;
}

static int
OperandSem_opnd_sem_BR2_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 16) || ((*valp & 1) != 0);
  *valp = *valp >> 1;
  return error;
}

static int
OperandSem_opnd_sem_BR4_decode (uint32 *valp)
{
  *valp = *valp << 2;
  return 0;
}

static int
OperandSem_opnd_sem_BR4_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 16) || ((*valp & 3) != 0);
  *valp = *valp >> 2;
  return error;
}

static int
OperandSem_opnd_sem_BR8_decode (uint32 *valp)
{
  *valp = *valp << 3;
  return 0;
}

static int
OperandSem_opnd_sem_BR8_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 16) || ((*valp & 7) != 0);
  *valp = *valp >> 3;
  return error;
}

static int
OperandSem_opnd_sem_BR16_decode (uint32 *valp)
{
  *valp = *valp << 4;
  return 0;
}

static int
OperandSem_opnd_sem_BR16_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 16) || ((*valp & 15) != 0);
  *valp = *valp >> 4;
  return error;
}

static int
OperandSem_opnd_sem_tp7_decode (uint32 *valp)
{
  unsigned tp7_out_0;
  unsigned tp7_in_0;
  tp7_in_0 = *valp & 0xf;
  tp7_out_0 = tp7_in_0 + 0x7;
  *valp = tp7_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_tp7_encode (uint32 *valp)
{
  unsigned tp7_in_0;
  unsigned tp7_out_0;
  tp7_out_0 = *valp;
  tp7_in_0 = (tp7_out_0 - 0x7) & 0xf;
  *valp = tp7_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_xt_wbr15_label_decode (uint32 *valp)
{
  unsigned xt_wbr15_label_out_0;
  unsigned xt_wbr15_label_in_0;
  xt_wbr15_label_in_0 = *valp & 0x7fff;
  xt_wbr15_label_out_0 = 0x4 + (((int) xt_wbr15_label_in_0 << 17) >> 17);
  *valp = xt_wbr15_label_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_xt_wbr15_label_encode (uint32 *valp)
{
  unsigned xt_wbr15_label_in_0;
  unsigned xt_wbr15_label_out_0;
  xt_wbr15_label_out_0 = *valp;
  xt_wbr15_label_in_0 = (xt_wbr15_label_out_0 - 0x4) & 0x7fff;
  *valp = xt_wbr15_label_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_xt_wbr18_label_decode (uint32 *valp)
{
  unsigned xt_wbr18_label_out_0;
  unsigned xt_wbr18_label_in_0;
  xt_wbr18_label_in_0 = *valp & 0x3ffff;
  xt_wbr18_label_out_0 = 0x4 + (((int) xt_wbr18_label_in_0 << 14) >> 14);
  *valp = xt_wbr18_label_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_xt_wbr18_label_encode (uint32 *valp)
{
  unsigned xt_wbr18_label_in_0;
  unsigned xt_wbr18_label_out_0;
  xt_wbr18_label_out_0 = *valp;
  xt_wbr18_label_in_0 = (xt_wbr18_label_out_0 - 0x4) & 0x3ffff;
  *valp = xt_wbr18_label_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls64neg_decode (uint32 *valp)
{
  unsigned ae_immls64neg_out_0;
  unsigned ae_immls64neg_in_0;
  ae_immls64neg_in_0 = *valp & 0x3;
  ae_immls64neg_out_0 = CONST_TBL_ae_ripimmtable_0[ae_immls64neg_in_0 & 0x3];
  *valp = ae_immls64neg_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls64neg_encode (uint32 *valp)
{
  unsigned ae_immls64neg_in_0;
  unsigned ae_immls64neg_out_0;
  ae_immls64neg_out_0 = *valp;
  ae_immls64neg_in_0 = (((ae_immls64neg_out_0 == (CONST_TBL_ae_ripimmtable_0[0]))) ? 0 : (((ae_immls64neg_out_0 == (CONST_TBL_ae_ripimmtable_0[1]))) ? 0x1 : (((ae_immls64neg_out_0 == (CONST_TBL_ae_ripimmtable_0[2]))) ? 0x2 : 0x3))) & 0x3;
  *valp = ae_immls64neg_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls64half_decode (uint32 *valp)
{
  unsigned ae_immls64half_out_0;
  unsigned ae_immls64half_in_0;
  ae_immls64half_in_0 = *valp & 0x7;
  ae_immls64half_out_0 = (((int) ae_immls64half_in_0 << 29) >> 29) << 3;
  *valp = ae_immls64half_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls64half_encode (uint32 *valp)
{
  unsigned ae_immls64half_in_0;
  unsigned ae_immls64half_out_0;
  ae_immls64half_out_0 = *valp;
  ae_immls64half_in_0 = ((ae_immls64half_out_0 >> 3) & 0x7);
  *valp = ae_immls64half_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_ohba_decode (uint32 *valp)
{
  unsigned ae_ohba_out_0;
  unsigned ae_ohba_in_0;
  ae_ohba_in_0 = *valp & 0xf;
  ae_ohba_out_0 = (0 << 5) | (((((ae_ohba_in_0 & 0xf))) == 0) << 4) | ((ae_ohba_in_0 & 0xf));
  *valp = ae_ohba_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_ohba_encode (uint32 *valp)
{
  unsigned ae_ohba_in_0;
  unsigned ae_ohba_out_0;
  ae_ohba_out_0 = *valp;
  ae_ohba_in_0 = (ae_ohba_out_0 & 0xf);
  *valp = ae_ohba_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_opnd_tp7_decode (uint32 *valp)
{
  unsigned ae_opnd_tp7_out_0;
  unsigned ae_opnd_tp7_in_0;
  ae_opnd_tp7_in_0 = *valp & 0xf;
  ae_opnd_tp7_out_0 = ae_opnd_tp7_in_0 + 0x7;
  *valp = ae_opnd_tp7_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_opnd_tp7_encode (uint32 *valp)
{
  unsigned ae_opnd_tp7_in_0;
  unsigned ae_opnd_tp7_out_0;
  ae_opnd_tp7_out_0 = *valp;
  ae_opnd_tp7_in_0 = (ae_opnd_tp7_out_0 - 0x7) & 0xf;
  *valp = ae_opnd_tp7_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_imm2_decode (uint32 *valp)
{
  unsigned ae_imm2_out_0;
  unsigned ae_imm2_in_0;
  ae_imm2_in_0 = *valp & 0x3;
  ae_imm2_out_0 = (0 << 2) | ae_imm2_in_0;
  *valp = ae_imm2_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_imm2_encode (uint32 *valp)
{
  unsigned ae_imm2_in_0;
  unsigned ae_imm2_out_0;
  ae_imm2_out_0 = *valp;
  ae_imm2_in_0 = (ae_imm2_out_0 & 0x3);
  *valp = ae_imm2_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa32_decode (uint32 *valp)
{
  unsigned ae_osa32_out_0;
  unsigned ae_osa32_in_0;
  ae_osa32_in_0 = *valp & 0x1f;
  ae_osa32_out_0 = (0 << 5) | ae_osa32_in_0;
  *valp = ae_osa32_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa32_encode (uint32 *valp)
{
  unsigned ae_osa32_in_0;
  unsigned ae_osa32_out_0;
  ae_osa32_out_0 = *valp;
  ae_osa32_in_0 = (ae_osa32_out_0 & 0x1f);
  *valp = ae_osa32_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa64_decode (uint32 *valp)
{
  unsigned ae_osa64_out_0;
  unsigned ae_osa64_in_0;
  ae_osa64_in_0 = *valp & 0x3f;
  ae_osa64_out_0 = (0 << 6) | ae_osa64_in_0;
  *valp = ae_osa64_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa64_encode (uint32 *valp)
{
  unsigned ae_osa64_in_0;
  unsigned ae_osa64_out_0;
  ae_osa64_out_0 = *valp;
  ae_osa64_in_0 = (ae_osa64_out_0 & 0x3f);
  *valp = ae_osa64_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls64_decode (uint32 *valp)
{
  unsigned ae_immls64_out_0;
  unsigned ae_immls64_in_0;
  ae_immls64_in_0 = *valp & 0xf;
  ae_immls64_out_0 = (((int) ae_immls64_in_0 << 28) >> 28) << 3;
  *valp = ae_immls64_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls64_encode (uint32 *valp)
{
  unsigned ae_immls64_in_0;
  unsigned ae_immls64_out_0;
  ae_immls64_out_0 = *valp;
  ae_immls64_in_0 = ((ae_immls64_out_0 >> 3) & 0xf);
  *valp = ae_immls64_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls64pos_decode (uint32 *valp)
{
  unsigned ae_immls64pos_out_0;
  unsigned ae_immls64pos_in_0;
  ae_immls64pos_in_0 = *valp & 0x7;
  ae_immls64pos_out_0 = ((0 << 3) | ae_immls64pos_in_0) << 3;
  *valp = ae_immls64pos_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls64pos_encode (uint32 *valp)
{
  unsigned ae_immls64pos_in_0;
  unsigned ae_immls64pos_out_0;
  ae_immls64pos_out_0 = *valp;
  ae_immls64pos_in_0 = ((ae_immls64pos_out_0 >> 3) & 0x7);
  *valp = ae_immls64pos_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls32_decode (uint32 *valp)
{
  unsigned ae_immls32_out_0;
  unsigned ae_immls32_in_0;
  ae_immls32_in_0 = *valp & 0xf;
  ae_immls32_out_0 = (((int) ae_immls32_in_0 << 28) >> 28) << 2;
  *valp = ae_immls32_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls32_encode (uint32 *valp)
{
  unsigned ae_immls32_in_0;
  unsigned ae_immls32_out_0;
  ae_immls32_out_0 = *valp;
  ae_immls32_in_0 = ((ae_immls32_out_0 >> 2) & 0xf);
  *valp = ae_immls32_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls16_decode (uint32 *valp)
{
  unsigned ae_immls16_out_0;
  unsigned ae_immls16_in_0;
  ae_immls16_in_0 = *valp & 0xf;
  ae_immls16_out_0 = (((int) ae_immls16_in_0 << 28) >> 28) << 1;
  *valp = ae_immls16_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_immls16_encode (uint32 *valp)
{
  unsigned ae_immls16_in_0;
  unsigned ae_immls16_out_0;
  ae_immls16_out_0 = *valp;
  ae_immls16_in_0 = ((ae_immls16_out_0 >> 1) & 0xf);
  *valp = ae_immls16_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa16_decode (uint32 *valp)
{
  unsigned ae_osa16_out_0;
  unsigned ae_osa16_in_0;
  ae_osa16_in_0 = *valp & 0xf;
  ae_osa16_out_0 = (0 << 4) | ae_osa16_in_0;
  *valp = ae_osa16_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa16_encode (uint32 *valp)
{
  unsigned ae_osa16_in_0;
  unsigned ae_osa16_out_0;
  ae_osa16_out_0 = *valp;
  ae_osa16_in_0 = (ae_osa16_out_0 & 0xf);
  *valp = ae_osa16_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_selimm_N_decode (uint32 *valp)
{
  unsigned ae_selimm_N_out_0;
  unsigned ae_selimm_N_in_0;
  ae_selimm_N_in_0 = *valp & 0x3;
  ae_selimm_N_out_0 = (0 << 2) | ae_selimm_N_in_0;
  *valp = ae_selimm_N_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_selimm_N_encode (uint32 *valp)
{
  unsigned ae_selimm_N_in_0;
  unsigned ae_selimm_N_out_0;
  ae_selimm_N_out_0 = *valp;
  ae_selimm_N_in_0 = (ae_selimm_N_out_0 & 0x3);
  *valp = ae_selimm_N_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_movi_imm_decode (uint32 *valp)
{
  unsigned movi_imm_out_0;
  unsigned movi_imm_in_0;
  movi_imm_in_0 = *valp & 0x3f;
  movi_imm_out_0 = ((((-(( ( ((((movi_imm_in_0 >> 4) & 0x3)) | 0xfffffffc)) == 0xffffffff))) & 0x3ffffff)) << 6) | movi_imm_in_0;
  *valp = movi_imm_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_movi_imm_encode (uint32 *valp)
{
  unsigned movi_imm_in_0;
  unsigned movi_imm_out_0;
  movi_imm_out_0 = *valp;
  movi_imm_in_0 = (movi_imm_out_0 & 0x3f);
  *valp = movi_imm_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_AE_DR_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AE_DR_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 16);
  return error;
}

static int
OperandSem_opnd_sem_AE_VALIGN_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AE_VALIGN_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_ae_uimm2x2_decode (uint32 *valp)
{
  unsigned ae_uimm2x2_out_0;
  unsigned ae_uimm2x2_in_0;
  ae_uimm2x2_in_0 = *valp & 0x1;
  ae_uimm2x2_out_0 = (0 << 2) | (ae_uimm2x2_in_0 << 1) | 0;
  *valp = ae_uimm2x2_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_uimm2x2_encode (uint32 *valp)
{
  unsigned ae_uimm2x2_in_0;
  unsigned ae_uimm2x2_out_0;
  ae_uimm2x2_out_0 = *valp;
  ae_uimm2x2_in_0 = (((ae_uimm2x2_out_0 >> 1) & 1)) & 0x1;
  *valp = ae_uimm2x2_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_AE_EP_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AE_EP_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_shift_i8_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_shift_i8_out_0;
  unsigned opnd_ae_sem_shift_i8_in_0;
  opnd_ae_sem_shift_i8_in_0 = *valp & 0x7;
  opnd_ae_sem_shift_i8_out_0 = CONST_TBL_ae_slai72table_0[opnd_ae_sem_shift_i8_in_0 & 0x7];
  *valp = opnd_ae_sem_shift_i8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_shift_i8_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_shift_i8_in_0;
  unsigned opnd_ae_sem_shift_i8_out_0;
  opnd_ae_sem_shift_i8_out_0 = *valp;
  switch (opnd_ae_sem_shift_i8_out_0)
    {
    case 0x1: opnd_ae_sem_shift_i8_in_0 = 0; break;
    case 0x2: opnd_ae_sem_shift_i8_in_0 = 0x1; break;
    case 0x3: opnd_ae_sem_shift_i8_in_0 = 0x2; break;
    case 0x4: opnd_ae_sem_shift_i8_in_0 = 0x3; break;
    case 0x5: opnd_ae_sem_shift_i8_in_0 = 0x4; break;
    case 0x6: opnd_ae_sem_shift_i8_in_0 = 0x5; break;
    case 0x7: opnd_ae_sem_shift_i8_in_0 = 0x6; break;
    default: opnd_ae_sem_shift_i8_in_0 = 0x7; break;
    }
  *valp = opnd_ae_sem_shift_i8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa2_decode (uint32 *valp)
{
  unsigned ae_osa2_out_0;
  unsigned ae_osa2_in_0;
  ae_osa2_in_0 = *valp & 0x1;
  ae_osa2_out_0 = (0 << 1) | ae_osa2_in_0;
  *valp = ae_osa2_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa2_encode (uint32 *valp)
{
  unsigned ae_osa2_in_0;
  unsigned ae_osa2_out_0;
  ae_osa2_out_0 = *valp;
  ae_osa2_in_0 = (((ae_osa2_out_0 >> 0) & 1)) & 0x1;
  *valp = ae_osa2_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa8_decode (uint32 *valp)
{
  unsigned ae_osa8_out_0;
  unsigned ae_osa8_in_0;
  ae_osa8_in_0 = *valp & 0x7;
  ae_osa8_out_0 = (0 << 3) | ae_osa8_in_0;
  *valp = ae_osa8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa8_encode (uint32 *valp)
{
  unsigned ae_osa8_in_0;
  unsigned ae_osa8_out_0;
  ae_osa8_out_0 = *valp;
  ae_osa8_in_0 = (ae_osa8_out_0 & 0x7);
  *valp = ae_osa8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_dfp_fld_op2_2_decode (uint32 *valp)
{
  unsigned dfp_fld_op2_2_out_0;
  unsigned dfp_fld_op2_2_in_0;
  dfp_fld_op2_2_in_0 = *valp & 0x1;
  dfp_fld_op2_2_out_0 = (0 << 1) | dfp_fld_op2_2_in_0;
  *valp = dfp_fld_op2_2_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_dfp_fld_op2_2_encode (uint32 *valp)
{
  unsigned dfp_fld_op2_2_in_0;
  unsigned dfp_fld_op2_2_out_0;
  dfp_fld_op2_2_out_0 = *valp;
  dfp_fld_op2_2_in_0 = (((dfp_fld_op2_2_out_0 >> 0) & 1)) & 0x1;
  *valp = dfp_fld_op2_2_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_dfp_fld_op2_1_0_decode (uint32 *valp)
{
  unsigned dfp_fld_op2_1_0_out_0;
  unsigned dfp_fld_op2_1_0_in_0;
  dfp_fld_op2_1_0_in_0 = *valp & 0x3;
  dfp_fld_op2_1_0_out_0 = (0 << 2) | dfp_fld_op2_1_0_in_0;
  *valp = dfp_fld_op2_1_0_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_dfp_fld_op2_1_0_encode (uint32 *valp)
{
  unsigned dfp_fld_op2_1_0_in_0;
  unsigned dfp_fld_op2_1_0_out_0;
  dfp_fld_op2_1_0_out_0 = *valp;
  dfp_fld_op2_1_0_in_0 = (dfp_fld_op2_1_0_out_0 & 0x3);
  *valp = dfp_fld_op2_1_0_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_dfp_fld_op2_decode (uint32 *valp)
{
  unsigned dfp_fld_op2_out_0;
  unsigned dfp_fld_op2_in_0;
  dfp_fld_op2_in_0 = *valp & 0xf;
  dfp_fld_op2_out_0 = (0 << 4) | dfp_fld_op2_in_0;
  *valp = dfp_fld_op2_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_dfp_fld_op2_encode (uint32 *valp)
{
  unsigned dfp_fld_op2_in_0;
  unsigned dfp_fld_op2_out_0;
  dfp_fld_op2_out_0 = *valp;
  dfp_fld_op2_in_0 = (dfp_fld_op2_out_0 & 0xf);
  *valp = dfp_fld_op2_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_bitindex_decode (uint32 *valp)
{
  unsigned bitindex_out_0;
  unsigned bitindex_in_0;
  bitindex_in_0 = *valp & 0x1f;
  bitindex_out_0 = (0 << 5) | bitindex_in_0;
  *valp = bitindex_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_bitindex_encode (uint32 *valp)
{
  unsigned bitindex_in_0;
  unsigned bitindex_out_0;
  bitindex_out_0 = *valp;
  bitindex_in_0 = (bitindex_out_0 & 0x1f);
  *valp = bitindex_in_0;
  return 0;
}

static int
Operand_soffsetx4_ator (uint32 *valp, uint32 pc)
{
  *valp -= (pc & ~0x3);
  return 0;
}

static int
Operand_soffsetx4_rtoa (uint32 *valp, uint32 pc)
{
  *valp += (pc & ~0x3);
  return 0;
}

static int
Operand_uimm6_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_uimm6_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_label8_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_label8_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_ulabel8_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_ulabel8_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_label12_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_label12_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_soffset_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_soffset_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_uimm16x4_ator (uint32 *valp, uint32 pc)
{
  *valp -= ((pc + 3) & ~0x3);
  return 0;
}

static int
Operand_uimm16x4_rtoa (uint32 *valp, uint32 pc)
{
  *valp += ((pc + 3) & ~0x3);
  return 0;
}

static int
Operand_xt_wbr15_label_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_xt_wbr15_label_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_xt_wbr18_label_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_xt_wbr18_label_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static xtensa_operand_internal operands[] = {
  { "soffsetx4", FIELD_offset, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_soffsetx4_encode, OperandSem_opnd_sem_soffsetx4_decode,
    Operand_soffsetx4_ator, Operand_soffsetx4_rtoa,
    -1, 0 },
  { "immr", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_immr_encode, OperandSem_opnd_sem_immr_decode,
    0, 0,
    -1, 0 },
  { "uimm12x8", FIELD_imm12, -1, 0,
    0,
    OperandSem_opnd_sem_uimm12x8_encode, OperandSem_opnd_sem_uimm12x8_decode,
    0, 0,
    -1, 0 },
  { "simm4", FIELD_mn, -1, 0,
    0,
    OperandSem_opnd_sem_simm4_encode, OperandSem_opnd_sem_simm4_decode,
    0, 0,
    -1, 0 },
  { "arr", FIELD_r, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "ars", FIELD_s, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "*ars_invisible", FIELD_s, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "art", FIELD_t, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "ar0", FIELD__ar0, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_0_encode, OperandSem_opnd_sem_AR_0_decode,
    0, 0,
    0, 31 },
  { "ar4", FIELD__ar4, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_4_encode, OperandSem_opnd_sem_AR_4_decode,
    0, 0,
    0, 31 },
  { "ar8", FIELD__ar8, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_8_encode, OperandSem_opnd_sem_AR_8_decode,
    0, 0,
    0, 31 },
  { "ar12", FIELD__ar12, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_12_encode, OperandSem_opnd_sem_AR_12_decode,
    0, 0,
    0, 31 },
  { "ars_entry", FIELD_s, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_entry_encode, OperandSem_opnd_sem_AR_entry_decode,
    0, 0,
    0, 31 },
  { "immrx4", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_immrx4_encode, OperandSem_opnd_sem_immrx4_decode,
    0, 0,
    -1, 0 },
  { "lsi4x4", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_lsi4x4_encode, OperandSem_opnd_sem_lsi4x4_decode,
    0, 0,
    -1, 0 },
  { "simm7", FIELD_imm7, -1, 0,
    0,
    OperandSem_opnd_sem_simm7_encode, OperandSem_opnd_sem_simm7_decode,
    0, 0,
    -1, 0 },
  { "uimm6", FIELD_imm6, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_uimm6_encode, OperandSem_opnd_sem_uimm6_decode,
    Operand_uimm6_ator, Operand_uimm6_rtoa,
    -1, 0 },
  { "ai4const", FIELD_t, -1, 0,
    0,
    OperandSem_opnd_sem_ai4const_encode, OperandSem_opnd_sem_ai4const_decode,
    0, 0,
    -1, 0 },
  { "b4const", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_b4const_encode, OperandSem_opnd_sem_b4const_decode,
    0, 0,
    -1, 0 },
  { "b4constu", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_b4constu_encode, OperandSem_opnd_sem_b4constu_decode,
    0, 0,
    -1, 0 },
  { "immt", FIELD_t, -1, 0,
    0,
    OperandSem_opnd_sem_immt_encode, OperandSem_opnd_sem_immt_decode,
    0, 0,
    -1, 0 },
  { "uimm8", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_uimm8_encode, OperandSem_opnd_sem_uimm8_decode,
    0, 0,
    -1, 0 },
  { "uimm8x2", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_uimm8x2_encode, OperandSem_opnd_sem_uimm8x2_decode,
    0, 0,
    -1, 0 },
  { "uimm8x4", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_uimm8x4_encode, OperandSem_opnd_sem_uimm8x4_decode,
    0, 0,
    -1, 0 },
  { "uimm4x16", FIELD_op2, -1, 0,
    0,
    OperandSem_opnd_sem_uimm4x16_encode, OperandSem_opnd_sem_uimm4x16_decode,
    0, 0,
    -1, 0 },
  { "uimmrx4", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_uimmrx4_encode, OperandSem_opnd_sem_uimmrx4_decode,
    0, 0,
    -1, 0 },
  { "simm8", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_simm8_encode, OperandSem_opnd_sem_simm8_decode,
    0, 0,
    -1, 0 },
  { "simm8x256", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_simm8x256_encode, OperandSem_opnd_sem_simm8x256_decode,
    0, 0,
    -1, 0 },
  { "simm12b", FIELD_imm12b, -1, 0,
    0,
    OperandSem_opnd_sem_simm12b_encode, OperandSem_opnd_sem_simm12b_decode,
    0, 0,
    -1, 0 },
  { "msalp32", FIELD_sal, -1, 0,
    0,
    OperandSem_opnd_sem_msalp32_encode, OperandSem_opnd_sem_msalp32_decode,
    0, 0,
    -1, 0 },
  { "op2p1", FIELD_op2, -1, 0,
    0,
    OperandSem_opnd_sem_op2p1_encode, OperandSem_opnd_sem_op2p1_decode,
    0, 0,
    -1, 0 },
  { "label8", FIELD_imm8, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_label8_encode, OperandSem_opnd_sem_label8_decode,
    Operand_label8_ator, Operand_label8_rtoa,
    -1, 0 },
  { "ulabel8", FIELD_imm8, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_ulabel8_encode, OperandSem_opnd_sem_ulabel8_decode,
    Operand_ulabel8_ator, Operand_ulabel8_rtoa,
    -1, 0 },
  { "label12", FIELD_imm12, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_label12_encode, OperandSem_opnd_sem_label12_decode,
    Operand_label12_ator, Operand_label12_rtoa,
    -1, 0 },
  { "soffset", FIELD_offset, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_soffset_encode, OperandSem_opnd_sem_soffset_decode,
    Operand_soffset_ator, Operand_soffset_rtoa,
    -1, 0 },
  { "uimm16x4", FIELD_imm16, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_uimm16x4_encode, OperandSem_opnd_sem_uimm16x4_decode,
    Operand_uimm16x4_ator, Operand_uimm16x4_rtoa,
    -1, 0 },
  { "bbi", FIELD_bbi, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0,
    -1, 0 },
  { "sae", FIELD_sae, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0,
    -1, 0 },
  { "sas", FIELD_sas, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0,
    -1, 0 },
  { "sargt", FIELD_sargt, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0,
    -1, 0 },
  { "s", FIELD_s, -1, 0,
    0,
    OperandSem_opnd_sem_s_encode, OperandSem_opnd_sem_s_decode,
    0, 0,
    -1, 0 },
  { "mx", FIELD_x, REGFILE_MR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_UNKNOWN,
    OperandSem_opnd_sem_MR_encode, OperandSem_opnd_sem_MR_decode,
    0, 0,
    0, 3 },
  { "my", FIELD_y, REGFILE_MR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_UNKNOWN,
    OperandSem_opnd_sem_MR_0_encode, OperandSem_opnd_sem_MR_0_decode,
    0, 0,
    0, 3 },
  { "mw", FIELD_w, REGFILE_MR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_MR_1_encode, OperandSem_opnd_sem_MR_1_decode,
    0, 0,
    0, 3 },
  { "mr0", FIELD__mr0, REGFILE_MR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_MR_2_encode, OperandSem_opnd_sem_MR_2_decode,
    0, 0,
    0, 3 },
  { "mr1", FIELD__mr1, REGFILE_MR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_MR_3_encode, OperandSem_opnd_sem_MR_3_decode,
    0, 0,
    0, 3 },
  { "mr2", FIELD__mr2, REGFILE_MR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_MR_4_encode, OperandSem_opnd_sem_MR_4_decode,
    0, 0,
    0, 3 },
  { "mr3", FIELD__mr3, REGFILE_MR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_MR_5_encode, OperandSem_opnd_sem_MR_5_decode,
    0, 0,
    0, 3 },
  { "imms", FIELD_s, -1, 0,
    0,
    OperandSem_opnd_sem_imms_encode, OperandSem_opnd_sem_imms_decode,
    0, 0,
    -1, 0 },
  { "imms1", FIELD_s, -1, 0,
    0,
    OperandSem_opnd_sem_imms_encode, OperandSem_opnd_sem_imms_decode,
    0, 0,
    -1, 0 },
  { "bt", FIELD_t, REGFILE_BR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR_encode, OperandSem_opnd_sem_BR_decode,
    0, 0,
    0, 15 },
  { "bs", FIELD_s, REGFILE_BR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR_encode, OperandSem_opnd_sem_BR_decode,
    0, 0,
    0, 15 },
  { "br", FIELD_r, REGFILE_BR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR_encode, OperandSem_opnd_sem_BR_decode,
    0, 0,
    0, 15 },
  { "bt2", FIELD_t2, REGFILE_BR, 2,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR2_encode, OperandSem_opnd_sem_BR2_decode,
    0, 0,
    0, 15 },
  { "bs2", FIELD_s2, REGFILE_BR, 2,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR2_encode, OperandSem_opnd_sem_BR2_decode,
    0, 0,
    0, 15 },
  { "br2", FIELD_r2, REGFILE_BR, 2,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR2_encode, OperandSem_opnd_sem_BR2_decode,
    0, 0,
    0, 15 },
  { "bt4", FIELD_t4, REGFILE_BR, 4,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR4_encode, OperandSem_opnd_sem_BR4_decode,
    0, 0,
    0, 15 },
  { "bs4", FIELD_s4, REGFILE_BR, 4,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR4_encode, OperandSem_opnd_sem_BR4_decode,
    0, 0,
    0, 15 },
  { "br4", FIELD_r4, REGFILE_BR, 4,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR4_encode, OperandSem_opnd_sem_BR4_decode,
    0, 0,
    0, 15 },
  { "bt8", FIELD_t8, REGFILE_BR, 8,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR8_encode, OperandSem_opnd_sem_BR8_decode,
    0, 0,
    0, 15 },
  { "bs8", FIELD_s8, REGFILE_BR, 8,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR8_encode, OperandSem_opnd_sem_BR8_decode,
    0, 0,
    0, 15 },
  { "br8", FIELD_r8, REGFILE_BR, 8,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR8_encode, OperandSem_opnd_sem_BR8_decode,
    0, 0,
    0, 15 },
  { "bt16", FIELD__bt16, REGFILE_BR, 16,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR16_encode, OperandSem_opnd_sem_BR16_decode,
    0, 0,
    0, 15 },
  { "bs16", FIELD__bs16, REGFILE_BR, 16,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR16_encode, OperandSem_opnd_sem_BR16_decode,
    0, 0,
    0, 15 },
  { "br16", FIELD__br16, REGFILE_BR, 16,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR16_encode, OperandSem_opnd_sem_BR16_decode,
    0, 0,
    0, 15 },
  { "brall", FIELD__brall, REGFILE_BR, 16,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_BR16_encode, OperandSem_opnd_sem_BR16_decode,
    0, 0,
    0, 15 },
  { "tp7", FIELD_t, -1, 0,
    0,
    OperandSem_opnd_sem_tp7_encode, OperandSem_opnd_sem_tp7_decode,
    0, 0,
    -1, 0 },
  { "xt_wbr15_label", FIELD_xt_wbr15_imm, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_xt_wbr15_label_encode, OperandSem_opnd_sem_xt_wbr15_label_decode,
    Operand_xt_wbr15_label_ator, Operand_xt_wbr15_label_rtoa,
    -1, 0 },
  { "xt_wbr18_label", FIELD_xt_wbr18_imm, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_xt_wbr18_label_encode, OperandSem_opnd_sem_xt_wbr18_label_decode,
    Operand_xt_wbr18_label_ator, Operand_xt_wbr18_label_rtoa,
    -1, 0 },
  { "ae_immls64neg", FIELD_fld_ae_immls64neg, -1, 0,
    0,
    OperandSem_opnd_sem_ae_immls64neg_encode, OperandSem_opnd_sem_ae_immls64neg_decode,
    0, 0,
    -1, 0 },
  { "ae_immls64half", FIELD_ae_fld_immls64half, -1, 0,
    0,
    OperandSem_opnd_sem_ae_immls64half_encode, OperandSem_opnd_sem_ae_immls64half_decode,
    0, 0,
    -1, 0 },
  { "ae_ohba", FIELD_ae_fld_fhba4, -1, 0,
    0,
    OperandSem_opnd_sem_ae_ohba_encode, OperandSem_opnd_sem_ae_ohba_decode,
    0, 0,
    -1, 0 },
  { "ae_ohba2", FIELD_ae_fld_fhba4_2, -1, 0,
    0,
    OperandSem_opnd_sem_ae_ohba_encode, OperandSem_opnd_sem_ae_ohba_decode,
    0, 0,
    -1, 0 },
  { "ae_opnd_tp7", FIELD_ae_fld_tp7, -1, 0,
    0,
    OperandSem_opnd_sem_ae_opnd_tp7_encode, OperandSem_opnd_sem_ae_opnd_tp7_decode,
    0, 0,
    -1, 0 },
  { "ae_imm2", FIELD_ae_fld_imm2, -1, 0,
    0,
    OperandSem_opnd_sem_ae_imm2_encode, OperandSem_opnd_sem_ae_imm2_decode,
    0, 0,
    -1, 0 },
  { "ae_osa32", FIELD_ae_fld_osa32, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa32_encode, OperandSem_opnd_sem_ae_osa32_decode,
    0, 0,
    -1, 0 },
  { "ae_osa64", FIELD_ae_fld_osa64, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa64_encode, OperandSem_opnd_sem_ae_osa64_decode,
    0, 0,
    -1, 0 },
  { "ae_immls64", FIELD_ae_fld_immls64, -1, 0,
    0,
    OperandSem_opnd_sem_ae_immls64_encode, OperandSem_opnd_sem_ae_immls64_decode,
    0, 0,
    -1, 0 },
  { "ae_immls64pos", FIELD_ae_fld_immls64pos, -1, 0,
    0,
    OperandSem_opnd_sem_ae_immls64pos_encode, OperandSem_opnd_sem_ae_immls64pos_decode,
    0, 0,
    -1, 0 },
  { "ae_immls32", FIELD_ae_fld_immls32, -1, 0,
    0,
    OperandSem_opnd_sem_ae_immls32_encode, OperandSem_opnd_sem_ae_immls32_decode,
    0, 0,
    -1, 0 },
  { "ae_immls16", FIELD_ae_fld_immls16, -1, 0,
    0,
    OperandSem_opnd_sem_ae_immls16_encode, OperandSem_opnd_sem_ae_immls16_decode,
    0, 0,
    -1, 0 },
  { "ae_osa16", FIELD_ae_fld_osa16, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa16_encode, OperandSem_opnd_sem_ae_osa16_decode,
    0, 0,
    -1, 0 },
  { "ae_selimm", FIELD_ae_fld_selimm, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa16_encode, OperandSem_opnd_sem_ae_osa16_decode,
    0, 0,
    -1, 0 },
  { "ae_selimm.N", FIELD_ae_fld_selimm_N, -1, 0,
    0,
    OperandSem_opnd_sem_ae_selimm_N_encode, OperandSem_opnd_sem_ae_selimm_N_decode,
    0, 0,
    -1, 0 },
  { "movi_imm", FIELD_fld_ar_to_dr_imm, -1, 0,
    0,
    OperandSem_opnd_sem_movi_imm_encode, OperandSem_opnd_sem_movi_imm_decode,
    0, 0,
    -1, 0 },
  { "ae_arth_v", FIELD_ae_fld_arth_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "ae_arth_v0", FIELD_ae_fld_arth_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "ae_arth_v1", FIELD_ae_fld_arth_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "ae_ar_to_dr_v", FIELD_ae_fld_ar_to_dr_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "ae_to_dr_v", FIELD_ae_fld_to_dr_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "ae_to_dr_v0", FIELD_ae_fld_to_dr_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "ae_dr_to_dr_v", FIELD_ae_fld_dr_to_dr_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "ae_dr_to_dr_v0", FIELD_ae_fld_dr_to_dr_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "ae_dr_to_dr_v1", FIELD_ae_fld_dr_to_dr_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "ae_ls_v", FIELD_ae_fld_ls_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "ae_ls_av", FIELD_ae_fld_ls_av, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "ae_ls_v1", FIELD_ae_fld_ls_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "ae_ls_v2", FIELD_ae_fld_ls_v2, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "ae_ls_uu", FIELD_ae_fld_ls_uu, REGFILE_AE_VALIGN, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_VALIGN_encode, OperandSem_opnd_sem_AE_VALIGN_decode,
    0, 0,
    0, 3 },
  { "ae_ls_su", FIELD_ae_fld_ls_su, REGFILE_AE_VALIGN, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_VALIGN_encode, OperandSem_opnd_sem_AE_VALIGN_decode,
    0, 0,
    0, 3 },
  { "ae_uu_v", FIELD_ae_fld_uu_v, REGFILE_AE_VALIGN, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_VALIGN_encode, OperandSem_opnd_sem_AE_VALIGN_decode,
    0, 0,
    0, 3 },
  { "ae_uu_uu", FIELD_ae_fld_uu_uu, REGFILE_AE_VALIGN, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_VALIGN_encode, OperandSem_opnd_sem_AE_VALIGN_decode,
    0, 0,
    0, 3 },
  { "ae_dr_to_ar_v0", FIELD_ae_fld_dr_to_ar_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "ae_cmov_v", FIELD_ae_fld_cmov_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "ae_cmov_v0", FIELD_ae_fld_cmov_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "ae_pks_d", FIELD_ae_fld_pks_d, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "ae_pks_s", FIELD_ae_fld_pks_s, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "ae_shift_d", FIELD_ae_fld_shift_d, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "ae_shift_d0", FIELD_ae_fld_shift_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "ae_shift_sd", FIELD_ae_fld_shift_sd, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "ae_uimm2x2", FIELD_ae_fld_Inst16b_12, -1, 0,
    0,
    OperandSem_opnd_sem_ae_uimm2x2_encode, OperandSem_opnd_sem_ae_uimm2x2_decode,
    0, 0,
    -1, 0 },
  { "opnd_ae_sem_loads_stores_end", FIELD_fld_ae_sem_loads_stores_end, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "opnd_ae_sem_arithmetic_ds", FIELD_fld_ae_sem_arithmetic_ds, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_rng_d", FIELD_fld_ae_sem_rng_d, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_mul_x2_S1_d1", FIELD_fld_ae_sem_mul_x2_S1_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_mul_x2_S1_d0", FIELD_fld_ae_sem_mul_x2_S1_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_mul_x2_S1_q0", FIELD_fld_ae_sem_mul_x2_S1_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_mul_x2_S2_d1", FIELD_fld_ae_sem_mul_x2_S2_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_mul_x2_S2_d0", FIELD_fld_ae_sem_mul_x2_S2_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_mul_x2_S2_q0", FIELD_fld_ae_sem_mul_x2_S2_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_mul_x4_d1", FIELD_fld_ae_sem_mul_x4_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_mul_x4_d0", FIELD_fld_ae_sem_mul_x4_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_mul_x4_q0", FIELD_fld_ae_sem_mul_x4_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_mul_x4_q1", FIELD_fld_ae_sem_mul_x4_q1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_mul_x4_d2", FIELD_fld_ae_sem_mul_x4_d2, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_mul_x2_S1_d2", FIELD_fld_ae_sem_mul_x2_S1_d2, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_mul_x2_S1_v1", FIELD_fld_ae_sem_mul_x2_S1_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_mul_x2_S2_d2", FIELD_fld_ae_sem_mul_x2_S2_d2, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_mul_x2_S2_v1", FIELD_fld_ae_sem_mul_x2_S2_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_ep_ls_ei", FIELD_fld_ae_sem_ep_ls_ei, REGFILE_AE_EP, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_EP_encode, OperandSem_opnd_sem_AE_EP_decode,
    0, 0,
    0, 3 },
  { "opnd_ae_sem_ep_ls_ar_s", FIELD_fld_ae_sem_ep_ls_ar_s, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "opnd_ae_sem_ep_ls_eo", FIELD_fld_ae_sem_ep_ls_eo, REGFILE_AE_EP, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_EP_encode, OperandSem_opnd_sem_AE_EP_decode,
    0, 0,
    0, 3 },
  { "opnd_ae_sem_arithmetic_ep", FIELD_fld_ae_sem_arithmetic_ep, REGFILE_AE_EP, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_EP_encode, OperandSem_opnd_sem_AE_EP_decode,
    0, 0,
    0, 3 },
  { "opnd_ae_sem_arithmetic_ep1", FIELD_fld_ae_sem_arithmetic_ep1, REGFILE_AE_EP, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_EP_encode, OperandSem_opnd_sem_AE_EP_decode,
    0, 0,
    0, 3 },
  { "opnd_ae_sem_mul_x2_S1_acc_ep", FIELD_fld_ae_sem_mul_x2_S1_acc_ep, REGFILE_AE_EP, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_EP_encode, OperandSem_opnd_sem_AE_EP_decode,
    0, 0,
    0, 3 },
  { "opnd_ae_sem_mul_x2_S2_acc_ep", FIELD_fld_ae_sem_mul_x2_S2_acc_ep, REGFILE_AE_EP, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_EP_encode, OperandSem_opnd_sem_AE_EP_decode,
    0, 0,
    0, 3 },
  { "opnd_ae_sem_shift_e", FIELD_fld_ae_sem_shift_e, REGFILE_AE_EP, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_EP_encode, OperandSem_opnd_sem_AE_EP_decode,
    0, 0,
    0, 3 },
  { "opnd_ae_sem_shift_i8", FIELD_fld_ae_sem_shift_i8, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_shift_i8_encode, OperandSem_opnd_sem_opnd_ae_sem_shift_i8_decode,
    0, 0,
    -1, 0 },
  { "opnd_ae_sem_arithmetic_e", FIELD_fld_ae_sem_arithmetic_e, REGFILE_AE_EP, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_EP_encode, OperandSem_opnd_sem_AE_EP_decode,
    0, 0,
    0, 3 },
  { "opnd_ae_sem_dr_to_ar_vr", FIELD_fld_ae_sem_dr_to_ar_vr, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_cmov_bt", FIELD_fld_ae_sem_cmov_bt, REGFILE_BR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR_encode, OperandSem_opnd_sem_BR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_cmov_arr", FIELD_fld_ae_sem_cmov_arr, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "opnd_vfpu2_sem_mov_vt", FIELD_fld_vfpu2_sem_mov_vt, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_vfpu2_sem_mov_vr", FIELD_fld_vfpu2_sem_mov_vr, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_vfpu2_sem_spfma_vt", FIELD_fld_vfpu2_sem_spfma_vt, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_vfpu2_sem_spfma_vs", FIELD_fld_vfpu2_sem_spfma_vs, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_vfpu2_sem_spfma_vr", FIELD_fld_vfpu2_sem_spfma_vr, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_vfpu2_sem_spmisc_brt", FIELD_fld_vfpu2_sem_spmisc_brt, REGFILE_BR, 2,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_BR2_encode, OperandSem_opnd_sem_BR2_decode,
    0, 0,
    0, 15 },
  { "opnd_vfpu2_sem_spmisc_vs", FIELD_fld_vfpu2_sem_spmisc_vs, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_vfpu2_sem_spmisc_vr", FIELD_fld_vfpu2_sem_spmisc_vr, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_vfpu2_sem_mov_i_imm4", FIELD_fld_vfpu2_sem_mov_i_imm4, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa16_encode, OperandSem_opnd_sem_ae_osa16_decode,
    0, 0,
    -1, 0 },
  { "opnd_vfpu2_sem_spmisc_vt", FIELD_fld_vfpu2_sem_spmisc_vt, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_vfpu2_sem_spmisc_vtM", FIELD_fld_vfpu2_sem_spmisc_vtM, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_vfpu2_sem_sp32cvt_vr", FIELD_fld_vfpu2_sem_sp32cvt_vr, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_vfpu2_sem_sp32cvt_vt", FIELD_fld_vfpu2_sem_sp32cvt_vt, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_vfpu2_sem_sp32cvt_i_imm5", FIELD_fld_vfpu2_sem_sp32cvt_i_imm5, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa32_encode, OperandSem_opnd_sem_ae_osa32_decode,
    0, 0,
    -1, 0 },
  { "opnd_vfpu2_sem_sp32cvt_arr", FIELD_fld_vfpu2_sem_sp32cvt_arr, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "opnd_vfpu2_sem_spmisc_vsM", FIELD_fld_vfpu2_sem_spmisc_vsM, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_vfpu2_sem_spfma_i_imm1", FIELD_fld_vfpu2_sem_spfma_i_imm1, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa2_encode, OperandSem_opnd_sem_ae_osa2_decode,
    0, 0,
    -1, 0 },
  { "opnd_vfpu2_sem_spfma_i_imm3", FIELD_fld_vfpu2_sem_spfma_i_imm3, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa8_encode, OperandSem_opnd_sem_ae_osa8_decode,
    0, 0,
    -1, 0 },
  { "opnd_ae_sem_movfpstate_v", FIELD_fld_ae_sem_movfpstate_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "dfp_fld_op2_2", FIELD_dfp_fld_op2_2, -1, 0,
    0,
    OperandSem_opnd_sem_dfp_fld_op2_2_encode, OperandSem_opnd_sem_dfp_fld_op2_2_decode,
    0, 0,
    -1, 0 },
  { "dfp_fld_op2_1_0", FIELD_dfp_fld_op2_1_0, -1, 0,
    0,
    OperandSem_opnd_sem_dfp_fld_op2_1_0_encode, OperandSem_opnd_sem_dfp_fld_op2_1_0_decode,
    0, 0,
    -1, 0 },
  { "dfp_fld_r_0", FIELD_dfp_fld_r_0, -1, 0,
    0,
    OperandSem_opnd_sem_dfp_fld_op2_2_encode, OperandSem_opnd_sem_dfp_fld_op2_2_decode,
    0, 0,
    -1, 0 },
  { "dfp_fld_r_2_1", FIELD_dfp_fld_r_2_1, -1, 0,
    0,
    OperandSem_opnd_sem_dfp_fld_op2_1_0_encode, OperandSem_opnd_sem_dfp_fld_op2_1_0_decode,
    0, 0,
    -1, 0 },
  { "dfp_fld_op2", FIELD_dfp_fld_op2, -1, 0,
    0,
    OperandSem_opnd_sem_dfp_fld_op2_encode, OperandSem_opnd_sem_dfp_fld_op2_decode,
    0, 0,
    -1, 0 },
  { "dfp_fld_op2_0", FIELD_dfp_fld_op2_0, -1, 0,
    0,
    OperandSem_opnd_sem_dfp_fld_op2_2_encode, OperandSem_opnd_sem_dfp_fld_op2_2_decode,
    0, 0,
    -1, 0 },
  { "dfp_fld_s_0", FIELD_dfp_fld_s_0, -1, 0,
    0,
    OperandSem_opnd_sem_dfp_fld_op2_2_encode, OperandSem_opnd_sem_dfp_fld_op2_2_decode,
    0, 0,
    -1, 0 },
  { "bitindex", FIELD_bitindex, -1, 0,
    0,
    OperandSem_opnd_sem_bitindex_encode, OperandSem_opnd_sem_bitindex_decode,
    0, 0,
    -1, 0 },
  { "opnd_SIGMOID_Q15_x", FIELD_fld_SIGMOID_Q15_x, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "opnd_SIGMOID_Q15_y", FIELD_fld_SIGMOID_Q15_y, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "opnd_SIGMOID_FP32_x", FIELD_fld_SIGMOID_FP32_x, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_SIGMOID_FP32_y", FIELD_fld_SIGMOID_FP32_y, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "t", FIELD_t, -1, 0, 0, 0, 0, 0, 0 },
  { "bbi4", FIELD_bbi4, -1, 0, 0, 0, 0, 0, 0 },
  { "imm12", FIELD_imm12, -1, 0, 0, 0, 0, 0, 0 },
  { "imm8", FIELD_imm8, -1, 0, 0, 0, 0, 0, 0 },
  { "imm12b", FIELD_imm12b, -1, 0, 0, 0, 0, 0, 0 },
  { "imm16", FIELD_imm16, -1, 0, 0, 0, 0, 0, 0 },
  { "m", FIELD_m, -1, 0, 0, 0, 0, 0, 0 },
  { "n", FIELD_n, -1, 0, 0, 0, 0, 0, 0 },
  { "offset", FIELD_offset, -1, 0, 0, 0, 0, 0, 0 },
  { "op0", FIELD_op0, -1, 0, 0, 0, 0, 0, 0 },
  { "op1", FIELD_op1, -1, 0, 0, 0, 0, 0, 0 },
  { "op2", FIELD_op2, -1, 0, 0, 0, 0, 0, 0 },
  { "r", FIELD_r, -1, 0, 0, 0, 0, 0, 0 },
  { "r_disp", FIELD_r_disp, -1, 0, 0, 0, 0, 0, 0 },
  { "r_3", FIELD_r_3, -1, 0, 0, 0, 0, 0, 0 },
  { "sa4", FIELD_sa4, -1, 0, 0, 0, 0, 0, 0 },
  { "sae4", FIELD_sae4, -1, 0, 0, 0, 0, 0, 0 },
  { "sal", FIELD_sal, -1, 0, 0, 0, 0, 0, 0 },
  { "sas4", FIELD_sas4, -1, 0, 0, 0, 0, 0, 0 },
  { "sr", FIELD_sr, -1, 0, 0, 0, 0, 0, 0 },
  { "st", FIELD_st, -1, 0, 0, 0, 0, 0, 0 },
  { "thi3", FIELD_thi3, -1, 0, 0, 0, 0, 0, 0 },
  { "imm4", FIELD_imm4, -1, 0, 0, 0, 0, 0, 0 },
  { "mn", FIELD_mn, -1, 0, 0, 0, 0, 0, 0 },
  { "i", FIELD_i, -1, 0, 0, 0, 0, 0, 0 },
  { "imm6lo", FIELD_imm6lo, -1, 0, 0, 0, 0, 0, 0 },
  { "imm6hi", FIELD_imm6hi, -1, 0, 0, 0, 0, 0, 0 },
  { "imm7lo", FIELD_imm7lo, -1, 0, 0, 0, 0, 0, 0 },
  { "imm7hi", FIELD_imm7hi, -1, 0, 0, 0, 0, 0, 0 },
  { "z", FIELD_z, -1, 0, 0, 0, 0, 0, 0 },
  { "imm6", FIELD_imm6, -1, 0, 0, 0, 0, 0, 0 },
  { "imm7", FIELD_imm7, -1, 0, 0, 0, 0, 0, 0 },
  { "r3", FIELD_r3, -1, 0, 0, 0, 0, 0, 0 },
  { "rbit2", FIELD_rbit2, -1, 0, 0, 0, 0, 0, 0 },
  { "rhi", FIELD_rhi, -1, 0, 0, 0, 0, 0, 0 },
  { "t3", FIELD_t3, -1, 0, 0, 0, 0, 0, 0 },
  { "tbit2", FIELD_tbit2, -1, 0, 0, 0, 0, 0, 0 },
  { "tlo", FIELD_tlo, -1, 0, 0, 0, 0, 0, 0 },
  { "w", FIELD_w, -1, 0, 0, 0, 0, 0, 0 },
  { "y", FIELD_y, -1, 0, 0, 0, 0, 0, 0 },
  { "x", FIELD_x, -1, 0, 0, 0, 0, 0, 0 },
  { "t2", FIELD_t2, -1, 0, 0, 0, 0, 0, 0 },
  { "s2", FIELD_s2, -1, 0, 0, 0, 0, 0, 0 },
  { "r2", FIELD_r2, -1, 0, 0, 0, 0, 0, 0 },
  { "t4", FIELD_t4, -1, 0, 0, 0, 0, 0, 0 },
  { "s4", FIELD_s4, -1, 0, 0, 0, 0, 0, 0 },
  { "r4", FIELD_r4, -1, 0, 0, 0, 0, 0, 0 },
  { "t8", FIELD_t8, -1, 0, 0, 0, 0, 0, 0 },
  { "s8", FIELD_s8, -1, 0, 0, 0, 0, 0, 0 },
  { "r8", FIELD_r8, -1, 0, 0, 0, 0, 0, 0 },
  { "xt_wbr15_imm", FIELD_xt_wbr15_imm, -1, 0, 0, 0, 0, 0, 0 },
  { "xt_wbr18_imm", FIELD_xt_wbr18_imm, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_fhba4", FIELD_ae_fld_fhba4, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_fhba4_2", FIELD_ae_fld_fhba4_2, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_tp7", FIELD_ae_fld_tp7, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_osa32", FIELD_ae_fld_osa32, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_osa64", FIELD_ae_fld_osa64, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_imm2", FIELD_ae_fld_imm2, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_immls64", FIELD_ae_fld_immls64, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_immls64pos", FIELD_ae_fld_immls64pos, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_immls64half", FIELD_ae_fld_immls64half, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_immls32", FIELD_ae_fld_immls32, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_immls16", FIELD_ae_fld_immls16, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_osa16", FIELD_ae_fld_osa16, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_15_12", FIELD_Inst_15_12, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_11_8", FIELD_Inst_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_7_4", FIELD_Inst_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_12", FIELD_Inst_12, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_7", FIELD_Inst_7, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_5_4", FIELD_Inst_5_4, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_7_6", FIELD_Inst_7_6, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_19_17", FIELD_Inst_19_17, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_19_18", FIELD_Inst_19_18, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_9_8", FIELD_Inst_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "Inst_4", FIELD_Inst_4, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ls_v", FIELD_ae_fld_ls_v, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ls_uu", FIELD_ae_fld_ls_uu, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ls_su", FIELD_ae_fld_ls_su, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ls_av", FIELD_ae_fld_ls_av, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ls_v1", FIELD_ae_fld_ls_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ls_v2", FIELD_ae_fld_ls_v2, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_cmpp_v0", FIELD_ae_fld_cmpp_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_cmpp_v1", FIELD_ae_fld_cmpp_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_cmpp_v", FIELD_ae_fld_cmpp_v, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_uu_v", FIELD_ae_fld_uu_v, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_uu_uu", FIELD_ae_fld_uu_uu, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_dr_to_ar_v0", FIELD_ae_fld_dr_to_ar_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_cmov_v", FIELD_ae_fld_cmov_v, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_cmov_v0", FIELD_ae_fld_cmov_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_pks_d", FIELD_ae_fld_pks_d, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_pks_s", FIELD_ae_fld_pks_s, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_shift_d", FIELD_ae_fld_shift_d, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_shift_d0", FIELD_ae_fld_shift_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_shift_sd", FIELD_ae_fld_shift_sd, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_dr_to_dr_v", FIELD_ae_fld_dr_to_dr_v, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_dr_to_dr_v0", FIELD_ae_fld_dr_to_dr_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_dr_to_dr_v1", FIELD_ae_fld_dr_to_dr_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_to_dr_v", FIELD_ae_fld_to_dr_v, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_to_dr_v0", FIELD_ae_fld_to_dr_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_immls64neg", FIELD_fld_ae_immls64neg, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_selimm", FIELD_ae_fld_selimm, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_selimm.N", FIELD_ae_fld_selimm_N, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ar_to_dr_imm", FIELD_fld_ar_to_dr_imm, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_arth_v", FIELD_ae_fld_arth_v, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_arth_v0", FIELD_ae_fld_arth_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_arth_v1", FIELD_ae_fld_arth_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_ar_to_dr_v", FIELD_ae_fld_ar_to_dr_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_23_12", FIELD_fld_Inst_23_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_23_16", FIELD_fld_Inst_23_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_7_7", FIELD_fld_Inst_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_11_8", FIELD_fld_Inst_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_13_8", FIELD_fld_Inst_13_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_12_8", FIELD_fld_Inst_12_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_9_8", FIELD_fld_Inst_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_4_4", FIELD_fld_Inst_4_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_5_4", FIELD_fld_Inst_5_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_7_4", FIELD_fld_Inst_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_Inst16b_12", FIELD_ae_fld_Inst16b_12, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_Inst16b_15_13", FIELD_ae_fld_Inst16b_15_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot0_7_4", FIELD_fld_ae4_slot0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_11_4", FIELD_fld_ae2_slot0_11_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_7_4", FIELD_fld_ae2_slot0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot0_27_24", FIELD_fld_ae4_slot0_27_24, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_11_9", FIELD_fld_ae2_slot0_11_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_28_27", FIELD_fld_ae2_slot0_28_27, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot0_27_23", FIELD_fld_ae4_slot0_27_23, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_11_8", FIELD_fld_ae2_slot0_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_21_8", FIELD_fld_ae5_slot0_21_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot1_13_8", FIELD_fld_ae4_slot1_13_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_19_8", FIELD_fld_ae3_slot1_19_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot1_13_11", FIELD_fld_ae4_slot1_13_11, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_3_0", FIELD_fld_ae5_slot0_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_3_0", FIELD_fld_ae3_slot0_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_3_0", FIELD_fld_ae3_slot1_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_3_0", FIELD_fld_ae2_slot0_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_3_0", FIELD_fld_ae2_slot1_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_3_0", FIELD_fld_ae_slot0_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_3_0", FIELD_fld_ae_slot1_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_21_12", FIELD_fld_ae5_slot0_21_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot1_13_12", FIELD_fld_ae4_slot1_13_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_21_12", FIELD_fld_ae3_slot0_21_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_19_12", FIELD_fld_ae3_slot1_19_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_19_12", FIELD_fld_ae2_slot1_19_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_19_12", FIELD_fld_ae_slot1_19_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_21_16", FIELD_fld_ae5_slot0_21_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_21_16", FIELD_fld_ae3_slot0_21_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_19_16", FIELD_fld_ae3_slot1_19_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_19_16", FIELD_fld_ae2_slot1_19_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_19_16", FIELD_fld_ae_slot1_19_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_21_17", FIELD_fld_ae5_slot0_21_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_21_17", FIELD_fld_ae3_slot0_21_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_19_17", FIELD_fld_ae3_slot1_19_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_28_17", FIELD_fld_ae2_slot0_28_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_19_17", FIELD_fld_ae2_slot1_19_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_19_17", FIELD_fld_ae_slot1_19_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_21_20", FIELD_fld_ae5_slot0_21_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_21_20", FIELD_fld_ae3_slot0_21_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_28_20", FIELD_fld_ae2_slot0_28_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_7_4", FIELD_fld_ae5_slot0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_7_4", FIELD_fld_ae3_slot0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot0_15_0", FIELD_fld_ae7_slot0_15_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot1_15_0", FIELD_fld_ae7_slot1_15_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot2_18_0", FIELD_fld_ae7_slot2_18_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot3_18_0", FIELD_fld_ae7_slot3_18_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot0_15_0", FIELD_fld_ae6_slot0_15_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot1_14_0", FIELD_fld_ae6_slot1_14_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot2_13_0", FIELD_fld_ae6_slot2_13_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot3_17_0", FIELD_fld_ae6_slot3_17_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_21_0", FIELD_fld_ae5_slot0_21_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot1_0_0", FIELD_fld_ae5_slot1_0_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot2_19_0", FIELD_fld_ae5_slot2_19_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot0_2_0", FIELD_fld_ae4_slot0_2_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot0_27_3", FIELD_fld_ae4_slot0_27_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae4_slot1_13_0", FIELD_fld_ae4_slot1_13_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_21_0", FIELD_fld_ae3_slot0_21_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_19_0", FIELD_fld_ae3_slot1_19_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_19_0", FIELD_fld_ae2_slot1_19_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_24_0", FIELD_fld_ae2_slot2_24_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_20_0", FIELD_fld_ae_slot0_20_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_19_0", FIELD_fld_ae_slot1_19_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_20_0", FIELD_fld_ae_slot2_20_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_7_4", FIELD_fld_ae3_slot1_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_21_13", FIELD_fld_ae5_slot0_21_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_21_13", FIELD_fld_ae3_slot0_21_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_19_13", FIELD_fld_ae3_slot1_19_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_28_13", FIELD_fld_ae2_slot0_28_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_19_13", FIELD_fld_ae2_slot1_19_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_20_15", FIELD_fld_ae_slot0_20_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_19_13", FIELD_fld_ae_slot1_19_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_20_13", FIELD_fld_ae_slot0_20_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_19_4", FIELD_fld_ae3_slot1_19_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_28_4", FIELD_fld_ae2_slot0_28_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_19_4", FIELD_fld_ae2_slot1_19_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_20_4", FIELD_fld_ae_slot0_20_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_19_4", FIELD_fld_ae_slot1_19_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_7_1", FIELD_fld_ae3_slot1_7_1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_19_9", FIELD_fld_ae2_slot1_19_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_19_9", FIELD_fld_ae_slot1_19_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_3_2", FIELD_fld_ae2_slot0_3_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_3_2", FIELD_fld_ae_slot0_3_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_0_0", FIELD_fld_ae2_slot0_0_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_0_0", FIELD_fld_ae_slot0_0_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_28_12", FIELD_fld_ae2_slot0_28_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_20_12", FIELD_fld_ae_slot0_20_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot0_7_4", FIELD_fld_ae7_slot0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot1_7_4", FIELD_fld_ae7_slot1_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_11_8", FIELD_fld_ae5_slot0_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_11_8", FIELD_fld_ae3_slot0_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_21_6", FIELD_fld_ae5_slot0_21_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_end", FIELD_fld_ae_sem_loads_stores_end, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_7_4", FIELD_fld_ae2_slot1_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_7_4", FIELD_fld_ae_slot1_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_28_8", FIELD_fld_ae2_slot0_28_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_19_8", FIELD_fld_ae2_slot1_19_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_20_8", FIELD_fld_ae_slot0_20_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_19_8", FIELD_fld_ae_slot1_19_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot1_14_12", FIELD_fld_ae6_slot1_14_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot2_3_0", FIELD_fld_ae6_slot2_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_ds", FIELD_fld_ae_sem_arithmetic_ds, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot3_17_16", FIELD_fld_ae6_slot3_17_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_20_0", FIELD_fld_ae_slot3_20_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_rng_d", FIELD_fld_ae_sem_rng_d, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_3_0", FIELD_fld_ae_slot3_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_8_8", FIELD_fld_ae3_slot0_8_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_8_8", FIELD_fld_ae_slot0_8_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_1_0", FIELD_fld_ae_slot3_1_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_11_0", FIELD_fld_ae2_slot0_11_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_11_0", FIELD_fld_ae_slot0_11_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_7_0", FIELD_fld_ae2_slot1_7_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_7_0", FIELD_fld_ae_slot0_7_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_28_16", FIELD_fld_ae2_slot0_28_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_20_16", FIELD_fld_ae_slot0_20_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_20_8", FIELD_fld_ae_slot3_20_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_9_4", FIELD_fld_ae2_slot0_9_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_9_4", FIELD_fld_ae_slot0_9_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x2_S1_d1", FIELD_fld_ae_sem_mul_x2_S1_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x2_S1_d0", FIELD_fld_ae_sem_mul_x2_S1_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x2_S1_q0", FIELD_fld_ae_sem_mul_x2_S1_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x2_S2_d1", FIELD_fld_ae_sem_mul_x2_S2_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x2_S2_d0", FIELD_fld_ae_sem_mul_x2_S2_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x2_S2_q0", FIELD_fld_ae_sem_mul_x2_S2_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x4_d1", FIELD_fld_ae_sem_mul_x4_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x4_d0", FIELD_fld_ae_sem_mul_x4_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x4_q0", FIELD_fld_ae_sem_mul_x4_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot2_13_12", FIELD_fld_ae6_slot2_13_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x4_q1", FIELD_fld_ae_sem_mul_x4_q1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_24_16", FIELD_fld_ae2_slot2_24_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x4_d2", FIELD_fld_ae_sem_mul_x4_d2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_24_20", FIELD_fld_ae2_slot2_24_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot2_18_16", FIELD_fld_ae7_slot2_18_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot2_7_4", FIELD_fld_ae2_slot2_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot3_18_16", FIELD_fld_ae7_slot3_18_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x2_S1_d2", FIELD_fld_ae_sem_mul_x2_S1_d2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x2_S1_v1", FIELD_fld_ae_sem_mul_x2_S1_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x2_S2_d2", FIELD_fld_ae_sem_mul_x2_S2_d2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x2_S2_v1", FIELD_fld_ae_sem_mul_x2_S2_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot2_19_12", FIELD_fld_ae5_slot2_19_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_20_12", FIELD_fld_ae_slot2_20_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_20_12", FIELD_fld_ae_slot3_20_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_21_4", FIELD_fld_ae5_slot0_21_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_ep_ls_ei", FIELD_fld_ae_sem_ep_ls_ei, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_3_2", FIELD_fld_ae3_slot0_3_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_3_2", FIELD_fld_ae3_slot1_3_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_ep_ls_ar_s", FIELD_fld_ae_sem_ep_ls_ar_s, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_ep_ls_eo", FIELD_fld_ae_sem_ep_ls_eo, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_7_0", FIELD_fld_ae_slot2_7_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_11_4", FIELD_fld_ae_slot3_11_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_ep", FIELD_fld_ae_sem_arithmetic_ep, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_3_0", FIELD_fld_ae_slot2_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_ep1", FIELD_fld_ae_sem_arithmetic_ep1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_20_10", FIELD_fld_ae_slot2_20_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x2_S1_acc_ep", FIELD_fld_ae_sem_mul_x2_S1_acc_ep, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_20_14", FIELD_fld_ae_slot2_20_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x2_S2_acc_ep", FIELD_fld_ae_sem_mul_x2_S2_acc_ep, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_20_14", FIELD_fld_ae_slot3_20_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_e", FIELD_fld_ae_sem_shift_e, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_20_16", FIELD_fld_ae_slot3_20_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_i8", FIELD_fld_ae_sem_shift_i8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_11_11", FIELD_fld_ae_slot3_11_11, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_e", FIELD_fld_ae_sem_arithmetic_e, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_9_8", FIELD_fld_ae_slot2_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_7_4", FIELD_fld_ae_slot3_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_20_8", FIELD_fld_ae_slot2_20_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_11_8", FIELD_fld_ae_slot0_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_11_4", FIELD_fld_ae_slot0_11_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_20_10", FIELD_fld_ae_slot3_20_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_7_4", FIELD_fld_ae_slot2_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_8_4", FIELD_fld_ae2_slot0_8_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_8_4", FIELD_fld_ae_slot0_8_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_7_6", FIELD_fld_ae5_slot0_7_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_5_4", FIELD_fld_ae3_slot0_5_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_7_6", FIELD_fld_ae3_slot1_7_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_7_6", FIELD_fld_ae2_slot1_7_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_7_6", FIELD_fld_ae_slot1_7_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_5_0", FIELD_fld_ae3_slot0_5_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_4_0", FIELD_fld_ae3_slot0_4_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_4_0", FIELD_fld_ae_slot0_4_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_9_8", FIELD_fld_ae3_slot0_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_9_8", FIELD_fld_ae_slot0_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot0_15_12", FIELD_fld_ae7_slot0_15_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot1_15_12", FIELD_fld_ae7_slot1_15_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_5_4", FIELD_fld_ae5_slot0_5_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_21_14", FIELD_fld_ae5_slot0_21_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_7_6", FIELD_fld_ae3_slot0_7_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_21_14", FIELD_fld_ae3_slot0_21_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot0_7_7", FIELD_fld_ae7_slot0_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot1_7_7", FIELD_fld_ae7_slot1_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot1_7_7", FIELD_fld_ae6_slot1_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_7_7", FIELD_fld_ae5_slot0_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_5_5", FIELD_fld_ae3_slot0_5_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot1_7_7", FIELD_fld_ae3_slot1_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_4_4", FIELD_fld_ae2_slot0_4_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot1_7_7", FIELD_fld_ae2_slot1_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_4_4", FIELD_fld_ae_slot0_4_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot1_7_7", FIELD_fld_ae_slot1_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot0_15_12", FIELD_fld_ae6_slot0_15_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot0_7_7", FIELD_fld_ae6_slot0_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae7_slot0_7_6", FIELD_fld_ae7_slot0_7_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot1_7_6", FIELD_fld_ae6_slot1_7_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae6_slot1_14_6", FIELD_fld_ae6_slot1_14_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae5_slot0_3_2", FIELD_fld_ae5_slot0_3_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_5_2", FIELD_fld_ae3_slot0_5_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_5_2", FIELD_fld_ae2_slot0_5_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_5_2", FIELD_fld_ae_slot0_5_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_21_2", FIELD_fld_ae3_slot0_21_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_5_0", FIELD_fld_ae2_slot0_5_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_0_0", FIELD_fld_ae_slot3_0_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_3_2", FIELD_fld_ae_slot2_3_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_7_4", FIELD_fld_ae_slot0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_7_0", FIELD_fld_ae2_slot0_7_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_7_7", FIELD_fld_ae2_slot0_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_7_7", FIELD_fld_ae_slot0_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_20_13", FIELD_fld_ae_slot3_20_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae2_slot0_5_4", FIELD_fld_ae2_slot0_5_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_5_4", FIELD_fld_ae_slot0_5_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_13_12", FIELD_fld_ae_slot3_13_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_21_8", FIELD_fld_ae3_slot0_21_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_20_14", FIELD_fld_ae_slot0_20_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_5_0", FIELD_fld_ae_slot0_5_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae3_slot0_21_4", FIELD_fld_ae3_slot0_21_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_ar_vr", FIELD_fld_ae_sem_dr_to_ar_vr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_cmov_bt", FIELD_fld_ae_sem_cmov_bt, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_cmov_arr", FIELD_fld_ae_sem_cmov_arr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_vfpu2_sem_mov_vt", FIELD_fld_vfpu2_sem_mov_vt, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_vfpu2_sem_mov_vr", FIELD_fld_vfpu2_sem_mov_vr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_vfpu2_sem_spfma_vt", FIELD_fld_vfpu2_sem_spfma_vt, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_vfpu2_sem_spfma_vs", FIELD_fld_vfpu2_sem_spfma_vs, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_vfpu2_sem_spfma_vr", FIELD_fld_vfpu2_sem_spfma_vr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_vfpu2_sem_spmisc_brt", FIELD_fld_vfpu2_sem_spmisc_brt, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_vfpu2_sem_spmisc_vs", FIELD_fld_vfpu2_sem_spmisc_vs, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_vfpu2_sem_spmisc_vr", FIELD_fld_vfpu2_sem_spmisc_vr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_vfpu2_sem_mov_i_imm4", FIELD_fld_vfpu2_sem_mov_i_imm4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_vfpu2_sem_sp32cvt_vr", FIELD_fld_vfpu2_sem_sp32cvt_vr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_vfpu2_sem_sp32cvt_vt", FIELD_fld_vfpu2_sem_sp32cvt_vt, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_vfpu2_sem_sp32cvt_i_imm5", FIELD_fld_vfpu2_sem_sp32cvt_i_imm5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_vfpu2_sem_sp32cvt_arr", FIELD_fld_vfpu2_sem_sp32cvt_arr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot0_11_11", FIELD_fld_ae_slot0_11_11, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_vfpu2_sem_spmisc_vt", FIELD_fld_vfpu2_sem_spmisc_vt, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_vfpu2_sem_spmisc_vsM", FIELD_fld_vfpu2_sem_spmisc_vsM, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_20_18", FIELD_fld_ae_slot2_20_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_vfpu2_sem_spmisc_vtM", FIELD_fld_vfpu2_sem_spmisc_vtM, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_vfpu2_sem_spfma_i_imm1", FIELD_fld_vfpu2_sem_spfma_i_imm1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_vfpu2_sem_spfma_i_imm3", FIELD_fld_vfpu2_sem_spfma_i_imm3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_20_13", FIELD_fld_ae_slot2_20_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot3_20_15", FIELD_fld_ae_slot3_20_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_20_15", FIELD_fld_ae_slot2_20_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_movfpstate_v", FIELD_fld_ae_sem_movfpstate_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_slot2_20_4", FIELD_fld_ae_slot2_20_4, -1, 0, 0, 0, 0, 0, 0 },
  { "dfp_fld_op1", FIELD_dfp_fld_op1, -1, 0, 0, 0, 0, 0, 0 },
  { "dfp_fld_r_3", FIELD_dfp_fld_r_3, -1, 0, 0, 0, 0, 0, 0 },
  { "dfp_fld_r_3_1", FIELD_dfp_fld_r_3_1, -1, 0, 0, 0, 0, 0, 0 },
  { "dfp_fld_s_3_1", FIELD_dfp_fld_s_3_1, -1, 0, 0, 0, 0, 0, 0 },
  { "dfp_fld_op2_3", FIELD_dfp_fld_op2_3, -1, 0, 0, 0, 0, 0, 0 },
  { "dfp_fld_op2_3_2", FIELD_dfp_fld_op2_3_2, -1, 0, 0, 0, 0, 0, 0 },
  { "dfp_fld_op2_3_1", FIELD_dfp_fld_op2_3_1, -1, 0, 0, 0, 0, 0, 0 },
  { "s3to1", FIELD_s3to1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_SIGMOID_Q15_x", FIELD_fld_SIGMOID_Q15_x, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_SIGMOID_Q15_y", FIELD_fld_SIGMOID_Q15_y, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_3_0", FIELD_fld_Inst_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_SIGMOID_FP32_x", FIELD_fld_SIGMOID_FP32_x, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_SIGMOID_FP32_y", FIELD_fld_SIGMOID_FP32_y, -1, 0, 0, 0, 0, 0, 0 }
};

enum xtensa_operand_id {
  OPERAND_soffsetx4,
  OPERAND_immr,
  OPERAND_uimm12x8,
  OPERAND_simm4,
  OPERAND_arr,
  OPERAND_ars,
  OPERAND__ars_invisible,
  OPERAND_art,
  OPERAND_ar0,
  OPERAND_ar4,
  OPERAND_ar8,
  OPERAND_ar12,
  OPERAND_ars_entry,
  OPERAND_immrx4,
  OPERAND_lsi4x4,
  OPERAND_simm7,
  OPERAND_uimm6,
  OPERAND_ai4const,
  OPERAND_b4const,
  OPERAND_b4constu,
  OPERAND_immt,
  OPERAND_uimm8,
  OPERAND_uimm8x2,
  OPERAND_uimm8x4,
  OPERAND_uimm4x16,
  OPERAND_uimmrx4,
  OPERAND_simm8,
  OPERAND_simm8x256,
  OPERAND_simm12b,
  OPERAND_msalp32,
  OPERAND_op2p1,
  OPERAND_label8,
  OPERAND_ulabel8,
  OPERAND_label12,
  OPERAND_soffset,
  OPERAND_uimm16x4,
  OPERAND_bbi,
  OPERAND_sae,
  OPERAND_sas,
  OPERAND_sargt,
  OPERAND_s,
  OPERAND_mx,
  OPERAND_my,
  OPERAND_mw,
  OPERAND_mr0,
  OPERAND_mr1,
  OPERAND_mr2,
  OPERAND_mr3,
  OPERAND_imms,
  OPERAND_imms1,
  OPERAND_bt,
  OPERAND_bs,
  OPERAND_br,
  OPERAND_bt2,
  OPERAND_bs2,
  OPERAND_br2,
  OPERAND_bt4,
  OPERAND_bs4,
  OPERAND_br4,
  OPERAND_bt8,
  OPERAND_bs8,
  OPERAND_br8,
  OPERAND_bt16,
  OPERAND_bs16,
  OPERAND_br16,
  OPERAND_brall,
  OPERAND_tp7,
  OPERAND_xt_wbr15_label,
  OPERAND_xt_wbr18_label,
  OPERAND_ae_immls64neg,
  OPERAND_ae_immls64half,
  OPERAND_ae_ohba,
  OPERAND_ae_ohba2,
  OPERAND_ae_opnd_tp7,
  OPERAND_ae_imm2,
  OPERAND_ae_osa32,
  OPERAND_ae_osa64,
  OPERAND_ae_immls64,
  OPERAND_ae_immls64pos,
  OPERAND_ae_immls32,
  OPERAND_ae_immls16,
  OPERAND_ae_osa16,
  OPERAND_ae_selimm,
  OPERAND_ae_selimm_N,
  OPERAND_movi_imm,
  OPERAND_ae_arth_v,
  OPERAND_ae_arth_v0,
  OPERAND_ae_arth_v1,
  OPERAND_ae_ar_to_dr_v,
  OPERAND_ae_to_dr_v,
  OPERAND_ae_to_dr_v0,
  OPERAND_ae_dr_to_dr_v,
  OPERAND_ae_dr_to_dr_v0,
  OPERAND_ae_dr_to_dr_v1,
  OPERAND_ae_ls_v,
  OPERAND_ae_ls_av,
  OPERAND_ae_ls_v1,
  OPERAND_ae_ls_v2,
  OPERAND_ae_ls_uu,
  OPERAND_ae_ls_su,
  OPERAND_ae_uu_v,
  OPERAND_ae_uu_uu,
  OPERAND_ae_dr_to_ar_v0,
  OPERAND_ae_cmov_v,
  OPERAND_ae_cmov_v0,
  OPERAND_ae_pks_d,
  OPERAND_ae_pks_s,
  OPERAND_ae_shift_d,
  OPERAND_ae_shift_d0,
  OPERAND_ae_shift_sd,
  OPERAND_ae_uimm2x2,
  OPERAND_opnd_ae_sem_loads_stores_end,
  OPERAND_opnd_ae_sem_arithmetic_ds,
  OPERAND_opnd_ae_sem_rng_d,
  OPERAND_opnd_ae_sem_mul_x2_S1_d1,
  OPERAND_opnd_ae_sem_mul_x2_S1_d0,
  OPERAND_opnd_ae_sem_mul_x2_S1_q0,
  OPERAND_opnd_ae_sem_mul_x2_S2_d1,
  OPERAND_opnd_ae_sem_mul_x2_S2_d0,
  OPERAND_opnd_ae_sem_mul_x2_S2_q0,
  OPERAND_opnd_ae_sem_mul_x4_d1,
  OPERAND_opnd_ae_sem_mul_x4_d0,
  OPERAND_opnd_ae_sem_mul_x4_q0,
  OPERAND_opnd_ae_sem_mul_x4_q1,
  OPERAND_opnd_ae_sem_mul_x4_d2,
  OPERAND_opnd_ae_sem_mul_x2_S1_d2,
  OPERAND_opnd_ae_sem_mul_x2_S1_v1,
  OPERAND_opnd_ae_sem_mul_x2_S2_d2,
  OPERAND_opnd_ae_sem_mul_x2_S2_v1,
  OPERAND_opnd_ae_sem_ep_ls_ei,
  OPERAND_opnd_ae_sem_ep_ls_ar_s,
  OPERAND_opnd_ae_sem_ep_ls_eo,
  OPERAND_opnd_ae_sem_arithmetic_ep,
  OPERAND_opnd_ae_sem_arithmetic_ep1,
  OPERAND_opnd_ae_sem_mul_x2_S1_acc_ep,
  OPERAND_opnd_ae_sem_mul_x2_S2_acc_ep,
  OPERAND_opnd_ae_sem_shift_e,
  OPERAND_opnd_ae_sem_shift_i8,
  OPERAND_opnd_ae_sem_arithmetic_e,
  OPERAND_opnd_ae_sem_dr_to_ar_vr,
  OPERAND_opnd_ae_sem_cmov_bt,
  OPERAND_opnd_ae_sem_cmov_arr,
  OPERAND_opnd_vfpu2_sem_mov_vt,
  OPERAND_opnd_vfpu2_sem_mov_vr,
  OPERAND_opnd_vfpu2_sem_spfma_vt,
  OPERAND_opnd_vfpu2_sem_spfma_vs,
  OPERAND_opnd_vfpu2_sem_spfma_vr,
  OPERAND_opnd_vfpu2_sem_spmisc_brt,
  OPERAND_opnd_vfpu2_sem_spmisc_vs,
  OPERAND_opnd_vfpu2_sem_spmisc_vr,
  OPERAND_opnd_vfpu2_sem_mov_i_imm4,
  OPERAND_opnd_vfpu2_sem_spmisc_vt,
  OPERAND_opnd_vfpu2_sem_spmisc_vtM,
  OPERAND_opnd_vfpu2_sem_sp32cvt_vr,
  OPERAND_opnd_vfpu2_sem_sp32cvt_vt,
  OPERAND_opnd_vfpu2_sem_sp32cvt_i_imm5,
  OPERAND_opnd_vfpu2_sem_sp32cvt_arr,
  OPERAND_opnd_vfpu2_sem_spmisc_vsM,
  OPERAND_opnd_vfpu2_sem_spfma_i_imm1,
  OPERAND_opnd_vfpu2_sem_spfma_i_imm3,
  OPERAND_opnd_ae_sem_movfpstate_v,
  OPERAND_dfp_fld_op2_2,
  OPERAND_dfp_fld_op2_1_0,
  OPERAND_dfp_fld_r_0,
  OPERAND_dfp_fld_r_2_1,
  OPERAND_dfp_fld_op2,
  OPERAND_dfp_fld_op2_0,
  OPERAND_dfp_fld_s_0,
  OPERAND_bitindex,
  OPERAND_opnd_SIGMOID_Q15_x,
  OPERAND_opnd_SIGMOID_Q15_y,
  OPERAND_opnd_SIGMOID_FP32_x,
  OPERAND_opnd_SIGMOID_FP32_y,
  OPERAND_t,
  OPERAND_bbi4,
  OPERAND_imm12,
  OPERAND_imm8,
  OPERAND_imm12b,
  OPERAND_imm16,
  OPERAND_m,
  OPERAND_n,
  OPERAND_offset,
  OPERAND_op0,
  OPERAND_op1,
  OPERAND_op2,
  OPERAND_r,
  OPERAND_r_disp,
  OPERAND_r_3,
  OPERAND_sa4,
  OPERAND_sae4,
  OPERAND_sal,
  OPERAND_sas4,
  OPERAND_sr,
  OPERAND_st,
  OPERAND_thi3,
  OPERAND_imm4,
  OPERAND_mn,
  OPERAND_i,
  OPERAND_imm6lo,
  OPERAND_imm6hi,
  OPERAND_imm7lo,
  OPERAND_imm7hi,
  OPERAND_z,
  OPERAND_imm6,
  OPERAND_imm7,
  OPERAND_r3,
  OPERAND_rbit2,
  OPERAND_rhi,
  OPERAND_t3,
  OPERAND_tbit2,
  OPERAND_tlo,
  OPERAND_w,
  OPERAND_y,
  OPERAND_x,
  OPERAND_t2,
  OPERAND_s2,
  OPERAND_r2,
  OPERAND_t4,
  OPERAND_s4,
  OPERAND_r4,
  OPERAND_t8,
  OPERAND_s8,
  OPERAND_r8,
  OPERAND_xt_wbr15_imm,
  OPERAND_xt_wbr18_imm,
  OPERAND_ae_fld_fhba4,
  OPERAND_ae_fld_fhba4_2,
  OPERAND_ae_fld_tp7,
  OPERAND_ae_fld_osa32,
  OPERAND_ae_fld_osa64,
  OPERAND_ae_fld_imm2,
  OPERAND_ae_fld_immls64,
  OPERAND_ae_fld_immls64pos,
  OPERAND_ae_fld_immls64half,
  OPERAND_ae_fld_immls32,
  OPERAND_ae_fld_immls16,
  OPERAND_ae_fld_osa16,
  OPERAND_Inst_15_12,
  OPERAND_Inst_11_8,
  OPERAND_Inst_7_4,
  OPERAND_Inst_12,
  OPERAND_Inst_7,
  OPERAND_Inst_5_4,
  OPERAND_Inst_7_6,
  OPERAND_Inst_19_17,
  OPERAND_Inst_19_18,
  OPERAND_Inst_9_8,
  OPERAND_Inst_4,
  OPERAND_ae_fld_ls_v,
  OPERAND_ae_fld_ls_uu,
  OPERAND_ae_fld_ls_su,
  OPERAND_ae_fld_ls_av,
  OPERAND_ae_fld_ls_v1,
  OPERAND_ae_fld_ls_v2,
  OPERAND_ae_fld_cmpp_v0,
  OPERAND_ae_fld_cmpp_v1,
  OPERAND_ae_fld_cmpp_v,
  OPERAND_ae_fld_uu_v,
  OPERAND_ae_fld_uu_uu,
  OPERAND_ae_fld_dr_to_ar_v0,
  OPERAND_ae_fld_cmov_v,
  OPERAND_ae_fld_cmov_v0,
  OPERAND_ae_fld_pks_d,
  OPERAND_ae_fld_pks_s,
  OPERAND_ae_fld_shift_d,
  OPERAND_ae_fld_shift_d0,
  OPERAND_ae_fld_shift_sd,
  OPERAND_ae_fld_dr_to_dr_v,
  OPERAND_ae_fld_dr_to_dr_v0,
  OPERAND_ae_fld_dr_to_dr_v1,
  OPERAND_ae_fld_to_dr_v,
  OPERAND_ae_fld_to_dr_v0,
  OPERAND_fld_ae_immls64neg,
  OPERAND_ae_fld_selimm,
  OPERAND_ae_fld_selimm_N,
  OPERAND_fld_ar_to_dr_imm,
  OPERAND_ae_fld_arth_v,
  OPERAND_ae_fld_arth_v0,
  OPERAND_ae_fld_arth_v1,
  OPERAND_ae_fld_ar_to_dr_v,
  OPERAND_fld_Inst_23_12,
  OPERAND_fld_Inst_23_16,
  OPERAND_fld_Inst_7_7,
  OPERAND_fld_Inst_11_8,
  OPERAND_fld_Inst_13_8,
  OPERAND_fld_Inst_12_8,
  OPERAND_fld_Inst_9_8,
  OPERAND_fld_Inst_4_4,
  OPERAND_fld_Inst_5_4,
  OPERAND_fld_Inst_7_4,
  OPERAND_ae_fld_Inst16b_12,
  OPERAND_ae_fld_Inst16b_15_13,
  OPERAND_fld_ae4_slot0_7_4,
  OPERAND_fld_ae2_slot0_11_4,
  OPERAND_fld_ae2_slot0_7_4,
  OPERAND_fld_ae4_slot0_27_24,
  OPERAND_fld_ae2_slot0_11_9,
  OPERAND_fld_ae2_slot0_28_27,
  OPERAND_fld_ae4_slot0_27_23,
  OPERAND_fld_ae2_slot0_11_8,
  OPERAND_fld_ae5_slot0_21_8,
  OPERAND_fld_ae4_slot1_13_8,
  OPERAND_fld_ae3_slot1_19_8,
  OPERAND_fld_ae4_slot1_13_11,
  OPERAND_fld_ae5_slot0_3_0,
  OPERAND_fld_ae3_slot0_3_0,
  OPERAND_fld_ae3_slot1_3_0,
  OPERAND_fld_ae2_slot0_3_0,
  OPERAND_fld_ae2_slot1_3_0,
  OPERAND_fld_ae_slot0_3_0,
  OPERAND_fld_ae_slot1_3_0,
  OPERAND_fld_ae5_slot0_21_12,
  OPERAND_fld_ae4_slot1_13_12,
  OPERAND_fld_ae3_slot0_21_12,
  OPERAND_fld_ae3_slot1_19_12,
  OPERAND_fld_ae2_slot1_19_12,
  OPERAND_fld_ae_slot1_19_12,
  OPERAND_fld_ae5_slot0_21_16,
  OPERAND_fld_ae3_slot0_21_16,
  OPERAND_fld_ae3_slot1_19_16,
  OPERAND_fld_ae2_slot1_19_16,
  OPERAND_fld_ae_slot1_19_16,
  OPERAND_fld_ae5_slot0_21_17,
  OPERAND_fld_ae3_slot0_21_17,
  OPERAND_fld_ae3_slot1_19_17,
  OPERAND_fld_ae2_slot0_28_17,
  OPERAND_fld_ae2_slot1_19_17,
  OPERAND_fld_ae_slot1_19_17,
  OPERAND_fld_ae5_slot0_21_20,
  OPERAND_fld_ae3_slot0_21_20,
  OPERAND_fld_ae2_slot0_28_20,
  OPERAND_fld_ae5_slot0_7_4,
  OPERAND_fld_ae3_slot0_7_4,
  OPERAND_fld_ae7_slot0_15_0,
  OPERAND_fld_ae7_slot1_15_0,
  OPERAND_fld_ae7_slot2_18_0,
  OPERAND_fld_ae7_slot3_18_0,
  OPERAND_fld_ae6_slot0_15_0,
  OPERAND_fld_ae6_slot1_14_0,
  OPERAND_fld_ae6_slot2_13_0,
  OPERAND_fld_ae6_slot3_17_0,
  OPERAND_fld_ae5_slot0_21_0,
  OPERAND_fld_ae5_slot1_0_0,
  OPERAND_fld_ae5_slot2_19_0,
  OPERAND_fld_ae4_slot0_2_0,
  OPERAND_fld_ae4_slot0_27_3,
  OPERAND_fld_ae4_slot1_13_0,
  OPERAND_fld_ae3_slot0_21_0,
  OPERAND_fld_ae3_slot1_19_0,
  OPERAND_fld_ae2_slot1_19_0,
  OPERAND_fld_ae2_slot2_24_0,
  OPERAND_fld_ae_slot0_20_0,
  OPERAND_fld_ae_slot1_19_0,
  OPERAND_fld_ae_slot2_20_0,
  OPERAND_fld_ae3_slot1_7_4,
  OPERAND_fld_ae5_slot0_21_13,
  OPERAND_fld_ae3_slot0_21_13,
  OPERAND_fld_ae3_slot1_19_13,
  OPERAND_fld_ae2_slot0_28_13,
  OPERAND_fld_ae2_slot1_19_13,
  OPERAND_fld_ae_slot0_20_15,
  OPERAND_fld_ae_slot1_19_13,
  OPERAND_fld_ae_slot0_20_13,
  OPERAND_fld_ae3_slot1_19_4,
  OPERAND_fld_ae2_slot0_28_4,
  OPERAND_fld_ae2_slot1_19_4,
  OPERAND_fld_ae_slot0_20_4,
  OPERAND_fld_ae_slot1_19_4,
  OPERAND_fld_ae3_slot1_7_1,
  OPERAND_fld_ae2_slot1_19_9,
  OPERAND_fld_ae_slot1_19_9,
  OPERAND_fld_ae2_slot0_3_2,
  OPERAND_fld_ae_slot0_3_2,
  OPERAND_fld_ae2_slot0_0_0,
  OPERAND_fld_ae_slot0_0_0,
  OPERAND_fld_ae2_slot0_28_12,
  OPERAND_fld_ae_slot0_20_12,
  OPERAND_fld_ae7_slot0_7_4,
  OPERAND_fld_ae7_slot1_7_4,
  OPERAND_fld_ae5_slot0_11_8,
  OPERAND_fld_ae3_slot0_11_8,
  OPERAND_fld_ae5_slot0_21_6,
  OPERAND_fld_ae_sem_loads_stores_end,
  OPERAND_fld_ae2_slot1_7_4,
  OPERAND_fld_ae_slot1_7_4,
  OPERAND_fld_ae2_slot0_28_8,
  OPERAND_fld_ae2_slot1_19_8,
  OPERAND_fld_ae_slot0_20_8,
  OPERAND_fld_ae_slot1_19_8,
  OPERAND_fld_ae6_slot1_14_12,
  OPERAND_fld_ae6_slot2_3_0,
  OPERAND_fld_ae_sem_arithmetic_ds,
  OPERAND_fld_ae6_slot3_17_16,
  OPERAND_fld_ae_slot3_20_0,
  OPERAND_fld_ae_sem_rng_d,
  OPERAND_fld_ae_slot3_3_0,
  OPERAND_fld_ae3_slot0_8_8,
  OPERAND_fld_ae_slot0_8_8,
  OPERAND_fld_ae_slot3_1_0,
  OPERAND_fld_ae2_slot0_11_0,
  OPERAND_fld_ae_slot0_11_0,
  OPERAND_fld_ae2_slot1_7_0,
  OPERAND_fld_ae_slot0_7_0,
  OPERAND_fld_ae2_slot0_28_16,
  OPERAND_fld_ae_slot0_20_16,
  OPERAND_fld_ae_slot3_20_8,
  OPERAND_fld_ae2_slot0_9_4,
  OPERAND_fld_ae_slot0_9_4,
  OPERAND_fld_ae_sem_mul_x2_S1_d1,
  OPERAND_fld_ae_sem_mul_x2_S1_d0,
  OPERAND_fld_ae_sem_mul_x2_S1_q0,
  OPERAND_fld_ae_sem_mul_x2_S2_d1,
  OPERAND_fld_ae_sem_mul_x2_S2_d0,
  OPERAND_fld_ae_sem_mul_x2_S2_q0,
  OPERAND_fld_ae_sem_mul_x4_d1,
  OPERAND_fld_ae_sem_mul_x4_d0,
  OPERAND_fld_ae_sem_mul_x4_q0,
  OPERAND_fld_ae6_slot2_13_12,
  OPERAND_fld_ae_sem_mul_x4_q1,
  OPERAND_fld_ae2_slot2_24_16,
  OPERAND_fld_ae_sem_mul_x4_d2,
  OPERAND_fld_ae2_slot2_24_20,
  OPERAND_fld_ae7_slot2_18_16,
  OPERAND_fld_ae2_slot2_7_4,
  OPERAND_fld_ae7_slot3_18_16,
  OPERAND_fld_ae_sem_mul_x2_S1_d2,
  OPERAND_fld_ae_sem_mul_x2_S1_v1,
  OPERAND_fld_ae_sem_mul_x2_S2_d2,
  OPERAND_fld_ae_sem_mul_x2_S2_v1,
  OPERAND_fld_ae5_slot2_19_12,
  OPERAND_fld_ae_slot2_20_12,
  OPERAND_fld_ae_slot3_20_12,
  OPERAND_fld_ae5_slot0_21_4,
  OPERAND_fld_ae_sem_ep_ls_ei,
  OPERAND_fld_ae3_slot0_3_2,
  OPERAND_fld_ae3_slot1_3_2,
  OPERAND_fld_ae_sem_ep_ls_ar_s,
  OPERAND_fld_ae_sem_ep_ls_eo,
  OPERAND_fld_ae_slot2_7_0,
  OPERAND_fld_ae_slot3_11_4,
  OPERAND_fld_ae_sem_arithmetic_ep,
  OPERAND_fld_ae_slot2_3_0,
  OPERAND_fld_ae_sem_arithmetic_ep1,
  OPERAND_fld_ae_slot2_20_10,
  OPERAND_fld_ae_sem_mul_x2_S1_acc_ep,
  OPERAND_fld_ae_slot2_20_14,
  OPERAND_fld_ae_sem_mul_x2_S2_acc_ep,
  OPERAND_fld_ae_slot3_20_14,
  OPERAND_fld_ae_sem_shift_e,
  OPERAND_fld_ae_slot3_20_16,
  OPERAND_fld_ae_sem_shift_i8,
  OPERAND_fld_ae_slot3_11_11,
  OPERAND_fld_ae_sem_arithmetic_e,
  OPERAND_fld_ae_slot2_9_8,
  OPERAND_fld_ae_slot3_7_4,
  OPERAND_fld_ae_slot2_20_8,
  OPERAND_fld_ae_slot0_11_8,
  OPERAND_fld_ae_slot0_11_4,
  OPERAND_fld_ae_slot3_20_10,
  OPERAND_fld_ae_slot2_7_4,
  OPERAND_fld_ae2_slot0_8_4,
  OPERAND_fld_ae_slot0_8_4,
  OPERAND_fld_ae5_slot0_7_6,
  OPERAND_fld_ae3_slot0_5_4,
  OPERAND_fld_ae3_slot1_7_6,
  OPERAND_fld_ae2_slot1_7_6,
  OPERAND_fld_ae_slot1_7_6,
  OPERAND_fld_ae3_slot0_5_0,
  OPERAND_fld_ae3_slot0_4_0,
  OPERAND_fld_ae_slot0_4_0,
  OPERAND_fld_ae3_slot0_9_8,
  OPERAND_fld_ae_slot0_9_8,
  OPERAND_fld_ae7_slot0_15_12,
  OPERAND_fld_ae7_slot1_15_12,
  OPERAND_fld_ae5_slot0_5_4,
  OPERAND_fld_ae5_slot0_21_14,
  OPERAND_fld_ae3_slot0_7_6,
  OPERAND_fld_ae3_slot0_21_14,
  OPERAND_fld_ae7_slot0_7_7,
  OPERAND_fld_ae7_slot1_7_7,
  OPERAND_fld_ae6_slot1_7_7,
  OPERAND_fld_ae5_slot0_7_7,
  OPERAND_fld_ae3_slot0_5_5,
  OPERAND_fld_ae3_slot1_7_7,
  OPERAND_fld_ae2_slot0_4_4,
  OPERAND_fld_ae2_slot1_7_7,
  OPERAND_fld_ae_slot0_4_4,
  OPERAND_fld_ae_slot1_7_7,
  OPERAND_fld_ae6_slot0_15_12,
  OPERAND_fld_ae6_slot0_7_7,
  OPERAND_fld_ae7_slot0_7_6,
  OPERAND_fld_ae6_slot1_7_6,
  OPERAND_fld_ae6_slot1_14_6,
  OPERAND_fld_ae5_slot0_3_2,
  OPERAND_fld_ae3_slot0_5_2,
  OPERAND_fld_ae2_slot0_5_2,
  OPERAND_fld_ae_slot0_5_2,
  OPERAND_fld_ae3_slot0_21_2,
  OPERAND_fld_ae2_slot0_5_0,
  OPERAND_fld_ae_slot3_0_0,
  OPERAND_fld_ae_slot2_3_2,
  OPERAND_fld_ae_slot0_7_4,
  OPERAND_fld_ae2_slot0_7_0,
  OPERAND_fld_ae2_slot0_7_7,
  OPERAND_fld_ae_slot0_7_7,
  OPERAND_fld_ae_slot3_20_13,
  OPERAND_fld_ae2_slot0_5_4,
  OPERAND_fld_ae_slot0_5_4,
  OPERAND_fld_ae_slot3_13_12,
  OPERAND_fld_ae3_slot0_21_8,
  OPERAND_fld_ae_slot0_20_14,
  OPERAND_fld_ae_slot0_5_0,
  OPERAND_fld_ae3_slot0_21_4,
  OPERAND_fld_ae_sem_dr_to_ar_vr,
  OPERAND_fld_ae_sem_cmov_bt,
  OPERAND_fld_ae_sem_cmov_arr,
  OPERAND_fld_vfpu2_sem_mov_vt,
  OPERAND_fld_vfpu2_sem_mov_vr,
  OPERAND_fld_vfpu2_sem_spfma_vt,
  OPERAND_fld_vfpu2_sem_spfma_vs,
  OPERAND_fld_vfpu2_sem_spfma_vr,
  OPERAND_fld_vfpu2_sem_spmisc_brt,
  OPERAND_fld_vfpu2_sem_spmisc_vs,
  OPERAND_fld_vfpu2_sem_spmisc_vr,
  OPERAND_fld_vfpu2_sem_mov_i_imm4,
  OPERAND_fld_vfpu2_sem_sp32cvt_vr,
  OPERAND_fld_vfpu2_sem_sp32cvt_vt,
  OPERAND_fld_vfpu2_sem_sp32cvt_i_imm5,
  OPERAND_fld_vfpu2_sem_sp32cvt_arr,
  OPERAND_fld_ae_slot0_11_11,
  OPERAND_fld_vfpu2_sem_spmisc_vt,
  OPERAND_fld_vfpu2_sem_spmisc_vsM,
  OPERAND_fld_ae_slot2_20_18,
  OPERAND_fld_vfpu2_sem_spmisc_vtM,
  OPERAND_fld_vfpu2_sem_spfma_i_imm1,
  OPERAND_fld_vfpu2_sem_spfma_i_imm3,
  OPERAND_fld_ae_slot2_20_13,
  OPERAND_fld_ae_slot3_20_15,
  OPERAND_fld_ae_slot2_20_15,
  OPERAND_fld_ae_sem_movfpstate_v,
  OPERAND_fld_ae_slot2_20_4,
  OPERAND_dfp_fld_op1,
  OPERAND_dfp_fld_r_3,
  OPERAND_dfp_fld_r_3_1,
  OPERAND_dfp_fld_s_3_1,
  OPERAND_dfp_fld_op2_3,
  OPERAND_dfp_fld_op2_3_2,
  OPERAND_dfp_fld_op2_3_1,
  OPERAND_s3to1,
  OPERAND_fld_SIGMOID_Q15_x,
  OPERAND_fld_SIGMOID_Q15_y,
  OPERAND_fld_Inst_3_0,
  OPERAND_fld_SIGMOID_FP32_x,
  OPERAND_fld_SIGMOID_FP32_y
};


/* Iclass table.  */

static xtensa_arg_internal Iclass_xt_iclass_rfe_stateArgs[] = {
  { { STATE_PSEXCM }, 'o' },
  { { STATE_EPC1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfde_stateArgs[] = {
  { { STATE_DEPC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_call12_args[] = {
  { { OPERAND_soffsetx4 }, 'i' },
  { { OPERAND_ar12 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call12_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call8_args[] = {
  { { OPERAND_soffsetx4 }, 'i' },
  { { OPERAND_ar8 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call8_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call4_args[] = {
  { { OPERAND_soffsetx4 }, 'i' },
  { { OPERAND_ar4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call4_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx12_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ar12 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx12_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx8_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ar8 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx8_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx4_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ar4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx4_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_entry_args[] = {
  { { OPERAND_ars_entry }, 's' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm12x8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_entry_stateArgs[] = {
  { { STATE_PSCALLINC }, 'i' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSWOE }, 'i' },
  { { STATE_WindowBase }, 'm' },
  { { STATE_WindowStart }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_movsp_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_movsp_stateArgs[] = {
  { { STATE_WindowBase }, 'i' },
  { { STATE_WindowStart }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rotw_args[] = {
  { { OPERAND_simm4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rotw_stateArgs[] = {
  { { STATE_WindowBase }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_retw_args[] = {
  { { OPERAND__ars_invisible }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_retw_stateArgs[] = {
  { { STATE_WindowBase }, 'm' },
  { { STATE_WindowStart }, 'm' },
  { { STATE_PSCALLINC }, 'o' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSWOE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfwou_stateArgs[] = {
  { { STATE_EPC1 }, 'i' },
  { { STATE_PSEXCM }, 'o' },
  { { STATE_WindowBase }, 'm' },
  { { STATE_WindowStart }, 'm' },
  { { STATE_PSOWB }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l32e_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_immrx4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32e_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_immrx4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_windowbase_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_windowbase_stateArgs[] = {
  { { STATE_WindowBase }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_windowbase_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_windowbase_stateArgs[] = {
  { { STATE_WindowBase }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_windowbase_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_windowbase_stateArgs[] = {
  { { STATE_WindowBase }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_windowstart_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_windowstart_stateArgs[] = {
  { { STATE_WindowStart }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_windowstart_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_windowstart_stateArgs[] = {
  { { STATE_WindowStart }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_windowstart_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_windowstart_stateArgs[] = {
  { { STATE_WindowStart }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_add_n_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_addi_n_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ai4const }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bz6_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm6 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_loadi4_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_lsi4x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mov_n_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_movi_n_args[] = {
  { { OPERAND_ars }, 'o' },
  { { OPERAND_simm7 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_retn_args[] = {
  { { OPERAND__ars_invisible }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_storei4_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_lsi4x4 }, 'i' }
};

static xtensa_arg_internal Iclass_rur_threadptr_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_threadptr_stateArgs[] = {
  { { STATE_THREADPTR }, 'i' }
};

static xtensa_arg_internal Iclass_wur_threadptr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_threadptr_stateArgs[] = {
  { { STATE_THREADPTR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_addi_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_simm8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_addmi_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_simm8x256 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_addsub_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bit_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bsi8_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_b4const }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bsi8b_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_bbi }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bsi8u_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_b4constu }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bst8_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bsz12_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_label12 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_call0_args[] = {
  { { OPERAND_soffsetx4 }, 'i' },
  { { OPERAND_ar0 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx0_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ar0 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_exti_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_sae }, 'i' },
  { { OPERAND_op2p1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_jump_args[] = {
  { { OPERAND_soffset }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_jumpx_args[] = {
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l16ui_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l16si_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l32i_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l32r_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_uimm16x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l8i_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_loop_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ulabel8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_loop_stateArgs[] = {
  { { STATE_LBEG }, 'o' },
  { { STATE_LEND }, 'o' },
  { { STATE_LCOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_loopz_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ulabel8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_loopz_stateArgs[] = {
  { { STATE_LBEG }, 'o' },
  { { STATE_LEND }, 'o' },
  { { STATE_LCOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_movi_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_simm12b }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_movz_args[] = {
  { { OPERAND_arr }, 'm' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_neg_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_return_args[] = {
  { { OPERAND__ars_invisible }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s16i_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32i_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32nb_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimmrx4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s8i_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sar_args[] = {
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sar_stateArgs[] = {
  { { STATE_SAR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_sari_args[] = {
  { { OPERAND_sas }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sari_stateArgs[] = {
  { { STATE_SAR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_shifts_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shifts_stateArgs[] = {
  { { STATE_SAR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shiftst_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shiftst_stateArgs[] = {
  { { STATE_SAR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shiftt_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shiftt_stateArgs[] = {
  { { STATE_SAR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_slli_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_msalp32 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_srai_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_sargt }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_srli_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_s }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sync_stateArgs[] = {
  { { STATE_XTSYNC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsil_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_s }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsil_stateArgs[] = {
  { { STATE_PSWOE }, 'i' },
  { { STATE_PSCALLINC }, 'i' },
  { { STATE_PSOWB }, 'i' },
  { { STATE_PSUM }, 'i' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSINTLEVEL }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lend_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lend_stateArgs[] = {
  { { STATE_LEND }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lend_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lend_stateArgs[] = {
  { { STATE_LEND }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lend_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lend_stateArgs[] = {
  { { STATE_LEND }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lcount_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lcount_stateArgs[] = {
  { { STATE_LCOUNT }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lcount_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lcount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_LCOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lcount_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lcount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_LCOUNT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lbeg_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lbeg_stateArgs[] = {
  { { STATE_LBEG }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lbeg_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lbeg_stateArgs[] = {
  { { STATE_LBEG }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lbeg_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lbeg_stateArgs[] = {
  { { STATE_LBEG }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_sar_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_sar_stateArgs[] = {
  { { STATE_SAR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_sar_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_sar_stateArgs[] = {
  { { STATE_SAR }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_sar_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_sar_stateArgs[] = {
  { { STATE_SAR }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_memctl_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_memctl_stateArgs[] = {
  { { STATE_MEMCTL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_memctl_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_memctl_stateArgs[] = {
  { { STATE_MEMCTL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_memctl_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_memctl_stateArgs[] = {
  { { STATE_MEMCTL }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_litbase_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_litbase_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_litbase_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_configid0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_configid0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_configid1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ps_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ps_stateArgs[] = {
  { { STATE_PSWOE }, 'i' },
  { { STATE_PSCALLINC }, 'i' },
  { { STATE_PSOWB }, 'i' },
  { { STATE_PSUM }, 'i' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSINTLEVEL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ps_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ps_stateArgs[] = {
  { { STATE_PSWOE }, 'o' },
  { { STATE_PSCALLINC }, 'o' },
  { { STATE_PSOWB }, 'o' },
  { { STATE_PSUM }, 'o' },
  { { STATE_PSEXCM }, 'o' },
  { { STATE_PSINTLEVEL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ps_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ps_stateArgs[] = {
  { { STATE_PSWOE }, 'm' },
  { { STATE_PSCALLINC }, 'm' },
  { { STATE_PSOWB }, 'm' },
  { { STATE_PSUM }, 'm' },
  { { STATE_PSEXCM }, 'm' },
  { { STATE_PSINTLEVEL }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc1_stateArgs[] = {
  { { STATE_EPC1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc1_stateArgs[] = {
  { { STATE_EPC1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc1_stateArgs[] = {
  { { STATE_EPC1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave1_stateArgs[] = {
  { { STATE_EXCSAVE1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave1_stateArgs[] = {
  { { STATE_EXCSAVE1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave1_stateArgs[] = {
  { { STATE_EXCSAVE1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc2_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc2_stateArgs[] = {
  { { STATE_EPC2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc2_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc2_stateArgs[] = {
  { { STATE_EPC2 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc2_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc2_stateArgs[] = {
  { { STATE_EPC2 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave2_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave2_stateArgs[] = {
  { { STATE_EXCSAVE2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave2_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave2_stateArgs[] = {
  { { STATE_EXCSAVE2 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave2_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave2_stateArgs[] = {
  { { STATE_EXCSAVE2 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc3_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc3_stateArgs[] = {
  { { STATE_EPC3 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc3_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc3_stateArgs[] = {
  { { STATE_EPC3 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc3_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc3_stateArgs[] = {
  { { STATE_EPC3 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave3_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave3_stateArgs[] = {
  { { STATE_EXCSAVE3 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave3_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave3_stateArgs[] = {
  { { STATE_EXCSAVE3 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave3_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave3_stateArgs[] = {
  { { STATE_EXCSAVE3 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc4_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc4_stateArgs[] = {
  { { STATE_EPC4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc4_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc4_stateArgs[] = {
  { { STATE_EPC4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc4_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc4_stateArgs[] = {
  { { STATE_EPC4 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave4_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave4_stateArgs[] = {
  { { STATE_EXCSAVE4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave4_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave4_stateArgs[] = {
  { { STATE_EXCSAVE4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave4_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave4_stateArgs[] = {
  { { STATE_EXCSAVE4 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc5_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc5_stateArgs[] = {
  { { STATE_EPC5 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc5_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc5_stateArgs[] = {
  { { STATE_EPC5 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc5_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc5_stateArgs[] = {
  { { STATE_EPC5 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave5_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave5_stateArgs[] = {
  { { STATE_EXCSAVE5 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave5_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave5_stateArgs[] = {
  { { STATE_EXCSAVE5 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave5_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave5_stateArgs[] = {
  { { STATE_EXCSAVE5 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps2_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps2_stateArgs[] = {
  { { STATE_EPS2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps2_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps2_stateArgs[] = {
  { { STATE_EPS2 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps2_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps2_stateArgs[] = {
  { { STATE_EPS2 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps3_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps3_stateArgs[] = {
  { { STATE_EPS3 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps3_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps3_stateArgs[] = {
  { { STATE_EPS3 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps3_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps3_stateArgs[] = {
  { { STATE_EPS3 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps4_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps4_stateArgs[] = {
  { { STATE_EPS4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps4_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps4_stateArgs[] = {
  { { STATE_EPS4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps4_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps4_stateArgs[] = {
  { { STATE_EPS4 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps5_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps5_stateArgs[] = {
  { { STATE_EPS5 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps5_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps5_stateArgs[] = {
  { { STATE_EPS5 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps5_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps5_stateArgs[] = {
  { { STATE_EPS5 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excvaddr_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excvaddr_stateArgs[] = {
  { { STATE_EXCVADDR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excvaddr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excvaddr_stateArgs[] = {
  { { STATE_EXCVADDR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excvaddr_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excvaddr_stateArgs[] = {
  { { STATE_EXCVADDR }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_depc_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_depc_stateArgs[] = {
  { { STATE_DEPC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_depc_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_depc_stateArgs[] = {
  { { STATE_DEPC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_depc_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_depc_stateArgs[] = {
  { { STATE_DEPC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_exccause_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_exccause_stateArgs[] = {
  { { STATE_EXCCAUSE }, 'i' },
  { { STATE_XTSYNC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_exccause_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_exccause_stateArgs[] = {
  { { STATE_EXCCAUSE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_exccause_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_exccause_stateArgs[] = {
  { { STATE_EXCCAUSE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_misc0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_misc0_stateArgs[] = {
  { { STATE_MISC0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_misc0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_misc0_stateArgs[] = {
  { { STATE_MISC0 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_misc0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_misc0_stateArgs[] = {
  { { STATE_MISC0 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_misc1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_misc1_stateArgs[] = {
  { { STATE_MISC1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_misc1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_misc1_stateArgs[] = {
  { { STATE_MISC1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_misc1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_misc1_stateArgs[] = {
  { { STATE_MISC1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_prid_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_vecbase_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_vecbase_stateArgs[] = {
  { { STATE_VECBASE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_vecbase_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_vecbase_stateArgs[] = {
  { { STATE_VECBASE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_vecbase_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_vecbase_stateArgs[] = {
  { { STATE_VECBASE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_mul16_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_mul32_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_mul32h_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_aa_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_aa_stateArgs[] = {
  { { STATE_ACC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_ad_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_my }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_ad_stateArgs[] = {
  { { STATE_ACC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_da_args[] = {
  { { OPERAND_mx }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_da_stateArgs[] = {
  { { STATE_ACC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_dd_args[] = {
  { { OPERAND_mx }, 'i' },
  { { OPERAND_my }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_dd_stateArgs[] = {
  { { STATE_ACC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_aa_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_aa_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_ad_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_my }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_ad_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_da_args[] = {
  { { OPERAND_mx }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_da_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_dd_args[] = {
  { { OPERAND_mx }, 'i' },
  { { OPERAND_my }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16a_dd_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16al_da_args[] = {
  { { OPERAND_mw }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_mx }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16al_da_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16al_dd_args[] = {
  { { OPERAND_mw }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_mx }, 'i' },
  { { OPERAND_my }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16al_dd_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_mac16_l_args[] = {
  { { OPERAND_mw }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_m0_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_mr0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_m0_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_mr0 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_m0_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_mr0 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_m1_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_mr1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_m1_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_mr1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_m1_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_mr1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_m2_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_mr2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_m2_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_mr2 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_m2_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_mr2 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_m3_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_mr3 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_m3_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_mr3 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_m3_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_mr3 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_acclo_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_acclo_stateArgs[] = {
  { { STATE_ACC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_acclo_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_acclo_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_acclo_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_acclo_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_acchi_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_acchi_stateArgs[] = {
  { { STATE_ACC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_acchi_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_acchi_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_acchi_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_acchi_stateArgs[] = {
  { { STATE_ACC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfi_args[] = {
  { { OPERAND_s }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfi_stateArgs[] = {
  { { STATE_PSWOE }, 'o' },
  { { STATE_PSCALLINC }, 'o' },
  { { STATE_PSOWB }, 'o' },
  { { STATE_PSUM }, 'o' },
  { { STATE_PSEXCM }, 'o' },
  { { STATE_PSINTLEVEL }, 'o' },
  { { STATE_EPC1 }, 'i' },
  { { STATE_EPC2 }, 'i' },
  { { STATE_EPC3 }, 'i' },
  { { STATE_EPC4 }, 'i' },
  { { STATE_EPC5 }, 'i' },
  { { STATE_EPS2 }, 'i' },
  { { STATE_EPS3 }, 'i' },
  { { STATE_EPS4 }, 'i' },
  { { STATE_EPS5 }, 'i' },
  { { STATE_InOCDMode }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_wait_args[] = {
  { { OPERAND_s }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wait_stateArgs[] = {
  { { STATE_PSINTLEVEL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_interrupt_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_interrupt_stateArgs[] = {
  { { STATE_INTERRUPT }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intset_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intset_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intclear_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intclear_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_intenable_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_intenable_stateArgs[] = {
  { { STATE_INTENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intenable_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intenable_stateArgs[] = {
  { { STATE_INTENABLE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_intenable_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_intenable_stateArgs[] = {
  { { STATE_INTENABLE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_break_args[] = {
  { { OPERAND_imms }, 'i' },
  { { OPERAND_immt }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_break_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSINTLEVEL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_break_n_args[] = {
  { { OPERAND_imms }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_break_n_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSINTLEVEL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreaka0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreaka0_stateArgs[] = {
  { { STATE_DBREAKA0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreaka0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreaka0_stateArgs[] = {
  { { STATE_DBREAKA0 }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreaka0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreaka0_stateArgs[] = {
  { { STATE_DBREAKA0 }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreakc0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreakc0_stateArgs[] = {
  { { STATE_DBREAKC0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreakc0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreakc0_stateArgs[] = {
  { { STATE_DBREAKC0 }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreakc0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreakc0_stateArgs[] = {
  { { STATE_DBREAKC0 }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreaka1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreaka1_stateArgs[] = {
  { { STATE_DBREAKA1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreaka1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreaka1_stateArgs[] = {
  { { STATE_DBREAKA1 }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreaka1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreaka1_stateArgs[] = {
  { { STATE_DBREAKA1 }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreakc1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreakc1_stateArgs[] = {
  { { STATE_DBREAKC1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreakc1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreakc1_stateArgs[] = {
  { { STATE_DBREAKC1 }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreakc1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreakc1_stateArgs[] = {
  { { STATE_DBREAKC1 }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreaka0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreaka0_stateArgs[] = {
  { { STATE_IBREAKA0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreaka0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreaka0_stateArgs[] = {
  { { STATE_IBREAKA0 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreaka0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreaka0_stateArgs[] = {
  { { STATE_IBREAKA0 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreaka1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreaka1_stateArgs[] = {
  { { STATE_IBREAKA1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreaka1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreaka1_stateArgs[] = {
  { { STATE_IBREAKA1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreaka1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreaka1_stateArgs[] = {
  { { STATE_IBREAKA1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreakenable_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreakenable_stateArgs[] = {
  { { STATE_IBREAKENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreakenable_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreakenable_stateArgs[] = {
  { { STATE_IBREAKENABLE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreakenable_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreakenable_stateArgs[] = {
  { { STATE_IBREAKENABLE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_debugcause_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_debugcause_stateArgs[] = {
  { { STATE_DEBUGCAUSE }, 'i' },
  { { STATE_DBNUM }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_debugcause_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_debugcause_stateArgs[] = {
  { { STATE_DEBUGCAUSE }, 'o' },
  { { STATE_DBNUM }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_debugcause_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_debugcause_stateArgs[] = {
  { { STATE_DEBUGCAUSE }, 'm' },
  { { STATE_DBNUM }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_icount_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_icount_stateArgs[] = {
  { { STATE_ICOUNT }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_icount_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_icount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_ICOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_icount_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_icount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_ICOUNT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_icountlevel_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_icountlevel_stateArgs[] = {
  { { STATE_ICOUNTLEVEL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_icountlevel_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_icountlevel_stateArgs[] = {
  { { STATE_ICOUNTLEVEL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_icountlevel_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_icountlevel_stateArgs[] = {
  { { STATE_ICOUNTLEVEL }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ddr_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ddr_stateArgs[] = {
  { { STATE_DDR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ddr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ddr_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_DDR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ddr_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ddr_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_DDR }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_lddr32_p_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_lddr32_p_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_InOCDMode }, 'i' },
  { { STATE_DDR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_sddr32_p_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_sddr32_p_stateArgs[] = {
  { { STATE_InOCDMode }, 'i' },
  { { STATE_DDR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfdo_args[] = {
  { { OPERAND_imms }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfdo_stateArgs[] = {
  { { STATE_InOCDMode }, 'm' },
  { { STATE_EPC4 }, 'i' },
  { { STATE_PSWOE }, 'o' },
  { { STATE_PSCALLINC }, 'o' },
  { { STATE_PSOWB }, 'o' },
  { { STATE_PSUM }, 'o' },
  { { STATE_PSEXCM }, 'o' },
  { { STATE_PSINTLEVEL }, 'o' },
  { { STATE_EPS4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfdd_stateArgs[] = {
  { { STATE_InOCDMode }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_mmid_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_mmid_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_bbool1_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_bs }, 'i' },
  { { OPERAND_bt }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bbool4_args[] = {
  { { OPERAND_bt }, 'o' },
  { { OPERAND_bs4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bbool8_args[] = {
  { { OPERAND_bt }, 'o' },
  { { OPERAND_bs8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bbranch_args[] = {
  { { OPERAND_bs }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bmove_args[] = {
  { { OPERAND_arr }, 'm' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_bt }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_RSR_BR_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_brall }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_WSR_BR_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_brall }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_XSR_BR_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_brall }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccount_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccount_stateArgs[] = {
  { { STATE_CCOUNT }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccount_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_CCOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccount_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_CCOUNT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare0_stateArgs[] = {
  { { STATE_CCOMPARE0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare0_stateArgs[] = {
  { { STATE_CCOMPARE0 }, 'o' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare0_stateArgs[] = {
  { { STATE_CCOMPARE0 }, 'm' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare1_stateArgs[] = {
  { { STATE_CCOMPARE1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare1_stateArgs[] = {
  { { STATE_CCOMPARE1 }, 'o' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare1_stateArgs[] = {
  { { STATE_CCOMPARE1 }, 'm' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_icache_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_icache_lock_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm4x16 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_icache_inv_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_licx_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sicx_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_dcache_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_dcache_dyn_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_dcache_ind_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm4x16 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_dcache_inv_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_dpf_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_dpfb_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_dpdngrd_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_dcache_lock_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm4x16 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sdct_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_ldct_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_prefctl_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_prefctl_stateArgs[] = {
  { { STATE_PREFCTL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_prefctl_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_prefctl_stateArgs[] = {
  { { STATE_PREFCTL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_prefctl_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_prefctl_stateArgs[] = {
  { { STATE_PREFCTL }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_idtlb_args[] = {
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_idtlb_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rdtlb_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wdtlb_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wdtlb_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_iitlb_args[] = {
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_ritlb_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_witlb_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_cpenable_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_cpenable_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_cpenable_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_cpenable_stateArgs[] = {
  { { STATE_CPENABLE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_cpenable_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_cpenable_stateArgs[] = {
  { { STATE_CPENABLE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_clamp_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_tp7 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_minmax_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_nsa_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sx_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_tp7 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l32ai_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32ri_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32c1i_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32c1i_stateArgs[] = {
  { { STATE_SCOMPARE1 }, 'i' },
  { { STATE_XTSYNC }, 'i' },
  { { STATE_SCOMPARE1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_scompare1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_scompare1_stateArgs[] = {
  { { STATE_SCOMPARE1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_scompare1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_scompare1_stateArgs[] = {
  { { STATE_SCOMPARE1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_scompare1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_scompare1_stateArgs[] = {
  { { STATE_SCOMPARE1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_atomctl_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_atomctl_stateArgs[] = {
  { { STATE_ATOMCTL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_atomctl_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_atomctl_stateArgs[] = {
  { { STATE_ATOMCTL }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_atomctl_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_atomctl_stateArgs[] = {
  { { STATE_ATOMCTL }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_div_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rer_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rer_stateArgs[] = {
  { { STATE_ERI_RAW_INTERLOCK }, 'i' }
};

static xtensa_interface Iclass_xt_iclass_rer_intfArgs[] = {
  INTERFACE_ERI_RD_In,
  INTERFACE_ERI_RD_Out
};

static xtensa_arg_internal Iclass_xt_iclass_wer_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wer_stateArgs[] = {
  { { STATE_ERI_RAW_INTERLOCK }, 'o' }
};

static xtensa_interface Iclass_xt_iclass_wer_intfArgs[] = {
  INTERFACE_ERI_WR_In,
  INTERFACE_ERI_WR_Out
};

static xtensa_arg_internal Iclass_xt_iclass_wb15_0_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_xt_wbr15_label }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wb15_1_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_b4const }, 'i' },
  { { OPERAND_xt_wbr15_label }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wb15_2_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_b4constu }, 'i' },
  { { OPERAND_xt_wbr15_label }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wb15_3_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_bbi }, 'i' },
  { { OPERAND_xt_wbr15_label }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wb15_4_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_xt_wbr15_label }, 'i' }
};

static xtensa_arg_internal Iclass_rur_ae_ovf_sar_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_ovf_sar_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'i' },
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_ovf_sar_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_ovf_sar_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'o' },
  { { STATE_AE_SAR }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_ae_bithead_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_bithead_stateArgs[] = {
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_bithead_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_bithead_stateArgs[] = {
  { { STATE_AE_BITHEAD }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_ae_ts_fts_bu_bp_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_ts_fts_bu_bp_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_TABLESIZE }, 'i' },
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_ts_fts_bu_bp_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_ts_fts_bu_bp_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'o' },
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_AE_TABLESIZE }, 'o' },
  { { STATE_AE_FIRST_TS }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_ae_cw_sd_no_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_cw_sd_no_stateArgs[] = {
  { { STATE_AE_CWRAP }, 'i' },
  { { STATE_AE_NEXTOFFSET }, 'i' },
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cw_sd_no_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cw_sd_no_stateArgs[] = {
  { { STATE_AE_CWRAP }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_AE_SEARCHDONE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_ae_cbegin0_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_cbegin0_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cbegin0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cbegin0_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_ae_cend0_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_cend0_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cend0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cend0_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_ae_cbegin1_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_cbegin1_stateArgs[] = {
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cbegin1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cbegin1_stateArgs[] = {
  { { STATE_AE_CBEGIN1 }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_ae_cend1_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_ae_cend1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cend1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_ae_cend1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ic_sext16_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_ic_zext16_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_ic_clamps16_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_rur_fcr_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_fcr_stateArgs[] = {
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_fcr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_fcr_stateArgs[] = {
  { { STATE_RoundMode }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_rur_fsr_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_fsr_stateArgs[] = {
  { { STATE_InvalidFlag }, 'i' },
  { { STATE_DivZeroFlag }, 'i' },
  { { STATE_OverflowFlag }, 'i' },
  { { STATE_UnderflowFlag }, 'i' },
  { { STATE_InexactFlag }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_fsr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_fsr_stateArgs[] = {
  { { STATE_InvalidFlag }, 'o' },
  { { STATE_DivZeroFlag }, 'o' },
  { { STATE_OverflowFlag }, 'o' },
  { { STATE_UnderflowFlag }, 'o' },
  { { STATE_InexactFlag }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_F64ITER_args[] = {
  { { OPERAND_arr }, 'm' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_dfp_fld_op2_1_0 }, 'i' },
  { { OPERAND_dfp_fld_op2_2 }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_F64ITER_stateArgs[] = {
  { { STATE_F64R }, 'm' },
  { { STATE_F64S }, 'm' }
};

static xtensa_arg_internal Iclass_iclass_F64RND_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_dfp_fld_op2_1_0 }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_F64RND_stateArgs[] = {
  { { STATE_F64R }, 'm' },
  { { STATE_F64S }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_F64ADDC_F64SUBC_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_dfp_fld_r_2_1 }, 'i' },
  { { OPERAND_dfp_fld_r_0 }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_F64ADDC_F64SUBC_stateArgs[] = {
  { { STATE_F64S }, 'm' }
};

static xtensa_arg_internal Iclass_iclass_F64SIG_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_F64CMPL_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_F64CMPL_stateArgs[] = {
  { { STATE_F64S }, 'o' }
};

static xtensa_arg_internal Iclass_iclass_F64CMPH_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_dfp_fld_op2 }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_F64CMPH_stateArgs[] = {
  { { STATE_SAR }, 'o' },
  { { STATE_F64R }, 'o' },
  { { STATE_F64S }, 'm' }
};

static xtensa_arg_internal Iclass_iclass_F64NORM_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_dfp_fld_op2_0 }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_F64NORM_stateArgs[] = {
  { { STATE_SAR }, 'o' },
  { { STATE_F64S }, 'm' }
};

static xtensa_arg_internal Iclass_iclass_F64SEXP_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_RF64R_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_dfp_fld_s_0 }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_RF64R_stateArgs[] = {
  { { STATE_F64R }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_WF64R_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_dfp_fld_r_0 }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_WF64R_stateArgs[] = {
  { { STATE_F64R }, 'o' }
};

static xtensa_arg_internal Iclass_rur_f64r_lo_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_f64r_lo_stateArgs[] = {
  { { STATE_F64R }, 'i' }
};

static xtensa_arg_internal Iclass_wur_f64r_lo_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_f64r_lo_stateArgs[] = {
  { { STATE_F64R }, 'm' }
};

static xtensa_arg_internal Iclass_rur_f64r_hi_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_f64r_hi_stateArgs[] = {
  { { STATE_F64R }, 'i' }
};

static xtensa_arg_internal Iclass_wur_f64r_hi_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_f64r_hi_stateArgs[] = {
  { { STATE_F64R }, 'm' }
};

static xtensa_arg_internal Iclass_rur_f64s_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_f64s_stateArgs[] = {
  { { STATE_F64S }, 'i' }
};

static xtensa_arg_internal Iclass_wur_f64s_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_f64s_stateArgs[] = {
  { { STATE_F64S }, 'o' }
};

static xtensa_arg_internal Iclass_rur_expstate_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_expstate_stateArgs[] = {
  { { STATE_EXPSTATE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_expstate_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_expstate_stateArgs[] = {
  { { STATE_EXPSTATE }, 'o' }
};

static xtensa_arg_internal Iclass_iclass_READ_IMPWIRE_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_interface Iclass_iclass_READ_IMPWIRE_intfArgs[] = {
  INTERFACE_IMPWIRE
};

static xtensa_arg_internal Iclass_iclass_SETB_EXPSTATE_args[] = {
  { { OPERAND_bitindex }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_SETB_EXPSTATE_stateArgs[] = {
  { { STATE_EXPSTATE }, 'm' }
};

static xtensa_arg_internal Iclass_iclass_CLRB_EXPSTATE_args[] = {
  { { OPERAND_bitindex }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_CLRB_EXPSTATE_stateArgs[] = {
  { { STATE_EXPSTATE }, 'm' }
};

static xtensa_arg_internal Iclass_iclass_WRMSK_EXPSTATE_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_WRMSK_EXPSTATE_stateArgs[] = {
  { { STATE_EXPSTATE }, 'm' }
};

static xtensa_arg_internal Iclass_RUR_AE_OVERFLOW_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_OVERFLOW_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_OVERFLOW_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_OVERFLOW_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_SAR_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_SAR_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_SAR_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_SAR_stateArgs[] = {
  { { STATE_AE_SAR }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_BITPTR_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_BITPTR_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_BITPTR_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_BITPTR_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_BITSUSED_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_BITSUSED_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_BITSUSED_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_BITSUSED_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_TABLESIZE_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_TABLESIZE_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_TABLESIZE_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_TABLESIZE_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_FIRST_TS_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_FIRST_TS_stateArgs[] = {
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_FIRST_TS_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_FIRST_TS_stateArgs[] = {
  { { STATE_AE_FIRST_TS }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_NEXTOFFSET_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_NEXTOFFSET_stateArgs[] = {
  { { STATE_AE_NEXTOFFSET }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_NEXTOFFSET_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_NEXTOFFSET_stateArgs[] = {
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_SEARCHDONE_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_SEARCHDONE_stateArgs[] = {
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_SEARCHDONE_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_SEARCHDONE_stateArgs[] = {
  { { STATE_AE_SEARCHDONE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_CWRAP_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_CWRAP_stateArgs[] = {
  { { STATE_AE_CWRAP }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_CWRAP_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_CWRAP_stateArgs[] = {
  { { STATE_AE_CWRAP }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4F_I_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4F_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4F_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4F_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_XC1_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_XC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_I_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_IU_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_X_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_XU_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_XC1_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_XC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_I_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_X_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_XC1_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_XC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_I_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_X_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32F24_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_XC1_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_XC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_I_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_X_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_I_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_IU_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_X_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_XU_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_XC1_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_XC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_I_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_IU_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_X_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_XU_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_XC1_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_XC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_I_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64pos }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_RIP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64neg }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_RI_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64half }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_RI_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_RIC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_RIC1_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_RIC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_X_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2F24_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_XC1_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_XC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_I_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64pos }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_RIC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_L32X2_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_RIC1_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_L32X2_RIC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_X_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_XC1_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_XC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_I_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64pos }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_X_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_XC1_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_XC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_I_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_X_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'o' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_XC1_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_XC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_I_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_IU_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_X_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_XU_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_XC1_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_XC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_I_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64pos }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_RIP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_RIC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_RIC1_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_RIC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_X_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2F24_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_XC1_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_XC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_I_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64pos }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_RIC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S32X2_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_RIC1_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S32X2_RIC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_X_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2RNG_I_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2RNG_I_stateArgs[] = {
  { { STATE_AE_SAR }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2RNG_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64pos }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2RNG_IP_stateArgs[] = {
  { { STATE_AE_SAR }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2RNG_X_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2RNG_X_stateArgs[] = {
  { { STATE_AE_SAR }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2RNG_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2RNG_XP_stateArgs[] = {
  { { STATE_AE_SAR }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_XC1_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_XC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_I_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64pos }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_X_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_XC1_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_XC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_I_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_IU_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_X_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_XU_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_XC1_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_XC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_I_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_X_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32F24_L_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_XC1_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_XC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_I_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_X_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_XC1_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_XC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_I_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_X_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_XC1_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_XC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_I_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_X_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_XP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_XC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_I_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_IU_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_X_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_XU_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ZALIGN64_args[] = {
  { { OPERAND_ae_uu_uu }, 'o' }
};

static xtensa_arg_internal Iclass_AE_ZALIGN64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LALIGN64_I_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LALIGN64_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SALIGN64_I_args[] = {
  { { OPERAND_ae_ls_su }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SALIGN64_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVALIGN_args[] = {
  { { OPERAND_ae_uu_uu }, 'o' },
  { { OPERAND_ae_uu_v }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVALIGN_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA64_PP_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA64_PP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24POS_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24POS_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24X2POS_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24X2POS_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2POS_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2POS_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4POS_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4POS_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24NEG_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24NEG_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24X2NEG_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24X2NEG_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2NEG_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2NEG_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4NEG_PC_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4NEG_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24POS_PC1_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24POS_PC1_stateArgs[] = {
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24X2POS_PC1_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24X2POS_PC1_stateArgs[] = {
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2POS_PC1_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2POS_PC1_stateArgs[] = {
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4POS_PC1_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4POS_PC1_stateArgs[] = {
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24NEG_PC1_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24NEG_PC1_stateArgs[] = {
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24X2NEG_PC1_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24X2NEG_PC1_stateArgs[] = {
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2NEG_PC1_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2NEG_PC1_stateArgs[] = {
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4NEG_PC1_args[] = {
  { { OPERAND_ae_ls_uu }, 'o' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4NEG_PC1_stateArgs[] = {
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA64POS_FP_args[] = {
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA64POS_FP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA64NEG_FP_args[] = {
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA64NEG_FP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_IC_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_IC1_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_IC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_IP_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_RIP_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_RIC_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_RIC1_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_RIC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_IC_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_IC1_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_IC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_IP_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_RIP_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_RIC_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_RIC1_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_RIC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_IC_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_IC1_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_IC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_IP_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_RIP_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_RIC_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_RIC1_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2F24_RIC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24_IC_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24_IC1_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24_IC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24_IP_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24_RIP_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24_RIC_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24_RIC1_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24_RIC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_IC_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_IC1_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_IC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_IP_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_RIP_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_RIC_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_RIC1_args[] = {
  { { OPERAND_ae_ls_av }, 'o' },
  { { OPERAND_ae_ls_uu }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA24X2_RIC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_IC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_IC1_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_IC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_RIP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_RIC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_RIC1_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_RIC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_IC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_IC1_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_IC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_RIP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_RIC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_RIC1_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_RIC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_IC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_IC1_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_IC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_RIP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_RIC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_RIC1_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2F24_RIC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_IC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_IC1_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_IC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_RIP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_RIC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_RIC1_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24_L_RIC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_IC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_IC1_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_IC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_IP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_RIP_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_RIC_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_RIC1_args[] = {
  { { OPERAND_ae_ls_v }, 'i' },
  { { OPERAND_ae_ls_su }, 'm' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA24X2_RIC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDICIRC_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_end }, 'i' },
  { { OPERAND_ae_immls64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDCIRC_XC1_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDCIRC_XC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDCIRC_XC_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDCIRC_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_I_args[] = {
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_I_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_IP_args[] = {
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_IP_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_X_args[] = {
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_X_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_XP_args[] = {
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_XP_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_XC_args[] = {
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_XC1_args[] = {
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32RA64S_XC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_I_args[] = {
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_I_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_IP_args[] = {
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_immls32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_IP_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_X_args[] = {
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_X_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_XP_args[] = {
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_XP_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_XC_args[] = {
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_XC1_args[] = {
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24RA64S_XC1_stateArgs[] = {
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2RA64S_IP_args[] = {
  { { OPERAND_ae_ls_v2 }, 'i' },
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S32X2RA64S_IP_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S24X2RA64S_IP_args[] = {
  { { OPERAND_ae_ls_v2 }, 'i' },
  { { OPERAND_ae_ls_v1 }, 'i' },
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S24X2RA64S_IP_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDBRBA32_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_BITSWAP_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32JS_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32JS_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDANDSUB32S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_ds }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDANDSUB32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDANDSUBRNG32_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_ds }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDANDSUBRNG32_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDRNG32_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDRNG32_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBRNG32_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBRNG32_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CALCRNG3_stateArgs[] = {
  { { STATE_AE_SAR }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CALCRNG2_stateArgs[] = {
  { { STATE_AE_SAR }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CALCRNG1_stateArgs[] = {
  { { STATE_AE_SAR }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_RNG32X2_args[] = {
  { { OPERAND_opnd_ae_sem_rng_d }, 'i' }
};

static xtensa_arg_internal Iclass_AE_RNG32X2_stateArgs[] = {
  { { STATE_AE_SAR }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEL16I_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' },
  { { OPERAND_ae_dr_to_dr_v1 }, 'i' },
  { { OPERAND_ae_selimm }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEL16I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEL16I_N_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' },
  { { OPERAND_ae_dr_to_dr_v1 }, 'i' },
  { { OPERAND_ae_selimm_N }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEL16I_N_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SHORTSWAP_args[] = {
  { { OPERAND_ae_to_dr_v }, 'o' },
  { { OPERAND_ae_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SHORTSWAP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAB4_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_bt4 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAB2_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_bt2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAB_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_bt }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVBA_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVBA1X2_args[] = {
  { { OPERAND_br2 }, 'o' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVBA4_args[] = {
  { { OPERAND_br4 }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVBA2_args[] = {
  { { OPERAND_br2 }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVB2_args[] = {
  { { OPERAND_br2 }, 'o' },
  { { OPERAND_bt2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVB4_args[] = {
  { { OPERAND_br4 }, 'o' },
  { { OPERAND_bt4 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT16X4_args[] = {
  { { OPERAND_ae_cmov_v }, 'm' },
  { { OPERAND_ae_cmov_v0 }, 'i' },
  { { OPERAND_bt4 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT16X4_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF16X4_args[] = {
  { { OPERAND_ae_cmov_v }, 'm' },
  { { OPERAND_ae_cmov_v0 }, 'i' },
  { { OPERAND_bt4 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF16X4_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT32X2_args[] = {
  { { OPERAND_ae_cmov_v }, 'm' },
  { { OPERAND_ae_cmov_v0 }, 'i' },
  { { OPERAND_bt2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT32X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF32X2_args[] = {
  { { OPERAND_ae_cmov_v }, 'm' },
  { { OPERAND_ae_cmov_v0 }, 'i' },
  { { OPERAND_bt2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF32X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVSARA7X2_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVSARA7X2_stateArgs[] = {
  { { STATE_AE_SAR }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVSARD7_args[] = {
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVSARD7_stateArgs[] = {
  { { STATE_AE_SAR }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVASAR_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_AE_MOVASAR_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA32X2_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA32X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA32_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA16X2_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA16X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA16_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVI_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_movi_imm }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVI_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCP24A32X2_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCP24A32X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT16X4_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT16X4_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT32X2F16_32_args[] = {
  { { OPERAND_ae_to_dr_v }, 'o' },
  { { OPERAND_ae_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT32X2F16_32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT32X2F16_10_args[] = {
  { { OPERAND_ae_to_dr_v }, 'o' },
  { { OPERAND_ae_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT32X2F16_10_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32X2D16_32_args[] = {
  { { OPERAND_ae_to_dr_v }, 'o' },
  { { OPERAND_ae_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32X2D16_32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32X2D16_10_args[] = {
  { { OPERAND_ae_to_dr_v }, 'o' },
  { { OPERAND_ae_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32X2D16_10_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTA32F24S_L_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTA32F24S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTA32F24S_H_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTA32F24S_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_LL_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_LH_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_HL_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_HL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_HH_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCP24Q48X2_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' },
  { { OPERAND_ae_dr_to_dr_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCP24Q48X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32X2F64S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_shift_sd }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32X2F64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCI32X2F64S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_shift_sd }, 'i' },
  { { OPERAND_ae_osa16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCI32X2F64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32F64S_L_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_shift_sd }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32F64S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCI32F64S_L_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_shift_sd }, 'i' },
  { { OPERAND_ae_osa16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCI32F64S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCP16_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCP16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F64SSYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F64SSYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F64SASYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F64SASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F48SSYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F48SSYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F48SASYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F48SASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND16X4F32SSYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' },
  { { OPERAND_ae_arth_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND16X4F32SSYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND16X4F32SASYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' },
  { { OPERAND_ae_arth_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND16X4F32SASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND24X2F48SSYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND24X2F48SSYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND24X2F48SASYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND24X2F48SASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16Q48X2SYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16Q48X2SYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16Q48X2ASYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16Q48X2ASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MINABS32S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MINABS32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAXABS32S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAXABS32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16F24SYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16F24SYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16F24ASYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16F24ASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOV_args[] = {
  { { OPERAND_ae_to_dr_v }, 'o' },
  { { OPERAND_ae_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOV_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT64_args[] = {
  { { OPERAND_ae_cmov_v }, 'm' },
  { { OPERAND_ae_cmov_v0 }, 'i' },
  { { OPERAND_bt }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF64_args[] = {
  { { OPERAND_ae_cmov_v }, 'm' },
  { { OPERAND_ae_cmov_v0 }, 'i' },
  { { OPERAND_bt }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTQ56A32S_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTQ56A32S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT48A32_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT48A32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT64A32_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT64A32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTQ56P32S_L_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTQ56P32S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTQ56P32S_H_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTQ56P32S_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT64F32_H_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT64F32_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT48F32_L_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT48F32_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT48F32_H_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT48F32_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT48S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT48S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SATQ56S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SATQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT24S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCQ32_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCQ32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MINABS64S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MINABS64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAXABS64S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAXABS64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSQ32F48SYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSQ32F48SYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSQ32F48ASYM_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSQ32F48ASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32Q48_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32Q48_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD32_L_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD32_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD32_H_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD32_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_3_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_2_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_1_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_0_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRA64_32_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRA64_32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_PKSR32_args[] = {
  { { OPERAND_ae_pks_d }, 'm' },
  { { OPERAND_ae_pks_s }, 'i' },
  { { OPERAND_ae_imm2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_PKSR32_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_PKSR24_args[] = {
  { { OPERAND_ae_pks_d }, 'm' },
  { { OPERAND_ae_pks_s }, 'i' },
  { { OPERAND_ae_imm2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_PKSR24_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_PKSRF32_args[] = {
  { { OPERAND_ae_pks_d }, 'm' },
  { { OPERAND_ae_pks_s }, 'i' },
  { { OPERAND_ae_imm2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_PKSRF32_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA16P24S_L_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA16P24S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA16P24S_H_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA16P24S_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB32_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSUB32_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSUB32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBADD32_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBADD32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD16_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB16_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32_HL_LH_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG32_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS32_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD24S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB24S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB32S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSUB32S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSUB32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBADD32S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBADD32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD16S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB16S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32S_HL_LH_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32S_HL_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG24S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS24S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG32S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG32S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS32S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS32S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG16S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG16S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS16S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS16S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT16_args[] = {
  { { OPERAND_br4 }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE16_args[] = {
  { { OPERAND_br4 }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ16_args[] = {
  { { OPERAND_br4 }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT32_args[] = {
  { { OPERAND_br2 }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE32_args[] = {
  { { OPERAND_br2 }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ32_args[] = {
  { { OPERAND_br2 }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MIN32_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MIN32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAX32_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAX32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD64_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB64_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG64_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS64_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSQ56S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBSQ56S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBSQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD64S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB64S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEGSQ56S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEGSQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABSSQ56S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABSSQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG64S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS64S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_AND_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' },
  { { OPERAND_ae_dr_to_dr_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_AND_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NAND_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' },
  { { OPERAND_ae_dr_to_dr_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NAND_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_OR_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' },
  { { OPERAND_ae_dr_to_dr_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_OR_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_XOR_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' },
  { { OPERAND_ae_dr_to_dr_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_XOR_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI24_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLI24_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLI24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI24_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS24_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS24_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLS24_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLS24_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAS24_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAS24_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI16_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI16R_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI16R_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI32_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLI32_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLI32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI32_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI32R_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI32R_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS32_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS32_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLS32_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLS32_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAS32_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAS32_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA32_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLA32_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLA32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI16S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA16S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA16S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA16RS_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA16RS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI24S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS24S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI32S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS32S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA32S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32RS_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32RS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLASQ56_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLASQ56_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLSQ56_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLSQ56_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRASQ56_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRASQ56_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAAQ56_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAAQ56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLAQ56_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLAQ56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAAQ56_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAAQ56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI64_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLI64_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLI64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI64_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS64_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS64_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLS64_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLS64_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAS64_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAS64_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA64_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLA64_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLA64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA64_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAISQ56S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAISQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLASSQ56S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLASSQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAASQ56S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAASQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI64S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS64S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA64S_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT64_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE64_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ64_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAX64_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAX64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MIN64_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_ae_arth_v0 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MIN64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSA64_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSA64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSAZ16_0_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSAZ16_0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSAZ32_L_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSAZ32_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_LL_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LL_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32RA_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32RA_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32RA_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32RA_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_LH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32RA_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32RA_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32RA_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32RA_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_HH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_HH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_HH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_HH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_HH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_HH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32RA_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32RA_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32RA_HH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32RA_HH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_HH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_HH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_LL_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LL_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32RA_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32RA_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32RA_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32RA_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_LH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32RA_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32RA_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32RA_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32RA_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_HH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_HH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_HH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_HH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_HH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_HH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32RA_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32RA_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32RA_HH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32RA_HH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_HH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_HH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_LL_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LL_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32RA_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32RA_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32RA_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32RA_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_LH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32RA_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32RA_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32RA_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32RA_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_HH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_HH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_HH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_HH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_HH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_HH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32RA_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32RA_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32RA_HH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32RA_HH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_HH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_HH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32U_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32U_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32U_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32U_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32U_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32U_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_33_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_33_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_33_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_33_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_22_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_22_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_22_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_32_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_32_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_32_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_32_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_21_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_21_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_21_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_21_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_31_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_31_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_31_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_31_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_30_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_30_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_30_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_30_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_10_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_10_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_10_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_10_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_20_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_20_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_20_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_20_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_11_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_11_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_11_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_11_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_00_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_00_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_33_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_33_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_33_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_33_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_22_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_22_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_22_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_32_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_32_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_32_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_32_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_21_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_21_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_21_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_21_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_31_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_31_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_31_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_31_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_30_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_30_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_30_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_30_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_10_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_10_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_10_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_10_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_20_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_20_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_20_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_20_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_11_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_11_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_11_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_11_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_00_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_00_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_33_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_33_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_33_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_33_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_22_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_22_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_22_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_32_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_32_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_32_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_32_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_21_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_21_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_21_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_21_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_31_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_31_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_31_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_31_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_30_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_30_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_30_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_30_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_10_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_10_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_10_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_10_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_20_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_20_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_20_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_20_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_11_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_11_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_11_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_11_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_00_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_00_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_33_22_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_33_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_33_22_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_33_22_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_13_02_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_13_02_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_13_02_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_13_02_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_11_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_11_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_11_00_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_11_00_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_33_22_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_33_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_33_22_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_33_22_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_13_02_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_13_02_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_13_02_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_13_02_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_11_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_11_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_11_00_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_11_00_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_33_22_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_33_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_33_22_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_33_22_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_13_02_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_13_02_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_13_02_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_13_02_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_11_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_11_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_11_00_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_11_00_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_33_22_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_33_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_33_22_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_33_22_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_13_02_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_13_02_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_13_02_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_13_02_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_11_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_11_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_11_00_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_11_00_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16S_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16S_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16U_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16U_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16U_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16S_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16S_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16U_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16U_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16U_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16S_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16S_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16U_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16U_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16U_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16S_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16S_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16U_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16U_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16U_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16S_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16S_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16U_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16U_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16U_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16S_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16S_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16U_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16U_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16U_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP24X2RA_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP24X2RA_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP24X2R_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP24X2R_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP24X2RA_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP24X2RA_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP24X2R_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP24X2R_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP24X2RA_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP24X2RA_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP24X2R_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP24X2R_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP24X2RA_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP24X2RA_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP24X2R_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP24X2R_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP24X2RA_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP24X2RA_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP24X2R_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP24X2R_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP24X2RA_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP24X2RA_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP24X2R_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP24X2R_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32S_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32S_HH_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32RA_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32RA_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32S_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32S_HH_LL_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32RA_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32RA_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32S_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32S_HL_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32RA_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32RA_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32S_HL_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32S_HL_LH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32RA_HL_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32RA_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32_HL_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32S_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32S_HH_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32RA_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32RA_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32S_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32S_HH_LL_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32RA_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32RA_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32S_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32S_HL_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32RA_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32RA_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32S_HL_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32S_HL_LH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32RA_HL_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32RA_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32_HL_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32S_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32S_HH_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32RA_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32RA_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32S_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32S_HH_LL_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32RA_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32RA_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32S_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32S_HH_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32RA_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32RA_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32S_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32S_HH_LL_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32RA_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32RA_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32S_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32S_HL_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32RA_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32RA_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32S_HL_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32S_HL_LH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32RA_HL_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32RA_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32_HL_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32S_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32S_HH_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32RA_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32RA_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32S_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32S_HH_LL_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32RA_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32RA_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32S_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32S_HL_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32RA_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32RA_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32S_HL_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32S_HL_LH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32RA_HL_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32RA_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32_HL_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32S_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32S_HH_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32RA_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32RA_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32S_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32S_HH_LL_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32RA_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32RA_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32S_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32S_HL_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32RA_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32RA_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32S_HL_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32S_HL_LH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32RA_HL_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32RA_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32_HL_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32S_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32S_HH_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32RA_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32RA_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32S_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32S_HH_LL_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32RA_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32RA_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32S_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32S_HH_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32RA_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32RA_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32S_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32S_HH_LL_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32RA_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32RA_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32S_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32S_HL_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32RA_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32RA_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32S_HL_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32S_HL_LH_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32RA_HL_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32RA_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32_HL_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L1_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L1_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L3_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L3_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H1_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H1_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H3_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H3_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L1_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L1_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L3_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L3_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H1_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H1_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H3_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H3_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L1_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L1_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L3_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L3_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H1_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H1_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H3_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H3_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H3_L2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H3_L2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H1_L0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H1_L0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H3_L2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H3_L2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H1_L0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H1_L0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H3_L2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H3_L2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H1_L0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H1_L0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H3_L2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H3_L2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H1_L0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H1_L0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H3_L2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H3_L2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H1_L0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H1_L0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H3_L2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H3_L2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H1_L0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H1_L0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H3_L2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H3_L2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H1_L0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H1_L0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H3_L2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H3_L2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H3_L2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H1_L0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H1_L0_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H1_L0_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H2_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H2_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H0_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H0_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H2_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H2_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H0_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H0_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H2_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H2_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H0_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H0_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H2_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H2_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H0_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H0_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H2_L3_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H2_L3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H0_L1_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H0_L1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H2_L3_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H2_L3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H0_L1_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H0_L1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H2_L3_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H2_L3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H0_L1_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H0_L1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H2_L3_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H2_L3_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H0_L1_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H0_L1_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X16X2_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X16X2_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2S_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2S_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2S_H_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2S_H_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X16X2_H_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X16X2_H_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_H_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_H_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_H_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_H_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X16X2_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X16X2_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2S_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2S_L_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X16X2_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X16X2_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_L_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_L_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X16X2_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X16X2_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2S_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2S_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2S_H_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2S_H_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X16X2_H_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X16X2_H_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_H_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_H_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_H_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_H_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X16X2_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X16X2_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2S_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2S_L_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X16X2_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X16X2_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_L_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_L_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X16X2_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X16X2_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2S_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2S_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2S_H_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2S_H_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X16X2_H_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X16X2_H_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_H_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_H_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_H_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_H_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X16X2_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X16X2_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2S_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2S_L_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X16X2_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X16X2_L_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_L_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_L_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_L_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RS_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RAS_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RAS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RS_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RS_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RAS_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RAS_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RS_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RAS_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RAS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RS_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RS_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RAS_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RAS_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RS_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RAS_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RAS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X2_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X2_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RS_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RS_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RAS_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RAS_S2_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4S_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4RAS_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4RAS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC32_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFC24RA_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFC24RA_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFC32RAS_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFC32RAS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC32X16_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC32X16_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFC32X16RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFC32X16RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC32X16_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC32X16_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFC32X16RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFC32X16RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC32_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFC24RA_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFC24RA_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFC32RAS_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFC32RAS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC32X16_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC32X16_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFC32X16RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFC32X16RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC32X16_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC32X16_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFC32X16RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFC32X16RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16X4SS_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q1 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16X4SS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16X4SS_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q1 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16X4SS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16X4SS_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q1 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16X4SS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL16X4_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q1 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL16X4_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA16X4_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q1 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA16X4_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS16X4_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q1 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS16X4_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X2S_FIR_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_q1 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X2S_FIR_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X2RA_FIR_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_q1 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X2RA_FIR_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X2S_FIR_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_q1 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X2S_FIR_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X2RA_FIR_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_q1 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X2RA_FIR_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_q1 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_HL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_q1 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_HL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_q1 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_q1 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFD32X16X2_FIR_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X2S_FIR_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_q1 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X2S_FIR_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X2RA_FIR_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_q1 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X2RA_FIR_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X2S_FIR_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_q1 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X2S_FIR_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X2RA_FIR_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_q1 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X2RA_FIR_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_q1 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_HL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_q1 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_HL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_q1 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x4_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_q1 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x4_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x4_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFD32X16X2_FIR_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAAAFQ32X16_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAAAFQ32X16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAAAFQ32X16_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAAAFQ32X16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAAAFQ32X16_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAAAFQ32X16_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAAAFQ32X16_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAAAFQ32X16_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAAAQ32X16_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAAAQ32X16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAAAQ32X16_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAAAQ32X16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAAAQ32X16_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAAAQ32X16_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAAAQ32X16_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAAAQ32X16_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL16_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL16_00_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA16_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA16_00_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL16_00_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL16_00_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA16_00_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA16_00_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAAAQ16_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAAAQ16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAAAQ16_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAAAQ16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAAAQ16_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAAAQ16_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAAAQ16_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAAAQ16_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DIV64D32_H_args[] = {
  { { OPERAND_ae_arth_v }, 'm' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DIV64D32_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DIV64D32_L_args[] = {
  { { OPERAND_ae_arth_v }, 'm' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DIV64D32_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SHA32_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL32T_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL32T_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_SEARCHDONE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL16T_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL16T_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_SEARCHDONE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_stateArgs[] = {
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_IP_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_IP_stateArgs[] = {
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_IC_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_IC1_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_IC1_stateArgs[] = {
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDSHT_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDSHT_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_AE_FIRST_TS }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_AE_TABLESIZE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LB_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LB_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBI_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBI_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBK_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBK_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBKI_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBKI_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBS_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBS_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBSI_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBSI_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_IC_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_IC_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_IC1_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_IC1_stateArgs[] = {
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_IC1_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_IC1_stateArgs[] = {
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_IP_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_IP_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_IP_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_IP_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLEL32T_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_art }, 'm' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLEL32T_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLEL16T_args[] = {
  { { OPERAND_br }, 'o' },
  { { OPERAND_art }, 'm' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLEL16T_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_ae_ohba2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLES16C_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLES16C_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_NEXTOFFSET }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBF_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SBF_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_IC_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_IC_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_ae_ohba2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLES16C_IC_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLES16C_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_NEXTOFFSET }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBF_IC_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SBF_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_IC1_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_IC1_stateArgs[] = {
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_IC1_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_ae_ohba2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_IC1_stateArgs[] = {
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLES16C_IC1_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLES16C_IC1_stateArgs[] = {
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_NEXTOFFSET }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBF_IC1_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SBF_IC1_stateArgs[] = {
  { { STATE_AE_CBEGIN1 }, 'i' },
  { { STATE_AE_CEND1 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_IP_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_IP_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_IP_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_ae_ohba2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_IP_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLES16C_IP_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLES16C_IP_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_NEXTOFFSET }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBF_IP_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SBF_IP_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32_args[] = {
  { { OPERAND_ae_dr_to_dr_v }, 'o' },
  { { OPERAND_ae_dr_to_dr_v0 }, 'i' },
  { { OPERAND_ae_opnd_tp7 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAE_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_opnd_ae_sem_ep_ls_ei }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAE_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVEA_args[] = {
  { { OPERAND_opnd_ae_sem_ep_ls_eo }, 'o' },
  { { OPERAND_opnd_ae_sem_ep_ls_ar_s }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVEA_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVEEP_args[] = {
  { { OPERAND_opnd_ae_sem_ep_ls_eo }, 'o' },
  { { OPERAND_opnd_ae_sem_ep_ls_ei }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVEEP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT72_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_ep }, 'o' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT72_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD72_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_ep }, 'm' },
  { { OPERAND_ae_arth_v }, 'm' },
  { { OPERAND_opnd_ae_sem_arithmetic_ep1 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD72_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB72_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_ep }, 'm' },
  { { OPERAND_ae_arth_v }, 'm' },
  { { OPERAND_opnd_ae_sem_arithmetic_ep1 }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB72_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD72X64_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_ep }, 'm' },
  { { OPERAND_ae_arth_v }, 'm' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD72X64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB72X64_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_ep }, 'm' },
  { { OPERAND_ae_arth_v }, 'm' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB72X64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32EP_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_acc_ep }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32EP_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32EP_HH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_acc_ep }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32EP_HH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32EP_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_acc_ep }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32EP_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32EP_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_acc_ep }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32EP_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32EP_HH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_acc_ep }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32EP_HH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32EP_HH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_acc_ep }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32EP_HH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32EP_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_acc_ep }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32EP_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32EP_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_acc_ep }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32EP_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32EP_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_acc_ep }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32EP_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32EP_HH_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_acc_ep }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32EP_HH_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32EP_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_acc_ep }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32EP_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32EP_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_acc_ep }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32EP_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32EP_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_acc_ep }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32EP_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32EP_HH_LL_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_acc_ep }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32EP_HH_LL_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32USEP_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_acc_ep }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32USEP_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32USEP_HL_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_acc_ep }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32USEP_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32USEP_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_acc_ep }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32USEP_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32USEP_HL_LH_S2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S2_acc_ep }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S2_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32USEP_HL_LH_S2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32USEP_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_acc_ep }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32USEP_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32USEP_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_acc_ep }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32USEP_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32USEP_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_acc_ep }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32USEP_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32USEP_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_acc_ep }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32USEP_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI72_args[] = {
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_e }, 'i' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_ae_osa64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI72_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI72_args[] = {
  { { OPERAND_opnd_ae_sem_shift_e }, 'o' },
  { { OPERAND_ae_shift_d }, 'o' },
  { { OPERAND_ae_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_i8 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI72_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT64S_args[] = {
  { { OPERAND_ae_arth_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_e }, 'i' },
  { { OPERAND_ae_arth_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16SI_N_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_uimm2x2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16UI_N_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_uimm2x2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16I_N_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ae_uimm2x2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVFCRFSRV_args[] = {
  { { OPERAND_opnd_ae_sem_movfpstate_v }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVFCRFSRV_stateArgs[] = {
  { { STATE_RoundMode }, 'o' },
  { { STATE_InvalidFlag }, 'o' },
  { { STATE_DivZeroFlag }, 'o' },
  { { STATE_OverflowFlag }, 'o' },
  { { STATE_UnderflowFlag }, 'o' },
  { { STATE_InexactFlag }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVVFCRFSR_args[] = {
  { { OPERAND_opnd_ae_sem_movfpstate_v }, 'o' }
};

static xtensa_arg_internal Iclass_AE_MOVVFCRFSR_stateArgs[] = {
  { { STATE_RoundMode }, 'i' },
  { { STATE_InvalidFlag }, 'i' },
  { { STATE_DivZeroFlag }, 'i' },
  { { STATE_OverflowFlag }, 'i' },
  { { STATE_UnderflowFlag }, 'i' },
  { { STATE_InexactFlag }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RFR_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_vr }, 'i' }
};

static xtensa_arg_internal Iclass_RFR_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WFR_args[] = {
  { { OPERAND_ae_ar_to_dr_v }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_WFR_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVT_S_args[] = {
  { { OPERAND_ae_cmov_v }, 'm' },
  { { OPERAND_ae_cmov_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmov_bt }, 'i' }
};

static xtensa_arg_internal Iclass_MOVT_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVF_S_args[] = {
  { { OPERAND_ae_cmov_v }, 'm' },
  { { OPERAND_ae_cmov_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmov_bt }, 'i' }
};

static xtensa_arg_internal Iclass_MOVF_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVEQZ_S_args[] = {
  { { OPERAND_ae_cmov_v }, 'm' },
  { { OPERAND_ae_cmov_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmov_arr }, 'i' }
};

static xtensa_arg_internal Iclass_MOVEQZ_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVNEZ_S_args[] = {
  { { OPERAND_ae_cmov_v }, 'm' },
  { { OPERAND_ae_cmov_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmov_arr }, 'i' }
};

static xtensa_arg_internal Iclass_MOVNEZ_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVGEZ_S_args[] = {
  { { OPERAND_ae_cmov_v }, 'm' },
  { { OPERAND_ae_cmov_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmov_arr }, 'i' }
};

static xtensa_arg_internal Iclass_MOVGEZ_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVLTZ_S_args[] = {
  { { OPERAND_ae_cmov_v }, 'm' },
  { { OPERAND_ae_cmov_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmov_arr }, 'i' }
};

static xtensa_arg_internal Iclass_MOVLTZ_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_TRUNC_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_arr }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vr }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_i_imm5 }, 'i' }
};

static xtensa_arg_internal Iclass_TRUNC_S_stateArgs[] = {
  { { STATE_InexactFlag }, 'm' },
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_UTRUNC_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_arr }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vr }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_i_imm5 }, 'i' }
};

static xtensa_arg_internal Iclass_UTRUNC_S_stateArgs[] = {
  { { STATE_InexactFlag }, 'm' },
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_TRUNC_SX2_args[] = {
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vr }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_i_imm5 }, 'i' }
};

static xtensa_arg_internal Iclass_TRUNC_SX2_stateArgs[] = {
  { { STATE_InexactFlag }, 'm' },
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_UTRUNC_SX2_args[] = {
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vr }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_i_imm5 }, 'i' }
};

static xtensa_arg_internal Iclass_UTRUNC_SX2_stateArgs[] = {
  { { STATE_InexactFlag }, 'm' },
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_FICEIL_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vr }, 'i' }
};

static xtensa_arg_internal Iclass_FICEIL_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_FIFLOOR_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vr }, 'i' }
};

static xtensa_arg_internal Iclass_FIFLOOR_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_FIROUND_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vr }, 'i' }
};

static xtensa_arg_internal Iclass_FIROUND_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_FITRUNC_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vr }, 'i' }
};

static xtensa_arg_internal Iclass_FITRUNC_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_FIRINT_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vr }, 'i' }
};

static xtensa_arg_internal Iclass_FIRINT_S_stateArgs[] = {
  { { STATE_RoundMode }, 'i' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_CVTSF16_L_args[] = {
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vr }, 'i' }
};

static xtensa_arg_internal Iclass_CVTSF16_L_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_CVTSF16_H_args[] = {
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vr }, 'i' }
};

static xtensa_arg_internal Iclass_CVTSF16_H_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_CVTF16S_L_args[] = {
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vr }, 'i' }
};

static xtensa_arg_internal Iclass_CVTF16S_L_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_CVTF16S_H_args[] = {
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vt }, 'm' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vr }, 'i' }
};

static xtensa_arg_internal Iclass_CVTF16S_H_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ABS_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_mov_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_mov_vr }, 'i' }
};

static xtensa_arg_internal Iclass_ABS_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MUL_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spfma_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_spfma_vs }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_spfma_vr }, 'i' }
};

static xtensa_arg_internal Iclass_MUL_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MADD_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spfma_vt }, 'm' },
  { { OPERAND_opnd_vfpu2_sem_spfma_vs }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_spfma_vr }, 'i' }
};

static xtensa_arg_internal Iclass_MADD_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MSUB_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spfma_vt }, 'm' },
  { { OPERAND_opnd_vfpu2_sem_spfma_vs }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_spfma_vr }, 'i' }
};

static xtensa_arg_internal Iclass_MSUB_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MSUBN_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spfma_vt }, 'm' },
  { { OPERAND_opnd_vfpu2_sem_spfma_vs }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_spfma_vr }, 'i' }
};

static xtensa_arg_internal Iclass_MSUBN_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MADDN_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spfma_vt }, 'm' },
  { { OPERAND_opnd_vfpu2_sem_spfma_vs }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_spfma_vr }, 'i' }
};

static xtensa_arg_internal Iclass_MADDN_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ADD_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spfma_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_spfma_vs }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_spfma_vr }, 'i' }
};

static xtensa_arg_internal Iclass_ADD_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_SUB_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spfma_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_spfma_vs }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_spfma_vr }, 'i' }
};

static xtensa_arg_internal Iclass_SUB_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_NEG_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_mov_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_mov_vr }, 'i' }
};

static xtensa_arg_internal Iclass_NEG_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_FLOAT_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_arr }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_i_imm5 }, 'i' }
};

static xtensa_arg_internal Iclass_FLOAT_S_stateArgs[] = {
  { { STATE_RoundMode }, 'i' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_UFLOAT_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_arr }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_i_imm5 }, 'i' }
};

static xtensa_arg_internal Iclass_UFLOAT_S_stateArgs[] = {
  { { STATE_RoundMode }, 'i' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_FLOAT_SX2_args[] = {
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vr }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_i_imm5 }, 'i' }
};

static xtensa_arg_internal Iclass_FLOAT_SX2_stateArgs[] = {
  { { STATE_RoundMode }, 'i' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_UFLOAT_SX2_args[] = {
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_vr }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_sp32cvt_i_imm5 }, 'i' }
};

static xtensa_arg_internal Iclass_UFLOAT_SX2_stateArgs[] = {
  { { STATE_RoundMode }, 'i' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_OLE_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spmisc_brt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vs }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vr }, 'i' }
};

static xtensa_arg_internal Iclass_OLE_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_OLT_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spmisc_brt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vs }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vr }, 'i' }
};

static xtensa_arg_internal Iclass_OLT_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_OEQ_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spmisc_brt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vs }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vr }, 'i' }
};

static xtensa_arg_internal Iclass_OEQ_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_UN_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spmisc_brt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vs }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vr }, 'i' }
};

static xtensa_arg_internal Iclass_UN_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ULE_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spmisc_brt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vs }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vr }, 'i' }
};

static xtensa_arg_internal Iclass_ULE_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ULT_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spmisc_brt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vs }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vr }, 'i' }
};

static xtensa_arg_internal Iclass_ULT_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_UEQ_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spmisc_brt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vs }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vr }, 'i' }
};

static xtensa_arg_internal Iclass_UEQ_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_CONST_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_mov_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_mov_i_imm4 }, 'i' }
};

static xtensa_arg_internal Iclass_CONST_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_NEXP01_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spmisc_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vr }, 'i' }
};

static xtensa_arg_internal Iclass_NEXP01_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MKSADJ_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spmisc_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vr }, 'i' }
};

static xtensa_arg_internal Iclass_MKSADJ_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MKDADJ_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spmisc_vs }, 'm' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vr }, 'i' }
};

static xtensa_arg_internal Iclass_MKDADJ_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_DivZeroFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_DIV0_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spmisc_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vr }, 'i' }
};

static xtensa_arg_internal Iclass_DIV0_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_SQRT0_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spmisc_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vr }, 'i' }
};

static xtensa_arg_internal Iclass_SQRT0_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RECIP0_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spmisc_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vr }, 'i' }
};

static xtensa_arg_internal Iclass_RECIP0_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_DivZeroFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RSQRT0_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spmisc_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vr }, 'i' }
};

static xtensa_arg_internal Iclass_RSQRT0_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_DivZeroFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_DIVN_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spfma_vt }, 'm' },
  { { OPERAND_opnd_vfpu2_sem_spfma_vs }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_spfma_vr }, 'i' }
};

static xtensa_arg_internal Iclass_DIVN_S_stateArgs[] = {
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ADDEXP_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spmisc_vsM }, 'm' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vr }, 'i' }
};

static xtensa_arg_internal Iclass_ADDEXP_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ADDEXPM_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spmisc_vsM }, 'm' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vr }, 'i' }
};

static xtensa_arg_internal Iclass_ADDEXPM_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MIN_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spmisc_vtM }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vs }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vr }, 'i' }
};

static xtensa_arg_internal Iclass_MIN_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MAX_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spmisc_vtM }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vs }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vr }, 'i' }
};

static xtensa_arg_internal Iclass_MAX_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MULMUX_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spfma_vt }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_spfma_vs }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_spfma_vr }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_spfma_i_imm1 }, 'i' }
};

static xtensa_arg_internal Iclass_MULMUX_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MADDMUX_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spfma_vt }, 'm' },
  { { OPERAND_opnd_vfpu2_sem_spfma_vs }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_spfma_vr }, 'i' },
  { { OPERAND_opnd_vfpu2_sem_spfma_i_imm3 }, 'i' }
};

static xtensa_arg_internal Iclass_MADDMUX_S_stateArgs[] = {
  { { STATE_InvalidFlag }, 'm' },
  { { STATE_OverflowFlag }, 'm' },
  { { STATE_UnderflowFlag }, 'm' },
  { { STATE_InexactFlag }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_CONJC_S_args[] = {
  { { OPERAND_opnd_vfpu2_sem_spmisc_vtM }, 'o' },
  { { OPERAND_opnd_vfpu2_sem_spmisc_vr }, 'i' }
};

static xtensa_arg_internal Iclass_CONJC_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_SIGMOID_Q15_args[] = {
  { { OPERAND_opnd_SIGMOID_Q15_y }, 'o' },
  { { OPERAND_opnd_SIGMOID_Q15_x }, 'i' }
};

static xtensa_arg_internal Iclass_SIGMOID_FP32_args[] = {
  { { OPERAND_opnd_SIGMOID_FP32_y }, 'o' },
  { { OPERAND_opnd_SIGMOID_FP32_x }, 'i' }
};

static xtensa_arg_internal Iclass_SIGMOID_FP32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_iclass_internal iclasses[] = {
  { 0, 0 /* xt_iclass_excw */,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_rfe */,
    2, Iclass_xt_iclass_rfe_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_rfde */,
    1, Iclass_xt_iclass_rfde_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_syscall */,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_call12_args,
    1, Iclass_xt_iclass_call12_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_call8_args,
    1, Iclass_xt_iclass_call8_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_call4_args,
    1, Iclass_xt_iclass_call4_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_callx12_args,
    1, Iclass_xt_iclass_callx12_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_callx8_args,
    1, Iclass_xt_iclass_callx8_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_callx4_args,
    1, Iclass_xt_iclass_callx4_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_entry_args,
    5, Iclass_xt_iclass_entry_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_movsp_args,
    2, Iclass_xt_iclass_movsp_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rotw_args,
    1, Iclass_xt_iclass_rotw_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_retw_args,
    5, Iclass_xt_iclass_retw_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_rfwou */,
    5, Iclass_xt_iclass_rfwou_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_l32e_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32e_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_windowbase_args,
    1, Iclass_xt_iclass_rsr_windowbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_windowbase_args,
    1, Iclass_xt_iclass_wsr_windowbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_windowbase_args,
    1, Iclass_xt_iclass_xsr_windowbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_windowstart_args,
    1, Iclass_xt_iclass_rsr_windowstart_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_windowstart_args,
    1, Iclass_xt_iclass_wsr_windowstart_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_windowstart_args,
    1, Iclass_xt_iclass_xsr_windowstart_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_add_n_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_addi_n_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_bz6_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_ill_n */,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_loadi4_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_mov_n_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_movi_n_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_nopn */,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_retn_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_storei4_args,
    0, 0, 0, 0 },
  { 1, Iclass_rur_threadptr_args,
    1, Iclass_rur_threadptr_stateArgs, 0, 0 },
  { 1, Iclass_wur_threadptr_args,
    1, Iclass_wur_threadptr_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_addi_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_addmi_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_addsub_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bit_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bsi8_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bsi8b_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bsi8u_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bst8_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_bsz12_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_call0_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_callx0_args,
    0, 0, 0, 0 },
  { 4, Iclass_xt_iclass_exti_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_ill */,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_jump_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_jumpx_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l16ui_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l16si_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l32i_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_l32r_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l8i_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_loop_args,
    3, Iclass_xt_iclass_loop_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_loopz_args,
    3, Iclass_xt_iclass_loopz_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_movi_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_movz_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_neg_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_nop */,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_return_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_simcall */,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s16i_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32i_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32nb_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s8i_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_sar_args,
    1, Iclass_xt_iclass_sar_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_sari_args,
    1, Iclass_xt_iclass_sari_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_shifts_args,
    1, Iclass_xt_iclass_shifts_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_shiftst_args,
    1, Iclass_xt_iclass_shiftst_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_shiftt_args,
    1, Iclass_xt_iclass_shiftt_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_slli_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_srai_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_srli_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_memw */,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_extw */,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_isync */,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_sync */,
    1, Iclass_xt_iclass_sync_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_rsil_args,
    6, Iclass_xt_iclass_rsil_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_lend_args,
    1, Iclass_xt_iclass_rsr_lend_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_lend_args,
    1, Iclass_xt_iclass_wsr_lend_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_lend_args,
    1, Iclass_xt_iclass_xsr_lend_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_lcount_args,
    1, Iclass_xt_iclass_rsr_lcount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_lcount_args,
    2, Iclass_xt_iclass_wsr_lcount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_lcount_args,
    2, Iclass_xt_iclass_xsr_lcount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_lbeg_args,
    1, Iclass_xt_iclass_rsr_lbeg_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_lbeg_args,
    1, Iclass_xt_iclass_wsr_lbeg_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_lbeg_args,
    1, Iclass_xt_iclass_xsr_lbeg_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_sar_args,
    1, Iclass_xt_iclass_rsr_sar_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_sar_args,
    2, Iclass_xt_iclass_wsr_sar_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_sar_args,
    1, Iclass_xt_iclass_xsr_sar_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_memctl_args,
    1, Iclass_xt_iclass_rsr_memctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_memctl_args,
    1, Iclass_xt_iclass_wsr_memctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_memctl_args,
    1, Iclass_xt_iclass_xsr_memctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_litbase_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_litbase_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_litbase_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_configid0_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_configid0_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_configid1_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ps_args,
    6, Iclass_xt_iclass_rsr_ps_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ps_args,
    6, Iclass_xt_iclass_wsr_ps_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ps_args,
    6, Iclass_xt_iclass_xsr_ps_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc1_args,
    1, Iclass_xt_iclass_rsr_epc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc1_args,
    1, Iclass_xt_iclass_wsr_epc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc1_args,
    1, Iclass_xt_iclass_xsr_epc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave1_args,
    1, Iclass_xt_iclass_rsr_excsave1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave1_args,
    1, Iclass_xt_iclass_wsr_excsave1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave1_args,
    1, Iclass_xt_iclass_xsr_excsave1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc2_args,
    1, Iclass_xt_iclass_rsr_epc2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc2_args,
    1, Iclass_xt_iclass_wsr_epc2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc2_args,
    1, Iclass_xt_iclass_xsr_epc2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave2_args,
    1, Iclass_xt_iclass_rsr_excsave2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave2_args,
    1, Iclass_xt_iclass_wsr_excsave2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave2_args,
    1, Iclass_xt_iclass_xsr_excsave2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc3_args,
    1, Iclass_xt_iclass_rsr_epc3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc3_args,
    1, Iclass_xt_iclass_wsr_epc3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc3_args,
    1, Iclass_xt_iclass_xsr_epc3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave3_args,
    1, Iclass_xt_iclass_rsr_excsave3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave3_args,
    1, Iclass_xt_iclass_wsr_excsave3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave3_args,
    1, Iclass_xt_iclass_xsr_excsave3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc4_args,
    1, Iclass_xt_iclass_rsr_epc4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc4_args,
    1, Iclass_xt_iclass_wsr_epc4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc4_args,
    1, Iclass_xt_iclass_xsr_epc4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave4_args,
    1, Iclass_xt_iclass_rsr_excsave4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave4_args,
    1, Iclass_xt_iclass_wsr_excsave4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave4_args,
    1, Iclass_xt_iclass_xsr_excsave4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc5_args,
    1, Iclass_xt_iclass_rsr_epc5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc5_args,
    1, Iclass_xt_iclass_wsr_epc5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc5_args,
    1, Iclass_xt_iclass_xsr_epc5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave5_args,
    1, Iclass_xt_iclass_rsr_excsave5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave5_args,
    1, Iclass_xt_iclass_wsr_excsave5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave5_args,
    1, Iclass_xt_iclass_xsr_excsave5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps2_args,
    1, Iclass_xt_iclass_rsr_eps2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps2_args,
    1, Iclass_xt_iclass_wsr_eps2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps2_args,
    1, Iclass_xt_iclass_xsr_eps2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps3_args,
    1, Iclass_xt_iclass_rsr_eps3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps3_args,
    1, Iclass_xt_iclass_wsr_eps3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps3_args,
    1, Iclass_xt_iclass_xsr_eps3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps4_args,
    1, Iclass_xt_iclass_rsr_eps4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps4_args,
    1, Iclass_xt_iclass_wsr_eps4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps4_args,
    1, Iclass_xt_iclass_xsr_eps4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps5_args,
    1, Iclass_xt_iclass_rsr_eps5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps5_args,
    1, Iclass_xt_iclass_wsr_eps5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps5_args,
    1, Iclass_xt_iclass_xsr_eps5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excvaddr_args,
    1, Iclass_xt_iclass_rsr_excvaddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excvaddr_args,
    1, Iclass_xt_iclass_wsr_excvaddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excvaddr_args,
    1, Iclass_xt_iclass_xsr_excvaddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_depc_args,
    1, Iclass_xt_iclass_rsr_depc_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_depc_args,
    1, Iclass_xt_iclass_wsr_depc_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_depc_args,
    1, Iclass_xt_iclass_xsr_depc_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_exccause_args,
    2, Iclass_xt_iclass_rsr_exccause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_exccause_args,
    1, Iclass_xt_iclass_wsr_exccause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_exccause_args,
    1, Iclass_xt_iclass_xsr_exccause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_misc0_args,
    1, Iclass_xt_iclass_rsr_misc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_misc0_args,
    1, Iclass_xt_iclass_wsr_misc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_misc0_args,
    1, Iclass_xt_iclass_xsr_misc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_misc1_args,
    1, Iclass_xt_iclass_rsr_misc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_misc1_args,
    1, Iclass_xt_iclass_wsr_misc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_misc1_args,
    1, Iclass_xt_iclass_xsr_misc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_prid_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_vecbase_args,
    1, Iclass_xt_iclass_rsr_vecbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_vecbase_args,
    1, Iclass_xt_iclass_wsr_vecbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_vecbase_args,
    1, Iclass_xt_iclass_xsr_vecbase_stateArgs, 0, 0 },
  { 3, Iclass_xt_mul16_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_mul32_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_mul32h_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_mac16_aa_args,
    1, Iclass_xt_iclass_mac16_aa_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16_ad_args,
    1, Iclass_xt_iclass_mac16_ad_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16_da_args,
    1, Iclass_xt_iclass_mac16_da_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16_dd_args,
    1, Iclass_xt_iclass_mac16_dd_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16a_aa_args,
    1, Iclass_xt_iclass_mac16a_aa_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16a_ad_args,
    1, Iclass_xt_iclass_mac16a_ad_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16a_da_args,
    1, Iclass_xt_iclass_mac16a_da_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16a_dd_args,
    1, Iclass_xt_iclass_mac16a_dd_stateArgs, 0, 0 },
  { 4, Iclass_xt_iclass_mac16al_da_args,
    1, Iclass_xt_iclass_mac16al_da_stateArgs, 0, 0 },
  { 4, Iclass_xt_iclass_mac16al_dd_args,
    1, Iclass_xt_iclass_mac16al_dd_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_mac16_l_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_rsr_m0_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_wsr_m0_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_xsr_m0_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_rsr_m1_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_wsr_m1_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_xsr_m1_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_rsr_m2_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_wsr_m2_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_xsr_m2_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_rsr_m3_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_wsr_m3_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_xsr_m3_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_acclo_args,
    1, Iclass_xt_iclass_rsr_acclo_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_acclo_args,
    1, Iclass_xt_iclass_wsr_acclo_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_acclo_args,
    1, Iclass_xt_iclass_xsr_acclo_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_acchi_args,
    1, Iclass_xt_iclass_rsr_acchi_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_acchi_args,
    1, Iclass_xt_iclass_wsr_acchi_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_acchi_args,
    1, Iclass_xt_iclass_xsr_acchi_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rfi_args,
    16, Iclass_xt_iclass_rfi_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wait_args,
    1, Iclass_xt_iclass_wait_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_interrupt_args,
    1, Iclass_xt_iclass_rsr_interrupt_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_intset_args,
    2, Iclass_xt_iclass_wsr_intset_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_intclear_args,
    2, Iclass_xt_iclass_wsr_intclear_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_intenable_args,
    1, Iclass_xt_iclass_rsr_intenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_intenable_args,
    1, Iclass_xt_iclass_wsr_intenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_intenable_args,
    1, Iclass_xt_iclass_xsr_intenable_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_break_args,
    2, Iclass_xt_iclass_break_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_break_n_args,
    2, Iclass_xt_iclass_break_n_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_dbreaka0_args,
    1, Iclass_xt_iclass_rsr_dbreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_dbreaka0_args,
    2, Iclass_xt_iclass_wsr_dbreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_dbreaka0_args,
    2, Iclass_xt_iclass_xsr_dbreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_dbreakc0_args,
    1, Iclass_xt_iclass_rsr_dbreakc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_dbreakc0_args,
    2, Iclass_xt_iclass_wsr_dbreakc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_dbreakc0_args,
    2, Iclass_xt_iclass_xsr_dbreakc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_dbreaka1_args,
    1, Iclass_xt_iclass_rsr_dbreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_dbreaka1_args,
    2, Iclass_xt_iclass_wsr_dbreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_dbreaka1_args,
    2, Iclass_xt_iclass_xsr_dbreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_dbreakc1_args,
    1, Iclass_xt_iclass_rsr_dbreakc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_dbreakc1_args,
    2, Iclass_xt_iclass_wsr_dbreakc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_dbreakc1_args,
    2, Iclass_xt_iclass_xsr_dbreakc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ibreaka0_args,
    1, Iclass_xt_iclass_rsr_ibreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ibreaka0_args,
    1, Iclass_xt_iclass_wsr_ibreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ibreaka0_args,
    1, Iclass_xt_iclass_xsr_ibreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ibreaka1_args,
    1, Iclass_xt_iclass_rsr_ibreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ibreaka1_args,
    1, Iclass_xt_iclass_wsr_ibreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ibreaka1_args,
    1, Iclass_xt_iclass_xsr_ibreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ibreakenable_args,
    1, Iclass_xt_iclass_rsr_ibreakenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ibreakenable_args,
    1, Iclass_xt_iclass_wsr_ibreakenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ibreakenable_args,
    1, Iclass_xt_iclass_xsr_ibreakenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_debugcause_args,
    2, Iclass_xt_iclass_rsr_debugcause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_debugcause_args,
    2, Iclass_xt_iclass_wsr_debugcause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_debugcause_args,
    2, Iclass_xt_iclass_xsr_debugcause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_icount_args,
    1, Iclass_xt_iclass_rsr_icount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_icount_args,
    2, Iclass_xt_iclass_wsr_icount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_icount_args,
    2, Iclass_xt_iclass_xsr_icount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_icountlevel_args,
    1, Iclass_xt_iclass_rsr_icountlevel_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_icountlevel_args,
    1, Iclass_xt_iclass_wsr_icountlevel_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_icountlevel_args,
    1, Iclass_xt_iclass_xsr_icountlevel_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ddr_args,
    1, Iclass_xt_iclass_rsr_ddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ddr_args,
    2, Iclass_xt_iclass_wsr_ddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ddr_args,
    2, Iclass_xt_iclass_xsr_ddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_lddr32_p_args,
    3, Iclass_xt_iclass_lddr32_p_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_sddr32_p_args,
    2, Iclass_xt_iclass_sddr32_p_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rfdo_args,
    9, Iclass_xt_iclass_rfdo_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_rfdd */,
    1, Iclass_xt_iclass_rfdd_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_mmid_args,
    1, Iclass_xt_iclass_wsr_mmid_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_bbool1_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_bbool4_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_bbool8_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_bbranch_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bmove_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_RSR_BR_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_WSR_BR_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_XSR_BR_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ccount_args,
    1, Iclass_xt_iclass_rsr_ccount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ccount_args,
    2, Iclass_xt_iclass_wsr_ccount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ccount_args,
    2, Iclass_xt_iclass_xsr_ccount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ccompare0_args,
    1, Iclass_xt_iclass_rsr_ccompare0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ccompare0_args,
    2, Iclass_xt_iclass_wsr_ccompare0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ccompare0_args,
    2, Iclass_xt_iclass_xsr_ccompare0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ccompare1_args,
    1, Iclass_xt_iclass_rsr_ccompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ccompare1_args,
    2, Iclass_xt_iclass_wsr_ccompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ccompare1_args,
    2, Iclass_xt_iclass_xsr_ccompare1_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_icache_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_icache_lock_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_icache_inv_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_licx_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_sicx_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_dcache_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_dcache_dyn_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_dcache_ind_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_dcache_inv_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_dpf_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_dpfb_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_bpfnxt */,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_dpdngrd_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_bpfctl */,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_dcache_lock_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_sdct_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_ldct_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_prefctl_args,
    1, Iclass_xt_iclass_rsr_prefctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_prefctl_args,
    1, Iclass_xt_iclass_wsr_prefctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_prefctl_args,
    1, Iclass_xt_iclass_xsr_prefctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_idtlb_args,
    1, Iclass_xt_iclass_idtlb_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_rdtlb_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_wdtlb_args,
    1, Iclass_xt_iclass_wdtlb_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_iitlb_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_ritlb_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_witlb_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_cpenable_args,
    1, Iclass_xt_iclass_rsr_cpenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_cpenable_args,
    1, Iclass_xt_iclass_wsr_cpenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_cpenable_args,
    1, Iclass_xt_iclass_xsr_cpenable_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_clamp_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_minmax_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_nsa_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_sx_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l32ai_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32ri_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32c1i_args,
    3, Iclass_xt_iclass_s32c1i_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_scompare1_args,
    1, Iclass_xt_iclass_rsr_scompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_scompare1_args,
    1, Iclass_xt_iclass_wsr_scompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_scompare1_args,
    1, Iclass_xt_iclass_xsr_scompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_atomctl_args,
    1, Iclass_xt_iclass_rsr_atomctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_atomctl_args,
    2, Iclass_xt_iclass_wsr_atomctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_atomctl_args,
    2, Iclass_xt_iclass_xsr_atomctl_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_div_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_rer_args,
    1, Iclass_xt_iclass_rer_stateArgs, 2, Iclass_xt_iclass_rer_intfArgs },
  { 2, Iclass_xt_iclass_wer_args,
    1, Iclass_xt_iclass_wer_stateArgs, 2, Iclass_xt_iclass_wer_intfArgs },
  { 2, Iclass_xt_iclass_wb15_0_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_wb15_1_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_wb15_2_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_wb15_3_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_wb15_4_args,
    0, 0, 0, 0 },
  { 1, Iclass_rur_ae_ovf_sar_args,
    3, Iclass_rur_ae_ovf_sar_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_ovf_sar_args,
    3, Iclass_wur_ae_ovf_sar_stateArgs, 0, 0 },
  { 1, Iclass_rur_ae_bithead_args,
    2, Iclass_rur_ae_bithead_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_bithead_args,
    2, Iclass_wur_ae_bithead_stateArgs, 0, 0 },
  { 1, Iclass_rur_ae_ts_fts_bu_bp_args,
    5, Iclass_rur_ae_ts_fts_bu_bp_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_ts_fts_bu_bp_args,
    5, Iclass_wur_ae_ts_fts_bu_bp_stateArgs, 0, 0 },
  { 1, Iclass_rur_ae_cw_sd_no_args,
    4, Iclass_rur_ae_cw_sd_no_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_cw_sd_no_args,
    4, Iclass_wur_ae_cw_sd_no_stateArgs, 0, 0 },
  { 1, Iclass_rur_ae_cbegin0_args,
    2, Iclass_rur_ae_cbegin0_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_cbegin0_args,
    2, Iclass_wur_ae_cbegin0_stateArgs, 0, 0 },
  { 1, Iclass_rur_ae_cend0_args,
    2, Iclass_rur_ae_cend0_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_cend0_args,
    2, Iclass_wur_ae_cend0_stateArgs, 0, 0 },
  { 1, Iclass_rur_ae_cbegin1_args,
    2, Iclass_rur_ae_cbegin1_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_cbegin1_args,
    2, Iclass_wur_ae_cbegin1_stateArgs, 0, 0 },
  { 1, Iclass_rur_ae_cend1_args,
    2, Iclass_rur_ae_cend1_stateArgs, 0, 0 },
  { 1, Iclass_wur_ae_cend1_args,
    2, Iclass_wur_ae_cend1_stateArgs, 0, 0 },
  { 2, Iclass_ic_sext16_args,
    0, 0, 0, 0 },
  { 2, Iclass_ic_zext16_args,
    0, 0, 0, 0 },
  { 2, Iclass_ic_clamps16_args,
    0, 0, 0, 0 },
  { 1, Iclass_rur_fcr_args,
    2, Iclass_rur_fcr_stateArgs, 0, 0 },
  { 1, Iclass_wur_fcr_args,
    2, Iclass_wur_fcr_stateArgs, 0, 0 },
  { 1, Iclass_rur_fsr_args,
    6, Iclass_rur_fsr_stateArgs, 0, 0 },
  { 1, Iclass_wur_fsr_args,
    6, Iclass_wur_fsr_stateArgs, 0, 0 },
  { 5, Iclass_iclass_F64ITER_args,
    2, Iclass_iclass_F64ITER_stateArgs, 0, 0 },
  { 4, Iclass_iclass_F64RND_args,
    2, Iclass_iclass_F64RND_stateArgs, 0, 0 },
  { 4, Iclass_iclass_F64ADDC_F64SUBC_args,
    1, Iclass_iclass_F64ADDC_F64SUBC_stateArgs, 0, 0 },
  { 2, Iclass_iclass_F64SIG_args,
    0, 0, 0, 0 },
  { 3, Iclass_iclass_F64CMPL_args,
    1, Iclass_iclass_F64CMPL_stateArgs, 0, 0 },
  { 4, Iclass_iclass_F64CMPH_args,
    3, Iclass_iclass_F64CMPH_stateArgs, 0, 0 },
  { 4, Iclass_iclass_F64NORM_args,
    2, Iclass_iclass_F64NORM_stateArgs, 0, 0 },
  { 3, Iclass_iclass_F64SEXP_args,
    0, 0, 0, 0 },
  { 2, Iclass_iclass_RF64R_args,
    1, Iclass_iclass_RF64R_stateArgs, 0, 0 },
  { 3, Iclass_iclass_WF64R_args,
    1, Iclass_iclass_WF64R_stateArgs, 0, 0 },
  { 1, Iclass_rur_f64r_lo_args,
    1, Iclass_rur_f64r_lo_stateArgs, 0, 0 },
  { 1, Iclass_wur_f64r_lo_args,
    1, Iclass_wur_f64r_lo_stateArgs, 0, 0 },
  { 1, Iclass_rur_f64r_hi_args,
    1, Iclass_rur_f64r_hi_stateArgs, 0, 0 },
  { 1, Iclass_wur_f64r_hi_args,
    1, Iclass_wur_f64r_hi_stateArgs, 0, 0 },
  { 1, Iclass_rur_f64s_args,
    1, Iclass_rur_f64s_stateArgs, 0, 0 },
  { 1, Iclass_wur_f64s_args,
    1, Iclass_wur_f64s_stateArgs, 0, 0 },
  { 1, Iclass_rur_expstate_args,
    1, Iclass_rur_expstate_stateArgs, 0, 0 },
  { 1, Iclass_wur_expstate_args,
    1, Iclass_wur_expstate_stateArgs, 0, 0 },
  { 1, Iclass_iclass_READ_IMPWIRE_args,
    0, 0, 1, Iclass_iclass_READ_IMPWIRE_intfArgs },
  { 1, Iclass_iclass_SETB_EXPSTATE_args,
    1, Iclass_iclass_SETB_EXPSTATE_stateArgs, 0, 0 },
  { 1, Iclass_iclass_CLRB_EXPSTATE_args,
    1, Iclass_iclass_CLRB_EXPSTATE_stateArgs, 0, 0 },
  { 2, Iclass_iclass_WRMSK_EXPSTATE_args,
    1, Iclass_iclass_WRMSK_EXPSTATE_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_OVERFLOW_args,
    2, Iclass_RUR_AE_OVERFLOW_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_OVERFLOW_args,
    2, Iclass_WUR_AE_OVERFLOW_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_SAR_args,
    2, Iclass_RUR_AE_SAR_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_SAR_args,
    2, Iclass_WUR_AE_SAR_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_BITPTR_args,
    2, Iclass_RUR_AE_BITPTR_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_BITPTR_args,
    2, Iclass_WUR_AE_BITPTR_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_BITSUSED_args,
    2, Iclass_RUR_AE_BITSUSED_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_BITSUSED_args,
    2, Iclass_WUR_AE_BITSUSED_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_TABLESIZE_args,
    2, Iclass_RUR_AE_TABLESIZE_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_TABLESIZE_args,
    2, Iclass_WUR_AE_TABLESIZE_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_FIRST_TS_args,
    2, Iclass_RUR_AE_FIRST_TS_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_FIRST_TS_args,
    2, Iclass_WUR_AE_FIRST_TS_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_NEXTOFFSET_args,
    2, Iclass_RUR_AE_NEXTOFFSET_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_NEXTOFFSET_args,
    2, Iclass_WUR_AE_NEXTOFFSET_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_SEARCHDONE_args,
    2, Iclass_RUR_AE_SEARCHDONE_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_SEARCHDONE_args,
    2, Iclass_WUR_AE_SEARCHDONE_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_CWRAP_args,
    2, Iclass_RUR_AE_CWRAP_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_CWRAP_args,
    2, Iclass_WUR_AE_CWRAP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X4F_I_args,
    1, Iclass_AE_L8X4F_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X4F_IP_args,
    1, Iclass_AE_L8X4F_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16M_XC_args,
    3, Iclass_AE_L16M_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16M_XC1_args,
    3, Iclass_AE_L16M_XC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16M_I_args,
    1, Iclass_AE_L16M_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16M_IU_args,
    1, Iclass_AE_L16M_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16M_X_args,
    1, Iclass_AE_L16M_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16M_XU_args,
    1, Iclass_AE_L16M_XU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16_XC_args,
    3, Iclass_AE_L16_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16_XC1_args,
    3, Iclass_AE_L16_XC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16_I_args,
    1, Iclass_AE_L16_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16_IP_args,
    1, Iclass_AE_L16_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16_X_args,
    1, Iclass_AE_L16_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16_XP_args,
    1, Iclass_AE_L16_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32F24_XC_args,
    3, Iclass_AE_L32F24_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32F24_XC1_args,
    3, Iclass_AE_L32F24_XC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32F24_I_args,
    1, Iclass_AE_L32F24_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32F24_IP_args,
    1, Iclass_AE_L32F24_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32F24_X_args,
    1, Iclass_AE_L32F24_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32F24_XP_args,
    1, Iclass_AE_L32F24_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32_XC_args,
    3, Iclass_AE_L32_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32_XC1_args,
    3, Iclass_AE_L32_XC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32_I_args,
    1, Iclass_AE_L32_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32_IP_args,
    1, Iclass_AE_L32_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32_X_args,
    1, Iclass_AE_L32_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32_XP_args,
    1, Iclass_AE_L32_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32M_XC_args,
    3, Iclass_AE_L32M_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32M_I_args,
    1, Iclass_AE_L32M_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32M_IU_args,
    1, Iclass_AE_L32M_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32M_X_args,
    1, Iclass_AE_L32M_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32M_XU_args,
    1, Iclass_AE_L32M_XU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X2M_XC_args,
    3, Iclass_AE_L16X2M_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X2M_XC1_args,
    3, Iclass_AE_L16X2M_XC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X2M_I_args,
    1, Iclass_AE_L16X2M_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X2M_IU_args,
    1, Iclass_AE_L16X2M_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X2M_X_args,
    1, Iclass_AE_L16X2M_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X2M_XU_args,
    1, Iclass_AE_L16X2M_XU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2F24_XC_args,
    3, Iclass_AE_L32X2F24_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2F24_XC1_args,
    3, Iclass_AE_L32X2F24_XC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2F24_I_args,
    1, Iclass_AE_L32X2F24_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2F24_IP_args,
    1, Iclass_AE_L32X2F24_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2F24_RIP_args,
    1, Iclass_AE_L32X2F24_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2F24_RI_args,
    1, Iclass_AE_L32X2F24_RI_stateArgs, 0, 0 },
  { 2, Iclass_AE_L32X2F24_RIC_args,
    3, Iclass_AE_L32X2F24_RIC_stateArgs, 0, 0 },
  { 2, Iclass_AE_L32X2F24_RIC1_args,
    3, Iclass_AE_L32X2F24_RIC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2F24_X_args,
    1, Iclass_AE_L32X2F24_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2F24_XP_args,
    1, Iclass_AE_L32X2F24_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2_XC_args,
    3, Iclass_AE_L32X2_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2_XC1_args,
    3, Iclass_AE_L32X2_XC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2_I_args,
    1, Iclass_AE_L32X2_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2_IP_args,
    1, Iclass_AE_L32X2_IP_stateArgs, 0, 0 },
  { 2, Iclass_AE_L32X2_RIC_args,
    3, Iclass_AE_L32X2_RIC_stateArgs, 0, 0 },
  { 2, Iclass_AE_L32X2_RIC1_args,
    3, Iclass_AE_L32X2_RIC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2_X_args,
    1, Iclass_AE_L32X2_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2_XP_args,
    1, Iclass_AE_L32X2_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X4_XC_args,
    3, Iclass_AE_L16X4_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X4_XC1_args,
    3, Iclass_AE_L16X4_XC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X4_I_args,
    1, Iclass_AE_L16X4_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X4_IP_args,
    1, Iclass_AE_L16X4_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X4_X_args,
    1, Iclass_AE_L16X4_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X4_XP_args,
    1, Iclass_AE_L16X4_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L64_XC_args,
    3, Iclass_AE_L64_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L64_XC1_args,
    3, Iclass_AE_L64_XC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_L64_I_args,
    1, Iclass_AE_L64_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L64_IP_args,
    1, Iclass_AE_L64_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L64_X_args,
    1, Iclass_AE_L64_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L64_XP_args,
    1, Iclass_AE_L64_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X2M_XC_args,
    3, Iclass_AE_S16X2M_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X2M_XC1_args,
    3, Iclass_AE_S16X2M_XC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X2M_I_args,
    1, Iclass_AE_S16X2M_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X2M_IU_args,
    1, Iclass_AE_S16X2M_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X2M_X_args,
    1, Iclass_AE_S16X2M_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X2M_XU_args,
    1, Iclass_AE_S16X2M_XU_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2F24_XC_args,
    3, Iclass_AE_S32X2F24_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2F24_XC1_args,
    3, Iclass_AE_S32X2F24_XC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2F24_I_args,
    1, Iclass_AE_S32X2F24_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2F24_IP_args,
    1, Iclass_AE_S32X2F24_IP_stateArgs, 0, 0 },
  { 2, Iclass_AE_S32X2F24_RIP_args,
    1, Iclass_AE_S32X2F24_RIP_stateArgs, 0, 0 },
  { 2, Iclass_AE_S32X2F24_RIC_args,
    3, Iclass_AE_S32X2F24_RIC_stateArgs, 0, 0 },
  { 2, Iclass_AE_S32X2F24_RIC1_args,
    3, Iclass_AE_S32X2F24_RIC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2F24_X_args,
    1, Iclass_AE_S32X2F24_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2F24_XP_args,
    1, Iclass_AE_S32X2F24_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2_XC_args,
    3, Iclass_AE_S32X2_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2_XC1_args,
    3, Iclass_AE_S32X2_XC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2_I_args,
    1, Iclass_AE_S32X2_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2_IP_args,
    1, Iclass_AE_S32X2_IP_stateArgs, 0, 0 },
  { 2, Iclass_AE_S32X2_RIC_args,
    3, Iclass_AE_S32X2_RIC_stateArgs, 0, 0 },
  { 2, Iclass_AE_S32X2_RIC1_args,
    3, Iclass_AE_S32X2_RIC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2_X_args,
    1, Iclass_AE_S32X2_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2_XP_args,
    1, Iclass_AE_S32X2_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2RNG_I_args,
    2, Iclass_AE_S32X2RNG_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2RNG_IP_args,
    2, Iclass_AE_S32X2RNG_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2RNG_X_args,
    2, Iclass_AE_S32X2RNG_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2RNG_XP_args,
    2, Iclass_AE_S32X2RNG_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4_XC_args,
    3, Iclass_AE_S16X4_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4_XC1_args,
    3, Iclass_AE_S16X4_XC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4_I_args,
    1, Iclass_AE_S16X4_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4_IP_args,
    1, Iclass_AE_S16X4_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4_X_args,
    1, Iclass_AE_S16X4_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4_XP_args,
    1, Iclass_AE_S16X4_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16M_L_XC_args,
    3, Iclass_AE_S16M_L_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16M_L_XC1_args,
    3, Iclass_AE_S16M_L_XC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16M_L_I_args,
    1, Iclass_AE_S16M_L_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16M_L_IU_args,
    1, Iclass_AE_S16M_L_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16M_L_X_args,
    1, Iclass_AE_S16M_L_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16M_L_XU_args,
    1, Iclass_AE_S16M_L_XU_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32F24_L_XC_args,
    3, Iclass_AE_S32F24_L_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32F24_L_XC1_args,
    3, Iclass_AE_S32F24_L_XC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32F24_L_I_args,
    1, Iclass_AE_S32F24_L_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32F24_L_IP_args,
    1, Iclass_AE_S32F24_L_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32F24_L_X_args,
    1, Iclass_AE_S32F24_L_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32F24_L_XP_args,
    1, Iclass_AE_S32F24_L_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_L_XC_args,
    3, Iclass_AE_S32_L_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_L_XC1_args,
    3, Iclass_AE_S32_L_XC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_L_I_args,
    1, Iclass_AE_S32_L_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_L_IP_args,
    1, Iclass_AE_S32_L_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_L_X_args,
    1, Iclass_AE_S32_L_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_L_XP_args,
    1, Iclass_AE_S32_L_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16_0_XC_args,
    3, Iclass_AE_S16_0_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16_0_XC1_args,
    3, Iclass_AE_S16_0_XC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16_0_I_args,
    1, Iclass_AE_S16_0_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16_0_IP_args,
    1, Iclass_AE_S16_0_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16_0_X_args,
    1, Iclass_AE_S16_0_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16_0_XP_args,
    1, Iclass_AE_S16_0_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S64_XC_args,
    3, Iclass_AE_S64_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S64_XC1_args,
    3, Iclass_AE_S64_XC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_S64_I_args,
    1, Iclass_AE_S64_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S64_IP_args,
    1, Iclass_AE_S64_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S64_X_args,
    1, Iclass_AE_S64_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S64_XP_args,
    1, Iclass_AE_S64_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32M_XC_args,
    3, Iclass_AE_S32M_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32M_I_args,
    1, Iclass_AE_S32M_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32M_IU_args,
    1, Iclass_AE_S32M_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32M_X_args,
    1, Iclass_AE_S32M_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32M_XU_args,
    1, Iclass_AE_S32M_XU_stateArgs, 0, 0 },
  { 1, Iclass_AE_ZALIGN64_args,
    1, Iclass_AE_ZALIGN64_stateArgs, 0, 0 },
  { 3, Iclass_AE_LALIGN64_I_args,
    1, Iclass_AE_LALIGN64_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_SALIGN64_I_args,
    1, Iclass_AE_SALIGN64_I_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVALIGN_args,
    1, Iclass_AE_MOVALIGN_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA64_PP_args,
    1, Iclass_AE_LA64_PP_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA24POS_PC_args,
    3, Iclass_AE_LA24POS_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA24X2POS_PC_args,
    3, Iclass_AE_LA24X2POS_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA32X2POS_PC_args,
    3, Iclass_AE_LA32X2POS_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA16X4POS_PC_args,
    3, Iclass_AE_LA16X4POS_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA24NEG_PC_args,
    3, Iclass_AE_LA24NEG_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA24X2NEG_PC_args,
    3, Iclass_AE_LA24X2NEG_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA32X2NEG_PC_args,
    3, Iclass_AE_LA32X2NEG_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA16X4NEG_PC_args,
    3, Iclass_AE_LA16X4NEG_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA24POS_PC1_args,
    3, Iclass_AE_LA24POS_PC1_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA24X2POS_PC1_args,
    3, Iclass_AE_LA24X2POS_PC1_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA32X2POS_PC1_args,
    3, Iclass_AE_LA32X2POS_PC1_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA16X4POS_PC1_args,
    3, Iclass_AE_LA16X4POS_PC1_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA24NEG_PC1_args,
    3, Iclass_AE_LA24NEG_PC1_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA24X2NEG_PC1_args,
    3, Iclass_AE_LA24X2NEG_PC1_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA32X2NEG_PC1_args,
    3, Iclass_AE_LA32X2NEG_PC1_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA16X4NEG_PC1_args,
    3, Iclass_AE_LA16X4NEG_PC1_stateArgs, 0, 0 },
  { 2, Iclass_AE_SA64POS_FP_args,
    1, Iclass_AE_SA64POS_FP_stateArgs, 0, 0 },
  { 2, Iclass_AE_SA64NEG_FP_args,
    1, Iclass_AE_SA64NEG_FP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2_IC_args,
    3, Iclass_AE_LA32X2_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2_IC1_args,
    3, Iclass_AE_LA32X2_IC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2_IP_args,
    1, Iclass_AE_LA32X2_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2_RIP_args,
    1, Iclass_AE_LA32X2_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2_RIC_args,
    3, Iclass_AE_LA32X2_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2_RIC1_args,
    3, Iclass_AE_LA32X2_RIC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA16X4_IC_args,
    3, Iclass_AE_LA16X4_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA16X4_IC1_args,
    3, Iclass_AE_LA16X4_IC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA16X4_IP_args,
    1, Iclass_AE_LA16X4_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA16X4_RIP_args,
    1, Iclass_AE_LA16X4_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA16X4_RIC_args,
    3, Iclass_AE_LA16X4_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA16X4_RIC1_args,
    3, Iclass_AE_LA16X4_RIC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2F24_IC_args,
    3, Iclass_AE_LA32X2F24_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2F24_IC1_args,
    3, Iclass_AE_LA32X2F24_IC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2F24_IP_args,
    1, Iclass_AE_LA32X2F24_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2F24_RIP_args,
    1, Iclass_AE_LA32X2F24_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2F24_RIC_args,
    3, Iclass_AE_LA32X2F24_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2F24_RIC1_args,
    3, Iclass_AE_LA32X2F24_RIC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24_IC_args,
    3, Iclass_AE_LA24_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24_IC1_args,
    3, Iclass_AE_LA24_IC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24_IP_args,
    1, Iclass_AE_LA24_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24_RIP_args,
    1, Iclass_AE_LA24_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24_RIC_args,
    3, Iclass_AE_LA24_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24_RIC1_args,
    3, Iclass_AE_LA24_RIC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24X2_IC_args,
    3, Iclass_AE_LA24X2_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24X2_IC1_args,
    3, Iclass_AE_LA24X2_IC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24X2_IP_args,
    1, Iclass_AE_LA24X2_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24X2_RIP_args,
    1, Iclass_AE_LA24X2_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24X2_RIC_args,
    3, Iclass_AE_LA24X2_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA24X2_RIC1_args,
    3, Iclass_AE_LA24X2_RIC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2_IC_args,
    3, Iclass_AE_SA32X2_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2_IC1_args,
    3, Iclass_AE_SA32X2_IC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2_IP_args,
    1, Iclass_AE_SA32X2_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2_RIP_args,
    1, Iclass_AE_SA32X2_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2_RIC_args,
    3, Iclass_AE_SA32X2_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2_RIC1_args,
    3, Iclass_AE_SA32X2_RIC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA16X4_IC_args,
    3, Iclass_AE_SA16X4_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA16X4_IC1_args,
    3, Iclass_AE_SA16X4_IC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA16X4_IP_args,
    1, Iclass_AE_SA16X4_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA16X4_RIP_args,
    1, Iclass_AE_SA16X4_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA16X4_RIC_args,
    3, Iclass_AE_SA16X4_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA16X4_RIC1_args,
    3, Iclass_AE_SA16X4_RIC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2F24_IC_args,
    3, Iclass_AE_SA32X2F24_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2F24_IC1_args,
    3, Iclass_AE_SA32X2F24_IC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2F24_IP_args,
    1, Iclass_AE_SA32X2F24_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2F24_RIP_args,
    1, Iclass_AE_SA32X2F24_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2F24_RIC_args,
    3, Iclass_AE_SA32X2F24_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2F24_RIC1_args,
    3, Iclass_AE_SA32X2F24_RIC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24_L_IC_args,
    3, Iclass_AE_SA24_L_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24_L_IC1_args,
    3, Iclass_AE_SA24_L_IC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24_L_IP_args,
    1, Iclass_AE_SA24_L_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24_L_RIP_args,
    1, Iclass_AE_SA24_L_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24_L_RIC_args,
    3, Iclass_AE_SA24_L_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24_L_RIC1_args,
    3, Iclass_AE_SA24_L_RIC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24X2_IC_args,
    3, Iclass_AE_SA24X2_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24X2_IC1_args,
    3, Iclass_AE_SA24X2_IC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24X2_IP_args,
    1, Iclass_AE_SA24X2_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24X2_RIP_args,
    1, Iclass_AE_SA24X2_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24X2_RIC_args,
    3, Iclass_AE_SA24X2_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA24X2_RIC1_args,
    3, Iclass_AE_SA24X2_RIC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADDICIRC_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_ADDCIRC_XC1_args,
    3, Iclass_AE_ADDCIRC_XC1_stateArgs, 0, 0 },
  { 2, Iclass_AE_ADDCIRC_XC_args,
    3, Iclass_AE_ADDCIRC_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32RA64S_I_args,
    2, Iclass_AE_S32RA64S_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32RA64S_IP_args,
    2, Iclass_AE_S32RA64S_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32RA64S_X_args,
    2, Iclass_AE_S32RA64S_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32RA64S_XP_args,
    2, Iclass_AE_S32RA64S_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32RA64S_XC_args,
    4, Iclass_AE_S32RA64S_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32RA64S_XC1_args,
    4, Iclass_AE_S32RA64S_XC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_S24RA64S_I_args,
    2, Iclass_AE_S24RA64S_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S24RA64S_IP_args,
    2, Iclass_AE_S24RA64S_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S24RA64S_X_args,
    2, Iclass_AE_S24RA64S_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S24RA64S_XP_args,
    2, Iclass_AE_S24RA64S_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S24RA64S_XC_args,
    4, Iclass_AE_S24RA64S_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S24RA64S_XC1_args,
    4, Iclass_AE_S24RA64S_XC1_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2RA64S_IP_args,
    2, Iclass_AE_S32X2RA64S_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S24X2RA64S_IP_args,
    2, Iclass_AE_S24X2RA64S_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADDBRBA32_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_BITSWAP_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_MUL32JS_args,
    1, Iclass_AE_MUL32JS_stateArgs, 0, 0 },
  { 4, Iclass_AE_ADDANDSUB32S_args,
    2, Iclass_AE_ADDANDSUB32S_stateArgs, 0, 0 },
  { 4, Iclass_AE_ADDANDSUBRNG32_args,
    2, Iclass_AE_ADDANDSUBRNG32_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADDRNG32_args,
    2, Iclass_AE_ADDRNG32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUBRNG32_args,
    2, Iclass_AE_SUBRNG32_stateArgs, 0, 0 },
  { 0, 0 /* AE_CALCRNG3 */,
    2, Iclass_AE_CALCRNG3_stateArgs, 0, 0 },
  { 0, 0 /* AE_CALCRNG2 */,
    2, Iclass_AE_CALCRNG2_stateArgs, 0, 0 },
  { 0, 0 /* AE_CALCRNG1 */,
    2, Iclass_AE_CALCRNG1_stateArgs, 0, 0 },
  { 1, Iclass_AE_RNG32X2_args,
    2, Iclass_AE_RNG32X2_stateArgs, 0, 0 },
  { 4, Iclass_AE_SEL16I_args,
    1, Iclass_AE_SEL16I_stateArgs, 0, 0 },
  { 4, Iclass_AE_SEL16I_N_args,
    1, Iclass_AE_SEL16I_N_stateArgs, 0, 0 },
  { 2, Iclass_AE_SHORTSWAP_args,
    1, Iclass_AE_SHORTSWAP_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAB4_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_MOVAB2_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_MOVAB_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_MOVBA_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_MOVBA1X2_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_MOVBA4_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_MOVBA2_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_MOVB2_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_MOVB4_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_MOVT16X4_args,
    1, Iclass_AE_MOVT16X4_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVF16X4_args,
    1, Iclass_AE_MOVF16X4_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVT32X2_args,
    1, Iclass_AE_MOVT32X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVF32X2_args,
    1, Iclass_AE_MOVF32X2_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVSARA7X2_args,
    2, Iclass_AE_MOVSARA7X2_stateArgs, 0, 0 },
  { 1, Iclass_AE_MOVSARD7_args,
    2, Iclass_AE_MOVSARD7_stateArgs, 0, 0 },
  { 1, Iclass_AE_MOVASAR_args,
    2, Iclass_AE_MOVASAR_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVDA32X2_args,
    1, Iclass_AE_MOVDA32X2_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVDA32_args,
    1, Iclass_AE_MOVDA32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVDA16X2_args,
    1, Iclass_AE_MOVDA16X2_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVDA16_args,
    1, Iclass_AE_MOVDA16_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVI_args,
    1, Iclass_AE_MOVI_stateArgs, 0, 0 },
  { 3, Iclass_AE_TRUNCP24A32X2_args,
    1, Iclass_AE_TRUNCP24A32X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_SAT16X4_args,
    2, Iclass_AE_SAT16X4_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVT32X2F16_32_args,
    1, Iclass_AE_CVT32X2F16_32_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVT32X2F16_10_args,
    1, Iclass_AE_CVT32X2F16_10_stateArgs, 0, 0 },
  { 2, Iclass_AE_SEXT32X2D16_32_args,
    1, Iclass_AE_SEXT32X2D16_32_stateArgs, 0, 0 },
  { 2, Iclass_AE_SEXT32X2D16_10_args,
    1, Iclass_AE_SEXT32X2D16_10_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVTA32F24S_L_args,
    1, Iclass_AE_CVTA32F24S_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVTA32F24S_H_args,
    1, Iclass_AE_CVTA32F24S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_CVTP24A16X2_LL_args,
    1, Iclass_AE_CVTP24A16X2_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_CVTP24A16X2_LH_args,
    1, Iclass_AE_CVTP24A16X2_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_CVTP24A16X2_HL_args,
    1, Iclass_AE_CVTP24A16X2_HL_stateArgs, 0, 0 },
  { 3, Iclass_AE_CVTP24A16X2_HH_args,
    1, Iclass_AE_CVTP24A16X2_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_TRUNCP24Q48X2_args,
    1, Iclass_AE_TRUNCP24Q48X2_stateArgs, 0, 0 },
  { 4, Iclass_AE_TRUNCA32X2F64S_args,
    2, Iclass_AE_TRUNCA32X2F64S_stateArgs, 0, 0 },
  { 4, Iclass_AE_TRUNCI32X2F64S_args,
    2, Iclass_AE_TRUNCI32X2F64S_stateArgs, 0, 0 },
  { 4, Iclass_AE_TRUNCA32F64S_L_args,
    2, Iclass_AE_TRUNCA32F64S_L_stateArgs, 0, 0 },
  { 4, Iclass_AE_TRUNCI32F64S_L_args,
    2, Iclass_AE_TRUNCI32F64S_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_TRUNCP16_args,
    1, Iclass_AE_TRUNCP16_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND32X2F64SSYM_args,
    2, Iclass_AE_ROUND32X2F64SSYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND32X2F64SASYM_args,
    2, Iclass_AE_ROUND32X2F64SASYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND32X2F48SSYM_args,
    2, Iclass_AE_ROUND32X2F48SSYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND32X2F48SASYM_args,
    2, Iclass_AE_ROUND32X2F48SASYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND16X4F32SSYM_args,
    2, Iclass_AE_ROUND16X4F32SSYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND16X4F32SASYM_args,
    2, Iclass_AE_ROUND16X4F32SASYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND24X2F48SSYM_args,
    2, Iclass_AE_ROUND24X2F48SSYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND24X2F48SASYM_args,
    2, Iclass_AE_ROUND24X2F48SASYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUNDSP16Q48X2SYM_args,
    2, Iclass_AE_ROUNDSP16Q48X2SYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUNDSP16Q48X2ASYM_args,
    2, Iclass_AE_ROUNDSP16Q48X2ASYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_MINABS32S_args,
    2, Iclass_AE_MINABS32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_MAXABS32S_args,
    2, Iclass_AE_MAXABS32S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ROUNDSP16F24SYM_args,
    2, Iclass_AE_ROUNDSP16F24SYM_stateArgs, 0, 0 },
  { 2, Iclass_AE_ROUNDSP16F24ASYM_args,
    2, Iclass_AE_ROUNDSP16F24ASYM_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOV_args,
    1, Iclass_AE_MOV_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVT64_args,
    1, Iclass_AE_MOVT64_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVF64_args,
    1, Iclass_AE_MOVF64_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVTQ56A32S_args,
    1, Iclass_AE_CVTQ56A32S_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVT48A32_args,
    1, Iclass_AE_CVT48A32_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVT64A32_args,
    1, Iclass_AE_CVT64A32_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVTQ56P32S_L_args,
    1, Iclass_AE_CVTQ56P32S_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVTQ56P32S_H_args,
    1, Iclass_AE_CVTQ56P32S_H_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVT64F32_H_args,
    1, Iclass_AE_CVT64F32_H_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVT48F32_L_args,
    1, Iclass_AE_CVT48F32_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVT48F32_H_args,
    1, Iclass_AE_CVT48F32_H_stateArgs, 0, 0 },
  { 2, Iclass_AE_SAT48S_args,
    2, Iclass_AE_SAT48S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SATQ56S_args,
    2, Iclass_AE_SATQ56S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SAT24S_args,
    2, Iclass_AE_SAT24S_stateArgs, 0, 0 },
  { 2, Iclass_AE_TRUNCQ32_args,
    1, Iclass_AE_TRUNCQ32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MINABS64S_args,
    2, Iclass_AE_MINABS64S_stateArgs, 0, 0 },
  { 3, Iclass_AE_MAXABS64S_args,
    2, Iclass_AE_MAXABS64S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ROUNDSQ32F48SYM_args,
    2, Iclass_AE_ROUNDSQ32F48SYM_stateArgs, 0, 0 },
  { 2, Iclass_AE_ROUNDSQ32F48ASYM_args,
    2, Iclass_AE_ROUNDSQ32F48ASYM_stateArgs, 0, 0 },
  { 2, Iclass_AE_TRUNCA32Q48_args,
    1, Iclass_AE_TRUNCA32Q48_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD32_L_args,
    1, Iclass_AE_MOVAD32_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD32_H_args,
    1, Iclass_AE_MOVAD32_H_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD16_3_args,
    1, Iclass_AE_MOVAD16_3_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD16_2_args,
    1, Iclass_AE_MOVAD16_2_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD16_1_args,
    1, Iclass_AE_MOVAD16_1_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD16_0_args,
    1, Iclass_AE_MOVAD16_0_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRA64_32_args,
    1, Iclass_AE_SRA64_32_stateArgs, 0, 0 },
  { 3, Iclass_AE_PKSR32_args,
    2, Iclass_AE_PKSR32_stateArgs, 0, 0 },
  { 3, Iclass_AE_PKSR24_args,
    2, Iclass_AE_PKSR24_stateArgs, 0, 0 },
  { 3, Iclass_AE_PKSRF32_args,
    2, Iclass_AE_PKSRF32_stateArgs, 0, 0 },
  { 2, Iclass_AE_TRUNCA16P24S_L_args,
    1, Iclass_AE_TRUNCA16P24S_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_TRUNCA16P24S_H_args,
    1, Iclass_AE_TRUNCA16P24S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD32_args,
    1, Iclass_AE_ADD32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB32_args,
    1, Iclass_AE_SUB32_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADDSUB32_args,
    1, Iclass_AE_ADDSUB32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUBADD32_args,
    1, Iclass_AE_SUBADD32_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD16_args,
    1, Iclass_AE_ADD16_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB16_args,
    1, Iclass_AE_SUB16_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD32_HL_LH_args,
    1, Iclass_AE_ADD32_HL_LH_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG32_args,
    1, Iclass_AE_NEG32_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS32_args,
    1, Iclass_AE_ABS32_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD24S_args,
    2, Iclass_AE_ADD24S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB24S_args,
    2, Iclass_AE_SUB24S_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD32S_args,
    2, Iclass_AE_ADD32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB32S_args,
    2, Iclass_AE_SUB32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADDSUB32S_args,
    2, Iclass_AE_ADDSUB32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUBADD32S_args,
    2, Iclass_AE_SUBADD32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD16S_args,
    2, Iclass_AE_ADD16S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB16S_args,
    2, Iclass_AE_SUB16S_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD32S_HL_LH_args,
    2, Iclass_AE_ADD32S_HL_LH_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG24S_args,
    2, Iclass_AE_NEG24S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS24S_args,
    2, Iclass_AE_ABS24S_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG32S_args,
    1, Iclass_AE_NEG32S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS32S_args,
    1, Iclass_AE_ABS32S_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG16S_args,
    1, Iclass_AE_NEG16S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS16S_args,
    1, Iclass_AE_ABS16S_stateArgs, 0, 0 },
  { 3, Iclass_AE_LT16_args,
    1, Iclass_AE_LT16_stateArgs, 0, 0 },
  { 3, Iclass_AE_LE16_args,
    1, Iclass_AE_LE16_stateArgs, 0, 0 },
  { 3, Iclass_AE_EQ16_args,
    1, Iclass_AE_EQ16_stateArgs, 0, 0 },
  { 3, Iclass_AE_LT32_args,
    1, Iclass_AE_LT32_stateArgs, 0, 0 },
  { 3, Iclass_AE_LE32_args,
    1, Iclass_AE_LE32_stateArgs, 0, 0 },
  { 3, Iclass_AE_EQ32_args,
    1, Iclass_AE_EQ32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MIN32_args,
    1, Iclass_AE_MIN32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MAX32_args,
    1, Iclass_AE_MAX32_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD64_args,
    1, Iclass_AE_ADD64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB64_args,
    1, Iclass_AE_SUB64_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG64_args,
    1, Iclass_AE_NEG64_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS64_args,
    1, Iclass_AE_ABS64_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADDSQ56S_args,
    2, Iclass_AE_ADDSQ56S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUBSQ56S_args,
    2, Iclass_AE_SUBSQ56S_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD64S_args,
    2, Iclass_AE_ADD64S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB64S_args,
    2, Iclass_AE_SUB64S_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEGSQ56S_args,
    2, Iclass_AE_NEGSQ56S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABSSQ56S_args,
    2, Iclass_AE_ABSSQ56S_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG64S_args,
    2, Iclass_AE_NEG64S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS64S_args,
    2, Iclass_AE_ABS64S_stateArgs, 0, 0 },
  { 3, Iclass_AE_AND_args,
    1, Iclass_AE_AND_stateArgs, 0, 0 },
  { 3, Iclass_AE_NAND_args,
    1, Iclass_AE_NAND_stateArgs, 0, 0 },
  { 3, Iclass_AE_OR_args,
    1, Iclass_AE_OR_stateArgs, 0, 0 },
  { 3, Iclass_AE_XOR_args,
    1, Iclass_AE_XOR_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI24_args,
    1, Iclass_AE_SLAI24_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRLI24_args,
    1, Iclass_AE_SRLI24_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI24_args,
    1, Iclass_AE_SRAI24_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLAS24_args,
    2, Iclass_AE_SLAS24_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRLS24_args,
    2, Iclass_AE_SRLS24_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRAS24_args,
    2, Iclass_AE_SRAS24_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI16_args,
    1, Iclass_AE_SRAI16_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI16R_args,
    1, Iclass_AE_SRAI16R_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI32_args,
    1, Iclass_AE_SLAI32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRLI32_args,
    1, Iclass_AE_SRLI32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI32_args,
    1, Iclass_AE_SRAI32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI32R_args,
    1, Iclass_AE_SRAI32R_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLAS32_args,
    2, Iclass_AE_SLAS32_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRLS32_args,
    2, Iclass_AE_SRLS32_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRAS32_args,
    2, Iclass_AE_SRAS32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAA32_args,
    1, Iclass_AE_SLAA32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRLA32_args,
    1, Iclass_AE_SRLA32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA32_args,
    1, Iclass_AE_SRAA32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI16S_args,
    2, Iclass_AE_SLAI16S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAA16S_args,
    2, Iclass_AE_SLAA16S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA16S_args,
    2, Iclass_AE_SRAA16S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA16RS_args,
    2, Iclass_AE_SRAA16RS_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI24S_args,
    2, Iclass_AE_SLAI24S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLAS24S_args,
    3, Iclass_AE_SLAS24S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI32S_args,
    2, Iclass_AE_SLAI32S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLAS32S_args,
    3, Iclass_AE_SLAS32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAA32S_args,
    2, Iclass_AE_SLAA32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA32S_args,
    2, Iclass_AE_SRAA32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA32RS_args,
    2, Iclass_AE_SRAA32RS_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLASQ56_args,
    2, Iclass_AE_SLASQ56_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRLSQ56_args,
    2, Iclass_AE_SRLSQ56_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRASQ56_args,
    2, Iclass_AE_SRASQ56_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAAQ56_args,
    1, Iclass_AE_SLAAQ56_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRLAQ56_args,
    1, Iclass_AE_SRLAQ56_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAAQ56_args,
    1, Iclass_AE_SRAAQ56_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI64_args,
    1, Iclass_AE_SLAI64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRLI64_args,
    1, Iclass_AE_SRLI64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI64_args,
    1, Iclass_AE_SRAI64_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLAS64_args,
    2, Iclass_AE_SLAS64_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRLS64_args,
    2, Iclass_AE_SRLS64_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRAS64_args,
    2, Iclass_AE_SRAS64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAA64_args,
    1, Iclass_AE_SLAA64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRLA64_args,
    1, Iclass_AE_SRLA64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA64_args,
    1, Iclass_AE_SRAA64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAISQ56S_args,
    2, Iclass_AE_SLAISQ56S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLASSQ56S_args,
    3, Iclass_AE_SLASSQ56S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAASQ56S_args,
    2, Iclass_AE_SLAASQ56S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI64S_args,
    2, Iclass_AE_SLAI64S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLAS64S_args,
    3, Iclass_AE_SLAS64S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAA64S_args,
    2, Iclass_AE_SLAA64S_stateArgs, 0, 0 },
  { 3, Iclass_AE_LT64_args,
    1, Iclass_AE_LT64_stateArgs, 0, 0 },
  { 3, Iclass_AE_LE64_args,
    1, Iclass_AE_LE64_stateArgs, 0, 0 },
  { 3, Iclass_AE_EQ64_args,
    1, Iclass_AE_EQ64_stateArgs, 0, 0 },
  { 3, Iclass_AE_MAX64_args,
    1, Iclass_AE_MAX64_stateArgs, 0, 0 },
  { 3, Iclass_AE_MIN64_args,
    1, Iclass_AE_MIN64_stateArgs, 0, 0 },
  { 2, Iclass_AE_NSA64_args,
    1, Iclass_AE_NSA64_stateArgs, 0, 0 },
  { 2, Iclass_AE_NSAZ16_0_args,
    1, Iclass_AE_NSAZ16_0_stateArgs, 0, 0 },
  { 2, Iclass_AE_NSAZ32_L_args,
    1, Iclass_AE_NSAZ32_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32F48P16S_LL_args,
    2, Iclass_AE_MULS32F48P16S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32S_LL_args,
    2, Iclass_AE_MULF32S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32_LL_args,
    1, Iclass_AE_MUL32_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32S_LL_S2_args,
    2, Iclass_AE_MULF32S_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32_LL_S2_args,
    1, Iclass_AE_MUL32_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32F48P16S_LL_S2_args,
    2, Iclass_AE_MULS32F48P16S_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32R_LL_args,
    1, Iclass_AE_MULF32R_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32RA_LL_args,
    1, Iclass_AE_MULF32RA_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32RA_LL_S2_args,
    1, Iclass_AE_MULF32RA_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32R_LL_S2_args,
    1, Iclass_AE_MULF32R_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32F48P16S_LH_args,
    2, Iclass_AE_MULS32F48P16S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32S_LH_args,
    2, Iclass_AE_MULF32S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32_LH_args,
    1, Iclass_AE_MUL32_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32S_LH_S2_args,
    2, Iclass_AE_MULF32S_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32_LH_S2_args,
    1, Iclass_AE_MUL32_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32F48P16S_LH_S2_args,
    2, Iclass_AE_MULS32F48P16S_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32R_LH_args,
    1, Iclass_AE_MULF32R_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32RA_LH_args,
    1, Iclass_AE_MULF32RA_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32RA_LH_S2_args,
    1, Iclass_AE_MULF32RA_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32R_LH_S2_args,
    1, Iclass_AE_MULF32R_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32F48P16S_HH_args,
    2, Iclass_AE_MULS32F48P16S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32S_HH_args,
    2, Iclass_AE_MULF32S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32_HH_args,
    1, Iclass_AE_MUL32_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32S_HH_S2_args,
    2, Iclass_AE_MULF32S_HH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32_HH_S2_args,
    1, Iclass_AE_MUL32_HH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32F48P16S_HH_S2_args,
    2, Iclass_AE_MULS32F48P16S_HH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32R_HH_args,
    1, Iclass_AE_MULF32R_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32RA_HH_args,
    1, Iclass_AE_MULF32RA_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32RA_HH_S2_args,
    1, Iclass_AE_MULF32RA_HH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32R_HH_S2_args,
    1, Iclass_AE_MULF32R_HH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAS32F48P16S_LL_args,
    2, Iclass_AE_MULAS32F48P16S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32S_LL_args,
    2, Iclass_AE_MULAF32S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32_LL_args,
    1, Iclass_AE_MULA32_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32S_LL_S2_args,
    2, Iclass_AE_MULAF32S_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32_LL_S2_args,
    1, Iclass_AE_MULA32_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAS32F48P16S_LL_S2_args,
    2, Iclass_AE_MULAS32F48P16S_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32R_LL_args,
    1, Iclass_AE_MULAF32R_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32RA_LL_args,
    1, Iclass_AE_MULAF32RA_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32RA_LL_S2_args,
    1, Iclass_AE_MULAF32RA_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32R_LL_S2_args,
    1, Iclass_AE_MULAF32R_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAS32F48P16S_LH_args,
    2, Iclass_AE_MULAS32F48P16S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32S_LH_args,
    2, Iclass_AE_MULAF32S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32_LH_args,
    1, Iclass_AE_MULA32_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32S_LH_S2_args,
    2, Iclass_AE_MULAF32S_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32_LH_S2_args,
    1, Iclass_AE_MULA32_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAS32F48P16S_LH_S2_args,
    2, Iclass_AE_MULAS32F48P16S_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32R_LH_args,
    1, Iclass_AE_MULAF32R_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32RA_LH_args,
    1, Iclass_AE_MULAF32RA_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32RA_LH_S2_args,
    1, Iclass_AE_MULAF32RA_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32R_LH_S2_args,
    1, Iclass_AE_MULAF32R_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAS32F48P16S_HH_args,
    2, Iclass_AE_MULAS32F48P16S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32S_HH_args,
    2, Iclass_AE_MULAF32S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32_HH_args,
    1, Iclass_AE_MULA32_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32S_HH_S2_args,
    2, Iclass_AE_MULAF32S_HH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32_HH_S2_args,
    1, Iclass_AE_MULA32_HH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAS32F48P16S_HH_S2_args,
    2, Iclass_AE_MULAS32F48P16S_HH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32R_HH_args,
    1, Iclass_AE_MULAF32R_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32RA_HH_args,
    1, Iclass_AE_MULAF32RA_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32RA_HH_S2_args,
    1, Iclass_AE_MULAF32RA_HH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32R_HH_S2_args,
    1, Iclass_AE_MULAF32R_HH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSS32F48P16S_LL_args,
    2, Iclass_AE_MULSS32F48P16S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32S_LL_args,
    2, Iclass_AE_MULSF32S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32_LL_args,
    1, Iclass_AE_MULS32_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32S_LL_S2_args,
    2, Iclass_AE_MULSF32S_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32_LL_S2_args,
    1, Iclass_AE_MULS32_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSS32F48P16S_LL_S2_args,
    2, Iclass_AE_MULSS32F48P16S_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32R_LL_args,
    1, Iclass_AE_MULSF32R_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32RA_LL_args,
    1, Iclass_AE_MULSF32RA_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32RA_LL_S2_args,
    1, Iclass_AE_MULSF32RA_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32R_LL_S2_args,
    1, Iclass_AE_MULSF32R_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSS32F48P16S_LH_args,
    2, Iclass_AE_MULSS32F48P16S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32S_LH_args,
    2, Iclass_AE_MULSF32S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32_LH_args,
    1, Iclass_AE_MULS32_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32S_LH_S2_args,
    2, Iclass_AE_MULSF32S_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32_LH_S2_args,
    1, Iclass_AE_MULS32_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSS32F48P16S_LH_S2_args,
    2, Iclass_AE_MULSS32F48P16S_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32R_LH_args,
    1, Iclass_AE_MULSF32R_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32RA_LH_args,
    1, Iclass_AE_MULSF32RA_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32RA_LH_S2_args,
    1, Iclass_AE_MULSF32RA_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32R_LH_S2_args,
    1, Iclass_AE_MULSF32R_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSS32F48P16S_HH_args,
    2, Iclass_AE_MULSS32F48P16S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32S_HH_args,
    2, Iclass_AE_MULSF32S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32_HH_args,
    1, Iclass_AE_MULS32_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32S_HH_S2_args,
    2, Iclass_AE_MULSF32S_HH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32_HH_S2_args,
    1, Iclass_AE_MULS32_HH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSS32F48P16S_HH_S2_args,
    2, Iclass_AE_MULSS32F48P16S_HH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32R_HH_args,
    1, Iclass_AE_MULSF32R_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32RA_HH_args,
    1, Iclass_AE_MULSF32RA_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32RA_HH_S2_args,
    1, Iclass_AE_MULSF32RA_HH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32R_HH_S2_args,
    1, Iclass_AE_MULSF32R_HH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32U_LL_args,
    1, Iclass_AE_MUL32U_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32U_LL_args,
    1, Iclass_AE_MULA32U_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32U_LL_args,
    1, Iclass_AE_MULS32U_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_33_args,
    2, Iclass_AE_MULF16SS_33_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_33_S2_args,
    2, Iclass_AE_MULF16SS_33_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_22_args,
    2, Iclass_AE_MULF16SS_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_22_S2_args,
    2, Iclass_AE_MULF16SS_22_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_32_args,
    2, Iclass_AE_MULF16SS_32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_32_S2_args,
    2, Iclass_AE_MULF16SS_32_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_21_args,
    2, Iclass_AE_MULF16SS_21_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_21_S2_args,
    2, Iclass_AE_MULF16SS_21_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_31_args,
    2, Iclass_AE_MULF16SS_31_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_31_S2_args,
    2, Iclass_AE_MULF16SS_31_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_30_args,
    2, Iclass_AE_MULF16SS_30_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_30_S2_args,
    2, Iclass_AE_MULF16SS_30_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_10_args,
    2, Iclass_AE_MULF16SS_10_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_10_S2_args,
    2, Iclass_AE_MULF16SS_10_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_20_args,
    2, Iclass_AE_MULF16SS_20_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_20_S2_args,
    2, Iclass_AE_MULF16SS_20_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_11_args,
    2, Iclass_AE_MULF16SS_11_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_11_S2_args,
    2, Iclass_AE_MULF16SS_11_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_00_args,
    2, Iclass_AE_MULF16SS_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_00_S2_args,
    2, Iclass_AE_MULF16SS_00_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_33_args,
    2, Iclass_AE_MULSF16SS_33_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_33_S2_args,
    2, Iclass_AE_MULSF16SS_33_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_22_args,
    2, Iclass_AE_MULSF16SS_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_22_S2_args,
    2, Iclass_AE_MULSF16SS_22_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_32_args,
    2, Iclass_AE_MULSF16SS_32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_32_S2_args,
    2, Iclass_AE_MULSF16SS_32_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_21_args,
    2, Iclass_AE_MULSF16SS_21_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_21_S2_args,
    2, Iclass_AE_MULSF16SS_21_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_31_args,
    2, Iclass_AE_MULSF16SS_31_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_31_S2_args,
    2, Iclass_AE_MULSF16SS_31_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_30_args,
    2, Iclass_AE_MULSF16SS_30_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_30_S2_args,
    2, Iclass_AE_MULSF16SS_30_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_10_args,
    2, Iclass_AE_MULSF16SS_10_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_10_S2_args,
    2, Iclass_AE_MULSF16SS_10_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_20_args,
    2, Iclass_AE_MULSF16SS_20_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_20_S2_args,
    2, Iclass_AE_MULSF16SS_20_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_11_args,
    2, Iclass_AE_MULSF16SS_11_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_11_S2_args,
    2, Iclass_AE_MULSF16SS_11_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_00_args,
    2, Iclass_AE_MULSF16SS_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_00_S2_args,
    2, Iclass_AE_MULSF16SS_00_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_33_args,
    2, Iclass_AE_MULAF16SS_33_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_33_S2_args,
    2, Iclass_AE_MULAF16SS_33_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_22_args,
    2, Iclass_AE_MULAF16SS_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_22_S2_args,
    2, Iclass_AE_MULAF16SS_22_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_32_args,
    2, Iclass_AE_MULAF16SS_32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_32_S2_args,
    2, Iclass_AE_MULAF16SS_32_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_21_args,
    2, Iclass_AE_MULAF16SS_21_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_21_S2_args,
    2, Iclass_AE_MULAF16SS_21_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_31_args,
    2, Iclass_AE_MULAF16SS_31_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_31_S2_args,
    2, Iclass_AE_MULAF16SS_31_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_30_args,
    2, Iclass_AE_MULAF16SS_30_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_30_S2_args,
    2, Iclass_AE_MULAF16SS_30_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_10_args,
    2, Iclass_AE_MULAF16SS_10_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_10_S2_args,
    2, Iclass_AE_MULAF16SS_10_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_20_args,
    2, Iclass_AE_MULAF16SS_20_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_20_S2_args,
    2, Iclass_AE_MULAF16SS_20_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_11_args,
    2, Iclass_AE_MULAF16SS_11_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_11_S2_args,
    2, Iclass_AE_MULAF16SS_11_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_00_args,
    2, Iclass_AE_MULAF16SS_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_00_S2_args,
    2, Iclass_AE_MULAF16SS_00_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD16SS_33_22_args,
    2, Iclass_AE_MULAAFD16SS_33_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD16SS_33_22_S2_args,
    2, Iclass_AE_MULAAFD16SS_33_22_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD16SS_13_02_args,
    2, Iclass_AE_MULAAFD16SS_13_02_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD16SS_13_02_S2_args,
    2, Iclass_AE_MULAAFD16SS_13_02_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD16SS_11_00_args,
    2, Iclass_AE_MULAAFD16SS_11_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD16SS_11_00_S2_args,
    2, Iclass_AE_MULAAFD16SS_11_00_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD16SS_33_22_args,
    2, Iclass_AE_MULSSFD16SS_33_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD16SS_33_22_S2_args,
    2, Iclass_AE_MULSSFD16SS_33_22_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD16SS_13_02_args,
    2, Iclass_AE_MULSSFD16SS_13_02_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD16SS_13_02_S2_args,
    2, Iclass_AE_MULSSFD16SS_13_02_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD16SS_11_00_args,
    2, Iclass_AE_MULSSFD16SS_11_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD16SS_11_00_S2_args,
    2, Iclass_AE_MULSSFD16SS_11_00_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD16SS_33_22_args,
    2, Iclass_AE_MULZAAFD16SS_33_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD16SS_33_22_S2_args,
    2, Iclass_AE_MULZAAFD16SS_33_22_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD16SS_13_02_args,
    2, Iclass_AE_MULZAAFD16SS_13_02_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD16SS_13_02_S2_args,
    2, Iclass_AE_MULZAAFD16SS_13_02_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD16SS_11_00_args,
    2, Iclass_AE_MULZAAFD16SS_11_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD16SS_11_00_S2_args,
    2, Iclass_AE_MULZAAFD16SS_11_00_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD16SS_33_22_args,
    2, Iclass_AE_MULZSSFD16SS_33_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD16SS_33_22_S2_args,
    2, Iclass_AE_MULZSSFD16SS_33_22_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD16SS_13_02_args,
    2, Iclass_AE_MULZSSFD16SS_13_02_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD16SS_13_02_S2_args,
    2, Iclass_AE_MULZSSFD16SS_13_02_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD16SS_11_00_args,
    2, Iclass_AE_MULZSSFD16SS_11_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD16SS_11_00_S2_args,
    2, Iclass_AE_MULZSSFD16SS_11_00_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF48Q32SP16S_L_args,
    1, Iclass_AE_MULF48Q32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF48Q32SP16S_L_S2_args,
    1, Iclass_AE_MULF48Q32SP16S_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF48Q32SP16U_L_args,
    1, Iclass_AE_MULF48Q32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF48Q32SP16U_L_S2_args,
    1, Iclass_AE_MULF48Q32SP16U_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULQ32SP16S_L_args,
    1, Iclass_AE_MULQ32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULQ32SP16S_L_S2_args,
    1, Iclass_AE_MULQ32SP16S_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULQ32SP16U_L_args,
    1, Iclass_AE_MULQ32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULQ32SP16U_L_S2_args,
    1, Iclass_AE_MULQ32SP16U_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF48Q32SP16S_L_args,
    1, Iclass_AE_MULAF48Q32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF48Q32SP16S_L_S2_args,
    1, Iclass_AE_MULAF48Q32SP16S_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF48Q32SP16U_L_args,
    1, Iclass_AE_MULAF48Q32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF48Q32SP16U_L_S2_args,
    1, Iclass_AE_MULAF48Q32SP16U_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAQ32SP16S_L_args,
    1, Iclass_AE_MULAQ32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAQ32SP16S_L_S2_args,
    1, Iclass_AE_MULAQ32SP16S_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAQ32SP16U_L_args,
    1, Iclass_AE_MULAQ32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAQ32SP16U_L_S2_args,
    1, Iclass_AE_MULAQ32SP16U_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF48Q32SP16S_L_args,
    1, Iclass_AE_MULSF48Q32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF48Q32SP16S_L_S2_args,
    1, Iclass_AE_MULSF48Q32SP16S_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF48Q32SP16U_L_args,
    1, Iclass_AE_MULSF48Q32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF48Q32SP16U_L_S2_args,
    1, Iclass_AE_MULSF48Q32SP16U_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSQ32SP16S_L_args,
    1, Iclass_AE_MULSQ32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSQ32SP16S_L_S2_args,
    1, Iclass_AE_MULSQ32SP16S_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSQ32SP16U_L_args,
    1, Iclass_AE_MULSQ32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSQ32SP16U_L_S2_args,
    1, Iclass_AE_MULSQ32SP16U_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP24X2RA_args,
    1, Iclass_AE_MULFP24X2RA_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP24X2R_args,
    1, Iclass_AE_MULFP24X2R_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP24X2RA_S2_args,
    1, Iclass_AE_MULFP24X2RA_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP24X2R_S2_args,
    1, Iclass_AE_MULFP24X2R_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP24X2RA_args,
    1, Iclass_AE_MULAFP24X2RA_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP24X2R_args,
    1, Iclass_AE_MULAFP24X2R_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP24X2RA_S2_args,
    1, Iclass_AE_MULAFP24X2RA_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP24X2R_S2_args,
    1, Iclass_AE_MULAFP24X2R_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP24X2RA_args,
    1, Iclass_AE_MULSFP24X2RA_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP24X2R_args,
    1, Iclass_AE_MULSFP24X2R_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP24X2RA_S2_args,
    1, Iclass_AE_MULSFP24X2RA_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP24X2R_S2_args,
    1, Iclass_AE_MULSFP24X2R_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32S_HH_LL_args,
    2, Iclass_AE_MULZAAFD32S_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32RA_HH_LL_args,
    1, Iclass_AE_MULZAAFD32RA_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32_HH_LL_args,
    1, Iclass_AE_MULZAAD32_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32S_HH_LL_S2_args,
    2, Iclass_AE_MULZAAFD32S_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32RA_HH_LL_S2_args,
    1, Iclass_AE_MULZAAFD32RA_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32_HH_LL_S2_args,
    1, Iclass_AE_MULZAAD32_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32S_HL_LH_args,
    2, Iclass_AE_MULZAAFD32S_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32RA_HL_LH_args,
    1, Iclass_AE_MULZAAFD32RA_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32_HL_LH_args,
    1, Iclass_AE_MULZAAD32_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32S_HL_LH_S2_args,
    2, Iclass_AE_MULZAAFD32S_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32RA_HL_LH_S2_args,
    1, Iclass_AE_MULZAAFD32RA_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32_HL_LH_S2_args,
    1, Iclass_AE_MULZAAD32_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD32S_HH_LL_args,
    2, Iclass_AE_MULZASFD32S_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD32RA_HH_LL_args,
    1, Iclass_AE_MULZASFD32RA_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASD32_HH_LL_args,
    1, Iclass_AE_MULZASD32_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD32S_HH_LL_S2_args,
    2, Iclass_AE_MULZASFD32S_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD32RA_HH_LL_S2_args,
    1, Iclass_AE_MULZASFD32RA_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASD32_HH_LL_S2_args,
    1, Iclass_AE_MULZASD32_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD32S_HL_LH_args,
    2, Iclass_AE_MULZASFD32S_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD32RA_HL_LH_args,
    1, Iclass_AE_MULZASFD32RA_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASD32_HL_LH_args,
    1, Iclass_AE_MULZASD32_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD32S_HL_LH_S2_args,
    2, Iclass_AE_MULZASFD32S_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD32RA_HL_LH_S2_args,
    1, Iclass_AE_MULZASFD32RA_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASD32_HL_LH_S2_args,
    1, Iclass_AE_MULZASD32_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAFD32S_HH_LL_args,
    2, Iclass_AE_MULZSAFD32S_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAFD32RA_HH_LL_args,
    1, Iclass_AE_MULZSAFD32RA_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAD32_HH_LL_args,
    1, Iclass_AE_MULZSAD32_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAFD32S_HH_LL_S2_args,
    2, Iclass_AE_MULZSAFD32S_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAFD32RA_HH_LL_S2_args,
    1, Iclass_AE_MULZSAFD32RA_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAD32_HH_LL_S2_args,
    1, Iclass_AE_MULZSAD32_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD32S_HH_LL_args,
    2, Iclass_AE_MULZSSFD32S_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD32RA_HH_LL_args,
    1, Iclass_AE_MULZSSFD32RA_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSD32_HH_LL_args,
    1, Iclass_AE_MULZSSD32_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD32S_HH_LL_S2_args,
    2, Iclass_AE_MULZSSFD32S_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD32RA_HH_LL_S2_args,
    1, Iclass_AE_MULZSSFD32RA_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSD32_HH_LL_S2_args,
    1, Iclass_AE_MULZSSD32_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD32S_HL_LH_args,
    2, Iclass_AE_MULZSSFD32S_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD32RA_HL_LH_args,
    1, Iclass_AE_MULZSSFD32RA_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSD32_HL_LH_args,
    1, Iclass_AE_MULZSSD32_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD32S_HL_LH_S2_args,
    2, Iclass_AE_MULZSSFD32S_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD32RA_HL_LH_S2_args,
    1, Iclass_AE_MULZSSFD32RA_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSD32_HL_LH_S2_args,
    1, Iclass_AE_MULZSSD32_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32S_HH_LL_args,
    2, Iclass_AE_MULAAFD32S_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32RA_HH_LL_args,
    1, Iclass_AE_MULAAFD32RA_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32_HH_LL_args,
    1, Iclass_AE_MULAAD32_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32S_HH_LL_S2_args,
    2, Iclass_AE_MULAAFD32S_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32RA_HH_LL_S2_args,
    1, Iclass_AE_MULAAFD32RA_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32_HH_LL_S2_args,
    1, Iclass_AE_MULAAD32_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32S_HL_LH_args,
    2, Iclass_AE_MULAAFD32S_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32RA_HL_LH_args,
    1, Iclass_AE_MULAAFD32RA_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32_HL_LH_args,
    1, Iclass_AE_MULAAD32_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32S_HL_LH_S2_args,
    2, Iclass_AE_MULAAFD32S_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32RA_HL_LH_S2_args,
    1, Iclass_AE_MULAAFD32RA_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32_HL_LH_S2_args,
    1, Iclass_AE_MULAAD32_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD32S_HH_LL_args,
    2, Iclass_AE_MULASFD32S_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD32RA_HH_LL_args,
    1, Iclass_AE_MULASFD32RA_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASD32_HH_LL_args,
    1, Iclass_AE_MULASD32_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD32S_HH_LL_S2_args,
    2, Iclass_AE_MULASFD32S_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD32RA_HH_LL_S2_args,
    1, Iclass_AE_MULASFD32RA_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASD32_HH_LL_S2_args,
    1, Iclass_AE_MULASD32_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD32S_HL_LH_args,
    2, Iclass_AE_MULASFD32S_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD32RA_HL_LH_args,
    1, Iclass_AE_MULASFD32RA_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASD32_HL_LH_args,
    1, Iclass_AE_MULASD32_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD32S_HL_LH_S2_args,
    2, Iclass_AE_MULASFD32S_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD32RA_HL_LH_S2_args,
    1, Iclass_AE_MULASFD32RA_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASD32_HL_LH_S2_args,
    1, Iclass_AE_MULASD32_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAFD32S_HH_LL_args,
    2, Iclass_AE_MULSAFD32S_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAFD32RA_HH_LL_args,
    1, Iclass_AE_MULSAFD32RA_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAD32_HH_LL_args,
    1, Iclass_AE_MULSAD32_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAFD32S_HH_LL_S2_args,
    2, Iclass_AE_MULSAFD32S_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAFD32RA_HH_LL_S2_args,
    1, Iclass_AE_MULSAFD32RA_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAD32_HH_LL_S2_args,
    1, Iclass_AE_MULSAD32_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD32S_HH_LL_args,
    2, Iclass_AE_MULSSFD32S_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD32RA_HH_LL_args,
    1, Iclass_AE_MULSSFD32RA_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSD32_HH_LL_args,
    1, Iclass_AE_MULSSD32_HH_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD32S_HH_LL_S2_args,
    2, Iclass_AE_MULSSFD32S_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD32RA_HH_LL_S2_args,
    1, Iclass_AE_MULSSFD32RA_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSD32_HH_LL_S2_args,
    1, Iclass_AE_MULSSD32_HH_LL_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD32S_HL_LH_args,
    2, Iclass_AE_MULSSFD32S_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD32RA_HL_LH_args,
    1, Iclass_AE_MULSSFD32RA_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSD32_HL_LH_args,
    1, Iclass_AE_MULSSD32_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD32S_HL_LH_S2_args,
    2, Iclass_AE_MULSSFD32S_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD32RA_HL_LH_S2_args,
    1, Iclass_AE_MULSSFD32RA_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSD32_HL_LH_S2_args,
    1, Iclass_AE_MULSSD32_HL_LH_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L0_args,
    1, Iclass_AE_MULF32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L0_args,
    1, Iclass_AE_MUL32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L0_S2_args,
    1, Iclass_AE_MULF32X16_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L0_S2_args,
    1, Iclass_AE_MUL32X16_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L1_args,
    1, Iclass_AE_MULF32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L1_args,
    1, Iclass_AE_MUL32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L1_S2_args,
    1, Iclass_AE_MULF32X16_L1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L1_S2_args,
    1, Iclass_AE_MUL32X16_L1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L2_args,
    1, Iclass_AE_MULF32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L2_args,
    1, Iclass_AE_MUL32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L2_S2_args,
    1, Iclass_AE_MULF32X16_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L2_S2_args,
    1, Iclass_AE_MUL32X16_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L3_args,
    1, Iclass_AE_MULF32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L3_args,
    1, Iclass_AE_MUL32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L3_S2_args,
    1, Iclass_AE_MULF32X16_L3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L3_S2_args,
    1, Iclass_AE_MUL32X16_L3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H0_args,
    1, Iclass_AE_MULF32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H0_args,
    1, Iclass_AE_MUL32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H0_S2_args,
    1, Iclass_AE_MULF32X16_H0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H0_S2_args,
    1, Iclass_AE_MUL32X16_H0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H1_args,
    1, Iclass_AE_MULF32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H1_args,
    1, Iclass_AE_MUL32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H1_S2_args,
    1, Iclass_AE_MULF32X16_H1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H1_S2_args,
    1, Iclass_AE_MUL32X16_H1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H2_args,
    1, Iclass_AE_MULF32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H2_args,
    1, Iclass_AE_MUL32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H2_S2_args,
    1, Iclass_AE_MULF32X16_H2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H2_S2_args,
    1, Iclass_AE_MUL32X16_H2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H3_args,
    1, Iclass_AE_MULF32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H3_args,
    1, Iclass_AE_MUL32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H3_S2_args,
    1, Iclass_AE_MULF32X16_H3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H3_S2_args,
    1, Iclass_AE_MUL32X16_H3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L0_args,
    1, Iclass_AE_MULAF32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L0_args,
    1, Iclass_AE_MULA32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L0_S2_args,
    1, Iclass_AE_MULAF32X16_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L0_S2_args,
    1, Iclass_AE_MULA32X16_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L1_args,
    1, Iclass_AE_MULAF32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L1_args,
    1, Iclass_AE_MULA32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L1_S2_args,
    1, Iclass_AE_MULAF32X16_L1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L1_S2_args,
    1, Iclass_AE_MULA32X16_L1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L2_args,
    1, Iclass_AE_MULAF32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L2_args,
    1, Iclass_AE_MULA32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L2_S2_args,
    1, Iclass_AE_MULAF32X16_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L2_S2_args,
    1, Iclass_AE_MULA32X16_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L3_args,
    1, Iclass_AE_MULAF32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L3_args,
    1, Iclass_AE_MULA32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L3_S2_args,
    1, Iclass_AE_MULAF32X16_L3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L3_S2_args,
    1, Iclass_AE_MULA32X16_L3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H0_args,
    1, Iclass_AE_MULAF32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H0_args,
    1, Iclass_AE_MULA32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H0_S2_args,
    1, Iclass_AE_MULAF32X16_H0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H0_S2_args,
    1, Iclass_AE_MULA32X16_H0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H1_args,
    1, Iclass_AE_MULAF32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H1_args,
    1, Iclass_AE_MULA32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H1_S2_args,
    1, Iclass_AE_MULAF32X16_H1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H1_S2_args,
    1, Iclass_AE_MULA32X16_H1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H2_args,
    1, Iclass_AE_MULAF32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H2_args,
    1, Iclass_AE_MULA32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H2_S2_args,
    1, Iclass_AE_MULAF32X16_H2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H2_S2_args,
    1, Iclass_AE_MULA32X16_H2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H3_args,
    1, Iclass_AE_MULAF32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H3_args,
    1, Iclass_AE_MULA32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H3_S2_args,
    1, Iclass_AE_MULAF32X16_H3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H3_S2_args,
    1, Iclass_AE_MULA32X16_H3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L0_args,
    1, Iclass_AE_MULSF32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L0_args,
    1, Iclass_AE_MULS32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L0_S2_args,
    1, Iclass_AE_MULSF32X16_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L0_S2_args,
    1, Iclass_AE_MULS32X16_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L1_args,
    1, Iclass_AE_MULSF32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L1_args,
    1, Iclass_AE_MULS32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L1_S2_args,
    1, Iclass_AE_MULSF32X16_L1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L1_S2_args,
    1, Iclass_AE_MULS32X16_L1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L2_args,
    1, Iclass_AE_MULSF32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L2_args,
    1, Iclass_AE_MULS32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L2_S2_args,
    1, Iclass_AE_MULSF32X16_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L2_S2_args,
    1, Iclass_AE_MULS32X16_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L3_args,
    1, Iclass_AE_MULSF32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L3_args,
    1, Iclass_AE_MULS32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L3_S2_args,
    1, Iclass_AE_MULSF32X16_L3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L3_S2_args,
    1, Iclass_AE_MULS32X16_L3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H0_args,
    1, Iclass_AE_MULSF32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H0_args,
    1, Iclass_AE_MULS32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H0_S2_args,
    1, Iclass_AE_MULSF32X16_H0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H0_S2_args,
    1, Iclass_AE_MULS32X16_H0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H1_args,
    1, Iclass_AE_MULSF32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H1_args,
    1, Iclass_AE_MULS32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H1_S2_args,
    1, Iclass_AE_MULSF32X16_H1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H1_S2_args,
    1, Iclass_AE_MULS32X16_H1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H2_args,
    1, Iclass_AE_MULSF32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H2_args,
    1, Iclass_AE_MULS32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H2_S2_args,
    1, Iclass_AE_MULSF32X16_H2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H2_S2_args,
    1, Iclass_AE_MULS32X16_H2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H3_args,
    1, Iclass_AE_MULSF32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H3_args,
    1, Iclass_AE_MULS32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H3_S2_args,
    1, Iclass_AE_MULSF32X16_H3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H3_S2_args,
    1, Iclass_AE_MULS32X16_H3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H3_L2_args,
    1, Iclass_AE_MULAAFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H3_L2_args,
    1, Iclass_AE_MULAAD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULAAFD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULAAD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H1_L0_args,
    1, Iclass_AE_MULAAFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H1_L0_args,
    1, Iclass_AE_MULAAD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULAAFD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULAAD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD32X16_H3_L2_args,
    1, Iclass_AE_MULASFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASD32X16_H3_L2_args,
    1, Iclass_AE_MULASD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULASFD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULASD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD32X16_H1_L0_args,
    1, Iclass_AE_MULASFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASD32X16_H1_L0_args,
    1, Iclass_AE_MULASD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULASFD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULASD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAFD32X16_H3_L2_args,
    1, Iclass_AE_MULSAFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAD32X16_H3_L2_args,
    1, Iclass_AE_MULSAD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAFD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULSAFD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULSAD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAFD32X16_H1_L0_args,
    1, Iclass_AE_MULSAFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAD32X16_H1_L0_args,
    1, Iclass_AE_MULSAD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAFD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULSAFD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULSAD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD32X16_H3_L2_args,
    1, Iclass_AE_MULSSFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSD32X16_H3_L2_args,
    1, Iclass_AE_MULSSD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULSSFD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULSSD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD32X16_H1_L0_args,
    1, Iclass_AE_MULSSFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSD32X16_H1_L0_args,
    1, Iclass_AE_MULSSD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULSSFD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULSSD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H3_L2_args,
    1, Iclass_AE_MULZAAFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H3_L2_args,
    1, Iclass_AE_MULZAAD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULZAAFD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULZAAD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H1_L0_args,
    1, Iclass_AE_MULZAAFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H1_L0_args,
    1, Iclass_AE_MULZAAD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULZAAFD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULZAAD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD32X16_H3_L2_args,
    1, Iclass_AE_MULZASFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASD32X16_H3_L2_args,
    1, Iclass_AE_MULZASD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULZASFD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULZASD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD32X16_H1_L0_args,
    1, Iclass_AE_MULZASFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASD32X16_H1_L0_args,
    1, Iclass_AE_MULZASD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULZASFD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULZASD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAFD32X16_H3_L2_args,
    1, Iclass_AE_MULZSAFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAD32X16_H3_L2_args,
    1, Iclass_AE_MULZSAD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAFD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULZSAFD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULZSAD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAFD32X16_H1_L0_args,
    1, Iclass_AE_MULZSAFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAD32X16_H1_L0_args,
    1, Iclass_AE_MULZSAD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAFD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULZSAFD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULZSAD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD32X16_H3_L2_args,
    1, Iclass_AE_MULZSSFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSD32X16_H3_L2_args,
    1, Iclass_AE_MULZSSD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULZSSFD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSD32X16_H3_L2_S2_args,
    1, Iclass_AE_MULZSSD32X16_H3_L2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD32X16_H1_L0_args,
    1, Iclass_AE_MULZSSFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSD32X16_H1_L0_args,
    1, Iclass_AE_MULZSSD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULZSSFD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSD32X16_H1_L0_S2_args,
    1, Iclass_AE_MULZSSD32X16_H1_L0_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H2_L3_args,
    1, Iclass_AE_MULZAAFD32X16_H2_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H0_L1_args,
    1, Iclass_AE_MULZAAFD32X16_H0_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H2_L3_args,
    1, Iclass_AE_MULAAFD32X16_H2_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H0_L1_args,
    1, Iclass_AE_MULAAFD32X16_H0_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H2_L3_args,
    1, Iclass_AE_MULZAAD32X16_H2_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H0_L1_args,
    1, Iclass_AE_MULZAAD32X16_H0_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H2_L3_args,
    1, Iclass_AE_MULAAD32X16_H2_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H0_L1_args,
    1, Iclass_AE_MULAAD32X16_H0_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H2_L3_S2_args,
    1, Iclass_AE_MULZAAFD32X16_H2_L3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H0_L1_S2_args,
    1, Iclass_AE_MULZAAFD32X16_H0_L1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H2_L3_S2_args,
    1, Iclass_AE_MULAAFD32X16_H2_L3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H0_L1_S2_args,
    1, Iclass_AE_MULAAFD32X16_H0_L1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H2_L3_S2_args,
    1, Iclass_AE_MULZAAD32X16_H2_L3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H0_L1_S2_args,
    1, Iclass_AE_MULZAAD32X16_H0_L1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H2_L3_S2_args,
    1, Iclass_AE_MULAAD32X16_H2_L3_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H0_L1_S2_args,
    1, Iclass_AE_MULAAD32X16_H0_L1_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULP32X16X2_H_args,
    1, Iclass_AE_MULP32X16X2_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RS_H_args,
    2, Iclass_AE_MULFP32X16X2RS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RAS_H_args,
    2, Iclass_AE_MULFP32X16X2RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2S_H_args,
    2, Iclass_AE_MULFP32X16X2S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2S_H_S2_args,
    2, Iclass_AE_MULFP32X16X2S_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULP32X16X2_H_S2_args,
    1, Iclass_AE_MULP32X16X2_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RS_H_S2_args,
    2, Iclass_AE_MULFP32X16X2RS_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RAS_H_S2_args,
    2, Iclass_AE_MULFP32X16X2RAS_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULP32X16X2_L_args,
    1, Iclass_AE_MULP32X16X2_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RS_L_args,
    2, Iclass_AE_MULFP32X16X2RS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RAS_L_args,
    2, Iclass_AE_MULFP32X16X2RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2S_L_args,
    2, Iclass_AE_MULFP32X16X2S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2S_L_S2_args,
    2, Iclass_AE_MULFP32X16X2S_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULP32X16X2_L_S2_args,
    1, Iclass_AE_MULP32X16X2_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RS_L_S2_args,
    2, Iclass_AE_MULFP32X16X2RS_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RAS_L_S2_args,
    2, Iclass_AE_MULFP32X16X2RAS_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAP32X16X2_H_args,
    1, Iclass_AE_MULAP32X16X2_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RS_H_args,
    2, Iclass_AE_MULAFP32X16X2RS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RAS_H_args,
    2, Iclass_AE_MULAFP32X16X2RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2S_H_args,
    2, Iclass_AE_MULAFP32X16X2S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2S_H_S2_args,
    2, Iclass_AE_MULAFP32X16X2S_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAP32X16X2_H_S2_args,
    1, Iclass_AE_MULAP32X16X2_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RS_H_S2_args,
    2, Iclass_AE_MULAFP32X16X2RS_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RAS_H_S2_args,
    2, Iclass_AE_MULAFP32X16X2RAS_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAP32X16X2_L_args,
    1, Iclass_AE_MULAP32X16X2_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RS_L_args,
    2, Iclass_AE_MULAFP32X16X2RS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RAS_L_args,
    2, Iclass_AE_MULAFP32X16X2RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2S_L_args,
    2, Iclass_AE_MULAFP32X16X2S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2S_L_S2_args,
    2, Iclass_AE_MULAFP32X16X2S_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAP32X16X2_L_S2_args,
    1, Iclass_AE_MULAP32X16X2_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RS_L_S2_args,
    2, Iclass_AE_MULAFP32X16X2RS_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RAS_L_S2_args,
    2, Iclass_AE_MULAFP32X16X2RAS_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSP32X16X2_H_args,
    1, Iclass_AE_MULSP32X16X2_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RS_H_args,
    2, Iclass_AE_MULSFP32X16X2RS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RAS_H_args,
    2, Iclass_AE_MULSFP32X16X2RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2S_H_args,
    2, Iclass_AE_MULSFP32X16X2S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2S_H_S2_args,
    2, Iclass_AE_MULSFP32X16X2S_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSP32X16X2_H_S2_args,
    1, Iclass_AE_MULSP32X16X2_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RS_H_S2_args,
    2, Iclass_AE_MULSFP32X16X2RS_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RAS_H_S2_args,
    2, Iclass_AE_MULSFP32X16X2RAS_H_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSP32X16X2_L_args,
    1, Iclass_AE_MULSP32X16X2_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RS_L_args,
    2, Iclass_AE_MULSFP32X16X2RS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RAS_L_args,
    2, Iclass_AE_MULSFP32X16X2RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2S_L_args,
    2, Iclass_AE_MULSFP32X16X2S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2S_L_S2_args,
    2, Iclass_AE_MULSFP32X16X2S_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSP32X16X2_L_S2_args,
    1, Iclass_AE_MULSP32X16X2_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RS_L_S2_args,
    2, Iclass_AE_MULSFP32X16X2RS_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RAS_L_S2_args,
    2, Iclass_AE_MULSFP32X16X2RAS_L_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULP32X2_args,
    1, Iclass_AE_MULP32X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X2RS_args,
    2, Iclass_AE_MULFP32X2RS_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X2RAS_args,
    2, Iclass_AE_MULFP32X2RAS_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULP32X2_S2_args,
    1, Iclass_AE_MULP32X2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X2RS_S2_args,
    2, Iclass_AE_MULFP32X2RS_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X2RAS_S2_args,
    2, Iclass_AE_MULFP32X2RAS_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAP32X2_args,
    1, Iclass_AE_MULAP32X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X2RS_args,
    2, Iclass_AE_MULAFP32X2RS_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X2RAS_args,
    2, Iclass_AE_MULAFP32X2RAS_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAP32X2_S2_args,
    1, Iclass_AE_MULAP32X2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X2RS_S2_args,
    2, Iclass_AE_MULAFP32X2RS_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X2RAS_S2_args,
    2, Iclass_AE_MULAFP32X2RAS_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSP32X2_args,
    1, Iclass_AE_MULSP32X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X2RS_args,
    2, Iclass_AE_MULSFP32X2RS_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X2RAS_args,
    2, Iclass_AE_MULSFP32X2RAS_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSP32X2_S2_args,
    1, Iclass_AE_MULSP32X2_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X2RS_S2_args,
    2, Iclass_AE_MULSFP32X2RS_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X2RAS_S2_args,
    2, Iclass_AE_MULSFP32X2RAS_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP16X4S_args,
    2, Iclass_AE_MULFP16X4S_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP16X4RAS_args,
    2, Iclass_AE_MULFP16X4RAS_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULC32_args,
    1, Iclass_AE_MULC32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFC24RA_args,
    1, Iclass_AE_MULFC24RA_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFC32RAS_args,
    2, Iclass_AE_MULFC32RAS_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULC32X16_L_args,
    1, Iclass_AE_MULC32X16_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFC32X16RAS_L_args,
    2, Iclass_AE_MULFC32X16RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULC32X16_H_args,
    1, Iclass_AE_MULC32X16_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFC32X16RAS_H_args,
    2, Iclass_AE_MULFC32X16RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAC32_args,
    1, Iclass_AE_MULAC32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFC24RA_args,
    1, Iclass_AE_MULAFC24RA_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFC32RAS_args,
    2, Iclass_AE_MULAFC32RAS_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAC32X16_L_args,
    1, Iclass_AE_MULAC32X16_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFC32X16RAS_L_args,
    2, Iclass_AE_MULAFC32X16RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAC32X16_H_args,
    1, Iclass_AE_MULAC32X16_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFC32X16RAS_H_args,
    2, Iclass_AE_MULAFC32X16RAS_H_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULF16X4SS_args,
    2, Iclass_AE_MULF16X4SS_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULAF16X4SS_args,
    2, Iclass_AE_MULAF16X4SS_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULSF16X4SS_args,
    2, Iclass_AE_MULSF16X4SS_stateArgs, 0, 0 },
  { 4, Iclass_AE_MUL16X4_args,
    1, Iclass_AE_MUL16X4_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULA16X4_args,
    1, Iclass_AE_MULA16X4_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULS16X4_args,
    1, Iclass_AE_MULS16X4_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULFD32X2S_FIR_H_args,
    2, Iclass_AE_MULFD32X2S_FIR_H_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULFD32X2RA_FIR_H_args,
    1, Iclass_AE_MULFD32X2RA_FIR_H_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULFD32X2S_FIR_L_args,
    2, Iclass_AE_MULFD32X2S_FIR_L_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULFD32X2RA_FIR_L_args,
    1, Iclass_AE_MULFD32X2RA_FIR_L_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULFD32X16X2_FIR_HH_args,
    1, Iclass_AE_MULFD32X16X2_FIR_HH_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULFD32X16X2_FIR_HL_args,
    1, Iclass_AE_MULFD32X16X2_FIR_HL_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULFD32X16X2_FIR_LH_args,
    1, Iclass_AE_MULFD32X16X2_FIR_LH_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULFD32X16X2_FIR_LL_args,
    1, Iclass_AE_MULFD32X16X2_FIR_LL_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULAFD32X2S_FIR_H_args,
    2, Iclass_AE_MULAFD32X2S_FIR_H_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULAFD32X2RA_FIR_H_args,
    1, Iclass_AE_MULAFD32X2RA_FIR_H_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULAFD32X2S_FIR_L_args,
    2, Iclass_AE_MULAFD32X2S_FIR_L_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULAFD32X2RA_FIR_L_args,
    1, Iclass_AE_MULAFD32X2RA_FIR_L_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULAFD32X16X2_FIR_HH_args,
    1, Iclass_AE_MULAFD32X16X2_FIR_HH_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULAFD32X16X2_FIR_HL_args,
    1, Iclass_AE_MULAFD32X16X2_FIR_HL_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULAFD32X16X2_FIR_LH_args,
    1, Iclass_AE_MULAFD32X16X2_FIR_LH_stateArgs, 0, 0 },
  { 5, Iclass_AE_MULAFD32X16X2_FIR_LL_args,
    1, Iclass_AE_MULAFD32X16X2_FIR_LL_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULZAAAAFQ32X16_args,
    1, Iclass_AE_MULZAAAAFQ32X16_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULAAAAFQ32X16_args,
    1, Iclass_AE_MULAAAAFQ32X16_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULZAAAAFQ32X16_S2_args,
    1, Iclass_AE_MULZAAAAFQ32X16_S2_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULAAAAFQ32X16_S2_args,
    1, Iclass_AE_MULAAAAFQ32X16_S2_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULZAAAAQ32X16_args,
    1, Iclass_AE_MULZAAAAQ32X16_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULAAAAQ32X16_args,
    1, Iclass_AE_MULAAAAQ32X16_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULZAAAAQ32X16_S2_args,
    1, Iclass_AE_MULZAAAAQ32X16_S2_stateArgs, 0, 0 },
  { 4, Iclass_AE_MULAAAAQ32X16_S2_args,
    1, Iclass_AE_MULAAAAQ32X16_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL16_00_args,
    1, Iclass_AE_MUL16_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA16_00_args,
    1, Iclass_AE_MULA16_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL16_00_S2_args,
    1, Iclass_AE_MUL16_00_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA16_00_S2_args,
    1, Iclass_AE_MULA16_00_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAAAQ16_args,
    1, Iclass_AE_MULZAAAAQ16_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAAAQ16_args,
    1, Iclass_AE_MULAAAAQ16_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAAAQ16_S2_args,
    1, Iclass_AE_MULZAAAAQ16_S2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAAAQ16_S2_args,
    1, Iclass_AE_MULAAAAQ16_S2_stateArgs, 0, 0 },
  { 2, Iclass_AE_DIV64D32_H_args,
    1, Iclass_AE_DIV64D32_H_stateArgs, 0, 0 },
  { 2, Iclass_AE_DIV64D32_L_args,
    1, Iclass_AE_DIV64D32_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_SHA32_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_VLDL32T_args,
    5, Iclass_AE_VLDL32T_stateArgs, 0, 0 },
  { 3, Iclass_AE_VLDL16T_args,
    5, Iclass_AE_VLDL16T_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLDL16C_args,
    8, Iclass_AE_VLDL16C_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLDL16C_IP_args,
    8, Iclass_AE_VLDL16C_IP_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLDL16C_IC_args,
    11, Iclass_AE_VLDL16C_IC_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLDL16C_IC1_args,
    11, Iclass_AE_VLDL16C_IC1_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLDSHT_args,
    6, Iclass_AE_VLDSHT_stateArgs, 0, 0 },
  { 2, Iclass_AE_LB_args,
    3, Iclass_AE_LB_stateArgs, 0, 0 },
  { 2, Iclass_AE_LBI_args,
    3, Iclass_AE_LBI_stateArgs, 0, 0 },
  { 3, Iclass_AE_LBK_args,
    3, Iclass_AE_LBK_stateArgs, 0, 0 },
  { 3, Iclass_AE_LBKI_args,
    3, Iclass_AE_LBKI_stateArgs, 0, 0 },
  { 2, Iclass_AE_LBS_args,
    3, Iclass_AE_LBS_stateArgs, 0, 0 },
  { 2, Iclass_AE_LBSI_args,
    3, Iclass_AE_LBSI_stateArgs, 0, 0 },
  { 2, Iclass_AE_DB_args,
    3, Iclass_AE_DB_stateArgs, 0, 0 },
  { 2, Iclass_AE_DBI_args,
    3, Iclass_AE_DBI_stateArgs, 0, 0 },
  { 2, Iclass_AE_DB_IC_a