/* Xtensa configuration-specific ISA information.

   Copyright (c) 2003-2023 Cadence Design Systems, Inc.

   Permission is hereby granted, free of charge, to any person obtaining
   a copy of this software and associated documentation files (the
   "Software"), to deal in the Software without restriction, including
   without limitation the rights to use, copy, modify, merge, publish,
   distribute, sublicense, and/or sell copies of the Software, and to
   permit persons to whom the Software is furnished to do so, subject to
   the following conditions:

   The above copyright notice and this permission notice shall be included
   in all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
   CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
   TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
   SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.  */

#include "ansidecl.h"
#include <xtensa-isa.h>
#include "xtensa-isa-internal.h"


/* Sysregs.  */

static xtensa_sysreg_internal sysregs[] = {
  { "LBEG", 0, 0 },
  { "LEND", 1, 0 },
  { "LCOUNT", 2, 0 },
  { "MMID", 89, 0 },
  { "DDR", 104, 0 },
  { "CONFIGID0", 176, 0 },
  { "CONFIGID1", 208, 0 },
  { "INTERRUPT", 226, 0 },
  { "INTCLEAR", 227, 0 },
  { "CCOUNT", 234, 0 },
  { "PRID", 235, 0 },
  { "ICOUNT", 236, 0 },
  { "CCOMPARE0", 240, 0 },
  { "CCOMPARE1", 241, 0 },
  { "VECBASE", 231, 0 },
  { "EPC1", 177, 0 },
  { "EPC2", 178, 0 },
  { "EPC3", 179, 0 },
  { "EPC4", 180, 0 },
  { "EPC5", 181, 0 },
  { "EXCSAVE1", 209, 0 },
  { "EXCSAVE2", 210, 0 },
  { "EXCSAVE3", 211, 0 },
  { "EXCSAVE4", 212, 0 },
  { "EXCSAVE5", 213, 0 },
  { "EPS2", 194, 0 },
  { "EPS3", 195, 0 },
  { "EPS4", 196, 0 },
  { "EPS5", 197, 0 },
  { "EXCCAUSE", 232, 0 },
  { "DEPC", 192, 0 },
  { "EXCVADDR", 238, 0 },
  { "WINDOWBASE", 72, 0 },
  { "WINDOWSTART", 73, 0 },
  { "MEMCTL", 97, 0 },
  { "SAR", 3, 0 },
  { "PS", 230, 0 },
  { "MISC0", 244, 0 },
  { "MISC1", 245, 0 },
  { "INTENABLE", 228, 0 },
  { "DBREAKA0", 144, 0 },
  { "DBREAKC0", 160, 0 },
  { "DBREAKA1", 145, 0 },
  { "DBREAKC1", 161, 0 },
  { "IBREAKA0", 128, 0 },
  { "IBREAKA1", 129, 0 },
  { "IBREAKENABLE", 96, 0 },
  { "ICOUNTLEVEL", 237, 0 },
  { "DEBUGCAUSE", 233, 0 },
  { "CPENABLE", 224, 0 },
  { "SCOMPARE1", 12, 0 },
  { "ATOMCTL", 99, 0 },
  { "THREADPTR", 231, 1 },
  { "CIRC", -1, 1 },
  { "TABLEFIRSTSEARCHNEXT", -1, 1 },
  { "FUSIONMISC", -1, 1 },
  { "FCR_FSR", -1, 1 },
  { "EXPSTATE", 230, 1 }
};

#define NUM_SYSREGS 58
#define MAX_SPECIAL_REG 245
#define MAX_USER_REG 231


/* Processor states.  */

static xtensa_state_internal states[] = {
  { "LCOUNT", 32, 0 },
  { "PC", 32, 0 },
  { "DDR", 32, 0 },
  { "ICOUNT", 32, 0 },
  { "INTERRUPT", 32, 0 },
  { "CCOUNT", 32, 0 },
  { "XTSYNC", 1, 0 },
  { "VECBASE", 22, 0 },
  { "VECBASELOCK", 1, 0 },
  { "EPC1", 32, 0 },
  { "EPC2", 32, 0 },
  { "EPC3", 32, 0 },
  { "EPC4", 32, 0 },
  { "EPC5", 32, 0 },
  { "EXCSAVE1", 32, 0 },
  { "EXCSAVE2", 32, 0 },
  { "EXCSAVE3", 32, 0 },
  { "EXCSAVE4", 32, 0 },
  { "EXCSAVE5", 32, 0 },
  { "EPS2", 13, 0 },
  { "EPS3", 13, 0 },
  { "EPS4", 13, 0 },
  { "EPS5", 13, 0 },
  { "EXCCAUSE", 6, 0 },
  { "PSINTLEVEL", 4, 0 },
  { "PSUM", 1, 0 },
  { "PSWOE", 1, 0 },
  { "PSEXCM", 1, 0 },
  { "DEPC", 32, 0 },
  { "EXCVADDR", 32, 0 },
  { "WindowBase", 3, 0 },
  { "WindowStart", 8, 0 },
  { "PSCALLINC", 2, 0 },
  { "PSOWB", 4, 0 },
  { "LBEG", 32, 0 },
  { "LEND", 32, 0 },
  { "MEMCTL", 1, 0 },
  { "SAR", 6, 0 },
  { "THREADPTR", 32, 0 },
  { "MISC0", 32, 0 },
  { "MISC1", 32, 0 },
  { "InOCDMode", 1, 0 },
  { "INTENABLE", 32, 0 },
  { "DBREAKA0", 32, 0 },
  { "DBREAKC0", 8, 0 },
  { "DBREAKA1", 32, 0 },
  { "DBREAKC1", 8, 0 },
  { "IBREAKA0", 32, 0 },
  { "IBREAKA1", 32, 0 },
  { "IBREAKENABLE", 2, 0 },
  { "ICOUNTLEVEL", 4, 0 },
  { "DEBUGCAUSE", 6, 0 },
  { "DBNUM", 4, 0 },
  { "CCOMPARE0", 32, 0 },
  { "CCOMPARE1", 32, 0 },
  { "CPENABLE", 2, 0 },
  { "SCOMPARE1", 32, 0 },
  { "ATOMCTL", 6, 0 },
  { "ERI_RAW_INTERLOCK", 1, 0 },
  { "AE_OVERFLOW", 1, XTENSA_STATE_IS_SHARED_OR },
  { "AE_CBEGIN0", 32, 0 },
  { "AE_CEND0", 32, 0 },
  { "AE_SAR", 7, 0 },
  { "AE_CWRAP", 1, 0 },
  { "AE_BITHEAD", 32, 0 },
  { "AE_BITPTR", 4, 0 },
  { "AE_BITSUSED", 4, 0 },
  { "AE_TABLESIZE", 4, 0 },
  { "AE_FIRST_TS", 4, 0 },
  { "AE_NEXTOFFSET", 27, 0 },
  { "AE_SEARCHDONE", 1, 0 },
  { "RoundMode", 2, 0 },
  { "StickyFlags", 5, XTENSA_STATE_IS_SHARED_OR },
  { "StickyEnable", 5, 0 },
  { "EXPSTATE", 32, XTENSA_STATE_IS_EXPORTED }
};

#define NUM_STATES 75

enum xtensa_state_id {
  STATE_LCOUNT,
  STATE_PC,
  STATE_DDR,
  STATE_ICOUNT,
  STATE_INTERRUPT,
  STATE_CCOUNT,
  STATE_XTSYNC,
  STATE_VECBASE,
  STATE_VECBASELOCK,
  STATE_EPC1,
  STATE_EPC2,
  STATE_EPC3,
  STATE_EPC4,
  STATE_EPC5,
  STATE_EXCSAVE1,
  STATE_EXCSAVE2,
  STATE_EXCSAVE3,
  STATE_EXCSAVE4,
  STATE_EXCSAVE5,
  STATE_EPS2,
  STATE_EPS3,
  STATE_EPS4,
  STATE_EPS5,
  STATE_EXCCAUSE,
  STATE_PSINTLEVEL,
  STATE_PSUM,
  STATE_PSWOE,
  STATE_PSEXCM,
  STATE_DEPC,
  STATE_EXCVADDR,
  STATE_WindowBase,
  STATE_WindowStart,
  STATE_PSCALLINC,
  STATE_PSOWB,
  STATE_LBEG,
  STATE_LEND,
  STATE_MEMCTL,
  STATE_SAR,
  STATE_THREADPTR,
  STATE_MISC0,
  STATE_MISC1,
  STATE_InOCDMode,
  STATE_INTENABLE,
  STATE_DBREAKA0,
  STATE_DBREAKC0,
  STATE_DBREAKA1,
  STATE_DBREAKC1,
  STATE_IBREAKA0,
  STATE_IBREAKA1,
  STATE_IBREAKENABLE,
  STATE_ICOUNTLEVEL,
  STATE_DEBUGCAUSE,
  STATE_DBNUM,
  STATE_CCOMPARE0,
  STATE_CCOMPARE1,
  STATE_CPENABLE,
  STATE_SCOMPARE1,
  STATE_ATOMCTL,
  STATE_ERI_RAW_INTERLOCK,
  STATE_AE_OVERFLOW,
  STATE_AE_CBEGIN0,
  STATE_AE_CEND0,
  STATE_AE_SAR,
  STATE_AE_CWRAP,
  STATE_AE_BITHEAD,
  STATE_AE_BITPTR,
  STATE_AE_BITSUSED,
  STATE_AE_TABLESIZE,
  STATE_AE_FIRST_TS,
  STATE_AE_NEXTOFFSET,
  STATE_AE_SEARCHDONE,
  STATE_RoundMode,
  STATE_StickyFlags,
  STATE_StickyEnable,
  STATE_EXPSTATE
};


/* Field definitions.  */

static unsigned
Field_t_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_s_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_r_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_op2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_op1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_op1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_op0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_op0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_n_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_n_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_m_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_m_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_sr_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sr_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_st_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_st_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_thi3_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_thi3_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_s3to1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 20) >> 29);
  return tie_t;
}

static void
Field_s3to1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00) | (tie_t << 9);
}

static unsigned
Field_fld_inst_23_12_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 8) >> 20);
  return tie_t;
}

static void
Field_fld_inst_23_12_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff000) | (tie_t << 12);
}

static unsigned
Field_fld_inst_7_0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 24) >> 24);
  return tie_t;
}

static void
Field_fld_inst_7_0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff) | (tie_t << 0);
}

static unsigned
Field_fld_inst_23_16_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 8) >> 24);
  return tie_t;
}

static void
Field_fld_inst_23_16_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0000) | (tie_t << 16);
}

static unsigned
Field_fld_inst_3_0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_inst_3_0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_inst_19_16_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_fld_inst_19_16_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_fld_inst_23_21_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 8) >> 29);
  return tie_t;
}

static void
Field_fld_inst_23_21_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe00000) | (tie_t << 21);
}

static unsigned
Field_fld_inst_19_18_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 12) >> 30);
  return tie_t;
}

static void
Field_fld_inst_19_18_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0000) | (tie_t << 18);
}

static unsigned
Field_fld_inst_9_8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_inst_9_8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_inst_11_8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_inst_11_8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_inst_23_10_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 8) >> 18);
  return tie_t;
}

static void
Field_fld_inst_23_10_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0xfffc00) | (tie_t << 10);
}

static unsigned
Field_fld_inst_15_12_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_inst_15_12_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_inst_7_6_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_inst_7_6_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_inst_11_10_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_fld_inst_11_10_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_fld_inst_23_20_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  return tie_t;
}

static void
Field_fld_inst_23_20_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_fld_inst_23_15_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 8) >> 23);
  return tie_t;
}

static void
Field_fld_inst_23_15_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0xff8000) | (tie_t << 15);
}

static unsigned
Field_fld_inst_7_7_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_inst_7_7_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_inst_19_17_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 12) >> 29);
  return tie_t;
}

static void
Field_fld_inst_19_17_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0000) | (tie_t << 17);
}

static unsigned
Field_fld_inst_19_8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 12) >> 20);
  return tie_t;
}

static void
Field_fld_inst_19_8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff00) | (tie_t << 8);
}

static unsigned
Field_fld_inst_19_12_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 12) >> 24);
  return tie_t;
}

static void
Field_fld_inst_19_12_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff000) | (tie_t << 12);
}

static unsigned
Field_fld_inst_23_8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 8) >> 16);
  return tie_t;
}

static void
Field_fld_inst_23_8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff00) | (tie_t << 8);
}

static unsigned
Field_fld_inst_23_23_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 8) >> 31);
  return tie_t;
}

static void
Field_fld_inst_23_23_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800000) | (tie_t << 23);
}

static unsigned
Field_fld_inst_23_11_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 8) >> 19);
  return tie_t;
}

static void
Field_fld_inst_23_11_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0xfff800) | (tie_t << 11);
}

static unsigned
Field_fld_inst_23_14_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 8) >> 22);
  return tie_t;
}

static void
Field_fld_inst_23_14_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0xffc000) | (tie_t << 14);
}

static unsigned
Field_op0_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_op0_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_t_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_r_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_r_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_op0_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_op0_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_z_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_z_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_i_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_i_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_s_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_s_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_inst16b_15_13_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 16) >> 29);
  return tie_t;
}

static void
Field_ae_fld_inst16b_15_13_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe000) | (tie_t << 13);
}

static unsigned
Field_ae_fld_inst16b_12_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_ae_fld_inst16b_12_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_f0_s0_22_8_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 9) >> 17);
  return tie_t;
}

static void
Field_fld_f0_s0_22_8_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x7fff00) | (tie_t << 8);
}

static unsigned
Field_fld_f0_s0_22_20_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 9) >> 29);
  return tie_t;
}

static void
Field_fld_f0_s0_22_20_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700000) | (tie_t << 20);
}

static unsigned
Field_fld_f0_s0_11_8_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_f0_s0_11_8_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_f0_s0_22_12_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 9) >> 21);
  return tie_t;
}

static void
Field_fld_f0_s0_22_12_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x7ff000) | (tie_t << 12);
}

static unsigned
Field_fld_f0_s0_7_4_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_f0_s0_7_4_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_f0_s0_7_5_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_fld_f0_s0_7_5_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_fld_f0_s0_22_16_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 9) >> 25);
  return tie_t;
}

static void
Field_fld_f0_s0_22_16_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x7f0000) | (tie_t << 16);
}

static unsigned
Field_fld_f0_s0_22_4_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 19) | ((insn[0] << 9) >> 13);
  return tie_t;
}

static void
Field_fld_f0_s0_22_4_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 13) >> 13;
  insn[0] = (insn[0] & ~0x7ffff0) | (tie_t << 4);
}

static unsigned
Field_fld_f0_s0_22_17_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 9) >> 26);
  return tie_t;
}

static void
Field_fld_f0_s0_22_17_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x7e0000) | (tie_t << 17);
}

static unsigned
Field_fld_f0_s0_22_18_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 9) >> 27);
  return tie_t;
}

static void
Field_fld_f0_s0_22_18_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x7c0000) | (tie_t << 18);
}

static unsigned
Field_fld_f0_s0_11_4_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_fld_f0_s0_11_4_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
}

static unsigned
Field_fld_f0_s0_3_0_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_f0_s0_3_0_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_f0_s0_22_0_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 23) | ((insn[0] << 9) >> 9);
  return tie_t;
}

static void
Field_fld_f0_s0_22_0_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 9) >> 9;
  insn[0] = (insn[0] & ~0x7fffff) | (tie_t << 0);
}

static unsigned
Field_fld_f0_s0_9_3_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 22) >> 25);
  return tie_t;
}

static void
Field_fld_f0_s0_9_3_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x3f8) | (tie_t << 3);
}

static unsigned
Field_fld_f0_s0_22_13_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 9) >> 22);
  return tie_t;
}

static void
Field_fld_f0_s0_22_13_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x7fe000) | (tie_t << 13);
}

static unsigned
Field_fld_f0_s0_13_12_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_fld_f0_s0_13_12_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_fld_f0_s0_22_14_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 9) >> 23);
  return tie_t;
}

static void
Field_fld_f0_s0_22_14_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x7fc000) | (tie_t << 14);
}

static unsigned
Field_fld_f0_s0_11_0_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 20) >> 20);
  return tie_t;
}

static void
Field_fld_f0_s0_11_0_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff) | (tie_t << 0);
}

static unsigned
Field_fld_f0_s0_11_2_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 20) >> 22);
  return tie_t;
}

static void
Field_fld_f0_s0_11_2_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0xffc) | (tie_t << 2);
}

static unsigned
Field_fld_f0_s0_3_2_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_f0_s0_3_2_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_f0_s0_9_9_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 22) >> 31);
  return tie_t;
}

static void
Field_fld_f0_s0_9_9_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x200) | (tie_t << 9);
}

static unsigned
Field_fld_f0_s0_9_5_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 22) >> 27);
  return tie_t;
}

static void
Field_fld_f0_s0_9_5_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0) | (tie_t << 5);
}

static unsigned
Field_fld_f0_s0_3_3_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 28) >> 31);
  return tie_t;
}

static void
Field_fld_f0_s0_3_3_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8) | (tie_t << 3);
}

static unsigned
Field_fld_f0_s0_22_10_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 9) >> 19);
  return tie_t;
}

static void
Field_fld_f0_s0_22_10_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x7ffc00) | (tie_t << 10);
}

static unsigned
Field_fld_f0_s1_20_8_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 11) >> 19);
  return tie_t;
}

static void
Field_fld_f0_s1_20_8_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x1fff00) | (tie_t << 8);
}

static unsigned
Field_fld_f0_s1_20_16_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 11) >> 27);
  return tie_t;
}

static void
Field_fld_f0_s1_20_16_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0000) | (tie_t << 16);
}

static unsigned
Field_fld_f0_s1_20_12_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 11) >> 23);
  return tie_t;
}

static void
Field_fld_f0_s1_20_12_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x1ff000) | (tie_t << 12);
}

static unsigned
Field_fld_f0_s1_20_17_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 11) >> 28);
  return tie_t;
}

static void
Field_fld_f0_s1_20_17_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e0000) | (tie_t << 17);
}

static unsigned
Field_fld_f0_s1_7_4_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_f0_s1_7_4_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_f0_s1_20_0_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 21) | ((insn[0] << 11) >> 11);
  return tie_t;
}

static void
Field_fld_f0_s1_20_0_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 11) >> 11;
  insn[0] = (insn[0] & ~0x1fffff) | (tie_t << 0);
}

static unsigned
Field_fld_f0_s1_3_0_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_f0_s1_3_0_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_f0_s1_20_13_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 11) >> 24);
  return tie_t;
}

static void
Field_fld_f0_s1_20_13_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x1fe000) | (tie_t << 13);
}

static unsigned
Field_fld_f0_s1_3_3_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 28) >> 31);
  return tie_t;
}

static void
Field_fld_f0_s1_3_3_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8) | (tie_t << 3);
}

static unsigned
Field_fld_f0_s1_20_10_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 11) >> 21);
  return tie_t;
}

static void
Field_fld_f0_s1_20_10_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x1ffc00) | (tie_t << 10);
}

static unsigned
Field_fld_f0_s1_20_9_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 11) >> 20);
  return tie_t;
}

static void
Field_fld_f0_s1_20_9_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x1ffe00) | (tie_t << 9);
}

static unsigned
Field_fld_f0_s1_20_7_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 11) >> 18);
  return tie_t;
}

static void
Field_fld_f0_s1_20_7_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0x1fff80) | (tie_t << 7);
}

static unsigned
Field_fld_f0_s1_20_15_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 11) >> 26);
  return tie_t;
}

static void
Field_fld_f0_s1_20_15_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x1f8000) | (tie_t << 15);
}

static unsigned
Field_fld_f1_s0_21_12_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 10) >> 22);
  return tie_t;
}

static void
Field_fld_f1_s0_21_12_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff000) | (tie_t << 12);
}

static unsigned
Field_fld_f1_s0_21_0_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 22) | ((insn[0] << 10) >> 10);
  return tie_t;
}

static void
Field_fld_f1_s0_21_0_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 10) >> 10;
  insn[0] = (insn[0] & ~0x3fffff) | (tie_t << 0);
}

static unsigned
Field_fld_f1_s0_21_8_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 14) | ((insn[0] << 10) >> 18);
  return tie_t;
}

static void
Field_fld_f1_s0_21_8_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 18) >> 18;
  insn[0] = (insn[0] & ~0x3fff00) | (tie_t << 8);
}

static unsigned
Field_fld_f1_s0_3_0_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_f1_s0_3_0_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_f1_s0_21_16_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 10) >> 26);
  return tie_t;
}

static void
Field_fld_f1_s0_21_16_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f0000) | (tie_t << 16);
}

static unsigned
Field_fld_f1_s0_21_13_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  return tie_t;
}

static void
Field_fld_f1_s0_21_13_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_fld_f1_s0_21_18_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 10) >> 28);
  return tie_t;
}

static void
Field_fld_f1_s0_21_18_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x3c0000) | (tie_t << 18);
}

static unsigned
Field_fld_f1_s0_13_12_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_fld_f1_s0_13_12_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_fld_f1_s0_11_8_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_f1_s0_11_8_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_f1_s0_21_14_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 10) >> 24);
  return tie_t;
}

static void
Field_fld_f1_s0_21_14_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0x3fc000) | (tie_t << 14);
}

static unsigned
Field_fld_f1_s0_7_7_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_f1_s0_7_7_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_f1_s0_7_4_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_f1_s0_7_4_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_f1_s0_21_10_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 10) >> 20);
  return tie_t;
}

static void
Field_fld_f1_s0_21_10_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0x3ffc00) | (tie_t << 10);
}

static unsigned
Field_fld_f1_s0_21_9_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 13) | ((insn[0] << 10) >> 19);
  return tie_t;
}

static void
Field_fld_f1_s0_21_9_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 19) >> 19;
  insn[0] = (insn[0] & ~0x3ffe00) | (tie_t << 9);
}

static unsigned
Field_fld_f1_s0_1_0_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_f1_s0_1_0_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_f1_s0_21_11_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 10) >> 21);
  return tie_t;
}

static void
Field_fld_f1_s0_21_11_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x3ff800) | (tie_t << 11);
}

static unsigned
Field_fld_f1_s0_11_7_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 20) >> 27);
  return tie_t;
}

static void
Field_fld_f1_s0_11_7_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0xf80) | (tie_t << 7);
}

static unsigned
Field_fld_f1_s0_11_11_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_fld_f1_s0_11_11_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_fld_f1_s0_3_2_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_f1_s0_3_2_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_f1_s0_21_17_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 10) >> 27);
  return tie_t;
}

static void
Field_fld_f1_s0_21_17_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x3e0000) | (tie_t << 17);
}

static unsigned
Field_fld_f1_s1_20_0_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 21) | ((insn[0] << 11) >> 11);
  return tie_t;
}

static void
Field_fld_f1_s1_20_0_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 11) >> 11;
  insn[0] = (insn[0] & ~0x1fffff) | (tie_t << 0);
}

static unsigned
Field_fld_f1_s1_20_12_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 11) >> 23);
  return tie_t;
}

static void
Field_fld_f1_s1_20_12_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x1ff000) | (tie_t << 12);
}

static unsigned
Field_fld_f1_s1_20_16_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 11) >> 27);
  return tie_t;
}

static void
Field_fld_f1_s1_20_16_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0000) | (tie_t << 16);
}

static unsigned
Field_fld_f1_s1_11_4_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_fld_f1_s1_11_4_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
}

static unsigned
Field_fld_f1_s1_20_15_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 11) >> 26);
  return tie_t;
}

static void
Field_fld_f1_s1_20_15_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x1f8000) | (tie_t << 15);
}

static unsigned
Field_fld_f1_s1_7_4_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_f1_s1_7_4_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_f1_s1_11_8_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_f1_s1_11_8_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_f1_s1_7_5_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_fld_f1_s1_7_5_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_fld_f1_s1_7_6_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  return tie_t;
}

static void
Field_fld_f1_s1_7_6_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_fld_f1_s1_11_3_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 20) >> 23);
  return tie_t;
}

static void
Field_fld_f1_s1_11_3_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0xff8) | (tie_t << 3);
}

static unsigned
Field_fld_f1_s1_7_7_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_f1_s1_7_7_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_f2_s0_33_9_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | (insn[1] & 0x3);
  tie_t = (tie_t << 23) | (insn[0] >> 9);
  return tie_t;
}

static void
Field_fld_f2_s0_33_9_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 7) >> 7;
  insn[0] = (insn[0] & ~0xfffffe00) | (tie_t << 9);
  insn[1] = (insn[1] & ~0x3) | (tie_t >> 23);
}

static unsigned
Field_fld_f2_s0_8_0_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 23) >> 23);
  return tie_t;
}

static void
Field_fld_f2_s0_8_0_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x1ff) | (tie_t << 0);
}

static unsigned
Field_fld_f2_s0_33_23_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | (insn[1] & 0x3);
  tie_t = (tie_t << 9) | (insn[0] >> 23);
  return tie_t;
}

static void
Field_fld_f2_s0_33_23_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0xff800000) | (tie_t << 23);
  insn[1] = (insn[1] & ~0x3) | (tie_t >> 9);
}

static unsigned
Field_fld_f2_s0_3_0_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_f2_s0_3_0_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_f2_s0_33_24_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | (insn[1] & 0x3);
  tie_t = (tie_t << 8) | (insn[0] >> 24);
  return tie_t;
}

static void
Field_fld_f2_s0_33_24_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0xff000000) | (tie_t << 24);
  insn[1] = (insn[1] & ~0x3) | (tie_t >> 8);
}

static unsigned
Field_fld_f2_s0_33_19_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | (insn[1] & 0x3);
  tie_t = (tie_t << 13) | (insn[0] >> 19);
  return tie_t;
}

static void
Field_fld_f2_s0_33_19_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0xfff80000) | (tie_t << 19);
  insn[1] = (insn[1] & ~0x3) | (tie_t >> 13);
}

static unsigned
Field_fld_f2_s0_8_8_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_fld_f2_s0_8_8_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_fld_f2_s0_33_12_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | (insn[1] & 0x3);
  tie_t = (tie_t << 20) | (insn[0] >> 12);
  return tie_t;
}

static void
Field_fld_f2_s0_33_12_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 10) >> 10;
  insn[0] = (insn[0] & ~0xfffff000) | (tie_t << 12);
  insn[1] = (insn[1] & ~0x3) | (tie_t >> 20);
}

static unsigned
Field_fld_f2_s0_7_0_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 24) >> 24);
  return tie_t;
}

static void
Field_fld_f2_s0_7_0_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff) | (tie_t << 0);
}

static unsigned
Field_fld_f2_s0_33_16_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | (insn[1] & 0x3);
  tie_t = (tie_t << 16) | (insn[0] >> 16);
  return tie_t;
}

static void
Field_fld_f2_s0_33_16_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xffff0000) | (tie_t << 16);
  insn[1] = (insn[1] & ~0x3) | (tie_t >> 16);
}

static unsigned
Field_fld_f2_s0_33_13_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | (insn[1] & 0x3);
  tie_t = (tie_t << 19) | (insn[0] >> 13);
  return tie_t;
}

static void
Field_fld_f2_s0_33_13_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 11) >> 11;
  insn[0] = (insn[0] & ~0xffffe000) | (tie_t << 13);
  insn[1] = (insn[1] & ~0x3) | (tie_t >> 19);
}

static unsigned
Field_fld_f2_s0_33_14_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | (insn[1] & 0x3);
  tie_t = (tie_t << 18) | (insn[0] >> 14);
  return tie_t;
}

static void
Field_fld_f2_s0_33_14_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 12) >> 12;
  insn[0] = (insn[0] & ~0xffffc000) | (tie_t << 14);
  insn[1] = (insn[1] & ~0x3) | (tie_t >> 18);
}

static unsigned
Field_fld_f2_s0_11_8_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_f2_s0_11_8_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_f2_s0_7_7_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_fld_f2_s0_7_7_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_fld_f2_s0_7_4_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_f2_s0_7_4_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_f2_s0_7_5_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 24) >> 29);
  return tie_t;
}

static void
Field_fld_f2_s0_7_5_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0xe0) | (tie_t << 5);
}

static unsigned
Field_fld_f2_s0_11_4_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_fld_f2_s0_11_4_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
}

static unsigned
Field_fld_f2_s0_9_8_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_f2_s0_9_8_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_f2_s0_33_15_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | (insn[1] & 0x3);
  tie_t = (tie_t << 17) | (insn[0] >> 15);
  return tie_t;
}

static void
Field_fld_f2_s0_33_15_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 13) >> 13;
  insn[0] = (insn[0] & ~0xffff8000) | (tie_t << 15);
  insn[1] = (insn[1] & ~0x3) | (tie_t >> 17);
}

static unsigned
Field_fld_f2_s0_10_8_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 21) >> 29);
  return tie_t;
}

static void
Field_fld_f2_s0_10_8_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700) | (tie_t << 8);
}

static unsigned
Field_fld_f2_s0_3_3_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 28) >> 31);
  return tie_t;
}

static void
Field_fld_f2_s0_3_3_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8) | (tie_t << 3);
}

static unsigned
Field_fld_f2_s0_9_7_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 22) >> 29);
  return tie_t;
}

static void
Field_fld_f2_s0_9_7_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380) | (tie_t << 7);
}

static unsigned
Field_fld_f2_s0_9_3_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 7) | ((insn[0] << 22) >> 25);
  return tie_t;
}

static void
Field_fld_f2_s0_9_3_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 25) >> 25;
  insn[0] = (insn[0] & ~0x3f8) | (tie_t << 3);
}

static unsigned
Field_fld_f2_s0_33_10_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | (insn[1] & 0x3);
  tie_t = (tie_t << 22) | (insn[0] >> 10);
  return tie_t;
}

static void
Field_fld_f2_s0_33_10_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 8) >> 8;
  insn[0] = (insn[0] & ~0xfffffc00) | (tie_t << 10);
  insn[1] = (insn[1] & ~0x3) | (tie_t >> 22);
}

static unsigned
Field_fld_f2_s0_33_17_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | (insn[1] & 0x3);
  tie_t = (tie_t << 15) | (insn[0] >> 17);
  return tie_t;
}

static void
Field_fld_f2_s0_33_17_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 15) >> 15;
  insn[0] = (insn[0] & ~0xfffe0000) | (tie_t << 17);
  insn[1] = (insn[1] & ~0x3) | (tie_t >> 15);
}

static unsigned
Field_fld_f3_s0_21_0_Slot_f3_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 22) | ((insn[0] << 10) >> 10);
  return tie_t;
}

static void
Field_fld_f3_s0_21_0_Slot_f3_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 10) >> 10;
  insn[0] = (insn[0] & ~0x3fffff) | (tie_t << 0);
}

static unsigned
Field_fld_f3_s0_21_13_Slot_f3_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 9) | ((insn[0] << 10) >> 23);
  return tie_t;
}

static void
Field_fld_f3_s0_21_13_Slot_f3_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 23) >> 23;
  insn[0] = (insn[0] & ~0x3fe000) | (tie_t << 13);
}

static unsigned
Field_fld_f3_s0_21_19_Slot_f3_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 10) >> 29);
  return tie_t;
}

static void
Field_fld_f3_s0_21_19_Slot_f3_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x380000) | (tie_t << 19);
}

static unsigned
Field_fld_f3_s0_21_16_Slot_f3_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 6) | ((insn[0] << 10) >> 26);
  return tie_t;
}

static void
Field_fld_f3_s0_21_16_Slot_f3_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 26) >> 26;
  insn[0] = (insn[0] & ~0x3f0000) | (tie_t << 16);
}

static unsigned
Field_fld_f3_s0_21_12_Slot_f3_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 10) | ((insn[0] << 10) >> 22);
  return tie_t;
}

static void
Field_fld_f3_s0_21_12_Slot_f3_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 22) >> 22;
  insn[0] = (insn[0] & ~0x3ff000) | (tie_t << 12);
}

static unsigned
Field_fld_f3_s0_3_2_Slot_f3_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_f3_s0_3_2_Slot_f3_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
}

static unsigned
Field_fld_f3_s1_10_0_Slot_f3_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 21) >> 21);
  return tie_t;
}

static void
Field_fld_f3_s1_10_0_Slot_f3_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 21) >> 21;
  insn[0] = (insn[0] & ~0x7ff) | (tie_t << 0);
}

static unsigned
Field_fld_f3_s1_10_8_Slot_f3_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 21) >> 29);
  return tie_t;
}

static void
Field_fld_f3_s1_10_8_Slot_f3_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700) | (tie_t << 8);
}

static unsigned
Field_t_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_t_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_t_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_t_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_t_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_t_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_bbi4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  return tie_t;
}

static void
Field_bbi4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_bbi_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_bbi_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_bbi_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_bbi_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_bbi_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 8) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_bbi_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x800000) | (tie_t << 23);
}

static unsigned
Field_imm12_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 8) >> 20);
  return tie_t;
}

static void
Field_imm12_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff000) | (tie_t << 12);
}

static unsigned
Field_imm12_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 16) >> 20);
  return tie_t;
}

static void
Field_imm12_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0) | (tie_t << 4);
}

static unsigned
Field_imm8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 8) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0000) | (tie_t << 16);
}

static unsigned
Field_imm8_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 12) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff000) | (tie_t << 12);
}

static unsigned
Field_imm8_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_imm8_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm8_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm8_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_s_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_s_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_s_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_s_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_s_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_s_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_s_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_s_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s_Slot_f3_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_s_Slot_f3_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_s8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  return tie_t;
}

static void
Field_s8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_imms8_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 21) >> 29);
  return tie_t;
}

static void
Field_imms8_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700) | (tie_t << 8);
}

static unsigned
Field_imm12b_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 8) | ((insn[0] << 8) >> 24);
  return tie_t;
}

static void
Field_imm12b_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0000) | (tie_t << 16);
  tie_t = (val << 20) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_imm12b_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm12b_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 20) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_imm12b_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 16) >> 20);
  return tie_t;
}

static void
Field_imm12b_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 20) >> 20;
  insn[0] = (insn[0] & ~0xfff0) | (tie_t << 4);
}

static unsigned
Field_imm16_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 16) | ((insn[0] << 8) >> 16);
  return tie_t;
}

static void
Field_imm16_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 16) >> 16;
  insn[0] = (insn[0] & ~0xffff00) | (tie_t << 8);
}

static unsigned
Field_imm16_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 12) | ((insn[0] << 12) >> 20);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_imm16_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 16) >> 20;
  insn[0] = (insn[0] & ~0xfff00) | (tie_t << 8);
}

static unsigned
Field_offset_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 8) >> 14);
  return tie_t;
}

static void
Field_offset_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0xffffc0) | (tie_t << 6);
}

static unsigned
Field_offset_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 18) | ((insn[0] << 14) >> 14);
  return tie_t;
}

static void
Field_offset_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 14) >> 14;
  insn[0] = (insn[0] & ~0x3ffff) | (tie_t << 0);
}

static unsigned
Field_op2_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_op2_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 15) >> 28);
  return tie_t;
}

static void
Field_op2_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x1e000) | (tie_t << 13);
}

static unsigned
Field_r_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_r_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_r_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_r_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_r_Slot_f3_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_r_Slot_f3_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_r_disp_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_r_disp_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_r_3_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 16) >> 31);
  return tie_t;
}

static void
Field_r_3_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8000) | (tie_t << 15);
}

static unsigned
Field_sa4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  return tie_t;
}

static void
Field_sa4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_sae4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  return tie_t;
}

static void
Field_sae4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_sae_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_sae_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sae_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sae_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_sal_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sal_Slot_f3_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sal_Slot_f3_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_sargt_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sargt_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_sargt_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_sas4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_sas4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_sas_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_sas_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
}

static unsigned
Field_sas_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_sas_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
  tie_t = (val << 27) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_f_low_depbits_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  return tie_t;
}

static void
Field_f_low_depbits_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_f_lngth_depbits_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_f_lngth_depbits_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_mn_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 24) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_mn_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0xc0) | (tie_t << 6);
}

static unsigned
Field_i_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 24) >> 31);
  return tie_t;
}

static void
Field_i_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x80) | (tie_t << 7);
}

static unsigned
Field_imm6lo_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm6lo_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm6lo_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm6lo_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm6hi_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_imm6hi_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_imm6hi_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_imm6hi_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_imm7lo_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm7lo_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm7lo_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm7lo_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_imm7hi_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_imm7hi_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_imm7hi_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_imm7hi_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_z_Slot_inst16a_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 25) >> 31);
  return tie_t;
}

static void
Field_z_Slot_inst16a_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x40) | (tie_t << 6);
}

static unsigned
Field_imm6_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm6_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_imm7_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_imm7_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 25) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_xt_wbr15_imm_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 8) >> 17);
  return tie_t;
}

static void
Field_xt_wbr15_imm_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0xfffe00) | (tie_t << 9);
}

static unsigned
Field_xt_wbr15_imm_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 9) >> 17);
  return tie_t;
}

static void
Field_xt_wbr15_imm_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0x7fff00) | (tie_t << 8);
}

static unsigned
Field_xt_wloop_imm_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 15) | ((insn[0] << 8) >> 17);
  return tie_t;
}

static void
Field_xt_wloop_imm_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 17) >> 17;
  insn[0] = (insn[0] & ~0xfffe00) | (tie_t << 9);
}

static unsigned
Field_xt_wloop_imm_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 13) >> 21);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_xt_wloop_imm_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 17) >> 21;
  insn[0] = (insn[0] & ~0x7ff00) | (tie_t << 8);
}

static unsigned
Field_xt_wloop_imm_Slot_f3_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 11) | ((insn[0] << 13) >> 21);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_xt_wloop_imm_Slot_f3_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 17) >> 21;
  insn[0] = (insn[0] & ~0x7ff00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_fhba4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_fhba4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_fhba4_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_fhba4_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_fhba4_2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_fhba4_2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_fhba4_2_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 17) >> 28);
  return tie_t;
}

static void
Field_ae_fld_fhba4_2_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0x7800) | (tie_t << 11);
}

static unsigned
Field_ae_fld_tp7_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_tp7_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_tp7_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_tp7_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_tp7_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_tp7_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_tp7_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_tp7_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_tp7_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_tp7_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_osa16_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa16_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_ae_fld_osa16_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa16_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_osa16_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa16_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_ae_fld_osa16_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa16_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_osa32_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 15) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa32_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x10000) | (tie_t << 16);
}

static unsigned
Field_ae_fld_osa32_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa32_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_osa32_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_ae_fld_osa32_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_osa32_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_ae_fld_osa32_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 27) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_osa64_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa64_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
}

static unsigned
Field_ae_fld_osa64_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_ae_fld_osa64_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 26) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_osa64_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_ae_fld_osa64_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
  tie_t = (val << 26) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_ae_fld_imm2_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_ae_fld_imm2_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_ae_fld_imm2_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_ae_fld_imm2_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_ae_fld_imm2_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_ae_fld_imm2_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_ae_fld_imm2_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_ae_fld_imm2_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_ae_fld_selimm_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 12) >> 28);
  return tie_t;
}

static void
Field_ae_fld_selimm_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0000) | (tie_t << 16);
}

static unsigned
Field_ae_fld_selimm_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_selimm_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_selimm_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_ae_fld_selimm_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_ae_fld_selimm_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_ae_fld_selimm_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_stage3_ar_operand_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_stage3_ar_operand_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_ar_to_ar_arr_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_ar_arr_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_ar_to_ar_arr_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_ar_arr_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_ar_to_ar_arr_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_ar_arr_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_ar_to_ar_arr_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_ar_arr_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_ar_to_ar_arr_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_ar_arr_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_ar_to_ar_arr_Slot_f3_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_ar_arr_Slot_f3_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_ar_to_ar_ars_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_ar_ars_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_ar_to_ar_ars_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_ar_ars_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_ar_to_ar_ars_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_ar_ars_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_ar_to_ar_ars_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_ar_ars_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_ar_to_ar_ars_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_ar_ars_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_ar_to_ar_ars_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_ar_ars_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_ar_to_ar_ars_Slot_f3_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_ar_ars_Slot_f3_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_ar_to_ar_art_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_ar_art_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_ar_to_ar_art_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_ar_art_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_ar_to_ar_art_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_ar_art_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_ar_to_ar_art_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_ar_art_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_ar_to_ar_art_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_ar_art_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_ar_to_ar_art_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_ar_art_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_ar_to_ar_art_Slot_f3_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_ar_art_Slot_f3_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_ar_to_dr_a0_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_dr_a0_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_ar_to_dr_a0_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_dr_a0_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_ar_to_dr_a0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_dr_a0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_ar_to_dr_a1_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_dr_a1_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_ar_to_dr_a1_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_dr_a1_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_ar_to_dr_a1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_dr_a1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_ar_to_dr_v_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_dr_v_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_ar_to_dr_v_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_dr_v_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_ar_to_dr_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_ar_to_dr_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_cmov_arr_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_arr_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_cmov_arr_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_arr_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_cmov_arr_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_arr_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_cmov_v_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_v_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_cmov_v_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_v_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_cmov_v_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_v_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_cmov_v_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_v_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_cmov_v_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_v_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_cmov_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_cmov_v0_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_v0_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_cmov_v0_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_v0_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_cmov_v0_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_v0_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_cmov_v0_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_v0_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_cmov_v0_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_v0_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_cmov_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_cmov_vbr_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_vbr_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_cmov_vbr_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_vbr_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_cmov_vbr_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_vbr_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_cmov_vbr_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_vbr_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_cmov_vbr_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_vbr_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_cmov_vbr_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_vbr_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_cmov_vbt_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_vbt_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_cmov_vbt_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_vbt_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_cmov_vbt_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_vbt_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_cmov_vbt_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_vbt_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_cmov_vbt_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_cmov_vbt_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_a_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_a_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_a_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_a_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_a_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_a_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_a_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_a_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_v0_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_v0_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_v0_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_v0_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_v0_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_v0_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_ar_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_ar_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_i_imm4_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_i_imm4_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_i_imm4_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_i_imm4_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_i_imm4_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_i_imm4_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_i_imm4_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_i_imm4_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_i_imm4_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_i_imm4_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_imm_movi_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 24) >> 24);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_imm_movi_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_imm_movi_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 20) >> 24);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_imm_movi_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_imm_movi_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_imm_movi_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_imm_movi_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_imm_movi_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_imm_movi_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 24) >> 24);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_imm_movi_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_imm_movi_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 16) >> 24);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_imm_movi_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_inst16b_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_inst16b_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_a_Slot_f3_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_a_Slot_f3_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16m_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16m_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16m_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16m_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16m_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16m_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16p_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16p_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16p_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16p_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_i16p_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i16p_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32m_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32m_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32m_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32m_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32m_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32m_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32p_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32p_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32p_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32p_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_i32p_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i32p_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 14) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0x3c000) | (tie_t << 14);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  tie_t = (tie_t << 2) | ((insn[0] << 14) >> 30);
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
  tie_t = (val << 28) >> 30;
  insn[0] = (insn[0] & ~0x30000) | (tie_t << 16);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64_Slot_f3_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64_Slot_f3_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64p_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64p_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64p_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64p_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64p_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64p_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_loads_stores_i64p_Slot_f3_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i64p_Slot_f3_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_i8_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i8_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_i8_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i8_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_i8_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i8_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 24) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_i8p_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i8p_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_i8p_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i8p_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_i8p_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_i8p_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_su_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_su_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_su_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_su_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_su_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_su_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_su_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_su_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_su_Slot_f3_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_su_Slot_f3_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_uu_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_uu_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_uu_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_uu_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_uu_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 18) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_uu_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_uu_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_uu_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_loads_stores_v_Slot_f3_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_v_Slot_f3_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_vu_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_vu_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_vu_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 26) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_vu_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x30) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_loads_stores_x_Slot_f3_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_loads_stores_x_Slot_f3_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_rur_wur_a_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_rur_wur_a_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_rur_wur_a_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_rur_wur_a_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_rur_wur_a_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_rur_wur_a_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_rur_wur_a_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_rur_wur_a_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_shift_a0_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_a0_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_shift_a0_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_a0_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_shift_a0_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_a0_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_shift_a0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_a0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_shift_d_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_shift_d_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_shift_d_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_shift_d_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 8) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_shift_d0_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d0_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_shift_d0_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d0_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_shift_d0_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d0_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_shift_d0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_d0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_spcvtlookup_arr_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spcvtlookup_arr_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spcvtlookup_arr_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spcvtlookup_arr_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_spcvtlookup_arr_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spcvtlookup_arr_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_spcvtlookup_art_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spcvtlookup_art_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_spcvtlookup_art_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spcvtlookup_art_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_spcvtlookup_art_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spcvtlookup_art_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_spcvtlookup_i_imm5_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 15) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spcvtlookup_i_imm5_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_spcvtlookup_i_imm5_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 15) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spcvtlookup_i_imm5_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_spcvtlookup_i_imm5_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 15) >> 27);
  return tie_t;
}

static void
Field_fld_ae_sem_spcvtlookup_i_imm5_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_spcvtlookup_i_imm5_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 11) >> 31);
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spcvtlookup_i_imm5_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
  tie_t = (val << 27) >> 31;
  insn[0] = (insn[0] & ~0x100000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_spcvtlookup_v_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spcvtlookup_v_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_spcvtlookup_v_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spcvtlookup_v_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_spcvtlookup_v_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spcvtlookup_v_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_spcvtlookup_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spcvtlookup_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_spcvtlookup_v0_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spcvtlookup_v0_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spcvtlookup_v0_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spcvtlookup_v0_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spcvtlookup_v0_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spcvtlookup_v0_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spcvtlookup_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spcvtlookup_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_vbool_arr_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_vbool_arr_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_vbool_arr_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_vbool_arr_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_vbool_arr_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_vbool_arr_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_vbool_art_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_vbool_art_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_vbool_art_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_vbool_art_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_vbool_art_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_vbool_art_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_vbool_art_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_vbool_art_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_vbool_i_imm3_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 28) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_vbool_i_imm3_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8) | (tie_t << 3);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_vbool_i_imm3_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_vbool_i_imm3_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_vbool_i_imm3_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 18) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_vbool_i_imm3_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x3800) | (tie_t << 11);
}

static unsigned
Field_fld_ae_sem_vbool_vbr_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_vbool_vbr_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_vbool_vbr_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 21) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_vbool_vbr_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_vbool_vbr_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_vbool_vbr_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_vbool_vbr_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 21) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_vbool_vbr_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_vbool_vbs_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 28) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_vbool_vbs_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8) | (tie_t << 3);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_vbool_vbs_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 20) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 30) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_vbool_vbs_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0x3) | (tie_t << 0);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x800) | (tie_t << 11);
}

static unsigned
Field_fld_ae_sem_vbool_vbs_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 22) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 28) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_vbool_vbs_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x8) | (tie_t << 3);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0x300) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_vbool_vbt_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 27) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_vbool_vbt_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x10) | (tie_t << 4);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_vbool_vbt_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 19) >> 31);
  tie_t = (tie_t << 2) | ((insn[0] << 28) >> 30);
  return tie_t;
}

static void
Field_fld_ae_sem_vbool_vbt_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 30) >> 30;
  insn[0] = (insn[0] & ~0xc) | (tie_t << 2);
  tie_t = (val << 29) >> 31;
  insn[0] = (insn[0] & ~0x1000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_vbool_vbt_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_vbool_vbt_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_vbool_vbt_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_vbool_vbt_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_vldc_loads_stores_done_Slot_f0_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 2) | ((insn[0] << 20) >> 30);
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_vldc_loads_stores_done_Slot_f0_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
  tie_t = (val << 29) >> 30;
  insn[0] = (insn[0] & ~0xc00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_vldc_loads_stores_done_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 19) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_vldc_loads_stores_done_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x1c00) | (tie_t << 10);
}

static unsigned
Field_fld_ae_sem_vldc_loads_stores_done_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_vldc_loads_stores_done_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_arithmetic_i_imm1_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_i_imm1_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_arithmetic_i_imm1_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 1) | ((insn[0] << 23) >> 31);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_i_imm1_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 31) >> 31;
  insn[0] = (insn[0] & ~0x100) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_arithmetic_v_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_arithmetic_v_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_arithmetic_v_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_arithmetic_v_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_arithmetic_v0_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v0_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_arithmetic_v0_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v0_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_arithmetic_v0_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v0_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_arithmetic_v0_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v0_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_arithmetic_v0_Slot_f3_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v0_Slot_f3_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_arithmetic_v1_Slot_f3_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_v1_Slot_f3_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_arithmetic_vbt_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 29) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_vbt_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_arithmetic_vbt_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_vbt_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_arithmetic_vbt_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_vbt_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_arithmetic_vbt_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_arithmetic_vbt_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_dr_to_dr_v1_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_dr_to_dr_v1_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_d0_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_d0_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_d0_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_d0_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_d1_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_d1_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_d1_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_d1_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_q0_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_q0_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_mul_x2_s1_q0_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_mul_x2_s1_q0_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_nn_act_q1_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_nn_act_q1_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_nn_act_q1_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_nn_act_q1_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_nn_act_v1_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_nn_act_v1_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_nn_act_v1_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_nn_act_v1_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_spfma_i_imm3_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 17) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_i_imm3_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x7000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_spfma_i_imm3_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 25) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_i_imm3_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x70) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_spfma_i_imm4_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_i_imm4_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_spfma_v_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_v_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spfma_v_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_v_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_spfma_v0_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 24) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_v0_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf0) | (tie_t << 4);
}

static unsigned
Field_fld_ae_sem_spfma_v0_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 28) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_v0_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_spfma_v1_Slot_f0_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_v1_Slot_f0_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_spfma_v1_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spfma_v1_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_spcvtlookup_v1_Slot_f1_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spcvtlookup_v1_Slot_f1_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_spcvtlookup_v1_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_spcvtlookup_v1_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_f1_s1_7_0_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 8) | ((insn[0] << 24) >> 24);
  return tie_t;
}

static void
Field_fld_f1_s1_7_0_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 24) >> 24;
  insn[0] = (insn[0] & ~0xff) | (tie_t << 0);
}

static unsigned
Field_fld_ae_sem_shift_sd_Slot_f1_s1_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_sd_Slot_f1_s1_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_shift_sd_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_sd_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_shift_sd_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_shift_sd_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_movstate1_v_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_movstate1_v_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_movstate1_v0_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_movstate1_v0_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_movstate2_v_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_movstate2_v_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_movstate2_v0_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_movstate2_v0_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_sb_loads_stores_ar_p_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_sb_loads_stores_ar_p_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_sb_loads_stores_ar_p_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 16) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_sb_loads_stores_ar_p_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf000) | (tie_t << 12);
}

static unsigned
Field_fld_ae_sem_sb_loads_stores_vbr_Slot_f2_s0_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 21) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_sb_loads_stores_vbr_Slot_f2_s0_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700) | (tie_t << 8);
}

static unsigned
Field_fld_ae_sem_sb_loads_stores_vbr_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 3) | ((insn[0] << 9) >> 29);
  return tie_t;
}

static void
Field_fld_ae_sem_sb_loads_stores_vbr_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 29) >> 29;
  insn[0] = (insn[0] & ~0x700000) | (tie_t << 20);
}

static unsigned
Field_fld_ae_sem_sb_loads_stores_ar_u_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 4) | ((insn[0] << 20) >> 28);
  return tie_t;
}

static void
Field_fld_ae_sem_sb_loads_stores_ar_u_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 28) >> 28;
  insn[0] = (insn[0] & ~0xf00) | (tie_t << 8);
}

static unsigned
Field_bitindex_Slot_inst_get (const xtensa_insnbuf insn)
{
  unsigned tie_t = 0;
  tie_t = (tie_t << 5) | ((insn[0] << 23) >> 27);
  return tie_t;
}

static void
Field_bitindex_Slot_inst_set (xtensa_insnbuf insn, uint32 val)
{
  uint32 tie_t;
  tie_t = (val << 27) >> 27;
  insn[0] = (insn[0] & ~0x1f0) | (tie_t << 4);
}

static void
Implicit_Field_set (xtensa_insnbuf insn ATTRIBUTE_UNUSED,
		    uint32 val ATTRIBUTE_UNUSED)
{
  /* Do nothing.  */
}

static unsigned
Implicit_Field_ar0_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 0;
}

static unsigned
Implicit_Field_ar4_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 4;
}

static unsigned
Implicit_Field_ar8_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 8;
}

static unsigned
Implicit_Field_ar12_get (const xtensa_insnbuf insn ATTRIBUTE_UNUSED)
{
  return 12;
}

enum xtensa_field_id {
  FIELD_t,
  FIELD_bbi4,
  FIELD_bbi,
  FIELD_imm12,
  FIELD_imm8,
  FIELD_s,
  FIELD_s8,
  FIELD_imms8,
  FIELD_imm12b,
  FIELD_imm16,
  FIELD_m,
  FIELD_n,
  FIELD_offset,
  FIELD_op0,
  FIELD_op1,
  FIELD_op2,
  FIELD_r,
  FIELD_r_disp,
  FIELD_r_3,
  FIELD_sa4,
  FIELD_sae4,
  FIELD_sae,
  FIELD_sal,
  FIELD_sargt,
  FIELD_sas4,
  FIELD_sas,
  FIELD_sr,
  FIELD_st,
  FIELD_thi3,
  FIELD_f_low_depbits,
  FIELD_f_lngth_depbits,
  FIELD_imm4,
  FIELD_mn,
  FIELD_i,
  FIELD_imm6lo,
  FIELD_imm6hi,
  FIELD_imm7lo,
  FIELD_imm7hi,
  FIELD_z,
  FIELD_imm6,
  FIELD_imm7,
  FIELD_xt_wbr15_imm,
  FIELD_xt_wloop_imm,
  FIELD_ae_fld_fhba4,
  FIELD_ae_fld_fhba4_2,
  FIELD_ae_fld_tp7,
  FIELD_ae_fld_osa16,
  FIELD_ae_fld_osa32,
  FIELD_ae_fld_osa64,
  FIELD_ae_fld_imm2,
  FIELD_ae_fld_selimm,
  FIELD_fld_stage3_ar_operand,
  FIELD_ae_fld_Inst16b_12,
  FIELD_ae_fld_Inst16b_15_13,
  FIELD_fld_F0_S0_11_0,
  FIELD_fld_F0_S0_11_2,
  FIELD_fld_F0_S0_11_4,
  FIELD_fld_F0_S0_11_8,
  FIELD_fld_F0_S0_13_12,
  FIELD_fld_F0_S0_22_0,
  FIELD_fld_F0_S0_22_10,
  FIELD_fld_F0_S0_22_12,
  FIELD_fld_F0_S0_22_13,
  FIELD_fld_F0_S0_22_14,
  FIELD_fld_F0_S0_22_16,
  FIELD_fld_F0_S0_22_17,
  FIELD_fld_F0_S0_22_18,
  FIELD_fld_F0_S0_22_20,
  FIELD_fld_F0_S0_22_4,
  FIELD_fld_F0_S0_22_8,
  FIELD_fld_F0_S0_3_0,
  FIELD_fld_F0_S0_3_2,
  FIELD_fld_F0_S0_3_3,
  FIELD_fld_F0_S0_7_4,
  FIELD_fld_F0_S0_7_5,
  FIELD_fld_F0_S0_9_3,
  FIELD_fld_F0_S0_9_5,
  FIELD_fld_F0_S0_9_9,
  FIELD_fld_ae_sem_ar_to_ar_arr,
  FIELD_fld_ae_sem_ar_to_ar_ars,
  FIELD_fld_ae_sem_ar_to_ar_art,
  FIELD_fld_ae_sem_ar_to_dr_a0,
  FIELD_fld_ae_sem_ar_to_dr_a1,
  FIELD_fld_ae_sem_ar_to_dr_v,
  FIELD_fld_ae_sem_cmov_arr,
  FIELD_fld_ae_sem_cmov_v,
  FIELD_fld_ae_sem_cmov_v0,
  FIELD_fld_ae_sem_cmov_vbr,
  FIELD_fld_ae_sem_cmov_vbt,
  FIELD_fld_ae_sem_dr_to_ar_a,
  FIELD_fld_ae_sem_dr_to_ar_v0,
  FIELD_fld_ae_sem_dr_to_dr_i_imm4,
  FIELD_fld_ae_sem_dr_to_dr_imm_movi,
  FIELD_fld_ae_sem_dr_to_dr_v,
  FIELD_fld_ae_sem_dr_to_dr_v0,
  FIELD_fld_ae_sem_loads_stores_a,
  FIELD_fld_ae_sem_loads_stores_i16,
  FIELD_fld_ae_sem_loads_stores_i16m,
  FIELD_fld_ae_sem_loads_stores_i16p,
  FIELD_fld_ae_sem_loads_stores_i32,
  FIELD_fld_ae_sem_loads_stores_i32m,
  FIELD_fld_ae_sem_loads_stores_i32p,
  FIELD_fld_ae_sem_loads_stores_i64,
  FIELD_fld_ae_sem_loads_stores_i64p,
  FIELD_fld_ae_sem_loads_stores_i8,
  FIELD_fld_ae_sem_loads_stores_i8p,
  FIELD_fld_ae_sem_loads_stores_su,
  FIELD_fld_ae_sem_loads_stores_uu,
  FIELD_fld_ae_sem_loads_stores_v,
  FIELD_fld_ae_sem_loads_stores_vu,
  FIELD_fld_ae_sem_loads_stores_x,
  FIELD_fld_ae_sem_rur_wur_a,
  FIELD_fld_ae_sem_shift_a0,
  FIELD_fld_ae_sem_shift_d,
  FIELD_fld_ae_sem_shift_d0,
  FIELD_fld_ae_sem_spcvtlookup_arr,
  FIELD_fld_ae_sem_spcvtlookup_art,
  FIELD_fld_ae_sem_spcvtlookup_i_imm5,
  FIELD_fld_ae_sem_spcvtlookup_v,
  FIELD_fld_ae_sem_spcvtlookup_v0,
  FIELD_fld_ae_sem_vbool_arr,
  FIELD_fld_ae_sem_vbool_art,
  FIELD_fld_ae_sem_vbool_i_imm3,
  FIELD_fld_ae_sem_vbool_vbr,
  FIELD_fld_ae_sem_vbool_vbs,
  FIELD_fld_ae_sem_vbool_vbt,
  FIELD_fld_ae_sem_vldc_loads_stores_done,
  FIELD_fld_F0_S1_20_0,
  FIELD_fld_F0_S1_20_10,
  FIELD_fld_F0_S1_20_12,
  FIELD_fld_F0_S1_20_13,
  FIELD_fld_F0_S1_20_15,
  FIELD_fld_F0_S1_20_16,
  FIELD_fld_F0_S1_20_17,
  FIELD_fld_F0_S1_20_7,
  FIELD_fld_F0_S1_20_8,
  FIELD_fld_F0_S1_20_9,
  FIELD_fld_F0_S1_3_0,
  FIELD_fld_F0_S1_3_3,
  FIELD_fld_F0_S1_7_4,
  FIELD_fld_ae_sem_arithmetic_i_imm1,
  FIELD_fld_ae_sem_arithmetic_v,
  FIELD_fld_ae_sem_arithmetic_v0,
  FIELD_fld_ae_sem_arithmetic_v1,
  FIELD_fld_ae_sem_arithmetic_vbt,
  FIELD_fld_ae_sem_dr_to_dr_v1,
  FIELD_fld_ae_sem_mul_x2_S1_d0,
  FIELD_fld_ae_sem_mul_x2_S1_d1,
  FIELD_fld_ae_sem_mul_x2_S1_q0,
  FIELD_fld_ae_sem_nn_act_q1,
  FIELD_fld_ae_sem_nn_act_v1,
  FIELD_fld_ae_sem_spfma_i_imm3,
  FIELD_fld_ae_sem_spfma_i_imm4,
  FIELD_fld_ae_sem_spfma_v,
  FIELD_fld_ae_sem_spfma_v0,
  FIELD_fld_ae_sem_spfma_v1,
  FIELD_fld_F1_S0_11_11,
  FIELD_fld_F1_S0_11_7,
  FIELD_fld_F1_S0_11_8,
  FIELD_fld_F1_S0_13_12,
  FIELD_fld_F1_S0_1_0,
  FIELD_fld_F1_S0_21_0,
  FIELD_fld_F1_S0_21_10,
  FIELD_fld_F1_S0_21_11,
  FIELD_fld_F1_S0_21_12,
  FIELD_fld_F1_S0_21_13,
  FIELD_fld_F1_S0_21_14,
  FIELD_fld_F1_S0_21_16,
  FIELD_fld_F1_S0_21_17,
  FIELD_fld_F1_S0_21_18,
  FIELD_fld_F1_S0_21_8,
  FIELD_fld_F1_S0_21_9,
  FIELD_fld_F1_S0_3_0,
  FIELD_fld_F1_S0_3_2,
  FIELD_fld_F1_S0_7_4,
  FIELD_fld_F1_S0_7_7,
  FIELD_fld_ae_sem_spcvtlookup_v1,
  FIELD_fld_F1_S1_11_3,
  FIELD_fld_F1_S1_11_4,
  FIELD_fld_F1_S1_11_8,
  FIELD_fld_F1_S1_20_0,
  FIELD_fld_F1_S1_20_12,
  FIELD_fld_F1_S1_20_15,
  FIELD_fld_F1_S1_20_16,
  FIELD_fld_F1_S1_7_0,
  FIELD_fld_F1_S1_7_4,
  FIELD_fld_F1_S1_7_5,
  FIELD_fld_F1_S1_7_6,
  FIELD_fld_F1_S1_7_7,
  FIELD_fld_ae_sem_shift_sd,
  FIELD_fld_F2_S0_10_8,
  FIELD_fld_F2_S0_11_4,
  FIELD_fld_F2_S0_11_8,
  FIELD_fld_F2_S0_33_10,
  FIELD_fld_F2_S0_33_12,
  FIELD_fld_F2_S0_33_13,
  FIELD_fld_F2_S0_33_14,
  FIELD_fld_F2_S0_33_15,
  FIELD_fld_F2_S0_33_16,
  FIELD_fld_F2_S0_33_17,
  FIELD_fld_F2_S0_33_19,
  FIELD_fld_F2_S0_33_23,
  FIELD_fld_F2_S0_33_24,
  FIELD_fld_F2_S0_33_9,
  FIELD_fld_F2_S0_3_0,
  FIELD_fld_F2_S0_3_3,
  FIELD_fld_F2_S0_7_0,
  FIELD_fld_F2_S0_7_4,
  FIELD_fld_F2_S0_7_5,
  FIELD_fld_F2_S0_7_7,
  FIELD_fld_F2_S0_8_0,
  FIELD_fld_F2_S0_8_8,
  FIELD_fld_F2_S0_9_3,
  FIELD_fld_F2_S0_9_7,
  FIELD_fld_F2_S0_9_8,
  FIELD_fld_ae_sem_movstate1_v,
  FIELD_fld_ae_sem_movstate1_v0,
  FIELD_fld_ae_sem_movstate2_v,
  FIELD_fld_ae_sem_movstate2_v0,
  FIELD_fld_ae_sem_sb_loads_stores_ar_p,
  FIELD_fld_ae_sem_sb_loads_stores_vbr,
  FIELD_fld_Inst_11_10,
  FIELD_fld_Inst_11_8,
  FIELD_fld_Inst_15_12,
  FIELD_fld_Inst_19_12,
  FIELD_fld_Inst_19_16,
  FIELD_fld_Inst_19_17,
  FIELD_fld_Inst_19_18,
  FIELD_fld_Inst_19_8,
  FIELD_fld_Inst_23_10,
  FIELD_fld_Inst_23_11,
  FIELD_fld_Inst_23_12,
  FIELD_fld_Inst_23_14,
  FIELD_fld_Inst_23_15,
  FIELD_fld_Inst_23_16,
  FIELD_fld_Inst_23_20,
  FIELD_fld_Inst_23_21,
  FIELD_fld_Inst_23_23,
  FIELD_fld_Inst_23_8,
  FIELD_fld_Inst_3_0,
  FIELD_fld_Inst_7_0,
  FIELD_fld_Inst_7_6,
  FIELD_fld_Inst_7_7,
  FIELD_fld_Inst_9_8,
  FIELD_fld_ae_sem_sb_loads_stores_ar_u,
  FIELD_fld_F3_S0_21_0,
  FIELD_fld_F3_S0_21_12,
  FIELD_fld_F3_S0_21_13,
  FIELD_fld_F3_S0_21_16,
  FIELD_fld_F3_S0_21_19,
  FIELD_fld_F3_S0_3_2,
  FIELD_fld_F3_S1_10_0,
  FIELD_fld_F3_S1_10_8,
  FIELD_bitindex,
  FIELD_s3to1,
  FIELD__ar0,
  FIELD__ar4,
  FIELD__ar8,
  FIELD__ar12
};


/* Functional units.  */

static xtensa_funcUnit_internal funcUnits[] = {
  {"XT_LOADSTORE_UNIT", 1},
  { "ae_mulpp33x24_1", 1 },
  { "ae_mulpp33x24_2", 1 }
};

enum xtensa_funcUnit_id {
  FUNCUNIT_XT_LOADSTORE_UNIT,
  FUNCUNIT_ae_mulpp33x24_1,
  FUNCUNIT_ae_mulpp33x24_2
};


/* Register files.  */

enum xtensa_regfile_id {
  REGFILE_AR,
  REGFILE_AE_DR,
  REGFILE_AE_VALIGN,
  REGFILE_vbool
};

static xtensa_regfile_internal regfiles[] = {
  { "AR", "a", REGFILE_AR, 32, 32 },
  { "AE_DR", "aed", REGFILE_AE_DR, 64, 16 },
  { "AE_VALIGN", "u", REGFILE_AE_VALIGN, 64, 4 },
  { "vbool", "vb", REGFILE_vbool, 8, 8 }
};


/* Interfaces.  */

static xtensa_interface_internal interfaces[] = {
  { "IMPWIRE", 32, 0, 0, 'i' },
  { "ERI_RD_Rdy", 1, 0, 1, 'i' },
  { "ERI_RD_Out", 14, 0, 1, 'o' },
  { "ERI_RD_In", 32, 0, 2, 'i' },
  { "ERI_WR_Out", 46, 0, 3, 'o' },
  { "ERI_WR_In", 1, 0, 4, 'i' }
};

enum xtensa_interface_id {
  INTERFACE_IMPWIRE,
  INTERFACE_ERI_RD_Rdy,
  INTERFACE_ERI_RD_Out,
  INTERFACE_ERI_RD_In,
  INTERFACE_ERI_WR_Out,
  INTERFACE_ERI_WR_In
};


/* Constant tables.  */

/* constant table ai4c */
static const unsigned CONST_TBL_ai4c_0[] = {
  0xffffffff,
  0x1,
  0x2,
  0x3,
  0x4,
  0x5,
  0x6,
  0x7,
  0x8,
  0x9,
  0xa,
  0xb,
  0xc,
  0xd,
  0xe,
  0xf,
  0
};

/* constant table b4c */
static const unsigned CONST_TBL_b4c_0[] = {
  0xffffffff,
  0x1,
  0x2,
  0x3,
  0x4,
  0x5,
  0x6,
  0x7,
  0x8,
  0xa,
  0xc,
  0x10,
  0x20,
  0x40,
  0x80,
  0x100,
  0
};

/* constant table b4cu */
static const unsigned CONST_TBL_b4cu_0[] = {
  0x8000,
  0x10000,
  0x2,
  0x3,
  0x4,
  0x5,
  0x6,
  0x7,
  0x8,
  0xa,
  0xc,
  0x10,
  0x20,
  0x40,
  0x80,
  0x100,
  0
};

/* constant table bitmask8 */
static const unsigned CONST_TBL_bitmask8_0[] = {
  0 & 0xff,
  0x1 & 0xff,
  0x3 & 0xff,
  0x7 & 0xff,
  0xf & 0xff,
  0x1f & 0xff,
  0x3f & 0xff,
  0x7f & 0xff,
  0
};

/* constant table ae_ltr4_table */
static const unsigned CONST_TBL_ae_ltr4_table_0[] = {
  0 & 0xff,
  0xc0 & 0xff,
  0xf0 & 0xff,
  0xfc & 0xff,
  0
};

/* constant table ae_seliencode */
static const unsigned CONST_TBL_ae_seliencode_0[] = {
  0x4e5 & 0xfff,
  0x65 & 0xfff,
  0x77 & 0xfff,
  0x4f7 & 0xfff,
  0x72e & 0xfff,
  0x29c & 0xfff,
  0xaf & 0xfff,
  0xa6 & 0xfff,
  0x2ef & 0xfff,
  0x10d & 0xfff,
  0x2ae & 0xfff,
  0x59f & 0xfff,
  0xb3e & 0xfff,
  0x18f & 0xfff,
  0x51d & 0xfff,
  0x116 & 0xfff,
  0
};

/* constant table RECIP_Data8 */
static const unsigned CONST_TBL_RECIP_Data8_0[] = {
  0xff & 0xff,
  0xfd & 0xff,
  0xfb & 0xff,
  0xf9 & 0xff,
  0xf7 & 0xff,
  0xf5 & 0xff,
  0xf4 & 0xff,
  0xf2 & 0xff,
  0xf0 & 0xff,
  0xee & 0xff,
  0xed & 0xff,
  0xeb & 0xff,
  0xe9 & 0xff,
  0xe8 & 0xff,
  0xe6 & 0xff,
  0xe4 & 0xff,
  0xe3 & 0xff,
  0xe1 & 0xff,
  0xe0 & 0xff,
  0xde & 0xff,
  0xdd & 0xff,
  0xdb & 0xff,
  0xda & 0xff,
  0xd8 & 0xff,
  0xd7 & 0xff,
  0xd5 & 0xff,
  0xd4 & 0xff,
  0xd3 & 0xff,
  0xd1 & 0xff,
  0xd0 & 0xff,
  0xcf & 0xff,
  0xcd & 0xff,
  0xcc & 0xff,
  0xcb & 0xff,
  0xca & 0xff,
  0xc8 & 0xff,
  0xc7 & 0xff,
  0xc6 & 0xff,
  0xc5 & 0xff,
  0xc4 & 0xff,
  0xc2 & 0xff,
  0xc1 & 0xff,
  0xc0 & 0xff,
  0xbf & 0xff,
  0xbe & 0xff,
  0xbd & 0xff,
  0xbc & 0xff,
  0xbb & 0xff,
  0xba & 0xff,
  0xb9 & 0xff,
  0xb8 & 0xff,
  0xb7 & 0xff,
  0xb6 & 0xff,
  0xb5 & 0xff,
  0xb4 & 0xff,
  0xb3 & 0xff,
  0xb2 & 0xff,
  0xb1 & 0xff,
  0xb0 & 0xff,
  0xaf & 0xff,
  0xae & 0xff,
  0xad & 0xff,
  0xac & 0xff,
  0xab & 0xff,
  0xaa & 0xff,
  0xa9 & 0xff,
  0xa8 & 0xff,
  0xa8 & 0xff,
  0xa7 & 0xff,
  0xa6 & 0xff,
  0xa5 & 0xff,
  0xa4 & 0xff,
  0xa3 & 0xff,
  0xa3 & 0xff,
  0xa2 & 0xff,
  0xa1 & 0xff,
  0xa0 & 0xff,
  0x9f & 0xff,
  0x9f & 0xff,
  0x9e & 0xff,
  0x9d & 0xff,
  0x9c & 0xff,
  0x9c & 0xff,
  0x9b & 0xff,
  0x9a & 0xff,
  0x99 & 0xff,
  0x99 & 0xff,
  0x98 & 0xff,
  0x97 & 0xff,
  0x97 & 0xff,
  0x96 & 0xff,
  0x95 & 0xff,
  0x95 & 0xff,
  0x94 & 0xff,
  0x93 & 0xff,
  0x93 & 0xff,
  0x92 & 0xff,
  0x91 & 0xff,
  0x91 & 0xff,
  0x90 & 0xff,
  0x8f & 0xff,
  0x8f & 0xff,
  0x8e & 0xff,
  0x8e & 0xff,
  0x8d & 0xff,
  0x8c & 0xff,
  0x8c & 0xff,
  0x8b & 0xff,
  0x8b & 0xff,
  0x8a & 0xff,
  0x89 & 0xff,
  0x89 & 0xff,
  0x88 & 0xff,
  0x88 & 0xff,
  0x87 & 0xff,
  0x87 & 0xff,
  0x86 & 0xff,
  0x85 & 0xff,
  0x85 & 0xff,
  0x84 & 0xff,
  0x84 & 0xff,
  0x83 & 0xff,
  0x83 & 0xff,
  0x82 & 0xff,
  0x82 & 0xff,
  0x81 & 0xff,
  0x81 & 0xff,
  0x81 & 0xff,
  0
};

/* constant table RSQRT_Data8 */
static const unsigned CONST_TBL_RSQRT_Data8_0[] = {
  0xb4 & 0xff,
  0xb3 & 0xff,
  0xb2 & 0xff,
  0xb0 & 0xff,
  0xaf & 0xff,
  0xae & 0xff,
  0xac & 0xff,
  0xab & 0xff,
  0xaa & 0xff,
  0xa9 & 0xff,
  0xa8 & 0xff,
  0xa7 & 0xff,
  0xa6 & 0xff,
  0xa5 & 0xff,
  0xa3 & 0xff,
  0xa2 & 0xff,
  0xa1 & 0xff,
  0xa0 & 0xff,
  0x9f & 0xff,
  0x9e & 0xff,
  0x9e & 0xff,
  0x9d & 0xff,
  0x9c & 0xff,
  0x9b & 0xff,
  0x9a & 0xff,
  0x99 & 0xff,
  0x98 & 0xff,
  0x97 & 0xff,
  0x97 & 0xff,
  0x96 & 0xff,
  0x95 & 0xff,
  0x94 & 0xff,
  0x93 & 0xff,
  0x93 & 0xff,
  0x92 & 0xff,
  0x91 & 0xff,
  0x90 & 0xff,
  0x90 & 0xff,
  0x8f & 0xff,
  0x8e & 0xff,
  0x8e & 0xff,
  0x8d & 0xff,
  0x8c & 0xff,
  0x8c & 0xff,
  0x8b & 0xff,
  0x8a & 0xff,
  0x8a & 0xff,
  0x89 & 0xff,
  0x89 & 0xff,
  0x88 & 0xff,
  0x87 & 0xff,
  0x87 & 0xff,
  0x86 & 0xff,
  0x86 & 0xff,
  0x85 & 0xff,
  0x84 & 0xff,
  0x84 & 0xff,
  0x83 & 0xff,
  0x83 & 0xff,
  0x82 & 0xff,
  0x82 & 0xff,
  0x81 & 0xff,
  0x81 & 0xff,
  0x80 & 0xff,
  0xff & 0xff,
  0xfd & 0xff,
  0xfb & 0xff,
  0xf9 & 0xff,
  0xf7 & 0xff,
  0xf6 & 0xff,
  0xf4 & 0xff,
  0xf2 & 0xff,
  0xf1 & 0xff,
  0xef & 0xff,
  0xed & 0xff,
  0xec & 0xff,
  0xea & 0xff,
  0xe9 & 0xff,
  0xe7 & 0xff,
  0xe6 & 0xff,
  0xe4 & 0xff,
  0xe3 & 0xff,
  0xe1 & 0xff,
  0xe0 & 0xff,
  0xdf & 0xff,
  0xdd & 0xff,
  0xdc & 0xff,
  0xdb & 0xff,
  0xda & 0xff,
  0xd8 & 0xff,
  0xd7 & 0xff,
  0xd6 & 0xff,
  0xd5 & 0xff,
  0xd4 & 0xff,
  0xd3 & 0xff,
  0xd2 & 0xff,
  0xd0 & 0xff,
  0xcf & 0xff,
  0xce & 0xff,
  0xcd & 0xff,
  0xcc & 0xff,
  0xcb & 0xff,
  0xca & 0xff,
  0xc9 & 0xff,
  0xc8 & 0xff,
  0xc7 & 0xff,
  0xc6 & 0xff,
  0xc6 & 0xff,
  0xc5 & 0xff,
  0xc4 & 0xff,
  0xc3 & 0xff,
  0xc2 & 0xff,
  0xc1 & 0xff,
  0xc0 & 0xff,
  0xbf & 0xff,
  0xbf & 0xff,
  0xbe & 0xff,
  0xbd & 0xff,
  0xbc & 0xff,
  0xbb & 0xff,
  0xbb & 0xff,
  0xba & 0xff,
  0xb9 & 0xff,
  0xb8 & 0xff,
  0xb8 & 0xff,
  0xb7 & 0xff,
  0xb6 & 0xff,
  0xb5 & 0xff,
  0
};

/* constant table vfpu2_table_mulmux */
static const unsigned CONST_TBL_vfpu2_table_mulmux_0[] = {
  0xe & 0x3f,
  0x1e & 0x3f,
  0x12 & 0x3f,
  0xd & 0x3f,
  0xf & 0x3f,
  0 & 0x3f,
  0 & 0x3f,
  0 & 0x3f,
  0
};

/* constant table vfpu2_table_maddmux */
static const unsigned CONST_TBL_vfpu2_table_maddmux_0[] = {
  0xe & 0x3f,
  0x21 & 0x3f,
  0x3e & 0x3f,
  0x11 & 0x3f,
  0x1e & 0x3f,
  0x1 & 0x3f,
  0x2e & 0x3f,
  0x31 & 0x3f,
  0x12 & 0x3f,
  0xd & 0x3f,
  0xf & 0x3f,
  0 & 0x3f,
  0 & 0x3f,
  0 & 0x3f,
  0 & 0x3f,
  0 & 0x3f,
  0
};

/* constant table xd_recip0_table128_8 */
static const unsigned CONST_TBL_xd_recip0_table128_8_0[] = {
  0xff & 0xff,
  0xfd & 0xff,
  0xfb & 0xff,
  0xf9 & 0xff,
  0xf7 & 0xff,
  0xf5 & 0xff,
  0xf4 & 0xff,
  0xf2 & 0xff,
  0xf0 & 0xff,
  0xee & 0xff,
  0xed & 0xff,
  0xeb & 0xff,
  0xe9 & 0xff,
  0xe8 & 0xff,
  0xe6 & 0xff,
  0xe4 & 0xff,
  0xe3 & 0xff,
  0xe1 & 0xff,
  0xe0 & 0xff,
  0xde & 0xff,
  0xdd & 0xff,
  0xdb & 0xff,
  0xda & 0xff,
  0xd8 & 0xff,
  0xd7 & 0xff,
  0xd5 & 0xff,
  0xd4 & 0xff,
  0xd3 & 0xff,
  0xd1 & 0xff,
  0xd0 & 0xff,
  0xcf & 0xff,
  0xcd & 0xff,
  0xcc & 0xff,
  0xcb & 0xff,
  0xca & 0xff,
  0xc8 & 0xff,
  0xc7 & 0xff,
  0xc6 & 0xff,
  0xc5 & 0xff,
  0xc4 & 0xff,
  0xc2 & 0xff,
  0xc1 & 0xff,
  0xc0 & 0xff,
  0xbf & 0xff,
  0xbe & 0xff,
  0xbd & 0xff,
  0xbc & 0xff,
  0xbb & 0xff,
  0xba & 0xff,
  0xb9 & 0xff,
  0xb8 & 0xff,
  0xb7 & 0xff,
  0xb6 & 0xff,
  0xb5 & 0xff,
  0xb4 & 0xff,
  0xb3 & 0xff,
  0xb2 & 0xff,
  0xb1 & 0xff,
  0xb0 & 0xff,
  0xaf & 0xff,
  0xae & 0xff,
  0xad & 0xff,
  0xac & 0xff,
  0xab & 0xff,
  0xaa & 0xff,
  0xa9 & 0xff,
  0xa8 & 0xff,
  0xa8 & 0xff,
  0xa7 & 0xff,
  0xa6 & 0xff,
  0xa5 & 0xff,
  0xa4 & 0xff,
  0xa3 & 0xff,
  0xa3 & 0xff,
  0xa2 & 0xff,
  0xa1 & 0xff,
  0xa0 & 0xff,
  0x9f & 0xff,
  0x9f & 0xff,
  0x9e & 0xff,
  0x9d & 0xff,
  0x9c & 0xff,
  0x9c & 0xff,
  0x9b & 0xff,
  0x9a & 0xff,
  0x99 & 0xff,
  0x99 & 0xff,
  0x98 & 0xff,
  0x97 & 0xff,
  0x97 & 0xff,
  0x96 & 0xff,
  0x95 & 0xff,
  0x95 & 0xff,
  0x94 & 0xff,
  0x93 & 0xff,
  0x93 & 0xff,
  0x92 & 0xff,
  0x91 & 0xff,
  0x91 & 0xff,
  0x90 & 0xff,
  0x8f & 0xff,
  0x8f & 0xff,
  0x8e & 0xff,
  0x8e & 0xff,
  0x8d & 0xff,
  0x8c & 0xff,
  0x8c & 0xff,
  0x8b & 0xff,
  0x8b & 0xff,
  0x8a & 0xff,
  0x89 & 0xff,
  0x89 & 0xff,
  0x88 & 0xff,
  0x88 & 0xff,
  0x87 & 0xff,
  0x87 & 0xff,
  0x86 & 0xff,
  0x85 & 0xff,
  0x85 & 0xff,
  0x84 & 0xff,
  0x84 & 0xff,
  0x83 & 0xff,
  0x83 & 0xff,
  0x82 & 0xff,
  0x82 & 0xff,
  0x81 & 0xff,
  0x81 & 0xff,
  0x81 & 0xff,
  0
};

/* constant table xd_rsqrt0_table128_8 */
static const unsigned CONST_TBL_xd_rsqrt0_table128_8_0[] = {
  0xb4 & 0xff,
  0xb3 & 0xff,
  0xb2 & 0xff,
  0xb0 & 0xff,
  0xaf & 0xff,
  0xae & 0xff,
  0xac & 0xff,
  0xab & 0xff,
  0xaa & 0xff,
  0xa9 & 0xff,
  0xa8 & 0xff,
  0xa7 & 0xff,
  0xa6 & 0xff,
  0xa5 & 0xff,
  0xa3 & 0xff,
  0xa2 & 0xff,
  0xa1 & 0xff,
  0xa0 & 0xff,
  0x9f & 0xff,
  0x9e & 0xff,
  0x9e & 0xff,
  0x9d & 0xff,
  0x9c & 0xff,
  0x9b & 0xff,
  0x9a & 0xff,
  0x99 & 0xff,
  0x98 & 0xff,
  0x97 & 0xff,
  0x97 & 0xff,
  0x96 & 0xff,
  0x95 & 0xff,
  0x94 & 0xff,
  0x93 & 0xff,
  0x93 & 0xff,
  0x92 & 0xff,
  0x91 & 0xff,
  0x90 & 0xff,
  0x90 & 0xff,
  0x8f & 0xff,
  0x8e & 0xff,
  0x8e & 0xff,
  0x8d & 0xff,
  0x8c & 0xff,
  0x8c & 0xff,
  0x8b & 0xff,
  0x8a & 0xff,
  0x8a & 0xff,
  0x89 & 0xff,
  0x89 & 0xff,
  0x88 & 0xff,
  0x87 & 0xff,
  0x87 & 0xff,
  0x86 & 0xff,
  0x86 & 0xff,
  0x85 & 0xff,
  0x84 & 0xff,
  0x84 & 0xff,
  0x83 & 0xff,
  0x83 & 0xff,
  0x82 & 0xff,
  0x82 & 0xff,
  0x81 & 0xff,
  0x81 & 0xff,
  0x80 & 0xff,
  0xff & 0xff,
  0xfd & 0xff,
  0xfb & 0xff,
  0xf9 & 0xff,
  0xf7 & 0xff,
  0xf6 & 0xff,
  0xf4 & 0xff,
  0xf2 & 0xff,
  0xf1 & 0xff,
  0xef & 0xff,
  0xed & 0xff,
  0xec & 0xff,
  0xea & 0xff,
  0xe9 & 0xff,
  0xe7 & 0xff,
  0xe6 & 0xff,
  0xe4 & 0xff,
  0xe3 & 0xff,
  0xe1 & 0xff,
  0xe0 & 0xff,
  0xdf & 0xff,
  0xdd & 0xff,
  0xdc & 0xff,
  0xdb & 0xff,
  0xda & 0xff,
  0xd8 & 0xff,
  0xd7 & 0xff,
  0xd6 & 0xff,
  0xd5 & 0xff,
  0xd4 & 0xff,
  0xd3 & 0xff,
  0xd2 & 0xff,
  0xd0 & 0xff,
  0xcf & 0xff,
  0xce & 0xff,
  0xcd & 0xff,
  0xcc & 0xff,
  0xcb & 0xff,
  0xca & 0xff,
  0xc9 & 0xff,
  0xc8 & 0xff,
  0xc7 & 0xff,
  0xc6 & 0xff,
  0xc6 & 0xff,
  0xc5 & 0xff,
  0xc4 & 0xff,
  0xc3 & 0xff,
  0xc2 & 0xff,
  0xc1 & 0xff,
  0xc0 & 0xff,
  0xbf & 0xff,
  0xbf & 0xff,
  0xbe & 0xff,
  0xbd & 0xff,
  0xbc & 0xff,
  0xbb & 0xff,
  0xbb & 0xff,
  0xba & 0xff,
  0xb9 & 0xff,
  0xb8 & 0xff,
  0xb8 & 0xff,
  0xb7 & 0xff,
  0xb6 & 0xff,
  0xb5 & 0xff,
  0
};

/* constant table xdsem_tab_la */
static const unsigned CONST_TBL_xdsem_tab_la_0[] = {
  0xff & 0xff,
  0xfe & 0xff,
  0xfc & 0xff,
  0xf8 & 0xff,
  0xf0 & 0xff,
  0xe0 & 0xff,
  0xc0 & 0xff,
  0x80 & 0xff,
  0
};

/* constant table xdsem_tab_ld_r8_m32 */
static const unsigned CONST_TBL_xdsem_tab_ld_r8_m32_0[] = {
  0x10 & 0xff,
  0x10 & 0xff,
  0x10 & 0xff,
  0x10 & 0xff,
  0x10 & 0xff,
  0x10 & 0xff,
  0x10 & 0xff,
  0x10 & 0xff,
  0
};

/* constant table xdsem_tab_ld_r8_m16 */
static const unsigned CONST_TBL_xdsem_tab_ld_r8_m16_0[] = {
  0x44 & 0xff,
  0x44 & 0xff,
  0x44 & 0xff,
  0x44 & 0xff,
  0x44 & 0xff,
  0x44 & 0xff,
  0x44 & 0xff,
  0x44 & 0xff,
  0
};

/* constant table xdsem_tab_ld_r8_m8 */
static const unsigned CONST_TBL_xdsem_tab_ld_r8_m8_0[] = {
  0xaa & 0xff,
  0xaa & 0xff,
  0xaa & 0xff,
  0xaa & 0xff,
  0xaa & 0xff,
  0xaa & 0xff,
  0xaa & 0xff,
  0xaa & 0xff,
  0
};

/* constant table xdsem_tab_ld_r16_m32 */
static const unsigned CONST_TBL_xdsem_tab_ld_r16_m32_0[] = {
  0x30 & 0xff,
  0x30 & 0xff,
  0x30 & 0xff,
  0x30 & 0xff,
  0x30 & 0xff,
  0x30 & 0xff,
  0x30 & 0xff,
  0x30 & 0xff,
  0
};

/* constant table xdsem_tab_ld_r16_m16 */
static const unsigned CONST_TBL_xdsem_tab_ld_r16_m16_0[] = {
  0xcc & 0xff,
  0xcc & 0xff,
  0xcc & 0xff,
  0xcc & 0xff,
  0xcc & 0xff,
  0xcc & 0xff,
  0xcc & 0xff,
  0xcc & 0xff,
  0
};

/* constant table xdsem_tab_ld_r16_m8 */
static const unsigned CONST_TBL_xdsem_tab_ld_r16_m8_0[] = {
  0 & 0xff,
  0 & 0xff,
  0 & 0xff,
  0 & 0xff,
  0 & 0xff,
  0 & 0xff,
  0 & 0xff,
  0 & 0xff,
  0
};

/* constant table xdsem_tab_ld_r32_m32 */
static const unsigned CONST_TBL_xdsem_tab_ld_r32_m32_0[] = {
  0xf0 & 0xff,
  0xf0 & 0xff,
  0xf0 & 0xff,
  0xf0 & 0xff,
  0xf0 & 0xff,
  0xf0 & 0xff,
  0xf0 & 0xff,
  0xf0 & 0xff,
  0
};

/* constant table xdsem_tab_ld_shiftrot_m32 */
static const unsigned CONST_TBL_xdsem_tab_ld_shiftrot_m32_0[] = {
  0 & 0xff,
  0x11 & 0xff,
  0x33 & 0xff,
  0x77 & 0xff,
  0xff & 0xff,
  0xee & 0xff,
  0xcc & 0xff,
  0x88 & 0xff,
  0
};

/* constant table xdsem_tab_ld_shiftrot_m16 */
static const unsigned CONST_TBL_xdsem_tab_ld_shiftrot_m16_0[] = {
  0 & 0xff,
  0x55 & 0xff,
  0xff & 0xff,
  0xaa & 0xff,
  0 & 0xff,
  0x55 & 0xff,
  0xff & 0xff,
  0xaa & 0xff,
  0
};

/* constant table xdsem_tab_ld_shiftrot_m8 */
static const unsigned CONST_TBL_xdsem_tab_ld_shiftrot_m8_0[] = {
  0 & 0xff,
  0xff & 0xff,
  0 & 0xff,
  0xff & 0xff,
  0 & 0xff,
  0xff & 0xff,
  0 & 0xff,
  0xff & 0xff,
  0
};

/* constant table xdsem_tab_ld_exp8to16_m32 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp8to16_m32_0[] = {
  0x30 & 0xff,
  0x61 & 0xff,
  0xc3 & 0xff,
  0x86 & 0xff,
  0xc & 0xff,
  0x8 & 0xff,
  0 & 0xff,
  0x10 & 0xff,
  0
};

/* constant table xdsem_tab_ld_exp8to16_m16 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp8to16_m16_0[] = {
  0x42 & 0xff,
  0x90 & 0xff,
  0x24 & 0xff,
  0x9 & 0xff,
  0x42 & 0xff,
  0x90 & 0xff,
  0x24 & 0xff,
  0x9 & 0xff,
  0
};

/* constant table xdsem_tab_ld_exp8to16_m8 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp8to16_m8_0[] = {
  0x99 & 0xff,
  0x66 & 0xff,
  0x99 & 0xff,
  0x66 & 0xff,
  0x99 & 0xff,
  0x66 & 0xff,
  0x99 & 0xff,
  0x66 & 0xff,
  0
};

/* constant table xdsem_tab_ld_exp16to32_m32 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp16to32_m32_0[] = {
  0xc0 & 0xff,
  0x80 & 0xff,
  0 & 0xff,
  0x1 & 0xff,
  0x3 & 0xff,
  0x16 & 0xff,
  0x3c & 0xff,
  0x68 & 0xff,
  0
};

/* constant table xdsem_tab_ld_exp16to32_m16 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp16to32_m16_0[] = {
  0x38 & 0xff,
  0x61 & 0xff,
  0x83 & 0xff,
  0x16 & 0xff,
  0x38 & 0xff,
  0x61 & 0xff,
  0x83 & 0xff,
  0x16 & 0xff,
  0
};

/* constant table xdsem_tab_ld_exp16to32_m8 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp16to32_m8_0[] = {
  0x44 & 0xff,
  0xbb & 0xff,
  0x44 & 0xff,
  0xbb & 0xff,
  0x44 & 0xff,
  0xbb & 0xff,
  0x44 & 0xff,
  0xbb & 0xff,
  0
};

/* constant table xdsem_tab_ld_exp8to32_m32 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp8to32_m32_0[] = {
  0x20 & 0xff,
  0x40 & 0xff,
  0x80 & 0xff,
  0 & 0xff,
  0x1 & 0xff,
  0x2 & 0xff,
  0x4 & 0xff,
  0x18 & 0xff,
  0
};

/* constant table xdsem_tab_ld_exp8to32_m16 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp8to32_m16_0[] = {
  0x84 & 0xff,
  0x18 & 0xff,
  0x21 & 0xff,
  0x42 & 0xff,
  0x84 & 0xff,
  0x18 & 0xff,
  0x21 & 0xff,
  0x42 & 0xff,
  0
};

/* constant table xdsem_tab_ld_exp8to32_m8 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp8to32_m8_0[] = {
  0x5a & 0xff,
  0xa5 & 0xff,
  0x5a & 0xff,
  0xa5 & 0xff,
  0x5a & 0xff,
  0xa5 & 0xff,
  0x5a & 0xff,
  0xa5 & 0xff,
  0
};

/* constant table xdsem_tab_ld_exp16to32h_m16 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp16to32h_m16_0[] = {
  0x3c & 0xff,
  0x69 & 0xff,
  0xc3 & 0xff,
  0x96 & 0xff,
  0x3c & 0xff,
  0x69 & 0xff,
  0xc3 & 0xff,
  0x96 & 0xff,
  0
};

/* constant table xdsem_tab_ld_rev8_shiftrot_m32 */
static const unsigned CONST_TBL_xdsem_tab_ld_rev8_shiftrot_m32_0[] = {
  0xff & 0xff,
  0xee & 0xff,
  0xcc & 0xff,
  0x88 & 0xff,
  0 & 0xff,
  0x11 & 0xff,
  0x33 & 0xff,
  0x77 & 0xff,
  0
};

/* constant table xdsem_tab_ld_rev8_shiftrot_m16 */
static const unsigned CONST_TBL_xdsem_tab_ld_rev8_shiftrot_m16_0[] = {
  0xff & 0xff,
  0xaa & 0xff,
  0 & 0xff,
  0x55 & 0xff,
  0xff & 0xff,
  0xaa & 0xff,
  0 & 0xff,
  0x55 & 0xff,
  0
};

/* constant table xdsem_tab_ld_rev8_shiftrot_m8 */
static const unsigned CONST_TBL_xdsem_tab_ld_rev8_shiftrot_m8_0[] = {
  0xff & 0xff,
  0 & 0xff,
  0xff & 0xff,
  0 & 0xff,
  0xff & 0xff,
  0 & 0xff,
  0xff & 0xff,
  0 & 0xff,
  0
};

/* constant table xdsem_tab_ld_exp16to32m_m32 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp16to32m_m32_0[] = {
  0x30 & 0xff,
  0x60 & 0xff,
  0xc0 & 0xff,
  0x81 & 0xff,
  0x3 & 0xff,
  0x6 & 0xff,
  0xc & 0xff,
  0x18 & 0xff,
  0
};

/* constant table xdsem_tab_ld_exp16to32m_m16 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp16to32m_m16_0[] = {
  0x88 & 0xff,
  0 & 0xff,
  0x11 & 0xff,
  0x66 & 0xff,
  0x88 & 0xff,
  0 & 0xff,
  0x11 & 0xff,
  0x66 & 0xff,
  0
};

/* constant table xdsem_tab_ld_exp16to32m_m8 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp16to32m_m8_0[] = {
  0x66 & 0xff,
  0x99 & 0xff,
  0x66 & 0xff,
  0x99 & 0xff,
  0x66 & 0xff,
  0x99 & 0xff,
  0x66 & 0xff,
  0x99 & 0xff,
  0
};

/* constant table xdsem_tab_ld_exp16x2m_m16 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp16x2m_m16_0[] = {
  0x81 & 0xff,
  0x6 & 0xff,
  0x18 & 0xff,
  0x60 & 0xff,
  0x81 & 0xff,
  0x6 & 0xff,
  0x18 & 0xff,
  0x60 & 0xff,
  0
};

/* constant table xdsem_tab_ld_exp32to64m_m16 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp32to64m_m16_0[] = {
  0x3c & 0xff,
  0x68 & 0xff,
  0x81 & 0xff,
  0x16 & 0xff,
  0x3c & 0xff,
  0x68 & 0xff,
  0x81 & 0xff,
  0x16 & 0xff,
  0
};

/* constant table xdsem_tab_ld_exp32to64m_m8 */
static const unsigned CONST_TBL_xdsem_tab_ld_exp32to64m_m8_0[] = {
  0x42 & 0xff,
  0xbd & 0xff,
  0x42 & 0xff,
  0xbd & 0xff,
  0x42 & 0xff,
  0xbd & 0xff,
  0x42 & 0xff,
  0xbd & 0xff,
  0
};

/* constant table xdsem_tab_st_compr16to8_m8 */
static const unsigned CONST_TBL_xdsem_tab_st_compr16to8_m8_0[] = {
  0x22 & 0xff,
  0x88 & 0xff,
  0x22 & 0xff,
  0x88 & 0xff,
  0x22 & 0xff,
  0x88 & 0xff,
  0x22 & 0xff,
  0x88 & 0xff,
  0
};

/* constant table xdsem_tab_st_compr16to8_m16 */
static const unsigned CONST_TBL_xdsem_tab_st_compr16to8_m16_0[] = {
  0x18 & 0xff,
  0x60 & 0xff,
  0x81 & 0xff,
  0x6 & 0xff,
  0x18 & 0xff,
  0x60 & 0xff,
  0x81 & 0xff,
  0x6 & 0xff,
  0
};

/* constant table xdsem_tab_st_compr16to8_m32 */
static const unsigned CONST_TBL_xdsem_tab_st_compr16to8_m32_0[] = {
  0x3 & 0xff,
  0x16 & 0xff,
  0x3c & 0xff,
  0x68 & 0xff,
  0xc0 & 0xff,
  0x80 & 0xff,
  0 & 0xff,
  0x1 & 0xff,
  0
};

/* constant table xdsem_tab_st_compr32to8_m8 */
static const unsigned CONST_TBL_xdsem_tab_st_compr32to8_m8_0[] = {
  0x20 & 0xff,
  0x2 & 0xff,
  0x20 & 0xff,
  0x2 & 0xff,
  0x20 & 0xff,
  0x2 & 0xff,
  0x20 & 0xff,
  0x2 & 0xff,
  0
};

/* constant table xdsem_tab_st_compr32to8_m16 */
static const unsigned CONST_TBL_xdsem_tab_st_compr32to8_m16_0[] = {
  0 & 0xff,
  0x40 & 0xff,
  0x84 & 0xff,
  0x8 & 0xff,
  0 & 0xff,
  0x40 & 0xff,
  0x84 & 0xff,
  0x8 & 0xff,
  0
};

/* constant table xdsem_tab_st_compr32to8_m32 */
static const unsigned CONST_TBL_xdsem_tab_st_compr32to8_m32_0[] = {
  0x2 & 0xff,
  0x4 & 0xff,
  0x8 & 0xff,
  0 & 0xff,
  0x10 & 0xff,
  0x20 & 0xff,
  0x40 & 0xff,
  0x81 & 0xff,
  0
};

/* constant table xdsem_tab_st_compr32to16_m8 */
static const unsigned CONST_TBL_xdsem_tab_st_compr32to16_m8_0[] = {
  0 & 0xff,
  0x33 & 0xff,
  0 & 0xff,
  0x33 & 0xff,
  0 & 0xff,
  0x33 & 0xff,
  0 & 0xff,
  0x33 & 0xff,
  0
};

/* constant table xdsem_tab_st_compr32to16_m16 */
static const unsigned CONST_TBL_xdsem_tab_st_compr32to16_m16_0[] = {
  0xc0 & 0xff,
  0x84 & 0xff,
  0xc & 0xff,
  0x48 & 0xff,
  0xc0 & 0xff,
  0x84 & 0xff,
  0xc & 0xff,
  0x48 & 0xff,
  0
};

/* constant table xdsem_tab_st_compr32to16_m32 */
static const unsigned CONST_TBL_xdsem_tab_st_compr32to16_m32_0[] = {
  0xc & 0xff,
  0x8 & 0xff,
  0 & 0xff,
  0x10 & 0xff,
  0x30 & 0xff,
  0x61 & 0xff,
  0xc3 & 0xff,
  0x86 & 0xff,
  0
};

/* constant table xdsem_tab_st_rev8_shiftrot_m16 */
static const unsigned CONST_TBL_xdsem_tab_st_rev8_shiftrot_m16_0[] = {
  0xff & 0xff,
  0x55 & 0xff,
  0 & 0xff,
  0xaa & 0xff,
  0xff & 0xff,
  0x55 & 0xff,
  0 & 0xff,
  0xaa & 0xff,
  0
};

/* constant table xdsem_tab_st_rev8_shiftrot_m32 */
static const unsigned CONST_TBL_xdsem_tab_st_rev8_shiftrot_m32_0[] = {
  0xff & 0xff,
  0x77 & 0xff,
  0x33 & 0xff,
  0x11 & 0xff,
  0 & 0xff,
  0x88 & 0xff,
  0xcc & 0xff,
  0xee & 0xff,
  0
};

/* constant table xdsem_tab_st_compr16hto8_m8 */
static const unsigned CONST_TBL_xdsem_tab_st_compr16hto8_m8_0[] = {
  0x44 & 0xff,
  0x11 & 0xff,
  0x44 & 0xff,
  0x11 & 0xff,
  0x44 & 0xff,
  0x11 & 0xff,
  0x44 & 0xff,
  0x11 & 0xff,
  0
};

/* constant table xdsem_tab_compr64mto32_m16 */
static const unsigned CONST_TBL_xdsem_tab_compr64mto32_m16_0[] = {
  0xc3 & 0xff,
  0xc3 & 0xff,
  0xc3 & 0xff,
  0xc3 & 0xff,
  0xc3 & 0xff,
  0xc3 & 0xff,
  0xc3 & 0xff,
  0xc3 & 0xff,
  0
};

/* constant table xdsem_tab_compr64mto32_m32 */
static const unsigned CONST_TBL_xdsem_tab_compr64mto32_m32_0[] = {
  0xc & 0xff,
  0xc & 0xff,
  0xc & 0xff,
  0xc & 0xff,
  0xc & 0xff,
  0xc & 0xff,
  0xc & 0xff,
  0xc & 0xff,
  0
};

/* constant table xdsem_tab_compr32mto16_m8 */
static const unsigned CONST_TBL_xdsem_tab_compr32mto16_m8_0[] = {
  0x99 & 0xff,
  0x99 & 0xff,
  0x99 & 0xff,
  0x99 & 0xff,
  0x99 & 0xff,
  0x99 & 0xff,
  0x99 & 0xff,
  0x99 & 0xff,
  0
};

/* constant table xdsem_tab_compr32mto16_m16 */
static const unsigned CONST_TBL_xdsem_tab_compr32mto16_m16_0[] = {
  0x24 & 0xff,
  0x24 & 0xff,
  0x24 & 0xff,
  0x24 & 0xff,
  0x24 & 0xff,
  0x24 & 0xff,
  0x24 & 0xff,
  0x24 & 0xff,
  0
};

/* constant table xdsem_tab_compr32mto16_m32 */
static const unsigned CONST_TBL_xdsem_tab_compr32mto16_m32_0[] = {
  0x3 & 0xff,
  0x3 & 0xff,
  0x3 & 0xff,
  0x3 & 0xff,
  0x3 & 0xff,
  0x3 & 0xff,
  0x3 & 0xff,
  0x3 & 0xff,
  0
};


/* Instruction operands.  */

static int
OperandSem_opnd_sem_soffsetx4_decode (uint32 *valp)
{
  unsigned soffsetx4_out_0;
  unsigned soffsetx4_in_0;
  soffsetx4_in_0 = *valp & 0x3ffff;
  soffsetx4_out_0 = 0x4 + ((((int) soffsetx4_in_0 << 14) >> 14) << 2);
  *valp = soffsetx4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_soffsetx4_encode (uint32 *valp)
{
  unsigned soffsetx4_in_0;
  unsigned soffsetx4_out_0;
  soffsetx4_out_0 = *valp;
  soffsetx4_in_0 = ((soffsetx4_out_0 - 0x4) >> 2) & 0x3ffff;
  *valp = soffsetx4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_immr_decode (uint32 *valp)
{
  unsigned immr_out_0;
  unsigned immr_in_0;
  immr_in_0 = *valp & 0xf;
  immr_out_0 = immr_in_0;
  *valp = immr_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_immr_encode (uint32 *valp)
{
  unsigned immr_in_0;
  unsigned immr_out_0;
  immr_out_0 = *valp;
  immr_in_0 = (immr_out_0 & 0xf);
  *valp = immr_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm12x8_decode (uint32 *valp)
{
  unsigned uimm12x8_out_0;
  unsigned uimm12x8_in_0;
  uimm12x8_in_0 = *valp & 0xfff;
  uimm12x8_out_0 = uimm12x8_in_0 << 3;
  *valp = uimm12x8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm12x8_encode (uint32 *valp)
{
  unsigned uimm12x8_in_0;
  unsigned uimm12x8_out_0;
  uimm12x8_out_0 = *valp;
  uimm12x8_in_0 = ((uimm12x8_out_0 >> 3) & 0xfff);
  *valp = uimm12x8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm4_decode (uint32 *valp)
{
  unsigned simm4_out_0;
  unsigned simm4_in_0;
  simm4_in_0 = *valp & 0xf;
  simm4_out_0 = ((int) simm4_in_0 << 28) >> 28;
  *valp = simm4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm4_encode (uint32 *valp)
{
  unsigned simm4_in_0;
  unsigned simm4_out_0;
  simm4_out_0 = *valp;
  simm4_in_0 = (simm4_out_0 & 0xf);
  *valp = simm4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_AR_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_AR_0_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_0_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_AR_4_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_4_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_AR_8_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_8_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_AR_12_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_12_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_AR_entry_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AR_entry_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 32);
  return error;
}

static int
OperandSem_opnd_sem_immrx4_decode (uint32 *valp)
{
  unsigned immrx4_out_0;
  unsigned immrx4_in_0;
  immrx4_in_0 = *valp & 0xf;
  immrx4_out_0 = (((0xfffffff) << 4) | immrx4_in_0) << 2;
  *valp = immrx4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_immrx4_encode (uint32 *valp)
{
  unsigned immrx4_in_0;
  unsigned immrx4_out_0;
  immrx4_out_0 = *valp;
  immrx4_in_0 = ((immrx4_out_0 >> 2) & 0xf);
  *valp = immrx4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_lsi4x4_decode (uint32 *valp)
{
  unsigned lsi4x4_out_0;
  unsigned lsi4x4_in_0;
  lsi4x4_in_0 = *valp & 0xf;
  lsi4x4_out_0 = lsi4x4_in_0 << 2;
  *valp = lsi4x4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_lsi4x4_encode (uint32 *valp)
{
  unsigned lsi4x4_in_0;
  unsigned lsi4x4_out_0;
  lsi4x4_out_0 = *valp;
  lsi4x4_in_0 = ((lsi4x4_out_0 >> 2) & 0xf);
  *valp = lsi4x4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm7_decode (uint32 *valp)
{
  unsigned simm7_out_0;
  unsigned simm7_in_0;
  simm7_in_0 = *valp & 0x7f;
  simm7_out_0 = ((((-((((simm7_in_0 >> 6) & 1)) & (((simm7_in_0 >> 5) & 1)))) & 0x1ffffff)) << 7) | simm7_in_0;
  *valp = simm7_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm7_encode (uint32 *valp)
{
  unsigned simm7_in_0;
  unsigned simm7_out_0;
  simm7_out_0 = *valp;
  simm7_in_0 = (simm7_out_0 & 0x7f);
  *valp = simm7_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm6_decode (uint32 *valp)
{
  unsigned uimm6_out_0;
  unsigned uimm6_in_0;
  uimm6_in_0 = *valp & 0x3f;
  uimm6_out_0 = 0x4 + (((0) << 6) | uimm6_in_0);
  *valp = uimm6_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm6_encode (uint32 *valp)
{
  unsigned uimm6_in_0;
  unsigned uimm6_out_0;
  uimm6_out_0 = *valp;
  uimm6_in_0 = (uimm6_out_0 - 0x4) & 0x3f;
  *valp = uimm6_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ai4const_decode (uint32 *valp)
{
  unsigned ai4const_out_0;
  unsigned ai4const_in_0;
  ai4const_in_0 = *valp & 0xf;
  ai4const_out_0 = CONST_TBL_ai4c_0[ai4const_in_0 & 0xf];
  *valp = ai4const_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ai4const_encode (uint32 *valp)
{
  unsigned ai4const_in_0;
  unsigned ai4const_out_0;
  ai4const_out_0 = *valp;
  switch (ai4const_out_0)
    {
    case 0xffffffff: ai4const_in_0 = 0; break;
    case 0x1: ai4const_in_0 = 0x1; break;
    case 0x2: ai4const_in_0 = 0x2; break;
    case 0x3: ai4const_in_0 = 0x3; break;
    case 0x4: ai4const_in_0 = 0x4; break;
    case 0x5: ai4const_in_0 = 0x5; break;
    case 0x6: ai4const_in_0 = 0x6; break;
    case 0x7: ai4const_in_0 = 0x7; break;
    case 0x8: ai4const_in_0 = 0x8; break;
    case 0x9: ai4const_in_0 = 0x9; break;
    case 0xa: ai4const_in_0 = 0xa; break;
    case 0xb: ai4const_in_0 = 0xb; break;
    case 0xc: ai4const_in_0 = 0xc; break;
    case 0xd: ai4const_in_0 = 0xd; break;
    case 0xe: ai4const_in_0 = 0xe; break;
    default: ai4const_in_0 = 0xf; break;
    }
  *valp = ai4const_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4const_decode (uint32 *valp)
{
  unsigned b4const_out_0;
  unsigned b4const_in_0;
  b4const_in_0 = *valp & 0xf;
  b4const_out_0 = CONST_TBL_b4c_0[b4const_in_0 & 0xf];
  *valp = b4const_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4const_encode (uint32 *valp)
{
  unsigned b4const_in_0;
  unsigned b4const_out_0;
  b4const_out_0 = *valp;
  switch (b4const_out_0)
    {
    case 0xffffffff: b4const_in_0 = 0; break;
    case 0x1: b4const_in_0 = 0x1; break;
    case 0x2: b4const_in_0 = 0x2; break;
    case 0x3: b4const_in_0 = 0x3; break;
    case 0x4: b4const_in_0 = 0x4; break;
    case 0x5: b4const_in_0 = 0x5; break;
    case 0x6: b4const_in_0 = 0x6; break;
    case 0x7: b4const_in_0 = 0x7; break;
    case 0x8: b4const_in_0 = 0x8; break;
    case 0xa: b4const_in_0 = 0x9; break;
    case 0xc: b4const_in_0 = 0xa; break;
    case 0x10: b4const_in_0 = 0xb; break;
    case 0x20: b4const_in_0 = 0xc; break;
    case 0x40: b4const_in_0 = 0xd; break;
    case 0x80: b4const_in_0 = 0xe; break;
    default: b4const_in_0 = 0xf; break;
    }
  *valp = b4const_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4constu_decode (uint32 *valp)
{
  unsigned b4constu_out_0;
  unsigned b4constu_in_0;
  b4constu_in_0 = *valp & 0xf;
  b4constu_out_0 = CONST_TBL_b4cu_0[b4constu_in_0 & 0xf];
  *valp = b4constu_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_b4constu_encode (uint32 *valp)
{
  unsigned b4constu_in_0;
  unsigned b4constu_out_0;
  b4constu_out_0 = *valp;
  switch (b4constu_out_0)
    {
    case 0x8000: b4constu_in_0 = 0; break;
    case 0x10000: b4constu_in_0 = 0x1; break;
    case 0x2: b4constu_in_0 = 0x2; break;
    case 0x3: b4constu_in_0 = 0x3; break;
    case 0x4: b4constu_in_0 = 0x4; break;
    case 0x5: b4constu_in_0 = 0x5; break;
    case 0x6: b4constu_in_0 = 0x6; break;
    case 0x7: b4constu_in_0 = 0x7; break;
    case 0x8: b4constu_in_0 = 0x8; break;
    case 0xa: b4constu_in_0 = 0x9; break;
    case 0xc: b4constu_in_0 = 0xa; break;
    case 0x10: b4constu_in_0 = 0xb; break;
    case 0x20: b4constu_in_0 = 0xc; break;
    case 0x40: b4constu_in_0 = 0xd; break;
    case 0x80: b4constu_in_0 = 0xe; break;
    default: b4constu_in_0 = 0xf; break;
    }
  *valp = b4constu_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_immt_decode (uint32 *valp)
{
  unsigned immt_out_0;
  unsigned immt_in_0;
  immt_in_0 = *valp & 0xf;
  immt_out_0 = immt_in_0;
  *valp = immt_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_immt_encode (uint32 *valp)
{
  unsigned immt_in_0;
  unsigned immt_out_0;
  immt_out_0 = *valp;
  immt_in_0 = immt_out_0 & 0xf;
  *valp = immt_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimms8_decode (uint32 *valp)
{
  unsigned uimms8_out_0;
  unsigned uimms8_in_0;
  uimms8_in_0 = *valp & 0x7;
  uimms8_out_0 = uimms8_in_0;
  *valp = uimms8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimms8_encode (uint32 *valp)
{
  unsigned uimms8_in_0;
  unsigned uimms8_out_0;
  uimms8_out_0 = *valp;
  uimms8_in_0 = uimms8_out_0 & 0x7;
  *valp = uimms8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8_decode (uint32 *valp)
{
  unsigned uimm8_out_0;
  unsigned uimm8_in_0;
  uimm8_in_0 = *valp & 0xff;
  uimm8_out_0 = uimm8_in_0;
  *valp = uimm8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8_encode (uint32 *valp)
{
  unsigned uimm8_in_0;
  unsigned uimm8_out_0;
  uimm8_out_0 = *valp;
  uimm8_in_0 = (uimm8_out_0 & 0xff);
  *valp = uimm8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x2_decode (uint32 *valp)
{
  unsigned uimm8x2_out_0;
  unsigned uimm8x2_in_0;
  uimm8x2_in_0 = *valp & 0xff;
  uimm8x2_out_0 = uimm8x2_in_0 << 1;
  *valp = uimm8x2_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x2_encode (uint32 *valp)
{
  unsigned uimm8x2_in_0;
  unsigned uimm8x2_out_0;
  uimm8x2_out_0 = *valp;
  uimm8x2_in_0 = ((uimm8x2_out_0 >> 1) & 0xff);
  *valp = uimm8x2_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x4_decode (uint32 *valp)
{
  unsigned uimm8x4_out_0;
  unsigned uimm8x4_in_0;
  uimm8x4_in_0 = *valp & 0xff;
  uimm8x4_out_0 = uimm8x4_in_0 << 2;
  *valp = uimm8x4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm8x4_encode (uint32 *valp)
{
  unsigned uimm8x4_in_0;
  unsigned uimm8x4_out_0;
  uimm8x4_out_0 = *valp;
  uimm8x4_in_0 = ((uimm8x4_out_0 >> 2) & 0xff);
  *valp = uimm8x4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm4x16_decode (uint32 *valp)
{
  unsigned uimm4x16_out_0;
  unsigned uimm4x16_in_0;
  uimm4x16_in_0 = *valp & 0xf;
  uimm4x16_out_0 = ((0 << 4) | uimm4x16_in_0) << 4;
  *valp = uimm4x16_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm4x16_encode (uint32 *valp)
{
  unsigned uimm4x16_in_0;
  unsigned uimm4x16_out_0;
  uimm4x16_out_0 = *valp;
  uimm4x16_in_0 = ((uimm4x16_out_0 >> 4) & 0xf);
  *valp = uimm4x16_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimmrx4_decode (uint32 *valp)
{
  unsigned uimmrx4_out_0;
  unsigned uimmrx4_in_0;
  uimmrx4_in_0 = *valp & 0xf;
  uimmrx4_out_0 = ((0 << 4) | uimmrx4_in_0) << 2;
  *valp = uimmrx4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimmrx4_encode (uint32 *valp)
{
  unsigned uimmrx4_in_0;
  unsigned uimmrx4_out_0;
  uimmrx4_out_0 = *valp;
  uimmrx4_in_0 = ((uimmrx4_out_0 >> 2) & 0xf);
  *valp = uimmrx4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8_decode (uint32 *valp)
{
  unsigned simm8_out_0;
  unsigned simm8_in_0;
  simm8_in_0 = *valp & 0xff;
  simm8_out_0 = ((int) simm8_in_0 << 24) >> 24;
  *valp = simm8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8_encode (uint32 *valp)
{
  unsigned simm8_in_0;
  unsigned simm8_out_0;
  simm8_out_0 = *valp;
  simm8_in_0 = (simm8_out_0 & 0xff);
  *valp = simm8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8x256_decode (uint32 *valp)
{
  unsigned simm8x256_out_0;
  unsigned simm8x256_in_0;
  simm8x256_in_0 = *valp & 0xff;
  simm8x256_out_0 = (((int) simm8x256_in_0 << 24) >> 24) << 8;
  *valp = simm8x256_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm8x256_encode (uint32 *valp)
{
  unsigned simm8x256_in_0;
  unsigned simm8x256_out_0;
  simm8x256_out_0 = *valp;
  simm8x256_in_0 = ((simm8x256_out_0 >> 8) & 0xff);
  *valp = simm8x256_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm12b_decode (uint32 *valp)
{
  unsigned simm12b_out_0;
  unsigned simm12b_in_0;
  simm12b_in_0 = *valp & 0xfff;
  simm12b_out_0 = ((int) simm12b_in_0 << 20) >> 20;
  *valp = simm12b_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_simm12b_encode (uint32 *valp)
{
  unsigned simm12b_in_0;
  unsigned simm12b_out_0;
  simm12b_out_0 = *valp;
  simm12b_in_0 = (simm12b_out_0 & 0xfff);
  *valp = simm12b_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_msalp32_decode (uint32 *valp)
{
  unsigned msalp32_out_0;
  unsigned msalp32_in_0;
  msalp32_in_0 = *valp & 0x1f;
  msalp32_out_0 = 0x20 - msalp32_in_0;
  *valp = msalp32_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_msalp32_encode (uint32 *valp)
{
  unsigned msalp32_in_0;
  unsigned msalp32_out_0;
  msalp32_out_0 = *valp;
  msalp32_in_0 = (0x20 - msalp32_out_0) & 0x1f;
  *valp = msalp32_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_op2p1_decode (uint32 *valp)
{
  unsigned op2p1_out_0;
  unsigned op2p1_in_0;
  op2p1_in_0 = *valp & 0xf;
  op2p1_out_0 = op2p1_in_0 + 0x1;
  *valp = op2p1_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_op2p1_encode (uint32 *valp)
{
  unsigned op2p1_in_0;
  unsigned op2p1_out_0;
  op2p1_out_0 = *valp;
  op2p1_in_0 = (op2p1_out_0 - 0x1) & 0xf;
  *valp = op2p1_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_low_depbits_decode (uint32 *valp)
{
  unsigned low_depbits_out_0;
  unsigned low_depbits_in_0;
  low_depbits_in_0 = *valp & 0x1f;
  low_depbits_out_0 = low_depbits_in_0;
  *valp = low_depbits_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_low_depbits_encode (uint32 *valp)
{
  unsigned low_depbits_in_0;
  unsigned low_depbits_out_0;
  low_depbits_out_0 = *valp;
  low_depbits_in_0 = (low_depbits_out_0 & 0x1f);
  *valp = low_depbits_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_lngth_depbits_decode (uint32 *valp)
{
  unsigned lngth_depbits_out_0;
  unsigned lngth_depbits_in_0;
  lngth_depbits_in_0 = *valp & 0xf;
  lngth_depbits_out_0 = lngth_depbits_in_0 + 0x1;
  *valp = lngth_depbits_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_lngth_depbits_encode (uint32 *valp)
{
  unsigned lngth_depbits_in_0;
  unsigned lngth_depbits_out_0;
  lngth_depbits_out_0 = *valp;
  lngth_depbits_in_0 = (lngth_depbits_out_0 - 0x1) & 0xf;
  *valp = lngth_depbits_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_label8_decode (uint32 *valp)
{
  unsigned label8_out_0;
  unsigned label8_in_0;
  label8_in_0 = *valp & 0xff;
  label8_out_0 = 0x4 + (((int) label8_in_0 << 24) >> 24);
  *valp = label8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_label8_encode (uint32 *valp)
{
  unsigned label8_in_0;
  unsigned label8_out_0;
  label8_out_0 = *valp;
  label8_in_0 = (label8_out_0 - 0x4) & 0xff;
  *valp = label8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ulabel8_decode (uint32 *valp)
{
  unsigned ulabel8_out_0;
  unsigned ulabel8_in_0;
  ulabel8_in_0 = *valp & 0xff;
  ulabel8_out_0 = 0x4 + (((0) << 8) | ulabel8_in_0);
  *valp = ulabel8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ulabel8_encode (uint32 *valp)
{
  unsigned ulabel8_in_0;
  unsigned ulabel8_out_0;
  ulabel8_out_0 = *valp;
  ulabel8_in_0 = (ulabel8_out_0 - 0x4) & 0xff;
  *valp = ulabel8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_label12_decode (uint32 *valp)
{
  unsigned label12_out_0;
  unsigned label12_in_0;
  label12_in_0 = *valp & 0xfff;
  label12_out_0 = 0x4 + (((int) label12_in_0 << 20) >> 20);
  *valp = label12_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_label12_encode (uint32 *valp)
{
  unsigned label12_in_0;
  unsigned label12_out_0;
  label12_out_0 = *valp;
  label12_in_0 = (label12_out_0 - 0x4) & 0xfff;
  *valp = label12_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_soffset_decode (uint32 *valp)
{
  unsigned soffset_out_0;
  unsigned soffset_in_0;
  soffset_in_0 = *valp & 0x3ffff;
  soffset_out_0 = 0x4 + (((int) soffset_in_0 << 14) >> 14);
  *valp = soffset_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_soffset_encode (uint32 *valp)
{
  unsigned soffset_in_0;
  unsigned soffset_out_0;
  soffset_out_0 = *valp;
  soffset_in_0 = (soffset_out_0 - 0x4) & 0x3ffff;
  *valp = soffset_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm16x4_decode (uint32 *valp)
{
  unsigned uimm16x4_out_0;
  unsigned uimm16x4_in_0;
  uimm16x4_in_0 = *valp & 0xffff;
  uimm16x4_out_0 = (((0xffff) << 16) | uimm16x4_in_0) << 2;
  *valp = uimm16x4_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_uimm16x4_encode (uint32 *valp)
{
  unsigned uimm16x4_in_0;
  unsigned uimm16x4_out_0;
  uimm16x4_out_0 = *valp;
  uimm16x4_in_0 = (uimm16x4_out_0 >> 2) & 0xffff;
  *valp = uimm16x4_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_imms_decode (uint32 *valp)
{
  unsigned imms_out_0;
  unsigned imms_in_0;
  imms_in_0 = *valp & 0xf;
  imms_out_0 = imms_in_0;
  *valp = imms_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_imms_encode (uint32 *valp)
{
  unsigned imms_in_0;
  unsigned imms_out_0;
  imms_out_0 = *valp;
  imms_in_0 = imms_out_0 & 0xf;
  *valp = imms_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_tp7_decode (uint32 *valp)
{
  unsigned tp7_out_0;
  unsigned tp7_in_0;
  tp7_in_0 = *valp & 0xf;
  tp7_out_0 = tp7_in_0 + 0x7;
  *valp = tp7_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_tp7_encode (uint32 *valp)
{
  unsigned tp7_in_0;
  unsigned tp7_out_0;
  tp7_out_0 = *valp;
  tp7_in_0 = (tp7_out_0 - 0x7) & 0xf;
  *valp = tp7_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_xt_wbr15_label_decode (uint32 *valp)
{
  unsigned xt_wbr15_label_out_0;
  unsigned xt_wbr15_label_in_0;
  xt_wbr15_label_in_0 = *valp & 0x7fff;
  xt_wbr15_label_out_0 = 0x4 + (((int) xt_wbr15_label_in_0 << 17) >> 17);
  *valp = xt_wbr15_label_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_xt_wbr15_label_encode (uint32 *valp)
{
  unsigned xt_wbr15_label_in_0;
  unsigned xt_wbr15_label_out_0;
  xt_wbr15_label_out_0 = *valp;
  xt_wbr15_label_in_0 = (xt_wbr15_label_out_0 - 0x4) & 0x7fff;
  *valp = xt_wbr15_label_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_xt_wloop_label_decode (uint32 *valp)
{
  unsigned xt_wloop_label_out_0;
  unsigned xt_wloop_label_in_0;
  xt_wloop_label_in_0 = *valp & 0x7fff;
  xt_wloop_label_out_0 = 0x4 + (((0) << 15) | xt_wloop_label_in_0);
  *valp = xt_wloop_label_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_xt_wloop_label_encode (uint32 *valp)
{
  unsigned xt_wloop_label_in_0;
  unsigned xt_wloop_label_out_0;
  xt_wloop_label_out_0 = *valp;
  xt_wloop_label_in_0 = (xt_wloop_label_out_0 - 0x4) & 0x7fff;
  *valp = xt_wloop_label_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_ohba_decode (uint32 *valp)
{
  unsigned ae_ohba_out_0;
  unsigned ae_ohba_in_0;
  ae_ohba_in_0 = *valp & 0xf;
  ae_ohba_out_0 = (0 << 5) | (((((ae_ohba_in_0 & 0xf))) == 0) << 4) | ((ae_ohba_in_0 & 0xf));
  *valp = ae_ohba_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_ohba_encode (uint32 *valp)
{
  unsigned ae_ohba_in_0;
  unsigned ae_ohba_out_0;
  ae_ohba_out_0 = *valp;
  ae_ohba_in_0 = (ae_ohba_out_0 & 0xf);
  *valp = ae_ohba_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_opnd_tp7_decode (uint32 *valp)
{
  unsigned ae_opnd_tp7_out_0;
  unsigned ae_opnd_tp7_in_0;
  ae_opnd_tp7_in_0 = *valp & 0xf;
  ae_opnd_tp7_out_0 = ae_opnd_tp7_in_0 + 0x7;
  *valp = ae_opnd_tp7_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_opnd_tp7_encode (uint32 *valp)
{
  unsigned ae_opnd_tp7_in_0;
  unsigned ae_opnd_tp7_out_0;
  ae_opnd_tp7_out_0 = *valp;
  ae_opnd_tp7_in_0 = (ae_opnd_tp7_out_0 - 0x7) & 0xf;
  *valp = ae_opnd_tp7_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_imm2_decode (uint32 *valp)
{
  unsigned ae_imm2_out_0;
  unsigned ae_imm2_in_0;
  ae_imm2_in_0 = *valp & 0x3;
  ae_imm2_out_0 = (0 << 2) | ae_imm2_in_0;
  *valp = ae_imm2_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_imm2_encode (uint32 *valp)
{
  unsigned ae_imm2_in_0;
  unsigned ae_imm2_out_0;
  ae_imm2_out_0 = *valp;
  ae_imm2_in_0 = (ae_imm2_out_0 & 0x3);
  *valp = ae_imm2_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa16_decode (uint32 *valp)
{
  unsigned ae_osa16_out_0;
  unsigned ae_osa16_in_0;
  ae_osa16_in_0 = *valp & 0xf;
  ae_osa16_out_0 = (0 << 4) | ae_osa16_in_0;
  *valp = ae_osa16_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa16_encode (uint32 *valp)
{
  unsigned ae_osa16_in_0;
  unsigned ae_osa16_out_0;
  ae_osa16_out_0 = *valp;
  ae_osa16_in_0 = (ae_osa16_out_0 & 0xf);
  *valp = ae_osa16_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa32_decode (uint32 *valp)
{
  unsigned ae_osa32_out_0;
  unsigned ae_osa32_in_0;
  ae_osa32_in_0 = *valp & 0x1f;
  ae_osa32_out_0 = (0 << 5) | ae_osa32_in_0;
  *valp = ae_osa32_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa32_encode (uint32 *valp)
{
  unsigned ae_osa32_in_0;
  unsigned ae_osa32_out_0;
  ae_osa32_out_0 = *valp;
  ae_osa32_in_0 = (ae_osa32_out_0 & 0x1f);
  *valp = ae_osa32_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa64_decode (uint32 *valp)
{
  unsigned ae_osa64_out_0;
  unsigned ae_osa64_in_0;
  ae_osa64_in_0 = *valp & 0x3f;
  ae_osa64_out_0 = (0 << 6) | ae_osa64_in_0;
  *valp = ae_osa64_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_osa64_encode (uint32 *valp)
{
  unsigned ae_osa64_in_0;
  unsigned ae_osa64_out_0;
  ae_osa64_out_0 = *valp;
  ae_osa64_in_0 = (ae_osa64_out_0 & 0x3f);
  *valp = ae_osa64_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_uimm2x2_decode (uint32 *valp)
{
  unsigned ae_uimm2x2_out_0;
  unsigned ae_uimm2x2_in_0;
  ae_uimm2x2_in_0 = *valp & 0x1;
  ae_uimm2x2_out_0 = (0 << 2) | (ae_uimm2x2_in_0 << 1) | 0;
  *valp = ae_uimm2x2_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_ae_uimm2x2_encode (uint32 *valp)
{
  unsigned ae_uimm2x2_in_0;
  unsigned ae_uimm2x2_out_0;
  ae_uimm2x2_out_0 = *valp;
  ae_uimm2x2_in_0 = (((ae_uimm2x2_out_0 >> 1) & 1)) & 0x1;
  *valp = ae_uimm2x2_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_AE_DR_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AE_DR_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 16);
  return error;
}

static int
OperandSem_opnd_sem_vbool_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_vbool_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 8);
  return error;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_vbool_i_imm3_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_vbool_i_imm3_out_0;
  unsigned opnd_ae_sem_vbool_i_imm3_in_0;
  opnd_ae_sem_vbool_i_imm3_in_0 = *valp & 0x7;
  opnd_ae_sem_vbool_i_imm3_out_0 = (0 << 3) | opnd_ae_sem_vbool_i_imm3_in_0;
  *valp = opnd_ae_sem_vbool_i_imm3_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_vbool_i_imm3_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_vbool_i_imm3_in_0;
  unsigned opnd_ae_sem_vbool_i_imm3_out_0;
  opnd_ae_sem_vbool_i_imm3_out_0 = *valp;
  opnd_ae_sem_vbool_i_imm3_in_0 = (opnd_ae_sem_vbool_i_imm3_out_0 & 0x7);
  *valp = opnd_ae_sem_vbool_i_imm3_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i8p_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i8p_out_0;
  unsigned opnd_ae_sem_loads_stores_i8p_in_0;
  opnd_ae_sem_loads_stores_i8p_in_0 = *valp & 0x1f;
  opnd_ae_sem_loads_stores_i8p_out_0 = (((-(( ( ((((opnd_ae_sem_loads_stores_i8p_in_0 >> 3) & 0x3)) | 0xfffffffc)) == 0xffffffff))) & 0x7ffffff) << 5) | opnd_ae_sem_loads_stores_i8p_in_0;
  *valp = opnd_ae_sem_loads_stores_i8p_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i8p_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i8p_in_0;
  unsigned opnd_ae_sem_loads_stores_i8p_out_0;
  opnd_ae_sem_loads_stores_i8p_out_0 = *valp;
  opnd_ae_sem_loads_stores_i8p_in_0 = (opnd_ae_sem_loads_stores_i8p_out_0 & 0x1f);
  *valp = opnd_ae_sem_loads_stores_i8p_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i8_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i8_out_0;
  unsigned opnd_ae_sem_loads_stores_i8_in_0;
  opnd_ae_sem_loads_stores_i8_in_0 = *valp & 0xff;
  opnd_ae_sem_loads_stores_i8_out_0 = (((-(( ( ((((opnd_ae_sem_loads_stores_i8_in_0 >> 3) & 0x1f)) | 0xffffffe0)) == 0xffffffff))) & 0xffffff) << 8) | opnd_ae_sem_loads_stores_i8_in_0;
  *valp = opnd_ae_sem_loads_stores_i8_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i8_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i8_in_0;
  unsigned opnd_ae_sem_loads_stores_i8_out_0;
  opnd_ae_sem_loads_stores_i8_out_0 = *valp;
  opnd_ae_sem_loads_stores_i8_in_0 = (opnd_ae_sem_loads_stores_i8_out_0 & 0xff);
  *valp = opnd_ae_sem_loads_stores_i8_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i32p_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i32p_out_0;
  unsigned opnd_ae_sem_loads_stores_i32p_in_0;
  opnd_ae_sem_loads_stores_i32p_in_0 = *valp & 0x1f;
  opnd_ae_sem_loads_stores_i32p_out_0 = ((((-(( ( ((((opnd_ae_sem_loads_stores_i32p_in_0 >> 3) & 0x3)) | 0xfffffffc)) == 0xffffffff))) & 0x7ffffff) << 5) | opnd_ae_sem_loads_stores_i32p_in_0) << 2;
  *valp = opnd_ae_sem_loads_stores_i32p_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i32p_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i32p_in_0;
  unsigned opnd_ae_sem_loads_stores_i32p_out_0;
  opnd_ae_sem_loads_stores_i32p_out_0 = *valp;
  opnd_ae_sem_loads_stores_i32p_in_0 = ((opnd_ae_sem_loads_stores_i32p_out_0 >> 2) & 0x1f);
  *valp = opnd_ae_sem_loads_stores_i32p_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i32_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i32_out_0;
  unsigned opnd_ae_sem_loads_stores_i32_in_0;
  opnd_ae_sem_loads_stores_i32_in_0 = *valp & 0xff;
  opnd_ae_sem_loads_stores_i32_out_0 = ((((-(( ( ((((opnd_ae_sem_loads_stores_i32_in_0 >> 3) & 0x1f)) | 0xffffffe0)) == 0xffffffff))) & 0xffffff) << 8) | opnd_ae_sem_loads_stores_i32_in_0) << 2;
  *valp = opnd_ae_sem_loads_stores_i32_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i32_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i32_in_0;
  unsigned opnd_ae_sem_loads_stores_i32_out_0;
  opnd_ae_sem_loads_stores_i32_out_0 = *valp;
  opnd_ae_sem_loads_stores_i32_in_0 = ((opnd_ae_sem_loads_stores_i32_out_0 >> 2) & 0xff);
  *valp = opnd_ae_sem_loads_stores_i32_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64p_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i64p_out_0;
  unsigned opnd_ae_sem_loads_stores_i64p_in_0;
  opnd_ae_sem_loads_stores_i64p_in_0 = *valp & 0x1f;
  opnd_ae_sem_loads_stores_i64p_out_0 = ((((-(( ( ((((opnd_ae_sem_loads_stores_i64p_in_0 >> 3) & 0x3)) | 0xfffffffc)) == 0xffffffff))) & 0x7ffffff) << 5) | opnd_ae_sem_loads_stores_i64p_in_0) << 3;
  *valp = opnd_ae_sem_loads_stores_i64p_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64p_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i64p_in_0;
  unsigned opnd_ae_sem_loads_stores_i64p_out_0;
  opnd_ae_sem_loads_stores_i64p_out_0 = *valp;
  opnd_ae_sem_loads_stores_i64p_in_0 = ((opnd_ae_sem_loads_stores_i64p_out_0 >> 3) & 0x1f);
  *valp = opnd_ae_sem_loads_stores_i64p_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i64_out_0;
  unsigned opnd_ae_sem_loads_stores_i64_in_0;
  opnd_ae_sem_loads_stores_i64_in_0 = *valp & 0xff;
  opnd_ae_sem_loads_stores_i64_out_0 = ((((-(( ( ((((opnd_ae_sem_loads_stores_i64_in_0 >> 3) & 0x1f)) | 0xffffffe0)) == 0xffffffff))) & 0xffffff) << 8) | opnd_ae_sem_loads_stores_i64_in_0) << 3;
  *valp = opnd_ae_sem_loads_stores_i64_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i64_in_0;
  unsigned opnd_ae_sem_loads_stores_i64_out_0;
  opnd_ae_sem_loads_stores_i64_out_0 = *valp;
  opnd_ae_sem_loads_stores_i64_in_0 = ((opnd_ae_sem_loads_stores_i64_out_0 >> 3) & 0xff);
  *valp = opnd_ae_sem_loads_stores_i64_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i16m_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i16m_out_0;
  unsigned opnd_ae_sem_loads_stores_i16m_in_0;
  opnd_ae_sem_loads_stores_i16m_in_0 = *valp & 0xf;
  opnd_ae_sem_loads_stores_i16m_out_0 = (((int) opnd_ae_sem_loads_stores_i16m_in_0 << 28) >> 28) << 1;
  *valp = opnd_ae_sem_loads_stores_i16m_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i16m_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i16m_in_0;
  unsigned opnd_ae_sem_loads_stores_i16m_out_0;
  opnd_ae_sem_loads_stores_i16m_out_0 = *valp;
  opnd_ae_sem_loads_stores_i16m_in_0 = ((opnd_ae_sem_loads_stores_i16m_out_0 >> 1) & 0xf);
  *valp = opnd_ae_sem_loads_stores_i16m_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i32m_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i32m_out_0;
  unsigned opnd_ae_sem_loads_stores_i32m_in_0;
  opnd_ae_sem_loads_stores_i32m_in_0 = *valp & 0xf;
  opnd_ae_sem_loads_stores_i32m_out_0 = (((int) opnd_ae_sem_loads_stores_i32m_in_0 << 28) >> 28) << 2;
  *valp = opnd_ae_sem_loads_stores_i32m_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i32m_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i32m_in_0;
  unsigned opnd_ae_sem_loads_stores_i32m_out_0;
  opnd_ae_sem_loads_stores_i32m_out_0 = *valp;
  opnd_ae_sem_loads_stores_i32m_in_0 = ((opnd_ae_sem_loads_stores_i32m_out_0 >> 2) & 0xf);
  *valp = opnd_ae_sem_loads_stores_i32m_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i16p_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i16p_out_0;
  unsigned opnd_ae_sem_loads_stores_i16p_in_0;
  opnd_ae_sem_loads_stores_i16p_in_0 = *valp & 0x1f;
  opnd_ae_sem_loads_stores_i16p_out_0 = ((((-(( ( ((((opnd_ae_sem_loads_stores_i16p_in_0 >> 3) & 0x3)) | 0xfffffffc)) == 0xffffffff))) & 0x7ffffff) << 5) | opnd_ae_sem_loads_stores_i16p_in_0) << 1;
  *valp = opnd_ae_sem_loads_stores_i16p_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i16p_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i16p_in_0;
  unsigned opnd_ae_sem_loads_stores_i16p_out_0;
  opnd_ae_sem_loads_stores_i16p_out_0 = *valp;
  opnd_ae_sem_loads_stores_i16p_in_0 = ((opnd_ae_sem_loads_stores_i16p_out_0 >> 1) & 0x1f);
  *valp = opnd_ae_sem_loads_stores_i16p_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i16_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i16_out_0;
  unsigned opnd_ae_sem_loads_stores_i16_in_0;
  opnd_ae_sem_loads_stores_i16_in_0 = *valp & 0xff;
  opnd_ae_sem_loads_stores_i16_out_0 = ((((-(( ( ((((opnd_ae_sem_loads_stores_i16_in_0 >> 3) & 0x1f)) | 0xffffffe0)) == 0xffffffff))) & 0xffffff) << 8) | opnd_ae_sem_loads_stores_i16_in_0) << 1;
  *valp = opnd_ae_sem_loads_stores_i16_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i16_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_loads_stores_i16_in_0;
  unsigned opnd_ae_sem_loads_stores_i16_out_0;
  opnd_ae_sem_loads_stores_i16_out_0 = *valp;
  opnd_ae_sem_loads_stores_i16_in_0 = ((opnd_ae_sem_loads_stores_i16_out_0 >> 1) & 0xff);
  *valp = opnd_ae_sem_loads_stores_i16_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_AE_VALIGN_decode (uint32 *valp ATTRIBUTE_UNUSED)
{
  return 0;
}

static int
OperandSem_opnd_sem_AE_VALIGN_encode (uint32 *valp)
{
  int error = 0;
  error = (*valp >= 4);
  return error;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_dr_to_dr_imm_movi_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_dr_to_dr_imm_movi_out_0;
  unsigned opnd_ae_sem_dr_to_dr_imm_movi_in_0;
  opnd_ae_sem_dr_to_dr_imm_movi_in_0 = *valp & 0xff;
  opnd_ae_sem_dr_to_dr_imm_movi_out_0 = (((-(( ( ((((opnd_ae_sem_dr_to_dr_imm_movi_in_0 >> 5) & 0x7)) | 0xfffffff8)) == 0xffffffff))) & 0xffffff) << 8) | opnd_ae_sem_dr_to_dr_imm_movi_in_0;
  *valp = opnd_ae_sem_dr_to_dr_imm_movi_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_dr_to_dr_imm_movi_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_dr_to_dr_imm_movi_in_0;
  unsigned opnd_ae_sem_dr_to_dr_imm_movi_out_0;
  opnd_ae_sem_dr_to_dr_imm_movi_out_0 = *valp;
  opnd_ae_sem_dr_to_dr_imm_movi_in_0 = (opnd_ae_sem_dr_to_dr_imm_movi_out_0 & 0xff);
  *valp = opnd_ae_sem_dr_to_dr_imm_movi_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_arithmetic_i_imm1_decode (uint32 *valp)
{
  unsigned opnd_ae_sem_arithmetic_i_imm1_out_0;
  unsigned opnd_ae_sem_arithmetic_i_imm1_in_0;
  opnd_ae_sem_arithmetic_i_imm1_in_0 = *valp & 0x1;
  opnd_ae_sem_arithmetic_i_imm1_out_0 = (0 << 1) | opnd_ae_sem_arithmetic_i_imm1_in_0;
  *valp = opnd_ae_sem_arithmetic_i_imm1_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_opnd_ae_sem_arithmetic_i_imm1_encode (uint32 *valp)
{
  unsigned opnd_ae_sem_arithmetic_i_imm1_in_0;
  unsigned opnd_ae_sem_arithmetic_i_imm1_out_0;
  opnd_ae_sem_arithmetic_i_imm1_out_0 = *valp;
  opnd_ae_sem_arithmetic_i_imm1_in_0 = (((opnd_ae_sem_arithmetic_i_imm1_out_0 >> 0) & 1)) & 0x1;
  *valp = opnd_ae_sem_arithmetic_i_imm1_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_bbi_decode (uint32 *valp)
{
  unsigned bbi_out_0;
  unsigned bbi_in_0;
  bbi_in_0 = *valp & 0x1f;
  bbi_out_0 = (0 << 5) | bbi_in_0;
  *valp = bbi_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_bbi_encode (uint32 *valp)
{
  unsigned bbi_in_0;
  unsigned bbi_out_0;
  bbi_out_0 = *valp;
  bbi_in_0 = (bbi_out_0 & 0x1f);
  *valp = bbi_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_s_decode (uint32 *valp)
{
  unsigned s_out_0;
  unsigned s_in_0;
  s_in_0 = *valp & 0xf;
  s_out_0 = (0 << 4) | s_in_0;
  *valp = s_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_s_encode (uint32 *valp)
{
  unsigned s_in_0;
  unsigned s_out_0;
  s_out_0 = *valp;
  s_in_0 = (s_out_0 & 0xf);
  *valp = s_in_0;
  return 0;
}

static int
OperandSem_opnd_sem_bitindex_decode (uint32 *valp)
{
  unsigned bitindex_out_0;
  unsigned bitindex_in_0;
  bitindex_in_0 = *valp & 0x1f;
  bitindex_out_0 = (0 << 5) | bitindex_in_0;
  *valp = bitindex_out_0;
  return 0;
}

static int
OperandSem_opnd_sem_bitindex_encode (uint32 *valp)
{
  unsigned bitindex_in_0;
  unsigned bitindex_out_0;
  bitindex_out_0 = *valp;
  bitindex_in_0 = (bitindex_out_0 & 0x1f);
  *valp = bitindex_in_0;
  return 0;
}

static int
Operand_soffsetx4_ator (uint32 *valp, uint32 pc)
{
  *valp -= (pc & ~0x3);
  return 0;
}

static int
Operand_soffsetx4_rtoa (uint32 *valp, uint32 pc)
{
  *valp += (pc & ~0x3);
  return 0;
}

static int
Operand_uimm6_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_uimm6_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_label8_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_label8_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_ulabel8_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_ulabel8_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_label12_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_label12_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_soffset_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_soffset_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_uimm16x4_ator (uint32 *valp, uint32 pc)
{
  *valp -= ((pc + 3) & ~0x3);
  return 0;
}

static int
Operand_uimm16x4_rtoa (uint32 *valp, uint32 pc)
{
  *valp += ((pc + 3) & ~0x3);
  return 0;
}

static int
Operand_xt_wbr15_label_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_xt_wbr15_label_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static int
Operand_xt_wloop_label_ator (uint32 *valp, uint32 pc)
{
  *valp -= pc;
  return 0;
}

static int
Operand_xt_wloop_label_rtoa (uint32 *valp, uint32 pc)
{
  *valp += pc;
  return 0;
}

static xtensa_operand_internal operands[] = {
  { "soffsetx4", FIELD_offset, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_soffsetx4_encode, OperandSem_opnd_sem_soffsetx4_decode,
    Operand_soffsetx4_ator, Operand_soffsetx4_rtoa,
    -1, 0 },
  { "immr", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_immr_encode, OperandSem_opnd_sem_immr_decode,
    0, 0,
    -1, 0 },
  { "uimm12x8", FIELD_imm12, -1, 0,
    0,
    OperandSem_opnd_sem_uimm12x8_encode, OperandSem_opnd_sem_uimm12x8_decode,
    0, 0,
    -1, 0 },
  { "simm4", FIELD_mn, -1, 0,
    0,
    OperandSem_opnd_sem_simm4_encode, OperandSem_opnd_sem_simm4_decode,
    0, 0,
    -1, 0 },
  { "arr", FIELD_r, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "ars", FIELD_s, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "*ars_invisible", FIELD_s, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "art", FIELD_t, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "ar0", FIELD__ar0, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_0_encode, OperandSem_opnd_sem_AR_0_decode,
    0, 0,
    0, 31 },
  { "ar4", FIELD__ar4, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_4_encode, OperandSem_opnd_sem_AR_4_decode,
    0, 0,
    0, 31 },
  { "ar8", FIELD__ar8, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_8_encode, OperandSem_opnd_sem_AR_8_decode,
    0, 0,
    0, 31 },
  { "ar12", FIELD__ar12, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER | XTENSA_OPERAND_IS_INVISIBLE,
    OperandSem_opnd_sem_AR_12_encode, OperandSem_opnd_sem_AR_12_decode,
    0, 0,
    0, 31 },
  { "ars_entry", FIELD_s, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_entry_encode, OperandSem_opnd_sem_AR_entry_decode,
    0, 0,
    0, 31 },
  { "immrx4", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_immrx4_encode, OperandSem_opnd_sem_immrx4_decode,
    0, 0,
    -1, 0 },
  { "lsi4x4", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_lsi4x4_encode, OperandSem_opnd_sem_lsi4x4_decode,
    0, 0,
    -1, 0 },
  { "simm7", FIELD_imm7, -1, 0,
    0,
    OperandSem_opnd_sem_simm7_encode, OperandSem_opnd_sem_simm7_decode,
    0, 0,
    -1, 0 },
  { "uimm6", FIELD_imm6, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_uimm6_encode, OperandSem_opnd_sem_uimm6_decode,
    Operand_uimm6_ator, Operand_uimm6_rtoa,
    -1, 0 },
  { "ai4const", FIELD_t, -1, 0,
    0,
    OperandSem_opnd_sem_ai4const_encode, OperandSem_opnd_sem_ai4const_decode,
    0, 0,
    -1, 0 },
  { "b4const", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_b4const_encode, OperandSem_opnd_sem_b4const_decode,
    0, 0,
    -1, 0 },
  { "b4constu", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_b4constu_encode, OperandSem_opnd_sem_b4constu_decode,
    0, 0,
    -1, 0 },
  { "immt", FIELD_t, -1, 0,
    0,
    OperandSem_opnd_sem_immt_encode, OperandSem_opnd_sem_immt_decode,
    0, 0,
    -1, 0 },
  { "uimms8", FIELD_imms8, -1, 0,
    0,
    OperandSem_opnd_sem_uimms8_encode, OperandSem_opnd_sem_uimms8_decode,
    0, 0,
    -1, 0 },
  { "uimm8", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_uimm8_encode, OperandSem_opnd_sem_uimm8_decode,
    0, 0,
    -1, 0 },
  { "uimm8x2", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_uimm8x2_encode, OperandSem_opnd_sem_uimm8x2_decode,
    0, 0,
    -1, 0 },
  { "uimm8x4", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_uimm8x4_encode, OperandSem_opnd_sem_uimm8x4_decode,
    0, 0,
    -1, 0 },
  { "uimm4x16", FIELD_op2, -1, 0,
    0,
    OperandSem_opnd_sem_uimm4x16_encode, OperandSem_opnd_sem_uimm4x16_decode,
    0, 0,
    -1, 0 },
  { "uimmrx4", FIELD_r, -1, 0,
    0,
    OperandSem_opnd_sem_uimmrx4_encode, OperandSem_opnd_sem_uimmrx4_decode,
    0, 0,
    -1, 0 },
  { "simm8", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_simm8_encode, OperandSem_opnd_sem_simm8_decode,
    0, 0,
    -1, 0 },
  { "simm8x256", FIELD_imm8, -1, 0,
    0,
    OperandSem_opnd_sem_simm8x256_encode, OperandSem_opnd_sem_simm8x256_decode,
    0, 0,
    -1, 0 },
  { "simm12b", FIELD_imm12b, -1, 0,
    0,
    OperandSem_opnd_sem_simm12b_encode, OperandSem_opnd_sem_simm12b_decode,
    0, 0,
    -1, 0 },
  { "msalp32", FIELD_sal, -1, 0,
    0,
    OperandSem_opnd_sem_msalp32_encode, OperandSem_opnd_sem_msalp32_decode,
    0, 0,
    -1, 0 },
  { "op2p1", FIELD_op2, -1, 0,
    0,
    OperandSem_opnd_sem_op2p1_encode, OperandSem_opnd_sem_op2p1_decode,
    0, 0,
    -1, 0 },
  { "low_depbits", FIELD_f_low_depbits, -1, 0,
    0,
    OperandSem_opnd_sem_low_depbits_encode, OperandSem_opnd_sem_low_depbits_decode,
    0, 0,
    -1, 0 },
  { "lngth_depbits", FIELD_f_lngth_depbits, -1, 0,
    0,
    OperandSem_opnd_sem_lngth_depbits_encode, OperandSem_opnd_sem_lngth_depbits_decode,
    0, 0,
    -1, 0 },
  { "label8", FIELD_imm8, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_label8_encode, OperandSem_opnd_sem_label8_decode,
    Operand_label8_ator, Operand_label8_rtoa,
    -1, 0 },
  { "ulabel8", FIELD_imm8, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_ulabel8_encode, OperandSem_opnd_sem_ulabel8_decode,
    Operand_ulabel8_ator, Operand_ulabel8_rtoa,
    -1, 0 },
  { "label12", FIELD_imm12, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_label12_encode, OperandSem_opnd_sem_label12_decode,
    Operand_label12_ator, Operand_label12_rtoa,
    -1, 0 },
  { "soffset", FIELD_offset, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_soffset_encode, OperandSem_opnd_sem_soffset_decode,
    Operand_soffset_ator, Operand_soffset_rtoa,
    -1, 0 },
  { "uimm16x4", FIELD_imm16, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_uimm16x4_encode, OperandSem_opnd_sem_uimm16x4_decode,
    Operand_uimm16x4_ator, Operand_uimm16x4_rtoa,
    -1, 0 },
  { "imms", FIELD_s, -1, 0,
    0,
    OperandSem_opnd_sem_imms_encode, OperandSem_opnd_sem_imms_decode,
    0, 0,
    -1, 0 },
  { "imms1", FIELD_s, -1, 0,
    0,
    OperandSem_opnd_sem_imms_encode, OperandSem_opnd_sem_imms_decode,
    0, 0,
    -1, 0 },
  { "tp7", FIELD_t, -1, 0,
    0,
    OperandSem_opnd_sem_tp7_encode, OperandSem_opnd_sem_tp7_decode,
    0, 0,
    -1, 0 },
  { "xt_wbr15_label", FIELD_xt_wbr15_imm, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_xt_wbr15_label_encode, OperandSem_opnd_sem_xt_wbr15_label_decode,
    Operand_xt_wbr15_label_ator, Operand_xt_wbr15_label_rtoa,
    -1, 0 },
  { "xt_wloop_label", FIELD_xt_wloop_imm, -1, 0,
    XTENSA_OPERAND_IS_PCRELATIVE,
    OperandSem_opnd_sem_xt_wloop_label_encode, OperandSem_opnd_sem_xt_wloop_label_decode,
    Operand_xt_wloop_label_ator, Operand_xt_wloop_label_rtoa,
    -1, 0 },
  { "ae_ohba", FIELD_ae_fld_fhba4, -1, 0,
    0,
    OperandSem_opnd_sem_ae_ohba_encode, OperandSem_opnd_sem_ae_ohba_decode,
    0, 0,
    -1, 0 },
  { "ae_ohba2", FIELD_ae_fld_fhba4_2, -1, 0,
    0,
    OperandSem_opnd_sem_ae_ohba_encode, OperandSem_opnd_sem_ae_ohba_decode,
    0, 0,
    -1, 0 },
  { "ae_opnd_tp7", FIELD_ae_fld_tp7, -1, 0,
    0,
    OperandSem_opnd_sem_ae_opnd_tp7_encode, OperandSem_opnd_sem_ae_opnd_tp7_decode,
    0, 0,
    -1, 0 },
  { "ae_imm2", FIELD_ae_fld_imm2, -1, 0,
    0,
    OperandSem_opnd_sem_ae_imm2_encode, OperandSem_opnd_sem_ae_imm2_decode,
    0, 0,
    -1, 0 },
  { "ae_osa16", FIELD_ae_fld_osa16, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa16_encode, OperandSem_opnd_sem_ae_osa16_decode,
    0, 0,
    -1, 0 },
  { "ae_osa32", FIELD_ae_fld_osa32, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa32_encode, OperandSem_opnd_sem_ae_osa32_decode,
    0, 0,
    -1, 0 },
  { "ae_osa64", FIELD_ae_fld_osa64, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa64_encode, OperandSem_opnd_sem_ae_osa64_decode,
    0, 0,
    -1, 0 },
  { "ae_selimm", FIELD_ae_fld_selimm, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa16_encode, OperandSem_opnd_sem_ae_osa16_decode,
    0, 0,
    -1, 0 },
  { "stage3_ar_operand", FIELD_fld_stage3_ar_operand, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "ae_uimm2x2", FIELD_ae_fld_Inst16b_12, -1, 0,
    0,
    OperandSem_opnd_sem_ae_uimm2x2_encode, OperandSem_opnd_sem_ae_uimm2x2_decode,
    0, 0,
    -1, 0 },
  { "opnd_ae_sem_dr_to_dr_v", FIELD_fld_ae_sem_dr_to_dr_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_dr_to_dr_v0", FIELD_fld_ae_sem_dr_to_dr_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_arithmetic_v", FIELD_fld_ae_sem_arithmetic_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_arithmetic_v1", FIELD_fld_ae_sem_arithmetic_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_spfma_v", FIELD_fld_ae_sem_spfma_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_spfma_v0", FIELD_fld_ae_sem_spfma_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_spfma_v1", FIELD_fld_ae_sem_spfma_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_arithmetic_v0", FIELD_fld_ae_sem_arithmetic_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_ar_to_ar_arr", FIELD_fld_ae_sem_ar_to_ar_arr, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "opnd_ae_sem_ar_to_ar_ars", FIELD_fld_ae_sem_ar_to_ar_ars, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "opnd_ae_sem_ar_to_ar_art", FIELD_fld_ae_sem_ar_to_ar_art, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "opnd_ae_sem_vbool_vbr", FIELD_fld_ae_sem_vbool_vbr, REGFILE_vbool, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_vbool_encode, OperandSem_opnd_sem_vbool_decode,
    0, 0,
    0, 7 },
  { "opnd_ae_sem_vbool_vbs", FIELD_fld_ae_sem_vbool_vbs, REGFILE_vbool, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_vbool_encode, OperandSem_opnd_sem_vbool_decode,
    0, 0,
    0, 7 },
  { "opnd_ae_sem_vbool_vbt", FIELD_fld_ae_sem_vbool_vbt, REGFILE_vbool, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_vbool_encode, OperandSem_opnd_sem_vbool_decode,
    0, 0,
    0, 7 },
  { "opnd_ae_sem_dr_to_dr_v1", FIELD_fld_ae_sem_dr_to_dr_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_dr_to_ar_a", FIELD_fld_ae_sem_dr_to_ar_a, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "opnd_ae_sem_ar_to_dr_a0", FIELD_fld_ae_sem_ar_to_dr_a0, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "opnd_ae_sem_ar_to_dr_v", FIELD_fld_ae_sem_ar_to_dr_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_ar_to_dr_a1", FIELD_fld_ae_sem_ar_to_dr_a1, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "opnd_ae_sem_sb_loads_stores_vbr", FIELD_fld_ae_sem_sb_loads_stores_vbr, REGFILE_vbool, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_vbool_encode, OperandSem_opnd_sem_vbool_decode,
    0, 0,
    0, 7 },
  { "opnd_ae_sem_arithmetic_vbt", FIELD_fld_ae_sem_arithmetic_vbt, REGFILE_vbool, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_vbool_encode, OperandSem_opnd_sem_vbool_decode,
    0, 0,
    0, 7 },
  { "opnd_ae_sem_vbool_i_imm3", FIELD_fld_ae_sem_vbool_i_imm3, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_vbool_i_imm3_encode, OperandSem_opnd_sem_opnd_ae_sem_vbool_i_imm3_decode,
    0, 0,
    -1, 0 },
  { "opnd_ae_sem_loads_stores_a", FIELD_fld_ae_sem_loads_stores_a, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "opnd_ae_sem_loads_stores_i8p", FIELD_fld_ae_sem_loads_stores_i8p, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i8p_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i8p_decode,
    0, 0,
    -1, 0 },
  { "opnd_ae_sem_loads_stores_v", FIELD_fld_ae_sem_loads_stores_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_loads_stores_i8", FIELD_fld_ae_sem_loads_stores_i8, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i8_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i8_decode,
    0, 0,
    -1, 0 },
  { "opnd_ae_sem_loads_stores_i32p", FIELD_fld_ae_sem_loads_stores_i32p, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i32p_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i32p_decode,
    0, 0,
    -1, 0 },
  { "opnd_ae_sem_loads_stores_i32", FIELD_fld_ae_sem_loads_stores_i32, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i32_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i32_decode,
    0, 0,
    -1, 0 },
  { "opnd_ae_sem_loads_stores_x", FIELD_fld_ae_sem_loads_stores_x, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "opnd_ae_sem_loads_stores_i64p", FIELD_fld_ae_sem_loads_stores_i64p, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64p_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64p_decode,
    0, 0,
    -1, 0 },
  { "opnd_ae_sem_loads_stores_i64", FIELD_fld_ae_sem_loads_stores_i64, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i64_decode,
    0, 0,
    -1, 0 },
  { "opnd_ae_sem_loads_stores_i16m", FIELD_fld_ae_sem_loads_stores_i16m, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i16m_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i16m_decode,
    0, 0,
    -1, 0 },
  { "opnd_ae_sem_loads_stores_i32m", FIELD_fld_ae_sem_loads_stores_i32m, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i32m_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i32m_decode,
    0, 0,
    -1, 0 },
  { "opnd_ae_sem_loads_stores_i16p", FIELD_fld_ae_sem_loads_stores_i16p, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i16p_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i16p_decode,
    0, 0,
    -1, 0 },
  { "opnd_ae_sem_loads_stores_i16", FIELD_fld_ae_sem_loads_stores_i16, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i16_encode, OperandSem_opnd_sem_opnd_ae_sem_loads_stores_i16_decode,
    0, 0,
    -1, 0 },
  { "opnd_ae_sem_loads_stores_uu", FIELD_fld_ae_sem_loads_stores_uu, REGFILE_AE_VALIGN, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_VALIGN_encode, OperandSem_opnd_sem_AE_VALIGN_decode,
    0, 0,
    0, 3 },
  { "opnd_ae_sem_sb_loads_stores_ar_p", FIELD_fld_ae_sem_sb_loads_stores_ar_p, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "opnd_ae_sem_sb_loads_stores_ar_u", FIELD_fld_ae_sem_sb_loads_stores_ar_u, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "opnd_ae_sem_vbool_arr", FIELD_fld_ae_sem_vbool_arr, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "opnd_ae_sem_cmov_vbr", FIELD_fld_ae_sem_cmov_vbr, REGFILE_vbool, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_vbool_encode, OperandSem_opnd_sem_vbool_decode,
    0, 0,
    0, 7 },
  { "opnd_ae_sem_cmov_vbt", FIELD_fld_ae_sem_cmov_vbt, REGFILE_vbool, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_vbool_encode, OperandSem_opnd_sem_vbool_decode,
    0, 0,
    0, 7 },
  { "opnd_ae_sem_vbool_art", FIELD_fld_ae_sem_vbool_art, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "opnd_ae_sem_dr_to_ar_v0", FIELD_fld_ae_sem_dr_to_ar_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_loads_stores_vu", FIELD_fld_ae_sem_loads_stores_vu, REGFILE_AE_VALIGN, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_VALIGN_encode, OperandSem_opnd_sem_AE_VALIGN_decode,
    0, 0,
    0, 3 },
  { "opnd_ae_sem_movstate1_v0", FIELD_fld_ae_sem_movstate1_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_cmov_v", FIELD_fld_ae_sem_cmov_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_cmov_v0", FIELD_fld_ae_sem_cmov_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_movstate2_v0", FIELD_fld_ae_sem_movstate2_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_dr_to_dr_imm_movi", FIELD_fld_ae_sem_dr_to_dr_imm_movi, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_dr_to_dr_imm_movi_encode, OperandSem_opnd_sem_opnd_ae_sem_dr_to_dr_imm_movi_decode,
    0, 0,
    -1, 0 },
  { "opnd_ae_sem_movstate1_v", FIELD_fld_ae_sem_movstate1_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_movstate2_v", FIELD_fld_ae_sem_movstate2_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_mul_x2_S1_d0", FIELD_fld_ae_sem_mul_x2_S1_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_mul_x2_S1_d1", FIELD_fld_ae_sem_mul_x2_S1_d1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_mul_x2_S1_q0", FIELD_fld_ae_sem_mul_x2_S1_q0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_shift_d", FIELD_fld_ae_sem_shift_d, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_shift_d0", FIELD_fld_ae_sem_shift_d0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_loads_stores_su", FIELD_fld_ae_sem_loads_stores_su, REGFILE_AE_VALIGN, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_VALIGN_encode, OperandSem_opnd_sem_AE_VALIGN_decode,
    0, 0,
    0, 3 },
  { "opnd_ae_sem_shift_a0", FIELD_fld_ae_sem_shift_a0, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "opnd_ae_sem_shift_sd", FIELD_fld_ae_sem_shift_sd, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_vldc_loads_stores_done", FIELD_fld_ae_sem_vldc_loads_stores_done, REGFILE_vbool, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_vbool_encode, OperandSem_opnd_sem_vbool_decode,
    0, 0,
    0, 7 },
  { "opnd_ae_sem_arithmetic_i_imm1", FIELD_fld_ae_sem_arithmetic_i_imm1, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_arithmetic_i_imm1_encode, OperandSem_opnd_sem_opnd_ae_sem_arithmetic_i_imm1_decode,
    0, 0,
    -1, 0 },
  { "opnd_ae_sem_dr_to_dr_i_imm4", FIELD_fld_ae_sem_dr_to_dr_i_imm4, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa16_encode, OperandSem_opnd_sem_ae_osa16_decode,
    0, 0,
    -1, 0 },
  { "opnd_ae_sem_spcvtlookup_v", FIELD_fld_ae_sem_spcvtlookup_v, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_spcvtlookup_v0", FIELD_fld_ae_sem_spcvtlookup_v0, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_spcvtlookup_i_imm5", FIELD_fld_ae_sem_spcvtlookup_i_imm5, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa32_encode, OperandSem_opnd_sem_ae_osa32_decode,
    0, 0,
    -1, 0 },
  { "opnd_ae_sem_spcvtlookup_arr", FIELD_fld_ae_sem_spcvtlookup_arr, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "opnd_ae_sem_spfma_i_imm4", FIELD_fld_ae_sem_spfma_i_imm4, -1, 0,
    0,
    OperandSem_opnd_sem_ae_osa16_encode, OperandSem_opnd_sem_ae_osa16_decode,
    0, 0,
    -1, 0 },
  { "opnd_ae_sem_spcvtlookup_v1", FIELD_fld_ae_sem_spcvtlookup_v1, REGFILE_AE_DR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AE_DR_encode, OperandSem_opnd_sem_AE_DR_decode,
    0, 0,
    0, 15 },
  { "opnd_ae_sem_cmov_arr", FIELD_fld_ae_sem_cmov_arr, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "opnd_ae_sem_spfma_i_imm3", FIELD_fld_ae_sem_spfma_i_imm3, -1, 0,
    0,
    OperandSem_opnd_sem_opnd_ae_sem_vbool_i_imm3_encode, OperandSem_opnd_sem_opnd_ae_sem_vbool_i_imm3_decode,
    0, 0,
    -1, 0 },
  { "opnd_ae_sem_rur_wur_a", FIELD_fld_ae_sem_rur_wur_a, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "opnd_ae_sem_spcvtlookup_art", FIELD_fld_ae_sem_spcvtlookup_art, REGFILE_AR, 1,
    XTENSA_OPERAND_IS_REGISTER,
    OperandSem_opnd_sem_AR_encode, OperandSem_opnd_sem_AR_decode,
    0, 0,
    0, 31 },
  { "bbi", FIELD_bbi, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0,
    -1, 0 },
  { "sae", FIELD_sae, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0,
    -1, 0 },
  { "sas", FIELD_sas, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0,
    -1, 0 },
  { "sargt", FIELD_sargt, -1, 0,
    0,
    OperandSem_opnd_sem_bbi_encode, OperandSem_opnd_sem_bbi_decode,
    0, 0,
    -1, 0 },
  { "s", FIELD_s, -1, 0,
    0,
    OperandSem_opnd_sem_s_encode, OperandSem_opnd_sem_s_decode,
    0, 0,
    -1, 0 },
  { "bitindex", FIELD_bitindex, -1, 0,
    0,
    OperandSem_opnd_sem_bitindex_encode, OperandSem_opnd_sem_bitindex_decode,
    0, 0,
    -1, 0 },
  { "t", FIELD_t, -1, 0, 0, 0, 0, 0, 0 },
  { "bbi4", FIELD_bbi4, -1, 0, 0, 0, 0, 0, 0 },
  { "imm12", FIELD_imm12, -1, 0, 0, 0, 0, 0, 0 },
  { "imm8", FIELD_imm8, -1, 0, 0, 0, 0, 0, 0 },
  { "s8", FIELD_s8, -1, 0, 0, 0, 0, 0, 0 },
  { "imms8", FIELD_imms8, -1, 0, 0, 0, 0, 0, 0 },
  { "imm12b", FIELD_imm12b, -1, 0, 0, 0, 0, 0, 0 },
  { "imm16", FIELD_imm16, -1, 0, 0, 0, 0, 0, 0 },
  { "m", FIELD_m, -1, 0, 0, 0, 0, 0, 0 },
  { "n", FIELD_n, -1, 0, 0, 0, 0, 0, 0 },
  { "offset", FIELD_offset, -1, 0, 0, 0, 0, 0, 0 },
  { "op0", FIELD_op0, -1, 0, 0, 0, 0, 0, 0 },
  { "op1", FIELD_op1, -1, 0, 0, 0, 0, 0, 0 },
  { "op2", FIELD_op2, -1, 0, 0, 0, 0, 0, 0 },
  { "r", FIELD_r, -1, 0, 0, 0, 0, 0, 0 },
  { "r_disp", FIELD_r_disp, -1, 0, 0, 0, 0, 0, 0 },
  { "r_3", FIELD_r_3, -1, 0, 0, 0, 0, 0, 0 },
  { "sa4", FIELD_sa4, -1, 0, 0, 0, 0, 0, 0 },
  { "sae4", FIELD_sae4, -1, 0, 0, 0, 0, 0, 0 },
  { "sal", FIELD_sal, -1, 0, 0, 0, 0, 0, 0 },
  { "sas4", FIELD_sas4, -1, 0, 0, 0, 0, 0, 0 },
  { "sr", FIELD_sr, -1, 0, 0, 0, 0, 0, 0 },
  { "st", FIELD_st, -1, 0, 0, 0, 0, 0, 0 },
  { "thi3", FIELD_thi3, -1, 0, 0, 0, 0, 0, 0 },
  { "f_low_depbits", FIELD_f_low_depbits, -1, 0, 0, 0, 0, 0, 0 },
  { "f_lngth_depbits", FIELD_f_lngth_depbits, -1, 0, 0, 0, 0, 0, 0 },
  { "imm4", FIELD_imm4, -1, 0, 0, 0, 0, 0, 0 },
  { "mn", FIELD_mn, -1, 0, 0, 0, 0, 0, 0 },
  { "i", FIELD_i, -1, 0, 0, 0, 0, 0, 0 },
  { "imm6lo", FIELD_imm6lo, -1, 0, 0, 0, 0, 0, 0 },
  { "imm6hi", FIELD_imm6hi, -1, 0, 0, 0, 0, 0, 0 },
  { "imm7lo", FIELD_imm7lo, -1, 0, 0, 0, 0, 0, 0 },
  { "imm7hi", FIELD_imm7hi, -1, 0, 0, 0, 0, 0, 0 },
  { "z", FIELD_z, -1, 0, 0, 0, 0, 0, 0 },
  { "imm6", FIELD_imm6, -1, 0, 0, 0, 0, 0, 0 },
  { "imm7", FIELD_imm7, -1, 0, 0, 0, 0, 0, 0 },
  { "xt_wbr15_imm", FIELD_xt_wbr15_imm, -1, 0, 0, 0, 0, 0, 0 },
  { "xt_wloop_imm", FIELD_xt_wloop_imm, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_fhba4", FIELD_ae_fld_fhba4, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_fhba4_2", FIELD_ae_fld_fhba4_2, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_tp7", FIELD_ae_fld_tp7, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_osa16", FIELD_ae_fld_osa16, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_osa32", FIELD_ae_fld_osa32, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_osa64", FIELD_ae_fld_osa64, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_imm2", FIELD_ae_fld_imm2, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_selimm", FIELD_ae_fld_selimm, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_stage3_ar_operand", FIELD_fld_stage3_ar_operand, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_Inst16b_12", FIELD_ae_fld_Inst16b_12, -1, 0, 0, 0, 0, 0, 0 },
  { "ae_fld_Inst16b_15_13", FIELD_ae_fld_Inst16b_15_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_11_0", FIELD_fld_F0_S0_11_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_11_2", FIELD_fld_F0_S0_11_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_11_4", FIELD_fld_F0_S0_11_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_11_8", FIELD_fld_F0_S0_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_13_12", FIELD_fld_F0_S0_13_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_22_0", FIELD_fld_F0_S0_22_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_22_10", FIELD_fld_F0_S0_22_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_22_12", FIELD_fld_F0_S0_22_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_22_13", FIELD_fld_F0_S0_22_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_22_14", FIELD_fld_F0_S0_22_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_22_16", FIELD_fld_F0_S0_22_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_22_17", FIELD_fld_F0_S0_22_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_22_18", FIELD_fld_F0_S0_22_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_22_20", FIELD_fld_F0_S0_22_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_22_4", FIELD_fld_F0_S0_22_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_22_8", FIELD_fld_F0_S0_22_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_3_0", FIELD_fld_F0_S0_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_3_2", FIELD_fld_F0_S0_3_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_3_3", FIELD_fld_F0_S0_3_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_7_4", FIELD_fld_F0_S0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_7_5", FIELD_fld_F0_S0_7_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_9_3", FIELD_fld_F0_S0_9_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_9_5", FIELD_fld_F0_S0_9_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S0_9_9", FIELD_fld_F0_S0_9_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_ar_to_ar_arr", FIELD_fld_ae_sem_ar_to_ar_arr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_ar_to_ar_ars", FIELD_fld_ae_sem_ar_to_ar_ars, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_ar_to_ar_art", FIELD_fld_ae_sem_ar_to_ar_art, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_ar_to_dr_a0", FIELD_fld_ae_sem_ar_to_dr_a0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_ar_to_dr_a1", FIELD_fld_ae_sem_ar_to_dr_a1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_ar_to_dr_v", FIELD_fld_ae_sem_ar_to_dr_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_cmov_arr", FIELD_fld_ae_sem_cmov_arr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_cmov_v", FIELD_fld_ae_sem_cmov_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_cmov_v0", FIELD_fld_ae_sem_cmov_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_cmov_vbr", FIELD_fld_ae_sem_cmov_vbr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_cmov_vbt", FIELD_fld_ae_sem_cmov_vbt, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_ar_a", FIELD_fld_ae_sem_dr_to_ar_a, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_ar_v0", FIELD_fld_ae_sem_dr_to_ar_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_dr_i_imm4", FIELD_fld_ae_sem_dr_to_dr_i_imm4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_dr_imm_movi", FIELD_fld_ae_sem_dr_to_dr_imm_movi, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_dr_v", FIELD_fld_ae_sem_dr_to_dr_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_dr_v0", FIELD_fld_ae_sem_dr_to_dr_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_a", FIELD_fld_ae_sem_loads_stores_a, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_i16", FIELD_fld_ae_sem_loads_stores_i16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_i16m", FIELD_fld_ae_sem_loads_stores_i16m, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_i16p", FIELD_fld_ae_sem_loads_stores_i16p, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_i32", FIELD_fld_ae_sem_loads_stores_i32, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_i32m", FIELD_fld_ae_sem_loads_stores_i32m, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_i32p", FIELD_fld_ae_sem_loads_stores_i32p, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_i64", FIELD_fld_ae_sem_loads_stores_i64, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_i64p", FIELD_fld_ae_sem_loads_stores_i64p, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_i8", FIELD_fld_ae_sem_loads_stores_i8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_i8p", FIELD_fld_ae_sem_loads_stores_i8p, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_su", FIELD_fld_ae_sem_loads_stores_su, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_uu", FIELD_fld_ae_sem_loads_stores_uu, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_v", FIELD_fld_ae_sem_loads_stores_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_vu", FIELD_fld_ae_sem_loads_stores_vu, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_loads_stores_x", FIELD_fld_ae_sem_loads_stores_x, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_rur_wur_a", FIELD_fld_ae_sem_rur_wur_a, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_a0", FIELD_fld_ae_sem_shift_a0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_d", FIELD_fld_ae_sem_shift_d, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_d0", FIELD_fld_ae_sem_shift_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spcvtlookup_arr", FIELD_fld_ae_sem_spcvtlookup_arr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spcvtlookup_art", FIELD_fld_ae_sem_spcvtlookup_art, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spcvtlookup_i_imm5", FIELD_fld_ae_sem_spcvtlookup_i_imm5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spcvtlookup_v", FIELD_fld_ae_sem_spcvtlookup_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spcvtlookup_v0", FIELD_fld_ae_sem_spcvtlookup_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_vbool_arr", FIELD_fld_ae_sem_vbool_arr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_vbool_art", FIELD_fld_ae_sem_vbool_art, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_vbool_i_imm3", FIELD_fld_ae_sem_vbool_i_imm3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_vbool_vbr", FIELD_fld_ae_sem_vbool_vbr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_vbool_vbs", FIELD_fld_ae_sem_vbool_vbs, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_vbool_vbt", FIELD_fld_ae_sem_vbool_vbt, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_vldc_loads_stores_done", FIELD_fld_ae_sem_vldc_loads_stores_done, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S1_20_0", FIELD_fld_F0_S1_20_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S1_20_10", FIELD_fld_F0_S1_20_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S1_20_12", FIELD_fld_F0_S1_20_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S1_20_13", FIELD_fld_F0_S1_20_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S1_20_15", FIELD_fld_F0_S1_20_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S1_20_16", FIELD_fld_F0_S1_20_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S1_20_17", FIELD_fld_F0_S1_20_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S1_20_7", FIELD_fld_F0_S1_20_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S1_20_8", FIELD_fld_F0_S1_20_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S1_20_9", FIELD_fld_F0_S1_20_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S1_3_0", FIELD_fld_F0_S1_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S1_3_3", FIELD_fld_F0_S1_3_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F0_S1_7_4", FIELD_fld_F0_S1_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_i_imm1", FIELD_fld_ae_sem_arithmetic_i_imm1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_v", FIELD_fld_ae_sem_arithmetic_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_v0", FIELD_fld_ae_sem_arithmetic_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_v1", FIELD_fld_ae_sem_arithmetic_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_arithmetic_vbt", FIELD_fld_ae_sem_arithmetic_vbt, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_dr_to_dr_v1", FIELD_fld_ae_sem_dr_to_dr_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x2_S1_d0", FIELD_fld_ae_sem_mul_x2_S1_d0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x2_S1_d1", FIELD_fld_ae_sem_mul_x2_S1_d1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_mul_x2_S1_q0", FIELD_fld_ae_sem_mul_x2_S1_q0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_nn_act_q1", FIELD_fld_ae_sem_nn_act_q1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_nn_act_v1", FIELD_fld_ae_sem_nn_act_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spfma_i_imm3", FIELD_fld_ae_sem_spfma_i_imm3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spfma_i_imm4", FIELD_fld_ae_sem_spfma_i_imm4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spfma_v", FIELD_fld_ae_sem_spfma_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spfma_v0", FIELD_fld_ae_sem_spfma_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spfma_v1", FIELD_fld_ae_sem_spfma_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S0_11_11", FIELD_fld_F1_S0_11_11, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S0_11_7", FIELD_fld_F1_S0_11_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S0_11_8", FIELD_fld_F1_S0_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S0_13_12", FIELD_fld_F1_S0_13_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S0_1_0", FIELD_fld_F1_S0_1_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S0_21_0", FIELD_fld_F1_S0_21_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S0_21_10", FIELD_fld_F1_S0_21_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S0_21_11", FIELD_fld_F1_S0_21_11, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S0_21_12", FIELD_fld_F1_S0_21_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S0_21_13", FIELD_fld_F1_S0_21_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S0_21_14", FIELD_fld_F1_S0_21_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S0_21_16", FIELD_fld_F1_S0_21_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S0_21_17", FIELD_fld_F1_S0_21_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S0_21_18", FIELD_fld_F1_S0_21_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S0_21_8", FIELD_fld_F1_S0_21_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S0_21_9", FIELD_fld_F1_S0_21_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S0_3_0", FIELD_fld_F1_S0_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S0_3_2", FIELD_fld_F1_S0_3_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S0_7_4", FIELD_fld_F1_S0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S0_7_7", FIELD_fld_F1_S0_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_spcvtlookup_v1", FIELD_fld_ae_sem_spcvtlookup_v1, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S1_11_3", FIELD_fld_F1_S1_11_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S1_11_4", FIELD_fld_F1_S1_11_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S1_11_8", FIELD_fld_F1_S1_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S1_20_0", FIELD_fld_F1_S1_20_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S1_20_12", FIELD_fld_F1_S1_20_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S1_20_15", FIELD_fld_F1_S1_20_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S1_20_16", FIELD_fld_F1_S1_20_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S1_7_0", FIELD_fld_F1_S1_7_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S1_7_4", FIELD_fld_F1_S1_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S1_7_5", FIELD_fld_F1_S1_7_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S1_7_6", FIELD_fld_F1_S1_7_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F1_S1_7_7", FIELD_fld_F1_S1_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_shift_sd", FIELD_fld_ae_sem_shift_sd, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_10_8", FIELD_fld_F2_S0_10_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_11_4", FIELD_fld_F2_S0_11_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_11_8", FIELD_fld_F2_S0_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_33_10", FIELD_fld_F2_S0_33_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_33_12", FIELD_fld_F2_S0_33_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_33_13", FIELD_fld_F2_S0_33_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_33_14", FIELD_fld_F2_S0_33_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_33_15", FIELD_fld_F2_S0_33_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_33_16", FIELD_fld_F2_S0_33_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_33_17", FIELD_fld_F2_S0_33_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_33_19", FIELD_fld_F2_S0_33_19, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_33_23", FIELD_fld_F2_S0_33_23, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_33_24", FIELD_fld_F2_S0_33_24, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_33_9", FIELD_fld_F2_S0_33_9, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_3_0", FIELD_fld_F2_S0_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_3_3", FIELD_fld_F2_S0_3_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_7_0", FIELD_fld_F2_S0_7_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_7_4", FIELD_fld_F2_S0_7_4, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_7_5", FIELD_fld_F2_S0_7_5, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_7_7", FIELD_fld_F2_S0_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_8_0", FIELD_fld_F2_S0_8_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_8_8", FIELD_fld_F2_S0_8_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_9_3", FIELD_fld_F2_S0_9_3, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_9_7", FIELD_fld_F2_S0_9_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F2_S0_9_8", FIELD_fld_F2_S0_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_movstate1_v", FIELD_fld_ae_sem_movstate1_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_movstate1_v0", FIELD_fld_ae_sem_movstate1_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_movstate2_v", FIELD_fld_ae_sem_movstate2_v, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_movstate2_v0", FIELD_fld_ae_sem_movstate2_v0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_sb_loads_stores_ar_p", FIELD_fld_ae_sem_sb_loads_stores_ar_p, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_sb_loads_stores_vbr", FIELD_fld_ae_sem_sb_loads_stores_vbr, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_11_10", FIELD_fld_Inst_11_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_11_8", FIELD_fld_Inst_11_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_15_12", FIELD_fld_Inst_15_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_19_12", FIELD_fld_Inst_19_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_19_16", FIELD_fld_Inst_19_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_19_17", FIELD_fld_Inst_19_17, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_19_18", FIELD_fld_Inst_19_18, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_19_8", FIELD_fld_Inst_19_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_23_10", FIELD_fld_Inst_23_10, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_23_11", FIELD_fld_Inst_23_11, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_23_12", FIELD_fld_Inst_23_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_23_14", FIELD_fld_Inst_23_14, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_23_15", FIELD_fld_Inst_23_15, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_23_16", FIELD_fld_Inst_23_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_23_20", FIELD_fld_Inst_23_20, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_23_21", FIELD_fld_Inst_23_21, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_23_23", FIELD_fld_Inst_23_23, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_23_8", FIELD_fld_Inst_23_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_3_0", FIELD_fld_Inst_3_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_7_0", FIELD_fld_Inst_7_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_7_6", FIELD_fld_Inst_7_6, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_7_7", FIELD_fld_Inst_7_7, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_Inst_9_8", FIELD_fld_Inst_9_8, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_ae_sem_sb_loads_stores_ar_u", FIELD_fld_ae_sem_sb_loads_stores_ar_u, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F3_S0_21_0", FIELD_fld_F3_S0_21_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F3_S0_21_12", FIELD_fld_F3_S0_21_12, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F3_S0_21_13", FIELD_fld_F3_S0_21_13, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F3_S0_21_16", FIELD_fld_F3_S0_21_16, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F3_S0_21_19", FIELD_fld_F3_S0_21_19, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F3_S0_3_2", FIELD_fld_F3_S0_3_2, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F3_S1_10_0", FIELD_fld_F3_S1_10_0, -1, 0, 0, 0, 0, 0, 0 },
  { "fld_F3_S1_10_8", FIELD_fld_F3_S1_10_8, -1, 0, 0, 0, 0, 0, 0 },
  { "s3to1", FIELD_s3to1, -1, 0, 0, 0, 0, 0, 0 }
};

enum xtensa_operand_id {
  OPERAND_soffsetx4,
  OPERAND_immr,
  OPERAND_uimm12x8,
  OPERAND_simm4,
  OPERAND_arr,
  OPERAND_ars,
  OPERAND__ars_invisible,
  OPERAND_art,
  OPERAND_ar0,
  OPERAND_ar4,
  OPERAND_ar8,
  OPERAND_ar12,
  OPERAND_ars_entry,
  OPERAND_immrx4,
  OPERAND_lsi4x4,
  OPERAND_simm7,
  OPERAND_uimm6,
  OPERAND_ai4const,
  OPERAND_b4const,
  OPERAND_b4constu,
  OPERAND_immt,
  OPERAND_uimms8,
  OPERAND_uimm8,
  OPERAND_uimm8x2,
  OPERAND_uimm8x4,
  OPERAND_uimm4x16,
  OPERAND_uimmrx4,
  OPERAND_simm8,
  OPERAND_simm8x256,
  OPERAND_simm12b,
  OPERAND_msalp32,
  OPERAND_op2p1,
  OPERAND_low_depbits,
  OPERAND_lngth_depbits,
  OPERAND_label8,
  OPERAND_ulabel8,
  OPERAND_label12,
  OPERAND_soffset,
  OPERAND_uimm16x4,
  OPERAND_imms,
  OPERAND_imms1,
  OPERAND_tp7,
  OPERAND_xt_wbr15_label,
  OPERAND_xt_wloop_label,
  OPERAND_ae_ohba,
  OPERAND_ae_ohba2,
  OPERAND_ae_opnd_tp7,
  OPERAND_ae_imm2,
  OPERAND_ae_osa16,
  OPERAND_ae_osa32,
  OPERAND_ae_osa64,
  OPERAND_ae_selimm,
  OPERAND_stage3_ar_operand,
  OPERAND_ae_uimm2x2,
  OPERAND_opnd_ae_sem_dr_to_dr_v,
  OPERAND_opnd_ae_sem_dr_to_dr_v0,
  OPERAND_opnd_ae_sem_arithmetic_v,
  OPERAND_opnd_ae_sem_arithmetic_v1,
  OPERAND_opnd_ae_sem_spfma_v,
  OPERAND_opnd_ae_sem_spfma_v0,
  OPERAND_opnd_ae_sem_spfma_v1,
  OPERAND_opnd_ae_sem_arithmetic_v0,
  OPERAND_opnd_ae_sem_ar_to_ar_arr,
  OPERAND_opnd_ae_sem_ar_to_ar_ars,
  OPERAND_opnd_ae_sem_ar_to_ar_art,
  OPERAND_opnd_ae_sem_vbool_vbr,
  OPERAND_opnd_ae_sem_vbool_vbs,
  OPERAND_opnd_ae_sem_vbool_vbt,
  OPERAND_opnd_ae_sem_dr_to_dr_v1,
  OPERAND_opnd_ae_sem_dr_to_ar_a,
  OPERAND_opnd_ae_sem_ar_to_dr_a0,
  OPERAND_opnd_ae_sem_ar_to_dr_v,
  OPERAND_opnd_ae_sem_ar_to_dr_a1,
  OPERAND_opnd_ae_sem_sb_loads_stores_vbr,
  OPERAND_opnd_ae_sem_arithmetic_vbt,
  OPERAND_opnd_ae_sem_vbool_i_imm3,
  OPERAND_opnd_ae_sem_loads_stores_a,
  OPERAND_opnd_ae_sem_loads_stores_i8p,
  OPERAND_opnd_ae_sem_loads_stores_v,
  OPERAND_opnd_ae_sem_loads_stores_i8,
  OPERAND_opnd_ae_sem_loads_stores_i32p,
  OPERAND_opnd_ae_sem_loads_stores_i32,
  OPERAND_opnd_ae_sem_loads_stores_x,
  OPERAND_opnd_ae_sem_loads_stores_i64p,
  OPERAND_opnd_ae_sem_loads_stores_i64,
  OPERAND_opnd_ae_sem_loads_stores_i16m,
  OPERAND_opnd_ae_sem_loads_stores_i32m,
  OPERAND_opnd_ae_sem_loads_stores_i16p,
  OPERAND_opnd_ae_sem_loads_stores_i16,
  OPERAND_opnd_ae_sem_loads_stores_uu,
  OPERAND_opnd_ae_sem_sb_loads_stores_ar_p,
  OPERAND_opnd_ae_sem_sb_loads_stores_ar_u,
  OPERAND_opnd_ae_sem_vbool_arr,
  OPERAND_opnd_ae_sem_cmov_vbr,
  OPERAND_opnd_ae_sem_cmov_vbt,
  OPERAND_opnd_ae_sem_vbool_art,
  OPERAND_opnd_ae_sem_dr_to_ar_v0,
  OPERAND_opnd_ae_sem_loads_stores_vu,
  OPERAND_opnd_ae_sem_movstate1_v0,
  OPERAND_opnd_ae_sem_cmov_v,
  OPERAND_opnd_ae_sem_cmov_v0,
  OPERAND_opnd_ae_sem_movstate2_v0,
  OPERAND_opnd_ae_sem_dr_to_dr_imm_movi,
  OPERAND_opnd_ae_sem_movstate1_v,
  OPERAND_opnd_ae_sem_movstate2_v,
  OPERAND_opnd_ae_sem_mul_x2_S1_d0,
  OPERAND_opnd_ae_sem_mul_x2_S1_d1,
  OPERAND_opnd_ae_sem_mul_x2_S1_q0,
  OPERAND_opnd_ae_sem_shift_d,
  OPERAND_opnd_ae_sem_shift_d0,
  OPERAND_opnd_ae_sem_loads_stores_su,
  OPERAND_opnd_ae_sem_shift_a0,
  OPERAND_opnd_ae_sem_shift_sd,
  OPERAND_opnd_ae_sem_vldc_loads_stores_done,
  OPERAND_opnd_ae_sem_arithmetic_i_imm1,
  OPERAND_opnd_ae_sem_dr_to_dr_i_imm4,
  OPERAND_opnd_ae_sem_spcvtlookup_v,
  OPERAND_opnd_ae_sem_spcvtlookup_v0,
  OPERAND_opnd_ae_sem_spcvtlookup_i_imm5,
  OPERAND_opnd_ae_sem_spcvtlookup_arr,
  OPERAND_opnd_ae_sem_spfma_i_imm4,
  OPERAND_opnd_ae_sem_spcvtlookup_v1,
  OPERAND_opnd_ae_sem_cmov_arr,
  OPERAND_opnd_ae_sem_spfma_i_imm3,
  OPERAND_opnd_ae_sem_rur_wur_a,
  OPERAND_opnd_ae_sem_spcvtlookup_art,
  OPERAND_bbi,
  OPERAND_sae,
  OPERAND_sas,
  OPERAND_sargt,
  OPERAND_s,
  OPERAND_bitindex,
  OPERAND_t,
  OPERAND_bbi4,
  OPERAND_imm12,
  OPERAND_imm8,
  OPERAND_s8,
  OPERAND_imms8,
  OPERAND_imm12b,
  OPERAND_imm16,
  OPERAND_m,
  OPERAND_n,
  OPERAND_offset,
  OPERAND_op0,
  OPERAND_op1,
  OPERAND_op2,
  OPERAND_r,
  OPERAND_r_disp,
  OPERAND_r_3,
  OPERAND_sa4,
  OPERAND_sae4,
  OPERAND_sal,
  OPERAND_sas4,
  OPERAND_sr,
  OPERAND_st,
  OPERAND_thi3,
  OPERAND_f_low_depbits,
  OPERAND_f_lngth_depbits,
  OPERAND_imm4,
  OPERAND_mn,
  OPERAND_i,
  OPERAND_imm6lo,
  OPERAND_imm6hi,
  OPERAND_imm7lo,
  OPERAND_imm7hi,
  OPERAND_z,
  OPERAND_imm6,
  OPERAND_imm7,
  OPERAND_xt_wbr15_imm,
  OPERAND_xt_wloop_imm,
  OPERAND_ae_fld_fhba4,
  OPERAND_ae_fld_fhba4_2,
  OPERAND_ae_fld_tp7,
  OPERAND_ae_fld_osa16,
  OPERAND_ae_fld_osa32,
  OPERAND_ae_fld_osa64,
  OPERAND_ae_fld_imm2,
  OPERAND_ae_fld_selimm,
  OPERAND_fld_stage3_ar_operand,
  OPERAND_ae_fld_Inst16b_12,
  OPERAND_ae_fld_Inst16b_15_13,
  OPERAND_fld_F0_S0_11_0,
  OPERAND_fld_F0_S0_11_2,
  OPERAND_fld_F0_S0_11_4,
  OPERAND_fld_F0_S0_11_8,
  OPERAND_fld_F0_S0_13_12,
  OPERAND_fld_F0_S0_22_0,
  OPERAND_fld_F0_S0_22_10,
  OPERAND_fld_F0_S0_22_12,
  OPERAND_fld_F0_S0_22_13,
  OPERAND_fld_F0_S0_22_14,
  OPERAND_fld_F0_S0_22_16,
  OPERAND_fld_F0_S0_22_17,
  OPERAND_fld_F0_S0_22_18,
  OPERAND_fld_F0_S0_22_20,
  OPERAND_fld_F0_S0_22_4,
  OPERAND_fld_F0_S0_22_8,
  OPERAND_fld_F0_S0_3_0,
  OPERAND_fld_F0_S0_3_2,
  OPERAND_fld_F0_S0_3_3,
  OPERAND_fld_F0_S0_7_4,
  OPERAND_fld_F0_S0_7_5,
  OPERAND_fld_F0_S0_9_3,
  OPERAND_fld_F0_S0_9_5,
  OPERAND_fld_F0_S0_9_9,
  OPERAND_fld_ae_sem_ar_to_ar_arr,
  OPERAND_fld_ae_sem_ar_to_ar_ars,
  OPERAND_fld_ae_sem_ar_to_ar_art,
  OPERAND_fld_ae_sem_ar_to_dr_a0,
  OPERAND_fld_ae_sem_ar_to_dr_a1,
  OPERAND_fld_ae_sem_ar_to_dr_v,
  OPERAND_fld_ae_sem_cmov_arr,
  OPERAND_fld_ae_sem_cmov_v,
  OPERAND_fld_ae_sem_cmov_v0,
  OPERAND_fld_ae_sem_cmov_vbr,
  OPERAND_fld_ae_sem_cmov_vbt,
  OPERAND_fld_ae_sem_dr_to_ar_a,
  OPERAND_fld_ae_sem_dr_to_ar_v0,
  OPERAND_fld_ae_sem_dr_to_dr_i_imm4,
  OPERAND_fld_ae_sem_dr_to_dr_imm_movi,
  OPERAND_fld_ae_sem_dr_to_dr_v,
  OPERAND_fld_ae_sem_dr_to_dr_v0,
  OPERAND_fld_ae_sem_loads_stores_a,
  OPERAND_fld_ae_sem_loads_stores_i16,
  OPERAND_fld_ae_sem_loads_stores_i16m,
  OPERAND_fld_ae_sem_loads_stores_i16p,
  OPERAND_fld_ae_sem_loads_stores_i32,
  OPERAND_fld_ae_sem_loads_stores_i32m,
  OPERAND_fld_ae_sem_loads_stores_i32p,
  OPERAND_fld_ae_sem_loads_stores_i64,
  OPERAND_fld_ae_sem_loads_stores_i64p,
  OPERAND_fld_ae_sem_loads_stores_i8,
  OPERAND_fld_ae_sem_loads_stores_i8p,
  OPERAND_fld_ae_sem_loads_stores_su,
  OPERAND_fld_ae_sem_loads_stores_uu,
  OPERAND_fld_ae_sem_loads_stores_v,
  OPERAND_fld_ae_sem_loads_stores_vu,
  OPERAND_fld_ae_sem_loads_stores_x,
  OPERAND_fld_ae_sem_rur_wur_a,
  OPERAND_fld_ae_sem_shift_a0,
  OPERAND_fld_ae_sem_shift_d,
  OPERAND_fld_ae_sem_shift_d0,
  OPERAND_fld_ae_sem_spcvtlookup_arr,
  OPERAND_fld_ae_sem_spcvtlookup_art,
  OPERAND_fld_ae_sem_spcvtlookup_i_imm5,
  OPERAND_fld_ae_sem_spcvtlookup_v,
  OPERAND_fld_ae_sem_spcvtlookup_v0,
  OPERAND_fld_ae_sem_vbool_arr,
  OPERAND_fld_ae_sem_vbool_art,
  OPERAND_fld_ae_sem_vbool_i_imm3,
  OPERAND_fld_ae_sem_vbool_vbr,
  OPERAND_fld_ae_sem_vbool_vbs,
  OPERAND_fld_ae_sem_vbool_vbt,
  OPERAND_fld_ae_sem_vldc_loads_stores_done,
  OPERAND_fld_F0_S1_20_0,
  OPERAND_fld_F0_S1_20_10,
  OPERAND_fld_F0_S1_20_12,
  OPERAND_fld_F0_S1_20_13,
  OPERAND_fld_F0_S1_20_15,
  OPERAND_fld_F0_S1_20_16,
  OPERAND_fld_F0_S1_20_17,
  OPERAND_fld_F0_S1_20_7,
  OPERAND_fld_F0_S1_20_8,
  OPERAND_fld_F0_S1_20_9,
  OPERAND_fld_F0_S1_3_0,
  OPERAND_fld_F0_S1_3_3,
  OPERAND_fld_F0_S1_7_4,
  OPERAND_fld_ae_sem_arithmetic_i_imm1,
  OPERAND_fld_ae_sem_arithmetic_v,
  OPERAND_fld_ae_sem_arithmetic_v0,
  OPERAND_fld_ae_sem_arithmetic_v1,
  OPERAND_fld_ae_sem_arithmetic_vbt,
  OPERAND_fld_ae_sem_dr_to_dr_v1,
  OPERAND_fld_ae_sem_mul_x2_S1_d0,
  OPERAND_fld_ae_sem_mul_x2_S1_d1,
  OPERAND_fld_ae_sem_mul_x2_S1_q0,
  OPERAND_fld_ae_sem_nn_act_q1,
  OPERAND_fld_ae_sem_nn_act_v1,
  OPERAND_fld_ae_sem_spfma_i_imm3,
  OPERAND_fld_ae_sem_spfma_i_imm4,
  OPERAND_fld_ae_sem_spfma_v,
  OPERAND_fld_ae_sem_spfma_v0,
  OPERAND_fld_ae_sem_spfma_v1,
  OPERAND_fld_F1_S0_11_11,
  OPERAND_fld_F1_S0_11_7,
  OPERAND_fld_F1_S0_11_8,
  OPERAND_fld_F1_S0_13_12,
  OPERAND_fld_F1_S0_1_0,
  OPERAND_fld_F1_S0_21_0,
  OPERAND_fld_F1_S0_21_10,
  OPERAND_fld_F1_S0_21_11,
  OPERAND_fld_F1_S0_21_12,
  OPERAND_fld_F1_S0_21_13,
  OPERAND_fld_F1_S0_21_14,
  OPERAND_fld_F1_S0_21_16,
  OPERAND_fld_F1_S0_21_17,
  OPERAND_fld_F1_S0_21_18,
  OPERAND_fld_F1_S0_21_8,
  OPERAND_fld_F1_S0_21_9,
  OPERAND_fld_F1_S0_3_0,
  OPERAND_fld_F1_S0_3_2,
  OPERAND_fld_F1_S0_7_4,
  OPERAND_fld_F1_S0_7_7,
  OPERAND_fld_ae_sem_spcvtlookup_v1,
  OPERAND_fld_F1_S1_11_3,
  OPERAND_fld_F1_S1_11_4,
  OPERAND_fld_F1_S1_11_8,
  OPERAND_fld_F1_S1_20_0,
  OPERAND_fld_F1_S1_20_12,
  OPERAND_fld_F1_S1_20_15,
  OPERAND_fld_F1_S1_20_16,
  OPERAND_fld_F1_S1_7_0,
  OPERAND_fld_F1_S1_7_4,
  OPERAND_fld_F1_S1_7_5,
  OPERAND_fld_F1_S1_7_6,
  OPERAND_fld_F1_S1_7_7,
  OPERAND_fld_ae_sem_shift_sd,
  OPERAND_fld_F2_S0_10_8,
  OPERAND_fld_F2_S0_11_4,
  OPERAND_fld_F2_S0_11_8,
  OPERAND_fld_F2_S0_33_10,
  OPERAND_fld_F2_S0_33_12,
  OPERAND_fld_F2_S0_33_13,
  OPERAND_fld_F2_S0_33_14,
  OPERAND_fld_F2_S0_33_15,
  OPERAND_fld_F2_S0_33_16,
  OPERAND_fld_F2_S0_33_17,
  OPERAND_fld_F2_S0_33_19,
  OPERAND_fld_F2_S0_33_23,
  OPERAND_fld_F2_S0_33_24,
  OPERAND_fld_F2_S0_33_9,
  OPERAND_fld_F2_S0_3_0,
  OPERAND_fld_F2_S0_3_3,
  OPERAND_fld_F2_S0_7_0,
  OPERAND_fld_F2_S0_7_4,
  OPERAND_fld_F2_S0_7_5,
  OPERAND_fld_F2_S0_7_7,
  OPERAND_fld_F2_S0_8_0,
  OPERAND_fld_F2_S0_8_8,
  OPERAND_fld_F2_S0_9_3,
  OPERAND_fld_F2_S0_9_7,
  OPERAND_fld_F2_S0_9_8,
  OPERAND_fld_ae_sem_movstate1_v,
  OPERAND_fld_ae_sem_movstate1_v0,
  OPERAND_fld_ae_sem_movstate2_v,
  OPERAND_fld_ae_sem_movstate2_v0,
  OPERAND_fld_ae_sem_sb_loads_stores_ar_p,
  OPERAND_fld_ae_sem_sb_loads_stores_vbr,
  OPERAND_fld_Inst_11_10,
  OPERAND_fld_Inst_11_8,
  OPERAND_fld_Inst_15_12,
  OPERAND_fld_Inst_19_12,
  OPERAND_fld_Inst_19_16,
  OPERAND_fld_Inst_19_17,
  OPERAND_fld_Inst_19_18,
  OPERAND_fld_Inst_19_8,
  OPERAND_fld_Inst_23_10,
  OPERAND_fld_Inst_23_11,
  OPERAND_fld_Inst_23_12,
  OPERAND_fld_Inst_23_14,
  OPERAND_fld_Inst_23_15,
  OPERAND_fld_Inst_23_16,
  OPERAND_fld_Inst_23_20,
  OPERAND_fld_Inst_23_21,
  OPERAND_fld_Inst_23_23,
  OPERAND_fld_Inst_23_8,
  OPERAND_fld_Inst_3_0,
  OPERAND_fld_Inst_7_0,
  OPERAND_fld_Inst_7_6,
  OPERAND_fld_Inst_7_7,
  OPERAND_fld_Inst_9_8,
  OPERAND_fld_ae_sem_sb_loads_stores_ar_u,
  OPERAND_fld_F3_S0_21_0,
  OPERAND_fld_F3_S0_21_12,
  OPERAND_fld_F3_S0_21_13,
  OPERAND_fld_F3_S0_21_16,
  OPERAND_fld_F3_S0_21_19,
  OPERAND_fld_F3_S0_3_2,
  OPERAND_fld_F3_S1_10_0,
  OPERAND_fld_F3_S1_10_8,
  OPERAND_s3to1
};


/* Iclass table.  */

static xtensa_arg_internal Iclass_xt_iclass_rfe_stateArgs[] = {
  { { STATE_PSEXCM }, 'o' },
  { { STATE_EPC1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfde_stateArgs[] = {
  { { STATE_DEPC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_call12_args[] = {
  { { OPERAND_soffsetx4 }, 'i' },
  { { OPERAND_ar12 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call12_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call8_args[] = {
  { { OPERAND_soffsetx4 }, 'i' },
  { { OPERAND_ar8 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call8_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call4_args[] = {
  { { OPERAND_soffsetx4 }, 'i' },
  { { OPERAND_ar4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_call4_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx12_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ar12 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx12_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx8_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ar8 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx8_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx4_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ar4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx4_stateArgs[] = {
  { { STATE_PSCALLINC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_entry_args[] = {
  { { OPERAND_ars_entry }, 's' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm12x8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_entry_stateArgs[] = {
  { { STATE_PSCALLINC }, 'i' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSWOE }, 'i' },
  { { STATE_WindowBase }, 'm' },
  { { STATE_WindowStart }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_movsp_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_movsp_stateArgs[] = {
  { { STATE_WindowBase }, 'i' },
  { { STATE_WindowStart }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rotw_args[] = {
  { { OPERAND_simm4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rotw_stateArgs[] = {
  { { STATE_WindowBase }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_retw_args[] = {
  { { OPERAND__ars_invisible }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_retw_stateArgs[] = {
  { { STATE_WindowBase }, 'm' },
  { { STATE_WindowStart }, 'm' },
  { { STATE_PSCALLINC }, 'o' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSWOE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfwou_stateArgs[] = {
  { { STATE_EPC1 }, 'i' },
  { { STATE_PSEXCM }, 'o' },
  { { STATE_WindowBase }, 'm' },
  { { STATE_WindowStart }, 'm' },
  { { STATE_PSOWB }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l32e_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_immrx4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32e_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_immrx4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_windowbase_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_windowbase_stateArgs[] = {
  { { STATE_WindowBase }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_windowbase_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_windowbase_stateArgs[] = {
  { { STATE_WindowBase }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_windowbase_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_windowbase_stateArgs[] = {
  { { STATE_WindowBase }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_windowstart_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_windowstart_stateArgs[] = {
  { { STATE_WindowStart }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_windowstart_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_windowstart_stateArgs[] = {
  { { STATE_WindowStart }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_windowstart_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_windowstart_stateArgs[] = {
  { { STATE_WindowStart }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_add_n_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_addi_n_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ai4const }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bz6_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm6 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_loadi4_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_lsi4x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_mov_n_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_movi_n_args[] = {
  { { OPERAND_ars }, 'o' },
  { { OPERAND_simm7 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_retn_args[] = {
  { { OPERAND__ars_invisible }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_storei4_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_lsi4x4 }, 'i' }
};

static xtensa_arg_internal Iclass_rur_threadptr_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_threadptr_stateArgs[] = {
  { { STATE_THREADPTR }, 'i' }
};

static xtensa_arg_internal Iclass_wur_threadptr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_threadptr_stateArgs[] = {
  { { STATE_THREADPTR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_addi_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_simm8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_addmi_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_simm8x256 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_addsub_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bit_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bsi8_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_b4const }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bsi8b_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_bbi }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bsi8u_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_b4constu }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bst8_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_label8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_bsz12_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_label12 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_call0_args[] = {
  { { OPERAND_soffsetx4 }, 'i' },
  { { OPERAND_ar0 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_callx0_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ar0 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_exti_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_sae }, 'i' },
  { { OPERAND_op2p1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_jump_args[] = {
  { { OPERAND_soffset }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_jumpx_args[] = {
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l16ui_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l16si_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l32i_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l32r_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_uimm16x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l8i_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_loop_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ulabel8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_loop_stateArgs[] = {
  { { STATE_LBEG }, 'o' },
  { { STATE_LEND }, 'o' },
  { { STATE_LCOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_loopz_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_ulabel8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_loopz_stateArgs[] = {
  { { STATE_LBEG }, 'o' },
  { { STATE_LEND }, 'o' },
  { { STATE_LCOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_movi_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_simm12b }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_movz_args[] = {
  { { OPERAND_arr }, 'm' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_neg_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_depbits_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_low_depbits }, 'i' },
  { { OPERAND_lngth_depbits }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_return_args[] = {
  { { OPERAND__ars_invisible }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_simcall_args[] = {
  { { OPERAND_immt }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s16i_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32i_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32nb_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimmrx4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s8i_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sar_args[] = {
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sar_stateArgs[] = {
  { { STATE_SAR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_sari_args[] = {
  { { OPERAND_sas }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sari_stateArgs[] = {
  { { STATE_SAR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_shifts_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shifts_stateArgs[] = {
  { { STATE_SAR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shiftst_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shiftst_stateArgs[] = {
  { { STATE_SAR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shiftt_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_shiftt_stateArgs[] = {
  { { STATE_SAR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_slli_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_msalp32 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_srai_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_sargt }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_srli_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_s }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sync_stateArgs[] = {
  { { STATE_XTSYNC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsil_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_s }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsil_stateArgs[] = {
  { { STATE_PSWOE }, 'i' },
  { { STATE_PSCALLINC }, 'i' },
  { { STATE_PSOWB }, 'i' },
  { { STATE_PSUM }, 'i' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSINTLEVEL }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lend_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lend_stateArgs[] = {
  { { STATE_LEND }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lend_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lend_stateArgs[] = {
  { { STATE_LEND }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lend_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lend_stateArgs[] = {
  { { STATE_LEND }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lcount_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lcount_stateArgs[] = {
  { { STATE_LCOUNT }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lcount_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lcount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_LCOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lcount_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lcount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_LCOUNT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lbeg_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_lbeg_stateArgs[] = {
  { { STATE_LBEG }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lbeg_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_lbeg_stateArgs[] = {
  { { STATE_LBEG }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lbeg_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_lbeg_stateArgs[] = {
  { { STATE_LBEG }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_sar_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_sar_stateArgs[] = {
  { { STATE_SAR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_sar_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_sar_stateArgs[] = {
  { { STATE_SAR }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_sar_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_sar_stateArgs[] = {
  { { STATE_SAR }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_memctl_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_memctl_stateArgs[] = {
  { { STATE_MEMCTL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_memctl_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_memctl_stateArgs[] = {
  { { STATE_MEMCTL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_memctl_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_memctl_stateArgs[] = {
  { { STATE_MEMCTL }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_configid0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_configid0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_configid1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_243_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ps_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ps_stateArgs[] = {
  { { STATE_PSWOE }, 'i' },
  { { STATE_PSCALLINC }, 'i' },
  { { STATE_PSOWB }, 'i' },
  { { STATE_PSUM }, 'i' },
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSINTLEVEL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ps_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ps_stateArgs[] = {
  { { STATE_PSWOE }, 'o' },
  { { STATE_PSCALLINC }, 'o' },
  { { STATE_PSOWB }, 'o' },
  { { STATE_PSUM }, 'o' },
  { { STATE_PSEXCM }, 'o' },
  { { STATE_PSINTLEVEL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ps_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ps_stateArgs[] = {
  { { STATE_PSWOE }, 'm' },
  { { STATE_PSCALLINC }, 'm' },
  { { STATE_PSOWB }, 'm' },
  { { STATE_PSUM }, 'm' },
  { { STATE_PSEXCM }, 'm' },
  { { STATE_PSINTLEVEL }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc1_stateArgs[] = {
  { { STATE_EPC1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc1_stateArgs[] = {
  { { STATE_EPC1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc1_stateArgs[] = {
  { { STATE_EPC1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave1_stateArgs[] = {
  { { STATE_EXCSAVE1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave1_stateArgs[] = {
  { { STATE_EXCSAVE1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave1_stateArgs[] = {
  { { STATE_EXCSAVE1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc2_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc2_stateArgs[] = {
  { { STATE_EPC2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc2_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc2_stateArgs[] = {
  { { STATE_EPC2 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc2_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc2_stateArgs[] = {
  { { STATE_EPC2 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave2_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave2_stateArgs[] = {
  { { STATE_EXCSAVE2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave2_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave2_stateArgs[] = {
  { { STATE_EXCSAVE2 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave2_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave2_stateArgs[] = {
  { { STATE_EXCSAVE2 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc3_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc3_stateArgs[] = {
  { { STATE_EPC3 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc3_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc3_stateArgs[] = {
  { { STATE_EPC3 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc3_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc3_stateArgs[] = {
  { { STATE_EPC3 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave3_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave3_stateArgs[] = {
  { { STATE_EXCSAVE3 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave3_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave3_stateArgs[] = {
  { { STATE_EXCSAVE3 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave3_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave3_stateArgs[] = {
  { { STATE_EXCSAVE3 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc4_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc4_stateArgs[] = {
  { { STATE_EPC4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc4_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc4_stateArgs[] = {
  { { STATE_EPC4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc4_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc4_stateArgs[] = {
  { { STATE_EPC4 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave4_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave4_stateArgs[] = {
  { { STATE_EXCSAVE4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave4_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave4_stateArgs[] = {
  { { STATE_EXCSAVE4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave4_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave4_stateArgs[] = {
  { { STATE_EXCSAVE4 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc5_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_epc5_stateArgs[] = {
  { { STATE_EPC5 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc5_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_epc5_stateArgs[] = {
  { { STATE_EPC5 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc5_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_epc5_stateArgs[] = {
  { { STATE_EPC5 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave5_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excsave5_stateArgs[] = {
  { { STATE_EXCSAVE5 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave5_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excsave5_stateArgs[] = {
  { { STATE_EXCSAVE5 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave5_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excsave5_stateArgs[] = {
  { { STATE_EXCSAVE5 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps2_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps2_stateArgs[] = {
  { { STATE_EPS2 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps2_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps2_stateArgs[] = {
  { { STATE_EPS2 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps2_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps2_stateArgs[] = {
  { { STATE_EPS2 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps3_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps3_stateArgs[] = {
  { { STATE_EPS3 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps3_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps3_stateArgs[] = {
  { { STATE_EPS3 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps3_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps3_stateArgs[] = {
  { { STATE_EPS3 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps4_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps4_stateArgs[] = {
  { { STATE_EPS4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps4_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps4_stateArgs[] = {
  { { STATE_EPS4 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps4_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps4_stateArgs[] = {
  { { STATE_EPS4 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps5_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eps5_stateArgs[] = {
  { { STATE_EPS5 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps5_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eps5_stateArgs[] = {
  { { STATE_EPS5 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps5_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eps5_stateArgs[] = {
  { { STATE_EPS5 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excvaddr_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_excvaddr_stateArgs[] = {
  { { STATE_EXCVADDR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excvaddr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_excvaddr_stateArgs[] = {
  { { STATE_EXCVADDR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excvaddr_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_excvaddr_stateArgs[] = {
  { { STATE_EXCVADDR }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_depc_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_depc_stateArgs[] = {
  { { STATE_DEPC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_depc_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_depc_stateArgs[] = {
  { { STATE_DEPC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_depc_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_depc_stateArgs[] = {
  { { STATE_DEPC }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_exccause_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_exccause_stateArgs[] = {
  { { STATE_EXCCAUSE }, 'i' },
  { { STATE_XTSYNC }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_exccause_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_exccause_stateArgs[] = {
  { { STATE_EXCCAUSE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_exccause_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_exccause_stateArgs[] = {
  { { STATE_EXCCAUSE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_misc0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_misc0_stateArgs[] = {
  { { STATE_MISC0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_misc0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_misc0_stateArgs[] = {
  { { STATE_MISC0 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_misc0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_misc0_stateArgs[] = {
  { { STATE_MISC0 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_misc1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_misc1_stateArgs[] = {
  { { STATE_MISC1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_misc1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_misc1_stateArgs[] = {
  { { STATE_MISC1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_misc1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_misc1_stateArgs[] = {
  { { STATE_MISC1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_prid_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_vecbase_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_vecbase_stateArgs[] = {
  { { STATE_VECBASE }, 'i' },
  { { STATE_VECBASELOCK }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_vecbase_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_vecbase_stateArgs[] = {
  { { STATE_VECBASE }, 'm' },
  { { STATE_VECBASELOCK }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_vecbase_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_vecbase_stateArgs[] = {
  { { STATE_VECBASE }, 'm' },
  { { STATE_VECBASELOCK }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_salt_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_opmode_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_opmode_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_opmode_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfi_args[] = {
  { { OPERAND_s }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfi_stateArgs[] = {
  { { STATE_PSWOE }, 'o' },
  { { STATE_PSCALLINC }, 'o' },
  { { STATE_PSOWB }, 'o' },
  { { STATE_PSUM }, 'o' },
  { { STATE_PSEXCM }, 'o' },
  { { STATE_PSINTLEVEL }, 'o' },
  { { STATE_EPC1 }, 'i' },
  { { STATE_EPC2 }, 'i' },
  { { STATE_EPC3 }, 'i' },
  { { STATE_EPC4 }, 'i' },
  { { STATE_EPC5 }, 'i' },
  { { STATE_EPS2 }, 'i' },
  { { STATE_EPS3 }, 'i' },
  { { STATE_EPS4 }, 'i' },
  { { STATE_EPS5 }, 'i' },
  { { STATE_InOCDMode }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_wait_args[] = {
  { { OPERAND_s }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wait_stateArgs[] = {
  { { STATE_PSINTLEVEL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_interrupt_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_interrupt_stateArgs[] = {
  { { STATE_INTERRUPT }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intset_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intset_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intclear_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intclear_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_intenable_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_intenable_stateArgs[] = {
  { { STATE_INTENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intenable_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_intenable_stateArgs[] = {
  { { STATE_INTENABLE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_intenable_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_intenable_stateArgs[] = {
  { { STATE_INTENABLE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_break_args[] = {
  { { OPERAND_imms }, 'i' },
  { { OPERAND_immt }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_break_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSINTLEVEL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_break_n_args[] = {
  { { OPERAND_imms }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_break_n_stateArgs[] = {
  { { STATE_PSEXCM }, 'i' },
  { { STATE_PSINTLEVEL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreaka0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreaka0_stateArgs[] = {
  { { STATE_DBREAKA0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreaka0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreaka0_stateArgs[] = {
  { { STATE_DBREAKA0 }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreaka0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreaka0_stateArgs[] = {
  { { STATE_DBREAKA0 }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreakc0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreakc0_stateArgs[] = {
  { { STATE_DBREAKC0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreakc0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreakc0_stateArgs[] = {
  { { STATE_DBREAKC0 }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreakc0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreakc0_stateArgs[] = {
  { { STATE_DBREAKC0 }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreaka1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreaka1_stateArgs[] = {
  { { STATE_DBREAKA1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreaka1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreaka1_stateArgs[] = {
  { { STATE_DBREAKA1 }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreaka1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreaka1_stateArgs[] = {
  { { STATE_DBREAKA1 }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreakc1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_dbreakc1_stateArgs[] = {
  { { STATE_DBREAKC1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreakc1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_dbreakc1_stateArgs[] = {
  { { STATE_DBREAKC1 }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreakc1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_dbreakc1_stateArgs[] = {
  { { STATE_DBREAKC1 }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreaka0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreaka0_stateArgs[] = {
  { { STATE_IBREAKA0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreaka0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreaka0_stateArgs[] = {
  { { STATE_IBREAKA0 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreaka0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreaka0_stateArgs[] = {
  { { STATE_IBREAKA0 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreaka1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreaka1_stateArgs[] = {
  { { STATE_IBREAKA1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreaka1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreaka1_stateArgs[] = {
  { { STATE_IBREAKA1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreaka1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreaka1_stateArgs[] = {
  { { STATE_IBREAKA1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreakenable_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ibreakenable_stateArgs[] = {
  { { STATE_IBREAKENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreakenable_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ibreakenable_stateArgs[] = {
  { { STATE_IBREAKENABLE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreakenable_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ibreakenable_stateArgs[] = {
  { { STATE_IBREAKENABLE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_debugcause_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_debugcause_stateArgs[] = {
  { { STATE_DEBUGCAUSE }, 'i' },
  { { STATE_DBNUM }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_debugcause_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_debugcause_stateArgs[] = {
  { { STATE_DEBUGCAUSE }, 'o' },
  { { STATE_DBNUM }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_debugcause_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_debugcause_stateArgs[] = {
  { { STATE_DEBUGCAUSE }, 'm' },
  { { STATE_DBNUM }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_icount_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_icount_stateArgs[] = {
  { { STATE_ICOUNT }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_icount_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_icount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_ICOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_icount_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_icount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_ICOUNT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_icountlevel_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_icountlevel_stateArgs[] = {
  { { STATE_ICOUNTLEVEL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_icountlevel_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_icountlevel_stateArgs[] = {
  { { STATE_ICOUNTLEVEL }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_icountlevel_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_icountlevel_stateArgs[] = {
  { { STATE_ICOUNTLEVEL }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ddr_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ddr_stateArgs[] = {
  { { STATE_DDR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ddr_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ddr_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_DDR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ddr_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ddr_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_DDR }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_lddr32_p_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_lddr32_p_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_InOCDMode }, 'i' },
  { { STATE_DDR }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_sddr32_p_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_sddr32_p_stateArgs[] = {
  { { STATE_InOCDMode }, 'i' },
  { { STATE_DDR }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfdo_args[] = {
  { { OPERAND_imms }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfdo_stateArgs[] = {
  { { STATE_InOCDMode }, 'm' },
  { { STATE_EPC4 }, 'i' },
  { { STATE_PSWOE }, 'o' },
  { { STATE_PSCALLINC }, 'o' },
  { { STATE_PSOWB }, 'o' },
  { { STATE_PSUM }, 'o' },
  { { STATE_PSEXCM }, 'o' },
  { { STATE_PSINTLEVEL }, 'o' },
  { { STATE_EPS4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rfdd_stateArgs[] = {
  { { STATE_InOCDMode }, 'm' },
  { { STATE_VECBASE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_mmid_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_mmid_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccount_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccount_stateArgs[] = {
  { { STATE_CCOUNT }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccount_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_CCOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccount_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccount_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' },
  { { STATE_CCOUNT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare0_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare0_stateArgs[] = {
  { { STATE_CCOMPARE0 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare0_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare0_stateArgs[] = {
  { { STATE_CCOMPARE0 }, 'o' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare0_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare0_stateArgs[] = {
  { { STATE_CCOMPARE0 }, 'm' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_ccompare1_stateArgs[] = {
  { { STATE_CCOMPARE1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_ccompare1_stateArgs[] = {
  { { STATE_CCOMPARE1 }, 'o' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_ccompare1_stateArgs[] = {
  { { STATE_CCOMPARE1 }, 'm' },
  { { STATE_INTERRUPT }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_idtlb_args[] = {
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_idtlb_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rdtlb_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wdtlb_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wdtlb_stateArgs[] = {
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_iitlb_args[] = {
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_ritlb_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_witlb_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_cpenable_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_cpenable_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_cpenable_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_cpenable_stateArgs[] = {
  { { STATE_CPENABLE }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_cpenable_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_cpenable_stateArgs[] = {
  { { STATE_CPENABLE }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_clamp_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_tp7 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_minmax_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_nsa_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_sx_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_tp7 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_l32ai_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32ri_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32c1i_args[] = {
  { { OPERAND_art }, 'm' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_uimm8x4 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_s32c1i_stateArgs[] = {
  { { STATE_SCOMPARE1 }, 'i' },
  { { STATE_XTSYNC }, 'i' },
  { { STATE_SCOMPARE1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_scompare1_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_scompare1_stateArgs[] = {
  { { STATE_SCOMPARE1 }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_scompare1_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_scompare1_stateArgs[] = {
  { { STATE_SCOMPARE1 }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_scompare1_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_scompare1_stateArgs[] = {
  { { STATE_SCOMPARE1 }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_atomctl_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_atomctl_stateArgs[] = {
  { { STATE_ATOMCTL }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_atomctl_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_atomctl_stateArgs[] = {
  { { STATE_ATOMCTL }, 'o' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_atomctl_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_atomctl_stateArgs[] = {
  { { STATE_ATOMCTL }, 'm' },
  { { STATE_XTSYNC }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_div_args[] = {
  { { OPERAND_arr }, 'o' },
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rsr_eraccess_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_wsr_eraccess_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_xsr_eraccess_args[] = {
  { { OPERAND_art }, 'm' }
};

static xtensa_arg_internal Iclass_xt_iclass_rer_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_rer_stateArgs[] = {
  { { STATE_ERI_RAW_INTERLOCK }, 'i' }
};

static xtensa_interface Iclass_xt_iclass_rer_intfArgs[] = {
  INTERFACE_ERI_RD_In,
  INTERFACE_ERI_RD_Out
};

static xtensa_arg_internal Iclass_xt_iclass_wer_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wer_stateArgs[] = {
  { { STATE_ERI_RAW_INTERLOCK }, 'o' }
};

static xtensa_interface Iclass_xt_iclass_wer_intfArgs[] = {
  INTERFACE_ERI_WR_In,
  INTERFACE_ERI_WR_Out
};

static xtensa_arg_internal Iclass_xt_iclass_wb15_0_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_xt_wbr15_label }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wb15_1_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_b4const }, 'i' },
  { { OPERAND_xt_wbr15_label }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wb15_2_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_b4constu }, 'i' },
  { { OPERAND_xt_wbr15_label }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wb15_3_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_bbi }, 'i' },
  { { OPERAND_xt_wbr15_label }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wb15_4_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_xt_wbr15_label }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wloop_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_xt_wloop_label }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wloop_stateArgs[] = {
  { { STATE_LBEG }, 'o' },
  { { STATE_LEND }, 'o' },
  { { STATE_LCOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_xt_iclass_wloopz_args[] = {
  { { OPERAND_ars }, 'i' },
  { { OPERAND_xt_wloop_label }, 'i' }
};

static xtensa_arg_internal Iclass_xt_iclass_wloopz_stateArgs[] = {
  { { STATE_LBEG }, 'o' },
  { { STATE_LEND }, 'o' },
  { { STATE_LCOUNT }, 'o' }
};

static xtensa_arg_internal Iclass_iclass_READ_IMPWIRE_args[] = {
  { { OPERAND_art }, 'o' }
};

static xtensa_interface Iclass_iclass_READ_IMPWIRE_intfArgs[] = {
  INTERFACE_IMPWIRE
};

static xtensa_arg_internal Iclass_iclass_SETB_EXPSTATE_args[] = {
  { { OPERAND_bitindex }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_SETB_EXPSTATE_stateArgs[] = {
  { { STATE_EXPSTATE }, 'm' }
};

static xtensa_arg_internal Iclass_iclass_CLRB_EXPSTATE_args[] = {
  { { OPERAND_bitindex }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_CLRB_EXPSTATE_stateArgs[] = {
  { { STATE_EXPSTATE }, 'm' }
};

static xtensa_arg_internal Iclass_iclass_WRMSK_EXPSTATE_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_iclass_WRMSK_EXPSTATE_stateArgs[] = {
  { { STATE_EXPSTATE }, 'm' }
};

static xtensa_arg_internal Iclass_rur_expstate_args[] = {
  { { OPERAND_arr }, 'o' }
};

static xtensa_arg_internal Iclass_rur_expstate_stateArgs[] = {
  { { STATE_EXPSTATE }, 'i' }
};

static xtensa_arg_internal Iclass_wur_expstate_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_wur_expstate_stateArgs[] = {
  { { STATE_EXPSTATE }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_BITHEAD_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_BITHEAD_stateArgs[] = {
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_BITHEAD_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_BITHEAD_stateArgs[] = {
  { { STATE_AE_BITHEAD }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_CBEGIN0_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_CBEGIN0_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_CBEGIN0_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_CBEGIN0_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_CEND0_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_CEND0_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_CEND0_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_CEND0_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_OVERFLOW_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_OVERFLOW_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_OVERFLOW_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_OVERFLOW_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_SAR_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_SAR_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_SAR_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_SAR_stateArgs[] = {
  { { STATE_AE_SAR }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_BITPTR_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_BITPTR_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_BITPTR_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_BITPTR_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_BITSUSED_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_BITSUSED_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_BITSUSED_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_BITSUSED_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_TABLESIZE_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_TABLESIZE_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_TABLESIZE_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_TABLESIZE_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_FIRST_TS_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_FIRST_TS_stateArgs[] = {
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_FIRST_TS_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_FIRST_TS_stateArgs[] = {
  { { STATE_AE_FIRST_TS }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_NEXTOFFSET_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_NEXTOFFSET_stateArgs[] = {
  { { STATE_AE_NEXTOFFSET }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_NEXTOFFSET_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_NEXTOFFSET_stateArgs[] = {
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_SEARCHDONE_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_SEARCHDONE_stateArgs[] = {
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_SEARCHDONE_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_SEARCHDONE_stateArgs[] = {
  { { STATE_AE_SEARCHDONE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_AE_CWRAP_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_AE_CWRAP_stateArgs[] = {
  { { STATE_AE_CWRAP }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_CWRAP_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_AE_CWRAP_stateArgs[] = {
  { { STATE_AE_CWRAP }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVCIRCV_args[] = {
  { { OPERAND_opnd_ae_sem_movstate1_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVCIRCV_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'o' },
  { { STATE_AE_CEND0 }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVVCIRC_args[] = {
  { { OPERAND_opnd_ae_sem_movstate1_v }, 'o' }
};

static xtensa_arg_internal Iclass_AE_MOVVCIRC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVFUSIONMISCV_args[] = {
  { { OPERAND_opnd_ae_sem_movstate2_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVFUSIONMISCV_stateArgs[] = {
  { { STATE_AE_CWRAP }, 'o' },
  { { STATE_AE_OVERFLOW }, 'o' },
  { { STATE_AE_SAR }, 'o' },
  { { STATE_AE_BITHEAD }, 'o' },
  { { STATE_AE_BITPTR }, 'o' },
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVVFUSIONMISC_args[] = {
  { { OPERAND_opnd_ae_sem_movstate2_v }, 'o' }
};

static xtensa_arg_internal Iclass_AE_MOVVFUSIONMISC_stateArgs[] = {
  { { STATE_AE_CWRAP }, 'i' },
  { { STATE_AE_OVERFLOW }, 'i' },
  { { STATE_AE_SAR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVTABLEFIRSTSEARCHNEXTV_args[] = {
  { { OPERAND_opnd_ae_sem_movstate1_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVTABLEFIRSTSEARCHNEXTV_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'o' },
  { { STATE_AE_FIRST_TS }, 'o' },
  { { STATE_AE_SEARCHDONE }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVVTABLEFIRSTSEARCHNEXT_args[] = {
  { { OPERAND_opnd_ae_sem_movstate1_v }, 'o' }
};

static xtensa_arg_internal Iclass_AE_MOVVTABLEFIRSTSEARCHNEXT_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'i' },
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_AE_NEXTOFFSET }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i8 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i8p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8S_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i8 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8S_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8S_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i8p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8S_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8U_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i8 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8U_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8U_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i8p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8U_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4F_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4F_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4F_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4F_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4F_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4F_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4F_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4F_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4S_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4S_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4S_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4S_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4S_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4S_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4S_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4S_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4U_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4U_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4U_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4U_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4U_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4U_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4U_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X4U_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X8_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X8_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X8_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i64p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X8_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X8_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X8_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X8_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L8X8_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i16p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i16m }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_IU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i16m }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_XU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16M_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32m }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_IU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32m }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_XU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X2M_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i64p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_L16X4_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_L16X4_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16X4_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32m }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_IU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32m }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_XU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32M_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i64p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_L32X2_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_L32X2_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L32X2_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i64p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L64_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8_0_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i8 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8_0_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8_0_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i8p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8_0_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8_0_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8_0_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8_0_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8_0_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8X4_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8X4_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8X4_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8X4_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8X4F_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8X4F_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8X4F_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8X4F_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8X8_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8X8_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8X8_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i64p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8X8_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8X8_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8X8_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8X8_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S8X8_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i16p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16_0_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i16m }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_IU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i16m }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_XU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16M_L_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32m }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_IU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32m }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_XU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X2M_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i64p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S16X4_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S16X4_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4RNG_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4RNG_I_stateArgs[] = {
  { { STATE_AE_SAR }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4RNG_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i64p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4RNG_IP_stateArgs[] = {
  { { STATE_AE_SAR }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4RNG_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4RNG_X_stateArgs[] = {
  { { STATE_AE_SAR }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4RNG_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16X4RNG_XP_stateArgs[] = {
  { { STATE_AE_SAR }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_L_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_H_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_H_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_H_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_H_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_H_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_H_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_H_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32_H_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32m }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_IU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i32m }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_IU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_XU_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32M_XU_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i64p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S32X2_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_S32X2_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S32X2_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_XC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_XC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_i64p }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_X_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_X_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S64_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ZALIGN64_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_su }, 'o' }
};

static xtensa_arg_internal Iclass_AE_ZALIGN64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LALIGN64_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_uu }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LALIGN64_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SALIGN64_I_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_su }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_i64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SALIGN64_I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVALIGN_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_uu }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_vu }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVALIGN_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA64_PP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_uu }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA64_PP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2POS_PC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_uu }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2POS_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2NEG_PC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_uu }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2NEG_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4POS_PC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_uu }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4POS_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4NEG_PC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_uu }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4NEG_PC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_IC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_uu }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_uu }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_uu }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_uu }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA32X2_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_IC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_uu }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_uu }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_uu }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_uu }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA16X4_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA8X8_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_uu }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA8X8_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDBRBA32_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_ar_art }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_ar_arr }, 'i' },
  { { OPERAND_opnd_ae_sem_ar_to_ar_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEL16I_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v1 }, 'i' },
  { { OPERAND_ae_selimm }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEL16I_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SHORTSWAP_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SHORTSWAP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_INTSWAP_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_INTSWAP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT16X4_args[] = {
  { { OPERAND_opnd_ae_sem_cmov_v }, 'm' },
  { { OPERAND_opnd_ae_sem_cmov_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmov_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT16X4_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF16X4_args[] = {
  { { OPERAND_opnd_ae_sem_cmov_v }, 'm' },
  { { OPERAND_opnd_ae_sem_cmov_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmov_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF16X4_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT32X2_args[] = {
  { { OPERAND_opnd_ae_sem_cmov_v }, 'm' },
  { { OPERAND_opnd_ae_sem_cmov_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmov_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT32X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF32X2_args[] = {
  { { OPERAND_opnd_ae_sem_cmov_v }, 'm' },
  { { OPERAND_opnd_ae_sem_cmov_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmov_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF32X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA32X2_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA32X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA32_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA16X2_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA16X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA16_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVDA16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVI_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_imm_movi }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVI_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVI16X4_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_imm_movi }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVI16X4_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT16X4_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT16X4_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT8S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT8S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT8U_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT8U_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT32X2F16_32_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT32X2F16_32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT32X2F16_10_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT32X2F16_10_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32X2D16_32_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32X2D16_32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32X2D16_10_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32X2D16_10_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32X2D24_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32X2D24_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT64Q56_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT64Q56_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_LL_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_LH_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_HL_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_HL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_HH_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVTP24A16X2_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCP24Q48X2_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCP24Q48X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32X2F64S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_sd }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32X2F64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCI32X2F64S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_sd }, 'i' },
  { { OPERAND_ae_osa16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCI32X2F64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCAV32X2F64S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_sd }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCAV32X2F64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCI16X4F32S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_sd }, 'i' },
  { { OPERAND_ae_osa16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCI16X4F32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32F64S_L_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_sd }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32F64S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCI32F64S_L_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_sd }, 'i' },
  { { OPERAND_ae_osa16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCI32F64S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCP16_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCP16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F64SSYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F64SSYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F64SASYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F64SASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F48SSYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F48SSYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F48SASYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND32X2F48SASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND16X4F32SSYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND16X4F32SSYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND16X4F32SASYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND16X4F32SASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND24X2F48SSYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND24X2F48SSYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND24X2F48SASYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUND24X2F48SASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16Q48X2SYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16Q48X2SYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16Q48X2ASYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSP16Q48X2ASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOV_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOV_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT64_args[] = {
  { { OPERAND_opnd_ae_sem_cmov_v }, 'm' },
  { { OPERAND_opnd_ae_sem_cmov_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmov_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVT64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF64_args[] = {
  { { OPERAND_opnd_ae_sem_cmov_v }, 'm' },
  { { OPERAND_opnd_ae_sem_cmov_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmov_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVF64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT48A32_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT48A32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT64A32_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT64A32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT64F32_H_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CVT64F32_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT48S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT48S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SATQ56S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SATQ56S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT24S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT24S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCQ32_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCQ32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSQ32F48SYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSQ32F48SYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSQ32F48ASYM_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ROUNDSQ32F48ASYM_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32Q48_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_TRUNCA32Q48_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD32_L_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD32_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD32_H_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD32_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_3_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_2_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_1_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_0_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAD16_0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRA64_32_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRA64_32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_PKSR32_0_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_imm2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_PKSR32_0_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_PKSR24_0_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_imm2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_PKSR24_0_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB32_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSUB32_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSUB32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBADD32_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBADD32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD16_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB16_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32_HL_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG32_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS32_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB32S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSUB32S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSUB32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBADD32S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBADD32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD16S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB16S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSUB32S_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDSUB32S_HL_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBADD32S_HL_LH_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUBADD32S_HL_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG32S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG32S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS32S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS32S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG16S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG16S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS16S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS16S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CONJ16S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CONJ16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC16JS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC16JS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC16JS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC16JS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC16JS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC16JS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC16JS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC16JS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT16_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE16_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ16_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT32_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE32_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ32_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MIN32_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MIN32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAX32_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAX32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MIN16_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MIN16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAX16_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAX16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD64_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB64_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG64_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS64_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD64S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADD64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB64S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SUB64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG64S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NEG64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS64S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ABS64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_AND_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_AND_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NAND_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NAND_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_OR_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_OR_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_XOR_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_XOR_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI16_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI16R_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI16R_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI32_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLI32_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLI32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI32_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI32R_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI32R_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS32_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS32_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLS32_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLS32_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAS32_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAS32_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA32_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLA32_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLA32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI16S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa16 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA16S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA16S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA16S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA16RS_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA16RS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI32S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa32 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS32S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA32S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32RS_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA32RS_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI64_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLI64_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLI64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI64_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAI64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS64_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS64_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLS64_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLS64_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAS64_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAS64_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA64_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLA64_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRLA64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA64_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SRAA64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI64S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_ae_osa64 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAI64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS64S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAS64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_AE_SAR }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA64S_args[] = {
  { { OPERAND_opnd_ae_sem_shift_d }, 'o' },
  { { OPERAND_opnd_ae_sem_shift_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_shift_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SLAA64S_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT64_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LT64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE64_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LE64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ64_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EQ64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAX64_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MAX64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MIN64_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MIN64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSA64_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSA64_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSAZ16_0_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSAZ16_0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSAZ32_L_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSAZ32_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSA16_0_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSA16_0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSA32_L_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NSA32_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32F48P16S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32R_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAS32F48P16S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32R_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_LL_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_LH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_LH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_LH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSS32F48P16S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32S_HH_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_HH_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32R_HH_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32U_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32U_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32U_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32U_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32U_LL_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32U_LL_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_33_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_33_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_22_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_32_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_32_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_21_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_21_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_31_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_31_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_30_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_30_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_10_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_10_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_20_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_20_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_11_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_11_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16SS_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_33_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_33_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_22_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_32_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_32_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_21_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_21_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_31_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_31_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_30_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_30_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_10_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_10_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_20_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_20_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_11_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_11_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16SS_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_33_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_33_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_22_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_32_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_32_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_21_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_21_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_31_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_31_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_30_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_30_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_10_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_10_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_20_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_20_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_11_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_11_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16SS_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_33_22_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_33_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_13_02_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_13_02_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_11_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD16SS_11_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_33_22_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_33_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_13_02_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_13_02_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_11_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD16SS_11_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_33_22_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_33_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_13_02_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_13_02_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_11_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD16SS_11_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_33_22_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_33_22_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_13_02_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_13_02_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_11_00_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD16SS_11_00_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16U_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF48Q32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16U_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULQ32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16U_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF48Q32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16U_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAQ32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16U_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF48Q32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16S_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16U_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSQ32SP16U_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS32X16_H3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULASD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSAD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSSD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZASD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSAD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H3_L2_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H3_L2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSFD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H1_L0_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZSSD32X16_H1_L0_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H2_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H2_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H0_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAFD32X16_H0_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H2_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H2_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H0_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAFD32X16_H0_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H2_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H2_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H0_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAD32X16_H0_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H2_L3_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H2_L3_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H0_L1_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAD32X16_H0_L1_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X16X2_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X16X2_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2S_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2S_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X16X2_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X16X2_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X16X2RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X16X2_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X16X2_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2S_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2S_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X16X2_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X16X2_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X16X2RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X16X2_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X16X2_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2S_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2S_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X16X2_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X16X2_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X16X2RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCR32X16RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCR32X16RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCR32X16RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCR32X16RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCI32X16RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCI32X16RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCI32X16RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCI32X16RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCR32X16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCR32X16S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCR32X16S_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCR32X16S_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCI32X16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCI32X16S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCI32X16S_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFCI32X16S_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCR32X16RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCR32X16RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCR32X16RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCR32X16RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCI32X16RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCI32X16RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCI32X16RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCI32X16RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCR32X16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCR32X16S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCR32X16S_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCR32X16S_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCI32X16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCI32X16S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCI32X16S_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFCI32X16S_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X2_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X2_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X2_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X2_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X2_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X2_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X2_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULP32X2_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X2_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAP32X2_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X2_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSP32X2_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP32X2RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFP32X2RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSFP32X2RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4S_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4S_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFP16X4RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULCR32X16_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULCR32X16_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULCR32X16_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULCR32X16_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULCI32X16_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULCI32X16_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULCI32X16_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULCI32X16_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULACR32X16_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULACR32X16_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULACR32X16_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULACR32X16_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULACI32X16_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULACI32X16_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULACI32X16_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULACI32X16_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16X4SS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16X4SS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16X4SS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16X4SS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16X4SS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16X4SS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16X4SS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULF16X4SS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16X4SS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAF16X4SS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16X4SS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULSF16X4SS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL16X4_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL16X4_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA16X4_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA16X4_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS16X4_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS16X4_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA16X4S_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA16X4S_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS16X4S_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS16X4S_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL16X4_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL16X4_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA16X4_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA16X4_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS16X4_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS16X4_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA16X4S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULA16X4S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS16X4S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULS16X4S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC16S_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC16S_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULC16S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC16S_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC16S_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAC16S_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFC16RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFC16RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFC16RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULFC16RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFC16RAS_H_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFC16RAS_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFC16RAS_L_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAFC16RAS_L_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAAAQ16_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'o' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULZAAAAQ16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAAAQ16_args[] = {
  { { OPERAND_opnd_ae_sem_mul_x2_S1_q0 }, 'm' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d0 }, 'i' },
  { { OPERAND_opnd_ae_sem_mul_x2_S1_d1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MULAAAAQ16_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL16JS_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MUL16JS_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CALCRNG3_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' }
};

static xtensa_arg_internal Iclass_AE_CALCRNG3_stateArgs[] = {
  { { STATE_AE_SAR }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDANDSUBRNG16RAS_S1_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'm' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'm' }
};

static xtensa_arg_internal Iclass_AE_ADDANDSUBRNG16RAS_S1_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ADDANDSUBRNG16RAS_S2_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'm' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'm' }
};

static xtensa_arg_internal Iclass_AE_ADDANDSUBRNG16RAS_S2_stateArgs[] = {
  { { STATE_AE_SAR }, 'i' },
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DIV64D32_H_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'm' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DIV64D32_H_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DIV64D32_L_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'm' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DIV64D32_L_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SHA32_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_ar_art }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_ar_arr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL32T_args[] = {
  { { OPERAND_opnd_ae_sem_vldc_loads_stores_done }, 'o' },
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL32T_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_SEARCHDONE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL16T_args[] = {
  { { OPERAND_opnd_ae_sem_vldc_loads_stores_done }, 'o' },
  { { OPERAND_art }, 'o' },
  { { OPERAND_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL16T_stateArgs[] = {
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITSUSED }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_SEARCHDONE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_stateArgs[] = {
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_IP_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_IP_stateArgs[] = {
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_IC_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_VLDL16C_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_NEXTOFFSET }, 'm' },
  { { STATE_AE_TABLESIZE }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_AE_FIRST_TS }, 'i' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_SEARCHDONE }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDSHT_args[] = {
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_VLDSHT_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_AE_FIRST_TS }, 'o' },
  { { STATE_AE_NEXTOFFSET }, 'o' },
  { { STATE_AE_TABLESIZE }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LB_args[] = {
  { { OPERAND_opnd_ae_sem_sb_loads_stores_ar_p }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LB_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBI_args[] = {
  { { OPERAND_opnd_ae_sem_sb_loads_stores_ar_p }, 'o' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBI_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBK_args[] = {
  { { OPERAND_opnd_ae_sem_sb_loads_stores_ar_p }, 'o' },
  { { OPERAND_opnd_ae_sem_sb_loads_stores_ar_u }, 'i' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBK_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBKI_args[] = {
  { { OPERAND_opnd_ae_sem_sb_loads_stores_ar_p }, 'o' },
  { { OPERAND_opnd_ae_sem_sb_loads_stores_ar_u }, 'i' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBKI_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBS_args[] = {
  { { OPERAND_opnd_ae_sem_sb_loads_stores_ar_p }, 'o' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBS_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBSI_args[] = {
  { { OPERAND_opnd_ae_sem_sb_loads_stores_ar_p }, 'o' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBSI_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBIT_args[] = {
  { { OPERAND_opnd_ae_sem_sb_loads_stores_ar_p }, 'm' },
  { { OPERAND_opnd_ae_sem_sb_loads_stores_vbr }, 'i' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBIT_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBIT_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_opnd_ae_sem_sb_loads_stores_vbr }, 'i' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBIT_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_IC_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_IC_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_IP_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DB_IP_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_IP_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_DBI_IP_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBI_DBI_IC_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_opnd_ae_sem_sb_loads_stores_ar_p }, 'o' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBI_DBI_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBI_DBI_IP_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_opnd_ae_sem_sb_loads_stores_ar_p }, 'o' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBI_DBI_IP_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBI_DBI_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_opnd_ae_sem_sb_loads_stores_ar_p }, 'o' },
  { { OPERAND_ae_ohba }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LBI_DBI_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_ae_ohba2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBF_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SBF_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBIT_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_opnd_ae_sem_sb_loads_stores_vbr }, 'i' },
  { { OPERAND_ae_ohba2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBIT_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_IC_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_IC_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_ae_ohba2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBF_IC_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SBF_IC_stateArgs[] = {
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CWRAP }, 'm' },
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_IP_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SB_IP_stateArgs[] = {
  { { STATE_AE_BITSUSED }, 'i' },
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_IP_args[] = {
  { { OPERAND_ars }, 'm' },
  { { OPERAND_art }, 'i' },
  { { OPERAND_ae_ohba2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBI_IP_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'm' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SBF_IP_args[] = {
  { { OPERAND_ars }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SBF_IP_stateArgs[] = {
  { { STATE_AE_BITPTR }, 'i' },
  { { STATE_AE_BITHEAD }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16SI_N_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_ae_uimm2x2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_L16UI_N_args[] = {
  { { OPERAND_art }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_ae_uimm2x2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_S16I_N_args[] = {
  { { OPERAND_art }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' },
  { { OPERAND_ae_uimm2x2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT16_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_ar_art }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_ar_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ZEXT16_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_ar_art }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_ar_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ZEXT8_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_ar_art }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_ar_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_CLAMPS16_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_ar_art }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_ar_ars }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ZEROB_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ZEROB_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ZEROC16X4_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' },
  { { OPERAND_ae_imm2 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ZEROC16X4_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ZEROC32X2_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_i_imm1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ZEROC32X2_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' },
  { { OPERAND_ae_opnd_tp7 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SEXT32_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVBA1_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_arr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAB1_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_art }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVBA2_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_arr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAB2_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_art }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVBA4_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_arr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAB4_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_art }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVBA8_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_arr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVAB8_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_art }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MB_args[] = {
  { { OPERAND_opnd_ae_sem_cmov_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_cmov_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_JOINB_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_vbs }, 'i' },
  { { OPERAND_opnd_ae_sem_vbool_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EXTRACTBI_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_vbr }, 'i' },
  { { OPERAND_opnd_ae_sem_vbool_i_imm3 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_RANDB4_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_RANDB8_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_RORB4_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_RORB8_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ANDB8_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_vbs }, 'i' },
  { { OPERAND_opnd_ae_sem_vbool_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ORB8_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_vbs }, 'i' },
  { { OPERAND_opnd_ae_sem_vbool_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_XORB8_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_vbs }, 'i' },
  { { OPERAND_opnd_ae_sem_vbool_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ANDNOTB8_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_vbs }, 'i' },
  { { OPERAND_opnd_ae_sem_vbool_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_ORNOTB8_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_vbs }, 'i' },
  { { OPERAND_opnd_ae_sem_vbool_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_NOTB8_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LTR4_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_arr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EXTRACTBL_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_EXTRACTBH_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_BITREV8_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_ar_art }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_ar_arr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_POPC2B_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_art }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_vbs }, 'i' },
  { { OPERAND_opnd_ae_sem_vbool_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_POPCB8_args[] = {
  { { OPERAND_opnd_ae_sem_vbool_art }, 'o' },
  { { OPERAND_opnd_ae_sem_vbool_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVSQZ16X4_args[] = {
  { { OPERAND_opnd_ae_sem_cmov_v }, 'o' },
  { { OPERAND_opnd_ae_sem_cmov_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmov_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVSQZ16X4_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA8X4S_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_uu }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA8X4S_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LA8X4U_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_uu }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_LA8X4U_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_IC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_su }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_su }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_su }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_su }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA32X2_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_IC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_su }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_IC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_su }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_RIP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_su }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_RIP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_RIC_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_su }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA16X4_RIC_stateArgs[] = {
  { { STATE_AE_CEND0 }, 'i' },
  { { STATE_AE_CBEGIN0 }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA8X4U_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_su }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA8X4U_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAV16X4_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_su }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAV16X4_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA64POS_FP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_su }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA64POS_FP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA64NEG_FP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_su }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA64NEG_FP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SA8X8_IP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_su }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' }
};

static xtensa_arg_internal Iclass_AE_SA8X8_IP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAV8X8_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_su }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAV8X8_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LAV8X8_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_uu }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LAV8X8_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LAV16X4_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_uu }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LAV16X4_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LAV8X4S_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_uu }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LAV8X4S_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LAV8X4U_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'o' },
  { { OPERAND_opnd_ae_sem_loads_stores_uu }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_LAV8X4U_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAV8X4U_XP_args[] = {
  { { OPERAND_opnd_ae_sem_loads_stores_v }, 'i' },
  { { OPERAND_opnd_ae_sem_loads_stores_su }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_a }, 'm' },
  { { OPERAND_opnd_ae_sem_loads_stores_x }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAV8X4U_XP_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SATU16X4_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SATU16X4_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT8X4X32_H_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SAT8X4X32_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SATU8X4X32_H_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_SATU8X4X32_H_stateArgs[] = {
  { { STATE_AE_OVERFLOW }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_FCR_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_FCR_stateArgs[] = {
  { { STATE_RoundMode }, 'i' },
  { { STATE_StickyEnable }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_FCR_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_FCR_stateArgs[] = {
  { { STATE_RoundMode }, 'o' },
  { { STATE_StickyEnable }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RUR_FSR_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'o' }
};

static xtensa_arg_internal Iclass_RUR_FSR_stateArgs[] = {
  { { STATE_StickyFlags }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_FSR_args[] = {
  { { OPERAND_opnd_ae_sem_rur_wur_a }, 'i' }
};

static xtensa_arg_internal Iclass_WUR_FSR_stateArgs[] = {
  { { STATE_StickyFlags }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RFR_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_ar_a }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_ar_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_RFR_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_WFR_args[] = {
  { { OPERAND_opnd_ae_sem_ar_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_ar_to_dr_a0 }, 'i' }
};

static xtensa_arg_internal Iclass_WFR_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVT_S_args[] = {
  { { OPERAND_opnd_ae_sem_cmov_v }, 'm' },
  { { OPERAND_opnd_ae_sem_cmov_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmov_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_MOVT_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVF_S_args[] = {
  { { OPERAND_opnd_ae_sem_cmov_v }, 'm' },
  { { OPERAND_opnd_ae_sem_cmov_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmov_vbr }, 'i' }
};

static xtensa_arg_internal Iclass_MOVF_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVEQZ_S_args[] = {
  { { OPERAND_opnd_ae_sem_cmov_v }, 'm' },
  { { OPERAND_opnd_ae_sem_cmov_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmov_arr }, 'i' }
};

static xtensa_arg_internal Iclass_MOVEQZ_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVNEZ_S_args[] = {
  { { OPERAND_opnd_ae_sem_cmov_v }, 'm' },
  { { OPERAND_opnd_ae_sem_cmov_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmov_arr }, 'i' }
};

static xtensa_arg_internal Iclass_MOVNEZ_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVGEZ_S_args[] = {
  { { OPERAND_opnd_ae_sem_cmov_v }, 'm' },
  { { OPERAND_opnd_ae_sem_cmov_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmov_arr }, 'i' }
};

static xtensa_arg_internal Iclass_MOVGEZ_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MOVLTZ_S_args[] = {
  { { OPERAND_opnd_ae_sem_cmov_v }, 'm' },
  { { OPERAND_opnd_ae_sem_cmov_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_cmov_arr }, 'i' }
};

static xtensa_arg_internal Iclass_MOVLTZ_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ADD_S_args[] = {
  { { OPERAND_opnd_ae_sem_spfma_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spfma_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_spfma_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_ADD_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_SUB_S_args[] = {
  { { OPERAND_opnd_ae_sem_spfma_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spfma_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_spfma_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_SUB_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MUL_S_args[] = {
  { { OPERAND_opnd_ae_sem_spfma_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spfma_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_spfma_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_MUL_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MADD_S_args[] = {
  { { OPERAND_opnd_ae_sem_spfma_v }, 'm' },
  { { OPERAND_opnd_ae_sem_spfma_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_spfma_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_MADD_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MADDN_S_args[] = {
  { { OPERAND_opnd_ae_sem_spfma_v }, 'm' },
  { { OPERAND_opnd_ae_sem_spfma_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_spfma_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_MADDN_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MSUB_S_args[] = {
  { { OPERAND_opnd_ae_sem_spfma_v }, 'm' },
  { { OPERAND_opnd_ae_sem_spfma_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_spfma_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_MSUB_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MSUBN_S_args[] = {
  { { OPERAND_opnd_ae_sem_spfma_v }, 'm' },
  { { OPERAND_opnd_ae_sem_spfma_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_spfma_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_MSUBN_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_DIVN_S_args[] = {
  { { OPERAND_opnd_ae_sem_spfma_v }, 'm' },
  { { OPERAND_opnd_ae_sem_spfma_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_spfma_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_DIVN_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ABS_S_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_ABS_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_NEG_S_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_NEG_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_CONJC_S_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_CONJC_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_CONST_S_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_i_imm4 }, 'i' }
};

static xtensa_arg_internal Iclass_CONST_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MAX_S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_MAX_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MIN_S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_MIN_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MINNUM_S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_MINNUM_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MAXNUM_S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_MAXNUM_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_OLE_S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_OLE_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_OLT_S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_OLT_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_OEQ_S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_OEQ_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_UN_S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_UN_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ULE_S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_ULE_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ULT_S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_ULT_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_UEQ_S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_vbt }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_arithmetic_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_UEQ_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ADDEXP_S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'm' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_ADDEXP_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_ADDEXPM_S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'm' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_ADDEXPM_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MKSADJ_S_args[] = {
  { { OPERAND_opnd_ae_sem_spcvtlookup_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_MKSADJ_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MKDADJ_S_args[] = {
  { { OPERAND_opnd_ae_sem_spcvtlookup_v1 }, 'm' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_MKDADJ_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_NEXP01_S_args[] = {
  { { OPERAND_opnd_ae_sem_spcvtlookup_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_NEXP01_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_DIV0_S_args[] = {
  { { OPERAND_opnd_ae_sem_spcvtlookup_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_DIV0_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_SQRT0_S_args[] = {
  { { OPERAND_opnd_ae_sem_spcvtlookup_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_SQRT0_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RECIP0_S_args[] = {
  { { OPERAND_opnd_ae_sem_spcvtlookup_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_RECIP0_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_RSQRT0_S_args[] = {
  { { OPERAND_opnd_ae_sem_spcvtlookup_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_RSQRT0_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_TRUNC_S_args[] = {
  { { OPERAND_opnd_ae_sem_spcvtlookup_art }, 'o' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_i_imm5 }, 'i' }
};

static xtensa_arg_internal Iclass_TRUNC_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_UTRUNC_S_args[] = {
  { { OPERAND_opnd_ae_sem_spcvtlookup_art }, 'o' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_i_imm5 }, 'i' }
};

static xtensa_arg_internal Iclass_UTRUNC_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_TRUNC_SX2_args[] = {
  { { OPERAND_opnd_ae_sem_spcvtlookup_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_i_imm5 }, 'i' }
};

static xtensa_arg_internal Iclass_TRUNC_SX2_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_UTRUNC_SX2_args[] = {
  { { OPERAND_opnd_ae_sem_spcvtlookup_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_i_imm5 }, 'i' }
};

static xtensa_arg_internal Iclass_UTRUNC_SX2_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_FICEIL_S_args[] = {
  { { OPERAND_opnd_ae_sem_spcvtlookup_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_FICEIL_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_FIFLOOR_S_args[] = {
  { { OPERAND_opnd_ae_sem_spcvtlookup_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_FIFLOOR_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_FIRINT_S_args[] = {
  { { OPERAND_opnd_ae_sem_spcvtlookup_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_FIRINT_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_FIROUND_S_args[] = {
  { { OPERAND_opnd_ae_sem_spcvtlookup_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_FIROUND_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_FITRUNC_S_args[] = {
  { { OPERAND_opnd_ae_sem_spcvtlookup_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_FITRUNC_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_FLOAT_S_args[] = {
  { { OPERAND_opnd_ae_sem_spcvtlookup_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_arr }, 'i' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_i_imm5 }, 'i' }
};

static xtensa_arg_internal Iclass_FLOAT_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_UFLOAT_S_args[] = {
  { { OPERAND_opnd_ae_sem_spcvtlookup_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_arr }, 'i' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_i_imm5 }, 'i' }
};

static xtensa_arg_internal Iclass_UFLOAT_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_FLOAT_SX2_args[] = {
  { { OPERAND_opnd_ae_sem_spcvtlookup_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_i_imm5 }, 'i' }
};

static xtensa_arg_internal Iclass_FLOAT_SX2_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_UFLOAT_SX2_args[] = {
  { { OPERAND_opnd_ae_sem_spcvtlookup_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_i_imm5 }, 'i' }
};

static xtensa_arg_internal Iclass_UFLOAT_SX2_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MULJC_S_args[] = {
  { { OPERAND_opnd_ae_sem_dr_to_dr_v }, 'o' },
  { { OPERAND_opnd_ae_sem_dr_to_dr_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_MULJC_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_CLSFY_S_args[] = {
  { { OPERAND_opnd_ae_sem_arithmetic_v }, 'o' },
  { { OPERAND_opnd_ae_sem_arithmetic_v1 }, 'i' }
};

static xtensa_arg_internal Iclass_CLSFY_S_stateArgs[] = {
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_CVTSF16_L_args[] = {
  { { OPERAND_opnd_ae_sem_spcvtlookup_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_CVTSF16_L_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_CVTF16S_L_args[] = {
  { { OPERAND_opnd_ae_sem_spcvtlookup_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spcvtlookup_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_CVTF16S_L_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MULMUX_S_args[] = {
  { { OPERAND_opnd_ae_sem_spfma_v }, 'o' },
  { { OPERAND_opnd_ae_sem_spfma_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_spfma_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_spfma_i_imm3 }, 'i' }
};

static xtensa_arg_internal Iclass_MULMUX_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_MADDMUX_S_args[] = {
  { { OPERAND_opnd_ae_sem_spfma_v }, 'm' },
  { { OPERAND_opnd_ae_sem_spfma_v1 }, 'i' },
  { { OPERAND_opnd_ae_sem_spfma_v0 }, 'i' },
  { { OPERAND_opnd_ae_sem_spfma_i_imm4 }, 'i' }
};

static xtensa_arg_internal Iclass_MADDMUX_S_stateArgs[] = {
  { { STATE_StickyFlags }, 'm' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVFCRFSRV_args[] = {
  { { OPERAND_opnd_ae_sem_movstate1_v0 }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVFCRFSRV_stateArgs[] = {
  { { STATE_StickyFlags }, 'o' },
  { { STATE_RoundMode }, 'o' },
  { { STATE_StickyEnable }, 'o' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_arg_internal Iclass_AE_MOVVFCRFSR_args[] = {
  { { OPERAND_opnd_ae_sem_movstate1_v }, 'o' }
};

static xtensa_arg_internal Iclass_AE_MOVVFCRFSR_stateArgs[] = {
  { { STATE_StickyFlags }, 'i' },
  { { STATE_RoundMode }, 'i' },
  { { STATE_StickyEnable }, 'i' },
  { { STATE_CPENABLE }, 'i' }
};

static xtensa_iclass_internal iclasses[] = {
  { 0, 0 /* xt_iclass_excw */,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_rfe */,
    2, Iclass_xt_iclass_rfe_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_rfde */,
    1, Iclass_xt_iclass_rfde_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_syscall */,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_call12_args,
    1, Iclass_xt_iclass_call12_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_call8_args,
    1, Iclass_xt_iclass_call8_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_call4_args,
    1, Iclass_xt_iclass_call4_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_callx12_args,
    1, Iclass_xt_iclass_callx12_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_callx8_args,
    1, Iclass_xt_iclass_callx8_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_callx4_args,
    1, Iclass_xt_iclass_callx4_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_entry_args,
    5, Iclass_xt_iclass_entry_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_movsp_args,
    2, Iclass_xt_iclass_movsp_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rotw_args,
    1, Iclass_xt_iclass_rotw_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_retw_args,
    5, Iclass_xt_iclass_retw_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_rfwou */,
    5, Iclass_xt_iclass_rfwou_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_l32e_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32e_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_windowbase_args,
    1, Iclass_xt_iclass_rsr_windowbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_windowbase_args,
    1, Iclass_xt_iclass_wsr_windowbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_windowbase_args,
    1, Iclass_xt_iclass_xsr_windowbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_windowstart_args,
    1, Iclass_xt_iclass_rsr_windowstart_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_windowstart_args,
    1, Iclass_xt_iclass_wsr_windowstart_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_windowstart_args,
    1, Iclass_xt_iclass_xsr_windowstart_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_add_n_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_addi_n_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_bz6_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_ill_n */,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_loadi4_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_mov_n_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_movi_n_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_nopn */,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_retn_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_storei4_args,
    0, 0, 0, 0 },
  { 1, Iclass_rur_threadptr_args,
    1, Iclass_rur_threadptr_stateArgs, 0, 0 },
  { 1, Iclass_wur_threadptr_args,
    1, Iclass_wur_threadptr_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_addi_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_addmi_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_addsub_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bit_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bsi8_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bsi8b_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bsi8u_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_bst8_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_bsz12_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_call0_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_callx0_args,
    0, 0, 0, 0 },
  { 4, Iclass_xt_iclass_exti_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_ill */,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_jump_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_jumpx_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l16ui_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l16si_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l32i_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_l32r_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l8i_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_loop_args,
    3, Iclass_xt_iclass_loop_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_loopz_args,
    3, Iclass_xt_iclass_loopz_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_movi_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_movz_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_neg_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_nop */,
    0, 0, 0, 0 },
  { 4, Iclass_xt_iclass_depbits_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_return_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_simcall_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s16i_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32i_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32nb_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s8i_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_sar_args,
    1, Iclass_xt_iclass_sar_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_sari_args,
    1, Iclass_xt_iclass_sari_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_shifts_args,
    1, Iclass_xt_iclass_shifts_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_shiftst_args,
    1, Iclass_xt_iclass_shiftst_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_shiftt_args,
    1, Iclass_xt_iclass_shiftt_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_slli_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_srai_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_srli_args,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_memw */,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_extw */,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_isync */,
    0, 0, 0, 0 },
  { 0, 0 /* xt_iclass_sync */,
    1, Iclass_xt_iclass_sync_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_rsil_args,
    6, Iclass_xt_iclass_rsil_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_lend_args,
    1, Iclass_xt_iclass_rsr_lend_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_lend_args,
    1, Iclass_xt_iclass_wsr_lend_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_lend_args,
    1, Iclass_xt_iclass_xsr_lend_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_lcount_args,
    1, Iclass_xt_iclass_rsr_lcount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_lcount_args,
    2, Iclass_xt_iclass_wsr_lcount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_lcount_args,
    2, Iclass_xt_iclass_xsr_lcount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_lbeg_args,
    1, Iclass_xt_iclass_rsr_lbeg_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_lbeg_args,
    1, Iclass_xt_iclass_wsr_lbeg_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_lbeg_args,
    1, Iclass_xt_iclass_xsr_lbeg_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_sar_args,
    1, Iclass_xt_iclass_rsr_sar_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_sar_args,
    2, Iclass_xt_iclass_wsr_sar_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_sar_args,
    1, Iclass_xt_iclass_xsr_sar_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_memctl_args,
    1, Iclass_xt_iclass_rsr_memctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_memctl_args,
    1, Iclass_xt_iclass_wsr_memctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_memctl_args,
    1, Iclass_xt_iclass_xsr_memctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_configid0_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_configid0_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_configid1_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_243_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ps_args,
    6, Iclass_xt_iclass_rsr_ps_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ps_args,
    6, Iclass_xt_iclass_wsr_ps_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ps_args,
    6, Iclass_xt_iclass_xsr_ps_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc1_args,
    1, Iclass_xt_iclass_rsr_epc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc1_args,
    1, Iclass_xt_iclass_wsr_epc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc1_args,
    1, Iclass_xt_iclass_xsr_epc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave1_args,
    1, Iclass_xt_iclass_rsr_excsave1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave1_args,
    1, Iclass_xt_iclass_wsr_excsave1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave1_args,
    1, Iclass_xt_iclass_xsr_excsave1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc2_args,
    1, Iclass_xt_iclass_rsr_epc2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc2_args,
    1, Iclass_xt_iclass_wsr_epc2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc2_args,
    1, Iclass_xt_iclass_xsr_epc2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave2_args,
    1, Iclass_xt_iclass_rsr_excsave2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave2_args,
    1, Iclass_xt_iclass_wsr_excsave2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave2_args,
    1, Iclass_xt_iclass_xsr_excsave2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc3_args,
    1, Iclass_xt_iclass_rsr_epc3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc3_args,
    1, Iclass_xt_iclass_wsr_epc3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc3_args,
    1, Iclass_xt_iclass_xsr_epc3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave3_args,
    1, Iclass_xt_iclass_rsr_excsave3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave3_args,
    1, Iclass_xt_iclass_wsr_excsave3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave3_args,
    1, Iclass_xt_iclass_xsr_excsave3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc4_args,
    1, Iclass_xt_iclass_rsr_epc4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc4_args,
    1, Iclass_xt_iclass_wsr_epc4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc4_args,
    1, Iclass_xt_iclass_xsr_epc4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave4_args,
    1, Iclass_xt_iclass_rsr_excsave4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave4_args,
    1, Iclass_xt_iclass_wsr_excsave4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave4_args,
    1, Iclass_xt_iclass_xsr_excsave4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_epc5_args,
    1, Iclass_xt_iclass_rsr_epc5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_epc5_args,
    1, Iclass_xt_iclass_wsr_epc5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_epc5_args,
    1, Iclass_xt_iclass_xsr_epc5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excsave5_args,
    1, Iclass_xt_iclass_rsr_excsave5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excsave5_args,
    1, Iclass_xt_iclass_wsr_excsave5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excsave5_args,
    1, Iclass_xt_iclass_xsr_excsave5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps2_args,
    1, Iclass_xt_iclass_rsr_eps2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps2_args,
    1, Iclass_xt_iclass_wsr_eps2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps2_args,
    1, Iclass_xt_iclass_xsr_eps2_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps3_args,
    1, Iclass_xt_iclass_rsr_eps3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps3_args,
    1, Iclass_xt_iclass_wsr_eps3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps3_args,
    1, Iclass_xt_iclass_xsr_eps3_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps4_args,
    1, Iclass_xt_iclass_rsr_eps4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps4_args,
    1, Iclass_xt_iclass_wsr_eps4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps4_args,
    1, Iclass_xt_iclass_xsr_eps4_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eps5_args,
    1, Iclass_xt_iclass_rsr_eps5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eps5_args,
    1, Iclass_xt_iclass_wsr_eps5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eps5_args,
    1, Iclass_xt_iclass_xsr_eps5_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_excvaddr_args,
    1, Iclass_xt_iclass_rsr_excvaddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_excvaddr_args,
    1, Iclass_xt_iclass_wsr_excvaddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_excvaddr_args,
    1, Iclass_xt_iclass_xsr_excvaddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_depc_args,
    1, Iclass_xt_iclass_rsr_depc_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_depc_args,
    1, Iclass_xt_iclass_wsr_depc_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_depc_args,
    1, Iclass_xt_iclass_xsr_depc_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_exccause_args,
    2, Iclass_xt_iclass_rsr_exccause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_exccause_args,
    1, Iclass_xt_iclass_wsr_exccause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_exccause_args,
    1, Iclass_xt_iclass_xsr_exccause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_misc0_args,
    1, Iclass_xt_iclass_rsr_misc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_misc0_args,
    1, Iclass_xt_iclass_wsr_misc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_misc0_args,
    1, Iclass_xt_iclass_xsr_misc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_misc1_args,
    1, Iclass_xt_iclass_rsr_misc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_misc1_args,
    1, Iclass_xt_iclass_wsr_misc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_misc1_args,
    1, Iclass_xt_iclass_xsr_misc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_prid_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_vecbase_args,
    2, Iclass_xt_iclass_rsr_vecbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_vecbase_args,
    2, Iclass_xt_iclass_wsr_vecbase_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_vecbase_args,
    2, Iclass_xt_iclass_xsr_vecbase_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_salt_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_opmode_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_opmode_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_opmode_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rfi_args,
    16, Iclass_xt_iclass_rfi_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wait_args,
    1, Iclass_xt_iclass_wait_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_interrupt_args,
    1, Iclass_xt_iclass_rsr_interrupt_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_intset_args,
    2, Iclass_xt_iclass_wsr_intset_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_intclear_args,
    2, Iclass_xt_iclass_wsr_intclear_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_intenable_args,
    1, Iclass_xt_iclass_rsr_intenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_intenable_args,
    1, Iclass_xt_iclass_wsr_intenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_intenable_args,
    1, Iclass_xt_iclass_xsr_intenable_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_break_args,
    2, Iclass_xt_iclass_break_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_break_n_args,
    2, Iclass_xt_iclass_break_n_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_dbreaka0_args,
    1, Iclass_xt_iclass_rsr_dbreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_dbreaka0_args,
    2, Iclass_xt_iclass_wsr_dbreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_dbreaka0_args,
    2, Iclass_xt_iclass_xsr_dbreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_dbreakc0_args,
    1, Iclass_xt_iclass_rsr_dbreakc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_dbreakc0_args,
    2, Iclass_xt_iclass_wsr_dbreakc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_dbreakc0_args,
    2, Iclass_xt_iclass_xsr_dbreakc0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_dbreaka1_args,
    1, Iclass_xt_iclass_rsr_dbreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_dbreaka1_args,
    2, Iclass_xt_iclass_wsr_dbreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_dbreaka1_args,
    2, Iclass_xt_iclass_xsr_dbreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_dbreakc1_args,
    1, Iclass_xt_iclass_rsr_dbreakc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_dbreakc1_args,
    2, Iclass_xt_iclass_wsr_dbreakc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_dbreakc1_args,
    2, Iclass_xt_iclass_xsr_dbreakc1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ibreaka0_args,
    1, Iclass_xt_iclass_rsr_ibreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ibreaka0_args,
    1, Iclass_xt_iclass_wsr_ibreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ibreaka0_args,
    1, Iclass_xt_iclass_xsr_ibreaka0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ibreaka1_args,
    1, Iclass_xt_iclass_rsr_ibreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ibreaka1_args,
    1, Iclass_xt_iclass_wsr_ibreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ibreaka1_args,
    1, Iclass_xt_iclass_xsr_ibreaka1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ibreakenable_args,
    1, Iclass_xt_iclass_rsr_ibreakenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ibreakenable_args,
    1, Iclass_xt_iclass_wsr_ibreakenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ibreakenable_args,
    1, Iclass_xt_iclass_xsr_ibreakenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_debugcause_args,
    2, Iclass_xt_iclass_rsr_debugcause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_debugcause_args,
    2, Iclass_xt_iclass_wsr_debugcause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_debugcause_args,
    2, Iclass_xt_iclass_xsr_debugcause_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_icount_args,
    1, Iclass_xt_iclass_rsr_icount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_icount_args,
    2, Iclass_xt_iclass_wsr_icount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_icount_args,
    2, Iclass_xt_iclass_xsr_icount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_icountlevel_args,
    1, Iclass_xt_iclass_rsr_icountlevel_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_icountlevel_args,
    1, Iclass_xt_iclass_wsr_icountlevel_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_icountlevel_args,
    1, Iclass_xt_iclass_xsr_icountlevel_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ddr_args,
    1, Iclass_xt_iclass_rsr_ddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ddr_args,
    2, Iclass_xt_iclass_wsr_ddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ddr_args,
    2, Iclass_xt_iclass_xsr_ddr_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_lddr32_p_args,
    3, Iclass_xt_iclass_lddr32_p_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_sddr32_p_args,
    2, Iclass_xt_iclass_sddr32_p_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rfdo_args,
    9, Iclass_xt_iclass_rfdo_stateArgs, 0, 0 },
  { 0, 0 /* xt_iclass_rfdd */,
    2, Iclass_xt_iclass_rfdd_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_mmid_args,
    1, Iclass_xt_iclass_wsr_mmid_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ccount_args,
    1, Iclass_xt_iclass_rsr_ccount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ccount_args,
    2, Iclass_xt_iclass_wsr_ccount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ccount_args,
    2, Iclass_xt_iclass_xsr_ccount_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ccompare0_args,
    1, Iclass_xt_iclass_rsr_ccompare0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ccompare0_args,
    2, Iclass_xt_iclass_wsr_ccompare0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ccompare0_args,
    2, Iclass_xt_iclass_xsr_ccompare0_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_ccompare1_args,
    1, Iclass_xt_iclass_rsr_ccompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_ccompare1_args,
    2, Iclass_xt_iclass_wsr_ccompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_ccompare1_args,
    2, Iclass_xt_iclass_xsr_ccompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_idtlb_args,
    1, Iclass_xt_iclass_idtlb_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_rdtlb_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_wdtlb_args,
    1, Iclass_xt_iclass_wdtlb_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_iitlb_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_ritlb_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_witlb_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_cpenable_args,
    1, Iclass_xt_iclass_rsr_cpenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_cpenable_args,
    1, Iclass_xt_iclass_wsr_cpenable_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_cpenable_args,
    1, Iclass_xt_iclass_xsr_cpenable_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_clamp_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_minmax_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_nsa_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_sx_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_l32ai_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32ri_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_s32c1i_args,
    3, Iclass_xt_iclass_s32c1i_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_scompare1_args,
    1, Iclass_xt_iclass_rsr_scompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_scompare1_args,
    1, Iclass_xt_iclass_wsr_scompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_scompare1_args,
    1, Iclass_xt_iclass_xsr_scompare1_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_atomctl_args,
    1, Iclass_xt_iclass_rsr_atomctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_atomctl_args,
    2, Iclass_xt_iclass_wsr_atomctl_stateArgs, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_atomctl_args,
    2, Iclass_xt_iclass_xsr_atomctl_stateArgs, 0, 0 },
  { 3, Iclass_xt_iclass_div_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_rsr_eraccess_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_wsr_eraccess_args,
    0, 0, 0, 0 },
  { 1, Iclass_xt_iclass_xsr_eraccess_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_rer_args,
    1, Iclass_xt_iclass_rer_stateArgs, 2, Iclass_xt_iclass_rer_intfArgs },
  { 2, Iclass_xt_iclass_wer_args,
    1, Iclass_xt_iclass_wer_stateArgs, 2, Iclass_xt_iclass_wer_intfArgs },
  { 2, Iclass_xt_iclass_wb15_0_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_wb15_1_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_wb15_2_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_wb15_3_args,
    0, 0, 0, 0 },
  { 3, Iclass_xt_iclass_wb15_4_args,
    0, 0, 0, 0 },
  { 2, Iclass_xt_iclass_wloop_args,
    3, Iclass_xt_iclass_wloop_stateArgs, 0, 0 },
  { 2, Iclass_xt_iclass_wloopz_args,
    3, Iclass_xt_iclass_wloopz_stateArgs, 0, 0 },
  { 1, Iclass_iclass_READ_IMPWIRE_args,
    0, 0, 1, Iclass_iclass_READ_IMPWIRE_intfArgs },
  { 1, Iclass_iclass_SETB_EXPSTATE_args,
    1, Iclass_iclass_SETB_EXPSTATE_stateArgs, 0, 0 },
  { 1, Iclass_iclass_CLRB_EXPSTATE_args,
    1, Iclass_iclass_CLRB_EXPSTATE_stateArgs, 0, 0 },
  { 2, Iclass_iclass_WRMSK_EXPSTATE_args,
    1, Iclass_iclass_WRMSK_EXPSTATE_stateArgs, 0, 0 },
  { 1, Iclass_rur_expstate_args,
    1, Iclass_rur_expstate_stateArgs, 0, 0 },
  { 1, Iclass_wur_expstate_args,
    1, Iclass_wur_expstate_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_BITHEAD_args,
    2, Iclass_RUR_AE_BITHEAD_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_BITHEAD_args,
    2, Iclass_WUR_AE_BITHEAD_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_CBEGIN0_args,
    2, Iclass_RUR_AE_CBEGIN0_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_CBEGIN0_args,
    2, Iclass_WUR_AE_CBEGIN0_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_CEND0_args,
    2, Iclass_RUR_AE_CEND0_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_CEND0_args,
    2, Iclass_WUR_AE_CEND0_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_OVERFLOW_args,
    2, Iclass_RUR_AE_OVERFLOW_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_OVERFLOW_args,
    2, Iclass_WUR_AE_OVERFLOW_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_SAR_args,
    2, Iclass_RUR_AE_SAR_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_SAR_args,
    2, Iclass_WUR_AE_SAR_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_BITPTR_args,
    2, Iclass_RUR_AE_BITPTR_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_BITPTR_args,
    2, Iclass_WUR_AE_BITPTR_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_BITSUSED_args,
    2, Iclass_RUR_AE_BITSUSED_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_BITSUSED_args,
    2, Iclass_WUR_AE_BITSUSED_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_TABLESIZE_args,
    2, Iclass_RUR_AE_TABLESIZE_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_TABLESIZE_args,
    2, Iclass_WUR_AE_TABLESIZE_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_FIRST_TS_args,
    2, Iclass_RUR_AE_FIRST_TS_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_FIRST_TS_args,
    2, Iclass_WUR_AE_FIRST_TS_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_NEXTOFFSET_args,
    2, Iclass_RUR_AE_NEXTOFFSET_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_NEXTOFFSET_args,
    2, Iclass_WUR_AE_NEXTOFFSET_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_SEARCHDONE_args,
    2, Iclass_RUR_AE_SEARCHDONE_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_SEARCHDONE_args,
    2, Iclass_WUR_AE_SEARCHDONE_stateArgs, 0, 0 },
  { 1, Iclass_RUR_AE_CWRAP_args,
    2, Iclass_RUR_AE_CWRAP_stateArgs, 0, 0 },
  { 1, Iclass_WUR_AE_CWRAP_args,
    2, Iclass_WUR_AE_CWRAP_stateArgs, 0, 0 },
  { 1, Iclass_AE_MOVCIRCV_args,
    3, Iclass_AE_MOVCIRCV_stateArgs, 0, 0 },
  { 1, Iclass_AE_MOVVCIRC_args,
    3, Iclass_AE_MOVVCIRC_stateArgs, 0, 0 },
  { 1, Iclass_AE_MOVFUSIONMISCV_args,
    7, Iclass_AE_MOVFUSIONMISCV_stateArgs, 0, 0 },
  { 1, Iclass_AE_MOVVFUSIONMISC_args,
    7, Iclass_AE_MOVVFUSIONMISC_stateArgs, 0, 0 },
  { 1, Iclass_AE_MOVTABLEFIRSTSEARCHNEXTV_args,
    5, Iclass_AE_MOVTABLEFIRSTSEARCHNEXTV_stateArgs, 0, 0 },
  { 1, Iclass_AE_MOVVTABLEFIRSTSEARCHNEXT_args,
    5, Iclass_AE_MOVVTABLEFIRSTSEARCHNEXT_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8_I_args,
    1, Iclass_AE_L8_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8_IP_args,
    1, Iclass_AE_L8_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8_X_args,
    1, Iclass_AE_L8_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8_XP_args,
    1, Iclass_AE_L8_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8S_I_args,
    1, Iclass_AE_L8S_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8S_IP_args,
    1, Iclass_AE_L8S_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8U_I_args,
    1, Iclass_AE_L8U_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8U_IP_args,
    1, Iclass_AE_L8U_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X4F_I_args,
    1, Iclass_AE_L8X4F_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X4F_IP_args,
    1, Iclass_AE_L8X4F_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X4F_X_args,
    1, Iclass_AE_L8X4F_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X4F_XP_args,
    1, Iclass_AE_L8X4F_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X4S_I_args,
    1, Iclass_AE_L8X4S_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X4S_IP_args,
    1, Iclass_AE_L8X4S_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X4S_X_args,
    1, Iclass_AE_L8X4S_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X4S_XP_args,
    1, Iclass_AE_L8X4S_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X4U_I_args,
    1, Iclass_AE_L8X4U_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X4U_IP_args,
    1, Iclass_AE_L8X4U_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X4U_X_args,
    1, Iclass_AE_L8X4U_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X4U_XP_args,
    1, Iclass_AE_L8X4U_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X8_I_args,
    1, Iclass_AE_L8X8_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X8_IP_args,
    1, Iclass_AE_L8X8_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X8_X_args,
    1, Iclass_AE_L8X8_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L8X8_XP_args,
    1, Iclass_AE_L8X8_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16_XC_args,
    3, Iclass_AE_L16_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16_I_args,
    1, Iclass_AE_L16_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16_IP_args,
    1, Iclass_AE_L16_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16_X_args,
    1, Iclass_AE_L16_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16_XP_args,
    1, Iclass_AE_L16_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16M_XC_args,
    3, Iclass_AE_L16M_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16M_I_args,
    1, Iclass_AE_L16M_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16M_IU_args,
    1, Iclass_AE_L16M_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16M_X_args,
    1, Iclass_AE_L16M_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16M_XU_args,
    1, Iclass_AE_L16M_XU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X2M_XC_args,
    3, Iclass_AE_L16X2M_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X2M_I_args,
    1, Iclass_AE_L16X2M_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X2M_IU_args,
    1, Iclass_AE_L16X2M_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X2M_X_args,
    1, Iclass_AE_L16X2M_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X2M_XU_args,
    1, Iclass_AE_L16X2M_XU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X4_XC_args,
    3, Iclass_AE_L16X4_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X4_I_args,
    1, Iclass_AE_L16X4_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X4_IP_args,
    1, Iclass_AE_L16X4_IP_stateArgs, 0, 0 },
  { 2, Iclass_AE_L16X4_RIP_args,
    1, Iclass_AE_L16X4_RIP_stateArgs, 0, 0 },
  { 2, Iclass_AE_L16X4_RIC_args,
    3, Iclass_AE_L16X4_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X4_X_args,
    1, Iclass_AE_L16X4_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16X4_XP_args,
    1, Iclass_AE_L16X4_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32_XC_args,
    3, Iclass_AE_L32_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32_I_args,
    1, Iclass_AE_L32_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32_IP_args,
    1, Iclass_AE_L32_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32_X_args,
    1, Iclass_AE_L32_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32_XP_args,
    1, Iclass_AE_L32_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32M_XC_args,
    3, Iclass_AE_L32M_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32M_I_args,
    1, Iclass_AE_L32M_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32M_IU_args,
    1, Iclass_AE_L32M_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32M_X_args,
    1, Iclass_AE_L32M_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32M_XU_args,
    1, Iclass_AE_L32M_XU_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2_XC_args,
    3, Iclass_AE_L32X2_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2_I_args,
    1, Iclass_AE_L32X2_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2_IP_args,
    1, Iclass_AE_L32X2_IP_stateArgs, 0, 0 },
  { 2, Iclass_AE_L32X2_RIP_args,
    1, Iclass_AE_L32X2_RIP_stateArgs, 0, 0 },
  { 2, Iclass_AE_L32X2_RIC_args,
    3, Iclass_AE_L32X2_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2_X_args,
    1, Iclass_AE_L32X2_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L32X2_XP_args,
    1, Iclass_AE_L32X2_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L64_XC_args,
    3, Iclass_AE_L64_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_L64_I_args,
    1, Iclass_AE_L64_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_L64_IP_args,
    1, Iclass_AE_L64_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L64_X_args,
    1, Iclass_AE_L64_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_L64_XP_args,
    1, Iclass_AE_L64_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S8_0_I_args,
    1, Iclass_AE_S8_0_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S8_0_IP_args,
    1, Iclass_AE_S8_0_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S8_0_X_args,
    1, Iclass_AE_S8_0_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S8_0_XP_args,
    1, Iclass_AE_S8_0_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S8X4_I_args,
    1, Iclass_AE_S8X4_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S8X4_IP_args,
    1, Iclass_AE_S8X4_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S8X4F_I_args,
    1, Iclass_AE_S8X4F_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S8X4F_IP_args,
    1, Iclass_AE_S8X4F_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S8X8_I_args,
    1, Iclass_AE_S8X8_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S8X8_IP_args,
    1, Iclass_AE_S8X8_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S8X8_X_args,
    1, Iclass_AE_S8X8_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S8X8_XP_args,
    1, Iclass_AE_S8X8_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16_0_XC_args,
    3, Iclass_AE_S16_0_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16_0_I_args,
    1, Iclass_AE_S16_0_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16_0_IP_args,
    1, Iclass_AE_S16_0_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16_0_X_args,
    1, Iclass_AE_S16_0_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16_0_XP_args,
    1, Iclass_AE_S16_0_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16M_L_XC_args,
    3, Iclass_AE_S16M_L_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16M_L_I_args,
    1, Iclass_AE_S16M_L_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16M_L_IU_args,
    1, Iclass_AE_S16M_L_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16M_L_X_args,
    1, Iclass_AE_S16M_L_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16M_L_XU_args,
    1, Iclass_AE_S16M_L_XU_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X2M_XC_args,
    3, Iclass_AE_S16X2M_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X2M_I_args,
    1, Iclass_AE_S16X2M_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X2M_IU_args,
    1, Iclass_AE_S16X2M_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X2M_X_args,
    1, Iclass_AE_S16X2M_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X2M_XU_args,
    1, Iclass_AE_S16X2M_XU_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4_XC_args,
    3, Iclass_AE_S16X4_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4_I_args,
    1, Iclass_AE_S16X4_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4_IP_args,
    1, Iclass_AE_S16X4_IP_stateArgs, 0, 0 },
  { 2, Iclass_AE_S16X4_RIP_args,
    1, Iclass_AE_S16X4_RIP_stateArgs, 0, 0 },
  { 2, Iclass_AE_S16X4_RIC_args,
    3, Iclass_AE_S16X4_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4_X_args,
    1, Iclass_AE_S16X4_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4_XP_args,
    1, Iclass_AE_S16X4_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4RNG_I_args,
    2, Iclass_AE_S16X4RNG_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4RNG_IP_args,
    2, Iclass_AE_S16X4RNG_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4RNG_X_args,
    2, Iclass_AE_S16X4RNG_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S16X4RNG_XP_args,
    2, Iclass_AE_S16X4RNG_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_L_XC_args,
    3, Iclass_AE_S32_L_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_L_I_args,
    1, Iclass_AE_S32_L_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_L_IP_args,
    1, Iclass_AE_S32_L_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_L_X_args,
    1, Iclass_AE_S32_L_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_L_XP_args,
    1, Iclass_AE_S32_L_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_H_I_args,
    1, Iclass_AE_S32_H_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_H_IP_args,
    1, Iclass_AE_S32_H_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_H_X_args,
    1, Iclass_AE_S32_H_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32_H_XP_args,
    1, Iclass_AE_S32_H_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32M_XC_args,
    3, Iclass_AE_S32M_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32M_I_args,
    1, Iclass_AE_S32M_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32M_IU_args,
    1, Iclass_AE_S32M_IU_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32M_X_args,
    1, Iclass_AE_S32M_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32M_XU_args,
    1, Iclass_AE_S32M_XU_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2_XC_args,
    3, Iclass_AE_S32X2_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2_I_args,
    1, Iclass_AE_S32X2_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2_IP_args,
    1, Iclass_AE_S32X2_IP_stateArgs, 0, 0 },
  { 2, Iclass_AE_S32X2_RIP_args,
    1, Iclass_AE_S32X2_RIP_stateArgs, 0, 0 },
  { 2, Iclass_AE_S32X2_RIC_args,
    3, Iclass_AE_S32X2_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2_X_args,
    1, Iclass_AE_S32X2_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S32X2_XP_args,
    1, Iclass_AE_S32X2_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S64_XC_args,
    3, Iclass_AE_S64_XC_stateArgs, 0, 0 },
  { 3, Iclass_AE_S64_I_args,
    1, Iclass_AE_S64_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_S64_IP_args,
    1, Iclass_AE_S64_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_S64_X_args,
    1, Iclass_AE_S64_X_stateArgs, 0, 0 },
  { 3, Iclass_AE_S64_XP_args,
    1, Iclass_AE_S64_XP_stateArgs, 0, 0 },
  { 1, Iclass_AE_ZALIGN64_args,
    1, Iclass_AE_ZALIGN64_stateArgs, 0, 0 },
  { 3, Iclass_AE_LALIGN64_I_args,
    1, Iclass_AE_LALIGN64_I_stateArgs, 0, 0 },
  { 3, Iclass_AE_SALIGN64_I_args,
    1, Iclass_AE_SALIGN64_I_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVALIGN_args,
    1, Iclass_AE_MOVALIGN_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA64_PP_args,
    1, Iclass_AE_LA64_PP_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA32X2POS_PC_args,
    3, Iclass_AE_LA32X2POS_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA32X2NEG_PC_args,
    3, Iclass_AE_LA32X2NEG_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA16X4POS_PC_args,
    3, Iclass_AE_LA16X4POS_PC_stateArgs, 0, 0 },
  { 2, Iclass_AE_LA16X4NEG_PC_args,
    3, Iclass_AE_LA16X4NEG_PC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2_IC_args,
    3, Iclass_AE_LA32X2_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2_IP_args,
    1, Iclass_AE_LA32X2_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2_RIP_args,
    1, Iclass_AE_LA32X2_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA32X2_RIC_args,
    3, Iclass_AE_LA32X2_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA16X4_IC_args,
    3, Iclass_AE_LA16X4_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA16X4_IP_args,
    1, Iclass_AE_LA16X4_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA16X4_RIP_args,
    1, Iclass_AE_LA16X4_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA16X4_RIC_args,
    3, Iclass_AE_LA16X4_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA8X8_IP_args,
    1, Iclass_AE_LA8X8_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADDBRBA32_args,
    0, 0, 0, 0 },
  { 4, Iclass_AE_SEL16I_args,
    1, Iclass_AE_SEL16I_stateArgs, 0, 0 },
  { 2, Iclass_AE_SHORTSWAP_args,
    1, Iclass_AE_SHORTSWAP_stateArgs, 0, 0 },
  { 2, Iclass_AE_INTSWAP_args,
    1, Iclass_AE_INTSWAP_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVT16X4_args,
    1, Iclass_AE_MOVT16X4_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVF16X4_args,
    1, Iclass_AE_MOVF16X4_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVT32X2_args,
    1, Iclass_AE_MOVT32X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVF32X2_args,
    1, Iclass_AE_MOVF32X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVDA32X2_args,
    1, Iclass_AE_MOVDA32X2_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVDA32_args,
    1, Iclass_AE_MOVDA32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVDA16X2_args,
    1, Iclass_AE_MOVDA16X2_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVDA16_args,
    1, Iclass_AE_MOVDA16_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVI_args,
    1, Iclass_AE_MOVI_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVI16X4_args,
    1, Iclass_AE_MOVI16X4_stateArgs, 0, 0 },
  { 3, Iclass_AE_SAT16X4_args,
    2, Iclass_AE_SAT16X4_stateArgs, 0, 0 },
  { 2, Iclass_AE_SAT8S_args,
    2, Iclass_AE_SAT8S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SAT8U_args,
    2, Iclass_AE_SAT8U_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVT32X2F16_32_args,
    1, Iclass_AE_CVT32X2F16_32_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVT32X2F16_10_args,
    1, Iclass_AE_CVT32X2F16_10_stateArgs, 0, 0 },
  { 2, Iclass_AE_SEXT32X2D16_32_args,
    1, Iclass_AE_SEXT32X2D16_32_stateArgs, 0, 0 },
  { 2, Iclass_AE_SEXT32X2D16_10_args,
    1, Iclass_AE_SEXT32X2D16_10_stateArgs, 0, 0 },
  { 2, Iclass_AE_SEXT32X2D24_args,
    1, Iclass_AE_SEXT32X2D24_stateArgs, 0, 0 },
  { 2, Iclass_AE_SEXT64Q56_args,
    1, Iclass_AE_SEXT64Q56_stateArgs, 0, 0 },
  { 3, Iclass_AE_CVTP24A16X2_LL_args,
    1, Iclass_AE_CVTP24A16X2_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_CVTP24A16X2_LH_args,
    1, Iclass_AE_CVTP24A16X2_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_CVTP24A16X2_HL_args,
    1, Iclass_AE_CVTP24A16X2_HL_stateArgs, 0, 0 },
  { 3, Iclass_AE_CVTP24A16X2_HH_args,
    1, Iclass_AE_CVTP24A16X2_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_TRUNCP24Q48X2_args,
    1, Iclass_AE_TRUNCP24Q48X2_stateArgs, 0, 0 },
  { 4, Iclass_AE_TRUNCA32X2F64S_args,
    2, Iclass_AE_TRUNCA32X2F64S_stateArgs, 0, 0 },
  { 4, Iclass_AE_TRUNCI32X2F64S_args,
    2, Iclass_AE_TRUNCI32X2F64S_stateArgs, 0, 0 },
  { 4, Iclass_AE_TRUNCAV32X2F64S_args,
    2, Iclass_AE_TRUNCAV32X2F64S_stateArgs, 0, 0 },
  { 4, Iclass_AE_TRUNCI16X4F32S_args,
    2, Iclass_AE_TRUNCI16X4F32S_stateArgs, 0, 0 },
  { 4, Iclass_AE_TRUNCA32F64S_L_args,
    2, Iclass_AE_TRUNCA32F64S_L_stateArgs, 0, 0 },
  { 4, Iclass_AE_TRUNCI32F64S_L_args,
    2, Iclass_AE_TRUNCI32F64S_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_TRUNCP16_args,
    1, Iclass_AE_TRUNCP16_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND32X2F64SSYM_args,
    2, Iclass_AE_ROUND32X2F64SSYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND32X2F64SASYM_args,
    2, Iclass_AE_ROUND32X2F64SASYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND32X2F48SSYM_args,
    2, Iclass_AE_ROUND32X2F48SSYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND32X2F48SASYM_args,
    2, Iclass_AE_ROUND32X2F48SASYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND16X4F32SSYM_args,
    2, Iclass_AE_ROUND16X4F32SSYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND16X4F32SASYM_args,
    2, Iclass_AE_ROUND16X4F32SASYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND24X2F48SSYM_args,
    2, Iclass_AE_ROUND24X2F48SSYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUND24X2F48SASYM_args,
    2, Iclass_AE_ROUND24X2F48SASYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUNDSP16Q48X2SYM_args,
    2, Iclass_AE_ROUNDSP16Q48X2SYM_stateArgs, 0, 0 },
  { 3, Iclass_AE_ROUNDSP16Q48X2ASYM_args,
    2, Iclass_AE_ROUNDSP16Q48X2ASYM_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOV_args,
    1, Iclass_AE_MOV_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVT64_args,
    1, Iclass_AE_MOVT64_stateArgs, 0, 0 },
  { 3, Iclass_AE_MOVF64_args,
    1, Iclass_AE_MOVF64_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVT48A32_args,
    1, Iclass_AE_CVT48A32_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVT64A32_args,
    1, Iclass_AE_CVT64A32_stateArgs, 0, 0 },
  { 2, Iclass_AE_CVT64F32_H_args,
    1, Iclass_AE_CVT64F32_H_stateArgs, 0, 0 },
  { 2, Iclass_AE_SAT48S_args,
    2, Iclass_AE_SAT48S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SATQ56S_args,
    2, Iclass_AE_SATQ56S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SAT24S_args,
    2, Iclass_AE_SAT24S_stateArgs, 0, 0 },
  { 2, Iclass_AE_TRUNCQ32_args,
    1, Iclass_AE_TRUNCQ32_stateArgs, 0, 0 },
  { 2, Iclass_AE_ROUNDSQ32F48SYM_args,
    2, Iclass_AE_ROUNDSQ32F48SYM_stateArgs, 0, 0 },
  { 2, Iclass_AE_ROUNDSQ32F48ASYM_args,
    2, Iclass_AE_ROUNDSQ32F48ASYM_stateArgs, 0, 0 },
  { 2, Iclass_AE_TRUNCA32Q48_args,
    1, Iclass_AE_TRUNCA32Q48_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD32_L_args,
    1, Iclass_AE_MOVAD32_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD32_H_args,
    1, Iclass_AE_MOVAD32_H_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD16_3_args,
    1, Iclass_AE_MOVAD16_3_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD16_2_args,
    1, Iclass_AE_MOVAD16_2_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD16_1_args,
    1, Iclass_AE_MOVAD16_1_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVAD16_0_args,
    1, Iclass_AE_MOVAD16_0_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRA64_32_args,
    1, Iclass_AE_SRA64_32_stateArgs, 0, 0 },
  { 3, Iclass_AE_PKSR32_0_args,
    2, Iclass_AE_PKSR32_0_stateArgs, 0, 0 },
  { 3, Iclass_AE_PKSR24_0_args,
    2, Iclass_AE_PKSR24_0_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD32_args,
    1, Iclass_AE_ADD32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB32_args,
    1, Iclass_AE_SUB32_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADDSUB32_args,
    1, Iclass_AE_ADDSUB32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUBADD32_args,
    1, Iclass_AE_SUBADD32_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD16_args,
    1, Iclass_AE_ADD16_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB16_args,
    1, Iclass_AE_SUB16_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD32_HL_LH_args,
    1, Iclass_AE_ADD32_HL_LH_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG32_args,
    1, Iclass_AE_NEG32_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS32_args,
    1, Iclass_AE_ABS32_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD32S_args,
    2, Iclass_AE_ADD32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB32S_args,
    2, Iclass_AE_SUB32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADDSUB32S_args,
    2, Iclass_AE_ADDSUB32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUBADD32S_args,
    2, Iclass_AE_SUBADD32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD16S_args,
    2, Iclass_AE_ADD16S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB16S_args,
    2, Iclass_AE_SUB16S_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADDSUB32S_HL_LH_args,
    2, Iclass_AE_ADDSUB32S_HL_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUBADD32S_HL_LH_args,
    2, Iclass_AE_SUBADD32S_HL_LH_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG32S_args,
    1, Iclass_AE_NEG32S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS32S_args,
    1, Iclass_AE_ABS32S_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG16S_args,
    1, Iclass_AE_NEG16S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS16S_args,
    1, Iclass_AE_ABS16S_stateArgs, 0, 0 },
  { 2, Iclass_AE_CONJ16S_args,
    2, Iclass_AE_CONJ16S_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULC16JS_H_args,
    2, Iclass_AE_MULC16JS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULC16JS_L_args,
    2, Iclass_AE_MULC16JS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAC16JS_H_args,
    2, Iclass_AE_MULAC16JS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAC16JS_L_args,
    2, Iclass_AE_MULAC16JS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_LT16_args,
    1, Iclass_AE_LT16_stateArgs, 0, 0 },
  { 3, Iclass_AE_LE16_args,
    1, Iclass_AE_LE16_stateArgs, 0, 0 },
  { 3, Iclass_AE_EQ16_args,
    1, Iclass_AE_EQ16_stateArgs, 0, 0 },
  { 3, Iclass_AE_LT32_args,
    1, Iclass_AE_LT32_stateArgs, 0, 0 },
  { 3, Iclass_AE_LE32_args,
    1, Iclass_AE_LE32_stateArgs, 0, 0 },
  { 3, Iclass_AE_EQ32_args,
    1, Iclass_AE_EQ32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MIN32_args,
    1, Iclass_AE_MIN32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MAX32_args,
    1, Iclass_AE_MAX32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MIN16_args,
    1, Iclass_AE_MIN16_stateArgs, 0, 0 },
  { 3, Iclass_AE_MAX16_args,
    1, Iclass_AE_MAX16_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD64_args,
    1, Iclass_AE_ADD64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB64_args,
    1, Iclass_AE_SUB64_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG64_args,
    1, Iclass_AE_NEG64_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS64_args,
    1, Iclass_AE_ABS64_stateArgs, 0, 0 },
  { 3, Iclass_AE_ADD64S_args,
    2, Iclass_AE_ADD64S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SUB64S_args,
    2, Iclass_AE_SUB64S_stateArgs, 0, 0 },
  { 2, Iclass_AE_NEG64S_args,
    2, Iclass_AE_NEG64S_stateArgs, 0, 0 },
  { 2, Iclass_AE_ABS64S_args,
    2, Iclass_AE_ABS64S_stateArgs, 0, 0 },
  { 3, Iclass_AE_AND_args,
    1, Iclass_AE_AND_stateArgs, 0, 0 },
  { 3, Iclass_AE_NAND_args,
    1, Iclass_AE_NAND_stateArgs, 0, 0 },
  { 3, Iclass_AE_OR_args,
    1, Iclass_AE_OR_stateArgs, 0, 0 },
  { 3, Iclass_AE_XOR_args,
    1, Iclass_AE_XOR_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI16_args,
    1, Iclass_AE_SRAI16_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI16R_args,
    1, Iclass_AE_SRAI16R_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI32_args,
    1, Iclass_AE_SLAI32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRLI32_args,
    1, Iclass_AE_SRLI32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI32_args,
    1, Iclass_AE_SRAI32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI32R_args,
    1, Iclass_AE_SRAI32R_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLAS32_args,
    2, Iclass_AE_SLAS32_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRLS32_args,
    2, Iclass_AE_SRLS32_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRAS32_args,
    2, Iclass_AE_SRAS32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAA32_args,
    1, Iclass_AE_SLAA32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRLA32_args,
    1, Iclass_AE_SRLA32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA32_args,
    1, Iclass_AE_SRAA32_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI16S_args,
    2, Iclass_AE_SLAI16S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAA16S_args,
    2, Iclass_AE_SLAA16S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA16S_args,
    2, Iclass_AE_SRAA16S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA16RS_args,
    2, Iclass_AE_SRAA16RS_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI32S_args,
    2, Iclass_AE_SLAI32S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLAS32S_args,
    3, Iclass_AE_SLAS32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAA32S_args,
    2, Iclass_AE_SLAA32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA32S_args,
    2, Iclass_AE_SRAA32S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA32RS_args,
    2, Iclass_AE_SRAA32RS_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI64_args,
    1, Iclass_AE_SLAI64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRLI64_args,
    1, Iclass_AE_SRLI64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAI64_args,
    1, Iclass_AE_SRAI64_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLAS64_args,
    2, Iclass_AE_SLAS64_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRLS64_args,
    2, Iclass_AE_SRLS64_stateArgs, 0, 0 },
  { 2, Iclass_AE_SRAS64_args,
    2, Iclass_AE_SRAS64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAA64_args,
    1, Iclass_AE_SLAA64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRLA64_args,
    1, Iclass_AE_SRLA64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SRAA64_args,
    1, Iclass_AE_SRAA64_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAI64S_args,
    2, Iclass_AE_SLAI64S_stateArgs, 0, 0 },
  { 2, Iclass_AE_SLAS64S_args,
    3, Iclass_AE_SLAS64S_stateArgs, 0, 0 },
  { 3, Iclass_AE_SLAA64S_args,
    2, Iclass_AE_SLAA64S_stateArgs, 0, 0 },
  { 3, Iclass_AE_LT64_args,
    1, Iclass_AE_LT64_stateArgs, 0, 0 },
  { 3, Iclass_AE_LE64_args,
    1, Iclass_AE_LE64_stateArgs, 0, 0 },
  { 3, Iclass_AE_EQ64_args,
    1, Iclass_AE_EQ64_stateArgs, 0, 0 },
  { 3, Iclass_AE_MAX64_args,
    1, Iclass_AE_MAX64_stateArgs, 0, 0 },
  { 3, Iclass_AE_MIN64_args,
    1, Iclass_AE_MIN64_stateArgs, 0, 0 },
  { 2, Iclass_AE_NSA64_args,
    1, Iclass_AE_NSA64_stateArgs, 0, 0 },
  { 2, Iclass_AE_NSAZ16_0_args,
    1, Iclass_AE_NSAZ16_0_stateArgs, 0, 0 },
  { 2, Iclass_AE_NSAZ32_L_args,
    1, Iclass_AE_NSAZ32_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_NSA16_0_args,
    1, Iclass_AE_NSA16_0_stateArgs, 0, 0 },
  { 2, Iclass_AE_NSA32_L_args,
    1, Iclass_AE_NSA32_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32F48P16S_LL_args,
    2, Iclass_AE_MULS32F48P16S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32S_LL_args,
    2, Iclass_AE_MULF32S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32_LL_args,
    1, Iclass_AE_MUL32_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32R_LL_args,
    1, Iclass_AE_MULF32R_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32F48P16S_LH_args,
    2, Iclass_AE_MULS32F48P16S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32S_LH_args,
    2, Iclass_AE_MULF32S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32_LH_args,
    1, Iclass_AE_MUL32_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32R_LH_args,
    1, Iclass_AE_MULF32R_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32F48P16S_HH_args,
    2, Iclass_AE_MULS32F48P16S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32S_HH_args,
    2, Iclass_AE_MULF32S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32_HH_args,
    1, Iclass_AE_MUL32_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32R_HH_args,
    1, Iclass_AE_MULF32R_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAS32F48P16S_LL_args,
    2, Iclass_AE_MULAS32F48P16S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32S_LL_args,
    2, Iclass_AE_MULAF32S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32_LL_args,
    1, Iclass_AE_MULA32_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32R_LL_args,
    1, Iclass_AE_MULAF32R_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAS32F48P16S_LH_args,
    2, Iclass_AE_MULAS32F48P16S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32S_LH_args,
    2, Iclass_AE_MULAF32S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32_LH_args,
    1, Iclass_AE_MULA32_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32R_LH_args,
    1, Iclass_AE_MULAF32R_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAS32F48P16S_HH_args,
    2, Iclass_AE_MULAS32F48P16S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32S_HH_args,
    2, Iclass_AE_MULAF32S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32_HH_args,
    1, Iclass_AE_MULA32_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32R_HH_args,
    1, Iclass_AE_MULAF32R_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSS32F48P16S_LL_args,
    2, Iclass_AE_MULSS32F48P16S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32S_LL_args,
    2, Iclass_AE_MULSF32S_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32_LL_args,
    1, Iclass_AE_MULS32_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32R_LL_args,
    1, Iclass_AE_MULSF32R_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSS32F48P16S_LH_args,
    2, Iclass_AE_MULSS32F48P16S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32S_LH_args,
    2, Iclass_AE_MULSF32S_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32_LH_args,
    1, Iclass_AE_MULS32_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32R_LH_args,
    1, Iclass_AE_MULSF32R_LH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSS32F48P16S_HH_args,
    2, Iclass_AE_MULSS32F48P16S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32S_HH_args,
    2, Iclass_AE_MULSF32S_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32_HH_args,
    1, Iclass_AE_MULS32_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32R_HH_args,
    1, Iclass_AE_MULSF32R_HH_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32U_LL_args,
    1, Iclass_AE_MUL32U_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32U_LL_args,
    1, Iclass_AE_MULA32U_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32U_LL_args,
    1, Iclass_AE_MULS32U_LL_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_33_args,
    2, Iclass_AE_MULF16SS_33_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_22_args,
    2, Iclass_AE_MULF16SS_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_32_args,
    2, Iclass_AE_MULF16SS_32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_21_args,
    2, Iclass_AE_MULF16SS_21_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_31_args,
    2, Iclass_AE_MULF16SS_31_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_30_args,
    2, Iclass_AE_MULF16SS_30_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_10_args,
    2, Iclass_AE_MULF16SS_10_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_20_args,
    2, Iclass_AE_MULF16SS_20_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_11_args,
    2, Iclass_AE_MULF16SS_11_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16SS_00_args,
    2, Iclass_AE_MULF16SS_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_33_args,
    2, Iclass_AE_MULSF16SS_33_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_22_args,
    2, Iclass_AE_MULSF16SS_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_32_args,
    2, Iclass_AE_MULSF16SS_32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_21_args,
    2, Iclass_AE_MULSF16SS_21_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_31_args,
    2, Iclass_AE_MULSF16SS_31_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_30_args,
    2, Iclass_AE_MULSF16SS_30_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_10_args,
    2, Iclass_AE_MULSF16SS_10_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_20_args,
    2, Iclass_AE_MULSF16SS_20_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_11_args,
    2, Iclass_AE_MULSF16SS_11_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16SS_00_args,
    2, Iclass_AE_MULSF16SS_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_33_args,
    2, Iclass_AE_MULAF16SS_33_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_22_args,
    2, Iclass_AE_MULAF16SS_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_32_args,
    2, Iclass_AE_MULAF16SS_32_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_21_args,
    2, Iclass_AE_MULAF16SS_21_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_31_args,
    2, Iclass_AE_MULAF16SS_31_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_30_args,
    2, Iclass_AE_MULAF16SS_30_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_10_args,
    2, Iclass_AE_MULAF16SS_10_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_20_args,
    2, Iclass_AE_MULAF16SS_20_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_11_args,
    2, Iclass_AE_MULAF16SS_11_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16SS_00_args,
    2, Iclass_AE_MULAF16SS_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD16SS_33_22_args,
    2, Iclass_AE_MULAAFD16SS_33_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD16SS_13_02_args,
    2, Iclass_AE_MULAAFD16SS_13_02_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD16SS_11_00_args,
    2, Iclass_AE_MULAAFD16SS_11_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD16SS_33_22_args,
    2, Iclass_AE_MULSSFD16SS_33_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD16SS_13_02_args,
    2, Iclass_AE_MULSSFD16SS_13_02_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD16SS_11_00_args,
    2, Iclass_AE_MULSSFD16SS_11_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD16SS_33_22_args,
    2, Iclass_AE_MULZAAFD16SS_33_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD16SS_13_02_args,
    2, Iclass_AE_MULZAAFD16SS_13_02_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD16SS_11_00_args,
    2, Iclass_AE_MULZAAFD16SS_11_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD16SS_33_22_args,
    2, Iclass_AE_MULZSSFD16SS_33_22_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD16SS_13_02_args,
    2, Iclass_AE_MULZSSFD16SS_13_02_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD16SS_11_00_args,
    2, Iclass_AE_MULZSSFD16SS_11_00_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF48Q32SP16S_L_args,
    1, Iclass_AE_MULF48Q32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF48Q32SP16U_L_args,
    1, Iclass_AE_MULF48Q32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULQ32SP16S_L_args,
    1, Iclass_AE_MULQ32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULQ32SP16U_L_args,
    1, Iclass_AE_MULQ32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF48Q32SP16S_L_args,
    1, Iclass_AE_MULAF48Q32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF48Q32SP16U_L_args,
    1, Iclass_AE_MULAF48Q32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAQ32SP16S_L_args,
    1, Iclass_AE_MULAQ32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAQ32SP16U_L_args,
    1, Iclass_AE_MULAQ32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF48Q32SP16S_L_args,
    1, Iclass_AE_MULSF48Q32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF48Q32SP16U_L_args,
    1, Iclass_AE_MULSF48Q32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSQ32SP16S_L_args,
    1, Iclass_AE_MULSQ32SP16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSQ32SP16U_L_args,
    1, Iclass_AE_MULSQ32SP16U_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L0_args,
    1, Iclass_AE_MULF32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L0_args,
    1, Iclass_AE_MUL32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L1_args,
    1, Iclass_AE_MULF32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L1_args,
    1, Iclass_AE_MUL32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L2_args,
    1, Iclass_AE_MULF32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L2_args,
    1, Iclass_AE_MUL32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_L3_args,
    1, Iclass_AE_MULF32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_L3_args,
    1, Iclass_AE_MUL32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H0_args,
    1, Iclass_AE_MULF32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H0_args,
    1, Iclass_AE_MUL32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H1_args,
    1, Iclass_AE_MULF32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H1_args,
    1, Iclass_AE_MUL32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H2_args,
    1, Iclass_AE_MULF32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H2_args,
    1, Iclass_AE_MUL32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF32X16_H3_args,
    1, Iclass_AE_MULF32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL32X16_H3_args,
    1, Iclass_AE_MUL32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L0_args,
    1, Iclass_AE_MULAF32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L0_args,
    1, Iclass_AE_MULA32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L1_args,
    1, Iclass_AE_MULAF32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L1_args,
    1, Iclass_AE_MULA32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L2_args,
    1, Iclass_AE_MULAF32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L2_args,
    1, Iclass_AE_MULA32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_L3_args,
    1, Iclass_AE_MULAF32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_L3_args,
    1, Iclass_AE_MULA32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H0_args,
    1, Iclass_AE_MULAF32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H0_args,
    1, Iclass_AE_MULA32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H1_args,
    1, Iclass_AE_MULAF32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H1_args,
    1, Iclass_AE_MULA32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H2_args,
    1, Iclass_AE_MULAF32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H2_args,
    1, Iclass_AE_MULA32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF32X16_H3_args,
    1, Iclass_AE_MULAF32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA32X16_H3_args,
    1, Iclass_AE_MULA32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L0_args,
    1, Iclass_AE_MULSF32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L0_args,
    1, Iclass_AE_MULS32X16_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L1_args,
    1, Iclass_AE_MULSF32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L1_args,
    1, Iclass_AE_MULS32X16_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L2_args,
    1, Iclass_AE_MULSF32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L2_args,
    1, Iclass_AE_MULS32X16_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_L3_args,
    1, Iclass_AE_MULSF32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_L3_args,
    1, Iclass_AE_MULS32X16_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H0_args,
    1, Iclass_AE_MULSF32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H0_args,
    1, Iclass_AE_MULS32X16_H0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H1_args,
    1, Iclass_AE_MULSF32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H1_args,
    1, Iclass_AE_MULS32X16_H1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H2_args,
    1, Iclass_AE_MULSF32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H2_args,
    1, Iclass_AE_MULS32X16_H2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF32X16_H3_args,
    1, Iclass_AE_MULSF32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS32X16_H3_args,
    1, Iclass_AE_MULS32X16_H3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H3_L2_args,
    1, Iclass_AE_MULAAFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H3_L2_args,
    1, Iclass_AE_MULAAD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H1_L0_args,
    1, Iclass_AE_MULAAFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H1_L0_args,
    1, Iclass_AE_MULAAD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD32X16_H3_L2_args,
    1, Iclass_AE_MULASFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASD32X16_H3_L2_args,
    1, Iclass_AE_MULASD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASFD32X16_H1_L0_args,
    1, Iclass_AE_MULASFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULASD32X16_H1_L0_args,
    1, Iclass_AE_MULASD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAFD32X16_H3_L2_args,
    1, Iclass_AE_MULSAFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAD32X16_H3_L2_args,
    1, Iclass_AE_MULSAD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAFD32X16_H1_L0_args,
    1, Iclass_AE_MULSAFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSAD32X16_H1_L0_args,
    1, Iclass_AE_MULSAD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD32X16_H3_L2_args,
    1, Iclass_AE_MULSSFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSD32X16_H3_L2_args,
    1, Iclass_AE_MULSSD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSFD32X16_H1_L0_args,
    1, Iclass_AE_MULSSFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSSD32X16_H1_L0_args,
    1, Iclass_AE_MULSSD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H3_L2_args,
    1, Iclass_AE_MULZAAFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H3_L2_args,
    1, Iclass_AE_MULZAAD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H1_L0_args,
    1, Iclass_AE_MULZAAFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H1_L0_args,
    1, Iclass_AE_MULZAAD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD32X16_H3_L2_args,
    1, Iclass_AE_MULZASFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASD32X16_H3_L2_args,
    1, Iclass_AE_MULZASD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASFD32X16_H1_L0_args,
    1, Iclass_AE_MULZASFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZASD32X16_H1_L0_args,
    1, Iclass_AE_MULZASD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAFD32X16_H3_L2_args,
    1, Iclass_AE_MULZSAFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAD32X16_H3_L2_args,
    1, Iclass_AE_MULZSAD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAFD32X16_H1_L0_args,
    1, Iclass_AE_MULZSAFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSAD32X16_H1_L0_args,
    1, Iclass_AE_MULZSAD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD32X16_H3_L2_args,
    1, Iclass_AE_MULZSSFD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSD32X16_H3_L2_args,
    1, Iclass_AE_MULZSSD32X16_H3_L2_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSFD32X16_H1_L0_args,
    1, Iclass_AE_MULZSSFD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZSSD32X16_H1_L0_args,
    1, Iclass_AE_MULZSSD32X16_H1_L0_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H2_L3_args,
    1, Iclass_AE_MULZAAFD32X16_H2_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAFD32X16_H0_L1_args,
    1, Iclass_AE_MULZAAFD32X16_H0_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H2_L3_args,
    1, Iclass_AE_MULAAFD32X16_H2_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAFD32X16_H0_L1_args,
    1, Iclass_AE_MULAAFD32X16_H0_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H2_L3_args,
    1, Iclass_AE_MULZAAD32X16_H2_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAD32X16_H0_L1_args,
    1, Iclass_AE_MULZAAD32X16_H0_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H2_L3_args,
    1, Iclass_AE_MULAAD32X16_H2_L3_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAD32X16_H0_L1_args,
    1, Iclass_AE_MULAAD32X16_H0_L1_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULP32X16X2_H_args,
    1, Iclass_AE_MULP32X16X2_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2S_H_args,
    2, Iclass_AE_MULFP32X16X2S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RS_H_args,
    2, Iclass_AE_MULFP32X16X2RS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RAS_H_args,
    2, Iclass_AE_MULFP32X16X2RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULP32X16X2_L_args,
    1, Iclass_AE_MULP32X16X2_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2S_L_args,
    2, Iclass_AE_MULFP32X16X2S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RS_L_args,
    2, Iclass_AE_MULFP32X16X2RS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X16X2RAS_L_args,
    2, Iclass_AE_MULFP32X16X2RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAP32X16X2_H_args,
    1, Iclass_AE_MULAP32X16X2_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2S_H_args,
    2, Iclass_AE_MULAFP32X16X2S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RS_H_args,
    2, Iclass_AE_MULAFP32X16X2RS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RAS_H_args,
    2, Iclass_AE_MULAFP32X16X2RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAP32X16X2_L_args,
    1, Iclass_AE_MULAP32X16X2_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2S_L_args,
    2, Iclass_AE_MULAFP32X16X2S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RS_L_args,
    2, Iclass_AE_MULAFP32X16X2RS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X16X2RAS_L_args,
    2, Iclass_AE_MULAFP32X16X2RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSP32X16X2_H_args,
    1, Iclass_AE_MULSP32X16X2_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2S_H_args,
    2, Iclass_AE_MULSFP32X16X2S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RS_H_args,
    2, Iclass_AE_MULSFP32X16X2RS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RAS_H_args,
    2, Iclass_AE_MULSFP32X16X2RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSP32X16X2_L_args,
    1, Iclass_AE_MULSP32X16X2_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2S_L_args,
    2, Iclass_AE_MULSFP32X16X2S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RS_L_args,
    2, Iclass_AE_MULSFP32X16X2RS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X16X2RAS_L_args,
    2, Iclass_AE_MULSFP32X16X2RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFCR32X16RAS_L_args,
    2, Iclass_AE_MULFCR32X16RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFCR32X16RAS_H_args,
    2, Iclass_AE_MULFCR32X16RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFCI32X16RAS_L_args,
    2, Iclass_AE_MULFCI32X16RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFCI32X16RAS_H_args,
    2, Iclass_AE_MULFCI32X16RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFCR32X16S_L_args,
    2, Iclass_AE_MULFCR32X16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFCR32X16S_H_args,
    2, Iclass_AE_MULFCR32X16S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFCI32X16S_L_args,
    2, Iclass_AE_MULFCI32X16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFCI32X16S_H_args,
    2, Iclass_AE_MULFCI32X16S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFCR32X16RAS_L_args,
    2, Iclass_AE_MULAFCR32X16RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFCR32X16RAS_H_args,
    2, Iclass_AE_MULAFCR32X16RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFCI32X16RAS_L_args,
    2, Iclass_AE_MULAFCI32X16RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFCI32X16RAS_H_args,
    2, Iclass_AE_MULAFCI32X16RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFCR32X16S_L_args,
    2, Iclass_AE_MULAFCR32X16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFCR32X16S_H_args,
    2, Iclass_AE_MULAFCR32X16S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFCI32X16S_L_args,
    2, Iclass_AE_MULAFCI32X16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFCI32X16S_H_args,
    2, Iclass_AE_MULAFCI32X16S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULP32X2_H_args,
    1, Iclass_AE_MULP32X2_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAP32X2_H_args,
    1, Iclass_AE_MULAP32X2_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSP32X2_H_args,
    1, Iclass_AE_MULSP32X2_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULP32X2_L_args,
    1, Iclass_AE_MULP32X2_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAP32X2_L_args,
    1, Iclass_AE_MULAP32X2_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSP32X2_L_args,
    1, Iclass_AE_MULSP32X2_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X2RS_H_args,
    2, Iclass_AE_MULFP32X2RS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X2RAS_H_args,
    2, Iclass_AE_MULFP32X2RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X2RS_H_args,
    2, Iclass_AE_MULAFP32X2RS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X2RAS_H_args,
    2, Iclass_AE_MULAFP32X2RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X2RS_H_args,
    2, Iclass_AE_MULSFP32X2RS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X2RAS_H_args,
    2, Iclass_AE_MULSFP32X2RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X2RS_L_args,
    2, Iclass_AE_MULFP32X2RS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP32X2RAS_L_args,
    2, Iclass_AE_MULFP32X2RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X2RS_L_args,
    2, Iclass_AE_MULAFP32X2RS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFP32X2RAS_L_args,
    2, Iclass_AE_MULAFP32X2RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X2RS_L_args,
    2, Iclass_AE_MULSFP32X2RS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSFP32X2RAS_L_args,
    2, Iclass_AE_MULSFP32X2RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP16X4S_H_args,
    2, Iclass_AE_MULFP16X4S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP16X4RAS_H_args,
    2, Iclass_AE_MULFP16X4RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP16X4S_L_args,
    2, Iclass_AE_MULFP16X4S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFP16X4RAS_L_args,
    2, Iclass_AE_MULFP16X4RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULCR32X16_L_args,
    1, Iclass_AE_MULCR32X16_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULCR32X16_H_args,
    1, Iclass_AE_MULCR32X16_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULCI32X16_L_args,
    1, Iclass_AE_MULCI32X16_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULCI32X16_H_args,
    1, Iclass_AE_MULCI32X16_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULACR32X16_L_args,
    1, Iclass_AE_MULACR32X16_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULACR32X16_H_args,
    1, Iclass_AE_MULACR32X16_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULACI32X16_L_args,
    1, Iclass_AE_MULACI32X16_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULACI32X16_H_args,
    1, Iclass_AE_MULACI32X16_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16X4SS_H_args,
    2, Iclass_AE_MULF16X4SS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16X4SS_H_args,
    2, Iclass_AE_MULAF16X4SS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16X4SS_H_args,
    2, Iclass_AE_MULSF16X4SS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULF16X4SS_L_args,
    2, Iclass_AE_MULF16X4SS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAF16X4SS_L_args,
    2, Iclass_AE_MULAF16X4SS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULSF16X4SS_L_args,
    2, Iclass_AE_MULSF16X4SS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL16X4_H_args,
    1, Iclass_AE_MUL16X4_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA16X4_H_args,
    1, Iclass_AE_MULA16X4_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS16X4_H_args,
    1, Iclass_AE_MULS16X4_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA16X4S_H_args,
    2, Iclass_AE_MULA16X4S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS16X4S_H_args,
    2, Iclass_AE_MULS16X4S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MUL16X4_L_args,
    1, Iclass_AE_MUL16X4_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA16X4_L_args,
    1, Iclass_AE_MULA16X4_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS16X4_L_args,
    1, Iclass_AE_MULS16X4_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULA16X4S_L_args,
    2, Iclass_AE_MULA16X4S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULS16X4S_L_args,
    2, Iclass_AE_MULS16X4S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULC16S_H_args,
    2, Iclass_AE_MULC16S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULC16S_L_args,
    2, Iclass_AE_MULC16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAC16S_H_args,
    2, Iclass_AE_MULAC16S_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAC16S_L_args,
    2, Iclass_AE_MULAC16S_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFC16RAS_H_args,
    2, Iclass_AE_MULFC16RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULFC16RAS_L_args,
    2, Iclass_AE_MULFC16RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFC16RAS_H_args,
    2, Iclass_AE_MULAFC16RAS_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAFC16RAS_L_args,
    2, Iclass_AE_MULAFC16RAS_L_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULZAAAAQ16_args,
    1, Iclass_AE_MULZAAAAQ16_stateArgs, 0, 0 },
  { 3, Iclass_AE_MULAAAAQ16_args,
    1, Iclass_AE_MULAAAAQ16_stateArgs, 0, 0 },
  { 2, Iclass_AE_MUL16JS_args,
    1, Iclass_AE_MUL16JS_stateArgs, 0, 0 },
  { 1, Iclass_AE_CALCRNG3_args,
    2, Iclass_AE_CALCRNG3_stateArgs, 0, 0 },
  { 2, Iclass_AE_ADDANDSUBRNG16RAS_S1_args,
    3, Iclass_AE_ADDANDSUBRNG16RAS_S1_stateArgs, 0, 0 },
  { 2, Iclass_AE_ADDANDSUBRNG16RAS_S2_args,
    3, Iclass_AE_ADDANDSUBRNG16RAS_S2_stateArgs, 0, 0 },
  { 2, Iclass_AE_DIV64D32_H_args,
    1, Iclass_AE_DIV64D32_H_stateArgs, 0, 0 },
  { 2, Iclass_AE_DIV64D32_L_args,
    1, Iclass_AE_DIV64D32_L_stateArgs, 0, 0 },
  { 2, Iclass_AE_SHA32_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_VLDL32T_args,
    5, Iclass_AE_VLDL32T_stateArgs, 0, 0 },
  { 3, Iclass_AE_VLDL16T_args,
    5, Iclass_AE_VLDL16T_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLDL16C_args,
    8, Iclass_AE_VLDL16C_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLDL16C_IP_args,
    8, Iclass_AE_VLDL16C_IP_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLDL16C_IC_args,
    11, Iclass_AE_VLDL16C_IC_stateArgs, 0, 0 },
  { 1, Iclass_AE_VLDSHT_args,
    6, Iclass_AE_VLDSHT_stateArgs, 0, 0 },
  { 2, Iclass_AE_LB_args,
    3, Iclass_AE_LB_stateArgs, 0, 0 },
  { 2, Iclass_AE_LBI_args,
    3, Iclass_AE_LBI_stateArgs, 0, 0 },
  { 3, Iclass_AE_LBK_args,
    3, Iclass_AE_LBK_stateArgs, 0, 0 },
  { 3, Iclass_AE_LBKI_args,
    3, Iclass_AE_LBKI_stateArgs, 0, 0 },
  { 2, Iclass_AE_LBS_args,
    3, Iclass_AE_LBS_stateArgs, 0, 0 },
  { 2, Iclass_AE_LBSI_args,
    3, Iclass_AE_LBSI_stateArgs, 0, 0 },
  { 3, Iclass_AE_LBIT_args,
    3, Iclass_AE_LBIT_stateArgs, 0, 0 },
  { 2, Iclass_AE_DB_args,
    3, Iclass_AE_DB_stateArgs, 0, 0 },
  { 2, Iclass_AE_DBI_args,
    3, Iclass_AE_DBI_stateArgs, 0, 0 },
  { 3, Iclass_AE_DBIT_args,
    3, Iclass_AE_DBIT_stateArgs, 0, 0 },
  { 2, Iclass_AE_DB_IC_args,
    6, Iclass_AE_DB_IC_stateArgs, 0, 0 },
  { 2, Iclass_AE_DBI_IC_args,
    6, Iclass_AE_DBI_IC_stateArgs, 0, 0 },
  { 2, Iclass_AE_DB_IP_args,
    3, Iclass_AE_DB_IP_stateArgs, 0, 0 },
  { 2, Iclass_AE_DBI_IP_args,
    3, Iclass_AE_DBI_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LBI_DBI_IC_args,
    6, Iclass_AE_LBI_DBI_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_LBI_DBI_IP_args,
    3, Iclass_AE_LBI_DBI_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LBI_DBI_args,
    3, Iclass_AE_LBI_DBI_stateArgs, 0, 0 },
  { 2, Iclass_AE_SB_args,
    4, Iclass_AE_SB_stateArgs, 0, 0 },
  { 3, Iclass_AE_SBI_args,
    3, Iclass_AE_SBI_stateArgs, 0, 0 },
  { 1, Iclass_AE_SBF_args,
    3, Iclass_AE_SBF_stateArgs, 0, 0 },
  { 4, Iclass_AE_SBIT_args,
    3, Iclass_AE_SBIT_stateArgs, 0, 0 },
  { 2, Iclass_AE_SB_IC_args,
    7, Iclass_AE_SB_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SBI_IC_args,
    6, Iclass_AE_SBI_IC_stateArgs, 0, 0 },
  { 1, Iclass_AE_SBF_IC_args,
    6, Iclass_AE_SBF_IC_stateArgs, 0, 0 },
  { 2, Iclass_AE_SB_IP_args,
    4, Iclass_AE_SB_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SBI_IP_args,
    3, Iclass_AE_SBI_IP_stateArgs, 0, 0 },
  { 1, Iclass_AE_SBF_IP_args,
    3, Iclass_AE_SBF_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_L16SI_N_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_L16UI_N_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_S16I_N_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_SEXT16_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_ZEXT16_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_ZEXT8_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_CLAMPS16_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_ZEROB_args,
    1, Iclass_AE_ZEROB_stateArgs, 0, 0 },
  { 3, Iclass_AE_ZEROC16X4_args,
    1, Iclass_AE_ZEROC16X4_stateArgs, 0, 0 },
  { 3, Iclass_AE_ZEROC32X2_args,
    1, Iclass_AE_ZEROC32X2_stateArgs, 0, 0 },
  { 3, Iclass_AE_SEXT32_args,
    1, Iclass_AE_SEXT32_stateArgs, 0, 0 },
  { 2, Iclass_AE_MOVBA1_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_MOVAB1_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_MOVBA2_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_MOVAB2_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_MOVBA4_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_MOVAB4_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_MOVBA8_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_MOVAB8_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_MB_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_JOINB_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_EXTRACTBI_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_RANDB4_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_RANDB8_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_RORB4_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_RORB8_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_ANDB8_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_ORB8_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_XORB8_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_ANDNOTB8_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_ORNOTB8_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_NOTB8_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_LTR4_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_EXTRACTBL_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_EXTRACTBH_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_BITREV8_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_POPC2B_args,
    0, 0, 0, 0 },
  { 2, Iclass_AE_POPCB8_args,
    0, 0, 0, 0 },
  { 3, Iclass_AE_MOVSQZ16X4_args,
    1, Iclass_AE_MOVSQZ16X4_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA8X4S_IP_args,
    1, Iclass_AE_LA8X4S_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_LA8X4U_IP_args,
    1, Iclass_AE_LA8X4U_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2_IC_args,
    3, Iclass_AE_SA32X2_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2_IP_args,
    1, Iclass_AE_SA32X2_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2_RIP_args,
    1, Iclass_AE_SA32X2_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA32X2_RIC_args,
    3, Iclass_AE_SA32X2_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA16X4_IC_args,
    3, Iclass_AE_SA16X4_IC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA16X4_IP_args,
    1, Iclass_AE_SA16X4_IP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA16X4_RIP_args,
    1, Iclass_AE_SA16X4_RIP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA16X4_RIC_args,
    3, Iclass_AE_SA16X4_RIC_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA8X4U_IP_args,
    1, Iclass_AE_SA8X4U_IP_stateArgs, 0, 0 },
  { 4, Iclass_AE_SAV16X4_XP_args,
    1, Iclass_AE_SAV16X4_XP_stateArgs, 0, 0 },
  { 2, Iclass_AE_SA64POS_FP_args,
    1, Iclass_AE_SA64POS_FP_stateArgs, 0, 0 },
  { 2, Iclass_AE_SA64NEG_FP_args,
    1, Iclass_AE_SA64NEG_FP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SA8X8_IP_args,
    1, Iclass_AE_SA8X8_IP_stateArgs, 0, 0 },
  { 4, Iclass_AE_SAV8X8_XP_args,
    1, Iclass_AE_SAV8X8_XP_stateArgs, 0, 0 },
  { 4, Iclass_AE_LAV8X8_XP_args,
    1, Iclass_AE_LAV8X8_XP_stateArgs, 0, 0 },
  { 4, Iclass_AE_LAV16X4_XP_args,
    1, Iclass_AE_LAV16X4_XP_stateArgs, 0, 0 },
  { 4, Iclass_AE_LAV8X4S_XP_args,
    1, Iclass_AE_LAV8X4S_XP_stateArgs, 0, 0 },
  { 4, Iclass_AE_LAV8X4U_XP_args,
    1, Iclass_AE_LAV8X4U_XP_stateArgs, 0, 0 },
  { 4, Iclass_AE_SAV8X4U_XP_args,
    1, Iclass_AE_SAV8X4U_XP_stateArgs, 0, 0 },
  { 3, Iclass_AE_SATU16X4_args,
    2, Iclass_AE_SATU16X4_stateArgs, 0, 0 },
  { 3, Iclass_AE_SAT8X4X32_H_args,
    2, Iclass_AE_SAT8X4X32_H_stateArgs, 0, 0 },
  { 3, Iclass_AE_SATU8X4X32_H_args,
    2, Iclass_AE_SATU8X4X32_H_stateArgs, 0, 0 },
  { 1, Iclass_RUR_FCR_args,
    3, Iclass_RUR_FCR_stateArgs, 0, 0 },
  { 1, Iclass_WUR_FCR_args,
    3, Iclass_WUR_FCR_stateArgs, 0, 0 },
  { 1, Iclass_RUR_FSR_args,
    2, Iclass_RUR_FSR_stateArgs, 0, 0 },
  { 1, Iclass_WUR_FSR_args,
    2, Iclass_WUR_FSR_stateArgs, 0, 0 },
  { 2, Iclass_RFR_args,
    1, Iclass_RFR_stateArgs, 0, 0 },
  { 2, Iclass_WFR_args,
    1, Iclass_WFR_stateArgs, 0, 0 },
  { 3, Iclass_MOVT_S_args,
    1, Iclass_MOVT_S_stateArgs, 0, 0 },
  { 3, Iclass_MOVF_S_args,
    1, Iclass_MOVF_S_stateArgs, 0, 0 },
  { 3, Iclass_MOVEQZ_S_args,
    1, Iclass_MOVEQZ_S_stateArgs, 0, 0 },
  { 3, Iclass_MOVNEZ_S_args,
    1, Iclass_MOVNEZ_S_stateArgs, 0, 0 },
  { 3, Iclass_MOVGEZ_S_args,
    1, Iclass_MOVGEZ_S_stateArgs, 0, 0 },
  { 3, Iclass_MOVLTZ_S_args,
    1, Iclass_MOVLTZ_S_stateArgs, 0, 0 },
  { 3, Iclass_ADD_S_args,
    3, Iclass_ADD_S_stateArgs, 0, 0 },
  { 3, Iclass_SUB_S_args,
    3, Iclass_SUB_S_stateArgs, 0, 0 },
  { 3, Iclass_MUL_S_args,
    3, Iclass_MUL_S_stateArgs, 0, 0 },
  { 3, Iclass_MADD_S_args,
    3, Iclass_MADD_S_stateArgs, 0, 0 },
  { 3, Iclass_MADDN_S_args,
    1, Iclass_MADDN_S_stateArgs, 0, 0 },
  { 3, Iclass_MSUB_S_args,
    3, Iclass_MSUB_S_stateArgs, 0, 0 },
  { 3, Iclass_MSUBN_S_args,
    1, Iclass_MSUBN_S_stateArgs, 0, 0 },
  { 3, Iclass_DIVN_S_args,
    3, Iclass_DIVN_S_stateArgs, 0, 0 },
  { 2, Iclass_ABS_S_args,
    1, Iclass_ABS_S_stateArgs, 0, 0 },
  { 2, Iclass_NEG_S_args,
    1, Iclass_NEG_S_stateArgs, 0, 0 },
  { 2, Iclass_CONJC_S_args,
    1, Iclass_CONJC_S_stateArgs, 0, 0 },
  { 2, Iclass_CONST_S_args,
    1, Iclass_CONST_S_stateArgs, 0, 0 },
  { 3, Iclass_MAX_S_args,
    2, Iclass_MAX_S_stateArgs, 0, 0 },
  { 3, Iclass_MIN_S_args,
    2, Iclass_MIN_S_stateArgs, 0, 0 },
  { 3, Iclass_MINNUM_S_args,
    2, Iclass_MINNUM_S_stateArgs, 0, 0 },
  { 3, Iclass_MAXNUM_S_args,
    2, Iclass_MAXNUM_S_stateArgs, 0, 0 },
  { 3, Iclass_OLE_S_args,
    2, Iclass_OLE_S_stateArgs, 0, 0 },
  { 3, Iclass_OLT_S_args,
    2, Iclass_OLT_S_stateArgs, 0, 0 },
  { 3, Iclass_OEQ_S_args,
    2, Iclass_OEQ_S_stateArgs, 0, 0 },
  { 3, Iclass_UN_S_args,
    2, Iclass_UN_S_stateArgs, 0, 0 },
  { 3, Iclass_ULE_S_args,
    2, Iclass_ULE_S_stateArgs, 0, 0 },
  { 3, Iclass_ULT_S_args,
    2, Iclass_ULT_S_stateArgs, 0, 0 },
  { 3, Iclass_UEQ_S_args,
    2, Iclass_UEQ_S_stateArgs, 0, 0 },
  { 2, Iclass_ADDEXP_S_args,
    1, Iclass_ADDEXP_S_stateArgs, 0, 0 },
  { 2, Iclass_ADDEXPM_S_args,
    1, Iclass_ADDEXPM_S_stateArgs, 0, 0 },
  { 2, Iclass_MKSADJ_S_args,
    2, Iclass_MKSADJ_S_stateArgs, 0, 0 },
  { 2, Iclass_MKDADJ_S_args,
    2, Iclass_MKDADJ_S_stateArgs, 0, 0 },
  { 2, Iclass_NEXP01_S_args,
    1, Iclass_NEXP01_S_stateArgs, 0, 0 },
  { 2, Iclass_DIV0_S_args,
    1, Iclass_DIV0_S_stateArgs, 0, 0 },
  { 2, Iclass_SQRT0_S_args,
    1, Iclass_SQRT0_S_stateArgs, 0, 0 },
  { 2, Iclass_RECIP0_S_args,
    2, Iclass_RECIP0_S_stateArgs, 0, 0 },
  { 2, Iclass_RSQRT0_S_args,
    2, Iclass_RSQRT0_S_stateArgs, 0, 0 },
  { 3, Iclass_TRUNC_S_args,
    2, Iclass_TRUNC_S_stateArgs, 0, 0 },
  { 3, Iclass_UTRUNC_S_args,
    2, Iclass_UTRUNC_S_stateArgs, 0, 0 },
  { 3, Iclass_TRUNC_SX2_args,
    2, Iclass_TRUNC_SX2_stateArgs, 0, 0 },
  { 3, Iclass_UTRUNC_SX2_args,
    2, Iclass_UTRUNC_SX2_stateArgs, 0, 0 },
  { 2, Iclass_FICEIL_S_args,
    2, Iclass_FICEIL_S_stateArgs, 0, 0 },
  { 2, Iclass_FIFLOOR_S_args,
    2, Iclass_FIFLOOR_S_stateArgs, 0, 0 },
  { 2, Iclass_FIRINT_S_args,
    3, Iclass_FIRINT_S_stateArgs, 0, 0 },
  { 2, Iclass_FIROUND_S_args,
    2, Iclass_FIROUND_S_stateArgs, 0, 0 },
  { 2, Iclass_FITRUNC_S_args,
    2, Iclass_FITRUNC_S_stateArgs, 0, 0 },
  { 3, Iclass_FLOAT_S_args,
    3, Iclass_FLOAT_S_stateArgs, 0, 0 },
  { 3, Iclass_UFLOAT_S_args,
    3, Iclass_UFLOAT_S_stateArgs, 0, 0 },
  { 3, Iclass_FLOAT_SX2_args,
    3, Iclass_FLOAT_SX2_stateArgs, 0, 0 },
  { 3, Iclass_UFLOAT_SX2_args,
    3, Iclass_UFLOAT_SX2_stateArgs, 0, 0 },
  { 2, Iclass_MULJC_S_args,
    1, Iclass_MULJC_S_stateArgs, 0, 0 },
  { 2, Iclass_CLSFY_S_args,
    1, Iclass_CLSFY_S_stateArgs, 0, 0 },
  { 2, Iclass_CVTSF16_L_args,
    2, Iclass_CVTSF16_L_stateArgs, 0, 0 },
  { 2, Iclass_CVTF16S_L_args,
    3, Iclass_CVTF16S_L_stateArgs, 0, 0 },
  { 4, Iclass_MULMUX_S_args,
    3, Iclass_MULMUX_S_stateArgs, 0, 0 },
  { 4, Iclass_MADDMUX_S_args,
    3, Iclass_MADDMUX_S_stateArgs, 0, 0 },
  { 1, Iclass_AE_MOVFCRFSRV_args,
    4, Iclass_AE_MOVFCRFSRV_stateArgs, 0, 0 },
  { 1, Iclass_AE_MOVVFCRFSR_args,
    4, Iclass_AE_MOVVFCRFSR_stateArgs, 0, 0 }
};

enum xtensa_iclass_id {
  ICLASS_xt_iclass_excw,
  ICLASS_xt_iclass_rfe,
  ICLASS_xt_iclass_rfde,
  ICLASS_xt_iclass_syscall,
  ICLASS_xt_iclass_call12,
  ICLASS_xt_iclass_call8,
  ICLASS_xt_iclass_call4,
  ICLASS_xt_iclass_callx12,
  ICLASS_xt_iclass_callx8,
  ICLASS_xt_iclass_callx4,
  ICLASS_xt_iclass_entry,
  ICLASS_xt_iclass_movsp,
  ICLASS_xt_iclass_rotw,
  ICLASS_xt_iclass_retw,
  ICLASS_xt_iclass_rfwou,
  ICLASS_xt_iclass_l32e,
  ICLASS_xt_iclass_s32e,
  ICLASS_xt_iclass_rsr_windowbase,
  ICLASS_xt_iclass_wsr_windowbase,
  ICLASS_xt_iclass_xsr_windowbase,
  ICLASS_xt_iclass_rsr_windowstart,
  ICLASS_xt_iclass_wsr_windowstart,
  ICLASS_xt_iclass_xsr_windowstart,
  ICLASS_xt_iclass_add_n,
  ICLASS_xt_iclass_addi_n,
  ICLASS_xt_iclass_bz6,
  ICLASS_xt_iclass_ill_n,
  ICLASS_xt_iclass_loadi4,
  ICLASS_xt_iclass_mov_n,
  ICLASS_xt_iclass_movi_n,
  ICLASS_xt_iclass_nopn,
  ICLASS_xt_iclass_retn,
  ICLASS_xt_iclass_storei4,
  ICLASS_rur_threadptr,
  ICLASS_wur_threadptr,
  ICLASS_xt_iclass_addi,
  ICLASS_xt_iclass_addmi,
  ICLASS_xt_iclass_addsub,
  ICLASS_xt_iclass_bit,
  ICLASS_xt_iclass_bsi8,
  ICLASS_xt_iclass_bsi8b,
  ICLASS_xt_iclass_bsi8u,
  ICLASS_xt_iclass_bst8,
  ICLASS_xt_iclass_bsz12,
  ICLASS_xt_iclass_call0,
  ICLASS_xt_iclass_callx0,
  ICLASS_xt_iclass_exti,
  ICLASS_xt_iclass_ill,
  ICLASS_xt_iclass_jump,
  ICLASS_xt_iclass_jumpx,
  ICLASS_xt_iclass_l16ui,
  ICLASS_xt_iclass_l16si,
  ICLASS_xt_iclass_l32i,
  ICLASS_xt_iclass_l32r,
  ICLASS_xt_iclass_l8i,
  ICLASS_xt_iclass_loop,
  ICLASS_xt_iclass_loopz,
  ICLASS_xt_iclass_movi,
  ICLASS_xt_iclass_movz,
  ICLASS_xt_iclass_neg,
  ICLASS_xt_iclass_nop,
  ICLASS_xt_iclass_depbits,
  ICLASS_xt_iclass_return,
  ICLASS_xt_iclass_simcall,
  ICLASS_xt_iclass_s16i,
  ICLASS_xt_iclass_s32i,
  ICLASS_xt_iclass_s32nb,
  ICLASS_xt_iclass_s8i,
  ICLASS_xt_iclass_sar,
  ICLASS_xt_iclass_sari,
  ICLASS_xt_iclass_shifts,
  ICLASS_xt_iclass_shiftst,
  ICLASS_xt_iclass_shiftt,
  ICLASS_xt_iclass_slli,
  ICLASS_xt_iclass_srai,
  ICLASS_xt_iclass_srli,
  ICLASS_xt_iclass_memw,
  ICLASS_xt_iclass_extw,
  ICLASS_xt_iclass_isync,
  ICLASS_xt_iclass_sync,
  ICLASS_xt_iclass_rsil,
  ICLASS_xt_iclass_rsr_lend,
  ICLASS_xt_iclass_wsr_lend,
  ICLASS_xt_iclass_xsr_lend,
  ICLASS_xt_iclass_rsr_lcount,
  ICLASS_xt_iclass_wsr_lcount,
  ICLASS_xt_iclass_xsr_lcount,
  ICLASS_xt_iclass_rsr_lbeg,
  ICLASS_xt_iclass_wsr_lbeg,
  ICLASS_xt_iclass_xsr_lbeg,
  ICLASS_xt_iclass_rsr_sar,
  ICLASS_xt_iclass_wsr_sar,
  ICLASS_xt_iclass_xsr_sar,
  ICLASS_xt_iclass_rsr_memctl,
  ICLASS_xt_iclass_wsr_memctl,
  ICLASS_xt_iclass_xsr_memctl,
  ICLASS_xt_iclass_rsr_configid0,
  ICLASS_xt_iclass_wsr_configid0,
  ICLASS_xt_iclass_rsr_configid1,
  ICLASS_xt_iclass_rsr_243,
  ICLASS_xt_iclass_rsr_ps,
  ICLASS_xt_iclass_wsr_ps,
  ICLASS_xt_iclass_xsr_ps,
  ICLASS_xt_iclass_rsr_epc1,
  ICLASS_xt_iclass_wsr_epc1,
  ICLASS_xt_iclass_xsr_epc1,
  ICLASS_xt_iclass_rsr_excsave1,
  ICLASS_xt_iclass_wsr_excsave1,
  ICLASS_xt_iclass_xsr_excsave1,
  ICLASS_xt_iclass_rsr_epc2,
  ICLASS_xt_iclass_wsr_epc2,
  ICLASS_xt_iclass_xsr_epc2,
  ICLASS_xt_iclass_rsr_excsave2,
  ICLASS_xt_iclass_wsr_excsave2,
  ICLASS_xt_iclass_xsr_excsave2,
  ICLASS_xt_iclass_rsr_epc3,
  ICLASS_xt_iclass_wsr_epc3,
  ICLASS_xt_iclass_xsr_epc3,
  ICLASS_xt_iclass_rsr_excsave3,
  ICLASS_xt_iclass_wsr_excsave3,
  ICLASS_xt_iclass_xsr_excsave3,
  ICLASS_xt_iclass_rsr_epc4,
  ICLASS_xt_iclass_wsr_epc4,
  ICLASS_xt_iclass_xsr_epc4,
  ICLASS_xt_iclass_rsr_excsave4,
  ICLASS_xt_iclass_wsr_excsave4,
  ICLASS_xt_iclass_xsr_excsave4,
  ICLASS_xt_iclass_rsr_epc5,
  ICLASS_xt_iclass_wsr_epc5,
  ICLASS_xt_iclass_xsr_epc5,
  ICLASS_xt_iclass_rsr_excsave5,
  ICLASS_xt_iclass_wsr_excsave5,
  ICLASS_xt_iclass_xsr_excsave5,
  ICLASS_xt_iclass_rsr_eps2,
  ICLASS_xt_iclass_wsr_eps2,
  ICLASS_xt_iclass_xsr_eps2,
  ICLASS_xt_iclass_rsr_eps3,
  ICLASS_xt_iclass_wsr_eps3,
  ICLASS_xt_iclass_xsr_eps3,
  ICLASS_xt_iclass_rsr_eps4,
  ICLASS_xt_iclass_wsr_eps4,
  ICLASS_xt_iclass_xsr_eps4,
  ICLASS_xt_iclass_rsr_eps5,
  ICLASS_xt_iclass_wsr_eps5,
  ICLASS_xt_iclass_xsr_eps5,
  ICLASS_xt_iclass_rsr_excvaddr,
  ICLASS_xt_iclass_wsr_excvaddr,
  ICLASS_xt_iclass_xsr_excvaddr,
  ICLASS_xt_iclass_rsr_depc,
  ICLASS_xt_iclass_wsr_depc,
  ICLASS_xt_iclass_xsr_depc,
  ICLASS_xt_iclass_rsr_exccause,
  ICLASS_xt_iclass_wsr_exccause,
  ICLASS_xt_iclass_xsr_exccause,
  ICLASS_xt_iclass_rsr_misc0,
  ICLASS_xt_iclass_wsr_misc0,
  ICLASS_xt_iclass_xsr_misc0,
  ICLASS_xt_iclass_rsr_misc1,
  ICLASS_xt_iclass_wsr_misc1,
  ICLASS_xt_iclass_xsr_misc1,
  ICLASS_xt_iclass_rsr_prid,
  ICLASS_xt_iclass_rsr_vecbase,
  ICLASS_xt_iclass_wsr_vecbase,
  ICLASS_xt_iclass_xsr_vecbase,
  ICLASS_xt_iclass_salt,
  ICLASS_xt_iclass_rsr_opmode,
  ICLASS_xt_iclass_wsr_opmode,
  ICLASS_xt_iclass_xsr_opmode,
  ICLASS_xt_iclass_rfi,
  ICLASS_xt_iclass_wait,
  ICLASS_xt_iclass_rsr_interrupt,
  ICLASS_xt_iclass_wsr_intset,
  ICLASS_xt_iclass_wsr_intclear,
  ICLASS_xt_iclass_rsr_intenable,
  ICLASS_xt_iclass_wsr_intenable,
  ICLASS_xt_iclass_xsr_intenable,
  ICLASS_xt_iclass_break,
  ICLASS_xt_iclass_break_n,
  ICLASS_xt_iclass_rsr_dbreaka0,
  ICLASS_xt_iclass_wsr_dbreaka0,
  ICLASS_xt_iclass_xsr_dbreaka0,
  ICLASS_xt_iclass_rsr_dbreakc0,
  ICLASS_xt_iclass_wsr_dbreakc0,
  ICLASS_xt_iclass_xsr_dbreakc0,
  ICLASS_xt_iclass_rsr_dbreaka1,
  ICLASS_xt_iclass_wsr_dbreaka1,
  ICLASS_xt_iclass_xsr_dbreaka1,
  ICLASS_xt_iclass_rsr_dbreakc1,
  ICLASS_xt_iclass_wsr_dbreakc1,
  ICLASS_xt_iclass_xsr_dbreakc1,
  ICLASS_xt_iclass_rsr_ibreaka0,
  ICLASS_xt_iclass_wsr_ibreaka0,
  ICLASS_xt_iclass_xsr_ibreaka0,
  ICLASS_xt_iclass_rsr_ibreaka1,
  ICLASS_xt_iclass_wsr_ibreaka1,
  ICLASS_xt_iclass_xsr_ibreaka1,
  ICLASS_xt_iclass_rsr_ibreakenable,
  ICLASS_xt_iclass_wsr_ibreakenable,
  ICLASS_xt_iclass_xsr_ibreakenable,
  ICLASS_xt_iclass_rsr_debugcause,
  ICLASS_xt_iclass_wsr_debugcause,
  ICLASS_xt_iclass_xsr_debugcause,
  ICLASS_xt_iclass_rsr_icount,
  ICLASS_xt_iclass_wsr_icount,
  ICLASS_xt_iclass_xsr_icount,
  ICLASS_xt_iclass_rsr_icountlevel,
  ICLASS_xt_iclass_wsr_icountlevel,
  ICLASS_xt_iclass_xsr_icountlevel,
  ICLASS_xt_iclass_rsr_ddr,
  ICLASS_xt_iclass_wsr_ddr,
  ICLASS_xt_iclass_xsr_ddr,
  ICLASS_xt_iclass_lddr32_p,
  ICLASS_xt_iclass_sddr32_p,
  ICLASS_xt_iclass_rfdo,
  ICLASS_xt_iclass_rfdd,
  ICLASS_xt_iclass_wsr_mmid,
  ICLASS_xt_iclass_rsr_ccount,
  ICLASS_xt_iclass_wsr_ccount,
  ICLASS_xt_iclass_xsr_ccount,
  ICLASS_xt_iclass_rsr_ccompare0,
  ICLASS_xt_iclass_wsr_ccompare0,
  ICLASS_xt_iclass_xsr_ccompare0,
  ICLASS_xt_iclass_rsr_ccompare1,
  ICLASS_xt_iclass_wsr_ccompare1,
  ICLASS_xt_iclass_xsr_ccompare1,
  ICLASS_xt_iclass_idtlb,
  ICLASS_xt_iclass_rdtlb,
  ICLASS_xt_iclass_wdtlb,
  ICLASS_xt_iclass_iitlb,
  ICLASS_xt_iclass_ritlb,
  ICLASS_xt_iclass_witlb,
  ICLASS_xt_iclass_rsr_cpenable,
  ICLASS_xt_iclass_wsr_cpenable,
  ICLASS_xt_iclass_xsr_cpenable,
  ICLASS_xt_iclass_clamp,
  ICLASS_xt_iclass_minmax,
  ICLASS_xt_iclass_nsa,
  ICLASS_xt_iclass_sx,
  ICLASS_xt_iclass_l32ai,
  ICLASS_xt_iclass_s32ri,
  ICLASS_xt_iclass_s32c1i,
  ICLASS_xt_iclass_rsr_scompare1,
  ICLASS_xt_iclass_wsr_scompare1,
  ICLASS_xt_iclass_xsr_scompare1,
  ICLASS_xt_iclass_rsr_atomctl,
  ICLASS_xt_iclass_wsr_atomctl,
  ICLASS_xt_iclass_xsr_atomctl,
  ICLASS_xt_iclass_div,
  ICLASS_xt_iclass_rsr_eraccess,
  ICLASS_xt_iclass_wsr_eraccess,
  ICLASS_xt_iclass_xsr_eraccess,
  ICLASS_xt_iclass_rer,
  ICLASS_xt_iclass_wer,
  ICLASS_xt_iclass_wb15_0,
  ICLASS_xt_iclass_wb15_1,
  ICLASS_xt_iclass_wb15_2,
  ICLASS_xt_iclass_wb15_3,
  ICLASS_xt_iclass_wb15_4,
  ICLASS_xt_iclass_wloop,
  ICLASS_xt_iclass_wloopz,
  ICLASS_iclass_READ_IMPWIRE,
  ICLASS_iclass_SETB_EXPSTATE,
  ICLASS_iclass_CLRB_EXPSTATE,
  ICLASS_iclass_WRMSK_EXPSTATE,
  ICLASS_rur_expstate,
  ICLASS_wur_expstate,
  ICLASS_RUR_AE_BITHEAD,
  ICLASS_WUR_AE_BITHEAD,
  ICLASS_RUR_AE_CBEGIN0,
  ICLASS_WUR_AE_CBEGIN0,
  ICLASS_RUR_AE_CEND0,
  ICLASS_WUR_AE_CEND0,
  ICLASS_RUR_AE_OVERFLOW,
  ICLASS_WUR_AE_OVERFLOW,
  ICLASS_RUR_AE_SAR,
  ICLASS_WUR_AE_SAR,
  ICLASS_RUR_AE_BITPTR,
  ICLASS_WUR_AE_BITPTR,
  ICLASS_RUR_AE_BITSUSED,
  ICLASS_WUR_AE_BITSUSED,
  ICLASS_RUR_AE_TABLESIZE,
  ICLASS_WUR_AE_TABLESIZE,
  ICLASS_RUR_AE_FIRST_TS,
  ICLASS_WUR_AE_FIRST_TS,
  ICLASS_RUR_AE_NEXTOFFSET,
  ICLASS_WUR_AE_NEXTOFFSET,
  ICLASS_RUR_AE_SEARCHDONE,
  ICLASS_WUR_AE_SEARCHDONE,
  ICLASS_RUR_AE_CWRAP,
  ICLASS_WUR_AE_CWRAP,
  ICLASS_AE_MOVCIRCV,
  ICLASS_AE_MOVVCIRC,
  ICLASS_AE_MOVFUSIONMISCV,
  ICLASS_AE_MOVVFUSIONMISC,
  ICLASS_AE_MOVTABLEFIRSTSEARCHNEXTV,
  ICLASS_AE_MOVVTABLEFIRSTSEARCHNEXT,
  ICLASS_AE_L8_I,
  ICLASS_AE_L8_IP,
  ICLASS_AE_L8_X,
  ICLASS_AE_L8_XP,
  ICLASS_AE_L8S_I,
  ICLASS_AE_L8S_IP,
  ICLASS_AE_L8U_I,
  ICLASS_AE_L8U_IP,
  ICLASS_AE_L8X4F_I,
  ICLASS_AE_L8X4F_IP,
  ICLASS_AE_L8X4F_X,
  ICLASS_AE_L8X4F_XP,
  ICLASS_AE_L8X4S_I,
  ICLASS_AE_L8X4S_IP,
  ICLASS_AE_L8X4S_X,
  ICLASS_AE_L8X4S_XP,
  ICLASS_AE_L8X4U_I,
  ICLASS_AE_L8X4U_IP,
  ICLASS_AE_L8X4U_X,
  ICLASS_AE_L8X4U_XP,
  ICLASS_AE_L8X8_I,
  ICLASS_AE_L8X8_IP,
  ICLASS_AE_L8X8_X,
  ICLASS_AE_L8X8_XP,
  ICLASS_AE_L16_XC,
  ICLASS_AE_L16_I,
  ICLASS_AE_L16_IP,
  ICLASS_AE_L16_X,
  ICLASS_AE_L16_XP,
  ICLASS_AE_L16M_XC,
  ICLASS_AE_L16M_I,
  ICLASS_AE_L16M_IU,
  ICLASS_AE_L16M_X,
  ICLASS_AE_L16M_XU,
  ICLASS_AE_L16X2M_XC,
  ICLASS_AE_L16X2M_I,
  ICLASS_AE_L16X2M_IU,
  ICLASS_AE_L16X2M_X,
  ICLASS_AE_L16X2M_XU,
  ICLASS_AE_L16X4_XC,
  ICLASS_AE_L16X4_I,
  ICLASS_AE_L16X4_IP,
  ICLASS_AE_L16X4_RIP,
  ICLASS_AE_L16X4_RIC,
  ICLASS_AE_L16X4_X,
  ICLASS_AE_L16X4_XP,
  ICLASS_AE_L32_XC,
  ICLASS_AE_L32_I,
  ICLASS_AE_L32_IP,
  ICLASS_AE_L32_X,
  ICLASS_AE_L32_XP,
  ICLASS_AE_L32M_XC,
  ICLASS_AE_L32M_I,
  ICLASS_AE_L32M_IU,
  ICLASS_AE_L32M_X,
  ICLASS_AE_L32M_XU,
  ICLASS_AE_L32X2_XC,
  ICLASS_AE_L32X2_I,
  ICLASS_AE_L32X2_IP,
  ICLASS_AE_L32X2_RIP,
  ICLASS_AE_L32X2_RIC,
  ICLASS_AE_L32X2_X,
  ICLASS_AE_L32X2_XP,
  ICLASS_AE_L64_XC,
  ICLASS_AE_L64_I,
  ICLASS_AE_L64_IP,
  ICLASS_AE_L64_X,
  ICLASS_AE_L64_XP,
  ICLASS_AE_S8_0_I,
  ICLASS_AE_S8_0_IP,
  ICLASS_AE_S8_0_X,
  ICLASS_AE_S8_0_XP,
  ICLASS_AE_S8X4_I,
  ICLASS_AE_S8X4_IP,
  ICLASS_AE_S8X4F_I,
  ICLASS_AE_S8X4F_IP,
  ICLASS_AE_S8X8_I,
  ICLASS_AE_S8X8_IP,
  ICLASS_AE_S8X8_X,
  ICLASS_AE_S8X8_XP,
  ICLASS_AE_S16_0_XC,
  ICLASS_AE_S16_0_I,
  ICLASS_AE_S16_0_IP,
  ICLASS_AE_S16_0_X,
  ICLASS_AE_S16_0_XP,
  ICLASS_AE_S16M_L_XC,
  ICLASS_AE_S16M_L_I,
  ICLASS_AE_S16M_L_IU,
  ICLASS_AE_S16M_L_X,
  ICLASS_AE_S16M_L_XU,
  ICLASS_AE_S16X2M_XC,
  ICLASS_AE_S16X2M_I,
  ICLASS_AE_S16X2M_IU,
  ICLASS_AE_S16X2M_X,
  ICLASS_AE_S16X2M_XU,
  ICLASS_AE_S16X4_XC,
  ICLASS_AE_S16X4_I,
  ICLASS_AE_S16X4_IP,
  ICLASS_AE_S16X4_RIP,
  ICLASS_AE_S16X4_RIC,
  ICLASS_AE_S16X4_X,
  ICLASS_AE_S16X4_XP,
  ICLASS_AE_S16X4RNG_I,
  ICLASS_AE_S16X4RNG_IP,
  ICLASS_AE_S16X4RNG_X,
  ICLASS_AE_S16X4RNG_XP,
  ICLASS_AE_S32_L_XC,
  ICLASS_AE_S32_L_I,
  ICLASS_AE_S32_L_IP,
  ICLASS_AE_S32_L_X,
  ICLASS_AE_S32_L_XP,
  ICLASS_AE_S32_H_I,
  ICLASS_AE_S32_H_IP,
  ICLASS_AE_S32_H_X,
  ICLASS_AE_S32_H_XP,
  ICLASS_AE_S32M_XC,
  ICLASS_AE_S32M_I,
  ICLASS_AE_S32M_IU,
  ICLASS_AE_S32M_X,
  ICLASS_AE_S32M_XU,
  ICLASS_AE_S32X2_XC,
  ICLASS_AE_S32X2_I,
  ICLASS_AE_S32X2_IP,
  ICLASS_AE_S32X2_RIP,
  ICLASS_AE_S32X2_RIC,
  ICLASS_AE_S32X2_X,
  ICLASS_AE_S32X2_XP,
  ICLASS_AE_S64_XC,
  ICLASS_AE_S64_I,
  ICLASS_AE_S64_IP,
  ICLASS_AE_S64_X,
  ICLASS_AE_S64_XP,
  ICLASS_AE_ZALIGN64,
  ICLASS_AE_LALIGN64_I,
  ICLASS_AE_SALIGN64_I,
  ICLASS_AE_MOVALIGN,
  ICLASS_AE_LA64_PP,
  ICLASS_AE_LA32X2POS_PC,
  ICLASS_AE_LA32X2NEG_PC,
  ICLASS_AE_LA16X4POS_PC,
  ICLASS_AE_LA16X4NEG_PC,
  ICLASS_AE_LA32X2_IC,
  ICLASS_AE_LA32X2_IP,
  ICLASS_AE_LA32X2_RIP,
  ICLASS_AE_LA32X2_RIC,
  ICLASS_AE_LA16X4_IC,
  ICLASS_AE_LA16X4_IP,
  ICLASS_AE_LA16X4_RIP,
  ICLASS_AE_LA16X4_RIC,
  ICLASS_AE_LA8X8_IP,
  ICLASS_AE_ADDBRBA32,
  ICLASS_AE_SEL16I,
  ICLASS_AE_SHORTSWAP,
  ICLASS_AE_INTSWAP,
  ICLASS_AE_MOVT16X4,
  ICLASS_AE_MOVF16X4,
  ICLASS_AE_MOVT32X2,
  ICLASS_AE_MOVF32X2,
  ICLASS_AE_MOVDA32X2,
  ICLASS_AE_MOVDA32,
  ICLASS_AE_MOVDA16X2,
  ICLASS_AE_MOVDA16,
  ICLASS_AE_MOVI,
  ICLASS_AE_MOVI16X4,
  ICLASS_AE_SAT16X4,
  ICLASS_AE_SAT8S,
  ICLASS_AE_SAT8U,
  ICLASS_AE_CVT32X2F16_32,
  ICLASS_AE_CVT32X2F16_10,
  ICLASS_AE_SEXT32X2D16_32,
  ICLASS_AE_SEXT32X2D16_10,
  ICLASS_AE_SEXT32X2D24,
  ICLASS_AE_SEXT64Q56,
  ICLASS_AE_CVTP24A16X2_LL,
  ICLASS_AE_CVTP24A16X2_LH,
  ICLASS_AE_CVTP24A16X2_HL,
  ICLASS_AE_CVTP24A16X2_HH,
  ICLASS_AE_TRUNCP24Q48X2,
  ICLASS_AE_TRUNCA32X2F64S,
  ICLASS_AE_TRUNCI32X2F64S,
  ICLASS_AE_TRUNCAV32X2F64S,
  ICLASS_AE_TRUNCI16X4F32S,
  ICLASS_AE_TRUNCA32F64S_L,
  ICLASS_AE_TRUNCI32F64S_L,
  ICLASS_AE_TRUNCP16,
  ICLASS_AE_ROUND32X2F64SSYM,
  ICLASS_AE_ROUND32X2F64SASYM,
  ICLASS_AE_ROUND32X2F48SSYM,
  ICLASS_AE_ROUND32X2F48SASYM,
  ICLASS_AE_ROUND16X4F32SSYM,
  ICLASS_AE_ROUND16X4F32SASYM,
  ICLASS_AE_ROUND24X2F48SSYM,
  ICLASS_AE_ROUND24X2F48SASYM,
  ICLASS_AE_ROUNDSP16Q48X2SYM,
  ICLASS_AE_ROUNDSP16Q48X2ASYM,
  ICLASS_AE_MOV,
  ICLASS_AE_MOVT64,
  ICLASS_AE_MOVF64,
  ICLASS_AE_CVT48A32,
  ICLASS_AE_CVT64A32,
  ICLASS_AE_CVT64F32_H,
  ICLASS_AE_SAT48S,
  ICLASS_AE_SATQ56S,
  ICLASS_AE_SAT24S,
  ICLASS_AE_TRUNCQ32,
  ICLASS_AE_ROUNDSQ32F48SYM,
  ICLASS_AE_ROUNDSQ32F48ASYM,
  ICLASS_AE_TRUNCA32Q48,
  ICLASS_AE_MOVAD32_L,
  ICLASS_AE_MOVAD32_H,
  ICLASS_AE_MOVAD16_3,
  ICLASS_AE_MOVAD16_2,
  ICLASS_AE_MOVAD16_1,
  ICLASS_AE_MOVAD16_0,
  ICLASS_AE_SRA64_32,
  ICLASS_AE_PKSR32_0,
  ICLASS_AE_PKSR24_0,
  ICLASS_AE_ADD32,
  ICLASS_AE_SUB32,
  ICLASS_AE_ADDSUB32,
  ICLASS_AE_SUBADD32,
  ICLASS_AE_ADD16,
  ICLASS_AE_SUB16,
  ICLASS_AE_ADD32_HL_LH,
  ICLASS_AE_NEG32,
  ICLASS_AE_ABS32,
  ICLASS_AE_ADD32S,
  ICLASS_AE_SUB32S,
  ICLASS_AE_ADDSUB32S,
  ICLASS_AE_SUBADD32S,
  ICLASS_AE_ADD16S,
  ICLASS_AE_SUB16S,
  ICLASS_AE_ADDSUB32S_HL_LH,
  ICLASS_AE_SUBADD32S_HL_LH,
  ICLASS_AE_NEG32S,
  ICLASS_AE_ABS32S,
  ICLASS_AE_NEG16S,
  ICLASS_AE_ABS16S,
  ICLASS_AE_CONJ16S,
  ICLASS_AE_MULC16JS_H,
  ICLASS_AE_MULC16JS_L,
  ICLASS_AE_MULAC16JS_H,
  ICLASS_AE_MULAC16JS_L,
  ICLASS_AE_LT16,
  ICLASS_AE_LE16,
  ICLASS_AE_EQ16,
  ICLASS_AE_LT32,
  ICLASS_AE_LE32,
  ICLASS_AE_EQ32,
  ICLASS_AE_MIN32,
  ICLASS_AE_MAX32,
  ICLASS_AE_MIN16,
  ICLASS_AE_MAX16,
  ICLASS_AE_ADD64,
  ICLASS_AE_SUB64,
  ICLASS_AE_NEG64,
  ICLASS_AE_ABS64,
  ICLASS_AE_ADD64S,
  ICLASS_AE_SUB64S,
  ICLASS_AE_NEG64S,
  ICLASS_AE_ABS64S,
  ICLASS_AE_AND,
  ICLASS_AE_NAND,
  ICLASS_AE_OR,
  ICLASS_AE_XOR,
  ICLASS_AE_SRAI16,
  ICLASS_AE_SRAI16R,
  ICLASS_AE_SLAI32,
  ICLASS_AE_SRLI32,
  ICLASS_AE_SRAI32,
  ICLASS_AE_SRAI32R,
  ICLASS_AE_SLAS32,
  ICLASS_AE_SRLS32,
  ICLASS_AE_SRAS32,
  ICLASS_AE_SLAA32,
  ICLASS_AE_SRLA32,
  ICLASS_AE_SRAA32,
  ICLASS_AE_SLAI16S,
  ICLASS_AE_SLAA16S,
  ICLASS_AE_SRAA16S,
  ICLASS_AE_SRAA16RS,
  ICLASS_AE_SLAI32S,
  ICLASS_AE_SLAS32S,
  ICLASS_AE_SLAA32S,
  ICLASS_AE_SRAA32S,
  ICLASS_AE_SRAA32RS,
  ICLASS_AE_SLAI64,
  ICLASS_AE_SRLI64,
  ICLASS_AE_SRAI64,
  ICLASS_AE_SLAS64,
  ICLASS_AE_SRLS64,
  ICLASS_AE_SRAS64,
  ICLASS_AE_SLAA64,
  ICLASS_AE_SRLA64,
  ICLASS_AE_SRAA64,
  ICLASS_AE_SLAI64S,
  ICLASS_AE_SLAS64S,
  ICLASS_AE_SLAA64S,
  ICLASS_AE_LT64,
  ICLASS_AE_LE64,
  ICLASS_AE_EQ64,
  ICLASS_AE_MAX64,
  ICLASS_AE_MIN64,
  ICLASS_AE_NSA64,
  ICLASS_AE_NSAZ16_0,
  ICLASS_AE_NSAZ32_L,
  ICLASS_AE_NSA16_0,
  ICLASS_AE_NSA32_L,
  ICLASS_AE_MULS32F48P16S_LL,
  ICLASS_AE_MULF32S_LL,
  ICLASS_AE_MUL32_LL,
  ICLASS_AE_MULF32R_LL,
  ICLASS_AE_MULS32F48P16S_LH,
  ICLASS_AE_MULF32S_LH,
  ICLASS_AE_MUL32_LH,
  ICLASS_AE_MULF32R_LH,
  ICLASS_AE_MULS32F48P16S_HH,
  ICLASS_AE_MULF32S_HH,
  ICLASS_AE_MUL32_HH,
  ICLASS_AE_MULF32R_HH,
  ICLASS_AE_MULAS32F48P16S_LL,
  ICLASS_AE_MULAF32S_LL,
  ICLASS_AE_MULA32_LL,
  ICLASS_AE_MULAF32R_LL,
  ICLASS_AE_MULAS32F48P16S_LH,
  ICLASS_AE_MULAF32S_LH,
  ICLASS_AE_MULA32_LH,
  ICLASS_AE_MULAF32R_LH,
  ICLASS_AE_MULAS32F48P16S_HH,
  ICLASS_AE_MULAF32S_HH,
  ICLASS_AE_MULA32_HH,
  ICLASS_AE_MULAF32R_HH,
  ICLASS_AE_MULSS32F48P16S_LL,
  ICLASS_AE_MULSF32S_LL,
  ICLASS_AE_MULS32_LL,
  ICLASS_AE_MULSF32R_LL,
  ICLASS_AE_MULSS32F48P16S_LH,
  ICLASS_AE_MULSF32S_LH,
  ICLASS_AE_MULS32_LH,
  ICLASS_AE_MULSF32R_LH,
  ICLASS_AE_MULSS32F48P16S_HH,
  ICLASS_AE_MULSF32S_HH,
  ICLASS_AE_MULS32_HH,
  ICLASS_AE_MULSF32R_HH,
  ICLASS_AE_MUL32U_LL,
  ICLASS_AE_MULA32U_LL,
  ICLASS_AE_MULS32U_LL,
  ICLASS_AE_MULF16SS_33,
  ICLASS_AE_MULF16SS_22,
  ICLASS_AE_MULF16SS_32,
  ICLASS_AE_MULF16SS_21,
  ICLASS_AE_MULF16SS_31,
  ICLASS_AE_MULF16SS_30,
  ICLASS_AE_MULF16SS_10,
  ICLASS_AE_MULF16SS_20,
  ICLASS_AE_MULF16SS_11,
  ICLASS_AE_MULF16SS_00,
  ICLASS_AE_MULSF16SS_33,
  ICLASS_AE_MULSF16SS_22,
  ICLASS_AE_MULSF16SS_32,
  ICLASS_AE_MULSF16SS_21,
  ICLASS_AE_MULSF16SS_31,
  ICLASS_AE_MULSF16SS_30,
  ICLASS_AE_MULSF16SS_10,
  ICLASS_AE_MULSF16SS_20,
  ICLASS_AE_MULSF16SS_11,
  ICLASS_AE_MULSF16SS_00,
  ICLASS_AE_MULAF16SS_33,
  ICLASS_AE_MULAF16SS_22,
  ICLASS_AE_MULAF16SS_32,
  ICLASS_AE_MULAF16SS_21,
  ICLASS_AE_MULAF16SS_31,
  ICLASS_AE_MULAF16SS_30,
  ICLASS_AE_MULAF16SS_10,
  ICLASS_AE_MULAF16SS_20,
  ICLASS_AE_MULAF16SS_11,
  ICLASS_AE_MULAF16SS_00,
  ICLASS_AE_MULAAFD16SS_33_22,
  ICLASS_AE_MULAAFD16SS_13_02,
  ICLASS_AE_MULAAFD16SS_11_00,
  ICLASS_AE_MULSSFD16SS_33_22,
  ICLASS_AE_MULSSFD16SS_13_02,
  ICLASS_AE_MULSSFD16SS_11_00,
  ICLASS_AE_MULZAAFD16SS_33_22,
  ICLASS_AE_MULZAAFD16SS_13_02,
  ICLASS_AE_MULZAAFD16SS_11_00,
  ICLASS_AE_MULZSSFD16SS_33_22,
  ICLASS_AE_MULZSSFD16SS_13_02,
  ICLASS_AE_MULZSSFD16SS_11_00,
  ICLASS_AE_MULF48Q32SP16S_L,
  ICLASS_AE_MULF48Q32SP16U_L,
  ICLASS_AE_MULQ32SP16S_L,
  ICLASS_AE_MULQ32SP16U_L,
  ICLASS_AE_MULAF48Q32SP16S_L,
  ICLASS_AE_MULAF48Q32SP16U_L,
  ICLASS_AE_MULAQ32SP16S_L,
  ICLASS_AE_MULAQ32SP16U_L,
  ICLASS_AE_MULSF48Q32SP16S_L,
  ICLASS_AE_MULSF48Q32SP16U_L,
  ICLASS_AE_MULSQ32SP16S_L,
  ICLASS_AE_MULSQ32SP16U_L,
  ICLASS_AE_MULF32X16_L0,
  ICLASS_AE_MUL32X16_L0,
  ICLASS_AE_MULF32X16_L1,
  ICLASS_AE_MUL32X16_L1,
  ICLASS_AE_MULF32X16_L2,
  ICLASS_AE_MUL32X16_L2,
  ICLASS_AE_MULF32X16_L3,
  ICLASS_AE_MUL32X16_L3,
  ICLASS_AE_MULF32X16_H0,
  ICLASS_AE_MUL32X16_H0,
  ICLASS_AE_MULF32X16_H1,
  ICLASS_AE_MUL32X16_H1,
  ICLASS_AE_MULF32X16_H2,
  ICLASS_AE_MUL32X16_H2,
  ICLASS_AE_MULF32X16_H3,
  ICLASS_AE_MUL32X16_H3,
  ICLASS_AE_MULAF32X16_L0,
  ICLASS_AE_MULA32X16_L0,
  ICLASS_AE_MULAF32X16_L1,
  ICLASS_AE_MULA32X16_L1,
  ICLASS_AE_MULAF32X16_L2,
  ICLASS_AE_MULA32X16_L2,
  ICLASS_AE_MULAF32X16_L3,
  ICLASS_AE_MULA32X16_L3,
  ICLASS_AE_MULAF32X16_H0,
  ICLASS_AE_MULA32X16_H0,
  ICLASS_AE_MULAF32X16_H1,
  ICLASS_AE_MULA32X16_H1,
  ICLASS_AE_MULAF32X16_H2,
  ICLASS_AE_MULA32X16_H2,
  ICLASS_AE_MULAF32X16_H3,
  ICLASS_AE_MULA32X16_H3,
  ICLASS_AE_MULSF32X16_L0,
  ICLASS_AE_MULS32X16_L0,
  ICLASS_AE_MULSF32X16_L1,
  ICLASS_AE_MULS32X16_L1,
  ICLASS_AE_MULSF32X16_L2,
  ICLASS_AE_MULS32X16_L2,
  ICLASS_AE_MULSF32X16_L3,
  ICLASS_AE_MULS32X16_L3,
  ICLASS_AE_MULSF32X16_H0,
  ICLASS_AE_MULS32X16_H0,
  ICLASS_AE_MULSF32X16_H1,
  ICLASS_AE_MULS32X16_H1,
  ICLASS_AE_MULSF32X16_H2,
  ICLASS_AE_MULS32X16_H2,
  ICLASS_AE_MULSF32X16_H3,
  ICLASS_AE_MULS32X16_H3,
  ICLASS_AE_MULAAFD32X16_H3_L2,
  ICLASS_AE_MULAAD32X16_H3_L2,
  ICLASS_AE_MULAAFD32X16_H1_L0,
  ICLASS_AE_MULAAD32X16_H1_L0,
  ICLASS_AE_MULASFD32X16_H3_L2,
  ICLASS_AE_MULASD32X16_H3_L2,
  ICLASS_AE_MULASFD32X16_H1_L0,
  ICLASS_AE_MULASD32X16_H1_L0,
  ICLASS_AE_MULSAFD32X16_H3_L2,
  ICLASS_AE_MULSAD32X16_H3_L2,
  ICLASS_AE_MULSAFD32X16_H1_L0,
  ICLASS_AE_MULSAD32X16_H1_L0,
  ICLASS_AE_MULSSFD32X16_H3_L2,
  ICLASS_AE_MULSSD32X16_H3_L2,
  ICLASS_AE_MULSSFD32X16_H1_L0,
  ICLASS_AE_MULSSD32X16_H1_L0,
  ICLASS_AE_MULZAAFD32X16_H3_L2,
  ICLASS_AE_MULZAAD32X16_H3_L2,
  ICLASS_AE_MULZAAFD32X16_H1_L0,
  ICLASS_AE_MULZAAD32X16_H1_L0,
  ICLASS_AE_MULZASFD32X16_H3_L2,
  ICLASS_AE_MULZASD32X16_H3_L2,
  ICLASS_AE_MULZASFD32X16_H1_L0,
  ICLASS_AE_MULZASD32X16_H1_L0,
  ICLASS_AE_MULZSAFD32X16_H3_L2,
  ICLASS_AE_MULZSAD32X16_H3_L2,
  ICLASS_AE_MULZSAFD32X16_H1_L0,
  ICLASS_AE_MULZSAD32X16_H1_L0,
  ICLASS_AE_MULZSSFD32X16_H3_L2,
  ICLASS_AE_MULZSSD32X16_H3_L2,
  ICLASS_AE_MULZSSFD32X16_H1_L0,
  ICLASS_AE_MULZSSD32X16_H1_L0,
  ICLASS_AE_MULZAAFD32X16_H2_L3,
  ICLASS_AE_MULZAAFD32X16_H0_L1,
  ICLASS_AE_MULAAFD32X16_H2_L3,
  ICLASS_AE_MULAAFD32X16_H0_L1,
  ICLASS_AE_MULZAAD32X16_H2_L3,
  ICLASS_AE_MULZAAD32X16_H0_L1,
  ICLASS_AE_MULAAD32X16_H2_L3,
  ICLASS_AE_MULAAD32X16_H0_L1,
  ICLASS_AE_MULP32X16X2_H,
  ICLASS_AE_MULFP32X16X2S_H,
  ICLASS_AE_MULFP32X16X2RS_H,
  ICLASS_AE_MULFP32X16X2RAS_H,
  ICLASS_AE_MULP32X16X2_L,
  ICLASS_AE_MULFP32X16X2S_L,
  ICLASS_AE_MULFP32X16X2RS_L,
  ICLASS_AE_MULFP32X16X2RAS_L,
  ICLASS_AE_MULAP32X16X2_H,
  ICLASS_AE_MULAFP32X16X2S_H,
  ICLASS_AE_MULAFP32X16X2RS_H,
  ICLASS_AE_MULAFP32X16X2RAS_H,
  ICLASS_AE_MULAP32X16X2_L,
  ICLASS_AE_MULAFP32X16X2S_L,
  ICLASS_AE_MULAFP32X16X2RS_L,
  ICLASS_AE_MULAFP32X16X2RAS_L,
  ICLASS_AE_MULSP32X16X2_H,
  ICLASS_AE_MULSFP32X16X2S_H,
  ICLASS_AE_MULSFP32X16X2RS_H,
  ICLASS_AE_MULSFP32X16X2RAS_H,
  ICLASS_AE_MULSP32X16X2_L,
  ICLASS_AE_MULSFP32X16X2S_L,
  ICLASS_AE_MULSFP32X16X2RS_L,
  ICLASS_AE_MULSFP32X16X2RAS_L,
  ICLASS_AE_MULFCR32X16RAS_L,
  ICLASS_AE_MULFCR32X16RAS_H,
  ICLASS_AE_MULFCI32X16RAS_L,
  ICLASS_AE_MULFCI32X16RAS_H,
  ICLASS_AE_MULFCR32X16S_L,
  ICLASS_AE_MULFCR32X16S_H,
  ICLASS_AE_MULFCI32X16S_L,
  ICLASS_AE_MULFCI32X16S_H,
  ICLASS_AE_MULAFCR32X16RAS_L,
  ICLASS_AE_MULAFCR32X16RAS_H,
  ICLASS_AE_MULAFCI32X16RAS_L,
  ICLASS_AE_MULAFCI32X16RAS_H,
  ICLASS_AE_MULAFCR32X16S_L,
  ICLASS_AE_MULAFCR32X16S_H,
  ICLASS_AE_MULAFCI32X16S_L,
  ICLASS_AE_MULAFCI32X16S_H,
  ICLASS_AE_MULP32X2_H,
  ICLASS_AE_MULAP32X2_H,
  ICLASS_AE_MULSP32X2_H,
  ICLASS_AE_MULP32X2_L,
  ICLASS_AE_MULAP32X2_L,
  ICLASS_AE_MULSP32X2_L,
  ICLASS_AE_MULFP32X2RS_H,
  ICLASS_AE_MULFP32X2RAS_H,
  ICLASS_AE_MULAFP32X2RS_H,
  ICLASS_AE_MULAFP32X2RAS_H,
  ICLASS_AE_MULSFP32X2RS_H,
  ICLASS_AE_MULSFP32X2RAS_H,
  ICLASS_AE_MULFP32X2RS_L,
  ICLASS_AE_MULFP32X2RAS_L,
  ICLASS_AE_MULAFP32X2RS_L,
  ICLASS_AE_MULAFP32X2RAS_L,
  ICLASS_AE_MULSFP32X2RS_L,
  ICLASS_AE_MULSFP32X2RAS_L,
  ICLASS_AE_MULFP16X4S_H,
  ICLASS_AE_MULFP16X4RAS_H,
  ICLASS_AE_MULFP16X4S_L,
  ICLASS_AE_MULFP16X4RAS_L,
  ICLASS_AE_MULCR32X16_L,
  ICLASS_AE_MULCR32X16_H,
  ICLASS_AE_MULCI32X16_L,
  ICLASS_AE_MULCI32X16_H,
  ICLASS_AE_MULACR32X16_L,
  ICLASS_AE_MULACR32X16_H,
  ICLASS_AE_MULACI32X16_L,
  ICLASS_AE_MULACI32X16_H,
  ICLASS_AE_MULF16X4SS_H,
  ICLASS_AE_MULAF16X4SS_H,
  ICLASS_AE_MULSF16X4SS_H,
  ICLASS_AE_MULF16X4SS_L,
  ICLASS_AE_MULAF16X4SS_L,
  ICLASS_AE_MULSF16X4SS_L,
  ICLASS_AE_MUL16X4_H,
  ICLASS_AE_MULA16X4_H,
  ICLASS_AE_MULS16X4_H,
  ICLASS_AE_MULA16X4S_H,
  ICLASS_AE_MULS16X4S_H,
  ICLASS_AE_MUL16X4_L,
  ICLASS_AE_MULA16X4_L,
  ICLASS_AE_MULS16X4_L,
  ICLASS_AE_MULA16X4S_L,
  ICLASS_AE_MULS16X4S_L,
  ICLASS_AE_MULC16S_H,
  ICLASS_AE_MULC16S_L,
  ICLASS_AE_MULAC16S_H,
  ICLASS_AE_MULAC16S_L,
  ICLASS_AE_MULFC16RAS_H,
  ICLASS_AE_MULFC16RAS_L,
  ICLASS_AE_MULAFC16RAS_H,
  ICLASS_AE_MULAFC16RAS_L,
  ICLASS_AE_MULZAAAAQ16,
  ICLASS_AE_MULAAAAQ16,
  ICLASS_AE_MUL16JS,
  ICLASS_AE_CALCRNG3,
  ICLASS_AE_ADDANDSUBRNG16RAS_S1,
  ICLASS_AE_ADDANDSUBRNG16RAS_S2,
  ICLASS_AE_DIV64D32_H,
  ICLASS_AE_DIV64D32_L,
  ICLASS_AE_SHA32,
  ICLASS_AE_VLDL32T,
  ICLASS_AE_VLDL16T,
  ICLASS_AE_VLDL16C,
  ICLASS_AE_VLDL16C_IP,
  ICLASS_AE_VLDL16C_IC,
  ICLASS_AE_VLDSHT,
  ICLASS_AE_LB,
  ICLASS_AE_LBI,
  ICLASS_AE_LBK,
  ICLASS_AE_LBKI,
  ICLASS_AE_LBS,
  ICLASS_AE_LBSI,
  ICLASS_AE_LBIT,
  ICLASS_AE_DB,
  ICLASS_AE_DBI,
  ICLASS_AE_DBIT,
  ICLASS_AE_DB_IC,
  ICLASS_AE_DBI_IC,
  ICLASS_AE_DB_IP,
  ICLASS_AE_DBI_IP,
  ICLASS_AE_LBI_DBI_IC,
  ICLASS_AE_LBI_DBI_IP,
  ICLASS_AE_LBI_DBI,
  ICLASS_AE_SB,
  ICLASS_AE_SBI,
  ICLASS_AE_SBF,
  ICLASS_AE_SBIT,
  ICLASS_AE_SB_IC,
  ICLASS_AE_SBI_IC,
  ICLASS_AE_SBF_IC,
  ICLASS_AE_SB_IP,
  ICLASS_AE_SBI_IP,
  ICLASS_AE_SBF_IP,
  ICLASS_AE_L16SI_N,
  ICLASS_AE_L16UI_N,
  ICLASS_AE_S16I_N,
  ICLASS_AE_SEXT16,
  ICLASS_AE_ZEXT16,
  ICLASS_AE_ZEXT8,
  ICLASS_AE_CLAMPS16,
  ICLASS_AE_ZEROB,
  ICLASS_AE_ZEROC16X4,
  ICLASS_AE_ZEROC32X2,
  ICLASS_AE_SEXT32,
  ICLASS_AE_MOVBA1,
  ICLASS_AE_MOVAB1,
  ICLASS_AE_MOVBA2,
  ICLASS_AE_MOVAB2,
  ICLASS_AE_MOVBA4,
  ICLASS_AE_MOVAB4,
  ICLASS_AE_MOVBA8,
  ICLASS_AE_MOVAB8,
  ICLASS_AE_MB,
  ICLASS_AE_JOINB,
  ICLASS_AE_EXTRACTBI,
  ICLASS_AE_RANDB4,
  ICLASS_AE_RANDB8,
  ICLASS_AE_RORB4,
  ICLASS_AE_RORB8,
  ICLASS_AE_ANDB8,
  ICLASS_AE_ORB8,
  ICLASS_AE_XORB8,
  ICLASS_AE_ANDNOTB8,
  ICLASS_AE_ORNOTB8,
  ICLASS_AE_NOTB8,
  ICLASS_AE_LTR4,
  ICLASS_AE_EXTRACTBL,
  ICLASS_AE_EXTRACTBH,
  ICLASS_AE_BITREV8,
  ICLASS_AE_POPC2B,
  ICLASS_AE_POPCB8,
  ICLASS_AE_MOVSQZ16X4,
  ICLASS_AE_LA8X4S_IP,
  ICLASS_AE_LA8X4U_IP,
  ICLASS_AE_SA32X2_IC,
  ICLASS_AE_SA32X2_IP,
  ICLASS_AE_SA32X2_RIP,
  ICLASS_AE_SA32X2_RIC,
  ICLASS_AE_SA16X4_IC,
  ICLASS_AE_SA16X4_IP,
  ICLASS_AE_SA16X4_RIP,
  ICLASS_AE_SA16X4_RIC,
  ICLASS_AE_SA8X4U_IP,
  ICLASS_AE_SAV16X4_XP,
  ICLASS_AE_SA64POS_FP,
  ICLASS_AE_SA64NEG_FP,
  ICLASS_AE_SA8X8_IP,
  ICLASS_AE_SAV8X8_XP,
  ICLASS_AE_LAV8X8_XP,
  ICLASS_AE_LAV16X4_XP,
  ICLASS_AE_LAV8X4S_XP,
  ICLASS_AE_LAV8X4U_XP,
  ICLASS_AE_SAV8X4U_XP,
  ICLASS_AE_SATU16X4,
  ICLASS_AE_SAT8X4X32_H,
  ICLASS_AE_SATU8X4X32_H,
  ICLASS_RUR_FCR,
  ICLASS_WUR_FCR,
  ICLASS_RUR_FSR,
  ICLASS_WUR_FSR,
  ICLASS_RFR,
  ICLASS_WFR,
  ICLASS_MOVT_S,
  ICLASS_MOVF_S,
  ICLASS_MOVEQZ_S,
  ICLASS_MOVNEZ_S,
  ICLASS_MOVGEZ_S,
  ICLASS_MOVLTZ_S,
  ICLASS_ADD_S,
  ICLASS_SUB_S,
  ICLASS_MUL_S,
  ICLASS_MADD_S,
  ICLASS_MADDN_S,
  ICLASS_MSUB_S,
  ICLASS_MSUBN_S,
  ICLASS_DIVN_S,
  ICLASS_ABS_S,
  ICLASS_NEG_S,
  ICLASS_CONJC_S,
  ICLASS_CONST_S,
  ICLASS_MAX_S,
  ICLASS_MIN_S,
  ICLASS_MINNUM_S,
  ICLASS_MAXNUM_S,
  ICLASS_OLE_S,
  ICLASS_OLT_S,
  ICLASS_OEQ_S,
  ICLASS_UN_S,
  ICLASS_ULE_S,
  ICLASS_ULT_S,
  ICLASS_UEQ_S,
  ICLASS_ADDEXP_S,
  ICLASS_ADDEXPM_S,
  ICLASS_MKSADJ_S,
  ICLASS_MKDADJ_S,
  ICLASS_NEXP01_S,
  ICLASS_DIV0_S,
  ICLASS_SQRT0_S,
  ICLASS_RECIP0_S,
  ICLASS_RSQRT0_S,
  ICLASS_TRUNC_S,
  ICLASS_UTRUNC_S,
  ICLASS_TRUNC_SX2,
  ICLASS_UTRUNC_SX2,
  ICLASS_FICEIL_S,
  ICLASS_FIFLOOR_S,
  ICLASS_FIRINT_S,
  ICLASS_FIROUND_S,
  ICLASS_FITRUNC_S,
  ICLASS_FLOAT_S,
  ICLASS_UFLOAT_S,
  ICLASS_FLOAT_SX2,
  ICLASS_UFLOAT_SX2,
  ICLASS_MULJC_S,
  ICLASS_CLSFY_S,
  ICLASS_CVTSF16_L,
  ICLASS_CVTF16S_L,
  ICLASS_MULMUX_S,
  ICLASS_MADDMUX_S,
  ICLASS_AE_MOVFCRFSRV,
  ICLASS_AE_MOVVFCRFSR
};


/*  Opcode encodings.  */

static void
Opcode_excw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2080;
}

static void
Opcode_rfe_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3000;
}

static void
Opcode_rfde_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3200;
}

static void
Opcode_syscall_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5000;
}

static void
Opcode_call12_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x35;
}

static void
Opcode_call8_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x25;
}

static void
Opcode_call4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x15;
}

static void
Opcode_callx12_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf0;
}

static void
Opcode_callx8_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0;
}

static void
Opcode_callx4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0;
}

static void
Opcode_entry_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36;
}

static void
Opcode_movsp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1000;
}

static void
Opcode_rotw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x408000;
}

static void
Opcode_retw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90;
}

static void
Opcode_retw_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf01d;
}

static void
Opcode_rfwo_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3400;
}

static void
Opcode_rfwu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3500;
}

static void
Opcode_l32e_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90000;
}

static void
Opcode_s32e_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x490000;
}

static void
Opcode_rsr_windowbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x34800;
}

static void
Opcode_wsr_windowbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x134800;
}

static void
Opcode_xsr_windowbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x614800;
}

static void
Opcode_rsr_windowstart_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x34900;
}

static void
Opcode_wsr_windowstart_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x134900;
}

static void
Opcode_xsr_windowstart_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x614900;
}

static void
Opcode_add_n_Slot_inst16a_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa;
}

static void
Opcode_addi_n_Slot_inst16a_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb;
}

static void
Opcode_beqz_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8c;
}

static void
Opcode_bnez_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc;
}

static void
Opcode_ill_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf06d;
}

static void
Opcode_l32i_n_Slot_inst16a_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8;
}

static void
Opcode_mov_n_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x731400;
}

static void
Opcode_mov_n_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f2c00;
}

static void
Opcode_mov_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd;
}

static void
Opcode_movi_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc;
}

static void
Opcode_nop_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf03d;
}

static void
Opcode_ret_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf00d;
}

static void
Opcode_s32i_n_Slot_inst16a_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9;
}

static void
Opcode_rur_threadptr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe30e70;
}

static void
Opcode_wur_threadptr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf3e700;
}

static void
Opcode_addi_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300000;
}

static void
Opcode_addi_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20000;
}

static void
Opcode_addi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc002;
}

static void
Opcode_addmi_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300400;
}

static void
Opcode_addmi_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30000;
}

static void
Opcode_addmi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd002;
}

static void
Opcode_add_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6f6000;
}

static void
Opcode_add_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c0000;
}

static void
Opcode_add_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800000;
}

static void
Opcode_addx2_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6f7000;
}

static void
Opcode_addx2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c1000;
}

static void
Opcode_addx2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x900000;
}

static void
Opcode_addx4_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6f8000;
}

static void
Opcode_addx4_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c2000;
}

static void
Opcode_addx4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa00000;
}

static void
Opcode_addx8_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6f9000;
}

static void
Opcode_addx8_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c3000;
}

static void
Opcode_addx8_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb00000;
}

static void
Opcode_sub_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x707000;
}

static void
Opcode_sub_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1cd000;
}

static void
Opcode_sub_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc00000;
}

static void
Opcode_subx2_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x708000;
}

static void
Opcode_subx2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ce000;
}

static void
Opcode_subx2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00000;
}

static void
Opcode_subx4_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x709000;
}

static void
Opcode_subx4_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1cf000;
}

static void
Opcode_subx4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe00000;
}

static void
Opcode_subx8_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70a000;
}

static void
Opcode_subx8_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d0000;
}

static void
Opcode_subx8_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf00000;
}

static void
Opcode_and_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6fa000;
}

static void
Opcode_and_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c4000;
}

static void
Opcode_and_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100000;
}

static void
Opcode_or_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x703000;
}

static void
Opcode_or_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c9000;
}

static void
Opcode_or_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200000;
}

static void
Opcode_xor_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70b000;
}

static void
Opcode_xor_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d1000;
}

static void
Opcode_xor_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300000;
}

static void
Opcode_beqi_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200040;
}

static void
Opcode_beqi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x26;
}

static void
Opcode_bgei_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200050;
}

static void
Opcode_bgei_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe6;
}

static void
Opcode_blti_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200070;
}

static void
Opcode_blti_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa6;
}

static void
Opcode_bnei_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200090;
}

static void
Opcode_bnei_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x66;
}

static void
Opcode_bbci_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200000;
}

static void
Opcode_bbci_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6007;
}

static void
Opcode_bbsi_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200020;
}

static void
Opcode_bbsi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe007;
}

static void
Opcode_bgeui_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200060;
}

static void
Opcode_bgeui_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf6;
}

static void
Opcode_bltui_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200080;
}

static void
Opcode_bltui_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb6;
}

static void
Opcode_ball_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300800;
}

static void
Opcode_ball_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4007;
}

static void
Opcode_bany_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300c00;
}

static void
Opcode_bany_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8007;
}

static void
Opcode_bbc_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300100;
}

static void
Opcode_bbc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5007;
}

static void
Opcode_bbs_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300500;
}

static void
Opcode_bbs_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd007;
}

static void
Opcode_beq_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300900;
}

static void
Opcode_beq_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1007;
}

static void
Opcode_bge_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300d00;
}

static void
Opcode_bge_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa007;
}

static void
Opcode_bgeu_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300200;
}

static void
Opcode_bgeu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb007;
}

static void
Opcode_blt_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300600;
}

static void
Opcode_blt_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2007;
}

static void
Opcode_bltu_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300a00;
}

static void
Opcode_bltu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3007;
}

static void
Opcode_bnall_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300e00;
}

static void
Opcode_bnall_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc007;
}

static void
Opcode_bne_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300300;
}

static void
Opcode_bne_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9007;
}

static void
Opcode_bnone_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300700;
}

static void
Opcode_bnone_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7;
}

static void
Opcode_beqz_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x540000;
}

static void
Opcode_beqz_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16;
}

static void
Opcode_bgez_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x550000;
}

static void
Opcode_bgez_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd6;
}

static void
Opcode_bltz_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x560000;
}

static void
Opcode_bltz_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x96;
}

static void
Opcode_bnez_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x570000;
}

static void
Opcode_bnez_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x56;
}

static void
Opcode_call0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5;
}

static void
Opcode_callx0_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x41fd10;
}

static void
Opcode_callx0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0;
}

static void
Opcode_extui_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x140000;
}

static void
Opcode_extui_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_extui_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40000;
}

static void
Opcode_ill_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_j_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100000;
}

static void
Opcode_j_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6;
}

static void
Opcode_jx_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7350b0;
}

static void
Opcode_jx_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0;
}

static void
Opcode_l16ui_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300f00;
}

static void
Opcode_l16ui_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1002;
}

static void
Opcode_l16si_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x300b00;
}

static void
Opcode_l16si_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9002;
}

static void
Opcode_l32i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400000;
}

static void
Opcode_l32i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2002;
}

static void
Opcode_l32r_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_l32r_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1;
}

static void
Opcode_l8ui_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400400;
}

static void
Opcode_l8ui_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2;
}

static void
Opcode_loop_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400900;
}

static void
Opcode_loop_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d3000;
}

static void
Opcode_loop_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8076;
}

static void
Opcode_loopgtz_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400d00;
}

static void
Opcode_loopgtz_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d4000;
}

static void
Opcode_loopgtz_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa076;
}

static void
Opcode_loopnez_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400910;
}

static void
Opcode_loopnez_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d5000;
}

static void
Opcode_loopnez_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9076;
}

static void
Opcode_movi_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x580000;
}

static void
Opcode_movi_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40000;
}

static void
Opcode_movi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa002;
}

static void
Opcode_moveqz_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6ff000;
}

static void
Opcode_moveqz_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c5000;
}

static void
Opcode_moveqz_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x830000;
}

static void
Opcode_movgez_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700000;
}

static void
Opcode_movgez_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c6000;
}

static void
Opcode_movgez_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb30000;
}

static void
Opcode_movltz_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x701000;
}

static void
Opcode_movltz_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c7000;
}

static void
Opcode_movltz_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa30000;
}

static void
Opcode_movnez_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x702000;
}

static void
Opcode_movnez_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c8000;
}

static void
Opcode_movnez_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x930000;
}

static void
Opcode_abs_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x730008;
}

static void
Opcode_abs_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f4000;
}

static void
Opcode_abs_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x600100;
}

static void
Opcode_neg_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x730009;
}

static void
Opcode_neg_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f4010;
}

static void
Opcode_neg_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x600000;
}

static void
Opcode_nop_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x420d15;
}

static void
Opcode_nop_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f1309;
}

static void
Opcode_nop_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e2581;
}

static void
Opcode_nop_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110338;
}

static void
Opcode_nop_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba46183;
  slotbuf[1] = 0;
}

static void
Opcode_nop_Slot_f3_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ab004;
}

static void
Opcode_nop_Slot_f3_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200;
}

static void
Opcode_nop_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20f0;
}

static void
Opcode_depbits_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0000;
}

static void
Opcode_ret_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7354b0;
}

static void
Opcode_ret_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80;
}

static void
Opcode_simcall_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5100;
}

static void
Opcode_s16i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400800;
}

static void
Opcode_s16i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5002;
}

static void
Opcode_s32i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400c00;
}

static void
Opcode_s32i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6002;
}

static void
Opcode_s32nb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x590000;
}

static void
Opcode_s8i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400100;
}

static void
Opcode_s8i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4002;
}

static void
Opcode_ssa8b_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7358b0;
}

static void
Opcode_ssa8b_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x403000;
}

static void
Opcode_ssa8l_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x735cb0;
}

static void
Opcode_ssa8l_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x402000;
}

static void
Opcode_ssl_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7350c0;
}

static void
Opcode_ssl_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f1308;
}

static void
Opcode_ssl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x401000;
}

static void
Opcode_ssr_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7350d0;
}

static void
Opcode_ssr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400000;
}

static void
Opcode_ssai_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7350a0;
}

static void
Opcode_ssai_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x404000;
}

static void
Opcode_sll_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a50a0;
}

static void
Opcode_sll_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f5000;
}

static void
Opcode_sll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa10000;
}

static void
Opcode_src_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x706000;
}

static void
Opcode_src_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1cc000;
}

static void
Opcode_src_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x810000;
}

static void
Opcode_sra_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73000a;
}

static void
Opcode_sra_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f4020;
}

static void
Opcode_sra_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb10000;
}

static void
Opcode_srl_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73000b;
}

static void
Opcode_srl_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f4030;
}

static void
Opcode_srl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x910000;
}

static void
Opcode_slli_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x68a000;
}

static void
Opcode_slli_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x78000;
}

static void
Opcode_slli_Slot_f3_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a4000;
}

static void
Opcode_slli_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10000;
}

static void
Opcode_srai_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x68c000;
}

static void
Opcode_srai_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7a000;
}

static void
Opcode_srai_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x210000;
}

static void
Opcode_srli_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70e000;
}

static void
Opcode_srli_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d3000;
}

static void
Opcode_srli_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x410000;
}

static void
Opcode_memw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20c0;
}

static void
Opcode_extw_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20d0;
}

static void
Opcode_isync_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2000;
}

static void
Opcode_dsync_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2030;
}

static void
Opcode_esync_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2020;
}

static void
Opcode_rsync_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2010;
}

static void
Opcode_rsil_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6000;
}

static void
Opcode_rsr_lend_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30100;
}

static void
Opcode_wsr_lend_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130100;
}

static void
Opcode_xsr_lend_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610100;
}

static void
Opcode_rsr_lcount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30200;
}

static void
Opcode_wsr_lcount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130200;
}

static void
Opcode_xsr_lcount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610200;
}

static void
Opcode_rsr_lbeg_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30000;
}

static void
Opcode_wsr_lbeg_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130000;
}

static void
Opcode_xsr_lbeg_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610000;
}

static void
Opcode_rsr_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30300;
}

static void
Opcode_wsr_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130300;
}

static void
Opcode_xsr_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610300;
}

static void
Opcode_rsr_memctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36100;
}

static void
Opcode_wsr_memctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x136100;
}

static void
Opcode_xsr_memctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x616100;
}

static void
Opcode_rsr_configid0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b000;
}

static void
Opcode_wsr_configid0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13b000;
}

static void
Opcode_rsr_configid1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d000;
}

static void
Opcode_rsr_243_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f300;
}

static void
Opcode_rsr_ps_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e600;
}

static void
Opcode_wsr_ps_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e600;
}

static void
Opcode_xsr_ps_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61e600;
}

static void
Opcode_rsr_epc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b100;
}

static void
Opcode_wsr_epc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13b100;
}

static void
Opcode_xsr_epc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61b100;
}

static void
Opcode_rsr_excsave1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d100;
}

static void
Opcode_wsr_excsave1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13d100;
}

static void
Opcode_xsr_excsave1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61d100;
}

static void
Opcode_rsr_epc2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b200;
}

static void
Opcode_wsr_epc2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13b200;
}

static void
Opcode_xsr_epc2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61b200;
}

static void
Opcode_rsr_excsave2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d200;
}

static void
Opcode_wsr_excsave2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13d200;
}

static void
Opcode_xsr_excsave2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61d200;
}

static void
Opcode_rsr_epc3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b300;
}

static void
Opcode_wsr_epc3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13b300;
}

static void
Opcode_xsr_epc3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61b300;
}

static void
Opcode_rsr_excsave3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d300;
}

static void
Opcode_wsr_excsave3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13d300;
}

static void
Opcode_xsr_excsave3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61d300;
}

static void
Opcode_rsr_epc4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b400;
}

static void
Opcode_wsr_epc4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13b400;
}

static void
Opcode_xsr_epc4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61b400;
}

static void
Opcode_rsr_excsave4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d400;
}

static void
Opcode_wsr_excsave4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13d400;
}

static void
Opcode_xsr_excsave4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61d400;
}

static void
Opcode_rsr_epc5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b500;
}

static void
Opcode_wsr_epc5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13b500;
}

static void
Opcode_xsr_epc5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61b500;
}

static void
Opcode_rsr_excsave5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d500;
}

static void
Opcode_wsr_excsave5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13d500;
}

static void
Opcode_xsr_excsave5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61d500;
}

static void
Opcode_rsr_eps2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c200;
}

static void
Opcode_wsr_eps2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13c200;
}

static void
Opcode_xsr_eps2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61c200;
}

static void
Opcode_rsr_eps3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c300;
}

static void
Opcode_wsr_eps3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13c300;
}

static void
Opcode_xsr_eps3_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61c300;
}

static void
Opcode_rsr_eps4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c400;
}

static void
Opcode_wsr_eps4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13c400;
}

static void
Opcode_xsr_eps4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61c400;
}

static void
Opcode_rsr_eps5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c500;
}

static void
Opcode_wsr_eps5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13c500;
}

static void
Opcode_xsr_eps5_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61c500;
}

static void
Opcode_rsr_excvaddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3ee00;
}

static void
Opcode_wsr_excvaddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13ee00;
}

static void
Opcode_xsr_excvaddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61ee00;
}

static void
Opcode_rsr_depc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c000;
}

static void
Opcode_wsr_depc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13c000;
}

static void
Opcode_xsr_depc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61c000;
}

static void
Opcode_rsr_exccause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e800;
}

static void
Opcode_wsr_exccause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e800;
}

static void
Opcode_xsr_exccause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61e800;
}

static void
Opcode_rsr_misc0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f400;
}

static void
Opcode_wsr_misc0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13f400;
}

static void
Opcode_xsr_misc0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61f400;
}

static void
Opcode_rsr_misc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f500;
}

static void
Opcode_wsr_misc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13f500;
}

static void
Opcode_xsr_misc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61f500;
}

static void
Opcode_rsr_prid_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3eb00;
}

static void
Opcode_rsr_vecbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e700;
}

static void
Opcode_wsr_vecbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e700;
}

static void
Opcode_xsr_vecbase_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61e700;
}

static void
Opcode_salt_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x704000;
}

static void
Opcode_salt_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ca000;
}

static void
Opcode_salt_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x720000;
}

static void
Opcode_saltu_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x705000;
}

static void
Opcode_saltu_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1cb000;
}

static void
Opcode_saltu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x620000;
}

static void
Opcode_rsr_opmode_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x37700;
}

static void
Opcode_wsr_opmode_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x137700;
}

static void
Opcode_xsr_opmode_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x617700;
}

static void
Opcode_rfi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3010;
}

static void
Opcode_waiti_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7000;
}

static void
Opcode_rsr_interrupt_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e200;
}

static void
Opcode_wsr_intset_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e200;
}

static void
Opcode_wsr_intclear_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e300;
}

static void
Opcode_rsr_intenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e400;
}

static void
Opcode_wsr_intenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e400;
}

static void
Opcode_xsr_intenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61e400;
}

static void
Opcode_break_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000;
}

static void
Opcode_break_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf02d;
}

static void
Opcode_rsr_dbreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x39000;
}

static void
Opcode_wsr_dbreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x139000;
}

static void
Opcode_xsr_dbreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x619000;
}

static void
Opcode_rsr_dbreakc0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3a000;
}

static void
Opcode_wsr_dbreakc0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13a000;
}

static void
Opcode_xsr_dbreakc0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61a000;
}

static void
Opcode_rsr_dbreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x39100;
}

static void
Opcode_wsr_dbreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x139100;
}

static void
Opcode_xsr_dbreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x619100;
}

static void
Opcode_rsr_dbreakc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3a100;
}

static void
Opcode_wsr_dbreakc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13a100;
}

static void
Opcode_xsr_dbreakc1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61a100;
}

static void
Opcode_rsr_ibreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x38000;
}

static void
Opcode_wsr_ibreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x138000;
}

static void
Opcode_xsr_ibreaka0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x618000;
}

static void
Opcode_rsr_ibreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x38100;
}

static void
Opcode_wsr_ibreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x138100;
}

static void
Opcode_xsr_ibreaka1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x618100;
}

static void
Opcode_rsr_ibreakenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36000;
}

static void
Opcode_wsr_ibreakenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x136000;
}

static void
Opcode_xsr_ibreakenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x616000;
}

static void
Opcode_rsr_debugcause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e900;
}

static void
Opcode_wsr_debugcause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e900;
}

static void
Opcode_xsr_debugcause_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61e900;
}

static void
Opcode_rsr_icount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3ec00;
}

static void
Opcode_wsr_icount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13ec00;
}

static void
Opcode_xsr_icount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61ec00;
}

static void
Opcode_rsr_icountlevel_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3ed00;
}

static void
Opcode_wsr_icountlevel_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13ed00;
}

static void
Opcode_xsr_icountlevel_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61ed00;
}

static void
Opcode_rsr_ddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36800;
}

static void
Opcode_wsr_ddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x136800;
}

static void
Opcode_xsr_ddr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x616800;
}

static void
Opcode_lddr32_p_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70e0;
}

static void
Opcode_sddr32_p_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70f0;
}

static void
Opcode_rfdo_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf1e000;
}

static void
Opcode_rfdd_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf1e010;
}

static void
Opcode_wsr_mmid_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x135900;
}

static void
Opcode_rsr_ccount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3ea00;
}

static void
Opcode_wsr_ccount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13ea00;
}

static void
Opcode_xsr_ccount_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61ea00;
}

static void
Opcode_rsr_ccompare0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f000;
}

static void
Opcode_wsr_ccompare0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13f000;
}

static void
Opcode_xsr_ccompare0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61f000;
}

static void
Opcode_rsr_ccompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f100;
}

static void
Opcode_wsr_ccompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13f100;
}

static void
Opcode_xsr_ccompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61f100;
}

static void
Opcode_idtlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50c000;
}

static void
Opcode_pdtlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50d000;
}

static void
Opcode_rdtlb0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50b000;
}

static void
Opcode_rdtlb1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50f000;
}

static void
Opcode_wdtlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50e000;
}

static void
Opcode_iitlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x504000;
}

static void
Opcode_pitlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x505000;
}

static void
Opcode_ritlb0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x503000;
}

static void
Opcode_ritlb1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x507000;
}

static void
Opcode_witlb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x506000;
}

static void
Opcode_rsr_cpenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e000;
}

static void
Opcode_wsr_cpenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e000;
}

static void
Opcode_xsr_cpenable_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x61e000;
}

static void
Opcode_clamps_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70c000;
}

static void
Opcode_clamps_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x330000;
}

static void
Opcode_max_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6fb000;
}

static void
Opcode_max_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x530000;
}

static void
Opcode_maxu_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6fc000;
}

static void
Opcode_maxu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x730000;
}

static void
Opcode_min_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6fd000;
}

static void
Opcode_min_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x430000;
}

static void
Opcode_minu_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6fe000;
}

static void
Opcode_minu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x630000;
}

static void
Opcode_nsa_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x731500;
}

static void
Opcode_nsa_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40e000;
}

static void
Opcode_nsau_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x731600;
}

static void
Opcode_nsau_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40f000;
}

static void
Opcode_sext_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70d000;
}

static void
Opcode_sext_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d2000;
}

static void
Opcode_sext_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x230000;
}

static void
Opcode_l32ai_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb002;
}

static void
Opcode_s32ri_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf002;
}

static void
Opcode_s32c1i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe002;
}

static void
Opcode_rsr_scompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30c00;
}

static void
Opcode_wsr_scompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130c00;
}

static void
Opcode_xsr_scompare1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610c00;
}

static void
Opcode_rsr_atomctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x36300;
}

static void
Opcode_wsr_atomctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x136300;
}

static void
Opcode_xsr_atomctl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x616300;
}

static void
Opcode_quos_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd20000;
}

static void
Opcode_quou_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc20000;
}

static void
Opcode_rems_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf20000;
}

static void
Opcode_remu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe20000;
}

static void
Opcode_rsr_eraccess_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x35f00;
}

static void
Opcode_wsr_eraccess_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x135f00;
}

static void
Opcode_xsr_eraccess_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x615f00;
}

static void
Opcode_rer_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x406000;
}

static void
Opcode_wer_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x407000;
}

static void
Opcode_beqz_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb000000;
  slotbuf[1] = 0;
}

static void
Opcode_bgez_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb000001;
  slotbuf[1] = 0;
}

static void
Opcode_bltz_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb000002;
  slotbuf[1] = 0;
}

static void
Opcode_bnez_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb000003;
  slotbuf[1] = 0;
}

static void
Opcode_beqi_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8000000;
  slotbuf[1] = 0;
}

static void
Opcode_bgei_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8800000;
  slotbuf[1] = 0;
}

static void
Opcode_blti_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9800000;
  slotbuf[1] = 0;
}

static void
Opcode_bnei_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa800000;
  slotbuf[1] = 0;
}

static void
Opcode_bgeui_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9000000;
  slotbuf[1] = 0;
}

static void
Opcode_bltui_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa000000;
  slotbuf[1] = 0;
}

static void
Opcode_bbci_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
  slotbuf[1] = 0;
}

static void
Opcode_bbsi_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1000000;
  slotbuf[1] = 0;
}

static void
Opcode_ball_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2000000;
  slotbuf[1] = 0;
}

static void
Opcode_bany_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2800000;
  slotbuf[1] = 0;
}

static void
Opcode_bbc_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3000000;
  slotbuf[1] = 0;
}

static void
Opcode_bbs_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3800000;
  slotbuf[1] = 0;
}

static void
Opcode_beq_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4000000;
  slotbuf[1] = 0;
}

static void
Opcode_bgeu_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4800000;
  slotbuf[1] = 0;
}

static void
Opcode_bge_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5000000;
  slotbuf[1] = 0;
}

static void
Opcode_bltu_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5800000;
  slotbuf[1] = 0;
}

static void
Opcode_blt_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6000000;
  slotbuf[1] = 0;
}

static void
Opcode_bnall_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6800000;
  slotbuf[1] = 0;
}

static void
Opcode_bne_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7000000;
  slotbuf[1] = 0;
}

static void
Opcode_bnone_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7800000;
  slotbuf[1] = 0;
}

static void
Opcode_loop_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb900000;
  slotbuf[1] = 0;
}

static void
Opcode_loop_w15_Slot_f3_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100000;
}

static void
Opcode_loopgtz_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb800000;
  slotbuf[1] = 0;
}

static void
Opcode_loopgtz_w15_Slot_f3_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_loopnez_w15_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb880000;
  slotbuf[1] = 0;
}

static void
Opcode_loopnez_w15_Slot_f3_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80000;
}

static void
Opcode_read_impwire_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0000;
}

static void
Opcode_setb_expstate_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe1000;
}

static void
Opcode_clrb_expstate_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe1200;
}

static void
Opcode_wrmsk_expstate_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe2000;
}

static void
Opcode_rur_expstate_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe30e60;
}

static void
Opcode_wur_expstate_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf3e600;
}

static void
Opcode_rur_ae_bithead_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0f508;
  slotbuf[1] = 0;
}

static void
Opcode_wur_ae_bithead_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7354c0;
}

static void
Opcode_wur_ae_bithead_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x24530d;
}

static void
Opcode_wur_ae_bithead_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1710c0;
}

static void
Opcode_rur_ae_cbegin0_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0cd08;
  slotbuf[1] = 0;
}

static void
Opcode_wur_ae_cbegin0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x161090;
}

static void
Opcode_rur_ae_cend0_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0d908;
  slotbuf[1] = 0;
}

static void
Opcode_wur_ae_cend0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1610d0;
}

static void
Opcode_rur_ae_overflow_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1610c0;
}

static void
Opcode_wur_ae_overflow_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x171050;
}

static void
Opcode_rur_ae_sar_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7350f0;
}

static void
Opcode_rur_ae_sar_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x245309;
}

static void
Opcode_rur_ae_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x171080;
}

static void
Opcode_wur_ae_sar_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7358c0;
}

static void
Opcode_wur_ae_sar_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x24730d;
}

static void
Opcode_wur_ae_sar_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x171090;
}

static void
Opcode_rur_ae_bitptr_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7350e0;
}

static void
Opcode_rur_ae_bitptr_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x24430d;
}

static void
Opcode_rur_ae_bitptr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x161080;
}

static void
Opcode_wur_ae_bitptr_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7354d0;
}

static void
Opcode_wur_ae_bitptr_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x246309;
}

static void
Opcode_wur_ae_bitptr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x161010;
}

static void
Opcode_rur_ae_bitsused_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0c908;
  slotbuf[1] = 0;
}

static void
Opcode_wur_ae_bitsused_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7354e0;
}

static void
Opcode_wur_ae_bitsused_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x24630d;
}

static void
Opcode_wur_ae_bitsused_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x161050;
}

static void
Opcode_rur_ae_tablesize_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0fd08;
  slotbuf[1] = 0;
}

static void
Opcode_wur_ae_tablesize_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0bd02;
  slotbuf[1] = 0;
}

static void
Opcode_rur_ae_first_ts_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0e908;
  slotbuf[1] = 0;
}

static void
Opcode_wur_ae_first_ts_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7354f0;
}

static void
Opcode_wur_ae_first_ts_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x247309;
}

static void
Opcode_wur_ae_first_ts_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x171010;
}

static void
Opcode_rur_ae_nextoffset_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0ed08;
  slotbuf[1] = 0;
}

static void
Opcode_wur_ae_nextoffset_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0bd01;
  slotbuf[1] = 0;
}

static void
Opcode_rur_ae_searchdone_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0f908;
  slotbuf[1] = 0;
}

static void
Opcode_wur_ae_searchdone_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0b902;
  slotbuf[1] = 0;
}

static void
Opcode_rur_ae_cwrap_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0dd08;
  slotbuf[1] = 0;
}

static void
Opcode_wur_ae_cwrap_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0b901;
  slotbuf[1] = 0;
}

static void
Opcode_ae_movcircv_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba72090;
  slotbuf[1] = 0;
}

static void
Opcode_ae_movvcirc_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba72093;
  slotbuf[1] = 0;
}

static void
Opcode_ae_movfusionmiscv_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba72096;
  slotbuf[1] = 0;
}

static void
Opcode_ae_movvfusionmisc_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba72097;
  slotbuf[1] = 0;
}

static void
Opcode_ae_movtablefirstsearchnextv_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba72092;
  slotbuf[1] = 0;
}

static void
Opcode_ae_movvtablefirstsearchnext_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba72095;
  slotbuf[1] = 0;
}

static void
Opcode_ae_l8_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d0000;
}

static void
Opcode_ae_l8_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70000;
}

static void
Opcode_ae_l8_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x666000;
}

static void
Opcode_ae_l8_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x186000;
}

static void
Opcode_ae_l8_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6ce000;
}

static void
Opcode_ae_l8_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x270000;
}

static void
Opcode_ae_l8_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6cf000;
}

static void
Opcode_ae_l8_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x271000;
}

static void
Opcode_ae_l8s_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x180000;
}

static void
Opcode_ae_l8s_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20000;
}

static void
Opcode_ae_l8s_i_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb980000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_l8s_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x64e000;
}

static void
Opcode_ae_l8s_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d6000;
}

static void
Opcode_ae_l8s_ip_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9f0000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_l8u_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x190000;
}

static void
Opcode_ae_l8u_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30000;
}

static void
Opcode_ae_l8u_i_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb990000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_l8u_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x652000;
}

static void
Opcode_ae_l8u_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d8000;
}

static void
Opcode_ae_l8u_ip_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9f2000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_l8x4f_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a0000;
}

static void
Opcode_ae_l8x4f_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40000;
}

static void
Opcode_ae_l8x4f_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x656000;
}

static void
Opcode_ae_l8x4f_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1da000;
}

static void
Opcode_ae_l8x4f_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6c6000;
}

static void
Opcode_ae_l8x4f_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x268000;
}

static void
Opcode_ae_l8x4f_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6c7000;
}

static void
Opcode_ae_l8x4f_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x269000;
}

static void
Opcode_ae_l8x4s_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b0000;
}

static void
Opcode_ae_l8x4s_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50000;
}

static void
Opcode_ae_l8x4s_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x65a000;
}

static void
Opcode_ae_l8x4s_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1dc000;
}

static void
Opcode_ae_l8x4s_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6c8000;
}

static void
Opcode_ae_l8x4s_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x26a000;
}

static void
Opcode_ae_l8x4s_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6c9000;
}

static void
Opcode_ae_l8x4s_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x26b000;
}

static void
Opcode_ae_l8x4u_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c0000;
}

static void
Opcode_ae_l8x4u_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x60000;
}

static void
Opcode_ae_l8x4u_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x65e000;
}

static void
Opcode_ae_l8x4u_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1de000;
}

static void
Opcode_ae_l8x4u_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6ca000;
}

static void
Opcode_ae_l8x4u_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x26c000;
}

static void
Opcode_ae_l8x4u_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6cb000;
}

static void
Opcode_ae_l8x4u_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x26d000;
}

static void
Opcode_ae_l8x8_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5c3000;
}

static void
Opcode_ae_l8x8_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x103000;
}

static void
Opcode_ae_l8x8_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x662000;
}

static void
Opcode_ae_l8x8_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x182000;
}

static void
Opcode_ae_l8x8_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6cc000;
}

static void
Opcode_ae_l8x8_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x26e000;
}

static void
Opcode_ae_l8x8_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6cd000;
}

static void
Opcode_ae_l8x8_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x26f000;
}

static void
Opcode_ae_l8x8_xp_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9fd000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_l16_xc_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x659000;
}

static void
Opcode_ae_l16_xc_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a1000;
}

static void
Opcode_ae_l16_xc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3a0003;
}

static void
Opcode_ae_l16_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x160000;
}

static void
Opcode_ae_l16_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_ae_l16_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80004;
}

static void
Opcode_ae_l16_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5be000;
}

static void
Opcode_ae_l16_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ce000;
}

static void
Opcode_ae_l16_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x880000;
}

static void
Opcode_ae_l16_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x655000;
}

static void
Opcode_ae_l16_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x19d000;
}

static void
Opcode_ae_l16_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2a0003;
}

static void
Opcode_ae_l16_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x65d000;
}

static void
Opcode_ae_l16_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a5000;
}

static void
Opcode_ae_l16_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0003;
}

static void
Opcode_ae_l16m_xc_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x69b000;
}

static void
Opcode_ae_l16m_xc_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1bb000;
}

static void
Opcode_ae_l16m_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x698000;
}

static void
Opcode_ae_l16m_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b6000;
}

static void
Opcode_ae_l16m_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x260003;
}

static void
Opcode_ae_l16m_iu_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x699000;
}

static void
Opcode_ae_l16m_iu_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b7000;
}

static void
Opcode_ae_l16m_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x360003;
}

static void
Opcode_ae_l16m_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x69a000;
}

static void
Opcode_ae_l16m_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ba000;
}

static void
Opcode_ae_l16m_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x270003;
}

static void
Opcode_ae_l16m_xu_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x69c000;
}

static void
Opcode_ae_l16m_xu_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1be000;
}

static void
Opcode_ae_l16m_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x370003;
}

static void
Opcode_ae_l16x2m_xc_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x641000;
}

static void
Opcode_ae_l16x2m_xc_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x189000;
}

static void
Opcode_ae_l16x2m_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x69d000;
}

static void
Opcode_ae_l16x2m_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1bf000;
}

static void
Opcode_ae_l16x2m_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x280003;
}

static void
Opcode_ae_l16x2m_iu_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x69e000;
}

static void
Opcode_ae_l16x2m_iu_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x181000;
}

static void
Opcode_ae_l16x2m_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x380003;
}

static void
Opcode_ae_l16x2m_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x69f000;
}

static void
Opcode_ae_l16x2m_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x185000;
}

static void
Opcode_ae_l16x2m_x_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9f8000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_l16x2m_xu_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x645000;
}

static void
Opcode_ae_l16x2m_xu_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x18d000;
}

static void
Opcode_ae_l16x2m_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x290003;
}

static void
Opcode_ae_l16x4_xc_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x64d000;
}

static void
Opcode_ae_l16x4_xc_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x195000;
}

static void
Opcode_ae_l16x4_xc_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9f9000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_l16x4_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5c0000;
}

static void
Opcode_ae_l16x4_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100000;
}

static void
Opcode_ae_l16x4_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4;
}

static void
Opcode_ae_l16x4_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5bc000;
}

static void
Opcode_ae_l16x4_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1cc000;
}

static void
Opcode_ae_l16x4_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc80000;
}

static void
Opcode_ae_l16x4_rip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a40f0;
}

static void
Opcode_ae_l16x4_rip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e0005;
}

static void
Opcode_ae_l16x4_rip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x430503;
}

static void
Opcode_ae_l16x4_ric_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a40e0;
}

static void
Opcode_ae_l16x4_ric_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e0004;
}

static void
Opcode_ae_l16x4_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x649000;
}

static void
Opcode_ae_l16x4_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x191000;
}

static void
Opcode_ae_l16x4_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x390003;
}

static void
Opcode_ae_l16x4_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x651000;
}

static void
Opcode_ae_l16x4_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x199000;
}

static void
Opcode_ae_l16x4_xp_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9fa000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_l32_xc_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6c1000;
}

static void
Opcode_ae_l32_xc_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x263000;
}

static void
Opcode_ae_l32_xc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e0003;
}

static void
Opcode_ae_l32_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x170000;
}

static void
Opcode_ae_l32_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10000;
}

static void
Opcode_ae_l32_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90004;
}

static void
Opcode_ae_l32_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x646000;
}

static void
Opcode_ae_l32_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d2000;
}

static void
Opcode_ae_l32_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x680000;
}

static void
Opcode_ae_l32_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6c0000;
}

static void
Opcode_ae_l32_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x262000;
}

static void
Opcode_ae_l32_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e0003;
}

static void
Opcode_ae_l32_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6c2000;
}

static void
Opcode_ae_l32_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x264000;
}

static void
Opcode_ae_l32_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2f0003;
}

static void
Opcode_ae_l32m_xc_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x66d000;
}

static void
Opcode_ae_l32m_xc_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b5000;
}

static void
Opcode_ae_l32m_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x661000;
}

static void
Opcode_ae_l32m_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a9000;
}

static void
Opcode_ae_l32m_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3b0003;
}

static void
Opcode_ae_l32m_iu_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x665000;
}

static void
Opcode_ae_l32m_iu_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ad000;
}

static void
Opcode_ae_l32m_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2c0003;
}

static void
Opcode_ae_l32m_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x669000;
}

static void
Opcode_ae_l32m_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b1000;
}

static void
Opcode_ae_l32m_x_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9fb000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_l32m_xu_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x671000;
}

static void
Opcode_ae_l32m_xu_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b9000;
}

static void
Opcode_ae_l32m_xu_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9fc000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_l32x2_xc_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x679000;
}

static void
Opcode_ae_l32x2_xc_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x260000;
}

static void
Opcode_ae_l32x2_xc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d0003;
}

static void
Opcode_ae_l32x2_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5c1000;
}

static void
Opcode_ae_l32x2_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x101000;
}

static void
Opcode_ae_l32x2_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x104;
}

static void
Opcode_ae_l32x2_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x642000;
}

static void
Opcode_ae_l32x2_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d0000;
}

static void
Opcode_ae_l32x2_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x280000;
}

static void
Opcode_ae_l32x2_rip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a10d0;
}

static void
Opcode_ae_l32x2_rip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e0007;
}

static void
Opcode_ae_l32x2_rip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x430703;
}

static void
Opcode_ae_l32x2_ric_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a00d0;
}

static void
Opcode_ae_l32x2_ric_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e0006;
}

static void
Opcode_ae_l32x2_ric_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x430603;
}

static void
Opcode_ae_l32x2_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x675000;
}

static void
Opcode_ae_l32x2_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1bd000;
}

static void
Opcode_ae_l32x2_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3c0003;
}

static void
Opcode_ae_l32x2_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67d000;
}

static void
Opcode_ae_l32x2_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x261000;
}

static void
Opcode_ae_l32x2_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3d0003;
}

static void
Opcode_ae_l64_xc_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6c4000;
}

static void
Opcode_ae_l64_xc_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x266000;
}

static void
Opcode_ae_l64_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5c2000;
}

static void
Opcode_ae_l64_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x102000;
}

static void
Opcode_ae_l64_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x204;
}

static void
Opcode_ae_l64_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x64a000;
}

static void
Opcode_ae_l64_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d4000;
}

static void
Opcode_ae_l64_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa80000;
}

static void
Opcode_ae_l64_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6c3000;
}

static void
Opcode_ae_l64_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x265000;
}

static void
Opcode_ae_l64_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f0003;
}

static void
Opcode_ae_l64_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6c5000;
}

static void
Opcode_ae_l64_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x267000;
}

static void
Opcode_ae_l64_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100003;
}

static void
Opcode_ae_s8_0_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x530000;
}

static void
Opcode_ae_s8_0_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0000;
}

static void
Opcode_ae_s8_0_i_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9a0000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_s8_0_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x688000;
}

static void
Opcode_ae_s8_0_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b2000;
}

static void
Opcode_ae_s8_0_ip_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9f4000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_s8_0_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6f4000;
}

static void
Opcode_ae_s8_0_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x296000;
}

static void
Opcode_ae_s8_0_x_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba62000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_s8_0_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6f5000;
}

static void
Opcode_ae_s8_0_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x297000;
}

static void
Opcode_ae_s8_0_xp_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba63000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_s8x4_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x520000;
}

static void
Opcode_ae_s8x4_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0000;
}

static void
Opcode_ae_s8x4_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x684000;
}

static void
Opcode_ae_s8x4_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1aa000;
}

static void
Opcode_ae_s8x4f_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x510000;
}

static void
Opcode_ae_s8x4f_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb0000;
}

static void
Opcode_ae_s8x4f_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x682000;
}

static void
Opcode_ae_s8x4f_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a6000;
}

static void
Opcode_ae_s8x8_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x640000;
}

static void
Opcode_ae_s8x8_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x180000;
}

static void
Opcode_ae_s8x8_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x686000;
}

static void
Opcode_ae_s8x8_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ae000;
}

static void
Opcode_ae_s8x8_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6f2000;
}

static void
Opcode_ae_s8x8_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x294000;
}

static void
Opcode_ae_s8x8_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6f3000;
}

static void
Opcode_ae_s8x8_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x295000;
}

static void
Opcode_ae_s16_0_xc_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6e0000;
}

static void
Opcode_ae_s16_0_xc_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x282000;
}

static void
Opcode_ae_s16_0_xc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x170003;
}

static void
Opcode_ae_s16_0_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e0000;
}

static void
Opcode_ae_s16_0_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80000;
}

static void
Opcode_ae_s16_0_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0004;
}

static void
Opcode_ae_s16_0_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x672000;
}

static void
Opcode_ae_s16_0_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x192000;
}

static void
Opcode_ae_s16_0_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200003;
}

static void
Opcode_ae_s16_0_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6df000;
}

static void
Opcode_ae_s16_0_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x281000;
}

static void
Opcode_ae_s16_0_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x160003;
}

static void
Opcode_ae_s16_0_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6e1000;
}

static void
Opcode_ae_s16_0_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x283000;
}

static void
Opcode_ae_s16_0_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x180003;
}

static void
Opcode_ae_s16m_l_xc_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6d3000;
}

static void
Opcode_ae_s16m_l_xc_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x275000;
}

static void
Opcode_ae_s16m_l_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6d0000;
}

static void
Opcode_ae_s16m_l_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x272000;
}

static void
Opcode_ae_s16m_l_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110003;
}

static void
Opcode_ae_s16m_l_iu_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6d1000;
}

static void
Opcode_ae_s16m_l_iu_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x273000;
}

static void
Opcode_ae_s16m_l_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x120003;
}

static void
Opcode_ae_s16m_l_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6d2000;
}

static void
Opcode_ae_s16m_l_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x274000;
}

static void
Opcode_ae_s16m_l_x_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9fe000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_s16m_l_xu_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6d4000;
}

static void
Opcode_ae_s16m_l_xu_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x276000;
}

static void
Opcode_ae_s16m_l_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130003;
}

static void
Opcode_ae_s16x2m_xc_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6d8000;
}

static void
Opcode_ae_s16x2m_xc_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x27a000;
}

static void
Opcode_ae_s16x2m_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6d5000;
}

static void
Opcode_ae_s16x2m_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x277000;
}

static void
Opcode_ae_s16x2m_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x140003;
}

static void
Opcode_ae_s16x2m_iu_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6d6000;
}

static void
Opcode_ae_s16x2m_iu_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x278000;
}

static void
Opcode_ae_s16x2m_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x150003;
}

static void
Opcode_ae_s16x2m_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6d7000;
}

static void
Opcode_ae_s16x2m_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x279000;
}

static void
Opcode_ae_s16x2m_x_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9ff000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_s16x2m_xu_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6d9000;
}

static void
Opcode_ae_s16x2m_xu_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x27b000;
}

static void
Opcode_ae_s16x2m_xu_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba60000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_s16x4_xc_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6dd000;
}

static void
Opcode_ae_s16x4_xc_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x27f000;
}

static void
Opcode_ae_s16x4_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x601000;
}

static void
Opcode_ae_s16x4_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x141000;
}

static void
Opcode_ae_s16x4_i_Slot_f3_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x190000;
}

static void
Opcode_ae_s16x4_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x304;
}

static void
Opcode_ae_s16x4_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x66e000;
}

static void
Opcode_ae_s16x4_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x18e000;
}

static void
Opcode_ae_s16x4_ip_Slot_f3_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a2000;
}

static void
Opcode_ae_s16x4_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe80000;
}

static void
Opcode_ae_s16x4_rip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a30d0;
}

static void
Opcode_ae_s16x4_rip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x245005;
}

static void
Opcode_ae_s16x4_ric_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a20d0;
}

static void
Opcode_ae_s16x4_ric_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x244005;
}

static void
Opcode_ae_s16x4_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6dc000;
}

static void
Opcode_ae_s16x4_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x27e000;
}

static void
Opcode_ae_s16x4_x_Slot_f3_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a8000;
}

static void
Opcode_ae_s16x4_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6de000;
}

static void
Opcode_ae_s16x4_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x280000;
}

static void
Opcode_ae_s16x4_xp_Slot_f3_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a9000;
}

static void
Opcode_ae_s16x4rng_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x600000;
}

static void
Opcode_ae_s16x4rng_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x140000;
}

static void
Opcode_ae_s16x4rng_i_Slot_f3_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x180000;
}

static void
Opcode_ae_s16x4rng_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x66a000;
}

static void
Opcode_ae_s16x4rng_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x18a000;
}

static void
Opcode_ae_s16x4rng_ip_Slot_f3_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a0000;
}

static void
Opcode_ae_s16x4rng_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6da000;
}

static void
Opcode_ae_s16x4rng_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x27c000;
}

static void
Opcode_ae_s16x4rng_x_Slot_f3_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a6000;
}

static void
Opcode_ae_s16x4rng_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6db000;
}

static void
Opcode_ae_s16x4rng_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x27d000;
}

static void
Opcode_ae_s16x4rng_xp_Slot_f3_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a7000;
}

static void
Opcode_ae_s32_l_xc_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6ed000;
}

static void
Opcode_ae_s32_l_xc_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x28f000;
}

static void
Opcode_ae_s32_l_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x500000;
}

static void
Opcode_ae_s32_l_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0000;
}

static void
Opcode_ae_s32_l_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb0004;
}

static void
Opcode_ae_s32_l_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67e000;
}

static void
Opcode_ae_s32_l_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x19e000;
}

static void
Opcode_ae_s32_l_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x220003;
}

static void
Opcode_ae_s32_l_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6ec000;
}

static void
Opcode_ae_s32_l_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x28e000;
}

static void
Opcode_ae_s32_l_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f0003;
}

static void
Opcode_ae_s32_l_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6ee000;
}

static void
Opcode_ae_s32_l_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x290000;
}

static void
Opcode_ae_s32_l_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0004;
}

static void
Opcode_ae_s32_h_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f0000;
}

static void
Opcode_ae_s32_h_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90000;
}

static void
Opcode_ae_s32_h_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67a000;
}

static void
Opcode_ae_s32_h_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x19a000;
}

static void
Opcode_ae_s32_h_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6ea000;
}

static void
Opcode_ae_s32_h_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x28c000;
}

static void
Opcode_ae_s32_h_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6eb000;
}

static void
Opcode_ae_s32_h_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x28d000;
}

static void
Opcode_ae_s32m_xc_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6e5000;
}

static void
Opcode_ae_s32m_xc_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x287000;
}

static void
Opcode_ae_s32m_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6e2000;
}

static void
Opcode_ae_s32m_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x284000;
}

static void
Opcode_ae_s32m_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x190003;
}

static void
Opcode_ae_s32m_iu_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6e3000;
}

static void
Opcode_ae_s32m_iu_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x285000;
}

static void
Opcode_ae_s32m_iu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a0003;
}

static void
Opcode_ae_s32m_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6e4000;
}

static void
Opcode_ae_s32m_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x286000;
}

static void
Opcode_ae_s32m_x_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba61000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_s32m_xu_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6e6000;
}

static void
Opcode_ae_s32m_xu_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x288000;
}

static void
Opcode_ae_s32m_xu_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b0003;
}

static void
Opcode_ae_s32x2_xc_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6e8000;
}

static void
Opcode_ae_s32x2_xc_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x28a000;
}

static void
Opcode_ae_s32x2_xc_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d0003;
}

static void
Opcode_ae_s32x2_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x602000;
}

static void
Opcode_ae_s32x2_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x142000;
}

static void
Opcode_ae_s32x2_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40004;
}

static void
Opcode_ae_s32x2_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x676000;
}

static void
Opcode_ae_s32x2_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x196000;
}

static void
Opcode_ae_s32x2_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x210003;
}

static void
Opcode_ae_s32x2_rip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a5090;
}

static void
Opcode_ae_s32x2_rip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x247005;
}

static void
Opcode_ae_s32x2_rip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40304;
}

static void
Opcode_ae_s32x2_ric_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a5080;
}

static void
Opcode_ae_s32x2_ric_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x246005;
}

static void
Opcode_ae_s32x2_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6e7000;
}

static void
Opcode_ae_s32x2_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x289000;
}

static void
Opcode_ae_s32x2_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c0003;
}

static void
Opcode_ae_s32x2_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6e9000;
}

static void
Opcode_ae_s32x2_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x28b000;
}

static void
Opcode_ae_s32x2_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e0003;
}

static void
Opcode_ae_s64_xc_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6f0000;
}

static void
Opcode_ae_s64_xc_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x292000;
}

static void
Opcode_ae_s64_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x603000;
}

static void
Opcode_ae_s64_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x143000;
}

static void
Opcode_ae_s64_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40104;
}

static void
Opcode_ae_s64_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x680000;
}

static void
Opcode_ae_s64_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a2000;
}

static void
Opcode_ae_s64_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x230003;
}

static void
Opcode_ae_s64_x_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6ef000;
}

static void
Opcode_ae_s64_x_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x291000;
}

static void
Opcode_ae_s64_x_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e0004;
}

static void
Opcode_ae_s64_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6f1000;
}

static void
Opcode_ae_s64_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x293000;
}

static void
Opcode_ae_s64_xp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e0004;
}

static void
Opcode_ae_zalign64_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x420d14;
}

static void
Opcode_ae_zalign64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc7440;
}

static void
Opcode_ae_lalign64_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400500;
}

static void
Opcode_ae_lalign64_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200000;
}

static void
Opcode_ae_lalign64_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc3000;
}

static void
Opcode_ae_salign64_i_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x440500;
}

static void
Opcode_ae_salign64_i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200100;
}

static void
Opcode_ae_salign64_i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3002;
}

static void
Opcode_ae_movalign_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x420d10;
}

static void
Opcode_ae_movalign_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc7400;
}

static void
Opcode_ae_la64_pp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x410d10;
}

static void
Opcode_ae_la64_pp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x372800;
}

static void
Opcode_ae_la32x2pos_pc_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40cd10;
}

static void
Opcode_ae_la32x2pos_pc_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x24410d;
}

static void
Opcode_ae_la32x2pos_pc_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0c108;
  slotbuf[1] = 0;
}

static void
Opcode_ae_la32x2neg_pc_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x408d10;
}

static void
Opcode_ae_la32x2neg_pc_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x244109;
}

static void
Opcode_ae_la16x4pos_pc_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x404d10;
}

static void
Opcode_ae_la16x4pos_pc_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x24400d;
}

static void
Opcode_ae_la16x4neg_pc_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400d10;
}

static void
Opcode_ae_la16x4neg_pc_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x244009;
}

static void
Opcode_ae_la32x2_ic_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a8060;
}

static void
Opcode_ae_la32x2_ic_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x248008;
}

static void
Opcode_ae_la32x2_ic_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x620403;
}

static void
Opcode_ae_la32x2_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a8070;
}

static void
Opcode_ae_la32x2_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x24800c;
}

static void
Opcode_ae_la32x2_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x620803;
}

static void
Opcode_ae_la32x2_rip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6ac070;
}

static void
Opcode_ae_la32x2_rip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x24c00c;
}

static void
Opcode_ae_la32x2_rip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x620c03;
}

static void
Opcode_ae_la32x2_ric_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6ac060;
}

static void
Opcode_ae_la32x2_ric_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x24c008;
}

static void
Opcode_ae_la16x4_ic_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a0060;
}

static void
Opcode_ae_la16x4_ic_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x240008;
}

static void
Opcode_ae_la16x4_ic_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba40002;
  slotbuf[1] = 0;
}

static void
Opcode_ae_la16x4_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a0070;
}

static void
Opcode_ae_la16x4_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x24000c;
}

static void
Opcode_ae_la16x4_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x620003;
}

static void
Opcode_ae_la16x4_rip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a4070;
}

static void
Opcode_ae_la16x4_rip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x24400c;
}

static void
Opcode_ae_la16x4_rip_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba40003;
  slotbuf[1] = 0;
}

static void
Opcode_ae_la16x4_ric_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a4060;
}

static void
Opcode_ae_la16x4_ric_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x244008;
}

static void
Opcode_ae_la8x8_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6b4060;
}

static void
Opcode_ae_la8x8_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x254008;
}

static void
Opcode_ae_la8x8_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x720003;
}

static void
Opcode_ae_addbrba32_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x72d000;
}

static void
Opcode_ae_addbrba32_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e4000;
}

static void
Opcode_ae_addbrba32_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d2000;
}

static void
Opcode_ae_addbrba32_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x120000;
}

static void
Opcode_ae_addbrba32_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba6f000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_addbrba32_Slot_f3_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1aa000;
}

static void
Opcode_ae_sel16i_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50000;
}

static void
Opcode_ae_sel16i_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0000;
}

static void
Opcode_ae_sel16i_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x60000;
}

static void
Opcode_ae_sel16i_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3;
}

static void
Opcode_ae_shortswap_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73200e;
}

static void
Opcode_ae_shortswap_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f3700;
}

static void
Opcode_ae_shortswap_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e4200;
}

static void
Opcode_ae_shortswap_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110300;
}

static void
Opcode_ae_intswap_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x732008;
}

static void
Opcode_ae_intswap_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f3100;
}

static void
Opcode_ae_intswap_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e1c00;
}

static void
Opcode_ae_intswap_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1101b0;
}

static void
Opcode_ae_intswap_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc5000;
}

static void
Opcode_ae_movt16x4_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ef008;
}

static void
Opcode_ae_movt16x4_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e0080;
}

static void
Opcode_ae_movt16x4_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf00f0;
}

static void
Opcode_ae_movt16x4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x420003;
}

static void
Opcode_ae_movf16x4_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ed008;
}

static void
Opcode_ae_movf16x4_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2de080;
}

static void
Opcode_ae_movf16x4_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf00d0;
}

static void
Opcode_ae_movf16x4_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba29080;
  slotbuf[1] = 0;
}

static void
Opcode_ae_movt32x2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f0000;
}

static void
Opcode_ae_movt32x2_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e1080;
}

static void
Opcode_ae_movt32x2_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf80f0;
}

static void
Opcode_ae_movt32x2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x428003;
}

static void
Opcode_ae_movf32x2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ee000;
}

static void
Opcode_ae_movf32x2_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2df000;
}

static void
Opcode_ae_movf32x2_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf80d0;
}

static void
Opcode_ae_movf32x2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x718003;
}

static void
Opcode_ae_movda32x2_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x728000;
}

static void
Opcode_ae_movda32x2_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d1000;
}

static void
Opcode_ae_movda32x2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x600003;
}

static void
Opcode_ae_movda32_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a70c0;
}

static void
Opcode_ae_movda32_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e000d;
}

static void
Opcode_ae_movda32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x540304;
}

static void
Opcode_ae_movda16x2_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x727000;
}

static void
Opcode_ae_movda16x2_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d0000;
}

static void
Opcode_ae_movda16x2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x500003;
}

static void
Opcode_ae_movda16_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a70b0;
}

static void
Opcode_ae_movda16_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e0009;
}

static void
Opcode_ae_movda16_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x440304;
}

static void
Opcode_ae_movi_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x720000;
}

static void
Opcode_ae_movi_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d5000;
}

static void
Opcode_ae_movi_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2c1000;
}

static void
Opcode_ae_movi_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf0040;
}

static void
Opcode_ae_movi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xaf0004;
}

static void
Opcode_ae_movi16x4_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x721000;
}

static void
Opcode_ae_movi16x4_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d6000;
}

static void
Opcode_ae_movi16x4_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2c2000;
}

static void
Opcode_ae_movi16x4_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf0050;
}

static void
Opcode_ae_movi16x4_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba6e000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_sat16x4_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1af000;
}

static void
Opcode_ae_sat16x4_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b2000;
}

static void
Opcode_ae_sat8s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f2800;
}

static void
Opcode_ae_sat8s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e1400;
}

static void
Opcode_ae_sat8u_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f2900;
}

static void
Opcode_ae_sat8u_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e1500;
}

static void
Opcode_ae_cvt32x2f16_32_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x732006;
}

static void
Opcode_ae_cvt32x2f16_32_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f2f00;
}

static void
Opcode_ae_cvt32x2f16_32_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e1a00;
}

static void
Opcode_ae_cvt32x2f16_32_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1101a0;
}

static void
Opcode_ae_cvt32x2f16_32_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba710a0;
  slotbuf[1] = 0;
}

static void
Opcode_ae_cvt32x2f16_10_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x732005;
}

static void
Opcode_ae_cvt32x2f16_10_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f2e00;
}

static void
Opcode_ae_cvt32x2f16_10_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e1900;
}

static void
Opcode_ae_cvt32x2f16_10_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110190;
}

static void
Opcode_ae_cvt32x2f16_10_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0000;
}

static void
Opcode_ae_sext32x2d16_32_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73200b;
}

static void
Opcode_ae_sext32x2d16_32_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f3400;
}

static void
Opcode_ae_sext32x2d16_32_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e1f00;
}

static void
Opcode_ae_sext32x2d16_32_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1101e0;
}

static void
Opcode_ae_sext32x2d16_32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d5000;
}

static void
Opcode_ae_sext32x2d16_10_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73200a;
}

static void
Opcode_ae_sext32x2d16_10_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f3300;
}

static void
Opcode_ae_sext32x2d16_10_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e1e00;
}

static void
Opcode_ae_sext32x2d16_10_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1101d0;
}

static void
Opcode_ae_sext32x2d16_10_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd5000;
}

static void
Opcode_ae_sext32x2d24_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73200c;
}

static void
Opcode_ae_sext32x2d24_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f3500;
}

static void
Opcode_ae_sext32x2d24_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e4000;
}

static void
Opcode_ae_sext32x2d24_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1101f0;
}

static void
Opcode_ae_sext32x2d24_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x263000;
}

static void
Opcode_ae_sext64q56_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73200d;
}

static void
Opcode_ae_sext64q56_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f3600;
}

static void
Opcode_ae_sext64q56_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e4100;
}

static void
Opcode_ae_sext64q56_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110200;
}

static void
Opcode_ae_sext64q56_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x363000;
}

static void
Opcode_ae_cvtp24a16x2_ll_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x726000;
}

static void
Opcode_ae_cvtp24a16x2_ll_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2cf000;
}

static void
Opcode_ae_cvtp24a16x2_ll_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xff0004;
}

static void
Opcode_ae_cvtp24a16x2_lh_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x725000;
}

static void
Opcode_ae_cvtp24a16x2_lh_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2ce000;
}

static void
Opcode_ae_cvtp24a16x2_hl_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x724000;
}

static void
Opcode_ae_cvtp24a16x2_hl_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2cd000;
}

static void
Opcode_ae_cvtp24a16x2_hl_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xef0004;
}

static void
Opcode_ae_cvtp24a16x2_hh_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x723000;
}

static void
Opcode_ae_cvtp24a16x2_hh_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2cc000;
}

static void
Opcode_ae_truncp24q48x2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1da000;
}

static void
Opcode_ae_truncp24q48x2_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2c6000;
}

static void
Opcode_ae_truncp24q48x2_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf0090;
}

static void
Opcode_ae_truncp24q48x2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf0004;
}

static void
Opcode_ae_trunca32x2f64s_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10000;
}

static void
Opcode_ae_trunca32x2f64s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0004;
}

static void
Opcode_ae_trunci32x2f64s_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x50000;
}

static void
Opcode_ae_trunci32x2f64s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0004;
}

static void
Opcode_ae_truncav32x2f64s_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x20000;
}

static void
Opcode_ae_trunci16x4f32s_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x30000;
}

static void
Opcode_ae_trunci16x4f32s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9c0000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_trunca32f64s_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_ae_trunca32f64s_l_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9b0000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_trunci32f64s_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40000;
}

static void
Opcode_ae_trunci32f64s_l_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9d0000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_truncp16_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f3800;
}

static void
Opcode_ae_truncp16_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e4300;
}

static void
Opcode_ae_truncp16_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110210;
}

static void
Opcode_ae_truncp16_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x273000;
}

static void
Opcode_ae_round32x2f64ssym_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ac000;
}

static void
Opcode_ae_round32x2f64ssym_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2af000;
}

static void
Opcode_ae_round32x2f64sasym_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ab000;
}

static void
Opcode_ae_round32x2f64sasym_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2ae000;
}

static void
Opcode_ae_round32x2f64sasym_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba66000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_round32x2f48ssym_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1aa000;
}

static void
Opcode_ae_round32x2f48ssym_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2ad000;
}

static void
Opcode_ae_round32x2f48sasym_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a9000;
}

static void
Opcode_ae_round32x2f48sasym_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2ac000;
}

static void
Opcode_ae_round16x4f32ssym_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a6000;
}

static void
Opcode_ae_round16x4f32ssym_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2a9000;
}

static void
Opcode_ae_round16x4f32sasym_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a5000;
}

static void
Opcode_ae_round16x4f32sasym_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2a8000;
}

static void
Opcode_ae_round16x4f32sasym_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xee0004;
}

static void
Opcode_ae_round24x2f48ssym_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a8000;
}

static void
Opcode_ae_round24x2f48ssym_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2ab000;
}

static void
Opcode_ae_round24x2f48ssym_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf0004;
}

static void
Opcode_ae_round24x2f48sasym_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a7000;
}

static void
Opcode_ae_round24x2f48sasym_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2aa000;
}

static void
Opcode_ae_round24x2f48sasym_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfe0004;
}

static void
Opcode_ae_roundsp16q48x2sym_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ae000;
}

static void
Opcode_ae_roundsp16q48x2sym_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b1000;
}

static void
Opcode_ae_roundsp16q48x2asym_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ad000;
}

static void
Opcode_ae_roundsp16q48x2asym_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b0000;
}

static void
Opcode_ae_roundsp16q48x2asym_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f0004;
}

static void
Opcode_ae_mov_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x732009;
}

static void
Opcode_ae_mov_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f3200;
}

static void
Opcode_ae_mov_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e1d00;
}

static void
Opcode_ae_mov_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1101c0;
}

static void
Opcode_ae_mov_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c5000;
}

static void
Opcode_ae_movt64_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f0008;
}

static void
Opcode_ae_movt64_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e2080;
}

static void
Opcode_ae_movt64_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x128000;
}

static void
Opcode_ae_movt64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x520003;
}

static void
Opcode_ae_movf64_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ee008;
}

static void
Opcode_ae_movf64_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2df080;
}

static void
Opcode_ae_movf64_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf00e0;
}

static void
Opcode_ae_movf64_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba2a080;
  slotbuf[1] = 0;
}

static void
Opcode_ae_cvt48a32_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a7090;
}

static void
Opcode_ae_cvt48a32_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e0008;
}

static void
Opcode_ae_cvt48a32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x140304;
}

static void
Opcode_ae_cvt64a32_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a70a0;
}

static void
Opcode_ae_cvt64a32_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e000c;
}

static void
Opcode_ae_cvt64a32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x240304;
}

static void
Opcode_ae_cvt64f32_h_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x732007;
}

static void
Opcode_ae_cvt64f32_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f3000;
}

static void
Opcode_ae_cvt64f32_h_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e1b00;
}

static void
Opcode_ae_cvt64f32_h_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d0000;
}

static void
Opcode_ae_sat48s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f2700;
}

static void
Opcode_ae_sat48s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e1300;
}

static void
Opcode_ae_sat48s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0000;
}

static void
Opcode_ae_satq56s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f2a00;
}

static void
Opcode_ae_satq56s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e1600;
}

static void
Opcode_ae_satq56s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c0000;
}

static void
Opcode_ae_sat24s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f2600;
}

static void
Opcode_ae_sat24s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e1200;
}

static void
Opcode_ae_sat24s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d4000;
}

static void
Opcode_ae_truncq32_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f3900;
}

static void
Opcode_ae_truncq32_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e4400;
}

static void
Opcode_ae_truncq32_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110310;
}

static void
Opcode_ae_truncq32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x373000;
}

static void
Opcode_ae_roundsq32f48sym_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f2500;
}

static void
Opcode_ae_roundsq32f48sym_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e1100;
}

static void
Opcode_ae_roundsq32f48sym_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba70a00;
  slotbuf[1] = 0;
}

static void
Opcode_ae_roundsq32f48asym_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f2400;
}

static void
Opcode_ae_roundsq32f48asym_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e1000;
}

static void
Opcode_ae_roundsq32f48asym_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba70d00;
  slotbuf[1] = 0;
}

static void
Opcode_ae_trunca32q48_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73300d;
}

static void
Opcode_ae_trunca32q48_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e5400;
}

static void
Opcode_ae_trunca32q48_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d2000;
}

static void
Opcode_ae_movad32_l_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x733007;
}

static void
Opcode_ae_movad32_l_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e4e00;
}

static void
Opcode_ae_movad32_l_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x371000;
}

static void
Opcode_ae_movad32_h_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x733006;
}

static void
Opcode_ae_movad32_h_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e4d00;
}

static void
Opcode_ae_movad32_h_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x271000;
}

static void
Opcode_ae_movad16_3_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x733005;
}

static void
Opcode_ae_movad16_3_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e4c00;
}

static void
Opcode_ae_movad16_3_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0a100;
  slotbuf[1] = 0;
}

static void
Opcode_ae_movad16_2_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x733004;
}

static void
Opcode_ae_movad16_2_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e4b00;
}

static void
Opcode_ae_movad16_2_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba70f00;
  slotbuf[1] = 0;
}

static void
Opcode_ae_movad16_1_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x733003;
}

static void
Opcode_ae_movad16_1_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e4a00;
}

static void
Opcode_ae_movad16_1_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba70b00;
  slotbuf[1] = 0;
}

static void
Opcode_ae_movad16_0_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x733002;
}

static void
Opcode_ae_movad16_0_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e4900;
}

static void
Opcode_ae_movad16_0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x361000;
}

static void
Opcode_ae_sra64_32_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x715000;
}

static void
Opcode_ae_sra64_32_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100600;
}

static void
Opcode_ae_pksr32_0_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x730004;
}

static void
Opcode_ae_pksr24_0_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x730000;
}

static void
Opcode_ae_add32_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x197000;
}

static void
Opcode_ae_add32_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x29a000;
}

static void
Opcode_ae_add32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5e0004;
}

static void
Opcode_ae_sub32_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b5000;
}

static void
Opcode_ae_sub32_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b5000;
}

static void
Opcode_ae_sub32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3f0004;
}

static void
Opcode_ae_addsub32_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x19c000;
}

static void
Opcode_ae_addsub32_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x29f000;
}

static void
Opcode_ae_subadd32_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b9000;
}

static void
Opcode_ae_subadd32_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b9000;
}

static void
Opcode_ae_subadd32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7f0004;
}

static void
Opcode_ae_add16_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x195000;
}

static void
Opcode_ae_add16_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x298000;
}

static void
Opcode_ae_add16_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x3e0004;
}

static void
Opcode_ae_sub16_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b3000;
}

static void
Opcode_ae_sub16_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b3000;
}

static void
Opcode_ae_add32_hl_lh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x199000;
}

static void
Opcode_ae_add32_hl_lh_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x29c000;
}

static void
Opcode_ae_add32_hl_lh_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7e0004;
}

static void
Opcode_ae_neg32_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f2000;
}

static void
Opcode_ae_neg32_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e3c00;
}

static void
Opcode_ae_neg32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d1000;
}

static void
Opcode_ae_abs32_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f1700;
}

static void
Opcode_ae_abs32_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e2b00;
}

static void
Opcode_ae_abs32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc1000;
}

static void
Opcode_ae_add32s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x198000;
}

static void
Opcode_ae_add32s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x29b000;
}

static void
Opcode_ae_add32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6e0004;
}

static void
Opcode_ae_sub32s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b6000;
}

static void
Opcode_ae_sub32s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b6000;
}

static void
Opcode_ae_sub32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4f0004;
}

static void
Opcode_ae_addsub32s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x19d000;
}

static void
Opcode_ae_addsub32s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2a0000;
}

static void
Opcode_ae_addsub32s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba64000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_subadd32s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ba000;
}

static void
Opcode_ae_subadd32s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2ba000;
}

static void
Opcode_ae_add16s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x196000;
}

static void
Opcode_ae_add16s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x299000;
}

static void
Opcode_ae_add16s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4e0004;
}

static void
Opcode_ae_sub16s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b4000;
}

static void
Opcode_ae_sub16s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b4000;
}

static void
Opcode_ae_sub16s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2f0004;
}

static void
Opcode_ae_addsub32s_hl_lh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x19e000;
}

static void
Opcode_ae_addsub32s_hl_lh_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2a1000;
}

static void
Opcode_ae_subadd32s_hl_lh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1bb000;
}

static void
Opcode_ae_subadd32s_hl_lh_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2bb000;
}

static void
Opcode_ae_neg32s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f2100;
}

static void
Opcode_ae_neg32s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e3d00;
}

static void
Opcode_ae_neg32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc4000;
}

static void
Opcode_ae_abs32s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f1800;
}

static void
Opcode_ae_abs32s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e2c00;
}

static void
Opcode_ae_abs32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c1000;
}

static void
Opcode_ae_neg16s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f1f00;
}

static void
Opcode_ae_neg16s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e3b00;
}

static void
Opcode_ae_neg16s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba70900;
  slotbuf[1] = 0;
}

static void
Opcode_ae_abs16s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f1600;
}

static void
Opcode_ae_abs16s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e2a00;
}

static void
Opcode_ae_abs16s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x172000;
}

static void
Opcode_ae_conj16s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f1b00;
}

static void
Opcode_ae_conj16s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e2f00;
}

static void
Opcode_ae_mulc16js_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xeb000;
}

static void
Opcode_ae_mulc16js_h_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0000;
}

static void
Opcode_ae_mulc16js_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xec000;
}

static void
Opcode_ae_mulc16js_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0010;
}

static void
Opcode_ae_mulac16js_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa6000;
}

static void
Opcode_ae_mulac16js_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa7000;
}

static void
Opcode_ae_lt16_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e8000;
}

static void
Opcode_ae_lt16_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d9000;
}

static void
Opcode_ae_lt16_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x410083;
}

static void
Opcode_ae_le16_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e6008;
}

static void
Opcode_ae_le16_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d7080;
}

static void
Opcode_ae_le16_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700083;
}

static void
Opcode_ae_eq16_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e5000;
}

static void
Opcode_ae_eq16_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d6000;
}

static void
Opcode_ae_eq16_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba20080;
  slotbuf[1] = 0;
}

static void
Opcode_ae_lt32_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e8008;
}

static void
Opcode_ae_lt32_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d9080;
}

static void
Opcode_ae_lt32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x510003;
}

static void
Opcode_ae_le32_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e7000;
}

static void
Opcode_ae_le32_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d8000;
}

static void
Opcode_ae_le32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x410003;
}

static void
Opcode_ae_eq32_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e5008;
}

static void
Opcode_ae_eq32_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d6080;
}

static void
Opcode_ae_eq32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700003;
}

static void
Opcode_ae_min32_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a3000;
}

static void
Opcode_ae_min32_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2a6000;
}

static void
Opcode_ae_min32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce0004;
}

static void
Opcode_ae_max32_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a0000;
}

static void
Opcode_ae_max32_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2a3000;
}

static void
Opcode_ae_max32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbe0004;
}

static void
Opcode_ae_min16_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a2000;
}

static void
Opcode_ae_min16_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2a5000;
}

static void
Opcode_ae_min16_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba65000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_max16_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x19f000;
}

static void
Opcode_ae_max16_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2a2000;
}

static void
Opcode_ae_max16_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xae0004;
}

static void
Opcode_ae_add64_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x19a000;
}

static void
Opcode_ae_add64_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x29d000;
}

static void
Opcode_ae_add64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8e0004;
}

static void
Opcode_ae_sub64_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b7000;
}

static void
Opcode_ae_sub64_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b7000;
}

static void
Opcode_ae_sub64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5f0004;
}

static void
Opcode_ae_neg64_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f2200;
}

static void
Opcode_ae_neg64_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e3e00;
}

static void
Opcode_ae_neg64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c4000;
}

static void
Opcode_ae_abs64_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f1900;
}

static void
Opcode_ae_abs64_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e2d00;
}

static void
Opcode_ae_abs64_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba70c00;
  slotbuf[1] = 0;
}

static void
Opcode_ae_add64s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x19b000;
}

static void
Opcode_ae_add64s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x29e000;
}

static void
Opcode_ae_add64s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9e0004;
}

static void
Opcode_ae_sub64s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b8000;
}

static void
Opcode_ae_sub64s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2b8000;
}

static void
Opcode_ae_sub64s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6f0004;
}

static void
Opcode_ae_neg64s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f2300;
}

static void
Opcode_ae_neg64s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e3f00;
}

static void
Opcode_ae_neg64s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd4000;
}

static void
Opcode_ae_abs64s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f1a00;
}

static void
Opcode_ae_abs64s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e2e00;
}

static void
Opcode_ae_and_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d4000;
}

static void
Opcode_ae_and_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2c0000;
}

static void
Opcode_ae_and_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf0030;
}

static void
Opcode_ae_and_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9f0004;
}

static void
Opcode_ae_nand_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d7000;
}

static void
Opcode_ae_nand_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2c3000;
}

static void
Opcode_ae_nand_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf0060;
}

static void
Opcode_ae_or_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d8000;
}

static void
Opcode_ae_or_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2c4000;
}

static void
Opcode_ae_or_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf0070;
}

static void
Opcode_ae_or_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbf0004;
}

static void
Opcode_ae_xor_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1db000;
}

static void
Opcode_ae_xor_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2c7000;
}

static void
Opcode_ae_xor_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf00a0;
}

static void
Opcode_ae_xor_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdf0004;
}

static void
Opcode_ae_srai16_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x71c000;
}

static void
Opcode_ae_srai16_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100d00;
}

static void
Opcode_ae_srai16_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba10c00;
  slotbuf[1] = 0;
}

static void
Opcode_ae_srai16r_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x71d000;
}

static void
Opcode_ae_srai16r_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100e00;
}

static void
Opcode_ae_slai32_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x68e000;
}

static void
Opcode_ae_slai32_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80080;
}

static void
Opcode_ae_slai32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x60000;
}

static void
Opcode_ae_srli32_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x696000;
}

static void
Opcode_ae_srli32_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90000;
}

static void
Opcode_ae_srli32_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba30020;
  slotbuf[1] = 0;
}

static void
Opcode_ae_srai32_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x692000;
}

static void
Opcode_ae_srai32_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800c0;
}

static void
Opcode_ae_srai32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x67000;
}

static void
Opcode_ae_srai32r_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x694000;
}

static void
Opcode_ae_srai32r_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800e0;
}

static void
Opcode_ae_srai32r_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba20020;
  slotbuf[1] = 0;
}

static void
Opcode_ae_slas32_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73000c;
}

static void
Opcode_ae_slas32_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110100;
}

static void
Opcode_ae_slas32_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba10100;
  slotbuf[1] = 0;
}

static void
Opcode_ae_srls32_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x732002;
}

static void
Opcode_ae_srls32_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110160;
}

static void
Opcode_ae_sras32_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x732000;
}

static void
Opcode_ae_sras32_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110140;
}

static void
Opcode_ae_sras32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa8302;
}

static void
Opcode_ae_slaa32_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x710000;
}

static void
Opcode_ae_slaa32_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100100;
}

static void
Opcode_ae_slaa32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x65000;
}

static void
Opcode_ae_srla32_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x71e000;
}

static void
Opcode_ae_srla32_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100f00;
}

static void
Opcode_ae_srla32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x88002;
}

static void
Opcode_ae_sraa32_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x718000;
}

static void
Opcode_ae_sraa32_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100900;
}

static void
Opcode_ae_sraa32_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x68002;
}

static void
Opcode_ae_slai16s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x714000;
}

static void
Opcode_ae_slai16s_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100500;
}

static void
Opcode_ae_slai16s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x48002;
}

static void
Opcode_ae_slaa16s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70f000;
}

static void
Opcode_ae_slaa16s_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100000;
}

static void
Opcode_ae_slaa16s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x64000;
}

static void
Opcode_ae_sraa16s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x717000;
}

static void
Opcode_ae_sraa16s_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100800;
}

static void
Opcode_ae_sraa16s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x58002;
}

static void
Opcode_ae_sraa16rs_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x716000;
}

static void
Opcode_ae_sraa16rs_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100700;
}

static void
Opcode_ae_slai32s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x690000;
}

static void
Opcode_ae_slai32s_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800a0;
}

static void
Opcode_ae_slai32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x66000;
}

static void
Opcode_ae_slas32s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73000d;
}

static void
Opcode_ae_slas32s_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110110;
}

static void
Opcode_ae_slas32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa8002;
}

static void
Opcode_ae_slaa32s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x711000;
}

static void
Opcode_ae_slaa32s_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100200;
}

static void
Opcode_ae_slaa32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x74000;
}

static void
Opcode_ae_sraa32s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x71a000;
}

static void
Opcode_ae_sraa32s_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100b00;
}

static void
Opcode_ae_sraa32s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x78002;
}

static void
Opcode_ae_sraa32rs_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x719000;
}

static void
Opcode_ae_sraa32rs_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100a00;
}

static void
Opcode_ae_sraa32rs_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba00c00;
  slotbuf[1] = 0;
}

static void
Opcode_ae_slai64_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5ac000;
}

static void
Opcode_ae_slai64_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70080;
}

static void
Opcode_ae_slai64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x43002;
}

static void
Opcode_ae_srli64_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5b8000;
}

static void
Opcode_ae_srli64_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80040;
}

static void
Opcode_ae_srli64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8002;
}

static void
Opcode_ae_srai64_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5b4000;
}

static void
Opcode_ae_srai64_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80000;
}

static void
Opcode_ae_srai64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc3002;
}

static void
Opcode_ae_slas64_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73000e;
}

static void
Opcode_ae_slas64_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110120;
}

static void
Opcode_ae_slas64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa8102;
}

static void
Opcode_ae_srls64_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x732003;
}

static void
Opcode_ae_srls64_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110170;
}

static void
Opcode_ae_srls64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa8502;
}

static void
Opcode_ae_sras64_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x732001;
}

static void
Opcode_ae_sras64_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110150;
}

static void
Opcode_ae_sras64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa8402;
}

static void
Opcode_ae_slaa64_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x712000;
}

static void
Opcode_ae_slaa64_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100300;
}

static void
Opcode_ae_slaa64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x75000;
}

static void
Opcode_ae_srla64_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x71f000;
}

static void
Opcode_ae_srla64_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110000;
}

static void
Opcode_ae_sraa64_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x71b000;
}

static void
Opcode_ae_sraa64_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100c00;
}

static void
Opcode_ae_sraa64_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba10400;
  slotbuf[1] = 0;
}

static void
Opcode_ae_slai64s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5b0000;
}

static void
Opcode_ae_slai64s_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x700c0;
}

static void
Opcode_ae_slai64s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x83002;
}

static void
Opcode_ae_slas64s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73000f;
}

static void
Opcode_ae_slas64s_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110130;
}

static void
Opcode_ae_slas64s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa8202;
}

static void
Opcode_ae_slaa64s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x713000;
}

static void
Opcode_ae_slaa64s_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100400;
}

static void
Opcode_ae_slaa64s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba00400;
  slotbuf[1] = 0;
}

static void
Opcode_ae_lt64_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e9000;
}

static void
Opcode_ae_lt64_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2da000;
}

static void
Opcode_ae_lt64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x510083;
}

static void
Opcode_ae_le64_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e7008;
}

static void
Opcode_ae_le64_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d8080;
}

static void
Opcode_ae_le64_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba22080;
  slotbuf[1] = 0;
}

static void
Opcode_ae_eq64_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e6000;
}

static void
Opcode_ae_eq64_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2d7000;
}

static void
Opcode_ae_eq64_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba21080;
  slotbuf[1] = 0;
}

static void
Opcode_ae_max64_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a1000;
}

static void
Opcode_ae_max64_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2a4000;
}

static void
Opcode_ae_min64_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1a4000;
}

static void
Opcode_ae_min64_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2a7000;
}

static void
Opcode_ae_min64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xde0004;
}

static void
Opcode_ae_nsa64_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73300a;
}

static void
Opcode_ae_nsa64_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e5100;
}

static void
Opcode_ae_nsa64_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc2000;
}

static void
Opcode_ae_nsaz16_0_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73300b;
}

static void
Opcode_ae_nsaz16_0_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e5200;
}

static void
Opcode_ae_nsaz16_0_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c2000;
}

static void
Opcode_ae_nsaz32_l_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73300c;
}

static void
Opcode_ae_nsaz32_l_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e5300;
}

static void
Opcode_ae_nsaz32_l_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd2000;
}

static void
Opcode_ae_nsa16_0_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x733008;
}

static void
Opcode_ae_nsa16_0_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e4f00;
}

static void
Opcode_ae_nsa16_0_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0a500;
  slotbuf[1] = 0;
}

static void
Opcode_ae_nsa32_l_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x733009;
}

static void
Opcode_ae_nsa32_l_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e5000;
}

static void
Opcode_ae_nsa32_l_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0a900;
  slotbuf[1] = 0;
}

static void
Opcode_ae_muls32f48p16s_ll_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x133000;
}

static void
Opcode_ae_muls32f48p16s_ll_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0080;
}

static void
Opcode_ae_mulf32s_ll_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x104000;
}

static void
Opcode_ae_mulf32s_ll_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb0070;
}

static void
Opcode_ae_mul32_ll_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x89000;
}

static void
Opcode_ae_mul32_ll_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x900f0;
}

static void
Opcode_ae_mulf32r_ll_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x101000;
}

static void
Opcode_ae_mulf32r_ll_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb0040;
}

static void
Opcode_ae_muls32f48p16s_lh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x132000;
}

static void
Opcode_ae_muls32f48p16s_lh_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0070;
}

static void
Opcode_ae_mulf32s_lh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x103000;
}

static void
Opcode_ae_mulf32s_lh_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb0060;
}

static void
Opcode_ae_mul32_lh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x88000;
}

static void
Opcode_ae_mul32_lh_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x900e0;
}

static void
Opcode_ae_mulf32r_lh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100000;
}

static void
Opcode_ae_mulf32r_lh_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb0030;
}

static void
Opcode_ae_muls32f48p16s_hh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x131000;
}

static void
Opcode_ae_muls32f48p16s_hh_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0060;
}

static void
Opcode_ae_mulf32s_hh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x102000;
}

static void
Opcode_ae_mulf32s_hh_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb0050;
}

static void
Opcode_ae_mul32_hh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x87000;
}

static void
Opcode_ae_mul32_hh_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x900d0;
}

static void
Opcode_ae_mulf32r_hh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xff000;
}

static void
Opcode_ae_mulf32r_hh_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb0020;
}

static void
Opcode_ae_mulas32f48p16s_ll_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe6000;
}

static void
Opcode_ae_mulaf32s_ll_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbf000;
}

static void
Opcode_ae_mula32_ll_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x99000;
}

static void
Opcode_ae_mulaf32r_ll_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbc000;
}

static void
Opcode_ae_mulas32f48p16s_lh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe5000;
}

static void
Opcode_ae_mulaf32s_lh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbe000;
}

static void
Opcode_ae_mula32_lh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x98000;
}

static void
Opcode_ae_mulaf32r_lh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbb000;
}

static void
Opcode_ae_mulas32f48p16s_hh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe4000;
}

static void
Opcode_ae_mulaf32s_hh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xbd000;
}

static void
Opcode_ae_mula32_hh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x97000;
}

static void
Opcode_ae_mulaf32r_hh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba000;
}

static void
Opcode_ae_mulss32f48p16s_ll_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x172000;
}

static void
Opcode_ae_mulsf32s_ll_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x155000;
}

static void
Opcode_ae_muls32_ll_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13f000;
}

static void
Opcode_ae_mulsf32r_ll_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x152000;
}

static void
Opcode_ae_mulss32f48p16s_lh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x171000;
}

static void
Opcode_ae_mulsf32s_lh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x154000;
}

static void
Opcode_ae_muls32_lh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13e000;
}

static void
Opcode_ae_mulsf32r_lh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x151000;
}

static void
Opcode_ae_mulss32f48p16s_hh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x170000;
}

static void
Opcode_ae_mulsf32s_hh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x153000;
}

static void
Opcode_ae_muls32_hh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13d000;
}

static void
Opcode_ae_mulsf32r_hh_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x150000;
}

static void
Opcode_ae_mul32u_ll_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7e000;
}

static void
Opcode_ae_mul32u_ll_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90040;
}

static void
Opcode_ae_mula32u_ll_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8e000;
}

static void
Opcode_ae_muls32u_ll_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x134000;
}

static void
Opcode_ae_mulf16ss_33_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfc000;
}

static void
Opcode_ae_mulf16ss_33_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa00f0;
}

static void
Opcode_ae_mulf16ss_22_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf8000;
}

static void
Opcode_ae_mulf16ss_22_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa00b0;
}

static void
Opcode_ae_mulf16ss_32_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfb000;
}

static void
Opcode_ae_mulf16ss_32_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa00e0;
}

static void
Opcode_ae_mulf16ss_21_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf7000;
}

static void
Opcode_ae_mulf16ss_21_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa00a0;
}

static void
Opcode_ae_mulf16ss_31_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfa000;
}

static void
Opcode_ae_mulf16ss_31_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa00d0;
}

static void
Opcode_ae_mulf16ss_30_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf9000;
}

static void
Opcode_ae_mulf16ss_30_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa00c0;
}

static void
Opcode_ae_mulf16ss_10_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf4000;
}

static void
Opcode_ae_mulf16ss_10_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0070;
}

static void
Opcode_ae_mulf16ss_20_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf6000;
}

static void
Opcode_ae_mulf16ss_20_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0090;
}

static void
Opcode_ae_mulf16ss_11_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf5000;
}

static void
Opcode_ae_mulf16ss_11_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0080;
}

static void
Opcode_ae_mulf16ss_00_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf3000;
}

static void
Opcode_ae_mulf16ss_00_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0060;
}

static void
Opcode_ae_mulsf16ss_33_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x14d000;
}

static void
Opcode_ae_mulsf16ss_22_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x149000;
}

static void
Opcode_ae_mulsf16ss_32_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x14c000;
}

static void
Opcode_ae_mulsf16ss_21_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x148000;
}

static void
Opcode_ae_mulsf16ss_31_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x14b000;
}

static void
Opcode_ae_mulsf16ss_30_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x14a000;
}

static void
Opcode_ae_mulsf16ss_10_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x145000;
}

static void
Opcode_ae_mulsf16ss_20_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x147000;
}

static void
Opcode_ae_mulsf16ss_11_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x146000;
}

static void
Opcode_ae_mulsf16ss_00_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x144000;
}

static void
Opcode_ae_mulaf16ss_33_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb7000;
}

static void
Opcode_ae_mulaf16ss_22_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb3000;
}

static void
Opcode_ae_mulaf16ss_32_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb6000;
}

static void
Opcode_ae_mulaf16ss_21_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb2000;
}

static void
Opcode_ae_mulaf16ss_31_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb5000;
}

static void
Opcode_ae_mulaf16ss_30_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb4000;
}

static void
Opcode_ae_mulaf16ss_10_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xaf000;
}

static void
Opcode_ae_mulaf16ss_20_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb1000;
}

static void
Opcode_ae_mulaf16ss_11_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb0000;
}

static void
Opcode_ae_mulaf16ss_00_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xae000;
}

static void
Opcode_ae_mulaafd16ss_33_22_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa1000;
}

static void
Opcode_ae_mulaafd16ss_13_02_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0000;
}

static void
Opcode_ae_mulaafd16ss_11_00_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9f000;
}

static void
Opcode_ae_mulssfd16ss_33_22_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x177000;
}

static void
Opcode_ae_mulssfd16ss_13_02_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x176000;
}

static void
Opcode_ae_mulssfd16ss_11_00_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x175000;
}

static void
Opcode_ae_mulzaafd16ss_33_22_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x181000;
}

static void
Opcode_ae_mulzaafd16ss_33_22_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00f0;
}

static void
Opcode_ae_mulzaafd16ss_13_02_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x180000;
}

static void
Opcode_ae_mulzaafd16ss_13_02_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00e0;
}

static void
Opcode_ae_mulzaafd16ss_11_00_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x17f000;
}

static void
Opcode_ae_mulzaafd16ss_11_00_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00d0;
}

static void
Opcode_ae_mulzssfd16ss_33_22_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x192000;
}

static void
Opcode_ae_mulzssfd16ss_33_22_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf0000;
}

static void
Opcode_ae_mulzssfd16ss_13_02_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x191000;
}

static void
Opcode_ae_mulzssfd16ss_13_02_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe00f0;
}

static void
Opcode_ae_mulzssfd16ss_11_00_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x190000;
}

static void
Opcode_ae_mulzssfd16ss_11_00_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe00e0;
}

static void
Opcode_ae_mulf48q32sp16s_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10d000;
}

static void
Opcode_ae_mulf48q32sp16s_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0000;
}

static void
Opcode_ae_mulf48q32sp16u_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10e000;
}

static void
Opcode_ae_mulf48q32sp16u_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0010;
}

static void
Opcode_ae_mulq32sp16s_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x12b000;
}

static void
Opcode_ae_mulq32sp16s_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0040;
}

static void
Opcode_ae_mulq32sp16u_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x12c000;
}

static void
Opcode_ae_mulq32sp16u_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0050;
}

static void
Opcode_ae_mulaf48q32sp16s_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc8000;
}

static void
Opcode_ae_mulaf48q32sp16u_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc9000;
}

static void
Opcode_ae_mulaq32sp16s_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe2000;
}

static void
Opcode_ae_mulaq32sp16u_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe3000;
}

static void
Opcode_ae_mulsf48q32sp16s_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x15e000;
}

static void
Opcode_ae_mulsf48q32sp16u_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x15f000;
}

static void
Opcode_ae_mulsq32sp16s_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16e000;
}

static void
Opcode_ae_mulsq32sp16u_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16f000;
}

static void
Opcode_ae_mulf32x16_l0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x109000;
}

static void
Opcode_ae_mulf32x16_l0_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb00c0;
}

static void
Opcode_ae_mul32x16_l0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x83000;
}

static void
Opcode_ae_mul32x16_l0_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90090;
}

static void
Opcode_ae_mulf32x16_l1_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10a000;
}

static void
Opcode_ae_mulf32x16_l1_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb00d0;
}

static void
Opcode_ae_mul32x16_l1_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x84000;
}

static void
Opcode_ae_mul32x16_l1_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x900a0;
}

static void
Opcode_ae_mulf32x16_l2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10b000;
}

static void
Opcode_ae_mulf32x16_l2_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb00e0;
}

static void
Opcode_ae_mul32x16_l2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x85000;
}

static void
Opcode_ae_mul32x16_l2_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x900b0;
}

static void
Opcode_ae_mulf32x16_l3_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10c000;
}

static void
Opcode_ae_mulf32x16_l3_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb00f0;
}

static void
Opcode_ae_mul32x16_l3_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x86000;
}

static void
Opcode_ae_mul32x16_l3_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x900c0;
}

static void
Opcode_ae_mulf32x16_h0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x105000;
}

static void
Opcode_ae_mulf32x16_h0_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb0080;
}

static void
Opcode_ae_mul32x16_h0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7f000;
}

static void
Opcode_ae_mul32x16_h0_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90050;
}

static void
Opcode_ae_mulf32x16_h1_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x106000;
}

static void
Opcode_ae_mulf32x16_h1_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb0090;
}

static void
Opcode_ae_mul32x16_h1_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80000;
}

static void
Opcode_ae_mul32x16_h1_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90060;
}

static void
Opcode_ae_mulf32x16_h2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x107000;
}

static void
Opcode_ae_mulf32x16_h2_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb00a0;
}

static void
Opcode_ae_mul32x16_h2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x81000;
}

static void
Opcode_ae_mul32x16_h2_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90070;
}

static void
Opcode_ae_mulf32x16_h3_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x108000;
}

static void
Opcode_ae_mulf32x16_h3_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb00b0;
}

static void
Opcode_ae_mul32x16_h3_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x82000;
}

static void
Opcode_ae_mul32x16_h3_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90080;
}

static void
Opcode_ae_mulaf32x16_l0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc4000;
}

static void
Opcode_ae_mula32x16_l0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x93000;
}

static void
Opcode_ae_mulaf32x16_l1_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc5000;
}

static void
Opcode_ae_mula32x16_l1_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x94000;
}

static void
Opcode_ae_mulaf32x16_l2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc6000;
}

static void
Opcode_ae_mula32x16_l2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x95000;
}

static void
Opcode_ae_mulaf32x16_l3_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc7000;
}

static void
Opcode_ae_mula32x16_l3_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x96000;
}

static void
Opcode_ae_mulaf32x16_h0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0000;
}

static void
Opcode_ae_mula32x16_h0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8f000;
}

static void
Opcode_ae_mulaf32x16_h1_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc1000;
}

static void
Opcode_ae_mula32x16_h1_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90000;
}

static void
Opcode_ae_mulaf32x16_h2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc2000;
}

static void
Opcode_ae_mula32x16_h2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x91000;
}

static void
Opcode_ae_mulaf32x16_h3_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc3000;
}

static void
Opcode_ae_mula32x16_h3_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x92000;
}

static void
Opcode_ae_mulsf32x16_l0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x15a000;
}

static void
Opcode_ae_muls32x16_l0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x139000;
}

static void
Opcode_ae_mulsf32x16_l1_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x15b000;
}

static void
Opcode_ae_muls32x16_l1_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13a000;
}

static void
Opcode_ae_mulsf32x16_l2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x15c000;
}

static void
Opcode_ae_muls32x16_l2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13b000;
}

static void
Opcode_ae_mulsf32x16_l3_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x15d000;
}

static void
Opcode_ae_muls32x16_l3_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x13c000;
}

static void
Opcode_ae_mulsf32x16_h0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x156000;
}

static void
Opcode_ae_muls32x16_h0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x135000;
}

static void
Opcode_ae_mulsf32x16_h1_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x157000;
}

static void
Opcode_ae_muls32x16_h1_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x136000;
}

static void
Opcode_ae_mulsf32x16_h2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x158000;
}

static void
Opcode_ae_muls32x16_h2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x137000;
}

static void
Opcode_ae_mulsf32x16_h3_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x159000;
}

static void
Opcode_ae_muls32x16_h3_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x138000;
}

static void
Opcode_ae_mulaafd32x16_h3_l2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa5000;
}

static void
Opcode_ae_mulaad32x16_h3_l2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9e000;
}

static void
Opcode_ae_mulaafd32x16_h1_l0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa3000;
}

static void
Opcode_ae_mulaad32x16_h1_l0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9c000;
}

static void
Opcode_ae_mulasfd32x16_h3_l2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xea000;
}

static void
Opcode_ae_mulasd32x16_h3_l2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe8000;
}

static void
Opcode_ae_mulasfd32x16_h1_l0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe9000;
}

static void
Opcode_ae_mulasd32x16_h1_l0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe7000;
}

static void
Opcode_ae_mulsafd32x16_h3_l2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x143000;
}

static void
Opcode_ae_mulsad32x16_h3_l2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x141000;
}

static void
Opcode_ae_mulsafd32x16_h1_l0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x142000;
}

static void
Opcode_ae_mulsad32x16_h1_l0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x140000;
}

static void
Opcode_ae_mulssfd32x16_h3_l2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x179000;
}

static void
Opcode_ae_mulssd32x16_h3_l2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x174000;
}

static void
Opcode_ae_mulssfd32x16_h1_l0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x178000;
}

static void
Opcode_ae_mulssd32x16_h1_l0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x173000;
}

static void
Opcode_ae_mulzaafd32x16_h3_l2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x185000;
}

static void
Opcode_ae_mulzaafd32x16_h3_l2_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0030;
}

static void
Opcode_ae_mulzaad32x16_h3_l2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x17e000;
}

static void
Opcode_ae_mulzaad32x16_h3_l2_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00c0;
}

static void
Opcode_ae_mulzaafd32x16_h1_l0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x183000;
}

static void
Opcode_ae_mulzaafd32x16_h1_l0_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0010;
}

static void
Opcode_ae_mulzaad32x16_h1_l0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x17c000;
}

static void
Opcode_ae_mulzaad32x16_h1_l0_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00a0;
}

static void
Opcode_ae_mulzasfd32x16_h3_l2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x189000;
}

static void
Opcode_ae_mulzasfd32x16_h3_l2_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0070;
}

static void
Opcode_ae_mulzasd32x16_h3_l2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x187000;
}

static void
Opcode_ae_mulzasd32x16_h3_l2_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0050;
}

static void
Opcode_ae_mulzasfd32x16_h1_l0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x188000;
}

static void
Opcode_ae_mulzasfd32x16_h1_l0_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0060;
}

static void
Opcode_ae_mulzasd32x16_h1_l0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x186000;
}

static void
Opcode_ae_mulzasd32x16_h1_l0_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0040;
}

static void
Opcode_ae_mulzsafd32x16_h3_l2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x18d000;
}

static void
Opcode_ae_mulzsafd32x16_h3_l2_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe00b0;
}

static void
Opcode_ae_mulzsad32x16_h3_l2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x18b000;
}

static void
Opcode_ae_mulzsad32x16_h3_l2_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0090;
}

static void
Opcode_ae_mulzsafd32x16_h1_l0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x18c000;
}

static void
Opcode_ae_mulzsafd32x16_h1_l0_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe00a0;
}

static void
Opcode_ae_mulzsad32x16_h1_l0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x18a000;
}

static void
Opcode_ae_mulzsad32x16_h1_l0_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0080;
}

static void
Opcode_ae_mulzssfd32x16_h3_l2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x194000;
}

static void
Opcode_ae_mulzssfd32x16_h3_l2_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf0020;
}

static void
Opcode_ae_mulzssd32x16_h3_l2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x18f000;
}

static void
Opcode_ae_mulzssd32x16_h3_l2_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe00d0;
}

static void
Opcode_ae_mulzssfd32x16_h1_l0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x193000;
}

static void
Opcode_ae_mulzssfd32x16_h1_l0_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf0010;
}

static void
Opcode_ae_mulzssd32x16_h1_l0_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x18e000;
}

static void
Opcode_ae_mulzssd32x16_h1_l0_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe00c0;
}

static void
Opcode_ae_mulzaafd32x16_h2_l3_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x184000;
}

static void
Opcode_ae_mulzaafd32x16_h2_l3_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0020;
}

static void
Opcode_ae_mulzaafd32x16_h0_l1_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x182000;
}

static void
Opcode_ae_mulzaafd32x16_h0_l1_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0000;
}

static void
Opcode_ae_mulaafd32x16_h2_l3_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa4000;
}

static void
Opcode_ae_mulaafd32x16_h0_l1_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa2000;
}

static void
Opcode_ae_mulzaad32x16_h2_l3_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x17d000;
}

static void
Opcode_ae_mulzaad32x16_h2_l3_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd00b0;
}

static void
Opcode_ae_mulzaad32x16_h0_l1_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x17b000;
}

static void
Opcode_ae_mulzaad32x16_h0_l1_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0090;
}

static void
Opcode_ae_mulaad32x16_h2_l3_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9d000;
}

static void
Opcode_ae_mulaad32x16_h0_l1_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9b000;
}

static void
Opcode_ae_mulp32x16x2_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x127000;
}

static void
Opcode_ae_mulp32x16x2_h_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0010;
}

static void
Opcode_ae_mulfp32x16x2s_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x121000;
}

static void
Opcode_ae_mulfp32x16x2s_h_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc00d0;
}

static void
Opcode_ae_mulfp32x16x2rs_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x11f000;
}

static void
Opcode_ae_mulfp32x16x2rs_h_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc00b0;
}

static void
Opcode_ae_mulfp32x16x2ras_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x11d000;
}

static void
Opcode_ae_mulfp32x16x2ras_h_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0090;
}

static void
Opcode_ae_mulp32x16x2_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x128000;
}

static void
Opcode_ae_mulp32x16x2_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0020;
}

static void
Opcode_ae_mulfp32x16x2s_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x122000;
}

static void
Opcode_ae_mulfp32x16x2s_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc00e0;
}

static void
Opcode_ae_mulfp32x16x2rs_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x120000;
}

static void
Opcode_ae_mulfp32x16x2rs_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc00c0;
}

static void
Opcode_ae_mulfp32x16x2ras_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x11e000;
}

static void
Opcode_ae_mulfp32x16x2ras_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc00a0;
}

static void
Opcode_ae_mulap32x16x2_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xde000;
}

static void
Opcode_ae_mulafp32x16x2s_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd8000;
}

static void
Opcode_ae_mulafp32x16x2rs_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd6000;
}

static void
Opcode_ae_mulafp32x16x2ras_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd4000;
}

static void
Opcode_ae_mulap32x16x2_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdf000;
}

static void
Opcode_ae_mulafp32x16x2s_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd9000;
}

static void
Opcode_ae_mulafp32x16x2rs_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd7000;
}

static void
Opcode_ae_mulafp32x16x2ras_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd5000;
}

static void
Opcode_ae_mulsp32x16x2_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16a000;
}

static void
Opcode_ae_mulsfp32x16x2s_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x164000;
}

static void
Opcode_ae_mulsfp32x16x2rs_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x162000;
}

static void
Opcode_ae_mulsfp32x16x2ras_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x160000;
}

static void
Opcode_ae_mulsp32x16x2_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16b000;
}

static void
Opcode_ae_mulsfp32x16x2s_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x165000;
}

static void
Opcode_ae_mulsfp32x16x2rs_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x163000;
}

static void
Opcode_ae_mulsfp32x16x2ras_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x161000;
}

static void
Opcode_ae_mulfcr32x16ras_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x116000;
}

static void
Opcode_ae_mulfcr32x16ras_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x115000;
}

static void
Opcode_ae_mulfci32x16ras_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x112000;
}

static void
Opcode_ae_mulfci32x16ras_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0040;
}

static void
Opcode_ae_mulfci32x16ras_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x111000;
}

static void
Opcode_ae_mulfci32x16ras_h_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0030;
}

static void
Opcode_ae_mulfcr32x16s_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x118000;
}

static void
Opcode_ae_mulfcr32x16s_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x117000;
}

static void
Opcode_ae_mulfci32x16s_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x114000;
}

static void
Opcode_ae_mulfci32x16s_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0060;
}

static void
Opcode_ae_mulfci32x16s_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x113000;
}

static void
Opcode_ae_mulfci32x16s_h_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0050;
}

static void
Opcode_ae_mulafcr32x16ras_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd1000;
}

static void
Opcode_ae_mulafcr32x16ras_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0000;
}

static void
Opcode_ae_mulafci32x16ras_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcd000;
}

static void
Opcode_ae_mulafci32x16ras_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcc000;
}

static void
Opcode_ae_mulafcr32x16s_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd3000;
}

static void
Opcode_ae_mulafcr32x16s_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd2000;
}

static void
Opcode_ae_mulafci32x16s_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcf000;
}

static void
Opcode_ae_mulafci32x16s_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xce000;
}

static void
Opcode_ae_mulp32x2_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x129000;
}

static void
Opcode_ae_mulap32x2_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe0000;
}

static void
Opcode_ae_mulsp32x2_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16c000;
}

static void
Opcode_ae_mulp32x2_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x12a000;
}

static void
Opcode_ae_mulp32x2_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0030;
}

static void
Opcode_ae_mulap32x2_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xe1000;
}

static void
Opcode_ae_mulsp32x2_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x16d000;
}

static void
Opcode_ae_mulfp32x2rs_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x125000;
}

static void
Opcode_ae_mulfp32x2ras_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x123000;
}

static void
Opcode_ae_mulafp32x2rs_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdc000;
}

static void
Opcode_ae_mulafp32x2ras_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xda000;
}

static void
Opcode_ae_mulsfp32x2rs_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x168000;
}

static void
Opcode_ae_mulsfp32x2ras_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x166000;
}

static void
Opcode_ae_mulfp32x2rs_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x126000;
}

static void
Opcode_ae_mulfp32x2rs_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd0000;
}

static void
Opcode_ae_mulfp32x2ras_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x124000;
}

static void
Opcode_ae_mulfp32x2ras_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc00f0;
}

static void
Opcode_ae_mulafp32x2rs_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdd000;
}

static void
Opcode_ae_mulafp32x2ras_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xdb000;
}

static void
Opcode_ae_mulsfp32x2rs_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x169000;
}

static void
Opcode_ae_mulsfp32x2ras_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x167000;
}

static void
Opcode_ae_mulfp16x4s_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x11b000;
}

static void
Opcode_ae_mulfp16x4ras_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x119000;
}

static void
Opcode_ae_mulfp16x4s_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x11c000;
}

static void
Opcode_ae_mulfp16x4s_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0080;
}

static void
Opcode_ae_mulfp16x4ras_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x11a000;
}

static void
Opcode_ae_mulfp16x4ras_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0070;
}

static void
Opcode_ae_mulcr32x16_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf2000;
}

static void
Opcode_ae_mulcr32x16_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf1000;
}

static void
Opcode_ae_mulci32x16_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf0000;
}

static void
Opcode_ae_mulci32x16_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0050;
}

static void
Opcode_ae_mulci32x16_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xef000;
}

static void
Opcode_ae_mulci32x16_h_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0040;
}

static void
Opcode_ae_mulacr32x16_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xad000;
}

static void
Opcode_ae_mulacr32x16_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xac000;
}

static void
Opcode_ae_mulaci32x16_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xab000;
}

static void
Opcode_ae_mulaci32x16_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xaa000;
}

static void
Opcode_ae_mulf16x4ss_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfd000;
}

static void
Opcode_ae_mulf16x4ss_h_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb0000;
}

static void
Opcode_ae_mulaf16x4ss_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb8000;
}

static void
Opcode_ae_mulsf16x4ss_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x14e000;
}

static void
Opcode_ae_mulf16x4ss_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfe000;
}

static void
Opcode_ae_mulf16x4ss_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb0010;
}

static void
Opcode_ae_mulaf16x4ss_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9000;
}

static void
Opcode_ae_mulsf16x4ss_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x14f000;
}

static void
Opcode_ae_mul16x4_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7c000;
}

static void
Opcode_ae_mul16x4_h_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90020;
}

static void
Opcode_ae_mula16x4_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8c000;
}

static void
Opcode_ae_muls16x4_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x12f000;
}

static void
Opcode_ae_mula16x4s_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8a000;
}

static void
Opcode_ae_muls16x4s_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x12d000;
}

static void
Opcode_ae_mul16x4_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x7d000;
}

static void
Opcode_ae_mul16x4_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x90030;
}

static void
Opcode_ae_mula16x4_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8d000;
}

static void
Opcode_ae_muls16x4_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x130000;
}

static void
Opcode_ae_mula16x4s_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8b000;
}

static void
Opcode_ae_muls16x4s_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x12e000;
}

static void
Opcode_ae_mulc16s_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xed000;
}

static void
Opcode_ae_mulc16s_h_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0020;
}

static void
Opcode_ae_mulc16s_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xee000;
}

static void
Opcode_ae_mulc16s_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa0030;
}

static void
Opcode_ae_mulac16s_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa8000;
}

static void
Opcode_ae_mulac16s_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa9000;
}

static void
Opcode_ae_mulfc16ras_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x10f000;
}

static void
Opcode_ae_mulfc16ras_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110000;
}

static void
Opcode_ae_mulfc16ras_l_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc0020;
}

static void
Opcode_ae_mulafc16ras_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xca000;
}

static void
Opcode_ae_mulafc16ras_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xcb000;
}

static void
Opcode_ae_mulzaaaaq16_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x17a000;
}

static void
Opcode_ae_mulaaaaq16_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x9a000;
}

static void
Opcode_ae_mul16js_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f1e00;
}

static void
Opcode_ae_mul16js_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e3a00;
}

static void
Opcode_ae_calcrng3_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x735509;
}

static void
Opcode_ae_calcrng3_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x244309;
}

static void
Opcode_ae_addandsubrng16ras_s1_Slot_f3_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0;
}

static void
Opcode_ae_addandsubrng16ras_s2_Slot_f3_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x100;
}

static void
Opcode_ae_div64d32_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f1c00;
}

static void
Opcode_ae_div64d32_h_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e3800;
}

static void
Opcode_ae_div64d32_l_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f1d00;
}

static void
Opcode_ae_div64d32_l_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e3900;
}

static void
Opcode_ae_div64d32_l_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xd1000;
}

static void
Opcode_ae_sha32_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x734000;
}

static void
Opcode_ae_sha32_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f5002;
}

static void
Opcode_ae_sha32_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e60b0;
}

static void
Opcode_ae_sha32_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x129010;
}

static void
Opcode_ae_sha32_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba72080;
  slotbuf[1] = 0;
}

static void
Opcode_ae_vldl32t_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x72e200;
}

static void
Opcode_ae_vldl32t_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba08100;
  slotbuf[1] = 0;
}

static void
Opcode_ae_vldl16t_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x72e000;
}

static void
Opcode_ae_vldl16t_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x710003;
}

static void
Opcode_ae_vldl16c_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x41cd10;
}

static void
Opcode_ae_vldl16c_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x161040;
}

static void
Opcode_ae_vldl16c_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x41ed10;
}

static void
Opcode_ae_vldl16c_ip_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0e508;
  slotbuf[1] = 0;
}

static void
Opcode_ae_vldl16c_ic_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x41dd10;
}

static void
Opcode_ae_vldl16c_ic_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x171040;
}

static void
Opcode_ae_vldsht_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x735508;
}

static void
Opcode_ae_vldsht_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73a00;
}

static void
Opcode_ae_lb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x430403;
}

static void
Opcode_ae_lbi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x340304;
}

static void
Opcode_ae_lbk_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x480000;
}

static void
Opcode_ae_lbki_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400003;
}

static void
Opcode_ae_lbs_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba72060;
  slotbuf[1] = 0;
}

static void
Opcode_ae_lbsi_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba710e0;
  slotbuf[1] = 0;
}

static void
Opcode_ae_lbit_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x40204;
}

static void
Opcode_ae_db_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x72000;
}

static void
Opcode_ae_dbi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f2000;
}

static void
Opcode_ae_dbit_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x98002;
}

static void
Opcode_ae_db_ic_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf2000;
}

static void
Opcode_ae_dbi_ic_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x162000;
}

static void
Opcode_ae_db_ip_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba70500;
  slotbuf[1] = 0;
}

static void
Opcode_ae_dbi_ip_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba70400;
  slotbuf[1] = 0;
}

static void
Opcode_ae_lbi_dbi_ic_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9f6000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_lbi_dbi_ip_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9f7000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_lbi_dbi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x80000;
}

static void
Opcode_ae_sb_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x71000;
}

static void
Opcode_ae_sbi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x580000;
}

static void
Opcode_ae_sbf_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x171000;
}

static void
Opcode_ae_sbit_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9e0000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_sb_ic_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba70600;
  slotbuf[1] = 0;
}

static void
Opcode_ae_sbi_ic_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba00100;
  slotbuf[1] = 0;
}

static void
Opcode_ae_sbf_ic_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0c508;
  slotbuf[1] = 0;
}

static void
Opcode_ae_sb_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e2000;
}

static void
Opcode_ae_sbi_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x180000;
}

static void
Opcode_ae_sbf_ip_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0d508;
  slotbuf[1] = 0;
}

static void
Opcode_ae_l16si_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200d;
}

static void
Opcode_ae_l16ui_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x400d;
}

static void
Opcode_ae_s16i_n_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x600d;
}

static void
Opcode_ae_sext16_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x800d;
}

static void
Opcode_ae_zext16_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x900d;
}

static void
Opcode_ae_zext8_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb00d;
}

static void
Opcode_ae_clamps16_Slot_inst16b_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xa00d;
}

static void
Opcode_ae_zerob_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e9008;
}

static void
Opcode_ae_zerob_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2da080;
}

static void
Opcode_ae_zeroc16x4_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f1000;
}

static void
Opcode_ae_zeroc16x4_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e5080;
}

static void
Opcode_ae_zeroc32x2_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f1008;
}

static void
Opcode_ae_zeroc32x2_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e5480;
}

static void
Opcode_ae_sext32_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x722000;
}

static void
Opcode_ae_sext32_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1d9000;
}

static void
Opcode_ae_sext32_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2c5000;
}

static void
Opcode_ae_sext32_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf0080;
}

static void
Opcode_ae_movba1_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a71e0;
}

static void
Opcode_ae_movba1_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e2101;
}

static void
Opcode_ae_movba1_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba44103;
  slotbuf[1] = 0;
}

static void
Opcode_ae_movab1_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x731700;
}

static void
Opcode_ae_movab1_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e000e;
}

static void
Opcode_ae_movab1_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x272000;
}

static void
Opcode_ae_movba2_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a72e0;
}

static void
Opcode_ae_movba2_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e2201;
}

static void
Opcode_ae_movba2_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba44203;
  slotbuf[1] = 0;
}

static void
Opcode_ae_movab2_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x731708;
}

static void
Opcode_ae_movab2_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e080e;
}

static void
Opcode_ae_movab2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x272800;
}

static void
Opcode_ae_movba4_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a73e0;
}

static void
Opcode_ae_movba4_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e2301;
}

static void
Opcode_ae_movba4_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba44303;
  slotbuf[1] = 0;
}

static void
Opcode_ae_movab4_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x735100;
}

static void
Opcode_ae_movab4_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e000b;
}

static void
Opcode_ae_movab4_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x372000;
}

static void
Opcode_ae_movba8_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x735000;
}

static void
Opcode_ae_movba8_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e2401;
}

static void
Opcode_ae_movba8_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba46003;
  slotbuf[1] = 0;
}

static void
Opcode_ae_movab8_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x735108;
}

static void
Opcode_ae_movab8_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e000f;
}

static void
Opcode_ae_movab8_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0b100;
  slotbuf[1] = 0;
}

static void
Opcode_ae_mb_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x735088;
}

static void
Opcode_ae_mb_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f1208;
}

static void
Opcode_ae_mb_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e2501;
}

static void
Opcode_ae_mb_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110330;
}

static void
Opcode_ae_mb_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba46103;
  slotbuf[1] = 0;
}

static void
Opcode_ae_joinb_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a30e0;
}

static void
Opcode_ae_joinb_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e60a0;
}

static void
Opcode_ae_joinb_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba72020;
  slotbuf[1] = 0;
}

static void
Opcode_ae_extractbi_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a20e0;
}

static void
Opcode_ae_extractbi_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e2000;
}

static void
Opcode_ae_extractbi_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610083;
}

static void
Opcode_ae_randb4_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x735048;
}

static void
Opcode_ae_randb4_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e20b0;
}

static void
Opcode_ae_randb4_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0c110;
  slotbuf[1] = 0;
}

static void
Opcode_ae_randb8_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x735060;
}

static void
Opcode_ae_randb8_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e20c0;
}

static void
Opcode_ae_randb8_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0c120;
  slotbuf[1] = 0;
}

static void
Opcode_ae_rorb4_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x735068;
}

static void
Opcode_ae_rorb4_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e20d0;
}

static void
Opcode_ae_rorb4_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0c130;
  slotbuf[1] = 0;
}

static void
Opcode_ae_rorb8_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x735080;
}

static void
Opcode_ae_rorb8_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e20e0;
}

static void
Opcode_ae_rorb8_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0c140;
  slotbuf[1] = 0;
}

static void
Opcode_ae_andb8_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a00e0;
}

static void
Opcode_ae_andb8_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e6080;
}

static void
Opcode_ae_andb8_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba72000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_orb8_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a4080;
}

static void
Opcode_ae_orb8_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e60b0;
}

static void
Opcode_ae_orb8_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba72030;
  slotbuf[1] = 0;
}

static void
Opcode_ae_xorb8_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a40c0;
}

static void
Opcode_ae_xorb8_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e60d0;
}

static void
Opcode_ae_xorb8_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba72050;
  slotbuf[1] = 0;
}

static void
Opcode_ae_andnotb8_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a10e0;
}

static void
Opcode_ae_andnotb8_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e6090;
}

static void
Opcode_ae_andnotb8_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba72010;
  slotbuf[1] = 0;
}

static void
Opcode_ae_ornotb8_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a40a0;
}

static void
Opcode_ae_ornotb8_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e60c0;
}

static void
Opcode_ae_ornotb8_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba72040;
  slotbuf[1] = 0;
}

static void
Opcode_ae_notb8_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x735040;
}

static void
Opcode_ae_notb8_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e20a0;
}

static void
Opcode_ae_notb8_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0c100;
  slotbuf[1] = 0;
}

static void
Opcode_ae_ltr4_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a70e0;
}

static void
Opcode_ae_ltr4_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e2001;
}

static void
Opcode_ae_ltr4_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba44003;
  slotbuf[1] = 0;
}

static void
Opcode_ae_extractbl_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x735028;
}

static void
Opcode_ae_extractbl_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e2090;
}

static void
Opcode_ae_extractbh_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x735020;
}

static void
Opcode_ae_extractbh_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e2080;
}

static void
Opcode_ae_bitrev8_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73300f;
}

static void
Opcode_ae_bitrev8_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f5001;
}

static void
Opcode_ae_bitrev8_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e60a0;
}

static void
Opcode_ae_bitrev8_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x128010;
}

static void
Opcode_ae_bitrev8_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba710f0;
  slotbuf[1] = 0;
}

static void
Opcode_ae_popc2b_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x731000;
}

static void
Opcode_ae_popc2b_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e0000;
}

static void
Opcode_ae_popc2b_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba70000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_popcb8_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x735500;
}

static void
Opcode_ae_popcb8_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e080b;
}

static void
Opcode_ae_popcb8_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0b500;
  slotbuf[1] = 0;
}

static void
Opcode_ae_movsqz16x4_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ef000;
}

static void
Opcode_ae_movsqz16x4_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf80e0;
}

static void
Opcode_ae_la8x4s_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6b0060;
}

static void
Opcode_ae_la8x4s_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x250008;
}

static void
Opcode_ae_la8x4u_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6b0070;
}

static void
Opcode_ae_la8x4u_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x25000c;
}

static void
Opcode_ae_sa32x2_ic_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6bc070;
}

static void
Opcode_ae_sa32x2_ic_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x25c00c;
}

static void
Opcode_ae_sa32x2_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a0080;
}

static void
Opcode_ae_sa32x2_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x240001;
}

static void
Opcode_ae_sa32x2_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x720c03;
}

static void
Opcode_ae_sa32x2_rip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a00a0;
}

static void
Opcode_ae_sa32x2_rip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x240009;
}

static void
Opcode_ae_sa32x2_rip_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba44002;
  slotbuf[1] = 0;
}

static void
Opcode_ae_sa32x2_ric_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a0090;
}

static void
Opcode_ae_sa32x2_ric_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x240005;
}

static void
Opcode_ae_sa16x4_ic_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6b4070;
}

static void
Opcode_ae_sa16x4_ic_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x25400c;
}

static void
Opcode_ae_sa16x4_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6b8060;
}

static void
Opcode_ae_sa16x4_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x258008;
}

static void
Opcode_ae_sa16x4_ip_Slot_f3_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ab000;
}

static void
Opcode_ae_sa16x4_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x720403;
}

static void
Opcode_ae_sa16x4_rip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6bc060;
}

static void
Opcode_ae_sa16x4_rip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x25c008;
}

static void
Opcode_ae_sa16x4_rip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x720803;
}

static void
Opcode_ae_sa16x4_ric_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6b8070;
}

static void
Opcode_ae_sa16x4_ric_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x25800c;
}

static void
Opcode_ae_sa8x4u_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a00b0;
}

static void
Opcode_ae_sa8x4u_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x24000d;
}

static void
Opcode_ae_sav16x4_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a0000;
}

static void
Opcode_ae_sav16x4_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c0000;
}

static void
Opcode_ae_sa64pos_fp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x418d10;
}

static void
Opcode_ae_sa64pos_fp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x24420d;
}

static void
Opcode_ae_sa64pos_fp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xc7000;
}

static void
Opcode_ae_sa64neg_fp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x414d10;
}

static void
Opcode_ae_sa64neg_fp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x244209;
}

static void
Opcode_ae_sa64neg_fp_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x372c00;
}

static void
Opcode_ae_sa8x8_ip_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a00c0;
}

static void
Opcode_ae_sa8x8_ip_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x244001;
}

static void
Opcode_ae_sa8x8_ip_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x430003;
}

static void
Opcode_ae_sav8x8_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a8000;
}

static void
Opcode_ae_sav8x8_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c8000;
}

static void
Opcode_ae_lav8x8_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x59c000;
}

static void
Opcode_ae_lav8x8_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xfc000;
}

static void
Opcode_ae_lav8x8_xp_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9ec000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_lav16x4_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x590000;
}

static void
Opcode_ae_lav16x4_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf0000;
}

static void
Opcode_ae_lav16x4_xp_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xb9e8000;
  slotbuf[1] = 0;
}

static void
Opcode_ae_lav8x4s_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x594000;
}

static void
Opcode_ae_lav8x4s_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf4000;
}

static void
Opcode_ae_lav8x4u_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x598000;
}

static void
Opcode_ae_lav8x4u_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf8000;
}

static void
Opcode_ae_sav8x4u_xp_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x5a4000;
}

static void
Opcode_ae_sav8x4u_xp_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1c4000;
}

static void
Opcode_ae_satu16x4_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b1000;
}

static void
Opcode_ae_sat8x4x32_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b0000;
}

static void
Opcode_ae_satu8x4x32_h_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1b2000;
}

static void
Opcode_rur_fcr_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0b900;
  slotbuf[1] = 0;
}

static void
Opcode_wur_fcr_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0b903;
  slotbuf[1] = 0;
}

static void
Opcode_rur_fsr_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0bd00;
  slotbuf[1] = 0;
}

static void
Opcode_wur_fsr_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0bd03;
  slotbuf[1] = 0;
}

static void
Opcode_rfr_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73300e;
}

static void
Opcode_rfr_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e5500;
}

static void
Opcode_rfr_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba0ad00;
  slotbuf[1] = 0;
}

static void
Opcode_wfr_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a70d0;
}

static void
Opcode_wfr_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e000a;
}

static void
Opcode_wfr_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x640304;
}

static void
Opcode_movt_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x72f008;
}

static void
Opcode_movt_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e4080;
}

static void
Opcode_movt_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x528003;
}

static void
Opcode_movf_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x72f000;
}

static void
Opcode_movf_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e3080;
}

static void
Opcode_movf_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba2b080;
  slotbuf[1] = 0;
}

static void
Opcode_moveqz_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x729000;
}

static void
Opcode_moveqz_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2c8000;
}

static void
Opcode_moveqz_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba6a000;
  slotbuf[1] = 0;
}

static void
Opcode_movnez_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x72c000;
}

static void
Opcode_movnez_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2cb000;
}

static void
Opcode_movnez_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba6d000;
  slotbuf[1] = 0;
}

static void
Opcode_movgez_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x72a000;
}

static void
Opcode_movgez_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2c9000;
}

static void
Opcode_movgez_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba6b000;
  slotbuf[1] = 0;
}

static void
Opcode_movltz_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x72b000;
}

static void
Opcode_movltz_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2ca000;
}

static void
Opcode_movltz_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba6c000;
  slotbuf[1] = 0;
}

static void
Opcode_add_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1dc000;
}

static void
Opcode_add_s_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf00b0;
}

static void
Opcode_sub_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e3000;
}

static void
Opcode_mul_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e2000;
}

static void
Opcode_mul_s_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xf00c0;
}

static void
Opcode_madd_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1df000;
}

static void
Opcode_maddn_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1de000;
}

static void
Opcode_msub_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e1000;
}

static void
Opcode_msubn_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e0000;
}

static void
Opcode_divn_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1dd000;
}

static void
Opcode_abs_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x732004;
}

static void
Opcode_abs_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f2d00;
}

static void
Opcode_abs_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e1800;
}

static void
Opcode_abs_s_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110180;
}

static void
Opcode_abs_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba71090;
  slotbuf[1] = 0;
}

static void
Opcode_neg_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x733001;
}

static void
Opcode_neg_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f3d00;
}

static void
Opcode_neg_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e4800;
}

static void
Opcode_neg_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba710d0;
  slotbuf[1] = 0;
}

static void
Opcode_conjc_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x73200f;
}

static void
Opcode_conjc_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f3a00;
}

static void
Opcode_conjc_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e4500;
}

static void
Opcode_conjc_s_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110220;
}

static void
Opcode_conjc_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba710b0;
  slotbuf[1] = 0;
}

static void
Opcode_const_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a7080;
}

static void
Opcode_const_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f3b00;
}

static void
Opcode_const_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e4600;
}

static void
Opcode_const_s_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110320;
}

static void
Opcode_const_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x261000;
}

static void
Opcode_max_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1bd000;
}

static void
Opcode_max_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2bd000;
}

static void
Opcode_max_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x8f0004;
}

static void
Opcode_min_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1bf000;
}

static void
Opcode_min_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2bf000;
}

static void
Opcode_min_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba69000;
  slotbuf[1] = 0;
}

static void
Opcode_minnum_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1be000;
}

static void
Opcode_minnum_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2be000;
}

static void
Opcode_minnum_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba68000;
  slotbuf[1] = 0;
}

static void
Opcode_maxnum_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1bc000;
}

static void
Opcode_maxnum_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2bc000;
}

static void
Opcode_maxnum_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba67000;
  slotbuf[1] = 0;
}

static void
Opcode_ole_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ea008;
}

static void
Opcode_ole_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2db080;
}

static void
Opcode_ole_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba24080;
  slotbuf[1] = 0;
}

static void
Opcode_olt_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1eb000;
}

static void
Opcode_olt_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2dc000;
}

static void
Opcode_olt_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x610003;
}

static void
Opcode_oeq_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ea000;
}

static void
Opcode_oeq_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2db000;
}

static void
Opcode_oeq_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba23080;
  slotbuf[1] = 0;
}

static void
Opcode_un_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ed000;
}

static void
Opcode_un_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2de000;
}

static void
Opcode_un_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba28080;
  slotbuf[1] = 0;
}

static void
Opcode_ule_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ec000;
}

static void
Opcode_ule_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2dd000;
}

static void
Opcode_ule_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba26080;
  slotbuf[1] = 0;
}

static void
Opcode_ult_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1ec008;
}

static void
Opcode_ult_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2dd080;
}

static void
Opcode_ult_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba27080;
  slotbuf[1] = 0;
}

static void
Opcode_ueq_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1eb008;
}

static void
Opcode_ueq_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2dc080;
}

static void
Opcode_ueq_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba25080;
  slotbuf[1] = 0;
}

static void
Opcode_addexp_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f1500;
}

static void
Opcode_addexp_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e2900;
}

static void
Opcode_addexp_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba70800;
  slotbuf[1] = 0;
}

static void
Opcode_addexpm_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f1400;
}

static void
Opcode_addexpm_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e2800;
}

static void
Opcode_addexpm_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba70700;
  slotbuf[1] = 0;
}

static void
Opcode_mksadj_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a60b0;
}

static void
Opcode_mksadj_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e6040;
}

static void
Opcode_mksadj_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba71030;
  slotbuf[1] = 0;
}

static void
Opcode_mkdadj_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e6090;
}

static void
Opcode_mkdadj_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba71080;
  slotbuf[1] = 0;
}

static void
Opcode_nexp01_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a60c0;
}

static void
Opcode_nexp01_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e6050;
}

static void
Opcode_nexp01_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba71040;
  slotbuf[1] = 0;
}

static void
Opcode_div0_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a50d0;
}

static void
Opcode_div0_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e70e0;
}

static void
Opcode_div0_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba73070;
  slotbuf[1] = 0;
}

static void
Opcode_sqrt0_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a60f0;
}

static void
Opcode_sqrt0_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e6080;
}

static void
Opcode_sqrt0_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba71070;
  slotbuf[1] = 0;
}

static void
Opcode_recip0_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a60d0;
}

static void
Opcode_recip0_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e6060;
}

static void
Opcode_recip0_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba71050;
  slotbuf[1] = 0;
}

static void
Opcode_rsqrt0_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a60e0;
}

static void
Opcode_rsqrt0_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e6070;
}

static void
Opcode_rsqrt0_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba71060;
  slotbuf[1] = 0;
}

static void
Opcode_trunc_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x480500;
}

static void
Opcode_trunc_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200200;
}

static void
Opcode_trunc_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba00000;
  slotbuf[1] = 0;
}

static void
Opcode_utrunc_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x4a0500;
}

static void
Opcode_utrunc_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x200300;
}

static void
Opcode_utrunc_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba00800;
  slotbuf[1] = 0;
}

static void
Opcode_trunc_sx2_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a0020;
}

static void
Opcode_trunc_sx2_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e0010;
}

static void
Opcode_trunc_sx2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x250003;
}

static void
Opcode_utrunc_sx2_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a0050;
}

static void
Opcode_utrunc_sx2_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e0030;
}

static void
Opcode_utrunc_sx2_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba20010;
  slotbuf[1] = 0;
}

static void
Opcode_ficeil_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a50e0;
}

static void
Opcode_ficeil_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e70f0;
}

static void
Opcode_ficeil_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x262000;
}

static void
Opcode_fifloor_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a50f0;
}

static void
Opcode_fifloor_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e6000;
}

static void
Opcode_fifloor_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba71000;
  slotbuf[1] = 0;
}

static void
Opcode_firint_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a6080;
}

static void
Opcode_firint_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e6010;
}

static void
Opcode_firint_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba71010;
  slotbuf[1] = 0;
}

static void
Opcode_firound_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a6090;
}

static void
Opcode_firound_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e6020;
}

static void
Opcode_firound_s_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x362000;
}

static void
Opcode_fitrunc_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a60a0;
}

static void
Opcode_fitrunc_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e6030;
}

static void
Opcode_fitrunc_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba71020;
  slotbuf[1] = 0;
}

static void
Opcode_float_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a0000;
}

static void
Opcode_float_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x240000;
}

static void
Opcode_float_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba40000;
  slotbuf[1] = 0;
}

static void
Opcode_ufloat_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a0030;
}

static void
Opcode_ufloat_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x240004;
}

static void
Opcode_ufloat_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba40001;
  slotbuf[1] = 0;
}

static void
Opcode_float_sx2_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a0010;
}

static void
Opcode_float_sx2_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e0000;
}

static void
Opcode_float_sx2_Slot_inst_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x240003;
}

static void
Opcode_ufloat_sx2_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a0040;
}

static void
Opcode_ufloat_sx2_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e0020;
}

static void
Opcode_ufloat_sx2_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba20000;
  slotbuf[1] = 0;
}

static void
Opcode_muljc_s_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x733000;
}

static void
Opcode_muljc_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f3c00;
}

static void
Opcode_muljc_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e4700;
}

static void
Opcode_muljc_s_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x110230;
}

static void
Opcode_muljc_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba710c0;
  slotbuf[1] = 0;
}

static void
Opcode_clsfy_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1f2b00;
}

static void
Opcode_clsfy_s_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x2e1700;
}

static void
Opcode_clsfy_s_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba70e00;
  slotbuf[1] = 0;
}

static void
Opcode_cvtsf16_l_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a50c0;
}

static void
Opcode_cvtsf16_l_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e60f0;
}

static void
Opcode_cvtsf16_l_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba73060;
  slotbuf[1] = 0;
}

static void
Opcode_cvtf16s_l_Slot_f0_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x6a50b0;
}

static void
Opcode_cvtf16s_l_Slot_f1_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x1e60e0;
}

static void
Opcode_cvtf16s_l_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba72070;
  slotbuf[1] = 0;
}

static void
Opcode_mulmux_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70000;
}

static void
Opcode_mulmux_s_Slot_f1_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x70000;
}

static void
Opcode_maddmux_s_Slot_f0_s1_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0x60000;
}

static void
Opcode_ae_movfcrfsrv_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba72091;
  slotbuf[1] = 0;
}

static void
Opcode_ae_movvfcrfsr_Slot_f2_s0_encode (xtensa_insnbuf slotbuf)
{
  slotbuf[0] = 0xba72094;
  slotbuf[1] = 0;
}

static xtensa_opcode_encode_fn Opcode_excw_encode_fns[] = {
  Opcode_excw_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rfe_encode_fns[] = {
  Opcode_rfe_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rfde_encode_fns[] = {
  Opcode_rfde_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_syscall_encode_fns[] = {
  Opcode_syscall_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_call12_encode_fns[] = {
  Opcode_call12_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_call8_encode_fns[] = {
  Opcode_call8_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_call4_encode_fns[] = {
  Opcode_call4_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_callx12_encode_fns[] = {
  Opcode_callx12_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_callx8_encode_fns[] = {
  Opcode_callx8_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_callx4_encode_fns[] = {
  Opcode_callx4_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_entry_encode_fns[] = {
  Opcode_entry_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_movsp_encode_fns[] = {
  Opcode_movsp_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rotw_encode_fns[] = {
  Opcode_rotw_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_retw_encode_fns[] = {
  Opcode_retw_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_retw_n_encode_fns[] = {
  0, 0, Opcode_retw_n_Slot_inst16b_encode, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rfwo_encode_fns[] = {
  Opcode_rfwo_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rfwu_encode_fns[] = {
  Opcode_rfwu_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_l32e_encode_fns[] = {
  Opcode_l32e_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_s32e_encode_fns[] = {
  Opcode_s32e_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_windowbase_encode_fns[] = {
  Opcode_rsr_windowbase_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_windowbase_encode_fns[] = {
  Opcode_wsr_windowbase_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_windowbase_encode_fns[] = {
  Opcode_xsr_windowbase_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_windowstart_encode_fns[] = {
  Opcode_rsr_windowstart_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_windowstart_encode_fns[] = {
  Opcode_wsr_windowstart_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_windowstart_encode_fns[] = {
  Opcode_xsr_windowstart_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_add_n_encode_fns[] = {
  0, Opcode_add_n_Slot_inst16a_encode, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_addi_n_encode_fns[] = {
  0, Opcode_addi_n_Slot_inst16a_encode, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_beqz_n_encode_fns[] = {
  0, 0, Opcode_beqz_n_Slot_inst16b_encode, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bnez_n_encode_fns[] = {
  0, 0, Opcode_bnez_n_Slot_inst16b_encode, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ill_n_encode_fns[] = {
  0, 0, Opcode_ill_n_Slot_inst16b_encode, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_l32i_n_encode_fns[] = {
  0, Opcode_l32i_n_Slot_inst16a_encode, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_mov_n_encode_fns[] = {
  0, 0, Opcode_mov_n_Slot_inst16b_encode, Opcode_mov_n_Slot_f0_s0_encode, Opcode_mov_n_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_movi_n_encode_fns[] = {
  0, 0, Opcode_movi_n_Slot_inst16b_encode, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_nop_n_encode_fns[] = {
  0, 0, Opcode_nop_n_Slot_inst16b_encode, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ret_n_encode_fns[] = {
  0, 0, Opcode_ret_n_Slot_inst16b_encode, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_s32i_n_encode_fns[] = {
  0, Opcode_s32i_n_Slot_inst16a_encode, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_threadptr_encode_fns[] = {
  Opcode_rur_threadptr_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_threadptr_encode_fns[] = {
  Opcode_wur_threadptr_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_addi_encode_fns[] = {
  Opcode_addi_Slot_inst_encode, 0, 0, Opcode_addi_Slot_f0_s0_encode, Opcode_addi_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_addmi_encode_fns[] = {
  Opcode_addmi_Slot_inst_encode, 0, 0, Opcode_addmi_Slot_f0_s0_encode, Opcode_addmi_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_add_encode_fns[] = {
  Opcode_add_Slot_inst_encode, 0, 0, Opcode_add_Slot_f0_s0_encode, Opcode_add_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_addx2_encode_fns[] = {
  Opcode_addx2_Slot_inst_encode, 0, 0, Opcode_addx2_Slot_f0_s0_encode, Opcode_addx2_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_addx4_encode_fns[] = {
  Opcode_addx4_Slot_inst_encode, 0, 0, Opcode_addx4_Slot_f0_s0_encode, Opcode_addx4_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_addx8_encode_fns[] = {
  Opcode_addx8_Slot_inst_encode, 0, 0, Opcode_addx8_Slot_f0_s0_encode, Opcode_addx8_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_sub_encode_fns[] = {
  Opcode_sub_Slot_inst_encode, 0, 0, Opcode_sub_Slot_f0_s0_encode, Opcode_sub_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_subx2_encode_fns[] = {
  Opcode_subx2_Slot_inst_encode, 0, 0, Opcode_subx2_Slot_f0_s0_encode, Opcode_subx2_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_subx4_encode_fns[] = {
  Opcode_subx4_Slot_inst_encode, 0, 0, Opcode_subx4_Slot_f0_s0_encode, Opcode_subx4_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_subx8_encode_fns[] = {
  Opcode_subx8_Slot_inst_encode, 0, 0, Opcode_subx8_Slot_f0_s0_encode, Opcode_subx8_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_and_encode_fns[] = {
  Opcode_and_Slot_inst_encode, 0, 0, Opcode_and_Slot_f0_s0_encode, Opcode_and_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_or_encode_fns[] = {
  Opcode_or_Slot_inst_encode, 0, 0, Opcode_or_Slot_f0_s0_encode, Opcode_or_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xor_encode_fns[] = {
  Opcode_xor_Slot_inst_encode, 0, 0, Opcode_xor_Slot_f0_s0_encode, Opcode_xor_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_beqi_encode_fns[] = {
  Opcode_beqi_Slot_inst_encode, 0, 0, Opcode_beqi_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bgei_encode_fns[] = {
  Opcode_bgei_Slot_inst_encode, 0, 0, Opcode_bgei_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_blti_encode_fns[] = {
  Opcode_blti_Slot_inst_encode, 0, 0, Opcode_blti_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bnei_encode_fns[] = {
  Opcode_bnei_Slot_inst_encode, 0, 0, Opcode_bnei_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bbci_encode_fns[] = {
  Opcode_bbci_Slot_inst_encode, 0, 0, Opcode_bbci_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bbsi_encode_fns[] = {
  Opcode_bbsi_Slot_inst_encode, 0, 0, Opcode_bbsi_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bgeui_encode_fns[] = {
  Opcode_bgeui_Slot_inst_encode, 0, 0, Opcode_bgeui_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bltui_encode_fns[] = {
  Opcode_bltui_Slot_inst_encode, 0, 0, Opcode_bltui_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ball_encode_fns[] = {
  Opcode_ball_Slot_inst_encode, 0, 0, Opcode_ball_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bany_encode_fns[] = {
  Opcode_bany_Slot_inst_encode, 0, 0, Opcode_bany_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bbc_encode_fns[] = {
  Opcode_bbc_Slot_inst_encode, 0, 0, Opcode_bbc_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bbs_encode_fns[] = {
  Opcode_bbs_Slot_inst_encode, 0, 0, Opcode_bbs_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_beq_encode_fns[] = {
  Opcode_beq_Slot_inst_encode, 0, 0, Opcode_beq_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bge_encode_fns[] = {
  Opcode_bge_Slot_inst_encode, 0, 0, Opcode_bge_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bgeu_encode_fns[] = {
  Opcode_bgeu_Slot_inst_encode, 0, 0, Opcode_bgeu_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_blt_encode_fns[] = {
  Opcode_blt_Slot_inst_encode, 0, 0, Opcode_blt_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bltu_encode_fns[] = {
  Opcode_bltu_Slot_inst_encode, 0, 0, Opcode_bltu_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bnall_encode_fns[] = {
  Opcode_bnall_Slot_inst_encode, 0, 0, Opcode_bnall_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bne_encode_fns[] = {
  Opcode_bne_Slot_inst_encode, 0, 0, Opcode_bne_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bnone_encode_fns[] = {
  Opcode_bnone_Slot_inst_encode, 0, 0, Opcode_bnone_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_beqz_encode_fns[] = {
  Opcode_beqz_Slot_inst_encode, 0, 0, Opcode_beqz_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bgez_encode_fns[] = {
  Opcode_bgez_Slot_inst_encode, 0, 0, Opcode_bgez_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bltz_encode_fns[] = {
  Opcode_bltz_Slot_inst_encode, 0, 0, Opcode_bltz_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bnez_encode_fns[] = {
  Opcode_bnez_Slot_inst_encode, 0, 0, Opcode_bnez_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_call0_encode_fns[] = {
  Opcode_call0_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_callx0_encode_fns[] = {
  Opcode_callx0_Slot_inst_encode, 0, 0, Opcode_callx0_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_extui_encode_fns[] = {
  Opcode_extui_Slot_inst_encode, 0, 0, Opcode_extui_Slot_f0_s0_encode, Opcode_extui_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ill_encode_fns[] = {
  Opcode_ill_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_j_encode_fns[] = {
  Opcode_j_Slot_inst_encode, 0, 0, Opcode_j_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_jx_encode_fns[] = {
  Opcode_jx_Slot_inst_encode, 0, 0, Opcode_jx_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_l16ui_encode_fns[] = {
  Opcode_l16ui_Slot_inst_encode, 0, 0, Opcode_l16ui_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_l16si_encode_fns[] = {
  Opcode_l16si_Slot_inst_encode, 0, 0, Opcode_l16si_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_l32i_encode_fns[] = {
  Opcode_l32i_Slot_inst_encode, 0, 0, Opcode_l32i_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_l32r_encode_fns[] = {
  Opcode_l32r_Slot_inst_encode, 0, 0, Opcode_l32r_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_l8ui_encode_fns[] = {
  Opcode_l8ui_Slot_inst_encode, 0, 0, Opcode_l8ui_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_loop_encode_fns[] = {
  Opcode_loop_Slot_inst_encode, 0, 0, Opcode_loop_Slot_f0_s0_encode, 0, Opcode_loop_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_loopgtz_encode_fns[] = {
  Opcode_loopgtz_Slot_inst_encode, 0, 0, Opcode_loopgtz_Slot_f0_s0_encode, 0, Opcode_loopgtz_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_loopnez_encode_fns[] = {
  Opcode_loopnez_Slot_inst_encode, 0, 0, Opcode_loopnez_Slot_f0_s0_encode, 0, Opcode_loopnez_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_movi_encode_fns[] = {
  Opcode_movi_Slot_inst_encode, 0, 0, Opcode_movi_Slot_f0_s0_encode, Opcode_movi_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_moveqz_encode_fns[] = {
  Opcode_moveqz_Slot_inst_encode, 0, 0, Opcode_moveqz_Slot_f0_s0_encode, Opcode_moveqz_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_movgez_encode_fns[] = {
  Opcode_movgez_Slot_inst_encode, 0, 0, Opcode_movgez_Slot_f0_s0_encode, Opcode_movgez_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_movltz_encode_fns[] = {
  Opcode_movltz_Slot_inst_encode, 0, 0, Opcode_movltz_Slot_f0_s0_encode, Opcode_movltz_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_movnez_encode_fns[] = {
  Opcode_movnez_Slot_inst_encode, 0, 0, Opcode_movnez_Slot_f0_s0_encode, Opcode_movnez_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_abs_encode_fns[] = {
  Opcode_abs_Slot_inst_encode, 0, 0, Opcode_abs_Slot_f0_s0_encode, Opcode_abs_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_neg_encode_fns[] = {
  Opcode_neg_Slot_inst_encode, 0, 0, Opcode_neg_Slot_f0_s0_encode, Opcode_neg_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_nop_encode_fns[] = {
  Opcode_nop_Slot_inst_encode, 0, 0, Opcode_nop_Slot_f0_s0_encode, Opcode_nop_Slot_f0_s1_encode, Opcode_nop_Slot_f1_s0_encode, Opcode_nop_Slot_f1_s1_encode, Opcode_nop_Slot_f2_s0_encode, Opcode_nop_Slot_f3_s0_encode, Opcode_nop_Slot_f3_s1_encode
};

static xtensa_opcode_encode_fn Opcode_depbits_encode_fns[] = {
  Opcode_depbits_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ret_encode_fns[] = {
  Opcode_ret_Slot_inst_encode, 0, 0, Opcode_ret_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_simcall_encode_fns[] = {
  Opcode_simcall_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_s16i_encode_fns[] = {
  Opcode_s16i_Slot_inst_encode, 0, 0, Opcode_s16i_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_s32i_encode_fns[] = {
  Opcode_s32i_Slot_inst_encode, 0, 0, Opcode_s32i_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_s32nb_encode_fns[] = {
  Opcode_s32nb_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_s8i_encode_fns[] = {
  Opcode_s8i_Slot_inst_encode, 0, 0, Opcode_s8i_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ssa8b_encode_fns[] = {
  Opcode_ssa8b_Slot_inst_encode, 0, 0, Opcode_ssa8b_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ssa8l_encode_fns[] = {
  Opcode_ssa8l_Slot_inst_encode, 0, 0, Opcode_ssa8l_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ssl_encode_fns[] = {
  Opcode_ssl_Slot_inst_encode, 0, 0, Opcode_ssl_Slot_f0_s0_encode, Opcode_ssl_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ssr_encode_fns[] = {
  Opcode_ssr_Slot_inst_encode, 0, 0, Opcode_ssr_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ssai_encode_fns[] = {
  Opcode_ssai_Slot_inst_encode, 0, 0, Opcode_ssai_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_sll_encode_fns[] = {
  Opcode_sll_Slot_inst_encode, 0, 0, Opcode_sll_Slot_f0_s0_encode, Opcode_sll_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_src_encode_fns[] = {
  Opcode_src_Slot_inst_encode, 0, 0, Opcode_src_Slot_f0_s0_encode, Opcode_src_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_sra_encode_fns[] = {
  Opcode_sra_Slot_inst_encode, 0, 0, Opcode_sra_Slot_f0_s0_encode, Opcode_sra_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_srl_encode_fns[] = {
  Opcode_srl_Slot_inst_encode, 0, 0, Opcode_srl_Slot_f0_s0_encode, Opcode_srl_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_slli_encode_fns[] = {
  Opcode_slli_Slot_inst_encode, 0, 0, Opcode_slli_Slot_f0_s0_encode, Opcode_slli_Slot_f0_s1_encode, 0, 0, 0, Opcode_slli_Slot_f3_s0_encode, 0
};

static xtensa_opcode_encode_fn Opcode_srai_encode_fns[] = {
  Opcode_srai_Slot_inst_encode, 0, 0, Opcode_srai_Slot_f0_s0_encode, Opcode_srai_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_srli_encode_fns[] = {
  Opcode_srli_Slot_inst_encode, 0, 0, Opcode_srli_Slot_f0_s0_encode, Opcode_srli_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_memw_encode_fns[] = {
  Opcode_memw_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_extw_encode_fns[] = {
  Opcode_extw_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_isync_encode_fns[] = {
  Opcode_isync_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_dsync_encode_fns[] = {
  Opcode_dsync_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_esync_encode_fns[] = {
  Opcode_esync_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsync_encode_fns[] = {
  Opcode_rsync_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsil_encode_fns[] = {
  Opcode_rsil_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_lend_encode_fns[] = {
  Opcode_rsr_lend_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_lend_encode_fns[] = {
  Opcode_wsr_lend_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_lend_encode_fns[] = {
  Opcode_xsr_lend_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_lcount_encode_fns[] = {
  Opcode_rsr_lcount_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_lcount_encode_fns[] = {
  Opcode_wsr_lcount_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_lcount_encode_fns[] = {
  Opcode_xsr_lcount_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_lbeg_encode_fns[] = {
  Opcode_rsr_lbeg_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_lbeg_encode_fns[] = {
  Opcode_wsr_lbeg_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_lbeg_encode_fns[] = {
  Opcode_xsr_lbeg_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_sar_encode_fns[] = {
  Opcode_rsr_sar_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_sar_encode_fns[] = {
  Opcode_wsr_sar_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_sar_encode_fns[] = {
  Opcode_xsr_sar_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_memctl_encode_fns[] = {
  Opcode_rsr_memctl_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_memctl_encode_fns[] = {
  Opcode_wsr_memctl_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_memctl_encode_fns[] = {
  Opcode_xsr_memctl_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_configid0_encode_fns[] = {
  Opcode_rsr_configid0_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_configid0_encode_fns[] = {
  Opcode_wsr_configid0_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_configid1_encode_fns[] = {
  Opcode_rsr_configid1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_243_encode_fns[] = {
  Opcode_rsr_243_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_ps_encode_fns[] = {
  Opcode_rsr_ps_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_ps_encode_fns[] = {
  Opcode_wsr_ps_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_ps_encode_fns[] = {
  Opcode_xsr_ps_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_epc1_encode_fns[] = {
  Opcode_rsr_epc1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_epc1_encode_fns[] = {
  Opcode_wsr_epc1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_epc1_encode_fns[] = {
  Opcode_xsr_epc1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_excsave1_encode_fns[] = {
  Opcode_rsr_excsave1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_excsave1_encode_fns[] = {
  Opcode_wsr_excsave1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_excsave1_encode_fns[] = {
  Opcode_xsr_excsave1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_epc2_encode_fns[] = {
  Opcode_rsr_epc2_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_epc2_encode_fns[] = {
  Opcode_wsr_epc2_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_epc2_encode_fns[] = {
  Opcode_xsr_epc2_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_excsave2_encode_fns[] = {
  Opcode_rsr_excsave2_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_excsave2_encode_fns[] = {
  Opcode_wsr_excsave2_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_excsave2_encode_fns[] = {
  Opcode_xsr_excsave2_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_epc3_encode_fns[] = {
  Opcode_rsr_epc3_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_epc3_encode_fns[] = {
  Opcode_wsr_epc3_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_epc3_encode_fns[] = {
  Opcode_xsr_epc3_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_excsave3_encode_fns[] = {
  Opcode_rsr_excsave3_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_excsave3_encode_fns[] = {
  Opcode_wsr_excsave3_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_excsave3_encode_fns[] = {
  Opcode_xsr_excsave3_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_epc4_encode_fns[] = {
  Opcode_rsr_epc4_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_epc4_encode_fns[] = {
  Opcode_wsr_epc4_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_epc4_encode_fns[] = {
  Opcode_xsr_epc4_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_excsave4_encode_fns[] = {
  Opcode_rsr_excsave4_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_excsave4_encode_fns[] = {
  Opcode_wsr_excsave4_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_excsave4_encode_fns[] = {
  Opcode_xsr_excsave4_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_epc5_encode_fns[] = {
  Opcode_rsr_epc5_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_epc5_encode_fns[] = {
  Opcode_wsr_epc5_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_epc5_encode_fns[] = {
  Opcode_xsr_epc5_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_excsave5_encode_fns[] = {
  Opcode_rsr_excsave5_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_excsave5_encode_fns[] = {
  Opcode_wsr_excsave5_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_excsave5_encode_fns[] = {
  Opcode_xsr_excsave5_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_eps2_encode_fns[] = {
  Opcode_rsr_eps2_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_eps2_encode_fns[] = {
  Opcode_wsr_eps2_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_eps2_encode_fns[] = {
  Opcode_xsr_eps2_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_eps3_encode_fns[] = {
  Opcode_rsr_eps3_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_eps3_encode_fns[] = {
  Opcode_wsr_eps3_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_eps3_encode_fns[] = {
  Opcode_xsr_eps3_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_eps4_encode_fns[] = {
  Opcode_rsr_eps4_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_eps4_encode_fns[] = {
  Opcode_wsr_eps4_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_eps4_encode_fns[] = {
  Opcode_xsr_eps4_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_eps5_encode_fns[] = {
  Opcode_rsr_eps5_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_eps5_encode_fns[] = {
  Opcode_wsr_eps5_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_eps5_encode_fns[] = {
  Opcode_xsr_eps5_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_excvaddr_encode_fns[] = {
  Opcode_rsr_excvaddr_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_excvaddr_encode_fns[] = {
  Opcode_wsr_excvaddr_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_excvaddr_encode_fns[] = {
  Opcode_xsr_excvaddr_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_depc_encode_fns[] = {
  Opcode_rsr_depc_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_depc_encode_fns[] = {
  Opcode_wsr_depc_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_depc_encode_fns[] = {
  Opcode_xsr_depc_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_exccause_encode_fns[] = {
  Opcode_rsr_exccause_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_exccause_encode_fns[] = {
  Opcode_wsr_exccause_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_exccause_encode_fns[] = {
  Opcode_xsr_exccause_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_misc0_encode_fns[] = {
  Opcode_rsr_misc0_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_misc0_encode_fns[] = {
  Opcode_wsr_misc0_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_misc0_encode_fns[] = {
  Opcode_xsr_misc0_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_misc1_encode_fns[] = {
  Opcode_rsr_misc1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_misc1_encode_fns[] = {
  Opcode_wsr_misc1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_misc1_encode_fns[] = {
  Opcode_xsr_misc1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_prid_encode_fns[] = {
  Opcode_rsr_prid_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_vecbase_encode_fns[] = {
  Opcode_rsr_vecbase_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_vecbase_encode_fns[] = {
  Opcode_wsr_vecbase_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_vecbase_encode_fns[] = {
  Opcode_xsr_vecbase_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_salt_encode_fns[] = {
  Opcode_salt_Slot_inst_encode, 0, 0, Opcode_salt_Slot_f0_s0_encode, Opcode_salt_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_saltu_encode_fns[] = {
  Opcode_saltu_Slot_inst_encode, 0, 0, Opcode_saltu_Slot_f0_s0_encode, Opcode_saltu_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_opmode_encode_fns[] = {
  Opcode_rsr_opmode_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_opmode_encode_fns[] = {
  Opcode_wsr_opmode_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_opmode_encode_fns[] = {
  Opcode_xsr_opmode_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rfi_encode_fns[] = {
  Opcode_rfi_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_waiti_encode_fns[] = {
  Opcode_waiti_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_interrupt_encode_fns[] = {
  Opcode_rsr_interrupt_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_intset_encode_fns[] = {
  Opcode_wsr_intset_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_intclear_encode_fns[] = {
  Opcode_wsr_intclear_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_intenable_encode_fns[] = {
  Opcode_rsr_intenable_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_intenable_encode_fns[] = {
  Opcode_wsr_intenable_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_intenable_encode_fns[] = {
  Opcode_xsr_intenable_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_break_encode_fns[] = {
  Opcode_break_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_break_n_encode_fns[] = {
  0, 0, Opcode_break_n_Slot_inst16b_encode, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_dbreaka0_encode_fns[] = {
  Opcode_rsr_dbreaka0_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_dbreaka0_encode_fns[] = {
  Opcode_wsr_dbreaka0_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_dbreaka0_encode_fns[] = {
  Opcode_xsr_dbreaka0_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_dbreakc0_encode_fns[] = {
  Opcode_rsr_dbreakc0_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_dbreakc0_encode_fns[] = {
  Opcode_wsr_dbreakc0_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_dbreakc0_encode_fns[] = {
  Opcode_xsr_dbreakc0_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_dbreaka1_encode_fns[] = {
  Opcode_rsr_dbreaka1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_dbreaka1_encode_fns[] = {
  Opcode_wsr_dbreaka1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_dbreaka1_encode_fns[] = {
  Opcode_xsr_dbreaka1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_dbreakc1_encode_fns[] = {
  Opcode_rsr_dbreakc1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_dbreakc1_encode_fns[] = {
  Opcode_wsr_dbreakc1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_dbreakc1_encode_fns[] = {
  Opcode_xsr_dbreakc1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_ibreaka0_encode_fns[] = {
  Opcode_rsr_ibreaka0_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_ibreaka0_encode_fns[] = {
  Opcode_wsr_ibreaka0_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_ibreaka0_encode_fns[] = {
  Opcode_xsr_ibreaka0_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_ibreaka1_encode_fns[] = {
  Opcode_rsr_ibreaka1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_ibreaka1_encode_fns[] = {
  Opcode_wsr_ibreaka1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_ibreaka1_encode_fns[] = {
  Opcode_xsr_ibreaka1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_ibreakenable_encode_fns[] = {
  Opcode_rsr_ibreakenable_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_ibreakenable_encode_fns[] = {
  Opcode_wsr_ibreakenable_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_ibreakenable_encode_fns[] = {
  Opcode_xsr_ibreakenable_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_debugcause_encode_fns[] = {
  Opcode_rsr_debugcause_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_debugcause_encode_fns[] = {
  Opcode_wsr_debugcause_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_debugcause_encode_fns[] = {
  Opcode_xsr_debugcause_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_icount_encode_fns[] = {
  Opcode_rsr_icount_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_icount_encode_fns[] = {
  Opcode_wsr_icount_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_icount_encode_fns[] = {
  Opcode_xsr_icount_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_icountlevel_encode_fns[] = {
  Opcode_rsr_icountlevel_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_icountlevel_encode_fns[] = {
  Opcode_wsr_icountlevel_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_icountlevel_encode_fns[] = {
  Opcode_xsr_icountlevel_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_ddr_encode_fns[] = {
  Opcode_rsr_ddr_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_ddr_encode_fns[] = {
  Opcode_wsr_ddr_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_ddr_encode_fns[] = {
  Opcode_xsr_ddr_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_lddr32_p_encode_fns[] = {
  Opcode_lddr32_p_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_sddr32_p_encode_fns[] = {
  Opcode_sddr32_p_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rfdo_encode_fns[] = {
  Opcode_rfdo_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rfdd_encode_fns[] = {
  Opcode_rfdd_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_mmid_encode_fns[] = {
  Opcode_wsr_mmid_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_ccount_encode_fns[] = {
  Opcode_rsr_ccount_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_ccount_encode_fns[] = {
  Opcode_wsr_ccount_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_ccount_encode_fns[] = {
  Opcode_xsr_ccount_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_ccompare0_encode_fns[] = {
  Opcode_rsr_ccompare0_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_ccompare0_encode_fns[] = {
  Opcode_wsr_ccompare0_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_ccompare0_encode_fns[] = {
  Opcode_xsr_ccompare0_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_ccompare1_encode_fns[] = {
  Opcode_rsr_ccompare1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_ccompare1_encode_fns[] = {
  Opcode_wsr_ccompare1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_ccompare1_encode_fns[] = {
  Opcode_xsr_ccompare1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_idtlb_encode_fns[] = {
  Opcode_idtlb_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_pdtlb_encode_fns[] = {
  Opcode_pdtlb_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rdtlb0_encode_fns[] = {
  Opcode_rdtlb0_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rdtlb1_encode_fns[] = {
  Opcode_rdtlb1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wdtlb_encode_fns[] = {
  Opcode_wdtlb_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_iitlb_encode_fns[] = {
  Opcode_iitlb_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_pitlb_encode_fns[] = {
  Opcode_pitlb_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ritlb0_encode_fns[] = {
  Opcode_ritlb0_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ritlb1_encode_fns[] = {
  Opcode_ritlb1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_witlb_encode_fns[] = {
  Opcode_witlb_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_cpenable_encode_fns[] = {
  Opcode_rsr_cpenable_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_cpenable_encode_fns[] = {
  Opcode_wsr_cpenable_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_cpenable_encode_fns[] = {
  Opcode_xsr_cpenable_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_clamps_encode_fns[] = {
  Opcode_clamps_Slot_inst_encode, 0, 0, Opcode_clamps_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_max_encode_fns[] = {
  Opcode_max_Slot_inst_encode, 0, 0, Opcode_max_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_maxu_encode_fns[] = {
  Opcode_maxu_Slot_inst_encode, 0, 0, Opcode_maxu_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_min_encode_fns[] = {
  Opcode_min_Slot_inst_encode, 0, 0, Opcode_min_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_minu_encode_fns[] = {
  Opcode_minu_Slot_inst_encode, 0, 0, Opcode_minu_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_nsa_encode_fns[] = {
  Opcode_nsa_Slot_inst_encode, 0, 0, Opcode_nsa_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_nsau_encode_fns[] = {
  Opcode_nsau_Slot_inst_encode, 0, 0, Opcode_nsau_Slot_f0_s0_encode, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_sext_encode_fns[] = {
  Opcode_sext_Slot_inst_encode, 0, 0, Opcode_sext_Slot_f0_s0_encode, Opcode_sext_Slot_f0_s1_encode, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_l32ai_encode_fns[] = {
  Opcode_l32ai_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_s32ri_encode_fns[] = {
  Opcode_s32ri_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_s32c1i_encode_fns[] = {
  Opcode_s32c1i_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_scompare1_encode_fns[] = {
  Opcode_rsr_scompare1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_scompare1_encode_fns[] = {
  Opcode_wsr_scompare1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_scompare1_encode_fns[] = {
  Opcode_xsr_scompare1_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_atomctl_encode_fns[] = {
  Opcode_rsr_atomctl_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_atomctl_encode_fns[] = {
  Opcode_wsr_atomctl_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_atomctl_encode_fns[] = {
  Opcode_xsr_atomctl_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_quos_encode_fns[] = {
  Opcode_quos_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_quou_encode_fns[] = {
  Opcode_quou_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rems_encode_fns[] = {
  Opcode_rems_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_remu_encode_fns[] = {
  Opcode_remu_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rsr_eraccess_encode_fns[] = {
  Opcode_rsr_eraccess_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wsr_eraccess_encode_fns[] = {
  Opcode_wsr_eraccess_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_xsr_eraccess_encode_fns[] = {
  Opcode_xsr_eraccess_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rer_encode_fns[] = {
  Opcode_rer_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wer_encode_fns[] = {
  Opcode_wer_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_beqz_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_beqz_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bgez_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_bgez_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bltz_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_bltz_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bnez_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_bnez_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_beqi_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_beqi_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bgei_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_bgei_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_blti_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_blti_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bnei_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_bnei_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bgeui_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_bgeui_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bltui_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_bltui_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bbci_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_bbci_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bbsi_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_bbsi_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ball_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_ball_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bany_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_bany_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bbc_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_bbc_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bbs_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_bbs_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_beq_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_beq_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bgeu_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_bgeu_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bge_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_bge_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bltu_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_bltu_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_blt_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_blt_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bnall_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_bnall_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bne_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_bne_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_bnone_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_bnone_w15_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_loop_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_loop_w15_Slot_f2_s0_encode, Opcode_loop_w15_Slot_f3_s0_encode, 0
};

static xtensa_opcode_encode_fn Opcode_loopgtz_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_loopgtz_w15_Slot_f2_s0_encode, Opcode_loopgtz_w15_Slot_f3_s0_encode, 0
};

static xtensa_opcode_encode_fn Opcode_loopnez_w15_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_loopnez_w15_Slot_f2_s0_encode, Opcode_loopnez_w15_Slot_f3_s0_encode, 0
};

static xtensa_opcode_encode_fn Opcode_read_impwire_encode_fns[] = {
  Opcode_read_impwire_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_setb_expstate_encode_fns[] = {
  Opcode_setb_expstate_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_clrb_expstate_encode_fns[] = {
  Opcode_clrb_expstate_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wrmsk_expstate_encode_fns[] = {
  Opcode_wrmsk_expstate_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_expstate_encode_fns[] = {
  Opcode_rur_expstate_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_expstate_encode_fns[] = {
  Opcode_wur_expstate_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_bithead_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_rur_ae_bithead_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_bithead_encode_fns[] = {
  Opcode_wur_ae_bithead_Slot_inst_encode, 0, 0, Opcode_wur_ae_bithead_Slot_f0_s0_encode, 0, Opcode_wur_ae_bithead_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_cbegin0_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_rur_ae_cbegin0_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_cbegin0_encode_fns[] = {
  Opcode_wur_ae_cbegin0_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_cend0_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_rur_ae_cend0_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_cend0_encode_fns[] = {
  Opcode_wur_ae_cend0_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_overflow_encode_fns[] = {
  Opcode_rur_ae_overflow_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_overflow_encode_fns[] = {
  Opcode_wur_ae_overflow_Slot_inst_encode, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_sar_encode_fns[] = {
  Opcode_rur_ae_sar_Slot_inst_encode, 0, 0, Opcode_rur_ae_sar_Slot_f0_s0_encode, 0, Opcode_rur_ae_sar_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_sar_encode_fns[] = {
  Opcode_wur_ae_sar_Slot_inst_encode, 0, 0, Opcode_wur_ae_sar_Slot_f0_s0_encode, 0, Opcode_wur_ae_sar_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_bitptr_encode_fns[] = {
  Opcode_rur_ae_bitptr_Slot_inst_encode, 0, 0, Opcode_rur_ae_bitptr_Slot_f0_s0_encode, 0, Opcode_rur_ae_bitptr_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_bitptr_encode_fns[] = {
  Opcode_wur_ae_bitptr_Slot_inst_encode, 0, 0, Opcode_wur_ae_bitptr_Slot_f0_s0_encode, 0, Opcode_wur_ae_bitptr_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_bitsused_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_rur_ae_bitsused_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_bitsused_encode_fns[] = {
  Opcode_wur_ae_bitsused_Slot_inst_encode, 0, 0, Opcode_wur_ae_bitsused_Slot_f0_s0_encode, 0, Opcode_wur_ae_bitsused_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_tablesize_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_rur_ae_tablesize_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_tablesize_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_wur_ae_tablesize_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_first_ts_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_rur_ae_first_ts_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_first_ts_encode_fns[] = {
  Opcode_wur_ae_first_ts_Slot_inst_encode, 0, 0, Opcode_wur_ae_first_ts_Slot_f0_s0_encode, 0, Opcode_wur_ae_first_ts_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_nextoffset_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_rur_ae_nextoffset_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_nextoffset_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_wur_ae_nextoffset_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_searchdone_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_rur_ae_searchdone_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_searchdone_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_wur_ae_searchdone_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_rur_ae_cwrap_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_rur_ae_cwrap_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_wur_ae_cwrap_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_wur_ae_cwrap_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_movcircv_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_ae_movcircv_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_movvcirc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_ae_movvcirc_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_movfusionmiscv_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_ae_movfusionmiscv_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_movvfusionmisc_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_ae_movvfusionmisc_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_movtablefirstsearchnextv_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_ae_movtablefirstsearchnextv_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_movvtablefirstsearchnext_encode_fns[] = {
  0, 0, 0, 0, 0, 0, 0, Opcode_ae_movvtablefirstsearchnext_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8_i_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8_i_Slot_f0_s0_encode, 0, Opcode_ae_l8_i_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8_ip_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8_ip_Slot_f0_s0_encode, 0, Opcode_ae_l8_ip_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8_x_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8_x_Slot_f0_s0_encode, 0, Opcode_ae_l8_x_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8_xp_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8_xp_Slot_f0_s0_encode, 0, Opcode_ae_l8_xp_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8s_i_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8s_i_Slot_f0_s0_encode, 0, Opcode_ae_l8s_i_Slot_f1_s0_encode, 0, Opcode_ae_l8s_i_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8s_ip_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8s_ip_Slot_f0_s0_encode, 0, Opcode_ae_l8s_ip_Slot_f1_s0_encode, 0, Opcode_ae_l8s_ip_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8u_i_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8u_i_Slot_f0_s0_encode, 0, Opcode_ae_l8u_i_Slot_f1_s0_encode, 0, Opcode_ae_l8u_i_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8u_ip_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8u_ip_Slot_f0_s0_encode, 0, Opcode_ae_l8u_ip_Slot_f1_s0_encode, 0, Opcode_ae_l8u_ip_Slot_f2_s0_encode, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8x4f_i_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8x4f_i_Slot_f0_s0_encode, 0, Opcode_ae_l8x4f_i_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8x4f_ip_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8x4f_ip_Slot_f0_s0_encode, 0, Opcode_ae_l8x4f_ip_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8x4f_x_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8x4f_x_Slot_f0_s0_encode, 0, Opcode_ae_l8x4f_x_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8x4f_xp_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8x4f_xp_Slot_f0_s0_encode, 0, Opcode_ae_l8x4f_xp_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8x4s_i_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8x4s_i_Slot_f0_s0_encode, 0, Opcode_ae_l8x4s_i_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8x4s_ip_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8x4s_ip_Slot_f0_s0_encode, 0, Opcode_ae_l8x4s_ip_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8x4s_x_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8x4s_x_Slot_f0_s0_encode, 0, Opcode_ae_l8x4s_x_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8x4s_xp_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8x4s_xp_Slot_f0_s0_encode, 0, Opcode_ae_l8x4s_xp_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8x4u_i_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8x4u_i_Slot_f0_s0_encode, 0, Opcode_ae_l8x4u_i_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8x4u_ip_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8x4u_ip_Slot_f0_s0_encode, 0, Opcode_ae_l8x4u_ip_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8x4u_x_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8x4u_x_Slot_f0_s0_encode, 0, Opcode_ae_l8x4u_x_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8x4u_xp_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8x4u_xp_Slot_f0_s0_encode, 0, Opcode_ae_l8x4u_xp_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8x8_i_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8x8_i_Slot_f0_s0_encode, 0, Opcode_ae_l8x8_i_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8x8_ip_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8x8_ip_Slot_f0_s0_encode, 0, Opcode_ae_l8x8_ip_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xtensa_opcode_encode_fn Opcode_ae_l8x8_x_encode_fns[] = {
  0, 0, 0, Opcode_ae_l8x8_x_Slot_f0_s0_encode, 0, Opcode_ae_l8x8_x_Slot_f1_s0_encode, 0, 0, 0, 0
};

static xten