/* Configuration for the Xtensa architecture for GDB, the GNU debugger.

   Copyright (c) 2003-2023 Cadence Design Systems, Inc.

   Permission is hereby granted, free of charge, to any person obtaining
   a copy of this software and associated documentation files (the
   "Software"), to deal in the Software without restriction, including
   without limitation the rights to use, copy, modify, merge, publish,
   distribute, sublicense, and/or sell copies of the Software, and to
   permit persons to whom the Software is furnished to do so, subject to
   the following conditions:

   The above copyright notice and this permission notice shall be included
   in all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
   CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
   TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
   SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.  */

#define XTENSA_CONFIG_VERSION 0x70

#include "defs.h"
#include "xtensa-config.h"
#include "xtensa-tdep.h"



/* Masked registers.  */
xtensa_reg_mask_t xtensa_submask0[] = { { 108, 0, 1 } };
const xtensa_mask_t xtensa_mask0 = { 1, xtensa_submask0 };
xtensa_reg_mask_t xtensa_submask1[] = { { 41, 0, 4 } };
const xtensa_mask_t xtensa_mask1 = { 1, xtensa_submask1 };
xtensa_reg_mask_t xtensa_submask2[] = { { 41, 5, 1 } };
const xtensa_mask_t xtensa_mask2 = { 1, xtensa_submask2 };
xtensa_reg_mask_t xtensa_submask3[] = { { 41, 18, 1 } };
const xtensa_mask_t xtensa_mask3 = { 1, xtensa_submask3 };
xtensa_reg_mask_t xtensa_submask4[] = { { 41, 4, 1 } };
const xtensa_mask_t xtensa_mask4 = { 1, xtensa_submask4 };
xtensa_reg_mask_t xtensa_submask5[] = { { 41, 16, 2 } };
const xtensa_mask_t xtensa_mask5 = { 1, xtensa_submask5 };
xtensa_reg_mask_t xtensa_submask6[] = { { 41, 8, 4 } };
const xtensa_mask_t xtensa_mask6 = { 1, xtensa_submask6 };
xtensa_reg_mask_t xtensa_submask7[] = { { 110, 8, 4 } };
const xtensa_mask_t xtensa_mask7 = { 1, xtensa_submask7 };
xtensa_reg_mask_t xtensa_submask8[] = { { 75, 7, 1 } };
const xtensa_mask_t xtensa_mask8 = { 1, xtensa_submask8 };
xtensa_reg_mask_t xtensa_submask9[] = { { 73, 32, 32 } };
const xtensa_mask_t xtensa_mask9 = { 1, xtensa_submask9 };
xtensa_reg_mask_t xtensa_submask10[] = { { 73, 0, 32 } };
const xtensa_mask_t xtensa_mask10 = { 1, xtensa_submask10 };
xtensa_reg_mask_t xtensa_submask11[] = { { 75, 0, 7 } };
const xtensa_mask_t xtensa_mask11 = { 1, xtensa_submask11 };
xtensa_reg_mask_t xtensa_submask12[] = { { 75, 8, 1 } };
const xtensa_mask_t xtensa_mask12 = { 1, xtensa_submask12 };
xtensa_reg_mask_t xtensa_submask13[] = { { 75, 17, 32 } };
const xtensa_mask_t xtensa_mask13 = { 1, xtensa_submask13 };
xtensa_reg_mask_t xtensa_submask14[] = { { 75, 13, 4 } };
const xtensa_mask_t xtensa_mask14 = { 1, xtensa_submask14 };
xtensa_reg_mask_t xtensa_submask15[] = { { 75, 9, 4 } };
const xtensa_mask_t xtensa_mask15 = { 1, xtensa_submask15 };
xtensa_reg_mask_t xtensa_submask16[] = { { 74, 32, 4 } };
const xtensa_mask_t xtensa_mask16 = { 1, xtensa_submask16 };
xtensa_reg_mask_t xtensa_submask17[] = { { 74, 28, 4 } };
const xtensa_mask_t xtensa_mask17 = { 1, xtensa_submask17 };
xtensa_reg_mask_t xtensa_submask18[] = { { 74, 0, 27 } };
const xtensa_mask_t xtensa_mask18 = { 1, xtensa_submask18 };
xtensa_reg_mask_t xtensa_submask19[] = { { 74, 27, 1 } };
const xtensa_mask_t xtensa_mask19 = { 1, xtensa_submask19 };
xtensa_reg_mask_t xtensa_submask20[] = { { 76, 8, 2 } };
const xtensa_mask_t xtensa_mask20 = { 1, xtensa_submask20 };
xtensa_reg_mask_t xtensa_submask21[] = { { 76, 2, 5 } };
const xtensa_mask_t xtensa_mask21 = { 1, xtensa_submask21 };
xtensa_reg_mask_t xtensa_submask22[] = { { 76, 10, 5 } };
const xtensa_mask_t xtensa_mask22 = { 1, xtensa_submask22 };


/* Register map.  */
xtensa_register_t rmap[] = 
{
  /*    idx ofs bi sz al targno  flags cp typ group name  */
  XTREG(  0,  0,32, 4, 4,0x0020,0x0006,-2, 9,0x2100,pc,          0,0,0,0,0,0)
  XTREG(  1,  4,32, 4, 4,0x0100,0x0006,-2, 1,0x0002,ar0,         0,0,0,0,0,0)
  XTREG(  2,  8,32, 4, 4,0x0101,0x0006,-2, 1,0x0002,ar1,         0,0,0,0,0,0)
  XTREG(  3, 12,32, 4, 4,0x0102,0x0006,-2, 1,0x0002,ar2,         0,0,0,0,0,0)
  XTREG(  4, 16,32, 4, 4,0x0103,0x0006,-2, 1,0x0002,ar3,         0,0,0,0,0,0)
  XTREG(  5, 20,32, 4, 4,0x0104,0x0006,-2, 1,0x0002,ar4,         0,0,0,0,0,0)
  XTREG(  6, 24,32, 4, 4,0x0105,0x0006,-2, 1,0x0002,ar5,         0,0,0,0,0,0)
  XTREG(  7, 28,32, 4, 4,0x0106,0x0006,-2, 1,0x0002,ar6,         0,0,0,0,0,0)
  XTREG(  8, 32,32, 4, 4,0x0107,0x0006,-2, 1,0x0002,ar7,         0,0,0,0,0,0)
  XTREG(  9, 36,32, 4, 4,0x0108,0x0006,-2, 1,0x0002,ar8,         0,0,0,0,0,0)
  XTREG( 10, 40,32, 4, 4,0x0109,0x0006,-2, 1,0x0002,ar9,         0,0,0,0,0,0)
  XTREG( 11, 44,32, 4, 4,0x010a,0x0006,-2, 1,0x0002,ar10,        0,0,0,0,0,0)
  XTREG( 12, 48,32, 4, 4,0x010b,0x0006,-2, 1,0x0002,ar11,        0,0,0,0,0,0)
  XTREG( 13, 52,32, 4, 4,0x010c,0x0006,-2, 1,0x0002,ar12,        0,0,0,0,0,0)
  XTREG( 14, 56,32, 4, 4,0x010d,0x0006,-2, 1,0x0002,ar13,        0,0,0,0,0,0)
  XTREG( 15, 60,32, 4, 4,0x010e,0x0006,-2, 1,0x0002,ar14,        0,0,0,0,0,0)
  XTREG( 16, 64,32, 4, 4,0x010f,0x0006,-2, 1,0x0002,ar15,        0,0,0,0,0,0)
  XTREG( 17, 68,32, 4, 4,0x0110,0x0006,-2, 1,0x0002,ar16,        0,0,0,0,0,0)
  XTREG( 18, 72,32, 4, 4,0x0111,0x0006,-2, 1,0x0002,ar17,        0,0,0,0,0,0)
  XTREG( 19, 76,32, 4, 4,0x0112,0x0006,-2, 1,0x0002,ar18,        0,0,0,0,0,0)
  XTREG( 20, 80,32, 4, 4,0x0113,0x0006,-2, 1,0x0002,ar19,        0,0,0,0,0,0)
  XTREG( 21, 84,32, 4, 4,0x0114,0x0006,-2, 1,0x0002,ar20,        0,0,0,0,0,0)
  XTREG( 22, 88,32, 4, 4,0x0115,0x0006,-2, 1,0x0002,ar21,        0,0,0,0,0,0)
  XTREG( 23, 92,32, 4, 4,0x0116,0x0006,-2, 1,0x0002,ar22,        0,0,0,0,0,0)
  XTREG( 24, 96,32, 4, 4,0x0117,0x0006,-2, 1,0x0002,ar23,        0,0,0,0,0,0)
  XTREG( 25,100,32, 4, 4,0x0118,0x0006,-2, 1,0x0002,ar24,        0,0,0,0,0,0)
  XTREG( 26,104,32, 4, 4,0x0119,0x0006,-2, 1,0x0002,ar25,        0,0,0,0,0,0)
  XTREG( 27,108,32, 4, 4,0x011a,0x0006,-2, 1,0x0002,ar26,        0,0,0,0,0,0)
  XTREG( 28,112,32, 4, 4,0x011b,0x0006,-2, 1,0x0002,ar27,        0,0,0,0,0,0)
  XTREG( 29,116,32, 4, 4,0x011c,0x0006,-2, 1,0x0002,ar28,        0,0,0,0,0,0)
  XTREG( 30,120,32, 4, 4,0x011d,0x0006,-2, 1,0x0002,ar29,        0,0,0,0,0,0)
  XTREG( 31,124,32, 4, 4,0x011e,0x0006,-2, 1,0x0002,ar30,        0,0,0,0,0,0)
  XTREG( 32,128,32, 4, 4,0x011f,0x0006,-2, 1,0x0002,ar31,        0,0,0,0,0,0)
  XTREG( 33,132,32, 4, 4,0x0200,0x0006,-2, 2,0x1100,lbeg,        0,0,0,0,0,0)
  XTREG( 34,136,32, 4, 4,0x0201,0x0006,-2, 2,0x1100,lend,        0,0,0,0,0,0)
  XTREG( 35,140,32, 4, 4,0x0202,0x0006,-2, 2,0x1100,lcount,      0,0,0,0,0,0)
  XTREG( 36,144, 6, 4, 4,0x0203,0x0006,-2, 2,0x1100,sar,         0,0,0,0,0,0)
  XTREG( 37,148, 3, 4, 4,0x0248,0x0006,-2, 2,0x1002,windowbase,  0,0,0,0,0,0)
  XTREG( 38,152, 8, 4, 4,0x0249,0x0006,-2, 2,0x1002,windowstart, 0,0,0,0,0,0)
  XTREG( 39,156,32, 4, 4,0x02b0,0x0002,-2, 2,0x1000,configid0,   0,0,0,0,0,0)
  XTREG( 40,160,32, 4, 4,0x02d0,0x0002,-2, 2,0x1000,configid1,   0,0,0,0,0,0)
  XTREG( 41,164,19, 4, 4,0x02e6,0x0006,-2, 2,0x1100,ps,          0,0,0,0,0,0)
  XTREG( 42,168,32, 4, 4,0x03e7,0x0006,-2, 3,0x0110,threadptr,   0,0,0,0,0,0)
  XTREG( 43,172, 8, 1, 1,0x1018,0x0006,-2, 4,0x0101,vb0,
            "03:52:64:01:06:5e:18:33:33:f0:f8:03:52:44:00:03:52:24:01","03:52:64:01:03:52:04:00:06:0e:05:33:33:f0:f8:03:52:24:01",0,0,0,0)
  XTREG( 44,173, 8, 1, 1,0x1019,0x0006,-2, 4,0x0101,vb1,
            "03:52:64:01:06:5e:19:33:33:f0:f8:03:52:44:00:03:52:24:01","03:52:64:01:03:52:04:00:06:1e:05:33:33:f0:f8:03:52:24:01",0,0,0,0)
  XTREG( 45,174, 8, 1, 1,0x101a,0x0006,-2, 4,0x0101,vb2,
            "03:52:64:01:06:5e:1a:33:33:f0:f8:03:52:44:00:03:52:24:01","03:52:64:01:03:52:04:00:06:0e:45:33:33:f0:f8:03:52:24:01",0,0,0,0)
  XTREG( 46,175, 8, 1, 1,0x101b,0x0006,-2, 4,0x0101,vb3,
            "03:52:64:01:06:5e:1b:33:33:f0:f8:03:52:44:00:03:52:24:01","03:52:64:01:03:52:04:00:06:1e:45:33:33:f0:f8:03:52:24:01",0,0,0,0)
  XTREG( 47,176, 8, 1, 1,0x101c,0x0006,-2, 4,0x0101,vb4,
            "03:52:64:01:06:5e:1c:33:33:f0:f8:03:52:44:00:03:52:24:01","03:52:64:01:03:52:04:00:06:0e:85:33:33:f0:f8:03:52:24:01",0,0,0,0)
  XTREG( 48,177, 8, 1, 1,0x101d,0x0006,-2, 4,0x0101,vb5,
            "03:52:64:01:06:5e:1d:33:33:f0:f8:03:52:44:00:03:52:24:01","03:52:64:01:03:52:04:00:06:1e:85:33:33:f0:f8:03:52:24:01",0,0,0,0)
  XTREG( 49,178, 8, 1, 1,0x101e,0x0006,-2, 4,0x0101,vb6,
            "03:52:64:01:06:5e:1e:33:33:f0:f8:03:52:44:00:03:52:24:01","03:52:64:01:03:52:04:00:06:0e:c5:33:33:f0:f8:03:52:24:01",0,0,0,0)
  XTREG( 50,179, 8, 1, 1,0x101f,0x0006,-2, 4,0x0101,vb7,
            "03:52:64:01:06:5e:1f:33:33:f0:f8:03:52:44:00:03:52:24:01","03:52:64:01:03:52:04:00:06:1e:c5:33:33:f0:f8:03:52:24:01",0,0,0,0)
  XTREG( 51,180,32, 4, 4,0x020c,0x0006,-1, 2,0x1100,scompare1,   0,0,0,0,0,0)
  XTREG( 52,184,32, 4, 4,0x03e6,0x000e,-1, 3,0x0110,expstate,    0,0,0,0,0,0)
  XTREG( 53,188,64, 8, 8,0x1000,0x0006, 1, 4,0x0101,aed0,
            "03:44:01:04","03:44:02:00",0,0,0,0)
  XTREG( 54,196,64, 8, 8,0x1001,0x0006, 1, 4,0x0101,aed1,
            "03:44:11:04","03:44:12:00",0,0,0,0)
  XTREG( 55,204,64, 8, 8,0x1002,0x0006, 1, 4,0x0101,aed2,
            "03:44:21:04","03:44:22:00",0,0,0,0)
  XTREG( 56,212,64, 8, 8,0x1003,0x0006, 1, 4,0x0101,aed3,
            "03:44:31:04","03:44:32:00",0,0,0,0)
  XTREG( 57,220,64, 8, 8,0x1004,0x0006, 1, 4,0x0101,aed4,
            "03:44:41:04","03:44:42:00",0,0,0,0)
  XTREG( 58,228,64, 8, 8,0x1005,0x0006, 1, 4,0x0101,aed5,
            "03:44:51:04","03:44:52:00",0,0,0,0)
  XTREG( 59,236,64, 8, 8,0x1006,0x0006, 1, 4,0x0101,aed6,
            "03:44:61:04","03:44:62:00",0,0,0,0)
  XTREG( 60,244,64, 8, 8,0x1007,0x0006, 1, 4,0x0101,aed7,
            "03:44:71:04","03:44:72:00",0,0,0,0)
  XTREG( 61,252,64, 8, 8,0x1008,0x0006, 1, 4,0x0101,aed8,
            "03:44:81:04","03:44:82:00",0,0,0,0)
  XTREG( 62,260,64, 8, 8,0x1009,0x0006, 1, 4,0x0101,aed9,
            "03:44:91:04","03:44:92:00",0,0,0,0)
  XTREG( 63,268,64, 8, 8,0x100a,0x0006, 1, 4,0x0101,aed10,
            "03:44:a1:04","03:44:a2:00",0,0,0,0)
  XTREG( 64,276,64, 8, 8,0x100b,0x0006, 1, 4,0x0101,aed11,
            "03:44:b1:04","03:44:b2:00",0,0,0,0)
  XTREG( 65,284,64, 8, 8,0x100c,0x0006, 1, 4,0x0101,aed12,
            "03:44:c1:04","03:44:c2:00",0,0,0,0)
  XTREG( 66,292,64, 8, 8,0x100d,0x0006, 1, 4,0x0101,aed13,
            "03:44:d1:04","03:44:d2:00",0,0,0,0)
  XTREG( 67,300,64, 8, 8,0x100e,0x0006, 1, 4,0x0101,aed14,
            "03:44:e1:04","03:44:e2:00",0,0,0,0)
  XTREG( 68,308,64, 8, 8,0x100f,0x0006, 1, 4,0x0101,aed15,
            "03:44:f1:04","03:44:f2:00",0,0,0,0)
  XTREG( 69,316,64, 8, 8,0x1010,0x0006, 1, 4,0x0101,u0,
            "03:42:30:00","03:40:30:0c",0,0,0,0)
  XTREG( 70,324,64, 8, 8,0x1011,0x0006, 1, 4,0x0101,u1,
            "03:42:31:00","03:40:31:0c",0,0,0,0)
  XTREG( 71,332,64, 8, 8,0x1012,0x0006, 1, 4,0x0101,u2,
            "03:42:32:00","03:40:32:0c",0,0,0,0)
  XTREG( 72,340,64, 8, 8,0x1013,0x0006, 1, 4,0x0101,u3,
            "03:42:33:00","03:40:33:0c",0,0,0,0)
  XTREG( 73,348,64, 8, 4,0x1020,0x0006, 1, 3,0x0200,circ,
            "03:44:05:04:05:df:09:47:e8:02:03:44:01:04:03:44:06:00","03:44:05:04:03:44:02:00:05:df:09:41:e8:02:03:44:06:00",0,0,0,0)
  XTREG( 74,356,36, 8, 4,0x1021,0x0006, 1, 3,0x0200,tablefirstsearchnext,
            "03:44:05:04:05:df:09:4b:e8:02:03:44:01:04:03:44:06:00","03:44:05:04:03:44:02:00:05:df:09:45:e8:02:03:44:06:00",0,0,0,0)
  XTREG( 75,364,49, 8, 4,0x1022,0x0006, 1, 3,0x0200,fusionmisc,
            "03:44:05:04:05:df:09:4f:e8:02:03:44:01:04:03:44:06:00","03:44:05:04:03:44:02:00:05:df:09:4d:e8:02:03:44:06:00",0,0,0,0)
  XTREG( 76,372,15, 4, 4,0x1023,0x0006, 1, 3,0x0200,fcr_fsr,
            "03:44:05:04:05:df:09:49:e8:02:03:44:01:04:03:44:06:00","03:44:05:04:03:44:02:00:05:df:09:43:e8:02:03:44:06:00",0,0,0,0)
  XTREG( 77,376,32, 4, 4,0x0259,0x000d,-2, 2,0x1000,mmid,        0,0,0,0,0,0)
  XTREG( 78,380, 2, 4, 4,0x0260,0x0007,-2, 2,0x1000,ibreakenable,0,0,0,0,0,0)
  XTREG( 79,384, 1, 4, 4,0x0261,0x0007,-2, 2,0x1000,memctl,      0,0,0,0,0,0)
  XTREG( 80,388, 6, 4, 4,0x0263,0x0007,-2, 2,0x1000,atomctl,     0,0,0,0,0,0)
  XTREG( 81,392,32, 4, 4,0x0268,0x0007,-2, 2,0x1000,ddr,         0,0,0,0,0,0)
  XTREG( 82,396,32, 4, 4,0x0280,0x0007,-2, 2,0x1000,ibreaka0,    0,0,0,0,0,0)
  XTREG( 83,400,32, 4, 4,0x0281,0x0007,-2, 2,0x1000,ibreaka1,    0,0,0,0,0,0)
  XTREG( 84,404,32, 4, 4,0x0290,0x0007,-2, 2,0x1000,dbreaka0,    0,0,0,0,0,0)
  XTREG( 85,408,32, 4, 4,0x0291,0x0007,-2, 2,0x1000,dbreaka1,    0,0,0,0,0,0)
  XTREG( 86,412,32, 4, 4,0x02a0,0x0007,-2, 2,0x1000,dbreakc0,    0,0,0,0,0,0)
  XTREG( 87,416,32, 4, 4,0x02a1,0x0007,-2, 2,0x1000,dbreakc1,    0,0,0,0,0,0)
  XTREG( 88,420,32, 4, 4,0x02b1,0x0007,-2, 2,0x1000,epc1,        0,0,0,0,0,0)
  XTREG( 89,424,32, 4, 4,0x02b2,0x0007,-2, 2,0x1000,epc2,        0,0,0,0,0,0)
  XTREG( 90,428,32, 4, 4,0x02b3,0x0007,-2, 2,0x1000,epc3,        0,0,0,0,0,0)
  XTREG( 91,432,32, 4, 4,0x02b4,0x0007,-2, 2,0x1000,epc4,        0,0,0,0,0,0)
  XTREG( 92,436,32, 4, 4,0x02b5,0x0007,-2, 2,0x1000,epc5,        0,0,0,0,0,0)
  XTREG( 93,440,32, 4, 4,0x02c0,0x0007,-2, 2,0x1000,depc,        0,0,0,0,0,0)
  XTREG( 94,444,19, 4, 4,0x02c2,0x0007,-2, 2,0x1000,eps2,        0,0,0,0,0,0)
  XTREG( 95,448,19, 4, 4,0x02c3,0x0007,-2, 2,0x1000,eps3,        0,0,0,0,0,0)
  XTREG( 96,452,19, 4, 4,0x02c4,0x0007,-2, 2,0x1000,eps4,        0,0,0,0,0,0)
  XTREG( 97,456,19, 4, 4,0x02c5,0x0007,-2, 2,0x1000,eps5,        0,0,0,0,0,0)
  XTREG( 98,460,32, 4, 4,0x02d1,0x0007,-2, 2,0x1000,excsave1,    0,0,0,0,0,0)
  XTREG( 99,464,32, 4, 4,0x02d2,0x0007,-2, 2,0x1000,excsave2,    0,0,0,0,0,0)
  XTREG(100,468,32, 4, 4,0x02d3,0x0007,-2, 2,0x1000,excsave3,    0,0,0,0,0,0)
  XTREG(101,472,32, 4, 4,0x02d4,0x0007,-2, 2,0x1000,excsave4,    0,0,0,0,0,0)
  XTREG(102,476,32, 4, 4,0x02d5,0x0007,-2, 2,0x1000,excsave5,    0,0,0,0,0,0)
  XTREG(103,480, 2, 4, 4,0x02e0,0x0007,-2, 2,0x1000,cpenable,    0,0,0,0,0,0)
  XTREG(104,484,32, 4, 4,0x02e2,0x000b,-2, 2,0x1000,interrupt,   0,0,0,0,0,0)
  XTREG(105,488,32, 4, 4,0x02e2,0x000d,-2, 2,0x1000,intset,      0,0,0,0,0,0)
  XTREG(106,492,32, 4, 4,0x02e3,0x000d,-2, 2,0x1000,intclear,    0,0,0,0,0,0)
  XTREG(107,496,32, 4, 4,0x02e4,0x0007,-2, 2,0x1000,intenable,   0,0,0,0,0,0)
  XTREG(108,500,32, 4, 4,0x02e7,0x0007,-2, 2,0x1000,vecbase,     0,0,0,0,0,0)
  XTREG(109,504, 6, 4, 4,0x02e8,0x0007,-2, 2,0x1000,exccause,    0,0,0,0,0,0)
  XTREG(110,508,12, 4, 4,0x02e9,0x0003,-2, 2,0x1000,debugcause,  0,0,0,0,0,0)
  XTREG(111,512,32, 4, 4,0x02ea,0x000f,-2, 2,0x1000,ccount,      0,0,0,0,0,0)
  XTREG(112,516,32, 4, 4,0x02eb,0x0003,-2, 2,0x1000,prid,        0,0,0,0,0,0)
  XTREG(113,520,32, 4, 4,0x02ec,0x000f,-2, 2,0x1000,icount,      0,0,0,0,0,0)
  XTREG(114,524, 4, 4, 4,0x02ed,0x0007,-2, 2,0x1000,icountlevel, 0,0,0,0,0,0)
  XTREG(115,528,32, 4, 4,0x02ee,0x0007,-2, 2,0x1000,excvaddr,    0,0,0,0,0,0)
  XTREG(116,532,32, 4, 4,0x02f0,0x000f,-2, 2,0x1000,ccompare0,   0,0,0,0,0,0)
  XTREG(117,536,32, 4, 4,0x02f1,0x000f,-2, 2,0x1000,ccompare1,   0,0,0,0,0,0)
  XTREG(118,540,32, 4, 4,0x02f4,0x0007,-2, 2,0x1000,misc0,       0,0,0,0,0,0)
  XTREG(119,544,32, 4, 4,0x02f5,0x0007,-2, 2,0x1000,misc1,       0,0,0,0,0,0)
  XTREG(120,548,32, 4, 4,0x2022,0x000f,-2, 4,0x0101,pwrctl,
            "03:52:64:01:03:62:64:02:03:52:a4:0c:03:60:55:11:03:52:c5:20:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:0c:03:60:55:11:03:52:c5:20:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(121,552,32, 4, 4,0x2023,0x000f,-2, 4,0x0101,pwrstat,
            "03:52:64:01:03:62:64:02:03:52:a4:0c:03:60:55:11:03:52:c5:24:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:0c:03:60:55:11:03:52:c5:24:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(122,556, 1, 4, 4,0x2024,0x000f,-2, 4,0x0101,eristat,
            "03:52:64:01:03:62:64:02:03:52:a4:0c:03:60:55:11:03:52:c5:28:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:0c:03:60:55:11:03:52:c5:28:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(123,560,32, 4, 4,0x2025,0x000f,-2, 4,0x0101,cs_itctrl,
            "03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:d5:03:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:d5:03:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(124,564,16, 4, 4,0x2026,0x000f,-2, 4,0x0101,cs_claimset,
            "03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:c5:a0:03:52:d5:04:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:c5:a0:03:52:d5:04:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(125,568,16, 4, 4,0x2027,0x000f,-2, 4,0x0101,cs_claimclr,
            "03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:c5:a4:03:52:d5:04:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:c5:a4:03:52:d5:04:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(126,572,32, 4, 4,0x2028,0x000d,-2, 4,0x0101,cs_lockaccess,
            "03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:c5:b0:03:52:d5:04:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:c5:b0:03:52:d5:04:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(127,576,32, 4, 4,0x2029,0x000b,-2, 4,0x0101,cs_lockstatus,
            "03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:c5:b4:03:52:d5:04:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:c5:b4:03:52:d5:04:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(128,580, 1, 4, 4,0x202a,0x000b,-2, 4,0x0101,cs_authstatus,
            "03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:c5:b8:03:52:d5:04:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:0f:03:60:55:11:03:52:c5:b8:03:52:d5:04:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(129,584,32, 4, 4,0x2039,0x000f,-2, 4,0x0101,fault_info,
            "03:52:64:01:03:62:64:02:03:52:a4:0c:03:60:55:11:03:52:c5:30:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:0c:03:60:55:11:03:52:c5:30:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(130,588,32, 4, 4,0x203a,0x0003,-2, 4,0x0101,trax_id,
            "03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(131,592,32, 4, 4,0x203b,0x000f,-2, 4,0x0101,trax_control,
            "03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:04:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:04:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(132,596,32, 4, 4,0x203c,0x000b,-2, 4,0x0101,trax_status,
            "03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:08:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:08:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(133,600,32, 4, 4,0x203d,0x000f,-2, 4,0x0101,trax_data,
            "03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:0c:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:0c:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(134,604,32, 4, 4,0x203e,0x000f,-2, 4,0x0101,trax_address,
            "03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:10:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:10:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(135,608,32, 4, 4,0x203f,0x000f,-2, 4,0x0101,trax_pctrigger,
            "03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:14:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:14:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(136,612,32, 4, 4,0x2040,0x000f,-2, 4,0x0101,trax_pcmatch,
            "03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:18:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:18:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(137,616,32, 4, 4,0x2041,0x000f,-2, 4,0x0101,trax_delay,
            "03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:1c:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:1c:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(138,620,32, 4, 4,0x2042,0x000f,-2, 4,0x0101,trax_memstart,
            "03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:20:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:20:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(139,624,32, 4, 4,0x2043,0x000f,-2, 4,0x0101,trax_memend,
            "03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:24:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:00:03:60:55:11:03:52:c5:24:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(140,628,32, 4, 4,0x2051,0x000f,-2, 4,0x0101,pmg,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(141,632,32, 4, 4,0x2052,0x000f,-2, 4,0x0101,pmpc,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:04:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:04:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(142,636,32, 4, 4,0x2053,0x000f,-2, 4,0x0101,pm0,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:01:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:01:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(143,640,32, 4, 4,0x2054,0x000f,-2, 4,0x0101,pm1,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:01:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:01:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(144,644,32, 4, 4,0x2055,0x000f,-2, 4,0x0101,pmctrl0,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:d5:01:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:d5:01:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(145,648,32, 4, 4,0x2056,0x000f,-2, 4,0x0101,pmctrl1,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:d5:01:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:d5:01:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(146,652,32, 4, 4,0x2057,0x000f,-2, 4,0x0101,pmstat0,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:02:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:02:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(147,656,32, 4, 4,0x2058,0x000f,-2, 4,0x0101,pmstat1,
            "03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:02:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:04:03:60:55:11:03:52:c5:80:03:52:d5:02:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(148,660,32, 4, 4,0x2059,0x0003,-2, 4,0x0101,ocdid,
            "03:52:64:01:03:62:64:02:03:52:a4:08:03:60:55:11:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:08:03:60:55:11:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(149,664,32, 4, 4,0x205a,0x000f,-2, 4,0x0101,ocd_dcrclr,
            "03:52:64:01:03:62:64:02:03:52:a4:08:03:60:55:11:03:52:c5:08:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:08:03:60:55:11:03:52:c5:08:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(150,668,32, 4, 4,0x205b,0x000f,-2, 4,0x0101,ocd_dcrset,
            "03:52:64:01:03:62:64:02:03:52:a4:08:03:60:55:11:03:52:c5:0c:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:08:03:60:55:11:03:52:c5:0c:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(151,672,32, 4, 4,0x205c,0x000f,-2, 4,0x0101,ocd_dsr,
            "03:52:64:01:03:62:64:02:03:52:a4:08:03:60:55:11:03:52:c5:10:03:60:65:40:03:62:64:00:03:52:24:01:03:62:24:02","03:52:64:01:03:62:64:02:03:52:a4:08:03:60:55:11:03:52:c5:10:03:62:24:00:03:60:75:40:03:52:24:01:03:62:24:02",0,0,0,0)
  XTREG(152,676,32, 4, 4,0x0000,0x0006,-2, 8,0x2100,a0,          0,0,0,0,0,0)
  XTREG(153,680,32, 4, 4,0x0001,0x0006,-2, 8,0x2100,a1,          0,0,0,0,0,0)
  XTREG(154,684,32, 4, 4,0x0002,0x0006,-2, 8,0x2100,a2,          0,0,0,0,0,0)
  XTREG(155,688,32, 4, 4,0x0003,0x0006,-2, 8,0x2100,a3,          0,0,0,0,0,0)
  XTREG(156,692,32, 4, 4,0x0004,0x0006,-2, 8,0x2100,a4,          0,0,0,0,0,0)
  XTREG(157,696,32, 4, 4,0x0005,0x0006,-2, 8,0x2100,a5,          0,0,0,0,0,0)
  XTREG(158,700,32, 4, 4,0x0006,0x0006,-2, 8,0x2100,a6,          0,0,0,0,0,0)
  XTREG(159,704,32, 4, 4,0x0007,0x0006,-2, 8,0x2100,a7,          0,0,0,0,0,0)
  XTREG(160,708,32, 4, 4,0x0008,0x0006,-2, 8,0x2100,a8,          0,0,0,0,0,0)
  XTREG(161,712,32, 4, 4,0x0009,0x0006,-2, 8,0x2100,a9,          0,0,0,0,0,0)
  XTREG(162,716,32, 4, 4,0x000a,0x0006,-2, 8,0x2100,a10,         0,0,0,0,0,0)
  XTREG(163,720,32, 4, 4,0x000b,0x0006,-2, 8,0x2100,a11,         0,0,0,0,0,0)
  XTREG(164,724,32, 4, 4,0x000c,0x0006,-2, 8,0x2100,a12,         0,0,0,0,0,0)
  XTREG(165,728,32, 4, 4,0x000d,0x0006,-2, 8,0x2100,a13,         0,0,0,0,0,0)
  XTREG(166,732,32, 4, 4,0x000e,0x0006,-2, 8,0x2100,a14,         0,0,0,0,0,0)
  XTREG(167,736,32, 4, 4,0x000f,0x0006,-2, 8,0x2100,a15,         0,0,0,0,0,0)
  XTREG(168,740, 1, 4, 4,0x2002,0x0006,-2, 6,0x1010,vecbaselock,
            0,0,&xtensa_mask0,0,0,0)
  XTREG(169,744, 4, 4, 4,0x2007,0x0006,-2, 6,0x1010,psintlevel,
            0,0,&xtensa_mask1,0,0,0)
  XTREG(170,748, 1, 4, 4,0x2008,0x0006,-2, 6,0x1010,psum,
            0,0,&xtensa_mask2,0,0,0)
  XTREG(171,752, 1, 4, 4,0x2009,0x0006,-2, 6,0x1010,pswoe,
            0,0,&xtensa_mask3,0,0,0)
  XTREG(172,756, 1, 4, 4,0x200a,0x0006,-2, 6,0x1010,psexcm,
            0,0,&xtensa_mask4,0,0,0)
  XTREG(173,760, 2, 4, 4,0x200b,0x0006,-2, 6,0x1010,pscallinc,
            0,0,&xtensa_mask5,0,0,0)
  XTREG(174,764, 4, 4, 4,0x200c,0x0006,-2, 6,0x1010,psowb,
            0,0,&xtensa_mask6,0,0,0)
  XTREG(175,768, 4, 4, 4,0x2011,0x0006,-2, 6,0x1010,dbnum,
            0,0,&xtensa_mask7,0,0,0)
  XTREG(176,772, 1, 4, 4,0x2013,0x0006, 1, 6,0x1010,ae_overflow,
            0,0,&xtensa_mask8,0,0,0)
  XTREG(177,776,32, 4, 4,0x2014,0x0006, 1, 6,0x1010,ae_cbegin0,
            0,0,&xtensa_mask9,0,0,0)
  XTREG(178,780,32, 4, 4,0x2015,0x0006, 1, 6,0x1010,ae_cend0,
            0,0,&xtensa_mask10,0,0,0)
  XTREG(179,784, 7, 4, 4,0x2016,0x0006, 1, 6,0x1010,ae_sar,
            0,0,&xtensa_mask11,0,0,0)
  XTREG(180,788, 1, 4, 4,0x2017,0x0006, 1, 6,0x1010,ae_cwrap,
            0,0,&xtensa_mask12,0,0,0)
  XTREG(181,792,32, 4, 4,0x2018,0x0006, 1, 6,0x1010,ae_bithead,
            0,0,&xtensa_mask13,0,0,0)
  XTREG(182,796, 4, 4, 4,0x2019,0x0006, 1, 6,0x1010,ae_bitptr,
            0,0,&xtensa_mask14,0,0,0)
  XTREG(183,800, 4, 4, 4,0x201a,0x0006, 1, 6,0x1010,ae_bitsused,
            0,0,&xtensa_mask15,0,0,0)
  XTREG(184,804, 4, 4, 4,0x201b,0x0006, 1, 6,0x1010,ae_tablesize,
            0,0,&xtensa_mask16,0,0,0)
  XTREG(185,808, 4, 4, 4,0x201c,0x0006, 1, 6,0x1010,ae_first_ts,
            0,0,&xtensa_mask17,0,0,0)
  XTREG(186,812,27, 4, 4,0x201d,0x0006, 1, 6,0x1010,ae_nextoffset,
            0,0,&xtensa_mask18,0,0,0)
  XTREG(187,816, 1, 4, 4,0x201e,0x0006, 1, 6,0x1010,ae_searchdone,
            0,0,&xtensa_mask19,0,0,0)
  XTREG(188,820, 2, 4, 4,0x201f,0x0006, 1, 6,0x1010,roundmode,
            0,0,&xtensa_mask20,0,0,0)
  XTREG(189,824, 5, 4, 4,0x2020,0x0006, 1, 6,0x1010,stickyflags,
            0,0,&xtensa_mask21,0,0,0)
  XTREG_END
};



#ifdef XTENSA_CONFIG_INSTANTIATE
XTENSA_CONFIG_INSTANTIATE(rmap,16)
#endif

xtensa_gdbarch_tdep xtensa_tdep (rmap);
